// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.legacy');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.spec');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
/**
 * Checks to see if the where clause has ' = ', ' > ', ' < ', ' <= ', or ' >= ', and returns true if yes
 */
fluree.db.query.subject_crawl.legacy.where_clause_valid_QMARK_ = (function fluree$db$query$subject_crawl$legacy$where_clause_valid_QMARK_(where_clause){
var and__4251__auto__ = typeof where_clause === 'string';
if(and__4251__auto__){
return cljs.core.re_find.call(null,/^.* (=|>|<|>=|<=|not=) .*$/,where_clause);
} else {
return and__4251__auto__;
}
});
/**
 * Returns a where clause spec based on a string where caluse.
 *   The spec can be applied to a specific db to coerce predicate names
 *   to predicate ids, validate types, and ultimately generate a filtering function.
 */
fluree.db.query.subject_crawl.legacy.parse_where_spec = (function fluree$db$query$subject_crawl$legacy$parse_where_spec(var_args){
var G__16620 = arguments.length;
switch (G__16620) {
case 1:
return fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$1 = (function (where){
return fluree.db.query.subject_crawl.legacy.parse_where_spec.call(null,where,null);
}));

(fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$core$IFn$_invoke$arity$2 = (function (where,default_collection){
if(cljs.core.truth_(fluree.db.query.subject_crawl.legacy.where_clause_valid_QMARK_.call(null,where))){
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var and_QMARK_ = cljs.core.re_matches.call(null,/.+ AND .+/,where);
var or_QMARK_ = cljs.core.re_matches.call(null,/.+ OR .+/,where);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = and_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return or_QMARK_;
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Where clause can have either AND or OR operations, but not both currently: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
var where_type = (cljs.core.truth_(and_QMARK_)?new cljs.core.Keyword(null,"and","and",-971899817):(cljs.core.truth_(or_QMARK_)?new cljs.core.Keyword(null,"or","or",235744169):new cljs.core.Keyword(null,"and","and",-971899817)
));
var args = (function (){var G__16621 = where_type;
var G__16621__$1 = (((G__16621 instanceof cljs.core.Keyword))?G__16621.fqn:null);
switch (G__16621__$1) {
case "and":
return clojure.string.split.call(null,where,/ AND /);

break;
case "or":
return clojure.string.split.call(null,where,/ OR /);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__16621__$1)].join('')));

}
})();
var statements = cljs.core.reduce.call(null,(function (acc,arg){
var arg__$1 = clojure.string.trim.call(null,arg);
var vec__16622 = cljs.core.re_find.call(null,/^([^\s=><].+)[\s]+:?(=|>|<|>=|<=|not=)[\s]+:?(.+)$/,arg__$1);
var ___$1 = cljs.core.nth.call(null,vec__16622,(0),null);
var pred_name = cljs.core.nth.call(null,vec__16622,(1),null);
var op = cljs.core.nth.call(null,vec__16622,(2),null);
var match = cljs.core.nth.call(null,vec__16622,(3),null);
var pred_name__$1 = ((fluree.db.query.schema.reverse_ref_QMARK_.call(null,pred_name,false))?(function(){throw cljs.core.ex_info.call(null,["Reverse references cannot be used in a where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((clojure.string.includes_QMARK_.call(null,pred_name,"/"))?pred_name:(cljs.core.truth_(default_collection)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(default_collection),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''):(function(){throw cljs.core.ex_info.call(null,["Only full namespaced predicate\n                                         names can be used in a where clause. This can be\n                                         provided in a from clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var match_STAR_ = (function (){var temp__5802__auto__ = (function (){var or__4253__auto__ = cljs.core.re_find.call(null,/'(.*)'$/,match);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.re_find.call(null,/\"(.*)\"$/,match);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var match_str = temp__5802__auto__;
return cljs.core.second.call(null,match_str);
} else {
try{if(cljs.core._EQ_.call(null,"true",match)){
return true;
} else {
if(cljs.core._EQ_.call(null,"false",match)){
return false;
} else {
if(clojure.string.includes_QMARK_.call(null,match,".")){
return parseFloat(match);
} else {
return parseInt(match);

}
}
}
}catch (e16625){var ___$2 = e16625;
throw cljs.core.ex_info.call(null,["Invalid where clause in argument: ",arg__$1].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}}
})();
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [pred_name__$1,op,match_STAR_], null));
}),cljs.core.PersistentVector.EMPTY,args);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [where_type,statements], null);
}));

(fluree.db.query.subject_crawl.legacy.parse_where_spec.cljs$lang$maxFixedArity = 2);

fluree.db.query.subject_crawl.legacy.into_where = (function fluree$db$query$subject_crawl$legacy$into_where(where){
var vec__16628 = fluree.db.query.subject_crawl.legacy.parse_where_spec.call(null,where);
var where_type = cljs.core.nth.call(null,vec__16628,(0),null);
var where_statements = cljs.core.nth.call(null,vec__16628,(1),null);
var vars = cljs.core.volatile_BANG_.call(null,(1));
var next_var = (function (){
return ["?__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._vreset_BANG_.call(null,vars,(cljs.core._deref.call(null,vars) + (1))))].join('');
});
var where_STAR_ = cljs.core.mapv.call(null,(function (p__16631){
var vec__16632 = p__16631;
var pred = cljs.core.nth.call(null,vec__16632,(0),null);
var op = cljs.core.nth.call(null,vec__16632,(1),null);
var val = cljs.core.nth.call(null,vec__16632,(2),null);
if(cljs.core._EQ_.call(null,"=",op)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",pred,val], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",pred,["#(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(op)," ",next_var.call(null)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),")"].join('')], null);
}
}),where_statements);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),where_type)){
return where_STAR_;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"or","or",235744169),where_type)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"optional","optional",2053951509),where_STAR_], null)], null);
} else {
return null;
}
}
});
fluree.db.query.subject_crawl.legacy.basic_to_analytical_transpiler = (function fluree$db$query$subject_crawl$legacy$basic_to_analytical_transpiler(query_map){
var map__16635 = query_map;
var map__16635__$1 = cljs.core.__destructure_map.call(null,map__16635);
var select = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var vars = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectOne = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__16635__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var selectKey = (cljs.core.truth_(select)?new cljs.core.Keyword(null,"select","select",1147833503):(cljs.core.truth_(selectOne)?new cljs.core.Keyword(null,"selectOne","selectOne",1588429876):(cljs.core.truth_(selectDistinct)?new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872):null)));
var select_smt = (function (){var or__4253__auto__ = select;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = selectOne;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return selectDistinct;
}
}
})();
var multi_subj = ((((cljs.core.sequential_QMARK_.call(null,from)) && (cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from))))?from:null);
var vars_STAR_ = (cljs.core.truth_(multi_subj)?cljs.core.assoc.call(null,vars,"?__subj",from):vars);
var where_STAR_ = (cljs.core.truth_(multi_subj)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","_id","?__subj"], null)], null):((typeof where === 'string')?(function (){var G__16636 = fluree.db.query.subject_crawl.legacy.into_where.call(null,where);
if(cljs.core.truth_(from)){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","rdf:type",from], null)], null),G__16636);
} else {
return G__16636;
}
})():((((typeof from === 'string') && (clojure.string.includes_QMARK_.call(null,from,"/"))))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",from,"?o"], null)], null):((typeof from === 'string')?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","rdf:type",from], null)], null):((typeof from === 'number')?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s","_id",from], null)], null):((fluree.db.util.core.pred_ident_QMARK_.call(null,from))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?s",cljs.core.first.call(null,from),cljs.core.second.call(null,from)], null)], null):cljs.core.ex_info.call(null,["Invalid 'from' in query:",cljs.core.pr_str.call(null,query_map)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))
))))));
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,query_map,selectKey,new cljs.core.PersistentArrayMap(null, 1, ["?s",select_smt], null),new cljs.core.Keyword(null,"where","where",-2044795965),where_STAR_,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars_STAR_),new cljs.core.Keyword(null,"from","from",1815293044));
});
