// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_23737 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k);
} else {
var m__4549__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_23737.call(null,s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_23738 = (function (s,d){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,d);
} else {
var m__4549__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,d);
} else {
throw cljs.core.missing_protocol.call(null,"Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_23738.call(null,s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_23739 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k);
} else {
var m__4549__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_23739.call(null,s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_23740 = (function (s,k,data){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k,data);
} else {
var m__4549__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k,data);
} else {
throw cljs.core.missing_protocol.call(null,"Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_23740.call(null,s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_23741 = (function (s,old_key,new_key){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,old_key,new_key);
} else {
var m__4549__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,old_key,new_key);
} else {
throw cljs.core.missing_protocol.call(null,"Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_23741.call(null,s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_23742 = (function (s,k){
var x__4550__auto__ = (((s == null))?null:s);
var m__4551__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,s,k);
} else {
var m__4549__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_23742.call(null,s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix.call(null,network,ldgr_id);
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23764){
var state_val_23765 = (state_23764[(1)]);
if((state_val_23765 === (7))){
var inst_23753 = (state_23764[(7)]);
var inst_23755 = fluree.db.storage.core.serde.call(null,conn);
var inst_23756 = fluree.db.serde.protocol._deserialize_block.call(null,inst_23755,inst_23753);
var state_23764__$1 = state_23764;
var statearr_23766_23785 = state_23764__$1;
(statearr_23766_23785[(2)] = inst_23756);

(statearr_23766_23785[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23765 === (1))){
var state_23764__$1 = state_23764;
var statearr_23767_23786 = state_23764__$1;
(statearr_23767_23786[(2)] = null);

(statearr_23767_23786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23765 === (4))){
var inst_23743 = (state_23764[(2)]);
var state_23764__$1 = state_23764;
var statearr_23768_23787 = state_23764__$1;
(statearr_23768_23787[(2)] = inst_23743);

(statearr_23768_23787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23765 === (6))){
var inst_23753 = (state_23764[(7)]);
var inst_23752 = (state_23764[(2)]);
var inst_23753__$1 = fluree.db.util.async.throw_err.call(null,inst_23752);
var state_23764__$1 = (function (){var statearr_23769 = state_23764;
(statearr_23769[(7)] = inst_23753__$1);

return statearr_23769;
})();
if(cljs.core.truth_(inst_23753__$1)){
var statearr_23770_23788 = state_23764__$1;
(statearr_23770_23788[(1)] = (7));

} else {
var statearr_23771_23789 = state_23764__$1;
(statearr_23771_23789[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23765 === (3))){
var inst_23762 = (state_23764[(2)]);
var state_23764__$1 = state_23764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23764__$1,inst_23762);
} else {
if((state_val_23765 === (2))){
var _ = (function (){var statearr_23773 = state_23764;
(statearr_23773[(4)] = cljs.core.cons.call(null,(5),(state_23764[(4)])));

return statearr_23773;
})();
var inst_23749 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_23750 = fluree.db.storage.core.read.call(null,conn,inst_23749);
var state_23764__$1 = state_23764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23764__$1,(6),inst_23750);
} else {
if((state_val_23765 === (9))){
var inst_23759 = (state_23764[(2)]);
var _ = (function (){var statearr_23774 = state_23764;
(statearr_23774[(4)] = cljs.core.rest.call(null,(state_23764[(4)])));

return statearr_23774;
})();
var state_23764__$1 = state_23764;
var statearr_23775_23790 = state_23764__$1;
(statearr_23775_23790[(2)] = inst_23759);

(statearr_23775_23790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23765 === (5))){
var _ = (function (){var statearr_23776 = state_23764;
(statearr_23776[(4)] = cljs.core.rest.call(null,(state_23764[(4)])));

return statearr_23776;
})();
var state_23764__$1 = state_23764;
var ex23772 = (state_23764__$1[(2)]);
var statearr_23777_23791 = state_23764__$1;
(statearr_23777_23791[(5)] = ex23772);


if((ex23772 instanceof Error)){
var statearr_23778_23792 = state_23764__$1;
(statearr_23778_23792[(1)] = (4));

(statearr_23778_23792[(5)] = null);

} else {
throw ex23772;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23765 === (8))){
var state_23764__$1 = state_23764;
var statearr_23779_23793 = state_23764__$1;
(statearr_23779_23793[(2)] = null);

(statearr_23779_23793[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____0 = (function (){
var statearr_23780 = [null,null,null,null,null,null,null,null];
(statearr_23780[(0)] = fluree$db$storage$core$read_block_$_state_machine__2727__auto__);

(statearr_23780[(1)] = (1));

return statearr_23780;
});
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____1 = (function (state_23764){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23781){var ex__2730__auto__ = e23781;
var statearr_23782_23794 = state_23764;
(statearr_23782_23794[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23764[(4)]))){
var statearr_23783_23795 = state_23764;
(statearr_23783_23795[(1)] = cljs.core.first.call(null,(state_23764[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23796 = state_23764;
state_23764 = G__23796;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = function(state_23764){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____1.call(this,state_23764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23784 = f__2750__auto__.call(null);
(statearr_23784[(6)] = c__2749__auto__);

return statearr_23784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23819){
var state_val_23820 = (state_23819[(1)]);
if((state_val_23820 === (7))){
var inst_23808 = (state_23819[(7)]);
var inst_23810 = fluree.db.storage.core.serde.call(null,conn);
var inst_23811 = fluree.db.serde.protocol._deserialize_block.call(null,inst_23810,inst_23808);
var state_23819__$1 = state_23819;
var statearr_23821_23840 = state_23819__$1;
(statearr_23821_23840[(2)] = inst_23811);

(statearr_23821_23840[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23820 === (1))){
var state_23819__$1 = state_23819;
var statearr_23822_23841 = state_23819__$1;
(statearr_23822_23841[(2)] = null);

(statearr_23822_23841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23820 === (4))){
var inst_23797 = (state_23819[(2)]);
var state_23819__$1 = state_23819;
var statearr_23823_23842 = state_23819__$1;
(statearr_23823_23842[(2)] = inst_23797);

(statearr_23823_23842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23820 === (6))){
var inst_23808 = (state_23819[(7)]);
var inst_23807 = (state_23819[(2)]);
var inst_23808__$1 = fluree.db.util.async.throw_err.call(null,inst_23807);
var state_23819__$1 = (function (){var statearr_23824 = state_23819;
(statearr_23824[(7)] = inst_23808__$1);

return statearr_23824;
})();
if(cljs.core.truth_(inst_23808__$1)){
var statearr_23825_23843 = state_23819__$1;
(statearr_23825_23843[(1)] = (7));

} else {
var statearr_23826_23844 = state_23819__$1;
(statearr_23826_23844[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23820 === (3))){
var inst_23817 = (state_23819[(2)]);
var state_23819__$1 = state_23819;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23819__$1,inst_23817);
} else {
if((state_val_23820 === (2))){
var _ = (function (){var statearr_23828 = state_23819;
(statearr_23828[(4)] = cljs.core.cons.call(null,(5),(state_23819[(4)])));

return statearr_23828;
})();
var inst_23803 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_23804 = [inst_23803,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_23805 = fluree.db.storage.core.read.call(null,conn,inst_23804);
var state_23819__$1 = state_23819;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23819__$1,(6),inst_23805);
} else {
if((state_val_23820 === (9))){
var inst_23814 = (state_23819[(2)]);
var _ = (function (){var statearr_23829 = state_23819;
(statearr_23829[(4)] = cljs.core.rest.call(null,(state_23819[(4)])));

return statearr_23829;
})();
var state_23819__$1 = state_23819;
var statearr_23830_23845 = state_23819__$1;
(statearr_23830_23845[(2)] = inst_23814);

(statearr_23830_23845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23820 === (5))){
var _ = (function (){var statearr_23831 = state_23819;
(statearr_23831[(4)] = cljs.core.rest.call(null,(state_23819[(4)])));

return statearr_23831;
})();
var state_23819__$1 = state_23819;
var ex23827 = (state_23819__$1[(2)]);
var statearr_23832_23846 = state_23819__$1;
(statearr_23832_23846[(5)] = ex23827);


if((ex23827 instanceof Error)){
var statearr_23833_23847 = state_23819__$1;
(statearr_23833_23847[(1)] = (4));

(statearr_23833_23847[(5)] = null);

} else {
throw ex23827;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23820 === (8))){
var state_23819__$1 = state_23819;
var statearr_23834_23848 = state_23819__$1;
(statearr_23834_23848[(2)] = null);

(statearr_23834_23848[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_23835 = [null,null,null,null,null,null,null,null];
(statearr_23835[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__);

(statearr_23835[(1)] = (1));

return statearr_23835;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1 = (function (state_23819){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23819);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23836){var ex__2730__auto__ = e23836;
var statearr_23837_23849 = state_23819;
(statearr_23837_23849[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23819[(4)]))){
var statearr_23838_23850 = state_23819;
(statearr_23838_23850[(1)] = cljs.core.first.call(null,(state_23819[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23851 = state_23819;
state_23819 = G__23851;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = function(state_23819){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1.call(this,state_23819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23839 = f__2750__auto__.call(null);
(statearr_23839[(6)] = c__2749__auto__);

return statearr_23839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23875){
var state_val_23876 = (state_23875[(1)]);
if((state_val_23876 === (1))){
var state_23875__$1 = state_23875;
var statearr_23877_23891 = state_23875__$1;
(statearr_23877_23891[(2)] = null);

(statearr_23877_23891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23876 === (2))){
var _ = (function (){var statearr_23878 = state_23875;
(statearr_23878[(4)] = cljs.core.cons.call(null,(5),(state_23875[(4)])));

return statearr_23878;
})();
var inst_23858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23859 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_23860 = (new cljs.core.PersistentVector(null,3,(5),inst_23858,inst_23859,null));
var inst_23861 = cljs.core.select_keys.call(null,block_data,inst_23860);
var inst_23862 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_23861);
var inst_23863 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_23862);
var inst_23864 = [inst_23863,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_23865 = fluree.db.storage.core.serde.call(null,conn);
var inst_23866 = fluree.db.serde.protocol._serialize_block.call(null,inst_23865,inst_23861);
var inst_23867 = fluree.db.storage.core.write.call(null,conn,inst_23864,inst_23866);
var state_23875__$1 = state_23875;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23875__$1,(6),inst_23867);
} else {
if((state_val_23876 === (3))){
var inst_23873 = (state_23875[(2)]);
var state_23875__$1 = state_23875;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23875__$1,inst_23873);
} else {
if((state_val_23876 === (4))){
var inst_23852 = (state_23875[(2)]);
var state_23875__$1 = state_23875;
var statearr_23880_23892 = state_23875__$1;
(statearr_23880_23892[(2)] = inst_23852);

(statearr_23880_23892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23876 === (5))){
var _ = (function (){var statearr_23881 = state_23875;
(statearr_23881[(4)] = cljs.core.rest.call(null,(state_23875[(4)])));

return statearr_23881;
})();
var state_23875__$1 = state_23875;
var ex23879 = (state_23875__$1[(2)]);
var statearr_23882_23893 = state_23875__$1;
(statearr_23882_23893[(5)] = ex23879);


if((ex23879 instanceof Error)){
var statearr_23883_23894 = state_23875__$1;
(statearr_23883_23894[(1)] = (4));

(statearr_23883_23894[(5)] = null);

} else {
throw ex23879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23876 === (6))){
var inst_23869 = (state_23875[(2)]);
var inst_23870 = fluree.db.util.async.throw_err.call(null,inst_23869);
var _ = (function (){var statearr_23884 = state_23875;
(statearr_23884[(4)] = cljs.core.rest.call(null,(state_23875[(4)])));

return statearr_23884;
})();
var state_23875__$1 = state_23875;
var statearr_23885_23895 = state_23875__$1;
(statearr_23885_23895[(2)] = inst_23870);

(statearr_23885_23895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_23886 = [null,null,null,null,null,null,null];
(statearr_23886[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__);

(statearr_23886[(1)] = (1));

return statearr_23886;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1 = (function (state_23875){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23887){var ex__2730__auto__ = e23887;
var statearr_23888_23896 = state_23875;
(statearr_23888_23896[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23875[(4)]))){
var statearr_23889_23897 = state_23875;
(statearr_23889_23897[(1)] = cljs.core.first.call(null,(state_23875[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23898 = state_23875;
state_23875 = G__23898;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = function(state_23875){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1.call(this,state_23875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23890 = f__2750__auto__.call(null);
(statearr_23890[(6)] = c__2749__auto__);

return statearr_23890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23921){
var state_val_23922 = (state_23921[(1)]);
if((state_val_23922 === (1))){
var state_23921__$1 = state_23921;
var statearr_23923_23937 = state_23921__$1;
(statearr_23923_23937[(2)] = null);

(statearr_23923_23937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23922 === (2))){
var _ = (function (){var statearr_23924 = state_23921;
(statearr_23924[(4)] = cljs.core.cons.call(null,(5),(state_23921[(4)])));

return statearr_23924;
})();
var inst_23905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23906 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_23907 = (new cljs.core.PersistentVector(null,3,(5),inst_23905,inst_23906,null));
var inst_23908 = cljs.core.select_keys.call(null,block_data,inst_23907);
var inst_23909 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_23908);
var inst_23910 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_23909);
var inst_23911 = fluree.db.storage.core.serde.call(null,conn);
var inst_23912 = fluree.db.serde.protocol._serialize_block.call(null,inst_23911,inst_23908);
var inst_23913 = fluree.db.storage.core.write.call(null,conn,inst_23910,inst_23912);
var state_23921__$1 = state_23921;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23921__$1,(6),inst_23913);
} else {
if((state_val_23922 === (3))){
var inst_23919 = (state_23921[(2)]);
var state_23921__$1 = state_23921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23921__$1,inst_23919);
} else {
if((state_val_23922 === (4))){
var inst_23899 = (state_23921[(2)]);
var state_23921__$1 = state_23921;
var statearr_23926_23938 = state_23921__$1;
(statearr_23926_23938[(2)] = inst_23899);

(statearr_23926_23938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23922 === (5))){
var _ = (function (){var statearr_23927 = state_23921;
(statearr_23927[(4)] = cljs.core.rest.call(null,(state_23921[(4)])));

return statearr_23927;
})();
var state_23921__$1 = state_23921;
var ex23925 = (state_23921__$1[(2)]);
var statearr_23928_23939 = state_23921__$1;
(statearr_23928_23939[(5)] = ex23925);


if((ex23925 instanceof Error)){
var statearr_23929_23940 = state_23921__$1;
(statearr_23929_23940[(1)] = (4));

(statearr_23929_23940[(5)] = null);

} else {
throw ex23925;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23922 === (6))){
var inst_23915 = (state_23921[(2)]);
var inst_23916 = fluree.db.util.async.throw_err.call(null,inst_23915);
var _ = (function (){var statearr_23930 = state_23921;
(statearr_23930[(4)] = cljs.core.rest.call(null,(state_23921[(4)])));

return statearr_23930;
})();
var state_23921__$1 = state_23921;
var statearr_23931_23941 = state_23921__$1;
(statearr_23931_23941[(2)] = inst_23916);

(statearr_23931_23941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____0 = (function (){
var statearr_23932 = [null,null,null,null,null,null,null];
(statearr_23932[(0)] = fluree$db$storage$core$write_block_$_state_machine__2727__auto__);

(statearr_23932[(1)] = (1));

return statearr_23932;
});
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____1 = (function (state_23921){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23933){var ex__2730__auto__ = e23933;
var statearr_23934_23942 = state_23921;
(statearr_23934_23942[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23921[(4)]))){
var statearr_23935_23943 = state_23921;
(statearr_23935_23943[(1)] = cljs.core.first.call(null,(state_23921[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23944 = state_23921;
state_23921 = G__23944;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = function(state_23921){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____1.call(this,state_23921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23936 = f__2750__auto__.call(null);
(statearr_23936[(6)] = c__2749__auto__);

return statearr_23936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__23946 = arguments.length;
switch (G__23946) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.call(null,conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__23947){
var map__23948 = p__23947;
var map__23948__$1 = cljs.core.__destructure_map.call(null,map__23948);
var leaf = map__23948__$1;
var flakes = cljs.core.get.call(null,map__23948__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23969){
var state_val_23970 = (state_23969[(1)]);
if((state_val_23970 === (1))){
var state_23969__$1 = state_23969;
var statearr_23971_23987 = state_23969__$1;
(statearr_23971_23987[(2)] = null);

(statearr_23971_23987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (2))){
var _ = (function (){var statearr_23972 = state_23969;
(statearr_23972[(4)] = cljs.core.cons.call(null,(5),(state_23969[(4)])));

return statearr_23972;
})();
var inst_23955 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_23956 = [flakes];
var inst_23957 = cljs.core.PersistentHashMap.fromArrays(inst_23955,inst_23956);
var inst_23958 = fluree.db.storage.core.serde.call(null,conn);
var inst_23959 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_23958,inst_23957);
var inst_23960 = fluree.db.storage.core.write.call(null,conn,leaf_id,inst_23959);
var state_23969__$1 = state_23969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23969__$1,(6),inst_23960);
} else {
if((state_val_23970 === (3))){
var inst_23967 = (state_23969[(2)]);
var state_23969__$1 = state_23969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23969__$1,inst_23967);
} else {
if((state_val_23970 === (4))){
var inst_23949 = (state_23969[(2)]);
var state_23969__$1 = state_23969;
var statearr_23974_23988 = state_23969__$1;
(statearr_23974_23988[(2)] = inst_23949);

(statearr_23974_23988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (5))){
var _ = (function (){var statearr_23975 = state_23969;
(statearr_23975[(4)] = cljs.core.rest.call(null,(state_23969[(4)])));

return statearr_23975;
})();
var state_23969__$1 = state_23969;
var ex23973 = (state_23969__$1[(2)]);
var statearr_23976_23989 = state_23969__$1;
(statearr_23976_23989[(5)] = ex23973);


if((ex23973 instanceof Error)){
var statearr_23977_23990 = state_23969__$1;
(statearr_23977_23990[(1)] = (4));

(statearr_23977_23990[(5)] = null);

} else {
throw ex23973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (6))){
var inst_23962 = (state_23969[(2)]);
var inst_23963 = fluree.db.util.async.throw_err.call(null,inst_23962);
var inst_23964 = cljs.core.assoc.call(null,leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_23978 = state_23969;
(statearr_23978[(4)] = cljs.core.rest.call(null,(state_23969[(4)])));

return statearr_23978;
})();
var state_23969__$1 = (function (){var statearr_23979 = state_23969;
(statearr_23979[(7)] = inst_23963);

return statearr_23979;
})();
var statearr_23980_23991 = state_23969__$1;
(statearr_23980_23991[(2)] = inst_23964);

(statearr_23980_23991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_23981 = [null,null,null,null,null,null,null,null];
(statearr_23981[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_23981[(1)] = (1));

return statearr_23981;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_23969){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23982){var ex__2730__auto__ = e23982;
var statearr_23983_23992 = state_23969;
(statearr_23983_23992[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23969[(4)]))){
var statearr_23984_23993 = state_23969;
(statearr_23984_23993[(1)] = cljs.core.first.call(null,(state_23969[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23994 = state_23969;
state_23969 = G__23994;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_23969){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_23969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23985 = f__2750__auto__.call(null);
(statearr_23985[(6)] = c__2749__auto__);

return statearr_23985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24011){
var state_val_24012 = (state_24011[(1)]);
if((state_val_24012 === (1))){
var state_24011__$1 = state_24011;
var statearr_24013_24028 = state_24011__$1;
(statearr_24013_24028[(2)] = null);

(statearr_24013_24028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24012 === (2))){
var _ = (function (){var statearr_24014 = state_24011;
(statearr_24014[(4)] = cljs.core.cons.call(null,(5),(state_24011[(4)])));

return statearr_24014;
})();
var inst_24001 = fluree.db.storage.core.serde.call(null,conn);
var inst_24002 = fluree.db.serde.protocol._serialize_branch.call(null,inst_24001,data);
var inst_24003 = fluree.db.storage.core.write.call(null,conn,key,inst_24002);
var state_24011__$1 = state_24011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24011__$1,(6),inst_24003);
} else {
if((state_val_24012 === (3))){
var inst_24009 = (state_24011[(2)]);
var state_24011__$1 = state_24011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24011__$1,inst_24009);
} else {
if((state_val_24012 === (4))){
var inst_23995 = (state_24011[(2)]);
var state_24011__$1 = state_24011;
var statearr_24016_24029 = state_24011__$1;
(statearr_24016_24029[(2)] = inst_23995);

(statearr_24016_24029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24012 === (5))){
var _ = (function (){var statearr_24017 = state_24011;
(statearr_24017[(4)] = cljs.core.rest.call(null,(state_24011[(4)])));

return statearr_24017;
})();
var state_24011__$1 = state_24011;
var ex24015 = (state_24011__$1[(2)]);
var statearr_24018_24030 = state_24011__$1;
(statearr_24018_24030[(5)] = ex24015);


if((ex24015 instanceof Error)){
var statearr_24019_24031 = state_24011__$1;
(statearr_24019_24031[(1)] = (4));

(statearr_24019_24031[(5)] = null);

} else {
throw ex24015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24012 === (6))){
var inst_24005 = (state_24011[(2)]);
var inst_24006 = fluree.db.util.async.throw_err.call(null,inst_24005);
var _ = (function (){var statearr_24020 = state_24011;
(statearr_24020[(4)] = cljs.core.rest.call(null,(state_24011[(4)])));

return statearr_24020;
})();
var state_24011__$1 = (function (){var statearr_24021 = state_24011;
(statearr_24021[(7)] = inst_24006);

return statearr_24021;
})();
var statearr_24022_24032 = state_24011__$1;
(statearr_24022_24032[(2)] = key);

(statearr_24022_24032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0 = (function (){
var statearr_24023 = [null,null,null,null,null,null,null,null];
(statearr_24023[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__);

(statearr_24023[(1)] = (1));

return statearr_24023;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1 = (function (state_24011){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24024){var ex__2730__auto__ = e24024;
var statearr_24025_24033 = state_24011;
(statearr_24025_24033[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24011[(4)]))){
var statearr_24026_24034 = state_24011;
(statearr_24026_24034[(1)] = cljs.core.first.call(null,(state_24011[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24035 = state_24011;
state_24011 = G__24035;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = function(state_24011){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1.call(this,state_24011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24027 = f__2750__auto__.call(null);
(statearr_24027[(6)] = c__2749__auto__);

return statearr_24027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__24037 = arguments.length;
switch (G__24037) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.call(null,conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__24038){
var map__24039 = p__24038;
var map__24039__$1 = cljs.core.__destructure_map.call(null,map__24039);
var branch = map__24039__$1;
var children = cljs.core.get.call(null,map__24039__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24065){
var state_val_24066 = (state_24065[(1)]);
if((state_val_24066 === (1))){
var state_24065__$1 = state_24065;
var statearr_24067_24084 = state_24065__$1;
(statearr_24067_24084[(2)] = null);

(statearr_24067_24084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (2))){
var _ = (function (){var statearr_24068 = state_24065;
(statearr_24068[(4)] = cljs.core.cons.call(null,(5),(state_24065[(4)])));

return statearr_24068;
})();
var inst_24046 = cljs.core.map.call(null,cljs.core.val,children);
var inst_24047 = cljs.core.mapv.call(null,fluree.db.storage.core.child_data,inst_24046);
var inst_24048 = cljs.core.first.call(null,inst_24047);
var inst_24049 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_24048);
var inst_24050 = cljs.core.rseq.call(null,inst_24047);
var inst_24051 = cljs.core.first.call(null,inst_24050);
var inst_24052 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_24051);
var inst_24053 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_24054 = [inst_24047];
var inst_24055 = cljs.core.PersistentHashMap.fromArrays(inst_24053,inst_24054);
var inst_24056 = fluree.db.storage.core.write_branch_data.call(null,conn,branch_id,inst_24055);
var state_24065__$1 = (function (){var statearr_24069 = state_24065;
(statearr_24069[(7)] = inst_24052);

(statearr_24069[(8)] = inst_24049);

return statearr_24069;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24065__$1,(6),inst_24056);
} else {
if((state_val_24066 === (3))){
var inst_24063 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24065__$1,inst_24063);
} else {
if((state_val_24066 === (4))){
var inst_24040 = (state_24065[(2)]);
var state_24065__$1 = state_24065;
var statearr_24071_24085 = state_24065__$1;
(statearr_24071_24085[(2)] = inst_24040);

(statearr_24071_24085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (5))){
var _ = (function (){var statearr_24072 = state_24065;
(statearr_24072[(4)] = cljs.core.rest.call(null,(state_24065[(4)])));

return statearr_24072;
})();
var state_24065__$1 = state_24065;
var ex24070 = (state_24065__$1[(2)]);
var statearr_24073_24086 = state_24065__$1;
(statearr_24073_24086[(5)] = ex24070);


if((ex24070 instanceof Error)){
var statearr_24074_24087 = state_24065__$1;
(statearr_24074_24087[(1)] = (4));

(statearr_24074_24087[(5)] = null);

} else {
throw ex24070;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24066 === (6))){
var inst_24058 = (state_24065[(2)]);
var inst_24059 = fluree.db.util.async.throw_err.call(null,inst_24058);
var inst_24060 = cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_24075 = state_24065;
(statearr_24075[(4)] = cljs.core.rest.call(null,(state_24065[(4)])));

return statearr_24075;
})();
var state_24065__$1 = (function (){var statearr_24076 = state_24065;
(statearr_24076[(9)] = inst_24059);

return statearr_24076;
})();
var statearr_24077_24088 = state_24065__$1;
(statearr_24077_24088[(2)] = inst_24060);

(statearr_24077_24088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_24078 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24078[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_24078[(1)] = (1));

return statearr_24078;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_24065){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24079){var ex__2730__auto__ = e24079;
var statearr_24080_24089 = state_24065;
(statearr_24080_24089[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24065[(4)]))){
var statearr_24081_24090 = state_24065;
(statearr_24081_24090[(1)] = cljs.core.first.call(null,(state_24065[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24091 = state_24065;
state_24065 = G__24091;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_24065){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_24065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24082 = f__2750__auto__.call(null);
(statearr_24082[(6)] = c__2749__auto__);

return statearr_24082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24119){
var state_val_24120 = (state_24119[(1)]);
if((state_val_24120 === (1))){
var state_24119__$1 = state_24119;
var statearr_24121_24137 = state_24119__$1;
(statearr_24121_24137[(2)] = null);

(statearr_24121_24137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24120 === (2))){
var inst_24105 = (state_24119[(7)]);
var _ = (function (){var statearr_24122 = state_24119;
(statearr_24122[(4)] = cljs.core.cons.call(null,(5),(state_24119[(4)])));

return statearr_24122;
})();
var inst_24099 = db;
var inst_24100 = cljs.core.__destructure_map.call(null,inst_24099);
var inst_24101 = cljs.core.get.call(null,inst_24100,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_24102 = cljs.core.get.call(null,inst_24100,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_24103 = cljs.core.get.call(null,inst_24100,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_24104 = cljs.core.get.call(null,inst_24100,new cljs.core.Keyword(null,"block","block",664686210));
var inst_24105__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_24102,inst_24103,inst_24104);
var inst_24106 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_24107 = [inst_24103,inst_24104,garbage];
var inst_24108 = cljs.core.PersistentHashMap.fromArrays(inst_24106,inst_24107);
var inst_24109 = fluree.db.storage.core.serde.call(null,inst_24101);
var inst_24110 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_24109,inst_24108);
var inst_24111 = fluree.db.storage.core.write.call(null,inst_24101,inst_24105__$1,inst_24110);
var state_24119__$1 = (function (){var statearr_24123 = state_24119;
(statearr_24123[(7)] = inst_24105__$1);

return statearr_24123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24119__$1,(6),inst_24111);
} else {
if((state_val_24120 === (3))){
var inst_24117 = (state_24119[(2)]);
var state_24119__$1 = state_24119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24119__$1,inst_24117);
} else {
if((state_val_24120 === (4))){
var inst_24092 = (state_24119[(2)]);
var state_24119__$1 = state_24119;
var statearr_24125_24138 = state_24119__$1;
(statearr_24125_24138[(2)] = inst_24092);

(statearr_24125_24138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24120 === (5))){
var _ = (function (){var statearr_24126 = state_24119;
(statearr_24126[(4)] = cljs.core.rest.call(null,(state_24119[(4)])));

return statearr_24126;
})();
var state_24119__$1 = state_24119;
var ex24124 = (state_24119__$1[(2)]);
var statearr_24127_24139 = state_24119__$1;
(statearr_24127_24139[(5)] = ex24124);


if((ex24124 instanceof Error)){
var statearr_24128_24140 = state_24119__$1;
(statearr_24128_24140[(1)] = (4));

(statearr_24128_24140[(5)] = null);

} else {
throw ex24124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24120 === (6))){
var inst_24105 = (state_24119[(7)]);
var inst_24113 = (state_24119[(2)]);
var inst_24114 = fluree.db.util.async.throw_err.call(null,inst_24113);
var _ = (function (){var statearr_24129 = state_24119;
(statearr_24129[(4)] = cljs.core.rest.call(null,(state_24119[(4)])));

return statearr_24129;
})();
var state_24119__$1 = (function (){var statearr_24130 = state_24119;
(statearr_24130[(8)] = inst_24114);

return statearr_24130;
})();
var statearr_24131_24141 = state_24119__$1;
(statearr_24131_24141[(2)] = inst_24105);

(statearr_24131_24141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_24132 = [null,null,null,null,null,null,null,null,null];
(statearr_24132[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__);

(statearr_24132[(1)] = (1));

return statearr_24132;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1 = (function (state_24119){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24133){var ex__2730__auto__ = e24133;
var statearr_24134_24142 = state_24119;
(statearr_24134_24142[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24119[(4)]))){
var statearr_24135_24143 = state_24119;
(statearr_24135_24143[(1)] = cljs.core.first.call(null,(state_24119[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24144 = state_24119;
state_24119 = G__24144;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = function(state_24119){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1.call(this,state_24119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24136 = f__2750__auto__.call(null);
(statearr_24136[(6)] = c__2749__auto__);

return statearr_24136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__24146 = arguments.length;
switch (G__24146) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24204){
var state_val_24205 = (state_24204[(1)]);
if((state_val_24205 === (7))){
var state_24204__$1 = state_24204;
var statearr_24206_24232 = state_24204__$1;
(statearr_24206_24232[(2)] = (0));

(statearr_24206_24232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (1))){
var state_24204__$1 = state_24204;
var statearr_24207_24233 = state_24204__$1;
(statearr_24207_24233[(2)] = null);

(statearr_24207_24233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (4))){
var inst_24147 = (state_24204[(2)]);
var state_24204__$1 = state_24204;
var statearr_24208_24234 = state_24204__$1;
(statearr_24208_24234[(2)] = inst_24147);

(statearr_24208_24234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (6))){
var inst_24173 = (state_24204[(7)]);
var state_24204__$1 = state_24204;
var statearr_24209_24235 = state_24204__$1;
(statearr_24209_24235[(2)] = inst_24173);

(statearr_24209_24235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (3))){
var inst_24202 = (state_24204[(2)]);
var state_24204__$1 = state_24204;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24204__$1,inst_24202);
} else {
if((state_val_24205 === (12))){
var inst_24170 = (state_24204[(8)]);
var inst_24198 = (state_24204[(2)]);
var inst_24199 = fluree.db.util.async.throw_err.call(null,inst_24198);
var _ = (function (){var statearr_24210 = state_24204;
(statearr_24210[(4)] = cljs.core.rest.call(null,(state_24204[(4)])));

return statearr_24210;
})();
var state_24204__$1 = (function (){var statearr_24211 = state_24204;
(statearr_24211[(9)] = inst_24199);

return statearr_24211;
})();
var statearr_24212_24236 = state_24204__$1;
(statearr_24212_24236[(2)] = inst_24170);

(statearr_24212_24236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (2))){
var inst_24165 = (state_24204[(10)]);
var inst_24173 = (state_24204[(7)]);
var inst_24162 = (state_24204[(11)]);
var inst_24160 = (state_24204[(12)]);
var _ = (function (){var statearr_24213 = state_24204;
(statearr_24213[(4)] = cljs.core.cons.call(null,(5),(state_24204[(4)])));

return statearr_24213;
})();
var inst_24154 = db;
var inst_24155 = cljs.core.__destructure_map.call(null,inst_24154);
var inst_24156 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_24157 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_24158 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_24159 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_24160__$1 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_24161 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_24162__$1 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"block","block",664686210));
var inst_24163 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_24164 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_24165__$1 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_24166 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_24167 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_24168 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_24169 = cljs.core.get.call(null,inst_24155,new cljs.core.Keyword(null,"post","post",269697687));
var inst_24170 = fluree.db.storage.core.ledger_root_key.call(null,inst_24156,inst_24165__$1,inst_24162__$1);
var inst_24171 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_24172 = fluree.db.storage.core.child_data.call(null,inst_24163);
var inst_24173__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_24160__$1);
var state_24204__$1 = (function (){var statearr_24214 = state_24204;
(statearr_24214[(13)] = inst_24171);

(statearr_24214[(14)] = inst_24164);

(statearr_24214[(10)] = inst_24165__$1);

(statearr_24214[(7)] = inst_24173__$1);

(statearr_24214[(11)] = inst_24162__$1);

(statearr_24214[(15)] = inst_24159);

(statearr_24214[(16)] = inst_24167);

(statearr_24214[(17)] = inst_24157);

(statearr_24214[(18)] = inst_24168);

(statearr_24214[(19)] = inst_24169);

(statearr_24214[(8)] = inst_24170);

(statearr_24214[(20)] = inst_24161);

(statearr_24214[(21)] = inst_24166);

(statearr_24214[(22)] = inst_24172);

(statearr_24214[(23)] = inst_24158);

(statearr_24214[(12)] = inst_24160__$1);

return statearr_24214;
})();
if(cljs.core.truth_(inst_24173__$1)){
var statearr_24215_24237 = state_24204__$1;
(statearr_24215_24237[(1)] = (6));

} else {
var statearr_24216_24238 = state_24204__$1;
(statearr_24216_24238[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (11))){
var inst_24177 = (state_24204[(24)]);
var inst_24171 = (state_24204[(13)]);
var inst_24165 = (state_24204[(10)]);
var inst_24162 = (state_24204[(11)]);
var inst_24159 = (state_24204[(15)]);
var inst_24167 = (state_24204[(16)]);
var inst_24178 = (state_24204[(25)]);
var inst_24157 = (state_24204[(17)]);
var inst_24168 = (state_24204[(18)]);
var inst_24169 = (state_24204[(19)]);
var inst_24170 = (state_24204[(8)]);
var inst_24161 = (state_24204[(20)]);
var inst_24172 = (state_24204[(22)]);
var inst_24158 = (state_24204[(23)]);
var inst_24160 = (state_24204[(12)]);
var inst_24183 = (state_24204[(2)]);
var inst_24184 = fluree.db.storage.core.child_data.call(null,inst_24167);
var inst_24185 = fluree.db.storage.core.child_data.call(null,inst_24169);
var inst_24186 = fluree.db.util.core.current_time_millis.call(null);
var inst_24187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24188 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_24189 = (new cljs.core.PersistentVector(null,2,(5),inst_24187,inst_24188,null));
var inst_24190 = cljs.core.select_keys.call(null,inst_24160,inst_24189);
var inst_24191 = fluree.db.storage.core.child_data.call(null,inst_24159);
var inst_24192 = [inst_24162,inst_24172,inst_24177,inst_24165,inst_24178,inst_24183,inst_24184,inst_24185,inst_24157,inst_24186,inst_24158,inst_24168,inst_24190,inst_24191];
var inst_24193 = cljs.core.PersistentHashMap.fromArrays(inst_24171,inst_24192);
var inst_24194 = fluree.db.storage.core.serde.call(null,inst_24161);
var inst_24195 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_24194,inst_24193);
var inst_24196 = fluree.db.storage.core.write.call(null,inst_24161,inst_24170,inst_24195);
var state_24204__$1 = state_24204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24204__$1,(12),inst_24196);
} else {
if((state_val_24205 === (9))){
var inst_24179 = (state_24204[(26)]);
var state_24204__$1 = state_24204;
var statearr_24218_24239 = state_24204__$1;
(statearr_24218_24239[(2)] = inst_24179);

(statearr_24218_24239[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (5))){
var _ = (function (){var statearr_24219 = state_24204;
(statearr_24219[(4)] = cljs.core.rest.call(null,(state_24204[(4)])));

return statearr_24219;
})();
var state_24204__$1 = state_24204;
var ex24217 = (state_24204__$1[(2)]);
var statearr_24220_24240 = state_24204__$1;
(statearr_24220_24240[(5)] = ex24217);


if((ex24217 instanceof Error)){
var statearr_24221_24241 = state_24204__$1;
(statearr_24221_24241[(1)] = (4));

(statearr_24221_24241[(5)] = null);

} else {
throw ex24217;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (10))){
var inst_24166 = (state_24204[(21)]);
var state_24204__$1 = state_24204;
var statearr_24222_24242 = state_24204__$1;
(statearr_24222_24242[(2)] = inst_24166);

(statearr_24222_24242[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24205 === (8))){
var inst_24164 = (state_24204[(14)]);
var inst_24179 = (state_24204[(26)]);
var inst_24177 = (state_24204[(2)]);
var inst_24178 = fluree.db.storage.core.child_data.call(null,inst_24164);
var inst_24179__$1 = custom_ecount;
var state_24204__$1 = (function (){var statearr_24223 = state_24204;
(statearr_24223[(24)] = inst_24177);

(statearr_24223[(26)] = inst_24179__$1);

(statearr_24223[(25)] = inst_24178);

return statearr_24223;
})();
if(cljs.core.truth_(inst_24179__$1)){
var statearr_24224_24243 = state_24204__$1;
(statearr_24224_24243[(1)] = (9));

} else {
var statearr_24225_24244 = state_24204__$1;
(statearr_24225_24244[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_24226 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24226[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_24226[(1)] = (1));

return statearr_24226;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_24204){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24204);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24227){var ex__2730__auto__ = e24227;
var statearr_24228_24245 = state_24204;
(statearr_24228_24245[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24204[(4)]))){
var statearr_24229_24246 = state_24204;
(statearr_24229_24246[(1)] = cljs.core.first.call(null,(state_24204[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24247 = state_24204;
state_24204 = G__24247;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_24204){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_24204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24230 = f__2750__auto__.call(null);
(statearr_24230[(6)] = c__2749__auto__);

return statearr_24230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__24248,key){
var map__24249 = p__24248;
var map__24249__$1 = cljs.core.__destructure_map.call(null,map__24249);
var conn = map__24249__$1;
var serializer = cljs.core.get.call(null,map__24249__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24269){
var state_val_24270 = (state_24269[(1)]);
if((state_val_24270 === (7))){
var inst_24259 = (state_24269[(7)]);
var inst_24261 = fluree.db.serde.protocol._deserialize_branch.call(null,serializer,inst_24259);
var state_24269__$1 = state_24269;
var statearr_24271_24290 = state_24269__$1;
(statearr_24271_24290[(2)] = inst_24261);

(statearr_24271_24290[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24270 === (1))){
var state_24269__$1 = state_24269;
var statearr_24272_24291 = state_24269__$1;
(statearr_24272_24291[(2)] = null);

(statearr_24272_24291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24270 === (4))){
var inst_24250 = (state_24269[(2)]);
var state_24269__$1 = state_24269;
var statearr_24273_24292 = state_24269__$1;
(statearr_24273_24292[(2)] = inst_24250);

(statearr_24273_24292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24270 === (6))){
var inst_24259 = (state_24269[(7)]);
var inst_24258 = (state_24269[(2)]);
var inst_24259__$1 = fluree.db.util.async.throw_err.call(null,inst_24258);
var state_24269__$1 = (function (){var statearr_24274 = state_24269;
(statearr_24274[(7)] = inst_24259__$1);

return statearr_24274;
})();
if(cljs.core.truth_(inst_24259__$1)){
var statearr_24275_24293 = state_24269__$1;
(statearr_24275_24293[(1)] = (7));

} else {
var statearr_24276_24294 = state_24269__$1;
(statearr_24276_24294[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24270 === (3))){
var inst_24267 = (state_24269[(2)]);
var state_24269__$1 = state_24269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24269__$1,inst_24267);
} else {
if((state_val_24270 === (2))){
var _ = (function (){var statearr_24278 = state_24269;
(statearr_24278[(4)] = cljs.core.cons.call(null,(5),(state_24269[(4)])));

return statearr_24278;
})();
var inst_24256 = fluree.db.storage.core.read.call(null,conn,key);
var state_24269__$1 = state_24269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24269__$1,(6),inst_24256);
} else {
if((state_val_24270 === (9))){
var inst_24264 = (state_24269[(2)]);
var _ = (function (){var statearr_24279 = state_24269;
(statearr_24279[(4)] = cljs.core.rest.call(null,(state_24269[(4)])));

return statearr_24279;
})();
var state_24269__$1 = state_24269;
var statearr_24280_24295 = state_24269__$1;
(statearr_24280_24295[(2)] = inst_24264);

(statearr_24280_24295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24270 === (5))){
var _ = (function (){var statearr_24281 = state_24269;
(statearr_24281[(4)] = cljs.core.rest.call(null,(state_24269[(4)])));

return statearr_24281;
})();
var state_24269__$1 = state_24269;
var ex24277 = (state_24269__$1[(2)]);
var statearr_24282_24296 = state_24269__$1;
(statearr_24282_24296[(5)] = ex24277);


if((ex24277 instanceof Error)){
var statearr_24283_24297 = state_24269__$1;
(statearr_24283_24297[(1)] = (4));

(statearr_24283_24297[(5)] = null);

} else {
throw ex24277;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24270 === (8))){
var state_24269__$1 = state_24269;
var statearr_24284_24298 = state_24269__$1;
(statearr_24284_24298[(2)] = null);

(statearr_24284_24298[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_24285 = [null,null,null,null,null,null,null,null];
(statearr_24285[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2727__auto__);

(statearr_24285[(1)] = (1));

return statearr_24285;
});
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1 = (function (state_24269){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24286){var ex__2730__auto__ = e24286;
var statearr_24287_24299 = state_24269;
(statearr_24287_24299[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24269[(4)]))){
var statearr_24288_24300 = state_24269;
(statearr_24288_24300[(1)] = cljs.core.first.call(null,(state_24269[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24301 = state_24269;
state_24269 = G__24301;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = function(state_24269){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1.call(this,state_24269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24289 = f__2750__auto__.call(null);
(statearr_24289[(6)] = c__2749__auto__);

return statearr_24289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__24302,key){
var map__24303 = p__24302;
var map__24303__$1 = cljs.core.__destructure_map.call(null,map__24303);
var conn = map__24303__$1;
var serializer = cljs.core.get.call(null,map__24303__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24323){
var state_val_24324 = (state_24323[(1)]);
if((state_val_24324 === (7))){
var inst_24313 = (state_24323[(7)]);
var inst_24315 = fluree.db.serde.protocol._deserialize_leaf.call(null,serializer,inst_24313);
var state_24323__$1 = state_24323;
var statearr_24325_24344 = state_24323__$1;
(statearr_24325_24344[(2)] = inst_24315);

(statearr_24325_24344[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (1))){
var state_24323__$1 = state_24323;
var statearr_24326_24345 = state_24323__$1;
(statearr_24326_24345[(2)] = null);

(statearr_24326_24345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (4))){
var inst_24304 = (state_24323[(2)]);
var state_24323__$1 = state_24323;
var statearr_24327_24346 = state_24323__$1;
(statearr_24327_24346[(2)] = inst_24304);

(statearr_24327_24346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (6))){
var inst_24313 = (state_24323[(7)]);
var inst_24312 = (state_24323[(2)]);
var inst_24313__$1 = fluree.db.util.async.throw_err.call(null,inst_24312);
var state_24323__$1 = (function (){var statearr_24328 = state_24323;
(statearr_24328[(7)] = inst_24313__$1);

return statearr_24328;
})();
if(cljs.core.truth_(inst_24313__$1)){
var statearr_24329_24347 = state_24323__$1;
(statearr_24329_24347[(1)] = (7));

} else {
var statearr_24330_24348 = state_24323__$1;
(statearr_24330_24348[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (3))){
var inst_24321 = (state_24323[(2)]);
var state_24323__$1 = state_24323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24323__$1,inst_24321);
} else {
if((state_val_24324 === (2))){
var _ = (function (){var statearr_24332 = state_24323;
(statearr_24332[(4)] = cljs.core.cons.call(null,(5),(state_24323[(4)])));

return statearr_24332;
})();
var inst_24310 = fluree.db.storage.core.read.call(null,conn,key);
var state_24323__$1 = state_24323;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24323__$1,(6),inst_24310);
} else {
if((state_val_24324 === (9))){
var inst_24318 = (state_24323[(2)]);
var _ = (function (){var statearr_24333 = state_24323;
(statearr_24333[(4)] = cljs.core.rest.call(null,(state_24323[(4)])));

return statearr_24333;
})();
var state_24323__$1 = state_24323;
var statearr_24334_24349 = state_24323__$1;
(statearr_24334_24349[(2)] = inst_24318);

(statearr_24334_24349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (5))){
var _ = (function (){var statearr_24335 = state_24323;
(statearr_24335[(4)] = cljs.core.rest.call(null,(state_24323[(4)])));

return statearr_24335;
})();
var state_24323__$1 = state_24323;
var ex24331 = (state_24323__$1[(2)]);
var statearr_24336_24350 = state_24323__$1;
(statearr_24336_24350[(5)] = ex24331);


if((ex24331 instanceof Error)){
var statearr_24337_24351 = state_24323__$1;
(statearr_24337_24351[(1)] = (4));

(statearr_24337_24351[(5)] = null);

} else {
throw ex24331;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (8))){
var state_24323__$1 = state_24323;
var statearr_24338_24352 = state_24323__$1;
(statearr_24338_24352[(2)] = null);

(statearr_24338_24352[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_24339 = [null,null,null,null,null,null,null,null];
(statearr_24339[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__);

(statearr_24339[(1)] = (1));

return statearr_24339;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1 = (function (state_24323){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24340){var ex__2730__auto__ = e24340;
var statearr_24341_24353 = state_24323;
(statearr_24341_24353[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24323[(4)]))){
var statearr_24342_24354 = state_24323;
(statearr_24342_24354[(1)] = cljs.core.first.call(null,(state_24323[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24355 = state_24323;
state_24323 = G__24355;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = function(state_24323){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1.call(this,state_24323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24343 = f__2750__auto__.call(null);
(statearr_24343[(6)] = c__2749__auto__);

return statearr_24343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__24356,index,index_data){
var map__24357 = p__24356;
var map__24357__$1 = cljs.core.__destructure_map.call(null,map__24357);
var network = cljs.core.get.call(null,map__24357__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__24357__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.call(null,map__24357__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.call(null,map__24357__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__24357__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__4253__auto__ = cljs.core.get.call(null,comparators,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db index root: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__24358 = index_data;
var G__24358__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__24358,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__24358);
var G__24358__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__24358__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__24358__$1);
return cljs.core.assoc.call(null,G__24358__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true);

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__24359 = root_data;
var map__24359__$1 = cljs.core.__destructure_map.call(null,map__24359);
var block = cljs.core.get.call(null,map__24359__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__24359__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__24359__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__24359__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root.call(null,conn,db,idx,cljs.core.get.call(null,root_data,idx));
return cljs.core.assoc.call(null,db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24381){
var state_val_24382 = (state_24381[(1)]);
if((state_val_24382 === (7))){
var state_24381__$1 = state_24381;
var statearr_24383_24403 = state_24381__$1;
(statearr_24383_24403[(2)] = null);

(statearr_24383_24403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24382 === (1))){
var state_24381__$1 = state_24381;
var statearr_24384_24404 = state_24381__$1;
(statearr_24384_24404[(2)] = null);

(statearr_24384_24404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24382 === (4))){
var inst_24360 = (state_24381[(2)]);
var state_24381__$1 = state_24381;
var statearr_24385_24405 = state_24381__$1;
(statearr_24385_24405[(2)] = inst_24360);

(statearr_24385_24405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24382 === (6))){
var inst_24367 = (state_24381[(7)]);
var inst_24369 = fluree.db.storage.core.serde.call(null,conn);
var state_24381__$1 = (function (){var statearr_24386 = state_24381;
(statearr_24386[(8)] = inst_24369);

return statearr_24386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24381__$1,(9),inst_24367);
} else {
if((state_val_24382 === (3))){
var inst_24379 = (state_24381[(2)]);
var state_24381__$1 = state_24381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24381__$1,inst_24379);
} else {
if((state_val_24382 === (2))){
var inst_24367 = (state_24381[(7)]);
var _ = (function (){var statearr_24388 = state_24381;
(statearr_24388[(4)] = cljs.core.cons.call(null,(5),(state_24381[(4)])));

return statearr_24388;
})();
var inst_24366 = fluree.db.storage.core.ledger_garbage_key.call(null,network,ledger_id,block);
var inst_24367__$1 = fluree.db.storage.core.read.call(null,conn,inst_24366);
var state_24381__$1 = (function (){var statearr_24389 = state_24381;
(statearr_24389[(7)] = inst_24367__$1);

return statearr_24389;
})();
if(cljs.core.truth_(inst_24367__$1)){
var statearr_24390_24406 = state_24381__$1;
(statearr_24390_24406[(1)] = (6));

} else {
var statearr_24391_24407 = state_24381__$1;
(statearr_24391_24407[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24382 === (9))){
var inst_24369 = (state_24381[(8)]);
var inst_24371 = (state_24381[(2)]);
var inst_24372 = fluree.db.util.async.throw_err.call(null,inst_24371);
var inst_24373 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_24369,inst_24372);
var state_24381__$1 = state_24381;
var statearr_24392_24408 = state_24381__$1;
(statearr_24392_24408[(2)] = inst_24373);

(statearr_24392_24408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24382 === (5))){
var _ = (function (){var statearr_24393 = state_24381;
(statearr_24393[(4)] = cljs.core.rest.call(null,(state_24381[(4)])));

return statearr_24393;
})();
var state_24381__$1 = state_24381;
var ex24387 = (state_24381__$1[(2)]);
var statearr_24394_24409 = state_24381__$1;
(statearr_24394_24409[(5)] = ex24387);


if((ex24387 instanceof Error)){
var statearr_24395_24410 = state_24381__$1;
(statearr_24395_24410[(1)] = (4));

(statearr_24395_24410[(5)] = null);

} else {
throw ex24387;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24382 === (8))){
var inst_24376 = (state_24381[(2)]);
var _ = (function (){var statearr_24396 = state_24381;
(statearr_24396[(4)] = cljs.core.rest.call(null,(state_24381[(4)])));

return statearr_24396;
})();
var state_24381__$1 = state_24381;
var statearr_24397_24411 = state_24381__$1;
(statearr_24397_24411[(2)] = inst_24376);

(statearr_24397_24411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_24398 = [null,null,null,null,null,null,null,null,null];
(statearr_24398[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__);

(statearr_24398[(1)] = (1));

return statearr_24398;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1 = (function (state_24381){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24399){var ex__2730__auto__ = e24399;
var statearr_24400_24412 = state_24381;
(statearr_24400_24412[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24381[(4)]))){
var statearr_24401_24413 = state_24381;
(statearr_24401_24413[(1)] = cljs.core.first.call(null,(state_24381[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24414 = state_24381;
state_24381 = G__24414;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = function(state_24381){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1.call(this,state_24381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24402 = f__2750__auto__.call(null);
(statearr_24402[(6)] = c__2749__auto__);

return statearr_24402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24436){
var state_val_24437 = (state_24436[(1)]);
if((state_val_24437 === (7))){
var inst_24425 = (state_24436[(7)]);
var inst_24427 = fluree.db.storage.core.serde.call(null,conn);
var inst_24428 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_24427,inst_24425);
var state_24436__$1 = state_24436;
var statearr_24438_24457 = state_24436__$1;
(statearr_24438_24457[(2)] = inst_24428);

(statearr_24438_24457[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24437 === (1))){
var state_24436__$1 = state_24436;
var statearr_24439_24458 = state_24436__$1;
(statearr_24439_24458[(2)] = null);

(statearr_24439_24458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24437 === (4))){
var inst_24415 = (state_24436[(2)]);
var state_24436__$1 = state_24436;
var statearr_24440_24459 = state_24436__$1;
(statearr_24440_24459[(2)] = inst_24415);

(statearr_24440_24459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24437 === (6))){
var inst_24425 = (state_24436[(7)]);
var inst_24424 = (state_24436[(2)]);
var inst_24425__$1 = fluree.db.util.async.throw_err.call(null,inst_24424);
var state_24436__$1 = (function (){var statearr_24441 = state_24436;
(statearr_24441[(7)] = inst_24425__$1);

return statearr_24441;
})();
if(cljs.core.truth_(inst_24425__$1)){
var statearr_24442_24460 = state_24436__$1;
(statearr_24442_24460[(1)] = (7));

} else {
var statearr_24443_24461 = state_24436__$1;
(statearr_24443_24461[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24437 === (3))){
var inst_24434 = (state_24436[(2)]);
var state_24436__$1 = state_24436;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24436__$1,inst_24434);
} else {
if((state_val_24437 === (2))){
var _ = (function (){var statearr_24445 = state_24436;
(statearr_24445[(4)] = cljs.core.cons.call(null,(5),(state_24436[(4)])));

return statearr_24445;
})();
var inst_24421 = fluree.db.storage.core.ledger_root_key.call(null,network,ledger_id,block);
var inst_24422 = fluree.db.storage.core.read.call(null,conn,inst_24421);
var state_24436__$1 = state_24436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24436__$1,(6),inst_24422);
} else {
if((state_val_24437 === (9))){
var inst_24431 = (state_24436[(2)]);
var _ = (function (){var statearr_24446 = state_24436;
(statearr_24446[(4)] = cljs.core.rest.call(null,(state_24436[(4)])));

return statearr_24446;
})();
var state_24436__$1 = state_24436;
var statearr_24447_24462 = state_24436__$1;
(statearr_24447_24462[(2)] = inst_24431);

(statearr_24447_24462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24437 === (5))){
var _ = (function (){var statearr_24448 = state_24436;
(statearr_24448[(4)] = cljs.core.rest.call(null,(state_24436[(4)])));

return statearr_24448;
})();
var state_24436__$1 = state_24436;
var ex24444 = (state_24436__$1[(2)]);
var statearr_24449_24463 = state_24436__$1;
(statearr_24449_24463[(5)] = ex24444);


if((ex24444 instanceof Error)){
var statearr_24450_24464 = state_24436__$1;
(statearr_24450_24464[(1)] = (4));

(statearr_24450_24464[(5)] = null);

} else {
throw ex24444;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24437 === (8))){
var state_24436__$1 = state_24436;
var statearr_24451_24465 = state_24436__$1;
(statearr_24451_24465[(2)] = null);

(statearr_24451_24465[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0 = (function (){
var statearr_24452 = [null,null,null,null,null,null,null,null];
(statearr_24452[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__);

(statearr_24452[(1)] = (1));

return statearr_24452;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1 = (function (state_24436){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24453){var ex__2730__auto__ = e24453;
var statearr_24454_24466 = state_24436;
(statearr_24454_24466[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24436[(4)]))){
var statearr_24455_24467 = state_24436;
(statearr_24455_24467[(1)] = cljs.core.first.call(null,(state_24436[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24468 = state_24436;
state_24436 = G__24468;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = function(state_24436){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1.call(this,state_24436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24456 = f__2750__auto__.call(null);
(statearr_24456[(6)] = c__2749__auto__);

return statearr_24456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24505){
var state_val_24506 = (state_24505[(1)]);
if((state_val_24506 === (7))){
var inst_24475 = (state_24505[(7)]);
var state_24505__$1 = state_24505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24505__$1,(9),inst_24475);
} else {
if((state_val_24506 === (1))){
var state_24505__$1 = state_24505;
var statearr_24507_24528 = state_24505__$1;
(statearr_24507_24528[(2)] = null);

(statearr_24507_24528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24506 === (4))){
var inst_24469 = (state_24505[(2)]);
var state_24505__$1 = state_24505;
var statearr_24508_24529 = state_24505__$1;
(statearr_24508_24529[(2)] = inst_24469);

(statearr_24508_24529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24506 === (6))){
var inst_24478 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_24479 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24480 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_24481 = cljs.core.PersistentHashMap.fromArrays(inst_24479,inst_24480);
var inst_24482 = cljs.core.ex_info.call(null,inst_24478,inst_24481);
var inst_24483 = (function(){throw inst_24482})();
var state_24505__$1 = state_24505;
var statearr_24509_24530 = state_24505__$1;
(statearr_24509_24530[(2)] = inst_24483);

(statearr_24509_24530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24506 === (3))){
var inst_24503 = (state_24505[(2)]);
var state_24505__$1 = state_24505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24505__$1,inst_24503);
} else {
if((state_val_24506 === (2))){
var inst_24475 = (state_24505[(7)]);
var _ = (function (){var statearr_24510 = state_24505;
(statearr_24510[(4)] = cljs.core.cons.call(null,(5),(state_24505[(4)])));

return statearr_24510;
})();
var inst_24475__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,ledger_id,index);
var inst_24476 = cljs.core.not.call(null,inst_24475__$1);
var state_24505__$1 = (function (){var statearr_24511 = state_24505;
(statearr_24511[(7)] = inst_24475__$1);

return statearr_24511;
})();
if(inst_24476){
var statearr_24512_24531 = state_24505__$1;
(statearr_24512_24531[(1)] = (6));

} else {
var statearr_24513_24532 = state_24505__$1;
(statearr_24513_24532[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24506 === (11))){
var inst_24493 = (state_24505[(8)]);
var inst_24496 = (state_24505[(2)]);
var inst_24497 = fluree.db.util.async.throw_err.call(null,inst_24496);
var inst_24498 = cljs.core.assoc.call(null,inst_24493,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_24497);
var state_24505__$1 = state_24505;
var statearr_24515_24533 = state_24505__$1;
(statearr_24515_24533[(2)] = inst_24498);

(statearr_24515_24533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24506 === (9))){
var inst_24488 = (state_24505[(9)]);
var inst_24486 = (state_24505[(2)]);
var inst_24487 = fluree.db.util.async.throw_err.call(null,inst_24486);
var inst_24488__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_24487);
var inst_24489 = fluree.db.query.schema.schema_map.call(null,inst_24488__$1);
var state_24505__$1 = (function (){var statearr_24516 = state_24505;
(statearr_24516[(9)] = inst_24488__$1);

return statearr_24516;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24505__$1,(10),inst_24489);
} else {
if((state_val_24506 === (5))){
var _ = (function (){var statearr_24517 = state_24505;
(statearr_24517[(4)] = cljs.core.rest.call(null,(state_24505[(4)])));

return statearr_24517;
})();
var state_24505__$1 = state_24505;
var ex24514 = (state_24505__$1[(2)]);
var statearr_24518_24534 = state_24505__$1;
(statearr_24518_24534[(5)] = ex24514);


if((ex24514 instanceof Error)){
var statearr_24519_24535 = state_24505__$1;
(statearr_24519_24535[(1)] = (4));

(statearr_24519_24535[(5)] = null);

} else {
throw ex24514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24506 === (10))){
var inst_24493 = (state_24505[(8)]);
var inst_24488 = (state_24505[(9)]);
var inst_24491 = (state_24505[(2)]);
var inst_24492 = fluree.db.util.async.throw_err.call(null,inst_24491);
var inst_24493__$1 = cljs.core.assoc.call(null,inst_24488,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_24492);
var inst_24494 = fluree.db.query.schema.setting_map.call(null,inst_24493__$1);
var state_24505__$1 = (function (){var statearr_24520 = state_24505;
(statearr_24520[(8)] = inst_24493__$1);

return statearr_24520;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24505__$1,(11),inst_24494);
} else {
if((state_val_24506 === (8))){
var inst_24500 = (state_24505[(2)]);
var _ = (function (){var statearr_24521 = state_24505;
(statearr_24521[(4)] = cljs.core.rest.call(null,(state_24505[(4)])));

return statearr_24521;
})();
var state_24505__$1 = state_24505;
var statearr_24522_24536 = state_24505__$1;
(statearr_24522_24536[(2)] = inst_24500);

(statearr_24522_24536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0 = (function (){
var statearr_24523 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24523[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2727__auto__);

(statearr_24523[(1)] = (1));

return statearr_24523;
});
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1 = (function (state_24505){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24524){var ex__2730__auto__ = e24524;
var statearr_24525_24537 = state_24505;
(statearr_24525_24537[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24505[(4)]))){
var statearr_24526_24538 = state_24505;
(statearr_24526_24538[(1)] = cljs.core.first.call(null,(state_24505[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24539 = state_24505;
state_24505 = G__24539;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = function(state_24505){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1.call(this,state_24505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24527 = f__2750__auto__.call(null);
(statearr_24527[(6)] = c__2749__auto__);

return statearr_24527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__24540){
var map__24541 = p__24540;
var map__24541__$1 = cljs.core.__destructure_map.call(null,map__24541);
var branch = map__24541__$1;
var id = cljs.core.get.call(null,map__24541__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__24541__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.call(null,map__24541__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24578){
var state_val_24579 = (state_24578[(1)]);
if((state_val_24579 === (7))){
var inst_24551 = (state_24578[(7)]);
var inst_24554 = cljs.core.__destructure_map.call(null,inst_24551);
var inst_24555 = cljs.core.get.call(null,inst_24554,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_24556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24557 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_24558 = (new cljs.core.PersistentVector(null,7,(5),inst_24556,inst_24557,null));
var inst_24559 = cljs.core.select_keys.call(null,branch,inst_24558);
var inst_24560 = (function (){var temp__5802__auto__ = inst_24551;
var map__24553 = inst_24554;
var children = inst_24555;
var branch_metadata = inst_24559;
return (function (i,child){
return cljs.core.merge.call(null,cljs.core.assoc.call(null,branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (i === (0));
} else {
return and__4251__auto__;
}
})()),child);
});
})();
var inst_24561 = cljs.core.map_indexed.call(null,inst_24560,inst_24555);
var inst_24562 = cljs.core.juxt.call(null,new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_24563 = cljs.core.mapcat.call(null,inst_24562,inst_24561);
var inst_24564 = cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,comparator,inst_24563);
var state_24578__$1 = state_24578;
var statearr_24580_24599 = state_24578__$1;
(statearr_24580_24599[(2)] = inst_24564);

(statearr_24580_24599[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24579 === (1))){
var state_24578__$1 = state_24578;
var statearr_24581_24600 = state_24578__$1;
(statearr_24581_24600[(2)] = null);

(statearr_24581_24600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24579 === (4))){
var inst_24542 = (state_24578[(2)]);
var state_24578__$1 = state_24578;
var statearr_24582_24601 = state_24578__$1;
(statearr_24582_24601[(2)] = inst_24542);

(statearr_24582_24601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24579 === (6))){
var inst_24551 = (state_24578[(7)]);
var inst_24550 = (state_24578[(2)]);
var inst_24551__$1 = fluree.db.util.async.throw_err.call(null,inst_24550);
var state_24578__$1 = (function (){var statearr_24583 = state_24578;
(statearr_24583[(7)] = inst_24551__$1);

return statearr_24583;
})();
if(cljs.core.truth_(inst_24551__$1)){
var statearr_24584_24602 = state_24578__$1;
(statearr_24584_24602[(1)] = (7));

} else {
var statearr_24585_24603 = state_24578__$1;
(statearr_24585_24603[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24579 === (3))){
var inst_24576 = (state_24578[(2)]);
var state_24578__$1 = state_24578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24578__$1,inst_24576);
} else {
if((state_val_24579 === (2))){
var _ = (function (){var statearr_24587 = state_24578;
(statearr_24587[(4)] = cljs.core.cons.call(null,(5),(state_24578[(4)])));

return statearr_24587;
})();
var inst_24548 = fluree.db.storage.core.read_branch.call(null,conn,id);
var state_24578__$1 = state_24578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24578__$1,(6),inst_24548);
} else {
if((state_val_24579 === (9))){
var inst_24573 = (state_24578[(2)]);
var _ = (function (){var statearr_24588 = state_24578;
(statearr_24588[(4)] = cljs.core.rest.call(null,(state_24578[(4)])));

return statearr_24588;
})();
var state_24578__$1 = state_24578;
var statearr_24589_24604 = state_24578__$1;
(statearr_24589_24604[(2)] = inst_24573);

(statearr_24589_24604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24579 === (5))){
var _ = (function (){var statearr_24590 = state_24578;
(statearr_24590[(4)] = cljs.core.rest.call(null,(state_24578[(4)])));

return statearr_24590;
})();
var state_24578__$1 = state_24578;
var ex24586 = (state_24578__$1[(2)]);
var statearr_24591_24605 = state_24578__$1;
(statearr_24591_24605[(5)] = ex24586);


if((ex24586 instanceof Error)){
var statearr_24592_24606 = state_24578__$1;
(statearr_24592_24606[(1)] = (4));

(statearr_24592_24606[(5)] = null);

} else {
throw ex24586;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24579 === (8))){
var inst_24566 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_24567 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24568 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_24569 = cljs.core.PersistentHashMap.fromArrays(inst_24567,inst_24568);
var inst_24570 = cljs.core.ex_info.call(null,inst_24566,inst_24569);
var inst_24571 = (function(){throw inst_24570})();
var state_24578__$1 = state_24578;
var statearr_24593_24607 = state_24578__$1;
(statearr_24593_24607[(2)] = inst_24571);

(statearr_24593_24607[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0 = (function (){
var statearr_24594 = [null,null,null,null,null,null,null,null];
(statearr_24594[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__);

(statearr_24594[(1)] = (1));

return statearr_24594;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1 = (function (state_24578){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24595){var ex__2730__auto__ = e24595;
var statearr_24596_24608 = state_24578;
(statearr_24596_24608[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24578[(4)]))){
var statearr_24597_24609 = state_24578;
(statearr_24597_24609[(1)] = cljs.core.first.call(null,(state_24578[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24610 = state_24578;
state_24578 = G__24610;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = function(state_24578){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1.call(this,state_24578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24598 = f__2750__auto__.call(null);
(statearr_24598[(6)] = c__2749__auto__);

return statearr_24598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__24611){
var map__24612 = p__24611;
var map__24612__$1 = cljs.core.__destructure_map.call(null,map__24612);
var id = cljs.core.get.call(null,map__24612__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__24612__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24641){
var state_val_24642 = (state_24641[(1)]);
if((state_val_24642 === (7))){
var inst_24622 = (state_24641[(7)]);
var inst_24625 = cljs.core.__destructure_map.call(null,inst_24622);
var inst_24626 = cljs.core.get.call(null,inst_24625,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_24627 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,comparator,inst_24626);
var state_24641__$1 = state_24641;
var statearr_24643_24662 = state_24641__$1;
(statearr_24643_24662[(2)] = inst_24627);

(statearr_24643_24662[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24642 === (1))){
var state_24641__$1 = state_24641;
var statearr_24644_24663 = state_24641__$1;
(statearr_24644_24663[(2)] = null);

(statearr_24644_24663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24642 === (4))){
var inst_24613 = (state_24641[(2)]);
var state_24641__$1 = state_24641;
var statearr_24645_24664 = state_24641__$1;
(statearr_24645_24664[(2)] = inst_24613);

(statearr_24645_24664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24642 === (6))){
var inst_24622 = (state_24641[(7)]);
var inst_24621 = (state_24641[(2)]);
var inst_24622__$1 = fluree.db.util.async.throw_err.call(null,inst_24621);
var state_24641__$1 = (function (){var statearr_24646 = state_24641;
(statearr_24646[(7)] = inst_24622__$1);

return statearr_24646;
})();
if(cljs.core.truth_(inst_24622__$1)){
var statearr_24647_24665 = state_24641__$1;
(statearr_24647_24665[(1)] = (7));

} else {
var statearr_24648_24666 = state_24641__$1;
(statearr_24648_24666[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24642 === (3))){
var inst_24639 = (state_24641[(2)]);
var state_24641__$1 = state_24641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24641__$1,inst_24639);
} else {
if((state_val_24642 === (2))){
var _ = (function (){var statearr_24650 = state_24641;
(statearr_24650[(4)] = cljs.core.cons.call(null,(5),(state_24641[(4)])));

return statearr_24650;
})();
var inst_24619 = fluree.db.storage.core.read_leaf.call(null,conn,id);
var state_24641__$1 = state_24641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24641__$1,(6),inst_24619);
} else {
if((state_val_24642 === (9))){
var inst_24636 = (state_24641[(2)]);
var _ = (function (){var statearr_24651 = state_24641;
(statearr_24651[(4)] = cljs.core.rest.call(null,(state_24641[(4)])));

return statearr_24651;
})();
var state_24641__$1 = state_24641;
var statearr_24652_24667 = state_24641__$1;
(statearr_24652_24667[(2)] = inst_24636);

(statearr_24652_24667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24642 === (5))){
var _ = (function (){var statearr_24653 = state_24641;
(statearr_24653[(4)] = cljs.core.rest.call(null,(state_24641[(4)])));

return statearr_24653;
})();
var state_24641__$1 = state_24641;
var ex24649 = (state_24641__$1[(2)]);
var statearr_24654_24668 = state_24641__$1;
(statearr_24654_24668[(5)] = ex24649);


if((ex24649 instanceof Error)){
var statearr_24655_24669 = state_24641__$1;
(statearr_24655_24669[(1)] = (4));

(statearr_24655_24669[(5)] = null);

} else {
throw ex24649;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24642 === (8))){
var inst_24629 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_24630 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24631 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_24632 = cljs.core.PersistentHashMap.fromArrays(inst_24630,inst_24631);
var inst_24633 = cljs.core.ex_info.call(null,inst_24629,inst_24632);
var inst_24634 = (function(){throw inst_24633})();
var state_24641__$1 = state_24641;
var statearr_24656_24670 = state_24641__$1;
(statearr_24656_24670[(2)] = inst_24634);

(statearr_24656_24670[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_24657 = [null,null,null,null,null,null,null,null];
(statearr_24657[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__);

(statearr_24657[(1)] = (1));

return statearr_24657;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1 = (function (state_24641){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24658){var ex__2730__auto__ = e24658;
var statearr_24659_24671 = state_24641;
(statearr_24659_24671[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24641[(4)]))){
var statearr_24660_24672 = state_24641;
(statearr_24660_24672[(1)] = cljs.core.first.call(null,(state_24641[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24673 = state_24641;
state_24641 = G__24673;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = function(state_24641){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1.call(this,state_24641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24661 = f__2750__auto__.call(null);
(statearr_24661[(6)] = c__2749__auto__);

return statearr_24661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__24675 = arguments.length;
switch (G__24675) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.call(null,node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__24676,error_fn){
var map__24677 = p__24676;
var map__24677__$1 = cljs.core.__destructure_map.call(null,map__24677);
var node = map__24677__$1;
var comparator = cljs.core.get.call(null,map__24677__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.call(null,map__24677__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.call(null);
var c__2749__auto___24749 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24721){
var state_val_24722 = (state_24721[(1)]);
if((state_val_24722 === (7))){
var inst_24686 = (state_24721[(2)]);
var state_24721__$1 = state_24721;
var statearr_24723_24750 = state_24721__$1;
(statearr_24723_24750[(2)] = inst_24686);

(statearr_24723_24750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (1))){
var state_24721__$1 = state_24721;
var statearr_24724_24751 = state_24721__$1;
(statearr_24724_24751[(2)] = null);

(statearr_24724_24751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (4))){
var inst_24678 = (state_24721[(7)]);
var inst_24678__$1 = (state_24721[(2)]);
var inst_24679 = fluree.db.util.log.error.call(null,inst_24678__$1,"Error resolving index node");
var state_24721__$1 = (function (){var statearr_24725 = state_24721;
(statearr_24725[(7)] = inst_24678__$1);

(statearr_24725[(8)] = inst_24679);

return statearr_24725;
})();
if(cljs.core.truth_(error_fn)){
var statearr_24726_24752 = state_24721__$1;
(statearr_24726_24752[(1)] = (5));

} else {
var statearr_24727_24753 = state_24721__$1;
(statearr_24727_24753[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (13))){
var inst_24704 = (state_24721[(9)]);
var inst_24707 = (state_24721[(2)]);
var inst_24708 = fluree.db.util.async.throw_err.call(null,inst_24707);
var inst_24709 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_24708];
var inst_24710 = (new cljs.core.PersistentVector(null,2,(5),inst_24704,inst_24709,null));
var state_24721__$1 = state_24721;
var statearr_24728_24754 = state_24721__$1;
(statearr_24728_24754[(2)] = inst_24710);

(statearr_24728_24754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (6))){
var state_24721__$1 = state_24721;
var statearr_24729_24755 = state_24721__$1;
(statearr_24729_24755[(2)] = null);

(statearr_24729_24755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (3))){
var inst_24719 = (state_24721[(2)]);
var state_24721__$1 = state_24721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24721__$1,inst_24719);
} else {
if((state_val_24722 === (12))){
var inst_24696 = (state_24721[(10)]);
var inst_24699 = (state_24721[(2)]);
var inst_24700 = fluree.db.util.async.throw_err.call(null,inst_24699);
var inst_24701 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_24700];
var inst_24702 = (new cljs.core.PersistentVector(null,2,(5),inst_24696,inst_24701,null));
var state_24721__$1 = state_24721;
var statearr_24730_24756 = state_24721__$1;
(statearr_24730_24756[(2)] = inst_24702);

(statearr_24730_24756[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (2))){
var _ = (function (){var statearr_24731 = state_24721;
(statearr_24731[(4)] = cljs.core.cons.call(null,(8),(state_24721[(4)])));

return statearr_24731;
})();
var state_24721__$1 = state_24721;
if(cljs.core.truth_(leaf)){
var statearr_24732_24757 = state_24721__$1;
(statearr_24732_24757[(1)] = (9));

} else {
var statearr_24733_24758 = state_24721__$1;
(statearr_24733_24758[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (11))){
var inst_24712 = (state_24721[(2)]);
var inst_24713 = cljs.core.nth.call(null,inst_24712,(0),null);
var inst_24714 = cljs.core.nth.call(null,inst_24712,(1),null);
var inst_24715 = cljs.core.assoc.call(null,node,inst_24713,inst_24714);
var inst_24716 = cljs.core.async.put_BANG_.call(null,return_ch,inst_24715);
var _ = (function (){var statearr_24734 = state_24721;
(statearr_24734[(4)] = cljs.core.rest.call(null,(state_24721[(4)])));

return statearr_24734;
})();
var state_24721__$1 = state_24721;
var statearr_24735_24759 = state_24721__$1;
(statearr_24735_24759[(2)] = inst_24716);

(statearr_24735_24759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (9))){
var inst_24696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24697 = fluree.db.storage.core.fetch_leaf_flakes.call(null,conn,node);
var state_24721__$1 = (function (){var statearr_24736 = state_24721;
(statearr_24736[(10)] = inst_24696);

return statearr_24736;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24721__$1,(12),inst_24697);
} else {
if((state_val_24722 === (5))){
var inst_24678 = (state_24721[(7)]);
var inst_24681 = cljs.core.async.put_BANG_.call(null,return_ch,inst_24678);
var inst_24682 = cljs.core.async.close_BANG_.call(null,return_ch);
var inst_24683 = error_fn.call(null,inst_24681,inst_24682);
var state_24721__$1 = state_24721;
var statearr_24738_24760 = state_24721__$1;
(statearr_24738_24760[(2)] = inst_24683);

(statearr_24738_24760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24722 === (10))){
var inst_24704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24705 = fluree.db.storage.core.fetch_child_attributes.call(null,conn,node);
var state_24721__$1 = (function (){var statearr_24739 = state_24721;
(statearr_24739[(9)] = inst_24704);

return statearr_24739;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24721__$1,(13),inst_24705);
} else {
if((state_val_24722 === (8))){
var _ = (function (){var statearr_24740 = state_24721;
(statearr_24740[(4)] = cljs.core.rest.call(null,(state_24721[(4)])));

return statearr_24740;
})();
var state_24721__$1 = state_24721;
var ex24737 = (state_24721__$1[(2)]);
var statearr_24741_24761 = state_24721__$1;
(statearr_24741_24761[(5)] = ex24737);


var statearr_24742_24762 = state_24721__$1;
(statearr_24742_24762[(1)] = (4));

(statearr_24742_24762[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_24743 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24743[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_24743[(1)] = (1));

return statearr_24743;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_24721){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_24721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24744){var ex__2730__auto__ = e24744;
var statearr_24745_24763 = state_24721;
(statearr_24745_24763[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_24721[(4)]))){
var statearr_24746_24764 = state_24721;
(statearr_24746_24764[(1)] = cljs.core.first.call(null,(state_24721[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24765 = state_24721;
state_24721 = G__24765;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_24721){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_24721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24747 = f__2750__auto__.call(null);
(statearr_24747[(6)] = c__2749__auto___24749);

return statearr_24747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__24766){
var map__24767 = p__24766;
var map__24767__$1 = cljs.core.__destructure_map.call(null,map__24767);
var node = map__24767__$1;
var comparator = cljs.core.get.call(null,map__24767__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.call(null);
var empty_set = fluree.db.flake.sorted_set_by.call(null,comparator);
var empty_node = cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.call(null,ch,empty_node);

return ch;
});
