// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
goog.require('goog.object');
goog.scope(function(){
fluree.db.util.json.goog$module$goog$object = goog.module.get('goog.object');
});
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__11656 = arguments.length;
switch (G__11656) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__11657 = options;
var map__11657__$1 = cljs.core.__destructure_map.call(null,map__11657);
var keyword_fn = cljs.core.get.call(null,map__11657__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.call(null,k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return keyword_fn.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
var m = ({});
var seq__11684_11705 = cljs.core.seq.call(null,x__$1);
var chunk__11685_11706 = null;
var count__11686_11707 = (0);
var i__11687_11708 = (0);
while(true){
if((i__11687_11708 < count__11686_11707)){
var vec__11694_11709 = cljs.core._nth.call(null,chunk__11685_11706,i__11687_11708);
var k_11710 = cljs.core.nth.call(null,vec__11694_11709,(0),null);
var v_11711 = cljs.core.nth.call(null,vec__11694_11709,(1),null);
fluree.db.util.json.goog$module$goog$object.set.call(null,m,keyfn.call(null,k_11710),fluree$db$util$json$thisfn.call(null,v_11711));


var G__11712 = seq__11684_11705;
var G__11713 = chunk__11685_11706;
var G__11714 = count__11686_11707;
var G__11715 = (i__11687_11708 + (1));
seq__11684_11705 = G__11712;
chunk__11685_11706 = G__11713;
count__11686_11707 = G__11714;
i__11687_11708 = G__11715;
continue;
} else {
var temp__5804__auto___11716 = cljs.core.seq.call(null,seq__11684_11705);
if(temp__5804__auto___11716){
var seq__11684_11717__$1 = temp__5804__auto___11716;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11684_11717__$1)){
var c__4679__auto___11718 = cljs.core.chunk_first.call(null,seq__11684_11717__$1);
var G__11719 = cljs.core.chunk_rest.call(null,seq__11684_11717__$1);
var G__11720 = c__4679__auto___11718;
var G__11721 = cljs.core.count.call(null,c__4679__auto___11718);
var G__11722 = (0);
seq__11684_11705 = G__11719;
chunk__11685_11706 = G__11720;
count__11686_11707 = G__11721;
i__11687_11708 = G__11722;
continue;
} else {
var vec__11697_11723 = cljs.core.first.call(null,seq__11684_11717__$1);
var k_11724 = cljs.core.nth.call(null,vec__11697_11723,(0),null);
var v_11725 = cljs.core.nth.call(null,vec__11697_11723,(1),null);
fluree.db.util.json.goog$module$goog$object.set.call(null,m,keyfn.call(null,k_11724),fluree$db$util$json$thisfn.call(null,v_11725));


var G__11726 = cljs.core.next.call(null,seq__11684_11717__$1);
var G__11727 = null;
var G__11728 = (0);
var G__11729 = (0);
seq__11684_11705 = G__11726;
chunk__11685_11706 = G__11727;
count__11686_11707 = G__11728;
i__11687_11708 = G__11729;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var arr = [];
var seq__11700_11730 = cljs.core.seq.call(null,cljs.core.map.call(null,fluree$db$util$json$thisfn,x__$1));
var chunk__11701_11731 = null;
var count__11702_11732 = (0);
var i__11703_11733 = (0);
while(true){
if((i__11703_11733 < count__11702_11732)){
var x_11734__$2 = cljs.core._nth.call(null,chunk__11701_11731,i__11703_11733);
arr.push(x_11734__$2);


var G__11735 = seq__11700_11730;
var G__11736 = chunk__11701_11731;
var G__11737 = count__11702_11732;
var G__11738 = (i__11703_11733 + (1));
seq__11700_11730 = G__11735;
chunk__11701_11731 = G__11736;
count__11702_11732 = G__11737;
i__11703_11733 = G__11738;
continue;
} else {
var temp__5804__auto___11739 = cljs.core.seq.call(null,seq__11700_11730);
if(temp__5804__auto___11739){
var seq__11700_11740__$1 = temp__5804__auto___11739;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11700_11740__$1)){
var c__4679__auto___11741 = cljs.core.chunk_first.call(null,seq__11700_11740__$1);
var G__11742 = cljs.core.chunk_rest.call(null,seq__11700_11740__$1);
var G__11743 = c__4679__auto___11741;
var G__11744 = cljs.core.count.call(null,c__4679__auto___11741);
var G__11745 = (0);
seq__11700_11730 = G__11742;
chunk__11701_11731 = G__11743;
count__11702_11732 = G__11744;
i__11703_11733 = G__11745;
continue;
} else {
var x_11746__$2 = cljs.core.first.call(null,seq__11700_11740__$1);
arr.push(x_11746__$2);


var G__11747 = cljs.core.next.call(null,seq__11700_11740__$1);
var G__11748 = null;
var G__11749 = (0);
var G__11750 = (0);
seq__11700_11730 = G__11747;
chunk__11701_11731 = G__11748;
count__11702_11732 = G__11749;
i__11703_11733 = G__11750;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn.call(null,x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.call(null,JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string.call(null,x))),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js.call(null,x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8.call(null,fluree.db.util.json.stringify.call(null,x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.call(null,(1),depth)){
return ((cljs.core.every_QMARK_.call(null,cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count.call(null,coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_.call(null,cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,(function (p1__11751_SHARP_){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(depth - (1)),p1__11751_SHARP_);
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_.call(null,coordinates)) && (((((4) <= cljs.core.count.call(null,coordinates))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,coordinates),cljs.core.last.call(null,coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Feature",(function (geometry){
var and__4251__auto__ = (function (){var or__4253__auto__ = fluree.db.util.json.valid_geojson_QMARK_.call(null,new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4251__auto__)){
return ((cljs.core.map_QMARK_.call(null,new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4251__auto__;
}
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,(function (p1__11752_SHARP_){
return cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,p1__11752_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
