// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__17671 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__17671,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__17671;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__17672 = opts;
var map__17672__$1 = cljs.core.__destructure_map.call(null,map__17672);
var request_timeout = cljs.core.get.call(null,map__17672__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__17672__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__17672__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__17673 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__17673__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__17673,headers):G__17673);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__17673__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__17673__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__17674 = opts;
var map__17674__$1 = cljs.core.__destructure_map.call(null,map__17674);
var request_timeout = cljs.core.get.call(null,map__17674__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__17674__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__17674__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__17674__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__17674__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__17675 = cljs.core.PersistentArrayMap.EMPTY;
var G__17675__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__17675,headers):G__17675);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__17675__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__17675__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__17676 = output_format;
var G__17676__$1 = (((G__17676 instanceof cljs.core.Keyword))?G__17676.fqn:null);
switch (G__17676__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__17678 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__17678,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__17678;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17710){
var state_val_17711 = (state_17710[(1)]);
if((state_val_17711 === (7))){
var inst_17706 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
var statearr_17712_17737 = state_17710__$1;
(statearr_17712_17737[(2)] = inst_17706);

(statearr_17712_17737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (1))){
var state_17710__$1 = state_17710;
var statearr_17713_17738 = state_17710__$1;
(statearr_17713_17738[(2)] = null);

(statearr_17713_17738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (4))){
var inst_17681 = (state_17710[(7)]);
var inst_17681__$1 = (state_17710[(2)]);
var inst_17682 = (inst_17681__$1 == null);
var state_17710__$1 = (function (){var statearr_17714 = state_17710;
(statearr_17714[(7)] = inst_17681__$1);

return statearr_17714;
})();
if(cljs.core.truth_(inst_17682)){
var statearr_17715_17739 = state_17710__$1;
(statearr_17715_17739[(1)] = (5));

} else {
var statearr_17716_17740 = state_17710__$1;
(statearr_17716_17740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (6))){
var inst_17681 = (state_17710[(7)]);
var inst_17689 = cljs.core.nth.call(null,inst_17681,(0),null);
var inst_17690 = cljs.core.nth.call(null,inst_17681,(1),null);
var state_17710__$1 = (function (){var statearr_17717 = state_17710;
(statearr_17717[(8)] = inst_17690);

(statearr_17717[(9)] = inst_17689);

return statearr_17717;
})();
var statearr_17718_17741 = state_17710__$1;
(statearr_17718_17741[(2)] = null);

(statearr_17718_17741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (3))){
var inst_17708 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17710__$1,inst_17708);
} else {
if((state_val_17711 === (2))){
var state_17710__$1 = state_17710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17710__$1,(4),pub_chan);
} else {
if((state_val_17711 === (11))){
var _ = (function (){var statearr_17720 = state_17710;
(statearr_17720[(4)] = cljs.core.rest.call(null,(state_17710[(4)])));

return statearr_17720;
})();
var state_17710__$1 = state_17710;
var ex17719 = (state_17710__$1[(2)]);
var statearr_17721_17742 = state_17710__$1;
(statearr_17721_17742[(5)] = ex17719);


var statearr_17722_17743 = state_17710__$1;
(statearr_17722_17743[(1)] = (10));

(statearr_17722_17743[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (9))){
var inst_17703 = (state_17710[(2)]);
var state_17710__$1 = (function (){var statearr_17723 = state_17710;
(statearr_17723[(10)] = inst_17703);

return statearr_17723;
})();
var statearr_17724_17744 = state_17710__$1;
(statearr_17724_17744[(2)] = null);

(statearr_17724_17744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (5))){
var inst_17684 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_17710__$1 = state_17710;
var statearr_17725_17745 = state_17710__$1;
(statearr_17725_17745[(2)] = inst_17684);

(statearr_17725_17745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (10))){
var inst_17690 = (state_17710[(8)]);
var inst_17689 = (state_17710[(9)]);
var inst_17691 = (state_17710[(2)]);
var inst_17692 = fluree.db.util.log.error.call(null,inst_17691,"Error sending websocket message:",inst_17689);
var inst_17693 = cljs.core.async.put_BANG_.call(null,inst_17690,false);
var state_17710__$1 = (function (){var statearr_17726 = state_17710;
(statearr_17726[(11)] = inst_17692);

return statearr_17726;
})();
var statearr_17727_17746 = state_17710__$1;
(statearr_17727_17746[(2)] = inst_17693);

(statearr_17727_17746[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17711 === (8))){
var inst_17690 = (state_17710[(8)]);
var inst_17689 = (state_17710[(9)]);
var _ = (function (){var statearr_17728 = state_17710;
(statearr_17728[(4)] = cljs.core.cons.call(null,(11),(state_17710[(4)])));

return statearr_17728;
})();
var inst_17699 = ws.send(inst_17689);
var inst_17700 = cljs.core.async.put_BANG_.call(null,inst_17690,true);
var ___$1 = (function (){var statearr_17729 = state_17710;
(statearr_17729[(4)] = cljs.core.rest.call(null,(state_17710[(4)])));

return statearr_17729;
})();
var state_17710__$1 = (function (){var statearr_17730 = state_17710;
(statearr_17730[(12)] = inst_17699);

return statearr_17730;
})();
var statearr_17731_17747 = state_17710__$1;
(statearr_17731_17747[(2)] = inst_17700);

(statearr_17731_17747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0 = (function (){
var statearr_17732 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17732[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__);

(statearr_17732[(1)] = (1));

return statearr_17732;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1 = (function (state_17710){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_17710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17733){var ex__2730__auto__ = e17733;
var statearr_17734_17748 = state_17710;
(statearr_17734_17748[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_17710[(4)]))){
var statearr_17735_17749 = state_17710;
(statearr_17735_17749[(1)] = cljs.core.first.call(null,(state_17710[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17750 = state_17710;
state_17710 = G__17750;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = function(state_17710){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1.call(this,state_17710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17736 = f__2750__auto__.call(null);
(statearr_17736[(6)] = c__2749__auto__);

return statearr_17736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2749__auto___17788 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17775){
var state_val_17776 = (state_17775[(1)]);
if((state_val_17776 === (1))){
var inst_17754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17755 = [open_QMARK_,timeout_chan];
var inst_17756 = (new cljs.core.PersistentVector(null,2,(5),inst_17754,inst_17755,null));
var state_17775__$1 = state_17775;
return cljs.core.async.ioc_alts_BANG_.call(null,state_17775__$1,(2),inst_17756,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_17776 === (2))){
var inst_17758 = (state_17775[(2)]);
var inst_17759 = cljs.core.nth.call(null,inst_17758,(0),null);
var inst_17760 = cljs.core.nth.call(null,inst_17758,(1),null);
var inst_17761 = cljs.core._EQ_.call(null,inst_17760,timeout_chan);
var state_17775__$1 = (function (){var statearr_17777 = state_17775;
(statearr_17777[(7)] = inst_17759);

return statearr_17777;
})();
if(inst_17761){
var statearr_17778_17789 = state_17775__$1;
(statearr_17778_17789[(1)] = (3));

} else {
var statearr_17779_17790 = state_17775__$1;
(statearr_17779_17790[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17776 === (3))){
var inst_17763 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_17764 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17765 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_17766 = cljs.core.PersistentHashMap.fromArrays(inst_17764,inst_17765);
var inst_17767 = cljs.core.ex_info.call(null,inst_17763,inst_17766);
var inst_17768 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_17767);
var inst_17769 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_17775__$1 = (function (){var statearr_17780 = state_17775;
(statearr_17780[(8)] = inst_17768);

return statearr_17780;
})();
var statearr_17781_17791 = state_17775__$1;
(statearr_17781_17791[(2)] = inst_17769);

(statearr_17781_17791[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17776 === (4))){
var inst_17771 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_17775__$1 = state_17775;
var statearr_17782_17792 = state_17775__$1;
(statearr_17782_17792[(2)] = inst_17771);

(statearr_17782_17792[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17776 === (5))){
var inst_17773 = (state_17775[(2)]);
var state_17775__$1 = state_17775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17775__$1,inst_17773);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_17783 = [null,null,null,null,null,null,null,null,null];
(statearr_17783[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__);

(statearr_17783[(1)] = (1));

return statearr_17783;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1 = (function (state_17775){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_17775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17784){var ex__2730__auto__ = e17784;
var statearr_17785_17793 = state_17775;
(statearr_17785_17793[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_17775[(4)]))){
var statearr_17786_17794 = state_17775;
(statearr_17786_17794[(1)] = cljs.core.first.call(null,(state_17775[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17795 = state_17775;
state_17775 = G__17795;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = function(state_17775){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1.call(this,state_17775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17787 = f__2750__auto__.call(null);
(statearr_17787[(6)] = c__2749__auto___17788);

return statearr_17787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
