// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__51113 = (line + (1));
var G__51114 = (1);
var G__51115 = (counter + (1));
line = G__51113;
col = G__51114;
counter = G__51115;
continue;
} else {
var G__51116 = line;
var G__51117 = (col + (1));
var G__51118 = (counter + (1));
line = G__51116;
col = G__51117;
counter = G__51118;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__51119 = cljs.core.next.call(null,chars);
var G__51120 = (n__$1 - (1));
chars = G__51119;
n__$1 = G__51120;
continue;
} else {
var G__51121 = cljs.core.next.call(null,chars);
var G__51122 = n__$1;
chars = G__51121;
n__$1 = G__51122;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 * and accounts for horizontal tabs which might change
 * the alignment of the '^' to the error location.
 */
instaparse.failure.marker = (function instaparse$failure$marker(text,n){
if(cljs.core.truth_((function (){var and__4251__auto__ = text;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.integer_QMARK_.call(null,n);
} else {
return and__4251__auto__;
}
})())){
var marker_text = clojure.string.replace.call(null,text,/[^\s]/," ");
if((n <= (1))){
return "^";
} else {
return [cljs.core.subs.call(null,marker_text,(0),(n - (1))),"^"].join('');
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__51123){
var map__51124 = p__51123;
var map__51124__$1 = cljs.core.__destructure_map.call(null,map__51124);
var line = cljs.core.get.call(null,map__51124__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__51124__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__51124__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__51124__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,text,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__51125_51133 = cljs.core.seq.call(null,full_reasons);
var chunk__51126_51134 = null;
var count__51127_51135 = (0);
var i__51128_51136 = (0);
while(true){
if((i__51128_51136 < count__51127_51135)){
var r_51137 = cljs.core._nth.call(null,chunk__51126_51134,i__51128_51136);
instaparse.failure.print_reason.call(null,r_51137);

cljs.core.println.call(null," (followed by end-of-string)");


var G__51138 = seq__51125_51133;
var G__51139 = chunk__51126_51134;
var G__51140 = count__51127_51135;
var G__51141 = (i__51128_51136 + (1));
seq__51125_51133 = G__51138;
chunk__51126_51134 = G__51139;
count__51127_51135 = G__51140;
i__51128_51136 = G__51141;
continue;
} else {
var temp__5804__auto___51142 = cljs.core.seq.call(null,seq__51125_51133);
if(temp__5804__auto___51142){
var seq__51125_51143__$1 = temp__5804__auto___51142;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51125_51143__$1)){
var c__4679__auto___51144 = cljs.core.chunk_first.call(null,seq__51125_51143__$1);
var G__51145 = cljs.core.chunk_rest.call(null,seq__51125_51143__$1);
var G__51146 = c__4679__auto___51144;
var G__51147 = cljs.core.count.call(null,c__4679__auto___51144);
var G__51148 = (0);
seq__51125_51133 = G__51145;
chunk__51126_51134 = G__51146;
count__51127_51135 = G__51147;
i__51128_51136 = G__51148;
continue;
} else {
var r_51149 = cljs.core.first.call(null,seq__51125_51143__$1);
instaparse.failure.print_reason.call(null,r_51149);

cljs.core.println.call(null," (followed by end-of-string)");


var G__51150 = cljs.core.next.call(null,seq__51125_51143__$1);
var G__51151 = null;
var G__51152 = (0);
var G__51153 = (0);
seq__51125_51133 = G__51150;
chunk__51126_51134 = G__51151;
count__51127_51135 = G__51152;
i__51128_51136 = G__51153;
continue;
}
} else {
}
}
break;
}

var seq__51129 = cljs.core.seq.call(null,partial_reasons);
var chunk__51130 = null;
var count__51131 = (0);
var i__51132 = (0);
while(true){
if((i__51132 < count__51131)){
var r = cljs.core._nth.call(null,chunk__51130,i__51132);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__51154 = seq__51129;
var G__51155 = chunk__51130;
var G__51156 = count__51131;
var G__51157 = (i__51132 + (1));
seq__51129 = G__51154;
chunk__51130 = G__51155;
count__51131 = G__51156;
i__51132 = G__51157;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__51129);
if(temp__5804__auto__){
var seq__51129__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51129__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__51129__$1);
var G__51158 = cljs.core.chunk_rest.call(null,seq__51129__$1);
var G__51159 = c__4679__auto__;
var G__51160 = cljs.core.count.call(null,c__4679__auto__);
var G__51161 = (0);
seq__51129 = G__51158;
chunk__51130 = G__51159;
count__51131 = G__51160;
i__51132 = G__51161;
continue;
} else {
var r = cljs.core.first.call(null,seq__51129__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__51162 = cljs.core.next.call(null,seq__51129__$1);
var G__51163 = null;
var G__51164 = (0);
var G__51165 = (0);
seq__51129 = G__51162;
chunk__51130 = G__51163;
count__51131 = G__51164;
i__51132 = G__51165;
continue;
}
} else {
return null;
}
}
break;
}
});
