// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.analyzer');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.destructure');
goog.require('sci.impl.evaluator');
goog.require('sci.impl.faster');
goog.require('sci.impl.fns');
goog.require('sci.impl.interop');
goog.require('sci.impl.load');
goog.require('sci.impl.macros');
goog.require('sci.impl.records');
goog.require('sci.impl.resolve');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
goog.require('cljs.tagged_literals');
goog.require('goog.object');
goog.scope(function(){
sci.impl.analyzer.goog$module$goog$object = goog.module.get('goog.object');
});
sci.impl.analyzer.recur_target = (function sci$impl$analyzer$recur_target(ctx){
return new cljs.core.Keyword(null,"recur-target","recur-target",-1909494536).cljs$core$IFn$_invoke$arity$1(ctx);
});
sci.impl.analyzer.with_recur_target = (function sci$impl$analyzer$with_recur_target(ctx,v){
return cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"recur-target","recur-target",-1909494536),v);
});
sci.impl.analyzer.without_recur_target = (function sci$impl$analyzer$without_recur_target(ctx){
return cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"recur-target","recur-target",-1909494536),false);
});
sci.impl.analyzer.recur_target_QMARK_ = (function sci$impl$analyzer$recur_target_QMARK_(ctx){
return new cljs.core.Keyword(null,"recur-target","recur-target",-1909494536).cljs$core$IFn$_invoke$arity$1(ctx);
});
sci.impl.analyzer.special_syms = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Symbol(null,"try","try",-1273693247,null),"null",new cljs.core.Symbol(null,"finally","finally",-1065347064,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Symbol(null,"new","new",-444906321,null),"null",new cljs.core.Symbol(null,"let*","let*",1920721458,null),"null",new cljs.core.Symbol(null,"recur","recur",1202958259,null),"null",new cljs.core.Symbol(null,"set!","set!",250714521,null),"null",new cljs.core.Symbol(null,".",".",1975675962,null),"null",new cljs.core.Symbol(null,"var","var",870848730,null),"null",new cljs.core.Symbol(null,"quote","quote",1377916282,null),"null",new cljs.core.Symbol(null,"catch","catch",-1616370245,null),"null",new cljs.core.Symbol(null,"throw","throw",595905694,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
sci.impl.analyzer.throw_error_with_location = (function sci$impl$analyzer$throw_error_with_location(msg,node){
return sci.impl.utils.throw_error_with_location.call(null,msg,node,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),"analysis"], null));
});




sci.impl.analyzer.macroexpand_1 = (function sci$impl$analyzer$macroexpand_1(ctx,expr){
var ctx__$1 = cljs.core.assoc.call(null,ctx,new cljs.core.Keyword("sci.impl","macroexpanding","sci.impl/macroexpanding",2113471825),true);
var original_expr = expr;
if(cljs.core.seq_QMARK_.call(null,expr)){
var op = cljs.core.first.call(null,expr);
if((op instanceof cljs.core.Symbol)){
if(cljs.core.truth_(cljs.core.get.call(null,sci.impl.analyzer.special_syms,op))){
return expr;
} else {
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"for","for",316745208,null),null], null), null),op)){
return sci.impl.analyzer.analyze.call(null,ctx__$1,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol("clojure.core","defrecord","clojure.core/defrecord",581689476,null),op)){
return expr;
} else {
var f = (function (){try{return sci.impl.resolve.resolve_symbol.call(null,ctx__$1,op,true);
}catch (e39490){var _ = e39490;
return new cljs.core.Keyword("sci.impl.analyzer","unresolved","sci.impl.analyzer/unresolved",308754858);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword("sci.impl.analyzer","unresolved","sci.impl.analyzer/unresolved",308754858),f)){
return expr;
} else {
var macro_var_QMARK_ = (function (){var and__4251__auto__ = sci.impl.vars.var_QMARK_.call(null,f);
if(and__4251__auto__){
return sci.impl.vars.isMacro.call(null,f);
} else {
return and__4251__auto__;
}
})();
var needs_ctx_QMARK_ = cljs.core.keyword_identical_QMARK_.call(null,sci.impl.utils.needs_ctx,(function (){var G__39491 = f;
var G__39491__$1 = (((G__39491 == null))?null:cljs.core.meta.call(null,G__39491));
if((G__39491__$1 == null)){
return null;
} else {
return new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978).cljs$core$IFn$_invoke$arity$1(G__39491__$1);
}
})());
var f__$1 = (cljs.core.truth_(macro_var_QMARK_)?cljs.core.deref.call(null,f):f);
if(cljs.core.truth_((function (){var or__4253__auto__ = macro_var_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return sci.impl.utils.macro_QMARK_.call(null,f__$1);
}
})())){
if(needs_ctx_QMARK_){
return cljs.core.apply.call(null,f__$1,original_expr,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx__$1),ctx__$1,cljs.core.rest.call(null,expr));
} else {
return cljs.core.apply.call(null,f__$1,original_expr,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx__$1),cljs.core.rest.call(null,expr));
}
} else {
return expr;
}
}

}
}
}
} else {
return expr;
}
} else {
return expr;
}
});
sci.impl.analyzer.macroexpand = (function sci$impl$analyzer$macroexpand(ctx,form){
var ex = sci.impl.analyzer.macroexpand_1.call(null,ctx,form);
if((ex === form)){
return form;
} else {
return sci.impl.analyzer.macroexpand.call(null,ctx,ex);
}
});
cljs.core.vreset_BANG_.call(null,sci.impl.utils.macroexpand_STAR_,sci.impl.analyzer.macroexpand);
cljs.core.vreset_BANG_.call(null,sci.impl.utils.macroexpand_1_STAR_,sci.impl.analyzer.macroexpand_1);
sci.impl.analyzer.analyze_children_tail = (function sci$impl$analyzer$analyze_children_tail(ctx,children){
var rt = sci.impl.analyzer.recur_target.call(null,ctx);
var non_tail_ctx = sci.impl.analyzer.without_recur_target.call(null,ctx);
var analyzed_children_non_tail = cljs.core.mapv.call(null,(function (p1__39492_SHARP_){
return sci.impl.analyzer.analyze.call(null,non_tail_ctx,p1__39492_SHARP_);
}),cljs.core.butlast.call(null,children));
var ret_child = sci.impl.analyzer.analyze.call(null,sci.impl.analyzer.with_recur_target.call(null,ctx,rt),cljs.core.last.call(null,children));
return cljs.core.conj.call(null,analyzed_children_non_tail,ret_child);
});
var ret__4913__auto___39497 = sci.impl.analyzer.gen_return_do = (function sci$impl$analyzer$gen_return_do(_AMPERSAND_form,_AMPERSAND_env){
var let_bindings = cljs.core.map.call(null,(function (i){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (j){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,["arg",cljs.core.str.cljs$core$IFn$_invoke$arity$1(j)].join('')),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nth","cljs.core/nth",1961052085,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,j,null,(1),null)))))], null);
}),cljs.core.range.call(null,i)))], null);
}),cljs.core.range.call(null,(2),(4)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"return-do","return-do",133353255,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","delay","cljs.core/delay",-406049125,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.analyzer","analyze-children-tail","sci.impl.analyzer/analyze-children-tail",628580735,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","case","cljs.core/case",-1674122212,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null)),cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),null], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nth","cljs.core/nth",1961052085,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,(0),null,(1),null)))))], null),cljs.core.mapcat.call(null,(function (p__39493){
var vec__39494 = p__39493;
var i = cljs.core.nth.call(null,vec__39494,(0),null);
var binds = cljs.core.nth.call(null,vec__39494,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,binds,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","->Node","sci.impl.types/->Node",-1318888839,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"do","do",1686842252,null),null,(1),null)),cljs.core.map.call(null,(function (j){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","eval","sci.impl.types/eval",700838406,null),null,(1),null)),(new cljs.core.List(null,cljs.core.symbol.call(null,["arg",cljs.core.str.cljs$core$IFn$_invoke$arity$1(j)].join('')),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),null,(1),null)))));
}),cljs.core.range.call(null,i))))),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null)))))], null);
}),let_bindings),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","->Node","sci.impl.types/->Node",-1318888839,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.evaluator","eval-do","sci.impl.evaluator/eval-do",-1643119421,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null))))),null,(1),null)))))))))),null,(1),null))))),null,(1),null)))));
});
(sci.impl.analyzer.gen_return_do.cljs$lang$macro = true);

sci.impl.analyzer.return_do = (function sci$impl$analyzer$return_do(ctx,expr,children){
var analyzed_children = (new cljs.core.Delay((function (){
return sci.impl.analyzer.analyze_children_tail.call(null,ctx,children);
}),null));
var G__39498 = cljs.core.count.call(null,children);
switch (G__39498) {
case (0):
return null;

break;
case (1):
return cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));

break;
case (2):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);

return sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
}),null);

break;
case (3):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);

sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);

return sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
}),null);

break;
default:
var analyzed_children__$1 = cljs.core.deref.call(null,analyzed_children);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return sci.impl.evaluator.eval_do.call(null,ctx__$1,bindings,analyzed_children__$1);
}),null);

}
});
var ret__4913__auto___39504 = sci.impl.analyzer.gen_return_or = (function sci$impl$analyzer$gen_return_or(_AMPERSAND_form,_AMPERSAND_env){
var let_bindings = cljs.core.map.call(null,(function (i){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (j){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,["arg",cljs.core.str.cljs$core$IFn$_invoke$arity$1(j)].join('')),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nth","cljs.core/nth",1961052085,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,j,null,(1),null)))))], null);
}),cljs.core.range.call(null,i)))], null);
}),cljs.core.range.call(null,(2),(20)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"return-or","return-or",1738651729,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","delay","cljs.core/delay",-406049125,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.analyzer","analyze-children-tail","sci.impl.analyzer/analyze-children-tail",628580735,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","case","cljs.core/case",-1674122212,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null)),cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),null], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.analyzer","analyze","sci.impl.analyzer/analyze",1465033510,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null)))))], null),cljs.core.mapcat.call(null,(function (p__39500){
var vec__39501 = p__39500;
var i = cljs.core.nth.call(null,vec__39501,(0),null);
var binds = cljs.core.nth.call(null,vec__39501,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,binds,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","->Node","sci.impl.types/->Node",-1318888839,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),null,(1),null)),cljs.core.map.call(null,(function (j){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","eval","sci.impl.types/eval",700838406,null),null,(1),null)),(new cljs.core.List(null,cljs.core.symbol.call(null,["arg",cljs.core.str.cljs$core$IFn$_invoke$arity$1(j)].join('')),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),null,(1),null)))));
}),cljs.core.range.call(null,i))))),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null)))))], null);
}),let_bindings),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","->Node","sci.impl.types/->Node",-1318888839,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.evaluator","eval-or","sci.impl.evaluator/eval-or",1529967651,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null))))),null,(1),null)))))))))),null,(1),null))))),null,(1),null)))));
});
(sci.impl.analyzer.gen_return_or.cljs$lang$macro = true);

sci.impl.analyzer.return_or = (function sci$impl$analyzer$return_or(ctx,expr,children){
var analyzed_children = (new cljs.core.Delay((function (){
return sci.impl.analyzer.analyze_children_tail.call(null,ctx,children);
}),null));
var G__39505 = cljs.core.count.call(null,children);
switch (G__39505) {
case (0):
return null;

break;
case (1):
return sci.impl.analyzer.analyze.call(null,ctx,cljs.core.first.call(null,children));

break;
case (2):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
}
}),null);

break;
case (3):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
}
}
}),null);

break;
case (4):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
}
}
}
}),null);

break;
case (5):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
return sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
}
}
}
}
}),null);

break;
case (6):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
return sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
}
}
}
}
}
}),null);

break;
case (7):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
return sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
}
}
}
}
}
}
}),null);

break;
case (8):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
return sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
}
}
}
}
}
}
}
}),null);

break;
case (9):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
return sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}),null);

break;
case (10):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
return sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}),null);

break;
case (11):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
return sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (12):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
return sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (13):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
var or__4253__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$11)){
return or__4253__auto____$11;
} else {
return sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (14):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
var or__4253__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$11)){
return or__4253__auto____$11;
} else {
var or__4253__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$12)){
return or__4253__auto____$12;
} else {
return sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (15):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
var or__4253__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$11)){
return or__4253__auto____$11;
} else {
var or__4253__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$12)){
return or__4253__auto____$12;
} else {
var or__4253__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$13)){
return or__4253__auto____$13;
} else {
return sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (16):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
var or__4253__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$11)){
return or__4253__auto____$11;
} else {
var or__4253__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$12)){
return or__4253__auto____$12;
} else {
var or__4253__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$13)){
return or__4253__auto____$13;
} else {
var or__4253__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$14)){
return or__4253__auto____$14;
} else {
return sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (17):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
var arg16 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(16));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
var or__4253__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$11)){
return or__4253__auto____$11;
} else {
var or__4253__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$12)){
return or__4253__auto____$12;
} else {
var or__4253__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$13)){
return or__4253__auto____$13;
} else {
var or__4253__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$14)){
return or__4253__auto____$14;
} else {
var or__4253__auto____$15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$15)){
return or__4253__auto____$15;
} else {
return sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (18):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
var arg16 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(16));
var arg17 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(17));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
var or__4253__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$11)){
return or__4253__auto____$11;
} else {
var or__4253__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$12)){
return or__4253__auto____$12;
} else {
var or__4253__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$13)){
return or__4253__auto____$13;
} else {
var or__4253__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$14)){
return or__4253__auto____$14;
} else {
var or__4253__auto____$15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$15)){
return or__4253__auto____$15;
} else {
var or__4253__auto____$16 = sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$16)){
return or__4253__auto____$16;
} else {
return sci.impl.types.eval.call(null,arg17,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
case (19):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
var arg16 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(16));
var arg17 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(17));
var arg18 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(18));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var or__4253__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
var or__4253__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$3)){
return or__4253__auto____$3;
} else {
var or__4253__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$4)){
return or__4253__auto____$4;
} else {
var or__4253__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$5)){
return or__4253__auto____$5;
} else {
var or__4253__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$6)){
return or__4253__auto____$6;
} else {
var or__4253__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$7)){
return or__4253__auto____$7;
} else {
var or__4253__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$8)){
return or__4253__auto____$8;
} else {
var or__4253__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$9)){
return or__4253__auto____$9;
} else {
var or__4253__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$10)){
return or__4253__auto____$10;
} else {
var or__4253__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$11)){
return or__4253__auto____$11;
} else {
var or__4253__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$12)){
return or__4253__auto____$12;
} else {
var or__4253__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$13)){
return or__4253__auto____$13;
} else {
var or__4253__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$14)){
return or__4253__auto____$14;
} else {
var or__4253__auto____$15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$15)){
return or__4253__auto____$15;
} else {
var or__4253__auto____$16 = sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$16)){
return or__4253__auto____$16;
} else {
var or__4253__auto____$17 = sci.impl.types.eval.call(null,arg17,ctx__$1,bindings);
if(cljs.core.truth_(or__4253__auto____$17)){
return or__4253__auto____$17;
} else {
return sci.impl.types.eval.call(null,arg18,ctx__$1,bindings);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}),null);

break;
default:
var analyzed_children__$1 = cljs.core.deref.call(null,analyzed_children);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return sci.impl.evaluator.eval_or.call(null,analyzed_children__$1,ctx__$1,bindings);
}),null);

}
});
var ret__4913__auto___39511 = sci.impl.analyzer.gen_return_and = (function sci$impl$analyzer$gen_return_and(_AMPERSAND_form,_AMPERSAND_env){
var let_bindings = cljs.core.map.call(null,(function (i){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (j){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,["arg",cljs.core.str.cljs$core$IFn$_invoke$arity$1(j)].join('')),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nth","cljs.core/nth",1961052085,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,j,null,(1),null)))))], null);
}),cljs.core.range.call(null,i)))], null);
}),cljs.core.range.call(null,(2),(20)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"return-and","return-and",-991888679,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),new cljs.core.Symbol(null,"expr","expr",-1908713478,null),new cljs.core.Symbol(null,"children","children",699969545,null)], null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","delay","cljs.core/delay",-406049125,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.analyzer","analyze-children-tail","sci.impl.analyzer/analyze-children-tail",628580735,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","case","cljs.core/case",-1674122212,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null)),cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),null], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.analyzer","analyze","sci.impl.analyzer/analyze",1465033510,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"children","children",699969545,null),null,(1),null))))),null,(1),null)))))], null),cljs.core.mapcat.call(null,(function (p__39507){
var vec__39508 = p__39507;
var i = cljs.core.nth.call(null,vec__39508,(0),null);
var binds = cljs.core.nth.call(null,vec__39508,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,binds,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","->Node","sci.impl.types/->Node",-1318888839,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),null,(1),null)),cljs.core.map.call(null,(function (j){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","eval","sci.impl.types/eval",700838406,null),null,(1),null)),(new cljs.core.List(null,cljs.core.symbol.call(null,["arg",cljs.core.str.cljs$core$IFn$_invoke$arity$1(j)].join('')),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),null,(1),null)))));
}),cljs.core.range.call(null,i))))),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null)))))], null);
}),let_bindings),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.types","->Node","sci.impl.types/->Node",-1318888839,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("sci.impl.evaluator","eval-and","sci.impl.evaluator/eval-and",298758339,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"bindings","bindings",-1383038577,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"analyzed-children","analyzed-children",1732620617,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null))))),null,(1),null)))))))))),null,(1),null))))),null,(1),null)))));
});
(sci.impl.analyzer.gen_return_and.cljs$lang$macro = true);

sci.impl.analyzer.return_and = (function sci$impl$analyzer$return_and(ctx,expr,children){
var analyzed_children = (new cljs.core.Delay((function (){
return sci.impl.analyzer.analyze_children_tail.call(null,ctx,children);
}),null));
var G__39512 = cljs.core.count.call(null,children);
switch (G__39512) {
case (0):
return null;

break;
case (1):
return sci.impl.analyzer.analyze.call(null,ctx,cljs.core.first.call(null,children));

break;
case (2):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
return sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
} else {
return and__4251__auto__;
}
}),null);

break;
case (3):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
return sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (4):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
return sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (5):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
return sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (6):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
return sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (7):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
return sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (8):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
return sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (9):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
return sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (10):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
return sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (11):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
return sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (12):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
return sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (13):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
var and__4251__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$11)){
return sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
} else {
return and__4251__auto____$11;
}
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (14):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
var and__4251__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$11)){
var and__4251__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$12)){
return sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
} else {
return and__4251__auto____$12;
}
} else {
return and__4251__auto____$11;
}
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (15):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
var and__4251__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$11)){
var and__4251__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$12)){
var and__4251__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$13)){
return sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
} else {
return and__4251__auto____$13;
}
} else {
return and__4251__auto____$12;
}
} else {
return and__4251__auto____$11;
}
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (16):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
var and__4251__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$11)){
var and__4251__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$12)){
var and__4251__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$13)){
var and__4251__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$14)){
return sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
} else {
return and__4251__auto____$14;
}
} else {
return and__4251__auto____$13;
}
} else {
return and__4251__auto____$12;
}
} else {
return and__4251__auto____$11;
}
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (17):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
var arg16 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(16));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
var and__4251__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$11)){
var and__4251__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$12)){
var and__4251__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$13)){
var and__4251__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$14)){
var and__4251__auto____$15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$15)){
return sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
} else {
return and__4251__auto____$15;
}
} else {
return and__4251__auto____$14;
}
} else {
return and__4251__auto____$13;
}
} else {
return and__4251__auto____$12;
}
} else {
return and__4251__auto____$11;
}
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (18):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
var arg16 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(16));
var arg17 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(17));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
var and__4251__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$11)){
var and__4251__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$12)){
var and__4251__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$13)){
var and__4251__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$14)){
var and__4251__auto____$15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$15)){
var and__4251__auto____$16 = sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$16)){
return sci.impl.types.eval.call(null,arg17,ctx__$1,bindings);
} else {
return and__4251__auto____$16;
}
} else {
return and__4251__auto____$15;
}
} else {
return and__4251__auto____$14;
}
} else {
return and__4251__auto____$13;
}
} else {
return and__4251__auto____$12;
}
} else {
return and__4251__auto____$11;
}
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
case (19):
var arg0 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(0));
var arg1 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(1));
var arg2 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(2));
var arg3 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(3));
var arg4 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(4));
var arg5 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(5));
var arg6 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(6));
var arg7 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(7));
var arg8 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(8));
var arg9 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(9));
var arg10 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(10));
var arg11 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(11));
var arg12 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(12));
var arg13 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(13));
var arg14 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(14));
var arg15 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(15));
var arg16 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(16));
var arg17 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(17));
var arg18 = cljs.core.nth.call(null,cljs.core.deref.call(null,analyzed_children),(18));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var and__4251__auto__ = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$3)){
var and__4251__auto____$4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$4)){
var and__4251__auto____$5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$5)){
var and__4251__auto____$6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$6)){
var and__4251__auto____$7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$7)){
var and__4251__auto____$8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$8)){
var and__4251__auto____$9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$9)){
var and__4251__auto____$10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$10)){
var and__4251__auto____$11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$11)){
var and__4251__auto____$12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$12)){
var and__4251__auto____$13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$13)){
var and__4251__auto____$14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$14)){
var and__4251__auto____$15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$15)){
var and__4251__auto____$16 = sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$16)){
var and__4251__auto____$17 = sci.impl.types.eval.call(null,arg17,ctx__$1,bindings);
if(cljs.core.truth_(and__4251__auto____$17)){
return sci.impl.types.eval.call(null,arg18,ctx__$1,bindings);
} else {
return and__4251__auto____$17;
}
} else {
return and__4251__auto____$16;
}
} else {
return and__4251__auto____$15;
}
} else {
return and__4251__auto____$14;
}
} else {
return and__4251__auto____$13;
}
} else {
return and__4251__auto____$12;
}
} else {
return and__4251__auto____$11;
}
} else {
return and__4251__auto____$10;
}
} else {
return and__4251__auto____$9;
}
} else {
return and__4251__auto____$8;
}
} else {
return and__4251__auto____$7;
}
} else {
return and__4251__auto____$6;
}
} else {
return and__4251__auto____$5;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
}),null);

break;
default:
var analyzed_children__$1 = cljs.core.deref.call(null,analyzed_children);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return sci.impl.evaluator.eval_and.call(null,ctx__$1,bindings,analyzed_children__$1);
}),null);

}
});
sci.impl.analyzer.return_recur = (function sci$impl$analyzer$return_recur(ctx,expr,analyzed_children){
if(cljs.core.truth_(sci.impl.analyzer.recur_target_QMARK_.call(null,ctx))){
} else {
sci.impl.analyzer.throw_error_with_location.call(null,"Can only recur from tail position",expr);
}

var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(ctx);
var G__39514 = cljs.core.count.call(null,analyzed_children);
switch (G__39514) {
case (0):
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (1):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
(bindings[(0)] = eval_0);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (2):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (3):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (4):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (5):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (6):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (7):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (8):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (9):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (10):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (11):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (12):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (13):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var param12 = cljs.core.nth.call(null,params,(12));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
var eval_12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

(bindings[(12)] = eval_12);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (14):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var param12 = cljs.core.nth.call(null,params,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var param13 = cljs.core.nth.call(null,params,(13));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
var eval_12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
var eval_13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

(bindings[(12)] = eval_12);

(bindings[(13)] = eval_13);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (15):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var param12 = cljs.core.nth.call(null,params,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var param13 = cljs.core.nth.call(null,params,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var param14 = cljs.core.nth.call(null,params,(14));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
var eval_12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
var eval_13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
var eval_14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

(bindings[(12)] = eval_12);

(bindings[(13)] = eval_13);

(bindings[(14)] = eval_14);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (16):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var param12 = cljs.core.nth.call(null,params,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var param13 = cljs.core.nth.call(null,params,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var param14 = cljs.core.nth.call(null,params,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var param15 = cljs.core.nth.call(null,params,(15));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
var eval_12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
var eval_13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
var eval_14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
var eval_15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

(bindings[(12)] = eval_12);

(bindings[(13)] = eval_13);

(bindings[(14)] = eval_14);

(bindings[(15)] = eval_15);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (17):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var param12 = cljs.core.nth.call(null,params,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var param13 = cljs.core.nth.call(null,params,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var param14 = cljs.core.nth.call(null,params,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var param15 = cljs.core.nth.call(null,params,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var param16 = cljs.core.nth.call(null,params,(16));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
var eval_12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
var eval_13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
var eval_14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
var eval_15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
var eval_16 = sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

(bindings[(12)] = eval_12);

(bindings[(13)] = eval_13);

(bindings[(14)] = eval_14);

(bindings[(15)] = eval_15);

(bindings[(16)] = eval_16);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (18):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var param12 = cljs.core.nth.call(null,params,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var param13 = cljs.core.nth.call(null,params,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var param14 = cljs.core.nth.call(null,params,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var param15 = cljs.core.nth.call(null,params,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var param16 = cljs.core.nth.call(null,params,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
var param17 = cljs.core.nth.call(null,params,(17));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
var eval_12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
var eval_13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
var eval_14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
var eval_15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
var eval_16 = sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
var eval_17 = sci.impl.types.eval.call(null,arg17,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

(bindings[(12)] = eval_12);

(bindings[(13)] = eval_13);

(bindings[(14)] = eval_14);

(bindings[(15)] = eval_15);

(bindings[(16)] = eval_16);

(bindings[(17)] = eval_17);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
case (19):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var param0 = cljs.core.nth.call(null,params,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var param1 = cljs.core.nth.call(null,params,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var param2 = cljs.core.nth.call(null,params,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var param3 = cljs.core.nth.call(null,params,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var param4 = cljs.core.nth.call(null,params,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var param5 = cljs.core.nth.call(null,params,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var param6 = cljs.core.nth.call(null,params,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var param7 = cljs.core.nth.call(null,params,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var param8 = cljs.core.nth.call(null,params,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var param9 = cljs.core.nth.call(null,params,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var param10 = cljs.core.nth.call(null,params,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var param11 = cljs.core.nth.call(null,params,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var param12 = cljs.core.nth.call(null,params,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var param13 = cljs.core.nth.call(null,params,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var param14 = cljs.core.nth.call(null,params,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var param15 = cljs.core.nth.call(null,params,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var param16 = cljs.core.nth.call(null,params,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
var param17 = cljs.core.nth.call(null,params,(17));
var arg18 = cljs.core.nth.call(null,analyzed_children,(18));
var param18 = cljs.core.nth.call(null,params,(18));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var eval_0 = sci.impl.types.eval.call(null,arg0,ctx__$1,bindings);
var eval_1 = sci.impl.types.eval.call(null,arg1,ctx__$1,bindings);
var eval_2 = sci.impl.types.eval.call(null,arg2,ctx__$1,bindings);
var eval_3 = sci.impl.types.eval.call(null,arg3,ctx__$1,bindings);
var eval_4 = sci.impl.types.eval.call(null,arg4,ctx__$1,bindings);
var eval_5 = sci.impl.types.eval.call(null,arg5,ctx__$1,bindings);
var eval_6 = sci.impl.types.eval.call(null,arg6,ctx__$1,bindings);
var eval_7 = sci.impl.types.eval.call(null,arg7,ctx__$1,bindings);
var eval_8 = sci.impl.types.eval.call(null,arg8,ctx__$1,bindings);
var eval_9 = sci.impl.types.eval.call(null,arg9,ctx__$1,bindings);
var eval_10 = sci.impl.types.eval.call(null,arg10,ctx__$1,bindings);
var eval_11 = sci.impl.types.eval.call(null,arg11,ctx__$1,bindings);
var eval_12 = sci.impl.types.eval.call(null,arg12,ctx__$1,bindings);
var eval_13 = sci.impl.types.eval.call(null,arg13,ctx__$1,bindings);
var eval_14 = sci.impl.types.eval.call(null,arg14,ctx__$1,bindings);
var eval_15 = sci.impl.types.eval.call(null,arg15,ctx__$1,bindings);
var eval_16 = sci.impl.types.eval.call(null,arg16,ctx__$1,bindings);
var eval_17 = sci.impl.types.eval.call(null,arg17,ctx__$1,bindings);
var eval_18 = sci.impl.types.eval.call(null,arg18,ctx__$1,bindings);
(bindings[(0)] = eval_0);

(bindings[(1)] = eval_1);

(bindings[(2)] = eval_2);

(bindings[(3)] = eval_3);

(bindings[(4)] = eval_4);

(bindings[(5)] = eval_5);

(bindings[(6)] = eval_6);

(bindings[(7)] = eval_7);

(bindings[(8)] = eval_8);

(bindings[(9)] = eval_9);

(bindings[(10)] = eval_10);

(bindings[(11)] = eval_11);

(bindings[(12)] = eval_12);

(bindings[(13)] = eval_13);

(bindings[(14)] = eval_14);

(bindings[(15)] = eval_15);

(bindings[(16)] = eval_16);

(bindings[(17)] = eval_17);

(bindings[(18)] = eval_18);

return new cljs.core.Keyword("sci.impl.analyzer","recur","sci.impl.analyzer/recur",2033369355);
}),null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39514)].join('')));

}
});
sci.impl.analyzer.analyze_children = (function sci$impl$analyzer$analyze_children(ctx,children){
return cljs.core.mapv.call(null,(function (p1__39516_SHARP_){
return sci.impl.analyzer.analyze.call(null,ctx,p1__39516_SHARP_);
}),children);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
sci.impl.analyzer.FnBody = (function (params,body,fixed_arity,var_arg_name,self_ref_idx,iden__GT_invoke_idx,__meta,__extmap,__hash){
this.params = params;
this.body = body;
this.fixed_arity = fixed_arity;
this.var_arg_name = var_arg_name;
this.self_ref_idx = self_ref_idx;
this.iden__GT_invoke_idx = iden__GT_invoke_idx;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(sci.impl.analyzer.FnBody.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k39518,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__39522 = k39518;
var G__39522__$1 = (((G__39522 instanceof cljs.core.Keyword))?G__39522.fqn:null);
switch (G__39522__$1) {
case "params":
return self__.params;

break;
case "body":
return self__.body;

break;
case "fixed-arity":
return self__.fixed_arity;

break;
case "var-arg-name":
return self__.var_arg_name;

break;
case "self-ref-idx":
return self__.self_ref_idx;

break;
case "iden->invoke-idx":
return self__.iden__GT_invoke_idx;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k39518,else__4505__auto__);

}
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__39523){
var vec__39524 = p__39523;
var k__4526__auto__ = cljs.core.nth.call(null,vec__39524,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__39524,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#sci.impl.analyzer.FnBody{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"body","body",-2049205669),self__.body],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),self__.fixed_arity],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887),self__.var_arg_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812),self__.self_ref_idx],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026),self__.iden__GT_invoke_idx],null))], null),self__.__extmap));
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39517){
var self__ = this;
var G__39517__$1 = this;
return (new cljs.core.RecordIter((0),G__39517__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887),new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812),new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,self__.fixed_arity,self__.var_arg_name,self__.self_ref_idx,self__.iden__GT_invoke_idx,self__.__meta,self__.__extmap,self__.__hash));
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1733662014 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39519,other39520){
var self__ = this;
var this39519__$1 = this;
return (((!((other39520 == null)))) && ((((this39519__$1.constructor === other39520.constructor)) && (((cljs.core._EQ_.call(null,this39519__$1.params,other39520.params)) && (((cljs.core._EQ_.call(null,this39519__$1.body,other39520.body)) && (((cljs.core._EQ_.call(null,this39519__$1.fixed_arity,other39520.fixed_arity)) && (((cljs.core._EQ_.call(null,this39519__$1.var_arg_name,other39520.var_arg_name)) && (((cljs.core._EQ_.call(null,this39519__$1.self_ref_idx,other39520.self_ref_idx)) && (((cljs.core._EQ_.call(null,this39519__$1.iden__GT_invoke_idx,other39520.iden__GT_invoke_idx)) && (cljs.core._EQ_.call(null,this39519__$1.__extmap,other39520.__extmap)))))))))))))))));
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812),null,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),null,new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026),null,new cljs.core.Keyword(null,"body","body",-2049205669),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,self__.fixed_arity,self__.var_arg_name,self__.self_ref_idx,self__.iden__GT_invoke_idx,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k39518){
var self__ = this;
var this__4509__auto____$1 = this;
var G__39527 = k39518;
var G__39527__$1 = (((G__39527 instanceof cljs.core.Keyword))?G__39527.fqn:null);
switch (G__39527__$1) {
case "params":
case "body":
case "fixed-arity":
case "var-arg-name":
case "self-ref-idx":
case "iden->invoke-idx":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k39518);

}
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__39517){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__39528 = cljs.core.keyword_identical_QMARK_;
var expr__39529 = k__4511__auto__;
if(cljs.core.truth_(pred__39528.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__39529))){
return (new sci.impl.analyzer.FnBody(G__39517,self__.body,self__.fixed_arity,self__.var_arg_name,self__.self_ref_idx,self__.iden__GT_invoke_idx,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39528.call(null,new cljs.core.Keyword(null,"body","body",-2049205669),expr__39529))){
return (new sci.impl.analyzer.FnBody(self__.params,G__39517,self__.fixed_arity,self__.var_arg_name,self__.self_ref_idx,self__.iden__GT_invoke_idx,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39528.call(null,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),expr__39529))){
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,G__39517,self__.var_arg_name,self__.self_ref_idx,self__.iden__GT_invoke_idx,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39528.call(null,new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887),expr__39529))){
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,self__.fixed_arity,G__39517,self__.self_ref_idx,self__.iden__GT_invoke_idx,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39528.call(null,new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812),expr__39529))){
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,self__.fixed_arity,self__.var_arg_name,G__39517,self__.iden__GT_invoke_idx,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39528.call(null,new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026),expr__39529))){
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,self__.fixed_arity,self__.var_arg_name,self__.self_ref_idx,G__39517,self__.__meta,self__.__extmap,null));
} else {
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,self__.fixed_arity,self__.var_arg_name,self__.self_ref_idx,self__.iden__GT_invoke_idx,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__39517),null));
}
}
}
}
}
}
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"params","params",710516235),self__.params,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"body","body",-2049205669),self__.body,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),self__.fixed_arity,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887),self__.var_arg_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812),self__.self_ref_idx,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026),self__.iden__GT_invoke_idx,null))], null),self__.__extmap));
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__39517){
var self__ = this;
var this__4501__auto____$1 = this;
return (new sci.impl.analyzer.FnBody(self__.params,self__.body,self__.fixed_arity,self__.var_arg_name,self__.self_ref_idx,self__.iden__GT_invoke_idx,G__39517,self__.__extmap,self__.__hash));
}));

(sci.impl.analyzer.FnBody.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(sci.impl.analyzer.FnBody.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"body","body",-408674142,null),new cljs.core.Symbol(null,"fixed-arity","fixed-arity",-1067989900,null),new cljs.core.Symbol(null,"var-arg-name","var-arg-name",540506640,null),new cljs.core.Symbol(null,"self-ref-idx","self-ref-idx",255993715,null),new cljs.core.Symbol(null,"iden->invoke-idx","iden->invoke-idx",-157095499,null)], null);
}));

(sci.impl.analyzer.FnBody.cljs$lang$type = true);

(sci.impl.analyzer.FnBody.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"sci.impl.analyzer/FnBody",null,(1),null));
}));

(sci.impl.analyzer.FnBody.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"sci.impl.analyzer/FnBody");
}));

/**
 * Positional factory function for sci.impl.analyzer/FnBody.
 */
sci.impl.analyzer.__GT_FnBody = (function sci$impl$analyzer$__GT_FnBody(params,body,fixed_arity,var_arg_name,self_ref_idx,iden__GT_invoke_idx){
return (new sci.impl.analyzer.FnBody(params,body,fixed_arity,var_arg_name,self_ref_idx,iden__GT_invoke_idx,null,null,null));
});

/**
 * Factory function for sci.impl.analyzer/FnBody, taking a map of keywords to field values.
 */
sci.impl.analyzer.map__GT_FnBody = (function sci$impl$analyzer$map__GT_FnBody(G__39521){
var extmap__4542__auto__ = (function (){var G__39531 = cljs.core.dissoc.call(null,G__39521,new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887),new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812),new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026));
if(cljs.core.record_QMARK_.call(null,G__39521)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__39531);
} else {
return G__39531;
}
})();
return (new sci.impl.analyzer.FnBody(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__39521),new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(G__39521),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869).cljs$core$IFn$_invoke$arity$1(G__39521),new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887).cljs$core$IFn$_invoke$arity$1(G__39521),new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812).cljs$core$IFn$_invoke$arity$1(G__39521),new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026).cljs$core$IFn$_invoke$arity$1(G__39521),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

sci.impl.analyzer.expand_fn_args_PLUS_body = (function sci$impl$analyzer$expand_fn_args_PLUS_body(p__39535,p__39536,macro_QMARK_,fn_name,fn_id){
var map__39537 = p__39535;
var map__39537__$1 = cljs.core.__destructure_map.call(null,map__39537);
var ctx = map__39537__$1;
var fn_expr = cljs.core.get.call(null,map__39537__$1,new cljs.core.Keyword(null,"fn-expr","fn-expr",-933027985));
var vec__39538 = p__39536;
var seq__39539 = cljs.core.seq.call(null,vec__39538);
var first__39540 = cljs.core.first.call(null,seq__39539);
var seq__39539__$1 = cljs.core.next.call(null,seq__39539);
var binding_vector = first__39540;
var body_exprs = seq__39539__$1;
if(cljs.core.truth_(binding_vector)){
} else {
sci.impl.analyzer.throw_error_with_location.call(null,"Parameter declaration missing.",fn_expr);
}

if(cljs.core.vector_QMARK_.call(null,binding_vector)){
} else {
sci.impl.analyzer.throw_error_with_location.call(null,"Parameter declaration should be a vector",fn_expr);
}

var binding_vector__$1 = (cljs.core.truth_(macro_QMARK_)?cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null)], null),binding_vector):binding_vector);
var next_body = cljs.core.next.call(null,body_exprs);
var conds = ((next_body)?(function (){var e = cljs.core.first.call(null,body_exprs);
if(cljs.core.map_QMARK_.call(null,e)){
return e;
} else {
return null;
}
})():null);
var body_exprs__$1 = (cljs.core.truth_(conds)?next_body:body_exprs);
var conds__$1 = (function (){var or__4253__auto__ = conds;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.meta.call(null,binding_vector__$1);
}
})();
var pre = new cljs.core.Keyword(null,"pre","pre",2118456869).cljs$core$IFn$_invoke$arity$1(conds__$1);
var post = new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(conds__$1);
var body_exprs__$2 = (cljs.core.truth_(post)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"%","%",-950237169,null),null,(1),null)),(new cljs.core.List(null,((((1) < cljs.core.count.call(null,body_exprs__$1)))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"do","do",1686842252,null),null,(1),null)),body_exprs__$1))):cljs.core.first.call(null,body_exprs__$1)),null,(1),null)))))),null,(1),null)),cljs.core.map.call(null,(function (c){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","assert","cljs.core/assert",1075777968,null),null,(1),null)),(new cljs.core.List(null,c,null,(1),null)))));
}),post),(new cljs.core.List(null,new cljs.core.Symbol(null,"%","%",-950237169,null),null,(1),null))))),null,(1),null))))):body_exprs__$1);
var body_exprs__$3 = (cljs.core.truth_(pre)?cljs.core.concat.call(null,cljs.core.map.call(null,(function (c){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","assert","cljs.core/assert",1075777968,null),null,(1),null)),(new cljs.core.List(null,c,null,(1),null)))));
}),pre),body_exprs__$2):body_exprs__$2);
var map__39541 = sci.impl.utils.maybe_destructured.call(null,binding_vector__$1,body_exprs__$3);
var map__39541__$1 = cljs.core.__destructure_map.call(null,map__39541);
var params = cljs.core.get.call(null,map__39541__$1,new cljs.core.Keyword(null,"params","params",710516235));
var body = cljs.core.get.call(null,map__39541__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var vec__39542 = cljs.core.split_with.call(null,(function (p1__39534_SHARP_){
return cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"&","&",-2144855648,null),p1__39534_SHARP_);
}),params);
var fixed_args = cljs.core.nth.call(null,vec__39542,(0),null);
var vec__39545 = cljs.core.nth.call(null,vec__39542,(1),null);
var _ = cljs.core.nth.call(null,vec__39545,(0),null);
var var_arg_name = cljs.core.nth.call(null,vec__39545,(1),null);
var fixed_args__$1 = cljs.core.vec.call(null,fixed_args);
var fixed_arity = cljs.core.count.call(null,fixed_args__$1);
var param_names = (function (){var G__39548 = fixed_args__$1;
if(cljs.core.truth_(var_arg_name)){
return cljs.core.conj.call(null,G__39548,var_arg_name);
} else {
return G__39548;
}
})();
var ctx__$1 = cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"params","params",710516235),param_names);
var param_count = cljs.core.count.call(null,param_names);
var param_idens = cljs.core.repeatedly.call(null,param_count,cljs.core.gensym);
var param_bindings = cljs.core.zipmap.call(null,param_names,param_idens);
var iden__GT_invoke_idx = cljs.core.zipmap.call(null,param_idens,cljs.core.range.call(null));
var bindings = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx__$1);
var ctx__$2 = cljs.core.assoc.call(null,ctx__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.merge.call(null,bindings,param_bindings));
var ctx__$3 = cljs.core.assoc.call(null,ctx__$2,new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026),iden__GT_invoke_idx);
var ctx__$4 = cljs.core.update.call(null,ctx__$3,new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.conj,fixed_arity);
var ___$1 = cljs.core._vreset_BANG_.call(null,new cljs.core.Keyword(null,"closure-bindings","closure-bindings",112932037).cljs$core$IFn$_invoke$arity$1(ctx__$4),cljs.core.assoc_in.call(null,cljs.core._deref.call(null,new cljs.core.Keyword(null,"closure-bindings","closure-bindings",112932037).cljs$core$IFn$_invoke$arity$1(ctx__$4)),cljs.core.conj.call(null,new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(ctx__$4),new cljs.core.Keyword(null,"syms","syms",-1575891762)),cljs.core.zipmap.call(null,param_idens,cljs.core.range.call(null))));
var self_ref_idx = (cljs.core.truth_(fn_name)?sci.impl.analyzer.update_parents.call(null,ctx__$4,new cljs.core.Keyword(null,"closure-bindings","closure-bindings",112932037).cljs$core$IFn$_invoke$arity$1(ctx__$4),fn_id):null);
var body__$1 = sci.impl.analyzer.return_do.call(null,sci.impl.analyzer.with_recur_target.call(null,ctx__$4,true),fn_expr,body);
var iden__GT_invoke_idx__$1 = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"closure-bindings","closure-bindings",112932037).cljs$core$IFn$_invoke$arity$1(ctx__$4)),cljs.core.conj.call(null,new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(ctx__$4),new cljs.core.Keyword(null,"syms","syms",-1575891762)));
var G__39549 = sci.impl.analyzer.__GT_FnBody.call(null,params,body__$1,fixed_arity,var_arg_name,self_ref_idx,iden__GT_invoke_idx__$1);
if(cljs.core.truth_(var_arg_name)){
return cljs.core.assoc.call(null,G__39549,new cljs.core.Keyword(null,"vararg-idx","vararg-idx",-590991228),cljs.core.get.call(null,iden__GT_invoke_idx__$1,cljs.core.last.call(null,param_idens)));
} else {
return G__39549;
}
});
sci.impl.analyzer.analyzed_fn_meta = (function sci$impl$analyzer$analyzed_fn_meta(ctx,m){
var meta_needs_eval_QMARK_ = (cljs.core.count.call(null,m) > (2));
var m__$1 = ((meta_needs_eval_QMARK_)?cljs.core.vary_meta.call(null,sci.impl.analyzer.analyze.call(null,cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"meta","meta",1499536964),true),m),cljs.core.assoc,new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978),new cljs.core.Keyword(null,"eval","eval",-1103567905)):m);
return m__$1;
});
sci.impl.analyzer.analyze_fn_STAR_ = (function sci$impl$analyzer$analyze_fn_STAR_(ctx,p__39550,macro_QMARK_){
var vec__39551 = p__39550;
var seq__39552 = cljs.core.seq.call(null,vec__39551);
var first__39553 = cljs.core.first.call(null,seq__39552);
var seq__39552__$1 = cljs.core.next.call(null,seq__39552);
var _fn = first__39553;
var first__39553__$1 = cljs.core.first.call(null,seq__39552__$1);
var seq__39552__$2 = cljs.core.next.call(null,seq__39552__$1);
var name_QMARK_ = first__39553__$1;
var body = seq__39552__$2;
var fn_expr = vec__39551;
var ctx__$1 = cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"fn-expr","fn-expr",-933027985),fn_expr);
var fn_name = (((name_QMARK_ instanceof cljs.core.Symbol))?name_QMARK_:null);
var body__$1 = (cljs.core.truth_(fn_name)?body:cljs.core.cons.call(null,name_QMARK_,body));
var bodies = ((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,body__$1)))?body__$1:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [body__$1], null));
var fn_id = cljs.core.gensym.call(null);
var parents = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY).call(null,new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(ctx__$1),fn_id);
var ctx__$2 = cljs.core.assoc.call(null,ctx__$1,new cljs.core.Keyword(null,"parents","parents",-2027538891),parents);
var ctx__$3 = (cljs.core.truth_(fn_name)?cljs.core.assoc_in.call(null,ctx__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),fn_name], null),fn_id):ctx__$2);
var bindings = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx__$3);
var bound_idens = cljs.core.set.call(null,cljs.core.vals.call(null,bindings));
var ctx__$4 = cljs.core.assoc.call(null,ctx__$3,new cljs.core.Keyword(null,"outer-idens","outer-idens",1197381241),bound_idens);
var closure_bindings = new cljs.core.Keyword(null,"closure-bindings","closure-bindings",112932037).cljs$core$IFn$_invoke$arity$1(ctx__$4);
var analyzed_bodies = cljs.core.reduce.call(null,(function (p__39554,body__$2){
var map__39555 = p__39554;
var map__39555__$1 = cljs.core.__destructure_map.call(null,map__39555);
var acc = map__39555__$1;
var max_fixed = cljs.core.get.call(null,map__39555__$1,new cljs.core.Keyword(null,"max-fixed","max-fixed",166770124));
var min_varargs = cljs.core.get.call(null,map__39555__$1,new cljs.core.Keyword(null,"min-varargs","min-varargs",1999010596));
var orig_body = body__$2;
var arglist = cljs.core.first.call(null,body__$2);
var body__$3 = sci.impl.analyzer.expand_fn_args_PLUS_body.call(null,ctx__$4,body__$2,macro_QMARK_,fn_name,fn_id);
var var_arg_name = new cljs.core.Keyword(null,"var-arg-name","var-arg-name",-1100024887).cljs$core$IFn$_invoke$arity$1(body__$3);
var fixed_arity = new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869).cljs$core$IFn$_invoke$arity$1(body__$3);
var new_min_varargs = (cljs.core.truth_(var_arg_name)?fixed_arity:null);
if(cljs.core.truth_((function (){var and__4251__auto__ = var_arg_name;
if(cljs.core.truth_(and__4251__auto__)){
return min_varargs;
} else {
return and__4251__auto__;
}
})())){
sci.impl.analyzer.throw_error_with_location.call(null,"Can't have more than 1 variadic overload",fn_expr);
} else {
}

if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.not.call(null,var_arg_name);
if(and__4251__auto__){
var and__4251__auto____$1 = min_varargs;
if(cljs.core.truth_(and__4251__auto____$1)){
return (fixed_arity > min_varargs);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
sci.impl.analyzer.throw_error_with_location.call(null,"Can't have fixed arity function with more params than variadic function",fn_expr);
} else {
}

return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"min-varargs","min-varargs",1999010596),new_min_varargs,new cljs.core.Keyword(null,"max-fixed","max-fixed",166770124),(function (){var x__4336__auto__ = fixed_arity;
var y__4337__auto__ = max_fixed;
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
})()),new cljs.core.Keyword(null,"bodies","bodies",-1295887172),cljs.core.conj,cljs.core.assoc.call(null,body__$3,new cljs.core.Keyword(null,"orig","orig",-1678309870),orig_body)),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.conj,arglist);
}),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"bodies","bodies",-1295887172),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"min-var-args","min-var-args",-1883389660),null,new cljs.core.Keyword(null,"max-fixed","max-fixed",166770124),(-1)], null),bodies);
var cb_idens_by_arity = cljs.core.get_in.call(null,cljs.core.deref.call(null,closure_bindings),parents);
var cb_idens = cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,new cljs.core.Keyword(null,"syms","syms",-1575891762),cljs.core.vals.call(null,cb_idens_by_arity)));
var self_ref_QMARK_ = (cljs.core.truth_(fn_name)?cljs.core.contains_QMARK_.call(null,cb_idens,fn_id):null);
var closed_over_idens = cljs.core.filter.call(null,bound_idens,cljs.core.keys.call(null,cb_idens));
var iden__GT_invoke_idx = cljs.core.get_in.call(null,cljs.core.deref.call(null,closure_bindings),cljs.core.conj.call(null,cljs.core.pop.call(null,parents),new cljs.core.Keyword(null,"syms","syms",-1575891762)));
var closed_over_iden__GT_binding_idx = (cljs.core.truth_(iden__GT_invoke_idx)?cljs.core.zipmap.call(null,closed_over_idens,cljs.core.mapv.call(null,iden__GT_invoke_idx,closed_over_idens)):null);
var closed_over_cnt = cljs.core.count.call(null,closed_over_idens);
var iden__GT_enclosed_idx = cljs.core.zipmap.call(null,closed_over_idens,cljs.core.range.call(null,closed_over_cnt));
var iden__GT_enclosed_idx__$1 = (cljs.core.truth_(fn_name)?cljs.core.assoc.call(null,iden__GT_enclosed_idx,fn_id,closed_over_cnt):iden__GT_enclosed_idx);
var enclosed_array_fn = (((function (){var or__4253__auto__ = self_ref_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.seq.call(null,closed_over_iden__GT_binding_idx);
}
})())?(function (){var enclosed_array_cnt = (function (){var G__39556 = closed_over_cnt;
if(cljs.core.truth_(fn_name)){
return (G__39556 + (1));
} else {
return G__39556;
}
})();
var binding__GT_enclosed = cljs.core.into_array.call(null,cljs.core.keep.call(null,(function (iden){
var temp__5804__auto__ = cljs.core.get.call(null,iden__GT_invoke_idx,iden);
if(cljs.core.truth_(temp__5804__auto__)){
var binding_idx = temp__5804__auto__;
var enclosed_idx = cljs.core.get.call(null,iden__GT_enclosed_idx__$1,iden);
var G__39557 = cljs.core.object_array.call(null,(2));
(G__39557[(0)] = binding_idx);

(G__39557[(1)] = enclosed_idx);

return G__39557;
} else {
return null;
}
}),closed_over_idens));
return (function (bindings__$1){
var a__4738__auto__ = binding__GT_enclosed;
var l__4739__auto__ = a__4738__auto__.length;
var idx = (0);
var ret = cljs.core.object_array.call(null,enclosed_array_cnt);
while(true){
if((idx < l__4739__auto__)){
var G__39559 = (idx + (1));
var G__39560 = (function (){var idxs = (binding__GT_enclosed[idx]);
var binding_idx = (idxs[(0)]);
var binding_val = (bindings__$1[binding_idx]);
var enclosed_idx = (idxs[(1)]);
(ret[enclosed_idx] = binding_val);

return ret;
})();
idx = G__39559;
ret = G__39560;
continue;
} else {
return ret;
}
break;
}
});
})():cljs.core.constantly.call(null,null));
var bodies__$1 = new cljs.core.Keyword(null,"bodies","bodies",-1295887172).cljs$core$IFn$_invoke$arity$1(analyzed_bodies);
var bodies__$2 = cljs.core.mapv.call(null,(function (body__$2){
var iden__GT_invocation_idx = new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026).cljs$core$IFn$_invoke$arity$1(body__$2);
var invocation_self_idx = new cljs.core.Keyword(null,"self-ref-idx","self-ref-idx",-1384537812).cljs$core$IFn$_invoke$arity$1(body__$2);
var enclosed__GT_invocation = cljs.core.into_array.call(null,cljs.core.keep.call(null,(function (iden){
var temp__5804__auto__ = iden__GT_invocation_idx.call(null,iden);
if(cljs.core.truth_(temp__5804__auto__)){
var invocation_idx = temp__5804__auto__;
var G__39558 = cljs.core.object_array.call(null,(2));
(G__39558[(0)] = iden__GT_enclosed_idx__$1.call(null,iden));

(G__39558[(1)] = invocation_idx);

return G__39558;
} else {
return null;
}
}),closed_over_idens));
var invoc_size = cljs.core.count.call(null,iden__GT_invocation_idx);
var copy_enclosed__GT_invocation = (((enclosed__GT_invocation.length > (0)))?(function (enclosed_array,invoc_array){
var a__4738__auto__ = enclosed__GT_invocation;
var l__4739__auto__ = a__4738__auto__.length;
var idx = (0);
var ret = invoc_array;
while(true){
if((idx < l__4739__auto__)){
var G__39561 = (idx + (1));
var G__39562 = (function (){var idxs = (enclosed__GT_invocation[idx]);
var enclosed_idx = (idxs[(0)]);
var enclosed_val = (enclosed_array[enclosed_idx]);
var invoc_idx = (idxs[(1)]);
(ret[invoc_idx] = enclosed_val);

return ret;
})();
idx = G__39561;
ret = G__39562;
continue;
} else {
return ret;
}
break;
}
}):null);
return cljs.core.assoc.call(null,body__$2,new cljs.core.Keyword(null,"invoc-size","invoc-size",2053298058),invoc_size,new cljs.core.Keyword(null,"invocation-self-idx","invocation-self-idx",-1258983407),invocation_self_idx,new cljs.core.Keyword(null,"copy-enclosed->invocation","copy-enclosed->invocation",-1322388729),copy_enclosed__GT_invocation);
}),bodies__$1);
var arglists = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(analyzed_bodies);
var fn_meta = cljs.core.dissoc.call(null,cljs.core.meta.call(null,fn_expr),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"column","column",2078222095));
var ana_fn_meta = ((cljs.core.seq.call(null,fn_meta))?sci.impl.analyzer.analyze.call(null,ctx__$4,fn_meta):null);
var struct = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("sci.impl","fn-bodies","sci.impl/fn-bodies",134751661),bodies__$2,new cljs.core.Keyword("sci.impl","fn-name","sci.impl/fn-name",-1172300569),fn_name,new cljs.core.Keyword("sci.impl","self-ref?","sci.impl/self-ref?",-276538273),self_ref_QMARK_,new cljs.core.Keyword("sci.impl","arglists","sci.impl/arglists",-802264395),arglists,new cljs.core.Keyword("sci.impl","fn","sci.impl/fn",1695180073),true,new cljs.core.Keyword("sci.impl","fn-meta","sci.impl/fn-meta",1093684639),ana_fn_meta,new cljs.core.Keyword("sci.impl","bindings-fn","sci.impl/bindings-fn",-992456394),enclosed_array_fn], null);
return struct;
});
sci.impl.analyzer.fn_ctx_fn = (function sci$impl$analyzer$fn_ctx_fn(_ctx,struct,fn_meta){
var fn_name = new cljs.core.Keyword("sci.impl","fn-name","sci.impl/fn-name",-1172300569).cljs$core$IFn$_invoke$arity$1(struct);
var fn_bodies = new cljs.core.Keyword("sci.impl","fn-bodies","sci.impl/fn-bodies",134751661).cljs$core$IFn$_invoke$arity$1(struct);
var macro_QMARK_ = new cljs.core.Keyword("sci","macro","sci/macro",-868536151).cljs$core$IFn$_invoke$arity$1(struct);
var single_arity = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,fn_bodies)))?cljs.core.first.call(null,fn_bodies):null);
var bindings_fn = new cljs.core.Keyword("sci.impl","bindings-fn","sci.impl/bindings-fn",-992456394).cljs$core$IFn$_invoke$arity$1(struct);
var self_ref_QMARK_ = new cljs.core.Keyword("sci.impl","self-ref?","sci.impl/self-ref?",-276538273).cljs$core$IFn$_invoke$arity$1(struct);
if(cljs.core.truth_(fn_meta)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
var fn_meta__$1 = sci.impl.types.eval.call(null,fn_meta,ctx,bindings);
var f = sci.impl.fns.eval_fn.call(null,ctx,bindings,fn_name,fn_bodies,macro_QMARK_,single_arity,self_ref_QMARK_,bindings_fn);
return cljs.core.vary_meta.call(null,f,cljs.core.merge,fn_meta__$1);
}),null);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return sci.impl.fns.eval_fn.call(null,ctx,bindings,fn_name,fn_bodies,macro_QMARK_,single_arity,self_ref_QMARK_,bindings_fn);
}),null);
}
});
sci.impl.analyzer.analyze_fn = (function sci$impl$analyzer$analyze_fn(ctx,fn_expr,macro_QMARK_){
var struct = sci.impl.analyzer.analyze_fn_STAR_.call(null,ctx,fn_expr,macro_QMARK_);
var fn_meta = new cljs.core.Keyword("sci.impl","fn-meta","sci.impl/fn-meta",1093684639).cljs$core$IFn$_invoke$arity$1(struct);
return sci.impl.analyzer.fn_ctx_fn.call(null,ctx,struct,fn_meta);
});
/**
 * :syms = closed over values
 */
sci.impl.analyzer.update_parents = (function sci$impl$analyzer$update_parents(ctx,closure_bindings,ob){
var parents = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(ctx);
var new_cb = cljs.core._vreset_BANG_.call(null,closure_bindings,(function (cb){
return cljs.core.update_in.call(null,cb,cljs.core.conj.call(null,parents,new cljs.core.Keyword(null,"syms","syms",-1575891762)),(function (iden__GT_invoke_idx){
if(cljs.core.contains_QMARK_.call(null,iden__GT_invoke_idx,ob)){
return iden__GT_invoke_idx;
} else {
return cljs.core.assoc.call(null,iden__GT_invoke_idx,ob,cljs.core.count.call(null,iden__GT_invoke_idx));
}
}));
}).call(null,cljs.core._deref.call(null,closure_bindings)));
var closure_idx = cljs.core.get_in.call(null,new_cb,cljs.core.conj.call(null,parents,new cljs.core.Keyword(null,"syms","syms",-1575891762),ob));
return closure_idx;
});
sci.impl.analyzer.analyze_let_STAR_ = (function sci$impl$analyzer$analyze_let_STAR_(ctx,expr,destructured_let_bindings,exprs){
var rt = sci.impl.analyzer.recur_target.call(null,ctx);
var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
var vec__39563 = cljs.core.reduce.call(null,(function (p__39566,p__39567){
var vec__39568 = p__39566;
var ctx__$2 = cljs.core.nth.call(null,vec__39568,(0),null);
var new_let_bindings = cljs.core.nth.call(null,vec__39568,(1),null);
var idens = cljs.core.nth.call(null,vec__39568,(2),null);
var vec__39571 = p__39567;
var binding_name = cljs.core.nth.call(null,vec__39571,(0),null);
var binding_value = cljs.core.nth.call(null,vec__39571,(1),null);
var m = cljs.core.meta.call(null,binding_value);
var t = (cljs.core.truth_(m)?new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(m):null);
var binding_name__$1 = (cljs.core.truth_(t)?cljs.core.vary_meta.call(null,binding_name,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),t):binding_name);
var v = sci.impl.analyzer.analyze.call(null,ctx__$2,binding_value);
var new_iden = cljs.core.gensym.call(null);
var cb = new cljs.core.Keyword(null,"closure-bindings","closure-bindings",112932037).cljs$core$IFn$_invoke$arity$1(ctx__$2);
var idx = sci.impl.analyzer.update_parents.call(null,ctx__$2,cb,new_iden);
var iden__GT_invoke_idx = new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026).cljs$core$IFn$_invoke$arity$1(ctx__$2);
var iden__GT_invoke_idx__$1 = cljs.core.assoc.call(null,iden__GT_invoke_idx,new_iden,idx);
var ctx__$3 = cljs.core.assoc.call(null,ctx__$2,new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026),iden__GT_invoke_idx__$1);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update.call(null,ctx__$3,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.assoc,binding_name__$1,new_iden),cljs.core.conj.call(null,new_let_bindings,binding_name__$1,v),cljs.core.conj.call(null,idens,new_iden)], null);
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx__$1,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY], null),cljs.core.partition.call(null,(2),destructured_let_bindings));
var ctx__$2 = cljs.core.nth.call(null,vec__39563,(0),null);
var new_let_bindings = cljs.core.nth.call(null,vec__39563,(1),null);
var idens = cljs.core.nth.call(null,vec__39563,(2),null);
var body = sci.impl.analyzer.return_do.call(null,sci.impl.analyzer.with_recur_target.call(null,ctx__$2,rt),expr,exprs);
var iden__GT_invoke_idx = new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026).cljs$core$IFn$_invoke$arity$1(ctx__$2);
var idxs = cljs.core.mapv.call(null,iden__GT_invoke_idx,idens);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$3,bindings){
return sci.impl.evaluator.eval_let.call(null,ctx__$3,bindings,new_let_bindings,body,idxs);
}),null);
});
/**
 * The let macro from clojure.core
 */
sci.impl.analyzer.analyze_let = (function sci$impl$analyzer$analyze_let(ctx,p__39574){
var vec__39575 = p__39574;
var seq__39576 = cljs.core.seq.call(null,vec__39575);
var first__39577 = cljs.core.first.call(null,seq__39576);
var seq__39576__$1 = cljs.core.next.call(null,seq__39576);
var _let = first__39577;
var first__39577__$1 = cljs.core.first.call(null,seq__39576__$1);
var seq__39576__$2 = cljs.core.next.call(null,seq__39576__$1);
var let_bindings = first__39577__$1;
var exprs = seq__39576__$2;
var expr = vec__39575;
var let_bindings__$1 = sci.impl.destructure.destructure.call(null,let_bindings);
return sci.impl.analyzer.analyze_let_STAR_.call(null,ctx,expr,let_bindings__$1,exprs);
});
sci.impl.analyzer.init_var_BANG_ = (function sci$impl$analyzer$init_var_BANG_(ctx,name,expr){
var cnn_39579 = sci.impl.vars.current_ns_name.call(null);
var env_39580 = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var the_current_ns_39581 = cljs.core.get_in.call(null,cljs.core.deref.call(null,env_39580),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn_39579], null));
var refers_39582 = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns_39581);
var the_current_ns_39583__$1 = (function (){var temp__5802__auto__ = (function (){var and__4251__auto__ = refers_39582;
if(cljs.core.truth_(and__4251__auto__)){
return refers_39582.get(name);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var x = temp__5802__auto__;
return sci.impl.analyzer.throw_error_with_location.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)," already refers to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," in namespace ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnn_39579)].join(''),expr);
} else {
if(cljs.core.not.call(null,cljs.core.get.call(null,the_current_ns_39581,name))){
return cljs.core.assoc.call(null,the_current_ns_39581,name,(function (){var G__39578 = sci.impl.vars.__GT_SciVar.call(null,null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnn_39579),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)),cljs.core.assoc.call(null,cljs.core.meta.call(null,name),new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file)),false);
sci.impl.vars.unbind.call(null,G__39578);

return G__39578;
})());
} else {
return the_current_ns_39581;
}
}
})();
cljs.core.swap_BANG_.call(null,env_39580,(function (env__$1){
return cljs.core.update.call(null,env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.assoc,cnn_39579,the_current_ns_39583__$1);
}));

return null;
});
sci.impl.analyzer.analyze_def = (function sci$impl$analyzer$analyze_def(ctx,expr){
var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
var vec__39584 = expr;
var _def = cljs.core.nth.call(null,vec__39584,(0),null);
var var_name = cljs.core.nth.call(null,vec__39584,(1),null);
var _QMARK_docstring = cljs.core.nth.call(null,vec__39584,(2),null);
var _QMARK_init = cljs.core.nth.call(null,vec__39584,(3),null);
sci.impl.analyzer.init_var_BANG_.call(null,ctx__$1,var_name,expr);

if(cljs.core.simple_symbol_QMARK_.call(null,var_name)){
} else {
sci.impl.analyzer.throw_error_with_location.call(null,"Var name should be simple symbol.",expr);
}

var arg_count = cljs.core.count.call(null,expr);
var docstring = ((((cljs.core._EQ_.call(null,(4),arg_count)) && (typeof _QMARK_docstring === 'string')))?_QMARK_docstring:null);
var expected_arg_count = (cljs.core.truth_(docstring)?(4):(3));
if((arg_count <= expected_arg_count)){
} else {
throw (new Error("Too many arguments to def"));
}

var init = (cljs.core.truth_(docstring)?_QMARK_init:_QMARK_docstring);
var init__$1 = ((cljs.core._EQ_.call(null,(2),arg_count))?sci.impl.utils.var_unbound:sci.impl.analyzer.analyze.call(null,ctx__$1,init));
var m = cljs.core.meta.call(null,var_name);
var m_needs_eval_QMARK_ = m;
var m__$1 = cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns));
var m__$2 = (cljs.core.truth_(docstring)?cljs.core.assoc.call(null,m__$1,new cljs.core.Keyword(null,"doc","doc",1913296891),docstring):m__$1);
var m__$3 = (cljs.core.truth_(m_needs_eval_QMARK_)?sci.impl.analyzer.analyze.call(null,ctx__$1,m__$2):sci.impl.types.__GT_constant.call(null,m__$2));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.evaluator.eval_def.call(null,ctx__$2,bindings,var_name,init__$1,m__$3);
}),null);
});
sci.impl.analyzer.analyze_defn = (function sci$impl$analyzer$analyze_defn(ctx,p__39587){
var vec__39588 = p__39587;
var seq__39589 = cljs.core.seq.call(null,vec__39588);
var first__39590 = cljs.core.first.call(null,seq__39589);
var seq__39589__$1 = cljs.core.next.call(null,seq__39589);
var op = first__39590;
var first__39590__$1 = cljs.core.first.call(null,seq__39589__$1);
var seq__39589__$2 = cljs.core.next.call(null,seq__39589__$1);
var fn_name = first__39590__$1;
var body = seq__39589__$2;
var expr = vec__39588;
if(cljs.core.simple_symbol_QMARK_.call(null,fn_name)){
} else {
sci.impl.analyzer.throw_error_with_location.call(null,"Var name should be simple symbol.",expr);
}

sci.impl.analyzer.init_var_BANG_.call(null,ctx,fn_name,expr);

var macro_QMARK_ = cljs.core._EQ_.call(null,"defmacro",cljs.core.name.call(null,op));
var vec__39591 = cljs.core.split_with.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.sequential_QMARK_),body);
var pre_body = cljs.core.nth.call(null,vec__39591,(0),null);
var body__$1 = cljs.core.nth.call(null,vec__39591,(1),null);
var _ = ((cljs.core.empty_QMARK_.call(null,body__$1))?sci.impl.analyzer.throw_error_with_location.call(null,"Parameter declaration missing.",expr):null);
var docstring = (function (){var temp__5804__auto__ = cljs.core.first.call(null,pre_body);
if(cljs.core.truth_(temp__5804__auto__)){
var ds = temp__5804__auto__;
if(typeof ds === 'string'){
return ds;
} else {
return null;
}
} else {
return null;
}
})();
var meta_map = (function (){var temp__5804__auto__ = cljs.core.last.call(null,pre_body);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
if(cljs.core.map_QMARK_.call(null,m)){
return m;
} else {
return null;
}
} else {
return null;
}
})();
var vec__39594 = ((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,body__$1)))?(function (){var lb = cljs.core.last.call(null,body__$1);
if(cljs.core.map_QMARK_.call(null,lb)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lb,cljs.core.butlast.call(null,body__$1)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,body__$1], null);
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,body__$1], null));
var meta_map2 = cljs.core.nth.call(null,vec__39594,(0),null);
var body__$2 = cljs.core.nth.call(null,vec__39594,(1),null);
var meta_map__$1 = cljs.core.merge.call(null,cljs.core.meta.call(null,fn_name),cljs.core.meta.call(null,expr),meta_map);
var meta_map__$2 = (cljs.core.truth_(meta_map2)?cljs.core.merge.call(null,meta_map__$1,meta_map2):meta_map__$1);
var fn_body = cljs.core.with_meta.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"fn","fn",465265323,null),body__$2),cljs.core.meta.call(null,expr));
var f = sci.impl.analyzer.analyze_fn_STAR_.call(null,ctx,fn_body,macro_QMARK_);
var arglists = (new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),(new cljs.core.List(null,cljs.core.seq.call(null,new cljs.core.Keyword("sci.impl","arglists","sci.impl/arglists",-802264395).cljs$core$IFn$_invoke$arity$1(f)),null,(1),null)),(2),null));
var meta_map__$3 = cljs.core.assoc.call(null,meta_map__$2,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists);
var meta_map__$4 = (function (){var G__39597 = meta_map__$3;
var G__39597__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.call(null,G__39597,new cljs.core.Keyword(null,"doc","doc",1913296891),docstring):G__39597);
if(macro_QMARK_){
return cljs.core.assoc.call(null,G__39597__$1,new cljs.core.Keyword(null,"macro","macro",-867863404),true);
} else {
return G__39597__$1;
}
})();
var f__$1 = cljs.core.assoc.call(null,f,new cljs.core.Keyword("sci","macro","sci/macro",-868536151),macro_QMARK_,new cljs.core.Keyword("sci.impl","fn-name","sci.impl/fn-name",-1172300569),fn_name,new cljs.core.Keyword("sci.impl","defn","sci.impl/defn",1087257818),true);
var fn_meta = new cljs.core.Keyword("sci.impl","fn-meta","sci.impl/fn-meta",1093684639).cljs$core$IFn$_invoke$arity$1(f__$1);
var ctxfn = sci.impl.analyzer.fn_ctx_fn.call(null,ctx,f__$1,fn_meta);
var f__$2 = ctxfn;
var meta_map__$5 = sci.impl.analyzer.analyze.call(null,ctx,meta_map__$4);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return sci.impl.evaluator.eval_def.call(null,ctx__$1,bindings,fn_name,f__$2,meta_map__$5);
}),null);
});
sci.impl.analyzer.analyze_loop = (function sci$impl$analyzer$analyze_loop(ctx,expr){
var bv = cljs.core.second.call(null,expr);
var arg_names = cljs.core.take_nth.call(null,(2),bv);
var init_vals = cljs.core.take_nth.call(null,(2),cljs.core.rest.call(null,bv));
var vec__39598 = ((cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,arg_names))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bv,arg_names], null):(function (){var syms = cljs.core.repeatedly.call(null,cljs.core.count.call(null,arg_names),cljs.core.gensym);
var bv1 = cljs.core.map.call(null,cljs.core.vector,syms,init_vals);
var bv2 = cljs.core.map.call(null,cljs.core.vector,arg_names,syms);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.cat,cljs.core.interleave.call(null,bv1,bv2)),syms], null);
})());
var bv__$1 = cljs.core.nth.call(null,vec__39598,(0),null);
var syms = cljs.core.nth.call(null,vec__39598,(1),null);
var body = cljs.core.nnext.call(null,expr);
var expansion = (new cljs.core.List(null,new cljs.core.Symbol("clojure.core","let","clojure.core/let",-407137853,null),(new cljs.core.List(null,bv__$1,(new cljs.core.List(null,cljs.core.list_STAR_.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,arg_names),null,(1),null)),body))),syms),null,(1),null)),(2),null)),(3),null));
return sci.impl.analyzer.analyze.call(null,ctx,expansion);
});
sci.impl.analyzer.analyze_lazy_seq = (function sci$impl$analyzer$analyze_lazy_seq(ctx,expr){
var body = cljs.core.rest.call(null,expr);
var ctx__$1 = sci.impl.analyzer.with_recur_target.call(null,ctx,true);
var ana = sci.impl.analyzer.return_do.call(null,ctx__$1,expr,body);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return (new cljs.core.LazySeq(null,(function (){
return sci.impl.types.eval.call(null,ana,ctx__$2,bindings);
}),null,null));
}),null);
});
sci.impl.analyzer.return_if = (function sci$impl$analyzer$return_if(ctx,expr){
var exprs = cljs.core.rest.call(null,expr);
var children = sci.impl.analyzer.analyze_children.call(null,ctx,exprs);
var stack = cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword(null,"special","special",-1125941630),true);
var G__39601 = cljs.core.count.call(null,children);
switch (G__39601) {
case (0):
case (1):
return sci.impl.analyzer.throw_error_with_location.call(null,"Too few arguments to if",expr);

break;
case (2):
var condition = cljs.core.nth.call(null,children,(0));
var then = cljs.core.nth.call(null,children,(1));
if(cljs.core.not.call(null,condition)){
return null;
} else {
if(sci.impl.utils.constant_QMARK_.call(null,condition)){
return then;
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
if(cljs.core.truth_(sci.impl.types.eval.call(null,condition,ctx__$1,bindings))){
return sci.impl.types.eval.call(null,then,ctx__$1,bindings);
} else {
return null;
}
}),stack);

}
}

break;
case (3):
var condition = cljs.core.nth.call(null,children,(0));
var then = cljs.core.nth.call(null,children,(1));
var else$ = cljs.core.nth.call(null,children,(2));
if(cljs.core.not.call(null,condition)){
return else$;
} else {
if(sci.impl.utils.constant_QMARK_.call(null,condition)){
return then;
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
if(cljs.core.truth_(sci.impl.types.eval.call(null,condition,ctx__$1,bindings))){
return sci.impl.types.eval.call(null,then,ctx__$1,bindings);
} else {
return sci.impl.types.eval.call(null,else$,ctx__$1,bindings);
}
}),stack);

}
}

break;
default:
return sci.impl.analyzer.throw_error_with_location.call(null,"Too many arguments to if",expr);

}
});
sci.impl.analyzer.analyze_case = (function sci$impl$analyzer$analyze_case(ctx,expr){
var ctx_wo_rt = sci.impl.analyzer.without_recur_target.call(null,ctx);
var case_val = sci.impl.analyzer.analyze.call(null,ctx_wo_rt,cljs.core.second.call(null,expr));
var clauses = cljs.core.nnext.call(null,expr);
var match_clauses = cljs.core.take_nth.call(null,(2),clauses);
var result_clauses = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.take_nth.call(null,(2),cljs.core.rest.call(null,clauses)));
var vec__39603 = ((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,clauses)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,sci.impl.analyzer.analyze.call(null,ctx,cljs.core.last.call(null,clauses))], null):null);
var default_QMARK_ = cljs.core.nth.call(null,vec__39603,(0),null);
var case_default = cljs.core.nth.call(null,vec__39603,(1),null);
var cases = cljs.core.interleave.call(null,match_clauses,result_clauses);
var assoc_new = (function (m,k,v){
if((!(cljs.core.contains_QMARK_.call(null,m,k)))){
return cljs.core.assoc.call(null,m,k,v);
} else {
return sci.impl.analyzer.throw_error_with_location.call(null,["Duplicate case test constant ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),expr);
}
});
var case_map = (function (){var cases__$1 = cljs.core.seq.call(null,cases);
var ret_map = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(cases__$1){
var vec__39609 = cases__$1;
var seq__39610 = cljs.core.seq.call(null,vec__39609);
var first__39611 = cljs.core.first.call(null,seq__39610);
var seq__39610__$1 = cljs.core.next.call(null,seq__39610);
var k = first__39611;
var first__39611__$1 = cljs.core.first.call(null,seq__39610__$1);
var seq__39610__$2 = cljs.core.next.call(null,seq__39610__$1);
var v = first__39611__$1;
var cases__$2 = seq__39610__$2;
if(cljs.core.seq_QMARK_.call(null,k)){
var G__39612 = cases__$2;
var G__39613 = cljs.core.reduce.call(null,((function (cases__$1,ret_map,vec__39609,seq__39610,first__39611,seq__39610__$1,k,first__39611__$1,seq__39610__$2,v,cases__$2,ctx_wo_rt,case_val,clauses,match_clauses,result_clauses,vec__39603,default_QMARK_,case_default,cases,assoc_new){
return (function (acc,k__$1){
return assoc_new.call(null,acc,k__$1,v);
});})(cases__$1,ret_map,vec__39609,seq__39610,first__39611,seq__39610__$1,k,first__39611__$1,seq__39610__$2,v,cases__$2,ctx_wo_rt,case_val,clauses,match_clauses,result_clauses,vec__39603,default_QMARK_,case_default,cases,assoc_new))
,ret_map,k);
cases__$1 = G__39612;
ret_map = G__39613;
continue;
} else {
var G__39614 = cases__$2;
var G__39615 = assoc_new.call(null,ret_map,k,v);
cases__$1 = G__39614;
ret_map = G__39615;
continue;
}
} else {
return ret_map;
}
break;
}
})();
var f = (cljs.core.truth_(default_QMARK_)?sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return sci.impl.evaluator.eval_case.call(null,ctx__$1,bindings,case_map,case_val,case_default);
}),null):sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return sci.impl.evaluator.eval_case.call(null,ctx__$1,bindings,case_map,case_val);
}),null));
return f;
});
sci.impl.analyzer.analyze_try = (function sci$impl$analyzer$analyze_try(ctx,expr){
var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
var body = cljs.core.next.call(null,expr);
var vec__39616 = (function (){var exprs = body;
var body_exprs = cljs.core.PersistentVector.EMPTY;
var catch_exprs = cljs.core.PersistentVector.EMPTY;
var finally_expr = null;
while(true){
if(exprs){
var expr__$1 = cljs.core.first.call(null,exprs);
var exprs__$1 = cljs.core.next.call(null,exprs);
if(((cljs.core.seq_QMARK_.call(null,expr__$1)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),cljs.core.first.call(null,expr__$1))))){
var G__39623 = exprs__$1;
var G__39624 = body_exprs;
var G__39625 = cljs.core.conj.call(null,catch_exprs,expr__$1);
var G__39626 = finally_expr;
exprs = G__39623;
body_exprs = G__39624;
catch_exprs = G__39625;
finally_expr = G__39626;
continue;
} else {
if(((cljs.core.not.call(null,exprs__$1)) && (((cljs.core.seq_QMARK_.call(null,expr__$1)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"finally","finally",-1065347064,null),cljs.core.first.call(null,expr__$1))))))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [body_exprs,catch_exprs,expr__$1], null);
} else {
var G__39627 = exprs__$1;
var G__39628 = cljs.core.conj.call(null,body_exprs,expr__$1);
var G__39629 = catch_exprs;
var G__39630 = finally_expr;
exprs = G__39627;
body_exprs = G__39628;
catch_exprs = G__39629;
finally_expr = G__39630;
continue;

}
}
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [body_exprs,catch_exprs,finally_expr], null);
}
break;
}
})();
var body_exprs = cljs.core.nth.call(null,vec__39616,(0),null);
var catches = cljs.core.nth.call(null,vec__39616,(1),null);
var finally$ = cljs.core.nth.call(null,vec__39616,(2),null);
var body__$1 = sci.impl.analyzer.analyze.call(null,ctx__$1,cljs.core.cons.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),body_exprs));
var catches__$1 = cljs.core.mapv.call(null,(function (c){
var vec__39619 = c;
var seq__39620 = cljs.core.seq.call(null,vec__39619);
var first__39621 = cljs.core.first.call(null,seq__39620);
var seq__39620__$1 = cljs.core.next.call(null,seq__39620);
var _ = first__39621;
var first__39621__$1 = cljs.core.first.call(null,seq__39620__$1);
var seq__39620__$2 = cljs.core.next.call(null,seq__39620__$1);
var ex = first__39621__$1;
var first__39621__$2 = cljs.core.first.call(null,seq__39620__$2);
var seq__39620__$3 = cljs.core.next.call(null,seq__39620__$2);
var binding = first__39621__$2;
var body__$2 = seq__39620__$3;
var temp__5802__auto__ = (function (){var G__39622 = ex;
if(cljs.core._EQ_.call(null,new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),G__39622)){
return Error;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol("js","Object","js/Object",61215323,null),G__39622)){
return Object;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"default","default",-1987822328),G__39622)){
return new cljs.core.Keyword(null,"default","default",-1987822328);
} else {
return sci.impl.analyzer.analyze.call(null,ctx__$1,ex);

}
}
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var clazz = temp__5802__auto__;
var ex_iden = cljs.core.gensym.call(null);
var closure_bindings = new cljs.core.Keyword(null,"closure-bindings","closure-bindings",112932037).cljs$core$IFn$_invoke$arity$1(ctx__$1);
var ex_idx = sci.impl.analyzer.update_parents.call(null,ctx__$1,closure_bindings,ex_iden);
var ctx__$2 = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,ctx__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bindings","bindings",1271397192),binding], null),ex_iden),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"iden->invoke-idx","iden->invoke-idx",-1797627026),ex_iden], null),ex_idx);
var analyzed_body = sci.impl.analyzer.analyze.call(null,ctx__$2,cljs.core.cons.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),body__$2));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),clazz,new cljs.core.Keyword(null,"ex-idx","ex-idx",795118805),ex_idx,new cljs.core.Keyword(null,"body","body",-2049205669),analyzed_body], null);
} else {
return sci.impl.analyzer.throw_error_with_location.call(null,["Unable to resolve classname: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join(''),ex);
}
}),catches);
var finally$__$1 = (cljs.core.truth_(finally$)?sci.impl.analyzer.analyze.call(null,ctx__$1,cljs.core.cons.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.rest.call(null,finally$))):null);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.evaluator.eval_try.call(null,ctx__$2,bindings,body__$1,catches__$1,finally$__$1);
}),null);
});
sci.impl.analyzer.analyze_throw = (function sci$impl$analyzer$analyze_throw(ctx,p__39631){
var vec__39632 = p__39631;
var _throw = cljs.core.nth.call(null,vec__39632,(0),null);
var ex = cljs.core.nth.call(null,vec__39632,(1),null);
var expr = vec__39632;
if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,expr))){
} else {
sci.impl.analyzer.throw_error_with_location.call(null,"Too many arguments to throw",expr);
}

var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
var ana = sci.impl.analyzer.analyze.call(null,ctx__$1,ex);
var stack = cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword(null,"special","special",-1125941630),true);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx__$2,bindings,sci.impl.types.eval.call(null,ana,ctx__$2,bindings),this$);
}),stack);
});
sci.impl.analyzer.analyze_dot = (function sci$impl$analyzer$analyze_dot(ctx,p__39635){
var vec__39636 = p__39635;
var seq__39637 = cljs.core.seq.call(null,vec__39636);
var first__39638 = cljs.core.first.call(null,seq__39637);
var seq__39637__$1 = cljs.core.next.call(null,seq__39637);
var _dot = first__39638;
var first__39638__$1 = cljs.core.first.call(null,seq__39637__$1);
var seq__39637__$2 = cljs.core.next.call(null,seq__39637__$1);
var instance_expr = first__39638__$1;
var first__39638__$2 = cljs.core.first.call(null,seq__39637__$2);
var seq__39637__$3 = cljs.core.next.call(null,seq__39637__$2);
var method_expr = first__39638__$2;
var args = seq__39637__$3;
var expr = vec__39636;
var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
var vec__39639 = ((cljs.core.seq_QMARK_.call(null,method_expr))?method_expr:cljs.core.cons.call(null,method_expr,args));
var seq__39640 = cljs.core.seq.call(null,vec__39639);
var first__39641 = cljs.core.first.call(null,seq__39640);
var seq__39640__$1 = cljs.core.next.call(null,seq__39640);
var method_expr__$1 = first__39641;
var args__$1 = seq__39640__$1;
var instance_expr__$1 = sci.impl.analyzer.analyze.call(null,ctx__$1,instance_expr);
var method_name = cljs.core.name.call(null,method_expr__$1);
var args__$2 = ((args__$1)?sci.impl.analyzer.analyze_children.call(null,ctx__$1,args__$1):null);
var res = (function (){var field_access = clojure.string.starts_with_QMARK_.call(null,method_name,"-");
var meth_name = ((field_access)?cljs.core.subs.call(null,method_name,(1)):method_name);
var stack = cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file));
var allowed_QMARK_ = (method_expr__$1 === sci.impl.utils.allowed_append);
return cljs.core.with_meta.call(null,sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.evaluator.eval_instance_method_invocation.call(null,ctx__$2,bindings,instance_expr__$1,meth_name,field_access,args__$2,allowed_QMARK_);
}),stack),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("sci.impl.analyzer","instance-expr","sci.impl.analyzer/instance-expr",629338719),instance_expr__$1,new cljs.core.Keyword("sci.impl.analyzer","method-name","sci.impl.analyzer/method-name",-842600667),method_name], null));
})();
return res;
});
/**
 * Expands (. x method)
 */
sci.impl.analyzer.expand_dot_STAR__STAR_ = (function sci$impl$analyzer$expand_dot_STAR__STAR_(ctx,expr){
if((cljs.core.count.call(null,expr) < (3))){
throw (new Error("Malformed member expression, expecting (.member target ...)"));
} else {
}

return sci.impl.analyzer.analyze_dot.call(null,ctx,expr);
});
/**
 * Expands (.foo x)
 */
sci.impl.analyzer.expand_dot_STAR_ = (function sci$impl$analyzer$expand_dot_STAR_(ctx,p__39642){
var vec__39643 = p__39642;
var seq__39644 = cljs.core.seq.call(null,vec__39643);
var first__39645 = cljs.core.first.call(null,seq__39644);
var seq__39644__$1 = cljs.core.next.call(null,seq__39644);
var method_name = first__39645;
var first__39645__$1 = cljs.core.first.call(null,seq__39644__$1);
var seq__39644__$2 = cljs.core.next.call(null,seq__39644__$1);
var obj = first__39645__$1;
var args = seq__39644__$2;
var expr = vec__39643;
if((cljs.core.count.call(null,expr) < (2))){
throw (new Error("Malformed member expression, expecting (.member target ...)"));
} else {
}

return sci.impl.analyzer.analyze_dot.call(null,ctx,(new cljs.core.List(null,new cljs.core.Symbol(null,".",".",1975675962,null),(new cljs.core.List(null,obj,(new cljs.core.List(null,cljs.core.cons.call(null,cljs.core.symbol.call(null,cljs.core.subs.call(null,cljs.core.name.call(null,method_name),(1))),args),null,(1),null)),(2),null)),(3),null)));
});
sci.impl.analyzer.analyze_new = (function sci$impl$analyzer$analyze_new(ctx,p__39651){
var vec__39652 = p__39651;
var seq__39653 = cljs.core.seq.call(null,vec__39652);
var first__39654 = cljs.core.first.call(null,seq__39653);
var seq__39653__$1 = cljs.core.next.call(null,seq__39653);
var _new = first__39654;
var first__39654__$1 = cljs.core.first.call(null,seq__39653__$1);
var seq__39653__$2 = cljs.core.next.call(null,seq__39653__$1);
var class_sym = first__39654__$1;
var args = seq__39653__$2;
var expr = vec__39652;
var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
if((class_sym instanceof cljs.core.Symbol)){
var temp__5802__auto__ = (function (){var or__4253__auto__ = (function (){var temp__5804__auto__ = (function (){var temp__5804__auto__ = sci.impl.interop.resolve_class_opts.call(null,ctx__$1,class_sym);
if(cljs.core.truth_(temp__5804__auto__)){
var opts = temp__5804__auto__;
var or__4253__auto__ = new cljs.core.Keyword(null,"constructor","constructor",-1953928811).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(opts);
}
} else {
return null;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var clazz = temp__5804__auto__;
return clazz;
} else {
return null;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return sci.impl.resolve.resolve_symbol.call(null,ctx__$1,class_sym,false);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var class$ = temp__5802__auto__;
var args__$1 = sci.impl.analyzer.analyze_children.call(null,ctx__$1,args);
var var_QMARK_ = sci.impl.vars.var_QMARK_.call(null,class$);
var maybe_var = ((var_QMARK_)?class$:null);
var maybe_record = ((var_QMARK_)?cljs.core.deref.call(null,maybe_var):(((class$ instanceof cljs.core.Symbol))?class$:null));
var maybe_record_constructor = (cljs.core.truth_(maybe_record)?new cljs.core.Keyword("sci.impl.record","constructor","sci.impl.record/constructor",-2025684209).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,maybe_record)):null);
if(cljs.core.truth_(maybe_record_constructor)){
return sci.impl.analyzer.return_call.call(null,ctx__$1,expr,maybe_record_constructor,args__$1,cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file)),null);
} else {
if(var_QMARK_){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.interop.invoke_constructor.call(null,cljs.core.deref.call(null,maybe_var),cljs.core.mapv.call(null,(function (p1__39647_SHARP_){
return sci.impl.types.eval.call(null,p1__39647_SHARP_,ctx__$2,bindings);
}),args__$1));
}),null);
} else {
if((class$ instanceof sci.impl.types.NodeR)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.interop.invoke_constructor.call(null,sci.impl.types.eval.call(null,class$,ctx__$2,bindings),cljs.core.mapv.call(null,(function (p1__39648_SHARP_){
return sci.impl.types.eval.call(null,p1__39648_SHARP_,ctx__$2,bindings);
}),args__$1));
}),null);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.interop.invoke_constructor.call(null,class$,cljs.core.mapv.call(null,(function (p1__39649_SHARP_){
return sci.impl.types.eval.call(null,p1__39649_SHARP_,ctx__$2,bindings);
}),args__$1));
}),null);

}
}
}
} else {
var temp__5802__auto____$1 = sci.impl.records.resolve_record_class.call(null,ctx__$1,class_sym);
if(cljs.core.truth_(temp__5802__auto____$1)){
var record = temp__5802__auto____$1;
var args__$1 = sci.impl.analyzer.analyze_children.call(null,ctx__$1,args);
return sci.impl.analyzer.return_call.call(null,ctx__$1,expr,new cljs.core.Keyword("sci.impl.record","constructor","sci.impl.record/constructor",-2025684209).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,record)),args__$1,cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file)),null);
} else {
return sci.impl.analyzer.throw_error_with_location.call(null,["Unable to resolve classname: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_sym)].join(''),class_sym);
}
}
} else {
var class$ = sci.impl.analyzer.analyze.call(null,ctx__$1,class_sym);
var args__$1 = sci.impl.analyzer.analyze_children.call(null,ctx__$1,args);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
return sci.impl.interop.invoke_constructor.call(null,sci.impl.types.eval.call(null,class$,ctx__$2,bindings),cljs.core.mapv.call(null,(function (p1__39650_SHARP_){
return sci.impl.types.eval.call(null,p1__39650_SHARP_,ctx__$2,bindings);
}),args__$1));
}),null);
}
});
sci.impl.analyzer.expand_constructor = (function sci$impl$analyzer$expand_constructor(ctx,p__39655){
var vec__39656 = p__39655;
var seq__39657 = cljs.core.seq.call(null,vec__39656);
var first__39658 = cljs.core.first.call(null,seq__39657);
var seq__39657__$1 = cljs.core.next.call(null,seq__39657);
var constructor_sym = first__39658;
var args = seq__39657__$1;
var constructor_name = cljs.core.name.call(null,constructor_sym);
var class_sym = cljs.core.with_meta.call(null,cljs.core.symbol.call(null,cljs.core.subs.call(null,constructor_name,(0),(((constructor_name).length) - (1)))),cljs.core.meta.call(null,constructor_sym));
return sci.impl.analyzer.analyze_new.call(null,ctx,cljs.core.with_meta.call(null,cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"new","new",-444906321,null),class_sym,args),cljs.core.meta.call(null,constructor_sym)));
});
sci.impl.analyzer.return_ns_op = (function sci$impl$analyzer$return_ns_op(_ctx,f,expr,analyzed_args){
var stack = cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return cljs.core.apply.call(null,f,ctx,analyzed_args);
}catch (e39659){if((e39659 instanceof Error)){
var e = e39659;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e,this$);
} else {
throw e39659;

}
}}),stack);
});
sci.impl.analyzer.analyze_ns_form = (function sci$impl$analyzer$analyze_ns_form(ctx,p__39660){
var vec__39661 = p__39660;
var seq__39662 = cljs.core.seq.call(null,vec__39661);
var first__39663 = cljs.core.first.call(null,seq__39662);
var seq__39662__$1 = cljs.core.next.call(null,seq__39662);
var _ns = first__39663;
var first__39663__$1 = cljs.core.first.call(null,seq__39662__$1);
var seq__39662__$2 = cljs.core.next.call(null,seq__39662__$1);
var ns_name = first__39663__$1;
var exprs = seq__39662__$2;
var expr = vec__39661;
if((ns_name instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Namespace name must be symbol, got: ",cljs.core.pr_str.call(null,ns_name)].join('')));
}

var vec__39664 = (function (){var fexpr = cljs.core.first.call(null,exprs);
if(typeof fexpr === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fexpr,cljs.core.next.call(null,exprs)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,exprs], null);
}
})();
var docstring = cljs.core.nth.call(null,vec__39664,(0),null);
var exprs__$1 = cljs.core.nth.call(null,vec__39664,(1),null);
var vec__39667 = (function (){var m = cljs.core.first.call(null,exprs__$1);
if(cljs.core.map_QMARK_.call(null,m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [m,cljs.core.next.call(null,exprs__$1)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,exprs__$1], null);
}
})();
var attr_map = cljs.core.nth.call(null,vec__39667,(0),null);
var exprs__$2 = cljs.core.nth.call(null,vec__39667,(1),null);
var attr_map__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.call(null,attr_map,new cljs.core.Keyword(null,"doc","doc",1913296891),docstring):attr_map);
sci.impl.utils.set_namespace_BANG_.call(null,ctx,ns_name,attr_map__$1);

var exprs__$3 = exprs__$2;
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if(cljs.core.truth_(exprs__$3)){
var vec__39675 = cljs.core.first.call(null,exprs__$3);
var seq__39676 = cljs.core.seq.call(null,vec__39675);
var first__39677 = cljs.core.first.call(null,seq__39676);
var seq__39676__$1 = cljs.core.next.call(null,seq__39676);
var k = first__39677;
var args = seq__39676__$1;
var expr__$1 = vec__39675;
var G__39678 = k;
var G__39678__$1 = (((G__39678 instanceof cljs.core.Keyword))?G__39678.fqn:null);
switch (G__39678__$1) {
case "require":
case "use":
case "import":
case "refer-clojure":
var G__39681 = cljs.core.next.call(null,exprs__$3);
var G__39682 = cljs.core.conj.call(null,ret,sci.impl.analyzer.return_ns_op.call(null,ctx,(function (){var G__39679 = k;
var G__39679__$1 = (((G__39679 instanceof cljs.core.Keyword))?G__39679.fqn:null);
switch (G__39679__$1) {
case "require":
return sci.impl.load.eval_require;

break;
case "use":
return sci.impl.load.eval_use;

break;
case "import":
return sci.impl.evaluator.eval_import;

break;
case "refer-clojure":
return ((function (exprs__$3,ret,G__39679,G__39679__$1,G__39678,G__39678__$1,vec__39675,seq__39676,first__39677,seq__39676__$1,k,args,expr__$1,vec__39664,docstring,exprs__$1,vec__39667,attr_map,exprs__$2,attr_map__$1,vec__39661,seq__39662,first__39663,seq__39662__$1,_ns,first__39663__$1,seq__39662__$2,ns_name,exprs,expr){
return (function() { 
var G__39684__delegate = function (ctx__$1,args__$1){
return cljs.core.apply.call(null,sci.impl.load.eval_refer,ctx__$1,new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null),args__$1);
};
var G__39684 = function (ctx__$1,var_args){
var args__$1 = null;
if (arguments.length > 1) {
var G__39685__i = 0, G__39685__a = new Array(arguments.length -  1);
while (G__39685__i < G__39685__a.length) {G__39685__a[G__39685__i] = arguments[G__39685__i + 1]; ++G__39685__i;}
  args__$1 = new cljs.core.IndexedSeq(G__39685__a,0,null);
} 
return G__39684__delegate.call(this,ctx__$1,args__$1);};
G__39684.cljs$lang$maxFixedArity = 1;
G__39684.cljs$lang$applyTo = (function (arglist__39686){
var ctx__$1 = cljs.core.first(arglist__39686);
var args__$1 = cljs.core.rest(arglist__39686);
return G__39684__delegate(ctx__$1,args__$1);
});
G__39684.cljs$core$IFn$_invoke$arity$variadic = G__39684__delegate;
return G__39684;
})()
;
;})(exprs__$3,ret,G__39679,G__39679__$1,G__39678,G__39678__$1,vec__39675,seq__39676,first__39677,seq__39676__$1,k,args,expr__$1,vec__39664,docstring,exprs__$1,vec__39667,attr_map,exprs__$2,attr_map__$1,vec__39661,seq__39662,first__39663,seq__39662__$1,_ns,first__39663__$1,seq__39662__$2,ns_name,exprs,expr))

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39679__$1)].join('')));

}
})(),expr__$1,args));
exprs__$3 = G__39681;
ret = G__39682;
continue;

break;
case "gen-class":
var G__39687 = cljs.core.next.call(null,exprs__$3);
var G__39688 = ret;
exprs__$3 = G__39687;
ret = G__39688;
continue;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39678__$1)].join('')));

}
} else {
return sci.impl.analyzer.return_do.call(null,ctx,expr,cljs.core.conj.call(null,ret,sci.impl.types.__GT_NodeR.call(null,((function (exprs__$3,ret,vec__39664,docstring,exprs__$1,vec__39667,attr_map,exprs__$2,attr_map__$1,vec__39661,seq__39662,first__39663,seq__39662__$1,_ns,first__39663__$1,seq__39662__$2,ns_name,exprs,expr){
return (function (this$,ctx__$1,bindings){
sci.impl.load.add_loaded_lib.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx__$1),ns_name);

return null;
});})(exprs__$3,ret,vec__39664,docstring,exprs__$1,vec__39667,attr_map,exprs__$2,attr_map__$1,vec__39661,seq__39662,first__39663,seq__39662__$1,_ns,first__39663__$1,seq__39662__$2,ns_name,exprs,expr))
,null)));
}
break;
}
});
sci.impl.analyzer.analyze_var = (function sci$impl$analyzer$analyze_var(ctx,p__39689){
var vec__39690 = p__39689;
var _ = cljs.core.nth.call(null,vec__39690,(0),null);
var var_name = cljs.core.nth.call(null,vec__39690,(1),null);
return sci.impl.resolve.resolve_symbol.call(null,ctx,var_name);
});
sci.impl.analyzer.analyze_set_BANG_ = (function sci$impl$analyzer$analyze_set_BANG_(ctx,p__39693){
var vec__39694 = p__39693;
var _ = cljs.core.nth.call(null,vec__39694,(0),null);
var obj = cljs.core.nth.call(null,vec__39694,(1),null);
var v = cljs.core.nth.call(null,vec__39694,(2),null);
var expr = vec__39694;
if((obj instanceof cljs.core.Symbol)){
var obj__$1 = sci.impl.resolve.resolve_symbol.call(null,ctx,obj);
var ___$1 = ((sci.impl.vars.var_QMARK_.call(null,obj__$1))?null:sci.impl.analyzer.throw_error_with_location.call(null,"Invalid assignment target",expr));
var v__$1 = sci.impl.analyzer.analyze.call(null,ctx,v);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var v__$2 = sci.impl.types.eval.call(null,v__$1,ctx__$1,bindings);
return sci.impl.types.setVal.call(null,obj__$1,v__$2);
}),null);
} else {
if(cljs.core.seq_QMARK_.call(null,obj)){
var obj__$1 = sci.impl.analyzer.analyze.call(null,ctx,obj);
var v__$1 = sci.impl.analyzer.analyze.call(null,ctx,v);
var info = cljs.core.meta.call(null,obj__$1);
var k = cljs.core.subs.call(null,new cljs.core.Keyword("sci.impl.analyzer","method-name","sci.impl.analyzer/method-name",-842600667).cljs$core$IFn$_invoke$arity$1(info),(1));
var obj__$2 = new cljs.core.Keyword("sci.impl.analyzer","instance-expr","sci.impl.analyzer/instance-expr",629338719).cljs$core$IFn$_invoke$arity$1(info);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var obj__$3 = sci.impl.types.eval.call(null,obj__$2,ctx__$1,bindings);
var v__$2 = sci.impl.types.eval.call(null,v__$1,ctx__$1,bindings);
return sci.impl.analyzer.goog$module$goog$object.set.call(null,obj__$3,k,v__$2);
}),null);
} else {
return sci.impl.analyzer.throw_error_with_location.call(null,"Invalid assignment target",expr);

}
}
});
sci.impl.analyzer.return_binding_call = (function sci$impl$analyzer$return_binding_call(_ctx,expr,idx,f,analyzed_children,stack){
var G__39698 = cljs.core.count.call(null,analyzed_children);
switch (G__39698) {
case (0):
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null);
}catch (e39699){if((e39699 instanceof Error)){
var e__39208__auto__ = e39699;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39699;

}
}}),stack);

break;
case (1):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings));
}catch (e39700){if((e39700 instanceof Error)){
var e__39208__auto__ = e39700;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39700;

}
}}),stack);

break;
case (2):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings));
}catch (e39701){if((e39701 instanceof Error)){
var e__39208__auto__ = e39701;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39701;

}
}}),stack);

break;
case (3):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings));
}catch (e39702){if((e39702 instanceof Error)){
var e__39208__auto__ = e39702;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39702;

}
}}),stack);

break;
case (4):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings));
}catch (e39703){if((e39703 instanceof Error)){
var e__39208__auto__ = e39703;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39703;

}
}}),stack);

break;
case (5):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings));
}catch (e39704){if((e39704 instanceof Error)){
var e__39208__auto__ = e39704;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39704;

}
}}),stack);

break;
case (6):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings));
}catch (e39705){if((e39705 instanceof Error)){
var e__39208__auto__ = e39705;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39705;

}
}}),stack);

break;
case (7):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings));
}catch (e39706){if((e39706 instanceof Error)){
var e__39208__auto__ = e39706;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39706;

}
}}),stack);

break;
case (8):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings));
}catch (e39707){if((e39707 instanceof Error)){
var e__39208__auto__ = e39707;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39707;

}
}}),stack);

break;
case (9):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings));
}catch (e39708){if((e39708 instanceof Error)){
var e__39208__auto__ = e39708;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39708;

}
}}),stack);

break;
case (10):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings));
}catch (e39709){if((e39709 instanceof Error)){
var e__39208__auto__ = e39709;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39709;

}
}}),stack);

break;
case (11):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings));
}catch (e39710){if((e39710 instanceof Error)){
var e__39208__auto__ = e39710;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39710;

}
}}),stack);

break;
case (12):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings));
}catch (e39711){if((e39711 instanceof Error)){
var e__39208__auto__ = e39711;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39711;

}
}}),stack);

break;
case (13):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings));
}catch (e39712){if((e39712 instanceof Error)){
var e__39208__auto__ = e39712;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39712;

}
}}),stack);

break;
case (14):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings));
}catch (e39713){if((e39713 instanceof Error)){
var e__39208__auto__ = e39713;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39713;

}
}}),stack);

break;
case (15):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings));
}catch (e39714){if((e39714 instanceof Error)){
var e__39208__auto__ = e39714;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39714;

}
}}),stack);

break;
case (16):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings));
}catch (e39715){if((e39715 instanceof Error)){
var e__39208__auto__ = e39715;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39715;

}
}}),stack);

break;
case (17):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings));
}catch (e39716){if((e39716 instanceof Error)){
var e__39208__auto__ = e39716;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39716;

}
}}),stack);

break;
case (18):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings));
}catch (e39717){if((e39717 instanceof Error)){
var e__39208__auto__ = e39717;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39717;

}
}}),stack);

break;
case (19):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
var arg18 = cljs.core.nth.call(null,analyzed_children,(18));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return (bindings[idx]).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings),sci.impl.types.eval.call(null,arg18,ctx,bindings));
}catch (e39718){if((e39718 instanceof Error)){
var e__39208__auto__ = e39718;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39208__auto__,this$);
} else {
throw e39718;

}
}}),stack);

break;
default:
return (function (ctx,bindings){
return sci.impl.evaluator.fn_call.call(null,ctx,bindings,(bindings[idx]),analyzed_children);
});

}
});
sci.impl.analyzer.return_needs_ctx_call = (function sci$impl$analyzer$return_needs_ctx_call(_ctx,expr,f,analyzed_children){
var stack = cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns));
var G__39720 = cljs.core.count.call(null,analyzed_children);
switch (G__39720) {
case (0):
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx);
}),stack);

break;
case (1):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings));
}),stack);

break;
case (2):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings));
}),stack);

break;
case (3):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings));
}),stack);

break;
case (4):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings));
}),stack);

break;
case (5):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings));
}),stack);

break;
case (6):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings));
}),stack);

break;
case (7):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings));
}),stack);

break;
case (8):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings));
}),stack);

break;
case (9):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings));
}),stack);

break;
case (10):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings));
}),stack);

break;
case (11):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings));
}),stack);

break;
case (12):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings));
}),stack);

break;
case (13):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings));
}),stack);

break;
case (14):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings));
}),stack);

break;
case (15):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings));
}),stack);

break;
case (16):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings));
}),stack);

break;
case (17):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings));
}),stack);

break;
case (18):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings));
}),stack);

break;
case (19):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
var arg18 = cljs.core.nth.call(null,analyzed_children,(18));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return f.call(null,ctx,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings),sci.impl.types.eval.call(null,arg18,ctx,bindings));
}),stack);

break;
default:
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return sci.impl.evaluator.fn_call.call(null,ctx,bindings,f,cljs.core.cons.call(null,ctx,analyzed_children));
}),stack);

}
});
sci.impl.analyzer.return_call = (function sci$impl$analyzer$return_call(_ctx,expr,f,analyzed_children,stack,wrap){
var G__39723 = cljs.core.count.call(null,analyzed_children);
switch (G__39723) {
case (0):
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null);
}catch (e39724){if((e39724 instanceof Error)){
var e__39331__auto__ = e39724;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39724;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null);
}catch (e39725){if((e39725 instanceof Error)){
var e__39331__auto__ = e39725;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39725;

}
}}),stack);
}

break;
case (1):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings));
}catch (e39726){if((e39726 instanceof Error)){
var e__39331__auto__ = e39726;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39726;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings));
}catch (e39727){if((e39727 instanceof Error)){
var e__39331__auto__ = e39727;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39727;

}
}}),stack);
}

break;
case (2):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings));
}catch (e39728){if((e39728 instanceof Error)){
var e__39331__auto__ = e39728;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39728;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings));
}catch (e39729){if((e39729 instanceof Error)){
var e__39331__auto__ = e39729;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39729;

}
}}),stack);
}

break;
case (3):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings));
}catch (e39730){if((e39730 instanceof Error)){
var e__39331__auto__ = e39730;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39730;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings));
}catch (e39731){if((e39731 instanceof Error)){
var e__39331__auto__ = e39731;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39731;

}
}}),stack);
}

break;
case (4):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings));
}catch (e39732){if((e39732 instanceof Error)){
var e__39331__auto__ = e39732;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39732;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings));
}catch (e39733){if((e39733 instanceof Error)){
var e__39331__auto__ = e39733;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39733;

}
}}),stack);
}

break;
case (5):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings));
}catch (e39734){if((e39734 instanceof Error)){
var e__39331__auto__ = e39734;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39734;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings));
}catch (e39735){if((e39735 instanceof Error)){
var e__39331__auto__ = e39735;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39735;

}
}}),stack);
}

break;
case (6):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings));
}catch (e39736){if((e39736 instanceof Error)){
var e__39331__auto__ = e39736;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39736;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings));
}catch (e39737){if((e39737 instanceof Error)){
var e__39331__auto__ = e39737;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39737;

}
}}),stack);
}

break;
case (7):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings));
}catch (e39738){if((e39738 instanceof Error)){
var e__39331__auto__ = e39738;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39738;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings));
}catch (e39739){if((e39739 instanceof Error)){
var e__39331__auto__ = e39739;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39739;

}
}}),stack);
}

break;
case (8):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings));
}catch (e39740){if((e39740 instanceof Error)){
var e__39331__auto__ = e39740;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39740;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings));
}catch (e39741){if((e39741 instanceof Error)){
var e__39331__auto__ = e39741;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39741;

}
}}),stack);
}

break;
case (9):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings));
}catch (e39742){if((e39742 instanceof Error)){
var e__39331__auto__ = e39742;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39742;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings));
}catch (e39743){if((e39743 instanceof Error)){
var e__39331__auto__ = e39743;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39743;

}
}}),stack);
}

break;
case (10):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings));
}catch (e39744){if((e39744 instanceof Error)){
var e__39331__auto__ = e39744;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39744;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings));
}catch (e39745){if((e39745 instanceof Error)){
var e__39331__auto__ = e39745;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39745;

}
}}),stack);
}

break;
case (11):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings));
}catch (e39746){if((e39746 instanceof Error)){
var e__39331__auto__ = e39746;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39746;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings));
}catch (e39747){if((e39747 instanceof Error)){
var e__39331__auto__ = e39747;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39747;

}
}}),stack);
}

break;
case (12):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings));
}catch (e39748){if((e39748 instanceof Error)){
var e__39331__auto__ = e39748;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39748;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings));
}catch (e39749){if((e39749 instanceof Error)){
var e__39331__auto__ = e39749;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39749;

}
}}),stack);
}

break;
case (13):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings));
}catch (e39750){if((e39750 instanceof Error)){
var e__39331__auto__ = e39750;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39750;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings));
}catch (e39751){if((e39751 instanceof Error)){
var e__39331__auto__ = e39751;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39751;

}
}}),stack);
}

break;
case (14):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings));
}catch (e39752){if((e39752 instanceof Error)){
var e__39331__auto__ = e39752;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39752;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings));
}catch (e39753){if((e39753 instanceof Error)){
var e__39331__auto__ = e39753;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39753;

}
}}),stack);
}

break;
case (15):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings));
}catch (e39754){if((e39754 instanceof Error)){
var e__39331__auto__ = e39754;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39754;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings));
}catch (e39755){if((e39755 instanceof Error)){
var e__39331__auto__ = e39755;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39755;

}
}}),stack);
}

break;
case (16):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings));
}catch (e39756){if((e39756 instanceof Error)){
var e__39331__auto__ = e39756;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39756;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings));
}catch (e39757){if((e39757 instanceof Error)){
var e__39331__auto__ = e39757;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39757;

}
}}),stack);
}

break;
case (17):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings));
}catch (e39758){if((e39758 instanceof Error)){
var e__39331__auto__ = e39758;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39758;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings));
}catch (e39759){if((e39759 instanceof Error)){
var e__39331__auto__ = e39759;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39759;

}
}}),stack);
}

break;
case (18):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings));
}catch (e39760){if((e39760 instanceof Error)){
var e__39331__auto__ = e39760;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39760;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings));
}catch (e39761){if((e39761 instanceof Error)){
var e__39331__auto__ = e39761;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39761;

}
}}),stack);
}

break;
case (19):
var arg0 = cljs.core.nth.call(null,analyzed_children,(0));
var arg1 = cljs.core.nth.call(null,analyzed_children,(1));
var arg2 = cljs.core.nth.call(null,analyzed_children,(2));
var arg3 = cljs.core.nth.call(null,analyzed_children,(3));
var arg4 = cljs.core.nth.call(null,analyzed_children,(4));
var arg5 = cljs.core.nth.call(null,analyzed_children,(5));
var arg6 = cljs.core.nth.call(null,analyzed_children,(6));
var arg7 = cljs.core.nth.call(null,analyzed_children,(7));
var arg8 = cljs.core.nth.call(null,analyzed_children,(8));
var arg9 = cljs.core.nth.call(null,analyzed_children,(9));
var arg10 = cljs.core.nth.call(null,analyzed_children,(10));
var arg11 = cljs.core.nth.call(null,analyzed_children,(11));
var arg12 = cljs.core.nth.call(null,analyzed_children,(12));
var arg13 = cljs.core.nth.call(null,analyzed_children,(13));
var arg14 = cljs.core.nth.call(null,analyzed_children,(14));
var arg15 = cljs.core.nth.call(null,analyzed_children,(15));
var arg16 = cljs.core.nth.call(null,analyzed_children,(16));
var arg17 = cljs.core.nth.call(null,analyzed_children,(17));
var arg18 = cljs.core.nth.call(null,analyzed_children,(18));
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return wrap.call(null,bindings,f).call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings),sci.impl.types.eval.call(null,arg18,ctx,bindings));
}catch (e39762){if((e39762 instanceof Error)){
var e__39331__auto__ = e39762;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39762;

}
}}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return f.call(null,sci.impl.types.eval.call(null,arg0,ctx,bindings),sci.impl.types.eval.call(null,arg1,ctx,bindings),sci.impl.types.eval.call(null,arg2,ctx,bindings),sci.impl.types.eval.call(null,arg3,ctx,bindings),sci.impl.types.eval.call(null,arg4,ctx,bindings),sci.impl.types.eval.call(null,arg5,ctx,bindings),sci.impl.types.eval.call(null,arg6,ctx,bindings),sci.impl.types.eval.call(null,arg7,ctx,bindings),sci.impl.types.eval.call(null,arg8,ctx,bindings),sci.impl.types.eval.call(null,arg9,ctx,bindings),sci.impl.types.eval.call(null,arg10,ctx,bindings),sci.impl.types.eval.call(null,arg11,ctx,bindings),sci.impl.types.eval.call(null,arg12,ctx,bindings),sci.impl.types.eval.call(null,arg13,ctx,bindings),sci.impl.types.eval.call(null,arg14,ctx,bindings),sci.impl.types.eval.call(null,arg15,ctx,bindings),sci.impl.types.eval.call(null,arg16,ctx,bindings),sci.impl.types.eval.call(null,arg17,ctx,bindings),sci.impl.types.eval.call(null,arg18,ctx,bindings));
}catch (e39763){if((e39763 instanceof Error)){
var e__39331__auto__ = e39763;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e__39331__auto__,this$);
} else {
throw e39763;

}
}}),stack);
}

break;
default:
if(cljs.core.truth_(wrap)){
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return sci.impl.evaluator.fn_call.call(null,ctx,bindings,wrap.call(null,bindings,f),analyzed_children);
}),stack);
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
return sci.impl.evaluator.fn_call.call(null,ctx,bindings,f,analyzed_children);
}),stack);
}

}
});
sci.impl.analyzer.analyze_quote = (function sci$impl$analyzer$analyze_quote(_ctx,expr){
if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,expr))){
} else {
sci.impl.analyzer.throw_error_with_location.call(null,"Wrong number of args (0) passed to quote",expr);
}

var snd = cljs.core.second.call(null,expr);
return sci.impl.types.__GT_constant.call(null,snd);
});
sci.impl.analyzer.analyze_in_ns = (function sci$impl$analyzer$analyze_in_ns(ctx,expr){
var ns_expr = sci.impl.analyzer.analyze.call(null,ctx,cljs.core.second.call(null,expr));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var ns_sym = sci.impl.types.eval.call(null,ns_expr,ctx__$1,bindings);
sci.impl.utils.set_namespace_BANG_.call(null,ctx__$1,ns_sym,null);

return null;
}),null);
});
sci.impl.analyzer.analyze_import = (function sci$impl$analyzer$analyze_import(_ctx,expr){
var args = cljs.core.rest.call(null,expr);
var stack = cljs.core.assoc.call(null,cljs.core.meta.call(null,expr),new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx,bindings){
try{return cljs.core.apply.call(null,sci.impl.evaluator.eval_import,ctx,args);
}catch (e39765){if((e39765 instanceof Error)){
var e = e39765;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e,this$);
} else {
throw e39765;

}
}}),stack);
});
sci.impl.analyzer.analyze_call = (function sci$impl$analyzer$analyze_call(ctx,expr,m,top_level_QMARK_){
var eval_file = new cljs.core.Keyword("clojure.core","eval-file","clojure.core/eval-file",801420726).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(eval_file)){
sci.impl.vars.push_thread_bindings.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_file,eval_file]));
} else {
}

try{var f = cljs.core.first.call(null,expr);
if((f instanceof cljs.core.Symbol)){
var fsym = f;
var special_sym = cljs.core.get.call(null,sci.impl.analyzer.special_syms,f);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = special_sym;
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"check-permissions","check-permissions",669054317).cljs$core$IFn$_invoke$arity$1(ctx);
} else {
return and__4251__auto__;
}
})())?sci.impl.resolve.check_permission_BANG_.call(null,ctx,f,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_sym,null], null)):null);
var f__$1 = (function (){var or__4253__auto__ = special_sym;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return sci.impl.resolve.resolve_symbol.call(null,ctx,f,true);
}
})();
var f_meta = cljs.core.meta.call(null,f__$1);
var eval_QMARK_ = (function (){var and__4251__auto__ = f_meta;
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978).cljs$core$IFn$_invoke$arity$1(f_meta);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_((function (){var and__4251__auto__ = f_meta;
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword("sci.impl.analyzer","static-access","sci.impl.analyzer/static-access",-79014000).cljs$core$IFn$_invoke$arity$1(f_meta);
} else {
return and__4251__auto__;
}
})())){
var vec__39766 = f__$1;
var class$ = cljs.core.nth.call(null,vec__39766,(0),null);
var method_name = cljs.core.nth.call(null,vec__39766,(1),null);
var method_name__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_name);
var len = method_name__$1.length;
var idx = clojure.string.last_index_of.call(null,method_name__$1,".");
var f__$2 = (cljs.core.truth_((function (){var and__4251__auto__ = idx;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,(len - (1)),idx);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sci.impl.analyzer.goog$module$goog$object.getValueByKeys.call(null,class$,cljs.core.into_array.call(null,cljs.core.subs.call(null,method_name__$1,(0),idx).split("."))),cljs.core.subs.call(null,method_name__$1,(idx + (1)))], null):f__$1);
var children = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return sci.impl.evaluator.eval_static_method_invocation.call(null,ctx__$1,bindings,cljs.core.cons.call(null,f__$2,children));
}),null);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.not.call(null,eval_QMARK_);
if(and__4251__auto__){
var and__4251__auto____$1 = (f__$1 instanceof cljs.core.Symbol);
if(and__4251__auto____$1){
var or__4253__auto__ = special_sym;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.contains_QMARK_.call(null,sci.impl.utils.ana_macros,f__$1);
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var G__39769 = f__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,".",".",1975675962,null),G__39769)){
return sci.impl.analyzer.expand_dot_STAR__STAR_.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"and","and",668631710,null),G__39769)){
return sci.impl.analyzer.return_and.call(null,ctx,expr,cljs.core.rest.call(null,expr));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"import","import",241030818,null),G__39769)){
return sci.impl.analyzer.analyze_import.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"case","case",-1510733573,null),G__39769)){
return sci.impl.analyzer.analyze_case.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),G__39769)){
return sci.impl.analyzer.analyze_fn.call(null,ctx,expr,false);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"if","if",1181717262,null),G__39769)){
return sci.impl.analyzer.return_if.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"defmacro","defmacro",2054157304,null),G__39769)){
var ret = sci.impl.analyzer.analyze_defn.call(null,ctx,expr);
return ret;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"defn","defn",-126010802,null),G__39769)){
var ret = sci.impl.analyzer.analyze_defn.call(null,ctx,expr);
return ret;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),G__39769)){
return sci.impl.analyzer.return_do.call(null,ctx,expr,cljs.core.rest.call(null,expr));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"loop","loop",1244978678,null),G__39769)){
return sci.impl.analyzer.analyze_loop.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"expand-constructor","expand-constructor",-343741576,null),G__39769)){
return sci.impl.analyzer.expand_constructor.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"def","def",597100991,null),G__39769)){
return sci.impl.analyzer.analyze_def.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),G__39769)){
return sci.impl.analyzer.analyze_quote.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"let*","let*",1920721458,null),G__39769)){
return sci.impl.analyzer.analyze_let_STAR_.call(null,ctx,expr,cljs.core.second.call(null,expr),cljs.core.nnext.call(null,expr));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"expand-dot*","expand-dot*",-1946890561,null),G__39769)){
return sci.impl.analyzer.expand_dot_STAR_.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"ns","ns",2082130287,null),G__39769)){
return sci.impl.analyzer.analyze_ns_form.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"let","let",358118826,null),G__39769)){
return sci.impl.analyzer.analyze_let.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"fn","fn",465265323,null),G__39769)){
return sci.impl.analyzer.analyze_fn.call(null,ctx,expr,false);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"in-ns","in-ns",-2089468466,null),G__39769)){
return sci.impl.analyzer.analyze_in_ns.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"set!","set!",250714521,null),G__39769)){
return sci.impl.analyzer.analyze_set_BANG_.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"recur","recur",1202958259,null),G__39769)){
return sci.impl.analyzer.return_recur.call(null,ctx,expr,sci.impl.analyzer.analyze_children.call(null,sci.impl.analyzer.without_recur_target.call(null,ctx),cljs.core.rest.call(null,expr)));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"new","new",-444906321,null),G__39769)){
return sci.impl.analyzer.analyze_new.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"var","var",870848730,null),G__39769)){
return sci.impl.analyzer.analyze_var.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"lazy-seq","lazy-seq",489632906,null),G__39769)){
return sci.impl.analyzer.analyze_lazy_seq.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"throw","throw",595905694,null),G__39769)){
return sci.impl.analyzer.analyze_throw.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),G__39769)){
return sci.impl.analyzer.analyze_try.call(null,ctx,expr);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"or","or",1876275696,null),G__39769)){
return sci.impl.analyzer.return_or.call(null,ctx,expr,cljs.core.rest.call(null,expr));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39769)].join('')));

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
} else {
try{if(cljs.core.truth_(sci.impl.utils.macro_QMARK_.call(null,f__$1))){
var needs_ctx_QMARK_ = (sci.impl.utils.needs_ctx === new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,f__$1)));
var f__$2 = ((sci.impl.vars.var_QMARK_.call(null,f__$1))?cljs.core.deref.call(null,f__$1):f__$1);
var v = ((needs_ctx_QMARK_)?cljs.core.apply.call(null,f__$2,expr,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx),ctx,cljs.core.rest.call(null,expr)):cljs.core.apply.call(null,f__$2,expr,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(ctx),cljs.core.rest.call(null,expr)));
var expanded = (cljs.core.truth_(new cljs.core.Keyword("sci.impl","macroexpanding","sci.impl/macroexpanding",2113471825).cljs$core$IFn$_invoke$arity$1(ctx))?v:(cljs.core.truth_((function (){var and__4251__auto__ = top_level_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return ((cljs.core.seq_QMARK_.call(null,v)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.first.call(null,v))));
} else {
return and__4251__auto__;
}
})())?sci.impl.types.__GT_EvalForm.call(null,v):(function (){var v__$1 = (cljs.core.truth_(m)?(((((!((v == null))))?(((((v.cljs$lang$protocol_mask$partition0$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === v.cljs$core$IWithMeta$))))?true:false):false))?cljs.core.with_meta.call(null,v,cljs.core.merge.call(null,m,cljs.core.meta.call(null,v))):v):v);
return sci.impl.analyzer.analyze.call(null,ctx,v__$1,top_level_QMARK_);
})()
));
return expanded;
} else {
var temp__5802__auto__ = new cljs.core.Keyword("sci.impl","inlined","sci.impl/inlined",-478453593).cljs$core$IFn$_invoke$arity$1(f_meta);
if(cljs.core.truth_(temp__5802__auto__)){
var f__$2 = temp__5802__auto__;
return sci.impl.analyzer.return_call.call(null,ctx,expr,f__$2,sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr)),cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword("sci.impl","f-meta","sci.impl/f-meta",-1735495322),f_meta),null);
} else {
var temp__5802__auto____$1 = new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,f__$1));
if(cljs.core.truth_(temp__5802__auto____$1)){
var op = temp__5802__auto____$1;
var G__39772 = op;
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"needs-ctx","needs-ctx",1605017124,null),G__39772)){
if((sci.impl.utils.needs_ctx === op)){
return sci.impl.analyzer.return_needs_ctx_call.call(null,ctx,expr,f__$1,sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr)));
} else {
var children = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr));
return sci.impl.analyzer.return_call.call(null,ctx,expr,f__$1,children,cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword("sci.impl","f-meta","sci.impl/f-meta",-1735495322),f_meta),null);
}
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"resolve-sym","resolve-sym",-1193683260),G__39772)){
return sci.impl.analyzer.return_binding_call.call(null,ctx,expr,new cljs.core.Keyword("sci.impl","idx","sci.impl/idx",700902278).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,f__$1)),f__$1,sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr)),cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword("sci.impl","f-meta","sci.impl/f-meta",-1735495322),f_meta));
} else {
var children = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr));
return sci.impl.analyzer.return_call.call(null,ctx,expr,f__$1,children,cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword("sci.impl","f-meta","sci.impl/f-meta",-1735495322),f_meta),null);

}
}
} else {
var self_ref_QMARK_ = new cljs.core.Keyword(null,"self-ref?","self-ref?",412808630).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_((function (){var and__4251__auto__ = self_ref_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return self_ref_QMARK_.call(null,f__$1);
} else {
return and__4251__auto__;
}
})())){
var children = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr));
return sci.impl.analyzer.return_call.call(null,ctx,expr,f__$1,children,cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword("sci.impl","f-meta","sci.impl/f-meta",-1735495322),f_meta),(function (bindings,___$1){
return cljs.core.deref.call(null,bindings.get(fsym));
}));
} else {
var children = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr));
return sci.impl.analyzer.return_call.call(null,ctx,expr,f__$1,children,cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword("sci.impl","f-meta","sci.impl/f-meta",-1735495322),f_meta),((sci.impl.vars.var_QMARK_.call(null,f__$1))?(function (___$1,v){
return cljs.core.deref.call(null,v);
}):null));
}
}
}
}
}catch (e39770){if((e39770 instanceof Error)){
var e = e39770;
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,e,(function (){var stack = cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file),new cljs.core.Keyword("sci.impl","f-meta","sci.impl/f-meta",-1735495322),f_meta);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return null;
}),stack);
})());
} else {
throw e39770;

}
}
}
}
} else {
if((f instanceof cljs.core.Keyword)){
var children = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr));
var ccount = cljs.core.count.call(null,children);
var G__39773 = ccount;
switch (G__39773) {
case (1):
var arg = cljs.core.nth.call(null,children,(0));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return f.cljs$core$IFn$_invoke$arity$1(sci.impl.types.eval.call(null,arg,ctx__$1,bindings));
}),null);

break;
case (2):
var arg0 = cljs.core.nth.call(null,children,(0));
var arg1 = cljs.core.nth.call(null,children,(1));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return f.cljs$core$IFn$_invoke$arity$2(sci.impl.types.eval.call(null,arg0,ctx__$1,bindings),sci.impl.types.eval.call(null,arg1,ctx__$1,bindings));
}),null);

break;
default:
return sci.impl.analyzer.throw_error_with_location.call(null,["Wrong number of args (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ccount),") passed to: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''),expr);

}
} else {
var f__$1 = sci.impl.analyzer.analyze.call(null,ctx,f);
var children = sci.impl.analyzer.analyze_children.call(null,ctx,cljs.core.rest.call(null,expr));
var stack = cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.deref.call(null,sci.impl.vars.current_ns),new cljs.core.Keyword(null,"file","file",-1269645878),cljs.core.deref.call(null,sci.impl.vars.current_file));
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var f__$2 = sci.impl.types.eval.call(null,f__$1,ctx__$1,bindings);
if(cljs.core.ifn_QMARK_.call(null,f__$2)){
return sci.impl.evaluator.fn_call.call(null,ctx__$1,bindings,f__$2,children);
} else {
throw (new Error(["Cannot call ",cljs.core.pr_str.call(null,f__$2)," as a function."].join('')));
}
}),stack);

}
}
}finally {if(cljs.core.truth_(eval_file)){
sci.impl.vars.pop_thread_bindings.call(null);
} else {
}
}});
sci.impl.analyzer.map_fn = (function sci$impl$analyzer$map_fn(children_count){
if((children_count <= (16))){
return cljs.core.array_map;
} else {
return cljs.core.hash_map;
}
});
sci.impl.analyzer.return_map = (function sci$impl$analyzer$return_map(ctx,the_map,analyzed_children){
var mf = sci.impl.analyzer.map_fn.call(null,cljs.core.count.call(null,analyzed_children));
sci.impl.analyzer.return_call.call(null,ctx,the_map,mf,analyzed_children,null,null);

return sci.impl.analyzer.return_call.call(null,ctx,the_map,mf,analyzed_children,null,null);
});
sci.impl.analyzer.constant_node_QMARK_ = (function sci$impl$analyzer$constant_node_QMARK_(x){
return (!((x instanceof sci.impl.types.NodeR)));
});
sci.impl.analyzer.analyze_map = (function sci$impl$analyzer$analyze_map(ctx,expr,m){
var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
var children = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.cat,expr);
var analyzed_children = sci.impl.analyzer.analyze_children.call(null,ctx__$1,children);
var const_QMARK_ = cljs.core.every_QMARK_.call(null,sci.impl.analyzer.constant_node_QMARK_,analyzed_children);
var same_QMARK_ = ((const_QMARK_)?cljs.core._EQ_.call(null,children,analyzed_children):null);
var const_val = ((const_QMARK_)?(cljs.core.truth_(same_QMARK_)?expr:(function (){var mf = sci.impl.analyzer.map_fn.call(null,cljs.core.count.call(null,analyzed_children));
return cljs.core.apply.call(null,mf,analyzed_children);
})()):null);
var analyzed_map = ((const_QMARK_)?sci.impl.types.__GT_constant.call(null,const_val):sci.impl.analyzer.return_map.call(null,ctx__$1,expr,analyzed_children));
var analyzed_meta = (cljs.core.truth_(m)?sci.impl.analyzer.analyze.call(null,ctx__$1,m):null);
var ret = (cljs.core.truth_(analyzed_meta)?sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
var coll = sci.impl.types.eval.call(null,analyzed_map,ctx__$2,bindings);
var md = sci.impl.types.eval.call(null,analyzed_meta,ctx__$2,bindings);
return cljs.core.with_meta.call(null,coll,md);
}),null):analyzed_map);
return ret;
});
/**
 * Returns analyzed vector or set
 */
sci.impl.analyzer.analyze_vec_or_set = (function sci$impl$analyzer$analyze_vec_or_set(ctx,f1,f2,expr,m){
var ctx__$1 = sci.impl.analyzer.without_recur_target.call(null,ctx);
var analyzed_meta = (cljs.core.truth_(m)?sci.impl.analyzer.analyze.call(null,ctx__$1,m):null);
var analyzed_children = sci.impl.analyzer.analyze_children.call(null,ctx__$1,expr);
var const_QMARK_ = cljs.core.every_QMARK_.call(null,sci.impl.analyzer.constant_node_QMARK_,analyzed_children);
var set_expr_QMARK_ = cljs.core.set_QMARK_.call(null,expr);
var same_QMARK_ = ((const_QMARK_) && (cljs.core._EQ_.call(null,((set_expr_QMARK_)?(function (){var or__4253__auto__ = cljs.core.seq.call(null,expr);
if(or__4253__auto__){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})():expr),analyzed_children)));
var const_val = ((const_QMARK_)?((same_QMARK_)?((cljs.core.empty_QMARK_.call(null,expr))?((set_expr_QMARK_)?cljs.core.PersistentHashSet.EMPTY:cljs.core.PersistentVector.EMPTY):expr):f1.call(null,analyzed_children)):null);
var analyzed_coll = ((const_QMARK_)?sci.impl.types.__GT_constant.call(null,const_val):sci.impl.analyzer.return_call.call(null,ctx__$1,expr,f2,analyzed_children,null,null));
var ret = (cljs.core.truth_(analyzed_meta)?sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$2,bindings){
var coll = sci.impl.types.eval.call(null,analyzed_coll,ctx__$2,bindings);
var md = sci.impl.types.eval.call(null,analyzed_meta,ctx__$2,bindings);
return cljs.core.with_meta.call(null,coll,md);
}),null):analyzed_coll);
return ret;
});
sci.impl.analyzer.analyze_js_obj = (function sci$impl$analyzer$analyze_js_obj(ctx,js_val){
var v = js_val.val;
if(cljs.core.map_QMARK_.call(null,v)){
var ks = cljs.core.keys.call(null,v);
var ks__$1 = cljs.core.map.call(null,cljs.core.name,ks);
var vs = cljs.core.vals.call(null,v);
var vs__$1 = sci.impl.analyzer.analyze_children.call(null,ctx,vs);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return cljs.core.apply.call(null,cljs.core.js_obj,cljs.core.interleave.call(null,ks__$1,cljs.core.map.call(null,(function (p1__39775_SHARP_){
return sci.impl.types.eval.call(null,p1__39775_SHARP_,ctx__$1,bindings);
}),vs__$1)));
}),null);
} else {
var vs = sci.impl.analyzer.analyze_children.call(null,ctx,v);
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
var arr = [];
var seq__39776_39780 = cljs.core.seq.call(null,vs);
var chunk__39777_39781 = null;
var count__39778_39782 = (0);
var i__39779_39783 = (0);
while(true){
if((i__39779_39783 < count__39778_39782)){
var x_39784 = cljs.core._nth.call(null,chunk__39777_39781,i__39779_39783);
arr.push(sci.impl.types.eval.call(null,x_39784,ctx__$1,bindings));


var G__39785 = seq__39776_39780;
var G__39786 = chunk__39777_39781;
var G__39787 = count__39778_39782;
var G__39788 = (i__39779_39783 + (1));
seq__39776_39780 = G__39785;
chunk__39777_39781 = G__39786;
count__39778_39782 = G__39787;
i__39779_39783 = G__39788;
continue;
} else {
var temp__5804__auto___39789 = cljs.core.seq.call(null,seq__39776_39780);
if(temp__5804__auto___39789){
var seq__39776_39790__$1 = temp__5804__auto___39789;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__39776_39790__$1)){
var c__4679__auto___39791 = cljs.core.chunk_first.call(null,seq__39776_39790__$1);
var G__39792 = cljs.core.chunk_rest.call(null,seq__39776_39790__$1);
var G__39793 = c__4679__auto___39791;
var G__39794 = cljs.core.count.call(null,c__4679__auto___39791);
var G__39795 = (0);
seq__39776_39780 = G__39792;
chunk__39777_39781 = G__39793;
count__39778_39782 = G__39794;
i__39779_39783 = G__39795;
continue;
} else {
var x_39796 = cljs.core.first.call(null,seq__39776_39790__$1);
arr.push(sci.impl.types.eval.call(null,x_39796,ctx__$1,bindings));


var G__39797 = cljs.core.next.call(null,seq__39776_39790__$1);
var G__39798 = null;
var G__39799 = (0);
var G__39800 = (0);
seq__39776_39780 = G__39797;
chunk__39777_39781 = G__39798;
count__39778_39782 = G__39799;
i__39779_39783 = G__39800;
continue;
}
} else {
}
}
break;
}

return arr;
}),null);
}
});
sci.impl.analyzer.analyze = (function sci$impl$analyzer$analyze(var_args){
var G__39802 = arguments.length;
switch (G__39802) {
case 2:
return sci.impl.analyzer.analyze.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sci.impl.analyzer.analyze.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.analyzer.analyze.cljs$core$IFn$_invoke$arity$2 = (function (ctx,expr){
return sci.impl.analyzer.analyze.call(null,ctx,expr,false);
}));

(sci.impl.analyzer.analyze.cljs$core$IFn$_invoke$arity$3 = (function (ctx,expr,top_level_QMARK_){
var m = cljs.core.meta.call(null,expr);
if(sci.impl.utils.constant_QMARK_.call(null,expr)){
return sci.impl.types.__GT_constant.call(null,expr);
} else {
if((expr instanceof cljs.core.Symbol)){
var v = sci.impl.resolve.resolve_symbol.call(null,ctx,expr,false,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(m));
var mv = cljs.core.meta.call(null,v);
if(sci.impl.utils.constant_QMARK_.call(null,v)){
return sci.impl.types.__GT_constant.call(null,v);
} else {
if((sci.impl.utils.needs_ctx === new cljs.core.Keyword("sci.impl","op","sci.impl/op",950953978).cljs$core$IFn$_invoke$arity$1(mv))){
return cljs.core.partial.call(null,v,ctx);
} else {
if(sci.impl.vars.var_QMARK_.call(null,v)){
if(cljs.core.truth_(new cljs.core.Keyword(null,"const","const",1709929842).cljs$core$IFn$_invoke$arity$1(mv))){
return cljs.core.deref.call(null,v);
} else {
if(cljs.core.truth_(sci.impl.vars.isMacro.call(null,v))){
throw (new Error(["Can't take value of a macro: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v),""].join('')));
} else {
return sci.impl.types.__GT_NodeR.call(null,(function (this$,ctx__$1,bindings){
return cljs.core._deref.call(null,v);
}),null);
}
}
} else {
return v;

}
}
}
} else {
if(cljs.core.record_QMARK_.call(null,expr)){
return expr;
} else {
if(cljs.core.map_QMARK_.call(null,expr)){
return sci.impl.analyzer.analyze_map.call(null,ctx,expr,m);
} else {
if((expr instanceof cljs.tagged_literals.JSValue)){
return sci.impl.analyzer.analyze_js_obj.call(null,ctx,expr);
} else {
if(cljs.core.vector_QMARK_.call(null,expr)){
return sci.impl.analyzer.analyze_vec_or_set.call(null,ctx,cljs.core.identity,cljs.core.vector,expr,m);
} else {
if(cljs.core.set_QMARK_.call(null,expr)){
return sci.impl.analyzer.analyze_vec_or_set.call(null,ctx,cljs.core.set,cljs.core.hash_set,expr,m);
} else {
if(cljs.core.seq_QMARK_.call(null,expr)){
if(cljs.core.seq.call(null,expr)){
return sci.impl.analyzer.analyze_call.call(null,ctx,expr,m,top_level_QMARK_);
} else {
return expr;
}
} else {
return expr;

}
}
}
}
}
}
}
}
}));

(sci.impl.analyzer.analyze.cljs$lang$maxFixedArity = 3);

