// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__5823){
var vec__5824 = p__5823;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5824,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5824,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5827 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5827,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5827,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5827,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5827,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5827,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5830 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(4),null);
var vec__5833 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5833,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5833,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5833,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5833,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5833,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4253__auto__ = source;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4253__auto__ = line;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4253__auto__ = col;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5836 = segmap;
var map__5836__$1 = cljs.core.__destructure_map(map__5836);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5836__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5836__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5836__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5836__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5836__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5838 = arguments.length;
switch (G__5838) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5842 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5846 = cljs.core.next(segs__$1);
var G__5847 = nrelseg;
var G__5848 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5846;
relseg__$1 = G__5847;
result__$1 = G__5848;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5842,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5842,(1),null);
var G__5849 = (gline + (1));
var G__5850 = cljs.core.next(lines__$1);
var G__5851 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5852 = result__$1;
gline = G__5849;
lines__$1 = G__5850;
relseg = G__5851;
result = G__5852;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5854 = segmap;
var map__5854__$1 = cljs.core.__destructure_map(map__5854);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5854__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5854__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5854__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5854__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5854__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__5853_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__5853_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5856 = arguments.length;
switch (G__5856) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5860 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5864 = cljs.core.next(segs__$1);
var G__5865 = nrelseg;
var G__5866 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5864;
relseg__$1 = G__5865;
result__$1 = G__5866;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5860,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5860,(1),null);
var G__5867 = (gline + (1));
var G__5868 = cljs.core.next(lines__$1);
var G__5869 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5870 = result__$1;
gline = G__5867;
lines__$1 = G__5868;
relseg = G__5869;
result = G__5870;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5871){
var vec__5872 = p__5871;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5872,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5872,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5872,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5872,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5872,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__5875){
var vec__5876 = p__5875;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5876,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5876,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5876,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5876,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5876,(4),null);
var seg = vec__5876;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5879){
var vec__5880 = p__5879;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5880,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5880,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5880,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5880,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5880,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5886 = cljs.core.seq(infos);
var chunk__5887 = null;
var count__5888 = (0);
var i__5889 = (0);
while(true){
if((i__5889 < count__5888)){
var info = chunk__5887.cljs$core$IIndexed$_nth$arity$2(null,i__5889);
var segv_6243 = info__GT_segv(info,source_idx,line,col);
var gline_6244 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6245 = cljs.core.count(cljs.core.deref(lines));
if((gline_6244 > (lc_6245 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5886,chunk__5887,count__5888,i__5889,segv_6243,gline_6244,lc_6245,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6244 - (lc_6245 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6243], null));
});})(seq__5886,chunk__5887,count__5888,i__5889,segv_6243,gline_6244,lc_6245,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5886,chunk__5887,count__5888,i__5889,segv_6243,gline_6244,lc_6245,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6244], null),cljs.core.conj,segv_6243);
});})(seq__5886,chunk__5887,count__5888,i__5889,segv_6243,gline_6244,lc_6245,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6246 = seq__5886;
var G__6247 = chunk__5887;
var G__6248 = count__5888;
var G__6249 = (i__5889 + (1));
seq__5886 = G__6246;
chunk__5887 = G__6247;
count__5888 = G__6248;
i__5889 = G__6249;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__5886);
if(temp__5753__auto__){
var seq__5886__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5886__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__5886__$1);
var G__6250 = cljs.core.chunk_rest(seq__5886__$1);
var G__6251 = c__4679__auto__;
var G__6252 = cljs.core.count(c__4679__auto__);
var G__6253 = (0);
seq__5886 = G__6250;
chunk__5887 = G__6251;
count__5888 = G__6252;
i__5889 = G__6253;
continue;
} else {
var info = cljs.core.first(seq__5886__$1);
var segv_6254 = info__GT_segv(info,source_idx,line,col);
var gline_6255 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6256 = cljs.core.count(cljs.core.deref(lines));
if((gline_6255 > (lc_6256 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5886,chunk__5887,count__5888,i__5889,segv_6254,gline_6255,lc_6256,info,seq__5886__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6255 - (lc_6256 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6254], null));
});})(seq__5886,chunk__5887,count__5888,i__5889,segv_6254,gline_6255,lc_6256,info,seq__5886__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5886,chunk__5887,count__5888,i__5889,segv_6254,gline_6255,lc_6256,info,seq__5886__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6255], null),cljs.core.conj,segv_6254);
});})(seq__5886,chunk__5887,count__5888,i__5889,segv_6254,gline_6255,lc_6256,info,seq__5886__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6257 = cljs.core.next(seq__5886__$1);
var G__6258 = null;
var G__6259 = (0);
var G__6260 = (0);
seq__5886 = G__6257;
chunk__5887 = G__6258;
count__5888 = G__6259;
i__5889 = G__6260;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5890_6261 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5891_6262 = null;
var count__5892_6263 = (0);
var i__5893_6264 = (0);
while(true){
if((i__5893_6264 < count__5892_6263)){
var vec__6066_6265 = chunk__5891_6262.cljs$core$IIndexed$_nth$arity$2(null,i__5893_6264);
var source_idx_6266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6066_6265,(0),null);
var vec__6069_6267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6066_6265,(1),null);
var __6268 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6069_6267,(0),null);
var lines_6269__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6069_6267,(1),null);
var seq__6072_6270 = cljs.core.seq(lines_6269__$1);
var chunk__6073_6271 = null;
var count__6074_6272 = (0);
var i__6075_6273 = (0);
while(true){
if((i__6075_6273 < count__6074_6272)){
var vec__6114_6274 = chunk__6073_6271.cljs$core$IIndexed$_nth$arity$2(null,i__6075_6273);
var line_6275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6114_6274,(0),null);
var cols_6276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6114_6274,(1),null);
var seq__6117_6277 = cljs.core.seq(cols_6276);
var chunk__6118_6278 = null;
var count__6119_6279 = (0);
var i__6120_6280 = (0);
while(true){
if((i__6120_6280 < count__6119_6279)){
var vec__6127_6281 = chunk__6118_6278.cljs$core$IIndexed$_nth$arity$2(null,i__6120_6280);
var col_6282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6127_6281,(0),null);
var infos_6283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6127_6281,(1),null);
encode_cols(infos_6283,source_idx_6266,line_6275,col_6282);


var G__6284 = seq__6117_6277;
var G__6285 = chunk__6118_6278;
var G__6286 = count__6119_6279;
var G__6287 = (i__6120_6280 + (1));
seq__6117_6277 = G__6284;
chunk__6118_6278 = G__6285;
count__6119_6279 = G__6286;
i__6120_6280 = G__6287;
continue;
} else {
var temp__5753__auto___6288 = cljs.core.seq(seq__6117_6277);
if(temp__5753__auto___6288){
var seq__6117_6289__$1 = temp__5753__auto___6288;
if(cljs.core.chunked_seq_QMARK_(seq__6117_6289__$1)){
var c__4679__auto___6290 = cljs.core.chunk_first(seq__6117_6289__$1);
var G__6291 = cljs.core.chunk_rest(seq__6117_6289__$1);
var G__6292 = c__4679__auto___6290;
var G__6293 = cljs.core.count(c__4679__auto___6290);
var G__6294 = (0);
seq__6117_6277 = G__6291;
chunk__6118_6278 = G__6292;
count__6119_6279 = G__6293;
i__6120_6280 = G__6294;
continue;
} else {
var vec__6130_6295 = cljs.core.first(seq__6117_6289__$1);
var col_6296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6130_6295,(0),null);
var infos_6297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6130_6295,(1),null);
encode_cols(infos_6297,source_idx_6266,line_6275,col_6296);


var G__6298 = cljs.core.next(seq__6117_6289__$1);
var G__6299 = null;
var G__6300 = (0);
var G__6301 = (0);
seq__6117_6277 = G__6298;
chunk__6118_6278 = G__6299;
count__6119_6279 = G__6300;
i__6120_6280 = G__6301;
continue;
}
} else {
}
}
break;
}


var G__6302 = seq__6072_6270;
var G__6303 = chunk__6073_6271;
var G__6304 = count__6074_6272;
var G__6305 = (i__6075_6273 + (1));
seq__6072_6270 = G__6302;
chunk__6073_6271 = G__6303;
count__6074_6272 = G__6304;
i__6075_6273 = G__6305;
continue;
} else {
var temp__5753__auto___6306 = cljs.core.seq(seq__6072_6270);
if(temp__5753__auto___6306){
var seq__6072_6307__$1 = temp__5753__auto___6306;
if(cljs.core.chunked_seq_QMARK_(seq__6072_6307__$1)){
var c__4679__auto___6308 = cljs.core.chunk_first(seq__6072_6307__$1);
var G__6309 = cljs.core.chunk_rest(seq__6072_6307__$1);
var G__6310 = c__4679__auto___6308;
var G__6311 = cljs.core.count(c__4679__auto___6308);
var G__6312 = (0);
seq__6072_6270 = G__6309;
chunk__6073_6271 = G__6310;
count__6074_6272 = G__6311;
i__6075_6273 = G__6312;
continue;
} else {
var vec__6133_6313 = cljs.core.first(seq__6072_6307__$1);
var line_6314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6133_6313,(0),null);
var cols_6315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6133_6313,(1),null);
var seq__6136_6316 = cljs.core.seq(cols_6315);
var chunk__6137_6317 = null;
var count__6138_6318 = (0);
var i__6139_6319 = (0);
while(true){
if((i__6139_6319 < count__6138_6318)){
var vec__6146_6320 = chunk__6137_6317.cljs$core$IIndexed$_nth$arity$2(null,i__6139_6319);
var col_6321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6146_6320,(0),null);
var infos_6322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6146_6320,(1),null);
encode_cols(infos_6322,source_idx_6266,line_6314,col_6321);


var G__6323 = seq__6136_6316;
var G__6324 = chunk__6137_6317;
var G__6325 = count__6138_6318;
var G__6326 = (i__6139_6319 + (1));
seq__6136_6316 = G__6323;
chunk__6137_6317 = G__6324;
count__6138_6318 = G__6325;
i__6139_6319 = G__6326;
continue;
} else {
var temp__5753__auto___6327__$1 = cljs.core.seq(seq__6136_6316);
if(temp__5753__auto___6327__$1){
var seq__6136_6328__$1 = temp__5753__auto___6327__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6136_6328__$1)){
var c__4679__auto___6329 = cljs.core.chunk_first(seq__6136_6328__$1);
var G__6330 = cljs.core.chunk_rest(seq__6136_6328__$1);
var G__6331 = c__4679__auto___6329;
var G__6332 = cljs.core.count(c__4679__auto___6329);
var G__6333 = (0);
seq__6136_6316 = G__6330;
chunk__6137_6317 = G__6331;
count__6138_6318 = G__6332;
i__6139_6319 = G__6333;
continue;
} else {
var vec__6149_6334 = cljs.core.first(seq__6136_6328__$1);
var col_6335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6149_6334,(0),null);
var infos_6336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6149_6334,(1),null);
encode_cols(infos_6336,source_idx_6266,line_6314,col_6335);


var G__6337 = cljs.core.next(seq__6136_6328__$1);
var G__6338 = null;
var G__6339 = (0);
var G__6340 = (0);
seq__6136_6316 = G__6337;
chunk__6137_6317 = G__6338;
count__6138_6318 = G__6339;
i__6139_6319 = G__6340;
continue;
}
} else {
}
}
break;
}


var G__6341 = cljs.core.next(seq__6072_6307__$1);
var G__6342 = null;
var G__6343 = (0);
var G__6344 = (0);
seq__6072_6270 = G__6341;
chunk__6073_6271 = G__6342;
count__6074_6272 = G__6343;
i__6075_6273 = G__6344;
continue;
}
} else {
}
}
break;
}


var G__6345 = seq__5890_6261;
var G__6346 = chunk__5891_6262;
var G__6347 = count__5892_6263;
var G__6348 = (i__5893_6264 + (1));
seq__5890_6261 = G__6345;
chunk__5891_6262 = G__6346;
count__5892_6263 = G__6347;
i__5893_6264 = G__6348;
continue;
} else {
var temp__5753__auto___6349 = cljs.core.seq(seq__5890_6261);
if(temp__5753__auto___6349){
var seq__5890_6350__$1 = temp__5753__auto___6349;
if(cljs.core.chunked_seq_QMARK_(seq__5890_6350__$1)){
var c__4679__auto___6351 = cljs.core.chunk_first(seq__5890_6350__$1);
var G__6352 = cljs.core.chunk_rest(seq__5890_6350__$1);
var G__6353 = c__4679__auto___6351;
var G__6354 = cljs.core.count(c__4679__auto___6351);
var G__6355 = (0);
seq__5890_6261 = G__6352;
chunk__5891_6262 = G__6353;
count__5892_6263 = G__6354;
i__5893_6264 = G__6355;
continue;
} else {
var vec__6152_6356 = cljs.core.first(seq__5890_6350__$1);
var source_idx_6357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6152_6356,(0),null);
var vec__6155_6358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6152_6356,(1),null);
var __6359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6155_6358,(0),null);
var lines_6360__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6155_6358,(1),null);
var seq__6158_6361 = cljs.core.seq(lines_6360__$1);
var chunk__6159_6362 = null;
var count__6160_6363 = (0);
var i__6161_6364 = (0);
while(true){
if((i__6161_6364 < count__6160_6363)){
var vec__6200_6365 = chunk__6159_6362.cljs$core$IIndexed$_nth$arity$2(null,i__6161_6364);
var line_6366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6200_6365,(0),null);
var cols_6367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6200_6365,(1),null);
var seq__6203_6368 = cljs.core.seq(cols_6367);
var chunk__6204_6369 = null;
var count__6205_6370 = (0);
var i__6206_6371 = (0);
while(true){
if((i__6206_6371 < count__6205_6370)){
var vec__6213_6372 = chunk__6204_6369.cljs$core$IIndexed$_nth$arity$2(null,i__6206_6371);
var col_6373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6213_6372,(0),null);
var infos_6374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6213_6372,(1),null);
encode_cols(infos_6374,source_idx_6357,line_6366,col_6373);


var G__6375 = seq__6203_6368;
var G__6376 = chunk__6204_6369;
var G__6377 = count__6205_6370;
var G__6378 = (i__6206_6371 + (1));
seq__6203_6368 = G__6375;
chunk__6204_6369 = G__6376;
count__6205_6370 = G__6377;
i__6206_6371 = G__6378;
continue;
} else {
var temp__5753__auto___6379__$1 = cljs.core.seq(seq__6203_6368);
if(temp__5753__auto___6379__$1){
var seq__6203_6380__$1 = temp__5753__auto___6379__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6203_6380__$1)){
var c__4679__auto___6381 = cljs.core.chunk_first(seq__6203_6380__$1);
var G__6382 = cljs.core.chunk_rest(seq__6203_6380__$1);
var G__6383 = c__4679__auto___6381;
var G__6384 = cljs.core.count(c__4679__auto___6381);
var G__6385 = (0);
seq__6203_6368 = G__6382;
chunk__6204_6369 = G__6383;
count__6205_6370 = G__6384;
i__6206_6371 = G__6385;
continue;
} else {
var vec__6216_6386 = cljs.core.first(seq__6203_6380__$1);
var col_6387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6216_6386,(0),null);
var infos_6388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6216_6386,(1),null);
encode_cols(infos_6388,source_idx_6357,line_6366,col_6387);


var G__6389 = cljs.core.next(seq__6203_6380__$1);
var G__6390 = null;
var G__6391 = (0);
var G__6392 = (0);
seq__6203_6368 = G__6389;
chunk__6204_6369 = G__6390;
count__6205_6370 = G__6391;
i__6206_6371 = G__6392;
continue;
}
} else {
}
}
break;
}


var G__6393 = seq__6158_6361;
var G__6394 = chunk__6159_6362;
var G__6395 = count__6160_6363;
var G__6396 = (i__6161_6364 + (1));
seq__6158_6361 = G__6393;
chunk__6159_6362 = G__6394;
count__6160_6363 = G__6395;
i__6161_6364 = G__6396;
continue;
} else {
var temp__5753__auto___6397__$1 = cljs.core.seq(seq__6158_6361);
if(temp__5753__auto___6397__$1){
var seq__6158_6398__$1 = temp__5753__auto___6397__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6158_6398__$1)){
var c__4679__auto___6399 = cljs.core.chunk_first(seq__6158_6398__$1);
var G__6400 = cljs.core.chunk_rest(seq__6158_6398__$1);
var G__6401 = c__4679__auto___6399;
var G__6402 = cljs.core.count(c__4679__auto___6399);
var G__6403 = (0);
seq__6158_6361 = G__6400;
chunk__6159_6362 = G__6401;
count__6160_6363 = G__6402;
i__6161_6364 = G__6403;
continue;
} else {
var vec__6219_6404 = cljs.core.first(seq__6158_6398__$1);
var line_6405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6219_6404,(0),null);
var cols_6406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6219_6404,(1),null);
var seq__6222_6407 = cljs.core.seq(cols_6406);
var chunk__6223_6408 = null;
var count__6224_6409 = (0);
var i__6225_6410 = (0);
while(true){
if((i__6225_6410 < count__6224_6409)){
var vec__6232_6411 = chunk__6223_6408.cljs$core$IIndexed$_nth$arity$2(null,i__6225_6410);
var col_6412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6232_6411,(0),null);
var infos_6413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6232_6411,(1),null);
encode_cols(infos_6413,source_idx_6357,line_6405,col_6412);


var G__6414 = seq__6222_6407;
var G__6415 = chunk__6223_6408;
var G__6416 = count__6224_6409;
var G__6417 = (i__6225_6410 + (1));
seq__6222_6407 = G__6414;
chunk__6223_6408 = G__6415;
count__6224_6409 = G__6416;
i__6225_6410 = G__6417;
continue;
} else {
var temp__5753__auto___6418__$2 = cljs.core.seq(seq__6222_6407);
if(temp__5753__auto___6418__$2){
var seq__6222_6419__$1 = temp__5753__auto___6418__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6222_6419__$1)){
var c__4679__auto___6420 = cljs.core.chunk_first(seq__6222_6419__$1);
var G__6421 = cljs.core.chunk_rest(seq__6222_6419__$1);
var G__6422 = c__4679__auto___6420;
var G__6423 = cljs.core.count(c__4679__auto___6420);
var G__6424 = (0);
seq__6222_6407 = G__6421;
chunk__6223_6408 = G__6422;
count__6224_6409 = G__6423;
i__6225_6410 = G__6424;
continue;
} else {
var vec__6235_6425 = cljs.core.first(seq__6222_6419__$1);
var col_6426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6235_6425,(0),null);
var infos_6427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6235_6425,(1),null);
encode_cols(infos_6427,source_idx_6357,line_6405,col_6426);


var G__6428 = cljs.core.next(seq__6222_6419__$1);
var G__6429 = null;
var G__6430 = (0);
var G__6431 = (0);
seq__6222_6407 = G__6428;
chunk__6223_6408 = G__6429;
count__6224_6409 = G__6430;
i__6225_6410 = G__6431;
continue;
}
} else {
}
}
break;
}


var G__6432 = cljs.core.next(seq__6158_6398__$1);
var G__6433 = null;
var G__6434 = (0);
var G__6435 = (0);
seq__6158_6361 = G__6432;
chunk__6159_6362 = G__6433;
count__6160_6363 = G__6434;
i__6161_6364 = G__6435;
continue;
}
} else {
}
}
break;
}


var G__6436 = cljs.core.next(seq__5890_6350__$1);
var G__6437 = null;
var G__6438 = (0);
var G__6439 = (0);
seq__5890_6261 = G__6436;
chunk__5891_6262 = G__6437;
count__5892_6263 = G__6438;
i__5893_6264 = G__6439;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__6238 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5883_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5883_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5884_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__5884_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5885_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__5885_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__6239 = G__6238;
var G__6240_6440 = G__6239;
var G__6241_6441 = "sourcesContent";
var G__6242_6442 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
cljs.source_map.goog$module$goog$object.set.call(null,G__6240_6440,G__6241_6441,G__6242_6442);

return G__6239;
} else {
return G__6238;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__6443 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6443,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6443,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__6446 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6446,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6446,(1),null);
var G__6451 = cljs.core.next(col_map_seq);
var G__6452 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6446,col,infos,vec__6443,line,col_map){
return (function (v,p__6449){
var map__6450 = p__6449;
var map__6450__$1 = cljs.core.__destructure_map(map__6450);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6450__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6450__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6446,col,infos,vec__6443,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6451;
new_cols = G__6452;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6453 = cljs.core.next(line_map_seq);
var G__6454 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__6453;
new_lines = G__6454;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__6455_6663 = cljs.core.seq(reverse_map);
var chunk__6456_6664 = null;
var count__6457_6665 = (0);
var i__6458_6666 = (0);
while(true){
if((i__6458_6666 < count__6457_6665)){
var vec__6561_6667 = chunk__6456_6664.cljs$core$IIndexed$_nth$arity$2(null,i__6458_6666);
var line_6668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6561_6667,(0),null);
var columns_6669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6561_6667,(1),null);
var seq__6564_6670 = cljs.core.seq(columns_6669);
var chunk__6565_6671 = null;
var count__6566_6672 = (0);
var i__6567_6673 = (0);
while(true){
if((i__6567_6673 < count__6566_6672)){
var vec__6590_6674 = chunk__6565_6671.cljs$core$IIndexed$_nth$arity$2(null,i__6567_6673);
var column_6675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6590_6674,(0),null);
var column_info_6676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6590_6674,(1),null);
var seq__6593_6677 = cljs.core.seq(column_info_6676);
var chunk__6594_6678 = null;
var count__6595_6679 = (0);
var i__6596_6680 = (0);
while(true){
if((i__6596_6680 < count__6595_6679)){
var map__6599_6681 = chunk__6594_6678.cljs$core$IIndexed$_nth$arity$2(null,i__6596_6680);
var map__6599_6682__$1 = cljs.core.__destructure_map(map__6599_6681);
var gline_6683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6599_6682__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6599_6682__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6599_6682__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6683], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6593_6677,chunk__6594_6678,count__6595_6679,i__6596_6680,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6599_6681,map__6599_6682__$1,gline_6683,gcol_6684,name_6685,vec__6590_6674,column_6675,column_info_6676,vec__6561_6667,line_6668,columns_6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6684], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6668,new cljs.core.Keyword(null,"col","col",-1959363084),column_6675,new cljs.core.Keyword(null,"name","name",1843675177),name_6685], null));
});})(seq__6593_6677,chunk__6594_6678,count__6595_6679,i__6596_6680,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6599_6681,map__6599_6682__$1,gline_6683,gcol_6684,name_6685,vec__6590_6674,column_6675,column_info_6676,vec__6561_6667,line_6668,columns_6669,inverted))
,cljs.core.sorted_map()));


var G__6686 = seq__6593_6677;
var G__6687 = chunk__6594_6678;
var G__6688 = count__6595_6679;
var G__6689 = (i__6596_6680 + (1));
seq__6593_6677 = G__6686;
chunk__6594_6678 = G__6687;
count__6595_6679 = G__6688;
i__6596_6680 = G__6689;
continue;
} else {
var temp__5753__auto___6690 = cljs.core.seq(seq__6593_6677);
if(temp__5753__auto___6690){
var seq__6593_6691__$1 = temp__5753__auto___6690;
if(cljs.core.chunked_seq_QMARK_(seq__6593_6691__$1)){
var c__4679__auto___6692 = cljs.core.chunk_first(seq__6593_6691__$1);
var G__6693 = cljs.core.chunk_rest(seq__6593_6691__$1);
var G__6694 = c__4679__auto___6692;
var G__6695 = cljs.core.count(c__4679__auto___6692);
var G__6696 = (0);
seq__6593_6677 = G__6693;
chunk__6594_6678 = G__6694;
count__6595_6679 = G__6695;
i__6596_6680 = G__6696;
continue;
} else {
var map__6600_6697 = cljs.core.first(seq__6593_6691__$1);
var map__6600_6698__$1 = cljs.core.__destructure_map(map__6600_6697);
var gline_6699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6600_6698__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6700 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6600_6698__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6701 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6600_6698__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6699], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6593_6677,chunk__6594_6678,count__6595_6679,i__6596_6680,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6600_6697,map__6600_6698__$1,gline_6699,gcol_6700,name_6701,seq__6593_6691__$1,temp__5753__auto___6690,vec__6590_6674,column_6675,column_info_6676,vec__6561_6667,line_6668,columns_6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6700], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6668,new cljs.core.Keyword(null,"col","col",-1959363084),column_6675,new cljs.core.Keyword(null,"name","name",1843675177),name_6701], null));
});})(seq__6593_6677,chunk__6594_6678,count__6595_6679,i__6596_6680,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6600_6697,map__6600_6698__$1,gline_6699,gcol_6700,name_6701,seq__6593_6691__$1,temp__5753__auto___6690,vec__6590_6674,column_6675,column_info_6676,vec__6561_6667,line_6668,columns_6669,inverted))
,cljs.core.sorted_map()));


var G__6702 = cljs.core.next(seq__6593_6691__$1);
var G__6703 = null;
var G__6704 = (0);
var G__6705 = (0);
seq__6593_6677 = G__6702;
chunk__6594_6678 = G__6703;
count__6595_6679 = G__6704;
i__6596_6680 = G__6705;
continue;
}
} else {
}
}
break;
}


var G__6706 = seq__6564_6670;
var G__6707 = chunk__6565_6671;
var G__6708 = count__6566_6672;
var G__6709 = (i__6567_6673 + (1));
seq__6564_6670 = G__6706;
chunk__6565_6671 = G__6707;
count__6566_6672 = G__6708;
i__6567_6673 = G__6709;
continue;
} else {
var temp__5753__auto___6710 = cljs.core.seq(seq__6564_6670);
if(temp__5753__auto___6710){
var seq__6564_6711__$1 = temp__5753__auto___6710;
if(cljs.core.chunked_seq_QMARK_(seq__6564_6711__$1)){
var c__4679__auto___6712 = cljs.core.chunk_first(seq__6564_6711__$1);
var G__6713 = cljs.core.chunk_rest(seq__6564_6711__$1);
var G__6714 = c__4679__auto___6712;
var G__6715 = cljs.core.count(c__4679__auto___6712);
var G__6716 = (0);
seq__6564_6670 = G__6713;
chunk__6565_6671 = G__6714;
count__6566_6672 = G__6715;
i__6567_6673 = G__6716;
continue;
} else {
var vec__6601_6717 = cljs.core.first(seq__6564_6711__$1);
var column_6718 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6601_6717,(0),null);
var column_info_6719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6601_6717,(1),null);
var seq__6604_6720 = cljs.core.seq(column_info_6719);
var chunk__6605_6721 = null;
var count__6606_6722 = (0);
var i__6607_6723 = (0);
while(true){
if((i__6607_6723 < count__6606_6722)){
var map__6610_6724 = chunk__6605_6721.cljs$core$IIndexed$_nth$arity$2(null,i__6607_6723);
var map__6610_6725__$1 = cljs.core.__destructure_map(map__6610_6724);
var gline_6726 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6610_6725__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6610_6725__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6728 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6610_6725__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6726], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6604_6720,chunk__6605_6721,count__6606_6722,i__6607_6723,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6610_6724,map__6610_6725__$1,gline_6726,gcol_6727,name_6728,vec__6601_6717,column_6718,column_info_6719,seq__6564_6711__$1,temp__5753__auto___6710,vec__6561_6667,line_6668,columns_6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6727], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6668,new cljs.core.Keyword(null,"col","col",-1959363084),column_6718,new cljs.core.Keyword(null,"name","name",1843675177),name_6728], null));
});})(seq__6604_6720,chunk__6605_6721,count__6606_6722,i__6607_6723,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6610_6724,map__6610_6725__$1,gline_6726,gcol_6727,name_6728,vec__6601_6717,column_6718,column_info_6719,seq__6564_6711__$1,temp__5753__auto___6710,vec__6561_6667,line_6668,columns_6669,inverted))
,cljs.core.sorted_map()));


var G__6729 = seq__6604_6720;
var G__6730 = chunk__6605_6721;
var G__6731 = count__6606_6722;
var G__6732 = (i__6607_6723 + (1));
seq__6604_6720 = G__6729;
chunk__6605_6721 = G__6730;
count__6606_6722 = G__6731;
i__6607_6723 = G__6732;
continue;
} else {
var temp__5753__auto___6733__$1 = cljs.core.seq(seq__6604_6720);
if(temp__5753__auto___6733__$1){
var seq__6604_6734__$1 = temp__5753__auto___6733__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6604_6734__$1)){
var c__4679__auto___6735 = cljs.core.chunk_first(seq__6604_6734__$1);
var G__6736 = cljs.core.chunk_rest(seq__6604_6734__$1);
var G__6737 = c__4679__auto___6735;
var G__6738 = cljs.core.count(c__4679__auto___6735);
var G__6739 = (0);
seq__6604_6720 = G__6736;
chunk__6605_6721 = G__6737;
count__6606_6722 = G__6738;
i__6607_6723 = G__6739;
continue;
} else {
var map__6611_6740 = cljs.core.first(seq__6604_6734__$1);
var map__6611_6741__$1 = cljs.core.__destructure_map(map__6611_6740);
var gline_6742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6611_6741__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6611_6741__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6611_6741__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6742], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6604_6720,chunk__6605_6721,count__6606_6722,i__6607_6723,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6611_6740,map__6611_6741__$1,gline_6742,gcol_6743,name_6744,seq__6604_6734__$1,temp__5753__auto___6733__$1,vec__6601_6717,column_6718,column_info_6719,seq__6564_6711__$1,temp__5753__auto___6710,vec__6561_6667,line_6668,columns_6669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6743], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6668,new cljs.core.Keyword(null,"col","col",-1959363084),column_6718,new cljs.core.Keyword(null,"name","name",1843675177),name_6744], null));
});})(seq__6604_6720,chunk__6605_6721,count__6606_6722,i__6607_6723,seq__6564_6670,chunk__6565_6671,count__6566_6672,i__6567_6673,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6611_6740,map__6611_6741__$1,gline_6742,gcol_6743,name_6744,seq__6604_6734__$1,temp__5753__auto___6733__$1,vec__6601_6717,column_6718,column_info_6719,seq__6564_6711__$1,temp__5753__auto___6710,vec__6561_6667,line_6668,columns_6669,inverted))
,cljs.core.sorted_map()));


var G__6745 = cljs.core.next(seq__6604_6734__$1);
var G__6746 = null;
var G__6747 = (0);
var G__6748 = (0);
seq__6604_6720 = G__6745;
chunk__6605_6721 = G__6746;
count__6606_6722 = G__6747;
i__6607_6723 = G__6748;
continue;
}
} else {
}
}
break;
}


var G__6749 = cljs.core.next(seq__6564_6711__$1);
var G__6750 = null;
var G__6751 = (0);
var G__6752 = (0);
seq__6564_6670 = G__6749;
chunk__6565_6671 = G__6750;
count__6566_6672 = G__6751;
i__6567_6673 = G__6752;
continue;
}
} else {
}
}
break;
}


var G__6753 = seq__6455_6663;
var G__6754 = chunk__6456_6664;
var G__6755 = count__6457_6665;
var G__6756 = (i__6458_6666 + (1));
seq__6455_6663 = G__6753;
chunk__6456_6664 = G__6754;
count__6457_6665 = G__6755;
i__6458_6666 = G__6756;
continue;
} else {
var temp__5753__auto___6757 = cljs.core.seq(seq__6455_6663);
if(temp__5753__auto___6757){
var seq__6455_6758__$1 = temp__5753__auto___6757;
if(cljs.core.chunked_seq_QMARK_(seq__6455_6758__$1)){
var c__4679__auto___6759 = cljs.core.chunk_first(seq__6455_6758__$1);
var G__6760 = cljs.core.chunk_rest(seq__6455_6758__$1);
var G__6761 = c__4679__auto___6759;
var G__6762 = cljs.core.count(c__4679__auto___6759);
var G__6763 = (0);
seq__6455_6663 = G__6760;
chunk__6456_6664 = G__6761;
count__6457_6665 = G__6762;
i__6458_6666 = G__6763;
continue;
} else {
var vec__6612_6764 = cljs.core.first(seq__6455_6758__$1);
var line_6765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6612_6764,(0),null);
var columns_6766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6612_6764,(1),null);
var seq__6615_6767 = cljs.core.seq(columns_6766);
var chunk__6616_6768 = null;
var count__6617_6769 = (0);
var i__6618_6770 = (0);
while(true){
if((i__6618_6770 < count__6617_6769)){
var vec__6641_6771 = chunk__6616_6768.cljs$core$IIndexed$_nth$arity$2(null,i__6618_6770);
var column_6772 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6641_6771,(0),null);
var column_info_6773 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6641_6771,(1),null);
var seq__6644_6774 = cljs.core.seq(column_info_6773);
var chunk__6645_6775 = null;
var count__6646_6776 = (0);
var i__6647_6777 = (0);
while(true){
if((i__6647_6777 < count__6646_6776)){
var map__6650_6778 = chunk__6645_6775.cljs$core$IIndexed$_nth$arity$2(null,i__6647_6777);
var map__6650_6779__$1 = cljs.core.__destructure_map(map__6650_6778);
var gline_6780 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6650_6779__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6781 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6650_6779__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6650_6779__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6780], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6644_6774,chunk__6645_6775,count__6646_6776,i__6647_6777,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6650_6778,map__6650_6779__$1,gline_6780,gcol_6781,name_6782,vec__6641_6771,column_6772,column_info_6773,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6781], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6765,new cljs.core.Keyword(null,"col","col",-1959363084),column_6772,new cljs.core.Keyword(null,"name","name",1843675177),name_6782], null));
});})(seq__6644_6774,chunk__6645_6775,count__6646_6776,i__6647_6777,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6650_6778,map__6650_6779__$1,gline_6780,gcol_6781,name_6782,vec__6641_6771,column_6772,column_info_6773,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted))
,cljs.core.sorted_map()));


var G__6783 = seq__6644_6774;
var G__6784 = chunk__6645_6775;
var G__6785 = count__6646_6776;
var G__6786 = (i__6647_6777 + (1));
seq__6644_6774 = G__6783;
chunk__6645_6775 = G__6784;
count__6646_6776 = G__6785;
i__6647_6777 = G__6786;
continue;
} else {
var temp__5753__auto___6787__$1 = cljs.core.seq(seq__6644_6774);
if(temp__5753__auto___6787__$1){
var seq__6644_6788__$1 = temp__5753__auto___6787__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6644_6788__$1)){
var c__4679__auto___6789 = cljs.core.chunk_first(seq__6644_6788__$1);
var G__6790 = cljs.core.chunk_rest(seq__6644_6788__$1);
var G__6791 = c__4679__auto___6789;
var G__6792 = cljs.core.count(c__4679__auto___6789);
var G__6793 = (0);
seq__6644_6774 = G__6790;
chunk__6645_6775 = G__6791;
count__6646_6776 = G__6792;
i__6647_6777 = G__6793;
continue;
} else {
var map__6651_6794 = cljs.core.first(seq__6644_6788__$1);
var map__6651_6795__$1 = cljs.core.__destructure_map(map__6651_6794);
var gline_6796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6651_6795__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6797 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6651_6795__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6651_6795__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6796], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6644_6774,chunk__6645_6775,count__6646_6776,i__6647_6777,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6651_6794,map__6651_6795__$1,gline_6796,gcol_6797,name_6798,seq__6644_6788__$1,temp__5753__auto___6787__$1,vec__6641_6771,column_6772,column_info_6773,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6797], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6765,new cljs.core.Keyword(null,"col","col",-1959363084),column_6772,new cljs.core.Keyword(null,"name","name",1843675177),name_6798], null));
});})(seq__6644_6774,chunk__6645_6775,count__6646_6776,i__6647_6777,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6651_6794,map__6651_6795__$1,gline_6796,gcol_6797,name_6798,seq__6644_6788__$1,temp__5753__auto___6787__$1,vec__6641_6771,column_6772,column_info_6773,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted))
,cljs.core.sorted_map()));


var G__6799 = cljs.core.next(seq__6644_6788__$1);
var G__6800 = null;
var G__6801 = (0);
var G__6802 = (0);
seq__6644_6774 = G__6799;
chunk__6645_6775 = G__6800;
count__6646_6776 = G__6801;
i__6647_6777 = G__6802;
continue;
}
} else {
}
}
break;
}


var G__6803 = seq__6615_6767;
var G__6804 = chunk__6616_6768;
var G__6805 = count__6617_6769;
var G__6806 = (i__6618_6770 + (1));
seq__6615_6767 = G__6803;
chunk__6616_6768 = G__6804;
count__6617_6769 = G__6805;
i__6618_6770 = G__6806;
continue;
} else {
var temp__5753__auto___6807__$1 = cljs.core.seq(seq__6615_6767);
if(temp__5753__auto___6807__$1){
var seq__6615_6808__$1 = temp__5753__auto___6807__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6615_6808__$1)){
var c__4679__auto___6809 = cljs.core.chunk_first(seq__6615_6808__$1);
var G__6810 = cljs.core.chunk_rest(seq__6615_6808__$1);
var G__6811 = c__4679__auto___6809;
var G__6812 = cljs.core.count(c__4679__auto___6809);
var G__6813 = (0);
seq__6615_6767 = G__6810;
chunk__6616_6768 = G__6811;
count__6617_6769 = G__6812;
i__6618_6770 = G__6813;
continue;
} else {
var vec__6652_6814 = cljs.core.first(seq__6615_6808__$1);
var column_6815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6652_6814,(0),null);
var column_info_6816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6652_6814,(1),null);
var seq__6655_6817 = cljs.core.seq(column_info_6816);
var chunk__6656_6818 = null;
var count__6657_6819 = (0);
var i__6658_6820 = (0);
while(true){
if((i__6658_6820 < count__6657_6819)){
var map__6661_6821 = chunk__6656_6818.cljs$core$IIndexed$_nth$arity$2(null,i__6658_6820);
var map__6661_6822__$1 = cljs.core.__destructure_map(map__6661_6821);
var gline_6823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6661_6822__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6824 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6661_6822__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6661_6822__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6823], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6655_6817,chunk__6656_6818,count__6657_6819,i__6658_6820,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6661_6821,map__6661_6822__$1,gline_6823,gcol_6824,name_6825,vec__6652_6814,column_6815,column_info_6816,seq__6615_6808__$1,temp__5753__auto___6807__$1,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6824], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6765,new cljs.core.Keyword(null,"col","col",-1959363084),column_6815,new cljs.core.Keyword(null,"name","name",1843675177),name_6825], null));
});})(seq__6655_6817,chunk__6656_6818,count__6657_6819,i__6658_6820,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6661_6821,map__6661_6822__$1,gline_6823,gcol_6824,name_6825,vec__6652_6814,column_6815,column_info_6816,seq__6615_6808__$1,temp__5753__auto___6807__$1,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted))
,cljs.core.sorted_map()));


var G__6826 = seq__6655_6817;
var G__6827 = chunk__6656_6818;
var G__6828 = count__6657_6819;
var G__6829 = (i__6658_6820 + (1));
seq__6655_6817 = G__6826;
chunk__6656_6818 = G__6827;
count__6657_6819 = G__6828;
i__6658_6820 = G__6829;
continue;
} else {
var temp__5753__auto___6830__$2 = cljs.core.seq(seq__6655_6817);
if(temp__5753__auto___6830__$2){
var seq__6655_6831__$1 = temp__5753__auto___6830__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6655_6831__$1)){
var c__4679__auto___6832 = cljs.core.chunk_first(seq__6655_6831__$1);
var G__6833 = cljs.core.chunk_rest(seq__6655_6831__$1);
var G__6834 = c__4679__auto___6832;
var G__6835 = cljs.core.count(c__4679__auto___6832);
var G__6836 = (0);
seq__6655_6817 = G__6833;
chunk__6656_6818 = G__6834;
count__6657_6819 = G__6835;
i__6658_6820 = G__6836;
continue;
} else {
var map__6662_6837 = cljs.core.first(seq__6655_6831__$1);
var map__6662_6838__$1 = cljs.core.__destructure_map(map__6662_6837);
var gline_6839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6662_6838__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6662_6838__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6662_6838__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6839], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6655_6817,chunk__6656_6818,count__6657_6819,i__6658_6820,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6662_6837,map__6662_6838__$1,gline_6839,gcol_6840,name_6841,seq__6655_6831__$1,temp__5753__auto___6830__$2,vec__6652_6814,column_6815,column_info_6816,seq__6615_6808__$1,temp__5753__auto___6807__$1,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6840], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6765,new cljs.core.Keyword(null,"col","col",-1959363084),column_6815,new cljs.core.Keyword(null,"name","name",1843675177),name_6841], null));
});})(seq__6655_6817,chunk__6656_6818,count__6657_6819,i__6658_6820,seq__6615_6767,chunk__6616_6768,count__6617_6769,i__6618_6770,seq__6455_6663,chunk__6456_6664,count__6457_6665,i__6458_6666,map__6662_6837,map__6662_6838__$1,gline_6839,gcol_6840,name_6841,seq__6655_6831__$1,temp__5753__auto___6830__$2,vec__6652_6814,column_6815,column_info_6816,seq__6615_6808__$1,temp__5753__auto___6807__$1,vec__6612_6764,line_6765,columns_6766,seq__6455_6758__$1,temp__5753__auto___6757,inverted))
,cljs.core.sorted_map()));


var G__6842 = cljs.core.next(seq__6655_6831__$1);
var G__6843 = null;
var G__6844 = (0);
var G__6845 = (0);
seq__6655_6817 = G__6842;
chunk__6656_6818 = G__6843;
count__6657_6819 = G__6844;
i__6658_6820 = G__6845;
continue;
}
} else {
}
}
break;
}


var G__6846 = cljs.core.next(seq__6615_6808__$1);
var G__6847 = null;
var G__6848 = (0);
var G__6849 = (0);
seq__6615_6767 = G__6846;
chunk__6616_6768 = G__6847;
count__6617_6769 = G__6848;
i__6618_6770 = G__6849;
continue;
}
} else {
}
}
break;
}


var G__6850 = cljs.core.next(seq__6455_6758__$1);
var G__6851 = null;
var G__6852 = (0);
var G__6853 = (0);
seq__6455_6663 = G__6850;
chunk__6456_6664 = G__6851;
count__6457_6665 = G__6852;
i__6458_6666 = G__6853;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
