// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.encodings');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.crypto.asn1');
goog.require('alphabase.core');
fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl = require('@fluree/sjcl');
/**
 * Pads a hex value with a leading zero if odd.
 */
fluree.crypto.encodings.pad_hex = (function fluree$crypto$encodings$pad_hex(hex){
if(cljs.core.odd_QMARK_(cljs.core.count(hex))){
return ["0",cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex)].join('');
} else {
return hex;
}
});
goog.exportSymbol('fluree.crypto.encodings.pad_hex', fluree.crypto.encodings.pad_hex);
/**
 * Hex-encode java.math.BigInteger (clj) or sjcl.bn (cljs).
 */
fluree.crypto.encodings.biginteger__GT_hex = (function fluree$crypto$encodings$biginteger__GT_hex(bn){
return fluree.crypto.encodings.pad_hex(bn.toString().replace(/^0x/,""));
});
/**
 * Return bytes of java.math.BigInteger (clj) or sjcl.bn (cljs).
 */
fluree.crypto.encodings.biginteger__GT_bytes = (function fluree$crypto$encodings$biginteger__GT_bytes(var_args){
var G__86683 = arguments.length;
switch (G__86683) {
case 1:
return fluree.crypto.encodings.biginteger__GT_bytes.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.encodings.biginteger__GT_bytes.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.encodings.biginteger__GT_bytes.cljs$core$IFn$_invoke$arity$1 = (function (bn){
return fluree.crypto.encodings.biginteger__GT_bytes.cljs$core$IFn$_invoke$arity$2(bn,null);
}));

(fluree.crypto.encodings.biginteger__GT_bytes.cljs$core$IFn$_invoke$arity$2 = (function (bn,l){
var G__86684 = bn.toBits(l);
return (fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.cljs$core$IFn$_invoke$arity$1(G__86684) : fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.call(null,G__86684));
}));

(fluree.crypto.encodings.biginteger__GT_bytes.cljs$lang$maxFixedArity = 2);

/**
 * Return bytes of java.math.BigInteger (clj) or sjcl.bn (cljs).
 */
fluree.crypto.encodings.bytes__GT_biginteger = (function fluree$crypto$encodings$bytes__GT_biginteger(ba){
return (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn((fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1(ba) : fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.call(null,ba))));
});
/**
 * Return bytes of java.math.BigInteger (clj) or sjcl.bn (cljs).
 */
fluree.crypto.encodings.hex__GT_biginteger = (function fluree$crypto$encodings$hex__GT_biginteger(hex){
return (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn()).initWith(hex);
});
fluree.crypto.encodings.byte__GT_int = (function fluree$crypto$encodings$byte__GT_int(the_bytes){
var the_bytes__$1 = cljs.core.bytes(the_bytes);
return ((the_bytes__$1[(0)]) | (0));
});
/**
 * Tests is an sjcl.bn (cljs) is even. Returns boolean if so.
 */
fluree.crypto.encodings.bn_even_QMARK_ = (function fluree$crypto$encodings$bn_even_QMARK_(sjcl_bn){
return ((cljs.core.get.cljs$core$IFn$_invoke$arity$2(sjcl_bn.limbs,(0)) & (1)) === (0));
});
/**
 * Compute the square root of a number modulo a prime.
 *   Number and modulus should be big numbers (bn).
 */
fluree.crypto.encodings.modular_square_root = (function fluree$crypto$encodings$modular_square_root(n,modulus){
var n__$1 = n.mod(modulus);
var mod8 = parseInt(modulus.mod((8)).toString());
if(cljs.core.truth_(modulus.greaterEquals((0)))){
} else {
throw (new Error(["Assert failed: ","Modulus must be non-negative","\n","(.greaterEquals modulus 0)"].join('')));
}

if(cljs.core.truth_(n__$1.equals((0)))){
return n__$1;
} else {
if(cljs.core.truth_(n__$1.equals((1)))){
return n__$1;
} else {
if(cljs.core.truth_(modulus.equals((2)))){
return n__$1.mod(modulus);
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mod8,(3))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mod8,(7))))){
var m = modulus.add((1)).normalize().halveM().halveM();
return n__$1.powermod(m,modulus);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mod8,(5))){
var m = modulus.sub((5)).normalize().halveM().halveM().halveM();
var v = n__$1.add(n__$1).powermod(m,modulus);
var i = v.multiply(v).multiply(n__$1).multiply((2)).sub((1)).mod(modulus);
return n__$1.multiply(v).multiply(i).mod(modulus);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mod8,(1))){
var q = modulus.sub((1)).normalize();
var e = cljs.core.count(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.even_QMARK_,cljs.core.iterate((function (p1__86686_SHARP_){
return p1__86686_SHARP_.halveM();
}),q)));
var two = (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn((2)));
var z = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__86689_SHARP_){
return cljs.core.not(p1__86689_SHARP_.powermod(two.pow((e - (1))),modulus).equals((1)));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__86688_SHARP_){
return p1__86688_SHARP_.powermod(q,modulus);
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__86687_SHARP_){
return (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn(p1__86687_SHARP_));
}),cljs.core.rest(cljs.core.rest(cljs.core.range.cljs$core$IFn$_invoke$arity$0()))))));
var x = n__$1.powermod(q.sub((1)).normalize().halveM(),modulus);
var y = z;
var r = e;
var v = n__$1.multiply(x).mod(modulus);
var w = n__$1.multiply(x).multiply(x).mod(modulus);
while(true){
if(cljs.core.truth_(w.equals((1)))){
return v;
} else {
var k = cljs.core.first(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (y,r,v,w,q,e,two,z,x,n__$1,mod8){
return (function (p1__86691_SHARP_){
return cljs.core.second(p1__86691_SHARP_).equals((1));
});})(y,r,v,w,q,e,two,z,x,n__$1,mod8))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (y,r,v,w,q,e,two,z,x,n__$1,mod8){
return (function (p1__86690_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__86690_SHARP_,w.powermod(two.pow(p1__86690_SHARP_),modulus)],null));
});})(y,r,v,w,q,e,two,z,x,n__$1,mod8))
,cljs.core.range.cljs$core$IFn$_invoke$arity$0()))));
var d = y.powermod(two.pow(((r - k) - (1))),modulus);
var y__$1 = d.multiply(d).mod(modulus);
var v__$1 = d.multiply(v).mod(modulus);
var w__$1 = w.multiply(y__$1).mod(modulus);
var G__86692 = y__$1;
var G__86693 = k;
var G__86694 = v__$1;
var G__86695 = w__$1;
y = G__86692;
r = G__86693;
v = G__86694;
w = G__86695;
continue;
}
break;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Cannot compute a square root for a non-prime modulus",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"argument","argument",1183001841),n__$1,new cljs.core.Keyword(null,"modulus","modulus",1798166227),modulus], null));

}
}
}
}
}
}
});
/**
 * Left-pads string s to length len with zeroes.
 */
fluree.crypto.encodings.pad_to_length = (function fluree$crypto$encodings$pad_to_length(s,len){
var pad_len = (len - cljs.core.count(s));
if((pad_len > (0))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(pad_len,"0"),s));
} else {
return s;
}
});
/**
 * Compute an elliptic curve point for a y-coordinate parity and x-coordinate
 */
fluree.crypto.encodings.compute_point = (function fluree$crypto$encodings$compute_point(y_even_QMARK_,x_coordinate,curve){
var modulus = curve.field.modulus;
var y_candidate = fluree.crypto.encodings.modular_square_root(x_coordinate.mul(curve.a.add(x_coordinate.square())).add(curve.b),modulus);
var y = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y_even_QMARK_,fluree.crypto.encodings.bn_even_QMARK_(y_candidate)))?y_candidate:modulus.sub(y_candidate));
return ({"x": (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn()).initWith(x_coordinate), "y": (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn()).initWith(y)});
});
fluree.crypto.encodings.x962_hex_compressed_decode = (function fluree$crypto$encodings$x962_hex_compressed_decode(encoded_key,curve){
var x = fluree.crypto.encodings.hex__GT_biginteger(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(encoded_key,(2)));
var y_even_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(encoded_key,(0),(2)),"02");
return fluree.crypto.encodings.compute_point(y_even_QMARK_,x,curve);
});
/**
 * Decode a hex encoded public key into x and y coordinates as bytes.
 */
fluree.crypto.encodings.x962_hex_uncompressed_decode = (function fluree$crypto$encodings$x962_hex_uncompressed_decode(encoded_key,curve){
var size = (cljs.core.count(encoded_key) - (2));
var x = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(encoded_key,(2),((2) + size));
var y = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(encoded_key,((2) + size));
return ({"x": (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn()).initWith(x), "y": (new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn()).initWith(y)});
});
/**
 * Decode a X9.62 encoded public key from hex
 */
fluree.crypto.encodings.x962_decode = (function fluree$crypto$encodings$x962_decode(public_key,curve){
if(cljs.core.truth_((function (){var G__86697 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(public_key,(0),(2));
var fexpr__86696 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["03",null,"02",null,"04",null], null), null);
return (fexpr__86696.cljs$core$IFn$_invoke$arity$1 ? fexpr__86696.cljs$core$IFn$_invoke$arity$1(G__86697) : fexpr__86696.call(null,G__86697));
})())){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("X9.62 encoded public key must have a first byte of 0x02, 0x03 or 0x04.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"public-key","public-key",-2106850051),public_key], null));
}

if(cljs.core.truth_((function (){var G__86699 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(public_key,(0),(2));
var fexpr__86698 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["03",null,"02",null], null), null);
return (fexpr__86698.cljs$core$IFn$_invoke$arity$1 ? fexpr__86698.cljs$core$IFn$_invoke$arity$1(G__86699) : fexpr__86698.call(null,G__86699));
})())){
return fluree.crypto.encodings.x962_hex_compressed_decode(public_key,curve);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("04",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(public_key,(0),(2)))){
return fluree.crypto.encodings.x962_hex_uncompressed_decode(public_key,curve);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid encoding on public key",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"encoded-key","encoded-key",-1294619749),public_key], null));

}
}
});
/**
 * Encodes x and y coords in hex to X9.62 with optional compression (default true).
 *   x coords and y coords should be supplied in hex format.
 */
fluree.crypto.encodings.x962_encode = (function fluree$crypto$encodings$x962_encode(var_args){
var G__86701 = arguments.length;
switch (G__86701) {
case 2:
return fluree.crypto.encodings.x962_encode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.encodings.x962_encode.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.encodings.x962_encode.cljs$core$IFn$_invoke$arity$2 = (function (x_coord,y_coord){
return fluree.crypto.encodings.x962_encode.cljs$core$IFn$_invoke$arity$3(x_coord,y_coord,true);
}));

(fluree.crypto.encodings.x962_encode.cljs$core$IFn$_invoke$arity$3 = (function (x_coord,y_coord,compressed_QMARK_){
if(cljs.core.not(compressed_QMARK_)){
return ["04",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.crypto.encodings.pad_hex(x_coord)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.crypto.encodings.pad_hex(y_coord))].join('');
} else {
var y_even_QMARK_ = fluree.crypto.encodings.bn_even_QMARK_((new fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.bn()).initWith(y_coord));
if(y_even_QMARK_){
return ["02",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.crypto.encodings.pad_hex(x_coord))].join('');
} else {
return ["03",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.crypto.encodings.pad_hex(x_coord))].join('');
}
}
}));

(fluree.crypto.encodings.x962_encode.cljs$lang$maxFixedArity = 3);

/**
 * Decodes an ordinary encoded list of numbers from a hexadecimal following the distinguished encoding rules.
 *   Returns R and S as bigintegers (clj). 
 */
fluree.crypto.encodings.DER_decode_standard = (function fluree$crypto$encodings$DER_decode_standard(asn1){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("30",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(asn1,(0),(2)))){
} else {
throw (new Error(["Assert failed: ","Input must start with the code 30","\n","(= \"30\" (subs asn1 0 2))"].join('')));
}

var map__86703 = fluree.crypto.asn1.decode_asn1_length(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(asn1,(2)));
var map__86703__$1 = cljs.core.__destructure_map(map__86703);
var length = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86703__$1,new cljs.core.Keyword(null,"length","length",588987862));
var remaining = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86703__$1,new cljs.core.Keyword(null,"remaining","remaining",-138926777));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((length * (2)),cljs.core.count(remaining))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Decoded header length does not match actual length of message",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"decoded-header-length","decoded-header-length",471082480),((2) * length),new cljs.core.Keyword(null,"actual-length","actual-length",-1240398531),cljs.core.count(remaining),new cljs.core.Keyword(null,"message","message",-406056002),remaining,new cljs.core.Keyword(null,"full-asn1","full-asn1",46275873),asn1], null));
}

var ret = cljs.core.PersistentVector.EMPTY;
var remaining__$1 = remaining;
while(true){
if(cljs.core.empty_QMARK_(remaining__$1)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.crypto.encodings.hex__GT_biginteger,ret);
} else {
var map__86705 = fluree.crypto.asn1.decode_asn1_integer(remaining__$1);
var map__86705__$1 = cljs.core.__destructure_map(map__86705);
var integer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86705__$1,new cljs.core.Keyword(null,"integer","integer",-604721710));
var remaining__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86705__$1,new cljs.core.Keyword(null,"remaining","remaining",-138926777));
var G__86706 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,integer);
var G__86707 = remaining__$2;
ret = G__86706;
remaining__$1 = G__86707;
continue;
}
break;
}
});
/**
 * Decodes a list of numbers including an optional recovery byte, following BitCoin's convention
 */
fluree.crypto.encodings.DER_decode = (function fluree$crypto$encodings$DER_decode(asn1){
var asn1__$1 = clojure.string.lower_case(asn1);
var first_byte = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(asn1__$1,(0),(2));
if(cljs.core.truth_((function (){var fexpr__86708 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["1c",null,"1b",null,"1e",null,"1d",null], null), null);
return (fexpr__86708.cljs$core$IFn$_invoke$arity$1 ? fexpr__86708.cljs$core$IFn$_invoke$arity$1(first_byte) : fexpr__86708.call(null,first_byte));
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fluree.crypto.encodings.DER_decode_standard(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(asn1__$1,(2))),fluree.crypto.encodings.byte__GT_int(alphabase.core.hex__GT_bytes(first_byte)));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("30",first_byte)){
return fluree.crypto.encodings.DER_decode_standard(asn1__$1);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Input must start with the code 30, or start with a recovery code (either 1b, 1c, 1d, or 1e)",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),asn1__$1], null));

}
}
});
/**
 * Formats an ECDSA signature from hex.
 *   Returns R, S and recover as hex values.
 */
fluree.crypto.encodings.DER_decode_ECDSA_signature = (function fluree$crypto$encodings$DER_decode_ECDSA_signature(ecdsa){
var vec__86709 = fluree.crypto.encodings.DER_decode(ecdsa);
var R = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86709,(0),null);
var S = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86709,(1),null);
var recover = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86709,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"R","R",-936662523),R,new cljs.core.Keyword(null,"S","S",1267293308),S,new cljs.core.Keyword(null,"recover","recover",849894427),recover], null);
});
/**
 * Create a DER encoded signature.
 *   Both R and S should be bigintegers (clj) /bignumbers (cljs).
 *   recover should also be biginteger
 */
fluree.crypto.encodings.DER_encode_ECDSA_signature = (function fluree$crypto$encodings$DER_encode_ECDSA_signature(R,S,recover,curve){
var recover__$1 = (27);
var l = curve.r.bitLength();
var R_hex = (function (){var G__86713 = R.toBits(l);
return (fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.cljs$core$IFn$_invoke$arity$1(G__86713) : fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.call(null,G__86713));
})();
var S_hex = (function (){var G__86714 = S.toBits(l);
return (fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.cljs$core$IFn$_invoke$arity$1(G__86714) : fluree.crypto.encodings.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.call(null,G__86714));
})();
var recover_hex = recover__$1.toString((16));
var R_asn1 = fluree.crypto.asn1.encode_asn1_unsigned_integer_hex(R_hex);
var S_asn1 = fluree.crypto.asn1.encode_asn1_unsigned_integer_hex(S_hex);
return alphabase.core.hex__GT_bytes([cljs.core.str.cljs$core$IFn$_invoke$arity$1(recover_hex),"30",(function (){var G__86718 = fluree.crypto.asn1.encode_asn1_unsigned_integer_hex([R_asn1,S_asn1].join(''));
var fexpr__86717 = (function (p1__86712_SHARP_){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(p1__86712_SHARP_,(2));
});
return fexpr__86717(G__86718);
})()].join(''));
});
