// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__73315 = arguments.length;
switch (G__73315) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___73354 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73336){
var state_val_73337 = (state_73336[(1)]);
if((state_val_73337 === (1))){
var state_73336__$1 = state_73336;
var statearr_73338_73355 = state_73336__$1;
(statearr_73338_73355[(2)] = null);

(statearr_73338_73355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (2))){
var _ = (function (){var statearr_73339 = state_73336;
(statearr_73339[(4)] = cljs.core.cons((5),(state_73336[(4)])));

return statearr_73339;
})();
var inst_73322 = fluree.db.session.db(conn,ledger,null);
var state_73336__$1 = state_73336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73336__$1,(7),inst_73322);
} else {
if((state_val_73337 === (3))){
var inst_73332 = (state_73336[(2)]);
var inst_73333 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73332);
var inst_73334 = cljs.core.async.close_BANG_(pc);
var state_73336__$1 = (function (){var statearr_73341 = state_73336;
(statearr_73341[(7)] = inst_73333);

return statearr_73341;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73336__$1,inst_73334);
} else {
if((state_val_73337 === (4))){
var inst_73316 = (state_73336[(2)]);
var state_73336__$1 = state_73336;
var statearr_73342_73356 = state_73336__$1;
(statearr_73342_73356[(2)] = inst_73316);

(statearr_73342_73356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (5))){
var _ = (function (){var statearr_73343 = state_73336;
(statearr_73343[(4)] = cljs.core.rest((state_73336[(4)])));

return statearr_73343;
})();
var state_73336__$1 = state_73336;
var ex73340 = (state_73336__$1[(2)]);
var statearr_73344_73357 = state_73336__$1;
(statearr_73344_73357[(5)] = ex73340);


var statearr_73345_73358 = state_73336__$1;
(statearr_73345_73358[(1)] = (4));

(statearr_73345_73358[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (6))){
var inst_73328 = (state_73336[(2)]);
var inst_73329 = fluree.db.util.async.throw_err(inst_73328);
var _ = (function (){var statearr_73346 = state_73336;
(statearr_73346[(4)] = cljs.core.rest((state_73336[(4)])));

return statearr_73346;
})();
var state_73336__$1 = state_73336;
var statearr_73347_73359 = state_73336__$1;
(statearr_73347_73359[(2)] = inst_73329);

(statearr_73347_73359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (7))){
var inst_73324 = (state_73336[(2)]);
var inst_73325 = fluree.db.util.async.throw_err(inst_73324);
var inst_73326 = fluree.db.time_travel.as_of_block(inst_73325,block);
var state_73336__$1 = state_73336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73336__$1,(6),inst_73326);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_73348 = [null,null,null,null,null,null,null,null];
(statearr_73348[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_73348[(1)] = (1));

return statearr_73348;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_73336){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73336);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73349){var ex__2730__auto__ = e73349;
var statearr_73350_73360 = state_73336;
(statearr_73350_73360[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73336[(4)]))){
var statearr_73351_73361 = state_73336;
(statearr_73351_73361[(1)] = cljs.core.first((state_73336[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73362 = state_73336;
state_73336 = G__73362;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_73336){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_73336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73352 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73352[(6)] = c__2749__auto___73354);

return statearr_73352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73403){
var state_val_73404 = (state_73403[(1)]);
if((state_val_73404 === (7))){
var inst_73372 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_73403__$1 = state_73403;
if(inst_73372){
var statearr_73405_73436 = state_73403__$1;
(statearr_73405_73436[(1)] = (9));

} else {
var statearr_73406_73437 = state_73403__$1;
(statearr_73406_73437[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (1))){
var state_73403__$1 = state_73403;
var statearr_73407_73438 = state_73403__$1;
(statearr_73407_73438[(2)] = null);

(statearr_73407_73438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (4))){
var inst_73363 = (state_73403[(2)]);
var state_73403__$1 = state_73403;
var statearr_73408_73439 = state_73403__$1;
(statearr_73408_73439[(2)] = inst_73363);

(statearr_73408_73439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (15))){
var inst_73380 = (state_73403[(7)]);
var inst_73379 = (state_73403[(2)]);
var inst_73380__$1 = fluree.db.util.async.throw_err(inst_73379);
var state_73403__$1 = (function (){var statearr_73409 = state_73403;
(statearr_73409[(7)] = inst_73380__$1);

return statearr_73409;
})();
if(cljs.core.truth_(inst_73380__$1)){
var statearr_73410_73440 = state_73403__$1;
(statearr_73410_73440[(1)] = (16));

} else {
var statearr_73411_73441 = state_73403__$1;
(statearr_73411_73441[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (13))){
var state_73403__$1 = state_73403;
var statearr_73412_73442 = state_73403__$1;
(statearr_73412_73442[(2)] = null);

(statearr_73412_73442[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (6))){
var state_73403__$1 = state_73403;
var statearr_73413_73443 = state_73403__$1;
(statearr_73413_73443[(2)] = db);

(statearr_73413_73443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (17))){
var inst_73384 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_73385 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73386 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_73387 = cljs.core.PersistentHashMap.fromArrays(inst_73385,inst_73386);
var inst_73388 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73384,inst_73387);
var inst_73389 = (function(){throw inst_73388})();
var state_73403__$1 = state_73403;
var statearr_73414_73444 = state_73403__$1;
(statearr_73414_73444[(2)] = inst_73389);

(statearr_73414_73444[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (3))){
var inst_73401 = (state_73403[(2)]);
var state_73403__$1 = state_73403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73403__$1,inst_73401);
} else {
if((state_val_73404 === (12))){
var inst_73377 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_73403__$1 = state_73403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73403__$1,(15),inst_73377);
} else {
if((state_val_73404 === (2))){
var _ = (function (){var statearr_73415 = state_73403;
(statearr_73415[(4)] = cljs.core.cons((5),(state_73403[(4)])));

return statearr_73415;
})();
var inst_73369 = cljs.core.not(auth);
var state_73403__$1 = state_73403;
if(inst_73369){
var statearr_73416_73445 = state_73403__$1;
(statearr_73416_73445[(1)] = (6));

} else {
var statearr_73417_73446 = state_73403__$1;
(statearr_73417_73446[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (11))){
var inst_73396 = (state_73403[(2)]);
var state_73403__$1 = state_73403;
var statearr_73419_73447 = state_73403__$1;
(statearr_73419_73447[(2)] = inst_73396);

(statearr_73419_73447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (9))){
var inst_73374 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_73403__$1 = state_73403;
var statearr_73420_73448 = state_73403__$1;
(statearr_73420_73448[(2)] = inst_73374);

(statearr_73420_73448[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (5))){
var _ = (function (){var statearr_73421 = state_73403;
(statearr_73421[(4)] = cljs.core.rest((state_73403[(4)])));

return statearr_73421;
})();
var state_73403__$1 = state_73403;
var ex73418 = (state_73403__$1[(2)]);
var statearr_73422_73449 = state_73403__$1;
(statearr_73422_73449[(5)] = ex73418);


if((ex73418 instanceof Error)){
var statearr_73423_73450 = state_73403__$1;
(statearr_73423_73450[(1)] = (4));

(statearr_73423_73450[(5)] = null);

} else {
throw ex73418;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (14))){
var inst_73394 = (state_73403[(2)]);
var state_73403__$1 = state_73403;
var statearr_73424_73451 = state_73403__$1;
(statearr_73424_73451[(2)] = inst_73394);

(statearr_73424_73451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (16))){
var inst_73380 = (state_73403[(7)]);
var inst_73382 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_73380);
var state_73403__$1 = state_73403;
var statearr_73425_73452 = state_73403__$1;
(statearr_73425_73452[(2)] = inst_73382);

(statearr_73425_73452[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (10))){
var state_73403__$1 = state_73403;
var statearr_73426_73453 = state_73403__$1;
(statearr_73426_73453[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (18))){
var inst_73391 = (state_73403[(2)]);
var state_73403__$1 = state_73403;
var statearr_73428_73454 = state_73403__$1;
(statearr_73428_73454[(2)] = inst_73391);

(statearr_73428_73454[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73404 === (8))){
var inst_73398 = (state_73403[(2)]);
var _ = (function (){var statearr_73429 = state_73403;
(statearr_73429[(4)] = cljs.core.rest((state_73403[(4)])));

return statearr_73429;
})();
var state_73403__$1 = state_73403;
var statearr_73430_73455 = state_73403__$1;
(statearr_73430_73455[(2)] = inst_73398);

(statearr_73430_73455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_73431 = [null,null,null,null,null,null,null,null];
(statearr_73431[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_73431[(1)] = (1));

return statearr_73431;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_73403){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73403);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73432){var ex__2730__auto__ = e73432;
var statearr_73433_73456 = state_73403;
(statearr_73433_73456[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73403[(4)]))){
var statearr_73434_73457 = state_73403;
(statearr_73434_73457[(1)] = cljs.core.first((state_73403[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73458 = state_73403;
state_73403 = G__73458;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_73403){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_73403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73435 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73435[(6)] = c__2749__auto__);

return statearr_73435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73530){
var state_val_73531 = (state_73530[(1)]);
if((state_val_73531 === (7))){
var inst_73468 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_73530__$1 = state_73530;
if(inst_73468){
var statearr_73532_73586 = state_73530__$1;
(statearr_73532_73586[(1)] = (9));

} else {
var statearr_73533_73587 = state_73530__$1;
(statearr_73533_73587[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (20))){
var inst_73492 = (state_73530[(7)]);
var state_73530__$1 = state_73530;
if(cljs.core.truth_(inst_73492)){
var statearr_73534_73588 = state_73530__$1;
(statearr_73534_73588[(1)] = (22));

} else {
var statearr_73535_73589 = state_73530__$1;
(statearr_73535_73589[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (27))){
var state_73530__$1 = state_73530;
var statearr_73536_73590 = state_73530__$1;
(statearr_73536_73590[(2)] = null);

(statearr_73536_73590[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (1))){
var state_73530__$1 = state_73530;
var statearr_73537_73591 = state_73530__$1;
(statearr_73537_73591[(2)] = null);

(statearr_73537_73591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (24))){
var inst_73506 = (state_73530[(2)]);
var state_73530__$1 = state_73530;
var statearr_73538_73592 = state_73530__$1;
(statearr_73538_73592[(2)] = inst_73506);

(statearr_73538_73592[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (4))){
var inst_73459 = (state_73530[(2)]);
var state_73530__$1 = state_73530;
var statearr_73539_73593 = state_73530__$1;
(statearr_73539_73593[(2)] = inst_73459);

(statearr_73539_73593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (15))){
var inst_73475 = (state_73530[(8)]);
var inst_73474 = (state_73530[(2)]);
var inst_73475__$1 = fluree.db.util.async.throw_err(inst_73474);
var state_73530__$1 = (function (){var statearr_73540 = state_73530;
(statearr_73540[(8)] = inst_73475__$1);

return statearr_73540;
})();
if(cljs.core.truth_(inst_73475__$1)){
var statearr_73541_73594 = state_73530__$1;
(statearr_73541_73594[(1)] = (16));

} else {
var statearr_73542_73595 = state_73530__$1;
(statearr_73542_73595[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (21))){
var inst_73508 = (state_73530[(9)]);
var inst_73508__$1 = (state_73530[(2)]);
var state_73530__$1 = (function (){var statearr_73543 = state_73530;
(statearr_73543[(9)] = inst_73508__$1);

return statearr_73543;
})();
if(cljs.core.truth_(inst_73508__$1)){
var statearr_73544_73596 = state_73530__$1;
(statearr_73544_73596[(1)] = (29));

} else {
var statearr_73545_73597 = state_73530__$1;
(statearr_73545_73597[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (31))){
var inst_73508 = (state_73530[(9)]);
var inst_73516 = (state_73530[(2)]);
var state_73530__$1 = (function (){var statearr_73546 = state_73530;
(statearr_73546[(10)] = inst_73516);

return statearr_73546;
})();
if(cljs.core.truth_(inst_73508)){
var statearr_73547_73598 = state_73530__$1;
(statearr_73547_73598[(1)] = (33));

} else {
var statearr_73548_73599 = state_73530__$1;
(statearr_73548_73599[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (32))){
var inst_73512 = (state_73530[(2)]);
var inst_73513 = fluree.db.util.async.throw_err(inst_73512);
var state_73530__$1 = state_73530;
var statearr_73549_73600 = state_73530__$1;
(statearr_73549_73600[(2)] = inst_73513);

(statearr_73549_73600[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (33))){
var inst_73508 = (state_73530[(9)]);
var inst_73518 = fluree.db.permissions.permission_map(db,inst_73508,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_73530__$1 = state_73530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73530__$1,(36),inst_73518);
} else {
if((state_val_73531 === (13))){
var state_73530__$1 = state_73530;
var statearr_73550_73601 = state_73530__$1;
(statearr_73550_73601[(2)] = null);

(statearr_73550_73601[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (22))){
var inst_73492 = (state_73530[(7)]);
var inst_73496 = fluree.db.auth.roles(db,inst_73492);
var state_73530__$1 = state_73530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73530__$1,(25),inst_73496);
} else {
if((state_val_73531 === (36))){
var inst_73520 = (state_73530[(2)]);
var inst_73521 = fluree.db.util.async.throw_err(inst_73520);
var state_73530__$1 = state_73530;
var statearr_73551_73602 = state_73530__$1;
(statearr_73551_73602[(2)] = inst_73521);

(statearr_73551_73602[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (29))){
var inst_73492 = (state_73530[(7)]);
var inst_73508 = (state_73530[(9)]);
var inst_73510 = fluree.db.dbfunctions.ctx.build(db,inst_73492,inst_73508);
var state_73530__$1 = state_73530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73530__$1,(32),inst_73510);
} else {
if((state_val_73531 === (6))){
var state_73530__$1 = state_73530;
var statearr_73552_73603 = state_73530__$1;
(statearr_73552_73603[(2)] = null);

(statearr_73552_73603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (28))){
var inst_73504 = (state_73530[(2)]);
var state_73530__$1 = state_73530;
var statearr_73553_73604 = state_73530__$1;
(statearr_73553_73604[(2)] = inst_73504);

(statearr_73553_73604[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (25))){
var inst_73498 = (state_73530[(2)]);
var inst_73499 = fluree.db.util.async.throw_err(inst_73498);
var state_73530__$1 = state_73530;
var statearr_73554_73605 = state_73530__$1;
(statearr_73554_73605[(2)] = inst_73499);

(statearr_73554_73605[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (34))){
var state_73530__$1 = state_73530;
var statearr_73555_73606 = state_73530__$1;
(statearr_73555_73606[(2)] = null);

(statearr_73555_73606[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (17))){
var inst_73478 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_73479 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73480 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_73481 = cljs.core.PersistentHashMap.fromArrays(inst_73479,inst_73480);
var inst_73482 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73478,inst_73481);
var inst_73483 = (function(){throw inst_73482})();
var state_73530__$1 = state_73530;
var statearr_73556_73607 = state_73530__$1;
(statearr_73556_73607[(2)] = inst_73483);

(statearr_73556_73607[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (3))){
var inst_73528 = (state_73530[(2)]);
var state_73530__$1 = state_73530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73530__$1,inst_73528);
} else {
if((state_val_73531 === (12))){
var inst_73472 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_73530__$1 = state_73530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73530__$1,(15),inst_73472);
} else {
if((state_val_73531 === (2))){
var _ = (function (){var statearr_73557 = state_73530;
(statearr_73557[(4)] = cljs.core.cons((5),(state_73530[(4)])));

return statearr_73557;
})();
var inst_73465 = (auth == null);
var state_73530__$1 = state_73530;
if(cljs.core.truth_(inst_73465)){
var statearr_73558_73608 = state_73530__$1;
(statearr_73558_73608[(1)] = (6));

} else {
var statearr_73559_73609 = state_73530__$1;
(statearr_73559_73609[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (23))){
var state_73530__$1 = state_73530;
var statearr_73560_73610 = state_73530__$1;
(statearr_73560_73610[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (35))){
var inst_73516 = (state_73530[(10)]);
var inst_73492 = (state_73530[(7)]);
var inst_73508 = (state_73530[(9)]);
var inst_73524 = (state_73530[(2)]);
var inst_73525 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_73492,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_73508,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_73524,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_73516], 0));
var _ = (function (){var statearr_73562 = state_73530;
(statearr_73562[(4)] = cljs.core.rest((state_73530[(4)])));

return statearr_73562;
})();
var state_73530__$1 = state_73530;
var statearr_73563_73611 = state_73530__$1;
(statearr_73563_73611[(2)] = inst_73525);

(statearr_73563_73611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (19))){
var state_73530__$1 = state_73530;
var statearr_73564_73612 = state_73530__$1;
(statearr_73564_73612[(2)] = roles);

(statearr_73564_73612[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (11))){
var inst_73490 = (state_73530[(2)]);
var state_73530__$1 = state_73530;
var statearr_73566_73613 = state_73530__$1;
(statearr_73566_73613[(2)] = inst_73490);

(statearr_73566_73613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (9))){
var state_73530__$1 = state_73530;
var statearr_73567_73614 = state_73530__$1;
(statearr_73567_73614[(2)] = (0));

(statearr_73567_73614[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (5))){
var _ = (function (){var statearr_73568 = state_73530;
(statearr_73568[(4)] = cljs.core.rest((state_73530[(4)])));

return statearr_73568;
})();
var state_73530__$1 = state_73530;
var ex73565 = (state_73530__$1[(2)]);
var statearr_73569_73615 = state_73530__$1;
(statearr_73569_73615[(5)] = ex73565);


if((ex73565 instanceof Error)){
var statearr_73570_73616 = state_73530__$1;
(statearr_73570_73616[(1)] = (4));

(statearr_73570_73616[(5)] = null);

} else {
throw ex73565;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (14))){
var inst_73488 = (state_73530[(2)]);
var state_73530__$1 = state_73530;
var statearr_73571_73617 = state_73530__$1;
(statearr_73571_73617[(2)] = inst_73488);

(statearr_73571_73617[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (26))){
var state_73530__$1 = state_73530;
var statearr_73572_73618 = state_73530__$1;
(statearr_73572_73618[(2)] = null);

(statearr_73572_73618[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (16))){
var inst_73475 = (state_73530[(8)]);
var state_73530__$1 = state_73530;
var statearr_73573_73619 = state_73530__$1;
(statearr_73573_73619[(2)] = inst_73475);

(statearr_73573_73619[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (30))){
var state_73530__$1 = state_73530;
var statearr_73574_73620 = state_73530__$1;
(statearr_73574_73620[(2)] = null);

(statearr_73574_73620[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (10))){
var state_73530__$1 = state_73530;
if(cljs.core.truth_(auth)){
var statearr_73575_73621 = state_73530__$1;
(statearr_73575_73621[(1)] = (12));

} else {
var statearr_73576_73622 = state_73530__$1;
(statearr_73576_73622[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (18))){
var inst_73485 = (state_73530[(2)]);
var state_73530__$1 = state_73530;
var statearr_73577_73623 = state_73530__$1;
(statearr_73577_73623[(2)] = inst_73485);

(statearr_73577_73623[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73531 === (8))){
var inst_73492 = (state_73530[(2)]);
var state_73530__$1 = (function (){var statearr_73578 = state_73530;
(statearr_73578[(7)] = inst_73492);

return statearr_73578;
})();
if(cljs.core.truth_(roles)){
var statearr_73579_73624 = state_73530__$1;
(statearr_73579_73624[(1)] = (19));

} else {
var statearr_73580_73625 = state_73530__$1;
(statearr_73580_73625[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_73581 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73581[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_73581[(1)] = (1));

return statearr_73581;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_73530){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73530);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73582){var ex__2730__auto__ = e73582;
var statearr_73583_73626 = state_73530;
(statearr_73583_73626[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73530[(4)]))){
var statearr_73584_73627 = state_73530;
(statearr_73584_73627[(1)] = cljs.core.first((state_73530[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73628 = state_73530;
state_73530 = G__73628;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_73530){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_73530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73585 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73585[(6)] = c__2749__auto__);

return statearr_73585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__73629 = db;
var map__73629__$1 = cljs.core.__destructure_map(map__73629);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73629__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73629__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73629__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73636){
var state_val_73637 = (state_73636[(1)]);
if((state_val_73637 === (1))){
var inst_73630 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_73631 = fluree.db.session.db(conn,inst_73630,null);
var state_73636__$1 = state_73636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73636__$1,(2),inst_73631);
} else {
if((state_val_73637 === (2))){
var inst_73633 = (state_73636[(2)]);
var inst_73634 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_73633);
var state_73636__$1 = state_73636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73636__$1,inst_73634);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_73638 = [null,null,null,null,null,null,null];
(statearr_73638[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_73638[(1)] = (1));

return statearr_73638;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_73636){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73636);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73639){var ex__2730__auto__ = e73639;
var statearr_73640_73667 = state_73636;
(statearr_73640_73667[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73636[(4)]))){
var statearr_73641_73668 = state_73636;
(statearr_73641_73668[(1)] = cljs.core.first((state_73636[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73669 = state_73636;
state_73636 = G__73669;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_73636){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_73636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73642 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73642[(6)] = c__2749__auto__);

return statearr_73642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73655){
var state_val_73656 = (state_73655[(1)]);
if((state_val_73656 === (1))){
var inst_73643 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_73644 = fluree.db.session.db(conn,inst_73643,null);
var state_73655__$1 = state_73655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73655__$1,(2),inst_73644);
} else {
if((state_val_73656 === (2))){
var inst_73646 = (state_73655[(7)]);
var inst_73646__$1 = (state_73655[(2)]);
var inst_73647 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_73646__$1);
var inst_73648 = newer_block_QMARK_(inst_73647);
var state_73655__$1 = (function (){var statearr_73657 = state_73655;
(statearr_73657[(7)] = inst_73646__$1);

return statearr_73657;
})();
if(inst_73648){
var statearr_73658_73670 = state_73655__$1;
(statearr_73658_73670[(1)] = (3));

} else {
var statearr_73659_73671 = state_73655__$1;
(statearr_73659_73671[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (3))){
var inst_73646 = (state_73655[(7)]);
var inst_73650 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_73646);
var state_73655__$1 = state_73655;
var statearr_73660_73672 = state_73655__$1;
(statearr_73660_73672[(2)] = inst_73650);

(statearr_73660_73672[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (4))){
var state_73655__$1 = state_73655;
var statearr_73661_73673 = state_73655__$1;
(statearr_73661_73673[(2)] = null);

(statearr_73661_73673[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (5))){
var inst_73653 = (state_73655[(2)]);
var state_73655__$1 = state_73655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73655__$1,inst_73653);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_73662 = [null,null,null,null,null,null,null,null];
(statearr_73662[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_73662[(1)] = (1));

return statearr_73662;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_73655){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73655);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73663){var ex__2730__auto__ = e73663;
var statearr_73664_73674 = state_73655;
(statearr_73664_73674[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73655[(4)]))){
var statearr_73665_73675 = state_73655;
(statearr_73665_73675[(1)] = cljs.core.first((state_73655[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73676 = state_73655;
state_73655 = G__73676;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_73655){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_73655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73666 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73666[(6)] = c__2749__auto__);

return statearr_73666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__73677 = db;
var map__73677__$1 = cljs.core.__destructure_map(map__73677);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73677__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73677__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73677__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___73753 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73727){
var state_val_73728 = (state_73727[(1)]);
if((state_val_73728 === (7))){
var inst_73693 = (state_73727[(7)]);
var inst_73704 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73693,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_73727__$1 = state_73727;
if(inst_73704){
var statearr_73729_73754 = state_73727__$1;
(statearr_73729_73754[(1)] = (9));

} else {
var statearr_73730_73755 = state_73727__$1;
(statearr_73730_73755[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (1))){
var inst_73686 = (state_73727[(8)]);
var inst_73678 = (state_73727[(9)]);
var inst_73678__$1 = cljs.core.async.timeout(timeout);
var inst_73686__$1 = res_port;
var inst_73687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73688 = [inst_73678__$1,inst_73686__$1];
var inst_73689 = (new cljs.core.PersistentVector(null,2,(5),inst_73687,inst_73688,null));
var state_73727__$1 = (function (){var statearr_73731 = state_73727;
(statearr_73731[(8)] = inst_73686__$1);

(statearr_73731[(9)] = inst_73678__$1);

return statearr_73731;
})();
return cljs.core.async.ioc_alts_BANG_(state_73727__$1,(2),inst_73689);
} else {
if((state_val_73728 === (4))){
var inst_73686 = (state_73727[(8)]);
var inst_73693 = (state_73727[(7)]);
var inst_73697 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73693,inst_73686);
var state_73727__$1 = state_73727;
if(inst_73697){
var statearr_73732_73756 = state_73727__$1;
(statearr_73732_73756[(1)] = (6));

} else {
var statearr_73733_73757 = state_73727__$1;
(statearr_73733_73757[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (13))){
var inst_73712 = (state_73727[(10)]);
var inst_73723 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73712);
var state_73727__$1 = state_73727;
var statearr_73734_73758 = state_73727__$1;
(statearr_73734_73758[(2)] = inst_73723);

(statearr_73734_73758[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (6))){
var inst_73691 = (state_73727[(11)]);
var inst_73702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73691,(0),null);
var state_73727__$1 = state_73727;
var statearr_73735_73759 = state_73727__$1;
(statearr_73735_73759[(2)] = inst_73702);

(statearr_73735_73759[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (3))){
var state_73727__$1 = state_73727;
var statearr_73736_73760 = state_73727__$1;
(statearr_73736_73760[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_73736_73760[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (12))){
var inst_73716 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_73717 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73718 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_73719 = cljs.core.PersistentHashMap.fromArrays(inst_73717,inst_73718);
var inst_73720 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73716,inst_73719);
var inst_73721 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73720);
var state_73727__$1 = state_73727;
var statearr_73737_73761 = state_73727__$1;
(statearr_73737_73761[(2)] = inst_73721);

(statearr_73737_73761[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (2))){
var inst_73691 = (state_73727[(11)]);
var inst_73693 = (state_73727[(7)]);
var inst_73678 = (state_73727[(9)]);
var inst_73691__$1 = (state_73727[(2)]);
var inst_73692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73691__$1,(0),null);
var inst_73693__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73691__$1,(1),null);
var inst_73694 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73693__$1,inst_73678);
var state_73727__$1 = (function (){var statearr_73738 = state_73727;
(statearr_73738[(12)] = inst_73692);

(statearr_73738[(11)] = inst_73691__$1);

(statearr_73738[(7)] = inst_73693__$1);

return statearr_73738;
})();
if(inst_73694){
var statearr_73739_73762 = state_73727__$1;
(statearr_73739_73762[(1)] = (3));

} else {
var statearr_73740_73763 = state_73727__$1;
(statearr_73740_73763[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (11))){
var inst_73708 = (state_73727[(2)]);
var state_73727__$1 = state_73727;
var statearr_73741_73764 = state_73727__$1;
(statearr_73741_73764[(2)] = inst_73708);

(statearr_73741_73764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (9))){
var inst_73692 = (state_73727[(12)]);
var state_73727__$1 = state_73727;
var statearr_73742_73765 = state_73727__$1;
(statearr_73742_73765[(2)] = inst_73692);

(statearr_73742_73765[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (5))){
var inst_73712 = (state_73727[(10)]);
var inst_73712__$1 = (state_73727[(2)]);
var inst_73713 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_73714 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_73712__$1);
var state_73727__$1 = (function (){var statearr_73743 = state_73727;
(statearr_73743[(10)] = inst_73712__$1);

(statearr_73743[(13)] = inst_73713);

return statearr_73743;
})();
if(inst_73714){
var statearr_73744_73766 = state_73727__$1;
(statearr_73744_73766[(1)] = (12));

} else {
var statearr_73745_73767 = state_73727__$1;
(statearr_73745_73767[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (14))){
var inst_73725 = (state_73727[(2)]);
var state_73727__$1 = state_73727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73727__$1,inst_73725);
} else {
if((state_val_73728 === (10))){
var state_73727__$1 = state_73727;
var statearr_73746_73768 = state_73727__$1;
(statearr_73746_73768[(2)] = null);

(statearr_73746_73768[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73728 === (8))){
var inst_73710 = (state_73727[(2)]);
var state_73727__$1 = state_73727;
var statearr_73747_73769 = state_73727__$1;
(statearr_73747_73769[(2)] = inst_73710);

(statearr_73747_73769[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_73748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73748[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_73748[(1)] = (1));

return statearr_73748;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_73727){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73727);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73749){var ex__2730__auto__ = e73749;
var statearr_73750_73770 = state_73727;
(statearr_73750_73770[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73727[(4)]))){
var statearr_73751_73771 = state_73727;
(statearr_73751_73771[(1)] = cljs.core.first((state_73727[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73772 = state_73727;
state_73727 = G__73772;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_73727){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_73727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73752 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73752[(6)] = c__2749__auto___73753);

return statearr_73752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__73774 = arguments.length;
switch (G__73774) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__73775){
var map__73776 = p__73775;
var map__73776__$1 = cljs.core.__destructure_map(map__73776);
var opts = map__73776__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73776__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73776__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73776__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73776__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73776__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___73865 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73827){
var state_val_73828 = (state_73827[(1)]);
if((state_val_73828 === (7))){
var inst_73789 = (state_73827[(7)]);
var inst_73791 = fluree.db.api.ledger.syncTo_db(inst_73789,syncTo,syncTimeout);
var state_73827__$1 = state_73827;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73827__$1,(10),inst_73791);
} else {
if((state_val_73828 === (20))){
var inst_73813 = (state_73827[(8)]);
var state_73827__$1 = state_73827;
var statearr_73829_73866 = state_73827__$1;
(statearr_73829_73866[(2)] = inst_73813);

(statearr_73829_73866[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (1))){
var state_73827__$1 = state_73827;
var statearr_73830_73867 = state_73827__$1;
(statearr_73830_73867[(2)] = null);

(statearr_73830_73867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (4))){
var inst_73777 = (state_73827[(2)]);
var inst_73778 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73777);
var inst_73779 = cljs.core.async.close_BANG_(pc);
var state_73827__$1 = (function (){var statearr_73831 = state_73827;
(statearr_73831[(9)] = inst_73778);

return statearr_73831;
})();
var statearr_73832_73868 = state_73827__$1;
(statearr_73832_73868[(2)] = inst_73779);

(statearr_73832_73868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (15))){
var inst_73805 = (state_73827[(10)]);
var inst_73807 = fluree.db.api.ledger.add_db_permissions(inst_73805,auth,roles);
var state_73827__$1 = state_73827;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73827__$1,(18),inst_73807);
} else {
if((state_val_73828 === (21))){
var inst_73821 = (state_73827[(2)]);
var inst_73822 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73821);
var _ = (function (){var statearr_73833 = state_73827;
(statearr_73833[(4)] = cljs.core.rest((state_73827[(4)])));

return statearr_73833;
})();
var state_73827__$1 = state_73827;
var statearr_73834_73869 = state_73827__$1;
(statearr_73834_73869[(2)] = inst_73822);

(statearr_73834_73869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (13))){
var inst_73805 = (state_73827[(2)]);
var state_73827__$1 = (function (){var statearr_73835 = state_73827;
(statearr_73835[(10)] = inst_73805);

return statearr_73835;
})();
if(cljs.core.truth_(roles)){
var statearr_73836_73870 = state_73827__$1;
(statearr_73836_73870[(1)] = (15));

} else {
var statearr_73837_73871 = state_73827__$1;
(statearr_73837_73871[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (22))){
var inst_73817 = (state_73827[(2)]);
var inst_73818 = fluree.db.util.async.throw_err(inst_73817);
var state_73827__$1 = state_73827;
var statearr_73838_73872 = state_73827__$1;
(statearr_73838_73872[(2)] = inst_73818);

(statearr_73838_73872[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (6))){
var inst_73788 = (state_73827[(2)]);
var inst_73789 = fluree.db.util.async.throw_err(inst_73788);
var state_73827__$1 = (function (){var statearr_73839 = state_73827;
(statearr_73839[(7)] = inst_73789);

return statearr_73839;
})();
if(cljs.core.truth_(syncTo)){
var statearr_73840_73873 = state_73827__$1;
(statearr_73840_73873[(1)] = (7));

} else {
var statearr_73841_73874 = state_73827__$1;
(statearr_73841_73874[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (17))){
var inst_73813 = (state_73827[(2)]);
var state_73827__$1 = (function (){var statearr_73842 = state_73827;
(statearr_73842[(8)] = inst_73813);

return statearr_73842;
})();
if(cljs.core.truth_(auth)){
var statearr_73843_73875 = state_73827__$1;
(statearr_73843_73875[(1)] = (19));

} else {
var statearr_73844_73876 = state_73827__$1;
(statearr_73844_73876[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (3))){
var inst_73825 = (state_73827[(2)]);
var state_73827__$1 = state_73827;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73827__$1,inst_73825);
} else {
if((state_val_73828 === (12))){
var inst_73797 = (state_73827[(11)]);
var state_73827__$1 = state_73827;
var statearr_73845_73877 = state_73827__$1;
(statearr_73845_73877[(2)] = inst_73797);

(statearr_73845_73877[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (2))){
var _ = (function (){var statearr_73846 = state_73827;
(statearr_73846[(4)] = cljs.core.cons((5),(state_73827[(4)])));

return statearr_73846;
})();
var inst_73786 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_73827__$1 = state_73827;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73827__$1,(6),inst_73786);
} else {
if((state_val_73828 === (19))){
var inst_73813 = (state_73827[(8)]);
var inst_73815 = fluree.db.api.ledger.add_db_permissions(inst_73813,auth,roles);
var state_73827__$1 = state_73827;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73827__$1,(22),inst_73815);
} else {
if((state_val_73828 === (11))){
var inst_73797 = (state_73827[(11)]);
var inst_73799 = fluree.db.time_travel.as_of_block(inst_73797,block);
var state_73827__$1 = state_73827;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73827__$1,(14),inst_73799);
} else {
if((state_val_73828 === (9))){
var inst_73797 = (state_73827[(2)]);
var state_73827__$1 = (function (){var statearr_73848 = state_73827;
(statearr_73848[(11)] = inst_73797);

return statearr_73848;
})();
if(cljs.core.truth_(block)){
var statearr_73849_73878 = state_73827__$1;
(statearr_73849_73878[(1)] = (11));

} else {
var statearr_73850_73879 = state_73827__$1;
(statearr_73850_73879[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (5))){
var _ = (function (){var statearr_73851 = state_73827;
(statearr_73851[(4)] = cljs.core.rest((state_73827[(4)])));

return statearr_73851;
})();
var state_73827__$1 = state_73827;
var ex73847 = (state_73827__$1[(2)]);
var statearr_73852_73880 = state_73827__$1;
(statearr_73852_73880[(5)] = ex73847);


var statearr_73853_73881 = state_73827__$1;
(statearr_73853_73881[(1)] = (4));

(statearr_73853_73881[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (14))){
var inst_73801 = (state_73827[(2)]);
var inst_73802 = fluree.db.util.async.throw_err(inst_73801);
var state_73827__$1 = state_73827;
var statearr_73854_73882 = state_73827__$1;
(statearr_73854_73882[(2)] = inst_73802);

(statearr_73854_73882[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (16))){
var inst_73805 = (state_73827[(10)]);
var state_73827__$1 = state_73827;
var statearr_73855_73883 = state_73827__$1;
(statearr_73855_73883[(2)] = inst_73805);

(statearr_73855_73883[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (10))){
var inst_73793 = (state_73827[(2)]);
var inst_73794 = fluree.db.util.async.throw_err(inst_73793);
var state_73827__$1 = state_73827;
var statearr_73856_73884 = state_73827__$1;
(statearr_73856_73884[(2)] = inst_73794);

(statearr_73856_73884[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (18))){
var inst_73809 = (state_73827[(2)]);
var inst_73810 = fluree.db.util.async.throw_err(inst_73809);
var state_73827__$1 = state_73827;
var statearr_73857_73885 = state_73827__$1;
(statearr_73857_73885[(2)] = inst_73810);

(statearr_73857_73885[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73828 === (8))){
var inst_73789 = (state_73827[(7)]);
var state_73827__$1 = state_73827;
var statearr_73858_73886 = state_73827__$1;
(statearr_73858_73886[(2)] = inst_73789);

(statearr_73858_73886[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_73859 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73859[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_73859[(1)] = (1));

return statearr_73859;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_73827){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73827);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73860){var ex__2730__auto__ = e73860;
var statearr_73861_73887 = state_73827;
(statearr_73861_73887[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73827[(4)]))){
var statearr_73862_73888 = state_73827;
(statearr_73862_73888[(1)] = cljs.core.first((state_73827[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73889 = state_73827;
state_73827 = G__73889;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_73827){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_73827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73863 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73863[(6)] = c__2749__auto___73865);

return statearr_73863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

