// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__26315 = cljs.core.get_global_hierarchy;
return (fexpr__26315.cljs$core$IFn$_invoke$arity$0 ? fexpr__26315.cljs$core$IFn$_invoke$arity$0() : fexpr__26315.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("set websocket id:",ws_id) : fluree.db.util.log.trace.call(null,"set websocket id:",ws_id));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$3("process event:",event_type,event_data) : fluree.db.util.log.trace.call(null,"process event:",event_type,event_data));

var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__26316 = cljs.core.seq(callbacks);
var chunk__26317 = null;
var count__26318 = (0);
var i__26319 = (0);
while(true){
if((i__26319 < count__26318)){
var vec__26332 = chunk__26317.cljs$core$IIndexed$_nth$arity$2(null,i__26319);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26332,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26332,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e26335){var e_26344 = e26335;
var G__26336_26345 = e_26344;
var G__26337_26346 = ["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__26336_26345,G__26337_26346) : fluree.db.util.log.error.call(null,G__26336_26345,G__26337_26346));
}

var G__26347 = seq__26316;
var G__26348 = chunk__26317;
var G__26349 = count__26318;
var G__26350 = (i__26319 + (1));
seq__26316 = G__26347;
chunk__26317 = G__26348;
count__26318 = G__26349;
i__26319 = G__26350;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__26316);
if(temp__5804__auto__){
var seq__26316__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__26316__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__26316__$1);
var G__26351 = cljs.core.chunk_rest(seq__26316__$1);
var G__26352 = c__4679__auto__;
var G__26353 = cljs.core.count(c__4679__auto__);
var G__26354 = (0);
seq__26316 = G__26351;
chunk__26317 = G__26352;
count__26318 = G__26353;
i__26319 = G__26354;
continue;
} else {
var vec__26338 = cljs.core.first(seq__26316__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26338,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26338,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e26341){var e_26355 = e26341;
var G__26342_26356 = e_26355;
var G__26343_26357 = ["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__26342_26356,G__26343_26357) : fluree.db.util.log.error.call(null,G__26342_26356,G__26343_26357));
}

var G__26358 = cljs.core.next(seq__26316__$1);
var G__26359 = null;
var G__26360 = (0);
var G__26361 = (0);
seq__26316 = G__26358;
chunk__26317 = G__26359;
count__26318 = G__26360;
i__26319 = G__26361;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Process events: ",msg) : fluree.db.util.log.trace.call(null,"Process events: ",msg));
var vec__26364 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26364,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26364,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26364,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26364,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__26367 = conn;
var map__26367__$1 = cljs.core.__destructure_map(map__26367);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26367__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__26368 = event_type__$1;
var G__26368__$1 = (((G__26368 instanceof cljs.core.Keyword))?G__26368.fqn:null);
switch (G__26368__$1) {
case "response":
var temp__5804__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5804__auto__)){
var res_chan = temp__5804__auto__;
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Found response channel for subject",subject) : fluree.db.util.log.trace.call(null,"Found response channel for subject",subject));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__26362_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__26362_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__26369 = error_data;
var map__26369__$1 = cljs.core.__destructure_map(map__26369);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26369__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e26363){var e = e26363;
return (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(e) : fluree.db.util.log.error.call(null,e));
}});
