// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('sci.core');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns true if the arg is a string containing a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(v){
var and__4251__auto__ = typeof v === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,v);
} else {
return and__4251__auto__;
}
});
fluree.db.dbfunctions.core.allowed_symbols = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Copies local fns ns public vars into SCI
 */
fluree.db.dbfunctions.core.load_local_fns_ns = (function fluree$db$dbfunctions$core$load_local_fns_ns(){
var ns_public_vars = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.fromArray([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("uuid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.uuid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,803,null,803,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("max-pred-val"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max_pred_val;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("contains?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.contains_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,1,372,null,372,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("subs"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.subs;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("ctx"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ctx;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ctx","fluree.db.dbfunctions.fns/ctx",570947084,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,363,null,363,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null)),"Returns a value from the user's context if set. Provide the key or key sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.ctx)?fluree.db.dbfunctions.fns.ctx.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("query"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.query;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,504,null,504,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("flakes"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.flakes;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,775,null,775,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("boolean"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.boolean$;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("dec"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.dec;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,570,null,570,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("<"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,426,null,426,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("floor"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.floor;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,825,null,825,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?o"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_o;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,1,303,null,303,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?sid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_sid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("objF"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objF;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("ceil"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ceil;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("<="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,439,null,439,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("*"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._STAR_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,619,null,619,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("min"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.min;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,491,null,491,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?pO"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pO;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("empty?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.empty_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("quot"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.quot;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,645,null,645,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("now"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.now;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,583,null,583,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("not="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not_EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,465,null,465,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("if-else"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.if_else;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("rand"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rand;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,787,null,787,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(">"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,413,null,413,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("mod"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.mod;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,658,null,658,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("lower-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.lower_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("-"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,606,null,606,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("hash-set"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.hash_set;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,386,null,386,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("or"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.or;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("valid-email?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.valid_email_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,709,null,709,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?s"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_s;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("rem"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rem;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("nth"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nth;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("nil?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nil_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("cas"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.cas;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,837,null,837,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("re-find"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.re_find;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("not"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("/"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._SLASH_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,632,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(">="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,452,null,452,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("upper-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.upper_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("inc"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.inc;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("+"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._PLUS_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,593,null,593,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("str"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.str;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("objT"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objT;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("max"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,478,null,478,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("=="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._EQ__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,400,null,400,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("count"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.count;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get-all"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_all;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,328,null,328,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path + query costs"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?p"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_p;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?auth_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_auth_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("extract"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.extract;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",18,1,14,true,14,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),"Resolves a value if a channel.\n  Must be used inside of a go-block.",(cljs.core.truth_(fluree.db.dbfunctions.fns.extract)?fluree.db.dbfunctions.fns.extract.cljs$lang$test:null)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?user_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_user_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,721,null,721,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("relationship?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.relationship_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,1,531,null,531,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("and"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.and;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?pid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get-in"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_in;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,349,null,349,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))], null)], true));
var _ = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Loading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ns_public_vars))," local fns"].join('')], null));
var sci_ns = sci.core.create_ns.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns_map,p__66858){
var vec__66859 = p__66858;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66859,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66859,(1),null);
var m = cljs.core.meta(var$);
var no_doc = new cljs.core.Keyword(null,"no-doc","no-doc",1559921891).cljs$core$IFn$_invoke$arity$1(m);
var doc = new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m);
var arglists = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(no_doc)){
return ns_map;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns_map,var_name,sci.core.new_var.cljs$core$IFn$_invoke$arity$3(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var_name),cljs.core.deref(var$),(function (){var G__66862 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ns","ns",441598760),sci_ns,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m)], null);
var G__66862__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__66862,new cljs.core.Keyword(null,"macro","macro",-867863404),true):G__66862);
var G__66862__$2 = (cljs.core.truth_(doc)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__66862__$1,new cljs.core.Keyword(null,"doc","doc",1913296891),doc):G__66862__$1);
if(cljs.core.truth_(arglists)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__66862__$2,new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists);
} else {
return G__66862__$2;
}
})()));
}
}),cljs.core.PersistentArrayMap.EMPTY,ns_public_vars);
});
fluree.db.dbfunctions.core.sci_ctx = (new cljs.core.Delay((function (){
var cfg = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),fluree.db.dbfunctions.core.load_local_fns_ns()], null)], null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI config:",cfg], null));

return sci.core.init(cfg);
}),null));
fluree.db.dbfunctions.core.parse_string = (function fluree$db$dbfunctions$core$parse_string(s){
return sci.core.parse_string(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_string = (function fluree$db$dbfunctions$core$eval_string(s){
return sci.core.eval_string_STAR_(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_form = (function fluree$db$dbfunctions$core$eval_form(f){
return sci.core.eval_form(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),f);
});
/**
 * Given a collection of function strings, returns a combined function using
 *   the and function.
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
/**
 * Tries to resolve a local pre-defined fn with fn-name. Returns a fn-map if
 *   found, nil otherwise.
 */
fluree.db.dbfunctions.core.find_local_fn = (function fluree$db$dbfunctions$core$find_local_fn(fn_name){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Looking for local fn:",fn_name], null));

var local_fns_ns = new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null);
var sci_vars = fluree.db.dbfunctions.core.eval_string(["(ns-publics '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),")"].join(''));
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI vars:",sci_vars], null));

if(cljs.core.truth_((function (){var G__66865 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name);
var fexpr__66864 = cljs.core.set(cljs.core.keys(sci_vars));
return (fexpr__66864.cljs$core$IFn$_invoke$arity$1 ? fexpr__66864.cljs$core$IFn$_invoke$arity$1(G__66865) : fexpr__66864.call(null,G__66865));
})())){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Found local fn:",fn_name], null));

var fn_var = cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name));
var map__66866 = fluree.db.dbfunctions.core.eval_string(["(meta #'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_var),")"].join(''));
var map__66866__$1 = cljs.core.__destructure_map(map__66866);
var sci_fn_meta = map__66866__$1;
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66866__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66866__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
if(cljs.core.truth_(sci_fn_meta)){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI fn metadata:",sci_fn_meta], null));

var first_arglist = cljs.core.first(arglists);
var args_set = cljs.core.set(first_arglist);
var var_args_QMARK_ = cljs.core.boolean$((function (){var G__66867 = new cljs.core.Symbol(null,"&","&",-2144855648,null);
return (args_set.cljs$core$IFn$_invoke$arity$1 ? args_set.cljs$core$IFn$_invoke$arity$1(G__66867) : args_set.call(null,G__66867));
})());
var arity = ((var_args_QMARK_)?null:cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__66863_SHARP_){
return (cljs.core.count(p1__66863_SHARP_) - (1));
}),arglists)));
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"f","f",-1597136552),fn_var,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),var_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec], null);
} else {
return null;
}
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_db_fn = (function fluree$db$dbfunctions$core$find_db_fn(var_args){
var G__66869 = arguments.length;
switch (G__66869) {
case 2:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,fn_type){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66960){
var state_val_66961 = (state_66960[(1)]);
if((state_val_66961 === (7))){
var inst_66896 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_66897 = ["Unknown function: ",inst_66896].join('');
var inst_66898 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66899 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_66900 = cljs.core.PersistentHashMap.fromArrays(inst_66898,inst_66899);
var inst_66901 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66897,inst_66900);
var inst_66902 = (function(){throw inst_66901})();
var state_66960__$1 = state_66960;
var statearr_66962_66995 = state_66960__$1;
(statearr_66962_66995[(2)] = inst_66902);

(statearr_66962_66995[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (1))){
var state_66960__$1 = state_66960;
var statearr_66963_66996 = state_66960__$1;
(statearr_66963_66996[(2)] = null);

(statearr_66963_66996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (4))){
var inst_66870 = (state_66960[(2)]);
var state_66960__$1 = state_66960;
var statearr_66964_66997 = state_66960__$1;
(statearr_66964_66997[(2)] = inst_66870);

(statearr_66964_66997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (15))){
var inst_66922 = (state_66960[(7)]);
var inst_66893 = (state_66960[(8)]);
var inst_66922__$1 = (state_66960[(2)]);
var inst_66923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66924 = ["Parsed params:",inst_66922__$1];
var inst_66925 = (new cljs.core.PersistentVector(null,2,(5),inst_66923,inst_66924,null));
var inst_66926 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66925);
var inst_66927 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66893,"_fn/code");
var inst_66928 = fluree.db.dbfunctions.core.parse_string(inst_66927);
var inst_66929 = (fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_66928,fn_type,inst_66922__$1) : fluree.db.dbfunctions.core.validate_form.call(null,db,inst_66928,fn_type,inst_66922__$1));
var state_66960__$1 = (function (){var statearr_66965 = state_66960;
(statearr_66965[(9)] = inst_66926);

(statearr_66965[(7)] = inst_66922__$1);

return statearr_66965;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66960__$1,(16),inst_66929);
} else {
if((state_val_66961 === (13))){
var state_66960__$1 = state_66960;
var statearr_66966_66998 = state_66960__$1;
(statearr_66966_66998[(2)] = null);

(statearr_66966_66998[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (6))){
var inst_66893 = (state_66960[(8)]);
var inst_66892 = (state_66960[(2)]);
var inst_66893__$1 = fluree.db.util.async.throw_err(inst_66892);
var inst_66894 = cljs.core.empty_QMARK_(inst_66893__$1);
var state_66960__$1 = (function (){var statearr_66967 = state_66960;
(statearr_66967[(8)] = inst_66893__$1);

return statearr_66967;
})();
if(inst_66894){
var statearr_66968_66999 = state_66960__$1;
(statearr_66968_66999[(1)] = (7));

} else {
var statearr_66969_67000 = state_66960__$1;
(statearr_66969_67000[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (3))){
var inst_66958 = (state_66960[(2)]);
var state_66960__$1 = state_66960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66960__$1,inst_66958);
} else {
if((state_val_66961 === (12))){
var inst_66916 = (state_66960[(10)]);
var inst_66916__$1 = (state_66960[(2)]);
var inst_66917 = (inst_66916__$1 == null);
var state_66960__$1 = (function (){var statearr_66970 = state_66960;
(statearr_66970[(10)] = inst_66916__$1);

return statearr_66970;
})();
if(cljs.core.truth_(inst_66917)){
var statearr_66971_67001 = state_66960__$1;
(statearr_66971_67001[(1)] = (13));

} else {
var statearr_66972_67002 = state_66960__$1;
(statearr_66972_67002[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (2))){
var _ = (function (){var statearr_66973 = state_66960;
(statearr_66973[(4)] = cljs.core.cons((5),(state_66960[(4)])));

return statearr_66973;
})();
var inst_66876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66877 = ["Looking for custom db fn:",fn_name];
var inst_66878 = (new cljs.core.PersistentVector(null,2,(5),inst_66876,inst_66877,null));
var inst_66879 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66878);
var inst_66880 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_66881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66882 = ["_fn/params","_fn/code","_fn/spec"];
var inst_66883 = (new cljs.core.PersistentVector(null,3,(5),inst_66881,inst_66882,null));
var inst_66884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66885 = cljs.core.name(fn_name);
var inst_66886 = ["_fn/name",inst_66885];
var inst_66887 = (new cljs.core.PersistentVector(null,2,(5),inst_66884,inst_66886,null));
var inst_66888 = [inst_66883,inst_66887];
var inst_66889 = cljs.core.PersistentHashMap.fromArrays(inst_66880,inst_66888);
var inst_66890 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_66889);
var state_66960__$1 = (function (){var statearr_66974 = state_66960;
(statearr_66974[(11)] = inst_66879);

return statearr_66974;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66960__$1,(6),inst_66890);
} else {
if((state_val_66961 === (11))){
var inst_66893 = (state_66960[(8)]);
var inst_66914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66893,"_fn/params");
var state_66960__$1 = state_66960;
var statearr_66976_67003 = state_66960__$1;
(statearr_66976_67003[(2)] = inst_66914);

(statearr_66976_67003[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (9))){
var inst_66893 = (state_66960[(8)]);
var inst_66905 = (state_66960[(2)]);
var inst_66906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66907 = ["Custom db fn query results:",inst_66893];
var inst_66908 = (new cljs.core.PersistentVector(null,2,(5),inst_66906,inst_66907,null));
var inst_66909 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66908);
var inst_66911 = (inst_66893 == null);
var state_66960__$1 = (function (){var statearr_66977 = state_66960;
(statearr_66977[(12)] = inst_66909);

(statearr_66977[(13)] = inst_66905);

return statearr_66977;
})();
if(cljs.core.truth_(inst_66911)){
var statearr_66978_67004 = state_66960__$1;
(statearr_66978_67004[(1)] = (10));

} else {
var statearr_66979_67005 = state_66960__$1;
(statearr_66979_67005[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (5))){
var _ = (function (){var statearr_66980 = state_66960;
(statearr_66980[(4)] = cljs.core.rest((state_66960[(4)])));

return statearr_66980;
})();
var state_66960__$1 = state_66960;
var ex66975 = (state_66960__$1[(2)]);
var statearr_66981_67006 = state_66960__$1;
(statearr_66981_67006[(5)] = ex66975);


if((ex66975 instanceof Error)){
var statearr_66982_67007 = state_66960__$1;
(statearr_66982_67007[(1)] = (4));

(statearr_66982_67007[(5)] = null);

} else {
throw ex66975;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (14))){
var inst_66916 = (state_66960[(10)]);
var inst_66920 = fluree.db.dbfunctions.core.parse_string(inst_66916);
var state_66960__$1 = state_66960;
var statearr_66983_67008 = state_66960__$1;
(statearr_66983_67008[(2)] = inst_66920);

(statearr_66983_67008[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (16))){
var inst_66922 = (state_66960[(7)]);
var inst_66893 = (state_66960[(8)]);
var inst_66931 = (state_66960[(2)]);
var inst_66932 = fluree.db.util.async.throw_err(inst_66931);
var inst_66933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66934 = ["Validated code:",inst_66932];
var inst_66935 = (new cljs.core.PersistentVector(null,2,(5),inst_66933,inst_66934,null));
var inst_66936 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66935);
var inst_66937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66893,"_fn/spec");
var inst_66938 = cljs.core.PersistentVector.EMPTY;
var inst_66939 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_66940 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,inst_66922);
var inst_66941 = cljs.core.cons(inst_66939,inst_66940);
var inst_66942 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_66938,inst_66941);
var inst_66943 = ["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66942)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66932),")"].join('');
var inst_66944 = fluree.db.dbfunctions.core.parse_string(inst_66943);
var inst_66945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66946 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66944], 0));
var inst_66947 = ["Found custom db fn:",inst_66946];
var inst_66948 = (new cljs.core.PersistentVector(null,2,(5),inst_66945,inst_66947,null));
var inst_66949 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66948);
var inst_66950 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_66951 = cljs.core.count(inst_66922);
var inst_66952 = [inst_66951];
var inst_66953 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_66952);
var inst_66954 = [inst_66944,inst_66922,inst_66953,false,inst_66937,null];
var inst_66955 = cljs.core.PersistentHashMap.fromArrays(inst_66950,inst_66954);
var _ = (function (){var statearr_66984 = state_66960;
(statearr_66984[(4)] = cljs.core.rest((state_66960[(4)])));

return statearr_66984;
})();
var state_66960__$1 = (function (){var statearr_66985 = state_66960;
(statearr_66985[(14)] = inst_66949);

(statearr_66985[(15)] = inst_66936);

return statearr_66985;
})();
var statearr_66986_67009 = state_66960__$1;
(statearr_66986_67009[(2)] = inst_66955);

(statearr_66986_67009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (10))){
var state_66960__$1 = state_66960;
var statearr_66987_67010 = state_66960__$1;
(statearr_66987_67010[(2)] = null);

(statearr_66987_67010[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66961 === (8))){
var state_66960__$1 = state_66960;
var statearr_66988_67011 = state_66960__$1;
(statearr_66988_67011[(2)] = null);

(statearr_66988_67011[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2727__auto____0 = (function (){
var statearr_66989 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66989[(0)] = fluree$db$dbfunctions$core$state_machine__2727__auto__);

(statearr_66989[(1)] = (1));

return statearr_66989;
});
var fluree$db$dbfunctions$core$state_machine__2727__auto____1 = (function (state_66960){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66960);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66990){var ex__2730__auto__ = e66990;
var statearr_66991_67012 = state_66960;
(statearr_66991_67012[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66960[(4)]))){
var statearr_66992_67013 = state_66960;
(statearr_66992_67013[(1)] = cljs.core.first((state_66960[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67014 = state_66960;
state_66960 = G__67014;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2727__auto__ = function(state_66960){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2727__auto____1.call(this,state_66960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2727__auto____0;
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66993 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66993[(6)] = c__2749__auto__);

return statearr_66993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$lang$maxFixedArity = 3);

/**
 * Is the symbol sym valid with the given form type & params?
 */
fluree.db.dbfunctions.core.valid_symbol_QMARK_ = (function fluree$db$dbfunctions$core$valid_symbol_QMARK_(type,params,sym){
var or__4253__auto__ = (fluree.db.dbfunctions.core.allowed_symbols.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.allowed_symbols.cljs$core$IFn$_invoke$arity$1(sym) : fluree.db.dbfunctions.core.allowed_symbols.call(null,sym));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = (function (){var fexpr__67015 = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,params));
return (fexpr__67015.cljs$core$IFn$_invoke$arity$1 ? fexpr__67015.cljs$core$IFn$_invoke$arity$1(sym) : fexpr__67015.call(null,sym));
})();
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
}
}
});
/**
 * Resolves local or custom db-stored fn from fn-name string
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(db,fn_name,type){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67035){
var state_val_67036 = (state_67035[(1)]);
if((state_val_67036 === (7))){
var inst_67025 = fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,type);
var state_67035__$1 = state_67035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67035__$1,(9),inst_67025);
} else {
if((state_val_67036 === (1))){
var state_67035__$1 = state_67035;
var statearr_67037_67056 = state_67035__$1;
(statearr_67037_67056[(2)] = null);

(statearr_67037_67056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67036 === (4))){
var inst_67016 = (state_67035[(2)]);
var state_67035__$1 = state_67035;
var statearr_67038_67057 = state_67035__$1;
(statearr_67038_67057[(2)] = inst_67016);

(statearr_67038_67057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67036 === (6))){
var inst_67022 = (state_67035[(7)]);
var state_67035__$1 = state_67035;
var statearr_67039_67058 = state_67035__$1;
(statearr_67039_67058[(2)] = inst_67022);

(statearr_67039_67058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67036 === (3))){
var inst_67033 = (state_67035[(2)]);
var state_67035__$1 = state_67035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67035__$1,inst_67033);
} else {
if((state_val_67036 === (2))){
var inst_67022 = (state_67035[(7)]);
var _ = (function (){var statearr_67041 = state_67035;
(statearr_67041[(4)] = cljs.core.cons((5),(state_67035[(4)])));

return statearr_67041;
})();
var inst_67022__$1 = fluree.db.dbfunctions.core.find_local_fn(fn_name);
var state_67035__$1 = (function (){var statearr_67042 = state_67035;
(statearr_67042[(7)] = inst_67022__$1);

return statearr_67042;
})();
if(cljs.core.truth_(inst_67022__$1)){
var statearr_67043_67059 = state_67035__$1;
(statearr_67043_67059[(1)] = (6));

} else {
var statearr_67044_67060 = state_67035__$1;
(statearr_67044_67060[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67036 === (9))){
var inst_67027 = (state_67035[(2)]);
var inst_67028 = fluree.db.util.async.throw_err(inst_67027);
var state_67035__$1 = state_67035;
var statearr_67045_67061 = state_67035__$1;
(statearr_67045_67061[(2)] = inst_67028);

(statearr_67045_67061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67036 === (5))){
var _ = (function (){var statearr_67046 = state_67035;
(statearr_67046[(4)] = cljs.core.rest((state_67035[(4)])));

return statearr_67046;
})();
var state_67035__$1 = state_67035;
var ex67040 = (state_67035__$1[(2)]);
var statearr_67047_67062 = state_67035__$1;
(statearr_67047_67062[(5)] = ex67040);


if((ex67040 instanceof Error)){
var statearr_67048_67063 = state_67035__$1;
(statearr_67048_67063[(1)] = (4));

(statearr_67048_67063[(5)] = null);

} else {
throw ex67040;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67036 === (8))){
var inst_67030 = (state_67035[(2)]);
var _ = (function (){var statearr_67049 = state_67035;
(statearr_67049[(4)] = cljs.core.rest((state_67035[(4)])));

return statearr_67049;
})();
var state_67035__$1 = state_67035;
var statearr_67050_67064 = state_67035__$1;
(statearr_67050_67064[(2)] = inst_67030);

(statearr_67050_67064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_67051 = [null,null,null,null,null,null,null,null];
(statearr_67051[(0)] = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__);

(statearr_67051[(1)] = (1));

return statearr_67051;
});
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____1 = (function (state_67035){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67035);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67052){var ex__2730__auto__ = e67052;
var statearr_67053_67065 = state_67035;
(statearr_67053_67065[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67035[(4)]))){
var statearr_67054_67066 = state_67035;
(statearr_67054_67066[(1)] = cljs.core.first((state_67035[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67067 = state_67035;
state_67035 = G__67067;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__ = function(state_67035){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____1.call(this,state_67035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67055 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67055[(6)] = c__2749__auto__);

return statearr_67055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.core.validate_form = (function fluree$db$dbfunctions$core$validate_form(var_args){
var G__67070 = arguments.length;
switch (G__67070) {
case 2:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67205){
var state_val_67206 = (state_67205[(1)]);
if((state_val_67206 === (7))){
var state_67205__$1 = state_67205;
var statearr_67207_67271 = state_67205__$1;
(statearr_67207_67271[(2)] = null);

(statearr_67207_67271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (20))){
var inst_67182 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
var statearr_67208_67272 = state_67205__$1;
(statearr_67208_67272[(2)] = inst_67182);

(statearr_67208_67272[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (27))){
var inst_67171 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
var statearr_67209_67273 = state_67205__$1;
(statearr_67209_67273[(2)] = inst_67171);

(statearr_67209_67273[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (1))){
var state_67205__$1 = state_67205;
var statearr_67210_67274 = state_67205__$1;
(statearr_67210_67274[(2)] = null);

(statearr_67210_67274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (24))){
var inst_67141 = (state_67205[(2)]);
var inst_67142 = fluree.db.util.async.throw_err(inst_67141);
var state_67205__$1 = state_67205;
var statearr_67211_67275 = state_67205__$1;
(statearr_67211_67275[(2)] = inst_67142);

(statearr_67211_67275[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (4))){
var inst_67071 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
var statearr_67212_67276 = state_67205__$1;
(statearr_67212_67276[(2)] = inst_67071);

(statearr_67212_67276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (15))){
var inst_67097 = (state_67205[(2)]);
var inst_67098 = fluree.db.util.async.throw_err(inst_67097);
var state_67205__$1 = state_67205;
var statearr_67213_67277 = state_67205__$1;
(statearr_67213_67277[(2)] = inst_67098);

(statearr_67213_67277[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (21))){
var inst_67126 = (state_67205[(7)]);
var inst_67139 = fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_67126,type,params);
var state_67205__$1 = state_67205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67205__$1,(24),inst_67139);
} else {
if((state_val_67206 === (31))){
var inst_67127 = (state_67205[(8)]);
var inst_67174 = (state_67205[(9)]);
var inst_67119 = inst_67127;
var inst_67120 = inst_67174;
var state_67205__$1 = (function (){var statearr_67214 = state_67205;
(statearr_67214[(10)] = inst_67120);

(statearr_67214[(11)] = inst_67119);

return statearr_67214;
})();
var statearr_67215_67278 = state_67205__$1;
(statearr_67215_67278[(2)] = null);

(statearr_67215_67278[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (32))){
var inst_67174 = (state_67205[(9)]);
var state_67205__$1 = state_67205;
var statearr_67216_67279 = state_67205__$1;
(statearr_67216_67279[(2)] = inst_67174);

(statearr_67216_67279[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (33))){
var inst_67180 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
var statearr_67217_67280 = state_67205__$1;
(statearr_67217_67280[(2)] = inst_67180);

(statearr_67217_67280[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (13))){
var state_67205__$1 = state_67205;
var statearr_67218_67281 = state_67205__$1;
(statearr_67218_67281[(2)] = null);

(statearr_67218_67281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (22))){
var inst_67126 = (state_67205[(7)]);
var inst_67144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67145 = [cljs.core.string_QMARK_,cljs.core.number_QMARK_,cljs.core.true_QMARK_,cljs.core.false_QMARK_,cljs.core.nil_QMARK_];
var inst_67146 = (new cljs.core.PersistentVector(null,5,(5),inst_67144,inst_67145,null));
var inst_67147 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_67146);
var inst_67148 = (inst_67147.cljs$core$IFn$_invoke$arity$1 ? inst_67147.cljs$core$IFn$_invoke$arity$1(inst_67126) : inst_67147.call(null,inst_67126));
var state_67205__$1 = state_67205;
if(cljs.core.truth_(inst_67148)){
var statearr_67219_67282 = state_67205__$1;
(statearr_67219_67282[(1)] = (25));

} else {
var statearr_67220_67283 = state_67205__$1;
(statearr_67220_67283[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (36))){
var inst_67200 = (state_67205[(2)]);
var _ = (function (){var statearr_67221 = state_67205;
(statearr_67221[(4)] = cljs.core.rest((state_67205[(4)])));

return statearr_67221;
})();
var state_67205__$1 = state_67205;
var statearr_67222_67284 = state_67205__$1;
(statearr_67222_67284[(2)] = inst_67200);

(statearr_67222_67284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (29))){
var inst_67126 = (state_67205[(7)]);
var inst_67159 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67126], 0));
var inst_67160 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_67126) : type.call(null,inst_67126));
var inst_67161 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_67162 = ["Invalid element (",inst_67159,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67160),") in form: ",inst_67161,"."].join('');
var inst_67163 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67164 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_67165 = cljs.core.PersistentHashMap.fromArrays(inst_67163,inst_67164);
var inst_67166 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67162,inst_67165);
var inst_67167 = (function(){throw inst_67166})();
var state_67205__$1 = state_67205;
var statearr_67223_67285 = state_67205__$1;
(statearr_67223_67285[(2)] = inst_67167);

(statearr_67223_67285[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (6))){
var inst_67084 = cljs.core.first(form);
var state_67205__$1 = state_67205;
var statearr_67224_67286 = state_67205__$1;
(statearr_67224_67286[(2)] = inst_67084);

(statearr_67224_67286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (28))){
var inst_67126 = (state_67205[(7)]);
var state_67205__$1 = state_67205;
var statearr_67225_67287 = state_67205__$1;
(statearr_67225_67287[(2)] = inst_67126);

(statearr_67225_67287[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (25))){
var inst_67126 = (state_67205[(7)]);
var state_67205__$1 = state_67205;
var statearr_67226_67288 = state_67205__$1;
(statearr_67226_67288[(2)] = inst_67126);

(statearr_67226_67288[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (34))){
var inst_67185 = (state_67205[(12)]);
var inst_67103 = (state_67205[(13)]);
var inst_67187 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_67188 = cljs.core.cons(inst_67187,inst_67185);
var inst_67189 = cljs.core.cons(inst_67103,inst_67188);
var inst_67190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67191 = ["Validated fn form:",inst_67189];
var inst_67192 = (new cljs.core.PersistentVector(null,2,(5),inst_67190,inst_67191,null));
var inst_67193 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_67192);
var state_67205__$1 = (function (){var statearr_67227 = state_67205;
(statearr_67227[(14)] = inst_67193);

return statearr_67227;
})();
var statearr_67228_67289 = state_67205__$1;
(statearr_67228_67289[(2)] = inst_67189);

(statearr_67228_67289[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (17))){
var state_67205__$1 = state_67205;
var statearr_67229_67290 = state_67205__$1;
(statearr_67229_67290[(2)] = null);

(statearr_67229_67290[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (3))){
var inst_67203 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67205__$1,inst_67203);
} else {
if((state_val_67206 === (12))){
var inst_67087 = (state_67205[(15)]);
var inst_67095 = fluree.db.dbfunctions.core.resolve_fn(db,inst_67087,type);
var state_67205__$1 = state_67205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67205__$1,(15),inst_67095);
} else {
if((state_val_67206 === (2))){
var _ = (function (){var statearr_67230 = state_67205;
(statearr_67230[(4)] = cljs.core.cons((5),(state_67205[(4)])));

return statearr_67230;
})();
var inst_67077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67078 = ["Validating form:",form,"- params:",params];
var inst_67079 = (new cljs.core.PersistentVector(null,4,(5),inst_67077,inst_67078,null));
var inst_67080 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_67079);
var inst_67082 = cljs.core.list_QMARK_(form);
var state_67205__$1 = (function (){var statearr_67231 = state_67205;
(statearr_67231[(16)] = inst_67080);

return statearr_67231;
})();
if(inst_67082){
var statearr_67232_67291 = state_67205__$1;
(statearr_67232_67291[(1)] = (6));

} else {
var statearr_67233_67292 = state_67205__$1;
(statearr_67233_67292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (23))){
var inst_67127 = (state_67205[(8)]);
var inst_67120 = (state_67205[(10)]);
var inst_67173 = (state_67205[(2)]);
var inst_67174 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_67120,inst_67173);
var inst_67175 = cljs.core.seq(inst_67127);
var state_67205__$1 = (function (){var statearr_67234 = state_67205;
(statearr_67234[(9)] = inst_67174);

return statearr_67234;
})();
if(inst_67175){
var statearr_67235_67293 = state_67205__$1;
(statearr_67235_67293[(1)] = (31));

} else {
var statearr_67236_67294 = state_67205__$1;
(statearr_67236_67294[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (35))){
var inst_67195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67196 = ["Validated non-fn form:",form];
var inst_67197 = (new cljs.core.PersistentVector(null,2,(5),inst_67195,inst_67196,null));
var inst_67198 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_67197);
var state_67205__$1 = (function (){var statearr_67237 = state_67205;
(statearr_67237[(17)] = inst_67198);

return statearr_67237;
})();
var statearr_67238_67295 = state_67205__$1;
(statearr_67238_67295[(2)] = form);

(statearr_67238_67295[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (19))){
var inst_67126 = (state_67205[(7)]);
var inst_67119 = (state_67205[(11)]);
var inst_67125 = cljs.core.seq(inst_67119);
var inst_67126__$1 = cljs.core.first(inst_67125);
var inst_67127 = cljs.core.next(inst_67125);
var inst_67128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67129 = ["Validating arg:",inst_67126__$1];
var inst_67130 = (new cljs.core.PersistentVector(null,2,(5),inst_67128,inst_67129,null));
var inst_67131 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_67130);
var inst_67133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67134 = [cljs.core.list_QMARK_,cljs.core.vector_QMARK_];
var inst_67135 = (new cljs.core.PersistentVector(null,2,(5),inst_67133,inst_67134,null));
var inst_67136 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_67135);
var inst_67137 = (inst_67136.cljs$core$IFn$_invoke$arity$1 ? inst_67136.cljs$core$IFn$_invoke$arity$1(inst_67126__$1) : inst_67136.call(null,inst_67126__$1));
var state_67205__$1 = (function (){var statearr_67239 = state_67205;
(statearr_67239[(8)] = inst_67127);

(statearr_67239[(18)] = inst_67131);

(statearr_67239[(7)] = inst_67126__$1);

return statearr_67239;
})();
if(cljs.core.truth_(inst_67137)){
var statearr_67240_67296 = state_67205__$1;
(statearr_67240_67296[(1)] = (21));

} else {
var statearr_67241_67297 = state_67205__$1;
(statearr_67241_67297[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (11))){
var inst_67092 = (state_67205[(19)]);
var inst_67087 = (state_67205[(15)]);
var inst_67092__$1 = (state_67205[(2)]);
var inst_67093 = cljs.core.count(inst_67092__$1);
var state_67205__$1 = (function (){var statearr_67243 = state_67205;
(statearr_67243[(20)] = inst_67093);

(statearr_67243[(19)] = inst_67092__$1);

return statearr_67243;
})();
if(cljs.core.truth_(inst_67087)){
var statearr_67244_67298 = state_67205__$1;
(statearr_67244_67298[(1)] = (12));

} else {
var statearr_67245_67299 = state_67205__$1;
(statearr_67245_67299[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (9))){
var inst_67089 = cljs.core.rest(form);
var state_67205__$1 = state_67205;
var statearr_67246_67300 = state_67205__$1;
(statearr_67246_67300[(2)] = inst_67089);

(statearr_67246_67300[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (5))){
var _ = (function (){var statearr_67247 = state_67205;
(statearr_67247[(4)] = cljs.core.rest((state_67205[(4)])));

return statearr_67247;
})();
var state_67205__$1 = state_67205;
var ex67242 = (state_67205__$1[(2)]);
var statearr_67248_67301 = state_67205__$1;
(statearr_67248_67301[(5)] = ex67242);


if((ex67242 instanceof Error)){
var statearr_67249_67302 = state_67205__$1;
(statearr_67249_67302[(1)] = (4));

(statearr_67249_67302[(5)] = null);

} else {
throw ex67242;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (14))){
var inst_67092 = (state_67205[(19)]);
var inst_67102 = (state_67205[(21)]);
var inst_67101 = (state_67205[(22)]);
var inst_67101__$1 = (state_67205[(2)]);
var inst_67102__$1 = cljs.core.__destructure_map(inst_67101__$1);
var inst_67103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67102__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_67104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67102__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_67105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67102__$1,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710));
var inst_67106 = cljs.core.seq(inst_67092);
var state_67205__$1 = (function (){var statearr_67250 = state_67205;
(statearr_67250[(21)] = inst_67102__$1);

(statearr_67250[(23)] = inst_67104);

(statearr_67250[(24)] = inst_67105);

(statearr_67250[(13)] = inst_67103);

(statearr_67250[(22)] = inst_67101__$1);

return statearr_67250;
})();
if(inst_67106){
var statearr_67251_67303 = state_67205__$1;
(statearr_67251_67303[(1)] = (16));

} else {
var statearr_67252_67304 = state_67205__$1;
(statearr_67252_67304[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (26))){
var inst_67127 = (state_67205[(8)]);
var inst_67093 = (state_67205[(20)]);
var inst_67092 = (state_67205[(19)]);
var inst_67102 = (state_67205[(21)]);
var inst_67087 = (state_67205[(15)]);
var inst_67120 = (state_67205[(10)]);
var inst_67117 = (state_67205[(25)]);
var inst_67104 = (state_67205[(23)]);
var inst_67105 = (state_67205[(24)]);
var inst_67126 = (state_67205[(7)]);
var inst_67103 = (state_67205[(13)]);
var inst_67116 = (state_67205[(26)]);
var inst_67101 = (state_67205[(22)]);
var inst_67119 = (state_67205[(11)]);
var inst_67151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67152 = (function (){var arity = inst_67104;
var expr__67132 = inst_67126;
var first__67114 = inst_67116;
var args_n = inst_67093;
var fn_map = inst_67101;
var vec__67112 = inst_67092;
var G__67111 = inst_67119;
var args = inst_67092;
var r = inst_67127;
var vec__67122 = inst_67119;
var first__67124 = inst_67126;
var acc = inst_67120;
var seq__67113 = inst_67117;
var var_args_QMARK_ = inst_67105;
var fn_name = inst_67087;
var seq__67123 = inst_67127;
var arg = inst_67126;
var map__67081 = inst_67102;
var f = inst_67103;
return (function (p1__67068_SHARP_){
var and__4251__auto__ = (p1__67068_SHARP_ instanceof cljs.core.Symbol);
if(and__4251__auto__){
return fluree.db.dbfunctions.core.valid_symbol_QMARK_(type,params,p1__67068_SHARP_);
} else {
return and__4251__auto__;
}
});
})();
var inst_67153 = [inst_67152];
var inst_67154 = (new cljs.core.PersistentVector(null,1,(5),inst_67151,inst_67153,null));
var inst_67155 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_67154);
var inst_67156 = (inst_67155.cljs$core$IFn$_invoke$arity$1 ? inst_67155.cljs$core$IFn$_invoke$arity$1(inst_67126) : inst_67155.call(null,inst_67126));
var state_67205__$1 = state_67205;
if(cljs.core.truth_(inst_67156)){
var statearr_67253_67305 = state_67205__$1;
(statearr_67253_67305[(1)] = (28));

} else {
var statearr_67254_67306 = state_67205__$1;
(statearr_67254_67306[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (16))){
var inst_67092 = (state_67205[(19)]);
var inst_67115 = cljs.core.seq(inst_67092);
var inst_67116 = cljs.core.first(inst_67115);
var inst_67117 = cljs.core.next(inst_67115);
var inst_67118 = cljs.core.PersistentVector.EMPTY;
var inst_67119 = inst_67092;
var inst_67120 = inst_67118;
var state_67205__$1 = (function (){var statearr_67255 = state_67205;
(statearr_67255[(10)] = inst_67120);

(statearr_67255[(25)] = inst_67117);

(statearr_67255[(26)] = inst_67116);

(statearr_67255[(11)] = inst_67119);

return statearr_67255;
})();
var statearr_67256_67307 = state_67205__$1;
(statearr_67256_67307[(2)] = null);

(statearr_67256_67307[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (30))){
var inst_67169 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
var statearr_67257_67308 = state_67205__$1;
(statearr_67257_67308[(2)] = inst_67169);

(statearr_67257_67308[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (10))){
var state_67205__$1 = state_67205;
var statearr_67258_67309 = state_67205__$1;
(statearr_67258_67309[(2)] = form);

(statearr_67258_67309[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (18))){
var inst_67087 = (state_67205[(15)]);
var inst_67185 = (state_67205[(2)]);
var state_67205__$1 = (function (){var statearr_67259 = state_67205;
(statearr_67259[(12)] = inst_67185);

return statearr_67259;
})();
if(cljs.core.truth_(inst_67087)){
var statearr_67260_67310 = state_67205__$1;
(statearr_67260_67310[(1)] = (34));

} else {
var statearr_67261_67311 = state_67205__$1;
(statearr_67261_67311[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67206 === (8))){
var inst_67087 = (state_67205[(15)]);
var inst_67087__$1 = (state_67205[(2)]);
var state_67205__$1 = (function (){var statearr_67262 = state_67205;
(statearr_67262[(15)] = inst_67087__$1);

return statearr_67262;
})();
if(cljs.core.truth_(inst_67087__$1)){
var statearr_67263_67312 = state_67205__$1;
(statearr_67263_67312[(1)] = (9));

} else {
var statearr_67264_67313 = state_67205__$1;
(statearr_67264_67313[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2727__auto____0 = (function (){
var statearr_67265 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67265[(0)] = fluree$db$dbfunctions$core$state_machine__2727__auto__);

(statearr_67265[(1)] = (1));

return statearr_67265;
});
var fluree$db$dbfunctions$core$state_machine__2727__auto____1 = (function (state_67205){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67205);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67266){var ex__2730__auto__ = e67266;
var statearr_67267_67314 = state_67205;
(statearr_67267_67314[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67205[(4)]))){
var statearr_67268_67315 = state_67205;
(statearr_67268_67315[(1)] = cljs.core.first((state_67205[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67316 = state_67205;
state_67205 = G__67316;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2727__auto__ = function(state_67205){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2727__auto____1.call(this,state_67205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2727__auto____0;
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67269 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67269[(6)] = c__2749__auto__);

return statearr_67269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.core.validate_form.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(db,fn_str,type,params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67352){
var state_val_67353 = (state_67352[(1)]);
if((state_val_67353 === (7))){
var inst_67323 = ["(fn [_] ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str),")"].join('');
var inst_67324 = fluree.db.dbfunctions.core.parse_string(inst_67323);
var state_67352__$1 = state_67352;
var statearr_67354_67378 = state_67352__$1;
(statearr_67354_67378[(2)] = inst_67324);

(statearr_67354_67378[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (1))){
var state_67352__$1 = state_67352;
var statearr_67355_67379 = state_67352__$1;
(statearr_67355_67379[(2)] = null);

(statearr_67355_67379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (4))){
var inst_67317 = (state_67352[(2)]);
var state_67352__$1 = state_67352;
var statearr_67356_67380 = state_67352__$1;
(statearr_67356_67380[(2)] = inst_67317);

(statearr_67356_67380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (6))){
var inst_67347 = (state_67352[(2)]);
var _ = (function (){var statearr_67357 = state_67352;
(statearr_67357[(4)] = cljs.core.rest((state_67352[(4)])));

return statearr_67357;
})();
var state_67352__$1 = state_67352;
var statearr_67358_67381 = state_67352__$1;
(statearr_67358_67381[(2)] = inst_67347);

(statearr_67358_67381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (3))){
var inst_67350 = (state_67352[(2)]);
var state_67352__$1 = state_67352;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67352__$1,inst_67350);
} else {
if((state_val_67353 === (12))){
var inst_67331 = (state_67352[(2)]);
var inst_67332 = fluree.db.util.async.throw_err(inst_67331);
var inst_67333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67334 = ["Parsed & validated db fn:",inst_67332];
var inst_67335 = (new cljs.core.PersistentVector(null,2,(5),inst_67333,inst_67334,null));
var inst_67336 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_67335);
var state_67352__$1 = (function (){var statearr_67359 = state_67352;
(statearr_67359[(7)] = inst_67336);

return statearr_67359;
})();
var statearr_67360_67382 = state_67352__$1;
(statearr_67360_67382[(2)] = inst_67332);

(statearr_67360_67382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (2))){
var _ = (function (){var statearr_67361 = state_67352;
(statearr_67361[(4)] = cljs.core.cons((5),(state_67352[(4)])));

return statearr_67361;
})();
var state_67352__$1 = state_67352;
var G__67362_67383 = fn_str;
switch (G__67362_67383) {
case "true":
case "false":
var statearr_67363_67385 = state_67352__$1;
(statearr_67363_67385[(1)] = (7));


break;
default:
var statearr_67364_67386 = state_67352__$1;
(statearr_67364_67386[(1)] = (8));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (11))){
var inst_67344 = (state_67352[(2)]);
var state_67352__$1 = state_67352;
var statearr_67366_67387 = state_67352__$1;
(statearr_67366_67387[(2)] = inst_67344);

(statearr_67366_67387[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (9))){
var inst_67328 = fluree.db.dbfunctions.core.parse_string(fn_str);
var inst_67329 = fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_67328,type,params);
var state_67352__$1 = state_67352;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67352__$1,(12),inst_67329);
} else {
if((state_val_67353 === (5))){
var _ = (function (){var statearr_67367 = state_67352;
(statearr_67367[(4)] = cljs.core.rest((state_67352[(4)])));

return statearr_67367;
})();
var state_67352__$1 = state_67352;
var ex67365 = (state_67352__$1[(2)]);
var statearr_67368_67388 = state_67352__$1;
(statearr_67368_67388[(5)] = ex67365);


if((ex67365 instanceof Error)){
var statearr_67369_67389 = state_67352__$1;
(statearr_67369_67389[(1)] = (4));

(statearr_67369_67389[(5)] = null);

} else {
throw ex67365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (10))){
var inst_67338 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67339 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_67340 = cljs.core.PersistentHashMap.fromArrays(inst_67338,inst_67339);
var inst_67341 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_67340);
var inst_67342 = (function(){throw inst_67341})();
var state_67352__$1 = state_67352;
var statearr_67370_67390 = state_67352__$1;
(statearr_67370_67390[(2)] = inst_67342);

(statearr_67370_67390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67353 === (8))){
var inst_67326 = cljs.core.re_matches(/^\(.+\)$/,fn_str);
var state_67352__$1 = state_67352;
if(cljs.core.truth_(inst_67326)){
var statearr_67371_67391 = state_67352__$1;
(statearr_67371_67391[(1)] = (9));

} else {
var statearr_67372_67392 = state_67352__$1;
(statearr_67372_67392[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_67373 = [null,null,null,null,null,null,null,null];
(statearr_67373[(0)] = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__);

(statearr_67373[(1)] = (1));

return statearr_67373;
});
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____1 = (function (state_67352){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67352);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67374){var ex__2730__auto__ = e67374;
var statearr_67375_67393 = state_67352;
(statearr_67375_67393[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67352[(4)]))){
var statearr_67376_67394 = state_67352;
(statearr_67376_67394[(1)] = cljs.core.first((state_67352[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67395 = state_67352;
state_67352 = G__67395;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__ = function(state_67352){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____1.call(this,state_67352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67377 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67377[(6)] = c__2749__auto__);

return statearr_67377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.core.parse_and_wrap_fn = (function fluree$db$dbfunctions$core$parse_and_wrap_fn(var_args){
var G__67397 = arguments.length;
switch (G__67397) {
case 3:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67440){
var state_val_67441 = (state_67440[(1)]);
if((state_val_67441 === (7))){
var inst_67423 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_67440__$1 = state_67440;
var statearr_67442_67466 = state_67440__$1;
(statearr_67442_67466[(2)] = inst_67423);

(statearr_67442_67466[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (1))){
var state_67440__$1 = state_67440;
var statearr_67443_67467 = state_67440__$1;
(statearr_67443_67467[(2)] = null);

(statearr_67443_67467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (4))){
var inst_67398 = (state_67440[(2)]);
var state_67440__$1 = state_67440;
var statearr_67444_67468 = state_67440__$1;
(statearr_67444_67468[(2)] = inst_67398);

(statearr_67444_67468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (6))){
var inst_67421 = (state_67440[(7)]);
var inst_67406 = (state_67440[(2)]);
var inst_67407 = fluree.db.util.async.throw_err(inst_67406);
var inst_67408 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_67409 = (new cljs.core.List(null,inst_67408,null,(1),null));
var inst_67410 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_67411 = (new cljs.core.List(null,inst_67410,null,(1),null));
var inst_67412 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_67411);
var inst_67413 = cljs.core.seq(inst_67412);
var inst_67414 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_67413);
var inst_67415 = cljs.core.vec(inst_67414);
var inst_67416 = (new cljs.core.List(null,inst_67415,null,(1),null));
var inst_67417 = (new cljs.core.List(null,inst_67407,null,(1),null));
var inst_67418 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_67409,inst_67416,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67417], 0));
var inst_67419 = cljs.core.seq(inst_67418);
var inst_67420 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_67419);
var inst_67421__$1 = params;
var state_67440__$1 = (function (){var statearr_67445 = state_67440;
(statearr_67445[(8)] = inst_67420);

(statearr_67445[(7)] = inst_67421__$1);

return statearr_67445;
})();
if(cljs.core.truth_(inst_67421__$1)){
var statearr_67446_67469 = state_67440__$1;
(statearr_67446_67469[(1)] = (7));

} else {
var statearr_67447_67470 = state_67440__$1;
(statearr_67447_67470[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (3))){
var inst_67438 = (state_67440[(2)]);
var state_67440__$1 = state_67440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67440__$1,inst_67438);
} else {
if((state_val_67441 === (12))){
var inst_67431 = (state_67440[(2)]);
var inst_67432 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_67433 = [fn_str];
var inst_67434 = cljs.core.PersistentHashMap.fromArrays(inst_67432,inst_67433);
var inst_67435 = cljs.core.with_meta(inst_67431,inst_67434);
var _ = (function (){var statearr_67448 = state_67440;
(statearr_67448[(4)] = cljs.core.rest((state_67440[(4)])));

return statearr_67448;
})();
var state_67440__$1 = state_67440;
var statearr_67449_67471 = state_67440__$1;
(statearr_67449_67471[(2)] = inst_67435);

(statearr_67449_67471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (2))){
var _ = (function (){var statearr_67450 = state_67440;
(statearr_67450[(4)] = cljs.core.cons((5),(state_67440[(4)])));

return statearr_67450;
})();
var inst_67404 = fluree.db.dbfunctions.core.parse_fn(db,fn_str,type,params);
var state_67440__$1 = state_67440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67440__$1,(6),inst_67404);
} else {
if((state_val_67441 === (11))){
var inst_67420 = (state_67440[(8)]);
var inst_67429 = fluree.db.dbfunctions.core.eval_form(inst_67420);
var state_67440__$1 = state_67440;
var statearr_67452_67472 = state_67440__$1;
(statearr_67452_67472[(2)] = inst_67429);

(statearr_67452_67472[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (9))){
var inst_67426 = (state_67440[(2)]);
var state_67440__$1 = state_67440;
if(cljs.core.truth_(inst_67426)){
var statearr_67453_67473 = state_67440__$1;
(statearr_67453_67473[(1)] = (10));

} else {
var statearr_67454_67474 = state_67440__$1;
(statearr_67454_67474[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (5))){
var _ = (function (){var statearr_67455 = state_67440;
(statearr_67455[(4)] = cljs.core.rest((state_67440[(4)])));

return statearr_67455;
})();
var state_67440__$1 = state_67440;
var ex67451 = (state_67440__$1[(2)]);
var statearr_67456_67475 = state_67440__$1;
(statearr_67456_67475[(5)] = ex67451);


if((ex67451 instanceof Error)){
var statearr_67457_67476 = state_67440__$1;
(statearr_67457_67476[(1)] = (4));

(statearr_67457_67476[(5)] = null);

} else {
throw ex67451;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (10))){
var inst_67420 = (state_67440[(8)]);
var state_67440__$1 = state_67440;
var statearr_67458_67477 = state_67440__$1;
(statearr_67458_67477[(2)] = inst_67420);

(statearr_67458_67477[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67441 === (8))){
var inst_67421 = (state_67440[(7)]);
var state_67440__$1 = state_67440;
var statearr_67459_67478 = state_67440__$1;
(statearr_67459_67478[(2)] = inst_67421);

(statearr_67459_67478[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2727__auto____0 = (function (){
var statearr_67460 = [null,null,null,null,null,null,null,null,null];
(statearr_67460[(0)] = fluree$db$dbfunctions$core$state_machine__2727__auto__);

(statearr_67460[(1)] = (1));

return statearr_67460;
});
var fluree$db$dbfunctions$core$state_machine__2727__auto____1 = (function (state_67440){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67440);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67461){var ex__2730__auto__ = e67461;
var statearr_67462_67479 = state_67440;
(statearr_67462_67479[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67440[(4)]))){
var statearr_67463_67480 = state_67440;
(statearr_67463_67480[(1)] = cljs.core.first((state_67440[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67481 = state_67440;
state_67440 = G__67481;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2727__auto__ = function(state_67440){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2727__auto____1.call(this,state_67440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2727__auto____0;
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67464 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67464[(6)] = c__2749__auto__);

return statearr_67464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(p__67482){
var map__67483 = p__67482;
var map__67483__$1 = cljs.core.__destructure_map(map__67483);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"db","db",993250759));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var _credits = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"_credits","_credits",1245712171));
var s = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var block_instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67483__$1,new cljs.core.Keyword(null,"block-instant","block-instant",-641639021));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67517){
var state_val_67518 = (state_67517[(1)]);
if((state_val_67518 === (7))){
var inst_67504 = (state_67517[(7)]);
var state_67517__$1 = state_67517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67517__$1,(10),inst_67504);
} else {
if((state_val_67518 === (1))){
var state_67517__$1 = state_67517;
var statearr_67519_67539 = state_67517__$1;
(statearr_67519_67539[(2)] = null);

(statearr_67519_67539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67518 === (4))){
var inst_67484 = (state_67517[(2)]);
var state_67517__$1 = state_67517;
var statearr_67520_67540 = state_67517__$1;
(statearr_67520_67540[(2)] = inst_67484);

(statearr_67520_67540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67518 === (6))){
var inst_67493 = (state_67517[(8)]);
var inst_67504 = (state_67517[(7)]);
var inst_67496 = (state_67517[(2)]);
var inst_67497 = fluree.db.util.async.throw_err(inst_67496);
var inst_67498 = (new cljs.core.List(null,inst_67493,null,(1),null));
var inst_67499 = (new cljs.core.List(null,inst_67497,inst_67498,(2),null));
var inst_67500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67501 = ["Evaluating fn call:",inst_67499];
var inst_67502 = (new cljs.core.PersistentVector(null,2,(5),inst_67500,inst_67501,null));
var inst_67503 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_67502);
var inst_67504__$1 = fluree.db.dbfunctions.core.eval_form(inst_67499);
var inst_67505 = fluree.db.util.async.channel_QMARK_(inst_67504__$1);
var state_67517__$1 = (function (){var statearr_67521 = state_67517;
(statearr_67521[(9)] = inst_67503);

(statearr_67521[(7)] = inst_67504__$1);

return statearr_67521;
})();
if(inst_67505){
var statearr_67522_67541 = state_67517__$1;
(statearr_67522_67541[(1)] = (7));

} else {
var statearr_67523_67542 = state_67517__$1;
(statearr_67523_67542[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67518 === (3))){
var inst_67515 = (state_67517[(2)]);
var state_67517__$1 = state_67517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67517__$1,inst_67515);
} else {
if((state_val_67518 === (2))){
var _ = (function (){var statearr_67525 = state_67517;
(statearr_67525[(4)] = cljs.core.cons((5),(state_67517[(4)])));

return statearr_67525;
})();
var inst_67490 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_67491 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_67492 = [db,block_instant,s,p,auth,fuel];
var inst_67493 = cljs.core.PersistentHashMap.fromArrays(inst_67491,inst_67492);
var inst_67494 = fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3(db,inst_67490,"txn");
var state_67517__$1 = (function (){var statearr_67526 = state_67517;
(statearr_67526[(8)] = inst_67493);

return statearr_67526;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67517__$1,(6),inst_67494);
} else {
if((state_val_67518 === (9))){
var inst_67512 = (state_67517[(2)]);
var _ = (function (){var statearr_67527 = state_67517;
(statearr_67527[(4)] = cljs.core.rest((state_67517[(4)])));

return statearr_67527;
})();
var state_67517__$1 = state_67517;
var statearr_67528_67543 = state_67517__$1;
(statearr_67528_67543[(2)] = inst_67512);

(statearr_67528_67543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67518 === (5))){
var _ = (function (){var statearr_67529 = state_67517;
(statearr_67529[(4)] = cljs.core.rest((state_67517[(4)])));

return statearr_67529;
})();
var state_67517__$1 = state_67517;
var ex67524 = (state_67517__$1[(2)]);
var statearr_67530_67544 = state_67517__$1;
(statearr_67530_67544[(5)] = ex67524);


if((ex67524 instanceof Error)){
var statearr_67531_67545 = state_67517__$1;
(statearr_67531_67545[(1)] = (4));

(statearr_67531_67545[(5)] = null);

} else {
throw ex67524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67518 === (10))){
var inst_67508 = (state_67517[(2)]);
var inst_67509 = fluree.db.util.async.throw_err(inst_67508);
var state_67517__$1 = state_67517;
var statearr_67532_67546 = state_67517__$1;
(statearr_67532_67546[(2)] = inst_67509);

(statearr_67532_67546[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67518 === (8))){
var inst_67504 = (state_67517[(7)]);
var state_67517__$1 = state_67517;
var statearr_67533_67547 = state_67517__$1;
(statearr_67533_67547[(2)] = inst_67504);

(statearr_67533_67547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_67534 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67534[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__);

(statearr_67534[(1)] = (1));

return statearr_67534;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____1 = (function (state_67517){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67517);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67535){var ex__2730__auto__ = e67535;
var statearr_67536_67548 = state_67517;
(statearr_67536_67548[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67517[(4)]))){
var statearr_67537_67549 = state_67517;
(statearr_67537_67549[(1)] = cljs.core.first((state_67517[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67550 = state_67517;
state_67517 = G__67550;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__ = function(state_67517){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____1.call(this,state_67517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67538 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67538[(6)] = c__2749__auto__);

return statearr_67538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
