// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbproto');
goog.require('cljs.core');

/**
 * @interface
 */
fluree.db.dbproto.IFlureeDb = function(){};

var fluree$db$dbproto$IFlureeDb$_latest_db$dyn_13321 = (function (db){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._latest_db[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4551__auto__.call(null,db));
} else {
var m__4549__auto__ = (fluree.db.dbproto._latest_db["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4549__auto__.call(null,db));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-latest-db",db);
}
}
});
/**
 * Updates a db to the most current version of the db known to this server. Maintains existing permissions
 */
fluree.db.dbproto._latest_db = (function fluree$db$dbproto$_latest_db(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_latest_db$dyn_13321(db);
}
});

var fluree$db$dbproto$IFlureeDb$_rootdb$dyn_13322 = (function (db){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._rootdb[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4551__auto__.call(null,db));
} else {
var m__4549__auto__ = (fluree.db.dbproto._rootdb["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4549__auto__.call(null,db));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-rootdb",db);
}
}
});
/**
 * Returns root db version of this db.
 */
fluree.db.dbproto._rootdb = (function fluree$db$dbproto$_rootdb(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_rootdb$dyn_13322(db);
}
});

var fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13323 = (function() {
var G__13324 = null;
var G__13324__2 = (function (db,flakes){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4551__auto__.call(null,db,flakes));
} else {
var m__4549__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4549__auto__.call(null,db,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-forward-time-travel",db);
}
}
});
var G__13324__3 = (function (db,tt_id,flakes){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes) : m__4551__auto__.call(null,db,tt_id,flakes));
} else {
var m__4549__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes) : m__4549__auto__.call(null,db,tt_id,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-forward-time-travel",db);
}
}
});
G__13324 = function(db,tt_id,flakes){
switch(arguments.length){
case 2:
return G__13324__2.call(this,db,tt_id);
case 3:
return G__13324__3.call(this,db,tt_id,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13324.cljs$core$IFn$_invoke$arity$2 = G__13324__2;
G__13324.cljs$core$IFn$_invoke$arity$3 = G__13324__3;
return G__13324;
})()
;
fluree.db.dbproto._forward_time_travel = (function fluree$db$dbproto$_forward_time_travel(var_args){
var G__13308 = arguments.length;
switch (G__13308) {
case 2:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13323.cljs$core$IFn$_invoke$arity$2(db,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3 = (function (db,tt_id,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3(db,tt_id,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13323.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_c_prop$dyn_13326 = (function (db,property,collection){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._c_prop[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,property,collection) : m__4551__auto__.call(null,db,property,collection));
} else {
var m__4549__auto__ = (fluree.db.dbproto._c_prop["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,property,collection) : m__4549__auto__.call(null,db,property,collection));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-c-prop",db);
}
}
});
/**
 * Returns schema property for a collection.
 */
fluree.db.dbproto._c_prop = (function fluree$db$dbproto$_c_prop(db,property,collection){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(db,property,collection);
} else {
return fluree$db$dbproto$IFlureeDb$_c_prop$dyn_13326(db,property,collection);
}
});

var fluree$db$dbproto$IFlureeDb$_p_prop$dyn_13327 = (function (db,property,predicate){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._p_prop[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,property,predicate) : m__4551__auto__.call(null,db,property,predicate));
} else {
var m__4549__auto__ = (fluree.db.dbproto._p_prop["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,property,predicate) : m__4549__auto__.call(null,db,property,predicate));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-p-prop",db);
}
}
});
/**
 * Returns the property specified for the given predicate.
 */
fluree.db.dbproto._p_prop = (function fluree$db$dbproto$_p_prop(db,property,predicate){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(db,property,predicate);
} else {
return fluree$db$dbproto$IFlureeDb$_p_prop$dyn_13327(db,property,predicate);
}
});

var fluree$db$dbproto$IFlureeDb$_tag$dyn_13328 = (function() {
var G__13329 = null;
var G__13329__2 = (function (db,tag_id){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_id) : m__4551__auto__.call(null,db,tag_id));
} else {
var m__4549__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_id) : m__4549__auto__.call(null,db,tag_id));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag",db);
}
}
});
var G__13329__3 = (function (db,tag_id,pred){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred) : m__4551__auto__.call(null,db,tag_id,pred));
} else {
var m__4549__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred) : m__4549__auto__.call(null,db,tag_id,pred));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag",db);
}
}
});
G__13329 = function(db,tag_id,pred){
switch(arguments.length){
case 2:
return G__13329__2.call(this,db,tag_id);
case 3:
return G__13329__3.call(this,db,tag_id,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13329.cljs$core$IFn$_invoke$arity$2 = G__13329__2;
G__13329.cljs$core$IFn$_invoke$arity$3 = G__13329__3;
return G__13329;
})()
;
/**
 * Returns resolved tag, shortens namespace if pred provided.
 */
fluree.db.dbproto._tag = (function fluree$db$dbproto$_tag(var_args){
var G__13310 = arguments.length;
switch (G__13310) {
case 2:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$2(db,tag_id);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_13328.cljs$core$IFn$_invoke$arity$2(db,tag_id);
}
}));

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_id,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$3(db,tag_id,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_13328.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred);
}
}));

(fluree.db.dbproto._tag.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13331 = (function() {
var G__13332 = null;
var G__13332__2 = (function (db,tag_name){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_name) : m__4551__auto__.call(null,db,tag_name));
} else {
var m__4549__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_name) : m__4549__auto__.call(null,db,tag_name));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag-id",db);
}
}
});
var G__13332__3 = (function (db,tag_name,pred){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred) : m__4551__auto__.call(null,db,tag_name,pred));
} else {
var m__4549__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred) : m__4549__auto__.call(null,db,tag_name,pred));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag-id",db);
}
}
});
G__13332 = function(db,tag_name,pred){
switch(arguments.length){
case 2:
return G__13332__2.call(this,db,tag_name);
case 3:
return G__13332__3.call(this,db,tag_name,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13332.cljs$core$IFn$_invoke$arity$2 = G__13332__2;
G__13332.cljs$core$IFn$_invoke$arity$3 = G__13332__3;
return G__13332;
})()
;
/**
 * Returns the tag sid. If pred provided will namespace tag if not already.
 */
fluree.db.dbproto._tag_id = (function fluree$db$dbproto$_tag_id(var_args){
var G__13312 = arguments.length;
switch (G__13312) {
case 2:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_name){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(db,tag_name);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13331.cljs$core$IFn$_invoke$arity$2(db,tag_name);
}
}));

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_name,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3(db,tag_name,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13331.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred);
}
}));

(fluree.db.dbproto._tag_id.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_subid$dyn_13334 = (function() {
var G__13335 = null;
var G__13335__2 = (function (db,ident){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,ident) : m__4551__auto__.call(null,db,ident));
} else {
var m__4549__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,ident) : m__4549__auto__.call(null,db,ident));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-subid",db);
}
}
});
var G__13335__3 = (function (db,ident,strict_QMARK_){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_) : m__4551__auto__.call(null,db,ident,strict_QMARK_));
} else {
var m__4549__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_) : m__4549__auto__.call(null,db,ident,strict_QMARK_));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-subid",db);
}
}
});
G__13335 = function(db,ident,strict_QMARK_){
switch(arguments.length){
case 2:
return G__13335__2.call(this,db,ident);
case 3:
return G__13335__3.call(this,db,ident,strict_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13335.cljs$core$IFn$_invoke$arity$2 = G__13335__2;
G__13335.cljs$core$IFn$_invoke$arity$3 = G__13335__3;
return G__13335;
})()
;
/**
 * Returns subject ID if exists, else nil
 */
fluree.db.dbproto._subid = (function fluree$db$dbproto$_subid(var_args){
var G__13314 = arguments.length;
switch (G__13314) {
case 2:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2 = (function (db,ident){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$2(db,ident);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_13334.cljs$core$IFn$_invoke$arity$2(db,ident);
}
}));

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3 = (function (db,ident,strict_QMARK_){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$3(db,ident,strict_QMARK_);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_13334.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_);
}
}));

(fluree.db.dbproto._subid.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_search$dyn_13337 = (function (db,fparts){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._search[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,fparts) : m__4551__auto__.call(null,db,fparts));
} else {
var m__4549__auto__ = (fluree.db.dbproto._search["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,fparts) : m__4549__auto__.call(null,db,fparts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-search",db);
}
}
});
/**
 * Performs a slice, but determines best index to use.
 */
fluree.db.dbproto._search = (function fluree$db$dbproto$_search(db,fparts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_search$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_search$arity$2(db,fparts);
} else {
return fluree$db$dbproto$IFlureeDb$_search$dyn_13337(db,fparts);
}
});

var fluree$db$dbproto$IFlureeDb$_query$dyn_13338 = (function() {
var G__13339 = null;
var G__13339__2 = (function (db,query){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,query) : m__4551__auto__.call(null,db,query));
} else {
var m__4549__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,query) : m__4549__auto__.call(null,db,query));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-query",db);
}
}
});
var G__13339__3 = (function (db,query,opts){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,query,opts) : m__4551__auto__.call(null,db,query,opts));
} else {
var m__4549__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,query,opts) : m__4549__auto__.call(null,db,query,opts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-query",db);
}
}
});
G__13339 = function(db,query,opts){
switch(arguments.length){
case 2:
return G__13339__2.call(this,db,query);
case 3:
return G__13339__3.call(this,db,query,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13339.cljs$core$IFn$_invoke$arity$2 = G__13339__2;
G__13339.cljs$core$IFn$_invoke$arity$3 = G__13339__3;
return G__13339;
})()
;
/**
 * Performs a query.
 */
fluree.db.dbproto._query = (function fluree$db$dbproto$_query(var_args){
var G__13316 = arguments.length;
switch (G__13316) {
case 2:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2 = (function (db,query){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$2(db,query);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_13338.cljs$core$IFn$_invoke$arity$2(db,query);
}
}));

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3 = (function (db,query,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$3(db,query,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_13338.cljs$core$IFn$_invoke$arity$3(db,query,opts);
}
}));

(fluree.db.dbproto._query.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_with$dyn_13341 = (function() {
var G__13342 = null;
var G__13342__3 = (function (db,block,flakes){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._with[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,block,flakes) : m__4551__auto__.call(null,db,block,flakes));
} else {
var m__4549__auto__ = (fluree.db.dbproto._with["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,block,flakes) : m__4549__auto__.call(null,db,block,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with",db);
}
}
});
var G__13342__4 = (function (db,block,flakes,opts){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._with[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(db,block,flakes,opts) : m__4551__auto__.call(null,db,block,flakes,opts));
} else {
var m__4549__auto__ = (fluree.db.dbproto._with["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(db,block,flakes,opts) : m__4549__auto__.call(null,db,block,flakes,opts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with",db);
}
}
});
G__13342 = function(db,block,flakes,opts){
switch(arguments.length){
case 3:
return G__13342__3.call(this,db,block,flakes);
case 4:
return G__13342__4.call(this,db,block,flakes,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13342.cljs$core$IFn$_invoke$arity$3 = G__13342__3;
G__13342.cljs$core$IFn$_invoke$arity$4 = G__13342__4;
return G__13342;
})()
;
/**
 * Applies flakes to this db as a new block with possibly multiple 't' transactions.
 */
fluree.db.dbproto._with = (function fluree$db$dbproto$_with(var_args){
var G__13318 = arguments.length;
switch (G__13318) {
case 3:
return fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with$arity$3(db,block,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with$dyn_13341.cljs$core$IFn$_invoke$arity$3(db,block,flakes);
}
}));

(fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with$arity$4 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with$arity$4(db,block,flakes,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_with$dyn_13341.cljs$core$IFn$_invoke$arity$4(db,block,flakes,opts);
}
}));

(fluree.db.dbproto._with.cljs$lang$maxFixedArity = 4);


var fluree$db$dbproto$IFlureeDb$_with_t$dyn_13344 = (function() {
var G__13345 = null;
var G__13345__2 = (function (db,flakes){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._with_t[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4551__auto__.call(null,db,flakes));
} else {
var m__4549__auto__ = (fluree.db.dbproto._with_t["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4549__auto__.call(null,db,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with-t",db);
}
}
});
var G__13345__3 = (function (db,flakes,opts){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._with_t[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(db,flakes,opts) : m__4551__auto__.call(null,db,flakes,opts));
} else {
var m__4549__auto__ = (fluree.db.dbproto._with_t["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(db,flakes,opts) : m__4549__auto__.call(null,db,flakes,opts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with-t",db);
}
}
});
G__13345 = function(db,flakes,opts){
switch(arguments.length){
case 2:
return G__13345__2.call(this,db,flakes);
case 3:
return G__13345__3.call(this,db,flakes,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13345.cljs$core$IFn$_invoke$arity$2 = G__13345__2;
G__13345.cljs$core$IFn$_invoke$arity$3 = G__13345__3;
return G__13345;
})()
;
/**
 * Applies flakes to this db as a new 't', but retains current block.
 */
fluree.db.dbproto._with_t = (function fluree$db$dbproto$_with_t(var_args){
var G__13320 = arguments.length;
switch (G__13320) {
case 2:
return fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with_t$dyn_13344.cljs$core$IFn$_invoke$arity$2(db,flakes);
}
}));

(fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with_t$arity$3(db,flakes,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_with_t$dyn_13344.cljs$core$IFn$_invoke$arity$3(db,flakes,opts);
}
}));

(fluree.db.dbproto._with_t.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_13347 = (function (db,pred_id){
var x__4550__auto__ = (((db == null))?null:db);
var m__4551__auto__ = (fluree.db.dbproto._add_predicate_to_idx[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(db,pred_id) : m__4551__auto__.call(null,db,pred_id));
} else {
var m__4549__auto__ = (fluree.db.dbproto._add_predicate_to_idx["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(db,pred_id) : m__4549__auto__.call(null,db,pred_id));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-add-predicate-to-idx",db);
}
}
});
/**
 * Adds predicate to idx, return updated db.
 */
fluree.db.dbproto._add_predicate_to_idx = (function fluree$db$dbproto$_add_predicate_to_idx(db,pred_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2(db,pred_id);
} else {
return fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_13347(db,pred_id);
}
});

fluree.db.dbproto.db_QMARK_ = (function fluree$db$dbproto$db_QMARK_(db){
if((!((db == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === db.fluree$db$dbproto$IFlureeDb$)))){
return true;
} else {
if((!db.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(fluree.db.dbproto.IFlureeDb,db);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(fluree.db.dbproto.IFlureeDb,db);
}
});
