// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__24929 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24929,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24929,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24929,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_(fluree.db.graphdb.exclude_predicates,fluree.db.flake.p(f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement(fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__24932){
var map__24933 = p__24932;
var map__24933__$1 = cljs.core.__destructure_map(map__24933);
var opts = map__24933__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24933__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24993){
var state_val_24994 = (state_24993[(1)]);
if((state_val_24994 === (7))){
var inst_24964 = cljs.core.not(reindex_QMARK_);
var state_24993__$1 = state_24993;
var statearr_24995_25019 = state_24993__$1;
(statearr_24995_25019[(2)] = inst_24964);

(statearr_24995_25019[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (1))){
var state_24993__$1 = state_24993;
var statearr_24996_25020 = state_24993__$1;
(statearr_24996_25020[(2)] = null);

(statearr_24996_25020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (4))){
var inst_24934 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
var statearr_24997_25021 = state_24993__$1;
(statearr_24997_25021[(2)] = inst_24934);

(statearr_24997_25021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (6))){
var inst_24962 = (state_24993[(7)]);
var inst_24948 = (state_24993[(8)]);
var inst_24954 = (state_24993[(9)]);
var inst_24947 = (state_24993[(2)]);
var inst_24948__$1 = fluree.db.util.async.throw_err(inst_24947);
var inst_24949 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_24950 = cljs.core.__destructure_map(inst_24949);
var inst_24951 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24950,new cljs.core.Keyword(null,"post","post",269697687));
var inst_24952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24950,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_24953 = fluree.db.flake.size_bytes(inst_24948__$1);
var inst_24954__$1 = (inst_24952 + inst_24953);
var inst_24955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24956 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_24957 = (new cljs.core.PersistentVector(null,2,(5),inst_24955,inst_24956,null));
var inst_24958 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_24957);
var inst_24959 = cljs.core.__destructure_map(inst_24958);
var inst_24960 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24959,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_24961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24959,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_24962__$1 = (inst_24954__$1 > inst_24961);
var state_24993__$1 = (function (){var statearr_24998 = state_24993;
(statearr_24998[(7)] = inst_24962__$1);

(statearr_24998[(8)] = inst_24948__$1);

(statearr_24998[(10)] = inst_24951);

(statearr_24998[(11)] = inst_24960);

(statearr_24998[(9)] = inst_24954__$1);

return statearr_24998;
})();
if(cljs.core.truth_(inst_24962__$1)){
var statearr_24999_25022 = state_24993__$1;
(statearr_24999_25022[(1)] = (7));

} else {
var statearr_25000_25023 = state_24993__$1;
(statearr_25000_25023[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (3))){
var inst_24991 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24993__$1,inst_24991);
} else {
if((state_val_24994 === (12))){
var inst_24948 = (state_24993[(8)]);
var inst_24951 = (state_24993[(10)]);
var inst_24954 = (state_24993[(9)]);
var inst_24977 = (state_24993[(2)]);
var inst_24978 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24951,inst_24948);
var inst_24979 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_24980 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24979,cljs.core.empty);
var inst_24981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24982 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_24983 = (new cljs.core.PersistentVector(null,2,(5),inst_24981,inst_24982,null));
var inst_24984 = cljs.core.assoc_in(db,inst_24983,inst_24978);
var inst_24985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24986 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_24987 = (new cljs.core.PersistentVector(null,2,(5),inst_24985,inst_24986,null));
var inst_24988 = cljs.core.assoc_in(inst_24984,inst_24987,inst_24954);
var _ = (function (){var statearr_25001 = state_24993;
(statearr_25001[(4)] = cljs.core.rest((state_24993[(4)])));

return statearr_25001;
})();
var state_24993__$1 = (function (){var statearr_25002 = state_24993;
(statearr_25002[(12)] = inst_24977);

(statearr_25002[(13)] = inst_24980);

return statearr_25002;
})();
var statearr_25003_25024 = state_24993__$1;
(statearr_25003_25024[(2)] = inst_24988);

(statearr_25003_25024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (2))){
var _ = (function (){var statearr_25004 = state_24993;
(statearr_25004[(4)] = cljs.core.cons((5),(state_24993[(4)])));

return statearr_25004;
})();
var inst_24942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24943 = [pred_id];
var inst_24944 = (new cljs.core.PersistentVector(null,1,(5),inst_24942,inst_24943,null));
var inst_24945 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_24944);
var state_24993__$1 = state_24993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24993__$1,(6),inst_24945);
} else {
if((state_val_24994 === (11))){
var state_24993__$1 = state_24993;
var statearr_25006_25025 = state_24993__$1;
(statearr_25006_25025[(2)] = null);

(statearr_25006_25025[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (9))){
var inst_24967 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
if(cljs.core.truth_(inst_24967)){
var statearr_25007_25026 = state_24993__$1;
(statearr_25007_25026[(1)] = (10));

} else {
var statearr_25008_25027 = state_24993__$1;
(statearr_25008_25027[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (5))){
var _ = (function (){var statearr_25009 = state_24993;
(statearr_25009[(4)] = cljs.core.rest((state_24993[(4)])));

return statearr_25009;
})();
var state_24993__$1 = state_24993;
var ex25005 = (state_24993__$1[(2)]);
var statearr_25010_25028 = state_24993__$1;
(statearr_25010_25028[(5)] = ex25005);


if((ex25005 instanceof Error)){
var statearr_25011_25029 = state_24993__$1;
(statearr_25011_25029[(1)] = (4));

(statearr_25011_25029[(5)] = null);

} else {
throw ex25005;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (10))){
var inst_24969 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_24970 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24971 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_24972 = cljs.core.PersistentHashMap.fromArrays(inst_24970,inst_24971);
var inst_24973 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24969,inst_24972);
var inst_24974 = (function(){throw inst_24973})();
var state_24993__$1 = state_24993;
var statearr_25012_25030 = state_24993__$1;
(statearr_25012_25030[(2)] = inst_24974);

(statearr_25012_25030[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (8))){
var inst_24962 = (state_24993[(7)]);
var state_24993__$1 = state_24993;
var statearr_25013_25031 = state_24993__$1;
(statearr_25013_25031[(2)] = inst_24962);

(statearr_25013_25031[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0 = (function (){
var statearr_25014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25014[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__);

(statearr_25014[(1)] = (1));

return statearr_25014;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1 = (function (state_24993){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24993);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25015){var ex__2730__auto__ = e25015;
var statearr_25016_25032 = state_24993;
(statearr_25016_25032[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24993[(4)]))){
var statearr_25017_25033 = state_24993;
(statearr_25017_25033[(1)] = cljs.core.first((state_24993[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25034 = state_24993;
state_24993 = G__25034;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__ = function(state_24993){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1.call(this,state_24993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25018 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25018[(6)] = c__2749__auto__);

return statearr_25018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25037 = arguments.length;
switch (G__25037) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25237){
var state_val_25238 = (state_25237[(1)]);
if((state_val_25238 === (7))){
var state_25237__$1 = state_25237;
var statearr_25239_25306 = state_25237__$1;
(statearr_25239_25306[(2)] = null);

(statearr_25239_25306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (20))){
var inst_25159 = (state_25237[(7)]);
var inst_25160 = (state_25237[(8)]);
var inst_25124 = (state_25237[(9)]);
var inst_25162 = (state_25237[(10)]);
var inst_25158 = (state_25237[(11)]);
var inst_25074 = (state_25237[(12)]);
var inst_25157 = (state_25237[(13)]);
var inst_25073 = (state_25237[(14)]);
var inst_25161 = (state_25237[(15)]);
var inst_25172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25173 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25174 = (new cljs.core.PersistentVector(null,2,(5),inst_25172,inst_25173,null));
var inst_25175 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25124,inst_25174);
var inst_25176 = (inst_25175 + inst_25073);
var inst_25177 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25178 = [inst_25157,inst_25158,inst_25159,inst_25160,inst_25161,inst_25176];
var inst_25179 = cljs.core.PersistentHashMap.fromArrays(inst_25177,inst_25178);
var inst_25180 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_25124,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25162,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_25179], 0));
var state_25237__$1 = (function (){var statearr_25240 = state_25237;
(statearr_25240[(16)] = inst_25180);

return statearr_25240;
})();
if(cljs.core.truth_(inst_25074)){
var statearr_25241_25307 = state_25237__$1;
(statearr_25241_25307[(1)] = (23));

} else {
var statearr_25242_25308 = state_25237__$1;
(statearr_25242_25308[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (27))){
var inst_25180 = (state_25237[(16)]);
var state_25237__$1 = state_25237;
var statearr_25243_25309 = state_25237__$1;
(statearr_25243_25309[(2)] = inst_25180);

(statearr_25243_25309[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (1))){
var state_25237__$1 = state_25237;
var statearr_25244_25310 = state_25237__$1;
(statearr_25244_25310[(2)] = null);

(statearr_25244_25310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (24))){
var inst_25180 = (state_25237[(16)]);
var inst_25184 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_25180);
var inst_25185 = (inst_25184 == null);
var state_25237__$1 = state_25237;
var statearr_25245_25311 = state_25237__$1;
(statearr_25245_25311[(2)] = inst_25185);

(statearr_25245_25311[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (39))){
var inst_25210 = (state_25237[(17)]);
var inst_25168 = (state_25237[(18)]);
var inst_25219 = (state_25237[(19)]);
var inst_25211 = (state_25237[(20)]);
var inst_25169 = (state_25237[(21)]);
var inst_25212 = (state_25237[(22)]);
var inst_25161 = (state_25237[(15)]);
var inst_25226 = (state_25237[(2)]);
var inst_25227 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25161,inst_25168);
var inst_25156 = inst_25169;
var inst_25157 = inst_25211;
var inst_25158 = inst_25212;
var inst_25159 = inst_25219;
var inst_25160 = inst_25226;
var inst_25161__$1 = inst_25227;
var inst_25162 = inst_25210;
var state_25237__$1 = (function (){var statearr_25246 = state_25237;
(statearr_25246[(7)] = inst_25159);

(statearr_25246[(8)] = inst_25160);

(statearr_25246[(10)] = inst_25162);

(statearr_25246[(23)] = inst_25156);

(statearr_25246[(11)] = inst_25158);

(statearr_25246[(13)] = inst_25157);

(statearr_25246[(15)] = inst_25161__$1);

return statearr_25246;
})();
var statearr_25247_25312 = state_25237__$1;
(statearr_25247_25312[(2)] = null);

(statearr_25247_25312[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (4))){
var inst_25038 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
var statearr_25248_25313 = state_25237__$1;
(statearr_25248_25313[(2)] = inst_25038);

(statearr_25248_25313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (15))){
var inst_25096 = (state_25237[(24)]);
var state_25237__$1 = state_25237;
var statearr_25249_25314 = state_25237__$1;
(statearr_25249_25314[(2)] = inst_25096);

(statearr_25249_25314[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (21))){
var inst_25159 = (state_25237[(7)]);
var inst_25160 = (state_25237[(8)]);
var inst_25124 = (state_25237[(9)]);
var inst_25162 = (state_25237[(10)]);
var inst_25156 = (state_25237[(23)]);
var inst_25168 = (state_25237[(18)]);
var inst_25158 = (state_25237[(11)]);
var inst_25074 = (state_25237[(12)]);
var inst_25133 = (state_25237[(25)]);
var inst_25064 = (state_25237[(26)]);
var inst_25157 = (state_25237[(13)]);
var inst_25083 = (state_25237[(27)]);
var inst_25068 = (state_25237[(28)]);
var inst_25072 = (state_25237[(29)]);
var inst_25060 = (state_25237[(30)]);
var inst_25073 = (state_25237[(14)]);
var inst_25075 = (state_25237[(31)]);
var inst_25077 = (state_25237[(32)]);
var inst_25134 = (state_25237[(33)]);
var inst_25169 = (state_25237[(21)]);
var inst_25061 = (state_25237[(34)]);
var inst_25045 = (state_25237[(35)]);
var inst_25161 = (state_25237[(15)]);
var inst_25207 = fluree.db.flake.s(inst_25168);
var inst_25208 = fluree.db.flake.sid__GT_cid(inst_25207);
var inst_25209 = (function (){var flakes_bytes = inst_25073;
var t = inst_25045;
var spot = inst_25157;
var add_flakes = inst_25061;
var G__25128 = inst_25156;
var root_setting_change_QMARK_ = inst_25075;
var vec__25129 = inst_25061;
var ref_QMARK__map = inst_25072;
var r = inst_25169;
var psot = inst_25158;
var first__25166 = inst_25168;
var add_pred_to_idx_QMARK_ = inst_25083;
var first__25131 = inst_25133;
var _ = inst_25060;
var tspo = inst_25161;
var cid = inst_25208;
var ecount = inst_25162;
var pred_ecount = inst_25077;
var db_STAR_ = inst_25124;
var system_change_QMARK_ = inst_25074;
var seq__25165 = inst_25169;
var add_preds = inst_25064;
var vec__25164 = inst_25156;
var opst = inst_25160;
var idx_QMARK__map = inst_25068;
var seq__25130 = inst_25134;
var post = inst_25159;
var f = inst_25168;
return (function (p1__25035_SHARP_){
if(cljs.core.truth_(p1__25035_SHARP_)){
var x__4336__auto__ = p1__25035_SHARP_;
var y__4337__auto__ = fluree.db.flake.s(f);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return fluree.db.flake.s(f);
}
});
})();
var inst_25210 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_25162,inst_25208,inst_25209);
var inst_25211 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25157,inst_25168);
var inst_25212 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25158,inst_25168);
var inst_25213 = fluree.db.flake.p(inst_25168);
var inst_25214 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25068,inst_25213);
var state_25237__$1 = (function (){var statearr_25250 = state_25237;
(statearr_25250[(17)] = inst_25210);

(statearr_25250[(20)] = inst_25211);

(statearr_25250[(22)] = inst_25212);

return statearr_25250;
})();
if(cljs.core.truth_(inst_25214)){
var statearr_25251_25315 = state_25237__$1;
(statearr_25251_25315[(1)] = (34));

} else {
var statearr_25252_25316 = state_25237__$1;
(statearr_25252_25316[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (31))){
var inst_25196 = (state_25237[(36)]);
var state_25237__$1 = state_25237;
var statearr_25253_25317 = state_25237__$1;
(statearr_25253_25317[(2)] = inst_25196);

(statearr_25253_25317[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (32))){
var inst_25205 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
var statearr_25254_25318 = state_25237__$1;
(statearr_25254_25318[(2)] = inst_25205);

(statearr_25254_25318[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (33))){
var inst_25196 = (state_25237[(36)]);
var inst_25200 = (state_25237[(2)]);
var inst_25201 = fluree.db.util.async.throw_err(inst_25200);
var inst_25202 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25196,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_25201);
var state_25237__$1 = state_25237;
var statearr_25255_25319 = state_25237__$1;
(statearr_25255_25319[(2)] = inst_25202);

(statearr_25255_25319[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (13))){
var inst_25124 = (state_25237[(9)]);
var inst_25073 = (state_25237[(14)]);
var inst_25061 = (state_25237[(34)]);
var inst_25045 = (state_25237[(35)]);
var inst_25114 = (state_25237[(2)]);
var inst_25115 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25114,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25045);
var inst_25116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25117 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25118 = (new cljs.core.PersistentVector(null,2,(5),inst_25116,inst_25117,null));
var inst_25119 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25115,inst_25118,cljs.core._PLUS_,inst_25073);
var inst_25120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25121 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25122 = (new cljs.core.PersistentVector(null,2,(5),inst_25120,inst_25121,null));
var inst_25123 = cljs.core.count(inst_25061);
var inst_25124__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_25119,inst_25122,cljs.core._PLUS_,inst_25123);
var inst_25132 = cljs.core.seq(inst_25061);
var inst_25133 = cljs.core.first(inst_25132);
var inst_25134 = cljs.core.next(inst_25132);
var inst_25135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25136 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25137 = (new cljs.core.PersistentVector(null,2,(5),inst_25135,inst_25136,null));
var inst_25138 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25124__$1,inst_25137);
var inst_25139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25140 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25141 = (new cljs.core.PersistentVector(null,2,(5),inst_25139,inst_25140,null));
var inst_25142 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25124__$1,inst_25141);
var inst_25143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25144 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25145 = (new cljs.core.PersistentVector(null,2,(5),inst_25143,inst_25144,null));
var inst_25146 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25124__$1,inst_25145);
var inst_25147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25148 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25149 = (new cljs.core.PersistentVector(null,2,(5),inst_25147,inst_25148,null));
var inst_25150 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25124__$1,inst_25149);
var inst_25151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25152 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25153 = (new cljs.core.PersistentVector(null,2,(5),inst_25151,inst_25152,null));
var inst_25154 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_25124__$1,inst_25153);
var inst_25155 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25156 = inst_25061;
var inst_25157 = inst_25138;
var inst_25158 = inst_25142;
var inst_25159 = inst_25146;
var inst_25160 = inst_25150;
var inst_25161 = inst_25154;
var inst_25162 = inst_25155;
var state_25237__$1 = (function (){var statearr_25256 = state_25237;
(statearr_25256[(7)] = inst_25159);

(statearr_25256[(8)] = inst_25160);

(statearr_25256[(9)] = inst_25124__$1);

(statearr_25256[(10)] = inst_25162);

(statearr_25256[(23)] = inst_25156);

(statearr_25256[(11)] = inst_25158);

(statearr_25256[(25)] = inst_25133);

(statearr_25256[(13)] = inst_25157);

(statearr_25256[(33)] = inst_25134);

(statearr_25256[(15)] = inst_25161);

return statearr_25256;
})();
var statearr_25257_25320 = state_25237__$1;
(statearr_25257_25320[(2)] = null);

(statearr_25257_25320[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (22))){
var inst_25230 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
var statearr_25258_25321 = state_25237__$1;
(statearr_25258_25321[(2)] = inst_25230);

(statearr_25258_25321[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (36))){
var inst_25168 = (state_25237[(18)]);
var inst_25072 = (state_25237[(29)]);
var inst_25219 = (state_25237[(2)]);
var inst_25220 = fluree.db.flake.p(inst_25168);
var inst_25221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25072,inst_25220);
var state_25237__$1 = (function (){var statearr_25259 = state_25237;
(statearr_25259[(19)] = inst_25219);

return statearr_25259;
})();
if(cljs.core.truth_(inst_25221)){
var statearr_25260_25322 = state_25237__$1;
(statearr_25260_25322[(1)] = (37));

} else {
var statearr_25261_25323 = state_25237__$1;
(statearr_25261_25323[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (29))){
var inst_25180 = (state_25237[(16)]);
var inst_25191 = (state_25237[(2)]);
var inst_25192 = fluree.db.util.async.throw_err(inst_25191);
var inst_25193 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25180,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_25192);
var state_25237__$1 = state_25237;
var statearr_25262_25324 = state_25237__$1;
(statearr_25262_25324[(2)] = inst_25193);

(statearr_25262_25324[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (6))){
var inst_25045 = (state_25237[(35)]);
var inst_25050 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25051 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25052 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25050)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25051)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25045),"."].join('');
var inst_25053 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25054 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25055 = cljs.core.PersistentHashMap.fromArrays(inst_25053,inst_25054);
var inst_25056 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25052,inst_25055);
var inst_25057 = (function(){throw inst_25056})();
var state_25237__$1 = state_25237;
var statearr_25263_25325 = state_25237__$1;
(statearr_25263_25325[(2)] = inst_25057);

(statearr_25263_25325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (28))){
var inst_25075 = (state_25237[(31)]);
var inst_25196 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25264 = state_25237;
(statearr_25264[(36)] = inst_25196);

return statearr_25264;
})();
if(cljs.core.truth_(inst_25075)){
var statearr_25265_25326 = state_25237__$1;
(statearr_25265_25326[(1)] = (30));

} else {
var statearr_25266_25327 = state_25237__$1;
(statearr_25266_25327[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (25))){
var inst_25187 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
if(cljs.core.truth_(inst_25187)){
var statearr_25267_25328 = state_25237__$1;
(statearr_25267_25328[(1)] = (26));

} else {
var statearr_25268_25329 = state_25237__$1;
(statearr_25268_25329[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (34))){
var inst_25159 = (state_25237[(7)]);
var inst_25168 = (state_25237[(18)]);
var inst_25216 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25159,inst_25168);
var state_25237__$1 = state_25237;
var statearr_25269_25330 = state_25237__$1;
(statearr_25269_25330[(2)] = inst_25216);

(statearr_25269_25330[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (17))){
var inst_25103 = (state_25237[(37)]);
var inst_25107 = (state_25237[(2)]);
var inst_25108 = fluree.db.util.async.throw_err(inst_25107);
var inst_25095 = inst_25103;
var inst_25096 = inst_25108;
var state_25237__$1 = (function (){var statearr_25270 = state_25237;
(statearr_25270[(38)] = inst_25095);

(statearr_25270[(24)] = inst_25096);

return statearr_25270;
})();
var statearr_25271_25331 = state_25237__$1;
(statearr_25271_25331[(2)] = null);

(statearr_25271_25331[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (3))){
var inst_25235 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25237__$1,inst_25235);
} else {
if((state_val_25238 === (12))){
var inst_25095 = (state_25237[(38)]);
var inst_25102 = (state_25237[(39)]);
var inst_25101 = cljs.core.seq(inst_25095);
var inst_25102__$1 = cljs.core.first(inst_25101);
var inst_25103 = cljs.core.next(inst_25101);
var state_25237__$1 = (function (){var statearr_25272 = state_25237;
(statearr_25272[(37)] = inst_25103);

(statearr_25272[(39)] = inst_25102__$1);

return statearr_25272;
})();
if(cljs.core.truth_(inst_25102__$1)){
var statearr_25273_25332 = state_25237__$1;
(statearr_25273_25332[(1)] = (14));

} else {
var statearr_25274_25333 = state_25237__$1;
(statearr_25274_25333[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (2))){
var inst_25045 = (state_25237[(35)]);
var _ = (function (){var statearr_25275 = state_25237;
(statearr_25275[(4)] = cljs.core.cons((5),(state_25237[(4)])));

return statearr_25275;
})();
var inst_25044 = cljs.core.first(flakes);
var inst_25045__$1 = fluree.db.flake.t(inst_25044);
var inst_25046 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25047 = (inst_25046 - (1));
var inst_25048 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_25045__$1,inst_25047);
var state_25237__$1 = (function (){var statearr_25276 = state_25237;
(statearr_25276[(35)] = inst_25045__$1);

return statearr_25276;
})();
if(inst_25048){
var statearr_25277_25334 = state_25237__$1;
(statearr_25277_25334[(1)] = (6));

} else {
var statearr_25278_25335 = state_25237__$1;
(statearr_25278_25335[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (23))){
var inst_25074 = (state_25237[(12)]);
var state_25237__$1 = state_25237;
var statearr_25279_25336 = state_25237__$1;
(statearr_25279_25336[(2)] = inst_25074);

(statearr_25279_25336[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (35))){
var inst_25159 = (state_25237[(7)]);
var state_25237__$1 = state_25237;
var statearr_25280_25337 = state_25237__$1;
(statearr_25280_25337[(2)] = inst_25159);

(statearr_25280_25337[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (19))){
var inst_25232 = (state_25237[(2)]);
var _ = (function (){var statearr_25281 = state_25237;
(statearr_25281[(4)] = cljs.core.rest((state_25237[(4)])));

return statearr_25281;
})();
var state_25237__$1 = state_25237;
var statearr_25282_25338 = state_25237__$1;
(statearr_25282_25338[(2)] = inst_25232);

(statearr_25282_25338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (11))){
var inst_25083 = (state_25237[(27)]);
var inst_25083__$1 = (state_25237[(2)]);
var inst_25091 = cljs.core.seq(inst_25083__$1);
var inst_25092 = cljs.core.first(inst_25091);
var inst_25093 = cljs.core.next(inst_25091);
var inst_25094 = db;
var inst_25095 = inst_25083__$1;
var inst_25096 = inst_25094;
var state_25237__$1 = (function (){var statearr_25284 = state_25237;
(statearr_25284[(40)] = inst_25092);

(statearr_25284[(27)] = inst_25083__$1);

(statearr_25284[(41)] = inst_25093);

(statearr_25284[(38)] = inst_25095);

(statearr_25284[(24)] = inst_25096);

return statearr_25284;
})();
var statearr_25285_25339 = state_25237__$1;
(statearr_25285_25339[(2)] = null);

(statearr_25285_25339[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (9))){
var inst_25077 = (state_25237[(32)]);
var inst_25061 = (state_25237[(34)]);
var inst_25079 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_25061,inst_25077);
var state_25237__$1 = state_25237;
var statearr_25286_25340 = state_25237__$1;
(statearr_25286_25340[(2)] = inst_25079);

(statearr_25286_25340[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (5))){
var _ = (function (){var statearr_25287 = state_25237;
(statearr_25287[(4)] = cljs.core.rest((state_25237[(4)])));

return statearr_25287;
})();
var state_25237__$1 = state_25237;
var ex25283 = (state_25237__$1[(2)]);
var statearr_25288_25341 = state_25237__$1;
(statearr_25288_25341[(5)] = ex25283);


if((ex25283 instanceof Error)){
var statearr_25289_25342 = state_25237__$1;
(statearr_25289_25342[(1)] = (4));

(statearr_25289_25342[(5)] = null);

} else {
throw ex25283;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (14))){
var inst_25102 = (state_25237[(39)]);
var inst_25096 = (state_25237[(24)]);
var inst_25105 = fluree.db.graphdb.add_predicate_to_idx(inst_25096,inst_25102,opts);
var state_25237__$1 = state_25237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25237__$1,(17),inst_25105);
} else {
if((state_val_25238 === (26))){
var inst_25180 = (state_25237[(16)]);
var inst_25189 = fluree.db.query.schema.schema_map(inst_25180);
var state_25237__$1 = state_25237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25237__$1,(29),inst_25189);
} else {
if((state_val_25238 === (16))){
var inst_25112 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
var statearr_25290_25343 = state_25237__$1;
(statearr_25290_25343[(2)] = inst_25112);

(statearr_25290_25343[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (38))){
var inst_25160 = (state_25237[(8)]);
var state_25237__$1 = state_25237;
var statearr_25291_25344 = state_25237__$1;
(statearr_25291_25344[(2)] = inst_25160);

(statearr_25291_25344[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (30))){
var inst_25180 = (state_25237[(16)]);
var inst_25198 = fluree.db.query.schema.setting_map(inst_25180);
var state_25237__$1 = state_25237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25237__$1,(33),inst_25198);
} else {
if((state_val_25238 === (10))){
var inst_25081 = cljs.core.PersistentVector.EMPTY;
var state_25237__$1 = state_25237;
var statearr_25292_25345 = state_25237__$1;
(statearr_25292_25345[(2)] = inst_25081);

(statearr_25292_25345[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (18))){
var inst_25156 = (state_25237[(23)]);
var inst_25168 = (state_25237[(18)]);
var inst_25167 = cljs.core.seq(inst_25156);
var inst_25168__$1 = cljs.core.first(inst_25167);
var inst_25169 = cljs.core.next(inst_25167);
var inst_25170 = cljs.core.not(inst_25168__$1);
var state_25237__$1 = (function (){var statearr_25293 = state_25237;
(statearr_25293[(18)] = inst_25168__$1);

(statearr_25293[(21)] = inst_25169);

return statearr_25293;
})();
if(inst_25170){
var statearr_25294_25346 = state_25237__$1;
(statearr_25294_25346[(1)] = (20));

} else {
var statearr_25295_25347 = state_25237__$1;
(statearr_25295_25347[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (37))){
var inst_25160 = (state_25237[(8)]);
var inst_25168 = (state_25237[(18)]);
var inst_25223 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25160,inst_25168);
var state_25237__$1 = state_25237;
var statearr_25296_25348 = state_25237__$1;
(statearr_25296_25348[(2)] = inst_25223);

(statearr_25296_25348[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (8))){
var inst_25074 = (state_25237[(12)]);
var inst_25064 = (state_25237[(26)]);
var inst_25068 = (state_25237[(28)]);
var inst_25060 = (state_25237[(30)]);
var inst_25061 = (state_25237[(34)]);
var inst_25045 = (state_25237[(35)]);
var inst_25060__$1 = (state_25237[(2)]);
var inst_25061__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25062 = cljs.core.PersistentHashSet.EMPTY;
var inst_25063 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,inst_25061__$1);
var inst_25064__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25062,inst_25063);
var inst_25065 = cljs.core.PersistentHashMap.EMPTY;
var inst_25066 = (function (){var t = inst_25045;
var _ = inst_25060__$1;
var add_flakes = inst_25061__$1;
var add_preds = inst_25064__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25067 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25066,inst_25064__$1);
var inst_25068__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25065,inst_25067);
var inst_25069 = cljs.core.PersistentHashMap.EMPTY;
var inst_25070 = (function (){var t = inst_25045;
var _ = inst_25060__$1;
var add_flakes = inst_25061__$1;
var add_preds = inst_25064__$1;
var idx_QMARK__map = inst_25068__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25071 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25070,inst_25064__$1);
var inst_25072 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25069,inst_25071);
var inst_25073 = fluree.db.flake.size_bytes(inst_25061__$1);
var inst_25074__$1 = fluree.db.util.schema.system_change_QMARK_(inst_25061__$1);
var inst_25075 = fluree.db.util.schema.setting_change_QMARK_(inst_25061__$1);
var inst_25076 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25076,(0));
var state_25237__$1 = (function (){var statearr_25297 = state_25237;
(statearr_25297[(12)] = inst_25074__$1);

(statearr_25297[(26)] = inst_25064__$1);

(statearr_25297[(28)] = inst_25068__$1);

(statearr_25297[(29)] = inst_25072);

(statearr_25297[(30)] = inst_25060__$1);

(statearr_25297[(14)] = inst_25073);

(statearr_25297[(31)] = inst_25075);

(statearr_25297[(32)] = inst_25077);

(statearr_25297[(34)] = inst_25061__$1);

return statearr_25297;
})();
if(cljs.core.truth_(inst_25074__$1)){
var statearr_25298_25349 = state_25237__$1;
(statearr_25298_25349[(1)] = (9));

} else {
var statearr_25299_25350 = state_25237__$1;
(statearr_25299_25350[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25300 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25300[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25300[(1)] = (1));

return statearr_25300;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25237){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25237);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25301){var ex__2730__auto__ = e25301;
var statearr_25302_25351 = state_25237;
(statearr_25302_25351[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25237[(4)]))){
var statearr_25303_25352 = state_25237;
(statearr_25303_25352[(1)] = cljs.core.first((state_25237[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25353 = state_25237;
state_25237 = G__25353;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25237){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25304 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25304[(6)] = c__2749__auto__);

return statearr_25304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__25355 = arguments.length;
switch (G__25355) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___25502 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25451){
var state_val_25452 = (state_25451[(1)]);
if((state_val_25452 === (7))){
var state_25451__$1 = state_25451;
var statearr_25453_25503 = state_25451__$1;
(statearr_25453_25503[(2)] = null);

(statearr_25453_25503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (20))){
var inst_25399 = (state_25451[(7)]);
var inst_25400 = (state_25451[(8)]);
var inst_25401 = (state_25451[(9)]);
var inst_25420 = (inst_25399 + (1));
var inst_25421 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25401,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25420);
var inst_25422 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_25421,inst_25400,opts);
var state_25451__$1 = state_25451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25451__$1,(23),inst_25422);
} else {
if((state_val_25452 === (1))){
var state_25451__$1 = state_25451;
var statearr_25454_25504 = state_25451__$1;
(statearr_25454_25504[(2)] = null);

(statearr_25454_25504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (24))){
var inst_25425 = (state_25451[(10)]);
var inst_25428 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25425,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_25451__$1 = state_25451;
var statearr_25455_25505 = state_25451__$1;
(statearr_25455_25505[(2)] = inst_25428);

(statearr_25455_25505[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (4))){
var inst_25356 = (state_25451[(2)]);
var inst_25357 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_25356);
var state_25451__$1 = state_25451;
var statearr_25456_25506 = state_25451__$1;
(statearr_25456_25506[(2)] = inst_25357);

(statearr_25456_25506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (15))){
var inst_25407 = (state_25451[(11)]);
var state_25451__$1 = state_25451;
var statearr_25457_25507 = state_25451__$1;
(statearr_25457_25507[(2)] = inst_25407);

(statearr_25457_25507[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (21))){
var state_25451__$1 = state_25451;
var statearr_25458_25508 = state_25451__$1;
(statearr_25458_25508[(2)] = null);

(statearr_25458_25508[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (13))){
var inst_25443 = (state_25451[(2)]);
var inst_25444 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_25443);
var state_25451__$1 = state_25451;
var statearr_25459_25509 = state_25451__$1;
(statearr_25459_25509[(2)] = inst_25444);

(statearr_25459_25509[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (22))){
var inst_25439 = (state_25451[(2)]);
var state_25451__$1 = state_25451;
var statearr_25460_25510 = state_25451__$1;
(statearr_25460_25510[(2)] = inst_25439);

(statearr_25460_25510[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (6))){
var inst_25367 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25368 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25369 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25367)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25368)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_25370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25371 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25372 = cljs.core.PersistentHashMap.fromArrays(inst_25370,inst_25371);
var inst_25373 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25369,inst_25372);
var inst_25374 = (function(){throw inst_25373})();
var state_25451__$1 = state_25451;
var statearr_25463_25511 = state_25451__$1;
(statearr_25463_25511[(2)] = inst_25374);

(statearr_25463_25511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (25))){
var inst_25425 = (state_25451[(10)]);
var inst_25408 = (state_25451[(12)]);
var inst_25407 = (state_25451[(11)]);
var inst_25430 = fluree.db.flake.t(inst_25407);
var inst_25431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25432 = [inst_25407];
var inst_25433 = (new cljs.core.PersistentVector(null,1,(5),inst_25431,inst_25432,null));
var inst_25398 = inst_25408;
var inst_25399 = inst_25430;
var inst_25400 = inst_25433;
var inst_25401 = inst_25425;
var state_25451__$1 = (function (){var statearr_25464 = state_25451;
(statearr_25464[(7)] = inst_25399);

(statearr_25464[(8)] = inst_25400);

(statearr_25464[(13)] = inst_25398);

(statearr_25464[(9)] = inst_25401);

return statearr_25464;
})();
var statearr_25465_25512 = state_25451__$1;
(statearr_25465_25512[(2)] = null);

(statearr_25465_25512[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (17))){
var inst_25399 = (state_25451[(7)]);
var inst_25400 = (state_25451[(8)]);
var inst_25408 = (state_25451[(12)]);
var inst_25407 = (state_25451[(11)]);
var inst_25401 = (state_25451[(9)]);
var inst_25416 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25400,inst_25407);
var tmp25461 = inst_25399;
var tmp25462 = inst_25401;
var inst_25398 = inst_25408;
var inst_25399__$1 = tmp25461;
var inst_25400__$1 = inst_25416;
var inst_25401__$1 = tmp25462;
var state_25451__$1 = (function (){var statearr_25466 = state_25451;
(statearr_25466[(7)] = inst_25399__$1);

(statearr_25466[(8)] = inst_25400__$1);

(statearr_25466[(13)] = inst_25398);

(statearr_25466[(9)] = inst_25401__$1);

return statearr_25466;
})();
var statearr_25467_25513 = state_25451__$1;
(statearr_25467_25513[(2)] = null);

(statearr_25467_25513[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (3))){
var inst_25449 = (state_25451[(2)]);
var state_25451__$1 = state_25451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25451__$1,inst_25449);
} else {
if((state_val_25452 === (12))){
var inst_25398 = (state_25451[(13)]);
var inst_25407 = (state_25451[(11)]);
var inst_25406 = cljs.core.seq(inst_25398);
var inst_25407__$1 = cljs.core.first(inst_25406);
var inst_25408 = cljs.core.next(inst_25406);
var state_25451__$1 = (function (){var statearr_25468 = state_25451;
(statearr_25468[(12)] = inst_25408);

(statearr_25468[(11)] = inst_25407__$1);

return statearr_25468;
})();
if(cljs.core.truth_(inst_25407__$1)){
var statearr_25469_25514 = state_25451__$1;
(statearr_25469_25514[(1)] = (14));

} else {
var statearr_25470_25515 = state_25451__$1;
(statearr_25470_25515[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (2))){
var _ = (function (){var statearr_25471 = state_25451;
(statearr_25471[(4)] = cljs.core.cons((5),(state_25451[(4)])));

return statearr_25471;
})();
var inst_25363 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_25364 = (inst_25363 + (1));
var inst_25365 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_25364);
var state_25451__$1 = state_25451;
if(inst_25365){
var statearr_25472_25516 = state_25451__$1;
(statearr_25472_25516[(1)] = (6));

} else {
var statearr_25473_25517 = state_25451__$1;
(statearr_25473_25517[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (23))){
var inst_25407 = (state_25451[(11)]);
var inst_25424 = (state_25451[(2)]);
var inst_25425 = fluree.db.util.async.throw_err(inst_25424);
var inst_25426 = (inst_25407 == null);
var state_25451__$1 = (function (){var statearr_25474 = state_25451;
(statearr_25474[(10)] = inst_25425);

return statearr_25474;
})();
if(cljs.core.truth_(inst_25426)){
var statearr_25475_25518 = state_25451__$1;
(statearr_25475_25518[(1)] = (24));

} else {
var statearr_25476_25519 = state_25451__$1;
(statearr_25476_25519[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (19))){
var inst_25441 = (state_25451[(2)]);
var state_25451__$1 = state_25451;
var statearr_25477_25520 = state_25451__$1;
(statearr_25477_25520[(2)] = inst_25441);

(statearr_25477_25520[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (11))){
var inst_25446 = (state_25451[(2)]);
var _ = (function (){var statearr_25479 = state_25451;
(statearr_25479[(4)] = cljs.core.rest((state_25451[(4)])));

return statearr_25479;
})();
var state_25451__$1 = state_25451;
var statearr_25480_25521 = state_25451__$1;
(statearr_25480_25521[(2)] = inst_25446);

(statearr_25480_25521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (9))){
var inst_25380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_25381 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_25380);
var state_25451__$1 = state_25451;
var statearr_25481_25522 = state_25451__$1;
(statearr_25481_25522[(2)] = inst_25381);

(statearr_25481_25522[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (5))){
var _ = (function (){var statearr_25482 = state_25451;
(statearr_25482[(4)] = cljs.core.rest((state_25451[(4)])));

return statearr_25482;
})();
var state_25451__$1 = state_25451;
var ex25478 = (state_25451__$1[(2)]);
var statearr_25483_25523 = state_25451__$1;
(statearr_25483_25523[(5)] = ex25478);


var statearr_25484_25524 = state_25451__$1;
(statearr_25484_25524[(1)] = (4));

(statearr_25484_25524[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (14))){
var inst_25399 = (state_25451[(7)]);
var inst_25407 = (state_25451[(11)]);
var inst_25410 = fluree.db.flake.t(inst_25407);
var inst_25411 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25399,inst_25410);
var state_25451__$1 = state_25451;
var statearr_25485_25525 = state_25451__$1;
(statearr_25485_25525[(2)] = inst_25411);

(statearr_25485_25525[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (26))){
var inst_25436 = (state_25451[(2)]);
var state_25451__$1 = state_25451;
var statearr_25486_25526 = state_25451__$1;
(statearr_25486_25526[(2)] = inst_25436);

(statearr_25486_25526[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (16))){
var inst_25414 = (state_25451[(2)]);
var state_25451__$1 = state_25451;
if(cljs.core.truth_(inst_25414)){
var statearr_25487_25527 = state_25451__$1;
(statearr_25487_25527[(1)] = (17));

} else {
var statearr_25488_25528 = state_25451__$1;
(statearr_25488_25528[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (10))){
var inst_25383 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_25391 = cljs.core.seq(inst_25383);
var inst_25392 = cljs.core.first(inst_25391);
var inst_25393 = cljs.core.next(inst_25391);
var inst_25394 = cljs.core.first(inst_25383);
var inst_25395 = fluree.db.flake.t(inst_25394);
var inst_25396 = cljs.core.PersistentVector.EMPTY;
var inst_25397 = db;
var inst_25398 = inst_25383;
var inst_25399 = inst_25395;
var inst_25400 = inst_25396;
var inst_25401 = inst_25397;
var state_25451__$1 = (function (){var statearr_25489 = state_25451;
(statearr_25489[(7)] = inst_25399);

(statearr_25489[(8)] = inst_25400);

(statearr_25489[(14)] = inst_25392);

(statearr_25489[(13)] = inst_25398);

(statearr_25489[(15)] = inst_25393);

(statearr_25489[(9)] = inst_25401);

return statearr_25489;
})();
var statearr_25490_25529 = state_25451__$1;
(statearr_25490_25529[(2)] = null);

(statearr_25490_25529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (18))){
var state_25451__$1 = state_25451;
var statearr_25491_25530 = state_25451__$1;
(statearr_25491_25530[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25452 === (8))){
var inst_25377 = (state_25451[(2)]);
var inst_25378 = cljs.core.empty_QMARK_(flakes);
var state_25451__$1 = (function (){var statearr_25493 = state_25451;
(statearr_25493[(16)] = inst_25377);

return statearr_25493;
})();
if(inst_25378){
var statearr_25494_25531 = state_25451__$1;
(statearr_25494_25531[(1)] = (9));

} else {
var statearr_25495_25532 = state_25451__$1;
(statearr_25495_25532[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25496 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25496[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25496[(1)] = (1));

return statearr_25496;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25451){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25451);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25497){var ex__2730__auto__ = e25497;
var statearr_25498_25533 = state_25451;
(statearr_25498_25533[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25451[(4)]))){
var statearr_25499_25534 = state_25451;
(statearr_25499_25534[(1)] = cljs.core.first((state_25451[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25535 = state_25451;
state_25451 = G__25535;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25451){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25500 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25500[(6)] = c__2749__auto___25502);

return statearr_25500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25587){
var state_val_25588 = (state_25587[(1)]);
if((state_val_25588 === (7))){
var state_25587__$1 = state_25587;
var statearr_25589_25616 = state_25587__$1;
(statearr_25589_25616[(2)] = tt_id);

(statearr_25589_25616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (1))){
var state_25587__$1 = state_25587;
var statearr_25590_25617 = state_25587__$1;
(statearr_25590_25617[(2)] = null);

(statearr_25590_25617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (4))){
var inst_25536 = (state_25587[(2)]);
var state_25587__$1 = state_25587;
var statearr_25591_25618 = state_25587__$1;
(statearr_25591_25618[(2)] = inst_25536);

(statearr_25591_25618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (13))){
var inst_25580 = (state_25587[(2)]);
var state_25587__$1 = state_25587;
var statearr_25592_25619 = state_25587__$1;
(statearr_25592_25619[(2)] = inst_25580);

(statearr_25592_25619[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (6))){
var inst_25544 = cljs.core.random_uuid();
var state_25587__$1 = state_25587;
var statearr_25593_25620 = state_25587__$1;
(statearr_25593_25620[(2)] = inst_25544);

(statearr_25593_25620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (3))){
var inst_25585 = (state_25587[(2)]);
var state_25587__$1 = state_25587;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25587__$1,inst_25585);
} else {
if((state_val_25588 === (12))){
var inst_25563 = (state_25587[(7)]);
var state_25587__$1 = state_25587;
var statearr_25594_25621 = state_25587__$1;
(statearr_25594_25621[(2)] = inst_25563);

(statearr_25594_25621[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (2))){
var _ = (function (){var statearr_25595 = state_25587;
(statearr_25595[(4)] = cljs.core.cons((5),(state_25587[(4)])));

return statearr_25595;
})();
var inst_25542 = (tt_id == null);
var state_25587__$1 = state_25587;
if(cljs.core.truth_(inst_25542)){
var statearr_25596_25622 = state_25587__$1;
(statearr_25596_25622[(1)] = (6));

} else {
var statearr_25597_25623 = state_25587__$1;
(statearr_25597_25623[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (11))){
var inst_25570 = (state_25587[(8)]);
var inst_25563 = (state_25587[(7)]);
var inst_25573 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_25563,inst_25570);
var state_25587__$1 = state_25587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25587__$1,(14),inst_25573);
} else {
if((state_val_25588 === (9))){
var inst_25564 = (state_25587[(9)]);
var inst_25570 = (state_25587[(8)]);
var inst_25569 = cljs.core.seq(inst_25564);
var inst_25570__$1 = cljs.core.first(inst_25569);
var inst_25571 = cljs.core.next(inst_25569);
var state_25587__$1 = (function (){var statearr_25599 = state_25587;
(statearr_25599[(10)] = inst_25571);

(statearr_25599[(8)] = inst_25570__$1);

return statearr_25599;
})();
if(cljs.core.truth_(inst_25570__$1)){
var statearr_25600_25624 = state_25587__$1;
(statearr_25600_25624[(1)] = (11));

} else {
var statearr_25601_25625 = state_25587__$1;
(statearr_25601_25625[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (5))){
var _ = (function (){var statearr_25602 = state_25587;
(statearr_25602[(4)] = cljs.core.rest((state_25587[(4)])));

return statearr_25602;
})();
var state_25587__$1 = state_25587;
var ex25598 = (state_25587__$1[(2)]);
var statearr_25603_25626 = state_25587__$1;
(statearr_25603_25626[(5)] = ex25598);


if((ex25598 instanceof Error)){
var statearr_25604_25627 = state_25587__$1;
(statearr_25604_25627[(1)] = (4));

(statearr_25604_25627[(5)] = null);

} else {
throw ex25598;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (14))){
var inst_25571 = (state_25587[(10)]);
var inst_25575 = (state_25587[(2)]);
var inst_25576 = fluree.db.util.async.throw_err(inst_25575);
var inst_25563 = inst_25576;
var inst_25564 = inst_25571;
var state_25587__$1 = (function (){var statearr_25605 = state_25587;
(statearr_25605[(9)] = inst_25564);

(statearr_25605[(7)] = inst_25563);

return statearr_25605;
})();
var statearr_25606_25628 = state_25587__$1;
(statearr_25606_25628[(2)] = null);

(statearr_25606_25628[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (10))){
var inst_25582 = (state_25587[(2)]);
var _ = (function (){var statearr_25607 = state_25587;
(statearr_25607[(4)] = cljs.core.rest((state_25587[(4)])));

return statearr_25607;
})();
var state_25587__$1 = state_25587;
var statearr_25608_25629 = state_25587__$1;
(statearr_25608_25629[(2)] = inst_25582);

(statearr_25608_25629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25588 === (8))){
var inst_25547 = (state_25587[(2)]);
var inst_25548 = (function (){var tt_id__$1 = inst_25547;
return (function (db_STAR_,idx){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_25549 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_25547);
var inst_25550 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_25548,inst_25549,fluree.db.index.types);
var inst_25551 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_25552 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_25551);
var inst_25560 = cljs.core.seq(inst_25552);
var inst_25561 = cljs.core.first(inst_25560);
var inst_25562 = cljs.core.next(inst_25560);
var inst_25563 = inst_25550;
var inst_25564 = inst_25552;
var state_25587__$1 = (function (){var statearr_25609 = state_25587;
(statearr_25609[(11)] = inst_25562);

(statearr_25609[(9)] = inst_25564);

(statearr_25609[(7)] = inst_25563);

(statearr_25609[(12)] = inst_25561);

return statearr_25609;
})();
var statearr_25610_25630 = state_25587__$1;
(statearr_25610_25630[(2)] = null);

(statearr_25610_25630[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0 = (function (){
var statearr_25611 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25611[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__);

(statearr_25611[(1)] = (1));

return statearr_25611;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1 = (function (state_25587){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25587);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25612){var ex__2730__auto__ = e25612;
var statearr_25613_25631 = state_25587;
(statearr_25613_25631[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25587[(4)]))){
var statearr_25614_25632 = state_25587;
(statearr_25614_25632[(1)] = cljs.core.first((state_25587[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25633 = state_25587;
state_25587 = G__25633;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__ = function(state_25587){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1.call(this,state_25587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25615 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25615[(6)] = c__2749__auto__);

return statearr_25615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___25820 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25751){
var state_val_25752 = (state_25751[(1)]);
if((state_val_25752 === (7))){
var inst_25661 = (state_25751[(7)]);
var inst_25661__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_25751__$1 = (function (){var statearr_25753 = state_25751;
(statearr_25753[(7)] = inst_25661__$1);

return statearr_25753;
})();
if(inst_25661__$1){
var statearr_25754_25821 = state_25751__$1;
(statearr_25754_25821[(1)] = (13));

} else {
var statearr_25755_25822 = state_25751__$1;
(statearr_25755_25822[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (20))){
var state_25751__$1 = state_25751;
var statearr_25756_25823 = state_25751__$1;
(statearr_25756_25823[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (27))){
var inst_25697 = (state_25751[(8)]);
var inst_25701 = fluree.db.flake.s(inst_25697);
var state_25751__$1 = state_25751;
var statearr_25758_25824 = state_25751__$1;
(statearr_25758_25824[(2)] = inst_25701);

(statearr_25758_25824[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (1))){
var state_25751__$1 = state_25751;
var statearr_25759_25825 = state_25751__$1;
(statearr_25759_25825[(2)] = null);

(statearr_25759_25825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (24))){
var inst_25691 = (state_25751[(9)]);
var inst_25695 = cljs.core.first(inst_25691);
var state_25751__$1 = state_25751;
var statearr_25760_25826 = state_25751__$1;
(statearr_25760_25826[(2)] = inst_25695);

(statearr_25760_25826[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (39))){
var state_25751__$1 = state_25751;
var statearr_25761_25827 = state_25751__$1;
(statearr_25761_25827[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (4))){
var inst_25634 = (state_25751[(2)]);
var inst_25635 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25636 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25637 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25638 = cljs.core.PersistentHashMap.fromArrays(inst_25636,inst_25637);
var inst_25639 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_25635,inst_25638,inst_25634);
var inst_25640 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_25639);
var state_25751__$1 = state_25751;
var statearr_25763_25828 = state_25751__$1;
(statearr_25763_25828[(2)] = inst_25640);

(statearr_25763_25828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (15))){
var inst_25668 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
if(cljs.core.truth_(inst_25668)){
var statearr_25764_25829 = state_25751__$1;
(statearr_25764_25829[(1)] = (16));

} else {
var statearr_25765_25830 = state_25751__$1;
(statearr_25765_25830[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (21))){
var inst_25717 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
var statearr_25766_25831 = state_25751__$1;
(statearr_25766_25831[(2)] = inst_25717);

(statearr_25766_25831[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (31))){
var inst_25715 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
var statearr_25767_25832 = state_25751__$1;
(statearr_25767_25832[(2)] = inst_25715);

(statearr_25767_25832[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (32))){
var inst_25721 = (state_25751[(10)]);
var inst_25723 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_25721);
var state_25751__$1 = state_25751;
var statearr_25768_25833 = state_25751__$1;
(statearr_25768_25833[(2)] = inst_25723);

(statearr_25768_25833[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (40))){
var inst_25744 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
var statearr_25769_25834 = state_25751__$1;
(statearr_25769_25834[(2)] = inst_25744);

(statearr_25769_25834[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (33))){
var inst_25725 = (state_25751[(11)]);
var inst_25721 = (state_25751[(10)]);
var inst_25725__$1 = (inst_25721 == null);
var state_25751__$1 = (function (){var statearr_25770 = state_25751;
(statearr_25770[(11)] = inst_25725__$1);

return statearr_25770;
})();
if(cljs.core.truth_(inst_25725__$1)){
var statearr_25771_25835 = state_25751__$1;
(statearr_25771_25835[(1)] = (35));

} else {
var statearr_25772_25836 = state_25751__$1;
(statearr_25772_25836[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (13))){
var inst_25663 = cljs.core.first(ident);
var inst_25664 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25663);
var inst_25665 = (inst_25664 == null);
var state_25751__$1 = state_25751;
var statearr_25773_25837 = state_25751__$1;
(statearr_25773_25837[(2)] = inst_25665);

(statearr_25773_25837[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (22))){
var inst_25691 = (state_25751[(9)]);
var inst_25690 = (state_25751[(2)]);
var inst_25691__$1 = fluree.db.util.async.throw_err(inst_25690);
var inst_25692 = (inst_25691__$1 == null);
var state_25751__$1 = (function (){var statearr_25774 = state_25751;
(statearr_25774[(9)] = inst_25691__$1);

return statearr_25774;
})();
if(cljs.core.truth_(inst_25692)){
var statearr_25775_25838 = state_25751__$1;
(statearr_25775_25838[(1)] = (23));

} else {
var statearr_25776_25839 = state_25751__$1;
(statearr_25776_25839[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (36))){
var inst_25725 = (state_25751[(11)]);
var state_25751__$1 = state_25751;
var statearr_25777_25840 = state_25751__$1;
(statearr_25777_25840[(2)] = inst_25725);

(statearr_25777_25840[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (41))){
var inst_25739 = cljs.core.async.close_BANG_(return_chan);
var state_25751__$1 = state_25751;
var statearr_25778_25841 = state_25751__$1;
(statearr_25778_25841[(2)] = inst_25739);

(statearr_25778_25841[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (43))){
var inst_25742 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
var statearr_25779_25842 = state_25751__$1;
(statearr_25779_25842[(2)] = inst_25742);

(statearr_25779_25842[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (29))){
var inst_25706 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_25707 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_25706].join('');
var inst_25708 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25709 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25710 = cljs.core.PersistentHashMap.fromArrays(inst_25708,inst_25709);
var inst_25711 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25707,inst_25710);
var inst_25712 = (function(){throw inst_25711})();
var state_25751__$1 = state_25751;
var statearr_25780_25843 = state_25751__$1;
(statearr_25780_25843[(2)] = inst_25712);

(statearr_25780_25843[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (6))){
var inst_25648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25649 = [ident];
var inst_25650 = (new cljs.core.PersistentVector(null,1,(5),inst_25648,inst_25649,null));
var inst_25651 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25650);
var state_25751__$1 = state_25751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25751__$1,(9),inst_25651);
} else {
if((state_val_25752 === (28))){
var inst_25703 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
var statearr_25781_25844 = state_25751__$1;
(statearr_25781_25844[(2)] = inst_25703);

(statearr_25781_25844[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (25))){
var inst_25697 = (state_25751[(8)]);
var inst_25697__$1 = (state_25751[(2)]);
var inst_25698 = (inst_25697__$1 == null);
var state_25751__$1 = (function (){var statearr_25782 = state_25751;
(statearr_25782[(8)] = inst_25697__$1);

return statearr_25782;
})();
if(cljs.core.truth_(inst_25698)){
var statearr_25783_25845 = state_25751__$1;
(statearr_25783_25845[(1)] = (26));

} else {
var statearr_25784_25846 = state_25751__$1;
(statearr_25784_25846[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (34))){
var inst_25746 = (state_25751[(2)]);
var _ = (function (){var statearr_25785 = state_25751;
(statearr_25785[(4)] = cljs.core.rest((state_25751[(4)])));

return statearr_25785;
})();
var state_25751__$1 = state_25751;
var statearr_25786_25847 = state_25751__$1;
(statearr_25786_25847[(2)] = inst_25746);

(statearr_25786_25847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (17))){
var inst_25679 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_25751__$1 = state_25751;
if(inst_25679){
var statearr_25787_25848 = state_25751__$1;
(statearr_25787_25848[(1)] = (19));

} else {
var statearr_25788_25849 = state_25751__$1;
(statearr_25788_25849[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (3))){
var inst_25749 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25751__$1,inst_25749);
} else {
if((state_val_25752 === (12))){
var inst_25659 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
var statearr_25789_25850 = state_25751__$1;
(statearr_25789_25850[(2)] = inst_25659);

(statearr_25789_25850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (2))){
var _ = (function (){var statearr_25790 = state_25751;
(statearr_25790[(4)] = cljs.core.cons((5),(state_25751[(4)])));

return statearr_25790;
})();
var inst_25646 = typeof ident === 'number';
var state_25751__$1 = state_25751;
if(cljs.core.truth_(inst_25646)){
var statearr_25791_25851 = state_25751__$1;
(statearr_25791_25851[(1)] = (6));

} else {
var statearr_25792_25852 = state_25751__$1;
(statearr_25792_25852[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (23))){
var state_25751__$1 = state_25751;
var statearr_25793_25853 = state_25751__$1;
(statearr_25793_25853[(2)] = null);

(statearr_25793_25853[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (35))){
var state_25751__$1 = state_25751;
var statearr_25794_25854 = state_25751__$1;
(statearr_25794_25854[(2)] = strict_QMARK_);

(statearr_25794_25854[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (19))){
var inst_25682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25683 = cljs.core.first(ident);
var inst_25684 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_25683);
var inst_25685 = cljs.core.second(ident);
var inst_25686 = [inst_25684,inst_25685];
var inst_25687 = (new cljs.core.PersistentVector(null,2,(5),inst_25682,inst_25686,null));
var inst_25688 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25687);
var state_25751__$1 = state_25751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25751__$1,(22),inst_25688);
} else {
if((state_val_25752 === (11))){
var state_25751__$1 = state_25751;
var statearr_25796_25855 = state_25751__$1;
(statearr_25796_25855[(2)] = null);

(statearr_25796_25855[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (9))){
var inst_25653 = (state_25751[(2)]);
var inst_25654 = fluree.db.util.async.throw_err(inst_25653);
var inst_25655 = cljs.core.not_empty(inst_25654);
var state_25751__$1 = state_25751;
if(cljs.core.truth_(inst_25655)){
var statearr_25797_25856 = state_25751__$1;
(statearr_25797_25856[(1)] = (10));

} else {
var statearr_25798_25857 = state_25751__$1;
(statearr_25798_25857[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (5))){
var _ = (function (){var statearr_25799 = state_25751;
(statearr_25799[(4)] = cljs.core.rest((state_25751[(4)])));

return statearr_25799;
})();
var state_25751__$1 = state_25751;
var ex25795 = (state_25751__$1[(2)]);
var statearr_25800_25858 = state_25751__$1;
(statearr_25800_25858[(5)] = ex25795);


var statearr_25801_25859 = state_25751__$1;
(statearr_25801_25859[(1)] = (4));

(statearr_25801_25859[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (14))){
var inst_25661 = (state_25751[(7)]);
var state_25751__$1 = state_25751;
var statearr_25802_25860 = state_25751__$1;
(statearr_25802_25860[(2)] = inst_25661);

(statearr_25802_25860[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (26))){
var state_25751__$1 = state_25751;
var statearr_25803_25861 = state_25751__$1;
(statearr_25803_25861[(2)] = null);

(statearr_25803_25861[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (16))){
var inst_25670 = cljs.core.first(ident);
var inst_25671 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_25670], 0));
var inst_25672 = ["Subject ID lookup failed. The predicate ",inst_25671," does not exist."].join('');
var inst_25673 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25674 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_25675 = cljs.core.PersistentHashMap.fromArrays(inst_25673,inst_25674);
var inst_25676 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25672,inst_25675);
var inst_25677 = (function(){throw inst_25676})();
var state_25751__$1 = state_25751;
var statearr_25804_25862 = state_25751__$1;
(statearr_25804_25862[(2)] = inst_25677);

(statearr_25804_25862[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (38))){
var inst_25731 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_25732 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25733 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_25734 = cljs.core.PersistentHashMap.fromArrays(inst_25732,inst_25733);
var inst_25735 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25731,inst_25734);
var inst_25736 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_25735);
var state_25751__$1 = state_25751;
var statearr_25805_25863 = state_25751__$1;
(statearr_25805_25863[(2)] = inst_25736);

(statearr_25805_25863[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (30))){
var state_25751__$1 = state_25751;
var statearr_25806_25864 = state_25751__$1;
(statearr_25806_25864[(2)] = null);

(statearr_25806_25864[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (10))){
var state_25751__$1 = state_25751;
var statearr_25807_25865 = state_25751__$1;
(statearr_25807_25865[(2)] = ident);

(statearr_25807_25865[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (18))){
var inst_25719 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
var statearr_25808_25866 = state_25751__$1;
(statearr_25808_25866[(2)] = inst_25719);

(statearr_25808_25866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (42))){
var state_25751__$1 = state_25751;
var statearr_25809_25867 = state_25751__$1;
(statearr_25809_25867[(2)] = null);

(statearr_25809_25867[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (37))){
var inst_25729 = (state_25751[(2)]);
var state_25751__$1 = state_25751;
if(cljs.core.truth_(inst_25729)){
var statearr_25810_25868 = state_25751__$1;
(statearr_25810_25868[(1)] = (38));

} else {
var statearr_25811_25869 = state_25751__$1;
(statearr_25811_25869[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25752 === (8))){
var inst_25721 = (state_25751[(10)]);
var inst_25721__$1 = (state_25751[(2)]);
var state_25751__$1 = (function (){var statearr_25812 = state_25751;
(statearr_25812[(10)] = inst_25721__$1);

return statearr_25812;
})();
if(cljs.core.truth_(inst_25721__$1)){
var statearr_25813_25870 = state_25751__$1;
(statearr_25813_25870[(1)] = (32));

} else {
var statearr_25814_25871 = state_25751__$1;
(statearr_25814_25871[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2727__auto____0 = (function (){
var statearr_25815 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25815[(0)] = fluree$db$graphdb$subid_$_state_machine__2727__auto__);

(statearr_25815[(1)] = (1));

return statearr_25815;
});
var fluree$db$graphdb$subid_$_state_machine__2727__auto____1 = (function (state_25751){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25751);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25816){var ex__2730__auto__ = e25816;
var statearr_25817_25872 = state_25751;
(statearr_25817_25872[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25751[(4)]))){
var statearr_25818_25873 = state_25751;
(statearr_25818_25873[(1)] = cljs.core.first((state_25751[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25874 = state_25751;
state_25751 = G__25874;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2727__auto__ = function(state_25751){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2727__auto____1.call(this,state_25751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2727__auto____0;
fluree$db$graphdb$subid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2727__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25819 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25819[(6)] = c__2749__auto___25820);

return statearr_25819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__25875){
var map__25876 = p__25875;
var map__25876__$1 = cljs.core.__destructure_map(map__25876);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25876__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25876__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25892){
var state_val_25893 = (state_25892[(1)]);
if((state_val_25893 === (1))){
var state_25892__$1 = state_25892;
var statearr_25894_25908 = state_25892__$1;
(statearr_25894_25908[(2)] = null);

(statearr_25894_25908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25893 === (2))){
var _ = (function (){var statearr_25895 = state_25892;
(statearr_25895[(4)] = cljs.core.cons((5),(state_25892[(4)])));

return statearr_25895;
})();
var inst_25883 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_25892__$1 = state_25892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25892__$1,(6),inst_25883);
} else {
if((state_val_25893 === (3))){
var inst_25890 = (state_25892[(2)]);
var state_25892__$1 = state_25892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25892__$1,inst_25890);
} else {
if((state_val_25893 === (4))){
var inst_25877 = (state_25892[(2)]);
var state_25892__$1 = state_25892;
var statearr_25897_25909 = state_25892__$1;
(statearr_25897_25909[(2)] = inst_25877);

(statearr_25897_25909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25893 === (5))){
var _ = (function (){var statearr_25898 = state_25892;
(statearr_25898[(4)] = cljs.core.rest((state_25892[(4)])));

return statearr_25898;
})();
var state_25892__$1 = state_25892;
var ex25896 = (state_25892__$1[(2)]);
var statearr_25899_25910 = state_25892__$1;
(statearr_25899_25910[(5)] = ex25896);


if((ex25896 instanceof Error)){
var statearr_25900_25911 = state_25892__$1;
(statearr_25900_25911[(1)] = (4));

(statearr_25900_25911[(5)] = null);

} else {
throw ex25896;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25893 === (6))){
var inst_25885 = (state_25892[(2)]);
var inst_25886 = fluree.db.util.async.throw_err(inst_25885);
var inst_25887 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25886,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_25901 = state_25892;
(statearr_25901[(4)] = cljs.core.rest((state_25892[(4)])));

return statearr_25901;
})();
var state_25892__$1 = state_25892;
var statearr_25902_25912 = state_25892__$1;
(statearr_25902_25912[(2)] = inst_25887);

(statearr_25902_25912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0 = (function (){
var statearr_25903 = [null,null,null,null,null,null,null];
(statearr_25903[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__);

(statearr_25903[(1)] = (1));

return statearr_25903;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1 = (function (state_25892){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25892);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25904){var ex__2730__auto__ = e25904;
var statearr_25905_25913 = state_25892;
(statearr_25905_25913[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25892[(4)]))){
var statearr_25906_25914 = state_25892;
(statearr_25906_25914[(1)] = cljs.core.first((state_25892[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25915 = state_25892;
state_25892 = G__25915;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__ = function(state_25892){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1.call(this,state_25892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25907 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25907[(6)] = c__2749__auto__);

return statearr_25907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__25916,property,collection){
var map__25917 = p__25916;
var map__25917__$1 = cljs.core.__destructure_map(map__25917);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25917__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__25918 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__25918.cljs$core$IFn$_invoke$arity$1 ? fexpr__25918.cljs$core$IFn$_invoke$arity$1(property) : fexpr__25918.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__25919,property,predicate){
var map__25920 = p__25919;
var map__25920__$1 = cljs.core.__destructure_map(map__25920);
var this$ = map__25920__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25920__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__25921 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__25921.cljs$core$IFn$_invoke$arity$1 ? fexpr__25921.cljs$core$IFn$_invoke$arity$1(property) : fexpr__25921.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__25922 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__25922);
} else {
return G__25922;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__25924 = arguments.length;
switch (G__25924) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25956){
var state_val_25957 = (state_25956[(1)]);
if((state_val_25957 === (7))){
var state_25956__$1 = state_25956;
var statearr_25958_26052 = state_25956__$1;
(statearr_25958_26052[(2)] = null);

(statearr_25958_26052[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (1))){
var state_25956__$1 = state_25956;
var statearr_25959_26053 = state_25956__$1;
(statearr_25959_26053[(2)] = null);

(statearr_25959_26053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (4))){
var inst_25925 = (state_25956[(2)]);
var state_25956__$1 = state_25956;
var statearr_25960_26054 = state_25956__$1;
(statearr_25960_26054[(2)] = inst_25925);

(statearr_25960_26054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (6))){
var inst_25939 = (state_25956[(7)]);
var inst_25938 = (state_25956[(2)]);
var inst_25939__$1 = fluree.db.util.async.throw_err(inst_25938);
var inst_25940 = (inst_25939__$1 == null);
var state_25956__$1 = (function (){var statearr_25961 = state_25956;
(statearr_25961[(7)] = inst_25939__$1);

return statearr_25961;
})();
if(cljs.core.truth_(inst_25940)){
var statearr_25962_26055 = state_25956__$1;
(statearr_25962_26055[(1)] = (7));

} else {
var statearr_25963_26056 = state_25956__$1;
(statearr_25963_26056[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (3))){
var inst_25954 = (state_25956[(2)]);
var state_25956__$1 = state_25956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25956__$1,inst_25954);
} else {
if((state_val_25957 === (12))){
var inst_25951 = (state_25956[(2)]);
var _ = (function (){var statearr_25964 = state_25956;
(statearr_25964[(4)] = cljs.core.rest((state_25956[(4)])));

return statearr_25964;
})();
var state_25956__$1 = state_25956;
var statearr_25965_26057 = state_25956__$1;
(statearr_25965_26057[(2)] = inst_25951);

(statearr_25965_26057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (2))){
var _ = (function (){var statearr_25966 = state_25956;
(statearr_25966[(4)] = cljs.core.cons((5),(state_25956[(4)])));

return statearr_25966;
})();
var inst_25932 = fluree.db.dbproto._rootdb(this$);
var inst_25933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25934 = [tag_id,(30)];
var inst_25935 = (new cljs.core.PersistentVector(null,2,(5),inst_25933,inst_25934,null));
var inst_25936 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_25932,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25935);
var state_25956__$1 = state_25956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25956__$1,(6),inst_25936);
} else {
if((state_val_25957 === (11))){
var inst_25945 = (state_25956[(8)]);
var inst_25949 = fluree.db.flake.o(inst_25945);
var state_25956__$1 = state_25956;
var statearr_25968_26058 = state_25956__$1;
(statearr_25968_26058[(2)] = inst_25949);

(statearr_25968_26058[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (9))){
var inst_25945 = (state_25956[(8)]);
var inst_25945__$1 = (state_25956[(2)]);
var inst_25946 = (inst_25945__$1 == null);
var state_25956__$1 = (function (){var statearr_25969 = state_25956;
(statearr_25969[(8)] = inst_25945__$1);

return statearr_25969;
})();
if(cljs.core.truth_(inst_25946)){
var statearr_25970_26059 = state_25956__$1;
(statearr_25970_26059[(1)] = (10));

} else {
var statearr_25971_26060 = state_25956__$1;
(statearr_25971_26060[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (5))){
var _ = (function (){var statearr_25972 = state_25956;
(statearr_25972[(4)] = cljs.core.rest((state_25956[(4)])));

return statearr_25972;
})();
var state_25956__$1 = state_25956;
var ex25967 = (state_25956__$1[(2)]);
var statearr_25973_26061 = state_25956__$1;
(statearr_25973_26061[(5)] = ex25967);


if((ex25967 instanceof Error)){
var statearr_25974_26062 = state_25956__$1;
(statearr_25974_26062[(1)] = (4));

(statearr_25974_26062[(5)] = null);

} else {
throw ex25967;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (10))){
var state_25956__$1 = state_25956;
var statearr_25975_26063 = state_25956__$1;
(statearr_25975_26063[(2)] = null);

(statearr_25975_26063[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (8))){
var inst_25939 = (state_25956[(7)]);
var inst_25943 = cljs.core.first(inst_25939);
var state_25956__$1 = state_25956;
var statearr_25976_26064 = state_25956__$1;
(statearr_25976_26064[(2)] = inst_25943);

(statearr_25976_26064[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_25977 = [null,null,null,null,null,null,null,null,null];
(statearr_25977[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_25977[(1)] = (1));

return statearr_25977;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_25956){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25956);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25978){var ex__2730__auto__ = e25978;
var statearr_25979_26065 = state_25956;
(statearr_25979_26065[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25956[(4)]))){
var statearr_25980_26066 = state_25956;
(statearr_25980_26066[(1)] = cljs.core.first((state_25956[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26067 = state_25956;
state_25956 = G__26067;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_25956){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_25956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25981 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25981[(6)] = c__2749__auto__);

return statearr_25981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26017){
var state_val_26018 = (state_26017[(1)]);
if((state_val_26018 === (7))){
var inst_25991 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26017__$1 = state_26017;
var statearr_26019_26068 = state_26017__$1;
(statearr_26019_26068[(2)] = inst_25991);

(statearr_26019_26068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (1))){
var state_26017__$1 = state_26017;
var statearr_26020_26069 = state_26017__$1;
(statearr_26020_26069[(2)] = null);

(statearr_26020_26069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (4))){
var inst_25982 = (state_26017[(2)]);
var state_26017__$1 = state_26017;
var statearr_26021_26070 = state_26017__$1;
(statearr_26021_26070[(2)] = inst_25982);

(statearr_26021_26070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (15))){
var inst_26012 = (state_26017[(2)]);
var _ = (function (){var statearr_26022 = state_26017;
(statearr_26022[(4)] = cljs.core.rest((state_26017[(4)])));

return statearr_26022;
})();
var state_26017__$1 = state_26017;
var statearr_26023_26071 = state_26017__$1;
(statearr_26023_26071[(2)] = inst_26012);

(statearr_26023_26071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (13))){
var inst_25997 = (state_26017[(7)]);
var inst_26003 = clojure.string.includes_QMARK_(inst_25997,":");
var state_26017__$1 = state_26017;
if(inst_26003){
var statearr_26024_26072 = state_26017__$1;
(statearr_26024_26072[(1)] = (16));

} else {
var statearr_26025_26073 = state_26017__$1;
(statearr_26025_26073[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (6))){
var state_26017__$1 = state_26017;
var statearr_26026_26074 = state_26017__$1;
(statearr_26026_26074[(2)] = pred);

(statearr_26026_26074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (17))){
var inst_25997 = (state_26017[(7)]);
var state_26017__$1 = state_26017;
var statearr_26027_26075 = state_26017__$1;
(statearr_26027_26075[(2)] = inst_25997);

(statearr_26027_26075[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (3))){
var inst_26015 = (state_26017[(2)]);
var state_26017__$1 = state_26017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26017__$1,inst_26015);
} else {
if((state_val_26018 === (12))){
var inst_26001 = (state_26017[(2)]);
var state_26017__$1 = state_26017;
if(cljs.core.truth_(inst_26001)){
var statearr_26028_26076 = state_26017__$1;
(statearr_26028_26076[(1)] = (13));

} else {
var statearr_26029_26077 = state_26017__$1;
(statearr_26029_26077[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (2))){
var _ = (function (){var statearr_26030 = state_26017;
(statearr_26030[(4)] = cljs.core.cons((5),(state_26017[(4)])));

return statearr_26030;
})();
var inst_25988 = typeof pred === 'string';
var state_26017__$1 = state_26017;
if(cljs.core.truth_(inst_25988)){
var statearr_26031_26078 = state_26017__$1;
(statearr_26031_26078[(1)] = (6));

} else {
var statearr_26032_26079 = state_26017__$1;
(statearr_26032_26079[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (11))){
var inst_25993 = (state_26017[(8)]);
var state_26017__$1 = state_26017;
var statearr_26034_26080 = state_26017__$1;
(statearr_26034_26080[(2)] = inst_25993);

(statearr_26034_26080[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (9))){
var inst_25993 = (state_26017[(8)]);
var inst_25996 = (state_26017[(2)]);
var inst_25997 = fluree.db.util.async.throw_err(inst_25996);
var state_26017__$1 = (function (){var statearr_26035 = state_26017;
(statearr_26035[(7)] = inst_25997);

return statearr_26035;
})();
if(cljs.core.truth_(inst_25993)){
var statearr_26036_26081 = state_26017__$1;
(statearr_26036_26081[(1)] = (10));

} else {
var statearr_26037_26082 = state_26017__$1;
(statearr_26037_26082[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (5))){
var _ = (function (){var statearr_26038 = state_26017;
(statearr_26038[(4)] = cljs.core.rest((state_26017[(4)])));

return statearr_26038;
})();
var state_26017__$1 = state_26017;
var ex26033 = (state_26017__$1[(2)]);
var statearr_26039_26083 = state_26017__$1;
(statearr_26039_26083[(5)] = ex26033);


if((ex26033 instanceof Error)){
var statearr_26040_26084 = state_26017__$1;
(statearr_26040_26084[(1)] = (4));

(statearr_26040_26084[(5)] = null);

} else {
throw ex26033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (14))){
var state_26017__$1 = state_26017;
var statearr_26041_26085 = state_26017__$1;
(statearr_26041_26085[(2)] = null);

(statearr_26041_26085[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (16))){
var inst_25997 = (state_26017[(7)]);
var inst_26005 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_25997,/:/);
var inst_26006 = cljs.core.second(inst_26005);
var state_26017__$1 = state_26017;
var statearr_26042_26086 = state_26017__$1;
(statearr_26042_26086[(2)] = inst_26006);

(statearr_26042_26086[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (10))){
var inst_25997 = (state_26017[(7)]);
var state_26017__$1 = state_26017;
var statearr_26043_26087 = state_26017__$1;
(statearr_26043_26087[(2)] = inst_25997);

(statearr_26043_26087[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (18))){
var inst_26009 = (state_26017[(2)]);
var state_26017__$1 = state_26017;
var statearr_26044_26088 = state_26017__$1;
(statearr_26044_26088[(2)] = inst_26009);

(statearr_26044_26088[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26018 === (8))){
var inst_25993 = (state_26017[(2)]);
var inst_25994 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_26017__$1 = (function (){var statearr_26045 = state_26017;
(statearr_26045[(8)] = inst_25993);

return statearr_26045;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26017__$1,(9),inst_25994);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26046 = [null,null,null,null,null,null,null,null,null];
(statearr_26046[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26046[(1)] = (1));

return statearr_26046;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26017){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26017);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26047){var ex__2730__auto__ = e26047;
var statearr_26048_26089 = state_26017;
(statearr_26048_26089[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26017[(4)]))){
var statearr_26049_26090 = state_26017;
(statearr_26049_26090[(1)] = cljs.core.first((state_26017[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26091 = state_26017;
state_26017 = G__26091;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26017){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26050 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26050[(6)] = c__2749__auto__);

return statearr_26050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26093 = arguments.length;
switch (G__26093) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26126){
var state_val_26127 = (state_26126[(1)]);
if((state_val_26127 === (7))){
var state_26126__$1 = state_26126;
var statearr_26128_26216 = state_26126__$1;
(statearr_26128_26216[(2)] = null);

(statearr_26128_26216[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (1))){
var state_26126__$1 = state_26126;
var statearr_26129_26217 = state_26126__$1;
(statearr_26129_26217[(2)] = null);

(statearr_26129_26217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (4))){
var inst_26094 = (state_26126[(2)]);
var state_26126__$1 = state_26126;
var statearr_26130_26218 = state_26126__$1;
(statearr_26130_26218[(2)] = inst_26094);

(statearr_26130_26218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (6))){
var inst_26109 = (state_26126[(7)]);
var inst_26108 = (state_26126[(2)]);
var inst_26109__$1 = fluree.db.util.async.throw_err(inst_26108);
var inst_26110 = (inst_26109__$1 == null);
var state_26126__$1 = (function (){var statearr_26131 = state_26126;
(statearr_26131[(7)] = inst_26109__$1);

return statearr_26131;
})();
if(cljs.core.truth_(inst_26110)){
var statearr_26132_26219 = state_26126__$1;
(statearr_26132_26219[(1)] = (7));

} else {
var statearr_26133_26220 = state_26126__$1;
(statearr_26133_26220[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (3))){
var inst_26124 = (state_26126[(2)]);
var state_26126__$1 = state_26126;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26126__$1,inst_26124);
} else {
if((state_val_26127 === (12))){
var inst_26121 = (state_26126[(2)]);
var _ = (function (){var statearr_26134 = state_26126;
(statearr_26134[(4)] = cljs.core.rest((state_26126[(4)])));

return statearr_26134;
})();
var state_26126__$1 = state_26126;
var statearr_26135_26221 = state_26126__$1;
(statearr_26135_26221[(2)] = inst_26121);

(statearr_26135_26221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (2))){
var _ = (function (){var statearr_26136 = state_26126;
(statearr_26136[(4)] = cljs.core.cons((5),(state_26126[(4)])));

return statearr_26136;
})();
var inst_26100 = (30);
var inst_26102 = fluree.db.dbproto._rootdb(this$);
var inst_26103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26104 = [inst_26100,tag_name];
var inst_26105 = (new cljs.core.PersistentVector(null,2,(5),inst_26103,inst_26104,null));
var inst_26106 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26102,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26105);
var state_26126__$1 = state_26126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26126__$1,(6),inst_26106);
} else {
if((state_val_26127 === (11))){
var inst_26115 = (state_26126[(8)]);
var inst_26119 = fluree.db.flake.s(inst_26115);
var state_26126__$1 = state_26126;
var statearr_26138_26222 = state_26126__$1;
(statearr_26138_26222[(2)] = inst_26119);

(statearr_26138_26222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (9))){
var inst_26115 = (state_26126[(8)]);
var inst_26115__$1 = (state_26126[(2)]);
var inst_26116 = (inst_26115__$1 == null);
var state_26126__$1 = (function (){var statearr_26139 = state_26126;
(statearr_26139[(8)] = inst_26115__$1);

return statearr_26139;
})();
if(cljs.core.truth_(inst_26116)){
var statearr_26140_26223 = state_26126__$1;
(statearr_26140_26223[(1)] = (10));

} else {
var statearr_26141_26224 = state_26126__$1;
(statearr_26141_26224[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (5))){
var _ = (function (){var statearr_26142 = state_26126;
(statearr_26142[(4)] = cljs.core.rest((state_26126[(4)])));

return statearr_26142;
})();
var state_26126__$1 = state_26126;
var ex26137 = (state_26126__$1[(2)]);
var statearr_26143_26225 = state_26126__$1;
(statearr_26143_26225[(5)] = ex26137);


if((ex26137 instanceof Error)){
var statearr_26144_26226 = state_26126__$1;
(statearr_26144_26226[(1)] = (4));

(statearr_26144_26226[(5)] = null);

} else {
throw ex26137;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (10))){
var state_26126__$1 = state_26126;
var statearr_26145_26227 = state_26126__$1;
(statearr_26145_26227[(2)] = null);

(statearr_26145_26227[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (8))){
var inst_26109 = (state_26126[(7)]);
var inst_26113 = cljs.core.first(inst_26109);
var state_26126__$1 = state_26126;
var statearr_26146_26228 = state_26126__$1;
(statearr_26146_26228[(2)] = inst_26113);

(statearr_26146_26228[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26147 = [null,null,null,null,null,null,null,null,null];
(statearr_26147[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26147[(1)] = (1));

return statearr_26147;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26126){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26126);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26148){var ex__2730__auto__ = e26148;
var statearr_26149_26229 = state_26126;
(statearr_26149_26229[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26126[(4)]))){
var statearr_26150_26230 = state_26126;
(statearr_26150_26230[(1)] = cljs.core.first((state_26126[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26231 = state_26126;
state_26126 = G__26231;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26126){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26151 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26151[(6)] = c__2749__auto__);

return statearr_26151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26186){
var state_val_26187 = (state_26186[(1)]);
if((state_val_26187 === (7))){
var inst_26165 = typeof pred === 'string';
var state_26186__$1 = state_26186;
if(cljs.core.truth_(inst_26165)){
var statearr_26188_26232 = state_26186__$1;
(statearr_26188_26232[(1)] = (10));

} else {
var statearr_26189_26233 = state_26186__$1;
(statearr_26189_26233[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (1))){
var state_26186__$1 = state_26186;
var statearr_26190_26234 = state_26186__$1;
(statearr_26190_26234[(2)] = null);

(statearr_26190_26234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (4))){
var inst_26152 = (state_26186[(2)]);
var state_26186__$1 = state_26186;
var statearr_26191_26235 = state_26186__$1;
(statearr_26191_26235[(2)] = inst_26152);

(statearr_26191_26235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (15))){
var inst_26179 = (state_26186[(2)]);
var state_26186__$1 = state_26186;
var statearr_26192_26236 = state_26186__$1;
(statearr_26192_26236[(2)] = inst_26179);

(statearr_26192_26236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (13))){
var inst_26170 = (state_26186[(7)]);
var inst_26172 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26170),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26173 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_26172);
var state_26186__$1 = state_26186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26186__$1,(16),inst_26173);
} else {
if((state_val_26187 === (6))){
var inst_26160 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_26186__$1 = state_26186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26186__$1,(9),inst_26160);
} else {
if((state_val_26187 === (3))){
var inst_26184 = (state_26186[(2)]);
var state_26186__$1 = state_26186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26186__$1,inst_26184);
} else {
if((state_val_26187 === (12))){
var inst_26170 = (state_26186[(7)]);
var inst_26170__$1 = (state_26186[(2)]);
var state_26186__$1 = (function (){var statearr_26193 = state_26186;
(statearr_26193[(7)] = inst_26170__$1);

return statearr_26193;
})();
if(cljs.core.truth_(inst_26170__$1)){
var statearr_26194_26237 = state_26186__$1;
(statearr_26194_26237[(1)] = (13));

} else {
var statearr_26195_26238 = state_26186__$1;
(statearr_26195_26238[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (2))){
var _ = (function (){var statearr_26196 = state_26186;
(statearr_26196[(4)] = cljs.core.cons((5),(state_26186[(4)])));

return statearr_26196;
})();
var inst_26158 = clojure.string.includes_QMARK_(tag_name,"/");
var state_26186__$1 = state_26186;
if(inst_26158){
var statearr_26197_26239 = state_26186__$1;
(statearr_26197_26239[(1)] = (6));

} else {
var statearr_26198_26240 = state_26186__$1;
(statearr_26198_26240[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (11))){
var inst_26168 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26186__$1 = state_26186;
var statearr_26200_26241 = state_26186__$1;
(statearr_26200_26241[(2)] = inst_26168);

(statearr_26200_26241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (9))){
var inst_26162 = (state_26186[(2)]);
var inst_26163 = fluree.db.util.async.throw_err(inst_26162);
var state_26186__$1 = state_26186;
var statearr_26201_26242 = state_26186__$1;
(statearr_26201_26242[(2)] = inst_26163);

(statearr_26201_26242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (5))){
var _ = (function (){var statearr_26202 = state_26186;
(statearr_26202[(4)] = cljs.core.rest((state_26186[(4)])));

return statearr_26202;
})();
var state_26186__$1 = state_26186;
var ex26199 = (state_26186__$1[(2)]);
var statearr_26203_26243 = state_26186__$1;
(statearr_26203_26243[(5)] = ex26199);


if((ex26199 instanceof Error)){
var statearr_26204_26244 = state_26186__$1;
(statearr_26204_26244[(1)] = (4));

(statearr_26204_26244[(5)] = null);

} else {
throw ex26199;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (14))){
var state_26186__$1 = state_26186;
var statearr_26205_26245 = state_26186__$1;
(statearr_26205_26245[(2)] = null);

(statearr_26205_26245[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (16))){
var inst_26175 = (state_26186[(2)]);
var inst_26176 = fluree.db.util.async.throw_err(inst_26175);
var state_26186__$1 = state_26186;
var statearr_26206_26246 = state_26186__$1;
(statearr_26206_26246[(2)] = inst_26176);

(statearr_26206_26246[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (10))){
var state_26186__$1 = state_26186;
var statearr_26207_26247 = state_26186__$1;
(statearr_26207_26247[(2)] = pred);

(statearr_26207_26247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26187 === (8))){
var inst_26181 = (state_26186[(2)]);
var _ = (function (){var statearr_26208 = state_26186;
(statearr_26208[(4)] = cljs.core.rest((state_26186[(4)])));

return statearr_26208;
})();
var state_26186__$1 = state_26186;
var statearr_26209_26248 = state_26186__$1;
(statearr_26209_26248[(2)] = inst_26181);

(statearr_26209_26248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2727__auto__ = null;
var fluree$db$graphdb$state_machine__2727__auto____0 = (function (){
var statearr_26210 = [null,null,null,null,null,null,null,null];
(statearr_26210[(0)] = fluree$db$graphdb$state_machine__2727__auto__);

(statearr_26210[(1)] = (1));

return statearr_26210;
});
var fluree$db$graphdb$state_machine__2727__auto____1 = (function (state_26186){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26186);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26211){var ex__2730__auto__ = e26211;
var statearr_26212_26249 = state_26186;
(statearr_26212_26249[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26186[(4)]))){
var statearr_26213_26250 = state_26186;
(statearr_26213_26250[(1)] = cljs.core.first((state_26186[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26251 = state_26186;
state_26186 = G__26251;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2727__auto__ = function(state_26186){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2727__auto____1.call(this,state_26186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2727__auto____0;
fluree$db$graphdb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2727__auto____1;
return fluree$db$graphdb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26214 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26214[(6)] = c__2749__auto__);

return statearr_26214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k26253,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__26257 = k26253;
var G__26257__$1 = (((G__26257 instanceof cljs.core.Keyword))?G__26257.fqn:null);
switch (G__26257__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26253,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__26258){
var vec__26259 = p__26258;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26259,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26259,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26252){
var self__ = this;
var G__26252__$1 = this;
return (new cljs.core.RecordIter((0),G__26252__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__26262 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__26262(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26254,other26255){
var self__ = this;
var this26254__$1 = this;
return (((!((other26255 == null)))) && ((((this26254__$1.constructor === other26255.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.conn,other26255.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.network,other26255.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.ledger_id,other26255.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.block,other26255.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.t,other26255.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.tt_id,other26255.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.stats,other26255.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.spot,other26255.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.psot,other26255.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.post,other26255.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.opst,other26255.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.tspo,other26255.tspo)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.schema,other26255.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.settings,other26255.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.comparators,other26255.comparators)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.schema_cache,other26255.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.novelty,other26255.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.permissions,other26255.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.fork,other26255.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.fork_block,other26255.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.current_db_fn,other26255.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26254__$1.__extmap,other26255.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k26253){
var self__ = this;
var this__4509__auto____$1 = this;
var G__26263 = k26253;
var G__26263__$1 = (((G__26263 instanceof cljs.core.Keyword))?G__26263.fqn:null);
switch (G__26263__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26253);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__26252){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__26264 = cljs.core.keyword_identical_QMARK_;
var expr__26265 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__26267 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__26268 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26267,G__26268) : pred__26264.call(null,G__26267,G__26268));
})())){
return (new fluree.db.graphdb.GraphDb(G__26252,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26269 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__26270 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26269,G__26270) : pred__26264.call(null,G__26269,G__26270));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26252,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26271 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__26272 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26271,G__26272) : pred__26264.call(null,G__26271,G__26272));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26252,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26273 = new cljs.core.Keyword(null,"block","block",664686210);
var G__26274 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26273,G__26274) : pred__26264.call(null,G__26273,G__26274));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__26252,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26275 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__26276 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26275,G__26276) : pred__26264.call(null,G__26275,G__26276));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__26252,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26277 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__26278 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26277,G__26278) : pred__26264.call(null,G__26277,G__26278));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__26252,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26279 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__26280 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26279,G__26280) : pred__26264.call(null,G__26279,G__26280));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__26252,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26281 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__26282 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26281,G__26282) : pred__26264.call(null,G__26281,G__26282));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__26252,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26283 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__26284 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26283,G__26284) : pred__26264.call(null,G__26283,G__26284));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26252,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26285 = new cljs.core.Keyword(null,"post","post",269697687);
var G__26286 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26285,G__26286) : pred__26264.call(null,G__26285,G__26286));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26252,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26287 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__26288 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26287,G__26288) : pred__26264.call(null,G__26287,G__26288));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26252,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26289 = new cljs.core.Keyword(null,"tspo","tspo",-440144953);
var G__26290 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26289,G__26290) : pred__26264.call(null,G__26289,G__26290));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26252,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26291 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__26292 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26291,G__26292) : pred__26264.call(null,G__26291,G__26292));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__26252,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26293 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__26294 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26293,G__26294) : pred__26264.call(null,G__26293,G__26294));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__26252,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26295 = new cljs.core.Keyword(null,"comparators","comparators",-1325611955);
var G__26296 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26295,G__26296) : pred__26264.call(null,G__26295,G__26296));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__26252,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26297 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__26298 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26297,G__26298) : pred__26264.call(null,G__26297,G__26298));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__26252,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26299 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__26300 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26299,G__26300) : pred__26264.call(null,G__26299,G__26300));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__26252,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26301 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__26302 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26301,G__26302) : pred__26264.call(null,G__26301,G__26302));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__26252,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26303 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__26304 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26303,G__26304) : pred__26264.call(null,G__26303,G__26304));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__26252,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26305 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__26306 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26305,G__26306) : pred__26264.call(null,G__26305,G__26306));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26252,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26307 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__26308 = expr__26265;
return (pred__26264.cljs$core$IFn$_invoke$arity$2 ? pred__26264.cljs$core$IFn$_invoke$arity$2(G__26307,G__26308) : pred__26264.call(null,G__26307,G__26308));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26252,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__26252),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__26252){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26252,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26256){
var extmap__4542__auto__ = (function (){var G__26309 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26256,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__26256)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26309);
} else {
return G__26309;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26256),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26256),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,clojure.data.avl.sorted_set_by(cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__26312 = fluree.db.index.default_comparators;
var map__26312__$1 = cljs.core.__destructure_map(map__26312);
var spot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch(network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch(network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch(network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch(network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch(network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
