// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15260){
var state_val_15261 = (state_15260[(1)]);
if((state_val_15261 === (1))){
var state_15260__$1 = state_15260;
var statearr_15262_15276 = state_15260__$1;
(statearr_15262_15276[(2)] = null);

(statearr_15262_15276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15261 === (2))){
var _ = (function (){var statearr_15263 = state_15260;
(statearr_15263[(4)] = cljs.core.cons((5),(state_15260[(4)])));

return statearr_15263;
})();
var inst_15251 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_15260__$1 = state_15260;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15260__$1,(6),inst_15251);
} else {
if((state_val_15261 === (3))){
var inst_15258 = (state_15260[(2)]);
var state_15260__$1 = state_15260;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15260__$1,inst_15258);
} else {
if((state_val_15261 === (4))){
var inst_15245 = (state_15260[(2)]);
var state_15260__$1 = state_15260;
var statearr_15265_15277 = state_15260__$1;
(statearr_15265_15277[(2)] = inst_15245);

(statearr_15265_15277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15261 === (5))){
var _ = (function (){var statearr_15266 = state_15260;
(statearr_15266[(4)] = cljs.core.rest((state_15260[(4)])));

return statearr_15266;
})();
var state_15260__$1 = state_15260;
var ex15264 = (state_15260__$1[(2)]);
var statearr_15267_15278 = state_15260__$1;
(statearr_15267_15278[(5)] = ex15264);


if((ex15264 instanceof Error)){
var statearr_15268_15279 = state_15260__$1;
(statearr_15268_15279[(1)] = (4));

(statearr_15268_15279[(5)] = null);

} else {
throw ex15264;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15261 === (6))){
var inst_15253 = (state_15260[(2)]);
var inst_15254 = fluree.db.util.async.throw_err(inst_15253);
var inst_15255 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_15254);
var _ = (function (){var statearr_15269 = state_15260;
(statearr_15269[(4)] = cljs.core.rest((state_15260[(4)])));

return statearr_15269;
})();
var state_15260__$1 = state_15260;
var statearr_15270_15280 = state_15260__$1;
(statearr_15270_15280[(2)] = inst_15255);

(statearr_15270_15280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0 = (function (){
var statearr_15271 = [null,null,null,null,null,null,null];
(statearr_15271[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__);

(statearr_15271[(1)] = (1));

return statearr_15271;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1 = (function (state_15260){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15260);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15272){var ex__2730__auto__ = e15272;
var statearr_15273_15281 = state_15260;
(statearr_15273_15281[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15260[(4)]))){
var statearr_15274_15282 = state_15260;
(statearr_15274_15282[(1)] = cljs.core.first((state_15260[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15283 = state_15260;
state_15260 = G__15283;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = function(state_15260){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1.call(this,state_15260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15275 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15275[(6)] = c__2749__auto__);

return statearr_15275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15315){
var state_val_15316 = (state_15315[(1)]);
if((state_val_15316 === (7))){
var inst_15299 = (state_15315[(7)]);
var inst_15301 = cljs.core.empty_QMARK_(inst_15299);
var inst_15302 = (!(inst_15301));
var state_15315__$1 = state_15315;
var statearr_15317_15341 = state_15315__$1;
(statearr_15317_15341[(2)] = inst_15302);

(statearr_15317_15341[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (1))){
var state_15315__$1 = state_15315;
var statearr_15318_15342 = state_15315__$1;
(statearr_15318_15342[(2)] = null);

(statearr_15318_15342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (4))){
var inst_15285 = (state_15315[(2)]);
var state_15315__$1 = state_15315;
var statearr_15319_15343 = state_15315__$1;
(statearr_15319_15343[(2)] = inst_15285);

(statearr_15319_15343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (6))){
var inst_15299 = (state_15315[(7)]);
var inst_15291 = (state_15315[(8)]);
var inst_15297 = (state_15315[(2)]);
var inst_15298 = fluree.db.util.async.throw_err(inst_15297);
var inst_15299__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_15291,inst_15298);
var state_15315__$1 = (function (){var statearr_15320 = state_15315;
(statearr_15320[(7)] = inst_15299__$1);

return statearr_15320;
})();
if(cljs.core.truth_(inst_15299__$1)){
var statearr_15321_15344 = state_15315__$1;
(statearr_15321_15344[(1)] = (7));

} else {
var statearr_15322_15345 = state_15315__$1;
(statearr_15322_15345[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (3))){
var inst_15313 = (state_15315[(2)]);
var state_15315__$1 = state_15315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15315__$1,inst_15313);
} else {
if((state_val_15316 === (12))){
var inst_15310 = (state_15315[(2)]);
var _ = (function (){var statearr_15323 = state_15315;
(statearr_15323[(4)] = cljs.core.rest((state_15315[(4)])));

return statearr_15323;
})();
var state_15315__$1 = state_15315;
var statearr_15324_15346 = state_15315__$1;
(statearr_15324_15346[(2)] = inst_15310);

(statearr_15324_15346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (2))){
var _ = (function (){var statearr_15325 = state_15315;
(statearr_15325[(4)] = cljs.core.cons((5),(state_15315[(4)])));

return statearr_15325;
})();
var inst_15291 = (function (){return (function (p1__15284_SHARP_){
return fluree.db.flake.o(p1__15284_SHARP_);
});
})();
var inst_15292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15293 = [pred_id];
var inst_15294 = (new cljs.core.PersistentVector(null,1,(5),inst_15292,inst_15293,null));
var inst_15295 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15294);
var state_15315__$1 = (function (){var statearr_15326 = state_15315;
(statearr_15326[(8)] = inst_15291);

return statearr_15326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15315__$1,(6),inst_15295);
} else {
if((state_val_15316 === (11))){
var state_15315__$1 = state_15315;
var statearr_15328_15347 = state_15315__$1;
(statearr_15328_15347[(2)] = true);

(statearr_15328_15347[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (9))){
var inst_15305 = (state_15315[(2)]);
var state_15315__$1 = state_15315;
if(cljs.core.truth_(inst_15305)){
var statearr_15329_15348 = state_15315__$1;
(statearr_15329_15348[(1)] = (10));

} else {
var statearr_15330_15349 = state_15315__$1;
(statearr_15330_15349[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (5))){
var _ = (function (){var statearr_15331 = state_15315;
(statearr_15331[(4)] = cljs.core.rest((state_15315[(4)])));

return statearr_15331;
})();
var state_15315__$1 = state_15315;
var ex15327 = (state_15315__$1[(2)]);
var statearr_15332_15350 = state_15315__$1;
(statearr_15332_15350[(5)] = ex15327);


if((ex15327 instanceof Error)){
var statearr_15333_15351 = state_15315__$1;
(statearr_15333_15351[(1)] = (4));

(statearr_15333_15351[(5)] = null);

} else {
throw ex15327;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (10))){
var inst_15299 = (state_15315[(7)]);
var inst_15307 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_15299);
var state_15315__$1 = state_15315;
var statearr_15334_15352 = state_15315__$1;
(statearr_15334_15352[(2)] = inst_15307);

(statearr_15334_15352[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15316 === (8))){
var inst_15299 = (state_15315[(7)]);
var state_15315__$1 = state_15315;
var statearr_15335_15353 = state_15315__$1;
(statearr_15335_15353[(2)] = inst_15299);

(statearr_15335_15353[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_15336 = [null,null,null,null,null,null,null,null,null];
(statearr_15336[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__);

(statearr_15336[(1)] = (1));

return statearr_15336;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1 = (function (state_15315){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15315);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15337){var ex__2730__auto__ = e15337;
var statearr_15338_15354 = state_15315;
(statearr_15338_15354[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15315[(4)]))){
var statearr_15339_15355 = state_15315;
(statearr_15339_15355[(1)] = cljs.core.first((state_15315[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15356 = state_15315;
state_15315 = G__15356;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = function(state_15315){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1.call(this,state_15315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15340 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15340[(6)] = c__2749__auto__);

return statearr_15340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15437){
var state_val_15438 = (state_15437[(1)]);
if((state_val_15438 === (7))){
var state_15437__$1 = state_15437;
var statearr_15439_15477 = state_15437__$1;
(statearr_15439_15477[(2)] = flakes);

(statearr_15439_15477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (20))){
var inst_15394 = (state_15437[(7)]);
var inst_15427 = (state_15437[(2)]);
var inst_15386 = inst_15394;
var inst_15387 = inst_15427;
var state_15437__$1 = (function (){var statearr_15440 = state_15437;
(statearr_15440[(8)] = inst_15386);

(statearr_15440[(9)] = inst_15387);

return statearr_15440;
})();
var statearr_15441_15478 = state_15437__$1;
(statearr_15441_15478[(2)] = null);

(statearr_15441_15478[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (1))){
var state_15437__$1 = state_15437;
var statearr_15442_15479 = state_15437__$1;
(statearr_15442_15479[(2)] = null);

(statearr_15442_15479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (4))){
var inst_15359 = (state_15437[(2)]);
var state_15437__$1 = state_15437;
var statearr_15443_15480 = state_15437__$1;
(statearr_15443_15480[(2)] = inst_15359);

(statearr_15443_15480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (15))){
var inst_15393 = (state_15437[(10)]);
var inst_15411 = fluree.db.flake.o(inst_15393);
var state_15437__$1 = state_15437;
var statearr_15444_15481 = state_15437__$1;
(statearr_15444_15481[(2)] = inst_15411);

(statearr_15444_15481[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (13))){
var inst_15430 = (state_15437[(2)]);
var state_15437__$1 = state_15437;
var statearr_15445_15482 = state_15437__$1;
(statearr_15445_15482[(2)] = inst_15430);

(statearr_15445_15482[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (6))){
var inst_15366 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_15437__$1 = state_15437;
var statearr_15446_15483 = state_15437__$1;
(statearr_15446_15483[(2)] = inst_15366);

(statearr_15446_15483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (17))){
var inst_15408 = (state_15437[(2)]);
var inst_15409 = fluree.db.util.async.throw_err(inst_15408);
var state_15437__$1 = state_15437;
var statearr_15447_15484 = state_15437__$1;
(statearr_15447_15484[(2)] = inst_15409);

(statearr_15447_15484[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (3))){
var inst_15435 = (state_15437[(2)]);
var state_15437__$1 = state_15437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15437__$1,inst_15435);
} else {
if((state_val_15438 === (12))){
var inst_15400 = (state_15437[(11)]);
var inst_15393 = (state_15437[(10)]);
var inst_15398 = fluree.db.flake.p(inst_15393);
var inst_15399 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15398);
var inst_15400__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_15399);
var inst_15401 = fluree.db.flake.op(inst_15393);
var inst_15402 = inst_15401 === false;
var inst_15403 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_15400__$1);
var state_15437__$1 = (function (){var statearr_15448 = state_15437;
(statearr_15448[(11)] = inst_15400__$1);

(statearr_15448[(12)] = inst_15402);

return statearr_15448;
})();
if(inst_15403){
var statearr_15449_15485 = state_15437__$1;
(statearr_15449_15485[(1)] = (14));

} else {
var statearr_15450_15486 = state_15437__$1;
(statearr_15450_15486[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (2))){
var _ = (function (){var statearr_15451 = state_15437;
(statearr_15451[(4)] = cljs.core.cons((5),(state_15437[(4)])));

return statearr_15451;
})();
var state_15437__$1 = state_15437;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_15452_15487 = state_15437__$1;
(statearr_15452_15487[(1)] = (6));

} else {
var statearr_15453_15488 = state_15437__$1;
(statearr_15453_15488[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (19))){
var inst_15413 = (state_15437[(13)]);
var inst_15400 = (state_15437[(11)]);
var inst_15387 = (state_15437[(9)]);
var inst_15393 = (state_15437[(10)]);
var inst_15421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15422 = fluree.db.flake.s(inst_15393);
var inst_15423 = [inst_15422,inst_15400,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15424 = (new cljs.core.PersistentVector(null,3,(5),inst_15421,inst_15423,null));
var inst_15425 = cljs.core.assoc_in(inst_15387,inst_15424,inst_15413);
var state_15437__$1 = state_15437;
var statearr_15454_15489 = state_15437__$1;
(statearr_15454_15489[(2)] = inst_15425);

(statearr_15454_15489[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (11))){
var inst_15387 = (state_15437[(9)]);
var state_15437__$1 = state_15437;
var statearr_15456_15490 = state_15437__$1;
(statearr_15456_15490[(2)] = inst_15387);

(statearr_15456_15490[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (9))){
var inst_15386 = (state_15437[(8)]);
var inst_15393 = (state_15437[(10)]);
var inst_15392 = cljs.core.seq(inst_15386);
var inst_15393__$1 = cljs.core.first(inst_15392);
var inst_15394 = cljs.core.next(inst_15392);
var inst_15395 = cljs.core.not(inst_15393__$1);
var state_15437__$1 = (function (){var statearr_15457 = state_15437;
(statearr_15457[(7)] = inst_15394);

(statearr_15457[(10)] = inst_15393__$1);

return statearr_15457;
})();
if(inst_15395){
var statearr_15458_15491 = state_15437__$1;
(statearr_15458_15491[(1)] = (11));

} else {
var statearr_15459_15492 = state_15437__$1;
(statearr_15459_15492[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (5))){
var _ = (function (){var statearr_15460 = state_15437;
(statearr_15460[(4)] = cljs.core.rest((state_15437[(4)])));

return statearr_15460;
})();
var state_15437__$1 = state_15437;
var ex15455 = (state_15437__$1[(2)]);
var statearr_15461_15493 = state_15437__$1;
(statearr_15461_15493[(5)] = ex15455);


if((ex15455 instanceof Error)){
var statearr_15462_15494 = state_15437__$1;
(statearr_15462_15494[(1)] = (4));

(statearr_15462_15494[(5)] = null);

} else {
throw ex15455;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (14))){
var inst_15393 = (state_15437[(10)]);
var inst_15405 = fluree.db.flake.o(inst_15393);
var inst_15406 = fluree.db.query.schema.convert_type_to_kw(inst_15405,db);
var state_15437__$1 = state_15437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15437__$1,(17),inst_15406);
} else {
if((state_val_15438 === (16))){
var inst_15402 = (state_15437[(12)]);
var inst_15413 = (state_15437[(2)]);
var state_15437__$1 = (function (){var statearr_15463 = state_15437;
(statearr_15463[(13)] = inst_15413);

return statearr_15463;
})();
if(cljs.core.truth_(inst_15402)){
var statearr_15464_15495 = state_15437__$1;
(statearr_15464_15495[(1)] = (18));

} else {
var statearr_15465_15496 = state_15437__$1;
(statearr_15465_15496[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (10))){
var inst_15432 = (state_15437[(2)]);
var _ = (function (){var statearr_15466 = state_15437;
(statearr_15466[(4)] = cljs.core.rest((state_15437[(4)])));

return statearr_15466;
})();
var state_15437__$1 = state_15437;
var statearr_15467_15497 = state_15437__$1;
(statearr_15467_15497[(2)] = inst_15432);

(statearr_15467_15497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (18))){
var inst_15413 = (state_15437[(13)]);
var inst_15400 = (state_15437[(11)]);
var inst_15387 = (state_15437[(9)]);
var inst_15393 = (state_15437[(10)]);
var inst_15415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15416 = fluree.db.flake.s(inst_15393);
var inst_15417 = [inst_15416,inst_15400,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15418 = (new cljs.core.PersistentVector(null,3,(5),inst_15415,inst_15417,null));
var inst_15419 = cljs.core.assoc_in(inst_15387,inst_15418,inst_15413);
var state_15437__$1 = state_15437;
var statearr_15468_15498 = state_15437__$1;
(statearr_15468_15498[(2)] = inst_15419);

(statearr_15468_15498[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15438 === (8))){
var inst_15369 = (state_15437[(2)]);
var inst_15370 = cljs.core.PersistentHashSet.EMPTY;
var inst_15371 = cljs.core.vals(tempids);
var inst_15372 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15370,inst_15371);
var inst_15373 = (function (){var pred_flakes = inst_15369;
var is_new_QMARK_ = inst_15372;
return (function (p1__15358_SHARP_,p2__15357_SHARP_){
var f = p2__15357_SHARP_;
return cljs.core.assoc_in(p1__15358_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s(f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__15469 = fluree.db.flake.s(f);
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__15469) : is_new_QMARK_.call(null,G__15469));
})()));
});
})();
var inst_15374 = cljs.core.PersistentHashMap.EMPTY;
var inst_15375 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_15373,inst_15374,inst_15369);
var inst_15383 = cljs.core.seq(inst_15369);
var inst_15384 = cljs.core.first(inst_15383);
var inst_15385 = cljs.core.next(inst_15383);
var inst_15386 = inst_15369;
var inst_15387 = inst_15375;
var state_15437__$1 = (function (){var statearr_15470 = state_15437;
(statearr_15470[(8)] = inst_15386);

(statearr_15470[(9)] = inst_15387);

(statearr_15470[(14)] = inst_15385);

(statearr_15470[(15)] = inst_15384);

return statearr_15470;
})();
var statearr_15471_15499 = state_15437__$1;
(statearr_15471_15499[(2)] = null);

(statearr_15471_15499[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0 = (function (){
var statearr_15472 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15472[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__);

(statearr_15472[(1)] = (1));

return statearr_15472;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1 = (function (state_15437){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15437);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15473){var ex__2730__auto__ = e15473;
var statearr_15474_15500 = state_15437;
(statearr_15474_15500[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15437[(4)]))){
var statearr_15475_15501 = state_15437;
(statearr_15475_15501[(1)] = cljs.core.first((state_15437[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15502 = state_15437;
state_15437 = G__15502;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = function(state_15437){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1.call(this,state_15437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15476 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15476[(6)] = c__2749__auto__);

return statearr_15476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__15504 = arguments.length;
switch (G__15504) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__15507 = arguments.length;
switch (G__15507) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15819){
var state_val_15820 = (state_15819[(1)]);
if((state_val_15820 === (121))){
var inst_15774 = (state_15819[(7)]);
var state_15819__$1 = state_15819;
var statearr_15821_16014 = state_15819__$1;
(statearr_15821_16014[(2)] = inst_15774);

(statearr_15821_16014[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (65))){
var inst_15673 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15673)){
var statearr_15822_16015 = state_15819__$1;
(statearr_15822_16015[(1)] = (66));

} else {
var statearr_15823_16016 = state_15819__$1;
(statearr_15823_16016[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (70))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15683 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_15684 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15683,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,3,inst_15683,null));
var inst_15685 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15684,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15684,null));
var inst_15686 = (inst_15685.cljs$core$IFn$_invoke$arity$1 ? inst_15685.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15685.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15686)){
var statearr_15824_16017 = state_15819__$1;
(statearr_15824_16017[(1)] = (72));

} else {
var statearr_15825_16018 = state_15819__$1;
(statearr_15825_16018[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (62))){
var inst_15663 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15826_16019 = state_15819__$1;
(statearr_15826_16019[(2)] = inst_15663);

(statearr_15826_16019[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (74))){
var inst_15769 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15827_16020 = state_15819__$1;
(statearr_15827_16020[(2)] = inst_15769);

(statearr_15827_16020[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (110))){
var inst_15796 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15796)){
var statearr_15828_16021 = state_15819__$1;
(statearr_15828_16021[(1)] = (117));

} else {
var statearr_15829_16022 = state_15819__$1;
(statearr_15829_16022[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (7))){
var inst_15814 = (state_15819[(2)]);
var _ = (function (){var statearr_15830 = state_15819;
(statearr_15830[(4)] = cljs.core.rest((state_15819[(4)])));

return statearr_15830;
})();
var state_15819__$1 = state_15819;
var statearr_15831_16023 = state_15819__$1;
(statearr_15831_16023[(2)] = inst_15814);

(statearr_15831_16023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (59))){
var inst_15667 = (state_15819[(10)]);
var inst_15547 = (state_15819[(11)]);
var inst_15666 = (state_15819[(2)]);
var inst_15667__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15547);
var state_15819__$1 = (function (){var statearr_15832 = state_15819;
(statearr_15832[(10)] = inst_15667__$1);

(statearr_15832[(12)] = inst_15666);

return statearr_15832;
})();
if(cljs.core.truth_(inst_15667__$1)){
var statearr_15833_16024 = state_15819__$1;
(statearr_15833_16024[(1)] = (63));

} else {
var statearr_15834_16025 = state_15819__$1;
(statearr_15834_16025[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (86))){
var inst_15709 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15835_16026 = state_15819__$1;
(statearr_15835_16026[(2)] = inst_15709);

(statearr_15835_16026[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (20))){
var inst_15573 = (state_15819[(13)]);
var inst_15547 = (state_15819[(11)]);
var inst_15573__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15547);
var state_15819__$1 = (function (){var statearr_15836 = state_15819;
(statearr_15836[(13)] = inst_15573__$1);

return statearr_15836;
})();
if(cljs.core.truth_(inst_15573__$1)){
var statearr_15837_16027 = state_15819__$1;
(statearr_15837_16027[(1)] = (23));

} else {
var statearr_15838_16028 = state_15819__$1;
(statearr_15838_16028[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (72))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15688 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15839_16029 = state_15819__$1;
(statearr_15839_16029[(2)] = inst_15688);

(statearr_15839_16029[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (58))){
var inst_15628 = (state_15819[(14)]);
var state_15819__$1 = state_15819;
var statearr_15840_16030 = state_15819__$1;
(statearr_15840_16030[(2)] = inst_15628);

(statearr_15840_16030[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (60))){
var inst_15546 = (state_15819[(15)]);
var inst_15535 = (state_15819[(16)]);
var inst_15654 = fluree.db.dbproto._p_prop(inst_15535,new cljs.core.Keyword(null,"name","name",1843675177),inst_15546);
var inst_15655 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15654)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_15656 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15657 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15658 = cljs.core.PersistentHashMap.fromArrays(inst_15656,inst_15657);
var inst_15659 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15655,inst_15658);
var inst_15660 = (function(){throw inst_15659})();
var state_15819__$1 = state_15819;
var statearr_15841_16031 = state_15819__$1;
(statearr_15841_16031[(2)] = inst_15660);

(statearr_15841_16031[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (27))){
var inst_15576 = (state_15819[(17)]);
var state_15819__$1 = state_15819;
var statearr_15842_16032 = state_15819__$1;
(statearr_15842_16032[(2)] = inst_15576);

(statearr_15842_16032[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (1))){
var state_15819__$1 = state_15819;
var statearr_15843_16033 = state_15819__$1;
(statearr_15843_16033[(2)] = null);

(statearr_15843_16033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (69))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_15844_16034 = state_15819__$1;
(statearr_15844_16034[(2)] = inst_15666);

(statearr_15844_16034[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (101))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15747 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15845_16035 = state_15819__$1;
(statearr_15845_16035[(2)] = inst_15747);

(statearr_15845_16035[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (24))){
var inst_15573 = (state_15819[(13)]);
var state_15819__$1 = state_15819;
var statearr_15846_16036 = state_15819__$1;
(statearr_15846_16036[(2)] = inst_15573);

(statearr_15846_16036[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (102))){
var inst_15749 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15847_16037 = state_15819__$1;
(statearr_15847_16037[(2)] = inst_15749);

(statearr_15847_16037[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (55))){
var inst_15645 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15848_16038 = state_15819__$1;
(statearr_15848_16038[(2)] = inst_15645);

(statearr_15848_16038[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (85))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15707 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15849_16039 = state_15819__$1;
(statearr_15849_16039[(2)] = inst_15707);

(statearr_15849_16039[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (39))){
var inst_15610 = (state_15819[(18)]);
var state_15819__$1 = state_15819;
var statearr_15850_16040 = state_15819__$1;
(statearr_15850_16040[(2)] = inst_15610);

(statearr_15850_16040[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (88))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_15851_16041 = state_15819__$1;
(statearr_15851_16041[(2)] = inst_15666);

(statearr_15851_16041[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (46))){
var inst_15629 = (state_15819[(19)]);
var inst_15547 = (state_15819[(11)]);
var inst_15628 = (state_15819[(2)]);
var inst_15629__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15547);
var state_15819__$1 = (function (){var statearr_15852 = state_15819;
(statearr_15852[(19)] = inst_15629__$1);

(statearr_15852[(14)] = inst_15628);

return statearr_15852;
})();
if(cljs.core.truth_(inst_15629__$1)){
var statearr_15853_16042 = state_15819__$1;
(statearr_15853_16042[(1)] = (47));

} else {
var statearr_15854_16043 = state_15819__$1;
(statearr_15854_16043[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (4))){
var inst_15508 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15855_16044 = state_15819__$1;
(statearr_15855_16044[(2)] = inst_15508);

(statearr_15855_16044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (77))){
var inst_15767 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15856_16045 = state_15819__$1;
(statearr_15856_16045[(2)] = inst_15767);

(statearr_15856_16045[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (106))){
var inst_15759 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15857_16046 = state_15819__$1;
(statearr_15857_16046[(2)] = inst_15759);

(statearr_15857_16046[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (119))){
var inst_15545 = (state_15819[(20)]);
var inst_15809 = (state_15819[(2)]);
var inst_15534 = inst_15545;
var inst_15535 = inst_15809;
var state_15819__$1 = (function (){var statearr_15858 = state_15819;
(statearr_15858[(21)] = inst_15534);

(statearr_15858[(16)] = inst_15535);

return statearr_15858;
})();
var statearr_15859_16047 = state_15819__$1;
(statearr_15859_16047[(2)] = null);

(statearr_15859_16047[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (95))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15731 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15732 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_15731,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,5,inst_15731,null));
var inst_15733 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15732,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15732,null));
var inst_15734 = (inst_15733.cljs$core$IFn$_invoke$arity$1 ? inst_15733.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15733.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15734)){
var statearr_15860_16048 = state_15819__$1;
(statearr_15860_16048[(1)] = (96));

} else {
var statearr_15861_16049 = state_15819__$1;
(statearr_15861_16049[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (54))){
var inst_15636 = (state_15819[(22)]);
var state_15819__$1 = state_15819;
var statearr_15862_16050 = state_15819__$1;
(statearr_15862_16050[(2)] = inst_15636);

(statearr_15862_16050[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (92))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_15863_16051 = state_15819__$1;
(statearr_15863_16051[(2)] = inst_15666);

(statearr_15863_16051[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (104))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_15864_16052 = state_15819__$1;
(statearr_15864_16052[(2)] = inst_15666);

(statearr_15864_16052[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (15))){
var inst_15555 = (state_15819[(23)]);
var state_15819__$1 = state_15819;
var statearr_15865_16053 = state_15819__$1;
(statearr_15865_16053[(2)] = inst_15555);

(statearr_15865_16053[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (48))){
var inst_15629 = (state_15819[(19)]);
var state_15819__$1 = state_15819;
var statearr_15866_16054 = state_15819__$1;
(statearr_15866_16054[(2)] = inst_15629);

(statearr_15866_16054[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (50))){
var inst_15547 = (state_15819[(11)]);
var inst_15636 = (state_15819[(22)]);
var inst_15634 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15635 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15634);
var inst_15636__$1 = inst_15635 === true;
var state_15819__$1 = (function (){var statearr_15867 = state_15819;
(statearr_15867[(22)] = inst_15636__$1);

return statearr_15867;
})();
if(cljs.core.truth_(inst_15636__$1)){
var statearr_15868_16055 = state_15819__$1;
(statearr_15868_16055[(1)] = (53));

} else {
var statearr_15869_16056 = state_15819__$1;
(statearr_15869_16056[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (116))){
var inst_15790 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15870_16057 = state_15819__$1;
(statearr_15870_16057[(2)] = inst_15790);

(statearr_15870_16057[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (75))){
var inst_15679 = (state_15819[(9)]);
var state_15819__$1 = state_15819;
var G__15871_16058 = inst_15679;
var G__15871_16059__$1 = (((G__15871_16058 instanceof cljs.core.Keyword))?G__15871_16058.fqn:null);
switch (G__15871_16059__$1) {
case "long":
var statearr_15872_16061 = state_15819__$1;
(statearr_15872_16061[(1)] = (79));


break;
case "bigint":
var statearr_15873_16062 = state_15819__$1;
(statearr_15873_16062[(1)] = (83));


break;
case "double":
var statearr_15874_16063 = state_15819__$1;
(statearr_15874_16063[(1)] = (87));


break;
case "float":
var statearr_15875_16064 = state_15819__$1;
(statearr_15875_16064[(1)] = (91));


break;
case "bigdec":
var statearr_15876_16065 = state_15819__$1;
(statearr_15876_16065[(1)] = (95));


break;
case "string":
var statearr_15877_16066 = state_15819__$1;
(statearr_15877_16066[(1)] = (99));


break;
case "instant":
var statearr_15878_16067 = state_15819__$1;
(statearr_15878_16067[(1)] = (103));


break;
default:
var statearr_15879_16068 = state_15819__$1;
(statearr_15879_16068[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (99))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15741 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_15742 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_15741,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,5,inst_15741,null));
var inst_15743 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15742,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15742,null));
var inst_15744 = (inst_15743.cljs$core$IFn$_invoke$arity$1 ? inst_15743.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15743.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15744)){
var statearr_15880_16069 = state_15819__$1;
(statearr_15880_16069[(1)] = (100));

} else {
var statearr_15881_16070 = state_15819__$1;
(statearr_15881_16070[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (21))){
var inst_15571 = (state_15819[(24)]);
var state_15819__$1 = state_15819;
var statearr_15882_16071 = state_15819__$1;
(statearr_15882_16071[(2)] = inst_15571);

(statearr_15882_16071[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (31))){
var inst_15587 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15883_16072 = state_15819__$1;
(statearr_15883_16072[(2)] = inst_15587);

(statearr_15883_16072[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (113))){
var inst_15793 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15884_16073 = state_15819__$1;
(statearr_15884_16073[(2)] = inst_15793);

(statearr_15884_16073[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (32))){
var state_15819__$1 = state_15819;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15885_16074 = state_15819__$1;
(statearr_15885_16074[(1)] = (35));

} else {
var statearr_15886_16075 = state_15819__$1;
(statearr_15886_16075[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (40))){
var inst_15623 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15623)){
var statearr_15887_16076 = state_15819__$1;
(statearr_15887_16076[(1)] = (44));

} else {
var statearr_15888_16077 = state_15819__$1;
(statearr_15888_16077[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (91))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15721 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15722 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15721,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,3,inst_15721,null));
var inst_15723 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15722,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15722,null));
var inst_15724 = (inst_15723.cljs$core$IFn$_invoke$arity$1 ? inst_15723.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15723.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15724)){
var statearr_15889_16078 = state_15819__$1;
(statearr_15889_16078[(1)] = (92));

} else {
var statearr_15890_16079 = state_15819__$1;
(statearr_15890_16079[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (117))){
var state_15819__$1 = state_15819;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15891_16080 = state_15819__$1;
(statearr_15891_16080[(1)] = (120));

} else {
var statearr_15892_16081 = state_15819__$1;
(statearr_15892_16081[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (108))){
var inst_15778 = (state_15819[(25)]);
var inst_15547 = (state_15819[(11)]);
var inst_15778__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15547);
var state_15819__$1 = (function (){var statearr_15893 = state_15819;
(statearr_15893[(25)] = inst_15778__$1);

return statearr_15893;
})();
if(cljs.core.truth_(inst_15778__$1)){
var statearr_15894_16082 = state_15819__$1;
(statearr_15894_16082[(1)] = (111));

} else {
var statearr_15895_16083 = state_15819__$1;
(statearr_15895_16083[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (56))){
var inst_15640 = (state_15819[(2)]);
var inst_15641 = fluree.db.util.async.throw_err(inst_15640);
var inst_15642 = cljs.core.not(inst_15641);
var state_15819__$1 = state_15819;
var statearr_15896_16084 = state_15819__$1;
(statearr_15896_16084[(2)] = inst_15642);

(statearr_15896_16084[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (33))){
var inst_15570 = (state_15819[(26)]);
var state_15819__$1 = state_15819;
var statearr_15897_16085 = state_15819__$1;
(statearr_15897_16085[(2)] = inst_15570);

(statearr_15897_16085[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (13))){
var inst_15565 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15565)){
var statearr_15898_16086 = state_15819__$1;
(statearr_15898_16086[(1)] = (17));

} else {
var statearr_15899_16087 = state_15819__$1;
(statearr_15899_16087[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (22))){
var inst_15596 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15596)){
var statearr_15900_16088 = state_15819__$1;
(statearr_15900_16088[(1)] = (32));

} else {
var statearr_15901_16089 = state_15819__$1;
(statearr_15901_16089[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (90))){
var inst_15719 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15902_16090 = state_15819__$1;
(statearr_15902_16090[(2)] = inst_15719);

(statearr_15902_16090[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (109))){
var inst_15776 = (state_15819[(27)]);
var state_15819__$1 = state_15819;
var statearr_15903_16091 = state_15819__$1;
(statearr_15903_16091[(2)] = inst_15776);

(statearr_15903_16091[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (36))){
var inst_15570 = (state_15819[(26)]);
var state_15819__$1 = state_15819;
var statearr_15904_16092 = state_15819__$1;
(statearr_15904_16092[(2)] = inst_15570);

(statearr_15904_16092[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (41))){
var inst_15547 = (state_15819[(11)]);
var inst_15615 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15616 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15615);
var inst_15617 = inst_15616 === true;
var state_15819__$1 = state_15819;
var statearr_15905_16093 = state_15819__$1;
(statearr_15905_16093[(2)] = inst_15617);

(statearr_15905_16093[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (118))){
var inst_15774 = (state_15819[(7)]);
var state_15819__$1 = state_15819;
var statearr_15906_16094 = state_15819__$1;
(statearr_15906_16094[(2)] = inst_15774);

(statearr_15906_16094[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (89))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15717 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15907_16095 = state_15819__$1;
(statearr_15907_16095[(2)] = inst_15717);

(statearr_15907_16095[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (100))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_15908_16096 = state_15819__$1;
(statearr_15908_16096[(2)] = inst_15666);

(statearr_15908_16096[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (122))){
var inst_15806 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15909_16097 = state_15819__$1;
(statearr_15909_16097[(2)] = inst_15806);

(statearr_15909_16097[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (43))){
var inst_15620 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15910_16098 = state_15819__$1;
(statearr_15910_16098[(2)] = inst_15620);

(statearr_15910_16098[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (61))){
var inst_15628 = (state_15819[(14)]);
var state_15819__$1 = state_15819;
var statearr_15911_16099 = state_15819__$1;
(statearr_15911_16099[(2)] = inst_15628);

(statearr_15911_16099[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (29))){
var inst_15547 = (state_15819[(11)]);
var inst_15582 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15583 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15582);
var inst_15584 = inst_15583 === true;
var state_15819__$1 = state_15819;
var statearr_15912_16100 = state_15819__$1;
(statearr_15912_16100[(2)] = inst_15584);

(statearr_15912_16100[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (44))){
var inst_15609 = (state_15819[(28)]);
var inst_15625 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_15609,"a component","a non-component",throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15913_16101 = state_15819__$1;
(statearr_15913_16101[(2)] = inst_15625);

(statearr_15913_16101[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (93))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15727 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15914_16102 = state_15819__$1;
(statearr_15914_16102[(2)] = inst_15727);

(statearr_15914_16102[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (6))){
var inst_15546 = (state_15819[(15)]);
var inst_15534 = (state_15819[(21)]);
var inst_15543 = cljs.core.seq(inst_15534);
var inst_15544 = cljs.core.first(inst_15543);
var inst_15545 = cljs.core.next(inst_15543);
var inst_15546__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15544,(0),null);
var inst_15547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15544,(1),null);
var inst_15548 = cljs.core.not(inst_15546__$1);
var state_15819__$1 = (function (){var statearr_15915 = state_15819;
(statearr_15915[(20)] = inst_15545);

(statearr_15915[(15)] = inst_15546__$1);

(statearr_15915[(11)] = inst_15547);

return statearr_15915;
})();
if(inst_15548){
var statearr_15916_16103 = state_15819__$1;
(statearr_15916_16103[(1)] = (8));

} else {
var statearr_15917_16104 = state_15819__$1;
(statearr_15917_16104[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (111))){
var inst_15782 = (state_15819[(29)]);
var inst_15547 = (state_15819[(11)]);
var inst_15780 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15781 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15780);
var inst_15782__$1 = inst_15781 === true;
var state_15819__$1 = (function (){var statearr_15918 = state_15819;
(statearr_15918[(29)] = inst_15782__$1);

return statearr_15918;
})();
if(cljs.core.truth_(inst_15782__$1)){
var statearr_15919_16105 = state_15819__$1;
(statearr_15919_16105[(1)] = (114));

} else {
var statearr_15920_16106 = state_15819__$1;
(statearr_15920_16106[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (28))){
var inst_15590 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15921_16107 = state_15819__$1;
(statearr_15921_16107[(2)] = inst_15590);

(statearr_15921_16107[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (64))){
var inst_15667 = (state_15819[(10)]);
var state_15819__$1 = state_15819;
var statearr_15922_16108 = state_15819__$1;
(statearr_15922_16108[(2)] = inst_15667);

(statearr_15922_16108[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (103))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15751 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15752 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_15751,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,2,inst_15751,null));
var inst_15753 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15752,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15752,null));
var inst_15754 = (inst_15753.cljs$core$IFn$_invoke$arity$1 ? inst_15753.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15753.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15754)){
var statearr_15923_16109 = state_15819__$1;
(statearr_15923_16109[(1)] = (104));

} else {
var statearr_15924_16110 = state_15819__$1;
(statearr_15924_16110[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (51))){
var inst_15632 = (state_15819[(30)]);
var state_15819__$1 = state_15819;
var statearr_15925_16111 = state_15819__$1;
(statearr_15925_16111[(2)] = inst_15632);

(statearr_15925_16111[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (25))){
var inst_15593 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15926_16112 = state_15819__$1;
(statearr_15926_16112[(2)] = inst_15593);

(statearr_15926_16112[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (34))){
var inst_15610 = (state_15819[(18)]);
var inst_15547 = (state_15819[(11)]);
var inst_15609 = (state_15819[(2)]);
var inst_15610__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15547);
var state_15819__$1 = (function (){var statearr_15927 = state_15819;
(statearr_15927[(18)] = inst_15610__$1);

(statearr_15927[(28)] = inst_15609);

return statearr_15927;
})();
if(cljs.core.truth_(inst_15610__$1)){
var statearr_15928_16113 = state_15819__$1;
(statearr_15928_16113[(1)] = (38));

} else {
var statearr_15929_16114 = state_15819__$1;
(statearr_15929_16114[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (17))){
var inst_15535 = (state_15819[(16)]);
var inst_15567 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_15535,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15930_16115 = state_15819__$1;
(statearr_15930_16115[(2)] = inst_15567);

(statearr_15930_16115[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (3))){
var inst_15817 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15819__$1,inst_15817);
} else {
if((state_val_15820 === (12))){
var inst_15551 = (state_15819[(31)]);
var state_15819__$1 = state_15819;
var statearr_15931_16116 = state_15819__$1;
(statearr_15931_16116[(2)] = inst_15551);

(statearr_15931_16116[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (2))){
var _ = (function (){var statearr_15932 = state_15819;
(statearr_15932[(4)] = cljs.core.cons((5),(state_15819[(4)])));

return statearr_15932;
})();
var inst_15527 = pred_changes;
var inst_15528 = cljs.core.seq(inst_15527);
var inst_15529 = cljs.core.first(inst_15528);
var inst_15530 = cljs.core.next(inst_15528);
var inst_15531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15529,(0),null);
var inst_15532 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15529,(1),null);
var inst_15533 = db;
var inst_15534 = inst_15527;
var inst_15535 = inst_15533;
var state_15819__$1 = (function (){var statearr_15933 = state_15819;
(statearr_15933[(32)] = inst_15532);

(statearr_15933[(33)] = inst_15531);

(statearr_15933[(34)] = inst_15530);

(statearr_15933[(21)] = inst_15534);

(statearr_15933[(16)] = inst_15535);

return statearr_15933;
})();
var statearr_15934_16117 = state_15819__$1;
(statearr_15934_16117[(2)] = null);

(statearr_15934_16117[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (66))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15547 = (state_15819[(11)]);
var inst_15676 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15677 = cljs.core.__destructure_map(inst_15676);
var inst_15678__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15677,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_15679__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15677,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_15680 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15679__$1,inst_15678__$1);
var state_15819__$1 = (function (){var statearr_15935 = state_15819;
(statearr_15935[(8)] = inst_15678__$1);

(statearr_15935[(9)] = inst_15679__$1);

return statearr_15935;
})();
if(inst_15680){
var statearr_15936_16118 = state_15819__$1;
(statearr_15936_16118[(1)] = (69));

} else {
var statearr_15937_16119 = state_15819__$1;
(statearr_15937_16119[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (107))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15761 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15938_16120 = state_15819__$1;
(statearr_15938_16120[(2)] = inst_15761);

(statearr_15938_16120[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (23))){
var inst_15547 = (state_15819[(11)]);
var inst_15576 = (state_15819[(17)]);
var inst_15575 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15576__$1 = inst_15575 === true;
var state_15819__$1 = (function (){var statearr_15939 = state_15819;
(statearr_15939[(17)] = inst_15576__$1);

return statearr_15939;
})();
if(cljs.core.truth_(inst_15576__$1)){
var statearr_15940_16121 = state_15819__$1;
(statearr_15940_16121[(1)] = (26));

} else {
var statearr_15941_16122 = state_15819__$1;
(statearr_15941_16122[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (47))){
var inst_15632 = (state_15819[(30)]);
var inst_15547 = (state_15819[(11)]);
var inst_15631 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15632__$1 = cljs.core.not(inst_15631);
var state_15819__$1 = (function (){var statearr_15942 = state_15819;
(statearr_15942[(30)] = inst_15632__$1);

return statearr_15942;
})();
if(inst_15632__$1){
var statearr_15943_16123 = state_15819__$1;
(statearr_15943_16123[(1)] = (50));

} else {
var statearr_15944_16124 = state_15819__$1;
(statearr_15944_16124[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (35))){
var inst_15599 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15600 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15601 = cljs.core.PersistentHashMap.fromArrays(inst_15599,inst_15600);
var inst_15602 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_15601);
var inst_15603 = (function(){throw inst_15602})();
var state_15819__$1 = state_15819;
var statearr_15945_16125 = state_15819__$1;
(statearr_15945_16125[(2)] = inst_15603);

(statearr_15945_16125[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (82))){
var inst_15699 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15946_16126 = state_15819__$1;
(statearr_15946_16126[(2)] = inst_15699);

(statearr_15946_16126[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (76))){
var state_15819__$1 = state_15819;
var statearr_15947_16127 = state_15819__$1;
(statearr_15947_16127[(2)] = null);

(statearr_15947_16127[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (97))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15737 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15948_16128 = state_15819__$1;
(statearr_15948_16128[(2)] = inst_15737);

(statearr_15948_16128[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (19))){
var inst_15571 = (state_15819[(24)]);
var inst_15547 = (state_15819[(11)]);
var inst_15570 = (state_15819[(2)]);
var inst_15571__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15547);
var state_15819__$1 = (function (){var statearr_15949 = state_15819;
(statearr_15949[(24)] = inst_15571__$1);

(statearr_15949[(26)] = inst_15570);

return statearr_15949;
})();
if(cljs.core.truth_(inst_15571__$1)){
var statearr_15950_16129 = state_15819__$1;
(statearr_15950_16129[(1)] = (20));

} else {
var statearr_15951_16130 = state_15819__$1;
(statearr_15951_16130[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (57))){
var state_15819__$1 = state_15819;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15952_16131 = state_15819__$1;
(statearr_15952_16131[(1)] = (60));

} else {
var statearr_15953_16132 = state_15819__$1;
(statearr_15953_16132[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (68))){
var inst_15776 = (state_15819[(27)]);
var inst_15547 = (state_15819[(11)]);
var inst_15774 = (state_15819[(2)]);
var inst_15775 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15776__$1 = inst_15775 === true;
var state_15819__$1 = (function (){var statearr_15954 = state_15819;
(statearr_15954[(7)] = inst_15774);

(statearr_15954[(27)] = inst_15776__$1);

return statearr_15954;
})();
if(cljs.core.truth_(inst_15776__$1)){
var statearr_15955_16133 = state_15819__$1;
(statearr_15955_16133[(1)] = (108));

} else {
var statearr_15956_16134 = state_15819__$1;
(statearr_15956_16134[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (11))){
var inst_15555 = (state_15819[(23)]);
var inst_15547 = (state_15819[(11)]);
var inst_15553 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15554 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15553);
var inst_15555__$1 = inst_15554 === false;
var state_15819__$1 = (function (){var statearr_15957 = state_15819;
(statearr_15957[(23)] = inst_15555__$1);

return statearr_15957;
})();
if(cljs.core.truth_(inst_15555__$1)){
var statearr_15958_16135 = state_15819__$1;
(statearr_15958_16135[(1)] = (14));

} else {
var statearr_15959_16136 = state_15819__$1;
(statearr_15959_16136[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (115))){
var inst_15782 = (state_15819[(29)]);
var state_15819__$1 = state_15819;
var statearr_15961_16137 = state_15819__$1;
(statearr_15961_16137[(2)] = inst_15782);

(statearr_15961_16137[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (9))){
var inst_15551 = (state_15819[(31)]);
var inst_15547 = (state_15819[(11)]);
var inst_15551__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15547);
var state_15819__$1 = (function (){var statearr_15962 = state_15819;
(statearr_15962[(31)] = inst_15551__$1);

return statearr_15962;
})();
if(cljs.core.truth_(inst_15551__$1)){
var statearr_15963_16138 = state_15819__$1;
(statearr_15963_16138[(1)] = (11));

} else {
var statearr_15964_16139 = state_15819__$1;
(statearr_15964_16139[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (5))){
var _ = (function (){var statearr_15965 = state_15819;
(statearr_15965[(4)] = cljs.core.rest((state_15819[(4)])));

return statearr_15965;
})();
var state_15819__$1 = state_15819;
var ex15960 = (state_15819__$1[(2)]);
var statearr_15966_16140 = state_15819__$1;
(statearr_15966_16140[(5)] = ex15960);


if((ex15960 instanceof Error)){
var statearr_15967_16141 = state_15819__$1;
(statearr_15967_16141[(1)] = (4));

(statearr_15967_16141[(5)] = null);

} else {
throw ex15960;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (112))){
var inst_15778 = (state_15819[(25)]);
var state_15819__$1 = state_15819;
var statearr_15968_16142 = state_15819__$1;
(statearr_15968_16142[(2)] = inst_15778);

(statearr_15968_16142[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (83))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15701 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15702 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15701,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,3,inst_15701,null));
var inst_15703 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15702,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15702,null));
var inst_15704 = (inst_15703.cljs$core$IFn$_invoke$arity$1 ? inst_15703.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15703.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15704)){
var statearr_15969_16143 = state_15819__$1;
(statearr_15969_16143[(1)] = (84));

} else {
var statearr_15970_16144 = state_15819__$1;
(statearr_15970_16144[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (14))){
var inst_15547 = (state_15819[(11)]);
var inst_15557 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15558 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15557);
var inst_15559 = inst_15558 === true;
var state_15819__$1 = state_15819;
var statearr_15971_16145 = state_15819__$1;
(statearr_15971_16145[(2)] = inst_15559);

(statearr_15971_16145[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (45))){
var inst_15609 = (state_15819[(28)]);
var state_15819__$1 = state_15819;
var statearr_15972_16146 = state_15819__$1;
(statearr_15972_16146[(2)] = inst_15609);

(statearr_15972_16146[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (53))){
var inst_15546 = (state_15819[(15)]);
var inst_15535 = (state_15819[(16)]);
var inst_15638 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_15535,inst_15546);
var state_15819__$1 = state_15819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15819__$1,(56),inst_15638);
} else {
if((state_val_15820 === (78))){
var inst_15764 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15973_16147 = state_15819__$1;
(statearr_15973_16147[(2)] = inst_15764);

(statearr_15973_16147[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (26))){
var inst_15580 = (state_15819[(35)]);
var inst_15547 = (state_15819[(11)]);
var inst_15578 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15579 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15578);
var inst_15580__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_15579);
var state_15819__$1 = (function (){var statearr_15974 = state_15819;
(statearr_15974[(35)] = inst_15580__$1);

return statearr_15974;
})();
if(inst_15580__$1){
var statearr_15975_16148 = state_15819__$1;
(statearr_15975_16148[(1)] = (29));

} else {
var statearr_15976_16149 = state_15819__$1;
(statearr_15976_16149[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (16))){
var inst_15562 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15977_16150 = state_15819__$1;
(statearr_15977_16150[(2)] = inst_15562);

(statearr_15977_16150[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (81))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15697 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15978_16151 = state_15819__$1;
(statearr_15978_16151[(2)] = inst_15697);

(statearr_15978_16151[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (120))){
var inst_15799 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15800 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15801 = cljs.core.PersistentHashMap.fromArrays(inst_15799,inst_15800);
var inst_15802 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_15801);
var inst_15803 = (function(){throw inst_15802})();
var state_15819__$1 = state_15819;
var statearr_15979_16152 = state_15819__$1;
(statearr_15979_16152[(2)] = inst_15803);

(statearr_15979_16152[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (79))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15691 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15692 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_15691,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,2,inst_15691,null));
var inst_15693 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15692,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15692,null));
var inst_15694 = (inst_15693.cljs$core$IFn$_invoke$arity$1 ? inst_15693.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15693.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15694)){
var statearr_15980_16153 = state_15819__$1;
(statearr_15980_16153[(1)] = (80));

} else {
var statearr_15981_16154 = state_15819__$1;
(statearr_15981_16154[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (38))){
var inst_15613 = (state_15819[(36)]);
var inst_15547 = (state_15819[(11)]);
var inst_15612 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15613__$1 = cljs.core.not(inst_15612);
var state_15819__$1 = (function (){var statearr_15982 = state_15819;
(statearr_15982[(36)] = inst_15613__$1);

return statearr_15982;
})();
if(inst_15613__$1){
var statearr_15983_16155 = state_15819__$1;
(statearr_15983_16155[(1)] = (41));

} else {
var statearr_15984_16156 = state_15819__$1;
(statearr_15984_16156[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (98))){
var inst_15739 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15985_16157 = state_15819__$1;
(statearr_15985_16157[(2)] = inst_15739);

(statearr_15985_16157[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (87))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15711 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15712 = (inst_15679.cljs$core$IFn$_invoke$arity$5 ? inst_15679.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15711,null) : inst_15679.call(null,cljs.core.PersistentArrayMap,null,3,inst_15711,null));
var inst_15713 = (inst_15679.cljs$core$IFn$_invoke$arity$4 ? inst_15679.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15712,null) : inst_15679.call(null,cljs.core.PersistentHashSet,null,inst_15712,null));
var inst_15714 = (inst_15713.cljs$core$IFn$_invoke$arity$1 ? inst_15713.cljs$core$IFn$_invoke$arity$1(inst_15678) : inst_15713.call(null,inst_15678));
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15714)){
var statearr_15986_16158 = state_15819__$1;
(statearr_15986_16158[(1)] = (88));

} else {
var statearr_15987_16159 = state_15819__$1;
(statearr_15987_16159[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (30))){
var inst_15580 = (state_15819[(35)]);
var state_15819__$1 = state_15819;
var statearr_15988_16160 = state_15819__$1;
(statearr_15988_16160[(2)] = inst_15580);

(statearr_15988_16160[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (73))){
var state_15819__$1 = state_15819;
var statearr_15989_16161 = state_15819__$1;
(statearr_15989_16161[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (96))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_15991_16162 = state_15819__$1;
(statearr_15991_16162[(2)] = inst_15666);

(statearr_15991_16162[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (10))){
var inst_15812 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15992_16163 = state_15819__$1;
(statearr_15992_16163[(2)] = inst_15812);

(statearr_15992_16163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (18))){
var inst_15535 = (state_15819[(16)]);
var state_15819__$1 = state_15819;
var statearr_15993_16164 = state_15819__$1;
(statearr_15993_16164[(2)] = inst_15535);

(statearr_15993_16164[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (105))){
var inst_15678 = (state_15819[(8)]);
var inst_15679 = (state_15819[(9)]);
var inst_15757 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15678,inst_15679,throw_QMARK_);
var state_15819__$1 = state_15819;
var statearr_15994_16165 = state_15819__$1;
(statearr_15994_16165[(2)] = inst_15757);

(statearr_15994_16165[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (52))){
var inst_15648 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15995_16166 = state_15819__$1;
(statearr_15995_16166[(2)] = inst_15648);

(statearr_15995_16166[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (114))){
var inst_15547 = (state_15819[(11)]);
var inst_15784 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15785 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15784);
var inst_15786 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_15785);
var inst_15787 = (!(inst_15786));
var state_15819__$1 = state_15819;
var statearr_15996_16167 = state_15819__$1;
(statearr_15996_16167[(2)] = inst_15787);

(statearr_15996_16167[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (67))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_15997_16168 = state_15819__$1;
(statearr_15997_16168[(2)] = inst_15666);

(statearr_15997_16168[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (71))){
var inst_15771 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_15998_16169 = state_15819__$1;
(statearr_15998_16169[(2)] = inst_15771);

(statearr_15998_16169[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (42))){
var inst_15613 = (state_15819[(36)]);
var state_15819__$1 = state_15819;
var statearr_15999_16170 = state_15819__$1;
(statearr_15999_16170[(2)] = inst_15613);

(statearr_15999_16170[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (80))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_16000_16171 = state_15819__$1;
(statearr_16000_16171[(2)] = inst_15666);

(statearr_16000_16171[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (37))){
var inst_15606 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_16001_16172 = state_15819__$1;
(statearr_16001_16172[(2)] = inst_15606);

(statearr_16001_16172[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (63))){
var inst_15547 = (state_15819[(11)]);
var inst_15669 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15670 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15669);
var state_15819__$1 = state_15819;
var statearr_16002_16173 = state_15819__$1;
(statearr_16002_16173[(2)] = inst_15670);

(statearr_16002_16173[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (94))){
var inst_15729 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
var statearr_16003_16174 = state_15819__$1;
(statearr_16003_16174[(2)] = inst_15729);

(statearr_16003_16174[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (8))){
var inst_15535 = (state_15819[(16)]);
var state_15819__$1 = state_15819;
var statearr_16004_16175 = state_15819__$1;
(statearr_16004_16175[(2)] = inst_15535);

(statearr_16004_16175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (49))){
var inst_15651 = (state_15819[(2)]);
var state_15819__$1 = state_15819;
if(cljs.core.truth_(inst_15651)){
var statearr_16005_16176 = state_15819__$1;
(statearr_16005_16176[(1)] = (57));

} else {
var statearr_16006_16177 = state_15819__$1;
(statearr_16006_16177[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15820 === (84))){
var inst_15666 = (state_15819[(12)]);
var state_15819__$1 = state_15819;
var statearr_16007_16178 = state_15819__$1;
(statearr_16007_16178[(2)] = inst_15666);

(statearr_16007_16178[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16008[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16008[(1)] = (1));

return statearr_16008;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_15819){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15819);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16009){var ex__2730__auto__ = e16009;
var statearr_16010_16179 = state_15819;
(statearr_16010_16179[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15819[(4)]))){
var statearr_16011_16180 = state_15819;
(statearr_16011_16180[(1)] = cljs.core.first((state_15819[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16181 = state_15819;
state_15819 = G__16181;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_15819){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_15819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16012 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16012[(6)] = c__2749__auto__);

return statearr_16012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16183 = arguments.length;
switch (G__16183) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16207){
var state_val_16208 = (state_16207[(1)]);
if((state_val_16208 === (7))){
var state_16207__$1 = state_16207;
var statearr_16209_16229 = state_16207__$1;
(statearr_16209_16229[(2)] = db);

(statearr_16209_16229[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16208 === (1))){
var state_16207__$1 = state_16207;
var statearr_16210_16230 = state_16207__$1;
(statearr_16210_16230[(2)] = null);

(statearr_16210_16230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16208 === (4))){
var inst_16184 = (state_16207[(2)]);
var state_16207__$1 = state_16207;
var statearr_16211_16231 = state_16207__$1;
(statearr_16211_16231[(2)] = inst_16184);

(statearr_16211_16231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16208 === (6))){
var inst_16193 = (state_16207[(7)]);
var inst_16192 = (state_16207[(2)]);
var inst_16193__$1 = fluree.db.util.async.throw_err(inst_16192);
var inst_16194 = cljs.core.empty_QMARK_(inst_16193__$1);
var state_16207__$1 = (function (){var statearr_16212 = state_16207;
(statearr_16212[(7)] = inst_16193__$1);

return statearr_16212;
})();
if(inst_16194){
var statearr_16213_16232 = state_16207__$1;
(statearr_16213_16232[(1)] = (7));

} else {
var statearr_16214_16233 = state_16207__$1;
(statearr_16214_16233[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16208 === (3))){
var inst_16205 = (state_16207[(2)]);
var state_16207__$1 = state_16207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16207__$1,inst_16205);
} else {
if((state_val_16208 === (2))){
var _ = (function (){var statearr_16216 = state_16207;
(statearr_16216[(4)] = cljs.core.cons((5),(state_16207[(4)])));

return statearr_16216;
})();
var inst_16190 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16207__$1 = state_16207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16207__$1,(6),inst_16190);
} else {
if((state_val_16208 === (9))){
var inst_16202 = (state_16207[(2)]);
var _ = (function (){var statearr_16217 = state_16207;
(statearr_16217[(4)] = cljs.core.rest((state_16207[(4)])));

return statearr_16217;
})();
var state_16207__$1 = state_16207;
var statearr_16218_16234 = state_16207__$1;
(statearr_16218_16234[(2)] = inst_16202);

(statearr_16218_16234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16208 === (5))){
var _ = (function (){var statearr_16219 = state_16207;
(statearr_16219[(4)] = cljs.core.rest((state_16207[(4)])));

return statearr_16219;
})();
var state_16207__$1 = state_16207;
var ex16215 = (state_16207__$1[(2)]);
var statearr_16220_16235 = state_16207__$1;
(statearr_16220_16235[(5)] = ex16215);


if((ex16215 instanceof Error)){
var statearr_16221_16236 = state_16207__$1;
(statearr_16221_16236[(1)] = (4));

(statearr_16221_16236[(5)] = null);

} else {
throw ex16215;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16208 === (10))){
var inst_16199 = (state_16207[(2)]);
var inst_16200 = fluree.db.util.async.throw_err(inst_16199);
var state_16207__$1 = state_16207;
var statearr_16222_16237 = state_16207__$1;
(statearr_16222_16237[(2)] = inst_16200);

(statearr_16222_16237[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16208 === (8))){
var inst_16193 = (state_16207[(7)]);
var inst_16197 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16193,db,true);
var state_16207__$1 = state_16207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16207__$1,(10),inst_16197);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16223 = [null,null,null,null,null,null,null,null];
(statearr_16223[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16223[(1)] = (1));

return statearr_16223;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16207){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16207);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16224){var ex__2730__auto__ = e16224;
var statearr_16225_16238 = state_16207;
(statearr_16225_16238[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16207[(4)]))){
var statearr_16226_16239 = state_16207;
(statearr_16226_16239[(1)] = cljs.core.first((state_16207[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16240 = state_16207;
state_16207 = G__16240;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16207){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16227 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16227[(6)] = c__2749__auto__);

return statearr_16227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16242 = arguments.length;
switch (G__16242) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16244 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16244,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16244,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16244,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = fluree.db.flake.p(flake);
var o = fluree.db.flake.o(flake);
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16247_SHARP_,p2__16248_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16247_SHARP_,p2__16248_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__16249_SHARP_){
var f = p1__16249_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,fluree.db.flake.p(f))){
return fluree.db.flake.o(f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16315){
var state_val_16316 = (state_16315[(1)]);
if((state_val_16316 === (1))){
var state_16315__$1 = state_16315;
var statearr_16317_16335 = state_16315__$1;
(statearr_16317_16335[(2)] = null);

(statearr_16317_16335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16316 === (2))){
var _ = (function (){var statearr_16318 = state_16315;
(statearr_16318[(4)] = cljs.core.cons((5),(state_16315[(4)])));

return statearr_16318;
})();
var inst_16267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16268 = fluree.db.flake.max_subject_id((1));
var inst_16269 = [inst_16268];
var inst_16270 = (new cljs.core.PersistentVector(null,1,(5),inst_16267,inst_16269,null));
var inst_16271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16272 = [(0)];
var inst_16273 = (new cljs.core.PersistentVector(null,1,(5),inst_16271,inst_16272,null));
var inst_16274 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16270,cljs.core._LT__EQ_,inst_16273);
var state_16315__$1 = state_16315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16315__$1,(6),inst_16274);
} else {
if((state_val_16316 === (3))){
var inst_16313 = (state_16315[(2)]);
var state_16315__$1 = state_16315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16315__$1,inst_16313);
} else {
if((state_val_16316 === (4))){
var inst_16255 = (state_16315[(2)]);
var state_16315__$1 = state_16315;
var statearr_16320_16336 = state_16315__$1;
(statearr_16320_16336[(2)] = inst_16255);

(statearr_16320_16336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16316 === (5))){
var _ = (function (){var statearr_16321 = state_16315;
(statearr_16321[(4)] = cljs.core.rest((state_16315[(4)])));

return statearr_16321;
})();
var state_16315__$1 = state_16315;
var ex16319 = (state_16315__$1[(2)]);
var statearr_16322_16337 = state_16315__$1;
(statearr_16322_16337[(5)] = ex16319);


if((ex16319 instanceof Error)){
var statearr_16323_16338 = state_16315__$1;
(statearr_16323_16338[(1)] = (4));

(statearr_16323_16338[(5)] = null);

} else {
throw ex16319;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16316 === (6))){
var inst_16276 = (state_16315[(2)]);
var inst_16277 = fluree.db.util.async.throw_err(inst_16276);
var inst_16278 = (function (){var schema_flakes = inst_16277;
return (function (p1__16250_SHARP_){
return (fluree.db.flake.s(p1__16250_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16279 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16278,inst_16277);
var inst_16280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16279,(0),null);
var inst_16281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16279,(1),null);
var inst_16282 = (function (){var schema_flakes = inst_16277;
var vec__16261 = inst_16279;
var collection_flakes = inst_16280;
var predicate_flakes = inst_16281;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = fluree.db.flake.s(first_flake);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__16253_SHARP_,p2__16252_SHARP_){
var f = p2__16252_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16253_SHARP_,fluree.db.flake.p(f),fluree.db.flake.o(f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_16283 = [(-1),"_tx"];
var inst_16284 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16285 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16286 = cljs.core.PersistentHashMap.fromArrays(inst_16284,inst_16285);
var inst_16287 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16288 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16289 = cljs.core.PersistentHashMap.fromArrays(inst_16287,inst_16288);
var inst_16290 = [inst_16286,inst_16289];
var inst_16291 = cljs.core.PersistentHashMap.fromArrays(inst_16283,inst_16290);
var inst_16292 = (function (){var schema_flakes = inst_16277;
var vec__16261 = inst_16279;
var collection_flakes = inst_16280;
var predicate_flakes = inst_16281;
return (function (p1__16251_SHARP_){
return fluree.db.flake.s(p1__16251_SHARP_);
});
})();
var inst_16293 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16292,inst_16280);
var inst_16294 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16282,inst_16291,inst_16293);
var inst_16296 = (function (){var schema_flakes = inst_16277;
var vec__16261 = inst_16279;
var collection_flakes = inst_16280;
var predicate_flakes = inst_16281;
var coll = inst_16294;
return (function (p__16295,pred_flakes){
var vec__16324 = p__16295;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16324,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16324,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = fluree.db.flake.s(first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__16327 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__16327.cljs$core$IFn$_invoke$arity$1 ? fexpr__16327.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__16327.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_16297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16298 = cljs.core.PersistentHashMap.EMPTY;
var inst_16299 = cljs.core.PersistentHashSet.EMPTY;
var inst_16300 = [inst_16298,inst_16299];
var inst_16301 = (new cljs.core.PersistentVector(null,2,(5),inst_16297,inst_16300,null));
var inst_16302 = (function (){var schema_flakes = inst_16277;
var vec__16261 = inst_16279;
var collection_flakes = inst_16280;
var predicate_flakes = inst_16281;
var coll = inst_16294;
return (function (p1__16254_SHARP_){
return fluree.db.flake.s(p1__16254_SHARP_);
});
})();
var inst_16303 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16302,inst_16281);
var inst_16304 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16296,inst_16301,inst_16303);
var inst_16305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16304,(0),null);
var inst_16306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16304,(1),null);
var inst_16307 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16308 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16309 = [inst_16308,inst_16294,inst_16305,inst_16306];
var inst_16310 = cljs.core.PersistentHashMap.fromArrays(inst_16307,inst_16309);
var _ = (function (){var statearr_16328 = state_16315;
(statearr_16328[(4)] = cljs.core.rest((state_16315[(4)])));

return statearr_16328;
})();
var state_16315__$1 = state_16315;
var statearr_16329_16339 = state_16315__$1;
(statearr_16329_16339[(2)] = inst_16310);

(statearr_16329_16339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0 = (function (){
var statearr_16330 = [null,null,null,null,null,null,null];
(statearr_16330[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2727__auto__);

(statearr_16330[(1)] = (1));

return statearr_16330;
});
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1 = (function (state_16315){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16315);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16331){var ex__2730__auto__ = e16331;
var statearr_16332_16340 = state_16315;
(statearr_16332_16340[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16315[(4)]))){
var statearr_16333_16341 = state_16315;
(statearr_16333_16341[(1)] = cljs.core.first((state_16315[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16342 = state_16315;
state_16315 = G__16342;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = function(state_16315){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1.call(this,state_16315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16334 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16334[(6)] = c__2749__auto__);

return statearr_16334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16384){
var state_val_16385 = (state_16384[(1)]);
if((state_val_16385 === (7))){
var inst_16367 = (state_16384[(2)]);
var inst_16368 = fluree.db.query.schema.flake__GT_pred_map(inst_16367);
var inst_16369 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16368,(114));
var inst_16371 = cljs.core.boolean$(inst_16370);
var inst_16372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16368,(110));
var inst_16373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16368,(117));
var inst_16374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_16373);
var inst_16375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16368,(111));
var inst_16376 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16368,(115));
var inst_16377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16368,(112));
var inst_16378 = [inst_16371,inst_16372,inst_16374,inst_16375,inst_16376,inst_16377];
var inst_16379 = cljs.core.PersistentHashMap.fromArrays(inst_16369,inst_16378);
var _ = (function (){var statearr_16386 = state_16384;
(statearr_16386[(4)] = cljs.core.rest((state_16384[(4)])));

return statearr_16386;
})();
var state_16384__$1 = state_16384;
var statearr_16387_16410 = state_16384__$1;
(statearr_16387_16410[(2)] = inst_16379);

(statearr_16387_16410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16385 === (1))){
var state_16384__$1 = state_16384;
var statearr_16388_16411 = state_16384__$1;
(statearr_16388_16411[(2)] = null);

(statearr_16388_16411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16385 === (4))){
var inst_16343 = (state_16384[(2)]);
var state_16384__$1 = state_16384;
var statearr_16389_16412 = state_16384__$1;
(statearr_16389_16412[(2)] = inst_16343);

(statearr_16389_16412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16385 === (6))){
var _ = (function (){var statearr_16390 = state_16384;
(statearr_16390[(4)] = cljs.core.cons((9),(state_16384[(4)])));

return statearr_16390;
})();
var inst_16355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16357 = ["_setting/id","root"];
var inst_16358 = (new cljs.core.PersistentVector(null,2,(5),inst_16356,inst_16357,null));
var inst_16359 = [inst_16358];
var inst_16360 = (new cljs.core.PersistentVector(null,1,(5),inst_16355,inst_16359,null));
var inst_16361 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16360);
var state_16384__$1 = state_16384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16384__$1,(10),inst_16361);
} else {
if((state_val_16385 === (3))){
var inst_16382 = (state_16384[(2)]);
var state_16384__$1 = state_16384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16384__$1,inst_16382);
} else {
if((state_val_16385 === (2))){
var _ = (function (){var statearr_16393 = state_16384;
(statearr_16393[(4)] = cljs.core.cons((5),(state_16384[(4)])));

return statearr_16393;
})();
var state_16384__$1 = state_16384;
var statearr_16394_16413 = state_16384__$1;
(statearr_16394_16413[(2)] = null);

(statearr_16394_16413[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16385 === (9))){
var _ = (function (){var statearr_16395 = state_16384;
(statearr_16395[(4)] = cljs.core.rest((state_16384[(4)])));

return statearr_16395;
})();
var state_16384__$1 = state_16384;
var ex16391 = (state_16384__$1[(2)]);
var statearr_16396_16414 = state_16384__$1;
(statearr_16396_16414[(5)] = ex16391);


var statearr_16397_16415 = state_16384__$1;
(statearr_16397_16415[(1)] = (8));

(statearr_16397_16415[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16385 === (5))){
var _ = (function (){var statearr_16398 = state_16384;
(statearr_16398[(4)] = cljs.core.rest((state_16384[(4)])));

return statearr_16398;
})();
var state_16384__$1 = state_16384;
var ex16392 = (state_16384__$1[(2)]);
var statearr_16399_16416 = state_16384__$1;
(statearr_16399_16416[(5)] = ex16392);


if((ex16392 instanceof Error)){
var statearr_16400_16417 = state_16384__$1;
(statearr_16400_16417[(1)] = (4));

(statearr_16400_16417[(5)] = null);

} else {
throw ex16392;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16385 === (10))){
var inst_16363 = (state_16384[(2)]);
var inst_16364 = fluree.db.util.async.throw_err(inst_16363);
var _ = (function (){var statearr_16401 = state_16384;
(statearr_16401[(4)] = cljs.core.rest((state_16384[(4)])));

return statearr_16401;
})();
var state_16384__$1 = state_16384;
var statearr_16402_16418 = state_16384__$1;
(statearr_16402_16418[(2)] = inst_16364);

(statearr_16402_16418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16385 === (8))){
var inst_16349 = (state_16384[(2)]);
var state_16384__$1 = (function (){var statearr_16403 = state_16384;
(statearr_16403[(7)] = inst_16349);

return statearr_16403;
})();
var statearr_16404_16419 = state_16384__$1;
(statearr_16404_16419[(2)] = null);

(statearr_16404_16419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0 = (function (){
var statearr_16405 = [null,null,null,null,null,null,null,null];
(statearr_16405[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2727__auto__);

(statearr_16405[(1)] = (1));

return statearr_16405;
});
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1 = (function (state_16384){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16384);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16406){var ex__2730__auto__ = e16406;
var statearr_16407_16420 = state_16384;
(statearr_16407_16420[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16384[(4)]))){
var statearr_16408_16421 = state_16384;
(statearr_16408_16421[(1)] = cljs.core.first((state_16384[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16422 = state_16384;
state_16384 = G__16422;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = function(state_16384){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1.call(this,state_16384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16409 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16409[(6)] = c__2749__auto__);

return statearr_16409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
