// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__22511){
var map__22512 = p__22511;
var map__22512__$1 = cljs.core.__destructure_map(map__22512);
var parsed_query = map__22512__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22512__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22512__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db(db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__22513){
var map__22514 = p__22513;
var map__22514__$1 = cljs.core.__destructure_map(map__22514);
var opts = map__22514__$1;
var rdf_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22514__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22514__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22558){
var state_val_22559 = (state_22558[(1)]);
if((state_val_22559 === (7))){
var inst_22537 = (state_22558[(7)]);
var inst_22539 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(inst_22537);
var state_22558__$1 = state_22558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22558__$1,(10),inst_22539);
} else {
if((state_val_22559 === (1))){
var inst_22522 = vars;
var inst_22523 = cljs.core.seq(inst_22522);
var inst_22524 = cljs.core.first(inst_22523);
var inst_22525 = cljs.core.next(inst_22523);
var inst_22526 = cljs.core.PersistentVector.EMPTY;
var inst_22527 = inst_22522;
var inst_22528 = inst_22526;
var state_22558__$1 = (function (){var statearr_22560 = state_22558;
(statearr_22560[(8)] = inst_22528);

(statearr_22560[(9)] = inst_22527);

(statearr_22560[(10)] = inst_22524);

(statearr_22560[(11)] = inst_22525);

return statearr_22560;
})();
var statearr_22561_22579 = state_22558__$1;
(statearr_22561_22579[(2)] = null);

(statearr_22561_22579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (4))){
var inst_22534 = (state_22558[(12)]);
var inst_22537 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_22534);
var state_22558__$1 = (function (){var statearr_22562 = state_22558;
(statearr_22562[(7)] = inst_22537);

return statearr_22562;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_22563_22580 = state_22558__$1;
(statearr_22563_22580[(1)] = (7));

} else {
var statearr_22564_22581 = state_22558__$1;
(statearr_22564_22581[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (6))){
var inst_22554 = (state_22558[(2)]);
var state_22558__$1 = state_22558;
var statearr_22565_22582 = state_22558__$1;
(statearr_22565_22582[(2)] = inst_22554);

(statearr_22565_22582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (3))){
var inst_22556 = (state_22558[(2)]);
var state_22558__$1 = state_22558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22558__$1,inst_22556);
} else {
if((state_val_22559 === (2))){
var inst_22534 = (state_22558[(12)]);
var inst_22527 = (state_22558[(9)]);
var inst_22533 = cljs.core.seq(inst_22527);
var inst_22534__$1 = cljs.core.first(inst_22533);
var inst_22535 = cljs.core.next(inst_22533);
var state_22558__$1 = (function (){var statearr_22566 = state_22558;
(statearr_22566[(12)] = inst_22534__$1);

(statearr_22566[(13)] = inst_22535);

return statearr_22566;
})();
if(cljs.core.truth_(inst_22534__$1)){
var statearr_22567_22583 = state_22558__$1;
(statearr_22567_22583[(1)] = (4));

} else {
var statearr_22568_22584 = state_22558__$1;
(statearr_22568_22584[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (11))){
var inst_22546 = (state_22558[(2)]);
var inst_22547 = fluree.db.util.async.throw_err(inst_22546);
var state_22558__$1 = state_22558;
var statearr_22569_22585 = state_22558__$1;
(statearr_22569_22585[(2)] = inst_22547);

(statearr_22569_22585[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (9))){
var inst_22528 = (state_22558[(8)]);
var inst_22535 = (state_22558[(13)]);
var inst_22549 = (state_22558[(2)]);
var inst_22550 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_22528,inst_22549);
var inst_22527 = inst_22535;
var inst_22528__$1 = inst_22550;
var state_22558__$1 = (function (){var statearr_22570 = state_22558;
(statearr_22570[(8)] = inst_22528__$1);

(statearr_22570[(9)] = inst_22527);

return statearr_22570;
})();
var statearr_22571_22586 = state_22558__$1;
(statearr_22571_22586[(2)] = null);

(statearr_22571_22586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (5))){
var inst_22528 = (state_22558[(8)]);
var state_22558__$1 = state_22558;
var statearr_22572_22587 = state_22558__$1;
(statearr_22572_22587[(2)] = inst_22528);

(statearr_22572_22587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (10))){
var inst_22541 = (state_22558[(2)]);
var inst_22542 = fluree.db.util.async.throw_err(inst_22541);
var state_22558__$1 = state_22558;
var statearr_22573_22588 = state_22558__$1;
(statearr_22573_22588[(2)] = inst_22542);

(statearr_22573_22588[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22559 === (8))){
var inst_22537 = (state_22558[(7)]);
var inst_22544 = fluree.db.query.subject_crawl.subject.subj_crawl(inst_22537);
var state_22558__$1 = state_22558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22558__$1,(11),inst_22544);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0 = (function (){
var statearr_22574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22574[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__);

(statearr_22574[(1)] = (1));

return statearr_22574;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1 = (function (state_22558){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22558);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22575){var ex__2730__auto__ = e22575;
var statearr_22576_22589 = state_22558;
(statearr_22576_22589[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22558[(4)]))){
var statearr_22577_22590 = state_22558;
(statearr_22577_22590[(1)] = cljs.core.first((state_22558[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22591 = state_22558;
state_22558 = G__22591;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = function(state_22558){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1.call(this,state_22558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22578 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22578[(6)] = c__2749__auto__);

return statearr_22578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__22593){
var map__22594 = p__22593;
var map__22594__$1 = cljs.core.__destructure_map(map__22594);
var parsed_query = map__22594__$1;
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22594__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22594__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22594__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var fns = (function (){var G__22595 = cljs.core.PersistentVector.EMPTY;
var G__22595__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__22595,(function (result){
return cljs.core.first(result);
})):G__22595);
var G__22595__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__22595__$1,(function (){var select_var = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__22592_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__22592_SHARP_]);
}),result);
});
})()):G__22595__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__22595__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results(result,order_by);
}));
} else {
return G__22595__$2;
}
})();
if(cljs.core.empty_QMARK_(fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__22596){
var map__22597 = p__22596;
var map__22597__$1 = cljs.core.__destructure_map(map__22597);
var parsed_query = map__22597__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22597__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22597__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22597__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22597__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22597__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22597__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var error_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var f_where = cljs.core.first(where);
var rdf_type_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second(where));
var cache = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_((0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec(db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn(parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,limit,offset,db,error_ch,cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding(opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl(opts);
}
}
});
