// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.reparse');
goog.require('cljs.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
/**
 * A filtering function in the :o space may utilize other supplied variables
 *   from {:vars {}} in the original query. This places those vars into the proper
 *   calling order of the function parameters that was generated during parsing.
 */
fluree.db.query.subject_crawl.reparse.fill_fn_params = (function fluree$db$query$subject_crawl$reparse$fill_fn_params(params,obj_val,obj_var,supplied_vars){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,param){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,obj_var)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,obj_val);
} else {
if(cljs.core.contains_QMARK_(supplied_vars,param)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.get.cljs$core$IFn$_invoke$arity$2(supplied_vars,param));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Variable used in filter function not included in 'vars' map: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}
}),cljs.core.PersistentVector.EMPTY,params);
});
/**
 * Merges all subsequent where clauses (rest where) for simple-subject-crawl
 *   into a map containing predicate filters.
 * 
 *   A simple-subject crawl will get a list of subjects and then pull all
 *   flakes for that subject in one lookup, instead of traditionally with multiple
 *   where clauses doing individual lookups per clauses.
 * 
 *   Instead of a lookup for every where clause, we therefore filter the subject
 *   flakes for the criteria of each where clause. This generates a single data
 *   structure that allows that filtering to happen. It looks like:
 * 
 *   {:required-p #{1001 1002 ...} - each where statement has a predicate that *must* be present
 * 1001 [(> % 42) (< % 10)] - for predicate 1001, list of filtering fns for the .-o value of each flake
 * 1002 [(= % hi)] }
 * 
 * Note that for multi-cardinality predicates, the prediate filters must pass for just one flake
 *   
 */
fluree.db.query.subject_crawl.reparse.merge_wheres_to_filter = (function fluree$db$query$subject_crawl$reparse$merge_wheres_to_filter(first_s,rest_where,supplied_vars){
var G__16708 = rest_where;
var vec__16709 = G__16708;
var seq__16710 = cljs.core.seq(vec__16709);
var first__16711 = cljs.core.first(seq__16710);
var seq__16710__$1 = cljs.core.next(seq__16710);
var map__16712 = first__16711;
var map__16712__$1 = cljs.core.__destructure_map(map__16712);
var where_smt = map__16712__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16712__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var s = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16712__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16712__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16712__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r = seq__16710__$1;
var required_p = cljs.core.PersistentHashSet.EMPTY;
var filter_map = cljs.core.PersistentArrayMap.EMPTY;
var G__16708__$1 = G__16708;
var required_p__$1 = required_p;
var filter_map__$1 = filter_map;
while(true){
var vec__16721 = G__16708__$1;
var seq__16722 = cljs.core.seq(vec__16721);
var first__16723 = cljs.core.first(seq__16722);
var seq__16722__$1 = cljs.core.next(seq__16722);
var map__16724 = first__16723;
var map__16724__$1 = cljs.core.__destructure_map(map__16724);
var where_smt__$1 = map__16724__$1;
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16724__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var s__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16724__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16724__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16724__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r__$1 = seq__16722__$1;
var required_p__$2 = required_p__$1;
var filter_map__$2 = filter_map__$1;
if(cljs.core.truth_(where_smt__$1)){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tuple","tuple",-472667284),type__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_s,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s__$1))))){
var map__16725 = o__$1;
var map__16725__$1 = cljs.core.__destructure_map(map__16725);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16725__$1,new cljs.core.Keyword(null,"value","value",305978217));
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16725__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16725__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var f = (cljs.core.truth_(value)?((function (G__16708__$1,required_p__$1,filter_map__$1,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,fluree.db.flake.o(flake));
});})(G__16708__$1,required_p__$1,filter_map__$1,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map))
:(cljs.core.truth_(filter)?(function (){var map__16726 = filter;
var map__16726__$1 = cljs.core.__destructure_map(map__16726);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16726__$1,new cljs.core.Keyword(null,"params","params",710516235));
var variable__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16726__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16726__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(params))){
return ((function (G__16708__$1,required_p__$1,filter_map__$1,map__16726,map__16726__$1,params,variable__$1,function$,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,_){
var G__16727 = fluree.db.flake.o(flake);
return (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(G__16727) : function$.call(null,G__16727));
});
;})(G__16708__$1,required_p__$1,filter_map__$1,map__16726,map__16726__$1,params,variable__$1,function$,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map))
} else {
return ((function (G__16708__$1,required_p__$1,filter_map__$1,map__16726,map__16726__$1,params,variable__$1,function$,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,vars){
var params__$1 = fluree.db.query.subject_crawl.reparse.fill_fn_params(params,fluree.db.flake.o(flake),variable__$1,vars);
var G__16728_16729 = ["Calling query-filter fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(filter)),"with params: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params__$1),"."].join('');
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1(G__16728_16729) : fluree.db.util.log.debug.call(null,G__16728_16729));

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(function$,params__$1);
});
;})(G__16708__$1,required_p__$1,filter_map__$1,map__16726,map__16726__$1,params,variable__$1,function$,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map))
}
})():(cljs.core.truth_((function (){var and__4251__auto__ = variable;
if(cljs.core.truth_(and__4251__auto__)){
return (supplied_vars.cljs$core$IFn$_invoke$arity$1 ? supplied_vars.cljs$core$IFn$_invoke$arity$1(variable) : supplied_vars.call(null,variable));
} else {
return and__4251__auto__;
}
})())?((function (G__16708__$1,required_p__$1,filter_map__$1,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,vars){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.o(flake),cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,variable));
});})(G__16708__$1,required_p__$1,filter_map__$1,map__16725,map__16725__$1,value,filter,variable,vec__16721,seq__16722,first__16723,seq__16722__$1,map__16724,map__16724__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__16708,vec__16709,seq__16710,first__16711,seq__16710__$1,map__16712,map__16712__$1,where_smt,type,s,p,o,r,required_p,filter_map))
:null)));
var G__16730 = r__$1;
var G__16731 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p__$1);
var G__16732 = (cljs.core.truth_(f)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(filter_map__$2,p__$1,fluree.db.util.core.conjv,f):filter_map__$2);
G__16708__$1 = G__16730;
required_p__$1 = G__16731;
filter_map__$1 = G__16732;
continue;
} else {
return null;
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(filter_map__$2,new cljs.core.Keyword(null,"required-p","required-p",-2091946078),required_p__$2);
}
break;
}
});
/**
 * Revises where clause for simple-subject-crawl query to optimize processing.
 *   If where does not end up meeting simple-subject-crawl criteria, returns nil
 *   so other strategies can be tried.
 */
fluree.db.query.subject_crawl.reparse.simple_subject_merge_where = (function fluree$db$query$subject_crawl$reparse$simple_subject_merge_where(p__16733){
var map__16734 = p__16733;
var map__16734__$1 = cljs.core.__destructure_map(map__16734);
var parsed_query = map__16734__$1;
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16734__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var supplied_vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16734__$1,new cljs.core.Keyword(null,"supplied-vars","supplied-vars",-919438628));
var first_where = cljs.core.first(where);
var rest_where = cljs.core.rest(where);
var first_type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(first_where);
var first_s = (cljs.core.truth_((function (){var and__4251__auto__ = (function (){var fexpr__16735 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("rdf","type","rdf/type",1175423232),null,new cljs.core.Keyword(null,"_id","_id",-789960287),null,new cljs.core.Keyword(null,"tuple","tuple",-472667284),null], null), null);
return (fexpr__16735.cljs$core$IFn$_invoke$arity$1 ? fexpr__16735.cljs$core$IFn$_invoke$arity$1(first_type) : fexpr__16735.call(null,first_type));
})();
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(first_where));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(first_where)):null);
if(cljs.core.truth_(first_s)){
if(cljs.core.empty_QMARK_(rest_where)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parsed_query,new cljs.core.Keyword(null,"strategy","strategy",-1471631918),new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044));
} else {
var temp__5802__auto__ = fluree.db.query.subject_crawl.reparse.merge_wheres_to_filter(first_s,rest_where,supplied_vars);
if(cljs.core.truth_(temp__5802__auto__)){
var subj_filter_map = temp__5802__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(parsed_query,new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_where,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020),subj_filter_map], null)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"strategy","strategy",-1471631918),new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044)], 0));
} else {
return null;
}
}
} else {
return null;
}
});
/**
 * Returns true if, when given parsed query, the select statement is a
 *   subject crawl - meaning there is nothing else in the :select except a
 *   graph crawl on a list of subjects
 */
fluree.db.query.subject_crawl.reparse.subject_crawl_QMARK_ = (function fluree$db$query$subject_crawl$reparse$subject_crawl_QMARK_(p__16736){
var map__16737 = p__16736;
var map__16737__$1 = cljs.core.__destructure_map(map__16737);
var _parsed_query = map__16737__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16737__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var and__4251__auto__ = new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444).cljs$core$IFn$_invoke$arity$1(select);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(new cljs.core.Keyword(null,"inVector?","inVector?",1948069375).cljs$core$IFn$_invoke$arity$1(select));
} else {
return and__4251__auto__;
}
});
/**
 * Simple subject crawl is where the same variable is used in the leading
 *   position of each where statement.
 */
fluree.db.query.subject_crawl.reparse.simple_subject_crawl_QMARK_ = (function fluree$db$query$subject_crawl$reparse$simple_subject_crawl_QMARK_(p__16739){
var map__16740 = p__16739;
var map__16740__$1 = cljs.core.__destructure_map(map__16740);
var _parsed_query = map__16740__$1;
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16740__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16740__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var select_var = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
if(cljs.core.truth_(select_var)){
return cljs.core.every_QMARK_((function (p1__16738_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(select_var,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(p1__16738_SHARP_)));
}),where);
} else {
return null;
}
});
/**
 * Returns true if query contains a single subject crawl.
 *   e.g.
 *   {:select {?subjects ['*']
 * :where [...]}
 */
fluree.db.query.subject_crawl.reparse.re_parse_as_simple_subj_crawl = (function fluree$db$query$subject_crawl$reparse$re_parse_as_simple_subj_crawl(parsed_query){
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.query.subject_crawl.reparse.subject_crawl_QMARK_(parsed_query);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = fluree.db.query.subject_crawl.reparse.simple_subject_crawl_QMARK_(parsed_query);
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core.not(new cljs.core.Keyword(null,"group-by","group-by",-379139802).cljs$core$IFn$_invoke$arity$1(parsed_query));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return fluree.db.query.subject_crawl.reparse.simple_subject_merge_where(parsed_query);
} else {
return null;
}
});
