// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
var G__17767_17770 = "XHTTP Request Error:";
var G__17768_17771 = e.request;
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__17767_17770,G__17768_17771) : fluree.db.util.log.error.call(null,G__17767_17770,G__17768_17771));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__17769 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17769,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__17769;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__17772 = opts;
var map__17772__$1 = cljs.core.__destructure_map(map__17772);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17772__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17772__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17772__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__17773 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__17773__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__17773,headers], 0)):G__17773);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17773__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__17773__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__17774 = opts;
var map__17774__$1 = cljs.core.__destructure_map(map__17774);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17774__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17774__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17774__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17774__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17774__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__17775 = cljs.core.PersistentArrayMap.EMPTY;
var G__17775__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__17775,headers], 0)):G__17775);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17775__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__17775__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__17776 = output_format;
var G__17776__$1 = (((G__17776 instanceof cljs.core.Keyword))?G__17776.fqn:null);
switch (G__17776__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__17778 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17778,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__17778;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17810){
var state_val_17811 = (state_17810[(1)]);
if((state_val_17811 === (7))){
var inst_17806 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
var statearr_17812_17837 = state_17810__$1;
(statearr_17812_17837[(2)] = inst_17806);

(statearr_17812_17837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (1))){
var state_17810__$1 = state_17810;
var statearr_17813_17838 = state_17810__$1;
(statearr_17813_17838[(2)] = null);

(statearr_17813_17838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (4))){
var inst_17781 = (state_17810[(7)]);
var inst_17781__$1 = (state_17810[(2)]);
var inst_17782 = (inst_17781__$1 == null);
var state_17810__$1 = (function (){var statearr_17814 = state_17810;
(statearr_17814[(7)] = inst_17781__$1);

return statearr_17814;
})();
if(cljs.core.truth_(inst_17782)){
var statearr_17815_17839 = state_17810__$1;
(statearr_17815_17839[(1)] = (5));

} else {
var statearr_17816_17840 = state_17810__$1;
(statearr_17816_17840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (6))){
var inst_17781 = (state_17810[(7)]);
var inst_17789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17781,(0),null);
var inst_17790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17781,(1),null);
var state_17810__$1 = (function (){var statearr_17817 = state_17810;
(statearr_17817[(8)] = inst_17790);

(statearr_17817[(9)] = inst_17789);

return statearr_17817;
})();
var statearr_17818_17841 = state_17810__$1;
(statearr_17818_17841[(2)] = null);

(statearr_17818_17841[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (3))){
var inst_17808 = (state_17810[(2)]);
var state_17810__$1 = state_17810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17810__$1,inst_17808);
} else {
if((state_val_17811 === (2))){
var state_17810__$1 = state_17810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17810__$1,(4),pub_chan);
} else {
if((state_val_17811 === (11))){
var _ = (function (){var statearr_17820 = state_17810;
(statearr_17820[(4)] = cljs.core.rest((state_17810[(4)])));

return statearr_17820;
})();
var state_17810__$1 = state_17810;
var ex17819 = (state_17810__$1[(2)]);
var statearr_17821_17842 = state_17810__$1;
(statearr_17821_17842[(5)] = ex17819);


var statearr_17822_17843 = state_17810__$1;
(statearr_17822_17843[(1)] = (10));

(statearr_17822_17843[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (9))){
var inst_17803 = (state_17810[(2)]);
var state_17810__$1 = (function (){var statearr_17823 = state_17810;
(statearr_17823[(10)] = inst_17803);

return statearr_17823;
})();
var statearr_17824_17844 = state_17810__$1;
(statearr_17824_17844[(2)] = null);

(statearr_17824_17844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (5))){
var inst_17784 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1("Web socket pub/producer channel closed.") : fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed."));
var state_17810__$1 = state_17810;
var statearr_17825_17845 = state_17810__$1;
(statearr_17825_17845[(2)] = inst_17784);

(statearr_17825_17845[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (10))){
var inst_17790 = (state_17810[(8)]);
var inst_17789 = (state_17810[(9)]);
var inst_17791 = (state_17810[(2)]);
var inst_17792 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_17791,"Error sending websocket message:",inst_17789) : fluree.db.util.log.error.call(null,inst_17791,"Error sending websocket message:",inst_17789));
var inst_17793 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17790,false);
var state_17810__$1 = (function (){var statearr_17826 = state_17810;
(statearr_17826[(11)] = inst_17792);

return statearr_17826;
})();
var statearr_17827_17846 = state_17810__$1;
(statearr_17827_17846[(2)] = inst_17793);

(statearr_17827_17846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17811 === (8))){
var inst_17790 = (state_17810[(8)]);
var inst_17789 = (state_17810[(9)]);
var _ = (function (){var statearr_17828 = state_17810;
(statearr_17828[(4)] = cljs.core.cons((11),(state_17810[(4)])));

return statearr_17828;
})();
var inst_17799 = ws.send(inst_17789);
var inst_17800 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17790,true);
var ___$1 = (function (){var statearr_17829 = state_17810;
(statearr_17829[(4)] = cljs.core.rest((state_17810[(4)])));

return statearr_17829;
})();
var state_17810__$1 = (function (){var statearr_17830 = state_17810;
(statearr_17830[(12)] = inst_17799);

return statearr_17830;
})();
var statearr_17831_17847 = state_17810__$1;
(statearr_17831_17847[(2)] = inst_17800);

(statearr_17831_17847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0 = (function (){
var statearr_17832 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17832[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__);

(statearr_17832[(1)] = (1));

return statearr_17832;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1 = (function (state_17810){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17810);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17833){var ex__2730__auto__ = e17833;
var statearr_17834_17848 = state_17810;
(statearr_17834_17848[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17810[(4)]))){
var statearr_17835_17849 = state_17810;
(statearr_17835_17849[(1)] = cljs.core.first((state_17810[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17850 = state_17810;
state_17810 = G__17850;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = function(state_17810){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1.call(this,state_17810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17836 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17836[(6)] = c__2749__auto__);

return statearr_17836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
var G__17851_17892 = "Websocket closed: ";
var G__17852_17893 = e.reason;
var G__17853_17894 = "Code: ";
var G__17854_17895 = e.code;
(fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4(G__17851_17892,G__17852_17893,G__17853_17894,G__17854_17895) : fluree.db.util.log.warn.call(null,G__17851_17892,G__17852_17893,G__17853_17894,G__17854_17895));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2749__auto___17896 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17879){
var state_val_17880 = (state_17879[(1)]);
if((state_val_17880 === (1))){
var inst_17858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17859 = [open_QMARK_,timeout_chan];
var inst_17860 = (new cljs.core.PersistentVector(null,2,(5),inst_17858,inst_17859,null));
var state_17879__$1 = state_17879;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_17879__$1,(2),inst_17860,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_17880 === (2))){
var inst_17862 = (state_17879[(2)]);
var inst_17863 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17862,(0),null);
var inst_17864 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17862,(1),null);
var inst_17865 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17864,timeout_chan);
var state_17879__$1 = (function (){var statearr_17881 = state_17879;
(statearr_17881[(7)] = inst_17863);

return statearr_17881;
})();
if(inst_17865){
var statearr_17882_17897 = state_17879__$1;
(statearr_17882_17897[(1)] = (3));

} else {
var statearr_17883_17898 = state_17879__$1;
(statearr_17883_17898[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (3))){
var inst_17867 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_17868 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17869 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_17870 = cljs.core.PersistentHashMap.fromArrays(inst_17868,inst_17869);
var inst_17871 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17867,inst_17870);
var inst_17872 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_17871);
var inst_17873 = fluree.db.util.xhttp.close_websocket(ws);
var state_17879__$1 = (function (){var statearr_17884 = state_17879;
(statearr_17884[(8)] = inst_17872);

return statearr_17884;
})();
var statearr_17885_17899 = state_17879__$1;
(statearr_17885_17899[(2)] = inst_17873);

(statearr_17885_17899[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (4))){
var inst_17875 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_17879__$1 = state_17879;
var statearr_17886_17900 = state_17879__$1;
(statearr_17886_17900[(2)] = inst_17875);

(statearr_17886_17900[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17880 === (5))){
var inst_17877 = (state_17879[(2)]);
var state_17879__$1 = state_17879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17879__$1,inst_17877);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_17887 = [null,null,null,null,null,null,null,null,null];
(statearr_17887[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__);

(statearr_17887[(1)] = (1));

return statearr_17887;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1 = (function (state_17879){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17879);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17888){var ex__2730__auto__ = e17888;
var statearr_17889_17901 = state_17879;
(statearr_17889_17901[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17879[(4)]))){
var statearr_17890_17902 = state_17879;
(statearr_17890_17902[(1)] = cljs.core.first((state_17879[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17903 = state_17879;
state_17879 = G__17903;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = function(state_17879){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1.call(this,state_17879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17891 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17891[(6)] = c__2749__auto___17896);

return statearr_17891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
