// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__37213(s__37214){
return (new cljs.core.LazySeq(null,(function (){
var s__37214__$1 = s__37214;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__37214__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37219 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37219,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37219,(1),null);
var iterys__4648__auto__ = ((function (s__37214__$1,vec__37219,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__37213_$_iter__37215(s__37216){
return (new cljs.core.LazySeq(null,((function (s__37214__$1,vec__37219,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__37216__$1 = s__37216;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__37216__$1);
if(temp__5753__auto____$1){
var s__37216__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__37216__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__37216__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__37218 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__37217 = (0);
while(true){
if((i__37217 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__37217);
cljs.core.chunk_append(b__37218,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__37271 = (i__37217 + (1));
i__37217 = G__37271;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37218),tailrecursion$priority_map$iter__37213_$_iter__37215(cljs.core.chunk_rest(s__37216__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37218),null);
}
} else {
var item = cljs.core.first(s__37216__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__37213_$_iter__37215(cljs.core.rest(s__37216__$2)));
}
} else {
return null;
}
break;
}
});})(s__37214__$1,vec__37219,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__37214__$1,vec__37219,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__37213(cljs.core.rest(s__37214__$1)));
} else {
var G__37272 = cljs.core.rest(s__37214__$1);
s__37214__$1 = G__37272;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__37222(s__37223){
return (new cljs.core.LazySeq(null,(function (){
var s__37223__$1 = s__37223;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__37223__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37228 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37228,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37228,(1),null);
var iterys__4648__auto__ = ((function (s__37223__$1,vec__37228,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__37222_$_iter__37224(s__37225){
return (new cljs.core.LazySeq(null,((function (s__37223__$1,vec__37228,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__37225__$1 = s__37225;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__37225__$1);
if(temp__5753__auto____$1){
var s__37225__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__37225__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__37225__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__37227 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__37226 = (0);
while(true){
if((i__37226 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__37226);
cljs.core.chunk_append(b__37227,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37273 = (i__37226 + (1));
i__37226 = G__37273;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37227),tailrecursion$priority_map$iter__37222_$_iter__37224(cljs.core.chunk_rest(s__37225__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37227),null);
}
} else {
var item = cljs.core.first(s__37225__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37222_$_iter__37224(cljs.core.rest(s__37225__$2)));
}
} else {
return null;
}
break;
}
});})(s__37223__$1,vec__37228,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__37223__$1,vec__37228,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__37222(cljs.core.rest(s__37223__$1)));
} else {
var G__37274 = cljs.core.rest(s__37223__$1);
s__37223__$1 = G__37274;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__37231 = item;
var G__37232 = new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517);
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__37231,G__37232) : self__.item__GT_priority.call(null,G__37231,G__37232));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__37233(s__37234){
return (new cljs.core.LazySeq(null,(function (){
var s__37234__$1 = s__37234;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__37234__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37239 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37239,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37239,(1),null);
var iterys__4648__auto__ = ((function (s__37234__$1,vec__37239,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__37233_$_iter__37235(s__37236){
return (new cljs.core.LazySeq(null,((function (s__37234__$1,vec__37239,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__37236__$1 = s__37236;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__37236__$1);
if(temp__5753__auto____$1){
var s__37236__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__37236__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__37236__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__37238 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__37237 = (0);
while(true){
if((i__37237 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__37237);
cljs.core.chunk_append(b__37238,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__37275 = (i__37237 + (1));
i__37237 = G__37275;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37238),tailrecursion$priority_map$iter__37233_$_iter__37235(cljs.core.chunk_rest(s__37236__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37238),null);
}
} else {
var item = cljs.core.first(s__37236__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__37233_$_iter__37235(cljs.core.rest(s__37236__$2)));
}
} else {
return null;
}
break;
}
});})(s__37234__$1,vec__37239,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__37234__$1,vec__37239,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__37233(cljs.core.rest(s__37234__$1)));
} else {
var G__37276 = cljs.core.rest(s__37234__$1);
s__37234__$1 = G__37276;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__37242(s__37243){
return (new cljs.core.LazySeq(null,(function (){
var s__37243__$1 = s__37243;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__37243__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37248 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37248,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37248,(1),null);
var iterys__4648__auto__ = ((function (s__37243__$1,vec__37248,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__37242_$_iter__37244(s__37245){
return (new cljs.core.LazySeq(null,((function (s__37243__$1,vec__37248,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__37245__$1 = s__37245;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__37245__$1);
if(temp__5753__auto____$1){
var s__37245__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__37245__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__37245__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__37247 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__37246 = (0);
while(true){
if((i__37246 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__37246);
cljs.core.chunk_append(b__37247,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37277 = (i__37246 + (1));
i__37246 = G__37277;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37247),tailrecursion$priority_map$iter__37242_$_iter__37244(cljs.core.chunk_rest(s__37245__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37247),null);
}
} else {
var item = cljs.core.first(s__37245__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37242_$_iter__37244(cljs.core.rest(s__37245__$2)));
}
} else {
return null;
}
break;
}
});})(s__37243__$1,vec__37248,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__37243__$1,vec__37248,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__37242(cljs.core.rest(s__37243__$1)));
} else {
var G__37278 = cljs.core.rest(s__37243__$1);
s__37243__$1 = G__37278;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__37279 = null;
var G__37279__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__37279__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__37279 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__37279__2.call(this,self__,item);
case 3:
return G__37279__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__37279.cljs$core$IFn$_invoke$arity$2 = G__37279__2;
G__37279.cljs$core$IFn$_invoke$arity$3 = G__37279__3;
return G__37279;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args37212){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args37212)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__37251 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__37251.cljs$core$IFn$_invoke$arity$1 ? fexpr__37251.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__37251.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__37252(s__37253){
return (new cljs.core.LazySeq(null,(function (){
var s__37253__$1 = s__37253;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__37253__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37258 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37258,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37258,(1),null);
var iterys__4648__auto__ = ((function (s__37253__$1,vec__37258,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__37252_$_iter__37254(s__37255){
return (new cljs.core.LazySeq(null,((function (s__37253__$1,vec__37258,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__37255__$1 = s__37255;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__37255__$1);
if(temp__5753__auto____$1){
var s__37255__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__37255__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__37255__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__37257 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__37256 = (0);
while(true){
if((i__37256 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__37256);
cljs.core.chunk_append(b__37257,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__37280 = (i__37256 + (1));
i__37256 = G__37280;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37257),tailrecursion$priority_map$iter__37252_$_iter__37254(cljs.core.chunk_rest(s__37255__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37257),null);
}
} else {
var item = cljs.core.first(s__37255__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__37252_$_iter__37254(cljs.core.rest(s__37255__$2)));
}
} else {
return null;
}
break;
}
});})(s__37253__$1,vec__37258,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__37253__$1,vec__37258,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__37252(cljs.core.rest(s__37253__$1)));
} else {
var G__37281 = cljs.core.rest(s__37253__$1);
s__37253__$1 = G__37281;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__37261(s__37262){
return (new cljs.core.LazySeq(null,(function (){
var s__37262__$1 = s__37262;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__37262__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__37267 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37267,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37267,(1),null);
var iterys__4648__auto__ = ((function (s__37262__$1,vec__37267,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__37261_$_iter__37263(s__37264){
return (new cljs.core.LazySeq(null,((function (s__37262__$1,vec__37267,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__37264__$1 = s__37264;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__37264__$1);
if(temp__5753__auto____$1){
var s__37264__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__37264__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__37264__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__37266 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__37265 = (0);
while(true){
if((i__37265 < size__4651__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__37265);
cljs.core.chunk_append(b__37266,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37282 = (i__37265 + (1));
i__37265 = G__37282;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37266),tailrecursion$priority_map$iter__37261_$_iter__37263(cljs.core.chunk_rest(s__37264__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37266),null);
}
} else {
var item = cljs.core.first(s__37264__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37261_$_iter__37263(cljs.core.rest(s__37264__$2)));
}
} else {
return null;
}
break;
}
});})(s__37262__$1,vec__37267,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__37262__$1,vec__37267,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq(iterys__4648__auto__(item_set));
if(fs__4649__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4649__auto__,tailrecursion$priority_map$iter__37261(cljs.core.rest(s__37262__$1)));
} else {
var G__37283 = cljs.core.rest(s__37262__$1);
s__37262__$1 = G__37283;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__37270 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__37270) : self__.keyfn.call(null,G__37270));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__37285 = arguments.length;
switch (G__37285) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___37288 = arguments.length;
var i__4865__auto___37289 = (0);
while(true){
if((i__4865__auto___37289 < len__4864__auto___37288)){
args__4870__auto__.push((arguments[i__4865__auto___37289]));

var G__37290 = (i__4865__auto___37289 + (1));
i__4865__auto___37289 = G__37290;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__37291 = cljs.core.nnext(in$);
var G__37292 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__37291;
out = G__37292;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq37287){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37287));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4870__auto__ = [];
var len__4864__auto___37295 = arguments.length;
var i__4865__auto___37296 = (0);
while(true){
if((i__4865__auto___37296 < len__4864__auto___37295)){
args__4870__auto__.push((arguments[i__4865__auto___37296]));

var G__37297 = (i__4865__auto___37296 + (1));
i__4865__auto___37296 = G__37297;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__37298 = cljs.core.nnext(in$);
var G__37299 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__37298;
out = G__37299;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq37293){
var G__37294 = cljs.core.first(seq37293);
var seq37293__$1 = cljs.core.next(seq37293);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37294,seq37293__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4870__auto__ = [];
var len__4864__auto___37302 = arguments.length;
var i__4865__auto___37303 = (0);
while(true){
if((i__4865__auto___37303 < len__4864__auto___37302)){
args__4870__auto__.push((arguments[i__4865__auto___37303]));

var G__37304 = (i__4865__auto___37303 + (1));
i__4865__auto___37303 = G__37304;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__37305 = cljs.core.nnext(in$);
var G__37306 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__37305;
out = G__37306;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq37300){
var G__37301 = cljs.core.first(seq37300);
var seq37300__$1 = cljs.core.next(seq37300);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37301,seq37300__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4870__auto__ = [];
var len__4864__auto___37310 = arguments.length;
var i__4865__auto___37311 = (0);
while(true){
if((i__4865__auto___37311 < len__4864__auto___37310)){
args__4870__auto__.push((arguments[i__4865__auto___37311]));

var G__37312 = (i__4865__auto___37311 + (1));
i__4865__auto___37311 = G__37312;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__37313 = cljs.core.nnext(in$);
var G__37314 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__37313;
out = G__37314;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq37307){
var G__37308 = cljs.core.first(seq37307);
var seq37307__$1 = cljs.core.next(seq37307);
var G__37309 = cljs.core.first(seq37307__$1);
var seq37307__$2 = cljs.core.next(seq37307__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37308,G__37309,seq37307__$2);
}));

