// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__80614 = arguments.length;
switch (G__80614) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___80653 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80635){
var state_val_80636 = (state_80635[(1)]);
if((state_val_80636 === (1))){
var state_80635__$1 = state_80635;
var statearr_80637_80654 = state_80635__$1;
(statearr_80637_80654[(2)] = null);

(statearr_80637_80654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80636 === (2))){
var _ = (function (){var statearr_80638 = state_80635;
(statearr_80638[(4)] = cljs.core.cons((5),(state_80635[(4)])));

return statearr_80638;
})();
var inst_80621 = fluree.db.session.db(conn,ledger,null);
var state_80635__$1 = state_80635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80635__$1,(7),inst_80621);
} else {
if((state_val_80636 === (3))){
var inst_80631 = (state_80635[(2)]);
var inst_80632 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_80631);
var inst_80633 = cljs.core.async.close_BANG_(pc);
var state_80635__$1 = (function (){var statearr_80640 = state_80635;
(statearr_80640[(7)] = inst_80632);

return statearr_80640;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_80635__$1,inst_80633);
} else {
if((state_val_80636 === (4))){
var inst_80615 = (state_80635[(2)]);
var state_80635__$1 = state_80635;
var statearr_80641_80655 = state_80635__$1;
(statearr_80641_80655[(2)] = inst_80615);

(statearr_80641_80655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80636 === (5))){
var _ = (function (){var statearr_80642 = state_80635;
(statearr_80642[(4)] = cljs.core.rest((state_80635[(4)])));

return statearr_80642;
})();
var state_80635__$1 = state_80635;
var ex80639 = (state_80635__$1[(2)]);
var statearr_80643_80656 = state_80635__$1;
(statearr_80643_80656[(5)] = ex80639);


var statearr_80644_80657 = state_80635__$1;
(statearr_80644_80657[(1)] = (4));

(statearr_80644_80657[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80636 === (6))){
var inst_80627 = (state_80635[(2)]);
var inst_80628 = fluree.db.util.async.throw_err(inst_80627);
var _ = (function (){var statearr_80645 = state_80635;
(statearr_80645[(4)] = cljs.core.rest((state_80635[(4)])));

return statearr_80645;
})();
var state_80635__$1 = state_80635;
var statearr_80646_80658 = state_80635__$1;
(statearr_80646_80658[(2)] = inst_80628);

(statearr_80646_80658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80636 === (7))){
var inst_80623 = (state_80635[(2)]);
var inst_80624 = fluree.db.util.async.throw_err(inst_80623);
var inst_80625 = fluree.db.time_travel.as_of_block(inst_80624,block);
var state_80635__$1 = state_80635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80635__$1,(6),inst_80625);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_80647 = [null,null,null,null,null,null,null,null];
(statearr_80647[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_80647[(1)] = (1));

return statearr_80647;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_80635){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80635);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80648){var ex__2730__auto__ = e80648;
var statearr_80649_80659 = state_80635;
(statearr_80649_80659[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80635[(4)]))){
var statearr_80650_80660 = state_80635;
(statearr_80650_80660[(1)] = cljs.core.first((state_80635[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80661 = state_80635;
state_80635 = G__80661;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_80635){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_80635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80651 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80651[(6)] = c__2749__auto___80653);

return statearr_80651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80702){
var state_val_80703 = (state_80702[(1)]);
if((state_val_80703 === (7))){
var inst_80671 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_80702__$1 = state_80702;
if(inst_80671){
var statearr_80704_80735 = state_80702__$1;
(statearr_80704_80735[(1)] = (9));

} else {
var statearr_80705_80736 = state_80702__$1;
(statearr_80705_80736[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (1))){
var state_80702__$1 = state_80702;
var statearr_80706_80737 = state_80702__$1;
(statearr_80706_80737[(2)] = null);

(statearr_80706_80737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (4))){
var inst_80662 = (state_80702[(2)]);
var state_80702__$1 = state_80702;
var statearr_80707_80738 = state_80702__$1;
(statearr_80707_80738[(2)] = inst_80662);

(statearr_80707_80738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (15))){
var inst_80679 = (state_80702[(7)]);
var inst_80678 = (state_80702[(2)]);
var inst_80679__$1 = fluree.db.util.async.throw_err(inst_80678);
var state_80702__$1 = (function (){var statearr_80708 = state_80702;
(statearr_80708[(7)] = inst_80679__$1);

return statearr_80708;
})();
if(cljs.core.truth_(inst_80679__$1)){
var statearr_80709_80739 = state_80702__$1;
(statearr_80709_80739[(1)] = (16));

} else {
var statearr_80710_80740 = state_80702__$1;
(statearr_80710_80740[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (13))){
var state_80702__$1 = state_80702;
var statearr_80711_80741 = state_80702__$1;
(statearr_80711_80741[(2)] = null);

(statearr_80711_80741[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (6))){
var state_80702__$1 = state_80702;
var statearr_80712_80742 = state_80702__$1;
(statearr_80712_80742[(2)] = db);

(statearr_80712_80742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (17))){
var inst_80683 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_80684 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80685 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_80686 = cljs.core.PersistentHashMap.fromArrays(inst_80684,inst_80685);
var inst_80687 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_80683,inst_80686);
var inst_80688 = (function(){throw inst_80687})();
var state_80702__$1 = state_80702;
var statearr_80713_80743 = state_80702__$1;
(statearr_80713_80743[(2)] = inst_80688);

(statearr_80713_80743[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (3))){
var inst_80700 = (state_80702[(2)]);
var state_80702__$1 = state_80702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80702__$1,inst_80700);
} else {
if((state_val_80703 === (12))){
var inst_80676 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_80702__$1 = state_80702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80702__$1,(15),inst_80676);
} else {
if((state_val_80703 === (2))){
var _ = (function (){var statearr_80714 = state_80702;
(statearr_80714[(4)] = cljs.core.cons((5),(state_80702[(4)])));

return statearr_80714;
})();
var inst_80668 = cljs.core.not(auth);
var state_80702__$1 = state_80702;
if(inst_80668){
var statearr_80715_80744 = state_80702__$1;
(statearr_80715_80744[(1)] = (6));

} else {
var statearr_80716_80745 = state_80702__$1;
(statearr_80716_80745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (11))){
var inst_80695 = (state_80702[(2)]);
var state_80702__$1 = state_80702;
var statearr_80718_80746 = state_80702__$1;
(statearr_80718_80746[(2)] = inst_80695);

(statearr_80718_80746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (9))){
var inst_80673 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_80702__$1 = state_80702;
var statearr_80719_80747 = state_80702__$1;
(statearr_80719_80747[(2)] = inst_80673);

(statearr_80719_80747[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (5))){
var _ = (function (){var statearr_80720 = state_80702;
(statearr_80720[(4)] = cljs.core.rest((state_80702[(4)])));

return statearr_80720;
})();
var state_80702__$1 = state_80702;
var ex80717 = (state_80702__$1[(2)]);
var statearr_80721_80748 = state_80702__$1;
(statearr_80721_80748[(5)] = ex80717);


if((ex80717 instanceof Error)){
var statearr_80722_80749 = state_80702__$1;
(statearr_80722_80749[(1)] = (4));

(statearr_80722_80749[(5)] = null);

} else {
throw ex80717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (14))){
var inst_80693 = (state_80702[(2)]);
var state_80702__$1 = state_80702;
var statearr_80723_80750 = state_80702__$1;
(statearr_80723_80750[(2)] = inst_80693);

(statearr_80723_80750[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (16))){
var inst_80679 = (state_80702[(7)]);
var inst_80681 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_80679);
var state_80702__$1 = state_80702;
var statearr_80724_80751 = state_80702__$1;
(statearr_80724_80751[(2)] = inst_80681);

(statearr_80724_80751[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (10))){
var state_80702__$1 = state_80702;
var statearr_80725_80752 = state_80702__$1;
(statearr_80725_80752[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (18))){
var inst_80690 = (state_80702[(2)]);
var state_80702__$1 = state_80702;
var statearr_80727_80753 = state_80702__$1;
(statearr_80727_80753[(2)] = inst_80690);

(statearr_80727_80753[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80703 === (8))){
var inst_80697 = (state_80702[(2)]);
var _ = (function (){var statearr_80728 = state_80702;
(statearr_80728[(4)] = cljs.core.rest((state_80702[(4)])));

return statearr_80728;
})();
var state_80702__$1 = state_80702;
var statearr_80729_80754 = state_80702__$1;
(statearr_80729_80754[(2)] = inst_80697);

(statearr_80729_80754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_80730 = [null,null,null,null,null,null,null,null];
(statearr_80730[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_80730[(1)] = (1));

return statearr_80730;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_80702){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80702);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80731){var ex__2730__auto__ = e80731;
var statearr_80732_80755 = state_80702;
(statearr_80732_80755[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80702[(4)]))){
var statearr_80733_80756 = state_80702;
(statearr_80733_80756[(1)] = cljs.core.first((state_80702[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80757 = state_80702;
state_80702 = G__80757;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_80702){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_80702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80734 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80734[(6)] = c__2749__auto__);

return statearr_80734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80829){
var state_val_80830 = (state_80829[(1)]);
if((state_val_80830 === (7))){
var inst_80767 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_80829__$1 = state_80829;
if(inst_80767){
var statearr_80831_80885 = state_80829__$1;
(statearr_80831_80885[(1)] = (9));

} else {
var statearr_80832_80886 = state_80829__$1;
(statearr_80832_80886[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (20))){
var inst_80791 = (state_80829[(7)]);
var state_80829__$1 = state_80829;
if(cljs.core.truth_(inst_80791)){
var statearr_80833_80887 = state_80829__$1;
(statearr_80833_80887[(1)] = (22));

} else {
var statearr_80834_80888 = state_80829__$1;
(statearr_80834_80888[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (27))){
var state_80829__$1 = state_80829;
var statearr_80835_80889 = state_80829__$1;
(statearr_80835_80889[(2)] = null);

(statearr_80835_80889[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (1))){
var state_80829__$1 = state_80829;
var statearr_80836_80890 = state_80829__$1;
(statearr_80836_80890[(2)] = null);

(statearr_80836_80890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (24))){
var inst_80805 = (state_80829[(2)]);
var state_80829__$1 = state_80829;
var statearr_80837_80891 = state_80829__$1;
(statearr_80837_80891[(2)] = inst_80805);

(statearr_80837_80891[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (4))){
var inst_80758 = (state_80829[(2)]);
var state_80829__$1 = state_80829;
var statearr_80838_80892 = state_80829__$1;
(statearr_80838_80892[(2)] = inst_80758);

(statearr_80838_80892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (15))){
var inst_80774 = (state_80829[(8)]);
var inst_80773 = (state_80829[(2)]);
var inst_80774__$1 = fluree.db.util.async.throw_err(inst_80773);
var state_80829__$1 = (function (){var statearr_80839 = state_80829;
(statearr_80839[(8)] = inst_80774__$1);

return statearr_80839;
})();
if(cljs.core.truth_(inst_80774__$1)){
var statearr_80840_80893 = state_80829__$1;
(statearr_80840_80893[(1)] = (16));

} else {
var statearr_80841_80894 = state_80829__$1;
(statearr_80841_80894[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (21))){
var inst_80807 = (state_80829[(9)]);
var inst_80807__$1 = (state_80829[(2)]);
var state_80829__$1 = (function (){var statearr_80842 = state_80829;
(statearr_80842[(9)] = inst_80807__$1);

return statearr_80842;
})();
if(cljs.core.truth_(inst_80807__$1)){
var statearr_80843_80895 = state_80829__$1;
(statearr_80843_80895[(1)] = (29));

} else {
var statearr_80844_80896 = state_80829__$1;
(statearr_80844_80896[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (31))){
var inst_80807 = (state_80829[(9)]);
var inst_80815 = (state_80829[(2)]);
var state_80829__$1 = (function (){var statearr_80845 = state_80829;
(statearr_80845[(10)] = inst_80815);

return statearr_80845;
})();
if(cljs.core.truth_(inst_80807)){
var statearr_80846_80897 = state_80829__$1;
(statearr_80846_80897[(1)] = (33));

} else {
var statearr_80847_80898 = state_80829__$1;
(statearr_80847_80898[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (32))){
var inst_80811 = (state_80829[(2)]);
var inst_80812 = fluree.db.util.async.throw_err(inst_80811);
var state_80829__$1 = state_80829;
var statearr_80848_80899 = state_80829__$1;
(statearr_80848_80899[(2)] = inst_80812);

(statearr_80848_80899[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (33))){
var inst_80807 = (state_80829[(9)]);
var inst_80817 = fluree.db.permissions.permission_map(db,inst_80807,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_80829__$1 = state_80829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80829__$1,(36),inst_80817);
} else {
if((state_val_80830 === (13))){
var state_80829__$1 = state_80829;
var statearr_80849_80900 = state_80829__$1;
(statearr_80849_80900[(2)] = null);

(statearr_80849_80900[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (22))){
var inst_80791 = (state_80829[(7)]);
var inst_80795 = fluree.db.auth.roles(db,inst_80791);
var state_80829__$1 = state_80829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80829__$1,(25),inst_80795);
} else {
if((state_val_80830 === (36))){
var inst_80819 = (state_80829[(2)]);
var inst_80820 = fluree.db.util.async.throw_err(inst_80819);
var state_80829__$1 = state_80829;
var statearr_80850_80901 = state_80829__$1;
(statearr_80850_80901[(2)] = inst_80820);

(statearr_80850_80901[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (29))){
var inst_80791 = (state_80829[(7)]);
var inst_80807 = (state_80829[(9)]);
var inst_80809 = fluree.db.dbfunctions.ctx.build(db,inst_80791,inst_80807);
var state_80829__$1 = state_80829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80829__$1,(32),inst_80809);
} else {
if((state_val_80830 === (6))){
var state_80829__$1 = state_80829;
var statearr_80851_80902 = state_80829__$1;
(statearr_80851_80902[(2)] = null);

(statearr_80851_80902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (28))){
var inst_80803 = (state_80829[(2)]);
var state_80829__$1 = state_80829;
var statearr_80852_80903 = state_80829__$1;
(statearr_80852_80903[(2)] = inst_80803);

(statearr_80852_80903[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (25))){
var inst_80797 = (state_80829[(2)]);
var inst_80798 = fluree.db.util.async.throw_err(inst_80797);
var state_80829__$1 = state_80829;
var statearr_80853_80904 = state_80829__$1;
(statearr_80853_80904[(2)] = inst_80798);

(statearr_80853_80904[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (34))){
var state_80829__$1 = state_80829;
var statearr_80854_80905 = state_80829__$1;
(statearr_80854_80905[(2)] = null);

(statearr_80854_80905[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (17))){
var inst_80777 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_80778 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80779 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_80780 = cljs.core.PersistentHashMap.fromArrays(inst_80778,inst_80779);
var inst_80781 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_80777,inst_80780);
var inst_80782 = (function(){throw inst_80781})();
var state_80829__$1 = state_80829;
var statearr_80855_80906 = state_80829__$1;
(statearr_80855_80906[(2)] = inst_80782);

(statearr_80855_80906[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (3))){
var inst_80827 = (state_80829[(2)]);
var state_80829__$1 = state_80829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80829__$1,inst_80827);
} else {
if((state_val_80830 === (12))){
var inst_80771 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_80829__$1 = state_80829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80829__$1,(15),inst_80771);
} else {
if((state_val_80830 === (2))){
var _ = (function (){var statearr_80856 = state_80829;
(statearr_80856[(4)] = cljs.core.cons((5),(state_80829[(4)])));

return statearr_80856;
})();
var inst_80764 = (auth == null);
var state_80829__$1 = state_80829;
if(cljs.core.truth_(inst_80764)){
var statearr_80857_80907 = state_80829__$1;
(statearr_80857_80907[(1)] = (6));

} else {
var statearr_80858_80908 = state_80829__$1;
(statearr_80858_80908[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (23))){
var state_80829__$1 = state_80829;
var statearr_80859_80909 = state_80829__$1;
(statearr_80859_80909[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (35))){
var inst_80815 = (state_80829[(10)]);
var inst_80791 = (state_80829[(7)]);
var inst_80807 = (state_80829[(9)]);
var inst_80823 = (state_80829[(2)]);
var inst_80824 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_80791,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_80807,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_80823,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_80815], 0));
var _ = (function (){var statearr_80861 = state_80829;
(statearr_80861[(4)] = cljs.core.rest((state_80829[(4)])));

return statearr_80861;
})();
var state_80829__$1 = state_80829;
var statearr_80862_80910 = state_80829__$1;
(statearr_80862_80910[(2)] = inst_80824);

(statearr_80862_80910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (19))){
var state_80829__$1 = state_80829;
var statearr_80863_80911 = state_80829__$1;
(statearr_80863_80911[(2)] = roles);

(statearr_80863_80911[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (11))){
var inst_80789 = (state_80829[(2)]);
var state_80829__$1 = state_80829;
var statearr_80865_80912 = state_80829__$1;
(statearr_80865_80912[(2)] = inst_80789);

(statearr_80865_80912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (9))){
var state_80829__$1 = state_80829;
var statearr_80866_80913 = state_80829__$1;
(statearr_80866_80913[(2)] = (0));

(statearr_80866_80913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (5))){
var _ = (function (){var statearr_80867 = state_80829;
(statearr_80867[(4)] = cljs.core.rest((state_80829[(4)])));

return statearr_80867;
})();
var state_80829__$1 = state_80829;
var ex80864 = (state_80829__$1[(2)]);
var statearr_80868_80914 = state_80829__$1;
(statearr_80868_80914[(5)] = ex80864);


if((ex80864 instanceof Error)){
var statearr_80869_80915 = state_80829__$1;
(statearr_80869_80915[(1)] = (4));

(statearr_80869_80915[(5)] = null);

} else {
throw ex80864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (14))){
var inst_80787 = (state_80829[(2)]);
var state_80829__$1 = state_80829;
var statearr_80870_80916 = state_80829__$1;
(statearr_80870_80916[(2)] = inst_80787);

(statearr_80870_80916[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (26))){
var state_80829__$1 = state_80829;
var statearr_80871_80917 = state_80829__$1;
(statearr_80871_80917[(2)] = null);

(statearr_80871_80917[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (16))){
var inst_80774 = (state_80829[(8)]);
var state_80829__$1 = state_80829;
var statearr_80872_80918 = state_80829__$1;
(statearr_80872_80918[(2)] = inst_80774);

(statearr_80872_80918[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (30))){
var state_80829__$1 = state_80829;
var statearr_80873_80919 = state_80829__$1;
(statearr_80873_80919[(2)] = null);

(statearr_80873_80919[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (10))){
var state_80829__$1 = state_80829;
if(cljs.core.truth_(auth)){
var statearr_80874_80920 = state_80829__$1;
(statearr_80874_80920[(1)] = (12));

} else {
var statearr_80875_80921 = state_80829__$1;
(statearr_80875_80921[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (18))){
var inst_80784 = (state_80829[(2)]);
var state_80829__$1 = state_80829;
var statearr_80876_80922 = state_80829__$1;
(statearr_80876_80922[(2)] = inst_80784);

(statearr_80876_80922[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80830 === (8))){
var inst_80791 = (state_80829[(2)]);
var state_80829__$1 = (function (){var statearr_80877 = state_80829;
(statearr_80877[(7)] = inst_80791);

return statearr_80877;
})();
if(cljs.core.truth_(roles)){
var statearr_80878_80923 = state_80829__$1;
(statearr_80878_80923[(1)] = (19));

} else {
var statearr_80879_80924 = state_80829__$1;
(statearr_80879_80924[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_80880 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_80880[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_80880[(1)] = (1));

return statearr_80880;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_80829){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80829);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80881){var ex__2730__auto__ = e80881;
var statearr_80882_80925 = state_80829;
(statearr_80882_80925[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80829[(4)]))){
var statearr_80883_80926 = state_80829;
(statearr_80883_80926[(1)] = cljs.core.first((state_80829[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80927 = state_80829;
state_80829 = G__80927;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_80829){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_80829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80884 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80884[(6)] = c__2749__auto__);

return statearr_80884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__80928 = db;
var map__80928__$1 = cljs.core.__destructure_map(map__80928);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80928__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80928__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80928__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80935){
var state_val_80936 = (state_80935[(1)]);
if((state_val_80936 === (1))){
var inst_80929 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_80930 = fluree.db.session.db(conn,inst_80929,null);
var state_80935__$1 = state_80935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80935__$1,(2),inst_80930);
} else {
if((state_val_80936 === (2))){
var inst_80932 = (state_80935[(2)]);
var inst_80933 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_80932);
var state_80935__$1 = state_80935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80935__$1,inst_80933);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_80937 = [null,null,null,null,null,null,null];
(statearr_80937[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_80937[(1)] = (1));

return statearr_80937;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_80935){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80935);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80938){var ex__2730__auto__ = e80938;
var statearr_80939_80966 = state_80935;
(statearr_80939_80966[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80935[(4)]))){
var statearr_80940_80967 = state_80935;
(statearr_80940_80967[(1)] = cljs.core.first((state_80935[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80968 = state_80935;
state_80935 = G__80968;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_80935){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_80935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80941 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80941[(6)] = c__2749__auto__);

return statearr_80941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80954){
var state_val_80955 = (state_80954[(1)]);
if((state_val_80955 === (1))){
var inst_80942 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_80943 = fluree.db.session.db(conn,inst_80942,null);
var state_80954__$1 = state_80954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80954__$1,(2),inst_80943);
} else {
if((state_val_80955 === (2))){
var inst_80945 = (state_80954[(7)]);
var inst_80945__$1 = (state_80954[(2)]);
var inst_80946 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_80945__$1);
var inst_80947 = newer_block_QMARK_(inst_80946);
var state_80954__$1 = (function (){var statearr_80956 = state_80954;
(statearr_80956[(7)] = inst_80945__$1);

return statearr_80956;
})();
if(inst_80947){
var statearr_80957_80969 = state_80954__$1;
(statearr_80957_80969[(1)] = (3));

} else {
var statearr_80958_80970 = state_80954__$1;
(statearr_80958_80970[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80955 === (3))){
var inst_80945 = (state_80954[(7)]);
var inst_80949 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_80945);
var state_80954__$1 = state_80954;
var statearr_80959_80971 = state_80954__$1;
(statearr_80959_80971[(2)] = inst_80949);

(statearr_80959_80971[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80955 === (4))){
var state_80954__$1 = state_80954;
var statearr_80960_80972 = state_80954__$1;
(statearr_80960_80972[(2)] = null);

(statearr_80960_80972[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80955 === (5))){
var inst_80952 = (state_80954[(2)]);
var state_80954__$1 = state_80954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80954__$1,inst_80952);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_80961 = [null,null,null,null,null,null,null,null];
(statearr_80961[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_80961[(1)] = (1));

return statearr_80961;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_80954){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80954);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80962){var ex__2730__auto__ = e80962;
var statearr_80963_80973 = state_80954;
(statearr_80963_80973[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80954[(4)]))){
var statearr_80964_80974 = state_80954;
(statearr_80964_80974[(1)] = cljs.core.first((state_80954[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80975 = state_80954;
state_80954 = G__80975;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_80954){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_80954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80965 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80965[(6)] = c__2749__auto__);

return statearr_80965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__80976 = db;
var map__80976__$1 = cljs.core.__destructure_map(map__80976);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80976__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80976__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80976__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___81052 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81026){
var state_val_81027 = (state_81026[(1)]);
if((state_val_81027 === (7))){
var inst_80992 = (state_81026[(7)]);
var inst_81003 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80992,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_81026__$1 = state_81026;
if(inst_81003){
var statearr_81028_81053 = state_81026__$1;
(statearr_81028_81053[(1)] = (9));

} else {
var statearr_81029_81054 = state_81026__$1;
(statearr_81029_81054[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (1))){
var inst_80985 = (state_81026[(8)]);
var inst_80977 = (state_81026[(9)]);
var inst_80977__$1 = cljs.core.async.timeout(timeout);
var inst_80985__$1 = res_port;
var inst_80986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80987 = [inst_80977__$1,inst_80985__$1];
var inst_80988 = (new cljs.core.PersistentVector(null,2,(5),inst_80986,inst_80987,null));
var state_81026__$1 = (function (){var statearr_81030 = state_81026;
(statearr_81030[(8)] = inst_80985__$1);

(statearr_81030[(9)] = inst_80977__$1);

return statearr_81030;
})();
return cljs.core.async.ioc_alts_BANG_(state_81026__$1,(2),inst_80988);
} else {
if((state_val_81027 === (4))){
var inst_80992 = (state_81026[(7)]);
var inst_80985 = (state_81026[(8)]);
var inst_80996 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80992,inst_80985);
var state_81026__$1 = state_81026;
if(inst_80996){
var statearr_81031_81055 = state_81026__$1;
(statearr_81031_81055[(1)] = (6));

} else {
var statearr_81032_81056 = state_81026__$1;
(statearr_81032_81056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (13))){
var inst_81011 = (state_81026[(10)]);
var inst_81022 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_81011);
var state_81026__$1 = state_81026;
var statearr_81033_81057 = state_81026__$1;
(statearr_81033_81057[(2)] = inst_81022);

(statearr_81033_81057[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (6))){
var inst_80990 = (state_81026[(11)]);
var inst_81001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80990,(0),null);
var state_81026__$1 = state_81026;
var statearr_81034_81058 = state_81026__$1;
(statearr_81034_81058[(2)] = inst_81001);

(statearr_81034_81058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (3))){
var state_81026__$1 = state_81026;
var statearr_81035_81059 = state_81026__$1;
(statearr_81035_81059[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_81035_81059[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (12))){
var inst_81015 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_81016 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81017 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_81018 = cljs.core.PersistentHashMap.fromArrays(inst_81016,inst_81017);
var inst_81019 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_81015,inst_81018);
var inst_81020 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_81019);
var state_81026__$1 = state_81026;
var statearr_81036_81060 = state_81026__$1;
(statearr_81036_81060[(2)] = inst_81020);

(statearr_81036_81060[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (2))){
var inst_80990 = (state_81026[(11)]);
var inst_80992 = (state_81026[(7)]);
var inst_80977 = (state_81026[(9)]);
var inst_80990__$1 = (state_81026[(2)]);
var inst_80991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80990__$1,(0),null);
var inst_80992__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80990__$1,(1),null);
var inst_80993 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80992__$1,inst_80977);
var state_81026__$1 = (function (){var statearr_81037 = state_81026;
(statearr_81037[(12)] = inst_80991);

(statearr_81037[(11)] = inst_80990__$1);

(statearr_81037[(7)] = inst_80992__$1);

return statearr_81037;
})();
if(inst_80993){
var statearr_81038_81061 = state_81026__$1;
(statearr_81038_81061[(1)] = (3));

} else {
var statearr_81039_81062 = state_81026__$1;
(statearr_81039_81062[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (11))){
var inst_81007 = (state_81026[(2)]);
var state_81026__$1 = state_81026;
var statearr_81040_81063 = state_81026__$1;
(statearr_81040_81063[(2)] = inst_81007);

(statearr_81040_81063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (9))){
var inst_80991 = (state_81026[(12)]);
var state_81026__$1 = state_81026;
var statearr_81041_81064 = state_81026__$1;
(statearr_81041_81064[(2)] = inst_80991);

(statearr_81041_81064[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (5))){
var inst_81011 = (state_81026[(10)]);
var inst_81011__$1 = (state_81026[(2)]);
var inst_81012 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_81013 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_81011__$1);
var state_81026__$1 = (function (){var statearr_81042 = state_81026;
(statearr_81042[(13)] = inst_81012);

(statearr_81042[(10)] = inst_81011__$1);

return statearr_81042;
})();
if(inst_81013){
var statearr_81043_81065 = state_81026__$1;
(statearr_81043_81065[(1)] = (12));

} else {
var statearr_81044_81066 = state_81026__$1;
(statearr_81044_81066[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (14))){
var inst_81024 = (state_81026[(2)]);
var state_81026__$1 = state_81026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81026__$1,inst_81024);
} else {
if((state_val_81027 === (10))){
var state_81026__$1 = state_81026;
var statearr_81045_81067 = state_81026__$1;
(statearr_81045_81067[(2)] = null);

(statearr_81045_81067[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81027 === (8))){
var inst_81009 = (state_81026[(2)]);
var state_81026__$1 = state_81026;
var statearr_81046_81068 = state_81026__$1;
(statearr_81046_81068[(2)] = inst_81009);

(statearr_81046_81068[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_81047 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81047[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_81047[(1)] = (1));

return statearr_81047;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_81026){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81026);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81048){var ex__2730__auto__ = e81048;
var statearr_81049_81069 = state_81026;
(statearr_81049_81069[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81026[(4)]))){
var statearr_81050_81070 = state_81026;
(statearr_81050_81070[(1)] = cljs.core.first((state_81026[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81071 = state_81026;
state_81026 = G__81071;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_81026){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_81026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81051 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81051[(6)] = c__2749__auto___81052);

return statearr_81051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__81073 = arguments.length;
switch (G__81073) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__81074){
var map__81075 = p__81074;
var map__81075__$1 = cljs.core.__destructure_map(map__81075);
var opts = map__81075__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81075__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81075__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81075__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81075__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81075__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___81164 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_81126){
var state_val_81127 = (state_81126[(1)]);
if((state_val_81127 === (7))){
var inst_81088 = (state_81126[(7)]);
var inst_81090 = fluree.db.api.ledger.syncTo_db(inst_81088,syncTo,syncTimeout);
var state_81126__$1 = state_81126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81126__$1,(10),inst_81090);
} else {
if((state_val_81127 === (20))){
var inst_81112 = (state_81126[(8)]);
var state_81126__$1 = state_81126;
var statearr_81128_81165 = state_81126__$1;
(statearr_81128_81165[(2)] = inst_81112);

(statearr_81128_81165[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (1))){
var state_81126__$1 = state_81126;
var statearr_81129_81166 = state_81126__$1;
(statearr_81129_81166[(2)] = null);

(statearr_81129_81166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (4))){
var inst_81076 = (state_81126[(2)]);
var inst_81077 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_81076);
var inst_81078 = cljs.core.async.close_BANG_(pc);
var state_81126__$1 = (function (){var statearr_81130 = state_81126;
(statearr_81130[(9)] = inst_81077);

return statearr_81130;
})();
var statearr_81131_81167 = state_81126__$1;
(statearr_81131_81167[(2)] = inst_81078);

(statearr_81131_81167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (15))){
var inst_81104 = (state_81126[(10)]);
var inst_81106 = fluree.db.api.ledger.add_db_permissions(inst_81104,auth,roles);
var state_81126__$1 = state_81126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81126__$1,(18),inst_81106);
} else {
if((state_val_81127 === (21))){
var inst_81120 = (state_81126[(2)]);
var inst_81121 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_81120);
var _ = (function (){var statearr_81132 = state_81126;
(statearr_81132[(4)] = cljs.core.rest((state_81126[(4)])));

return statearr_81132;
})();
var state_81126__$1 = state_81126;
var statearr_81133_81168 = state_81126__$1;
(statearr_81133_81168[(2)] = inst_81121);

(statearr_81133_81168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (13))){
var inst_81104 = (state_81126[(2)]);
var state_81126__$1 = (function (){var statearr_81134 = state_81126;
(statearr_81134[(10)] = inst_81104);

return statearr_81134;
})();
if(cljs.core.truth_(roles)){
var statearr_81135_81169 = state_81126__$1;
(statearr_81135_81169[(1)] = (15));

} else {
var statearr_81136_81170 = state_81126__$1;
(statearr_81136_81170[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (22))){
var inst_81116 = (state_81126[(2)]);
var inst_81117 = fluree.db.util.async.throw_err(inst_81116);
var state_81126__$1 = state_81126;
var statearr_81137_81171 = state_81126__$1;
(statearr_81137_81171[(2)] = inst_81117);

(statearr_81137_81171[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (6))){
var inst_81087 = (state_81126[(2)]);
var inst_81088 = fluree.db.util.async.throw_err(inst_81087);
var state_81126__$1 = (function (){var statearr_81138 = state_81126;
(statearr_81138[(7)] = inst_81088);

return statearr_81138;
})();
if(cljs.core.truth_(syncTo)){
var statearr_81139_81172 = state_81126__$1;
(statearr_81139_81172[(1)] = (7));

} else {
var statearr_81140_81173 = state_81126__$1;
(statearr_81140_81173[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (17))){
var inst_81112 = (state_81126[(2)]);
var state_81126__$1 = (function (){var statearr_81141 = state_81126;
(statearr_81141[(8)] = inst_81112);

return statearr_81141;
})();
if(cljs.core.truth_(auth)){
var statearr_81142_81174 = state_81126__$1;
(statearr_81142_81174[(1)] = (19));

} else {
var statearr_81143_81175 = state_81126__$1;
(statearr_81143_81175[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (3))){
var inst_81124 = (state_81126[(2)]);
var state_81126__$1 = state_81126;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81126__$1,inst_81124);
} else {
if((state_val_81127 === (12))){
var inst_81096 = (state_81126[(11)]);
var state_81126__$1 = state_81126;
var statearr_81144_81176 = state_81126__$1;
(statearr_81144_81176[(2)] = inst_81096);

(statearr_81144_81176[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (2))){
var _ = (function (){var statearr_81145 = state_81126;
(statearr_81145[(4)] = cljs.core.cons((5),(state_81126[(4)])));

return statearr_81145;
})();
var inst_81085 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_81126__$1 = state_81126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81126__$1,(6),inst_81085);
} else {
if((state_val_81127 === (19))){
var inst_81112 = (state_81126[(8)]);
var inst_81114 = fluree.db.api.ledger.add_db_permissions(inst_81112,auth,roles);
var state_81126__$1 = state_81126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81126__$1,(22),inst_81114);
} else {
if((state_val_81127 === (11))){
var inst_81096 = (state_81126[(11)]);
var inst_81098 = fluree.db.time_travel.as_of_block(inst_81096,block);
var state_81126__$1 = state_81126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81126__$1,(14),inst_81098);
} else {
if((state_val_81127 === (9))){
var inst_81096 = (state_81126[(2)]);
var state_81126__$1 = (function (){var statearr_81147 = state_81126;
(statearr_81147[(11)] = inst_81096);

return statearr_81147;
})();
if(cljs.core.truth_(block)){
var statearr_81148_81177 = state_81126__$1;
(statearr_81148_81177[(1)] = (11));

} else {
var statearr_81149_81178 = state_81126__$1;
(statearr_81149_81178[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (5))){
var _ = (function (){var statearr_81150 = state_81126;
(statearr_81150[(4)] = cljs.core.rest((state_81126[(4)])));

return statearr_81150;
})();
var state_81126__$1 = state_81126;
var ex81146 = (state_81126__$1[(2)]);
var statearr_81151_81179 = state_81126__$1;
(statearr_81151_81179[(5)] = ex81146);


var statearr_81152_81180 = state_81126__$1;
(statearr_81152_81180[(1)] = (4));

(statearr_81152_81180[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (14))){
var inst_81100 = (state_81126[(2)]);
var inst_81101 = fluree.db.util.async.throw_err(inst_81100);
var state_81126__$1 = state_81126;
var statearr_81153_81181 = state_81126__$1;
(statearr_81153_81181[(2)] = inst_81101);

(statearr_81153_81181[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (16))){
var inst_81104 = (state_81126[(10)]);
var state_81126__$1 = state_81126;
var statearr_81154_81182 = state_81126__$1;
(statearr_81154_81182[(2)] = inst_81104);

(statearr_81154_81182[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (10))){
var inst_81092 = (state_81126[(2)]);
var inst_81093 = fluree.db.util.async.throw_err(inst_81092);
var state_81126__$1 = state_81126;
var statearr_81155_81183 = state_81126__$1;
(statearr_81155_81183[(2)] = inst_81093);

(statearr_81155_81183[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (18))){
var inst_81108 = (state_81126[(2)]);
var inst_81109 = fluree.db.util.async.throw_err(inst_81108);
var state_81126__$1 = state_81126;
var statearr_81156_81184 = state_81126__$1;
(statearr_81156_81184[(2)] = inst_81109);

(statearr_81156_81184[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81127 === (8))){
var inst_81088 = (state_81126[(7)]);
var state_81126__$1 = state_81126;
var statearr_81157_81185 = state_81126__$1;
(statearr_81157_81185[(2)] = inst_81088);

(statearr_81157_81185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_81158 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81158[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_81158[(1)] = (1));

return statearr_81158;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_81126){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_81126);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e81159){var ex__2730__auto__ = e81159;
var statearr_81160_81186 = state_81126;
(statearr_81160_81186[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_81126[(4)]))){
var statearr_81161_81187 = state_81126;
(statearr_81161_81187[(1)] = cljs.core.first((state_81126[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81188 = state_81126;
state_81126 = G__81188;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_81126){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_81126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_81162 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_81162[(6)] = c__2749__auto___81164);

return statearr_81162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

