// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__74302 = arguments.length;
switch (G__74302) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___74450 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74389){
var state_val_74390 = (state_74389[(1)]);
if((state_val_74390 === (7))){
var inst_74320 = (state_74389[(7)]);
var inst_74323 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_74320);
var state_74389__$1 = state_74389;
var statearr_74391_74451 = state_74389__$1;
(statearr_74391_74451[(2)] = inst_74323);

(statearr_74391_74451[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (20))){
var inst_74315 = (state_74389[(8)]);
var inst_74344 = (state_74389[(9)]);
var inst_74348 = fluree.db.auth.roles(inst_74315,inst_74344);
var state_74389__$1 = state_74389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74389__$1,(23),inst_74348);
} else {
if((state_val_74390 === (27))){
var inst_74315 = (state_74389[(8)]);
var inst_74363 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74364 = fluree.db.time_travel.as_of_block(inst_74315,inst_74363);
var state_74389__$1 = state_74389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74389__$1,(30),inst_74364);
} else {
if((state_val_74390 === (1))){
var state_74389__$1 = state_74389;
var statearr_74392_74452 = state_74389__$1;
(statearr_74392_74452[(2)] = null);

(statearr_74392_74452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (24))){
var inst_74315 = (state_74389[(8)]);
var inst_74356 = (state_74389[(10)]);
var inst_74358 = fluree.db.permissions.permission_map(inst_74315,inst_74356,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74389__$1 = state_74389;
var statearr_74393_74453 = state_74389__$1;
(statearr_74393_74453[(2)] = inst_74358);

(statearr_74393_74453[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (4))){
var inst_74303 = (state_74389[(2)]);
var inst_74304 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74303);
var inst_74305 = cljs.core.async.close_BANG_(pc);
var state_74389__$1 = (function (){var statearr_74394 = state_74389;
(statearr_74394[(11)] = inst_74304);

return statearr_74394;
})();
var statearr_74395_74454 = state_74389__$1;
(statearr_74395_74454[(2)] = inst_74305);

(statearr_74395_74454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (15))){
var inst_74320 = (state_74389[(7)]);
var inst_74334 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74320)," unknown."].join('');
var inst_74335 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74336 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_74337 = cljs.core.PersistentHashMap.fromArrays(inst_74335,inst_74336);
var inst_74338 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74334,inst_74337);
var inst_74339 = (function(){throw inst_74338})();
var state_74389__$1 = state_74389;
var statearr_74396_74455 = state_74389__$1;
(statearr_74396_74455[(2)] = inst_74339);

(statearr_74396_74455[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (21))){
var state_74389__$1 = state_74389;
var statearr_74397_74456 = state_74389__$1;
(statearr_74397_74456[(2)] = null);

(statearr_74397_74456[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (31))){
var inst_74320 = (state_74389[(7)]);
var inst_74370 = (state_74389[(12)]);
var inst_74372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74370,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_74320);
var state_74389__$1 = state_74389;
var statearr_74398_74457 = state_74389__$1;
(statearr_74398_74457[(2)] = inst_74372);

(statearr_74398_74457[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (32))){
var inst_74370 = (state_74389[(12)]);
var state_74389__$1 = state_74389;
var statearr_74399_74458 = state_74389__$1;
(statearr_74399_74458[(2)] = inst_74370);

(statearr_74399_74458[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (33))){
var inst_74356 = (state_74389[(10)]);
var inst_74375 = (state_74389[(2)]);
var state_74389__$1 = (function (){var statearr_74400 = state_74389;
(statearr_74400[(13)] = inst_74375);

return statearr_74400;
})();
if(cljs.core.truth_(inst_74356)){
var statearr_74401_74459 = state_74389__$1;
(statearr_74401_74459[(1)] = (34));

} else {
var statearr_74402_74460 = state_74389__$1;
(statearr_74402_74460[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (13))){
var inst_74331 = (state_74389[(14)]);
var inst_74330 = (state_74389[(2)]);
var inst_74331__$1 = fluree.db.util.async.throw_err(inst_74330);
var state_74389__$1 = (function (){var statearr_74403 = state_74389;
(statearr_74403[(14)] = inst_74331__$1);

return statearr_74403;
})();
if(cljs.core.truth_(inst_74331__$1)){
var statearr_74404_74461 = state_74389__$1;
(statearr_74404_74461[(1)] = (14));

} else {
var statearr_74405_74462 = state_74389__$1;
(statearr_74405_74462[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (22))){
var inst_74354 = (state_74389[(2)]);
var state_74389__$1 = state_74389;
var statearr_74406_74463 = state_74389__$1;
(statearr_74406_74463[(2)] = inst_74354);

(statearr_74406_74463[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (36))){
var inst_74383 = (state_74389[(2)]);
var inst_74384 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74383);
var _ = (function (){var statearr_74407 = state_74389;
(statearr_74407[(4)] = cljs.core.rest((state_74389[(4)])));

return statearr_74407;
})();
var state_74389__$1 = state_74389;
var statearr_74408_74464 = state_74389__$1;
(statearr_74408_74464[(2)] = inst_74384);

(statearr_74408_74464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (29))){
var inst_74320 = (state_74389[(7)]);
var inst_74370 = (state_74389[(2)]);
var state_74389__$1 = (function (){var statearr_74409 = state_74389;
(statearr_74409[(12)] = inst_74370);

return statearr_74409;
})();
if(cljs.core.truth_(inst_74320)){
var statearr_74410_74465 = state_74389__$1;
(statearr_74410_74465[(1)] = (31));

} else {
var statearr_74411_74466 = state_74389__$1;
(statearr_74411_74466[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (6))){
var inst_74320 = (state_74389[(7)]);
var inst_74314 = (state_74389[(2)]);
var inst_74315 = fluree.db.util.async.throw_err(inst_74314);
var inst_74316 = opts;
var inst_74317 = cljs.core.__destructure_map(inst_74316);
var inst_74318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74317,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_74319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74317,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_74320__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74317,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74317,new cljs.core.Keyword(null,"block","block",664686210));
var state_74389__$1 = (function (){var statearr_74412 = state_74389;
(statearr_74412[(8)] = inst_74315);

(statearr_74412[(15)] = inst_74321);

(statearr_74412[(16)] = inst_74318);

(statearr_74412[(7)] = inst_74320__$1);

(statearr_74412[(17)] = inst_74319);

return statearr_74412;
})();
if(cljs.core.truth_(inst_74320__$1)){
var statearr_74413_74467 = state_74389__$1;
(statearr_74413_74467[(1)] = (7));

} else {
var statearr_74414_74468 = state_74389__$1;
(statearr_74414_74468[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (28))){
var inst_74315 = (state_74389[(8)]);
var state_74389__$1 = state_74389;
var statearr_74415_74469 = state_74389__$1;
(statearr_74415_74469[(2)] = inst_74315);

(statearr_74415_74469[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (25))){
var state_74389__$1 = state_74389;
var statearr_74416_74470 = state_74389__$1;
(statearr_74416_74470[(2)] = null);

(statearr_74416_74470[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (34))){
var inst_74361 = (state_74389[(18)]);
var state_74389__$1 = state_74389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74389__$1,(37),inst_74361);
} else {
if((state_val_74390 === (17))){
var inst_74318 = (state_74389[(16)]);
var state_74389__$1 = state_74389;
var statearr_74417_74471 = state_74389__$1;
(statearr_74417_74471[(2)] = inst_74318);

(statearr_74417_74471[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (3))){
var inst_74387 = (state_74389[(2)]);
var state_74389__$1 = state_74389;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74389__$1,inst_74387);
} else {
if((state_val_74390 === (12))){
var inst_74318 = (state_74389[(16)]);
var inst_74344 = (state_74389[(2)]);
var state_74389__$1 = (function (){var statearr_74418 = state_74389;
(statearr_74418[(9)] = inst_74344);

return statearr_74418;
})();
if(cljs.core.truth_(inst_74318)){
var statearr_74419_74472 = state_74389__$1;
(statearr_74419_74472[(1)] = (17));

} else {
var statearr_74420_74473 = state_74389__$1;
(statearr_74420_74473[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (2))){
var _ = (function (){var statearr_74421 = state_74389;
(statearr_74421[(4)] = cljs.core.cons((5),(state_74389[(4)])));

return statearr_74421;
})();
var inst_74312 = fluree.db.session.db(conn,ledger,null);
var state_74389__$1 = state_74389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74389__$1,(6),inst_74312);
} else {
if((state_val_74390 === (23))){
var inst_74350 = (state_74389[(2)]);
var inst_74351 = fluree.db.util.async.throw_err(inst_74350);
var state_74389__$1 = state_74389;
var statearr_74422_74474 = state_74389__$1;
(statearr_74422_74474[(2)] = inst_74351);

(statearr_74422_74474[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (35))){
var inst_74375 = (state_74389[(13)]);
var state_74389__$1 = state_74389;
var statearr_74423_74475 = state_74389__$1;
(statearr_74423_74475[(2)] = inst_74375);

(statearr_74423_74475[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (19))){
var inst_74356 = (state_74389[(10)]);
var inst_74356__$1 = (state_74389[(2)]);
var state_74389__$1 = (function (){var statearr_74424 = state_74389;
(statearr_74424[(10)] = inst_74356__$1);

return statearr_74424;
})();
if(cljs.core.truth_(inst_74356__$1)){
var statearr_74425_74476 = state_74389__$1;
(statearr_74425_74476[(1)] = (24));

} else {
var statearr_74426_74477 = state_74389__$1;
(statearr_74426_74477[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (11))){
var state_74389__$1 = state_74389;
var statearr_74428_74478 = state_74389__$1;
(statearr_74428_74478[(2)] = null);

(statearr_74428_74478[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (9))){
var inst_74326 = (state_74389[(2)]);
var state_74389__$1 = state_74389;
if(cljs.core.truth_(inst_74326)){
var statearr_74429_74479 = state_74389__$1;
(statearr_74429_74479[(1)] = (10));

} else {
var statearr_74430_74480 = state_74389__$1;
(statearr_74430_74480[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (5))){
var _ = (function (){var statearr_74431 = state_74389;
(statearr_74431[(4)] = cljs.core.rest((state_74389[(4)])));

return statearr_74431;
})();
var state_74389__$1 = state_74389;
var ex74427 = (state_74389__$1[(2)]);
var statearr_74432_74481 = state_74389__$1;
(statearr_74432_74481[(5)] = ex74427);


var statearr_74433_74482 = state_74389__$1;
(statearr_74433_74482[(1)] = (4));

(statearr_74433_74482[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (14))){
var inst_74331 = (state_74389[(14)]);
var state_74389__$1 = state_74389;
var statearr_74434_74483 = state_74389__$1;
(statearr_74434_74483[(2)] = inst_74331);

(statearr_74434_74483[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (26))){
var inst_74321 = (state_74389[(15)]);
var inst_74361 = (state_74389[(2)]);
var state_74389__$1 = (function (){var statearr_74435 = state_74389;
(statearr_74435[(18)] = inst_74361);

return statearr_74435;
})();
if(cljs.core.truth_(inst_74321)){
var statearr_74436_74484 = state_74389__$1;
(statearr_74436_74484[(1)] = (27));

} else {
var statearr_74437_74485 = state_74389__$1;
(statearr_74437_74485[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (16))){
var inst_74341 = (state_74389[(2)]);
var state_74389__$1 = state_74389;
var statearr_74438_74486 = state_74389__$1;
(statearr_74438_74486[(2)] = inst_74341);

(statearr_74438_74486[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (30))){
var inst_74366 = (state_74389[(2)]);
var inst_74367 = fluree.db.util.async.throw_err(inst_74366);
var state_74389__$1 = state_74389;
var statearr_74439_74487 = state_74389__$1;
(statearr_74439_74487[(2)] = inst_74367);

(statearr_74439_74487[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (10))){
var inst_74315 = (state_74389[(8)]);
var inst_74320 = (state_74389[(7)]);
var inst_74328 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_74315,inst_74320);
var state_74389__$1 = state_74389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74389__$1,(13),inst_74328);
} else {
if((state_val_74390 === (18))){
var inst_74344 = (state_74389[(9)]);
var state_74389__$1 = state_74389;
if(cljs.core.truth_(inst_74344)){
var statearr_74440_74488 = state_74389__$1;
(statearr_74440_74488[(1)] = (20));

} else {
var statearr_74441_74489 = state_74389__$1;
(statearr_74441_74489[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (37))){
var inst_74375 = (state_74389[(13)]);
var inst_74378 = (state_74389[(2)]);
var inst_74379 = fluree.db.util.async.throw_err(inst_74378);
var inst_74380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74375,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_74379);
var state_74389__$1 = state_74389;
var statearr_74442_74490 = state_74389__$1;
(statearr_74442_74490[(2)] = inst_74380);

(statearr_74442_74490[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74390 === (8))){
var inst_74320 = (state_74389[(7)]);
var state_74389__$1 = state_74389;
var statearr_74443_74491 = state_74389__$1;
(statearr_74443_74491[(2)] = inst_74320);

(statearr_74443_74491[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_74444 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74444[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_74444[(1)] = (1));

return statearr_74444;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_74389){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74389);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74445){var ex__2730__auto__ = e74445;
var statearr_74446_74492 = state_74389;
(statearr_74446_74492[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74389[(4)]))){
var statearr_74447_74493 = state_74389;
(statearr_74447_74493[(1)] = cljs.core.first((state_74389[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74494 = state_74389;
state_74389 = G__74494;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_74389){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_74389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74448 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74448[(6)] = c__2749__auto___74450);

return statearr_74448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74635){
var state_val_74636 = (state_74635[(1)]);
if((state_val_74636 === (7))){
var inst_74515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74516 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74517 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74518 = [inst_74516,inst_74517];
var inst_74519 = (new cljs.core.PersistentVector(null,2,(5),inst_74515,inst_74518,null));
var state_74635__$1 = state_74635;
var statearr_74637_74707 = state_74635__$1;
(statearr_74637_74707[(2)] = inst_74519);

(statearr_74637_74707[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (20))){
var inst_74545 = (state_74635[(7)]);
var state_74635__$1 = state_74635;
var statearr_74638_74708 = state_74635__$1;
(statearr_74638_74708[(2)] = inst_74545);

(statearr_74638_74708[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (27))){
var state_74635__$1 = state_74635;
var statearr_74639_74709 = state_74635__$1;
(statearr_74639_74709[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (1))){
var state_74635__$1 = state_74635;
var statearr_74641_74710 = state_74635__$1;
(statearr_74641_74710[(2)] = null);

(statearr_74641_74710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (24))){
var inst_74544 = (state_74635[(8)]);
var state_74635__$1 = state_74635;
if(cljs.core.truth_(inst_74544)){
var statearr_74642_74711 = state_74635__$1;
(statearr_74642_74711[(1)] = (26));

} else {
var statearr_74643_74712 = state_74635__$1;
(statearr_74643_74712[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (39))){
var inst_74590 = (state_74635[(9)]);
var inst_74591 = (state_74635[(10)]);
var inst_74616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74617 = [inst_74590,inst_74591];
var inst_74618 = (new cljs.core.PersistentVector(null,2,(5),inst_74616,inst_74617,null));
var state_74635__$1 = state_74635;
var statearr_74644_74713 = state_74635__$1;
(statearr_74644_74713[(2)] = inst_74618);

(statearr_74644_74713[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (4))){
var inst_74495 = (state_74635[(2)]);
var state_74635__$1 = state_74635;
var statearr_74645_74714 = state_74635__$1;
(statearr_74645_74714[(2)] = inst_74495);

(statearr_74645_74714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (15))){
var inst_74524 = (state_74635[(11)]);
var inst_74529 = (state_74635[(12)]);
var inst_74538 = (state_74635[(2)]);
var inst_74539 = [inst_74529,inst_74538];
var inst_74540 = (new cljs.core.PersistentVector(null,2,(5),inst_74524,inst_74539,null));
var state_74635__$1 = state_74635;
var statearr_74646_74715 = state_74635__$1;
(statearr_74646_74715[(2)] = inst_74540);

(statearr_74646_74715[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (21))){
var inst_74544 = (state_74635[(8)]);
var state_74635__$1 = state_74635;
var statearr_74647_74716 = state_74635__$1;
(statearr_74647_74716[(2)] = inst_74544);

(statearr_74647_74716[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (31))){
var inst_74585 = (state_74635[(2)]);
var state_74635__$1 = state_74635;
var statearr_74648_74717 = state_74635__$1;
(statearr_74648_74717[(2)] = inst_74585);

(statearr_74648_74717[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (32))){
var inst_74591 = (state_74635[(10)]);
var inst_74594 = cljs.core.pos_int_QMARK_(inst_74591);
var state_74635__$1 = state_74635;
var statearr_74649_74718 = state_74635__$1;
(statearr_74649_74718[(2)] = inst_74594);

(statearr_74649_74718[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (40))){
var inst_74622 = (state_74635[(13)]);
var inst_74546 = (state_74635[(14)]);
var inst_74620 = (state_74635[(2)]);
var inst_74621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74620,(0),null);
var inst_74622__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74620,(1),null);
var inst_74623 = (inst_74622__$1 > inst_74546);
var state_74635__$1 = (function (){var statearr_74650 = state_74635;
(statearr_74650[(13)] = inst_74622__$1);

(statearr_74650[(15)] = inst_74621);

return statearr_74650;
})();
if(cljs.core.truth_(inst_74623)){
var statearr_74651_74719 = state_74635__$1;
(statearr_74651_74719[(1)] = (41));

} else {
var statearr_74652_74720 = state_74635__$1;
(statearr_74652_74720[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (33))){
var inst_74592 = (state_74635[(16)]);
var state_74635__$1 = state_74635;
var statearr_74653_74721 = state_74635__$1;
(statearr_74653_74721[(2)] = inst_74592);

(statearr_74653_74721[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (13))){
var inst_74530 = (state_74635[(17)]);
var inst_74532 = fluree.db.time_travel.block_to_int_format(db,inst_74530);
var state_74635__$1 = state_74635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74635__$1,(16),inst_74532);
} else {
if((state_val_74636 === (22))){
var inst_74563 = (state_74635[(2)]);
var state_74635__$1 = state_74635;
if(cljs.core.truth_(inst_74563)){
var statearr_74654_74722 = state_74635__$1;
(statearr_74654_74722[(1)] = (23));

} else {
var statearr_74655_74723 = state_74635__$1;
(statearr_74655_74723[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (36))){
var state_74635__$1 = state_74635;
var statearr_74656_74724 = state_74635__$1;
(statearr_74656_74724[(2)] = null);

(statearr_74656_74724[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (41))){
var inst_74546 = (state_74635[(14)]);
var state_74635__$1 = state_74635;
var statearr_74657_74725 = state_74635__$1;
(statearr_74657_74725[(2)] = inst_74546);

(statearr_74657_74725[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (43))){
var inst_74621 = (state_74635[(15)]);
var inst_74627 = (state_74635[(2)]);
var inst_74628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74629 = [inst_74621,inst_74627];
var inst_74630 = (new cljs.core.PersistentVector(null,2,(5),inst_74628,inst_74629,null));
var _ = (function (){var statearr_74658 = state_74635;
(statearr_74658[(4)] = cljs.core.rest((state_74635[(4)])));

return statearr_74658;
})();
var state_74635__$1 = state_74635;
var statearr_74659_74726 = state_74635__$1;
(statearr_74659_74726[(2)] = inst_74630);

(statearr_74659_74726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (29))){
var inst_74521 = (state_74635[(18)]);
var inst_74576 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74521], 0));
var inst_74577 = ["Invalid block range provided: ",inst_74576].join('');
var inst_74578 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74579 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74580 = cljs.core.PersistentHashMap.fromArrays(inst_74578,inst_74579);
var inst_74581 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74577,inst_74580);
var inst_74582 = (function(){throw inst_74581})();
var state_74635__$1 = state_74635;
var statearr_74660_74727 = state_74635__$1;
(statearr_74660_74727[(2)] = inst_74582);

(statearr_74660_74727[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (6))){
var inst_74513 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74635__$1 = state_74635;
var statearr_74661_74728 = state_74635__$1;
(statearr_74661_74728[(2)] = inst_74513);

(statearr_74661_74728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (28))){
var inst_74587 = (state_74635[(2)]);
var state_74635__$1 = state_74635;
var statearr_74662_74729 = state_74635__$1;
(statearr_74662_74729[(2)] = inst_74587);

(statearr_74662_74729[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (25))){
var inst_74590 = (state_74635[(9)]);
var inst_74592 = (state_74635[(16)]);
var inst_74589 = (state_74635[(2)]);
var inst_74590__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74589,(0),null);
var inst_74591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74589,(1),null);
var inst_74592__$1 = cljs.core.pos_int_QMARK_(inst_74590__$1);
var state_74635__$1 = (function (){var statearr_74663 = state_74635;
(statearr_74663[(9)] = inst_74590__$1);

(statearr_74663[(10)] = inst_74591);

(statearr_74663[(16)] = inst_74592__$1);

return statearr_74663;
})();
if(inst_74592__$1){
var statearr_74664_74730 = state_74635__$1;
(statearr_74664_74730[(1)] = (32));

} else {
var statearr_74665_74731 = state_74635__$1;
(statearr_74665_74731[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (34))){
var inst_74597 = (state_74635[(2)]);
var inst_74598 = cljs.core.not(inst_74597);
var state_74635__$1 = state_74635;
if(inst_74598){
var statearr_74666_74732 = state_74635__$1;
(statearr_74666_74732[(1)] = (35));

} else {
var statearr_74667_74733 = state_74635__$1;
(statearr_74667_74733[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (17))){
var inst_74544 = (state_74635[(8)]);
var inst_74546 = (state_74635[(14)]);
var inst_74549 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74544], 0));
var inst_74550 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74546], 0));
var inst_74551 = ["Start block is out of range for this ledger. Start block provided: ",inst_74549,". Database block: ",inst_74550].join('');
var inst_74552 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74553 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74554 = cljs.core.PersistentHashMap.fromArrays(inst_74552,inst_74553);
var inst_74555 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74551,inst_74554);
var inst_74556 = (function(){throw inst_74555})();
var state_74635__$1 = state_74635;
var statearr_74668_74734 = state_74635__$1;
(statearr_74668_74734[(2)] = inst_74556);

(statearr_74668_74734[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (3))){
var inst_74633 = (state_74635[(2)]);
var state_74635__$1 = state_74635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74635__$1,inst_74633);
} else {
if((state_val_74636 === (12))){
var inst_74521 = (state_74635[(18)]);
var inst_74530 = (state_74635[(17)]);
var inst_74528 = (state_74635[(2)]);
var inst_74529 = fluree.db.util.async.throw_err(inst_74528);
var inst_74530__$1 = cljs.core.second(inst_74521);
var state_74635__$1 = (function (){var statearr_74669 = state_74635;
(statearr_74669[(12)] = inst_74529);

(statearr_74669[(17)] = inst_74530__$1);

return statearr_74669;
})();
if(cljs.core.truth_(inst_74530__$1)){
var statearr_74670_74735 = state_74635__$1;
(statearr_74670_74735[(1)] = (13));

} else {
var statearr_74671_74736 = state_74635__$1;
(statearr_74671_74736[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (2))){
var _ = (function (){var statearr_74672 = state_74635;
(statearr_74672[(4)] = cljs.core.cons((5),(state_74635[(4)])));

return statearr_74672;
})();
var inst_74510 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74511 = cljs.core.sequential_QMARK_(inst_74510);
var state_74635__$1 = state_74635;
if(inst_74511){
var statearr_74673_74737 = state_74635__$1;
(statearr_74673_74737[(1)] = (6));

} else {
var statearr_74674_74738 = state_74635__$1;
(statearr_74674_74738[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (23))){
var inst_74545 = (state_74635[(7)]);
var inst_74544 = (state_74635[(8)]);
var inst_74565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74566 = [inst_74544,inst_74545];
var inst_74567 = (new cljs.core.PersistentVector(null,2,(5),inst_74565,inst_74566,null));
var state_74635__$1 = state_74635;
var statearr_74675_74739 = state_74635__$1;
(statearr_74675_74739[(2)] = inst_74567);

(statearr_74675_74739[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (35))){
var inst_74521 = (state_74635[(18)]);
var inst_74600 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74521], 0));
var inst_74601 = ["Invalid block range provided: ",inst_74600].join('');
var inst_74602 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74603 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74604 = cljs.core.PersistentHashMap.fromArrays(inst_74602,inst_74603);
var inst_74605 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74601,inst_74604);
var inst_74606 = (function(){throw inst_74605})();
var state_74635__$1 = state_74635;
var statearr_74676_74740 = state_74635__$1;
(statearr_74676_74740[(2)] = inst_74606);

(statearr_74676_74740[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (19))){
var inst_74544 = (state_74635[(8)]);
var inst_74559 = (state_74635[(2)]);
var state_74635__$1 = (function (){var statearr_74677 = state_74635;
(statearr_74677[(19)] = inst_74559);

return statearr_74677;
})();
if(cljs.core.truth_(inst_74544)){
var statearr_74678_74741 = state_74635__$1;
(statearr_74678_74741[(1)] = (20));

} else {
var statearr_74679_74742 = state_74635__$1;
(statearr_74679_74742[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (11))){
var inst_74544 = (state_74635[(8)]);
var inst_74546 = (state_74635[(14)]);
var inst_74543 = (state_74635[(2)]);
var inst_74544__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74543,(0),null);
var inst_74545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74543,(1),null);
var inst_74546__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_74547 = (inst_74544__$1 > inst_74546__$1);
var state_74635__$1 = (function (){var statearr_74681 = state_74635;
(statearr_74681[(7)] = inst_74545);

(statearr_74681[(8)] = inst_74544__$1);

(statearr_74681[(14)] = inst_74546__$1);

return statearr_74681;
})();
if(cljs.core.truth_(inst_74547)){
var statearr_74682_74743 = state_74635__$1;
(statearr_74682_74743[(1)] = (17));

} else {
var statearr_74683_74744 = state_74635__$1;
(statearr_74683_74744[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (9))){
var inst_74521 = (state_74635[(18)]);
var inst_74524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74525 = cljs.core.first(inst_74521);
var inst_74526 = fluree.db.time_travel.block_to_int_format(db,inst_74525);
var state_74635__$1 = (function (){var statearr_74684 = state_74635;
(statearr_74684[(11)] = inst_74524);

return statearr_74684;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74635__$1,(12),inst_74526);
} else {
if((state_val_74636 === (5))){
var _ = (function (){var statearr_74685 = state_74635;
(statearr_74685[(4)] = cljs.core.rest((state_74635[(4)])));

return statearr_74685;
})();
var state_74635__$1 = state_74635;
var ex74680 = (state_74635__$1[(2)]);
var statearr_74686_74745 = state_74635__$1;
(statearr_74686_74745[(5)] = ex74680);


if((ex74680 instanceof Error)){
var statearr_74687_74746 = state_74635__$1;
(statearr_74687_74746[(1)] = (4));

(statearr_74687_74746[(5)] = null);

} else {
throw ex74680;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (14))){
var state_74635__$1 = state_74635;
var statearr_74688_74747 = state_74635__$1;
(statearr_74688_74747[(2)] = null);

(statearr_74688_74747[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (26))){
var inst_74544 = (state_74635[(8)]);
var inst_74570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74571 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_74572 = [inst_74544,inst_74571];
var inst_74573 = (new cljs.core.PersistentVector(null,2,(5),inst_74570,inst_74572,null));
var state_74635__$1 = state_74635;
var statearr_74689_74748 = state_74635__$1;
(statearr_74689_74748[(2)] = inst_74573);

(statearr_74689_74748[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (16))){
var inst_74534 = (state_74635[(2)]);
var inst_74535 = fluree.db.util.async.throw_err(inst_74534);
var state_74635__$1 = state_74635;
var statearr_74690_74749 = state_74635__$1;
(statearr_74690_74749[(2)] = inst_74535);

(statearr_74690_74749[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (38))){
var inst_74590 = (state_74635[(9)]);
var inst_74591 = (state_74635[(10)]);
var inst_74612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74613 = [inst_74591,inst_74590];
var inst_74614 = (new cljs.core.PersistentVector(null,2,(5),inst_74612,inst_74613,null));
var state_74635__$1 = state_74635;
var statearr_74691_74750 = state_74635__$1;
(statearr_74691_74750[(2)] = inst_74614);

(statearr_74691_74750[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (30))){
var state_74635__$1 = state_74635;
var statearr_74692_74751 = state_74635__$1;
(statearr_74692_74751[(2)] = null);

(statearr_74692_74751[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (10))){
var inst_74521 = (state_74635[(18)]);
var state_74635__$1 = state_74635;
var statearr_74693_74752 = state_74635__$1;
(statearr_74693_74752[(2)] = inst_74521);

(statearr_74693_74752[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (18))){
var state_74635__$1 = state_74635;
var statearr_74694_74753 = state_74635__$1;
(statearr_74694_74753[(2)] = null);

(statearr_74694_74753[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (42))){
var inst_74622 = (state_74635[(13)]);
var state_74635__$1 = state_74635;
var statearr_74695_74754 = state_74635__$1;
(statearr_74695_74754[(2)] = inst_74622);

(statearr_74695_74754[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (37))){
var inst_74590 = (state_74635[(9)]);
var inst_74591 = (state_74635[(10)]);
var inst_74609 = (state_74635[(2)]);
var inst_74610 = (inst_74591 < inst_74590);
var state_74635__$1 = (function (){var statearr_74696 = state_74635;
(statearr_74696[(20)] = inst_74609);

return statearr_74696;
})();
if(cljs.core.truth_(inst_74610)){
var statearr_74697_74755 = state_74635__$1;
(statearr_74697_74755[(1)] = (38));

} else {
var statearr_74698_74756 = state_74635__$1;
(statearr_74698_74756[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74636 === (8))){
var inst_74521 = (state_74635[(18)]);
var inst_74521__$1 = (state_74635[(2)]);
var inst_74522 = cljs.core.some(cljs.core.string_QMARK_,inst_74521__$1);
var state_74635__$1 = (function (){var statearr_74699 = state_74635;
(statearr_74699[(18)] = inst_74521__$1);

return statearr_74699;
})();
if(cljs.core.truth_(inst_74522)){
var statearr_74700_74757 = state_74635__$1;
(statearr_74700_74757[(1)] = (9));

} else {
var statearr_74701_74758 = state_74635__$1;
(statearr_74701_74758[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_74702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74702[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_74702[(1)] = (1));

return statearr_74702;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_74635){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74635);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74703){var ex__2730__auto__ = e74703;
var statearr_74704_74759 = state_74635;
(statearr_74704_74759[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74635[(4)]))){
var statearr_74705_74760 = state_74635;
(statearr_74705_74760[(1)] = cljs.core.first((state_74635[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74761 = state_74635;
state_74635 = G__74761;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_74635){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_74635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74706 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74706[(6)] = c__2749__auto__);

return statearr_74706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74911){
var state_val_74912 = (state_74911[(1)]);
if((state_val_74912 === (7))){
var inst_74823 = (state_74911[(2)]);
var inst_74824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74823,(0),null);
var inst_74825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74823,(1),null);
var inst_74833 = cljs.core.vals(inst_74825);
var inst_74834 = cljs.core.seq(inst_74833);
var inst_74835 = cljs.core.first(inst_74834);
var inst_74836 = cljs.core.next(inst_74834);
var inst_74837 = cljs.core.PersistentVector.EMPTY;
var inst_74838 = inst_74833;
var inst_74839 = inst_74837;
var state_74911__$1 = (function (){var statearr_74913 = state_74911;
(statearr_74913[(7)] = inst_74824);

(statearr_74913[(8)] = inst_74838);

(statearr_74913[(9)] = inst_74839);

(statearr_74913[(10)] = inst_74835);

(statearr_74913[(11)] = inst_74836);

return statearr_74913;
})();
var statearr_74914_74967 = state_74911__$1;
(statearr_74914_74967[(2)] = null);

(statearr_74914_74967[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (20))){
var inst_74845 = (state_74911[(12)]);
var inst_74850 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_74851 = cljs.core.PersistentHashMap.EMPTY;
var inst_74852 = [true,inst_74851];
var inst_74853 = cljs.core.PersistentHashMap.fromArrays(inst_74850,inst_74852);
var inst_74854 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_74853,inst_74845);
var state_74911__$1 = state_74911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74911__$1,(22),inst_74854);
} else {
if((state_val_74912 === (27))){
var inst_74899 = (state_74911[(2)]);
var state_74911__$1 = state_74911;
var statearr_74915_74968 = state_74911__$1;
(statearr_74915_74968[(2)] = inst_74899);

(statearr_74915_74968[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (1))){
var state_74911__$1 = state_74911;
var statearr_74916_74969 = state_74911__$1;
(statearr_74916_74969[(2)] = null);

(statearr_74916_74969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (24))){
var inst_74863 = (state_74911[(13)]);
var inst_74901 = (state_74911[(2)]);
var inst_74902 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_74903 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_74904 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_74905 = [inst_74903,inst_74904,inst_74863,inst_74901];
var inst_74906 = cljs.core.PersistentHashMap.fromArrays(inst_74902,inst_74905);
var _ = (function (){var statearr_74918 = state_74911;
(statearr_74918[(4)] = cljs.core.rest((state_74911[(4)])));

return statearr_74918;
})();
var state_74911__$1 = state_74911;
var statearr_74919_74970 = state_74911__$1;
(statearr_74919_74970[(2)] = inst_74906);

(statearr_74919_74970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (4))){
var inst_74764 = (state_74911[(2)]);
var state_74911__$1 = state_74911;
var statearr_74920_74971 = state_74911__$1;
(statearr_74920_74971[(2)] = inst_74764);

(statearr_74920_74971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (15))){
var inst_74795 = (state_74911[(14)]);
var inst_74794 = (state_74911[(15)]);
var inst_74788 = (state_74911[(16)]);
var inst_74804 = (state_74911[(17)]);
var inst_74780 = (state_74911[(18)]);
var inst_74786 = (state_74911[(19)]);
var inst_74787 = (state_74911[(20)]);
var inst_74783 = (state_74911[(21)]);
var inst_74802 = (state_74911[(22)]);
var inst_74809 = (state_74911[(23)]);
var inst_74782 = (state_74911[(24)]);
var inst_74815 = (function (){var vec__74777 = inst_74780;
var subject = inst_74802;
var G__74776 = inst_74786;
var flake = inst_74794;
var seq__74791 = inst_74795;
var vec__74790 = inst_74786;
var r = inst_74795;
var asserted_subjects = inst_74787;
var flake_SINGLEQUOTE_ = inst_74809;
var retracted_subjects = inst_74788;
var seq__74778 = inst_74783;
var asserted_QMARK_ = inst_74804;
var first__74792 = inst_74794;
var first__74779 = inst_74782;
return (function (p1__74763_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__74763_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_74816 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_74788,inst_74802,inst_74815);
var tmp74917 = inst_74787;
var inst_74786__$1 = inst_74795;
var inst_74787__$1 = tmp74917;
var inst_74788__$1 = inst_74816;
var state_74911__$1 = (function (){var statearr_74921 = state_74911;
(statearr_74921[(16)] = inst_74788__$1);

(statearr_74921[(19)] = inst_74786__$1);

(statearr_74921[(20)] = inst_74787__$1);

return statearr_74921;
})();
var statearr_74922_74972 = state_74911__$1;
(statearr_74922_74972[(2)] = null);

(statearr_74922_74972[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (21))){
var inst_74861 = (state_74911[(2)]);
var state_74911__$1 = state_74911;
var statearr_74923_74973 = state_74911__$1;
(statearr_74923_74973[(2)] = inst_74861);

(statearr_74923_74973[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (13))){
var inst_74804 = (state_74911[(17)]);
var inst_74809 = (state_74911[(2)]);
var state_74911__$1 = (function (){var statearr_74924 = state_74911;
(statearr_74924[(23)] = inst_74809);

return statearr_74924;
})();
if(cljs.core.truth_(inst_74804)){
var statearr_74925_74974 = state_74911__$1;
(statearr_74925_74974[(1)] = (14));

} else {
var statearr_74926_74975 = state_74911__$1;
(statearr_74926_74975[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (22))){
var inst_74846 = (state_74911[(25)]);
var inst_74839 = (state_74911[(9)]);
var inst_74856 = (state_74911[(2)]);
var inst_74857 = fluree.db.util.async.throw_err(inst_74856);
var inst_74858 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_74839,inst_74857);
var inst_74838 = inst_74846;
var inst_74839__$1 = inst_74858;
var state_74911__$1 = (function (){var statearr_74927 = state_74911;
(statearr_74927[(8)] = inst_74838);

(statearr_74927[(9)] = inst_74839__$1);

return statearr_74927;
})();
var statearr_74928_74976 = state_74911__$1;
(statearr_74928_74976[(2)] = null);

(statearr_74928_74976[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (6))){
var inst_74794 = (state_74911[(15)]);
var inst_74786 = (state_74911[(19)]);
var inst_74793 = cljs.core.seq(inst_74786);
var inst_74794__$1 = cljs.core.first(inst_74793);
var inst_74795 = cljs.core.next(inst_74793);
var inst_74796 = cljs.core.not(inst_74794__$1);
var state_74911__$1 = (function (){var statearr_74929 = state_74911;
(statearr_74929[(14)] = inst_74795);

(statearr_74929[(15)] = inst_74794__$1);

return statearr_74929;
})();
if(inst_74796){
var statearr_74930_74977 = state_74911__$1;
(statearr_74930_74977[(1)] = (8));

} else {
var statearr_74931_74978 = state_74911__$1;
(statearr_74931_74978[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (28))){
var inst_74884 = (state_74911[(26)]);
var inst_74877 = (state_74911[(27)]);
var inst_74894 = (state_74911[(2)]);
var inst_74895 = fluree.db.util.async.throw_err(inst_74894);
var inst_74896 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_74877,inst_74895);
var inst_74876 = inst_74884;
var inst_74877__$1 = inst_74896;
var state_74911__$1 = (function (){var statearr_74932 = state_74911;
(statearr_74932[(28)] = inst_74876);

(statearr_74932[(27)] = inst_74877__$1);

return statearr_74932;
})();
var statearr_74933_74979 = state_74911__$1;
(statearr_74933_74979[(2)] = null);

(statearr_74933_74979[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (25))){
var inst_74877 = (state_74911[(27)]);
var state_74911__$1 = state_74911;
var statearr_74934_74980 = state_74911__$1;
(statearr_74934_74980[(2)] = inst_74877);

(statearr_74934_74980[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (17))){
var inst_74845 = (state_74911[(12)]);
var inst_74838 = (state_74911[(8)]);
var inst_74844 = cljs.core.seq(inst_74838);
var inst_74845__$1 = cljs.core.first(inst_74844);
var inst_74846 = cljs.core.next(inst_74844);
var inst_74847 = cljs.core.not(inst_74845__$1);
var state_74911__$1 = (function (){var statearr_74935 = state_74911;
(statearr_74935[(25)] = inst_74846);

(statearr_74935[(12)] = inst_74845__$1);

return statearr_74935;
})();
if(inst_74847){
var statearr_74936_74981 = state_74911__$1;
(statearr_74936_74981[(1)] = (19));

} else {
var statearr_74937_74982 = state_74911__$1;
(statearr_74937_74982[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (3))){
var inst_74909 = (state_74911[(2)]);
var state_74911__$1 = state_74911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74911__$1,inst_74909);
} else {
if((state_val_74912 === (12))){
var inst_74794 = (state_74911[(15)]);
var inst_74807 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_74794);
var state_74911__$1 = state_74911;
var statearr_74938_74983 = state_74911__$1;
(statearr_74938_74983[(2)] = inst_74807);

(statearr_74938_74983[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (2))){
var inst_74780 = (state_74911[(18)]);
var _ = (function (){var statearr_74939 = state_74911;
(statearr_74939[(4)] = cljs.core.cons((5),(state_74911[(4)])));

return statearr_74939;
})();
var inst_74780__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_74781 = cljs.core.seq(inst_74780__$1);
var inst_74782 = cljs.core.first(inst_74781);
var inst_74783 = cljs.core.next(inst_74781);
var inst_74784 = cljs.core.PersistentHashMap.EMPTY;
var inst_74785 = cljs.core.PersistentHashMap.EMPTY;
var inst_74786 = inst_74780__$1;
var inst_74787 = inst_74784;
var inst_74788 = inst_74785;
var state_74911__$1 = (function (){var statearr_74940 = state_74911;
(statearr_74940[(16)] = inst_74788);

(statearr_74940[(18)] = inst_74780__$1);

(statearr_74940[(19)] = inst_74786);

(statearr_74940[(20)] = inst_74787);

(statearr_74940[(21)] = inst_74783);

(statearr_74940[(24)] = inst_74782);

return statearr_74940;
})();
var statearr_74941_74984 = state_74911__$1;
(statearr_74941_74984[(2)] = null);

(statearr_74941_74984[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (23))){
var inst_74883 = (state_74911[(29)]);
var inst_74876 = (state_74911[(28)]);
var inst_74882 = cljs.core.seq(inst_74876);
var inst_74883__$1 = cljs.core.first(inst_74882);
var inst_74884 = cljs.core.next(inst_74882);
var inst_74885 = cljs.core.not(inst_74883__$1);
var state_74911__$1 = (function (){var statearr_74942 = state_74911;
(statearr_74942[(29)] = inst_74883__$1);

(statearr_74942[(26)] = inst_74884);

return statearr_74942;
})();
if(inst_74885){
var statearr_74943_74985 = state_74911__$1;
(statearr_74943_74985[(1)] = (25));

} else {
var statearr_74944_74986 = state_74911__$1;
(statearr_74944_74986[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (19))){
var inst_74839 = (state_74911[(9)]);
var state_74911__$1 = state_74911;
var statearr_74945_74987 = state_74911__$1;
(statearr_74945_74987[(2)] = inst_74839);

(statearr_74945_74987[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (11))){
var inst_74794 = (state_74911[(15)]);
var state_74911__$1 = state_74911;
var statearr_74947_74988 = state_74911__$1;
(statearr_74947_74988[(2)] = inst_74794);

(statearr_74947_74988[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (9))){
var inst_74794 = (state_74911[(15)]);
var inst_74804 = (state_74911[(17)]);
var inst_74802 = fluree.db.flake.s(inst_74794);
var inst_74803 = fluree.db.flake.op(inst_74794);
var inst_74804__$1 = inst_74803 === true;
var state_74911__$1 = (function (){var statearr_74949 = state_74911;
(statearr_74949[(17)] = inst_74804__$1);

(statearr_74949[(22)] = inst_74802);

return statearr_74949;
})();
if(cljs.core.truth_(inst_74804__$1)){
var statearr_74950_74989 = state_74911__$1;
(statearr_74950_74989[(1)] = (11));

} else {
var statearr_74951_74990 = state_74911__$1;
(statearr_74951_74990[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (5))){
var _ = (function (){var statearr_74952 = state_74911;
(statearr_74952[(4)] = cljs.core.rest((state_74911[(4)])));

return statearr_74952;
})();
var state_74911__$1 = state_74911;
var ex74946 = (state_74911__$1[(2)]);
var statearr_74953_74991 = state_74911__$1;
(statearr_74953_74991[(5)] = ex74946);


if((ex74946 instanceof Error)){
var statearr_74954_74992 = state_74911__$1;
(statearr_74954_74992[(1)] = (4));

(statearr_74954_74992[(5)] = null);

} else {
throw ex74946;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (14))){
var inst_74795 = (state_74911[(14)]);
var inst_74794 = (state_74911[(15)]);
var inst_74788 = (state_74911[(16)]);
var inst_74804 = (state_74911[(17)]);
var inst_74780 = (state_74911[(18)]);
var inst_74786 = (state_74911[(19)]);
var inst_74787 = (state_74911[(20)]);
var inst_74783 = (state_74911[(21)]);
var inst_74802 = (state_74911[(22)]);
var inst_74809 = (state_74911[(23)]);
var inst_74782 = (state_74911[(24)]);
var inst_74811 = (function (){var vec__74777 = inst_74780;
var subject = inst_74802;
var G__74776 = inst_74786;
var flake = inst_74794;
var seq__74791 = inst_74795;
var vec__74790 = inst_74786;
var r = inst_74795;
var asserted_subjects = inst_74787;
var flake_SINGLEQUOTE_ = inst_74809;
var retracted_subjects = inst_74788;
var seq__74778 = inst_74783;
var asserted_QMARK_ = inst_74804;
var first__74792 = inst_74794;
var first__74779 = inst_74782;
return (function (p1__74762_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__74762_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_74812 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_74787,inst_74802,inst_74811);
var tmp74948 = inst_74788;
var inst_74786__$1 = inst_74795;
var inst_74787__$1 = inst_74812;
var inst_74788__$1 = tmp74948;
var state_74911__$1 = (function (){var statearr_74955 = state_74911;
(statearr_74955[(16)] = inst_74788__$1);

(statearr_74955[(19)] = inst_74786__$1);

(statearr_74955[(20)] = inst_74787__$1);

return statearr_74955;
})();
var statearr_74956_74993 = state_74911__$1;
(statearr_74956_74993[(2)] = null);

(statearr_74956_74993[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (26))){
var inst_74883 = (state_74911[(29)]);
var inst_74888 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_74889 = cljs.core.PersistentHashMap.EMPTY;
var inst_74890 = [true,inst_74889];
var inst_74891 = cljs.core.PersistentHashMap.fromArrays(inst_74888,inst_74890);
var inst_74892 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_74891,inst_74883);
var state_74911__$1 = state_74911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74911__$1,(28),inst_74892);
} else {
if((state_val_74912 === (16))){
var inst_74819 = (state_74911[(2)]);
var state_74911__$1 = state_74911;
var statearr_74957_74994 = state_74911__$1;
(statearr_74957_74994[(2)] = inst_74819);

(statearr_74957_74994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (10))){
var inst_74821 = (state_74911[(2)]);
var state_74911__$1 = state_74911;
var statearr_74958_74995 = state_74911__$1;
(statearr_74958_74995[(2)] = inst_74821);

(statearr_74958_74995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (18))){
var inst_74824 = (state_74911[(7)]);
var inst_74863 = (state_74911[(2)]);
var inst_74871 = cljs.core.vals(inst_74824);
var inst_74872 = cljs.core.seq(inst_74871);
var inst_74873 = cljs.core.first(inst_74872);
var inst_74874 = cljs.core.next(inst_74872);
var inst_74875 = cljs.core.PersistentVector.EMPTY;
var inst_74876 = inst_74871;
var inst_74877 = inst_74875;
var state_74911__$1 = (function (){var statearr_74959 = state_74911;
(statearr_74959[(30)] = inst_74874);

(statearr_74959[(13)] = inst_74863);

(statearr_74959[(31)] = inst_74873);

(statearr_74959[(28)] = inst_74876);

(statearr_74959[(27)] = inst_74877);

return statearr_74959;
})();
var statearr_74960_74996 = state_74911__$1;
(statearr_74960_74996[(2)] = null);

(statearr_74960_74996[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74912 === (8))){
var inst_74788 = (state_74911[(16)]);
var inst_74787 = (state_74911[(20)]);
var inst_74798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74799 = [inst_74787,inst_74788];
var inst_74800 = (new cljs.core.PersistentVector(null,2,(5),inst_74798,inst_74799,null));
var state_74911__$1 = state_74911;
var statearr_74961_74997 = state_74911__$1;
(statearr_74961_74997[(2)] = inst_74800);

(statearr_74961_74997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_74962 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74962[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_74962[(1)] = (1));

return statearr_74962;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_74911){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74911);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74963){var ex__2730__auto__ = e74963;
var statearr_74964_74998 = state_74911;
(statearr_74964_74998[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74911[(4)]))){
var statearr_74965_74999 = state_74911;
(statearr_74965_74999[(1)] = cljs.core.first((state_74911[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75000 = state_74911;
state_74911 = G__75000;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_74911){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_74911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74966 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74966[(6)] = c__2749__auto__);

return statearr_74966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75032){
var state_val_75033 = (state_75032[(1)]);
if((state_val_75033 === (1))){
var inst_75001 = cljs.core.volatile_BANG_((0));
var inst_75002 = cljs.core.PersistentHashMap.EMPTY;
var inst_75003 = cljs.core.volatile_BANG_(inst_75002);
var inst_75004 = cljs.core.first(resp);
var inst_75005 = cljs.core.rest(resp);
var inst_75006 = cljs.core.PersistentVector.EMPTY;
var inst_75007 = inst_75001;
var inst_75008 = inst_75003;
var inst_75009 = inst_75004;
var inst_75010 = inst_75005;
var inst_75011 = inst_75006;
var state_75032__$1 = (function (){var statearr_75034 = state_75032;
(statearr_75034[(7)] = inst_75011);

(statearr_75034[(8)] = inst_75009);

(statearr_75034[(9)] = inst_75010);

(statearr_75034[(10)] = inst_75008);

(statearr_75034[(11)] = inst_75007);

return statearr_75034;
})();
var statearr_75035_75050 = state_75032__$1;
(statearr_75035_75050[(2)] = null);

(statearr_75035_75050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75033 === (2))){
var inst_75009 = (state_75032[(8)]);
var inst_75008 = (state_75032[(10)]);
var inst_75007 = (state_75032[(11)]);
var inst_75013 = fluree.db.api.query.format_block_resp_pretty(db,inst_75009,inst_75008,inst_75007);
var state_75032__$1 = state_75032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75032__$1,(4),inst_75013);
} else {
if((state_val_75033 === (3))){
var inst_75030 = (state_75032[(2)]);
var state_75032__$1 = state_75032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75032__$1,inst_75030);
} else {
if((state_val_75033 === (4))){
var inst_75011 = (state_75032[(7)]);
var inst_75010 = (state_75032[(9)]);
var inst_75015 = (state_75032[(2)]);
var inst_75016 = fluree.db.util.async.throw_err(inst_75015);
var inst_75017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75018 = [inst_75016];
var inst_75019 = (new cljs.core.PersistentVector(null,1,(5),inst_75017,inst_75018,null));
var inst_75020 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_75011,inst_75019);
var inst_75021 = cljs.core.first(inst_75010);
var state_75032__$1 = (function (){var statearr_75038 = state_75032;
(statearr_75038[(12)] = inst_75020);

return statearr_75038;
})();
if(cljs.core.truth_(inst_75021)){
var statearr_75039_75051 = state_75032__$1;
(statearr_75039_75051[(1)] = (5));

} else {
var statearr_75040_75052 = state_75032__$1;
(statearr_75040_75052[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75033 === (5))){
var inst_75020 = (state_75032[(12)]);
var inst_75010 = (state_75032[(9)]);
var inst_75008 = (state_75032[(10)]);
var inst_75007 = (state_75032[(11)]);
var inst_75023 = cljs.core.first(inst_75010);
var inst_75024 = cljs.core.rest(inst_75010);
var tmp75036 = inst_75008;
var tmp75037 = inst_75007;
var inst_75007__$1 = tmp75037;
var inst_75008__$1 = tmp75036;
var inst_75009 = inst_75023;
var inst_75010__$1 = inst_75024;
var inst_75011 = inst_75020;
var state_75032__$1 = (function (){var statearr_75041 = state_75032;
(statearr_75041[(7)] = inst_75011);

(statearr_75041[(8)] = inst_75009);

(statearr_75041[(9)] = inst_75010__$1);

(statearr_75041[(10)] = inst_75008__$1);

(statearr_75041[(11)] = inst_75007__$1);

return statearr_75041;
})();
var statearr_75042_75053 = state_75032__$1;
(statearr_75042_75053[(2)] = null);

(statearr_75042_75053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75033 === (6))){
var inst_75020 = (state_75032[(12)]);
var state_75032__$1 = state_75032;
var statearr_75043_75054 = state_75032__$1;
(statearr_75043_75054[(2)] = inst_75020);

(statearr_75043_75054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75033 === (7))){
var inst_75028 = (state_75032[(2)]);
var state_75032__$1 = state_75032;
var statearr_75044_75055 = state_75032__$1;
(statearr_75044_75055[(2)] = inst_75028);

(statearr_75044_75055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_75045 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75045[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_75045[(1)] = (1));

return statearr_75045;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_75032){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75032);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75046){var ex__2730__auto__ = e75046;
var statearr_75047_75056 = state_75032;
(statearr_75047_75056[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75032[(4)]))){
var statearr_75048_75057 = state_75032;
(statearr_75048_75057[(1)] = cljs.core.first((state_75032[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75058 = state_75032;
state_75032 = G__75058;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_75032){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_75032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75049 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75049[(6)] = c__2749__auto__);

return statearr_75049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__75060 = arguments.length;
switch (G__75060) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__75062){
var map__75063 = p__75062;
var map__75063__$1 = cljs.core.__destructure_map(map__75063);
var query = map__75063__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75063__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75148){
var state_val_75149 = (state_75148[(1)]);
if((state_val_75149 === (7))){
var inst_75074 = (state_75148[(7)]);
var inst_75078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75079 = ["_auth/id",inst_75074];
var inst_75080 = (new cljs.core.PersistentVector(null,2,(5),inst_75078,inst_75079,null));
var state_75148__$1 = state_75148;
var statearr_75150_75194 = state_75148__$1;
(statearr_75150_75194[(2)] = inst_75080);

(statearr_75150_75194[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (20))){
var inst_75128 = (state_75148[(2)]);
var inst_75129 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_75148__$1 = (function (){var statearr_75151 = state_75148;
(statearr_75151[(8)] = inst_75128);

return statearr_75151;
})();
if(cljs.core.truth_(inst_75129)){
var statearr_75152_75195 = state_75148__$1;
(statearr_75152_75195[(1)] = (22));

} else {
var statearr_75153_75196 = state_75148__$1;
(statearr_75153_75196[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (27))){
var inst_75075 = (state_75148[(9)]);
var inst_75131 = (state_75148[(10)]);
var inst_75137 = (state_75148[(2)]);
var inst_75138 = fluree.db.util.core.response_time_formatted(inst_75075);
var inst_75139 = [(200),inst_75137,(100),inst_75138];
var inst_75140 = cljs.core.PersistentHashMap.fromArrays(inst_75131,inst_75139);
var state_75148__$1 = state_75148;
var statearr_75154_75197 = state_75148__$1;
(statearr_75154_75197[(2)] = inst_75140);

(statearr_75154_75197[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (1))){
var state_75148__$1 = state_75148;
var statearr_75155_75198 = state_75148__$1;
(statearr_75155_75198[(2)] = null);

(statearr_75155_75198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (24))){
var inst_75143 = (state_75148[(2)]);
var _ = (function (){var statearr_75156 = state_75148;
(statearr_75156[(4)] = cljs.core.rest((state_75148[(4)])));

return statearr_75156;
})();
var state_75148__$1 = state_75148;
var statearr_75157_75199 = state_75148__$1;
(statearr_75157_75199[(2)] = inst_75143);

(statearr_75157_75199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (4))){
var inst_75064 = (state_75148[(2)]);
var state_75148__$1 = state_75148;
var statearr_75158_75200 = state_75148__$1;
(statearr_75158_75200[(2)] = inst_75064);

(statearr_75158_75200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (15))){
var inst_75115 = (state_75148[(11)]);
var state_75148__$1 = state_75148;
var statearr_75159_75201 = state_75148__$1;
(statearr_75159_75201[(2)] = inst_75115);

(statearr_75159_75201[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (21))){
var inst_75124 = (state_75148[(2)]);
var inst_75125 = fluree.db.util.async.throw_err(inst_75124);
var state_75148__$1 = state_75148;
var statearr_75160_75202 = state_75148__$1;
(statearr_75160_75202[(2)] = inst_75125);

(statearr_75160_75202[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (13))){
var inst_75115 = (state_75148[(11)]);
var inst_75073 = (state_75148[(12)]);
var inst_75114 = (state_75148[(2)]);
var inst_75115__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_75073);
var state_75148__$1 = (function (){var statearr_75161 = state_75148;
(statearr_75161[(11)] = inst_75115__$1);

(statearr_75161[(13)] = inst_75114);

return statearr_75161;
})();
if(cljs.core.truth_(inst_75115__$1)){
var statearr_75162_75203 = state_75148__$1;
(statearr_75162_75203[(1)] = (15));

} else {
var statearr_75163_75204 = state_75148__$1;
(statearr_75163_75204[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (22))){
var inst_75128 = (state_75148[(8)]);
var inst_75131 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_75132 = cljs.core.sequential_QMARK_(inst_75128);
var state_75148__$1 = (function (){var statearr_75164 = state_75148;
(statearr_75164[(10)] = inst_75131);

return statearr_75164;
})();
if(inst_75132){
var statearr_75165_75205 = state_75148__$1;
(statearr_75165_75205[(1)] = (25));

} else {
var statearr_75166_75206 = state_75148__$1;
(statearr_75166_75206[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (6))){
var inst_75073 = (state_75148[(12)]);
var inst_75089 = (state_75148[(14)]);
var inst_75088 = (state_75148[(2)]);
var inst_75089__$1 = fluree.db.util.async.throw_err(inst_75088);
var inst_75090 = fluree.db.api.query.resolve_block_range(inst_75089__$1,inst_75073);
var state_75148__$1 = (function (){var statearr_75167 = state_75148;
(statearr_75167[(14)] = inst_75089__$1);

return statearr_75167;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75148__$1,(10),inst_75090);
} else {
if((state_val_75149 === (25))){
var inst_75128 = (state_75148[(8)]);
var inst_75134 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_75128);
var state_75148__$1 = state_75148;
var statearr_75168_75207 = state_75148__$1;
(statearr_75168_75207[(2)] = inst_75134);

(statearr_75168_75207[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (17))){
var inst_75120 = (state_75148[(2)]);
var state_75148__$1 = state_75148;
if(cljs.core.truth_(inst_75120)){
var statearr_75169_75208 = state_75148__$1;
(statearr_75169_75208[(1)] = (18));

} else {
var statearr_75170_75209 = state_75148__$1;
(statearr_75170_75209[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (3))){
var inst_75146 = (state_75148[(2)]);
var state_75148__$1 = state_75148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75148__$1,inst_75146);
} else {
if((state_val_75149 === (12))){
var inst_75073 = (state_75148[(12)]);
var inst_75106 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75073], 0));
var inst_75107 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_75106].join('');
var inst_75108 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75109 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75110 = cljs.core.PersistentHashMap.fromArrays(inst_75108,inst_75109);
var inst_75111 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75107,inst_75110);
var inst_75112 = (function(){throw inst_75111})();
var state_75148__$1 = state_75148;
var statearr_75171_75210 = state_75148__$1;
(statearr_75171_75210[(2)] = inst_75112);

(statearr_75171_75210[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (2))){
var inst_75074 = (state_75148[(7)]);
var _ = (function (){var statearr_75172 = state_75148;
(statearr_75172[(4)] = cljs.core.cons((5),(state_75148[(4)])));

return statearr_75172;
})();
var inst_75073 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_75074__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_75075 = fluree.db.util.core.current_time_millis();
var inst_75076 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_75148__$1 = (function (){var statearr_75173 = state_75148;
(statearr_75173[(9)] = inst_75075);

(statearr_75173[(12)] = inst_75073);

(statearr_75173[(7)] = inst_75074__$1);

(statearr_75173[(15)] = inst_75076);

return statearr_75173;
})();
if(cljs.core.truth_(inst_75074__$1)){
var statearr_75174_75211 = state_75148__$1;
(statearr_75174_75211[(1)] = (7));

} else {
var statearr_75175_75212 = state_75148__$1;
(statearr_75175_75212[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (23))){
var inst_75128 = (state_75148[(8)]);
var state_75148__$1 = state_75148;
var statearr_75176_75213 = state_75148__$1;
(statearr_75176_75213[(2)] = inst_75128);

(statearr_75176_75213[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (19))){
var inst_75114 = (state_75148[(13)]);
var state_75148__$1 = state_75148;
var statearr_75177_75214 = state_75148__$1;
(statearr_75177_75214[(2)] = inst_75114);

(statearr_75177_75214[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (11))){
var inst_75094 = (state_75148[(16)]);
var inst_75089 = (state_75148[(14)]);
var inst_75095 = (state_75148[(17)]);
var inst_75101 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_75089,inst_75094,inst_75095,opts);
var state_75148__$1 = state_75148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75148__$1,(14),inst_75101);
} else {
if((state_val_75149 === (9))){
var inst_75076 = (state_75148[(15)]);
var inst_75083 = (state_75148[(2)]);
var inst_75084 = [inst_75083];
var inst_75085 = cljs.core.PersistentHashMap.fromArrays(inst_75076,inst_75084);
var inst_75086 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_75085);
var state_75148__$1 = state_75148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75148__$1,(6),inst_75086);
} else {
if((state_val_75149 === (5))){
var _ = (function (){var statearr_75179 = state_75148;
(statearr_75179[(4)] = cljs.core.rest((state_75148[(4)])));

return statearr_75179;
})();
var state_75148__$1 = state_75148;
var ex75178 = (state_75148__$1[(2)]);
var statearr_75180_75215 = state_75148__$1;
(statearr_75180_75215[(5)] = ex75178);


if((ex75178 instanceof Error)){
var statearr_75181_75216 = state_75148__$1;
(statearr_75181_75216[(1)] = (4));

(statearr_75181_75216[(5)] = null);

} else {
throw ex75178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (14))){
var inst_75103 = (state_75148[(2)]);
var inst_75104 = fluree.db.util.async.throw_err(inst_75103);
var state_75148__$1 = state_75148;
var statearr_75182_75217 = state_75148__$1;
(statearr_75182_75217[(2)] = inst_75104);

(statearr_75182_75217[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (26))){
var inst_75128 = (state_75148[(8)]);
var state_75148__$1 = state_75148;
var statearr_75183_75218 = state_75148__$1;
(statearr_75183_75218[(2)] = inst_75128);

(statearr_75183_75218[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (16))){
var inst_75073 = (state_75148[(12)]);
var inst_75118 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_75073);
var state_75148__$1 = state_75148;
var statearr_75184_75219 = state_75148__$1;
(statearr_75184_75219[(2)] = inst_75118);

(statearr_75184_75219[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (10))){
var inst_75073 = (state_75148[(12)]);
var inst_75092 = (state_75148[(2)]);
var inst_75093 = fluree.db.util.async.throw_err(inst_75092);
var inst_75094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75093,(0),null);
var inst_75095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75093,(1),null);
var inst_75096 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_75097 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_75073,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_75098 = cljs.core.keys(inst_75097);
var inst_75099 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75096,inst_75098);
var state_75148__$1 = (function (){var statearr_75185 = state_75148;
(statearr_75185[(16)] = inst_75094);

(statearr_75185[(17)] = inst_75095);

return statearr_75185;
})();
if(inst_75099){
var statearr_75186_75220 = state_75148__$1;
(statearr_75186_75220[(1)] = (11));

} else {
var statearr_75187_75221 = state_75148__$1;
(statearr_75187_75221[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75149 === (18))){
var inst_75114 = (state_75148[(13)]);
var inst_75089 = (state_75148[(14)]);
var inst_75122 = fluree.db.api.query.format_blocks_resp_pretty(inst_75089,inst_75114);
var state_75148__$1 = state_75148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75148__$1,(21),inst_75122);
} else {
if((state_val_75149 === (8))){
var state_75148__$1 = state_75148;
var statearr_75188_75222 = state_75148__$1;
(statearr_75188_75222[(2)] = null);

(statearr_75188_75222[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_75189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75189[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_75189[(1)] = (1));

return statearr_75189;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_75148){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75148);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75190){var ex__2730__auto__ = e75190;
var statearr_75191_75223 = state_75148;
(statearr_75191_75223[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75148[(4)]))){
var statearr_75192_75224 = state_75148;
(statearr_75192_75224[(1)] = cljs.core.first((state_75148[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75225 = state_75148;
state_75148 = G__75225;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_75148){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_75148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75193 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75193[(6)] = c__2749__auto__);

return statearr_75193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__75226 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75226,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75226,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75226,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75226,(3),null);
var vec__75229 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75229,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75229,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__75232 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75232,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75232,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___75236 = arguments.length;
var i__5770__auto___75237 = (0);
while(true){
if((i__5770__auto___75237 < len__5769__auto___75236)){
args__5775__auto__.push((arguments[i__5770__auto___75237]));

var G__75238 = (i__5770__auto___75237 + (1));
i__5770__auto___75237 = G__75238;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq75235){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq75235));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75434){
var state_val_75435 = (state_75434[(1)]);
if((state_val_75435 === (7))){
var inst_75354 = (state_75434[(7)]);
var inst_75361 = (state_75434[(8)]);
var inst_75360 = cljs.core.seq(inst_75354);
var inst_75361__$1 = cljs.core.first(inst_75360);
var inst_75362 = cljs.core.next(inst_75360);
var state_75434__$1 = (function (){var statearr_75436 = state_75434;
(statearr_75436[(9)] = inst_75362);

(statearr_75436[(8)] = inst_75361__$1);

return statearr_75436;
})();
if(cljs.core.truth_(inst_75361__$1)){
var statearr_75437_75537 = state_75434__$1;
(statearr_75437_75537[(1)] = (9));

} else {
var statearr_75438_75538 = state_75434__$1;
(statearr_75438_75538[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (20))){
var inst_75424 = (state_75434[(2)]);
var state_75434__$1 = state_75434;
var statearr_75439_75539 = state_75434__$1;
(statearr_75439_75539[(2)] = inst_75424);

(statearr_75439_75539[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (27))){
var inst_75400 = (state_75434[(10)]);
var inst_75379 = (state_75434[(11)]);
var inst_75382 = (state_75434[(12)]);
var inst_75402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75403 = [inst_75382,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_75404 = (new cljs.core.PersistentVector(null,2,(5),inst_75402,inst_75403,null));
var inst_75405 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_75400,inst_75404,fluree.db.api.query.min_safe,inst_75379);
var state_75434__$1 = state_75434;
var statearr_75440_75540 = state_75434__$1;
(statearr_75440_75540[(2)] = inst_75405);

(statearr_75440_75540[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (1))){
var state_75434__$1 = state_75434;
var statearr_75441_75541 = state_75434__$1;
(statearr_75441_75541[(2)] = null);

(statearr_75441_75541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (24))){
var inst_75392 = (state_75434[(13)]);
var inst_75382 = (state_75434[(12)]);
var inst_75361 = (state_75434[(8)]);
var inst_75394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75395 = [inst_75382,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_75396 = (new cljs.core.PersistentVector(null,2,(5),inst_75394,inst_75395,null));
var inst_75397 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_75392,inst_75396,cljs.core.conj,inst_75361);
var state_75434__$1 = state_75434;
var statearr_75443_75542 = state_75434__$1;
(statearr_75443_75542[(2)] = inst_75397);

(statearr_75443_75542[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (4))){
var inst_75240 = (state_75434[(2)]);
var state_75434__$1 = state_75434;
var statearr_75444_75543 = state_75434__$1;
(statearr_75444_75543[(2)] = inst_75240);

(statearr_75444_75543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (15))){
var inst_75362 = (state_75434[(9)]);
var inst_75355 = (state_75434[(14)]);
var tmp75442 = inst_75355;
var inst_75354 = inst_75362;
var inst_75355__$1 = tmp75442;
var state_75434__$1 = (function (){var statearr_75445 = state_75434;
(statearr_75445[(7)] = inst_75354);

(statearr_75445[(14)] = inst_75355__$1);

return statearr_75445;
})();
var statearr_75446_75544 = state_75434__$1;
(statearr_75446_75544[(2)] = null);

(statearr_75446_75544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (21))){
var inst_75382 = (state_75434[(12)]);
var inst_75355 = (state_75434[(14)]);
var inst_75386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75387 = [inst_75382,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_75388 = (new cljs.core.PersistentVector(null,2,(5),inst_75386,inst_75387,null));
var inst_75389 = cljs.core.assoc_in(inst_75355,inst_75388,inst_75382);
var state_75434__$1 = state_75434;
var statearr_75447_75545 = state_75434__$1;
(statearr_75447_75545[(2)] = inst_75389);

(statearr_75447_75545[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (31))){
var inst_75408 = (state_75434[(15)]);
var state_75434__$1 = state_75434;
var statearr_75448_75546 = state_75434__$1;
(statearr_75448_75546[(2)] = inst_75408);

(statearr_75448_75546[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (32))){
var inst_75362 = (state_75434[(9)]);
var inst_75416 = (state_75434[(2)]);
var inst_75354 = inst_75362;
var inst_75355 = inst_75416;
var state_75434__$1 = (function (){var statearr_75449 = state_75434;
(statearr_75449[(7)] = inst_75354);

(statearr_75449[(14)] = inst_75355);

return statearr_75449;
})();
var statearr_75450_75547 = state_75434__$1;
(statearr_75450_75547[(2)] = null);

(statearr_75450_75547[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (33))){
var inst_75355 = (state_75434[(14)]);
var state_75434__$1 = state_75434;
var statearr_75451_75548 = state_75434__$1;
(statearr_75451_75548[(2)] = inst_75355);

(statearr_75451_75548[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (13))){
var inst_75364 = (state_75434[(16)]);
var state_75434__$1 = state_75434;
var statearr_75452_75549 = state_75434__$1;
(statearr_75452_75549[(2)] = inst_75364);

(statearr_75452_75549[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (22))){
var inst_75355 = (state_75434[(14)]);
var state_75434__$1 = state_75434;
var statearr_75453_75550 = state_75434__$1;
(statearr_75453_75550[(2)] = inst_75355);

(statearr_75453_75550[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (29))){
var inst_75408 = (state_75434[(2)]);
var state_75434__$1 = (function (){var statearr_75454 = state_75434;
(statearr_75454[(15)] = inst_75408);

return statearr_75454;
})();
if(cljs.core.truth_(show_auth)){
var statearr_75455_75551 = state_75434__$1;
(statearr_75455_75551[(1)] = (30));

} else {
var statearr_75456_75552 = state_75434__$1;
(statearr_75456_75552[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (6))){
var inst_75340 = (state_75434[(2)]);
var inst_75341 = fluree.db.util.async.throw_err(inst_75340);
var inst_75349 = resp;
var inst_75350 = cljs.core.seq(inst_75349);
var inst_75351 = cljs.core.first(inst_75350);
var inst_75352 = cljs.core.next(inst_75350);
var inst_75353 = cljs.core.PersistentHashMap.EMPTY;
var inst_75354 = inst_75349;
var inst_75355 = inst_75353;
var state_75434__$1 = (function (){var statearr_75457 = state_75434;
(statearr_75457[(7)] = inst_75354);

(statearr_75457[(17)] = inst_75351);

(statearr_75457[(18)] = inst_75352);

(statearr_75457[(19)] = inst_75341);

(statearr_75457[(14)] = inst_75355);

return statearr_75457;
})();
var statearr_75458_75553 = state_75434__$1;
(statearr_75458_75553[(2)] = null);

(statearr_75458_75553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (28))){
var inst_75400 = (state_75434[(10)]);
var state_75434__$1 = state_75434;
var statearr_75459_75554 = state_75434__$1;
(statearr_75459_75554[(2)] = inst_75400);

(statearr_75459_75554[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (25))){
var inst_75392 = (state_75434[(13)]);
var state_75434__$1 = state_75434;
var statearr_75460_75555 = state_75434__$1;
(statearr_75460_75555[(2)] = inst_75392);

(statearr_75460_75555[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (34))){
var state_75434__$1 = state_75434;
var statearr_75461_75556 = state_75434__$1;
(statearr_75461_75556[(2)] = null);

(statearr_75461_75556[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (17))){
var inst_75426 = (state_75434[(2)]);
var state_75434__$1 = state_75434;
var statearr_75462_75557 = state_75434__$1;
(statearr_75462_75557[(2)] = inst_75426);

(statearr_75462_75557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (3))){
var inst_75432 = (state_75434[(2)]);
var state_75434__$1 = state_75434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75434__$1,inst_75432);
} else {
if((state_val_75435 === (12))){
var inst_75341 = (state_75434[(19)]);
var inst_75361 = (state_75434[(8)]);
var inst_75366 = fluree.db.api.query.auth_match(auth,inst_75341,inst_75361);
var inst_75367 = cljs.core.not(inst_75366);
var state_75434__$1 = state_75434;
var statearr_75463_75558 = state_75434__$1;
(statearr_75463_75558[(2)] = inst_75367);

(statearr_75463_75558[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (2))){
var _ = (function (){var statearr_75464 = state_75434;
(statearr_75464[(4)] = cljs.core.cons((5),(state_75434[(4)])));

return statearr_75464;
})();
var inst_75246 = (function (){return (function (p1__75239_SHARP_){
return fluree.db.flake.t(p1__75239_SHARP_);
});
})();
var inst_75247 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_75246,resp);
var inst_75248 = cljs.core.set(inst_75247);
var inst_75336 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_75337 = (function (){var ts = inst_75248;
var c__2749__auto____$1 = inst_75336;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75334){
var state_val_75335 = (state_75334[(1)]);
if((state_val_75335 === (7))){
var inst_75268 = (state_75334[(7)]);
var inst_75262 = (state_75334[(8)]);
var inst_75274 = (state_75334[(9)]);
var inst_75280 = (state_75334[(10)]);
var inst_75273 = (state_75334[(2)]);
var inst_75274__$1 = fluree.db.util.async.throw_err(inst_75273);
var inst_75276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75277 = [inst_75268,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_75278 = (new cljs.core.PersistentVector(null,2,(5),inst_75276,inst_75277,null));
var inst_75279 = cljs.core.assoc_in(inst_75262,inst_75278,inst_75274__$1);
var inst_75280__$1 = auth;
var state_75334__$1 = (function (){var statearr_75465 = state_75334;
(statearr_75465[(11)] = inst_75279);

(statearr_75465[(9)] = inst_75274__$1);

(statearr_75465[(10)] = inst_75280__$1);

return statearr_75465;
})();
if(cljs.core.truth_(inst_75280__$1)){
var statearr_75466_75559 = state_75334__$1;
(statearr_75466_75559[(1)] = (8));

} else {
var statearr_75467_75560 = state_75334__$1;
(statearr_75467_75560[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (1))){
var inst_75256 = (state_75334[(12)]);
var inst_75256__$1 = ts;
var inst_75257 = cljs.core.seq(inst_75256__$1);
var inst_75258 = cljs.core.first(inst_75257);
var inst_75259 = cljs.core.next(inst_75257);
var inst_75260 = cljs.core.PersistentHashMap.EMPTY;
var inst_75261 = inst_75256__$1;
var inst_75262 = inst_75260;
var state_75334__$1 = (function (){var statearr_75468 = state_75334;
(statearr_75468[(12)] = inst_75256__$1);

(statearr_75468[(8)] = inst_75262);

(statearr_75468[(13)] = inst_75258);

(statearr_75468[(14)] = inst_75261);

(statearr_75468[(15)] = inst_75259);

return statearr_75468;
})();
var statearr_75469_75561 = state_75334__$1;
(statearr_75469_75561[(2)] = null);

(statearr_75469_75561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (4))){
var inst_75268 = (state_75334[(7)]);
var inst_75271 = fluree.db.time_travel.non_border_t_to_block(db,inst_75268);
var state_75334__$1 = state_75334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75334__$1,(7),inst_75271);
} else {
if((state_val_75335 === (13))){
var inst_75269 = (state_75334[(16)]);
var inst_75326 = (state_75334[(2)]);
var inst_75261 = inst_75269;
var inst_75262 = inst_75326;
var state_75334__$1 = (function (){var statearr_75470 = state_75334;
(statearr_75470[(8)] = inst_75262);

(statearr_75470[(14)] = inst_75261);

return statearr_75470;
})();
var statearr_75471_75562 = state_75334__$1;
(statearr_75471_75562[(2)] = null);

(statearr_75471_75562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (6))){
var inst_75330 = (state_75334[(2)]);
var state_75334__$1 = state_75334;
var statearr_75472_75563 = state_75334__$1;
(statearr_75472_75563[(2)] = inst_75330);

(statearr_75472_75563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (3))){
var inst_75332 = (state_75334[(2)]);
var state_75334__$1 = state_75334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75334__$1,inst_75332);
} else {
if((state_val_75335 === (12))){
var inst_75279 = (state_75334[(11)]);
var state_75334__$1 = state_75334;
var statearr_75473_75564 = state_75334__$1;
(statearr_75473_75564[(2)] = inst_75279);

(statearr_75473_75564[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (2))){
var inst_75268 = (state_75334[(7)]);
var inst_75261 = (state_75334[(14)]);
var inst_75267 = cljs.core.seq(inst_75261);
var inst_75268__$1 = cljs.core.first(inst_75267);
var inst_75269 = cljs.core.next(inst_75267);
var state_75334__$1 = (function (){var statearr_75474 = state_75334;
(statearr_75474[(7)] = inst_75268__$1);

(statearr_75474[(16)] = inst_75269);

return statearr_75474;
})();
if(cljs.core.truth_(inst_75268__$1)){
var statearr_75475_75565 = state_75334__$1;
(statearr_75475_75565[(1)] = (4));

} else {
var statearr_75476_75566 = state_75334__$1;
(statearr_75476_75566[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (11))){
var inst_75279 = (state_75334[(11)]);
var inst_75256 = (state_75334[(12)]);
var inst_75268 = (state_75334[(7)]);
var inst_75262 = (state_75334[(8)]);
var inst_75274 = (state_75334[(9)]);
var inst_75258 = (state_75334[(13)]);
var inst_75269 = (state_75334[(16)]);
var inst_75261 = (state_75334[(14)]);
var inst_75259 = (state_75334[(15)]);
var inst_75286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75287 = [inst_75268,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_75288 = (new cljs.core.PersistentVector(null,2,(5),inst_75286,inst_75287,null));
var inst_75301 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_75302 = (function (){var t = inst_75268;
var G__75275 = inst_75279;
var first__75266 = inst_75268;
var c__2749__auto____$2 = inst_75301;
var seq__75265 = inst_75269;
var vec__75253 = inst_75256;
var block = inst_75274;
var r = inst_75269;
var G__75252 = inst_75261;
var first__75255 = inst_75258;
var acc = inst_75262;
var seq__75254 = inst_75259;
var vec__75264 = inst_75261;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75299){
var state_val_75300 = (state_75299[(1)]);
if((state_val_75300 === (1))){
var state_75299__$1 = state_75299;
var statearr_75477_75567 = state_75299__$1;
(statearr_75477_75567[(2)] = null);

(statearr_75477_75567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75300 === (2))){
var ___$1 = (function (){var statearr_75478 = state_75299;
(statearr_75478[(4)] = cljs.core.cons((5),(state_75299[(4)])));

return statearr_75478;
})();
var ___$2 = (function (){var statearr_75479 = state_75299;
(statearr_75479[(4)] = cljs.core.rest((state_75299[(4)])));

return statearr_75479;
})();
var state_75299__$1 = state_75299;
var statearr_75480_75568 = state_75299__$1;
(statearr_75480_75568[(2)] = db);

(statearr_75480_75568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75300 === (3))){
var inst_75297 = (state_75299[(2)]);
var state_75299__$1 = state_75299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75299__$1,inst_75297);
} else {
if((state_val_75300 === (4))){
var inst_75289 = (state_75299[(2)]);
var state_75299__$1 = state_75299;
var statearr_75482_75569 = state_75299__$1;
(statearr_75482_75569[(2)] = inst_75289);

(statearr_75482_75569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75300 === (5))){
var ___$1 = (function (){var statearr_75483 = state_75299;
(statearr_75483[(4)] = cljs.core.rest((state_75299[(4)])));

return statearr_75483;
})();
var state_75299__$1 = state_75299;
var ex75481 = (state_75299__$1[(2)]);
var statearr_75484_75570 = state_75299__$1;
(statearr_75484_75570[(5)] = ex75481);


if((ex75481 instanceof Error)){
var statearr_75485_75571 = state_75299__$1;
(statearr_75485_75571[(1)] = (4));

(statearr_75485_75571[(5)] = null);

} else {
throw ex75481;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_75486 = [null,null,null,null,null,null,null];
(statearr_75486[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_75486[(1)] = (1));

return statearr_75486;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_75299){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75299);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75487){var ex__2730__auto__ = e75487;
var statearr_75488_75572 = state_75299;
(statearr_75488_75572[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75299[(4)]))){
var statearr_75489_75573 = state_75299;
(statearr_75489_75573[(1)] = cljs.core.first((state_75299[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75574 = state_75299;
state_75299 = G__75574;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_75299){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_75299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75490 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75490[(6)] = c__2749__auto____$2);

return statearr_75490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_75303 = cljs.core.async.impl.dispatch.run(inst_75302);
var inst_75304 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_75305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75306 = ["?auth","?id"];
var inst_75307 = (new cljs.core.PersistentVector(null,2,(5),inst_75305,inst_75306,null));
var inst_75308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75310 = [inst_75268,"_tx/auth","?auth"];
var inst_75311 = (new cljs.core.PersistentVector(null,3,(5),inst_75309,inst_75310,null));
var inst_75312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75313 = ["?auth","_auth/id","?id"];
var inst_75314 = (new cljs.core.PersistentVector(null,3,(5),inst_75312,inst_75313,null));
var inst_75315 = [inst_75311,inst_75314];
var inst_75316 = (new cljs.core.PersistentVector(null,2,(5),inst_75308,inst_75315,null));
var inst_75317 = [inst_75307,inst_75316];
var inst_75318 = cljs.core.PersistentHashMap.fromArrays(inst_75304,inst_75317);
var inst_75319 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_75301,inst_75318) : fluree.db.api.query.query_async.call(null,inst_75301,inst_75318));
var state_75334__$1 = (function (){var statearr_75491 = state_75334;
(statearr_75491[(17)] = inst_75288);

(statearr_75491[(18)] = inst_75303);

return statearr_75491;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75334__$1,(14),inst_75319);
} else {
if((state_val_75335 === (9))){
var state_75334__$1 = state_75334;
var statearr_75492_75575 = state_75334__$1;
(statearr_75492_75575[(2)] = show_auth);

(statearr_75492_75575[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (5))){
var inst_75262 = (state_75334[(8)]);
var state_75334__$1 = state_75334;
var statearr_75493_75576 = state_75334__$1;
(statearr_75493_75576[(2)] = inst_75262);

(statearr_75493_75576[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (14))){
var inst_75279 = (state_75334[(11)]);
var inst_75288 = (state_75334[(17)]);
var inst_75321 = (state_75334[(2)]);
var inst_75322 = fluree.db.util.async.throw_err(inst_75321);
var inst_75323 = cljs.core.assoc_in(inst_75279,inst_75288,inst_75322);
var state_75334__$1 = state_75334;
var statearr_75494_75577 = state_75334__$1;
(statearr_75494_75577[(2)] = inst_75323);

(statearr_75494_75577[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (10))){
var inst_75284 = (state_75334[(2)]);
var state_75334__$1 = state_75334;
if(cljs.core.truth_(inst_75284)){
var statearr_75495_75578 = state_75334__$1;
(statearr_75495_75578[(1)] = (11));

} else {
var statearr_75496_75579 = state_75334__$1;
(statearr_75496_75579[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75335 === (8))){
var inst_75280 = (state_75334[(10)]);
var state_75334__$1 = state_75334;
var statearr_75497_75580 = state_75334__$1;
(statearr_75497_75580[(2)] = inst_75280);

(statearr_75497_75580[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_75498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75498[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_75498[(1)] = (1));

return statearr_75498;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_75334){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75334);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75499){var ex__2730__auto__ = e75499;
var statearr_75500_75581 = state_75334;
(statearr_75500_75581[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75334[(4)]))){
var statearr_75501_75582 = state_75334;
(statearr_75501_75582[(1)] = cljs.core.first((state_75334[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75583 = state_75334;
state_75334 = G__75583;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_75334){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_75334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75502 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75502[(6)] = c__2749__auto____$1);

return statearr_75502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_75338 = cljs.core.async.impl.dispatch.run(inst_75337);
var state_75434__$1 = (function (){var statearr_75503 = state_75434;
(statearr_75503[(20)] = inst_75338);

return statearr_75503;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75434__$1,(6),inst_75336);
} else {
if((state_val_75435 === (23))){
var inst_75392 = (state_75434[(2)]);
var state_75434__$1 = (function (){var statearr_75504 = state_75434;
(statearr_75504[(13)] = inst_75392);

return statearr_75504;
})();
var statearr_75505_75584 = state_75434__$1;
(statearr_75505_75584[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (35))){
var inst_75422 = (state_75434[(2)]);
var state_75434__$1 = state_75434;
var statearr_75507_75585 = state_75434__$1;
(statearr_75507_75585[(2)] = inst_75422);

(statearr_75507_75585[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (19))){
var state_75434__$1 = state_75434;
var statearr_75508_75586 = state_75434__$1;
(statearr_75508_75586[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (11))){
var inst_75373 = (state_75434[(2)]);
var state_75434__$1 = state_75434;
if(cljs.core.truth_(inst_75373)){
var statearr_75511_75587 = state_75434__$1;
(statearr_75511_75587[(1)] = (15));

} else {
var statearr_75512_75588 = state_75434__$1;
(statearr_75512_75588[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (9))){
var inst_75364 = (state_75434[(16)]);
var inst_75364__$1 = auth;
var state_75434__$1 = (function (){var statearr_75513 = state_75434;
(statearr_75513[(16)] = inst_75364__$1);

return statearr_75513;
})();
if(cljs.core.truth_(inst_75364__$1)){
var statearr_75514_75589 = state_75434__$1;
(statearr_75514_75589[(1)] = (12));

} else {
var statearr_75515_75590 = state_75434__$1;
(statearr_75515_75590[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (5))){
var _ = (function (){var statearr_75516 = state_75434;
(statearr_75516[(4)] = cljs.core.rest((state_75434[(4)])));

return statearr_75516;
})();
var state_75434__$1 = state_75434;
var ex75510 = (state_75434__$1[(2)]);
var statearr_75517_75591 = state_75434__$1;
(statearr_75517_75591[(5)] = ex75510);


if((ex75510 instanceof Error)){
var statearr_75518_75592 = state_75434__$1;
(statearr_75518_75592[(1)] = (4));

(statearr_75518_75592[(5)] = null);

} else {
throw ex75510;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (14))){
var inst_75370 = (state_75434[(2)]);
var state_75434__$1 = state_75434;
var statearr_75519_75593 = state_75434__$1;
(statearr_75519_75593[(2)] = inst_75370);

(statearr_75519_75593[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (26))){
var inst_75400 = (state_75434[(2)]);
var state_75434__$1 = (function (){var statearr_75520 = state_75434;
(statearr_75520[(10)] = inst_75400);

return statearr_75520;
})();
var statearr_75521_75594 = state_75434__$1;
(statearr_75521_75594[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (16))){
var inst_75361 = (state_75434[(8)]);
var state_75434__$1 = state_75434;
if(cljs.core.truth_(inst_75361)){
var statearr_75523_75595 = state_75434__$1;
(statearr_75523_75595[(1)] = (18));

} else {
var statearr_75524_75596 = state_75434__$1;
(statearr_75524_75596[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (30))){
var inst_75408 = (state_75434[(15)]);
var inst_75382 = (state_75434[(12)]);
var inst_75383 = (state_75434[(21)]);
var inst_75410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75411 = [inst_75382,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_75412 = (new cljs.core.PersistentVector(null,2,(5),inst_75410,inst_75411,null));
var inst_75413 = cljs.core.assoc_in(inst_75408,inst_75412,inst_75383);
var state_75434__$1 = state_75434;
var statearr_75525_75597 = state_75434__$1;
(statearr_75525_75597[(2)] = inst_75413);

(statearr_75525_75597[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (10))){
var inst_75361 = (state_75434[(8)]);
var state_75434__$1 = state_75434;
var statearr_75526_75598 = state_75434__$1;
(statearr_75526_75598[(2)] = inst_75361);

(statearr_75526_75598[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (18))){
var inst_75379 = (state_75434[(11)]);
var inst_75341 = (state_75434[(19)]);
var inst_75361 = (state_75434[(8)]);
var inst_75379__$1 = fluree.db.flake.t(inst_75361);
var inst_75380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75341,inst_75379__$1);
var inst_75381 = cljs.core.__destructure_map(inst_75380);
var inst_75382 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75381,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75381,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_75434__$1 = (function (){var statearr_75527 = state_75434;
(statearr_75527[(11)] = inst_75379__$1);

(statearr_75527[(12)] = inst_75382);

(statearr_75527[(21)] = inst_75383);

return statearr_75527;
})();
var statearr_75528_75599 = state_75434__$1;
(statearr_75528_75599[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75435 === (8))){
var inst_75428 = (state_75434[(2)]);
var inst_75429 = cljs.core.vals(inst_75428);
var _ = (function (){var statearr_75530 = state_75434;
(statearr_75530[(4)] = cljs.core.rest((state_75434[(4)])));

return statearr_75530;
})();
var state_75434__$1 = state_75434;
var statearr_75531_75600 = state_75434__$1;
(statearr_75531_75600[(2)] = inst_75429);

(statearr_75531_75600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_75532 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75532[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_75532[(1)] = (1));

return statearr_75532;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_75434){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75434);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75533){var ex__2730__auto__ = e75533;
var statearr_75534_75601 = state_75434;
(statearr_75534_75601[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75434[(4)]))){
var statearr_75535_75602 = state_75434;
(statearr_75535_75602[(1)] = cljs.core.first((state_75434[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75603 = state_75434;
state_75434 = G__75603;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_75434){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_75434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75536 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75536[(6)] = c__2749__auto__);

return statearr_75536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75727){
var state_val_75728 = (state_75727[(1)]);
if((state_val_75728 === (7))){
var inst_75626 = (state_75727[(7)]);
var inst_75628 = fluree.db.api.query.resolve_block_range(inst_75626,query_map);
var state_75727__$1 = state_75727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75727__$1,(10),inst_75628);
} else {
if((state_val_75728 === (20))){
var inst_75652 = (state_75727[(2)]);
var inst_75653 = fluree.db.util.async.throw_err(inst_75652);
var inst_75654 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75653);
var inst_75655 = (inst_75654 - (1));
var state_75727__$1 = state_75727;
var statearr_75729_75792 = state_75727__$1;
(statearr_75729_75792[(2)] = inst_75655);

(statearr_75729_75792[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (27))){
var state_75727__$1 = state_75727;
var statearr_75730_75793 = state_75727__$1;
(statearr_75730_75793[(2)] = null);

(statearr_75730_75793[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (1))){
var state_75727__$1 = state_75727;
var statearr_75731_75794 = state_75727__$1;
(statearr_75731_75794[(2)] = null);

(statearr_75731_75794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (24))){
var inst_75662 = (state_75727[(2)]);
var inst_75663 = fluree.db.util.async.throw_err(inst_75662);
var inst_75664 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75663);
var state_75727__$1 = state_75727;
var statearr_75732_75795 = state_75727__$1;
(statearr_75732_75795[(2)] = inst_75664);

(statearr_75732_75795[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (39))){
var inst_75699 = (state_75727[(2)]);
var inst_75700 = fluree.db.util.async.throw_err(inst_75699);
var state_75727__$1 = state_75727;
var statearr_75733_75796 = state_75727__$1;
(statearr_75733_75796[(2)] = inst_75700);

(statearr_75733_75796[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (4))){
var inst_75604 = (state_75727[(2)]);
var state_75727__$1 = state_75727;
var statearr_75734_75797 = state_75727__$1;
(statearr_75734_75797[(2)] = inst_75604);

(statearr_75734_75797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (15))){
var inst_75635 = (state_75727[(8)]);
var state_75727__$1 = state_75727;
var statearr_75735_75798 = state_75727__$1;
(statearr_75735_75798[(2)] = inst_75635);

(statearr_75735_75798[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (21))){
var inst_75626 = (state_75727[(7)]);
var inst_75636 = (state_75727[(9)]);
var inst_75660 = fluree.db.time_travel.as_of_block(inst_75626,inst_75636);
var state_75727__$1 = state_75727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75727__$1,(24),inst_75660);
} else {
if((state_val_75728 === (31))){
var inst_75620 = (state_75727[(10)]);
var state_75727__$1 = state_75727;
var statearr_75736_75799 = state_75727__$1;
(statearr_75736_75799[(2)] = inst_75620);

(statearr_75736_75799[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (32))){
var inst_75626 = (state_75727[(7)]);
var inst_75678 = (state_75727[(11)]);
var inst_75683 = (state_75727[(12)]);
var inst_75687 = (state_75727[(2)]);
var inst_75688 = fluree.db.api.query.format_history_resp(inst_75626,inst_75678,inst_75683,inst_75687);
var state_75727__$1 = state_75727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75727__$1,(29),inst_75688);
} else {
if((state_val_75728 === (40))){
var inst_75678 = (state_75727[(11)]);
var inst_75704 = (state_75727[(13)]);
var inst_75706 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_75707 = cljs.core.count(inst_75678);
var inst_75708 = [inst_75704,inst_75707,(200)];
var inst_75709 = cljs.core.PersistentHashMap.fromArrays(inst_75706,inst_75708);
var state_75727__$1 = state_75727;
var statearr_75737_75800 = state_75727__$1;
(statearr_75737_75800[(2)] = inst_75709);

(statearr_75737_75800[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (33))){
var inst_75619 = (state_75727[(14)]);
var state_75727__$1 = state_75727;
var statearr_75738_75801 = state_75727__$1;
(statearr_75738_75801[(2)] = inst_75619);

(statearr_75738_75801[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (13))){
var inst_75722 = (state_75727[(2)]);
var _ = (function (){var statearr_75739 = state_75727;
(statearr_75739[(4)] = cljs.core.rest((state_75727[(4)])));

return statearr_75739;
})();
var state_75727__$1 = state_75727;
var statearr_75740_75802 = state_75727__$1;
(statearr_75740_75802[(2)] = inst_75722);

(statearr_75740_75802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (22))){
var inst_75626 = (state_75727[(7)]);
var inst_75666 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75626);
var state_75727__$1 = state_75727;
var statearr_75741_75803 = state_75727__$1;
(statearr_75741_75803[(2)] = inst_75666);

(statearr_75741_75803[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (36))){
var inst_75626 = (state_75727[(7)]);
var inst_75691 = (state_75727[(15)]);
var inst_75697 = fluree.db.api.query.format_blocks_resp_pretty(inst_75626,inst_75691);
var state_75727__$1 = state_75727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75727__$1,(39),inst_75697);
} else {
if((state_val_75728 === (41))){
var inst_75704 = (state_75727[(13)]);
var state_75727__$1 = state_75727;
var statearr_75742_75804 = state_75727__$1;
(statearr_75742_75804[(2)] = inst_75704);

(statearr_75742_75804[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (29))){
var inst_75619 = (state_75727[(14)]);
var inst_75690 = (state_75727[(2)]);
var inst_75691 = fluree.db.util.async.throw_err(inst_75690);
var state_75727__$1 = (function (){var statearr_75743 = state_75727;
(statearr_75743[(15)] = inst_75691);

return statearr_75743;
})();
if(cljs.core.truth_(inst_75619)){
var statearr_75744_75805 = state_75727__$1;
(statearr_75744_75805[(1)] = (33));

} else {
var statearr_75745_75806 = state_75727__$1;
(statearr_75745_75806[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (6))){
var inst_75616 = (state_75727[(16)]);
var inst_75625 = (state_75727[(2)]);
var inst_75626 = fluree.db.util.async.throw_err(inst_75625);
var state_75727__$1 = (function (){var statearr_75746 = state_75727;
(statearr_75746[(7)] = inst_75626);

return statearr_75746;
})();
if(cljs.core.truth_(inst_75616)){
var statearr_75747_75807 = state_75727__$1;
(statearr_75747_75807[(1)] = (7));

} else {
var statearr_75748_75808 = state_75727__$1;
(statearr_75748_75808[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (28))){
var inst_75621 = (state_75727[(17)]);
var inst_75683 = (state_75727[(2)]);
var state_75727__$1 = (function (){var statearr_75749 = state_75727;
(statearr_75749[(12)] = inst_75683);

return statearr_75749;
})();
if(cljs.core.truth_(inst_75621)){
var statearr_75750_75809 = state_75727__$1;
(statearr_75750_75809[(1)] = (30));

} else {
var statearr_75751_75810 = state_75727__$1;
(statearr_75751_75810[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (25))){
var inst_75622 = (state_75727[(18)]);
var inst_75677 = (state_75727[(2)]);
var inst_75678 = fluree.db.util.async.throw_err(inst_75677);
var state_75727__$1 = (function (){var statearr_75752 = state_75727;
(statearr_75752[(11)] = inst_75678);

return statearr_75752;
})();
if(cljs.core.truth_(inst_75622)){
var statearr_75753_75811 = state_75727__$1;
(statearr_75753_75811[(1)] = (26));

} else {
var statearr_75754_75812 = state_75727__$1;
(statearr_75754_75812[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (34))){
var inst_75618 = (state_75727[(19)]);
var state_75727__$1 = state_75727;
var statearr_75755_75813 = state_75727__$1;
(statearr_75755_75813[(2)] = inst_75618);

(statearr_75755_75813[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (17))){
var inst_75626 = (state_75727[(7)]);
var inst_75635 = (state_75727[(8)]);
var inst_75649 = (inst_75635 - (1));
var inst_75650 = fluree.db.time_travel.as_of_block(inst_75626,inst_75649);
var state_75727__$1 = state_75727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75727__$1,(20),inst_75650);
} else {
if((state_val_75728 === (3))){
var inst_75725 = (state_75727[(2)]);
var state_75727__$1 = state_75727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75727__$1,inst_75725);
} else {
if((state_val_75728 === (12))){
var inst_75714 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_75715 = ["History query not properly formatted. Provided ",inst_75714].join('');
var inst_75716 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75717 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75718 = cljs.core.PersistentHashMap.fromArrays(inst_75716,inst_75717);
var inst_75719 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75715,inst_75718);
var inst_75720 = (function(){throw inst_75719})();
var state_75727__$1 = state_75727;
var statearr_75756_75814 = state_75727__$1;
(statearr_75756_75814[(2)] = inst_75720);

(statearr_75756_75814[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (2))){
var _ = (function (){var statearr_75757 = state_75727;
(statearr_75757[(4)] = cljs.core.cons((5),(state_75727[(4)])));

return statearr_75757;
})();
var inst_75614 = query_map;
var inst_75615 = cljs.core.__destructure_map(inst_75614);
var inst_75616 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_75618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_75619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_75620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_75621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_75622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_75623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75615,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_75727__$1 = (function (){var statearr_75758 = state_75727;
(statearr_75758[(20)] = inst_75623);

(statearr_75758[(17)] = inst_75621);

(statearr_75758[(10)] = inst_75620);

(statearr_75758[(19)] = inst_75618);

(statearr_75758[(21)] = inst_75617);

(statearr_75758[(16)] = inst_75616);

(statearr_75758[(18)] = inst_75622);

(statearr_75758[(14)] = inst_75619);

return statearr_75758;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75727__$1,(6),sources);
} else {
if((state_val_75728 === (23))){
var inst_75626 = (state_75727[(7)]);
var inst_75617 = (state_75727[(21)]);
var inst_75658 = (state_75727[(22)]);
var inst_75668 = (state_75727[(2)]);
var inst_75669 = fluree.db.api.query.get_history_pattern(inst_75617);
var inst_75670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75669,(0),null);
var inst_75671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75669,(1),null);
var inst_75672 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_75673 = [inst_75658,inst_75668];
var inst_75674 = cljs.core.PersistentHashMap.fromArrays(inst_75672,inst_75673);
var inst_75675 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_75626,inst_75671,cljs.core._EQ_,inst_75670,inst_75674);
var state_75727__$1 = state_75727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75727__$1,(25),inst_75675);
} else {
if((state_val_75728 === (35))){
var inst_75695 = (state_75727[(2)]);
var state_75727__$1 = state_75727;
if(cljs.core.truth_(inst_75695)){
var statearr_75759_75815 = state_75727__$1;
(statearr_75759_75815[(1)] = (36));

} else {
var statearr_75760_75816 = state_75727__$1;
(statearr_75760_75816[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (19))){
var inst_75636 = (state_75727[(9)]);
var inst_75658 = (state_75727[(2)]);
var state_75727__$1 = (function (){var statearr_75761 = state_75727;
(statearr_75761[(22)] = inst_75658);

return statearr_75761;
})();
if(cljs.core.truth_(inst_75636)){
var statearr_75762_75817 = state_75727__$1;
(statearr_75762_75817[(1)] = (21));

} else {
var statearr_75763_75818 = state_75727__$1;
(statearr_75763_75818[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (11))){
var inst_75623 = (state_75727[(20)]);
var inst_75635 = (state_75727[(8)]);
var inst_75642 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_75623);
var state_75727__$1 = (function (){var statearr_75765 = state_75727;
(statearr_75765[(23)] = inst_75642);

return statearr_75765;
})();
if(cljs.core.truth_(inst_75635)){
var statearr_75766_75819 = state_75727__$1;
(statearr_75766_75819[(1)] = (14));

} else {
var statearr_75767_75820 = state_75727__$1;
(statearr_75767_75820[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (9))){
var inst_75634 = (state_75727[(2)]);
var inst_75635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75634,(0),null);
var inst_75636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75634,(1),null);
var inst_75637 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_75727__$1 = (function (){var statearr_75768 = state_75727;
(statearr_75768[(9)] = inst_75636);

(statearr_75768[(8)] = inst_75635);

return statearr_75768;
})();
if(inst_75637){
var statearr_75769_75821 = state_75727__$1;
(statearr_75769_75821[(1)] = (11));

} else {
var statearr_75770_75822 = state_75727__$1;
(statearr_75770_75822[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (5))){
var _ = (function (){var statearr_75771 = state_75727;
(statearr_75771[(4)] = cljs.core.rest((state_75727[(4)])));

return statearr_75771;
})();
var state_75727__$1 = state_75727;
var ex75764 = (state_75727__$1[(2)]);
var statearr_75772_75823 = state_75727__$1;
(statearr_75772_75823[(5)] = ex75764);


if((ex75764 instanceof Error)){
var statearr_75773_75824 = state_75727__$1;
(statearr_75773_75824[(1)] = (4));

(statearr_75773_75824[(5)] = null);

} else {
throw ex75764;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (14))){
var inst_75635 = (state_75727[(8)]);
var inst_75644 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_75635);
var state_75727__$1 = state_75727;
var statearr_75774_75825 = state_75727__$1;
(statearr_75774_75825[(2)] = inst_75644);

(statearr_75774_75825[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (26))){
var inst_75622 = (state_75727[(18)]);
var inst_75680 = cljs.core.set(inst_75622);
var state_75727__$1 = state_75727;
var statearr_75775_75826 = state_75727__$1;
(statearr_75775_75826[(2)] = inst_75680);

(statearr_75775_75826[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (16))){
var inst_75647 = (state_75727[(2)]);
var state_75727__$1 = state_75727;
if(cljs.core.truth_(inst_75647)){
var statearr_75776_75827 = state_75727__$1;
(statearr_75776_75827[(1)] = (17));

} else {
var statearr_75777_75828 = state_75727__$1;
(statearr_75777_75828[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (38))){
var inst_75642 = (state_75727[(23)]);
var inst_75704 = (state_75727[(2)]);
var state_75727__$1 = (function (){var statearr_75778 = state_75727;
(statearr_75778[(13)] = inst_75704);

return statearr_75778;
})();
if(cljs.core.truth_(inst_75642)){
var statearr_75779_75829 = state_75727__$1;
(statearr_75779_75829[(1)] = (40));

} else {
var statearr_75780_75830 = state_75727__$1;
(statearr_75780_75830[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (30))){
var inst_75621 = (state_75727[(17)]);
var state_75727__$1 = state_75727;
var statearr_75781_75831 = state_75727__$1;
(statearr_75781_75831[(2)] = inst_75621);

(statearr_75781_75831[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (10))){
var inst_75630 = (state_75727[(2)]);
var inst_75631 = fluree.db.util.async.throw_err(inst_75630);
var state_75727__$1 = state_75727;
var statearr_75782_75832 = state_75727__$1;
(statearr_75782_75832[(2)] = inst_75631);

(statearr_75782_75832[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (18))){
var state_75727__$1 = state_75727;
var statearr_75783_75833 = state_75727__$1;
(statearr_75783_75833[(2)] = (-1));

(statearr_75783_75833[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (42))){
var inst_75712 = (state_75727[(2)]);
var state_75727__$1 = state_75727;
var statearr_75784_75834 = state_75727__$1;
(statearr_75784_75834[(2)] = inst_75712);

(statearr_75784_75834[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (37))){
var inst_75691 = (state_75727[(15)]);
var inst_75702 = fluree.db.api.query.block_Flakes__GT_vector(inst_75691);
var state_75727__$1 = state_75727;
var statearr_75785_75835 = state_75727__$1;
(statearr_75785_75835[(2)] = inst_75702);

(statearr_75785_75835[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75728 === (8))){
var state_75727__$1 = state_75727;
var statearr_75786_75836 = state_75727__$1;
(statearr_75786_75836[(2)] = null);

(statearr_75786_75836[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_75787 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75787[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_75787[(1)] = (1));

return statearr_75787;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_75727){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75727);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75788){var ex__2730__auto__ = e75788;
var statearr_75789_75837 = state_75727;
(statearr_75789_75837[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75727[(4)]))){
var statearr_75790_75838 = state_75727;
(statearr_75790_75838[(1)] = cljs.core.first((state_75727[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75839 = state_75727;
state_75727 = G__75839;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_75727){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_75727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75791 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75791[(6)] = c__2749__auto__);

return statearr_75791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75972){
var state_val_75973 = (state_75972[(1)]);
if((state_val_75973 === (7))){
var inst_75869 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_75870 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_75869].join('');
var inst_75871 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75872 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75873 = cljs.core.PersistentHashMap.fromArrays(inst_75871,inst_75872);
var inst_75874 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75870,inst_75873);
var inst_75875 = (function(){throw inst_75874})();
var state_75972__$1 = state_75972;
var statearr_75974_76053 = state_75972__$1;
(statearr_75974_76053[(2)] = inst_75875);

(statearr_75974_76053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (20))){
var inst_75907 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
if(cljs.core.truth_(inst_75907)){
var statearr_75975_76054 = state_75972__$1;
(statearr_75975_76054[(1)] = (21));

} else {
var statearr_75976_76055 = state_75972__$1;
(statearr_75976_76055[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (27))){
var inst_75851 = (state_75972[(7)]);
var state_75972__$1 = state_75972;
var statearr_75977_76056 = state_75972__$1;
(statearr_75977_76056[(2)] = inst_75851);

(statearr_75977_76056[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (1))){
var state_75972__$1 = state_75972;
var statearr_75978_76057 = state_75972__$1;
(statearr_75978_76057[(2)] = null);

(statearr_75978_76057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (24))){
var inst_75913 = (state_75972[(8)]);
var state_75972__$1 = state_75972;
var statearr_75979_76058 = state_75972__$1;
(statearr_75979_76058[(2)] = inst_75913);

(statearr_75979_76058[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (39))){
var inst_75857 = (state_75972[(9)]);
var state_75972__$1 = state_75972;
if(cljs.core.truth_(inst_75857)){
var statearr_75980_76059 = state_75972__$1;
(statearr_75980_76059[(1)] = (42));

} else {
var statearr_75981_76060 = state_75972__$1;
(statearr_75981_76060[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (46))){
var inst_75945 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75946 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75947 = cljs.core.PersistentHashMap.fromArrays(inst_75945,inst_75946);
var inst_75948 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_75947);
var inst_75949 = (function(){throw inst_75948})();
var state_75972__$1 = state_75972;
var statearr_75982_76061 = state_75972__$1;
(statearr_75982_76061[(2)] = inst_75949);

(statearr_75982_76061[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (4))){
var inst_75841 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
var statearr_75983_76062 = state_75972__$1;
(statearr_75983_76062[(2)] = inst_75841);

(statearr_75983_76062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (15))){
var inst_75854 = (state_75972[(10)]);
var inst_75892 = (state_75972[(11)]);
var inst_75894 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_75892);
var inst_75895 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_75892);
var inst_75896 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_75892);
var inst_75897 = fluree.db.api.query.get_sources(inst_75894,inst_75895,inst_75896,inst_75854);
var state_75972__$1 = state_75972;
var statearr_75984_76063 = state_75972__$1;
(statearr_75984_76063[(2)] = inst_75897);

(statearr_75984_76063[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (48))){
var inst_75902 = (state_75972[(12)]);
var inst_75956 = (state_75972[(2)]);
var inst_75957 = fluree.db.util.async.throw_err(inst_75956);
var state_75972__$1 = (function (){var statearr_75985 = state_75972;
(statearr_75985[(13)] = inst_75957);

return statearr_75985;
})();
if(cljs.core.truth_(inst_75902)){
var statearr_75986_76064 = state_75972__$1;
(statearr_75986_76064[(1)] = (49));

} else {
var statearr_75987_76065 = state_75972__$1;
(statearr_75987_76065[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (50))){
var inst_75957 = (state_75972[(13)]);
var state_75972__$1 = state_75972;
var statearr_75988_76066 = state_75972__$1;
(statearr_75988_76066[(2)] = inst_75957);

(statearr_75988_76066[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (21))){
var inst_75909 = cljs.core.volatile_BANG_((0));
var state_75972__$1 = state_75972;
var statearr_75989_76067 = state_75972__$1;
(statearr_75989_76067[(2)] = inst_75909);

(statearr_75989_76067[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (31))){
var inst_75855 = (state_75972[(14)]);
var state_75972__$1 = state_75972;
if(cljs.core.truth_(inst_75855)){
var statearr_75990_76068 = state_75972__$1;
(statearr_75990_76068[(1)] = (33));

} else {
var statearr_75991_76069 = state_75972__$1;
(statearr_75991_76069[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (32))){
var inst_75932 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
var statearr_75992_76070 = state_75972__$1;
(statearr_75992_76070[(2)] = inst_75932);

(statearr_75992_76070[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (40))){
var inst_75934 = (state_75972[(15)]);
var state_75972__$1 = state_75972;
var statearr_75993_76071 = state_75972__$1;
(statearr_75993_76071[(2)] = inst_75934);

(statearr_75993_76071[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (33))){
var inst_75855 = (state_75972[(14)]);
var state_75972__$1 = state_75972;
var statearr_75994_76072 = state_75972__$1;
(statearr_75994_76072[(2)] = inst_75855);

(statearr_75994_76072[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (13))){
var inst_75852 = (state_75972[(16)]);
var inst_75881 = (state_75972[(2)]);
var inst_75882 = fluree.db.util.async.throw_err(inst_75881);
var inst_75883 = fluree.db.time_travel.as_of_block(inst_75882,inst_75852);
var state_75972__$1 = state_75972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75972__$1,(12),inst_75883);
} else {
if((state_val_75973 === (22))){
var state_75972__$1 = state_75972;
var statearr_75995_76073 = state_75972__$1;
(statearr_75995_76073[(2)] = null);

(statearr_75995_76073[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (36))){
var inst_75859 = (state_75972[(17)]);
var state_75972__$1 = state_75972;
var statearr_75996_76074 = state_75972__$1;
(statearr_75996_76074[(2)] = inst_75859);

(statearr_75996_76074[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (41))){
var inst_75942 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
if(cljs.core.truth_(inst_75942)){
var statearr_75997_76075 = state_75972__$1;
(statearr_75997_76075[(1)] = (45));

} else {
var statearr_75998_76076 = state_75972__$1;
(statearr_75998_76076[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (43))){
var inst_75853 = (state_75972[(18)]);
var state_75972__$1 = state_75972;
var statearr_75999_76077 = state_75972__$1;
(statearr_75999_76077[(2)] = inst_75853);

(statearr_75999_76077[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (29))){
var inst_75934 = (state_75972[(15)]);
var inst_75934__$1 = (state_75972[(2)]);
var state_75972__$1 = (function (){var statearr_76000 = state_75972;
(statearr_76000[(15)] = inst_75934__$1);

return statearr_76000;
})();
if(cljs.core.truth_(inst_75934__$1)){
var statearr_76001_76078 = state_75972__$1;
(statearr_76001_76078[(1)] = (39));

} else {
var statearr_76002_76079 = state_75972__$1;
(statearr_76002_76079[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (44))){
var inst_75939 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
var statearr_76003_76080 = state_75972__$1;
(statearr_76003_76080[(2)] = inst_75939);

(statearr_76003_76080[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (6))){
var state_75972__$1 = state_75972;
var statearr_76004_76081 = state_75972__$1;
(statearr_76004_76081[(2)] = null);

(statearr_76004_76081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (28))){
var inst_75856 = (state_75972[(19)]);
var state_75972__$1 = state_75972;
if(cljs.core.truth_(inst_75856)){
var statearr_76005_76082 = state_75972__$1;
(statearr_76005_76082[(1)] = (30));

} else {
var statearr_76006_76083 = state_75972__$1;
(statearr_76006_76083[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (51))){
var inst_75967 = (state_75972[(2)]);
var _ = (function (){var statearr_76007 = state_75972;
(statearr_76007[(4)] = cljs.core.rest((state_75972[(4)])));

return statearr_76007;
})();
var state_75972__$1 = state_75972;
var statearr_76008_76084 = state_75972__$1;
(statearr_76008_76084[(2)] = inst_75967);

(statearr_76008_76084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (25))){
var state_75972__$1 = state_75972;
var statearr_76009_76085 = state_75972__$1;
(statearr_76009_76085[(2)] = (1000000));

(statearr_76009_76085[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (34))){
var inst_75859 = (state_75972[(17)]);
var state_75972__$1 = state_75972;
if(cljs.core.truth_(inst_75859)){
var statearr_76010_76086 = state_75972__$1;
(statearr_76010_76086[(1)] = (36));

} else {
var statearr_76011_76087 = state_75972__$1;
(statearr_76011_76087[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (17))){
var inst_75903 = (state_75972[(20)]);
var inst_75858 = (state_75972[(21)]);
var inst_75901 = (state_75972[(2)]);
var inst_75902 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_75858);
var inst_75903__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_75858);
var state_75972__$1 = (function (){var statearr_76012 = state_75972;
(statearr_76012[(20)] = inst_75903__$1);

(statearr_76012[(12)] = inst_75902);

(statearr_76012[(22)] = inst_75901);

return statearr_76012;
})();
if(cljs.core.truth_(inst_75903__$1)){
var statearr_76013_76088 = state_75972__$1;
(statearr_76013_76088[(1)] = (18));

} else {
var statearr_76014_76089 = state_75972__$1;
(statearr_76014_76089[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (3))){
var inst_75970 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75972__$1,inst_75970);
} else {
if((state_val_75973 === (12))){
var inst_75885 = (state_75972[(2)]);
var inst_75886 = fluree.db.util.async.throw_err(inst_75885);
var state_75972__$1 = state_75972;
var statearr_76015_76090 = state_75972__$1;
(statearr_76015_76090[(2)] = inst_75886);

(statearr_76015_76090[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (2))){
var inst_75850 = (state_75972[(23)]);
var inst_75852 = (state_75972[(16)]);
var inst_75854 = (state_75972[(10)]);
var inst_75857 = (state_75972[(9)]);
var inst_75859 = (state_75972[(17)]);
var inst_75858 = (state_75972[(21)]);
var inst_75855 = (state_75972[(14)]);
var inst_75851 = (state_75972[(7)]);
var inst_75856 = (state_75972[(19)]);
var inst_75853 = (state_75972[(18)]);
var _ = (function (){var statearr_76016 = state_75972;
(statearr_76016[(4)] = cljs.core.cons((5),(state_75972[(4)])));

return statearr_76016;
})();
var inst_75848 = flureeQL;
var inst_75849 = cljs.core.__destructure_map(inst_75848);
var inst_75850__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_75851__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_75852__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75853__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_75854__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_75855__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_75856__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_75857__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_75858__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_75859__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75849,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_75860 = (function (){var construct = inst_75850__$1;
var select = inst_75851__$1;
var block = inst_75852__$1;
var where = inst_75853__$1;
var prefixes = inst_75854__$1;
var map__75847 = inst_75849;
var selectDistinct = inst_75855__$1;
var selectOne = inst_75856__$1;
var from = inst_75857__$1;
var opts = inst_75858__$1;
var selectReduced = inst_75859__$1;
return (function (p1__75840_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__75840_SHARP_);
});
})();
var inst_75861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75862 = [inst_75851__$1,inst_75856__$1,inst_75855__$1,inst_75859__$1];
var inst_75863 = (new cljs.core.PersistentVector(null,4,(5),inst_75861,inst_75862,null));
var inst_75864 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_75863);
var inst_75865 = cljs.core.count(inst_75864);
var inst_75866 = (inst_75860.cljs$core$IFn$_invoke$arity$1 ? inst_75860.cljs$core$IFn$_invoke$arity$1(inst_75865) : inst_75860.call(null,inst_75865));
var state_75972__$1 = (function (){var statearr_76017 = state_75972;
(statearr_76017[(23)] = inst_75850__$1);

(statearr_76017[(16)] = inst_75852__$1);

(statearr_76017[(10)] = inst_75854__$1);

(statearr_76017[(9)] = inst_75857__$1);

(statearr_76017[(17)] = inst_75859__$1);

(statearr_76017[(21)] = inst_75858__$1);

(statearr_76017[(14)] = inst_75855__$1);

(statearr_76017[(7)] = inst_75851__$1);

(statearr_76017[(19)] = inst_75856__$1);

(statearr_76017[(18)] = inst_75853__$1);

return statearr_76017;
})();
if(cljs.core.truth_(inst_75866)){
var statearr_76018_76091 = state_75972__$1;
(statearr_76018_76091[(1)] = (6));

} else {
var statearr_76019_76092 = state_75972__$1;
(statearr_76019_76092[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (23))){
var inst_75913 = (state_75972[(8)]);
var inst_75858 = (state_75972[(21)]);
var inst_75912 = (state_75972[(2)]);
var inst_75913__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_75858);
var state_75972__$1 = (function (){var statearr_76020 = state_75972;
(statearr_76020[(24)] = inst_75912);

(statearr_76020[(8)] = inst_75913__$1);

return statearr_76020;
})();
if(cljs.core.truth_(inst_75913__$1)){
var statearr_76021_76093 = state_75972__$1;
(statearr_76021_76093[(1)] = (24));

} else {
var statearr_76022_76094 = state_75972__$1;
(statearr_76022_76094[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (47))){
var inst_75918 = (state_75972[(25)]);
var inst_75892 = (state_75972[(11)]);
var inst_75951 = (state_75972[(2)]);
var inst_75952 = fluree.db.util.core.current_time_millis();
var inst_75953 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_75918);
var inst_75954 = fluree.db.query.fql.query(inst_75892,inst_75953);
var state_75972__$1 = (function (){var statearr_76023 = state_75972;
(statearr_76023[(26)] = inst_75951);

(statearr_76023[(27)] = inst_75952);

return statearr_76023;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75972__$1,(48),inst_75954);
} else {
if((state_val_75973 === (35))){
var inst_75930 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
var statearr_76024_76095 = state_75972__$1;
(statearr_76024_76095[(2)] = inst_75930);

(statearr_76024_76095[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (19))){
var inst_75902 = (state_75972[(12)]);
var state_75972__$1 = state_75972;
var statearr_76025_76096 = state_75972__$1;
(statearr_76025_76096[(2)] = inst_75902);

(statearr_76025_76096[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (11))){
var inst_75854 = (state_75972[(10)]);
var inst_75892 = (state_75972[(2)]);
var state_75972__$1 = (function (){var statearr_76027 = state_75972;
(statearr_76027[(11)] = inst_75892);

return statearr_76027;
})();
if(cljs.core.truth_(inst_75854)){
var statearr_76028_76097 = state_75972__$1;
(statearr_76028_76097[(1)] = (15));

} else {
var statearr_76029_76098 = state_75972__$1;
(statearr_76029_76098[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (9))){
var inst_75878 = (state_75972[(28)]);
var state_75972__$1 = state_75972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75972__$1,(13),inst_75878);
} else {
if((state_val_75973 === (5))){
var _ = (function (){var statearr_76030 = state_75972;
(statearr_76030[(4)] = cljs.core.rest((state_75972[(4)])));

return statearr_76030;
})();
var state_75972__$1 = state_75972;
var ex76026 = (state_75972__$1[(2)]);
var statearr_76031_76099 = state_75972__$1;
(statearr_76031_76099[(5)] = ex76026);


if((ex76026 instanceof Error)){
var statearr_76032_76100 = state_75972__$1;
(statearr_76032_76100[(1)] = (4));

(statearr_76032_76100[(5)] = null);

} else {
throw ex76026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (14))){
var inst_75889 = (state_75972[(2)]);
var inst_75890 = fluree.db.util.async.throw_err(inst_75889);
var state_75972__$1 = state_75972;
var statearr_76033_76101 = state_75972__$1;
(statearr_76033_76101[(2)] = inst_75890);

(statearr_76033_76101[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (45))){
var state_75972__$1 = state_75972;
var statearr_76034_76102 = state_75972__$1;
(statearr_76034_76102[(2)] = null);

(statearr_76034_76102[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (26))){
var inst_75912 = (state_75972[(24)]);
var inst_75858 = (state_75972[(21)]);
var inst_75851 = (state_75972[(7)]);
var inst_75901 = (state_75972[(22)]);
var inst_75917 = (state_75972[(2)]);
var inst_75918 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_75858,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_75901,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_75917,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75912], 0));
var state_75972__$1 = (function (){var statearr_76035 = state_75972;
(statearr_76035[(25)] = inst_75918);

return statearr_76035;
})();
if(cljs.core.truth_(inst_75851)){
var statearr_76036_76103 = state_75972__$1;
(statearr_76036_76103[(1)] = (27));

} else {
var statearr_76037_76104 = state_75972__$1;
(statearr_76037_76104[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (16))){
var inst_75899 = cljs.core.PersistentHashMap.EMPTY;
var state_75972__$1 = state_75972;
var statearr_76038_76105 = state_75972__$1;
(statearr_76038_76105[(2)] = inst_75899);

(statearr_76038_76105[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (38))){
var inst_75928 = (state_75972[(2)]);
var state_75972__$1 = state_75972;
var statearr_76039_76106 = state_75972__$1;
(statearr_76039_76106[(2)] = inst_75928);

(statearr_76039_76106[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (30))){
var inst_75856 = (state_75972[(19)]);
var state_75972__$1 = state_75972;
var statearr_76040_76107 = state_75972__$1;
(statearr_76040_76107[(2)] = inst_75856);

(statearr_76040_76107[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (10))){
var inst_75878 = (state_75972[(28)]);
var state_75972__$1 = state_75972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75972__$1,(14),inst_75878);
} else {
if((state_val_75973 === (18))){
var inst_75903 = (state_75972[(20)]);
var state_75972__$1 = state_75972;
var statearr_76041_76108 = state_75972__$1;
(statearr_76041_76108[(2)] = inst_75903);

(statearr_76041_76108[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (42))){
var inst_75857 = (state_75972[(9)]);
var state_75972__$1 = state_75972;
var statearr_76042_76109 = state_75972__$1;
(statearr_76042_76109[(2)] = inst_75857);

(statearr_76042_76109[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (37))){
var inst_75850 = (state_75972[(23)]);
var state_75972__$1 = state_75972;
var statearr_76043_76110 = state_75972__$1;
(statearr_76043_76110[(2)] = inst_75850);

(statearr_76043_76110[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (8))){
var inst_75852 = (state_75972[(16)]);
var inst_75877 = (state_75972[(2)]);
var inst_75878 = sources;
var state_75972__$1 = (function (){var statearr_76044 = state_75972;
(statearr_76044[(29)] = inst_75877);

(statearr_76044[(28)] = inst_75878);

return statearr_76044;
})();
if(cljs.core.truth_(inst_75852)){
var statearr_76045_76111 = state_75972__$1;
(statearr_76045_76111[(1)] = (9));

} else {
var statearr_76046_76112 = state_75972__$1;
(statearr_76046_76112[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75973 === (49))){
var inst_75912 = (state_75972[(24)]);
var inst_75892 = (state_75972[(11)]);
var inst_75957 = (state_75972[(13)]);
var inst_75952 = (state_75972[(27)]);
var inst_75959 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_75960 = cljs.core.deref(inst_75912);
var inst_75961 = fluree.db.util.core.response_time_formatted(inst_75952);
var inst_75962 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_75892);
var inst_75963 = [(200),inst_75957,inst_75960,inst_75961,inst_75962];
var inst_75964 = cljs.core.PersistentHashMap.fromArrays(inst_75959,inst_75963);
var state_75972__$1 = state_75972;
var statearr_76047_76113 = state_75972__$1;
(statearr_76047_76113[(2)] = inst_75964);

(statearr_76047_76113[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_76048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76048[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_76048[(1)] = (1));

return statearr_76048;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_75972){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75972);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76049){var ex__2730__auto__ = e76049;
var statearr_76050_76114 = state_75972;
(statearr_76050_76114[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75972[(4)]))){
var statearr_76051_76115 = state_75972;
(statearr_76051_76115[(1)] = cljs.core.first((state_75972[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76116 = state_75972;
state_75972 = G__76116;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_75972){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_75972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76052 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76052[(6)] = c__2749__auto__);

return statearr_76052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76257){
var state_val_76258 = (state_76257[(1)]);
if((state_val_76258 === (7))){
var inst_76252 = (state_76257[(2)]);
var _ = (function (){var statearr_76259 = state_76257;
(statearr_76259[(4)] = cljs.core.rest((state_76257[(4)])));

return statearr_76259;
})();
var state_76257__$1 = state_76257;
var statearr_76260_76336 = state_76257__$1;
(statearr_76260_76336[(2)] = inst_76252);

(statearr_76260_76336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (20))){
var inst_76224 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76261_76337 = state_76257__$1;
(statearr_76261_76337[(2)] = inst_76224);

(statearr_76261_76337[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (27))){
var inst_76204 = (state_76257[(7)]);
var state_76257__$1 = state_76257;
var statearr_76262_76338 = state_76257__$1;
(statearr_76262_76338[(2)] = inst_76204);

(statearr_76262_76338[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (1))){
var state_76257__$1 = state_76257;
var statearr_76263_76339 = state_76257__$1;
(statearr_76263_76339[(2)] = null);

(statearr_76263_76339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (24))){
var inst_76201 = (state_76257[(8)]);
var state_76257__$1 = state_76257;
var statearr_76264_76340 = state_76257__$1;
(statearr_76264_76340[(2)] = inst_76201);

(statearr_76264_76340[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (39))){
var inst_76169 = (state_76257[(9)]);
var inst_76158 = (state_76257[(10)]);
var inst_76191 = (state_76257[(11)]);
var inst_76235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76236 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_76169];
var inst_76237 = (new cljs.core.PersistentVector(null,2,(5),inst_76235,inst_76236,null));
var inst_76238 = cljs.core.assoc_in(inst_76158,inst_76237,inst_76191);
var state_76257__$1 = state_76257;
var statearr_76265_76341 = state_76257__$1;
(statearr_76265_76341[(2)] = inst_76238);

(statearr_76265_76341[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (4))){
var inst_76117 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76266_76342 = state_76257__$1;
(statearr_76266_76342[(2)] = inst_76117);

(statearr_76266_76342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (15))){
var inst_76156 = (state_76257[(12)]);
var inst_76191 = (state_76257[(11)]);
var inst_76194 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_76191);
var inst_76195 = (inst_76156 == null);
var state_76257__$1 = (function (){var statearr_76267 = state_76257;
(statearr_76267[(13)] = inst_76194);

return statearr_76267;
})();
if(cljs.core.truth_(inst_76195)){
var statearr_76268_76343 = state_76257__$1;
(statearr_76268_76343[(1)] = (18));

} else {
var statearr_76269_76344 = state_76257__$1;
(statearr_76269_76344[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (21))){
var inst_76194 = (state_76257[(13)]);
var state_76257__$1 = state_76257;
var statearr_76270_76345 = state_76257__$1;
(statearr_76270_76345[(2)] = inst_76194);

(statearr_76270_76345[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (31))){
var state_76257__$1 = state_76257;
var statearr_76271_76346 = state_76257__$1;
(statearr_76271_76346[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (32))){
var inst_76220 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76273_76347 = state_76257__$1;
(statearr_76273_76347[(2)] = inst_76220);

(statearr_76273_76347[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (40))){
var inst_76189 = (state_76257[(14)]);
var state_76257__$1 = state_76257;
if(cljs.core.truth_(inst_76189)){
var statearr_76274_76348 = state_76257__$1;
(statearr_76274_76348[(1)] = (42));

} else {
var statearr_76275_76349 = state_76257__$1;
(statearr_76275_76349[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (33))){
var inst_76194 = (state_76257[(13)]);
var inst_76156 = (state_76257[(12)]);
var inst_76215 = ((inst_76194 > inst_76156) ? inst_76194 : inst_76156);
var state_76257__$1 = state_76257;
var statearr_76276_76350 = state_76257__$1;
(statearr_76276_76350[(2)] = inst_76215);

(statearr_76276_76350[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (13))){
var inst_76180 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76277_76351 = state_76257__$1;
(statearr_76277_76351[(2)] = inst_76180);

(statearr_76277_76351[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (22))){
var inst_76194 = (state_76257[(13)]);
var inst_76201 = (state_76257[(8)]);
var inst_76201__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_76194);
var state_76257__$1 = (function (){var statearr_76278 = state_76257;
(statearr_76278[(8)] = inst_76201__$1);

return statearr_76278;
})();
if(inst_76201__$1){
var statearr_76279_76352 = state_76257__$1;
(statearr_76279_76352[(1)] = (24));

} else {
var statearr_76280_76353 = state_76257__$1;
(statearr_76280_76353[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (36))){
var inst_76157 = (state_76257[(15)]);
var inst_76191 = (state_76257[(11)]);
var inst_76229 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76191,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_76230 = (inst_76157 + inst_76229);
var state_76257__$1 = state_76257;
var statearr_76281_76354 = state_76257__$1;
(statearr_76281_76354[(2)] = inst_76230);

(statearr_76281_76354[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (41))){
var inst_76227 = (state_76257[(16)]);
var inst_76168 = (state_76257[(17)]);
var inst_76233 = (state_76257[(18)]);
var inst_76247 = (state_76257[(2)]);
var inst_76155 = inst_76168;
var inst_76156 = inst_76227;
var inst_76157 = inst_76233;
var inst_76158 = inst_76247;
var state_76257__$1 = (function (){var statearr_76282 = state_76257;
(statearr_76282[(15)] = inst_76157);

(statearr_76282[(19)] = inst_76155);

(statearr_76282[(12)] = inst_76156);

(statearr_76282[(10)] = inst_76158);

return statearr_76282;
})();
var statearr_76283_76355 = state_76257__$1;
(statearr_76283_76355[(2)] = null);

(statearr_76283_76355[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (43))){
var inst_76191 = (state_76257[(11)]);
var state_76257__$1 = state_76257;
var statearr_76284_76356 = state_76257__$1;
(statearr_76284_76356[(2)] = inst_76191);

(statearr_76284_76356[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (29))){
var inst_76209 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76285_76357 = state_76257__$1;
(statearr_76285_76357[(2)] = inst_76209);

(statearr_76285_76357[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (44))){
var inst_76169 = (state_76257[(9)]);
var inst_76158 = (state_76257[(10)]);
var inst_76244 = (state_76257[(2)]);
var inst_76245 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76158,inst_76169,inst_76244);
var state_76257__$1 = state_76257;
var statearr_76286_76358 = state_76257__$1;
(statearr_76286_76358[(2)] = inst_76245);

(statearr_76286_76358[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (6))){
var inst_76155 = (state_76257[(19)]);
var inst_76170 = (state_76257[(20)]);
var inst_76166 = cljs.core.seq(inst_76155);
var inst_76167 = cljs.core.first(inst_76166);
var inst_76168 = cljs.core.next(inst_76166);
var inst_76169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76167,(0),null);
var inst_76170__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76167,(1),null);
var inst_76171 = (inst_76170__$1 == null);
var state_76257__$1 = (function (){var statearr_76287 = state_76257;
(statearr_76287[(9)] = inst_76169);

(statearr_76287[(17)] = inst_76168);

(statearr_76287[(20)] = inst_76170__$1);

return statearr_76287;
})();
if(cljs.core.truth_(inst_76171)){
var statearr_76288_76359 = state_76257__$1;
(statearr_76288_76359[(1)] = (8));

} else {
var statearr_76289_76360 = state_76257__$1;
(statearr_76289_76360[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (28))){
var inst_76156 = (state_76257[(12)]);
var inst_76207 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_76156);
var state_76257__$1 = state_76257;
var statearr_76290_76361 = state_76257__$1;
(statearr_76290_76361[(2)] = inst_76207);

(statearr_76290_76361[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (25))){
var inst_76204 = (state_76257[(7)]);
var inst_76156 = (state_76257[(12)]);
var inst_76204__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_76156);
var state_76257__$1 = (function (){var statearr_76291 = state_76257;
(statearr_76291[(7)] = inst_76204__$1);

return statearr_76291;
})();
if(inst_76204__$1){
var statearr_76292_76362 = state_76257__$1;
(statearr_76292_76362[(1)] = (27));

} else {
var statearr_76293_76363 = state_76257__$1;
(statearr_76293_76363[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (34))){
var state_76257__$1 = state_76257;
var statearr_76294_76364 = state_76257__$1;
(statearr_76294_76364[(2)] = null);

(statearr_76294_76364[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (17))){
var inst_76188 = (state_76257[(21)]);
var inst_76227 = (state_76257[(2)]);
var state_76257__$1 = (function (){var statearr_76295 = state_76257;
(statearr_76295[(16)] = inst_76227);

return statearr_76295;
})();
if(cljs.core.truth_(inst_76188)){
var statearr_76296_76365 = state_76257__$1;
(statearr_76296_76365[(1)] = (36));

} else {
var statearr_76297_76366 = state_76257__$1;
(statearr_76297_76366[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (3))){
var inst_76255 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76257__$1,inst_76255);
} else {
if((state_val_76258 === (12))){
var inst_76158 = (state_76257[(10)]);
var state_76257__$1 = state_76257;
var statearr_76298_76367 = state_76257__$1;
(statearr_76298_76367[(2)] = inst_76158);

(statearr_76298_76367[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (2))){
var inst_76127 = (state_76257[(22)]);
var inst_76132 = (state_76257[(23)]);
var inst_76131 = (state_76257[(24)]);
var _ = (function (){var statearr_76299 = state_76257;
(statearr_76299[(4)] = cljs.core.cons((5),(state_76257[(4)])));

return statearr_76299;
})();
var inst_76123 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_76124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76125 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_76126 = (new cljs.core.PersistentVector(null,2,(5),inst_76124,inst_76125,null));
var inst_76127__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_76126);
var inst_76128 = (function (){var global_block = inst_76123;
var global_meta_QMARK_ = inst_76127__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_76129 = cljs.core.PersistentHashMap.EMPTY;
var inst_76130 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_76131__$1 = cljs.core.reduce_kv(inst_76128,inst_76129,inst_76130);
var inst_76132__$1 = fluree.db.util.core.current_time_millis();
var inst_76134 = (function (){var global_block = inst_76123;
var global_meta_QMARK_ = inst_76127__$1;
var queries = inst_76131__$1;
var start_time = inst_76132__$1;
return (function (p__76133){
var vec__76300 = p__76133;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76300,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76300,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_76135 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_76134,inst_76131__$1);
var inst_76149 = cljs.core.seq(inst_76135);
var inst_76150 = cljs.core.first(inst_76149);
var inst_76151 = cljs.core.next(inst_76149);
var inst_76152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76150,(0),null);
var inst_76153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76150,(1),null);
var inst_76154 = cljs.core.PersistentHashMap.EMPTY;
var inst_76155 = inst_76135;
var inst_76156 = null;
var inst_76157 = (0);
var inst_76158 = inst_76154;
var state_76257__$1 = (function (){var statearr_76303 = state_76257;
(statearr_76303[(25)] = inst_76152);

(statearr_76303[(15)] = inst_76157);

(statearr_76303[(26)] = inst_76151);

(statearr_76303[(27)] = inst_76153);

(statearr_76303[(22)] = inst_76127__$1);

(statearr_76303[(19)] = inst_76155);

(statearr_76303[(12)] = inst_76156);

(statearr_76303[(10)] = inst_76158);

(statearr_76303[(23)] = inst_76132__$1);

(statearr_76303[(24)] = inst_76131__$1);

return statearr_76303;
})();
var statearr_76304_76368 = state_76257__$1;
(statearr_76304_76368[(2)] = null);

(statearr_76304_76368[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (23))){
var inst_76222 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76305_76369 = state_76257__$1;
(statearr_76305_76369[(2)] = inst_76222);

(statearr_76305_76369[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (35))){
var inst_76218 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76306_76370 = state_76257__$1;
(statearr_76306_76370[(2)] = inst_76218);

(statearr_76306_76370[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (19))){
var inst_76194 = (state_76257[(13)]);
var inst_76156 = (state_76257[(12)]);
var inst_76198 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76156,inst_76194);
var state_76257__$1 = state_76257;
if(inst_76198){
var statearr_76307_76371 = state_76257__$1;
(statearr_76307_76371[(1)] = (21));

} else {
var statearr_76308_76372 = state_76257__$1;
(statearr_76308_76372[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (11))){
var inst_76157 = (state_76257[(15)]);
var inst_76156 = (state_76257[(12)]);
var inst_76158 = (state_76257[(10)]);
var inst_76132 = (state_76257[(23)]);
var inst_76174 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_76175 = fluree.db.util.core.response_time_formatted(inst_76132);
var inst_76176 = [inst_76158,inst_76157,inst_76156,inst_76175];
var inst_76177 = cljs.core.PersistentHashMap.fromArrays(inst_76174,inst_76176);
var state_76257__$1 = state_76257;
var statearr_76310_76373 = state_76257__$1;
(statearr_76310_76373[(2)] = inst_76177);

(statearr_76310_76373[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (9))){
var inst_76169 = (state_76257[(9)]);
var inst_76170 = (state_76257[(20)]);
var inst_76131 = (state_76257[(24)]);
var inst_76183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76184 = [inst_76169,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_76185 = (new cljs.core.PersistentVector(null,2,(5),inst_76183,inst_76184,null));
var inst_76186 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76131,inst_76185);
var inst_76187 = cljs.core.__destructure_map(inst_76186);
var inst_76188 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76187,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_76189 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76187,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_76257__$1 = (function (){var statearr_76311 = state_76257;
(statearr_76311[(21)] = inst_76188);

(statearr_76311[(14)] = inst_76189);

return statearr_76311;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76257__$1,(14),inst_76170);
} else {
if((state_val_76258 === (5))){
var _ = (function (){var statearr_76312 = state_76257;
(statearr_76312[(4)] = cljs.core.rest((state_76257[(4)])));

return statearr_76312;
})();
var state_76257__$1 = state_76257;
var ex76309 = (state_76257__$1[(2)]);
var statearr_76313_76374 = state_76257__$1;
(statearr_76313_76374[(5)] = ex76309);


var statearr_76314_76375 = state_76257__$1;
(statearr_76314_76375[(1)] = (4));

(statearr_76314_76375[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (14))){
var inst_76188 = (state_76257[(21)]);
var inst_76191 = (state_76257[(11)]);
var inst_76191__$1 = (state_76257[(2)]);
var inst_76192 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_76191__$1);
var state_76257__$1 = (function (){var statearr_76315 = state_76257;
(statearr_76315[(28)] = inst_76192);

(statearr_76315[(11)] = inst_76191__$1);

return statearr_76315;
})();
if(cljs.core.truth_(inst_76188)){
var statearr_76316_76376 = state_76257__$1;
(statearr_76316_76376[(1)] = (15));

} else {
var statearr_76317_76377 = state_76257__$1;
(statearr_76317_76377[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (26))){
var inst_76211 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
if(cljs.core.truth_(inst_76211)){
var statearr_76318_76378 = state_76257__$1;
(statearr_76318_76378[(1)] = (30));

} else {
var statearr_76319_76379 = state_76257__$1;
(statearr_76319_76379[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (16))){
var state_76257__$1 = state_76257;
var statearr_76320_76380 = state_76257__$1;
(statearr_76320_76380[(2)] = null);

(statearr_76320_76380[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (38))){
var inst_76192 = (state_76257[(28)]);
var inst_76233 = (state_76257[(2)]);
var state_76257__$1 = (function (){var statearr_76321 = state_76257;
(statearr_76321[(18)] = inst_76233);

return statearr_76321;
})();
if(cljs.core.truth_(inst_76192)){
var statearr_76322_76381 = state_76257__$1;
(statearr_76322_76381[(1)] = (39));

} else {
var statearr_76323_76382 = state_76257__$1;
(statearr_76323_76382[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (30))){
var state_76257__$1 = state_76257;
var statearr_76324_76383 = state_76257__$1;
(statearr_76324_76383[(2)] = (207));

(statearr_76324_76383[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (10))){
var inst_76250 = (state_76257[(2)]);
var state_76257__$1 = state_76257;
var statearr_76325_76384 = state_76257__$1;
(statearr_76325_76384[(2)] = inst_76250);

(statearr_76325_76384[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (18))){
var inst_76194 = (state_76257[(13)]);
var state_76257__$1 = state_76257;
var statearr_76326_76385 = state_76257__$1;
(statearr_76326_76385[(2)] = inst_76194);

(statearr_76326_76385[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (42))){
var inst_76191 = (state_76257[(11)]);
var inst_76241 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_76191);
var state_76257__$1 = state_76257;
var statearr_76327_76386 = state_76257__$1;
(statearr_76327_76386[(2)] = inst_76241);

(statearr_76327_76386[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (37))){
var state_76257__$1 = state_76257;
var statearr_76328_76387 = state_76257__$1;
(statearr_76328_76387[(2)] = null);

(statearr_76328_76387[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76258 === (8))){
var inst_76127 = (state_76257[(22)]);
var state_76257__$1 = state_76257;
if(cljs.core.truth_(inst_76127)){
var statearr_76329_76388 = state_76257__$1;
(statearr_76329_76388[(1)] = (11));

} else {
var statearr_76330_76389 = state_76257__$1;
(statearr_76330_76389[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_76331 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76331[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_76331[(1)] = (1));

return statearr_76331;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_76257){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76257);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76332){var ex__2730__auto__ = e76332;
var statearr_76333_76390 = state_76257;
(statearr_76333_76390[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76257[(4)]))){
var statearr_76334_76391 = state_76257;
(statearr_76334_76391[(1)] = cljs.core.first((state_76257[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76392 = state_76257;
state_76257 = G__76392;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_76257){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_76257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76335 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76335[(6)] = c__2749__auto__);

return statearr_76335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__76393 = query_type;
var G__76393__$1 = (((G__76393 instanceof cljs.core.Keyword))?G__76393.fqn:null);
switch (G__76393__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__76393__$1)].join('')));

}
});
