// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__76437_76618 = cljs.core.seq(servers);
var chunk__76438_76619 = null;
var count__76439_76620 = (0);
var i__76440_76621 = (0);
while(true){
if((i__76440_76621 < count__76439_76620)){
var server_76622 = chunk__76438_76619.cljs$core$IIndexed$_nth$arity$2(null,i__76440_76621);
var healthcheck_uri_76623 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_76622),"/fdb/health"].join('');
var resp_chan_76624 = fluree.db.util.xhttp.post_json(healthcheck_uri_76623,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___76625 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76625,healthcheck_uri_76623,resp_chan_76624,server_76622){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76625,healthcheck_uri_76623,resp_chan_76624,server_76622){
return (function (state_76510){
var state_val_76511 = (state_76510[(1)]);
if((state_val_76511 === (1))){
var state_76510__$1 = state_76510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76510__$1,(2),resp_chan_76624);
} else {
if((state_val_76511 === (2))){
var inst_76496 = (state_76510[(7)]);
var inst_76496__$1 = (state_76510[(2)]);
var inst_76497 = fluree.db.util.core.exception_QMARK_(inst_76496__$1);
var state_76510__$1 = (function (){var statearr_76512 = state_76510;
(statearr_76512[(7)] = inst_76496__$1);

return statearr_76512;
})();
if(inst_76497){
var statearr_76513_76626 = state_76510__$1;
(statearr_76513_76626[(1)] = (3));

} else {
var statearr_76514_76627 = state_76510__$1;
(statearr_76514_76627[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76511 === (3))){
var inst_76496 = (state_76510[(7)]);
var inst_76499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76500 = cljs.core.ex_message(inst_76496);
var inst_76501 = cljs.core.ex_data(inst_76496);
var inst_76502 = ["Server contact error: ",inst_76500,inst_76501];
var inst_76503 = (new cljs.core.PersistentVector(null,3,(5),inst_76499,inst_76502,null));
var inst_76504 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_76503);
var state_76510__$1 = state_76510;
var statearr_76515_76628 = state_76510__$1;
(statearr_76515_76628[(2)] = inst_76504);

(statearr_76515_76628[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76511 === (4))){
var inst_76506 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_76622);
var state_76510__$1 = state_76510;
var statearr_76516_76629 = state_76510__$1;
(statearr_76516_76629[(2)] = inst_76506);

(statearr_76516_76629[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76511 === (5))){
var inst_76508 = (state_76510[(2)]);
var state_76510__$1 = state_76510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76510__$1,inst_76508);
} else {
return null;
}
}
}
}
}
});})(seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76625,healthcheck_uri_76623,resp_chan_76624,server_76622))
;
return ((function (seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,switch__2726__auto__,c__2749__auto___76625,healthcheck_uri_76623,resp_chan_76624,server_76622){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_76517 = [null,null,null,null,null,null,null,null];
(statearr_76517[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_76517[(1)] = (1));

return statearr_76517;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_76510){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76510);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76518){var ex__2730__auto__ = e76518;
var statearr_76519_76630 = state_76510;
(statearr_76519_76630[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76510[(4)]))){
var statearr_76520_76631 = state_76510;
(statearr_76520_76631[(1)] = cljs.core.first((state_76510[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76632 = state_76510;
state_76510 = G__76632;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_76510){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_76510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,switch__2726__auto__,c__2749__auto___76625,healthcheck_uri_76623,resp_chan_76624,server_76622))
})();
var state__2751__auto__ = (function (){var statearr_76521 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76521[(6)] = c__2749__auto___76625);

return statearr_76521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76625,healthcheck_uri_76623,resp_chan_76624,server_76622))
);



var G__76633 = seq__76437_76618;
var G__76634 = chunk__76438_76619;
var G__76635 = count__76439_76620;
var G__76636 = (i__76440_76621 + (1));
seq__76437_76618 = G__76633;
chunk__76438_76619 = G__76634;
count__76439_76620 = G__76635;
i__76440_76621 = G__76636;
continue;
} else {
var temp__5804__auto___76637 = cljs.core.seq(seq__76437_76618);
if(temp__5804__auto___76637){
var seq__76437_76638__$1 = temp__5804__auto___76637;
if(cljs.core.chunked_seq_QMARK_(seq__76437_76638__$1)){
var c__5568__auto___76639 = cljs.core.chunk_first(seq__76437_76638__$1);
var G__76640 = cljs.core.chunk_rest(seq__76437_76638__$1);
var G__76641 = c__5568__auto___76639;
var G__76642 = cljs.core.count(c__5568__auto___76639);
var G__76643 = (0);
seq__76437_76618 = G__76640;
chunk__76438_76619 = G__76641;
count__76439_76620 = G__76642;
i__76440_76621 = G__76643;
continue;
} else {
var server_76644 = cljs.core.first(seq__76437_76638__$1);
var healthcheck_uri_76645 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_76644),"/fdb/health"].join('');
var resp_chan_76646 = fluree.db.util.xhttp.post_json(healthcheck_uri_76645,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___76647 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76647,healthcheck_uri_76645,resp_chan_76646,server_76644,seq__76437_76638__$1,temp__5804__auto___76637){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76647,healthcheck_uri_76645,resp_chan_76646,server_76644,seq__76437_76638__$1,temp__5804__auto___76637){
return (function (state_76537){
var state_val_76538 = (state_76537[(1)]);
if((state_val_76538 === (1))){
var state_76537__$1 = state_76537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76537__$1,(2),resp_chan_76646);
} else {
if((state_val_76538 === (2))){
var inst_76523 = (state_76537[(7)]);
var inst_76523__$1 = (state_76537[(2)]);
var inst_76524 = fluree.db.util.core.exception_QMARK_(inst_76523__$1);
var state_76537__$1 = (function (){var statearr_76539 = state_76537;
(statearr_76539[(7)] = inst_76523__$1);

return statearr_76539;
})();
if(inst_76524){
var statearr_76540_76648 = state_76537__$1;
(statearr_76540_76648[(1)] = (3));

} else {
var statearr_76541_76649 = state_76537__$1;
(statearr_76541_76649[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76538 === (3))){
var inst_76523 = (state_76537[(7)]);
var inst_76526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76527 = cljs.core.ex_message(inst_76523);
var inst_76528 = cljs.core.ex_data(inst_76523);
var inst_76529 = ["Server contact error: ",inst_76527,inst_76528];
var inst_76530 = (new cljs.core.PersistentVector(null,3,(5),inst_76526,inst_76529,null));
var inst_76531 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_76530);
var state_76537__$1 = state_76537;
var statearr_76542_76650 = state_76537__$1;
(statearr_76542_76650[(2)] = inst_76531);

(statearr_76542_76650[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76538 === (4))){
var inst_76533 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_76644);
var state_76537__$1 = state_76537;
var statearr_76543_76651 = state_76537__$1;
(statearr_76543_76651[(2)] = inst_76533);

(statearr_76543_76651[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76538 === (5))){
var inst_76535 = (state_76537[(2)]);
var state_76537__$1 = state_76537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76537__$1,inst_76535);
} else {
return null;
}
}
}
}
}
});})(seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76647,healthcheck_uri_76645,resp_chan_76646,server_76644,seq__76437_76638__$1,temp__5804__auto___76637))
;
return ((function (seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,switch__2726__auto__,c__2749__auto___76647,healthcheck_uri_76645,resp_chan_76646,server_76644,seq__76437_76638__$1,temp__5804__auto___76637){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_76544 = [null,null,null,null,null,null,null,null];
(statearr_76544[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_76544[(1)] = (1));

return statearr_76544;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_76537){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76537);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76545){var ex__2730__auto__ = e76545;
var statearr_76546_76652 = state_76537;
(statearr_76546_76652[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76537[(4)]))){
var statearr_76547_76653 = state_76537;
(statearr_76547_76653[(1)] = cljs.core.first((state_76537[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76654 = state_76537;
state_76537 = G__76654;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_76537){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_76537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,switch__2726__auto__,c__2749__auto___76647,healthcheck_uri_76645,resp_chan_76646,server_76644,seq__76437_76638__$1,temp__5804__auto___76637))
})();
var state__2751__auto__ = (function (){var statearr_76548 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76548[(6)] = c__2749__auto___76647);

return statearr_76548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__76437_76618,chunk__76438_76619,count__76439_76620,i__76440_76621,c__2749__auto___76647,healthcheck_uri_76645,resp_chan_76646,server_76644,seq__76437_76638__$1,temp__5804__auto___76637))
);



var G__76655 = cljs.core.next(seq__76437_76638__$1);
var G__76656 = null;
var G__76657 = (0);
var G__76658 = (0);
seq__76437_76618 = G__76655;
chunk__76438_76619 = G__76656;
count__76439_76620 = G__76657;
i__76440_76621 = G__76658;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76592){
var state_val_76593 = (state_76592[(1)]);
if((state_val_76593 === (7))){
var inst_76564 = (state_76592[(7)]);
var inst_76571 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76564,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_76592__$1 = state_76592;
if(inst_76571){
var statearr_76594_76659 = state_76592__$1;
(statearr_76594_76659[(1)] = (9));

} else {
var statearr_76595_76660 = state_76592__$1;
(statearr_76595_76660[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (1))){
var inst_76556 = (state_76592[(8)]);
var inst_76557 = (state_76592[(9)]);
var inst_76556__$1 = promise_chan;
var inst_76557__$1 = cljs.core.async.timeout((60000));
var inst_76558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76559 = [inst_76556__$1,inst_76557__$1];
var inst_76560 = (new cljs.core.PersistentVector(null,2,(5),inst_76558,inst_76559,null));
var state_76592__$1 = (function (){var statearr_76596 = state_76592;
(statearr_76596[(8)] = inst_76556__$1);

(statearr_76596[(9)] = inst_76557__$1);

return statearr_76596;
})();
return cljs.core.async.ioc_alts_BANG_(state_76592__$1,(2),inst_76560);
} else {
if((state_val_76593 === (4))){
var inst_76564 = (state_76592[(7)]);
var inst_76557 = (state_76592[(9)]);
var inst_76568 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76564,inst_76557);
var state_76592__$1 = state_76592;
if(inst_76568){
var statearr_76597_76661 = state_76592__$1;
(statearr_76597_76661[(1)] = (6));

} else {
var statearr_76598_76662 = state_76592__$1;
(statearr_76598_76662[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (13))){
var state_76592__$1 = state_76592;
var statearr_76599_76663 = state_76592__$1;
(statearr_76599_76663[(2)] = null);

(statearr_76599_76663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (6))){
var state_76592__$1 = state_76592;
var statearr_76600_76664 = state_76592__$1;
(statearr_76600_76664[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_76600_76664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (3))){
var state_76592__$1 = state_76592;
var statearr_76601_76665 = state_76592__$1;
(statearr_76601_76665[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_76601_76665[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (12))){
var inst_76582 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_76583 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76584 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_76585 = cljs.core.PersistentHashMap.fromArrays(inst_76583,inst_76584);
var inst_76586 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_76585);
var inst_76587 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_76586);
var state_76592__$1 = (function (){var statearr_76602 = state_76592;
(statearr_76602[(10)] = inst_76582);

return statearr_76602;
})();
var statearr_76603_76666 = state_76592__$1;
(statearr_76603_76666[(2)] = inst_76587);

(statearr_76603_76666[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (2))){
var inst_76564 = (state_76592[(7)]);
var inst_76556 = (state_76592[(8)]);
var inst_76562 = (state_76592[(2)]);
var inst_76563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76562,(0),null);
var inst_76564__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76562,(1),null);
var inst_76565 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76564__$1,inst_76556);
var state_76592__$1 = (function (){var statearr_76604 = state_76592;
(statearr_76604[(7)] = inst_76564__$1);

(statearr_76604[(11)] = inst_76563);

return statearr_76604;
})();
if(inst_76565){
var statearr_76605_76667 = state_76592__$1;
(statearr_76605_76667[(1)] = (3));

} else {
var statearr_76606_76668 = state_76592__$1;
(statearr_76606_76668[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (11))){
var inst_76575 = (state_76592[(2)]);
var state_76592__$1 = state_76592;
var statearr_76607_76669 = state_76592__$1;
(statearr_76607_76669[(2)] = inst_76575);

(statearr_76607_76669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (9))){
var inst_76563 = (state_76592[(11)]);
var state_76592__$1 = state_76592;
var statearr_76608_76670 = state_76592__$1;
(statearr_76608_76670[(2)] = inst_76563);

(statearr_76608_76670[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (5))){
var inst_76579 = (state_76592[(2)]);
var inst_76580 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_76579);
var state_76592__$1 = state_76592;
if(inst_76580){
var statearr_76609_76671 = state_76592__$1;
(statearr_76609_76671[(1)] = (12));

} else {
var statearr_76610_76672 = state_76592__$1;
(statearr_76610_76672[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (14))){
var inst_76590 = (state_76592[(2)]);
var state_76592__$1 = state_76592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76592__$1,inst_76590);
} else {
if((state_val_76593 === (10))){
var state_76592__$1 = state_76592;
var statearr_76611_76673 = state_76592__$1;
(statearr_76611_76673[(2)] = null);

(statearr_76611_76673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76593 === (8))){
var inst_76577 = (state_76592[(2)]);
var state_76592__$1 = state_76592;
var statearr_76612_76674 = state_76592__$1;
(statearr_76612_76674[(2)] = inst_76577);

(statearr_76612_76674[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_76613 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76613[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_76613[(1)] = (1));

return statearr_76613;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_76592){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76592);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76614){var ex__2730__auto__ = e76614;
var statearr_76615_76675 = state_76592;
(statearr_76615_76675[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76592[(4)]))){
var statearr_76616_76676 = state_76592;
(statearr_76616_76676[(1)] = cljs.core.first((state_76592[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76677 = state_76592;
state_76592 = G__76677;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_76592){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_76592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76617 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76617[(6)] = c__2749__auto__);

return statearr_76617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76721){
var state_val_76722 = (state_76721[(1)]);
if((state_val_76722 === (7))){
var state_76721__$1 = state_76721;
var statearr_76723_76749 = state_76721__$1;
(statearr_76723_76749[(2)] = null);

(statearr_76723_76749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (1))){
var state_76721__$1 = state_76721;
var statearr_76724_76750 = state_76721__$1;
(statearr_76724_76750[(2)] = null);

(statearr_76724_76750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (4))){
var inst_76678 = (state_76721[(2)]);
var state_76721__$1 = state_76721;
var statearr_76725_76751 = state_76721__$1;
(statearr_76725_76751[(2)] = inst_76678);

(statearr_76725_76751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (6))){
var inst_76700 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_76721__$1 = state_76721;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76721__$1,(9),inst_76700);
} else {
if((state_val_76722 === (3))){
var inst_76719 = (state_76721[(2)]);
var state_76721__$1 = state_76721;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76721__$1,inst_76719);
} else {
if((state_val_76722 === (12))){
var inst_76713 = (state_76721[(2)]);
var state_76721__$1 = state_76721;
var statearr_76726_76752 = state_76721__$1;
(statearr_76726_76752[(2)] = inst_76713);

(statearr_76726_76752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (2))){
var inst_76684 = (state_76721[(7)]);
var inst_76694 = (state_76721[(8)]);
var inst_76689 = (state_76721[(9)]);
var _ = (function (){var statearr_76727 = state_76721;
(statearr_76727[(4)] = cljs.core.cons((5),(state_76721[(4)])));

return statearr_76727;
})();
var inst_76684__$1 = cljs.core.random_uuid();
var inst_76685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76686 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_76687 = (new cljs.core.PersistentVector(null,2,(5),inst_76685,inst_76686,null));
var inst_76688 = (function (){var lock_id = inst_76684__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_76689__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_76687,inst_76688);
var inst_76690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76691 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_76692 = (new cljs.core.PersistentVector(null,3,(5),inst_76690,inst_76691,null));
var inst_76693 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76689__$1,inst_76692);
var inst_76694__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76684__$1,inst_76693);
var inst_76695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76696 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_76697 = (new cljs.core.PersistentVector(null,3,(5),inst_76695,inst_76696,null));
var inst_76698 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76689__$1,inst_76697);
var state_76721__$1 = (function (){var statearr_76728 = state_76721;
(statearr_76728[(10)] = inst_76698);

(statearr_76728[(7)] = inst_76684__$1);

(statearr_76728[(8)] = inst_76694__$1);

(statearr_76728[(9)] = inst_76689__$1);

return statearr_76728;
})();
if(inst_76694__$1){
var statearr_76729_76753 = state_76721__$1;
(statearr_76729_76753[(1)] = (6));

} else {
var statearr_76730_76754 = state_76721__$1;
(statearr_76730_76754[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (11))){
var inst_76698 = (state_76721[(10)]);
var inst_76704 = (state_76721[(11)]);
var inst_76705 = (state_76721[(12)]);
var inst_76711 = fluree.db.util.xhttp.try_socket(inst_76704,sub_chan,pub_chan,inst_76698,(60000),inst_76705);
var state_76721__$1 = state_76721;
var statearr_76732_76755 = state_76721__$1;
(statearr_76732_76755[(2)] = inst_76711);

(statearr_76732_76755[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (9))){
var inst_76698 = (state_76721[(10)]);
var inst_76684 = (state_76721[(7)]);
var inst_76704 = (state_76721[(11)]);
var inst_76702 = (state_76721[(13)]);
var inst_76694 = (state_76721[(8)]);
var inst_76689 = (state_76721[(9)]);
var inst_76702__$1 = (state_76721[(2)]);
var inst_76703 = clojure.string.replace(inst_76702__$1,"http","ws");
var inst_76704__$1 = [inst_76703,"/fdb/ws"].join('');
var inst_76705 = (function (){var lock_id = inst_76684;
var state = inst_76689;
var have_lock_QMARK_ = inst_76694;
var resp_chan = inst_76698;
var healthy_server = inst_76702__$1;
var ws_url = inst_76704__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_76706 = fluree.db.util.core.exception_QMARK_(inst_76702__$1);
var state_76721__$1 = (function (){var statearr_76733 = state_76721;
(statearr_76733[(11)] = inst_76704__$1);

(statearr_76733[(13)] = inst_76702__$1);

(statearr_76733[(12)] = inst_76705);

return statearr_76733;
})();
if(inst_76706){
var statearr_76734_76756 = state_76721__$1;
(statearr_76734_76756[(1)] = (10));

} else {
var statearr_76735_76757 = state_76721__$1;
(statearr_76735_76757[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (5))){
var _ = (function (){var statearr_76736 = state_76721;
(statearr_76736[(4)] = cljs.core.rest((state_76721[(4)])));

return statearr_76736;
})();
var state_76721__$1 = state_76721;
var ex76731 = (state_76721__$1[(2)]);
var statearr_76737_76758 = state_76721__$1;
(statearr_76737_76758[(5)] = ex76731);


if((ex76731 instanceof Error)){
var statearr_76738_76759 = state_76721__$1;
(statearr_76738_76759[(1)] = (4));

(statearr_76738_76759[(5)] = null);

} else {
throw ex76731;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (10))){
var inst_76698 = (state_76721[(10)]);
var inst_76702 = (state_76721[(13)]);
var inst_76708 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_76709 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_76698,inst_76702);
var state_76721__$1 = (function (){var statearr_76739 = state_76721;
(statearr_76739[(14)] = inst_76708);

return statearr_76739;
})();
var statearr_76740_76760 = state_76721__$1;
(statearr_76740_76760[(2)] = inst_76709);

(statearr_76740_76760[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76722 === (8))){
var inst_76698 = (state_76721[(10)]);
var inst_76716 = (state_76721[(2)]);
var _ = (function (){var statearr_76741 = state_76721;
(statearr_76741[(4)] = cljs.core.rest((state_76721[(4)])));

return statearr_76741;
})();
var state_76721__$1 = (function (){var statearr_76742 = state_76721;
(statearr_76742[(15)] = inst_76716);

return statearr_76742;
})();
var statearr_76743_76761 = state_76721__$1;
(statearr_76743_76761[(2)] = inst_76698);

(statearr_76743_76761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_76744 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76744[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_76744[(1)] = (1));

return statearr_76744;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_76721){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76721);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76745){var ex__2730__auto__ = e76745;
var statearr_76746_76762 = state_76721;
(statearr_76746_76762[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76721[(4)]))){
var statearr_76747_76763 = state_76721;
(statearr_76747_76763[(1)] = cljs.core.first((state_76721[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76764 = state_76721;
state_76721 = G__76764;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_76721){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_76721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76748 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76748[(6)] = c__2749__auto__);

return statearr_76748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k76766,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__76770 = k76766;
var G__76770__$1 = (((G__76770 instanceof cljs.core.Keyword))?G__76770.fqn:null);
switch (G__76770__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k76766,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__76771){
var vec__76772 = p__76771;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76772,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76772,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__76765){
var self__ = this;
var G__76765__$1 = this;
return (new cljs.core.RecordIter((0),G__76765__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__76775 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__76775(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this76767,other76768){
var self__ = this;
var this76767__$1 = this;
return (((!((other76768 == null)))) && ((((this76767__$1.constructor === other76768.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.id,other76768.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.servers,other76768.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.state,other76768.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.req_chan,other76768.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.sub_chan,other76768.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.pub_chan,other76768.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.group,other76768.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.storage_read,other76768.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.storage_list,other76768.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.storage_write,other76768.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.storage_exists,other76768.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.storage_rename,other76768.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.storage_delete,other76768.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.object_cache,other76768.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.async_cache,other76768.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.parallelism,other76768.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.serializer,other76768.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.default_network,other76768.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.transactor_QMARK_,other76768.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.publish,other76768.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.transact_handler,other76768.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.tx_private_key,other76768.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.tx_key_id,other76768.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.meta,other76768.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.add_listener,other76768.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.remove_listener,other76768.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.close,other76768.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76767__$1.__extmap,other76768.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__76776){
var self__ = this;
var map__76777 = p__76776;
var map__76777__$1 = cljs.core.__destructure_map(map__76777);
var node = map__76777__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76777__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76777__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76777__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__76778 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__76779 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__76780 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__76781 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__76780,G__76781) : self__.async_cache.call(null,G__76780,G__76781));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__76778,G__76779) : self__.async_cache.call(null,G__76778,G__76779));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k76766){
var self__ = this;
var this__5350__auto____$1 = this;
var G__76782 = k76766;
var G__76782__$1 = (((G__76782 instanceof cljs.core.Keyword))?G__76782.fqn:null);
switch (G__76782__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k76766);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__76765){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__76783 = cljs.core.keyword_identical_QMARK_;
var expr__76784 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__76786 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__76787 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76786,G__76787) : pred__76783.call(null,G__76786,G__76787));
})())){
return (new fluree.db.connection.Connection(G__76765,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76788 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__76789 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76788,G__76789) : pred__76783.call(null,G__76788,G__76789));
})())){
return (new fluree.db.connection.Connection(self__.id,G__76765,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76790 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__76791 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76790,G__76791) : pred__76783.call(null,G__76790,G__76791));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__76765,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76792 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__76793 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76792,G__76793) : pred__76783.call(null,G__76792,G__76793));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__76765,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76794 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__76795 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76794,G__76795) : pred__76783.call(null,G__76794,G__76795));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__76765,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76796 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__76797 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76796,G__76797) : pred__76783.call(null,G__76796,G__76797));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__76765,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76798 = new cljs.core.Keyword(null,"group","group",582596132);
var G__76799 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76798,G__76799) : pred__76783.call(null,G__76798,G__76799));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__76765,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76800 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__76801 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76800,G__76801) : pred__76783.call(null,G__76800,G__76801));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__76765,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76802 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__76803 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76802,G__76803) : pred__76783.call(null,G__76802,G__76803));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__76765,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76804 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__76805 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76804,G__76805) : pred__76783.call(null,G__76804,G__76805));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__76765,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76806 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__76807 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76806,G__76807) : pred__76783.call(null,G__76806,G__76807));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__76765,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76808 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__76809 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76808,G__76809) : pred__76783.call(null,G__76808,G__76809));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__76765,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76810 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__76811 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76810,G__76811) : pred__76783.call(null,G__76810,G__76811));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__76765,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76812 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__76813 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76812,G__76813) : pred__76783.call(null,G__76812,G__76813));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__76765,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76814 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__76815 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76814,G__76815) : pred__76783.call(null,G__76814,G__76815));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__76765,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76816 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__76817 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76816,G__76817) : pred__76783.call(null,G__76816,G__76817));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__76765,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76818 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__76819 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76818,G__76819) : pred__76783.call(null,G__76818,G__76819));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__76765,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76820 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__76821 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76820,G__76821) : pred__76783.call(null,G__76820,G__76821));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__76765,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76822 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__76823 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76822,G__76823) : pred__76783.call(null,G__76822,G__76823));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__76765,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76824 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__76825 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76824,G__76825) : pred__76783.call(null,G__76824,G__76825));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__76765,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76826 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__76827 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76826,G__76827) : pred__76783.call(null,G__76826,G__76827));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__76765,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76828 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__76829 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76828,G__76829) : pred__76783.call(null,G__76828,G__76829));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__76765,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76830 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__76831 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76830,G__76831) : pred__76783.call(null,G__76830,G__76831));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__76765,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76832 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__76833 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76832,G__76833) : pred__76783.call(null,G__76832,G__76833));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__76765,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76834 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__76835 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76834,G__76835) : pred__76783.call(null,G__76834,G__76835));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__76765,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76836 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__76837 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76836,G__76837) : pred__76783.call(null,G__76836,G__76837));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__76765,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76838 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__76839 = expr__76784;
return (pred__76783.cljs$core$IFn$_invoke$arity$2 ? pred__76783.cljs$core$IFn$_invoke$arity$2(G__76838,G__76839) : pred__76783.call(null,G__76838,G__76839));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__76765,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__76765),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__76765){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__76765,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__76769){
var extmap__5385__auto__ = (function (){var G__76840 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__76769,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__76769)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__76840);
} else {
return G__76840;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__76769),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__76769),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__76846 = servers_STAR_;
var vec__76847 = G__76846;
var seq__76848 = cljs.core.seq(vec__76847);
var first__76849 = cljs.core.first(seq__76848);
var seq__76848__$1 = cljs.core.next(seq__76848);
var server = first__76849;
var r = seq__76848__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__76846__$1 = G__76846;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__76853 = G__76846__$1;
var seq__76854 = cljs.core.seq(vec__76853);
var first__76855 = cljs.core.first(seq__76854);
var seq__76854__$1 = cljs.core.next(seq__76854);
var server__$1 = first__76855;
var r__$1 = seq__76854__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__76856 = r__$1;
var G__76857 = is_https_QMARK_;
var G__76858 = result_STAR_;
G__76846__$1 = G__76856;
https_QMARK___$1 = G__76857;
result__$1 = G__76858;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__76859 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__76859 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__76859);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76888){
var state_val_76889 = (state_76888[(1)]);
if((state_val_76889 === (7))){
var inst_76874 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76875 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76876 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76877 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76878 = fluree.db.connection.establish_socket(inst_76874,inst_76875,inst_76876,inst_76877);
var state_76888__$1 = state_76888;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76888__$1,(9),inst_76878);
} else {
if((state_val_76889 === (1))){
var state_76888__$1 = state_76888;
var statearr_76890_76909 = state_76888__$1;
(statearr_76890_76909[(2)] = null);

(statearr_76890_76909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76889 === (4))){
var inst_76860 = (state_76888[(2)]);
var state_76888__$1 = state_76888;
var statearr_76891_76910 = state_76888__$1;
(statearr_76891_76910[(2)] = inst_76860);

(statearr_76891_76910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76889 === (6))){
var inst_76871 = (state_76888[(7)]);
var state_76888__$1 = state_76888;
var statearr_76892_76911 = state_76888__$1;
(statearr_76892_76911[(2)] = inst_76871);

(statearr_76892_76911[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76889 === (3))){
var inst_76886 = (state_76888[(2)]);
var state_76888__$1 = state_76888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76888__$1,inst_76886);
} else {
if((state_val_76889 === (2))){
var inst_76871 = (state_76888[(7)]);
var _ = (function (){var statearr_76894 = state_76888;
(statearr_76894[(4)] = cljs.core.cons((5),(state_76888[(4)])));

return statearr_76894;
})();
var inst_76866 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_76867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76868 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_76869 = [inst_76868,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_76870 = (new cljs.core.PersistentVector(null,3,(5),inst_76867,inst_76869,null));
var inst_76871__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76866,inst_76870);
var state_76888__$1 = (function (){var statearr_76895 = state_76888;
(statearr_76895[(7)] = inst_76871__$1);

return statearr_76895;
})();
if(cljs.core.truth_(inst_76871__$1)){
var statearr_76896_76912 = state_76888__$1;
(statearr_76896_76912[(1)] = (6));

} else {
var statearr_76897_76913 = state_76888__$1;
(statearr_76897_76913[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76889 === (9))){
var inst_76880 = (state_76888[(2)]);
var inst_76881 = fluree.db.util.async.throw_err(inst_76880);
var state_76888__$1 = state_76888;
var statearr_76898_76914 = state_76888__$1;
(statearr_76898_76914[(2)] = inst_76881);

(statearr_76898_76914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76889 === (5))){
var _ = (function (){var statearr_76899 = state_76888;
(statearr_76899[(4)] = cljs.core.rest((state_76888[(4)])));

return statearr_76899;
})();
var state_76888__$1 = state_76888;
var ex76893 = (state_76888__$1[(2)]);
var statearr_76900_76915 = state_76888__$1;
(statearr_76900_76915[(5)] = ex76893);


if((ex76893 instanceof Error)){
var statearr_76901_76916 = state_76888__$1;
(statearr_76901_76916[(1)] = (4));

(statearr_76901_76916[(5)] = null);

} else {
throw ex76893;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76889 === (8))){
var inst_76883 = (state_76888[(2)]);
var _ = (function (){var statearr_76902 = state_76888;
(statearr_76902[(4)] = cljs.core.rest((state_76888[(4)])));

return statearr_76902;
})();
var state_76888__$1 = state_76888;
var statearr_76903_76917 = state_76888__$1;
(statearr_76903_76917[(2)] = inst_76883);

(statearr_76903_76917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_76904 = [null,null,null,null,null,null,null,null];
(statearr_76904[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_76904[(1)] = (1));

return statearr_76904;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_76888){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76888);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76905){var ex__2730__auto__ = e76905;
var statearr_76906_76918 = state_76888;
(statearr_76906_76918[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76888[(4)]))){
var statearr_76907_76919 = state_76888;
(statearr_76907_76919[(1)] = cljs.core.first((state_76888[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76920 = state_76888;
state_76888 = G__76920;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_76888){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_76888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76908 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76908[(6)] = c__2749__auto__);

return statearr_76908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e76921){var e = e76921;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__76923){
var map__76924 = p__76923;
var map__76924__$1 = cljs.core.__destructure_map(map__76924);
var conn = map__76924__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76924__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76924__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76924__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77070){
var state_val_77071 = (state_77070[(1)]);
if((state_val_77071 === (7))){
var inst_77066 = (state_77070[(2)]);
var state_77070__$1 = state_77070;
var statearr_77073_77147 = state_77070__$1;
(statearr_77073_77147[(2)] = inst_77066);

(statearr_77073_77147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (20))){
var _ = (function (){var statearr_77074 = state_77070;
(statearr_77074[(4)] = cljs.core.rest((state_77070[(4)])));

return statearr_77074;
})();
var state_77070__$1 = state_77070;
var ex77072 = (state_77070__$1[(2)]);
var statearr_77075_77148 = state_77070__$1;
(statearr_77075_77148[(5)] = ex77072);


var statearr_77076_77149 = state_77070__$1;
(statearr_77076_77149[(1)] = (10));

(statearr_77076_77149[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (27))){
var inst_77027 = (state_77070[(7)]);
var inst_77027__$1 = (state_77070[(2)]);
var inst_77028 = inst_77027__$1 === true;
var state_77070__$1 = (function (){var statearr_77077 = state_77070;
(statearr_77077[(7)] = inst_77027__$1);

return statearr_77077;
})();
if(cljs.core.truth_(inst_77028)){
var statearr_77078_77150 = state_77070__$1;
(statearr_77078_77150[(1)] = (28));

} else {
var statearr_77079_77151 = state_77070__$1;
(statearr_77079_77151[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (1))){
var inst_76925 = (0);
var state_77070__$1 = (function (){var statearr_77080 = state_77070;
(statearr_77080[(8)] = inst_76925);

return statearr_77080;
})();
var statearr_77081_77152 = state_77070__$1;
(statearr_77081_77152[(2)] = null);

(statearr_77081_77152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (24))){
var inst_77017 = (state_77070[(9)]);
var state_77070__$1 = state_77070;
var statearr_77082_77153 = state_77070__$1;
(statearr_77082_77153[(2)] = inst_77017);

(statearr_77082_77153[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (39))){
var inst_77052 = (state_77070[(2)]);
var state_77070__$1 = state_77070;
var statearr_77083_77154 = state_77070__$1;
(statearr_77083_77154[(2)] = inst_77052);

(statearr_77083_77154[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (4))){
var inst_76928 = (state_77070[(10)]);
var inst_76928__$1 = (state_77070[(2)]);
var state_77070__$1 = (function (){var statearr_77084 = state_77070;
(statearr_77084[(10)] = inst_76928__$1);

return statearr_77084;
})();
if(cljs.core.truth_(inst_76928__$1)){
var statearr_77085_77155 = state_77070__$1;
(statearr_77085_77155[(1)] = (5));

} else {
var statearr_77086_77156 = state_77070__$1;
(statearr_77086_77156[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (15))){
var inst_76941 = (state_77070[(11)]);
var state_77070__$1 = state_77070;
var statearr_77087_77157 = state_77070__$1;
(statearr_77087_77157[(2)] = inst_76941);

(statearr_77087_77157[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (21))){
var inst_76925 = (state_77070[(8)]);
var inst_76975 = (state_77070[(12)]);
var inst_76979 = (state_77070[(13)]);
var inst_76970 = (state_77070[(14)]);
var inst_76971 = (state_77070[(15)]);
var inst_76972 = (state_77070[(16)]);
var inst_76978 = (state_77070[(17)]);
var inst_76973 = (state_77070[(18)]);
var inst_76928 = (state_77070[(10)]);
var inst_76974 = (state_77070[(19)]);
var inst_76981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76982 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_76978];
var inst_76983 = (new cljs.core.PersistentVector(null,2,(5),inst_76981,inst_76982,null));
var inst_76984 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_76983,inst_76973);
var inst_77011 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_77012 = (function (){var resp_chan = inst_76973;
var timeout = inst_76979;
var c__2749__auto____$1 = inst_77011;
var i = inst_76925;
var data = inst_76972;
var _ = inst_76970;
var req_id = inst_76978;
var operation = inst_76971;
var msg = inst_76928;
var temp__5804__auto__ = inst_76928;
var vec__76963 = inst_76928;
var opts = inst_76974;
var map__76966 = inst_76975;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77009){
var state_val_77010 = (state_77009[(1)]);
if((state_val_77010 === (1))){
var inst_76988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76989 = cljs.core.async.timeout(timeout);
var inst_76990 = [resp_chan,inst_76989];
var inst_76991 = (new cljs.core.PersistentVector(null,2,(5),inst_76988,inst_76990,null));
var state_77009__$1 = state_77009;
return cljs.core.async.ioc_alts_BANG_(state_77009__$1,(2),inst_76991);
} else {
if((state_val_77010 === (2))){
var inst_76994 = (state_77009[(7)]);
var inst_76993 = (state_77009[(2)]);
var inst_76994__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76993,(0),null);
var inst_76995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76993,(1),null);
var inst_76996 = (function (){var vec__76985 = inst_76993;
var resp = inst_76994__$1;
var c = inst_76995;
return (function (p1__76922_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__76922_SHARP_,req_id);
});
})();
var inst_76997 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_76996);
var inst_76998 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76995,resp_chan);
var state_77009__$1 = (function (){var statearr_77088 = state_77009;
(statearr_77088[(7)] = inst_76994__$1);

(statearr_77088[(8)] = inst_76997);

return statearr_77088;
})();
if(inst_76998){
var statearr_77089_77158 = state_77009__$1;
(statearr_77089_77158[(1)] = (3));

} else {
var statearr_77090_77159 = state_77009__$1;
(statearr_77090_77159[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77010 === (3))){
var inst_76994 = (state_77009[(7)]);
var state_77009__$1 = state_77009;
var statearr_77091_77160 = state_77009__$1;
(statearr_77091_77160[(2)] = inst_76994);

(statearr_77091_77160[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77010 === (4))){
var inst_77001 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_77002 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77003 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_77004 = cljs.core.PersistentHashMap.fromArrays(inst_77002,inst_77003);
var inst_77005 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_77001,inst_77004);
var state_77009__$1 = state_77009;
var statearr_77092_77161 = state_77009__$1;
(statearr_77092_77161[(2)] = inst_77005);

(statearr_77092_77161[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77010 === (5))){
var inst_77007 = (state_77009[(2)]);
var state_77009__$1 = state_77009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77009__$1,inst_77007);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_77093 = [null,null,null,null,null,null,null,null,null];
(statearr_77093[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_77093[(1)] = (1));

return statearr_77093;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_77009){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77009);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77094){var ex__2730__auto__ = e77094;
var statearr_77095_77162 = state_77009;
(statearr_77095_77162[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77009[(4)]))){
var statearr_77096_77163 = state_77009;
(statearr_77096_77163[(1)] = cljs.core.first((state_77009[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77164 = state_77009;
state_77009 = G__77164;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_77009){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_77009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77097 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77097[(6)] = c__2749__auto____$1);

return statearr_77097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_77013 = cljs.core.async.impl.dispatch.run(inst_77012);
var state_77070__$1 = (function (){var statearr_77098 = state_77070;
(statearr_77098[(20)] = inst_77013);

(statearr_77098[(21)] = inst_76984);

return statearr_77098;
})();
var statearr_77099_77165 = state_77070__$1;
(statearr_77099_77165[(2)] = inst_77011);

(statearr_77099_77165[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (31))){
var inst_77027 = (state_77070[(7)]);
var inst_77033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77034 = [inst_77027,"Error processing message in producer."];
var inst_77035 = (new cljs.core.PersistentVector(null,2,(5),inst_77033,inst_77034,null));
var inst_77036 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77035);
var state_77070__$1 = state_77070;
var statearr_77100_77166 = state_77070__$1;
(statearr_77100_77166[(2)] = inst_77036);

(statearr_77100_77166[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (32))){
var inst_77027 = (state_77070[(7)]);
var inst_77038 = (inst_77027 == null);
var state_77070__$1 = state_77070;
if(cljs.core.truth_(inst_77038)){
var statearr_77101_77167 = state_77070__$1;
(statearr_77101_77167[(1)] = (34));

} else {
var statearr_77102_77168 = state_77070__$1;
(statearr_77102_77168[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (33))){
var inst_77056 = (state_77070[(2)]);
var state_77070__$1 = state_77070;
var statearr_77103_77169 = state_77070__$1;
(statearr_77103_77169[(2)] = inst_77056);

(statearr_77103_77169[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (13))){
var inst_76941 = (state_77070[(11)]);
var inst_76938 = (state_77070[(2)]);
var inst_76939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76938,(0),null);
var inst_76940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76938,(1),null);
var inst_76941__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76938,(2),null);
var state_77070__$1 = (function (){var statearr_77104 = state_77070;
(statearr_77104[(22)] = inst_76940);

(statearr_77104[(23)] = inst_76939);

(statearr_77104[(11)] = inst_76941__$1);

return statearr_77104;
})();
if(cljs.core.truth_(inst_76941__$1)){
var statearr_77105_77170 = state_77070__$1;
(statearr_77105_77170[(1)] = (14));

} else {
var statearr_77106_77171 = state_77070__$1;
(statearr_77106_77171[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (22))){
var state_77070__$1 = state_77070;
var statearr_77107_77172 = state_77070__$1;
(statearr_77107_77172[(2)] = null);

(statearr_77107_77172[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (36))){
var inst_77054 = (state_77070[(2)]);
var state_77070__$1 = state_77070;
var statearr_77108_77173 = state_77070__$1;
(statearr_77108_77173[(2)] = inst_77054);

(statearr_77108_77173[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (29))){
var inst_77027 = (state_77070[(7)]);
var inst_77031 = fluree.db.util.core.exception_QMARK_(inst_77027);
var state_77070__$1 = state_77070;
if(inst_77031){
var statearr_77109_77174 = state_77070__$1;
(statearr_77109_77174[(1)] = (31));

} else {
var statearr_77110_77175 = state_77070__$1;
(statearr_77110_77175[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (6))){
var state_77070__$1 = state_77070;
var statearr_77111_77176 = state_77070__$1;
(statearr_77111_77176[(2)] = null);

(statearr_77111_77176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (28))){
var state_77070__$1 = state_77070;
var statearr_77112_77177 = state_77070__$1;
(statearr_77112_77177[(2)] = null);

(statearr_77112_77177[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (25))){
var state_77070__$1 = state_77070;
var statearr_77113_77178 = state_77070__$1;
(statearr_77113_77178[(2)] = fluree.db.connection.default_publish_fn);

(statearr_77113_77178[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (34))){
var inst_77040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77041 = ["Error processing message in producer. Socket closed."];
var inst_77042 = (new cljs.core.PersistentVector(null,1,(5),inst_77040,inst_77041,null));
var inst_77043 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77042);
var state_77070__$1 = state_77070;
var statearr_77114_77179 = state_77070__$1;
(statearr_77114_77179[(2)] = inst_77043);

(statearr_77114_77179[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (17))){
var inst_76941 = (state_77070[(11)]);
var inst_76930 = (state_77070[(24)]);
var inst_76948 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_76941,inst_76930);
var state_77070__$1 = state_77070;
var statearr_77115_77180 = state_77070__$1;
(statearr_77115_77180[(2)] = inst_76948);

(statearr_77115_77180[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (3))){
var inst_77068 = (state_77070[(2)]);
var state_77070__$1 = state_77070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77070__$1,inst_77068);
} else {
if((state_val_77071 === (12))){
var state_77070__$1 = state_77070;
var statearr_77116_77181 = state_77070__$1;
(statearr_77116_77181[(2)] = null);

(statearr_77116_77181[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (2))){
var state_77070__$1 = state_77070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77070__$1,(4),req_chan);
} else {
if((state_val_77071 === (23))){
var inst_77017 = (state_77070[(9)]);
var inst_77016 = (state_77070[(2)]);
var inst_77017__$1 = publish;
var state_77070__$1 = (function (){var statearr_77117 = state_77070;
(statearr_77117[(9)] = inst_77017__$1);

(statearr_77117[(25)] = inst_77016);

return statearr_77117;
})();
if(cljs.core.truth_(inst_77017__$1)){
var statearr_77118_77182 = state_77070__$1;
(statearr_77118_77182[(1)] = (24));

} else {
var statearr_77119_77183 = state_77070__$1;
(statearr_77119_77183[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (35))){
var state_77070__$1 = state_77070;
var statearr_77120_77184 = state_77070__$1;
(statearr_77120_77184[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (19))){
var inst_76957 = (state_77070[(2)]);
var state_77070__$1 = state_77070;
var statearr_77122_77185 = state_77070__$1;
(statearr_77122_77185[(2)] = inst_76957);

(statearr_77122_77185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (11))){
var inst_76928 = (state_77070[(10)]);
var state_77070__$1 = state_77070;
var statearr_77123_77186 = state_77070__$1;
(statearr_77123_77186[(2)] = inst_76928);

(statearr_77123_77186[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (9))){
var inst_76925 = (state_77070[(8)]);
var inst_77061 = (state_77070[(2)]);
var inst_77062 = (inst_76925 + (1));
var inst_76925__$1 = inst_77062;
var state_77070__$1 = (function (){var statearr_77124 = state_77070;
(statearr_77124[(8)] = inst_76925__$1);

(statearr_77124[(26)] = inst_77061);

return statearr_77124;
})();
var statearr_77125_77187 = state_77070__$1;
(statearr_77125_77187[(2)] = null);

(statearr_77125_77187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (5))){
var state_77070__$1 = state_77070;
var statearr_77126_77188 = state_77070__$1;
(statearr_77126_77188[(2)] = null);

(statearr_77126_77188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (14))){
var inst_76941 = (state_77070[(11)]);
var inst_76943 = fluree.db.util.async.channel_QMARK_(inst_76941);
var state_77070__$1 = state_77070;
var statearr_77127_77189 = state_77070__$1;
(statearr_77127_77189[(2)] = inst_76943);

(statearr_77127_77189[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (26))){
var inst_76971 = (state_77070[(15)]);
var inst_76972 = (state_77070[(16)]);
var inst_76978 = (state_77070[(17)]);
var inst_77021 = (state_77070[(2)]);
var inst_77022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77023 = [inst_76971,inst_76978,inst_76972];
var inst_77024 = (new cljs.core.PersistentVector(null,3,(5),inst_77022,inst_77023,null));
var inst_77025 = (inst_77021.cljs$core$IFn$_invoke$arity$2 ? inst_77021.cljs$core$IFn$_invoke$arity$2(conn,inst_77024) : inst_77021.call(null,conn,inst_77024));
var state_77070__$1 = state_77070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77070__$1,(27),inst_77025);
} else {
if((state_val_77071 === (16))){
var inst_76946 = (state_77070[(2)]);
var state_77070__$1 = state_77070;
if(cljs.core.truth_(inst_76946)){
var statearr_77128_77190 = state_77070__$1;
(statearr_77128_77190[(1)] = (17));

} else {
var statearr_77129_77191 = state_77070__$1;
(statearr_77129_77191[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (38))){
var state_77070__$1 = state_77070;
var statearr_77130_77192 = state_77070__$1;
(statearr_77130_77192[(2)] = null);

(statearr_77130_77192[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (30))){
var inst_77058 = (state_77070[(2)]);
var _ = (function (){var statearr_77131 = state_77070;
(statearr_77131[(4)] = cljs.core.rest((state_77070[(4)])));

return statearr_77131;
})();
var state_77070__$1 = state_77070;
var statearr_77132_77193 = state_77070__$1;
(statearr_77132_77193[(2)] = inst_77058);

(statearr_77132_77193[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (10))){
var inst_76928 = (state_77070[(10)]);
var inst_76930 = (state_77070[(2)]);
var inst_76934 = cljs.core.sequential_QMARK_(inst_76928);
var state_77070__$1 = (function (){var statearr_77133 = state_77070;
(statearr_77133[(24)] = inst_76930);

return statearr_77133;
})();
if(inst_76934){
var statearr_77134_77194 = state_77070__$1;
(statearr_77134_77194[(1)] = (11));

} else {
var statearr_77135_77195 = state_77070__$1;
(statearr_77135_77195[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (18))){
var inst_76928 = (state_77070[(10)]);
var inst_76930 = (state_77070[(24)]);
var inst_76950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76951 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76928], 0));
var inst_76952 = ["Error processing ledger request, no valid return channel: ",inst_76951].join('');
var inst_76953 = [inst_76930,inst_76952];
var inst_76954 = (new cljs.core.PersistentVector(null,2,(5),inst_76950,inst_76953,null));
var inst_76955 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76954);
var state_77070__$1 = state_77070;
var statearr_77136_77196 = state_77070__$1;
(statearr_77136_77196[(2)] = inst_76955);

(statearr_77136_77196[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (37))){
var inst_77027 = (state_77070[(7)]);
var inst_77046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77047 = ["Error processing message in producer. Socket closed. Published result",inst_77027];
var inst_77048 = (new cljs.core.PersistentVector(null,2,(5),inst_77046,inst_77047,null));
var inst_77049 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77048);
var state_77070__$1 = state_77070;
var statearr_77137_77197 = state_77070__$1;
(statearr_77137_77197[(2)] = inst_77049);

(statearr_77137_77197[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77071 === (8))){
var inst_76975 = (state_77070[(12)]);
var inst_76973 = (state_77070[(18)]);
var inst_76928 = (state_77070[(10)]);
var inst_76974 = (state_77070[(19)]);
var _ = (function (){var statearr_77138 = state_77070;
(statearr_77138[(4)] = cljs.core.cons((20),(state_77070[(4)])));

return statearr_77138;
})();
var inst_76967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76968 = ["Outgoing message to websocket: ",inst_76928];
var inst_76969 = (new cljs.core.PersistentVector(null,2,(5),inst_76967,inst_76968,null));
var inst_76970 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_76969);
var inst_76971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76928,(0),null);
var inst_76972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76928,(1),null);
var inst_76973__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76928,(2),null);
var inst_76974__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76928,(3),null);
var inst_76975__$1 = cljs.core.__destructure_map(inst_76974__$1);
var inst_76976 = cljs.core.random_uuid();
var inst_76977 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76976);
var inst_76978 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76975__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_76977);
var inst_76979 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76975__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_77070__$1 = (function (){var statearr_77139 = state_77070;
(statearr_77139[(12)] = inst_76975__$1);

(statearr_77139[(13)] = inst_76979);

(statearr_77139[(14)] = inst_76970);

(statearr_77139[(15)] = inst_76971);

(statearr_77139[(16)] = inst_76972);

(statearr_77139[(17)] = inst_76978);

(statearr_77139[(18)] = inst_76973__$1);

(statearr_77139[(19)] = inst_76974__$1);

return statearr_77139;
})();
if(cljs.core.truth_(inst_76973__$1)){
var statearr_77140_77198 = state_77070__$1;
(statearr_77140_77198[(1)] = (21));

} else {
var statearr_77141_77199 = state_77070__$1;
(statearr_77141_77199[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_77142 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77142[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_77142[(1)] = (1));

return statearr_77142;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_77070){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77070);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77143){var ex__2730__auto__ = e77143;
var statearr_77144_77200 = state_77070;
(statearr_77144_77200[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77070[(4)]))){
var statearr_77145_77201 = state_77070;
(statearr_77145_77201[(1)] = cljs.core.first((state_77070[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77202 = state_77070;
state_77070 = G__77202;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_77070){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_77070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77146 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77146[(6)] = c__2749__auto__);

return statearr_77146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77240){
var state_val_77241 = (state_77240[(1)]);
if((state_val_77241 === (7))){
var inst_77211 = (state_77240[(7)]);
var state_77240__$1 = state_77240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77240__$1,(9),inst_77211);
} else {
if((state_val_77241 === (1))){
var inst_77203 = (1);
var state_77240__$1 = (function (){var statearr_77242 = state_77240;
(statearr_77242[(8)] = inst_77203);

return statearr_77242;
})();
var statearr_77243_77266 = state_77240__$1;
(statearr_77243_77266[(2)] = null);

(statearr_77243_77266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (4))){
var inst_77208 = (state_77240[(2)]);
var inst_77209 = fluree.db.connection.get_socket(conn);
var state_77240__$1 = (function (){var statearr_77244 = state_77240;
(statearr_77244[(9)] = inst_77208);

return statearr_77244;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77240__$1,(5),inst_77209);
} else {
if((state_val_77241 === (15))){
var inst_77236 = (state_77240[(2)]);
var state_77240__$1 = state_77240;
var statearr_77245_77267 = state_77240__$1;
(statearr_77245_77267[(2)] = inst_77236);

(statearr_77245_77267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (13))){
var inst_77203 = (state_77240[(8)]);
var inst_77218 = (state_77240[(10)]);
var inst_77226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77227 = [inst_77218,"Cannot establish connection to a healthy server, backing off:",inst_77203,"s."];
var inst_77228 = (new cljs.core.PersistentVector(null,4,(5),inst_77226,inst_77227,null));
var inst_77229 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77228);
var inst_77230 = ((2) * inst_77203);
var inst_77231 = ((60) * (2));
var inst_77232 = ((inst_77230 < inst_77231) ? inst_77230 : inst_77231);
var inst_77203__$1 = inst_77232;
var state_77240__$1 = (function (){var statearr_77246 = state_77240;
(statearr_77246[(8)] = inst_77203__$1);

(statearr_77246[(11)] = inst_77229);

return statearr_77246;
})();
var statearr_77247_77268 = state_77240__$1;
(statearr_77247_77268[(2)] = null);

(statearr_77247_77268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (6))){
var inst_77211 = (state_77240[(7)]);
var state_77240__$1 = state_77240;
var statearr_77248_77269 = state_77240__$1;
(statearr_77248_77269[(2)] = inst_77211);

(statearr_77248_77269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (3))){
var inst_77238 = (state_77240[(2)]);
var state_77240__$1 = state_77240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77240__$1,inst_77238);
} else {
if((state_val_77241 === (12))){
var inst_77224 = (state_77240[(2)]);
var state_77240__$1 = state_77240;
if(cljs.core.truth_(inst_77224)){
var statearr_77249_77270 = state_77240__$1;
(statearr_77249_77270[(1)] = (13));

} else {
var statearr_77250_77271 = state_77240__$1;
(statearr_77250_77271[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (2))){
var inst_77203 = (state_77240[(8)]);
var inst_77205 = (inst_77203 * (1000));
var inst_77206 = cljs.core.async.timeout(inst_77205);
var state_77240__$1 = state_77240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77240__$1,(4),inst_77206);
} else {
if((state_val_77241 === (11))){
var inst_77218 = (state_77240[(10)]);
var inst_77222 = fluree.db.util.core.exception_QMARK_(inst_77218);
var state_77240__$1 = state_77240;
var statearr_77251_77272 = state_77240__$1;
(statearr_77251_77272[(2)] = inst_77222);

(statearr_77251_77272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (9))){
var inst_77216 = (state_77240[(2)]);
var state_77240__$1 = state_77240;
var statearr_77252_77273 = state_77240__$1;
(statearr_77252_77273[(2)] = inst_77216);

(statearr_77252_77273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (5))){
var inst_77211 = (state_77240[(7)]);
var inst_77211__$1 = (state_77240[(2)]);
var inst_77212 = fluree.db.util.core.exception_QMARK_(inst_77211__$1);
var state_77240__$1 = (function (){var statearr_77253 = state_77240;
(statearr_77253[(7)] = inst_77211__$1);

return statearr_77253;
})();
if(inst_77212){
var statearr_77254_77274 = state_77240__$1;
(statearr_77254_77274[(1)] = (6));

} else {
var statearr_77255_77275 = state_77240__$1;
(statearr_77255_77275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (14))){
var inst_77218 = (state_77240[(10)]);
var state_77240__$1 = state_77240;
var statearr_77256_77276 = state_77240__$1;
(statearr_77256_77276[(2)] = inst_77218);

(statearr_77256_77276[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (10))){
var inst_77219 = (state_77240[(12)]);
var state_77240__$1 = state_77240;
var statearr_77257_77277 = state_77240__$1;
(statearr_77257_77277[(2)] = inst_77219);

(statearr_77257_77277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77241 === (8))){
var inst_77219 = (state_77240[(12)]);
var inst_77218 = (state_77240[(10)]);
var inst_77218__$1 = (state_77240[(2)]);
var inst_77219__$1 = (inst_77218__$1 == null);
var state_77240__$1 = (function (){var statearr_77258 = state_77240;
(statearr_77258[(12)] = inst_77219__$1);

(statearr_77258[(10)] = inst_77218__$1);

return statearr_77258;
})();
if(cljs.core.truth_(inst_77219__$1)){
var statearr_77259_77278 = state_77240__$1;
(statearr_77259_77278[(1)] = (10));

} else {
var statearr_77260_77279 = state_77240__$1;
(statearr_77260_77279[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0 = (function (){
var statearr_77261 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77261[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__);

(statearr_77261[(1)] = (1));

return statearr_77261;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1 = (function (state_77240){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77240);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77262){var ex__2730__auto__ = e77262;
var statearr_77263_77280 = state_77240;
(statearr_77263_77280[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77240[(4)]))){
var statearr_77264_77281 = state_77240;
(statearr_77264_77281[(1)] = cljs.core.first((state_77240[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77282 = state_77240;
state_77240 = G__77282;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = function(state_77240){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1.call(this,state_77240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77265 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77265[(6)] = c__2749__auto__);

return statearr_77265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__77283){
var map__77284 = p__77283;
var map__77284__$1 = cljs.core.__destructure_map(map__77284);
var conn = map__77284__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77284__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77284__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77284__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77284__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77395){
var state_val_77396 = (state_77395[(1)]);
if((state_val_77396 === (7))){
var inst_77391 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77397_77453 = state_77395__$1;
(statearr_77397_77453[(2)] = inst_77391);

(statearr_77397_77453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (20))){
var inst_77342 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77398_77454 = state_77395__$1;
(statearr_77398_77454[(2)] = inst_77342);

(statearr_77398_77454[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (27))){
var inst_77360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77361 = ["Connection closed."];
var inst_77362 = (new cljs.core.PersistentVector(null,1,(5),inst_77360,inst_77361,null));
var inst_77363 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_77362);
var state_77395__$1 = state_77395;
var statearr_77399_77455 = state_77395__$1;
(statearr_77399_77455[(2)] = inst_77363);

(statearr_77399_77455[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (1))){
var inst_77285 = (0);
var state_77395__$1 = (function (){var statearr_77400 = state_77395;
(statearr_77400[(7)] = inst_77285);

return statearr_77400;
})();
var statearr_77401_77456 = state_77395__$1;
(statearr_77401_77456[(2)] = null);

(statearr_77401_77456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (24))){
var inst_77329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77330 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_77331 = [keep_alive_fn];
var inst_77332 = cljs.core.PersistentHashMap.fromArrays(inst_77330,inst_77331);
var inst_77333 = ["Unsupported callback registered",inst_77332];
var inst_77334 = (new cljs.core.PersistentVector(null,2,(5),inst_77329,inst_77333,null));
var inst_77335 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_77334);
var state_77395__$1 = state_77395;
var statearr_77402_77457 = state_77395__$1;
(statearr_77402_77457[(2)] = inst_77335);

(statearr_77402_77457[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (4))){
var inst_77290 = (state_77395[(8)]);
var inst_77295 = (state_77395[(2)]);
var inst_77296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77295,(0),null);
var inst_77297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77295,(1),null);
var inst_77298 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77297,inst_77290);
var state_77395__$1 = (function (){var statearr_77403 = state_77395;
(statearr_77403[(9)] = inst_77296);

return statearr_77403;
})();
if(inst_77298){
var statearr_77404_77458 = state_77395__$1;
(statearr_77404_77458[(1)] = (5));

} else {
var statearr_77405_77459 = state_77395__$1;
(statearr_77405_77459[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (15))){
var inst_77315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77316 = ["No keep-alive callback is registered"];
var inst_77317 = (new cljs.core.PersistentVector(null,1,(5),inst_77315,inst_77316,null));
var inst_77318 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_77317);
var state_77395__$1 = state_77395;
var statearr_77406_77460 = state_77395__$1;
(statearr_77406_77460[(2)] = inst_77318);

(statearr_77406_77460[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (21))){
var inst_77326 = cljs.core.eval(keep_alive_fn);
var state_77395__$1 = state_77395;
var statearr_77407_77461 = state_77395__$1;
(statearr_77407_77461[(2)] = inst_77326);

(statearr_77407_77461[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (31))){
var state_77395__$1 = state_77395;
var statearr_77408_77462 = state_77395__$1;
(statearr_77408_77462[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (32))){
var inst_77387 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77410_77463 = state_77395__$1;
(statearr_77410_77463[(2)] = inst_77387);

(statearr_77410_77463[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (33))){
var inst_77296 = (state_77395[(9)]);
var inst_77374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77375 = fluree.db.util.json.parse(inst_77296);
var inst_77376 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77375], 0));
var inst_77377 = ["Received message:",inst_77376];
var inst_77378 = (new cljs.core.PersistentVector(null,2,(5),inst_77374,inst_77377,null));
var inst_77379 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_77378);
var inst_77380 = fluree.db.util.json.parse(inst_77296);
var inst_77381 = fluree.db.conn_events.process_events(conn,inst_77380);
var inst_77285 = (0);
var state_77395__$1 = (function (){var statearr_77411 = state_77395;
(statearr_77411[(10)] = inst_77379);

(statearr_77411[(11)] = inst_77381);

(statearr_77411[(7)] = inst_77285);

return statearr_77411;
})();
var statearr_77412_77464 = state_77395__$1;
(statearr_77412_77464[(2)] = null);

(statearr_77412_77464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (13))){
var inst_77350 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77413_77465 = state_77395__$1;
(statearr_77413_77465[(2)] = inst_77350);

(statearr_77413_77465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (22))){
var state_77395__$1 = state_77395;
var statearr_77414_77466 = state_77395__$1;
(statearr_77414_77466[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (29))){
var inst_77389 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77416_77467 = state_77395__$1;
(statearr_77416_77467[(2)] = inst_77389);

(statearr_77416_77467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (6))){
var inst_77296 = (state_77395[(9)]);
var inst_77358 = (inst_77296 == null);
var state_77395__$1 = state_77395;
if(cljs.core.truth_(inst_77358)){
var statearr_77417_77468 = state_77395__$1;
(statearr_77417_77468[(1)] = (27));

} else {
var statearr_77418_77469 = state_77395__$1;
(statearr_77418_77469[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (28))){
var inst_77296 = (state_77395[(9)]);
var inst_77365 = fluree.db.util.core.exception_QMARK_(inst_77296);
var state_77395__$1 = state_77395;
if(inst_77365){
var statearr_77419_77470 = state_77395__$1;
(statearr_77419_77470[(1)] = (30));

} else {
var statearr_77420_77471 = state_77395__$1;
(statearr_77420_77471[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (25))){
var state_77395__$1 = state_77395;
var statearr_77421_77472 = state_77395__$1;
(statearr_77421_77472[(2)] = null);

(statearr_77421_77472[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (34))){
var state_77395__$1 = state_77395;
var statearr_77422_77473 = state_77395__$1;
(statearr_77422_77473[(2)] = null);

(statearr_77422_77473[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (17))){
var inst_77344 = (state_77395[(2)]);
var inst_77345 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_77346 = fluree.db.connection.close_websocket(inst_77345);
var inst_77347 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_77348 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_77347);
var state_77395__$1 = (function (){var statearr_77423 = state_77395;
(statearr_77423[(12)] = inst_77344);

(statearr_77423[(13)] = inst_77346);

return statearr_77423;
})();
var statearr_77424_77474 = state_77395__$1;
(statearr_77424_77474[(2)] = inst_77348);

(statearr_77424_77474[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (3))){
var inst_77393 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77395__$1,inst_77393);
} else {
if((state_val_77396 === (12))){
var inst_77308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77309 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_77310 = (new cljs.core.PersistentVector(null,1,(5),inst_77308,inst_77309,null));
var inst_77311 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_77310);
var inst_77312 = keep_alive_fn;
var inst_77313 = (keep_alive_fn == null);
var state_77395__$1 = (function (){var statearr_77425 = state_77395;
(statearr_77425[(14)] = inst_77312);

(statearr_77425[(15)] = inst_77311);

return statearr_77425;
})();
if(cljs.core.truth_(inst_77313)){
var statearr_77426_77475 = state_77395__$1;
(statearr_77426_77475[(1)] = (15));

} else {
var statearr_77427_77476 = state_77395__$1;
(statearr_77427_77476[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (2))){
var inst_77290 = (state_77395[(8)]);
var inst_77290__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_77291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77292 = [sub_chan,inst_77290__$1];
var inst_77293 = (new cljs.core.PersistentVector(null,2,(5),inst_77291,inst_77292,null));
var state_77395__$1 = (function (){var statearr_77428 = state_77395;
(statearr_77428[(8)] = inst_77290__$1);

return statearr_77428;
})();
return cljs.core.async.ioc_alts_BANG_(state_77395__$1,(4),inst_77293);
} else {
if((state_val_77396 === (23))){
var inst_77340 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77429_77477 = state_77395__$1;
(statearr_77429_77477[(2)] = inst_77340);

(statearr_77429_77477[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (35))){
var inst_77385 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77430_77478 = state_77395__$1;
(statearr_77430_77478[(2)] = inst_77385);

(statearr_77430_77478[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (19))){
var inst_77324 = typeof keep_alive_fn === 'string';
var state_77395__$1 = state_77395;
if(cljs.core.truth_(inst_77324)){
var statearr_77431_77479 = state_77395__$1;
(statearr_77431_77479[(1)] = (21));

} else {
var statearr_77432_77480 = state_77395__$1;
(statearr_77432_77480[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (11))){
var inst_77303 = fluree.db.connection.reconnect_conn(conn);
var state_77395__$1 = state_77395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77395__$1,(14),inst_77303);
} else {
if((state_val_77396 === (9))){
var inst_77285 = (state_77395[(7)]);
var inst_77352 = fluree.db.connection.ping_transactor(req_chan);
var inst_77353 = (inst_77285 + (1));
var inst_77285__$1 = inst_77353;
var state_77395__$1 = (function (){var statearr_77433 = state_77395;
(statearr_77433[(16)] = inst_77352);

(statearr_77433[(7)] = inst_77285__$1);

return statearr_77433;
})();
var statearr_77434_77481 = state_77395__$1;
(statearr_77434_77481[(2)] = null);

(statearr_77434_77481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (5))){
var inst_77285 = (state_77395[(7)]);
var inst_77300 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_77285);
var state_77395__$1 = state_77395;
if(inst_77300){
var statearr_77435_77482 = state_77395__$1;
(statearr_77435_77482[(1)] = (8));

} else {
var statearr_77436_77483 = state_77395__$1;
(statearr_77436_77483[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (14))){
var inst_77305 = (state_77395[(2)]);
var inst_77285 = (0);
var state_77395__$1 = (function (){var statearr_77437 = state_77395;
(statearr_77437[(17)] = inst_77305);

(statearr_77437[(7)] = inst_77285);

return statearr_77437;
})();
var statearr_77438_77484 = state_77395__$1;
(statearr_77438_77484[(2)] = null);

(statearr_77438_77484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (26))){
var inst_77338 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77439_77485 = state_77395__$1;
(statearr_77439_77485[(2)] = inst_77338);

(statearr_77439_77485[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (16))){
var inst_77320 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_77395__$1 = state_77395;
if(inst_77320){
var statearr_77440_77486 = state_77395__$1;
(statearr_77440_77486[(1)] = (18));

} else {
var statearr_77441_77487 = state_77395__$1;
(statearr_77441_77487[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (30))){
var inst_77296 = (state_77395[(9)]);
var inst_77367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77368 = [inst_77296];
var inst_77369 = (new cljs.core.PersistentVector(null,1,(5),inst_77367,inst_77368,null));
var inst_77370 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77369);
var inst_77285 = (0);
var state_77395__$1 = (function (){var statearr_77442 = state_77395;
(statearr_77442[(18)] = inst_77370);

(statearr_77442[(7)] = inst_77285);

return statearr_77442;
})();
var statearr_77443_77488 = state_77395__$1;
(statearr_77443_77488[(2)] = null);

(statearr_77443_77488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (10))){
var inst_77356 = (state_77395[(2)]);
var state_77395__$1 = state_77395;
var statearr_77444_77489 = state_77395__$1;
(statearr_77444_77489[(2)] = inst_77356);

(statearr_77444_77489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (18))){
var inst_77322 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_77395__$1 = state_77395;
var statearr_77445_77490 = state_77395__$1;
(statearr_77445_77490[(2)] = inst_77322);

(statearr_77445_77490[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77396 === (8))){
var state_77395__$1 = state_77395;
if(cljs.core.truth_(keep_alive)){
var statearr_77446_77491 = state_77395__$1;
(statearr_77446_77491[(1)] = (11));

} else {
var statearr_77447_77492 = state_77395__$1;
(statearr_77447_77492[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_77448 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77448[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_77448[(1)] = (1));

return statearr_77448;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_77395){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77395);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77449){var ex__2730__auto__ = e77449;
var statearr_77450_77493 = state_77395;
(statearr_77450_77493[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77395[(4)]))){
var statearr_77451_77494 = state_77395;
(statearr_77451_77494[(1)] = cljs.core.first((state_77395[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77495 = state_77395;
state_77395 = G__77495;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_77395){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_77395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77452 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77452[(6)] = c__2749__auto__);

return statearr_77452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__77497 = arguments.length;
switch (G__77497) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__77498 = opts;
var map__77498__$1 = cljs.core.__destructure_map(map__77498);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77498__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77498__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77550){
var state_val_77551 = (state_77550[(1)]);
if((state_val_77551 === (7))){
var inst_77508 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_77509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77510 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_77511 = (new cljs.core.PersistentVector(null,2,(5),inst_77509,inst_77510,null));
var inst_77512 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_77508,inst_77511);
var state_77550__$1 = state_77550;
var statearr_77552_77583 = state_77550__$1;
(statearr_77552_77583[(2)] = inst_77512);

(statearr_77552_77583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (1))){
var state_77550__$1 = state_77550;
var statearr_77553_77584 = state_77550__$1;
(statearr_77553_77584[(2)] = null);

(statearr_77553_77584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (4))){
var inst_77499 = (state_77550[(2)]);
var state_77550__$1 = state_77550;
var statearr_77554_77585 = state_77550__$1;
(statearr_77554_77585[(2)] = inst_77499);

(statearr_77554_77585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (15))){
var inst_77519 = (state_77550[(7)]);
var inst_77538 = (state_77550[(2)]);
var inst_77539 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_77540 = [(5000),inst_77538,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_77541 = cljs.core.PersistentHashMap.fromArrays(inst_77539,inst_77540);
var inst_77542 = fluree.db.util.xhttp.get(inst_77519,inst_77541);
var state_77550__$1 = state_77550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77550__$1,(16),inst_77542);
} else {
if((state_val_77551 === (13))){
var inst_77519 = (state_77550[(7)]);
var inst_77529 = (state_77550[(8)]);
var inst_77531 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_77532 = [inst_77529];
var inst_77533 = cljs.core.PersistentHashMap.fromArrays(inst_77531,inst_77532);
var inst_77534 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_77519,inst_77533,private$);
var inst_77535 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_77534);
var state_77550__$1 = state_77550;
var statearr_77555_77586 = state_77550__$1;
(statearr_77555_77586[(2)] = inst_77535);

(statearr_77555_77586[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (6))){
var inst_77505 = (state_77550[(9)]);
var state_77550__$1 = state_77550;
var statearr_77556_77587 = state_77550__$1;
(statearr_77556_77587[(2)] = inst_77505);

(statearr_77556_77587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (3))){
var inst_77548 = (state_77550[(2)]);
var state_77550__$1 = state_77550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77550__$1,inst_77548);
} else {
if((state_val_77551 === (12))){
var inst_77529 = (state_77550[(2)]);
var state_77550__$1 = (function (){var statearr_77557 = state_77550;
(statearr_77557[(8)] = inst_77529);

return statearr_77557;
})();
if(cljs.core.truth_(private$)){
var statearr_77558_77588 = state_77550__$1;
(statearr_77558_77588[(1)] = (13));

} else {
var statearr_77559_77589 = state_77550__$1;
(statearr_77559_77589[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (2))){
var inst_77505 = (state_77550[(9)]);
var _ = (function (){var statearr_77560 = state_77550;
(statearr_77560[(4)] = cljs.core.cons((5),(state_77550[(4)])));

return statearr_77560;
})();
var inst_77505__$1 = jwt;
var state_77550__$1 = (function (){var statearr_77561 = state_77550;
(statearr_77561[(9)] = inst_77505__$1);

return statearr_77561;
})();
if(cljs.core.truth_(inst_77505__$1)){
var statearr_77562_77590 = state_77550__$1;
(statearr_77562_77590[(1)] = (6));

} else {
var statearr_77563_77591 = state_77550__$1;
(statearr_77563_77591[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (11))){
var inst_77523 = (state_77550[(10)]);
var state_77550__$1 = state_77550;
var statearr_77565_77592 = state_77550__$1;
(statearr_77565_77592[(2)] = inst_77523);

(statearr_77565_77592[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (9))){
var inst_77515 = (state_77550[(11)]);
var inst_77514 = (state_77550[(12)]);
var inst_77518 = (state_77550[(2)]);
var inst_77519 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77518),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77515)].join('');
var inst_77521 = ["Accept"];
var inst_77522 = ["application/json"];
var inst_77523 = cljs.core.PersistentHashMap.fromArrays(inst_77521,inst_77522);
var state_77550__$1 = (function (){var statearr_77566 = state_77550;
(statearr_77566[(10)] = inst_77523);

(statearr_77566[(7)] = inst_77519);

return statearr_77566;
})();
if(cljs.core.truth_(inst_77514)){
var statearr_77567_77593 = state_77550__$1;
(statearr_77567_77593[(1)] = (10));

} else {
var statearr_77568_77594 = state_77550__$1;
(statearr_77568_77594[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (5))){
var _ = (function (){var statearr_77569 = state_77550;
(statearr_77569[(4)] = cljs.core.rest((state_77550[(4)])));

return statearr_77569;
})();
var state_77550__$1 = state_77550;
var ex77564 = (state_77550__$1[(2)]);
var statearr_77570_77595 = state_77550__$1;
(statearr_77570_77595[(5)] = ex77564);


if((ex77564 instanceof Error)){
var statearr_77571_77596 = state_77550__$1;
(statearr_77571_77596[(1)] = (4));

(statearr_77571_77596[(5)] = null);

} else {
throw ex77564;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (14))){
var inst_77529 = (state_77550[(8)]);
var state_77550__$1 = state_77550;
var statearr_77572_77597 = state_77550__$1;
(statearr_77572_77597[(2)] = inst_77529);

(statearr_77572_77597[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (16))){
var inst_77544 = (state_77550[(2)]);
var inst_77545 = fluree.db.util.async.throw_err(inst_77544);
var _ = (function (){var statearr_77573 = state_77550;
(statearr_77573[(4)] = cljs.core.rest((state_77550[(4)])));

return statearr_77573;
})();
var state_77550__$1 = state_77550;
var statearr_77574_77598 = state_77550__$1;
(statearr_77574_77598[(2)] = inst_77545);

(statearr_77574_77598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (10))){
var inst_77523 = (state_77550[(10)]);
var inst_77514 = (state_77550[(12)]);
var inst_77525 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77514)].join('');
var inst_77526 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_77523,"Authorization",inst_77525);
var state_77550__$1 = state_77550;
var statearr_77575_77599 = state_77550__$1;
(statearr_77575_77599[(2)] = inst_77526);

(statearr_77575_77599[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77551 === (8))){
var inst_77514 = (state_77550[(2)]);
var inst_77515 = clojure.string.replace(k,"_","/");
var inst_77516 = fluree.db.connection.get_server(conn_id,servers);
var state_77550__$1 = (function (){var statearr_77576 = state_77550;
(statearr_77576[(11)] = inst_77515);

(statearr_77576[(12)] = inst_77514);

return statearr_77576;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77550__$1,(9),inst_77516);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_77577 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77577[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_77577[(1)] = (1));

return statearr_77577;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_77550){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77550);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77578){var ex__2730__auto__ = e77578;
var statearr_77579_77600 = state_77550;
(statearr_77579_77600[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77550[(4)]))){
var statearr_77580_77601 = state_77550;
(statearr_77580_77601[(1)] = cljs.core.first((state_77550[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77602 = state_77550;
state_77550 = G__77602;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_77550){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_77550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77581 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77581[(6)] = c__2749__auto__);

return statearr_77581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___77627 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___77627)){
var v_77628 = temp__5802__auto___77627;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_77628);
} else {
var c__2749__auto___77629 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77614){
var state_val_77615 = (state_77614[(1)]);
if((state_val_77615 === (1))){
var inst_77603 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_77614__$1 = state_77614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77614__$1,(2),inst_77603);
} else {
if((state_val_77615 === (2))){
var inst_77605 = (state_77614[(7)]);
var inst_77605__$1 = (state_77614[(2)]);
var inst_77606 = fluree.db.util.core.exception_QMARK_(inst_77605__$1);
var state_77614__$1 = (function (){var statearr_77616 = state_77614;
(statearr_77616[(7)] = inst_77605__$1);

return statearr_77616;
})();
if(inst_77606){
var statearr_77617_77630 = state_77614__$1;
(statearr_77617_77630[(1)] = (3));

} else {
var statearr_77618_77631 = state_77614__$1;
(statearr_77618_77631[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77615 === (3))){
var state_77614__$1 = state_77614;
var statearr_77619_77632 = state_77614__$1;
(statearr_77619_77632[(2)] = null);

(statearr_77619_77632[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77615 === (4))){
var inst_77605 = (state_77614[(7)]);
var inst_77609 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_77605);
var state_77614__$1 = state_77614;
var statearr_77620_77633 = state_77614__$1;
(statearr_77620_77633[(2)] = inst_77609);

(statearr_77620_77633[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77615 === (5))){
var inst_77605 = (state_77614[(7)]);
var inst_77611 = (state_77614[(2)]);
var inst_77612 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_77605);
var state_77614__$1 = (function (){var statearr_77621 = state_77614;
(statearr_77621[(8)] = inst_77611);

return statearr_77621;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_77614__$1,inst_77612);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_77622 = [null,null,null,null,null,null,null,null,null];
(statearr_77622[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__);

(statearr_77622[(1)] = (1));

return statearr_77622;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1 = (function (state_77614){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77614);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77623){var ex__2730__auto__ = e77623;
var statearr_77624_77634 = state_77614;
(statearr_77624_77634[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77614[(4)]))){
var statearr_77625_77635 = state_77614;
(statearr_77625_77635[(1)] = cljs.core.first((state_77614[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77636 = state_77614;
state_77614 = G__77636;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = function(state_77614){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1.call(this,state_77614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77626 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77626[(6)] = c__2749__auto___77629);

return statearr_77626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__77637_SHARP_){
if(cljs.core.truth_(p1__77637_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__77638_SHARP_){
var or__5045__auto__ = p1__77638_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e77639){var e = e77639;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__77640 = opts;
var map__77640__$1 = cljs.core.__destructure_map(map__77640);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__77640__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77640__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__77641_77642 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__77641_77642.cljs$core$IFn$_invoke$arity$0 ? fexpr__77641_77642.cljs$core$IFn$_invoke$arity$0() : fexpr__77641_77642.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___77686 = arguments.length;
var i__5770__auto___77687 = (0);
while(true){
if((i__5770__auto___77687 < len__5769__auto___77686)){
args__5775__auto__.push((arguments[i__5770__auto___77687]));

var G__77688 = (i__5770__auto___77687 + (1));
i__5770__auto___77687 = G__77688;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__77645){
var vec__77646 = p__77645;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77646,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___77689 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77669){
var state_val_77670 = (state_77669[(1)]);
if((state_val_77670 === (1))){
var inst_77649 = fluree.db.connection.get_socket(conn);
var state_77669__$1 = state_77669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77669__$1,(2),inst_77649);
} else {
if((state_val_77670 === (2))){
var inst_77652 = (state_77669[(7)]);
var inst_77651 = (state_77669[(8)]);
var inst_77651__$1 = (state_77669[(2)]);
var inst_77652__$1 = (inst_77651__$1 == null);
var state_77669__$1 = (function (){var statearr_77671 = state_77669;
(statearr_77671[(7)] = inst_77652__$1);

(statearr_77671[(8)] = inst_77651__$1);

return statearr_77671;
})();
if(cljs.core.truth_(inst_77652__$1)){
var statearr_77672_77690 = state_77669__$1;
(statearr_77672_77690[(1)] = (3));

} else {
var statearr_77673_77691 = state_77669__$1;
(statearr_77673_77691[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77670 === (3))){
var inst_77652 = (state_77669[(7)]);
var state_77669__$1 = state_77669;
var statearr_77674_77692 = state_77669__$1;
(statearr_77674_77692[(2)] = inst_77652);

(statearr_77674_77692[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77670 === (4))){
var inst_77651 = (state_77669[(8)]);
var inst_77655 = fluree.db.util.core.exception_QMARK_(inst_77651);
var state_77669__$1 = state_77669;
var statearr_77675_77693 = state_77669__$1;
(statearr_77675_77693[(2)] = inst_77655);

(statearr_77675_77693[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77670 === (5))){
var inst_77657 = (state_77669[(2)]);
var state_77669__$1 = state_77669;
if(cljs.core.truth_(inst_77657)){
var statearr_77676_77694 = state_77669__$1;
(statearr_77676_77694[(1)] = (6));

} else {
var statearr_77677_77695 = state_77669__$1;
(statearr_77677_77695[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77670 === (6))){
var inst_77651 = (state_77669[(8)]);
var inst_77659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77660 = [inst_77651,"Cannot establish connection to a healthy server, disconnecting."];
var inst_77661 = (new cljs.core.PersistentVector(null,2,(5),inst_77659,inst_77660,null));
var inst_77662 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77661);
var inst_77663 = cljs.core.async.close_BANG_(conn);
var state_77669__$1 = (function (){var statearr_77678 = state_77669;
(statearr_77678[(9)] = inst_77662);

return statearr_77678;
})();
var statearr_77679_77696 = state_77669__$1;
(statearr_77679_77696[(2)] = inst_77663);

(statearr_77679_77696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77670 === (7))){
var inst_77665 = fluree.db.connection.msg_consumer(conn);
var state_77669__$1 = state_77669;
var statearr_77680_77697 = state_77669__$1;
(statearr_77680_77697[(2)] = inst_77665);

(statearr_77680_77697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77670 === (8))){
var inst_77667 = (state_77669[(2)]);
var state_77669__$1 = state_77669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77669__$1,inst_77667);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_77681 = [null,null,null,null,null,null,null,null,null,null];
(statearr_77681[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_77681[(1)] = (1));

return statearr_77681;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_77669){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77669);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77682){var ex__2730__auto__ = e77682;
var statearr_77683_77698 = state_77669;
(statearr_77683_77698[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77669[(4)]))){
var statearr_77684_77699 = state_77669;
(statearr_77684_77699[(1)] = cljs.core.first((state_77669[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77700 = state_77669;
state_77669 = G__77700;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_77669){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_77669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77685 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77685[(6)] = c__2749__auto___77689);

return statearr_77685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq77643){
var G__77644 = cljs.core.first(seq77643);
var seq77643__$1 = cljs.core.next(seq77643);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__77644,seq77643__$1);
}));

