// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__81281 = arguments.length;
switch (G__81281) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___81320 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81302){
var state_val_81303 = (state_81302[(1)]);
if((state_val_81303 === (1))){
var state_81302__$1 = state_81302;
var statearr_81304_81321 = state_81302__$1;
(statearr_81304_81321[(2)] = null);

(statearr_81304_81321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81303 === (2))){
var _ = (function (){var statearr_81305 = state_81302;
(statearr_81305[(4)] = cljs.core.cons.call(null,(5),(state_81302[(4)])));

return statearr_81305;
})();
var inst_81288 = fluree.db.session.db.call(null,conn,ledger,null);
var state_81302__$1 = state_81302;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81302__$1,(7),inst_81288);
} else {
if((state_val_81303 === (3))){
var inst_81298 = (state_81302[(2)]);
var inst_81299 = cljs.core.async.put_BANG_.call(null,pc,inst_81298);
var inst_81300 = cljs.core.async.close_BANG_.call(null,pc);
var state_81302__$1 = (function (){var statearr_81307 = state_81302;
(statearr_81307[(7)] = inst_81299);

return statearr_81307;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81302__$1,inst_81300);
} else {
if((state_val_81303 === (4))){
var inst_81282 = (state_81302[(2)]);
var state_81302__$1 = state_81302;
var statearr_81308_81322 = state_81302__$1;
(statearr_81308_81322[(2)] = inst_81282);

(statearr_81308_81322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81303 === (5))){
var _ = (function (){var statearr_81309 = state_81302;
(statearr_81309[(4)] = cljs.core.rest.call(null,(state_81302[(4)])));

return statearr_81309;
})();
var state_81302__$1 = state_81302;
var ex81306 = (state_81302__$1[(2)]);
var statearr_81310_81323 = state_81302__$1;
(statearr_81310_81323[(5)] = ex81306);


var statearr_81311_81324 = state_81302__$1;
(statearr_81311_81324[(1)] = (4));

(statearr_81311_81324[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81303 === (6))){
var inst_81294 = (state_81302[(2)]);
var inst_81295 = fluree.db.util.async.throw_err.call(null,inst_81294);
var _ = (function (){var statearr_81312 = state_81302;
(statearr_81312[(4)] = cljs.core.rest.call(null,(state_81302[(4)])));

return statearr_81312;
})();
var state_81302__$1 = state_81302;
var statearr_81313_81325 = state_81302__$1;
(statearr_81313_81325[(2)] = inst_81295);

(statearr_81313_81325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81303 === (7))){
var inst_81290 = (state_81302[(2)]);
var inst_81291 = fluree.db.util.async.throw_err.call(null,inst_81290);
var inst_81292 = fluree.db.time_travel.as_of_block.call(null,inst_81291,block);
var state_81302__$1 = state_81302;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81302__$1,(6),inst_81292);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_81314 = [null,null,null,null,null,null,null,null];
(statearr_81314[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_81314[(1)] = (1));

return statearr_81314;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_81302){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81315){var ex__2749__auto__ = e81315;
var statearr_81316_81326 = state_81302;
(statearr_81316_81326[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81302[(4)]))){
var statearr_81317_81327 = state_81302;
(statearr_81317_81327[(1)] = cljs.core.first.call(null,(state_81302[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81328 = state_81302;
state_81302 = G__81328;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_81302){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_81302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81318 = f__2769__auto__.call(null);
(statearr_81318[(6)] = c__2768__auto___81320);

return statearr_81318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81369){
var state_val_81370 = (state_81369[(1)]);
if((state_val_81370 === (7))){
var inst_81338 = cljs.core._EQ_.call(null,(0),auth);
var state_81369__$1 = state_81369;
if(inst_81338){
var statearr_81371_81402 = state_81369__$1;
(statearr_81371_81402[(1)] = (9));

} else {
var statearr_81372_81403 = state_81369__$1;
(statearr_81372_81403[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (1))){
var state_81369__$1 = state_81369;
var statearr_81373_81404 = state_81369__$1;
(statearr_81373_81404[(2)] = null);

(statearr_81373_81404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (4))){
var inst_81329 = (state_81369[(2)]);
var state_81369__$1 = state_81369;
var statearr_81374_81405 = state_81369__$1;
(statearr_81374_81405[(2)] = inst_81329);

(statearr_81374_81405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (15))){
var inst_81346 = (state_81369[(7)]);
var inst_81345 = (state_81369[(2)]);
var inst_81346__$1 = fluree.db.util.async.throw_err.call(null,inst_81345);
var state_81369__$1 = (function (){var statearr_81375 = state_81369;
(statearr_81375[(7)] = inst_81346__$1);

return statearr_81375;
})();
if(cljs.core.truth_(inst_81346__$1)){
var statearr_81376_81406 = state_81369__$1;
(statearr_81376_81406[(1)] = (16));

} else {
var statearr_81377_81407 = state_81369__$1;
(statearr_81377_81407[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (13))){
var state_81369__$1 = state_81369;
var statearr_81378_81408 = state_81369__$1;
(statearr_81378_81408[(2)] = null);

(statearr_81378_81408[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (6))){
var state_81369__$1 = state_81369;
var statearr_81379_81409 = state_81369__$1;
(statearr_81379_81409[(2)] = db);

(statearr_81379_81409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (17))){
var inst_81350 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_81351 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81352 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_81353 = cljs.core.PersistentHashMap.fromArrays(inst_81351,inst_81352);
var inst_81354 = cljs.core.ex_info.call(null,inst_81350,inst_81353);
var inst_81355 = (function(){throw inst_81354})();
var state_81369__$1 = state_81369;
var statearr_81380_81410 = state_81369__$1;
(statearr_81380_81410[(2)] = inst_81355);

(statearr_81380_81410[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (3))){
var inst_81367 = (state_81369[(2)]);
var state_81369__$1 = state_81369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81369__$1,inst_81367);
} else {
if((state_val_81370 === (12))){
var inst_81343 = fluree.db.dbproto._subid.call(null,db,auth);
var state_81369__$1 = state_81369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81369__$1,(15),inst_81343);
} else {
if((state_val_81370 === (2))){
var _ = (function (){var statearr_81381 = state_81369;
(statearr_81381[(4)] = cljs.core.cons.call(null,(5),(state_81369[(4)])));

return statearr_81381;
})();
var inst_81335 = cljs.core.not.call(null,auth);
var state_81369__$1 = state_81369;
if(inst_81335){
var statearr_81382_81411 = state_81369__$1;
(statearr_81382_81411[(1)] = (6));

} else {
var statearr_81383_81412 = state_81369__$1;
(statearr_81383_81412[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (11))){
var inst_81362 = (state_81369[(2)]);
var state_81369__$1 = state_81369;
var statearr_81385_81413 = state_81369__$1;
(statearr_81385_81413[(2)] = inst_81362);

(statearr_81385_81413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (9))){
var inst_81340 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_81369__$1 = state_81369;
var statearr_81386_81414 = state_81369__$1;
(statearr_81386_81414[(2)] = inst_81340);

(statearr_81386_81414[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (5))){
var _ = (function (){var statearr_81387 = state_81369;
(statearr_81387[(4)] = cljs.core.rest.call(null,(state_81369[(4)])));

return statearr_81387;
})();
var state_81369__$1 = state_81369;
var ex81384 = (state_81369__$1[(2)]);
var statearr_81388_81415 = state_81369__$1;
(statearr_81388_81415[(5)] = ex81384);


if((ex81384 instanceof Error)){
var statearr_81389_81416 = state_81369__$1;
(statearr_81389_81416[(1)] = (4));

(statearr_81389_81416[(5)] = null);

} else {
throw ex81384;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (14))){
var inst_81360 = (state_81369[(2)]);
var state_81369__$1 = state_81369;
var statearr_81390_81417 = state_81369__$1;
(statearr_81390_81417[(2)] = inst_81360);

(statearr_81390_81417[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (16))){
var inst_81346 = (state_81369[(7)]);
var inst_81348 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_81346);
var state_81369__$1 = state_81369;
var statearr_81391_81418 = state_81369__$1;
(statearr_81391_81418[(2)] = inst_81348);

(statearr_81391_81418[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (10))){
var state_81369__$1 = state_81369;
var statearr_81392_81419 = state_81369__$1;
(statearr_81392_81419[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (18))){
var inst_81357 = (state_81369[(2)]);
var state_81369__$1 = state_81369;
var statearr_81394_81420 = state_81369__$1;
(statearr_81394_81420[(2)] = inst_81357);

(statearr_81394_81420[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81370 === (8))){
var inst_81364 = (state_81369[(2)]);
var _ = (function (){var statearr_81395 = state_81369;
(statearr_81395[(4)] = cljs.core.rest.call(null,(state_81369[(4)])));

return statearr_81395;
})();
var state_81369__$1 = state_81369;
var statearr_81396_81421 = state_81369__$1;
(statearr_81396_81421[(2)] = inst_81364);

(statearr_81396_81421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0 = (function (){
var statearr_81397 = [null,null,null,null,null,null,null,null];
(statearr_81397[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__);

(statearr_81397[(1)] = (1));

return statearr_81397;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1 = (function (state_81369){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81398){var ex__2749__auto__ = e81398;
var statearr_81399_81422 = state_81369;
(statearr_81399_81422[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81369[(4)]))){
var statearr_81400_81423 = state_81369;
(statearr_81400_81423[(1)] = cljs.core.first.call(null,(state_81369[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81424 = state_81369;
state_81369 = G__81424;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = function(state_81369){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1.call(this,state_81369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81401 = f__2769__auto__.call(null);
(statearr_81401[(6)] = c__2768__auto__);

return statearr_81401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81496){
var state_val_81497 = (state_81496[(1)]);
if((state_val_81497 === (7))){
var inst_81434 = cljs.core._EQ_.call(null,(0),auth);
var state_81496__$1 = state_81496;
if(inst_81434){
var statearr_81498_81552 = state_81496__$1;
(statearr_81498_81552[(1)] = (9));

} else {
var statearr_81499_81553 = state_81496__$1;
(statearr_81499_81553[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (20))){
var inst_81458 = (state_81496[(7)]);
var state_81496__$1 = state_81496;
if(cljs.core.truth_(inst_81458)){
var statearr_81500_81554 = state_81496__$1;
(statearr_81500_81554[(1)] = (22));

} else {
var statearr_81501_81555 = state_81496__$1;
(statearr_81501_81555[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (27))){
var state_81496__$1 = state_81496;
var statearr_81502_81556 = state_81496__$1;
(statearr_81502_81556[(2)] = null);

(statearr_81502_81556[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (1))){
var state_81496__$1 = state_81496;
var statearr_81503_81557 = state_81496__$1;
(statearr_81503_81557[(2)] = null);

(statearr_81503_81557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (24))){
var inst_81472 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81504_81558 = state_81496__$1;
(statearr_81504_81558[(2)] = inst_81472);

(statearr_81504_81558[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (4))){
var inst_81425 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81505_81559 = state_81496__$1;
(statearr_81505_81559[(2)] = inst_81425);

(statearr_81505_81559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (15))){
var inst_81441 = (state_81496[(8)]);
var inst_81440 = (state_81496[(2)]);
var inst_81441__$1 = fluree.db.util.async.throw_err.call(null,inst_81440);
var state_81496__$1 = (function (){var statearr_81506 = state_81496;
(statearr_81506[(8)] = inst_81441__$1);

return statearr_81506;
})();
if(cljs.core.truth_(inst_81441__$1)){
var statearr_81507_81560 = state_81496__$1;
(statearr_81507_81560[(1)] = (16));

} else {
var statearr_81508_81561 = state_81496__$1;
(statearr_81508_81561[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (21))){
var inst_81474 = (state_81496[(9)]);
var inst_81474__$1 = (state_81496[(2)]);
var state_81496__$1 = (function (){var statearr_81509 = state_81496;
(statearr_81509[(9)] = inst_81474__$1);

return statearr_81509;
})();
if(cljs.core.truth_(inst_81474__$1)){
var statearr_81510_81562 = state_81496__$1;
(statearr_81510_81562[(1)] = (29));

} else {
var statearr_81511_81563 = state_81496__$1;
(statearr_81511_81563[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (31))){
var inst_81474 = (state_81496[(9)]);
var inst_81482 = (state_81496[(2)]);
var state_81496__$1 = (function (){var statearr_81512 = state_81496;
(statearr_81512[(10)] = inst_81482);

return statearr_81512;
})();
if(cljs.core.truth_(inst_81474)){
var statearr_81513_81564 = state_81496__$1;
(statearr_81513_81564[(1)] = (33));

} else {
var statearr_81514_81565 = state_81496__$1;
(statearr_81514_81565[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (32))){
var inst_81478 = (state_81496[(2)]);
var inst_81479 = fluree.db.util.async.throw_err.call(null,inst_81478);
var state_81496__$1 = state_81496;
var statearr_81515_81566 = state_81496__$1;
(statearr_81515_81566[(2)] = inst_81479);

(statearr_81515_81566[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (33))){
var inst_81474 = (state_81496[(9)]);
var inst_81484 = fluree.db.permissions.permission_map.call(null,db,inst_81474,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81496__$1,(36),inst_81484);
} else {
if((state_val_81497 === (13))){
var state_81496__$1 = state_81496;
var statearr_81516_81567 = state_81496__$1;
(statearr_81516_81567[(2)] = null);

(statearr_81516_81567[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (22))){
var inst_81458 = (state_81496[(7)]);
var inst_81462 = fluree.db.auth.roles.call(null,db,inst_81458);
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81496__$1,(25),inst_81462);
} else {
if((state_val_81497 === (36))){
var inst_81486 = (state_81496[(2)]);
var inst_81487 = fluree.db.util.async.throw_err.call(null,inst_81486);
var state_81496__$1 = state_81496;
var statearr_81517_81568 = state_81496__$1;
(statearr_81517_81568[(2)] = inst_81487);

(statearr_81517_81568[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (29))){
var inst_81474 = (state_81496[(9)]);
var inst_81458 = (state_81496[(7)]);
var inst_81476 = fluree.db.dbfunctions.ctx.build.call(null,db,inst_81458,inst_81474);
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81496__$1,(32),inst_81476);
} else {
if((state_val_81497 === (6))){
var state_81496__$1 = state_81496;
var statearr_81518_81569 = state_81496__$1;
(statearr_81518_81569[(2)] = null);

(statearr_81518_81569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (28))){
var inst_81470 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81519_81570 = state_81496__$1;
(statearr_81519_81570[(2)] = inst_81470);

(statearr_81519_81570[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (25))){
var inst_81464 = (state_81496[(2)]);
var inst_81465 = fluree.db.util.async.throw_err.call(null,inst_81464);
var state_81496__$1 = state_81496;
var statearr_81520_81571 = state_81496__$1;
(statearr_81520_81571[(2)] = inst_81465);

(statearr_81520_81571[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (34))){
var state_81496__$1 = state_81496;
var statearr_81521_81572 = state_81496__$1;
(statearr_81521_81572[(2)] = null);

(statearr_81521_81572[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (17))){
var inst_81444 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_81445 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81446 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_81447 = cljs.core.PersistentHashMap.fromArrays(inst_81445,inst_81446);
var inst_81448 = cljs.core.ex_info.call(null,inst_81444,inst_81447);
var inst_81449 = (function(){throw inst_81448})();
var state_81496__$1 = state_81496;
var statearr_81522_81573 = state_81496__$1;
(statearr_81522_81573[(2)] = inst_81449);

(statearr_81522_81573[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (3))){
var inst_81494 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81496__$1,inst_81494);
} else {
if((state_val_81497 === (12))){
var inst_81438 = fluree.db.dbproto._subid.call(null,db,auth);
var state_81496__$1 = state_81496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81496__$1,(15),inst_81438);
} else {
if((state_val_81497 === (2))){
var _ = (function (){var statearr_81523 = state_81496;
(statearr_81523[(4)] = cljs.core.cons.call(null,(5),(state_81496[(4)])));

return statearr_81523;
})();
var inst_81431 = (auth == null);
var state_81496__$1 = state_81496;
if(cljs.core.truth_(inst_81431)){
var statearr_81524_81574 = state_81496__$1;
(statearr_81524_81574[(1)] = (6));

} else {
var statearr_81525_81575 = state_81496__$1;
(statearr_81525_81575[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (23))){
var state_81496__$1 = state_81496;
var statearr_81526_81576 = state_81496__$1;
(statearr_81526_81576[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (35))){
var inst_81482 = (state_81496[(10)]);
var inst_81474 = (state_81496[(9)]);
var inst_81458 = (state_81496[(7)]);
var inst_81490 = (state_81496[(2)]);
var inst_81491 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_81458,new cljs.core.Keyword(null,"roles","roles",143379530),inst_81474,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_81490,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_81482);
var _ = (function (){var statearr_81528 = state_81496;
(statearr_81528[(4)] = cljs.core.rest.call(null,(state_81496[(4)])));

return statearr_81528;
})();
var state_81496__$1 = state_81496;
var statearr_81529_81577 = state_81496__$1;
(statearr_81529_81577[(2)] = inst_81491);

(statearr_81529_81577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (19))){
var state_81496__$1 = state_81496;
var statearr_81530_81578 = state_81496__$1;
(statearr_81530_81578[(2)] = roles);

(statearr_81530_81578[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (11))){
var inst_81456 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81532_81579 = state_81496__$1;
(statearr_81532_81579[(2)] = inst_81456);

(statearr_81532_81579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (9))){
var state_81496__$1 = state_81496;
var statearr_81533_81580 = state_81496__$1;
(statearr_81533_81580[(2)] = (0));

(statearr_81533_81580[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (5))){
var _ = (function (){var statearr_81534 = state_81496;
(statearr_81534[(4)] = cljs.core.rest.call(null,(state_81496[(4)])));

return statearr_81534;
})();
var state_81496__$1 = state_81496;
var ex81531 = (state_81496__$1[(2)]);
var statearr_81535_81581 = state_81496__$1;
(statearr_81535_81581[(5)] = ex81531);


if((ex81531 instanceof Error)){
var statearr_81536_81582 = state_81496__$1;
(statearr_81536_81582[(1)] = (4));

(statearr_81536_81582[(5)] = null);

} else {
throw ex81531;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (14))){
var inst_81454 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81537_81583 = state_81496__$1;
(statearr_81537_81583[(2)] = inst_81454);

(statearr_81537_81583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (26))){
var state_81496__$1 = state_81496;
var statearr_81538_81584 = state_81496__$1;
(statearr_81538_81584[(2)] = null);

(statearr_81538_81584[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (16))){
var inst_81441 = (state_81496[(8)]);
var state_81496__$1 = state_81496;
var statearr_81539_81585 = state_81496__$1;
(statearr_81539_81585[(2)] = inst_81441);

(statearr_81539_81585[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (30))){
var state_81496__$1 = state_81496;
var statearr_81540_81586 = state_81496__$1;
(statearr_81540_81586[(2)] = null);

(statearr_81540_81586[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (10))){
var state_81496__$1 = state_81496;
if(cljs.core.truth_(auth)){
var statearr_81541_81587 = state_81496__$1;
(statearr_81541_81587[(1)] = (12));

} else {
var statearr_81542_81588 = state_81496__$1;
(statearr_81542_81588[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (18))){
var inst_81451 = (state_81496[(2)]);
var state_81496__$1 = state_81496;
var statearr_81543_81589 = state_81496__$1;
(statearr_81543_81589[(2)] = inst_81451);

(statearr_81543_81589[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81497 === (8))){
var inst_81458 = (state_81496[(2)]);
var state_81496__$1 = (function (){var statearr_81544 = state_81496;
(statearr_81544[(7)] = inst_81458);

return statearr_81544;
})();
if(cljs.core.truth_(roles)){
var statearr_81545_81590 = state_81496__$1;
(statearr_81545_81590[(1)] = (19));

} else {
var statearr_81546_81591 = state_81496__$1;
(statearr_81546_81591[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0 = (function (){
var statearr_81547 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81547[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__);

(statearr_81547[(1)] = (1));

return statearr_81547;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1 = (function (state_81496){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81548){var ex__2749__auto__ = e81548;
var statearr_81549_81592 = state_81496;
(statearr_81549_81592[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81496[(4)]))){
var statearr_81550_81593 = state_81496;
(statearr_81550_81593[(1)] = cljs.core.first.call(null,(state_81496[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81594 = state_81496;
state_81496 = G__81594;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = function(state_81496){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1.call(this,state_81496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81551 = f__2769__auto__.call(null);
(statearr_81551[(6)] = c__2768__auto__);

return statearr_81551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__81595 = db;
var map__81595__$1 = cljs.core.__destructure_map.call(null,map__81595);
var conn = cljs.core.get.call(null,map__81595__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__81595__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__81595__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81602){
var state_val_81603 = (state_81602[(1)]);
if((state_val_81603 === (1))){
var inst_81596 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_81597 = fluree.db.session.db.call(null,conn,inst_81596,null);
var state_81602__$1 = state_81602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81602__$1,(2),inst_81597);
} else {
if((state_val_81603 === (2))){
var inst_81599 = (state_81602[(2)]);
var inst_81600 = cljs.core.async.put_BANG_.call(null,resp_port,inst_81599);
var state_81602__$1 = state_81602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81602__$1,inst_81600);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_81604 = [null,null,null,null,null,null,null];
(statearr_81604[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_81604[(1)] = (1));

return statearr_81604;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_81602){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81605){var ex__2749__auto__ = e81605;
var statearr_81606_81633 = state_81602;
(statearr_81606_81633[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81602[(4)]))){
var statearr_81607_81634 = state_81602;
(statearr_81607_81634[(1)] = cljs.core.first.call(null,(state_81602[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81635 = state_81602;
state_81602 = G__81635;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_81602){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_81602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81608 = f__2769__auto__.call(null);
(statearr_81608[(6)] = c__2768__auto__);

return statearr_81608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,ledger_id,listen_id,event_fn);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81621){
var state_val_81622 = (state_81621[(1)]);
if((state_val_81622 === (1))){
var inst_81609 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_81610 = fluree.db.session.db.call(null,conn,inst_81609,null);
var state_81621__$1 = state_81621;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81621__$1,(2),inst_81610);
} else {
if((state_val_81622 === (2))){
var inst_81612 = (state_81621[(7)]);
var inst_81612__$1 = (state_81621[(2)]);
var inst_81613 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_81612__$1);
var inst_81614 = newer_block_QMARK_.call(null,inst_81613);
var state_81621__$1 = (function (){var statearr_81623 = state_81621;
(statearr_81623[(7)] = inst_81612__$1);

return statearr_81623;
})();
if(inst_81614){
var statearr_81624_81636 = state_81621__$1;
(statearr_81624_81636[(1)] = (3));

} else {
var statearr_81625_81637 = state_81621__$1;
(statearr_81625_81637[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81622 === (3))){
var inst_81612 = (state_81621[(7)]);
var inst_81616 = cljs.core.async.put_BANG_.call(null,resp_port,inst_81612);
var state_81621__$1 = state_81621;
var statearr_81626_81638 = state_81621__$1;
(statearr_81626_81638[(2)] = inst_81616);

(statearr_81626_81638[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81622 === (4))){
var state_81621__$1 = state_81621;
var statearr_81627_81639 = state_81621__$1;
(statearr_81627_81639[(2)] = null);

(statearr_81627_81639[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81622 === (5))){
var inst_81619 = (state_81621[(2)]);
var state_81621__$1 = state_81621;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81621__$1,inst_81619);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_81628 = [null,null,null,null,null,null,null,null];
(statearr_81628[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_81628[(1)] = (1));

return statearr_81628;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_81621){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81621);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81629){var ex__2749__auto__ = e81629;
var statearr_81630_81640 = state_81621;
(statearr_81630_81640[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81621[(4)]))){
var statearr_81631_81641 = state_81621;
(statearr_81631_81641[(1)] = cljs.core.first.call(null,(state_81621[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81642 = state_81621;
state_81621 = G__81642;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_81621){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_81621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81632 = f__2769__auto__.call(null);
(statearr_81632[(6)] = c__2768__auto__);

return statearr_81632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__81643 = db;
var map__81643__$1 = cljs.core.__destructure_map.call(null,map__81643);
var conn = cljs.core.get.call(null,map__81643__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__81643__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__81643__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2768__auto___81719 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81693){
var state_val_81694 = (state_81693[(1)]);
if((state_val_81694 === (7))){
var inst_81659 = (state_81693[(7)]);
var inst_81670 = cljs.core._EQ_.call(null,inst_81659,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_81693__$1 = state_81693;
if(inst_81670){
var statearr_81695_81720 = state_81693__$1;
(statearr_81695_81720[(1)] = (9));

} else {
var statearr_81696_81721 = state_81693__$1;
(statearr_81696_81721[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (1))){
var inst_81652 = (state_81693[(8)]);
var inst_81644 = (state_81693[(9)]);
var inst_81644__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_81652__$1 = res_port;
var inst_81653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81654 = [inst_81644__$1,inst_81652__$1];
var inst_81655 = (new cljs.core.PersistentVector(null,2,(5),inst_81653,inst_81654,null));
var state_81693__$1 = (function (){var statearr_81697 = state_81693;
(statearr_81697[(8)] = inst_81652__$1);

(statearr_81697[(9)] = inst_81644__$1);

return statearr_81697;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_81693__$1,(2),inst_81655);
} else {
if((state_val_81694 === (4))){
var inst_81659 = (state_81693[(7)]);
var inst_81652 = (state_81693[(8)]);
var inst_81663 = cljs.core._EQ_.call(null,inst_81659,inst_81652);
var state_81693__$1 = state_81693;
if(inst_81663){
var statearr_81698_81722 = state_81693__$1;
(statearr_81698_81722[(1)] = (6));

} else {
var statearr_81699_81723 = state_81693__$1;
(statearr_81699_81723[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (13))){
var inst_81678 = (state_81693[(10)]);
var inst_81689 = cljs.core.async.put_BANG_.call(null,pc,inst_81678);
var state_81693__$1 = state_81693;
var statearr_81700_81724 = state_81693__$1;
(statearr_81700_81724[(2)] = inst_81689);

(statearr_81700_81724[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (6))){
var inst_81657 = (state_81693[(11)]);
var inst_81668 = cljs.core.nth.call(null,inst_81657,(0),null);
var state_81693__$1 = state_81693;
var statearr_81701_81725 = state_81693__$1;
(statearr_81701_81725[(2)] = inst_81668);

(statearr_81701_81725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (3))){
var state_81693__$1 = state_81693;
var statearr_81702_81726 = state_81693__$1;
(statearr_81702_81726[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_81702_81726[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (12))){
var inst_81682 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_81683 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81684 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_81685 = cljs.core.PersistentHashMap.fromArrays(inst_81683,inst_81684);
var inst_81686 = cljs.core.ex_info.call(null,inst_81682,inst_81685);
var inst_81687 = cljs.core.async.put_BANG_.call(null,pc,inst_81686);
var state_81693__$1 = state_81693;
var statearr_81703_81727 = state_81693__$1;
(statearr_81703_81727[(2)] = inst_81687);

(statearr_81703_81727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (2))){
var inst_81659 = (state_81693[(7)]);
var inst_81657 = (state_81693[(11)]);
var inst_81644 = (state_81693[(9)]);
var inst_81657__$1 = (state_81693[(2)]);
var inst_81658 = cljs.core.nth.call(null,inst_81657__$1,(0),null);
var inst_81659__$1 = cljs.core.nth.call(null,inst_81657__$1,(1),null);
var inst_81660 = cljs.core._EQ_.call(null,inst_81659__$1,inst_81644);
var state_81693__$1 = (function (){var statearr_81704 = state_81693;
(statearr_81704[(7)] = inst_81659__$1);

(statearr_81704[(12)] = inst_81658);

(statearr_81704[(11)] = inst_81657__$1);

return statearr_81704;
})();
if(inst_81660){
var statearr_81705_81728 = state_81693__$1;
(statearr_81705_81728[(1)] = (3));

} else {
var statearr_81706_81729 = state_81693__$1;
(statearr_81706_81729[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (11))){
var inst_81674 = (state_81693[(2)]);
var state_81693__$1 = state_81693;
var statearr_81707_81730 = state_81693__$1;
(statearr_81707_81730[(2)] = inst_81674);

(statearr_81707_81730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (9))){
var inst_81658 = (state_81693[(12)]);
var state_81693__$1 = state_81693;
var statearr_81708_81731 = state_81693__$1;
(statearr_81708_81731[(2)] = inst_81658);

(statearr_81708_81731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (5))){
var inst_81678 = (state_81693[(10)]);
var inst_81678__$1 = (state_81693[(2)]);
var inst_81679 = fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);
var inst_81680 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_81678__$1);
var state_81693__$1 = (function (){var statearr_81709 = state_81693;
(statearr_81709[(10)] = inst_81678__$1);

(statearr_81709[(13)] = inst_81679);

return statearr_81709;
})();
if(inst_81680){
var statearr_81710_81732 = state_81693__$1;
(statearr_81710_81732[(1)] = (12));

} else {
var statearr_81711_81733 = state_81693__$1;
(statearr_81711_81733[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (14))){
var inst_81691 = (state_81693[(2)]);
var state_81693__$1 = state_81693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81693__$1,inst_81691);
} else {
if((state_val_81694 === (10))){
var state_81693__$1 = state_81693;
var statearr_81712_81734 = state_81693__$1;
(statearr_81712_81734[(2)] = null);

(statearr_81712_81734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81694 === (8))){
var inst_81676 = (state_81693[(2)]);
var state_81693__$1 = state_81693;
var statearr_81713_81735 = state_81693__$1;
(statearr_81713_81735[(2)] = inst_81676);

(statearr_81713_81735[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0 = (function (){
var statearr_81714 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81714[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__);

(statearr_81714[(1)] = (1));

return statearr_81714;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1 = (function (state_81693){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81715){var ex__2749__auto__ = e81715;
var statearr_81716_81736 = state_81693;
(statearr_81716_81736[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81693[(4)]))){
var statearr_81717_81737 = state_81693;
(statearr_81717_81737[(1)] = cljs.core.first.call(null,(state_81693[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81738 = state_81693;
state_81693 = G__81738;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = function(state_81693){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1.call(this,state_81693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81718 = f__2769__auto__.call(null);
(statearr_81718[(6)] = c__2768__auto___81719);

return statearr_81718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__81740 = arguments.length;
switch (G__81740) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__81741){
var map__81742 = p__81741;
var map__81742__$1 = cljs.core.__destructure_map.call(null,map__81742);
var opts = map__81742__$1;
var roles = cljs.core.get.call(null,map__81742__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__81742__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__81742__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__81742__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__81742__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2768__auto___81831 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81793){
var state_val_81794 = (state_81793[(1)]);
if((state_val_81794 === (7))){
var inst_81755 = (state_81793[(7)]);
var inst_81757 = fluree.db.api.ledger.syncTo_db.call(null,inst_81755,syncTo,syncTimeout);
var state_81793__$1 = state_81793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81793__$1,(10),inst_81757);
} else {
if((state_val_81794 === (20))){
var inst_81779 = (state_81793[(8)]);
var state_81793__$1 = state_81793;
var statearr_81795_81832 = state_81793__$1;
(statearr_81795_81832[(2)] = inst_81779);

(statearr_81795_81832[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (1))){
var state_81793__$1 = state_81793;
var statearr_81796_81833 = state_81793__$1;
(statearr_81796_81833[(2)] = null);

(statearr_81796_81833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (4))){
var inst_81743 = (state_81793[(2)]);
var inst_81744 = cljs.core.async.put_BANG_.call(null,pc,inst_81743);
var inst_81745 = cljs.core.async.close_BANG_.call(null,pc);
var state_81793__$1 = (function (){var statearr_81797 = state_81793;
(statearr_81797[(9)] = inst_81744);

return statearr_81797;
})();
var statearr_81798_81834 = state_81793__$1;
(statearr_81798_81834[(2)] = inst_81745);

(statearr_81798_81834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (15))){
var inst_81771 = (state_81793[(10)]);
var inst_81773 = fluree.db.api.ledger.add_db_permissions.call(null,inst_81771,auth,roles);
var state_81793__$1 = state_81793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81793__$1,(18),inst_81773);
} else {
if((state_val_81794 === (21))){
var inst_81787 = (state_81793[(2)]);
var inst_81788 = cljs.core.async.put_BANG_.call(null,pc,inst_81787);
var _ = (function (){var statearr_81799 = state_81793;
(statearr_81799[(4)] = cljs.core.rest.call(null,(state_81793[(4)])));

return statearr_81799;
})();
var state_81793__$1 = state_81793;
var statearr_81800_81835 = state_81793__$1;
(statearr_81800_81835[(2)] = inst_81788);

(statearr_81800_81835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (13))){
var inst_81771 = (state_81793[(2)]);
var state_81793__$1 = (function (){var statearr_81801 = state_81793;
(statearr_81801[(10)] = inst_81771);

return statearr_81801;
})();
if(cljs.core.truth_(roles)){
var statearr_81802_81836 = state_81793__$1;
(statearr_81802_81836[(1)] = (15));

} else {
var statearr_81803_81837 = state_81793__$1;
(statearr_81803_81837[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (22))){
var inst_81783 = (state_81793[(2)]);
var inst_81784 = fluree.db.util.async.throw_err.call(null,inst_81783);
var state_81793__$1 = state_81793;
var statearr_81804_81838 = state_81793__$1;
(statearr_81804_81838[(2)] = inst_81784);

(statearr_81804_81838[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (6))){
var inst_81754 = (state_81793[(2)]);
var inst_81755 = fluree.db.util.async.throw_err.call(null,inst_81754);
var state_81793__$1 = (function (){var statearr_81805 = state_81793;
(statearr_81805[(7)] = inst_81755);

return statearr_81805;
})();
if(cljs.core.truth_(syncTo)){
var statearr_81806_81839 = state_81793__$1;
(statearr_81806_81839[(1)] = (7));

} else {
var statearr_81807_81840 = state_81793__$1;
(statearr_81807_81840[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (17))){
var inst_81779 = (state_81793[(2)]);
var state_81793__$1 = (function (){var statearr_81808 = state_81793;
(statearr_81808[(8)] = inst_81779);

return statearr_81808;
})();
if(cljs.core.truth_(auth)){
var statearr_81809_81841 = state_81793__$1;
(statearr_81809_81841[(1)] = (19));

} else {
var statearr_81810_81842 = state_81793__$1;
(statearr_81810_81842[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (3))){
var inst_81791 = (state_81793[(2)]);
var state_81793__$1 = state_81793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81793__$1,inst_81791);
} else {
if((state_val_81794 === (12))){
var inst_81763 = (state_81793[(11)]);
var state_81793__$1 = state_81793;
var statearr_81811_81843 = state_81793__$1;
(statearr_81811_81843[(2)] = inst_81763);

(statearr_81811_81843[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (2))){
var _ = (function (){var statearr_81812 = state_81793;
(statearr_81812[(4)] = cljs.core.cons.call(null,(5),(state_81793[(4)])));

return statearr_81812;
})();
var inst_81752 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_81793__$1 = state_81793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81793__$1,(6),inst_81752);
} else {
if((state_val_81794 === (19))){
var inst_81779 = (state_81793[(8)]);
var inst_81781 = fluree.db.api.ledger.add_db_permissions.call(null,inst_81779,auth,roles);
var state_81793__$1 = state_81793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81793__$1,(22),inst_81781);
} else {
if((state_val_81794 === (11))){
var inst_81763 = (state_81793[(11)]);
var inst_81765 = fluree.db.time_travel.as_of_block.call(null,inst_81763,block);
var state_81793__$1 = state_81793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81793__$1,(14),inst_81765);
} else {
if((state_val_81794 === (9))){
var inst_81763 = (state_81793[(2)]);
var state_81793__$1 = (function (){var statearr_81814 = state_81793;
(statearr_81814[(11)] = inst_81763);

return statearr_81814;
})();
if(cljs.core.truth_(block)){
var statearr_81815_81844 = state_81793__$1;
(statearr_81815_81844[(1)] = (11));

} else {
var statearr_81816_81845 = state_81793__$1;
(statearr_81816_81845[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (5))){
var _ = (function (){var statearr_81817 = state_81793;
(statearr_81817[(4)] = cljs.core.rest.call(null,(state_81793[(4)])));

return statearr_81817;
})();
var state_81793__$1 = state_81793;
var ex81813 = (state_81793__$1[(2)]);
var statearr_81818_81846 = state_81793__$1;
(statearr_81818_81846[(5)] = ex81813);


var statearr_81819_81847 = state_81793__$1;
(statearr_81819_81847[(1)] = (4));

(statearr_81819_81847[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (14))){
var inst_81767 = (state_81793[(2)]);
var inst_81768 = fluree.db.util.async.throw_err.call(null,inst_81767);
var state_81793__$1 = state_81793;
var statearr_81820_81848 = state_81793__$1;
(statearr_81820_81848[(2)] = inst_81768);

(statearr_81820_81848[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (16))){
var inst_81771 = (state_81793[(10)]);
var state_81793__$1 = state_81793;
var statearr_81821_81849 = state_81793__$1;
(statearr_81821_81849[(2)] = inst_81771);

(statearr_81821_81849[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (10))){
var inst_81759 = (state_81793[(2)]);
var inst_81760 = fluree.db.util.async.throw_err.call(null,inst_81759);
var state_81793__$1 = state_81793;
var statearr_81822_81850 = state_81793__$1;
(statearr_81822_81850[(2)] = inst_81760);

(statearr_81822_81850[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (18))){
var inst_81775 = (state_81793[(2)]);
var inst_81776 = fluree.db.util.async.throw_err.call(null,inst_81775);
var state_81793__$1 = state_81793;
var statearr_81823_81851 = state_81793__$1;
(statearr_81823_81851[(2)] = inst_81776);

(statearr_81823_81851[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81794 === (8))){
var inst_81755 = (state_81793[(7)]);
var state_81793__$1 = state_81793;
var statearr_81824_81852 = state_81793__$1;
(statearr_81824_81852[(2)] = inst_81755);

(statearr_81824_81852[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_81825 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81825[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_81825[(1)] = (1));

return statearr_81825;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_81793){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81826){var ex__2749__auto__ = e81826;
var statearr_81827_81853 = state_81793;
(statearr_81827_81853[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81793[(4)]))){
var statearr_81828_81854 = state_81793;
(statearr_81828_81854[(1)] = cljs.core.first.call(null,(state_81793[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81855 = state_81793;
state_81793 = G__81855;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_81793){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_81793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81829 = f__2769__auto__.call(null);
(statearr_81829[(6)] = c__2768__auto___81831);

return statearr_81829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

