// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__72802 = arguments.length;
switch (G__72802) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___72950 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72889){
var state_val_72890 = (state_72889[(1)]);
if((state_val_72890 === (7))){
var inst_72820 = (state_72889[(7)]);
var inst_72823 = cljs.core.not_EQ_.call(null,(0),inst_72820);
var state_72889__$1 = state_72889;
var statearr_72891_72951 = state_72889__$1;
(statearr_72891_72951[(2)] = inst_72823);

(statearr_72891_72951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (20))){
var inst_72815 = (state_72889[(8)]);
var inst_72844 = (state_72889[(9)]);
var inst_72848 = fluree.db.auth.roles.call(null,inst_72815,inst_72844);
var state_72889__$1 = state_72889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72889__$1,(23),inst_72848);
} else {
if((state_val_72890 === (27))){
var inst_72815 = (state_72889[(8)]);
var inst_72863 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_72864 = fluree.db.time_travel.as_of_block.call(null,inst_72815,inst_72863);
var state_72889__$1 = state_72889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72889__$1,(30),inst_72864);
} else {
if((state_val_72890 === (1))){
var state_72889__$1 = state_72889;
var statearr_72892_72952 = state_72889__$1;
(statearr_72892_72952[(2)] = null);

(statearr_72892_72952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (24))){
var inst_72856 = (state_72889[(10)]);
var inst_72815 = (state_72889[(8)]);
var inst_72858 = fluree.db.permissions.permission_map.call(null,inst_72815,inst_72856,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_72889__$1 = state_72889;
var statearr_72893_72953 = state_72889__$1;
(statearr_72893_72953[(2)] = inst_72858);

(statearr_72893_72953[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (4))){
var inst_72803 = (state_72889[(2)]);
var inst_72804 = cljs.core.async.put_BANG_.call(null,pc,inst_72803);
var inst_72805 = cljs.core.async.close_BANG_.call(null,pc);
var state_72889__$1 = (function (){var statearr_72894 = state_72889;
(statearr_72894[(11)] = inst_72804);

return statearr_72894;
})();
var statearr_72895_72954 = state_72889__$1;
(statearr_72895_72954[(2)] = inst_72805);

(statearr_72895_72954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (15))){
var inst_72820 = (state_72889[(7)]);
var inst_72834 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72820)," unknown."].join('');
var inst_72835 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72836 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_72837 = cljs.core.PersistentHashMap.fromArrays(inst_72835,inst_72836);
var inst_72838 = cljs.core.ex_info.call(null,inst_72834,inst_72837);
var inst_72839 = (function(){throw inst_72838})();
var state_72889__$1 = state_72889;
var statearr_72896_72955 = state_72889__$1;
(statearr_72896_72955[(2)] = inst_72839);

(statearr_72896_72955[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (21))){
var state_72889__$1 = state_72889;
var statearr_72897_72956 = state_72889__$1;
(statearr_72897_72956[(2)] = null);

(statearr_72897_72956[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (31))){
var inst_72870 = (state_72889[(12)]);
var inst_72820 = (state_72889[(7)]);
var inst_72872 = cljs.core.assoc.call(null,inst_72870,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_72820);
var state_72889__$1 = state_72889;
var statearr_72898_72957 = state_72889__$1;
(statearr_72898_72957[(2)] = inst_72872);

(statearr_72898_72957[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (32))){
var inst_72870 = (state_72889[(12)]);
var state_72889__$1 = state_72889;
var statearr_72899_72958 = state_72889__$1;
(statearr_72899_72958[(2)] = inst_72870);

(statearr_72899_72958[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (33))){
var inst_72856 = (state_72889[(10)]);
var inst_72875 = (state_72889[(2)]);
var state_72889__$1 = (function (){var statearr_72900 = state_72889;
(statearr_72900[(13)] = inst_72875);

return statearr_72900;
})();
if(cljs.core.truth_(inst_72856)){
var statearr_72901_72959 = state_72889__$1;
(statearr_72901_72959[(1)] = (34));

} else {
var statearr_72902_72960 = state_72889__$1;
(statearr_72902_72960[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (13))){
var inst_72831 = (state_72889[(14)]);
var inst_72830 = (state_72889[(2)]);
var inst_72831__$1 = fluree.db.util.async.throw_err.call(null,inst_72830);
var state_72889__$1 = (function (){var statearr_72903 = state_72889;
(statearr_72903[(14)] = inst_72831__$1);

return statearr_72903;
})();
if(cljs.core.truth_(inst_72831__$1)){
var statearr_72904_72961 = state_72889__$1;
(statearr_72904_72961[(1)] = (14));

} else {
var statearr_72905_72962 = state_72889__$1;
(statearr_72905_72962[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (22))){
var inst_72854 = (state_72889[(2)]);
var state_72889__$1 = state_72889;
var statearr_72906_72963 = state_72889__$1;
(statearr_72906_72963[(2)] = inst_72854);

(statearr_72906_72963[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (36))){
var inst_72883 = (state_72889[(2)]);
var inst_72884 = cljs.core.async.put_BANG_.call(null,pc,inst_72883);
var _ = (function (){var statearr_72907 = state_72889;
(statearr_72907[(4)] = cljs.core.rest.call(null,(state_72889[(4)])));

return statearr_72907;
})();
var state_72889__$1 = state_72889;
var statearr_72908_72964 = state_72889__$1;
(statearr_72908_72964[(2)] = inst_72884);

(statearr_72908_72964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (29))){
var inst_72820 = (state_72889[(7)]);
var inst_72870 = (state_72889[(2)]);
var state_72889__$1 = (function (){var statearr_72909 = state_72889;
(statearr_72909[(12)] = inst_72870);

return statearr_72909;
})();
if(cljs.core.truth_(inst_72820)){
var statearr_72910_72965 = state_72889__$1;
(statearr_72910_72965[(1)] = (31));

} else {
var statearr_72911_72966 = state_72889__$1;
(statearr_72911_72966[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (6))){
var inst_72820 = (state_72889[(7)]);
var inst_72814 = (state_72889[(2)]);
var inst_72815 = fluree.db.util.async.throw_err.call(null,inst_72814);
var inst_72816 = opts;
var inst_72817 = cljs.core.__destructure_map.call(null,inst_72816);
var inst_72818 = cljs.core.get.call(null,inst_72817,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_72819 = cljs.core.get.call(null,inst_72817,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_72820__$1 = cljs.core.get.call(null,inst_72817,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72821 = cljs.core.get.call(null,inst_72817,new cljs.core.Keyword(null,"block","block",664686210));
var state_72889__$1 = (function (){var statearr_72912 = state_72889;
(statearr_72912[(15)] = inst_72819);

(statearr_72912[(16)] = inst_72818);

(statearr_72912[(8)] = inst_72815);

(statearr_72912[(17)] = inst_72821);

(statearr_72912[(7)] = inst_72820__$1);

return statearr_72912;
})();
if(cljs.core.truth_(inst_72820__$1)){
var statearr_72913_72967 = state_72889__$1;
(statearr_72913_72967[(1)] = (7));

} else {
var statearr_72914_72968 = state_72889__$1;
(statearr_72914_72968[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (28))){
var inst_72815 = (state_72889[(8)]);
var state_72889__$1 = state_72889;
var statearr_72915_72969 = state_72889__$1;
(statearr_72915_72969[(2)] = inst_72815);

(statearr_72915_72969[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (25))){
var state_72889__$1 = state_72889;
var statearr_72916_72970 = state_72889__$1;
(statearr_72916_72970[(2)] = null);

(statearr_72916_72970[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (34))){
var inst_72861 = (state_72889[(18)]);
var state_72889__$1 = state_72889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72889__$1,(37),inst_72861);
} else {
if((state_val_72890 === (17))){
var inst_72818 = (state_72889[(16)]);
var state_72889__$1 = state_72889;
var statearr_72917_72971 = state_72889__$1;
(statearr_72917_72971[(2)] = inst_72818);

(statearr_72917_72971[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (3))){
var inst_72887 = (state_72889[(2)]);
var state_72889__$1 = state_72889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72889__$1,inst_72887);
} else {
if((state_val_72890 === (12))){
var inst_72818 = (state_72889[(16)]);
var inst_72844 = (state_72889[(2)]);
var state_72889__$1 = (function (){var statearr_72918 = state_72889;
(statearr_72918[(9)] = inst_72844);

return statearr_72918;
})();
if(cljs.core.truth_(inst_72818)){
var statearr_72919_72972 = state_72889__$1;
(statearr_72919_72972[(1)] = (17));

} else {
var statearr_72920_72973 = state_72889__$1;
(statearr_72920_72973[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (2))){
var _ = (function (){var statearr_72921 = state_72889;
(statearr_72921[(4)] = cljs.core.cons.call(null,(5),(state_72889[(4)])));

return statearr_72921;
})();
var inst_72812 = fluree.db.session.db.call(null,conn,ledger,null);
var state_72889__$1 = state_72889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72889__$1,(6),inst_72812);
} else {
if((state_val_72890 === (23))){
var inst_72850 = (state_72889[(2)]);
var inst_72851 = fluree.db.util.async.throw_err.call(null,inst_72850);
var state_72889__$1 = state_72889;
var statearr_72922_72974 = state_72889__$1;
(statearr_72922_72974[(2)] = inst_72851);

(statearr_72922_72974[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (35))){
var inst_72875 = (state_72889[(13)]);
var state_72889__$1 = state_72889;
var statearr_72923_72975 = state_72889__$1;
(statearr_72923_72975[(2)] = inst_72875);

(statearr_72923_72975[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (19))){
var inst_72856 = (state_72889[(10)]);
var inst_72856__$1 = (state_72889[(2)]);
var state_72889__$1 = (function (){var statearr_72924 = state_72889;
(statearr_72924[(10)] = inst_72856__$1);

return statearr_72924;
})();
if(cljs.core.truth_(inst_72856__$1)){
var statearr_72925_72976 = state_72889__$1;
(statearr_72925_72976[(1)] = (24));

} else {
var statearr_72926_72977 = state_72889__$1;
(statearr_72926_72977[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (11))){
var state_72889__$1 = state_72889;
var statearr_72928_72978 = state_72889__$1;
(statearr_72928_72978[(2)] = null);

(statearr_72928_72978[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (9))){
var inst_72826 = (state_72889[(2)]);
var state_72889__$1 = state_72889;
if(cljs.core.truth_(inst_72826)){
var statearr_72929_72979 = state_72889__$1;
(statearr_72929_72979[(1)] = (10));

} else {
var statearr_72930_72980 = state_72889__$1;
(statearr_72930_72980[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (5))){
var _ = (function (){var statearr_72931 = state_72889;
(statearr_72931[(4)] = cljs.core.rest.call(null,(state_72889[(4)])));

return statearr_72931;
})();
var state_72889__$1 = state_72889;
var ex72927 = (state_72889__$1[(2)]);
var statearr_72932_72981 = state_72889__$1;
(statearr_72932_72981[(5)] = ex72927);


var statearr_72933_72982 = state_72889__$1;
(statearr_72933_72982[(1)] = (4));

(statearr_72933_72982[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (14))){
var inst_72831 = (state_72889[(14)]);
var state_72889__$1 = state_72889;
var statearr_72934_72983 = state_72889__$1;
(statearr_72934_72983[(2)] = inst_72831);

(statearr_72934_72983[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (26))){
var inst_72821 = (state_72889[(17)]);
var inst_72861 = (state_72889[(2)]);
var state_72889__$1 = (function (){var statearr_72935 = state_72889;
(statearr_72935[(18)] = inst_72861);

return statearr_72935;
})();
if(cljs.core.truth_(inst_72821)){
var statearr_72936_72984 = state_72889__$1;
(statearr_72936_72984[(1)] = (27));

} else {
var statearr_72937_72985 = state_72889__$1;
(statearr_72937_72985[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (16))){
var inst_72841 = (state_72889[(2)]);
var state_72889__$1 = state_72889;
var statearr_72938_72986 = state_72889__$1;
(statearr_72938_72986[(2)] = inst_72841);

(statearr_72938_72986[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (30))){
var inst_72866 = (state_72889[(2)]);
var inst_72867 = fluree.db.util.async.throw_err.call(null,inst_72866);
var state_72889__$1 = state_72889;
var statearr_72939_72987 = state_72889__$1;
(statearr_72939_72987[(2)] = inst_72867);

(statearr_72939_72987[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (10))){
var inst_72815 = (state_72889[(8)]);
var inst_72820 = (state_72889[(7)]);
var inst_72828 = fluree.db.dbproto._subid.call(null,inst_72815,inst_72820);
var state_72889__$1 = state_72889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72889__$1,(13),inst_72828);
} else {
if((state_val_72890 === (18))){
var inst_72844 = (state_72889[(9)]);
var state_72889__$1 = state_72889;
if(cljs.core.truth_(inst_72844)){
var statearr_72940_72988 = state_72889__$1;
(statearr_72940_72988[(1)] = (20));

} else {
var statearr_72941_72989 = state_72889__$1;
(statearr_72941_72989[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (37))){
var inst_72875 = (state_72889[(13)]);
var inst_72878 = (state_72889[(2)]);
var inst_72879 = fluree.db.util.async.throw_err.call(null,inst_72878);
var inst_72880 = cljs.core.assoc.call(null,inst_72875,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_72879);
var state_72889__$1 = state_72889;
var statearr_72942_72990 = state_72889__$1;
(statearr_72942_72990[(2)] = inst_72880);

(statearr_72942_72990[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72890 === (8))){
var inst_72820 = (state_72889[(7)]);
var state_72889__$1 = state_72889;
var statearr_72943_72991 = state_72889__$1;
(statearr_72943_72991[(2)] = inst_72820);

(statearr_72943_72991[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2746__auto__ = null;
var fluree$db$api$query$state_machine__2746__auto____0 = (function (){
var statearr_72944 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72944[(0)] = fluree$db$api$query$state_machine__2746__auto__);

(statearr_72944[(1)] = (1));

return statearr_72944;
});
var fluree$db$api$query$state_machine__2746__auto____1 = (function (state_72889){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72945){var ex__2749__auto__ = e72945;
var statearr_72946_72992 = state_72889;
(statearr_72946_72992[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72889[(4)]))){
var statearr_72947_72993 = state_72889;
(statearr_72947_72993[(1)] = cljs.core.first.call(null,(state_72889[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72994 = state_72889;
state_72889 = G__72994;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2746__auto__ = function(state_72889){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2746__auto____1.call(this,state_72889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2746__auto____0;
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2746__auto____1;
return fluree$db$api$query$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72948 = f__2769__auto__.call(null);
(statearr_72948[(6)] = c__2768__auto___72950);

return statearr_72948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73135){
var state_val_73136 = (state_73135[(1)]);
if((state_val_73136 === (7))){
var inst_73015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73016 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73017 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73018 = [inst_73016,inst_73017];
var inst_73019 = (new cljs.core.PersistentVector(null,2,(5),inst_73015,inst_73018,null));
var state_73135__$1 = state_73135;
var statearr_73137_73207 = state_73135__$1;
(statearr_73137_73207[(2)] = inst_73019);

(statearr_73137_73207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (20))){
var inst_73045 = (state_73135[(7)]);
var state_73135__$1 = state_73135;
var statearr_73138_73208 = state_73135__$1;
(statearr_73138_73208[(2)] = inst_73045);

(statearr_73138_73208[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (27))){
var state_73135__$1 = state_73135;
var statearr_73139_73209 = state_73135__$1;
(statearr_73139_73209[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (1))){
var state_73135__$1 = state_73135;
var statearr_73141_73210 = state_73135__$1;
(statearr_73141_73210[(2)] = null);

(statearr_73141_73210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (24))){
var inst_73044 = (state_73135[(8)]);
var state_73135__$1 = state_73135;
if(cljs.core.truth_(inst_73044)){
var statearr_73142_73211 = state_73135__$1;
(statearr_73142_73211[(1)] = (26));

} else {
var statearr_73143_73212 = state_73135__$1;
(statearr_73143_73212[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (39))){
var inst_73090 = (state_73135[(9)]);
var inst_73091 = (state_73135[(10)]);
var inst_73116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73117 = [inst_73090,inst_73091];
var inst_73118 = (new cljs.core.PersistentVector(null,2,(5),inst_73116,inst_73117,null));
var state_73135__$1 = state_73135;
var statearr_73144_73213 = state_73135__$1;
(statearr_73144_73213[(2)] = inst_73118);

(statearr_73144_73213[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (4))){
var inst_72995 = (state_73135[(2)]);
var state_73135__$1 = state_73135;
var statearr_73145_73214 = state_73135__$1;
(statearr_73145_73214[(2)] = inst_72995);

(statearr_73145_73214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (15))){
var inst_73024 = (state_73135[(11)]);
var inst_73029 = (state_73135[(12)]);
var inst_73038 = (state_73135[(2)]);
var inst_73039 = [inst_73029,inst_73038];
var inst_73040 = (new cljs.core.PersistentVector(null,2,(5),inst_73024,inst_73039,null));
var state_73135__$1 = state_73135;
var statearr_73146_73215 = state_73135__$1;
(statearr_73146_73215[(2)] = inst_73040);

(statearr_73146_73215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (21))){
var inst_73044 = (state_73135[(8)]);
var state_73135__$1 = state_73135;
var statearr_73147_73216 = state_73135__$1;
(statearr_73147_73216[(2)] = inst_73044);

(statearr_73147_73216[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (31))){
var inst_73085 = (state_73135[(2)]);
var state_73135__$1 = state_73135;
var statearr_73148_73217 = state_73135__$1;
(statearr_73148_73217[(2)] = inst_73085);

(statearr_73148_73217[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (32))){
var inst_73091 = (state_73135[(10)]);
var inst_73094 = cljs.core.pos_int_QMARK_.call(null,inst_73091);
var state_73135__$1 = state_73135;
var statearr_73149_73218 = state_73135__$1;
(statearr_73149_73218[(2)] = inst_73094);

(statearr_73149_73218[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (40))){
var inst_73046 = (state_73135[(13)]);
var inst_73122 = (state_73135[(14)]);
var inst_73120 = (state_73135[(2)]);
var inst_73121 = cljs.core.nth.call(null,inst_73120,(0),null);
var inst_73122__$1 = cljs.core.nth.call(null,inst_73120,(1),null);
var inst_73123 = (inst_73122__$1 > inst_73046);
var state_73135__$1 = (function (){var statearr_73150 = state_73135;
(statearr_73150[(15)] = inst_73121);

(statearr_73150[(14)] = inst_73122__$1);

return statearr_73150;
})();
if(cljs.core.truth_(inst_73123)){
var statearr_73151_73219 = state_73135__$1;
(statearr_73151_73219[(1)] = (41));

} else {
var statearr_73152_73220 = state_73135__$1;
(statearr_73152_73220[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (33))){
var inst_73092 = (state_73135[(16)]);
var state_73135__$1 = state_73135;
var statearr_73153_73221 = state_73135__$1;
(statearr_73153_73221[(2)] = inst_73092);

(statearr_73153_73221[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (13))){
var inst_73030 = (state_73135[(17)]);
var inst_73032 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73030);
var state_73135__$1 = state_73135;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73135__$1,(16),inst_73032);
} else {
if((state_val_73136 === (22))){
var inst_73063 = (state_73135[(2)]);
var state_73135__$1 = state_73135;
if(cljs.core.truth_(inst_73063)){
var statearr_73154_73222 = state_73135__$1;
(statearr_73154_73222[(1)] = (23));

} else {
var statearr_73155_73223 = state_73135__$1;
(statearr_73155_73223[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (36))){
var state_73135__$1 = state_73135;
var statearr_73156_73224 = state_73135__$1;
(statearr_73156_73224[(2)] = null);

(statearr_73156_73224[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (41))){
var inst_73046 = (state_73135[(13)]);
var state_73135__$1 = state_73135;
var statearr_73157_73225 = state_73135__$1;
(statearr_73157_73225[(2)] = inst_73046);

(statearr_73157_73225[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (43))){
var inst_73121 = (state_73135[(15)]);
var inst_73127 = (state_73135[(2)]);
var inst_73128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73129 = [inst_73121,inst_73127];
var inst_73130 = (new cljs.core.PersistentVector(null,2,(5),inst_73128,inst_73129,null));
var _ = (function (){var statearr_73158 = state_73135;
(statearr_73158[(4)] = cljs.core.rest.call(null,(state_73135[(4)])));

return statearr_73158;
})();
var state_73135__$1 = state_73135;
var statearr_73159_73226 = state_73135__$1;
(statearr_73159_73226[(2)] = inst_73130);

(statearr_73159_73226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (29))){
var inst_73021 = (state_73135[(18)]);
var inst_73076 = cljs.core.pr_str.call(null,inst_73021);
var inst_73077 = ["Invalid block range provided: ",inst_73076].join('');
var inst_73078 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73079 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73080 = cljs.core.PersistentHashMap.fromArrays(inst_73078,inst_73079);
var inst_73081 = cljs.core.ex_info.call(null,inst_73077,inst_73080);
var inst_73082 = (function(){throw inst_73081})();
var state_73135__$1 = state_73135;
var statearr_73160_73227 = state_73135__$1;
(statearr_73160_73227[(2)] = inst_73082);

(statearr_73160_73227[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (6))){
var inst_73013 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_73135__$1 = state_73135;
var statearr_73161_73228 = state_73135__$1;
(statearr_73161_73228[(2)] = inst_73013);

(statearr_73161_73228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (28))){
var inst_73087 = (state_73135[(2)]);
var state_73135__$1 = state_73135;
var statearr_73162_73229 = state_73135__$1;
(statearr_73162_73229[(2)] = inst_73087);

(statearr_73162_73229[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (25))){
var inst_73092 = (state_73135[(16)]);
var inst_73090 = (state_73135[(9)]);
var inst_73089 = (state_73135[(2)]);
var inst_73090__$1 = cljs.core.nth.call(null,inst_73089,(0),null);
var inst_73091 = cljs.core.nth.call(null,inst_73089,(1),null);
var inst_73092__$1 = cljs.core.pos_int_QMARK_.call(null,inst_73090__$1);
var state_73135__$1 = (function (){var statearr_73163 = state_73135;
(statearr_73163[(16)] = inst_73092__$1);

(statearr_73163[(9)] = inst_73090__$1);

(statearr_73163[(10)] = inst_73091);

return statearr_73163;
})();
if(inst_73092__$1){
var statearr_73164_73230 = state_73135__$1;
(statearr_73164_73230[(1)] = (32));

} else {
var statearr_73165_73231 = state_73135__$1;
(statearr_73165_73231[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (34))){
var inst_73097 = (state_73135[(2)]);
var inst_73098 = cljs.core.not.call(null,inst_73097);
var state_73135__$1 = state_73135;
if(inst_73098){
var statearr_73166_73232 = state_73135__$1;
(statearr_73166_73232[(1)] = (35));

} else {
var statearr_73167_73233 = state_73135__$1;
(statearr_73167_73233[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (17))){
var inst_73046 = (state_73135[(13)]);
var inst_73044 = (state_73135[(8)]);
var inst_73049 = cljs.core.pr_str.call(null,inst_73044);
var inst_73050 = cljs.core.pr_str.call(null,inst_73046);
var inst_73051 = ["Start block is out of range for this ledger. Start block provided: ",inst_73049,". Database block: ",inst_73050].join('');
var inst_73052 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73053 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73054 = cljs.core.PersistentHashMap.fromArrays(inst_73052,inst_73053);
var inst_73055 = cljs.core.ex_info.call(null,inst_73051,inst_73054);
var inst_73056 = (function(){throw inst_73055})();
var state_73135__$1 = state_73135;
var statearr_73168_73234 = state_73135__$1;
(statearr_73168_73234[(2)] = inst_73056);

(statearr_73168_73234[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (3))){
var inst_73133 = (state_73135[(2)]);
var state_73135__$1 = state_73135;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73135__$1,inst_73133);
} else {
if((state_val_73136 === (12))){
var inst_73030 = (state_73135[(17)]);
var inst_73021 = (state_73135[(18)]);
var inst_73028 = (state_73135[(2)]);
var inst_73029 = fluree.db.util.async.throw_err.call(null,inst_73028);
var inst_73030__$1 = cljs.core.second.call(null,inst_73021);
var state_73135__$1 = (function (){var statearr_73169 = state_73135;
(statearr_73169[(17)] = inst_73030__$1);

(statearr_73169[(12)] = inst_73029);

return statearr_73169;
})();
if(cljs.core.truth_(inst_73030__$1)){
var statearr_73170_73235 = state_73135__$1;
(statearr_73170_73235[(1)] = (13));

} else {
var statearr_73171_73236 = state_73135__$1;
(statearr_73171_73236[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (2))){
var _ = (function (){var statearr_73172 = state_73135;
(statearr_73172[(4)] = cljs.core.cons.call(null,(5),(state_73135[(4)])));

return statearr_73172;
})();
var inst_73010 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73011 = cljs.core.sequential_QMARK_.call(null,inst_73010);
var state_73135__$1 = state_73135;
if(inst_73011){
var statearr_73173_73237 = state_73135__$1;
(statearr_73173_73237[(1)] = (6));

} else {
var statearr_73174_73238 = state_73135__$1;
(statearr_73174_73238[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (23))){
var inst_73044 = (state_73135[(8)]);
var inst_73045 = (state_73135[(7)]);
var inst_73065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73066 = [inst_73044,inst_73045];
var inst_73067 = (new cljs.core.PersistentVector(null,2,(5),inst_73065,inst_73066,null));
var state_73135__$1 = state_73135;
var statearr_73175_73239 = state_73135__$1;
(statearr_73175_73239[(2)] = inst_73067);

(statearr_73175_73239[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (35))){
var inst_73021 = (state_73135[(18)]);
var inst_73100 = cljs.core.pr_str.call(null,inst_73021);
var inst_73101 = ["Invalid block range provided: ",inst_73100].join('');
var inst_73102 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73103 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73104 = cljs.core.PersistentHashMap.fromArrays(inst_73102,inst_73103);
var inst_73105 = cljs.core.ex_info.call(null,inst_73101,inst_73104);
var inst_73106 = (function(){throw inst_73105})();
var state_73135__$1 = state_73135;
var statearr_73176_73240 = state_73135__$1;
(statearr_73176_73240[(2)] = inst_73106);

(statearr_73176_73240[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (19))){
var inst_73044 = (state_73135[(8)]);
var inst_73059 = (state_73135[(2)]);
var state_73135__$1 = (function (){var statearr_73177 = state_73135;
(statearr_73177[(19)] = inst_73059);

return statearr_73177;
})();
if(cljs.core.truth_(inst_73044)){
var statearr_73178_73241 = state_73135__$1;
(statearr_73178_73241[(1)] = (20));

} else {
var statearr_73179_73242 = state_73135__$1;
(statearr_73179_73242[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (11))){
var inst_73046 = (state_73135[(13)]);
var inst_73044 = (state_73135[(8)]);
var inst_73043 = (state_73135[(2)]);
var inst_73044__$1 = cljs.core.nth.call(null,inst_73043,(0),null);
var inst_73045 = cljs.core.nth.call(null,inst_73043,(1),null);
var inst_73046__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73047 = (inst_73044__$1 > inst_73046__$1);
var state_73135__$1 = (function (){var statearr_73181 = state_73135;
(statearr_73181[(13)] = inst_73046__$1);

(statearr_73181[(8)] = inst_73044__$1);

(statearr_73181[(7)] = inst_73045);

return statearr_73181;
})();
if(cljs.core.truth_(inst_73047)){
var statearr_73182_73243 = state_73135__$1;
(statearr_73182_73243[(1)] = (17));

} else {
var statearr_73183_73244 = state_73135__$1;
(statearr_73183_73244[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (9))){
var inst_73021 = (state_73135[(18)]);
var inst_73024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73025 = cljs.core.first.call(null,inst_73021);
var inst_73026 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73025);
var state_73135__$1 = (function (){var statearr_73184 = state_73135;
(statearr_73184[(11)] = inst_73024);

return statearr_73184;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73135__$1,(12),inst_73026);
} else {
if((state_val_73136 === (5))){
var _ = (function (){var statearr_73185 = state_73135;
(statearr_73185[(4)] = cljs.core.rest.call(null,(state_73135[(4)])));

return statearr_73185;
})();
var state_73135__$1 = state_73135;
var ex73180 = (state_73135__$1[(2)]);
var statearr_73186_73245 = state_73135__$1;
(statearr_73186_73245[(5)] = ex73180);


if((ex73180 instanceof Error)){
var statearr_73187_73246 = state_73135__$1;
(statearr_73187_73246[(1)] = (4));

(statearr_73187_73246[(5)] = null);

} else {
throw ex73180;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (14))){
var state_73135__$1 = state_73135;
var statearr_73188_73247 = state_73135__$1;
(statearr_73188_73247[(2)] = null);

(statearr_73188_73247[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (26))){
var inst_73044 = (state_73135[(8)]);
var inst_73070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73071 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73072 = [inst_73044,inst_73071];
var inst_73073 = (new cljs.core.PersistentVector(null,2,(5),inst_73070,inst_73072,null));
var state_73135__$1 = state_73135;
var statearr_73189_73248 = state_73135__$1;
(statearr_73189_73248[(2)] = inst_73073);

(statearr_73189_73248[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (16))){
var inst_73034 = (state_73135[(2)]);
var inst_73035 = fluree.db.util.async.throw_err.call(null,inst_73034);
var state_73135__$1 = state_73135;
var statearr_73190_73249 = state_73135__$1;
(statearr_73190_73249[(2)] = inst_73035);

(statearr_73190_73249[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (38))){
var inst_73090 = (state_73135[(9)]);
var inst_73091 = (state_73135[(10)]);
var inst_73112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73113 = [inst_73091,inst_73090];
var inst_73114 = (new cljs.core.PersistentVector(null,2,(5),inst_73112,inst_73113,null));
var state_73135__$1 = state_73135;
var statearr_73191_73250 = state_73135__$1;
(statearr_73191_73250[(2)] = inst_73114);

(statearr_73191_73250[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (30))){
var state_73135__$1 = state_73135;
var statearr_73192_73251 = state_73135__$1;
(statearr_73192_73251[(2)] = null);

(statearr_73192_73251[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (10))){
var inst_73021 = (state_73135[(18)]);
var state_73135__$1 = state_73135;
var statearr_73193_73252 = state_73135__$1;
(statearr_73193_73252[(2)] = inst_73021);

(statearr_73193_73252[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (18))){
var state_73135__$1 = state_73135;
var statearr_73194_73253 = state_73135__$1;
(statearr_73194_73253[(2)] = null);

(statearr_73194_73253[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (42))){
var inst_73122 = (state_73135[(14)]);
var state_73135__$1 = state_73135;
var statearr_73195_73254 = state_73135__$1;
(statearr_73195_73254[(2)] = inst_73122);

(statearr_73195_73254[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (37))){
var inst_73090 = (state_73135[(9)]);
var inst_73091 = (state_73135[(10)]);
var inst_73109 = (state_73135[(2)]);
var inst_73110 = (inst_73091 < inst_73090);
var state_73135__$1 = (function (){var statearr_73196 = state_73135;
(statearr_73196[(20)] = inst_73109);

return statearr_73196;
})();
if(cljs.core.truth_(inst_73110)){
var statearr_73197_73255 = state_73135__$1;
(statearr_73197_73255[(1)] = (38));

} else {
var statearr_73198_73256 = state_73135__$1;
(statearr_73198_73256[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73136 === (8))){
var inst_73021 = (state_73135[(18)]);
var inst_73021__$1 = (state_73135[(2)]);
var inst_73022 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_73021__$1);
var state_73135__$1 = (function (){var statearr_73199 = state_73135;
(statearr_73199[(18)] = inst_73021__$1);

return statearr_73199;
})();
if(cljs.core.truth_(inst_73022)){
var statearr_73200_73257 = state_73135__$1;
(statearr_73200_73257[(1)] = (9));

} else {
var statearr_73201_73258 = state_73135__$1;
(statearr_73201_73258[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_73202 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73202[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__);

(statearr_73202[(1)] = (1));

return statearr_73202;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_73135){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73135);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73203){var ex__2749__auto__ = e73203;
var statearr_73204_73259 = state_73135;
(statearr_73204_73259[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73135[(4)]))){
var statearr_73205_73260 = state_73135;
(statearr_73205_73260[(1)] = cljs.core.first.call(null,(state_73135[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73261 = state_73135;
state_73135 = G__73261;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = function(state_73135){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_73135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73206 = f__2769__auto__.call(null);
(statearr_73206[(6)] = c__2768__auto__);

return statearr_73206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73411){
var state_val_73412 = (state_73411[(1)]);
if((state_val_73412 === (7))){
var inst_73323 = (state_73411[(2)]);
var inst_73324 = cljs.core.nth.call(null,inst_73323,(0),null);
var inst_73325 = cljs.core.nth.call(null,inst_73323,(1),null);
var inst_73333 = cljs.core.vals.call(null,inst_73325);
var inst_73334 = cljs.core.seq.call(null,inst_73333);
var inst_73335 = cljs.core.first.call(null,inst_73334);
var inst_73336 = cljs.core.next.call(null,inst_73334);
var inst_73337 = cljs.core.PersistentVector.EMPTY;
var inst_73338 = inst_73333;
var inst_73339 = inst_73337;
var state_73411__$1 = (function (){var statearr_73413 = state_73411;
(statearr_73413[(7)] = inst_73338);

(statearr_73413[(8)] = inst_73339);

(statearr_73413[(9)] = inst_73324);

(statearr_73413[(10)] = inst_73336);

(statearr_73413[(11)] = inst_73335);

return statearr_73413;
})();
var statearr_73414_73467 = state_73411__$1;
(statearr_73414_73467[(2)] = null);

(statearr_73414_73467[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (20))){
var inst_73345 = (state_73411[(12)]);
var inst_73350 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_73351 = cljs.core.PersistentHashMap.EMPTY;
var inst_73352 = [true,inst_73351];
var inst_73353 = cljs.core.PersistentHashMap.fromArrays(inst_73350,inst_73352);
var inst_73354 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_73353,inst_73345);
var state_73411__$1 = state_73411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73411__$1,(22),inst_73354);
} else {
if((state_val_73412 === (27))){
var inst_73399 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73415_73468 = state_73411__$1;
(statearr_73415_73468[(2)] = inst_73399);

(statearr_73415_73468[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (1))){
var state_73411__$1 = state_73411;
var statearr_73416_73469 = state_73411__$1;
(statearr_73416_73469[(2)] = null);

(statearr_73416_73469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (24))){
var inst_73363 = (state_73411[(13)]);
var inst_73401 = (state_73411[(2)]);
var inst_73402 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_73403 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_73404 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_73405 = [inst_73403,inst_73404,inst_73363,inst_73401];
var inst_73406 = cljs.core.PersistentHashMap.fromArrays(inst_73402,inst_73405);
var _ = (function (){var statearr_73418 = state_73411;
(statearr_73418[(4)] = cljs.core.rest.call(null,(state_73411[(4)])));

return statearr_73418;
})();
var state_73411__$1 = state_73411;
var statearr_73419_73470 = state_73411__$1;
(statearr_73419_73470[(2)] = inst_73406);

(statearr_73419_73470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (4))){
var inst_73264 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73420_73471 = state_73411__$1;
(statearr_73420_73471[(2)] = inst_73264);

(statearr_73420_73471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (15))){
var inst_73309 = (state_73411[(14)]);
var inst_73283 = (state_73411[(15)]);
var inst_73302 = (state_73411[(16)]);
var inst_73280 = (state_73411[(17)]);
var inst_73304 = (state_73411[(18)]);
var inst_73287 = (state_73411[(19)]);
var inst_73286 = (state_73411[(20)]);
var inst_73282 = (state_73411[(21)]);
var inst_73295 = (state_73411[(22)]);
var inst_73288 = (state_73411[(23)]);
var inst_73294 = (state_73411[(24)]);
var inst_73315 = (function (){var subject = inst_73302;
var flake = inst_73294;
var seq__73291 = inst_73295;
var r = inst_73295;
var vec__73290 = inst_73286;
var asserted_subjects = inst_73287;
var first__73292 = inst_73294;
var flake_SINGLEQUOTE_ = inst_73309;
var retracted_subjects = inst_73288;
var vec__73277 = inst_73280;
var asserted_QMARK_ = inst_73304;
var seq__73278 = inst_73283;
var first__73279 = inst_73282;
var G__73276 = inst_73286;
return (function (p1__73263_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__73263_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_73316 = cljs.core.update.call(null,inst_73288,inst_73302,inst_73315);
var tmp73417 = inst_73287;
var inst_73286__$1 = inst_73295;
var inst_73287__$1 = tmp73417;
var inst_73288__$1 = inst_73316;
var state_73411__$1 = (function (){var statearr_73421 = state_73411;
(statearr_73421[(19)] = inst_73287__$1);

(statearr_73421[(20)] = inst_73286__$1);

(statearr_73421[(23)] = inst_73288__$1);

return statearr_73421;
})();
var statearr_73422_73472 = state_73411__$1;
(statearr_73422_73472[(2)] = null);

(statearr_73422_73472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (21))){
var inst_73361 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73423_73473 = state_73411__$1;
(statearr_73423_73473[(2)] = inst_73361);

(statearr_73423_73473[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (13))){
var inst_73304 = (state_73411[(18)]);
var inst_73309 = (state_73411[(2)]);
var state_73411__$1 = (function (){var statearr_73424 = state_73411;
(statearr_73424[(14)] = inst_73309);

return statearr_73424;
})();
if(cljs.core.truth_(inst_73304)){
var statearr_73425_73474 = state_73411__$1;
(statearr_73425_73474[(1)] = (14));

} else {
var statearr_73426_73475 = state_73411__$1;
(statearr_73426_73475[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (22))){
var inst_73339 = (state_73411[(8)]);
var inst_73346 = (state_73411[(25)]);
var inst_73356 = (state_73411[(2)]);
var inst_73357 = fluree.db.util.async.throw_err.call(null,inst_73356);
var inst_73358 = cljs.core.conj.call(null,inst_73339,inst_73357);
var inst_73338 = inst_73346;
var inst_73339__$1 = inst_73358;
var state_73411__$1 = (function (){var statearr_73427 = state_73411;
(statearr_73427[(7)] = inst_73338);

(statearr_73427[(8)] = inst_73339__$1);

return statearr_73427;
})();
var statearr_73428_73476 = state_73411__$1;
(statearr_73428_73476[(2)] = null);

(statearr_73428_73476[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (6))){
var inst_73286 = (state_73411[(20)]);
var inst_73294 = (state_73411[(24)]);
var inst_73293 = cljs.core.seq.call(null,inst_73286);
var inst_73294__$1 = cljs.core.first.call(null,inst_73293);
var inst_73295 = cljs.core.next.call(null,inst_73293);
var inst_73296 = cljs.core.not.call(null,inst_73294__$1);
var state_73411__$1 = (function (){var statearr_73429 = state_73411;
(statearr_73429[(22)] = inst_73295);

(statearr_73429[(24)] = inst_73294__$1);

return statearr_73429;
})();
if(inst_73296){
var statearr_73430_73477 = state_73411__$1;
(statearr_73430_73477[(1)] = (8));

} else {
var statearr_73431_73478 = state_73411__$1;
(statearr_73431_73478[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (28))){
var inst_73377 = (state_73411[(26)]);
var inst_73384 = (state_73411[(27)]);
var inst_73394 = (state_73411[(2)]);
var inst_73395 = fluree.db.util.async.throw_err.call(null,inst_73394);
var inst_73396 = cljs.core.conj.call(null,inst_73377,inst_73395);
var inst_73376 = inst_73384;
var inst_73377__$1 = inst_73396;
var state_73411__$1 = (function (){var statearr_73432 = state_73411;
(statearr_73432[(26)] = inst_73377__$1);

(statearr_73432[(28)] = inst_73376);

return statearr_73432;
})();
var statearr_73433_73479 = state_73411__$1;
(statearr_73433_73479[(2)] = null);

(statearr_73433_73479[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (25))){
var inst_73377 = (state_73411[(26)]);
var state_73411__$1 = state_73411;
var statearr_73434_73480 = state_73411__$1;
(statearr_73434_73480[(2)] = inst_73377);

(statearr_73434_73480[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (17))){
var inst_73338 = (state_73411[(7)]);
var inst_73345 = (state_73411[(12)]);
var inst_73344 = cljs.core.seq.call(null,inst_73338);
var inst_73345__$1 = cljs.core.first.call(null,inst_73344);
var inst_73346 = cljs.core.next.call(null,inst_73344);
var inst_73347 = cljs.core.not.call(null,inst_73345__$1);
var state_73411__$1 = (function (){var statearr_73435 = state_73411;
(statearr_73435[(25)] = inst_73346);

(statearr_73435[(12)] = inst_73345__$1);

return statearr_73435;
})();
if(inst_73347){
var statearr_73436_73481 = state_73411__$1;
(statearr_73436_73481[(1)] = (19));

} else {
var statearr_73437_73482 = state_73411__$1;
(statearr_73437_73482[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (3))){
var inst_73409 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73411__$1,inst_73409);
} else {
if((state_val_73412 === (12))){
var inst_73294 = (state_73411[(24)]);
var inst_73307 = fluree.db.flake.flip_flake.call(null,inst_73294);
var state_73411__$1 = state_73411;
var statearr_73438_73483 = state_73411__$1;
(statearr_73438_73483[(2)] = inst_73307);

(statearr_73438_73483[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (2))){
var inst_73280 = (state_73411[(17)]);
var _ = (function (){var statearr_73439 = state_73411;
(statearr_73439[(4)] = cljs.core.cons.call(null,(5),(state_73411[(4)])));

return statearr_73439;
})();
var inst_73280__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_73281 = cljs.core.seq.call(null,inst_73280__$1);
var inst_73282 = cljs.core.first.call(null,inst_73281);
var inst_73283 = cljs.core.next.call(null,inst_73281);
var inst_73284 = cljs.core.PersistentHashMap.EMPTY;
var inst_73285 = cljs.core.PersistentHashMap.EMPTY;
var inst_73286 = inst_73280__$1;
var inst_73287 = inst_73284;
var inst_73288 = inst_73285;
var state_73411__$1 = (function (){var statearr_73440 = state_73411;
(statearr_73440[(15)] = inst_73283);

(statearr_73440[(17)] = inst_73280__$1);

(statearr_73440[(19)] = inst_73287);

(statearr_73440[(20)] = inst_73286);

(statearr_73440[(21)] = inst_73282);

(statearr_73440[(23)] = inst_73288);

return statearr_73440;
})();
var statearr_73441_73484 = state_73411__$1;
(statearr_73441_73484[(2)] = null);

(statearr_73441_73484[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (23))){
var inst_73383 = (state_73411[(29)]);
var inst_73376 = (state_73411[(28)]);
var inst_73382 = cljs.core.seq.call(null,inst_73376);
var inst_73383__$1 = cljs.core.first.call(null,inst_73382);
var inst_73384 = cljs.core.next.call(null,inst_73382);
var inst_73385 = cljs.core.not.call(null,inst_73383__$1);
var state_73411__$1 = (function (){var statearr_73442 = state_73411;
(statearr_73442[(29)] = inst_73383__$1);

(statearr_73442[(27)] = inst_73384);

return statearr_73442;
})();
if(inst_73385){
var statearr_73443_73485 = state_73411__$1;
(statearr_73443_73485[(1)] = (25));

} else {
var statearr_73444_73486 = state_73411__$1;
(statearr_73444_73486[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (19))){
var inst_73339 = (state_73411[(8)]);
var state_73411__$1 = state_73411;
var statearr_73445_73487 = state_73411__$1;
(statearr_73445_73487[(2)] = inst_73339);

(statearr_73445_73487[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (11))){
var inst_73294 = (state_73411[(24)]);
var state_73411__$1 = state_73411;
var statearr_73447_73488 = state_73411__$1;
(statearr_73447_73488[(2)] = inst_73294);

(statearr_73447_73488[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (9))){
var inst_73304 = (state_73411[(18)]);
var inst_73294 = (state_73411[(24)]);
var inst_73302 = fluree.db.flake.s.call(null,inst_73294);
var inst_73303 = fluree.db.flake.op.call(null,inst_73294);
var inst_73304__$1 = inst_73303 === true;
var state_73411__$1 = (function (){var statearr_73449 = state_73411;
(statearr_73449[(16)] = inst_73302);

(statearr_73449[(18)] = inst_73304__$1);

return statearr_73449;
})();
if(cljs.core.truth_(inst_73304__$1)){
var statearr_73450_73489 = state_73411__$1;
(statearr_73450_73489[(1)] = (11));

} else {
var statearr_73451_73490 = state_73411__$1;
(statearr_73451_73490[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (5))){
var _ = (function (){var statearr_73452 = state_73411;
(statearr_73452[(4)] = cljs.core.rest.call(null,(state_73411[(4)])));

return statearr_73452;
})();
var state_73411__$1 = state_73411;
var ex73446 = (state_73411__$1[(2)]);
var statearr_73453_73491 = state_73411__$1;
(statearr_73453_73491[(5)] = ex73446);


if((ex73446 instanceof Error)){
var statearr_73454_73492 = state_73411__$1;
(statearr_73454_73492[(1)] = (4));

(statearr_73454_73492[(5)] = null);

} else {
throw ex73446;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (14))){
var inst_73309 = (state_73411[(14)]);
var inst_73283 = (state_73411[(15)]);
var inst_73302 = (state_73411[(16)]);
var inst_73280 = (state_73411[(17)]);
var inst_73304 = (state_73411[(18)]);
var inst_73287 = (state_73411[(19)]);
var inst_73286 = (state_73411[(20)]);
var inst_73282 = (state_73411[(21)]);
var inst_73295 = (state_73411[(22)]);
var inst_73288 = (state_73411[(23)]);
var inst_73294 = (state_73411[(24)]);
var inst_73311 = (function (){var subject = inst_73302;
var flake = inst_73294;
var seq__73291 = inst_73295;
var r = inst_73295;
var vec__73290 = inst_73286;
var asserted_subjects = inst_73287;
var first__73292 = inst_73294;
var flake_SINGLEQUOTE_ = inst_73309;
var retracted_subjects = inst_73288;
var vec__73277 = inst_73280;
var asserted_QMARK_ = inst_73304;
var seq__73278 = inst_73283;
var first__73279 = inst_73282;
var G__73276 = inst_73286;
return (function (p1__73262_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__73262_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_73312 = cljs.core.update.call(null,inst_73287,inst_73302,inst_73311);
var tmp73448 = inst_73288;
var inst_73286__$1 = inst_73295;
var inst_73287__$1 = inst_73312;
var inst_73288__$1 = tmp73448;
var state_73411__$1 = (function (){var statearr_73455 = state_73411;
(statearr_73455[(19)] = inst_73287__$1);

(statearr_73455[(20)] = inst_73286__$1);

(statearr_73455[(23)] = inst_73288__$1);

return statearr_73455;
})();
var statearr_73456_73493 = state_73411__$1;
(statearr_73456_73493[(2)] = null);

(statearr_73456_73493[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (26))){
var inst_73383 = (state_73411[(29)]);
var inst_73388 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_73389 = cljs.core.PersistentHashMap.EMPTY;
var inst_73390 = [true,inst_73389];
var inst_73391 = cljs.core.PersistentHashMap.fromArrays(inst_73388,inst_73390);
var inst_73392 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_73391,inst_73383);
var state_73411__$1 = state_73411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73411__$1,(28),inst_73392);
} else {
if((state_val_73412 === (16))){
var inst_73319 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73457_73494 = state_73411__$1;
(statearr_73457_73494[(2)] = inst_73319);

(statearr_73457_73494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (10))){
var inst_73321 = (state_73411[(2)]);
var state_73411__$1 = state_73411;
var statearr_73458_73495 = state_73411__$1;
(statearr_73458_73495[(2)] = inst_73321);

(statearr_73458_73495[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (18))){
var inst_73324 = (state_73411[(9)]);
var inst_73363 = (state_73411[(2)]);
var inst_73371 = cljs.core.vals.call(null,inst_73324);
var inst_73372 = cljs.core.seq.call(null,inst_73371);
var inst_73373 = cljs.core.first.call(null,inst_73372);
var inst_73374 = cljs.core.next.call(null,inst_73372);
var inst_73375 = cljs.core.PersistentVector.EMPTY;
var inst_73376 = inst_73371;
var inst_73377 = inst_73375;
var state_73411__$1 = (function (){var statearr_73459 = state_73411;
(statearr_73459[(13)] = inst_73363);

(statearr_73459[(30)] = inst_73374);

(statearr_73459[(26)] = inst_73377);

(statearr_73459[(28)] = inst_73376);

(statearr_73459[(31)] = inst_73373);

return statearr_73459;
})();
var statearr_73460_73496 = state_73411__$1;
(statearr_73460_73496[(2)] = null);

(statearr_73460_73496[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73412 === (8))){
var inst_73287 = (state_73411[(19)]);
var inst_73288 = (state_73411[(23)]);
var inst_73298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73299 = [inst_73287,inst_73288];
var inst_73300 = (new cljs.core.PersistentVector(null,2,(5),inst_73298,inst_73299,null));
var state_73411__$1 = state_73411;
var statearr_73461_73497 = state_73411__$1;
(statearr_73461_73497[(2)] = inst_73300);

(statearr_73461_73497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_73462 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73462[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_73462[(1)] = (1));

return statearr_73462;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_73411){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73463){var ex__2749__auto__ = e73463;
var statearr_73464_73498 = state_73411;
(statearr_73464_73498[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73411[(4)]))){
var statearr_73465_73499 = state_73411;
(statearr_73465_73499[(1)] = cljs.core.first.call(null,(state_73411[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73500 = state_73411;
state_73411 = G__73500;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_73411){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_73411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73466 = f__2769__auto__.call(null);
(statearr_73466[(6)] = c__2768__auto__);

return statearr_73466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73532){
var state_val_73533 = (state_73532[(1)]);
if((state_val_73533 === (1))){
var inst_73501 = cljs.core.volatile_BANG_.call(null,(0));
var inst_73502 = cljs.core.PersistentHashMap.EMPTY;
var inst_73503 = cljs.core.volatile_BANG_.call(null,inst_73502);
var inst_73504 = cljs.core.first.call(null,resp);
var inst_73505 = cljs.core.rest.call(null,resp);
var inst_73506 = cljs.core.PersistentVector.EMPTY;
var inst_73507 = inst_73501;
var inst_73508 = inst_73503;
var inst_73509 = inst_73504;
var inst_73510 = inst_73505;
var inst_73511 = inst_73506;
var state_73532__$1 = (function (){var statearr_73534 = state_73532;
(statearr_73534[(7)] = inst_73509);

(statearr_73534[(8)] = inst_73507);

(statearr_73534[(9)] = inst_73510);

(statearr_73534[(10)] = inst_73511);

(statearr_73534[(11)] = inst_73508);

return statearr_73534;
})();
var statearr_73535_73550 = state_73532__$1;
(statearr_73535_73550[(2)] = null);

(statearr_73535_73550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73533 === (2))){
var inst_73509 = (state_73532[(7)]);
var inst_73507 = (state_73532[(8)]);
var inst_73508 = (state_73532[(11)]);
var inst_73513 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_73509,inst_73508,inst_73507);
var state_73532__$1 = state_73532;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73532__$1,(4),inst_73513);
} else {
if((state_val_73533 === (3))){
var inst_73530 = (state_73532[(2)]);
var state_73532__$1 = state_73532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73532__$1,inst_73530);
} else {
if((state_val_73533 === (4))){
var inst_73510 = (state_73532[(9)]);
var inst_73511 = (state_73532[(10)]);
var inst_73515 = (state_73532[(2)]);
var inst_73516 = fluree.db.util.async.throw_err.call(null,inst_73515);
var inst_73517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73518 = [inst_73516];
var inst_73519 = (new cljs.core.PersistentVector(null,1,(5),inst_73517,inst_73518,null));
var inst_73520 = cljs.core.concat.call(null,inst_73511,inst_73519);
var inst_73521 = cljs.core.first.call(null,inst_73510);
var state_73532__$1 = (function (){var statearr_73538 = state_73532;
(statearr_73538[(12)] = inst_73520);

return statearr_73538;
})();
if(cljs.core.truth_(inst_73521)){
var statearr_73539_73551 = state_73532__$1;
(statearr_73539_73551[(1)] = (5));

} else {
var statearr_73540_73552 = state_73532__$1;
(statearr_73540_73552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73533 === (5))){
var inst_73507 = (state_73532[(8)]);
var inst_73510 = (state_73532[(9)]);
var inst_73520 = (state_73532[(12)]);
var inst_73508 = (state_73532[(11)]);
var inst_73523 = cljs.core.first.call(null,inst_73510);
var inst_73524 = cljs.core.rest.call(null,inst_73510);
var tmp73536 = inst_73507;
var tmp73537 = inst_73508;
var inst_73507__$1 = tmp73536;
var inst_73508__$1 = tmp73537;
var inst_73509 = inst_73523;
var inst_73510__$1 = inst_73524;
var inst_73511 = inst_73520;
var state_73532__$1 = (function (){var statearr_73541 = state_73532;
(statearr_73541[(7)] = inst_73509);

(statearr_73541[(8)] = inst_73507__$1);

(statearr_73541[(9)] = inst_73510__$1);

(statearr_73541[(10)] = inst_73511);

(statearr_73541[(11)] = inst_73508__$1);

return statearr_73541;
})();
var statearr_73542_73553 = state_73532__$1;
(statearr_73542_73553[(2)] = null);

(statearr_73542_73553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73533 === (6))){
var inst_73520 = (state_73532[(12)]);
var state_73532__$1 = state_73532;
var statearr_73543_73554 = state_73532__$1;
(statearr_73543_73554[(2)] = inst_73520);

(statearr_73543_73554[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73533 === (7))){
var inst_73528 = (state_73532[(2)]);
var state_73532__$1 = state_73532;
var statearr_73544_73555 = state_73532__$1;
(statearr_73544_73555[(2)] = inst_73528);

(statearr_73544_73555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_73545 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73545[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__);

(statearr_73545[(1)] = (1));

return statearr_73545;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1 = (function (state_73532){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73546){var ex__2749__auto__ = e73546;
var statearr_73547_73556 = state_73532;
(statearr_73547_73556[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73532[(4)]))){
var statearr_73548_73557 = state_73532;
(statearr_73548_73557[(1)] = cljs.core.first.call(null,(state_73532[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73558 = state_73532;
state_73532 = G__73558;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = function(state_73532){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1.call(this,state_73532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73549 = f__2769__auto__.call(null);
(statearr_73549[(6)] = c__2768__auto__);

return statearr_73549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__73560 = arguments.length;
switch (G__73560) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__73562){
var map__73563 = p__73562;
var map__73563__$1 = cljs.core.__destructure_map.call(null,map__73563);
var query = map__73563__$1;
var opts = cljs.core.get.call(null,map__73563__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73648){
var state_val_73649 = (state_73648[(1)]);
if((state_val_73649 === (7))){
var inst_73574 = (state_73648[(7)]);
var inst_73578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73579 = ["_auth/id",inst_73574];
var inst_73580 = (new cljs.core.PersistentVector(null,2,(5),inst_73578,inst_73579,null));
var state_73648__$1 = state_73648;
var statearr_73650_73694 = state_73648__$1;
(statearr_73650_73694[(2)] = inst_73580);

(statearr_73650_73694[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (20))){
var inst_73628 = (state_73648[(2)]);
var inst_73629 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_73648__$1 = (function (){var statearr_73651 = state_73648;
(statearr_73651[(8)] = inst_73628);

return statearr_73651;
})();
if(cljs.core.truth_(inst_73629)){
var statearr_73652_73695 = state_73648__$1;
(statearr_73652_73695[(1)] = (22));

} else {
var statearr_73653_73696 = state_73648__$1;
(statearr_73653_73696[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (27))){
var inst_73631 = (state_73648[(9)]);
var inst_73575 = (state_73648[(10)]);
var inst_73637 = (state_73648[(2)]);
var inst_73638 = fluree.db.util.core.response_time_formatted.call(null,inst_73575);
var inst_73639 = [(200),inst_73637,(100),inst_73638];
var inst_73640 = cljs.core.PersistentHashMap.fromArrays(inst_73631,inst_73639);
var state_73648__$1 = state_73648;
var statearr_73654_73697 = state_73648__$1;
(statearr_73654_73697[(2)] = inst_73640);

(statearr_73654_73697[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (1))){
var state_73648__$1 = state_73648;
var statearr_73655_73698 = state_73648__$1;
(statearr_73655_73698[(2)] = null);

(statearr_73655_73698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (24))){
var inst_73643 = (state_73648[(2)]);
var _ = (function (){var statearr_73656 = state_73648;
(statearr_73656[(4)] = cljs.core.rest.call(null,(state_73648[(4)])));

return statearr_73656;
})();
var state_73648__$1 = state_73648;
var statearr_73657_73699 = state_73648__$1;
(statearr_73657_73699[(2)] = inst_73643);

(statearr_73657_73699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (4))){
var inst_73564 = (state_73648[(2)]);
var state_73648__$1 = state_73648;
var statearr_73658_73700 = state_73648__$1;
(statearr_73658_73700[(2)] = inst_73564);

(statearr_73658_73700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (15))){
var inst_73615 = (state_73648[(11)]);
var state_73648__$1 = state_73648;
var statearr_73659_73701 = state_73648__$1;
(statearr_73659_73701[(2)] = inst_73615);

(statearr_73659_73701[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (21))){
var inst_73624 = (state_73648[(2)]);
var inst_73625 = fluree.db.util.async.throw_err.call(null,inst_73624);
var state_73648__$1 = state_73648;
var statearr_73660_73702 = state_73648__$1;
(statearr_73660_73702[(2)] = inst_73625);

(statearr_73660_73702[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (13))){
var inst_73615 = (state_73648[(11)]);
var inst_73573 = (state_73648[(12)]);
var inst_73614 = (state_73648[(2)]);
var inst_73615__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_73573);
var state_73648__$1 = (function (){var statearr_73661 = state_73648;
(statearr_73661[(13)] = inst_73614);

(statearr_73661[(11)] = inst_73615__$1);

return statearr_73661;
})();
if(cljs.core.truth_(inst_73615__$1)){
var statearr_73662_73703 = state_73648__$1;
(statearr_73662_73703[(1)] = (15));

} else {
var statearr_73663_73704 = state_73648__$1;
(statearr_73663_73704[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (22))){
var inst_73628 = (state_73648[(8)]);
var inst_73631 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_73632 = cljs.core.sequential_QMARK_.call(null,inst_73628);
var state_73648__$1 = (function (){var statearr_73664 = state_73648;
(statearr_73664[(9)] = inst_73631);

return statearr_73664;
})();
if(inst_73632){
var statearr_73665_73705 = state_73648__$1;
(statearr_73665_73705[(1)] = (25));

} else {
var statearr_73666_73706 = state_73648__$1;
(statearr_73666_73706[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (6))){
var inst_73589 = (state_73648[(14)]);
var inst_73573 = (state_73648[(12)]);
var inst_73588 = (state_73648[(2)]);
var inst_73589__$1 = fluree.db.util.async.throw_err.call(null,inst_73588);
var inst_73590 = fluree.db.api.query.resolve_block_range.call(null,inst_73589__$1,inst_73573);
var state_73648__$1 = (function (){var statearr_73667 = state_73648;
(statearr_73667[(14)] = inst_73589__$1);

return statearr_73667;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73648__$1,(10),inst_73590);
} else {
if((state_val_73649 === (25))){
var inst_73628 = (state_73648[(8)]);
var inst_73634 = cljs.core.doall.call(null,inst_73628);
var state_73648__$1 = state_73648;
var statearr_73668_73707 = state_73648__$1;
(statearr_73668_73707[(2)] = inst_73634);

(statearr_73668_73707[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (17))){
var inst_73620 = (state_73648[(2)]);
var state_73648__$1 = state_73648;
if(cljs.core.truth_(inst_73620)){
var statearr_73669_73708 = state_73648__$1;
(statearr_73669_73708[(1)] = (18));

} else {
var statearr_73670_73709 = state_73648__$1;
(statearr_73670_73709[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (3))){
var inst_73646 = (state_73648[(2)]);
var state_73648__$1 = state_73648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73648__$1,inst_73646);
} else {
if((state_val_73649 === (12))){
var inst_73573 = (state_73648[(12)]);
var inst_73606 = cljs.core.pr_str.call(null,inst_73573);
var inst_73607 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_73606].join('');
var inst_73608 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73609 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73610 = cljs.core.PersistentHashMap.fromArrays(inst_73608,inst_73609);
var inst_73611 = cljs.core.ex_info.call(null,inst_73607,inst_73610);
var inst_73612 = (function(){throw inst_73611})();
var state_73648__$1 = state_73648;
var statearr_73671_73710 = state_73648__$1;
(statearr_73671_73710[(2)] = inst_73612);

(statearr_73671_73710[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (2))){
var inst_73574 = (state_73648[(7)]);
var _ = (function (){var statearr_73672 = state_73648;
(statearr_73672[(4)] = cljs.core.cons.call(null,(5),(state_73648[(4)])));

return statearr_73672;
})();
var inst_73573 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_73574__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_73575 = fluree.db.util.core.current_time_millis.call(null);
var inst_73576 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_73648__$1 = (function (){var statearr_73673 = state_73648;
(statearr_73673[(10)] = inst_73575);

(statearr_73673[(7)] = inst_73574__$1);

(statearr_73673[(15)] = inst_73576);

(statearr_73673[(12)] = inst_73573);

return statearr_73673;
})();
if(cljs.core.truth_(inst_73574__$1)){
var statearr_73674_73711 = state_73648__$1;
(statearr_73674_73711[(1)] = (7));

} else {
var statearr_73675_73712 = state_73648__$1;
(statearr_73675_73712[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (23))){
var inst_73628 = (state_73648[(8)]);
var state_73648__$1 = state_73648;
var statearr_73676_73713 = state_73648__$1;
(statearr_73676_73713[(2)] = inst_73628);

(statearr_73676_73713[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (19))){
var inst_73614 = (state_73648[(13)]);
var state_73648__$1 = state_73648;
var statearr_73677_73714 = state_73648__$1;
(statearr_73677_73714[(2)] = inst_73614);

(statearr_73677_73714[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (11))){
var inst_73595 = (state_73648[(16)]);
var inst_73594 = (state_73648[(17)]);
var inst_73589 = (state_73648[(14)]);
var inst_73601 = fluree.db.api.query.block_range.call(null,inst_73589,inst_73594,inst_73595,opts);
var state_73648__$1 = state_73648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73648__$1,(14),inst_73601);
} else {
if((state_val_73649 === (9))){
var inst_73576 = (state_73648[(15)]);
var inst_73583 = (state_73648[(2)]);
var inst_73584 = [inst_73583];
var inst_73585 = cljs.core.PersistentHashMap.fromArrays(inst_73576,inst_73584);
var inst_73586 = fluree.db.api.query.db.call(null,conn,ledger,inst_73585);
var state_73648__$1 = state_73648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73648__$1,(6),inst_73586);
} else {
if((state_val_73649 === (5))){
var _ = (function (){var statearr_73679 = state_73648;
(statearr_73679[(4)] = cljs.core.rest.call(null,(state_73648[(4)])));

return statearr_73679;
})();
var state_73648__$1 = state_73648;
var ex73678 = (state_73648__$1[(2)]);
var statearr_73680_73715 = state_73648__$1;
(statearr_73680_73715[(5)] = ex73678);


if((ex73678 instanceof Error)){
var statearr_73681_73716 = state_73648__$1;
(statearr_73681_73716[(1)] = (4));

(statearr_73681_73716[(5)] = null);

} else {
throw ex73678;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (14))){
var inst_73603 = (state_73648[(2)]);
var inst_73604 = fluree.db.util.async.throw_err.call(null,inst_73603);
var state_73648__$1 = state_73648;
var statearr_73682_73717 = state_73648__$1;
(statearr_73682_73717[(2)] = inst_73604);

(statearr_73682_73717[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (26))){
var inst_73628 = (state_73648[(8)]);
var state_73648__$1 = state_73648;
var statearr_73683_73718 = state_73648__$1;
(statearr_73683_73718[(2)] = inst_73628);

(statearr_73683_73718[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (16))){
var inst_73573 = (state_73648[(12)]);
var inst_73618 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_73573);
var state_73648__$1 = state_73648;
var statearr_73684_73719 = state_73648__$1;
(statearr_73684_73719[(2)] = inst_73618);

(statearr_73684_73719[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (10))){
var inst_73573 = (state_73648[(12)]);
var inst_73592 = (state_73648[(2)]);
var inst_73593 = fluree.db.util.async.throw_err.call(null,inst_73592);
var inst_73594 = cljs.core.nth.call(null,inst_73593,(0),null);
var inst_73595 = cljs.core.nth.call(null,inst_73593,(1),null);
var inst_73596 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_73597 = cljs.core.dissoc.call(null,inst_73573,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_73598 = cljs.core.keys.call(null,inst_73597);
var inst_73599 = cljs.core._EQ_.call(null,inst_73596,inst_73598);
var state_73648__$1 = (function (){var statearr_73685 = state_73648;
(statearr_73685[(16)] = inst_73595);

(statearr_73685[(17)] = inst_73594);

return statearr_73685;
})();
if(inst_73599){
var statearr_73686_73720 = state_73648__$1;
(statearr_73686_73720[(1)] = (11));

} else {
var statearr_73687_73721 = state_73648__$1;
(statearr_73687_73721[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73649 === (18))){
var inst_73614 = (state_73648[(13)]);
var inst_73589 = (state_73648[(14)]);
var inst_73622 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_73589,inst_73614);
var state_73648__$1 = state_73648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73648__$1,(21),inst_73622);
} else {
if((state_val_73649 === (8))){
var state_73648__$1 = state_73648;
var statearr_73688_73722 = state_73648__$1;
(statearr_73688_73722[(2)] = null);

(statearr_73688_73722[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_73689 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73689[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2746__auto__);

(statearr_73689[(1)] = (1));

return statearr_73689;
});
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1 = (function (state_73648){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73690){var ex__2749__auto__ = e73690;
var statearr_73691_73723 = state_73648;
(statearr_73691_73723[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73648[(4)]))){
var statearr_73692_73724 = state_73648;
(statearr_73692_73724[(1)] = cljs.core.first.call(null,(state_73648[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73725 = state_73648;
state_73648 = G__73725;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = function(state_73648){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1.call(this,state_73648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73693 = f__2769__auto__.call(null);
(statearr_73693[(6)] = c__2768__auto__);

return statearr_73693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__73726 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__73726,(0),null);
var p = cljs.core.nth.call(null,vec__73726,(1),null);
var o = cljs.core.nth.call(null,vec__73726,(2),null);
var t = cljs.core.nth.call(null,vec__73726,(3),null);
var vec__73729 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__73729,(0),null);
var idx = cljs.core.nth.call(null,vec__73729,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__73732 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t.call(null,flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__73732,(0),null);
var id = cljs.core.nth.call(null,vec__73732,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___73736 = arguments.length;
var i__5770__auto___73737 = (0);
while(true){
if((i__5770__auto___73737 < len__5769__auto___73736)){
args__5775__auto__.push((arguments[i__5770__auto___73737]));

var G__73738 = (i__5770__auto___73737 + (1));
i__5770__auto___73737 = G__73738;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq73735){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq73735));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73934){
var state_val_73935 = (state_73934[(1)]);
if((state_val_73935 === (7))){
var inst_73861 = (state_73934[(7)]);
var inst_73854 = (state_73934[(8)]);
var inst_73860 = cljs.core.seq.call(null,inst_73854);
var inst_73861__$1 = cljs.core.first.call(null,inst_73860);
var inst_73862 = cljs.core.next.call(null,inst_73860);
var state_73934__$1 = (function (){var statearr_73936 = state_73934;
(statearr_73936[(7)] = inst_73861__$1);

(statearr_73936[(9)] = inst_73862);

return statearr_73936;
})();
if(cljs.core.truth_(inst_73861__$1)){
var statearr_73937_74037 = state_73934__$1;
(statearr_73937_74037[(1)] = (9));

} else {
var statearr_73938_74038 = state_73934__$1;
(statearr_73938_74038[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (20))){
var inst_73924 = (state_73934[(2)]);
var state_73934__$1 = state_73934;
var statearr_73939_74039 = state_73934__$1;
(statearr_73939_74039[(2)] = inst_73924);

(statearr_73939_74039[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (27))){
var inst_73879 = (state_73934[(10)]);
var inst_73882 = (state_73934[(11)]);
var inst_73900 = (state_73934[(12)]);
var inst_73902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73903 = [inst_73882,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_73904 = (new cljs.core.PersistentVector(null,2,(5),inst_73902,inst_73903,null));
var inst_73905 = cljs.core.update_in.call(null,inst_73900,inst_73904,fluree.db.api.query.min_safe,inst_73879);
var state_73934__$1 = state_73934;
var statearr_73940_74040 = state_73934__$1;
(statearr_73940_74040[(2)] = inst_73905);

(statearr_73940_74040[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (1))){
var state_73934__$1 = state_73934;
var statearr_73941_74041 = state_73934__$1;
(statearr_73941_74041[(2)] = null);

(statearr_73941_74041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (24))){
var inst_73892 = (state_73934[(13)]);
var inst_73882 = (state_73934[(11)]);
var inst_73861 = (state_73934[(7)]);
var inst_73894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73895 = [inst_73882,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_73896 = (new cljs.core.PersistentVector(null,2,(5),inst_73894,inst_73895,null));
var inst_73897 = cljs.core.update_in.call(null,inst_73892,inst_73896,cljs.core.conj,inst_73861);
var state_73934__$1 = state_73934;
var statearr_73943_74042 = state_73934__$1;
(statearr_73943_74042[(2)] = inst_73897);

(statearr_73943_74042[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (4))){
var inst_73740 = (state_73934[(2)]);
var state_73934__$1 = state_73934;
var statearr_73944_74043 = state_73934__$1;
(statearr_73944_74043[(2)] = inst_73740);

(statearr_73944_74043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (15))){
var inst_73855 = (state_73934[(14)]);
var inst_73862 = (state_73934[(9)]);
var tmp73942 = inst_73855;
var inst_73854 = inst_73862;
var inst_73855__$1 = tmp73942;
var state_73934__$1 = (function (){var statearr_73945 = state_73934;
(statearr_73945[(14)] = inst_73855__$1);

(statearr_73945[(8)] = inst_73854);

return statearr_73945;
})();
var statearr_73946_74044 = state_73934__$1;
(statearr_73946_74044[(2)] = null);

(statearr_73946_74044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (21))){
var inst_73882 = (state_73934[(11)]);
var inst_73855 = (state_73934[(14)]);
var inst_73886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73887 = [inst_73882,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73888 = (new cljs.core.PersistentVector(null,2,(5),inst_73886,inst_73887,null));
var inst_73889 = cljs.core.assoc_in.call(null,inst_73855,inst_73888,inst_73882);
var state_73934__$1 = state_73934;
var statearr_73947_74045 = state_73934__$1;
(statearr_73947_74045[(2)] = inst_73889);

(statearr_73947_74045[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (31))){
var inst_73908 = (state_73934[(15)]);
var state_73934__$1 = state_73934;
var statearr_73948_74046 = state_73934__$1;
(statearr_73948_74046[(2)] = inst_73908);

(statearr_73948_74046[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (32))){
var inst_73862 = (state_73934[(9)]);
var inst_73916 = (state_73934[(2)]);
var inst_73854 = inst_73862;
var inst_73855 = inst_73916;
var state_73934__$1 = (function (){var statearr_73949 = state_73934;
(statearr_73949[(14)] = inst_73855);

(statearr_73949[(8)] = inst_73854);

return statearr_73949;
})();
var statearr_73950_74047 = state_73934__$1;
(statearr_73950_74047[(2)] = null);

(statearr_73950_74047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (33))){
var inst_73855 = (state_73934[(14)]);
var state_73934__$1 = state_73934;
var statearr_73951_74048 = state_73934__$1;
(statearr_73951_74048[(2)] = inst_73855);

(statearr_73951_74048[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (13))){
var inst_73864 = (state_73934[(16)]);
var state_73934__$1 = state_73934;
var statearr_73952_74049 = state_73934__$1;
(statearr_73952_74049[(2)] = inst_73864);

(statearr_73952_74049[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (22))){
var inst_73855 = (state_73934[(14)]);
var state_73934__$1 = state_73934;
var statearr_73953_74050 = state_73934__$1;
(statearr_73953_74050[(2)] = inst_73855);

(statearr_73953_74050[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (29))){
var inst_73908 = (state_73934[(2)]);
var state_73934__$1 = (function (){var statearr_73954 = state_73934;
(statearr_73954[(15)] = inst_73908);

return statearr_73954;
})();
if(cljs.core.truth_(show_auth)){
var statearr_73955_74051 = state_73934__$1;
(statearr_73955_74051[(1)] = (30));

} else {
var statearr_73956_74052 = state_73934__$1;
(statearr_73956_74052[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (6))){
var inst_73840 = (state_73934[(2)]);
var inst_73841 = fluree.db.util.async.throw_err.call(null,inst_73840);
var inst_73849 = resp;
var inst_73850 = cljs.core.seq.call(null,inst_73849);
var inst_73851 = cljs.core.first.call(null,inst_73850);
var inst_73852 = cljs.core.next.call(null,inst_73850);
var inst_73853 = cljs.core.PersistentHashMap.EMPTY;
var inst_73854 = inst_73849;
var inst_73855 = inst_73853;
var state_73934__$1 = (function (){var statearr_73957 = state_73934;
(statearr_73957[(17)] = inst_73851);

(statearr_73957[(18)] = inst_73841);

(statearr_73957[(14)] = inst_73855);

(statearr_73957[(19)] = inst_73852);

(statearr_73957[(8)] = inst_73854);

return statearr_73957;
})();
var statearr_73958_74053 = state_73934__$1;
(statearr_73958_74053[(2)] = null);

(statearr_73958_74053[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (28))){
var inst_73900 = (state_73934[(12)]);
var state_73934__$1 = state_73934;
var statearr_73959_74054 = state_73934__$1;
(statearr_73959_74054[(2)] = inst_73900);

(statearr_73959_74054[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (25))){
var inst_73892 = (state_73934[(13)]);
var state_73934__$1 = state_73934;
var statearr_73960_74055 = state_73934__$1;
(statearr_73960_74055[(2)] = inst_73892);

(statearr_73960_74055[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (34))){
var state_73934__$1 = state_73934;
var statearr_73961_74056 = state_73934__$1;
(statearr_73961_74056[(2)] = null);

(statearr_73961_74056[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (17))){
var inst_73926 = (state_73934[(2)]);
var state_73934__$1 = state_73934;
var statearr_73962_74057 = state_73934__$1;
(statearr_73962_74057[(2)] = inst_73926);

(statearr_73962_74057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (3))){
var inst_73932 = (state_73934[(2)]);
var state_73934__$1 = state_73934;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73934__$1,inst_73932);
} else {
if((state_val_73935 === (12))){
var inst_73841 = (state_73934[(18)]);
var inst_73861 = (state_73934[(7)]);
var inst_73866 = fluree.db.api.query.auth_match.call(null,auth,inst_73841,inst_73861);
var inst_73867 = cljs.core.not.call(null,inst_73866);
var state_73934__$1 = state_73934;
var statearr_73963_74058 = state_73934__$1;
(statearr_73963_74058[(2)] = inst_73867);

(statearr_73963_74058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (2))){
var _ = (function (){var statearr_73964 = state_73934;
(statearr_73964[(4)] = cljs.core.cons.call(null,(5),(state_73934[(4)])));

return statearr_73964;
})();
var inst_73746 = (function (){return (function (p1__73739_SHARP_){
return fluree.db.flake.t.call(null,p1__73739_SHARP_);
});
})();
var inst_73747 = cljs.core.map.call(null,inst_73746,resp);
var inst_73748 = cljs.core.set.call(null,inst_73747);
var inst_73836 = cljs.core.async.chan.call(null,(1));
var inst_73837 = (function (){var ts = inst_73748;
var c__2768__auto____$1 = inst_73836;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73834){
var state_val_73835 = (state_73834[(1)]);
if((state_val_73835 === (7))){
var inst_73762 = (state_73834[(7)]);
var inst_73768 = (state_73834[(8)]);
var inst_73774 = (state_73834[(9)]);
var inst_73780 = (state_73834[(10)]);
var inst_73773 = (state_73834[(2)]);
var inst_73774__$1 = fluree.db.util.async.throw_err.call(null,inst_73773);
var inst_73776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73777 = [inst_73768,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73778 = (new cljs.core.PersistentVector(null,2,(5),inst_73776,inst_73777,null));
var inst_73779 = cljs.core.assoc_in.call(null,inst_73762,inst_73778,inst_73774__$1);
var inst_73780__$1 = auth;
var state_73834__$1 = (function (){var statearr_73965 = state_73834;
(statearr_73965[(9)] = inst_73774__$1);

(statearr_73965[(11)] = inst_73779);

(statearr_73965[(10)] = inst_73780__$1);

return statearr_73965;
})();
if(cljs.core.truth_(inst_73780__$1)){
var statearr_73966_74059 = state_73834__$1;
(statearr_73966_74059[(1)] = (8));

} else {
var statearr_73967_74060 = state_73834__$1;
(statearr_73967_74060[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (1))){
var inst_73756 = (state_73834[(12)]);
var inst_73756__$1 = ts;
var inst_73757 = cljs.core.seq.call(null,inst_73756__$1);
var inst_73758 = cljs.core.first.call(null,inst_73757);
var inst_73759 = cljs.core.next.call(null,inst_73757);
var inst_73760 = cljs.core.PersistentHashMap.EMPTY;
var inst_73761 = inst_73756__$1;
var inst_73762 = inst_73760;
var state_73834__$1 = (function (){var statearr_73968 = state_73834;
(statearr_73968[(13)] = inst_73761);

(statearr_73968[(7)] = inst_73762);

(statearr_73968[(14)] = inst_73758);

(statearr_73968[(15)] = inst_73759);

(statearr_73968[(12)] = inst_73756__$1);

return statearr_73968;
})();
var statearr_73969_74061 = state_73834__$1;
(statearr_73969_74061[(2)] = null);

(statearr_73969_74061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (4))){
var inst_73768 = (state_73834[(8)]);
var inst_73771 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_73768);
var state_73834__$1 = state_73834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73834__$1,(7),inst_73771);
} else {
if((state_val_73835 === (13))){
var inst_73769 = (state_73834[(16)]);
var inst_73826 = (state_73834[(2)]);
var inst_73761 = inst_73769;
var inst_73762 = inst_73826;
var state_73834__$1 = (function (){var statearr_73970 = state_73834;
(statearr_73970[(13)] = inst_73761);

(statearr_73970[(7)] = inst_73762);

return statearr_73970;
})();
var statearr_73971_74062 = state_73834__$1;
(statearr_73971_74062[(2)] = null);

(statearr_73971_74062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (6))){
var inst_73830 = (state_73834[(2)]);
var state_73834__$1 = state_73834;
var statearr_73972_74063 = state_73834__$1;
(statearr_73972_74063[(2)] = inst_73830);

(statearr_73972_74063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (3))){
var inst_73832 = (state_73834[(2)]);
var state_73834__$1 = state_73834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73834__$1,inst_73832);
} else {
if((state_val_73835 === (12))){
var inst_73779 = (state_73834[(11)]);
var state_73834__$1 = state_73834;
var statearr_73973_74064 = state_73834__$1;
(statearr_73973_74064[(2)] = inst_73779);

(statearr_73973_74064[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (2))){
var inst_73761 = (state_73834[(13)]);
var inst_73768 = (state_73834[(8)]);
var inst_73767 = cljs.core.seq.call(null,inst_73761);
var inst_73768__$1 = cljs.core.first.call(null,inst_73767);
var inst_73769 = cljs.core.next.call(null,inst_73767);
var state_73834__$1 = (function (){var statearr_73974 = state_73834;
(statearr_73974[(8)] = inst_73768__$1);

(statearr_73974[(16)] = inst_73769);

return statearr_73974;
})();
if(cljs.core.truth_(inst_73768__$1)){
var statearr_73975_74065 = state_73834__$1;
(statearr_73975_74065[(1)] = (4));

} else {
var statearr_73976_74066 = state_73834__$1;
(statearr_73976_74066[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (11))){
var inst_73761 = (state_73834[(13)]);
var inst_73762 = (state_73834[(7)]);
var inst_73768 = (state_73834[(8)]);
var inst_73774 = (state_73834[(9)]);
var inst_73779 = (state_73834[(11)]);
var inst_73758 = (state_73834[(14)]);
var inst_73759 = (state_73834[(15)]);
var inst_73756 = (state_73834[(12)]);
var inst_73769 = (state_73834[(16)]);
var inst_73786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73787 = [inst_73768,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_73788 = (new cljs.core.PersistentVector(null,2,(5),inst_73786,inst_73787,null));
var inst_73801 = cljs.core.async.chan.call(null,(1));
var inst_73802 = (function (){var t = inst_73768;
var seq__73754 = inst_73759;
var block = inst_73774;
var r = inst_73769;
var G__73775 = inst_73779;
var seq__73765 = inst_73769;
var acc = inst_73762;
var vec__73753 = inst_73756;
var first__73755 = inst_73758;
var vec__73764 = inst_73761;
var c__2768__auto____$2 = inst_73801;
var G__73752 = inst_73761;
var first__73766 = inst_73768;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73799){
var state_val_73800 = (state_73799[(1)]);
if((state_val_73800 === (1))){
var state_73799__$1 = state_73799;
var statearr_73977_74067 = state_73799__$1;
(statearr_73977_74067[(2)] = null);

(statearr_73977_74067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73800 === (2))){
var ___$1 = (function (){var statearr_73978 = state_73799;
(statearr_73978[(4)] = cljs.core.cons.call(null,(5),(state_73799[(4)])));

return statearr_73978;
})();
var ___$2 = (function (){var statearr_73979 = state_73799;
(statearr_73979[(4)] = cljs.core.rest.call(null,(state_73799[(4)])));

return statearr_73979;
})();
var state_73799__$1 = state_73799;
var statearr_73980_74068 = state_73799__$1;
(statearr_73980_74068[(2)] = db);

(statearr_73980_74068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73800 === (3))){
var inst_73797 = (state_73799[(2)]);
var state_73799__$1 = state_73799;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73799__$1,inst_73797);
} else {
if((state_val_73800 === (4))){
var inst_73789 = (state_73799[(2)]);
var state_73799__$1 = state_73799;
var statearr_73982_74069 = state_73799__$1;
(statearr_73982_74069[(2)] = inst_73789);

(statearr_73982_74069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73800 === (5))){
var ___$1 = (function (){var statearr_73983 = state_73799;
(statearr_73983[(4)] = cljs.core.rest.call(null,(state_73799[(4)])));

return statearr_73983;
})();
var state_73799__$1 = state_73799;
var ex73981 = (state_73799__$1[(2)]);
var statearr_73984_74070 = state_73799__$1;
(statearr_73984_74070[(5)] = ex73981);


if((ex73981 instanceof Error)){
var statearr_73985_74071 = state_73799__$1;
(statearr_73985_74071[(1)] = (4));

(statearr_73985_74071[(5)] = null);

} else {
throw ex73981;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_73986 = [null,null,null,null,null,null,null];
(statearr_73986[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_73986[(1)] = (1));

return statearr_73986;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_73799){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73987){var ex__2749__auto__ = e73987;
var statearr_73988_74072 = state_73799;
(statearr_73988_74072[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73799[(4)]))){
var statearr_73989_74073 = state_73799;
(statearr_73989_74073[(1)] = cljs.core.first.call(null,(state_73799[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74074 = state_73799;
state_73799 = G__74074;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_73799){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_73799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73990 = f__2769__auto__.call(null);
(statearr_73990[(6)] = c__2768__auto____$2);

return statearr_73990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_73803 = cljs.core.async.impl.dispatch.run.call(null,inst_73802);
var inst_73804 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_73805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73806 = ["?auth","?id"];
var inst_73807 = (new cljs.core.PersistentVector(null,2,(5),inst_73805,inst_73806,null));
var inst_73808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73810 = [inst_73768,"_tx/auth","?auth"];
var inst_73811 = (new cljs.core.PersistentVector(null,3,(5),inst_73809,inst_73810,null));
var inst_73812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73813 = ["?auth","_auth/id","?id"];
var inst_73814 = (new cljs.core.PersistentVector(null,3,(5),inst_73812,inst_73813,null));
var inst_73815 = [inst_73811,inst_73814];
var inst_73816 = (new cljs.core.PersistentVector(null,2,(5),inst_73808,inst_73815,null));
var inst_73817 = [inst_73807,inst_73816];
var inst_73818 = cljs.core.PersistentHashMap.fromArrays(inst_73804,inst_73817);
var inst_73819 = fluree.db.api.query.query_async.call(null,inst_73801,inst_73818);
var state_73834__$1 = (function (){var statearr_73991 = state_73834;
(statearr_73991[(17)] = inst_73803);

(statearr_73991[(18)] = inst_73788);

return statearr_73991;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73834__$1,(14),inst_73819);
} else {
if((state_val_73835 === (9))){
var state_73834__$1 = state_73834;
var statearr_73992_74075 = state_73834__$1;
(statearr_73992_74075[(2)] = show_auth);

(statearr_73992_74075[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (5))){
var inst_73762 = (state_73834[(7)]);
var state_73834__$1 = state_73834;
var statearr_73993_74076 = state_73834__$1;
(statearr_73993_74076[(2)] = inst_73762);

(statearr_73993_74076[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (14))){
var inst_73779 = (state_73834[(11)]);
var inst_73788 = (state_73834[(18)]);
var inst_73821 = (state_73834[(2)]);
var inst_73822 = fluree.db.util.async.throw_err.call(null,inst_73821);
var inst_73823 = cljs.core.assoc_in.call(null,inst_73779,inst_73788,inst_73822);
var state_73834__$1 = state_73834;
var statearr_73994_74077 = state_73834__$1;
(statearr_73994_74077[(2)] = inst_73823);

(statearr_73994_74077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (10))){
var inst_73784 = (state_73834[(2)]);
var state_73834__$1 = state_73834;
if(cljs.core.truth_(inst_73784)){
var statearr_73995_74078 = state_73834__$1;
(statearr_73995_74078[(1)] = (11));

} else {
var statearr_73996_74079 = state_73834__$1;
(statearr_73996_74079[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (8))){
var inst_73780 = (state_73834[(10)]);
var state_73834__$1 = state_73834;
var statearr_73997_74080 = state_73834__$1;
(statearr_73997_74080[(2)] = inst_73780);

(statearr_73997_74080[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_73998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73998[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_73998[(1)] = (1));

return statearr_73998;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_73834){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73999){var ex__2749__auto__ = e73999;
var statearr_74000_74081 = state_73834;
(statearr_74000_74081[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73834[(4)]))){
var statearr_74001_74082 = state_73834;
(statearr_74001_74082[(1)] = cljs.core.first.call(null,(state_73834[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74083 = state_73834;
state_73834 = G__74083;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_73834){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_73834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74002 = f__2769__auto__.call(null);
(statearr_74002[(6)] = c__2768__auto____$1);

return statearr_74002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_73838 = cljs.core.async.impl.dispatch.run.call(null,inst_73837);
var state_73934__$1 = (function (){var statearr_74003 = state_73934;
(statearr_74003[(20)] = inst_73838);

return statearr_74003;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73934__$1,(6),inst_73836);
} else {
if((state_val_73935 === (23))){
var inst_73892 = (state_73934[(2)]);
var state_73934__$1 = (function (){var statearr_74004 = state_73934;
(statearr_74004[(13)] = inst_73892);

return statearr_74004;
})();
var statearr_74005_74084 = state_73934__$1;
(statearr_74005_74084[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (35))){
var inst_73922 = (state_73934[(2)]);
var state_73934__$1 = state_73934;
var statearr_74007_74085 = state_73934__$1;
(statearr_74007_74085[(2)] = inst_73922);

(statearr_74007_74085[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (19))){
var state_73934__$1 = state_73934;
var statearr_74008_74086 = state_73934__$1;
(statearr_74008_74086[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (11))){
var inst_73873 = (state_73934[(2)]);
var state_73934__$1 = state_73934;
if(cljs.core.truth_(inst_73873)){
var statearr_74011_74087 = state_73934__$1;
(statearr_74011_74087[(1)] = (15));

} else {
var statearr_74012_74088 = state_73934__$1;
(statearr_74012_74088[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (9))){
var inst_73864 = (state_73934[(16)]);
var inst_73864__$1 = auth;
var state_73934__$1 = (function (){var statearr_74013 = state_73934;
(statearr_74013[(16)] = inst_73864__$1);

return statearr_74013;
})();
if(cljs.core.truth_(inst_73864__$1)){
var statearr_74014_74089 = state_73934__$1;
(statearr_74014_74089[(1)] = (12));

} else {
var statearr_74015_74090 = state_73934__$1;
(statearr_74015_74090[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (5))){
var _ = (function (){var statearr_74016 = state_73934;
(statearr_74016[(4)] = cljs.core.rest.call(null,(state_73934[(4)])));

return statearr_74016;
})();
var state_73934__$1 = state_73934;
var ex74010 = (state_73934__$1[(2)]);
var statearr_74017_74091 = state_73934__$1;
(statearr_74017_74091[(5)] = ex74010);


if((ex74010 instanceof Error)){
var statearr_74018_74092 = state_73934__$1;
(statearr_74018_74092[(1)] = (4));

(statearr_74018_74092[(5)] = null);

} else {
throw ex74010;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (14))){
var inst_73870 = (state_73934[(2)]);
var state_73934__$1 = state_73934;
var statearr_74019_74093 = state_73934__$1;
(statearr_74019_74093[(2)] = inst_73870);

(statearr_74019_74093[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (26))){
var inst_73900 = (state_73934[(2)]);
var state_73934__$1 = (function (){var statearr_74020 = state_73934;
(statearr_74020[(12)] = inst_73900);

return statearr_74020;
})();
var statearr_74021_74094 = state_73934__$1;
(statearr_74021_74094[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (16))){
var inst_73861 = (state_73934[(7)]);
var state_73934__$1 = state_73934;
if(cljs.core.truth_(inst_73861)){
var statearr_74023_74095 = state_73934__$1;
(statearr_74023_74095[(1)] = (18));

} else {
var statearr_74024_74096 = state_73934__$1;
(statearr_74024_74096[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (30))){
var inst_73883 = (state_73934[(21)]);
var inst_73882 = (state_73934[(11)]);
var inst_73908 = (state_73934[(15)]);
var inst_73910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73911 = [inst_73882,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_73912 = (new cljs.core.PersistentVector(null,2,(5),inst_73910,inst_73911,null));
var inst_73913 = cljs.core.assoc_in.call(null,inst_73908,inst_73912,inst_73883);
var state_73934__$1 = state_73934;
var statearr_74025_74097 = state_73934__$1;
(statearr_74025_74097[(2)] = inst_73913);

(statearr_74025_74097[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (10))){
var inst_73861 = (state_73934[(7)]);
var state_73934__$1 = state_73934;
var statearr_74026_74098 = state_73934__$1;
(statearr_74026_74098[(2)] = inst_73861);

(statearr_74026_74098[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (18))){
var inst_73841 = (state_73934[(18)]);
var inst_73879 = (state_73934[(10)]);
var inst_73861 = (state_73934[(7)]);
var inst_73879__$1 = fluree.db.flake.t.call(null,inst_73861);
var inst_73880 = cljs.core.get.call(null,inst_73841,inst_73879__$1);
var inst_73881 = cljs.core.__destructure_map.call(null,inst_73880);
var inst_73882 = cljs.core.get.call(null,inst_73881,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73883 = cljs.core.get.call(null,inst_73881,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_73934__$1 = (function (){var statearr_74027 = state_73934;
(statearr_74027[(10)] = inst_73879__$1);

(statearr_74027[(21)] = inst_73883);

(statearr_74027[(11)] = inst_73882);

return statearr_74027;
})();
var statearr_74028_74099 = state_73934__$1;
(statearr_74028_74099[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73935 === (8))){
var inst_73928 = (state_73934[(2)]);
var inst_73929 = cljs.core.vals.call(null,inst_73928);
var _ = (function (){var statearr_74030 = state_73934;
(statearr_74030[(4)] = cljs.core.rest.call(null,(state_73934[(4)])));

return statearr_74030;
})();
var state_73934__$1 = state_73934;
var statearr_74031_74100 = state_73934__$1;
(statearr_74031_74100[(2)] = inst_73929);

(statearr_74031_74100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_74032 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74032[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_74032[(1)] = (1));

return statearr_74032;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_73934){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73934);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74033){var ex__2749__auto__ = e74033;
var statearr_74034_74101 = state_73934;
(statearr_74034_74101[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73934[(4)]))){
var statearr_74035_74102 = state_73934;
(statearr_74035_74102[(1)] = cljs.core.first.call(null,(state_73934[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74103 = state_73934;
state_73934 = G__74103;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_73934){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_73934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74036 = f__2769__auto__.call(null);
(statearr_74036[(6)] = c__2768__auto__);

return statearr_74036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74227){
var state_val_74228 = (state_74227[(1)]);
if((state_val_74228 === (7))){
var inst_74126 = (state_74227[(7)]);
var inst_74128 = fluree.db.api.query.resolve_block_range.call(null,inst_74126,query_map);
var state_74227__$1 = state_74227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74227__$1,(10),inst_74128);
} else {
if((state_val_74228 === (20))){
var inst_74152 = (state_74227[(2)]);
var inst_74153 = fluree.db.util.async.throw_err.call(null,inst_74152);
var inst_74154 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74153);
var inst_74155 = (inst_74154 - (1));
var state_74227__$1 = state_74227;
var statearr_74229_74292 = state_74227__$1;
(statearr_74229_74292[(2)] = inst_74155);

(statearr_74229_74292[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (27))){
var state_74227__$1 = state_74227;
var statearr_74230_74293 = state_74227__$1;
(statearr_74230_74293[(2)] = null);

(statearr_74230_74293[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (1))){
var state_74227__$1 = state_74227;
var statearr_74231_74294 = state_74227__$1;
(statearr_74231_74294[(2)] = null);

(statearr_74231_74294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (24))){
var inst_74162 = (state_74227[(2)]);
var inst_74163 = fluree.db.util.async.throw_err.call(null,inst_74162);
var inst_74164 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74163);
var state_74227__$1 = state_74227;
var statearr_74232_74295 = state_74227__$1;
(statearr_74232_74295[(2)] = inst_74164);

(statearr_74232_74295[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (39))){
var inst_74199 = (state_74227[(2)]);
var inst_74200 = fluree.db.util.async.throw_err.call(null,inst_74199);
var state_74227__$1 = state_74227;
var statearr_74233_74296 = state_74227__$1;
(statearr_74233_74296[(2)] = inst_74200);

(statearr_74233_74296[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (4))){
var inst_74104 = (state_74227[(2)]);
var state_74227__$1 = state_74227;
var statearr_74234_74297 = state_74227__$1;
(statearr_74234_74297[(2)] = inst_74104);

(statearr_74234_74297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (15))){
var inst_74135 = (state_74227[(8)]);
var state_74227__$1 = state_74227;
var statearr_74235_74298 = state_74227__$1;
(statearr_74235_74298[(2)] = inst_74135);

(statearr_74235_74298[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (21))){
var inst_74136 = (state_74227[(9)]);
var inst_74126 = (state_74227[(7)]);
var inst_74160 = fluree.db.time_travel.as_of_block.call(null,inst_74126,inst_74136);
var state_74227__$1 = state_74227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74227__$1,(24),inst_74160);
} else {
if((state_val_74228 === (31))){
var inst_74120 = (state_74227[(10)]);
var state_74227__$1 = state_74227;
var statearr_74236_74299 = state_74227__$1;
(statearr_74236_74299[(2)] = inst_74120);

(statearr_74236_74299[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (32))){
var inst_74183 = (state_74227[(11)]);
var inst_74178 = (state_74227[(12)]);
var inst_74126 = (state_74227[(7)]);
var inst_74187 = (state_74227[(2)]);
var inst_74188 = fluree.db.api.query.format_history_resp.call(null,inst_74126,inst_74178,inst_74183,inst_74187);
var state_74227__$1 = state_74227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74227__$1,(29),inst_74188);
} else {
if((state_val_74228 === (40))){
var inst_74178 = (state_74227[(12)]);
var inst_74204 = (state_74227[(13)]);
var inst_74206 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_74207 = cljs.core.count.call(null,inst_74178);
var inst_74208 = [inst_74204,inst_74207,(200)];
var inst_74209 = cljs.core.PersistentHashMap.fromArrays(inst_74206,inst_74208);
var state_74227__$1 = state_74227;
var statearr_74237_74300 = state_74227__$1;
(statearr_74237_74300[(2)] = inst_74209);

(statearr_74237_74300[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (33))){
var inst_74119 = (state_74227[(14)]);
var state_74227__$1 = state_74227;
var statearr_74238_74301 = state_74227__$1;
(statearr_74238_74301[(2)] = inst_74119);

(statearr_74238_74301[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (13))){
var inst_74222 = (state_74227[(2)]);
var _ = (function (){var statearr_74239 = state_74227;
(statearr_74239[(4)] = cljs.core.rest.call(null,(state_74227[(4)])));

return statearr_74239;
})();
var state_74227__$1 = state_74227;
var statearr_74240_74302 = state_74227__$1;
(statearr_74240_74302[(2)] = inst_74222);

(statearr_74240_74302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (22))){
var inst_74126 = (state_74227[(7)]);
var inst_74166 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74126);
var state_74227__$1 = state_74227;
var statearr_74241_74303 = state_74227__$1;
(statearr_74241_74303[(2)] = inst_74166);

(statearr_74241_74303[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (36))){
var inst_74191 = (state_74227[(15)]);
var inst_74126 = (state_74227[(7)]);
var inst_74197 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_74126,inst_74191);
var state_74227__$1 = state_74227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74227__$1,(39),inst_74197);
} else {
if((state_val_74228 === (41))){
var inst_74204 = (state_74227[(13)]);
var state_74227__$1 = state_74227;
var statearr_74242_74304 = state_74227__$1;
(statearr_74242_74304[(2)] = inst_74204);

(statearr_74242_74304[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (29))){
var inst_74119 = (state_74227[(14)]);
var inst_74190 = (state_74227[(2)]);
var inst_74191 = fluree.db.util.async.throw_err.call(null,inst_74190);
var state_74227__$1 = (function (){var statearr_74243 = state_74227;
(statearr_74243[(15)] = inst_74191);

return statearr_74243;
})();
if(cljs.core.truth_(inst_74119)){
var statearr_74244_74305 = state_74227__$1;
(statearr_74244_74305[(1)] = (33));

} else {
var statearr_74245_74306 = state_74227__$1;
(statearr_74245_74306[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (6))){
var inst_74116 = (state_74227[(16)]);
var inst_74125 = (state_74227[(2)]);
var inst_74126 = fluree.db.util.async.throw_err.call(null,inst_74125);
var state_74227__$1 = (function (){var statearr_74246 = state_74227;
(statearr_74246[(7)] = inst_74126);

return statearr_74246;
})();
if(cljs.core.truth_(inst_74116)){
var statearr_74247_74307 = state_74227__$1;
(statearr_74247_74307[(1)] = (7));

} else {
var statearr_74248_74308 = state_74227__$1;
(statearr_74248_74308[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (28))){
var inst_74121 = (state_74227[(17)]);
var inst_74183 = (state_74227[(2)]);
var state_74227__$1 = (function (){var statearr_74249 = state_74227;
(statearr_74249[(11)] = inst_74183);

return statearr_74249;
})();
if(cljs.core.truth_(inst_74121)){
var statearr_74250_74309 = state_74227__$1;
(statearr_74250_74309[(1)] = (30));

} else {
var statearr_74251_74310 = state_74227__$1;
(statearr_74251_74310[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (25))){
var inst_74122 = (state_74227[(18)]);
var inst_74177 = (state_74227[(2)]);
var inst_74178 = fluree.db.util.async.throw_err.call(null,inst_74177);
var state_74227__$1 = (function (){var statearr_74252 = state_74227;
(statearr_74252[(12)] = inst_74178);

return statearr_74252;
})();
if(cljs.core.truth_(inst_74122)){
var statearr_74253_74311 = state_74227__$1;
(statearr_74253_74311[(1)] = (26));

} else {
var statearr_74254_74312 = state_74227__$1;
(statearr_74254_74312[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (34))){
var inst_74118 = (state_74227[(19)]);
var state_74227__$1 = state_74227;
var statearr_74255_74313 = state_74227__$1;
(statearr_74255_74313[(2)] = inst_74118);

(statearr_74255_74313[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (17))){
var inst_74126 = (state_74227[(7)]);
var inst_74135 = (state_74227[(8)]);
var inst_74149 = (inst_74135 - (1));
var inst_74150 = fluree.db.time_travel.as_of_block.call(null,inst_74126,inst_74149);
var state_74227__$1 = state_74227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74227__$1,(20),inst_74150);
} else {
if((state_val_74228 === (3))){
var inst_74225 = (state_74227[(2)]);
var state_74227__$1 = state_74227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74227__$1,inst_74225);
} else {
if((state_val_74228 === (12))){
var inst_74214 = cljs.core.pr_str.call(null,query_map);
var inst_74215 = ["History query not properly formatted. Provided ",inst_74214].join('');
var inst_74216 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74217 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74218 = cljs.core.PersistentHashMap.fromArrays(inst_74216,inst_74217);
var inst_74219 = cljs.core.ex_info.call(null,inst_74215,inst_74218);
var inst_74220 = (function(){throw inst_74219})();
var state_74227__$1 = state_74227;
var statearr_74256_74314 = state_74227__$1;
(statearr_74256_74314[(2)] = inst_74220);

(statearr_74256_74314[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (2))){
var _ = (function (){var statearr_74257 = state_74227;
(statearr_74257[(4)] = cljs.core.cons.call(null,(5),(state_74227[(4)])));

return statearr_74257;
})();
var inst_74114 = query_map;
var inst_74115 = cljs.core.__destructure_map.call(null,inst_74114);
var inst_74116 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74117 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_74118 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_74119 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_74120 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_74121 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_74122 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74123 = cljs.core.get.call(null,inst_74115,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_74227__$1 = (function (){var statearr_74258 = state_74227;
(statearr_74258[(20)] = inst_74123);

(statearr_74258[(19)] = inst_74118);

(statearr_74258[(21)] = inst_74117);

(statearr_74258[(16)] = inst_74116);

(statearr_74258[(17)] = inst_74121);

(statearr_74258[(14)] = inst_74119);

(statearr_74258[(18)] = inst_74122);

(statearr_74258[(10)] = inst_74120);

return statearr_74258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74227__$1,(6),sources);
} else {
if((state_val_74228 === (23))){
var inst_74117 = (state_74227[(21)]);
var inst_74158 = (state_74227[(22)]);
var inst_74126 = (state_74227[(7)]);
var inst_74168 = (state_74227[(2)]);
var inst_74169 = fluree.db.api.query.get_history_pattern.call(null,inst_74117);
var inst_74170 = cljs.core.nth.call(null,inst_74169,(0),null);
var inst_74171 = cljs.core.nth.call(null,inst_74169,(1),null);
var inst_74172 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_74173 = [inst_74158,inst_74168];
var inst_74174 = cljs.core.PersistentHashMap.fromArrays(inst_74172,inst_74173);
var inst_74175 = fluree.db.query.range.time_range.call(null,inst_74126,inst_74171,cljs.core._EQ_,inst_74170,inst_74174);
var state_74227__$1 = state_74227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74227__$1,(25),inst_74175);
} else {
if((state_val_74228 === (35))){
var inst_74195 = (state_74227[(2)]);
var state_74227__$1 = state_74227;
if(cljs.core.truth_(inst_74195)){
var statearr_74259_74315 = state_74227__$1;
(statearr_74259_74315[(1)] = (36));

} else {
var statearr_74260_74316 = state_74227__$1;
(statearr_74260_74316[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (19))){
var inst_74136 = (state_74227[(9)]);
var inst_74158 = (state_74227[(2)]);
var state_74227__$1 = (function (){var statearr_74261 = state_74227;
(statearr_74261[(22)] = inst_74158);

return statearr_74261;
})();
if(cljs.core.truth_(inst_74136)){
var statearr_74262_74317 = state_74227__$1;
(statearr_74262_74317[(1)] = (21));

} else {
var statearr_74263_74318 = state_74227__$1;
(statearr_74263_74318[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (11))){
var inst_74123 = (state_74227[(20)]);
var inst_74135 = (state_74227[(8)]);
var inst_74142 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_74123);
var state_74227__$1 = (function (){var statearr_74265 = state_74227;
(statearr_74265[(23)] = inst_74142);

return statearr_74265;
})();
if(cljs.core.truth_(inst_74135)){
var statearr_74266_74319 = state_74227__$1;
(statearr_74266_74319[(1)] = (14));

} else {
var statearr_74267_74320 = state_74227__$1;
(statearr_74267_74320[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (9))){
var inst_74134 = (state_74227[(2)]);
var inst_74135 = cljs.core.nth.call(null,inst_74134,(0),null);
var inst_74136 = cljs.core.nth.call(null,inst_74134,(1),null);
var inst_74137 = cljs.core.contains_QMARK_.call(null,query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_74227__$1 = (function (){var statearr_74268 = state_74227;
(statearr_74268[(9)] = inst_74136);

(statearr_74268[(8)] = inst_74135);

return statearr_74268;
})();
if(inst_74137){
var statearr_74269_74321 = state_74227__$1;
(statearr_74269_74321[(1)] = (11));

} else {
var statearr_74270_74322 = state_74227__$1;
(statearr_74270_74322[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (5))){
var _ = (function (){var statearr_74271 = state_74227;
(statearr_74271[(4)] = cljs.core.rest.call(null,(state_74227[(4)])));

return statearr_74271;
})();
var state_74227__$1 = state_74227;
var ex74264 = (state_74227__$1[(2)]);
var statearr_74272_74323 = state_74227__$1;
(statearr_74272_74323[(5)] = ex74264);


if((ex74264 instanceof Error)){
var statearr_74273_74324 = state_74227__$1;
(statearr_74273_74324[(1)] = (4));

(statearr_74273_74324[(5)] = null);

} else {
throw ex74264;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (14))){
var inst_74135 = (state_74227[(8)]);
var inst_74144 = cljs.core.not_EQ_.call(null,(1),inst_74135);
var state_74227__$1 = state_74227;
var statearr_74274_74325 = state_74227__$1;
(statearr_74274_74325[(2)] = inst_74144);

(statearr_74274_74325[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (26))){
var inst_74122 = (state_74227[(18)]);
var inst_74180 = cljs.core.set.call(null,inst_74122);
var state_74227__$1 = state_74227;
var statearr_74275_74326 = state_74227__$1;
(statearr_74275_74326[(2)] = inst_74180);

(statearr_74275_74326[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (16))){
var inst_74147 = (state_74227[(2)]);
var state_74227__$1 = state_74227;
if(cljs.core.truth_(inst_74147)){
var statearr_74276_74327 = state_74227__$1;
(statearr_74276_74327[(1)] = (17));

} else {
var statearr_74277_74328 = state_74227__$1;
(statearr_74277_74328[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (38))){
var inst_74142 = (state_74227[(23)]);
var inst_74204 = (state_74227[(2)]);
var state_74227__$1 = (function (){var statearr_74278 = state_74227;
(statearr_74278[(13)] = inst_74204);

return statearr_74278;
})();
if(cljs.core.truth_(inst_74142)){
var statearr_74279_74329 = state_74227__$1;
(statearr_74279_74329[(1)] = (40));

} else {
var statearr_74280_74330 = state_74227__$1;
(statearr_74280_74330[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (30))){
var inst_74121 = (state_74227[(17)]);
var state_74227__$1 = state_74227;
var statearr_74281_74331 = state_74227__$1;
(statearr_74281_74331[(2)] = inst_74121);

(statearr_74281_74331[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (10))){
var inst_74130 = (state_74227[(2)]);
var inst_74131 = fluree.db.util.async.throw_err.call(null,inst_74130);
var state_74227__$1 = state_74227;
var statearr_74282_74332 = state_74227__$1;
(statearr_74282_74332[(2)] = inst_74131);

(statearr_74282_74332[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (18))){
var state_74227__$1 = state_74227;
var statearr_74283_74333 = state_74227__$1;
(statearr_74283_74333[(2)] = (-1));

(statearr_74283_74333[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (42))){
var inst_74212 = (state_74227[(2)]);
var state_74227__$1 = state_74227;
var statearr_74284_74334 = state_74227__$1;
(statearr_74284_74334[(2)] = inst_74212);

(statearr_74284_74334[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (37))){
var inst_74191 = (state_74227[(15)]);
var inst_74202 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_74191);
var state_74227__$1 = state_74227;
var statearr_74285_74335 = state_74227__$1;
(statearr_74285_74335[(2)] = inst_74202);

(statearr_74285_74335[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74228 === (8))){
var state_74227__$1 = state_74227;
var statearr_74286_74336 = state_74227__$1;
(statearr_74286_74336[(2)] = null);

(statearr_74286_74336[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_74287 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74287[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2746__auto__);

(statearr_74287[(1)] = (1));

return statearr_74287;
});
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1 = (function (state_74227){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74288){var ex__2749__auto__ = e74288;
var statearr_74289_74337 = state_74227;
(statearr_74289_74337[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74227[(4)]))){
var statearr_74290_74338 = state_74227;
(statearr_74290_74338[(1)] = cljs.core.first.call(null,(state_74227[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74339 = state_74227;
state_74227 = G__74339;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = function(state_74227){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1.call(this,state_74227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74291 = f__2769__auto__.call(null);
(statearr_74291[(6)] = c__2768__auto__);

return statearr_74291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74472){
var state_val_74473 = (state_74472[(1)]);
if((state_val_74473 === (7))){
var inst_74369 = cljs.core.pr_str.call(null,flureeQL);
var inst_74370 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_74369].join('');
var inst_74371 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74372 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74373 = cljs.core.PersistentHashMap.fromArrays(inst_74371,inst_74372);
var inst_74374 = cljs.core.ex_info.call(null,inst_74370,inst_74373);
var inst_74375 = (function(){throw inst_74374})();
var state_74472__$1 = state_74472;
var statearr_74474_74553 = state_74472__$1;
(statearr_74474_74553[(2)] = inst_74375);

(statearr_74474_74553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (20))){
var inst_74407 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
if(cljs.core.truth_(inst_74407)){
var statearr_74475_74554 = state_74472__$1;
(statearr_74475_74554[(1)] = (21));

} else {
var statearr_74476_74555 = state_74472__$1;
(statearr_74476_74555[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (27))){
var inst_74351 = (state_74472[(7)]);
var state_74472__$1 = state_74472;
var statearr_74477_74556 = state_74472__$1;
(statearr_74477_74556[(2)] = inst_74351);

(statearr_74477_74556[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (1))){
var state_74472__$1 = state_74472;
var statearr_74478_74557 = state_74472__$1;
(statearr_74478_74557[(2)] = null);

(statearr_74478_74557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (24))){
var inst_74413 = (state_74472[(8)]);
var state_74472__$1 = state_74472;
var statearr_74479_74558 = state_74472__$1;
(statearr_74479_74558[(2)] = inst_74413);

(statearr_74479_74558[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (39))){
var inst_74357 = (state_74472[(9)]);
var state_74472__$1 = state_74472;
if(cljs.core.truth_(inst_74357)){
var statearr_74480_74559 = state_74472__$1;
(statearr_74480_74559[(1)] = (42));

} else {
var statearr_74481_74560 = state_74472__$1;
(statearr_74481_74560[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (46))){
var inst_74445 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74446 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74447 = cljs.core.PersistentHashMap.fromArrays(inst_74445,inst_74446);
var inst_74448 = cljs.core.ex_info.call(null,"Invalid query.",inst_74447);
var inst_74449 = (function(){throw inst_74448})();
var state_74472__$1 = state_74472;
var statearr_74482_74561 = state_74472__$1;
(statearr_74482_74561[(2)] = inst_74449);

(statearr_74482_74561[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (4))){
var inst_74341 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
var statearr_74483_74562 = state_74472__$1;
(statearr_74483_74562[(2)] = inst_74341);

(statearr_74483_74562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (15))){
var inst_74392 = (state_74472[(10)]);
var inst_74354 = (state_74472[(11)]);
var inst_74394 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_74392);
var inst_74395 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_74392);
var inst_74396 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_74392);
var inst_74397 = fluree.db.api.query.get_sources.call(null,inst_74394,inst_74395,inst_74396,inst_74354);
var state_74472__$1 = state_74472;
var statearr_74484_74563 = state_74472__$1;
(statearr_74484_74563[(2)] = inst_74397);

(statearr_74484_74563[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (48))){
var inst_74402 = (state_74472[(12)]);
var inst_74456 = (state_74472[(2)]);
var inst_74457 = fluree.db.util.async.throw_err.call(null,inst_74456);
var state_74472__$1 = (function (){var statearr_74485 = state_74472;
(statearr_74485[(13)] = inst_74457);

return statearr_74485;
})();
if(cljs.core.truth_(inst_74402)){
var statearr_74486_74564 = state_74472__$1;
(statearr_74486_74564[(1)] = (49));

} else {
var statearr_74487_74565 = state_74472__$1;
(statearr_74487_74565[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (50))){
var inst_74457 = (state_74472[(13)]);
var state_74472__$1 = state_74472;
var statearr_74488_74566 = state_74472__$1;
(statearr_74488_74566[(2)] = inst_74457);

(statearr_74488_74566[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (21))){
var inst_74409 = cljs.core.volatile_BANG_.call(null,(0));
var state_74472__$1 = state_74472;
var statearr_74489_74567 = state_74472__$1;
(statearr_74489_74567[(2)] = inst_74409);

(statearr_74489_74567[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (31))){
var inst_74355 = (state_74472[(14)]);
var state_74472__$1 = state_74472;
if(cljs.core.truth_(inst_74355)){
var statearr_74490_74568 = state_74472__$1;
(statearr_74490_74568[(1)] = (33));

} else {
var statearr_74491_74569 = state_74472__$1;
(statearr_74491_74569[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (32))){
var inst_74432 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
var statearr_74492_74570 = state_74472__$1;
(statearr_74492_74570[(2)] = inst_74432);

(statearr_74492_74570[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (40))){
var inst_74434 = (state_74472[(15)]);
var state_74472__$1 = state_74472;
var statearr_74493_74571 = state_74472__$1;
(statearr_74493_74571[(2)] = inst_74434);

(statearr_74493_74571[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (33))){
var inst_74355 = (state_74472[(14)]);
var state_74472__$1 = state_74472;
var statearr_74494_74572 = state_74472__$1;
(statearr_74494_74572[(2)] = inst_74355);

(statearr_74494_74572[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (13))){
var inst_74352 = (state_74472[(16)]);
var inst_74381 = (state_74472[(2)]);
var inst_74382 = fluree.db.util.async.throw_err.call(null,inst_74381);
var inst_74383 = fluree.db.time_travel.as_of_block.call(null,inst_74382,inst_74352);
var state_74472__$1 = state_74472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74472__$1,(12),inst_74383);
} else {
if((state_val_74473 === (22))){
var state_74472__$1 = state_74472;
var statearr_74495_74573 = state_74472__$1;
(statearr_74495_74573[(2)] = null);

(statearr_74495_74573[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (36))){
var inst_74359 = (state_74472[(17)]);
var state_74472__$1 = state_74472;
var statearr_74496_74574 = state_74472__$1;
(statearr_74496_74574[(2)] = inst_74359);

(statearr_74496_74574[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (41))){
var inst_74442 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
if(cljs.core.truth_(inst_74442)){
var statearr_74497_74575 = state_74472__$1;
(statearr_74497_74575[(1)] = (45));

} else {
var statearr_74498_74576 = state_74472__$1;
(statearr_74498_74576[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (43))){
var inst_74353 = (state_74472[(18)]);
var state_74472__$1 = state_74472;
var statearr_74499_74577 = state_74472__$1;
(statearr_74499_74577[(2)] = inst_74353);

(statearr_74499_74577[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (29))){
var inst_74434 = (state_74472[(15)]);
var inst_74434__$1 = (state_74472[(2)]);
var state_74472__$1 = (function (){var statearr_74500 = state_74472;
(statearr_74500[(15)] = inst_74434__$1);

return statearr_74500;
})();
if(cljs.core.truth_(inst_74434__$1)){
var statearr_74501_74578 = state_74472__$1;
(statearr_74501_74578[(1)] = (39));

} else {
var statearr_74502_74579 = state_74472__$1;
(statearr_74502_74579[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (44))){
var inst_74439 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
var statearr_74503_74580 = state_74472__$1;
(statearr_74503_74580[(2)] = inst_74439);

(statearr_74503_74580[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (6))){
var state_74472__$1 = state_74472;
var statearr_74504_74581 = state_74472__$1;
(statearr_74504_74581[(2)] = null);

(statearr_74504_74581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (28))){
var inst_74356 = (state_74472[(19)]);
var state_74472__$1 = state_74472;
if(cljs.core.truth_(inst_74356)){
var statearr_74505_74582 = state_74472__$1;
(statearr_74505_74582[(1)] = (30));

} else {
var statearr_74506_74583 = state_74472__$1;
(statearr_74506_74583[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (51))){
var inst_74467 = (state_74472[(2)]);
var _ = (function (){var statearr_74507 = state_74472;
(statearr_74507[(4)] = cljs.core.rest.call(null,(state_74472[(4)])));

return statearr_74507;
})();
var state_74472__$1 = state_74472;
var statearr_74508_74584 = state_74472__$1;
(statearr_74508_74584[(2)] = inst_74467);

(statearr_74508_74584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (25))){
var state_74472__$1 = state_74472;
var statearr_74509_74585 = state_74472__$1;
(statearr_74509_74585[(2)] = (1000000));

(statearr_74509_74585[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (34))){
var inst_74359 = (state_74472[(17)]);
var state_74472__$1 = state_74472;
if(cljs.core.truth_(inst_74359)){
var statearr_74510_74586 = state_74472__$1;
(statearr_74510_74586[(1)] = (36));

} else {
var statearr_74511_74587 = state_74472__$1;
(statearr_74511_74587[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (17))){
var inst_74358 = (state_74472[(20)]);
var inst_74403 = (state_74472[(21)]);
var inst_74401 = (state_74472[(2)]);
var inst_74402 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_74358);
var inst_74403__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_74358);
var state_74472__$1 = (function (){var statearr_74512 = state_74472;
(statearr_74512[(12)] = inst_74402);

(statearr_74512[(22)] = inst_74401);

(statearr_74512[(21)] = inst_74403__$1);

return statearr_74512;
})();
if(cljs.core.truth_(inst_74403__$1)){
var statearr_74513_74588 = state_74472__$1;
(statearr_74513_74588[(1)] = (18));

} else {
var statearr_74514_74589 = state_74472__$1;
(statearr_74514_74589[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (3))){
var inst_74470 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74472__$1,inst_74470);
} else {
if((state_val_74473 === (12))){
var inst_74385 = (state_74472[(2)]);
var inst_74386 = fluree.db.util.async.throw_err.call(null,inst_74385);
var state_74472__$1 = state_74472;
var statearr_74515_74590 = state_74472__$1;
(statearr_74515_74590[(2)] = inst_74386);

(statearr_74515_74590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (2))){
var inst_74351 = (state_74472[(7)]);
var inst_74359 = (state_74472[(17)]);
var inst_74355 = (state_74472[(14)]);
var inst_74356 = (state_74472[(19)]);
var inst_74357 = (state_74472[(9)]);
var inst_74358 = (state_74472[(20)]);
var inst_74354 = (state_74472[(11)]);
var inst_74353 = (state_74472[(18)]);
var inst_74352 = (state_74472[(16)]);
var inst_74350 = (state_74472[(23)]);
var _ = (function (){var statearr_74516 = state_74472;
(statearr_74516[(4)] = cljs.core.cons.call(null,(5),(state_74472[(4)])));

return statearr_74516;
})();
var inst_74348 = flureeQL;
var inst_74349 = cljs.core.__destructure_map.call(null,inst_74348);
var inst_74350__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_74351__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_74352__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74353__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_74354__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_74355__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_74356__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_74357__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_74358__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_74359__$1 = cljs.core.get.call(null,inst_74349,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_74360 = (function (){var construct = inst_74350__$1;
var select = inst_74351__$1;
var block = inst_74352__$1;
var where = inst_74353__$1;
var prefixes = inst_74354__$1;
var selectDistinct = inst_74355__$1;
var selectOne = inst_74356__$1;
var from = inst_74357__$1;
var opts = inst_74358__$1;
var selectReduced = inst_74359__$1;
var map__74347 = inst_74349;
return (function (p1__74340_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__74340_SHARP_);
});
})();
var inst_74361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74362 = [inst_74351__$1,inst_74356__$1,inst_74355__$1,inst_74359__$1];
var inst_74363 = (new cljs.core.PersistentVector(null,4,(5),inst_74361,inst_74362,null));
var inst_74364 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_74363);
var inst_74365 = cljs.core.count.call(null,inst_74364);
var inst_74366 = inst_74360.call(null,inst_74365);
var state_74472__$1 = (function (){var statearr_74517 = state_74472;
(statearr_74517[(7)] = inst_74351__$1);

(statearr_74517[(17)] = inst_74359__$1);

(statearr_74517[(14)] = inst_74355__$1);

(statearr_74517[(19)] = inst_74356__$1);

(statearr_74517[(9)] = inst_74357__$1);

(statearr_74517[(20)] = inst_74358__$1);

(statearr_74517[(11)] = inst_74354__$1);

(statearr_74517[(18)] = inst_74353__$1);

(statearr_74517[(16)] = inst_74352__$1);

(statearr_74517[(23)] = inst_74350__$1);

return statearr_74517;
})();
if(cljs.core.truth_(inst_74366)){
var statearr_74518_74591 = state_74472__$1;
(statearr_74518_74591[(1)] = (6));

} else {
var statearr_74519_74592 = state_74472__$1;
(statearr_74519_74592[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (23))){
var inst_74358 = (state_74472[(20)]);
var inst_74413 = (state_74472[(8)]);
var inst_74412 = (state_74472[(2)]);
var inst_74413__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_74358);
var state_74472__$1 = (function (){var statearr_74520 = state_74472;
(statearr_74520[(24)] = inst_74412);

(statearr_74520[(8)] = inst_74413__$1);

return statearr_74520;
})();
if(cljs.core.truth_(inst_74413__$1)){
var statearr_74521_74593 = state_74472__$1;
(statearr_74521_74593[(1)] = (24));

} else {
var statearr_74522_74594 = state_74472__$1;
(statearr_74522_74594[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (47))){
var inst_74418 = (state_74472[(25)]);
var inst_74392 = (state_74472[(10)]);
var inst_74451 = (state_74472[(2)]);
var inst_74452 = fluree.db.util.core.current_time_millis.call(null);
var inst_74453 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74418);
var inst_74454 = fluree.db.query.fql.query.call(null,inst_74392,inst_74453);
var state_74472__$1 = (function (){var statearr_74523 = state_74472;
(statearr_74523[(26)] = inst_74451);

(statearr_74523[(27)] = inst_74452);

return statearr_74523;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74472__$1,(48),inst_74454);
} else {
if((state_val_74473 === (35))){
var inst_74430 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
var statearr_74524_74595 = state_74472__$1;
(statearr_74524_74595[(2)] = inst_74430);

(statearr_74524_74595[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (19))){
var inst_74402 = (state_74472[(12)]);
var state_74472__$1 = state_74472;
var statearr_74525_74596 = state_74472__$1;
(statearr_74525_74596[(2)] = inst_74402);

(statearr_74525_74596[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (11))){
var inst_74354 = (state_74472[(11)]);
var inst_74392 = (state_74472[(2)]);
var state_74472__$1 = (function (){var statearr_74527 = state_74472;
(statearr_74527[(10)] = inst_74392);

return statearr_74527;
})();
if(cljs.core.truth_(inst_74354)){
var statearr_74528_74597 = state_74472__$1;
(statearr_74528_74597[(1)] = (15));

} else {
var statearr_74529_74598 = state_74472__$1;
(statearr_74529_74598[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (9))){
var inst_74378 = (state_74472[(28)]);
var state_74472__$1 = state_74472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74472__$1,(13),inst_74378);
} else {
if((state_val_74473 === (5))){
var _ = (function (){var statearr_74530 = state_74472;
(statearr_74530[(4)] = cljs.core.rest.call(null,(state_74472[(4)])));

return statearr_74530;
})();
var state_74472__$1 = state_74472;
var ex74526 = (state_74472__$1[(2)]);
var statearr_74531_74599 = state_74472__$1;
(statearr_74531_74599[(5)] = ex74526);


if((ex74526 instanceof Error)){
var statearr_74532_74600 = state_74472__$1;
(statearr_74532_74600[(1)] = (4));

(statearr_74532_74600[(5)] = null);

} else {
throw ex74526;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (14))){
var inst_74389 = (state_74472[(2)]);
var inst_74390 = fluree.db.util.async.throw_err.call(null,inst_74389);
var state_74472__$1 = state_74472;
var statearr_74533_74601 = state_74472__$1;
(statearr_74533_74601[(2)] = inst_74390);

(statearr_74533_74601[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (45))){
var state_74472__$1 = state_74472;
var statearr_74534_74602 = state_74472__$1;
(statearr_74534_74602[(2)] = null);

(statearr_74534_74602[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (26))){
var inst_74351 = (state_74472[(7)]);
var inst_74412 = (state_74472[(24)]);
var inst_74401 = (state_74472[(22)]);
var inst_74358 = (state_74472[(20)]);
var inst_74417 = (state_74472[(2)]);
var inst_74418 = cljs.core.assoc.call(null,inst_74358,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_74401,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_74417,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74412);
var state_74472__$1 = (function (){var statearr_74535 = state_74472;
(statearr_74535[(25)] = inst_74418);

return statearr_74535;
})();
if(cljs.core.truth_(inst_74351)){
var statearr_74536_74603 = state_74472__$1;
(statearr_74536_74603[(1)] = (27));

} else {
var statearr_74537_74604 = state_74472__$1;
(statearr_74537_74604[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (16))){
var inst_74399 = cljs.core.PersistentHashMap.EMPTY;
var state_74472__$1 = state_74472;
var statearr_74538_74605 = state_74472__$1;
(statearr_74538_74605[(2)] = inst_74399);

(statearr_74538_74605[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (38))){
var inst_74428 = (state_74472[(2)]);
var state_74472__$1 = state_74472;
var statearr_74539_74606 = state_74472__$1;
(statearr_74539_74606[(2)] = inst_74428);

(statearr_74539_74606[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (30))){
var inst_74356 = (state_74472[(19)]);
var state_74472__$1 = state_74472;
var statearr_74540_74607 = state_74472__$1;
(statearr_74540_74607[(2)] = inst_74356);

(statearr_74540_74607[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (10))){
var inst_74378 = (state_74472[(28)]);
var state_74472__$1 = state_74472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74472__$1,(14),inst_74378);
} else {
if((state_val_74473 === (18))){
var inst_74403 = (state_74472[(21)]);
var state_74472__$1 = state_74472;
var statearr_74541_74608 = state_74472__$1;
(statearr_74541_74608[(2)] = inst_74403);

(statearr_74541_74608[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (42))){
var inst_74357 = (state_74472[(9)]);
var state_74472__$1 = state_74472;
var statearr_74542_74609 = state_74472__$1;
(statearr_74542_74609[(2)] = inst_74357);

(statearr_74542_74609[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (37))){
var inst_74350 = (state_74472[(23)]);
var state_74472__$1 = state_74472;
var statearr_74543_74610 = state_74472__$1;
(statearr_74543_74610[(2)] = inst_74350);

(statearr_74543_74610[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (8))){
var inst_74352 = (state_74472[(16)]);
var inst_74377 = (state_74472[(2)]);
var inst_74378 = sources;
var state_74472__$1 = (function (){var statearr_74544 = state_74472;
(statearr_74544[(29)] = inst_74377);

(statearr_74544[(28)] = inst_74378);

return statearr_74544;
})();
if(cljs.core.truth_(inst_74352)){
var statearr_74545_74611 = state_74472__$1;
(statearr_74545_74611[(1)] = (9));

} else {
var statearr_74546_74612 = state_74472__$1;
(statearr_74546_74612[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74473 === (49))){
var inst_74412 = (state_74472[(24)]);
var inst_74392 = (state_74472[(10)]);
var inst_74457 = (state_74472[(13)]);
var inst_74452 = (state_74472[(27)]);
var inst_74459 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_74460 = cljs.core.deref.call(null,inst_74412);
var inst_74461 = fluree.db.util.core.response_time_formatted.call(null,inst_74452);
var inst_74462 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74392);
var inst_74463 = [(200),inst_74457,inst_74460,inst_74461,inst_74462];
var inst_74464 = cljs.core.PersistentHashMap.fromArrays(inst_74459,inst_74463);
var state_74472__$1 = state_74472;
var statearr_74547_74613 = state_74472__$1;
(statearr_74547_74613[(2)] = inst_74464);

(statearr_74547_74613[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_74548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74548[(0)] = fluree$db$api$query$query_async_$_state_machine__2746__auto__);

(statearr_74548[(1)] = (1));

return statearr_74548;
});
var fluree$db$api$query$query_async_$_state_machine__2746__auto____1 = (function (state_74472){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74549){var ex__2749__auto__ = e74549;
var statearr_74550_74614 = state_74472;
(statearr_74550_74614[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74472[(4)]))){
var statearr_74551_74615 = state_74472;
(statearr_74551_74615[(1)] = cljs.core.first.call(null,(state_74472[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74616 = state_74472;
state_74472 = G__74616;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2746__auto__ = function(state_74472){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____1.call(this,state_74472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74552 = f__2769__auto__.call(null);
(statearr_74552[(6)] = c__2768__auto__);

return statearr_74552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74757){
var state_val_74758 = (state_74757[(1)]);
if((state_val_74758 === (7))){
var inst_74752 = (state_74757[(2)]);
var _ = (function (){var statearr_74759 = state_74757;
(statearr_74759[(4)] = cljs.core.rest.call(null,(state_74757[(4)])));

return statearr_74759;
})();
var state_74757__$1 = state_74757;
var statearr_74760_74836 = state_74757__$1;
(statearr_74760_74836[(2)] = inst_74752);

(statearr_74760_74836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (20))){
var inst_74724 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74761_74837 = state_74757__$1;
(statearr_74761_74837[(2)] = inst_74724);

(statearr_74761_74837[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (27))){
var inst_74704 = (state_74757[(7)]);
var state_74757__$1 = state_74757;
var statearr_74762_74838 = state_74757__$1;
(statearr_74762_74838[(2)] = inst_74704);

(statearr_74762_74838[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (1))){
var state_74757__$1 = state_74757;
var statearr_74763_74839 = state_74757__$1;
(statearr_74763_74839[(2)] = null);

(statearr_74763_74839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (24))){
var inst_74701 = (state_74757[(8)]);
var state_74757__$1 = state_74757;
var statearr_74764_74840 = state_74757__$1;
(statearr_74764_74840[(2)] = inst_74701);

(statearr_74764_74840[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (39))){
var inst_74691 = (state_74757[(9)]);
var inst_74658 = (state_74757[(10)]);
var inst_74669 = (state_74757[(11)]);
var inst_74735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74736 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_74669];
var inst_74737 = (new cljs.core.PersistentVector(null,2,(5),inst_74735,inst_74736,null));
var inst_74738 = cljs.core.assoc_in.call(null,inst_74658,inst_74737,inst_74691);
var state_74757__$1 = state_74757;
var statearr_74765_74841 = state_74757__$1;
(statearr_74765_74841[(2)] = inst_74738);

(statearr_74765_74841[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (4))){
var inst_74617 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74766_74842 = state_74757__$1;
(statearr_74766_74842[(2)] = inst_74617);

(statearr_74766_74842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (15))){
var inst_74691 = (state_74757[(9)]);
var inst_74656 = (state_74757[(12)]);
var inst_74694 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_74691);
var inst_74695 = (inst_74656 == null);
var state_74757__$1 = (function (){var statearr_74767 = state_74757;
(statearr_74767[(13)] = inst_74694);

return statearr_74767;
})();
if(cljs.core.truth_(inst_74695)){
var statearr_74768_74843 = state_74757__$1;
(statearr_74768_74843[(1)] = (18));

} else {
var statearr_74769_74844 = state_74757__$1;
(statearr_74769_74844[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (21))){
var inst_74694 = (state_74757[(13)]);
var state_74757__$1 = state_74757;
var statearr_74770_74845 = state_74757__$1;
(statearr_74770_74845[(2)] = inst_74694);

(statearr_74770_74845[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (31))){
var state_74757__$1 = state_74757;
var statearr_74771_74846 = state_74757__$1;
(statearr_74771_74846[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (32))){
var inst_74720 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74773_74847 = state_74757__$1;
(statearr_74773_74847[(2)] = inst_74720);

(statearr_74773_74847[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (40))){
var inst_74689 = (state_74757[(14)]);
var state_74757__$1 = state_74757;
if(cljs.core.truth_(inst_74689)){
var statearr_74774_74848 = state_74757__$1;
(statearr_74774_74848[(1)] = (42));

} else {
var statearr_74775_74849 = state_74757__$1;
(statearr_74775_74849[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (33))){
var inst_74656 = (state_74757[(12)]);
var inst_74694 = (state_74757[(13)]);
var inst_74715 = ((inst_74694 > inst_74656) ? inst_74694 : inst_74656);
var state_74757__$1 = state_74757;
var statearr_74776_74850 = state_74757__$1;
(statearr_74776_74850[(2)] = inst_74715);

(statearr_74776_74850[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (13))){
var inst_74680 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74777_74851 = state_74757__$1;
(statearr_74777_74851[(2)] = inst_74680);

(statearr_74777_74851[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (22))){
var inst_74701 = (state_74757[(8)]);
var inst_74694 = (state_74757[(13)]);
var inst_74701__$1 = cljs.core._EQ_.call(null,(200),inst_74694);
var state_74757__$1 = (function (){var statearr_74778 = state_74757;
(statearr_74778[(8)] = inst_74701__$1);

return statearr_74778;
})();
if(inst_74701__$1){
var statearr_74779_74852 = state_74757__$1;
(statearr_74779_74852[(1)] = (24));

} else {
var statearr_74780_74853 = state_74757__$1;
(statearr_74780_74853[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (36))){
var inst_74657 = (state_74757[(15)]);
var inst_74691 = (state_74757[(9)]);
var inst_74729 = cljs.core.get.call(null,inst_74691,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_74730 = (inst_74657 + inst_74729);
var state_74757__$1 = state_74757;
var statearr_74781_74854 = state_74757__$1;
(statearr_74781_74854[(2)] = inst_74730);

(statearr_74781_74854[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (41))){
var inst_74733 = (state_74757[(16)]);
var inst_74668 = (state_74757[(17)]);
var inst_74727 = (state_74757[(18)]);
var inst_74747 = (state_74757[(2)]);
var inst_74655 = inst_74668;
var inst_74656 = inst_74727;
var inst_74657 = inst_74733;
var inst_74658 = inst_74747;
var state_74757__$1 = (function (){var statearr_74782 = state_74757;
(statearr_74782[(15)] = inst_74657);

(statearr_74782[(19)] = inst_74655);

(statearr_74782[(12)] = inst_74656);

(statearr_74782[(10)] = inst_74658);

return statearr_74782;
})();
var statearr_74783_74855 = state_74757__$1;
(statearr_74783_74855[(2)] = null);

(statearr_74783_74855[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (43))){
var inst_74691 = (state_74757[(9)]);
var state_74757__$1 = state_74757;
var statearr_74784_74856 = state_74757__$1;
(statearr_74784_74856[(2)] = inst_74691);

(statearr_74784_74856[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (29))){
var inst_74709 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74785_74857 = state_74757__$1;
(statearr_74785_74857[(2)] = inst_74709);

(statearr_74785_74857[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (44))){
var inst_74658 = (state_74757[(10)]);
var inst_74669 = (state_74757[(11)]);
var inst_74744 = (state_74757[(2)]);
var inst_74745 = cljs.core.assoc.call(null,inst_74658,inst_74669,inst_74744);
var state_74757__$1 = state_74757;
var statearr_74786_74858 = state_74757__$1;
(statearr_74786_74858[(2)] = inst_74745);

(statearr_74786_74858[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (6))){
var inst_74655 = (state_74757[(19)]);
var inst_74670 = (state_74757[(20)]);
var inst_74666 = cljs.core.seq.call(null,inst_74655);
var inst_74667 = cljs.core.first.call(null,inst_74666);
var inst_74668 = cljs.core.next.call(null,inst_74666);
var inst_74669 = cljs.core.nth.call(null,inst_74667,(0),null);
var inst_74670__$1 = cljs.core.nth.call(null,inst_74667,(1),null);
var inst_74671 = (inst_74670__$1 == null);
var state_74757__$1 = (function (){var statearr_74787 = state_74757;
(statearr_74787[(17)] = inst_74668);

(statearr_74787[(20)] = inst_74670__$1);

(statearr_74787[(11)] = inst_74669);

return statearr_74787;
})();
if(cljs.core.truth_(inst_74671)){
var statearr_74788_74859 = state_74757__$1;
(statearr_74788_74859[(1)] = (8));

} else {
var statearr_74789_74860 = state_74757__$1;
(statearr_74789_74860[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (28))){
var inst_74656 = (state_74757[(12)]);
var inst_74707 = cljs.core._EQ_.call(null,(207),inst_74656);
var state_74757__$1 = state_74757;
var statearr_74790_74861 = state_74757__$1;
(statearr_74790_74861[(2)] = inst_74707);

(statearr_74790_74861[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (25))){
var inst_74704 = (state_74757[(7)]);
var inst_74656 = (state_74757[(12)]);
var inst_74704__$1 = cljs.core._EQ_.call(null,(200),inst_74656);
var state_74757__$1 = (function (){var statearr_74791 = state_74757;
(statearr_74791[(7)] = inst_74704__$1);

return statearr_74791;
})();
if(inst_74704__$1){
var statearr_74792_74862 = state_74757__$1;
(statearr_74792_74862[(1)] = (27));

} else {
var statearr_74793_74863 = state_74757__$1;
(statearr_74793_74863[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (34))){
var state_74757__$1 = state_74757;
var statearr_74794_74864 = state_74757__$1;
(statearr_74794_74864[(2)] = null);

(statearr_74794_74864[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (17))){
var inst_74688 = (state_74757[(21)]);
var inst_74727 = (state_74757[(2)]);
var state_74757__$1 = (function (){var statearr_74795 = state_74757;
(statearr_74795[(18)] = inst_74727);

return statearr_74795;
})();
if(cljs.core.truth_(inst_74688)){
var statearr_74796_74865 = state_74757__$1;
(statearr_74796_74865[(1)] = (36));

} else {
var statearr_74797_74866 = state_74757__$1;
(statearr_74797_74866[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (3))){
var inst_74755 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74757__$1,inst_74755);
} else {
if((state_val_74758 === (12))){
var inst_74658 = (state_74757[(10)]);
var state_74757__$1 = state_74757;
var statearr_74798_74867 = state_74757__$1;
(statearr_74798_74867[(2)] = inst_74658);

(statearr_74798_74867[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (2))){
var inst_74632 = (state_74757[(22)]);
var inst_74627 = (state_74757[(23)]);
var inst_74631 = (state_74757[(24)]);
var _ = (function (){var statearr_74799 = state_74757;
(statearr_74799[(4)] = cljs.core.cons.call(null,(5),(state_74757[(4)])));

return statearr_74799;
})();
var inst_74623 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_74624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74625 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_74626 = (new cljs.core.PersistentVector(null,2,(5),inst_74624,inst_74625,null));
var inst_74627__$1 = cljs.core.get_in.call(null,flureeQL,inst_74626);
var inst_74628 = (function (){var global_block = inst_74623;
var global_meta_QMARK_ = inst_74627__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_74629 = cljs.core.PersistentHashMap.EMPTY;
var inst_74630 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_74631__$1 = cljs.core.reduce_kv.call(null,inst_74628,inst_74629,inst_74630);
var inst_74632__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_74634 = (function (){var global_block = inst_74623;
var global_meta_QMARK_ = inst_74627__$1;
var queries = inst_74631__$1;
var start_time = inst_74632__$1;
return (function (p__74633){
var vec__74800 = p__74633;
var alias = cljs.core.nth.call(null,vec__74800,(0),null);
var q = cljs.core.nth.call(null,vec__74800,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_74635 = cljs.core.map.call(null,inst_74634,inst_74631__$1);
var inst_74649 = cljs.core.seq.call(null,inst_74635);
var inst_74650 = cljs.core.first.call(null,inst_74649);
var inst_74651 = cljs.core.next.call(null,inst_74649);
var inst_74652 = cljs.core.nth.call(null,inst_74650,(0),null);
var inst_74653 = cljs.core.nth.call(null,inst_74650,(1),null);
var inst_74654 = cljs.core.PersistentHashMap.EMPTY;
var inst_74655 = inst_74635;
var inst_74656 = null;
var inst_74657 = (0);
var inst_74658 = inst_74654;
var state_74757__$1 = (function (){var statearr_74803 = state_74757;
(statearr_74803[(22)] = inst_74632__$1);

(statearr_74803[(15)] = inst_74657);

(statearr_74803[(23)] = inst_74627__$1);

(statearr_74803[(25)] = inst_74652);

(statearr_74803[(26)] = inst_74651);

(statearr_74803[(19)] = inst_74655);

(statearr_74803[(24)] = inst_74631__$1);

(statearr_74803[(12)] = inst_74656);

(statearr_74803[(10)] = inst_74658);

(statearr_74803[(27)] = inst_74653);

return statearr_74803;
})();
var statearr_74804_74868 = state_74757__$1;
(statearr_74804_74868[(2)] = null);

(statearr_74804_74868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (23))){
var inst_74722 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74805_74869 = state_74757__$1;
(statearr_74805_74869[(2)] = inst_74722);

(statearr_74805_74869[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (35))){
var inst_74718 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74806_74870 = state_74757__$1;
(statearr_74806_74870[(2)] = inst_74718);

(statearr_74806_74870[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (19))){
var inst_74656 = (state_74757[(12)]);
var inst_74694 = (state_74757[(13)]);
var inst_74698 = cljs.core._EQ_.call(null,inst_74656,inst_74694);
var state_74757__$1 = state_74757;
if(inst_74698){
var statearr_74807_74871 = state_74757__$1;
(statearr_74807_74871[(1)] = (21));

} else {
var statearr_74808_74872 = state_74757__$1;
(statearr_74808_74872[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (11))){
var inst_74632 = (state_74757[(22)]);
var inst_74657 = (state_74757[(15)]);
var inst_74656 = (state_74757[(12)]);
var inst_74658 = (state_74757[(10)]);
var inst_74674 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_74675 = fluree.db.util.core.response_time_formatted.call(null,inst_74632);
var inst_74676 = [inst_74658,inst_74657,inst_74656,inst_74675];
var inst_74677 = cljs.core.PersistentHashMap.fromArrays(inst_74674,inst_74676);
var state_74757__$1 = state_74757;
var statearr_74810_74873 = state_74757__$1;
(statearr_74810_74873[(2)] = inst_74677);

(statearr_74810_74873[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (9))){
var inst_74670 = (state_74757[(20)]);
var inst_74631 = (state_74757[(24)]);
var inst_74669 = (state_74757[(11)]);
var inst_74683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74684 = [inst_74669,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_74685 = (new cljs.core.PersistentVector(null,2,(5),inst_74683,inst_74684,null));
var inst_74686 = cljs.core.get_in.call(null,inst_74631,inst_74685);
var inst_74687 = cljs.core.__destructure_map.call(null,inst_74686);
var inst_74688 = cljs.core.get.call(null,inst_74687,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_74689 = cljs.core.get.call(null,inst_74687,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_74757__$1 = (function (){var statearr_74811 = state_74757;
(statearr_74811[(14)] = inst_74689);

(statearr_74811[(21)] = inst_74688);

return statearr_74811;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74757__$1,(14),inst_74670);
} else {
if((state_val_74758 === (5))){
var _ = (function (){var statearr_74812 = state_74757;
(statearr_74812[(4)] = cljs.core.rest.call(null,(state_74757[(4)])));

return statearr_74812;
})();
var state_74757__$1 = state_74757;
var ex74809 = (state_74757__$1[(2)]);
var statearr_74813_74874 = state_74757__$1;
(statearr_74813_74874[(5)] = ex74809);


var statearr_74814_74875 = state_74757__$1;
(statearr_74814_74875[(1)] = (4));

(statearr_74814_74875[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (14))){
var inst_74691 = (state_74757[(9)]);
var inst_74688 = (state_74757[(21)]);
var inst_74691__$1 = (state_74757[(2)]);
var inst_74692 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_74691__$1);
var state_74757__$1 = (function (){var statearr_74815 = state_74757;
(statearr_74815[(9)] = inst_74691__$1);

(statearr_74815[(28)] = inst_74692);

return statearr_74815;
})();
if(cljs.core.truth_(inst_74688)){
var statearr_74816_74876 = state_74757__$1;
(statearr_74816_74876[(1)] = (15));

} else {
var statearr_74817_74877 = state_74757__$1;
(statearr_74817_74877[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (26))){
var inst_74711 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
if(cljs.core.truth_(inst_74711)){
var statearr_74818_74878 = state_74757__$1;
(statearr_74818_74878[(1)] = (30));

} else {
var statearr_74819_74879 = state_74757__$1;
(statearr_74819_74879[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (16))){
var state_74757__$1 = state_74757;
var statearr_74820_74880 = state_74757__$1;
(statearr_74820_74880[(2)] = null);

(statearr_74820_74880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (38))){
var inst_74692 = (state_74757[(28)]);
var inst_74733 = (state_74757[(2)]);
var state_74757__$1 = (function (){var statearr_74821 = state_74757;
(statearr_74821[(16)] = inst_74733);

return statearr_74821;
})();
if(cljs.core.truth_(inst_74692)){
var statearr_74822_74881 = state_74757__$1;
(statearr_74822_74881[(1)] = (39));

} else {
var statearr_74823_74882 = state_74757__$1;
(statearr_74823_74882[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (30))){
var state_74757__$1 = state_74757;
var statearr_74824_74883 = state_74757__$1;
(statearr_74824_74883[(2)] = (207));

(statearr_74824_74883[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (10))){
var inst_74750 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74825_74884 = state_74757__$1;
(statearr_74825_74884[(2)] = inst_74750);

(statearr_74825_74884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (18))){
var inst_74694 = (state_74757[(13)]);
var state_74757__$1 = state_74757;
var statearr_74826_74885 = state_74757__$1;
(statearr_74826_74885[(2)] = inst_74694);

(statearr_74826_74885[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (42))){
var inst_74691 = (state_74757[(9)]);
var inst_74741 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_74691);
var state_74757__$1 = state_74757;
var statearr_74827_74886 = state_74757__$1;
(statearr_74827_74886[(2)] = inst_74741);

(statearr_74827_74886[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (37))){
var state_74757__$1 = state_74757;
var statearr_74828_74887 = state_74757__$1;
(statearr_74828_74887[(2)] = null);

(statearr_74828_74887[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74758 === (8))){
var inst_74627 = (state_74757[(23)]);
var state_74757__$1 = state_74757;
if(cljs.core.truth_(inst_74627)){
var statearr_74829_74888 = state_74757__$1;
(statearr_74829_74888[(1)] = (11));

} else {
var statearr_74830_74889 = state_74757__$1;
(statearr_74830_74889[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_74831 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74831[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__);

(statearr_74831[(1)] = (1));

return statearr_74831;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1 = (function (state_74757){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74832){var ex__2749__auto__ = e74832;
var statearr_74833_74890 = state_74757;
(statearr_74833_74890[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74757[(4)]))){
var statearr_74834_74891 = state_74757;
(statearr_74834_74891[(1)] = cljs.core.first.call(null,(state_74757[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74892 = state_74757;
state_74757 = G__74892;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = function(state_74757){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1.call(this,state_74757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74835 = f__2769__auto__.call(null);
(statearr_74835[(6)] = c__2768__auto__);

return statearr_74835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__74893 = query_type;
var G__74893__$1 = (((G__74893 instanceof cljs.core.Keyword))?G__74893.fqn:null);
switch (G__74893__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__74893__$1)].join('')));

}
});
