// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___66817 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66868){
var state_val_66869 = (state_66868[(1)]);
if((state_val_66869 === (7))){
var inst_66863 = (state_66868[(2)]);
var _ = (function (){var statearr_66870 = state_66868;
(statearr_66870[(4)] = cljs.core.rest.call(null,(state_66868[(4)])));

return statearr_66870;
})();
var state_66868__$1 = state_66868;
var statearr_66871_66898 = state_66868__$1;
(statearr_66871_66898[(2)] = inst_66863);

(statearr_66871_66898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (1))){
var state_66868__$1 = state_66868;
var statearr_66872_66899 = state_66868__$1;
(statearr_66872_66899[(2)] = null);

(statearr_66872_66899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (4))){
var inst_66818 = (state_66868[(2)]);
var state_66868__$1 = state_66868;
var statearr_66873_66900 = state_66868__$1;
(statearr_66873_66900[(2)] = inst_66818);

(statearr_66873_66900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (13))){
var inst_66859 = (state_66868[(2)]);
var state_66868__$1 = state_66868;
var statearr_66874_66901 = state_66868__$1;
(statearr_66874_66901[(2)] = inst_66859);

(statearr_66874_66901[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (6))){
var inst_66843 = (state_66868[(7)]);
var inst_66836 = (state_66868[(8)]);
var inst_66842 = cljs.core.seq.call(null,inst_66836);
var inst_66843__$1 = cljs.core.first.call(null,inst_66842);
var inst_66844 = cljs.core.next.call(null,inst_66842);
var inst_66845 = cljs.core.not.call(null,inst_66843__$1);
var state_66868__$1 = (function (){var statearr_66875 = state_66868;
(statearr_66875[(7)] = inst_66843__$1);

(statearr_66875[(9)] = inst_66844);

return statearr_66875;
})();
if(inst_66845){
var statearr_66876_66902 = state_66868__$1;
(statearr_66876_66902[(1)] = (8));

} else {
var statearr_66877_66903 = state_66868__$1;
(statearr_66877_66903[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (3))){
var inst_66866 = (state_66868[(2)]);
var state_66868__$1 = state_66868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66868__$1,inst_66866);
} else {
if((state_val_66869 === (12))){
var inst_66843 = (state_66868[(7)]);
var inst_66844 = (state_66868[(9)]);
var inst_66837 = (state_66868[(10)]);
var inst_66856 = cljs.core.conj.call(null,inst_66837,inst_66843);
var inst_66836 = inst_66844;
var inst_66837__$1 = inst_66856;
var state_66868__$1 = (function (){var statearr_66878 = state_66868;
(statearr_66878[(8)] = inst_66836);

(statearr_66878[(10)] = inst_66837__$1);

return statearr_66878;
})();
var statearr_66879_66904 = state_66868__$1;
(statearr_66879_66904[(2)] = null);

(statearr_66879_66904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (2))){
var _ = (function (){var statearr_66880 = state_66868;
(statearr_66880[(4)] = cljs.core.cons.call(null,(5),(state_66868[(4)])));

return statearr_66880;
})();
var inst_66831 = args;
var inst_66832 = cljs.core.seq.call(null,inst_66831);
var inst_66833 = cljs.core.first.call(null,inst_66832);
var inst_66834 = cljs.core.next.call(null,inst_66832);
var inst_66835 = cljs.core.PersistentVector.EMPTY;
var inst_66836 = inst_66831;
var inst_66837 = inst_66835;
var state_66868__$1 = (function (){var statearr_66881 = state_66868;
(statearr_66881[(8)] = inst_66836);

(statearr_66881[(10)] = inst_66837);

(statearr_66881[(11)] = inst_66833);

(statearr_66881[(12)] = inst_66834);

return statearr_66881;
})();
var statearr_66882_66905 = state_66868__$1;
(statearr_66882_66905[(2)] = null);

(statearr_66882_66905[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (11))){
var inst_66843 = (state_66868[(7)]);
var state_66868__$1 = state_66868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66868__$1,(14),inst_66843);
} else {
if((state_val_66869 === (9))){
var inst_66843 = (state_66868[(7)]);
var inst_66848 = fluree.db.util.async.channel_QMARK_.call(null,inst_66843);
var state_66868__$1 = state_66868;
if(inst_66848){
var statearr_66884_66906 = state_66868__$1;
(statearr_66884_66906[(1)] = (11));

} else {
var statearr_66885_66907 = state_66868__$1;
(statearr_66885_66907[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (5))){
var _ = (function (){var statearr_66886 = state_66868;
(statearr_66886[(4)] = cljs.core.rest.call(null,(state_66868[(4)])));

return statearr_66886;
})();
var state_66868__$1 = state_66868;
var ex66883 = (state_66868__$1[(2)]);
var statearr_66887_66908 = state_66868__$1;
(statearr_66887_66908[(5)] = ex66883);


if((ex66883 instanceof Error)){
var statearr_66888_66909 = state_66868__$1;
(statearr_66888_66909[(1)] = (4));

(statearr_66888_66909[(5)] = null);

} else {
throw ex66883;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (14))){
var inst_66844 = (state_66868[(9)]);
var inst_66837 = (state_66868[(10)]);
var inst_66851 = (state_66868[(2)]);
var inst_66852 = fluree.db.util.async.throw_err.call(null,inst_66851);
var inst_66853 = cljs.core.conj.call(null,inst_66837,inst_66852);
var inst_66836 = inst_66844;
var inst_66837__$1 = inst_66853;
var state_66868__$1 = (function (){var statearr_66889 = state_66868;
(statearr_66889[(8)] = inst_66836);

(statearr_66889[(10)] = inst_66837__$1);

return statearr_66889;
})();
var statearr_66890_66910 = state_66868__$1;
(statearr_66890_66910[(2)] = null);

(statearr_66890_66910[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (10))){
var inst_66861 = (state_66868[(2)]);
var state_66868__$1 = state_66868;
var statearr_66891_66911 = state_66868__$1;
(statearr_66891_66911[(2)] = inst_66861);

(statearr_66891_66911[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66869 === (8))){
var inst_66837 = (state_66868[(10)]);
var state_66868__$1 = state_66868;
var statearr_66892_66912 = state_66868__$1;
(statearr_66892_66912[(2)] = inst_66837);

(statearr_66892_66912[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0 = (function (){
var statearr_66893 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66893[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__);

(statearr_66893[(1)] = (1));

return statearr_66893;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1 = (function (state_66868){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66894){var ex__2749__auto__ = e66894;
var statearr_66895_66913 = state_66868;
(statearr_66895_66913[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66868[(4)]))){
var statearr_66896_66914 = state_66868;
(statearr_66896_66914[(1)] = cljs.core.first.call(null,(state_66868[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66915 = state_66868;
state_66868 = G__66915;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = function(state_66868){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1.call(this,state_66868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66897 = f__2769__auto__.call(null);
(statearr_66897[(6)] = c__2768__auto__);

return statearr_66897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__66917 = entry;
var res = cljs.core.nth.call(null,vec__66917,(0),null);
var cost = cljs.core.nth.call(null,vec__66917,(1),null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__66916_SHARP_){
return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,p1__66916_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66965){
var state_val_66966 = (state_66965[(1)]);
if((state_val_66966 === (7))){
var state_66965__$1 = state_66965;
var statearr_66967_66996 = state_66965__$1;
(statearr_66967_66996[(2)] = coll);

(statearr_66967_66996[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (1))){
var state_66965__$1 = state_66965;
var statearr_66968_66997 = state_66965__$1;
(statearr_66968_66997[(2)] = null);

(statearr_66968_66997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (4))){
var inst_66920 = (state_66965[(2)]);
var state_66965__$1 = state_66965;
var statearr_66969_66998 = state_66965__$1;
(statearr_66969_66998[(2)] = inst_66920);

(statearr_66969_66998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (15))){
var inst_66939 = (state_66965[(7)]);
var inst_66947 = (state_66965[(2)]);
var inst_66948 = fluree.db.dbfunctions.internal.nth.call(null,inst_66939,inst_66947);
var inst_66949 = cljs.core.count.call(null,inst_66939);
var inst_66950 = ((9) + inst_66949);
var inst_66951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66952 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66954 = [inst_66939,inst_66947];
var inst_66955 = (new cljs.core.PersistentVector(null,2,(5),inst_66953,inst_66954,null));
var inst_66956 = ["nth",inst_66955,inst_66948];
var inst_66957 = cljs.core.PersistentHashMap.fromArrays(inst_66952,inst_66956);
var inst_66958 = [inst_66957,inst_66950];
var inst_66959 = (new cljs.core.PersistentVector(null,2,(5),inst_66951,inst_66958,null));
var inst_66960 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66959);
var _ = (function (){var statearr_66970 = state_66965;
(statearr_66970[(4)] = cljs.core.rest.call(null,(state_66965[(4)])));

return statearr_66970;
})();
var state_66965__$1 = (function (){var statearr_66971 = state_66965;
(statearr_66971[(8)] = inst_66960);

return statearr_66971;
})();
var statearr_66972_66999 = state_66965__$1;
(statearr_66972_66999[(2)] = inst_66948);

(statearr_66972_66999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (13))){
var state_66965__$1 = state_66965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66965__$1,(16),key);
} else {
if((state_val_66966 === (6))){
var state_66965__$1 = state_66965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66965__$1,(9),coll);
} else {
if((state_val_66966 === (3))){
var inst_66963 = (state_66965[(2)]);
var state_66965__$1 = state_66965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66965__$1,inst_66963);
} else {
if((state_val_66966 === (12))){
var inst_66939 = (state_66965[(2)]);
var inst_66940 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_66965__$1 = (function (){var statearr_66973 = state_66965;
(statearr_66973[(7)] = inst_66939);

return statearr_66973;
})();
if(inst_66940){
var statearr_66974_67000 = state_66965__$1;
(statearr_66974_67000[(1)] = (13));

} else {
var statearr_66975_67001 = state_66965__$1;
(statearr_66975_67001[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (2))){
var _ = (function (){var statearr_66976 = state_66965;
(statearr_66976[(4)] = cljs.core.cons.call(null,(5),(state_66965[(4)])));

return statearr_66976;
})();
var inst_66926 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_66965__$1 = state_66965;
if(inst_66926){
var statearr_66977_67002 = state_66965__$1;
(statearr_66977_67002[(1)] = (6));

} else {
var statearr_66978_67003 = state_66965__$1;
(statearr_66978_67003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (11))){
var inst_66933 = (state_66965[(9)]);
var state_66965__$1 = state_66965;
var statearr_66980_67004 = state_66965__$1;
(statearr_66980_67004[(2)] = inst_66933);

(statearr_66980_67004[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (9))){
var inst_66929 = (state_66965[(2)]);
var inst_66930 = fluree.db.util.async.throw_err.call(null,inst_66929);
var state_66965__$1 = state_66965;
var statearr_66981_67005 = state_66965__$1;
(statearr_66981_67005[(2)] = inst_66930);

(statearr_66981_67005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (5))){
var _ = (function (){var statearr_66982 = state_66965;
(statearr_66982[(4)] = cljs.core.rest.call(null,(state_66965[(4)])));

return statearr_66982;
})();
var state_66965__$1 = state_66965;
var ex66979 = (state_66965__$1[(2)]);
var statearr_66983_67006 = state_66965__$1;
(statearr_66983_67006[(5)] = ex66979);


if((ex66979 instanceof Error)){
var statearr_66984_67007 = state_66965__$1;
(statearr_66984_67007[(1)] = (4));

(statearr_66984_67007[(5)] = null);

} else {
throw ex66979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (14))){
var state_66965__$1 = state_66965;
var statearr_66985_67008 = state_66965__$1;
(statearr_66985_67008[(2)] = key);

(statearr_66985_67008[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (16))){
var inst_66943 = (state_66965[(2)]);
var inst_66944 = fluree.db.util.async.throw_err.call(null,inst_66943);
var state_66965__$1 = state_66965;
var statearr_66986_67009 = state_66965__$1;
(statearr_66986_67009[(2)] = inst_66944);

(statearr_66986_67009[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (10))){
var inst_66933 = (state_66965[(9)]);
var inst_66936 = cljs.core.vec.call(null,inst_66933);
var state_66965__$1 = state_66965;
var statearr_66987_67010 = state_66965__$1;
(statearr_66987_67010[(2)] = inst_66936);

(statearr_66987_67010[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66966 === (8))){
var inst_66933 = (state_66965[(9)]);
var inst_66933__$1 = (state_66965[(2)]);
var inst_66934 = cljs.core.set_QMARK_.call(null,inst_66933__$1);
var state_66965__$1 = (function (){var statearr_66988 = state_66965;
(statearr_66988[(9)] = inst_66933__$1);

return statearr_66988;
})();
if(inst_66934){
var statearr_66989_67011 = state_66965__$1;
(statearr_66989_67011[(1)] = (10));

} else {
var statearr_66990_67012 = state_66965__$1;
(statearr_66990_67012[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0 = (function (){
var statearr_66991 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66991[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__);

(statearr_66991[(1)] = (1));

return statearr_66991;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1 = (function (state_66965){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66992){var ex__2749__auto__ = e66992;
var statearr_66993_67013 = state_66965;
(statearr_66993_67013[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66965[(4)]))){
var statearr_66994_67014 = state_66965;
(statearr_66994_67014[(1)] = cljs.core.first.call(null,(state_66965[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67015 = state_66965;
state_66965 = G__67015;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = function(state_66965){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1.call(this,state_66965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66995 = f__2769__auto__.call(null);
(statearr_66995[(6)] = c__2768__auto__);

return statearr_66995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67076){
var state_val_67077 = (state_67076[(1)]);
if((state_val_67077 === (7))){
var state_67076__$1 = state_67076;
var statearr_67078_67112 = state_67076__$1;
(statearr_67078_67112[(2)] = test);

(statearr_67078_67112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (20))){
var inst_67050 = (state_67076[(2)]);
var inst_67051 = fluree.db.util.async.throw_err.call(null,inst_67050);
var state_67076__$1 = state_67076;
var statearr_67079_67113 = state_67076__$1;
(statearr_67079_67113[(2)] = inst_67051);

(statearr_67079_67113[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (1))){
var state_67076__$1 = state_67076;
var statearr_67080_67114 = state_67076__$1;
(statearr_67080_67114[(2)] = null);

(statearr_67080_67114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (4))){
var inst_67016 = (state_67076[(2)]);
var state_67076__$1 = state_67076;
var statearr_67081_67115 = state_67076__$1;
(statearr_67081_67115[(2)] = inst_67016);

(statearr_67081_67115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (15))){
var inst_67034 = (state_67076[(7)]);
var inst_67042 = (state_67076[(2)]);
var inst_67043 = [inst_67042,f];
var inst_67044 = (new cljs.core.PersistentVector(null,2,(5),inst_67034,inst_67043,null));
var state_67076__$1 = state_67076;
var statearr_67082_67116 = state_67076__$1;
(statearr_67082_67116[(2)] = inst_67044);

(statearr_67082_67116[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (13))){
var state_67076__$1 = state_67076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67076__$1,(16),t);
} else {
if((state_val_67077 === (6))){
var state_67076__$1 = state_67076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67076__$1,(9),test);
} else {
if((state_val_67077 === (17))){
var state_67076__$1 = state_67076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67076__$1,(20),f);
} else {
if((state_val_67077 === (3))){
var inst_67074 = (state_67076[(2)]);
var state_67076__$1 = state_67076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67076__$1,inst_67074);
} else {
if((state_val_67077 === (12))){
var inst_67032 = (state_67076[(8)]);
var inst_67058 = (state_67076[(2)]);
var inst_67059 = cljs.core.nth.call(null,inst_67058,(0),null);
var inst_67060 = cljs.core.nth.call(null,inst_67058,(1),null);
var inst_67061 = fluree.db.dbfunctions.internal.if_else.call(null,inst_67032,inst_67059,inst_67060);
var inst_67062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67063 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67065 = [inst_67032,inst_67059,inst_67060];
var inst_67066 = (new cljs.core.PersistentVector(null,3,(5),inst_67064,inst_67065,null));
var inst_67067 = ["if-else",inst_67066,inst_67061];
var inst_67068 = cljs.core.PersistentHashMap.fromArrays(inst_67063,inst_67067);
var inst_67069 = [inst_67068,(10)];
var inst_67070 = (new cljs.core.PersistentVector(null,2,(5),inst_67062,inst_67069,null));
var inst_67071 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67070);
var _ = (function (){var statearr_67083 = state_67076;
(statearr_67083[(4)] = cljs.core.rest.call(null,(state_67076[(4)])));

return statearr_67083;
})();
var state_67076__$1 = (function (){var statearr_67084 = state_67076;
(statearr_67084[(9)] = inst_67071);

return statearr_67084;
})();
var statearr_67085_67117 = state_67076__$1;
(statearr_67085_67117[(2)] = inst_67061);

(statearr_67085_67117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (2))){
var _ = (function (){var statearr_67086 = state_67076;
(statearr_67086[(4)] = cljs.core.cons.call(null,(5),(state_67076[(4)])));

return statearr_67086;
})();
var inst_67025 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_67076__$1 = state_67076;
if(inst_67025){
var statearr_67087_67118 = state_67076__$1;
(statearr_67087_67118[(1)] = (6));

} else {
var statearr_67088_67119 = state_67076__$1;
(statearr_67088_67119[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (19))){
var inst_67046 = (state_67076[(10)]);
var inst_67054 = (state_67076[(2)]);
var inst_67055 = [f,inst_67054];
var inst_67056 = (new cljs.core.PersistentVector(null,2,(5),inst_67046,inst_67055,null));
var state_67076__$1 = state_67076;
var statearr_67089_67120 = state_67076__$1;
(statearr_67089_67120[(2)] = inst_67056);

(statearr_67089_67120[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (11))){
var inst_67046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67047 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_67076__$1 = (function (){var statearr_67091 = state_67076;
(statearr_67091[(10)] = inst_67046);

return statearr_67091;
})();
if(inst_67047){
var statearr_67092_67121 = state_67076__$1;
(statearr_67092_67121[(1)] = (17));

} else {
var statearr_67093_67122 = state_67076__$1;
(statearr_67093_67122[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (9))){
var inst_67028 = (state_67076[(2)]);
var inst_67029 = fluree.db.util.async.throw_err.call(null,inst_67028);
var state_67076__$1 = state_67076;
var statearr_67094_67123 = state_67076__$1;
(statearr_67094_67123[(2)] = inst_67029);

(statearr_67094_67123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (5))){
var _ = (function (){var statearr_67095 = state_67076;
(statearr_67095[(4)] = cljs.core.rest.call(null,(state_67076[(4)])));

return statearr_67095;
})();
var state_67076__$1 = state_67076;
var ex67090 = (state_67076__$1[(2)]);
var statearr_67096_67124 = state_67076__$1;
(statearr_67096_67124[(5)] = ex67090);


if((ex67090 instanceof Error)){
var statearr_67097_67125 = state_67076__$1;
(statearr_67097_67125[(1)] = (4));

(statearr_67097_67125[(5)] = null);

} else {
throw ex67090;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (14))){
var state_67076__$1 = state_67076;
var statearr_67098_67126 = state_67076__$1;
(statearr_67098_67126[(2)] = t);

(statearr_67098_67126[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (16))){
var inst_67038 = (state_67076[(2)]);
var inst_67039 = fluree.db.util.async.throw_err.call(null,inst_67038);
var state_67076__$1 = state_67076;
var statearr_67099_67127 = state_67076__$1;
(statearr_67099_67127[(2)] = inst_67039);

(statearr_67099_67127[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (10))){
var inst_67034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67035 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_67076__$1 = (function (){var statearr_67100 = state_67076;
(statearr_67100[(7)] = inst_67034);

return statearr_67100;
})();
if(inst_67035){
var statearr_67101_67128 = state_67076__$1;
(statearr_67101_67128[(1)] = (13));

} else {
var statearr_67102_67129 = state_67076__$1;
(statearr_67102_67129[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (18))){
var state_67076__$1 = state_67076;
var statearr_67103_67130 = state_67076__$1;
(statearr_67103_67130[(2)] = f);

(statearr_67103_67130[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (8))){
var inst_67032 = (state_67076[(8)]);
var inst_67032__$1 = (state_67076[(2)]);
var state_67076__$1 = (function (){var statearr_67104 = state_67076;
(statearr_67104[(8)] = inst_67032__$1);

return statearr_67104;
})();
if(cljs.core.truth_(inst_67032__$1)){
var statearr_67105_67131 = state_67076__$1;
(statearr_67105_67131[(1)] = (10));

} else {
var statearr_67106_67132 = state_67076__$1;
(statearr_67106_67132[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0 = (function (){
var statearr_67107 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_67107[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__);

(statearr_67107[(1)] = (1));

return statearr_67107;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1 = (function (state_67076){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67108){var ex__2749__auto__ = e67108;
var statearr_67109_67133 = state_67076;
(statearr_67109_67133[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67076[(4)]))){
var statearr_67110_67134 = state_67076;
(statearr_67110_67134[(1)] = cljs.core.first.call(null,(state_67076[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67135 = state_67076;
state_67076 = G__67135;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = function(state_67076){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1.call(this,state_67076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67111 = f__2769__auto__.call(null);
(statearr_67111[(6)] = c__2768__auto__);

return statearr_67111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67165){
var state_val_67166 = (state_67165[(1)]);
if((state_val_67166 === (7))){
var state_67165__$1 = state_67165;
var statearr_67167_67186 = state_67165__$1;
(statearr_67167_67186[(2)] = arg);

(statearr_67167_67186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (1))){
var state_67165__$1 = state_67165;
var statearr_67168_67187 = state_67165__$1;
(statearr_67168_67187[(2)] = null);

(statearr_67168_67187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (4))){
var inst_67136 = (state_67165[(2)]);
var state_67165__$1 = state_67165;
var statearr_67169_67188 = state_67165__$1;
(statearr_67169_67188[(2)] = inst_67136);

(statearr_67169_67188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (6))){
var state_67165__$1 = state_67165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67165__$1,(9),arg);
} else {
if((state_val_67166 === (3))){
var inst_67163 = (state_67165[(2)]);
var state_67165__$1 = state_67165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67165__$1,inst_67163);
} else {
if((state_val_67166 === (2))){
var _ = (function (){var statearr_67171 = state_67165;
(statearr_67171[(4)] = cljs.core.cons.call(null,(5),(state_67165[(4)])));

return statearr_67171;
})();
var inst_67142 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_67165__$1 = state_67165;
if(inst_67142){
var statearr_67172_67189 = state_67165__$1;
(statearr_67172_67189[(1)] = (6));

} else {
var statearr_67173_67190 = state_67165__$1;
(statearr_67173_67190[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (9))){
var inst_67145 = (state_67165[(2)]);
var inst_67146 = fluree.db.util.async.throw_err.call(null,inst_67145);
var state_67165__$1 = state_67165;
var statearr_67174_67191 = state_67165__$1;
(statearr_67174_67191[(2)] = inst_67146);

(statearr_67174_67191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (5))){
var _ = (function (){var statearr_67175 = state_67165;
(statearr_67175[(4)] = cljs.core.rest.call(null,(state_67165[(4)])));

return statearr_67175;
})();
var state_67165__$1 = state_67165;
var ex67170 = (state_67165__$1[(2)]);
var statearr_67176_67192 = state_67165__$1;
(statearr_67176_67192[(5)] = ex67170);


if((ex67170 instanceof Error)){
var statearr_67177_67193 = state_67165__$1;
(statearr_67177_67193[(1)] = (4));

(statearr_67177_67193[(5)] = null);

} else {
throw ex67170;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (8))){
var inst_67149 = (state_67165[(2)]);
var inst_67150 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_67149);
var inst_67151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67152 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67154 = [inst_67149];
var inst_67155 = (new cljs.core.PersistentVector(null,1,(5),inst_67153,inst_67154,null));
var inst_67156 = ["nil?",inst_67155,inst_67150];
var inst_67157 = cljs.core.PersistentHashMap.fromArrays(inst_67152,inst_67156);
var inst_67158 = [inst_67157,(10)];
var inst_67159 = (new cljs.core.PersistentVector(null,2,(5),inst_67151,inst_67158,null));
var inst_67160 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67159);
var _ = (function (){var statearr_67178 = state_67165;
(statearr_67178[(4)] = cljs.core.rest.call(null,(state_67165[(4)])));

return statearr_67178;
})();
var state_67165__$1 = (function (){var statearr_67179 = state_67165;
(statearr_67179[(7)] = inst_67160);

return statearr_67179;
})();
var statearr_67180_67194 = state_67165__$1;
(statearr_67180_67194[(2)] = inst_67150);

(statearr_67180_67194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_67181 = [null,null,null,null,null,null,null,null];
(statearr_67181[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__);

(statearr_67181[(1)] = (1));

return statearr_67181;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1 = (function (state_67165){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67182){var ex__2749__auto__ = e67182;
var statearr_67183_67195 = state_67165;
(statearr_67183_67195[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67165[(4)]))){
var statearr_67184_67196 = state_67165;
(statearr_67184_67196[(1)] = cljs.core.first.call(null,(state_67165[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67197 = state_67165;
state_67165 = G__67197;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = function(state_67165){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1.call(this,state_67165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67185 = f__2769__auto__.call(null);
(statearr_67185[(6)] = c__2768__auto__);

return statearr_67185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67227){
var state_val_67228 = (state_67227[(1)]);
if((state_val_67228 === (7))){
var state_67227__$1 = state_67227;
var statearr_67229_67248 = state_67227__$1;
(statearr_67229_67248[(2)] = arg);

(statearr_67229_67248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67228 === (1))){
var state_67227__$1 = state_67227;
var statearr_67230_67249 = state_67227__$1;
(statearr_67230_67249[(2)] = null);

(statearr_67230_67249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67228 === (4))){
var inst_67198 = (state_67227[(2)]);
var state_67227__$1 = state_67227;
var statearr_67231_67250 = state_67227__$1;
(statearr_67231_67250[(2)] = inst_67198);

(statearr_67231_67250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67228 === (6))){
var state_67227__$1 = state_67227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67227__$1,(9),arg);
} else {
if((state_val_67228 === (3))){
var inst_67225 = (state_67227[(2)]);
var state_67227__$1 = state_67227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67227__$1,inst_67225);
} else {
if((state_val_67228 === (2))){
var _ = (function (){var statearr_67233 = state_67227;
(statearr_67233[(4)] = cljs.core.cons.call(null,(5),(state_67227[(4)])));

return statearr_67233;
})();
var inst_67204 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_67227__$1 = state_67227;
if(inst_67204){
var statearr_67234_67251 = state_67227__$1;
(statearr_67234_67251[(1)] = (6));

} else {
var statearr_67235_67252 = state_67227__$1;
(statearr_67235_67252[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67228 === (9))){
var inst_67207 = (state_67227[(2)]);
var inst_67208 = fluree.db.util.async.throw_err.call(null,inst_67207);
var state_67227__$1 = state_67227;
var statearr_67236_67253 = state_67227__$1;
(statearr_67236_67253[(2)] = inst_67208);

(statearr_67236_67253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67228 === (5))){
var _ = (function (){var statearr_67237 = state_67227;
(statearr_67237[(4)] = cljs.core.rest.call(null,(state_67227[(4)])));

return statearr_67237;
})();
var state_67227__$1 = state_67227;
var ex67232 = (state_67227__$1[(2)]);
var statearr_67238_67254 = state_67227__$1;
(statearr_67238_67254[(5)] = ex67232);


if((ex67232 instanceof Error)){
var statearr_67239_67255 = state_67227__$1;
(statearr_67239_67255[(1)] = (4));

(statearr_67239_67255[(5)] = null);

} else {
throw ex67232;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67228 === (8))){
var inst_67211 = (state_67227[(2)]);
var inst_67212 = fluree.db.dbfunctions.internal.not.call(null,inst_67211);
var inst_67213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67214 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67216 = [inst_67211];
var inst_67217 = (new cljs.core.PersistentVector(null,1,(5),inst_67215,inst_67216,null));
var inst_67218 = ["not",inst_67217,inst_67212];
var inst_67219 = cljs.core.PersistentHashMap.fromArrays(inst_67214,inst_67218);
var inst_67220 = [inst_67219,(10)];
var inst_67221 = (new cljs.core.PersistentVector(null,2,(5),inst_67213,inst_67220,null));
var inst_67222 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67221);
var _ = (function (){var statearr_67240 = state_67227;
(statearr_67240[(4)] = cljs.core.rest.call(null,(state_67227[(4)])));

return statearr_67240;
})();
var state_67227__$1 = (function (){var statearr_67241 = state_67227;
(statearr_67241[(7)] = inst_67222);

return statearr_67241;
})();
var statearr_67242_67256 = state_67227__$1;
(statearr_67242_67256[(2)] = inst_67212);

(statearr_67242_67256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0 = (function (){
var statearr_67243 = [null,null,null,null,null,null,null,null];
(statearr_67243[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__);

(statearr_67243[(1)] = (1));

return statearr_67243;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1 = (function (state_67227){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67244){var ex__2749__auto__ = e67244;
var statearr_67245_67257 = state_67227;
(statearr_67245_67257[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67227[(4)]))){
var statearr_67246_67258 = state_67227;
(statearr_67246_67258[(1)] = cljs.core.first.call(null,(state_67227[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67259 = state_67227;
state_67227 = G__67259;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = function(state_67227){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1.call(this,state_67227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67247 = f__2769__auto__.call(null);
(statearr_67247[(6)] = c__2768__auto__);

return statearr_67247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67289){
var state_val_67290 = (state_67289[(1)]);
if((state_val_67290 === (7))){
var state_67289__$1 = state_67289;
var statearr_67291_67310 = state_67289__$1;
(statearr_67291_67310[(2)] = arg);

(statearr_67291_67310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67290 === (1))){
var state_67289__$1 = state_67289;
var statearr_67292_67311 = state_67289__$1;
(statearr_67292_67311[(2)] = null);

(statearr_67292_67311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67290 === (4))){
var inst_67260 = (state_67289[(2)]);
var state_67289__$1 = state_67289;
var statearr_67293_67312 = state_67289__$1;
(statearr_67293_67312[(2)] = inst_67260);

(statearr_67293_67312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67290 === (6))){
var state_67289__$1 = state_67289;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67289__$1,(9),arg);
} else {
if((state_val_67290 === (3))){
var inst_67287 = (state_67289[(2)]);
var state_67289__$1 = state_67289;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67289__$1,inst_67287);
} else {
if((state_val_67290 === (2))){
var _ = (function (){var statearr_67295 = state_67289;
(statearr_67295[(4)] = cljs.core.cons.call(null,(5),(state_67289[(4)])));

return statearr_67295;
})();
var inst_67266 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_67289__$1 = state_67289;
if(inst_67266){
var statearr_67296_67313 = state_67289__$1;
(statearr_67296_67313[(1)] = (6));

} else {
var statearr_67297_67314 = state_67289__$1;
(statearr_67297_67314[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67290 === (9))){
var inst_67269 = (state_67289[(2)]);
var inst_67270 = fluree.db.util.async.throw_err.call(null,inst_67269);
var state_67289__$1 = state_67289;
var statearr_67298_67315 = state_67289__$1;
(statearr_67298_67315[(2)] = inst_67270);

(statearr_67298_67315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67290 === (5))){
var _ = (function (){var statearr_67299 = state_67289;
(statearr_67299[(4)] = cljs.core.rest.call(null,(state_67289[(4)])));

return statearr_67299;
})();
var state_67289__$1 = state_67289;
var ex67294 = (state_67289__$1[(2)]);
var statearr_67300_67316 = state_67289__$1;
(statearr_67300_67316[(5)] = ex67294);


if((ex67294 instanceof Error)){
var statearr_67301_67317 = state_67289__$1;
(statearr_67301_67317[(1)] = (4));

(statearr_67301_67317[(5)] = null);

} else {
throw ex67294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67290 === (8))){
var inst_67273 = (state_67289[(2)]);
var inst_67274 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_67273);
var inst_67275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67276 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67278 = [inst_67273];
var inst_67279 = (new cljs.core.PersistentVector(null,1,(5),inst_67277,inst_67278,null));
var inst_67280 = ["empty?",inst_67279,inst_67274];
var inst_67281 = cljs.core.PersistentHashMap.fromArrays(inst_67276,inst_67280);
var inst_67282 = [inst_67281,(10)];
var inst_67283 = (new cljs.core.PersistentVector(null,2,(5),inst_67275,inst_67282,null));
var inst_67284 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67283);
var _ = (function (){var statearr_67302 = state_67289;
(statearr_67302[(4)] = cljs.core.rest.call(null,(state_67289[(4)])));

return statearr_67302;
})();
var state_67289__$1 = (function (){var statearr_67303 = state_67289;
(statearr_67303[(7)] = inst_67284);

return statearr_67303;
})();
var statearr_67304_67318 = state_67289__$1;
(statearr_67304_67318[(2)] = inst_67274);

(statearr_67304_67318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_67305 = [null,null,null,null,null,null,null,null];
(statearr_67305[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__);

(statearr_67305[(1)] = (1));

return statearr_67305;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1 = (function (state_67289){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67289);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67306){var ex__2749__auto__ = e67306;
var statearr_67307_67319 = state_67289;
(statearr_67307_67319[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67289[(4)]))){
var statearr_67308_67320 = state_67289;
(statearr_67308_67320[(1)] = cljs.core.first.call(null,(state_67289[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67321 = state_67289;
state_67289 = G__67321;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = function(state_67289){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1.call(this,state_67289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67309 = f__2769__auto__.call(null);
(statearr_67309[(6)] = c__2768__auto__);

return statearr_67309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67366 = arguments.length;
var i__5770__auto___67367 = (0);
while(true){
if((i__5770__auto___67367 < len__5769__auto___67366)){
args__5775__auto__.push((arguments[i__5770__auto___67367]));

var G__67368 = (i__5770__auto___67367 + (1));
i__5770__auto___67367 = G__67368;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67349){
var state_val_67350 = (state_67349[(1)]);
if((state_val_67350 === (1))){
var state_67349__$1 = state_67349;
var statearr_67351_67369 = state_67349__$1;
(statearr_67351_67369[(2)] = null);

(statearr_67351_67369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67350 === (2))){
var _ = (function (){var statearr_67352 = state_67349;
(statearr_67352[(4)] = cljs.core.cons.call(null,(5),(state_67349[(4)])));

return statearr_67352;
})();
var inst_67330 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67349__$1 = state_67349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67349__$1,(6),inst_67330);
} else {
if((state_val_67350 === (3))){
var inst_67347 = (state_67349[(2)]);
var state_67349__$1 = state_67349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67349__$1,inst_67347);
} else {
if((state_val_67350 === (4))){
var inst_67324 = (state_67349[(2)]);
var state_67349__$1 = state_67349;
var statearr_67354_67370 = state_67349__$1;
(statearr_67354_67370[(2)] = inst_67324);

(statearr_67354_67370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67350 === (5))){
var _ = (function (){var statearr_67355 = state_67349;
(statearr_67355[(4)] = cljs.core.rest.call(null,(state_67349[(4)])));

return statearr_67355;
})();
var state_67349__$1 = state_67349;
var ex67353 = (state_67349__$1[(2)]);
var statearr_67356_67371 = state_67349__$1;
(statearr_67356_67371[(5)] = ex67353);


if((ex67353 instanceof Error)){
var statearr_67357_67372 = state_67349__$1;
(statearr_67357_67372[(1)] = (4));

(statearr_67357_67372[(5)] = null);

} else {
throw ex67353;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67350 === (6))){
var inst_67332 = (state_67349[(2)]);
var inst_67333 = fluree.db.util.async.throw_err.call(null,inst_67332);
var inst_67334 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_67333);
var inst_67335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67336 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67338 = [inst_67333];
var inst_67339 = (new cljs.core.PersistentVector(null,1,(5),inst_67337,inst_67338,null));
var inst_67340 = ["str",inst_67339,inst_67334];
var inst_67341 = cljs.core.PersistentHashMap.fromArrays(inst_67336,inst_67340);
var inst_67342 = [inst_67341,(10)];
var inst_67343 = (new cljs.core.PersistentVector(null,2,(5),inst_67335,inst_67342,null));
var inst_67344 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67343);
var _ = (function (){var statearr_67358 = state_67349;
(statearr_67358[(4)] = cljs.core.rest.call(null,(state_67349[(4)])));

return statearr_67358;
})();
var state_67349__$1 = (function (){var statearr_67359 = state_67349;
(statearr_67359[(7)] = inst_67344);

return statearr_67359;
})();
var statearr_67360_67373 = state_67349__$1;
(statearr_67360_67373[(2)] = inst_67334);

(statearr_67360_67373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_67361 = [null,null,null,null,null,null,null,null];
(statearr_67361[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_67361[(1)] = (1));

return statearr_67361;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_67349){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67362){var ex__2749__auto__ = e67362;
var statearr_67363_67374 = state_67349;
(statearr_67363_67374[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67349[(4)]))){
var statearr_67364_67375 = state_67349;
(statearr_67364_67375[(1)] = cljs.core.first.call(null,(state_67349[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67376 = state_67349;
state_67349 = G__67376;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_67349){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_67349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67365 = f__2769__auto__.call(null);
(statearr_67365[(6)] = c__2768__auto__);

return statearr_67365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq67322){
var G__67323 = cljs.core.first.call(null,seq67322);
var seq67322__$1 = cljs.core.next.call(null,seq67322);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67323,seq67322__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67402){
var state_val_67403 = (state_67402[(1)]);
if((state_val_67403 === (1))){
var state_67402__$1 = state_67402;
var statearr_67404_67419 = state_67402__$1;
(statearr_67404_67419[(2)] = null);

(statearr_67404_67419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67403 === (2))){
var _ = (function (){var statearr_67405 = state_67402;
(statearr_67405[(4)] = cljs.core.cons.call(null,(5),(state_67402[(4)])));

return statearr_67405;
})();
var inst_67383 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67402__$1 = state_67402;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67402__$1,(6),inst_67383);
} else {
if((state_val_67403 === (3))){
var inst_67400 = (state_67402[(2)]);
var state_67402__$1 = state_67402;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67402__$1,inst_67400);
} else {
if((state_val_67403 === (4))){
var inst_67377 = (state_67402[(2)]);
var state_67402__$1 = state_67402;
var statearr_67407_67420 = state_67402__$1;
(statearr_67407_67420[(2)] = inst_67377);

(statearr_67407_67420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67403 === (5))){
var _ = (function (){var statearr_67408 = state_67402;
(statearr_67408[(4)] = cljs.core.rest.call(null,(state_67402[(4)])));

return statearr_67408;
})();
var state_67402__$1 = state_67402;
var ex67406 = (state_67402__$1[(2)]);
var statearr_67409_67421 = state_67402__$1;
(statearr_67409_67421[(5)] = ex67406);


if((ex67406 instanceof Error)){
var statearr_67410_67422 = state_67402__$1;
(statearr_67410_67422[(1)] = (4));

(statearr_67410_67422[(5)] = null);

} else {
throw ex67406;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67403 === (6))){
var inst_67385 = (state_67402[(2)]);
var inst_67386 = fluree.db.util.async.throw_err.call(null,inst_67385);
var inst_67387 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_67386);
var inst_67388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67389 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67391 = [inst_67386];
var inst_67392 = (new cljs.core.PersistentVector(null,1,(5),inst_67390,inst_67391,null));
var inst_67393 = ["subs",inst_67392,inst_67387];
var inst_67394 = cljs.core.PersistentHashMap.fromArrays(inst_67389,inst_67393);
var inst_67395 = [inst_67394,(30)];
var inst_67396 = (new cljs.core.PersistentVector(null,2,(5),inst_67388,inst_67395,null));
var inst_67397 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67396);
var _ = (function (){var statearr_67411 = state_67402;
(statearr_67411[(4)] = cljs.core.rest.call(null,(state_67402[(4)])));

return statearr_67411;
})();
var state_67402__$1 = (function (){var statearr_67412 = state_67402;
(statearr_67412[(7)] = inst_67397);

return statearr_67412;
})();
var statearr_67413_67423 = state_67402__$1;
(statearr_67413_67423[(2)] = inst_67387);

(statearr_67413_67423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0 = (function (){
var statearr_67414 = [null,null,null,null,null,null,null,null];
(statearr_67414[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__);

(statearr_67414[(1)] = (1));

return statearr_67414;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1 = (function (state_67402){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67402);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67415){var ex__2749__auto__ = e67415;
var statearr_67416_67424 = state_67402;
(statearr_67416_67424[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67402[(4)]))){
var statearr_67417_67425 = state_67402;
(statearr_67417_67425[(1)] = cljs.core.first.call(null,(state_67402[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67426 = state_67402;
state_67402 = G__67426;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = function(state_67402){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1.call(this,state_67402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67418 = f__2769__auto__.call(null);
(statearr_67418[(6)] = c__2768__auto__);

return statearr_67418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67456){
var state_val_67457 = (state_67456[(1)]);
if((state_val_67457 === (7))){
var state_67456__$1 = state_67456;
var statearr_67458_67477 = state_67456__$1;
(statearr_67458_67477[(2)] = str);

(statearr_67458_67477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (1))){
var state_67456__$1 = state_67456;
var statearr_67459_67478 = state_67456__$1;
(statearr_67459_67478[(2)] = null);

(statearr_67459_67478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (4))){
var inst_67427 = (state_67456[(2)]);
var state_67456__$1 = state_67456;
var statearr_67460_67479 = state_67456__$1;
(statearr_67460_67479[(2)] = inst_67427);

(statearr_67460_67479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (6))){
var state_67456__$1 = state_67456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67456__$1,(9),str);
} else {
if((state_val_67457 === (3))){
var inst_67454 = (state_67456[(2)]);
var state_67456__$1 = state_67456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67456__$1,inst_67454);
} else {
if((state_val_67457 === (2))){
var _ = (function (){var statearr_67462 = state_67456;
(statearr_67462[(4)] = cljs.core.cons.call(null,(5),(state_67456[(4)])));

return statearr_67462;
})();
var inst_67433 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_67456__$1 = state_67456;
if(inst_67433){
var statearr_67463_67480 = state_67456__$1;
(statearr_67463_67480[(1)] = (6));

} else {
var statearr_67464_67481 = state_67456__$1;
(statearr_67464_67481[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (9))){
var inst_67436 = (state_67456[(2)]);
var inst_67437 = fluree.db.util.async.throw_err.call(null,inst_67436);
var state_67456__$1 = state_67456;
var statearr_67465_67482 = state_67456__$1;
(statearr_67465_67482[(2)] = inst_67437);

(statearr_67465_67482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (5))){
var _ = (function (){var statearr_67466 = state_67456;
(statearr_67466[(4)] = cljs.core.rest.call(null,(state_67456[(4)])));

return statearr_67466;
})();
var state_67456__$1 = state_67456;
var ex67461 = (state_67456__$1[(2)]);
var statearr_67467_67483 = state_67456__$1;
(statearr_67467_67483[(5)] = ex67461);


if((ex67461 instanceof Error)){
var statearr_67468_67484 = state_67456__$1;
(statearr_67468_67484[(1)] = (4));

(statearr_67468_67484[(5)] = null);

} else {
throw ex67461;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (8))){
var inst_67440 = (state_67456[(2)]);
var inst_67441 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_67440);
var inst_67442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67443 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67445 = [inst_67440];
var inst_67446 = (new cljs.core.PersistentVector(null,1,(5),inst_67444,inst_67445,null));
var inst_67447 = ["lower-case",inst_67446,inst_67441];
var inst_67448 = cljs.core.PersistentHashMap.fromArrays(inst_67443,inst_67447);
var inst_67449 = [inst_67448,(10)];
var inst_67450 = (new cljs.core.PersistentVector(null,2,(5),inst_67442,inst_67449,null));
var inst_67451 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67450);
var _ = (function (){var statearr_67469 = state_67456;
(statearr_67469[(4)] = cljs.core.rest.call(null,(state_67456[(4)])));

return statearr_67469;
})();
var state_67456__$1 = (function (){var statearr_67470 = state_67456;
(statearr_67470[(7)] = inst_67451);

return statearr_67470;
})();
var statearr_67471_67485 = state_67456__$1;
(statearr_67471_67485[(2)] = inst_67441);

(statearr_67471_67485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0 = (function (){
var statearr_67472 = [null,null,null,null,null,null,null,null];
(statearr_67472[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__);

(statearr_67472[(1)] = (1));

return statearr_67472;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1 = (function (state_67456){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67473){var ex__2749__auto__ = e67473;
var statearr_67474_67486 = state_67456;
(statearr_67474_67486[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67456[(4)]))){
var statearr_67475_67487 = state_67456;
(statearr_67475_67487[(1)] = cljs.core.first.call(null,(state_67456[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67488 = state_67456;
state_67456 = G__67488;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = function(state_67456){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1.call(this,state_67456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67476 = f__2769__auto__.call(null);
(statearr_67476[(6)] = c__2768__auto__);

return statearr_67476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67518){
var state_val_67519 = (state_67518[(1)]);
if((state_val_67519 === (7))){
var state_67518__$1 = state_67518;
var statearr_67520_67539 = state_67518__$1;
(statearr_67520_67539[(2)] = str);

(statearr_67520_67539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67519 === (1))){
var state_67518__$1 = state_67518;
var statearr_67521_67540 = state_67518__$1;
(statearr_67521_67540[(2)] = null);

(statearr_67521_67540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67519 === (4))){
var inst_67489 = (state_67518[(2)]);
var state_67518__$1 = state_67518;
var statearr_67522_67541 = state_67518__$1;
(statearr_67522_67541[(2)] = inst_67489);

(statearr_67522_67541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67519 === (6))){
var state_67518__$1 = state_67518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67518__$1,(9),str);
} else {
if((state_val_67519 === (3))){
var inst_67516 = (state_67518[(2)]);
var state_67518__$1 = state_67518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67518__$1,inst_67516);
} else {
if((state_val_67519 === (2))){
var _ = (function (){var statearr_67524 = state_67518;
(statearr_67524[(4)] = cljs.core.cons.call(null,(5),(state_67518[(4)])));

return statearr_67524;
})();
var inst_67495 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_67518__$1 = state_67518;
if(inst_67495){
var statearr_67525_67542 = state_67518__$1;
(statearr_67525_67542[(1)] = (6));

} else {
var statearr_67526_67543 = state_67518__$1;
(statearr_67526_67543[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67519 === (9))){
var inst_67498 = (state_67518[(2)]);
var inst_67499 = fluree.db.util.async.throw_err.call(null,inst_67498);
var state_67518__$1 = state_67518;
var statearr_67527_67544 = state_67518__$1;
(statearr_67527_67544[(2)] = inst_67499);

(statearr_67527_67544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67519 === (5))){
var _ = (function (){var statearr_67528 = state_67518;
(statearr_67528[(4)] = cljs.core.rest.call(null,(state_67518[(4)])));

return statearr_67528;
})();
var state_67518__$1 = state_67518;
var ex67523 = (state_67518__$1[(2)]);
var statearr_67529_67545 = state_67518__$1;
(statearr_67529_67545[(5)] = ex67523);


if((ex67523 instanceof Error)){
var statearr_67530_67546 = state_67518__$1;
(statearr_67530_67546[(1)] = (4));

(statearr_67530_67546[(5)] = null);

} else {
throw ex67523;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67519 === (8))){
var inst_67502 = (state_67518[(2)]);
var inst_67503 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_67502);
var inst_67504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67505 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67507 = [inst_67502];
var inst_67508 = (new cljs.core.PersistentVector(null,1,(5),inst_67506,inst_67507,null));
var inst_67509 = ["upper-case",inst_67508,inst_67503];
var inst_67510 = cljs.core.PersistentHashMap.fromArrays(inst_67505,inst_67509);
var inst_67511 = [inst_67510,(10)];
var inst_67512 = (new cljs.core.PersistentVector(null,2,(5),inst_67504,inst_67511,null));
var inst_67513 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67512);
var _ = (function (){var statearr_67531 = state_67518;
(statearr_67531[(4)] = cljs.core.rest.call(null,(state_67518[(4)])));

return statearr_67531;
})();
var state_67518__$1 = (function (){var statearr_67532 = state_67518;
(statearr_67532[(7)] = inst_67513);

return statearr_67532;
})();
var statearr_67533_67547 = state_67518__$1;
(statearr_67533_67547[(2)] = inst_67503);

(statearr_67533_67547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0 = (function (){
var statearr_67534 = [null,null,null,null,null,null,null,null];
(statearr_67534[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__);

(statearr_67534[(1)] = (1));

return statearr_67534;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1 = (function (state_67518){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67535){var ex__2749__auto__ = e67535;
var statearr_67536_67548 = state_67518;
(statearr_67536_67548[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67518[(4)]))){
var statearr_67537_67549 = state_67518;
(statearr_67537_67549[(1)] = cljs.core.first.call(null,(state_67518[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67550 = state_67518;
state_67518 = G__67550;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = function(state_67518){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1.call(this,state_67518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67538 = f__2769__auto__.call(null);
(statearr_67538[(6)] = c__2768__auto__);

return statearr_67538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__67552 = arguments.length;
switch (G__67552) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67580){
var state_val_67581 = (state_67580[(1)]);
if((state_val_67581 === (1))){
var state_67580__$1 = state_67580;
var statearr_67582_67598 = state_67580__$1;
(statearr_67582_67598[(2)] = null);

(statearr_67582_67598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67581 === (2))){
var _ = (function (){var statearr_67583 = state_67580;
(statearr_67583[(4)] = cljs.core.cons.call(null,(5),(state_67580[(4)])));

return statearr_67583;
})();
var inst_67562 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_67580__$1 = state_67580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67580__$1,(6),inst_67562);
} else {
if((state_val_67581 === (3))){
var inst_67578 = (state_67580[(2)]);
var state_67580__$1 = state_67580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67580__$1,inst_67578);
} else {
if((state_val_67581 === (4))){
var inst_67553 = (state_67580[(2)]);
var state_67580__$1 = state_67580;
var statearr_67585_67599 = state_67580__$1;
(statearr_67585_67599[(2)] = inst_67553);

(statearr_67585_67599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67581 === (5))){
var _ = (function (){var statearr_67586 = state_67580;
(statearr_67586[(4)] = cljs.core.rest.call(null,(state_67580[(4)])));

return statearr_67586;
})();
var state_67580__$1 = state_67580;
var ex67584 = (state_67580__$1[(2)]);
var statearr_67587_67600 = state_67580__$1;
(statearr_67587_67600[(5)] = ex67584);


if((ex67584 instanceof Error)){
var statearr_67588_67601 = state_67580__$1;
(statearr_67588_67601[(1)] = (4));

(statearr_67588_67601[(5)] = null);

} else {
throw ex67584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67581 === (6))){
var inst_67564 = (state_67580[(2)]);
var inst_67565 = fluree.db.util.async.throw_err.call(null,inst_67564);
var inst_67566 = cljs.core.nth.call(null,inst_67565,(0),null);
var inst_67567 = cljs.core.nth.call(null,inst_67565,(1),null);
var inst_67568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67569 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67570 = ["?s","?ctx",inst_67566];
var inst_67571 = cljs.core.PersistentHashMap.fromArrays(inst_67569,inst_67570);
var inst_67572 = ((10) + inst_67567);
var inst_67573 = [inst_67571,inst_67572];
var inst_67574 = (new cljs.core.PersistentVector(null,2,(5),inst_67568,inst_67573,null));
var inst_67575 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67574);
var _ = (function (){var statearr_67589 = state_67580;
(statearr_67589[(4)] = cljs.core.rest.call(null,(state_67580[(4)])));

return statearr_67589;
})();
var state_67580__$1 = (function (){var statearr_67590 = state_67580;
(statearr_67590[(7)] = inst_67575);

return statearr_67590;
})();
var statearr_67591_67602 = state_67580__$1;
(statearr_67591_67602[(2)] = inst_67566);

(statearr_67591_67602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_67592 = [null,null,null,null,null,null,null,null];
(statearr_67592[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_67592[(1)] = (1));

return statearr_67592;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_67580){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67593){var ex__2749__auto__ = e67593;
var statearr_67594_67603 = state_67580;
(statearr_67594_67603[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67580[(4)]))){
var statearr_67595_67604 = state_67580;
(statearr_67595_67604[(1)] = cljs.core.first.call(null,(state_67580[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67605 = state_67580;
state_67580 = G__67605;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_67580){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_67580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67596 = f__2769__auto__.call(null);
(statearr_67596[(6)] = c__2768__auto__);

return statearr_67596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__67607 = arguments.length;
switch (G__67607) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67645){
var state_val_67646 = (state_67645[(1)]);
if((state_val_67646 === (7))){
var inst_67638 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_67645__$1 = state_67645;
var statearr_67647_67667 = state_67645__$1;
(statearr_67647_67667[(2)] = inst_67638);

(statearr_67647_67667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67646 === (1))){
var state_67645__$1 = state_67645;
var statearr_67648_67668 = state_67645__$1;
(statearr_67648_67668[(2)] = null);

(statearr_67648_67668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67646 === (4))){
var inst_67608 = (state_67645[(2)]);
var state_67645__$1 = state_67645;
var statearr_67649_67669 = state_67645__$1;
(statearr_67649_67669[(2)] = inst_67608);

(statearr_67649_67669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67646 === (6))){
var inst_67619 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_67645__$1 = state_67645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67645__$1,(10),inst_67619);
} else {
if((state_val_67646 === (3))){
var inst_67643 = (state_67645[(2)]);
var state_67645__$1 = state_67645;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67645__$1,inst_67643);
} else {
if((state_val_67646 === (2))){
var _ = (function (){var statearr_67651 = state_67645;
(statearr_67651[(4)] = cljs.core.cons.call(null,(5),(state_67645[(4)])));

return statearr_67651;
})();
var inst_67614 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67645__$1 = state_67645;
if(cljs.core.truth_(inst_67614)){
var statearr_67652_67670 = state_67645__$1;
(statearr_67652_67670[(1)] = (6));

} else {
var statearr_67653_67671 = state_67645__$1;
(statearr_67653_67671[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67646 === (9))){
var inst_67625 = (state_67645[(2)]);
var inst_67626 = fluree.db.util.async.throw_err.call(null,inst_67625);
var inst_67627 = cljs.core.nth.call(null,inst_67626,(0),null);
var inst_67628 = cljs.core.nth.call(null,inst_67626,(1),null);
var inst_67629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67630 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67631 = ["?p","?ctx",inst_67627];
var inst_67632 = cljs.core.PersistentHashMap.fromArrays(inst_67630,inst_67631);
var inst_67633 = ((10) + inst_67628);
var inst_67634 = [inst_67632,inst_67633];
var inst_67635 = (new cljs.core.PersistentVector(null,2,(5),inst_67629,inst_67634,null));
var inst_67636 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67635);
var state_67645__$1 = (function (){var statearr_67654 = state_67645;
(statearr_67654[(7)] = inst_67636);

return statearr_67654;
})();
var statearr_67655_67672 = state_67645__$1;
(statearr_67655_67672[(2)] = inst_67627);

(statearr_67655_67672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67646 === (5))){
var _ = (function (){var statearr_67656 = state_67645;
(statearr_67656[(4)] = cljs.core.rest.call(null,(state_67645[(4)])));

return statearr_67656;
})();
var state_67645__$1 = state_67645;
var ex67650 = (state_67645__$1[(2)]);
var statearr_67657_67673 = state_67645__$1;
(statearr_67657_67673[(5)] = ex67650);


if((ex67650 instanceof Error)){
var statearr_67658_67674 = state_67645__$1;
(statearr_67658_67674[(1)] = (4));

(statearr_67658_67674[(5)] = null);

} else {
throw ex67650;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67646 === (10))){
var inst_67621 = (state_67645[(2)]);
var inst_67622 = fluree.db.util.async.throw_err.call(null,inst_67621);
var inst_67623 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_67622);
var state_67645__$1 = state_67645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67645__$1,(9),inst_67623);
} else {
if((state_val_67646 === (8))){
var inst_67640 = (state_67645[(2)]);
var _ = (function (){var statearr_67659 = state_67645;
(statearr_67659[(4)] = cljs.core.rest.call(null,(state_67645[(4)])));

return statearr_67659;
})();
var state_67645__$1 = state_67645;
var statearr_67660_67675 = state_67645__$1;
(statearr_67660_67675[(2)] = inst_67640);

(statearr_67660_67675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_67661 = [null,null,null,null,null,null,null,null];
(statearr_67661[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_67661[(1)] = (1));

return statearr_67661;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_67645){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67645);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67662){var ex__2749__auto__ = e67662;
var statearr_67663_67676 = state_67645;
(statearr_67663_67676[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67645[(4)]))){
var statearr_67664_67677 = state_67645;
(statearr_67664_67677[(1)] = cljs.core.first.call(null,(state_67645[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67678 = state_67645;
state_67645 = G__67678;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_67645){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_67645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67665 = f__2769__auto__.call(null);
(statearr_67665[(6)] = c__2768__auto__);

return statearr_67665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67727 = arguments.length;
var i__5770__auto___67728 = (0);
while(true){
if((i__5770__auto___67728 < len__5769__auto___67727)){
args__5775__auto__.push((arguments[i__5770__auto___67728]));

var G__67729 = (i__5770__auto___67728 + (1));
i__5770__auto___67728 = G__67729;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67710){
var state_val_67711 = (state_67710[(1)]);
if((state_val_67711 === (1))){
var state_67710__$1 = state_67710;
var statearr_67712_67730 = state_67710__$1;
(statearr_67712_67730[(2)] = null);

(statearr_67712_67730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67711 === (2))){
var _ = (function (){var statearr_67713 = state_67710;
(statearr_67713[(4)] = cljs.core.cons.call(null,(5),(state_67710[(4)])));

return statearr_67713;
})();
var inst_67687 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67710__$1 = state_67710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67710__$1,(6),inst_67687);
} else {
if((state_val_67711 === (3))){
var inst_67708 = (state_67710[(2)]);
var state_67710__$1 = state_67710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67710__$1,inst_67708);
} else {
if((state_val_67711 === (4))){
var inst_67681 = (state_67710[(2)]);
var state_67710__$1 = state_67710;
var statearr_67715_67731 = state_67710__$1;
(statearr_67715_67731[(2)] = inst_67681);

(statearr_67715_67731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67711 === (5))){
var _ = (function (){var statearr_67716 = state_67710;
(statearr_67716[(4)] = cljs.core.rest.call(null,(state_67710[(4)])));

return statearr_67716;
})();
var state_67710__$1 = state_67710;
var ex67714 = (state_67710__$1[(2)]);
var statearr_67717_67732 = state_67710__$1;
(statearr_67717_67732[(5)] = ex67714);


if((ex67714 instanceof Error)){
var statearr_67718_67733 = state_67710__$1;
(statearr_67718_67733[(1)] = (4));

(statearr_67718_67733[(5)] = null);

} else {
throw ex67714;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67711 === (6))){
var inst_67689 = (state_67710[(2)]);
var inst_67690 = fluree.db.util.async.throw_err.call(null,inst_67689);
var inst_67691 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_67690);
var inst_67692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67693 = [inst_67690];
var inst_67694 = (new cljs.core.PersistentVector(null,1,(5),inst_67692,inst_67693,null));
var inst_67695 = cljs.core.count.call(null,inst_67694);
var inst_67696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67697 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67699 = [inst_67690];
var inst_67700 = (new cljs.core.PersistentVector(null,1,(5),inst_67698,inst_67699,null));
var inst_67701 = ["and",inst_67700,inst_67691];
var inst_67702 = cljs.core.PersistentHashMap.fromArrays(inst_67697,inst_67701);
var inst_67703 = [inst_67702,inst_67695];
var inst_67704 = (new cljs.core.PersistentVector(null,2,(5),inst_67696,inst_67703,null));
var inst_67705 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67704);
var _ = (function (){var statearr_67719 = state_67710;
(statearr_67719[(4)] = cljs.core.rest.call(null,(state_67710[(4)])));

return statearr_67719;
})();
var state_67710__$1 = (function (){var statearr_67720 = state_67710;
(statearr_67720[(7)] = inst_67705);

return statearr_67720;
})();
var statearr_67721_67734 = state_67710__$1;
(statearr_67721_67734[(2)] = inst_67691);

(statearr_67721_67734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_67722 = [null,null,null,null,null,null,null,null];
(statearr_67722[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_67722[(1)] = (1));

return statearr_67722;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_67710){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67723){var ex__2749__auto__ = e67723;
var statearr_67724_67735 = state_67710;
(statearr_67724_67735[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67710[(4)]))){
var statearr_67725_67736 = state_67710;
(statearr_67725_67736[(1)] = cljs.core.first.call(null,(state_67710[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67737 = state_67710;
state_67710 = G__67737;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_67710){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_67710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67726 = f__2769__auto__.call(null);
(statearr_67726[(6)] = c__2768__auto__);

return statearr_67726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq67679){
var G__67680 = cljs.core.first.call(null,seq67679);
var seq67679__$1 = cljs.core.next.call(null,seq67679);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67680,seq67679__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67786 = arguments.length;
var i__5770__auto___67787 = (0);
while(true){
if((i__5770__auto___67787 < len__5769__auto___67786)){
args__5775__auto__.push((arguments[i__5770__auto___67787]));

var G__67788 = (i__5770__auto___67787 + (1));
i__5770__auto___67787 = G__67788;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67769){
var state_val_67770 = (state_67769[(1)]);
if((state_val_67770 === (1))){
var state_67769__$1 = state_67769;
var statearr_67771_67789 = state_67769__$1;
(statearr_67771_67789[(2)] = null);

(statearr_67771_67789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67770 === (2))){
var _ = (function (){var statearr_67772 = state_67769;
(statearr_67772[(4)] = cljs.core.cons.call(null,(5),(state_67769[(4)])));

return statearr_67772;
})();
var inst_67746 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67769__$1 = state_67769;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67769__$1,(6),inst_67746);
} else {
if((state_val_67770 === (3))){
var inst_67767 = (state_67769[(2)]);
var state_67769__$1 = state_67769;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67769__$1,inst_67767);
} else {
if((state_val_67770 === (4))){
var inst_67740 = (state_67769[(2)]);
var state_67769__$1 = state_67769;
var statearr_67774_67790 = state_67769__$1;
(statearr_67774_67790[(2)] = inst_67740);

(statearr_67774_67790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67770 === (5))){
var _ = (function (){var statearr_67775 = state_67769;
(statearr_67775[(4)] = cljs.core.rest.call(null,(state_67769[(4)])));

return statearr_67775;
})();
var state_67769__$1 = state_67769;
var ex67773 = (state_67769__$1[(2)]);
var statearr_67776_67791 = state_67769__$1;
(statearr_67776_67791[(5)] = ex67773);


if((ex67773 instanceof Error)){
var statearr_67777_67792 = state_67769__$1;
(statearr_67777_67792[(1)] = (4));

(statearr_67777_67792[(5)] = null);

} else {
throw ex67773;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67770 === (6))){
var inst_67748 = (state_67769[(2)]);
var inst_67749 = fluree.db.util.async.throw_err.call(null,inst_67748);
var inst_67750 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_67749);
var inst_67751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67752 = [inst_67749];
var inst_67753 = (new cljs.core.PersistentVector(null,1,(5),inst_67751,inst_67752,null));
var inst_67754 = cljs.core.count.call(null,inst_67753);
var inst_67755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67756 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67758 = [inst_67749];
var inst_67759 = (new cljs.core.PersistentVector(null,1,(5),inst_67757,inst_67758,null));
var inst_67760 = ["or",inst_67759,inst_67750];
var inst_67761 = cljs.core.PersistentHashMap.fromArrays(inst_67756,inst_67760);
var inst_67762 = [inst_67761,inst_67754];
var inst_67763 = (new cljs.core.PersistentVector(null,2,(5),inst_67755,inst_67762,null));
var inst_67764 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67763);
var _ = (function (){var statearr_67778 = state_67769;
(statearr_67778[(4)] = cljs.core.rest.call(null,(state_67769[(4)])));

return statearr_67778;
})();
var state_67769__$1 = (function (){var statearr_67779 = state_67769;
(statearr_67779[(7)] = inst_67764);

return statearr_67779;
})();
var statearr_67780_67793 = state_67769__$1;
(statearr_67780_67793[(2)] = inst_67750);

(statearr_67780_67793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_67781 = [null,null,null,null,null,null,null,null];
(statearr_67781[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_67781[(1)] = (1));

return statearr_67781;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_67769){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67769);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67782){var ex__2749__auto__ = e67782;
var statearr_67783_67794 = state_67769;
(statearr_67783_67794[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67769[(4)]))){
var statearr_67784_67795 = state_67769;
(statearr_67784_67795[(1)] = cljs.core.first.call(null,(state_67769[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67796 = state_67769;
state_67769 = G__67796;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_67769){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_67769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67785 = f__2769__auto__.call(null);
(statearr_67785[(6)] = c__2768__auto__);

return statearr_67785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq67738){
var G__67739 = cljs.core.first.call(null,seq67738);
var seq67738__$1 = cljs.core.next.call(null,seq67738);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67739,seq67738__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67834){
var state_val_67835 = (state_67834[(1)]);
if((state_val_67835 === (7))){
var inst_67810 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_67834__$1 = state_67834;
if(inst_67810){
var statearr_67836_67859 = state_67834__$1;
(statearr_67836_67859[(1)] = (10));

} else {
var statearr_67837_67860 = state_67834__$1;
(statearr_67837_67860[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (1))){
var state_67834__$1 = state_67834;
var statearr_67838_67861 = state_67834__$1;
(statearr_67838_67861[(2)] = null);

(statearr_67838_67861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (4))){
var inst_67797 = (state_67834[(2)]);
var state_67834__$1 = state_67834;
var statearr_67839_67862 = state_67834__$1;
(statearr_67839_67862[(2)] = inst_67797);

(statearr_67839_67862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (13))){
var inst_67813 = (state_67834[(2)]);
var inst_67814 = fluree.db.util.async.throw_err.call(null,inst_67813);
var state_67834__$1 = state_67834;
var statearr_67840_67863 = state_67834__$1;
(statearr_67840_67863[(2)] = inst_67814);

(statearr_67840_67863[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (6))){
var inst_67805 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_67834__$1 = state_67834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67834__$1,(9),inst_67805);
} else {
if((state_val_67835 === (3))){
var inst_67832 = (state_67834[(2)]);
var state_67834__$1 = state_67834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67834__$1,inst_67832);
} else {
if((state_val_67835 === (12))){
var inst_67817 = (state_67834[(2)]);
var state_67834__$1 = state_67834;
var statearr_67841_67864 = state_67834__$1;
(statearr_67841_67864[(2)] = inst_67817);

(statearr_67841_67864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (2))){
var _ = (function (){var statearr_67842 = state_67834;
(statearr_67842[(4)] = cljs.core.cons.call(null,(5),(state_67834[(4)])));

return statearr_67842;
})();
var inst_67803 = cljs.core.vector_QMARK_.call(null,coll);
var state_67834__$1 = state_67834;
if(inst_67803){
var statearr_67843_67865 = state_67834__$1;
(statearr_67843_67865[(1)] = (6));

} else {
var statearr_67844_67866 = state_67834__$1;
(statearr_67844_67866[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (11))){
var state_67834__$1 = state_67834;
var statearr_67846_67867 = state_67834__$1;
(statearr_67846_67867[(2)] = coll);

(statearr_67846_67867[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (9))){
var inst_67807 = (state_67834[(2)]);
var inst_67808 = fluree.db.util.async.throw_err.call(null,inst_67807);
var state_67834__$1 = state_67834;
var statearr_67847_67868 = state_67834__$1;
(statearr_67847_67868[(2)] = inst_67808);

(statearr_67847_67868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (5))){
var _ = (function (){var statearr_67848 = state_67834;
(statearr_67848[(4)] = cljs.core.rest.call(null,(state_67834[(4)])));

return statearr_67848;
})();
var state_67834__$1 = state_67834;
var ex67845 = (state_67834__$1[(2)]);
var statearr_67849_67869 = state_67834__$1;
(statearr_67849_67869[(5)] = ex67845);


if((ex67845 instanceof Error)){
var statearr_67850_67870 = state_67834__$1;
(statearr_67850_67870[(1)] = (4));

(statearr_67850_67870[(5)] = null);

} else {
throw ex67845;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67835 === (10))){
var state_67834__$1 = state_67834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67834__$1,(13),coll);
} else {
if((state_val_67835 === (8))){
var inst_67819 = (state_67834[(2)]);
var inst_67820 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_67819);
var inst_67821 = cljs.core.count.call(null,inst_67820);
var inst_67822 = ((9) + inst_67821);
var inst_67823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67824 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67825 = ["count",inst_67819,inst_67821];
var inst_67826 = cljs.core.PersistentHashMap.fromArrays(inst_67824,inst_67825);
var inst_67827 = [inst_67826,inst_67822];
var inst_67828 = (new cljs.core.PersistentVector(null,2,(5),inst_67823,inst_67827,null));
var inst_67829 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67828);
var _ = (function (){var statearr_67851 = state_67834;
(statearr_67851[(4)] = cljs.core.rest.call(null,(state_67834[(4)])));

return statearr_67851;
})();
var state_67834__$1 = (function (){var statearr_67852 = state_67834;
(statearr_67852[(7)] = inst_67829);

return statearr_67852;
})();
var statearr_67853_67871 = state_67834__$1;
(statearr_67853_67871[(2)] = inst_67821);

(statearr_67853_67871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0 = (function (){
var statearr_67854 = [null,null,null,null,null,null,null,null];
(statearr_67854[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__);

(statearr_67854[(1)] = (1));

return statearr_67854;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1 = (function (state_67834){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67855){var ex__2749__auto__ = e67855;
var statearr_67856_67872 = state_67834;
(statearr_67856_67872[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67834[(4)]))){
var statearr_67857_67873 = state_67834;
(statearr_67857_67873[(1)] = cljs.core.first.call(null,(state_67834[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67874 = state_67834;
state_67834 = G__67874;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = function(state_67834){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1.call(this,state_67834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67858 = f__2769__auto__.call(null);
(statearr_67858[(6)] = c__2768__auto__);

return statearr_67858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__67875,subject,pred){
var map__67876 = p__67875;
var map__67876__$1 = cljs.core.__destructure_map.call(null,map__67876);
var _QMARK_ctx = map__67876__$1;
var cache = cljs.core.get.call(null,map__67876__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.call(null,map__67876__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67967){
var state_val_67968 = (state_67967[(1)]);
if((state_val_67968 === (7))){
var state_67967__$1 = state_67967;
var statearr_67969_68025 = state_67967__$1;
(statearr_67969_68025[(2)] = subject);

(statearr_67969_68025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (20))){
var state_67967__$1 = state_67967;
var statearr_67970_68026 = state_67967__$1;
(statearr_67970_68026[(2)] = cache);

(statearr_67970_68026[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (27))){
var inst_67898 = (state_67967[(7)]);
var inst_67910 = (state_67967[(8)]);
var inst_67924 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_67910,inst_67898);
var state_67967__$1 = state_67967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67967__$1,(29),inst_67924);
} else {
if((state_val_67968 === (1))){
var state_67967__$1 = state_67967;
var statearr_67971_68027 = state_67967__$1;
(statearr_67971_68027[(2)] = null);

(statearr_67971_68027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (24))){
var inst_67910 = (state_67967[(8)]);
var inst_67937 = cljs.core.int_QMARK_.call(null,inst_67910);
var state_67967__$1 = state_67967;
if(inst_67937){
var statearr_67972_68028 = state_67967__$1;
(statearr_67972_68028[(1)] = (30));

} else {
var statearr_67973_68029 = state_67967__$1;
(statearr_67973_68029[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (4))){
var inst_67877 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
var statearr_67974_68030 = state_67967__$1;
(statearr_67974_68030[(2)] = inst_67877);

(statearr_67974_68030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (15))){
var inst_67890 = (state_67967[(9)]);
var state_67967__$1 = state_67967;
var statearr_67975_68031 = state_67967__$1;
(statearr_67975_68031[(2)] = inst_67890);

(statearr_67975_68031[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (21))){
var inst_67911 = (state_67967[(10)]);
var state_67967__$1 = state_67967;
var statearr_67976_68032 = state_67967__$1;
(statearr_67976_68032[(2)] = inst_67911);

(statearr_67976_68032[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (31))){
var state_67967__$1 = state_67967;
var statearr_67977_68033 = state_67967__$1;
(statearr_67977_68033[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (32))){
var inst_67950 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
var statearr_67979_68034 = state_67967__$1;
(statearr_67979_68034[(2)] = inst_67950);

(statearr_67979_68034[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (33))){
var inst_67941 = (state_67967[(2)]);
var inst_67942 = fluree.db.util.async.throw_err.call(null,inst_67941);
var state_67967__$1 = state_67967;
var statearr_67980_68035 = state_67967__$1;
(statearr_67980_68035[(2)] = inst_67942);

(statearr_67980_68035[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (13))){
var inst_67894 = (state_67967[(2)]);
var inst_67895 = fluree.db.util.async.throw_err.call(null,inst_67894);
var state_67967__$1 = state_67967;
var statearr_67981_68036 = state_67967__$1;
(statearr_67981_68036[(2)] = inst_67895);

(statearr_67981_68036[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (22))){
var inst_67915 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
if(cljs.core.truth_(inst_67915)){
var statearr_67982_68037 = state_67967__$1;
(statearr_67982_68037[(1)] = (23));

} else {
var statearr_67983_68038 = state_67967__$1;
(statearr_67983_68038[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (36))){
var inst_67948 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
var statearr_67984_68039 = state_67967__$1;
(statearr_67984_68039[(2)] = inst_67948);

(statearr_67984_68039[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (29))){
var inst_67898 = (state_67967[(7)]);
var inst_67910 = (state_67967[(8)]);
var inst_67926 = (state_67967[(2)]);
var inst_67927 = fluree.db.util.async.throw_err.call(null,inst_67926);
var inst_67928 = cljs.core._deref.call(null,cache);
var inst_67929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67930 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_67910,inst_67898];
var inst_67931 = (new cljs.core.PersistentVector(null,3,(5),inst_67929,inst_67930,null));
var inst_67932 = cljs.core.assoc_in.call(null,inst_67928,inst_67931,inst_67927);
var inst_67933 = cljs.core._vreset_BANG_.call(null,cache,inst_67932);
var state_67967__$1 = (function (){var statearr_67985 = state_67967;
(statearr_67985[(11)] = inst_67933);

return statearr_67985;
})();
var statearr_67986_68040 = state_67967__$1;
(statearr_67986_68040[(2)] = inst_67927);

(statearr_67986_68040[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (6))){
var state_67967__$1 = state_67967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67967__$1,(9),subject);
} else {
if((state_val_67968 === (28))){
var inst_67935 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
var statearr_67987_68041 = state_67967__$1;
(statearr_67987_68041[(2)] = inst_67935);

(statearr_67987_68041[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (25))){
var inst_67890 = (state_67967[(9)]);
var inst_67898 = (state_67967[(7)]);
var inst_67952 = (state_67967[(2)]);
var inst_67953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67954 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67956 = [inst_67890,inst_67898];
var inst_67957 = (new cljs.core.PersistentVector(null,2,(5),inst_67955,inst_67956,null));
var inst_67958 = ["get",inst_67957,inst_67952];
var inst_67959 = cljs.core.PersistentHashMap.fromArrays(inst_67954,inst_67958);
var inst_67960 = [inst_67959,(10)];
var inst_67961 = (new cljs.core.PersistentVector(null,2,(5),inst_67953,inst_67960,null));
var inst_67962 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67961);
var _ = (function (){var statearr_67988 = state_67967;
(statearr_67988[(4)] = cljs.core.rest.call(null,(state_67967[(4)])));

return statearr_67988;
})();
var state_67967__$1 = (function (){var statearr_67989 = state_67967;
(statearr_67989[(12)] = inst_67962);

return statearr_67989;
})();
var statearr_67990_68042 = state_67967__$1;
(statearr_67990_68042[(2)] = inst_67952);

(statearr_67990_68042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (34))){
var inst_67898 = (state_67967[(7)]);
var inst_67910 = (state_67967[(8)]);
var inst_67945 = fluree.db.dbfunctions.internal.get.call(null,inst_67910,inst_67898);
var state_67967__$1 = state_67967;
var statearr_67991_68043 = state_67967__$1;
(statearr_67991_68043[(2)] = inst_67945);

(statearr_67991_68043[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (17))){
var inst_67890 = (state_67967[(9)]);
var inst_67904 = cljs.core.first.call(null,inst_67890);
var state_67967__$1 = state_67967;
var statearr_67992_68044 = state_67967__$1;
(statearr_67992_68044[(2)] = inst_67904);

(statearr_67992_68044[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (3))){
var inst_67965 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67967__$1,inst_67965);
} else {
if((state_val_67968 === (12))){
var inst_67890 = (state_67967[(9)]);
var inst_67898 = (state_67967[(2)]);
var inst_67899 = cljs.core.vector_QMARK_.call(null,inst_67890);
var state_67967__$1 = (function (){var statearr_67993 = state_67967;
(statearr_67993[(7)] = inst_67898);

return statearr_67993;
})();
if(inst_67899){
var statearr_67994_68045 = state_67967__$1;
(statearr_67994_68045[(1)] = (14));

} else {
var statearr_67995_68046 = state_67967__$1;
(statearr_67995_68046[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (2))){
var _ = (function (){var statearr_67996 = state_67967;
(statearr_67996[(4)] = cljs.core.cons.call(null,(5),(state_67967[(4)])));

return statearr_67996;
})();
var inst_67883 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_67967__$1 = state_67967;
if(inst_67883){
var statearr_67997_68047 = state_67967__$1;
(statearr_67997_68047[(1)] = (6));

} else {
var statearr_67998_68048 = state_67967__$1;
(statearr_67998_68048[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (23))){
var inst_67921 = (state_67967[(13)]);
var inst_67898 = (state_67967[(7)]);
var inst_67910 = (state_67967[(8)]);
var inst_67917 = cljs.core.deref.call(null,cache);
var inst_67918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67919 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_67910,inst_67898];
var inst_67920 = (new cljs.core.PersistentVector(null,3,(5),inst_67918,inst_67919,null));
var inst_67921__$1 = cljs.core.get_in.call(null,inst_67917,inst_67920);
var state_67967__$1 = (function (){var statearr_67999 = state_67967;
(statearr_67999[(13)] = inst_67921__$1);

return statearr_67999;
})();
if(cljs.core.truth_(inst_67921__$1)){
var statearr_68000_68049 = state_67967__$1;
(statearr_68000_68049[(1)] = (26));

} else {
var statearr_68001_68050 = state_67967__$1;
(statearr_68001_68050[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (35))){
var state_67967__$1 = state_67967;
var statearr_68002_68051 = state_67967__$1;
(statearr_68002_68051[(2)] = null);

(statearr_68002_68051[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (19))){
var inst_67907 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
var statearr_68003_68052 = state_67967__$1;
(statearr_68003_68052[(2)] = inst_67907);

(statearr_68003_68052[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (11))){
var state_67967__$1 = state_67967;
var statearr_68005_68053 = state_67967__$1;
(statearr_68005_68053[(2)] = pred);

(statearr_68005_68053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (9))){
var inst_67886 = (state_67967[(2)]);
var inst_67887 = fluree.db.util.async.throw_err.call(null,inst_67886);
var state_67967__$1 = state_67967;
var statearr_68006_68054 = state_67967__$1;
(statearr_68006_68054[(2)] = inst_67887);

(statearr_68006_68054[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (5))){
var _ = (function (){var statearr_68007 = state_67967;
(statearr_68007[(4)] = cljs.core.rest.call(null,(state_67967[(4)])));

return statearr_68007;
})();
var state_67967__$1 = state_67967;
var ex68004 = (state_67967__$1[(2)]);
var statearr_68008_68055 = state_67967__$1;
(statearr_68008_68055[(5)] = ex68004);


if((ex68004 instanceof Error)){
var statearr_68009_68056 = state_67967__$1;
(statearr_68009_68056[(1)] = (4));

(statearr_68009_68056[(5)] = null);

} else {
throw ex68004;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (14))){
var inst_67890 = (state_67967[(9)]);
var inst_67901 = cljs.core.count.call(null,inst_67890);
var inst_67902 = cljs.core._EQ_.call(null,(1),inst_67901);
var state_67967__$1 = state_67967;
if(inst_67902){
var statearr_68010_68057 = state_67967__$1;
(statearr_68010_68057[(1)] = (17));

} else {
var statearr_68011_68058 = state_67967__$1;
(statearr_68011_68058[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (26))){
var inst_67921 = (state_67967[(13)]);
var state_67967__$1 = state_67967;
var statearr_68012_68059 = state_67967__$1;
(statearr_68012_68059[(2)] = inst_67921);

(statearr_68012_68059[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (16))){
var inst_67911 = (state_67967[(10)]);
var inst_67910 = (state_67967[(8)]);
var inst_67910__$1 = (state_67967[(2)]);
var inst_67911__$1 = cljs.core.int_QMARK_.call(null,inst_67910__$1);
var state_67967__$1 = (function (){var statearr_68013 = state_67967;
(statearr_68013[(10)] = inst_67911__$1);

(statearr_68013[(8)] = inst_67910__$1);

return statearr_68013;
})();
if(inst_67911__$1){
var statearr_68014_68060 = state_67967__$1;
(statearr_68014_68060[(1)] = (20));

} else {
var statearr_68015_68061 = state_67967__$1;
(statearr_68015_68061[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (30))){
var inst_67898 = (state_67967[(7)]);
var inst_67910 = (state_67967[(8)]);
var inst_67939 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_67910,inst_67898);
var state_67967__$1 = state_67967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67967__$1,(33),inst_67939);
} else {
if((state_val_67968 === (10))){
var state_67967__$1 = state_67967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67967__$1,(13),pred);
} else {
if((state_val_67968 === (18))){
var inst_67890 = (state_67967[(9)]);
var state_67967__$1 = state_67967;
var statearr_68016_68062 = state_67967__$1;
(statearr_68016_68062[(2)] = inst_67890);

(statearr_68016_68062[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (8))){
var inst_67890 = (state_67967[(2)]);
var inst_67891 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_67967__$1 = (function (){var statearr_68017 = state_67967;
(statearr_68017[(9)] = inst_67890);

return statearr_68017;
})();
if(inst_67891){
var statearr_68018_68063 = state_67967__$1;
(statearr_68018_68063[(1)] = (10));

} else {
var statearr_68019_68064 = state_67967__$1;
(statearr_68019_68064[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0 = (function (){
var statearr_68020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68020[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__);

(statearr_68020[(1)] = (1));

return statearr_68020;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1 = (function (state_67967){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68021){var ex__2749__auto__ = e68021;
var statearr_68022_68065 = state_67967;
(statearr_68022_68065[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67967[(4)]))){
var statearr_68023_68066 = state_67967;
(statearr_68023_68066[(1)] = cljs.core.first.call(null,(state_67967[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68067 = state_67967;
state_67967 = G__68067;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = function(state_67967){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1.call(this,state_67967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68024 = f__2769__auto__.call(null);
(statearr_68024[(6)] = c__2768__auto__);

return statearr_68024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68106){
var state_val_68107 = (state_68106[(1)]);
if((state_val_68107 === (7))){
var inst_68074 = (state_68106[(7)]);
var state_68106__$1 = state_68106;
var statearr_68108_68132 = state_68106__$1;
(statearr_68108_68132[(2)] = inst_68074);

(statearr_68108_68132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (1))){
var state_68106__$1 = state_68106;
var statearr_68109_68133 = state_68106__$1;
(statearr_68109_68133[(2)] = null);

(statearr_68109_68133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (4))){
var inst_68068 = (state_68106[(2)]);
var state_68106__$1 = state_68106;
var statearr_68110_68134 = state_68106__$1;
(statearr_68110_68134[(2)] = inst_68068);

(statearr_68110_68134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (6))){
var inst_68076 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68106__$1 = state_68106;
var statearr_68111_68135 = state_68106__$1;
(statearr_68111_68135[(2)] = inst_68076);

(statearr_68111_68135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (3))){
var inst_68104 = (state_68106[(2)]);
var state_68106__$1 = state_68106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68106__$1,inst_68104);
} else {
if((state_val_68107 === (12))){
var inst_68086 = (state_68106[(2)]);
var inst_68087 = fluree.db.util.async.throw_err.call(null,inst_68086);
var inst_68088 = cljs.core.nth.call(null,inst_68087,(0),null);
var inst_68089 = cljs.core.nth.call(null,inst_68087,(1),null);
var inst_68090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68091 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68092 = ["?pO","?ctx",inst_68088];
var inst_68093 = cljs.core.PersistentHashMap.fromArrays(inst_68091,inst_68092);
var inst_68094 = ((10) + inst_68089);
var inst_68095 = [inst_68093,inst_68094];
var inst_68096 = (new cljs.core.PersistentVector(null,2,(5),inst_68090,inst_68095,null));
var inst_68097 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68096);
var state_68106__$1 = (function (){var statearr_68112 = state_68106;
(statearr_68112[(8)] = inst_68097);

return statearr_68112;
})();
var statearr_68113_68136 = state_68106__$1;
(statearr_68113_68136[(2)] = inst_68088);

(statearr_68113_68136[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (2))){
var inst_68074 = (state_68106[(7)]);
var _ = (function (){var statearr_68114 = state_68106;
(statearr_68114[(4)] = cljs.core.cons.call(null,(5),(state_68106[(4)])));

return statearr_68114;
})();
var inst_68074__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68106__$1 = (function (){var statearr_68115 = state_68106;
(statearr_68115[(7)] = inst_68074__$1);

return statearr_68115;
})();
if(cljs.core.truth_(inst_68074__$1)){
var statearr_68116_68137 = state_68106__$1;
(statearr_68116_68137[(1)] = (6));

} else {
var statearr_68117_68138 = state_68106__$1;
(statearr_68117_68138[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (11))){
var inst_68101 = (state_68106[(2)]);
var _ = (function (){var statearr_68119 = state_68106;
(statearr_68119[(4)] = cljs.core.rest.call(null,(state_68106[(4)])));

return statearr_68119;
})();
var state_68106__$1 = state_68106;
var statearr_68120_68139 = state_68106__$1;
(statearr_68120_68139[(2)] = inst_68101);

(statearr_68120_68139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (9))){
var inst_68084 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_68106__$1 = state_68106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68106__$1,(12),inst_68084);
} else {
if((state_val_68107 === (5))){
var _ = (function (){var statearr_68121 = state_68106;
(statearr_68121[(4)] = cljs.core.rest.call(null,(state_68106[(4)])));

return statearr_68121;
})();
var state_68106__$1 = state_68106;
var ex68118 = (state_68106__$1[(2)]);
var statearr_68122_68140 = state_68106__$1;
(statearr_68122_68140[(5)] = ex68118);


if((ex68118 instanceof Error)){
var statearr_68123_68141 = state_68106__$1;
(statearr_68123_68141[(1)] = (4));

(statearr_68123_68141[(5)] = null);

} else {
throw ex68118;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (10))){
var inst_68099 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_68106__$1 = state_68106;
var statearr_68124_68142 = state_68106__$1;
(statearr_68124_68142[(2)] = inst_68099);

(statearr_68124_68142[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68107 === (8))){
var inst_68079 = (state_68106[(2)]);
var state_68106__$1 = state_68106;
if(cljs.core.truth_(inst_68079)){
var statearr_68125_68143 = state_68106__$1;
(statearr_68125_68143[(1)] = (9));

} else {
var statearr_68126_68144 = state_68106__$1;
(statearr_68126_68144[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_68127 = [null,null,null,null,null,null,null,null,null];
(statearr_68127[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_68127[(1)] = (1));

return statearr_68127;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_68106){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68128){var ex__2749__auto__ = e68128;
var statearr_68129_68145 = state_68106;
(statearr_68129_68145[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68106[(4)]))){
var statearr_68130_68146 = state_68106;
(statearr_68130_68146[(1)] = cljs.core.first.call(null,(state_68106[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68147 = state_68106;
state_68106 = G__68147;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = function(state_68106){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_68106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68131 = f__2769__auto__.call(null);
(statearr_68131[(6)] = c__2768__auto__);

return statearr_68131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68216){
var state_val_68217 = (state_68216[(1)]);
if((state_val_68217 === (7))){
var state_68216__$1 = state_68216;
var statearr_68218_68256 = state_68216__$1;
(statearr_68218_68256[(2)] = subject);

(statearr_68218_68256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (20))){
var inst_68172 = (state_68216[(7)]);
var inst_68184 = (state_68216[(8)]);
var inst_68187 = fluree.db.dbfunctions.internal.follow_subject.call(null,_QMARK_ctx,inst_68184,inst_68172);
var state_68216__$1 = state_68216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68216__$1,(23),inst_68187);
} else {
if((state_val_68217 === (1))){
var state_68216__$1 = state_68216;
var statearr_68219_68257 = state_68216__$1;
(statearr_68219_68257[(2)] = null);

(statearr_68219_68257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (4))){
var inst_68148 = (state_68216[(2)]);
var state_68216__$1 = state_68216;
var statearr_68220_68258 = state_68216__$1;
(statearr_68220_68258[(2)] = inst_68148);

(statearr_68220_68258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (15))){
var inst_68164 = (state_68216[(9)]);
var state_68216__$1 = state_68216;
var statearr_68221_68259 = state_68216__$1;
(statearr_68221_68259[(2)] = inst_68164);

(statearr_68221_68259[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (21))){
var inst_68172 = (state_68216[(7)]);
var inst_68184 = (state_68216[(8)]);
var inst_68192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68193 = fluree.db.dbfunctions.internal.get_all.call(null,inst_68184,inst_68172);
var inst_68194 = cljs.core.count.call(null,inst_68172);
var inst_68195 = ((9) + inst_68194);
var inst_68196 = [inst_68193,inst_68195];
var inst_68197 = (new cljs.core.PersistentVector(null,2,(5),inst_68192,inst_68196,null));
var state_68216__$1 = state_68216;
var statearr_68222_68260 = state_68216__$1;
(statearr_68222_68260[(2)] = inst_68197);

(statearr_68222_68260[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (13))){
var inst_68168 = (state_68216[(2)]);
var inst_68169 = fluree.db.util.async.throw_err.call(null,inst_68168);
var state_68216__$1 = state_68216;
var statearr_68223_68261 = state_68216__$1;
(statearr_68223_68261[(2)] = inst_68169);

(statearr_68223_68261[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (22))){
var inst_68164 = (state_68216[(9)]);
var inst_68172 = (state_68216[(7)]);
var inst_68199 = (state_68216[(2)]);
var inst_68200 = cljs.core.nth.call(null,inst_68199,(0),null);
var inst_68201 = cljs.core.nth.call(null,inst_68199,(1),null);
var inst_68202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68203 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68205 = [inst_68164,inst_68172];
var inst_68206 = (new cljs.core.PersistentVector(null,2,(5),inst_68204,inst_68205,null));
var inst_68207 = ["get-all",inst_68206,inst_68200];
var inst_68208 = cljs.core.PersistentHashMap.fromArrays(inst_68203,inst_68207);
var inst_68209 = [inst_68208,inst_68201];
var inst_68210 = (new cljs.core.PersistentVector(null,2,(5),inst_68202,inst_68209,null));
var inst_68211 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68210);
var _ = (function (){var statearr_68224 = state_68216;
(statearr_68224[(4)] = cljs.core.rest.call(null,(state_68216[(4)])));

return statearr_68224;
})();
var state_68216__$1 = (function (){var statearr_68225 = state_68216;
(statearr_68225[(10)] = inst_68211);

return statearr_68225;
})();
var statearr_68226_68262 = state_68216__$1;
(statearr_68226_68262[(2)] = inst_68200);

(statearr_68226_68262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (6))){
var state_68216__$1 = state_68216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68216__$1,(9),subject);
} else {
if((state_val_68217 === (17))){
var inst_68164 = (state_68216[(9)]);
var inst_68178 = cljs.core.first.call(null,inst_68164);
var state_68216__$1 = state_68216;
var statearr_68227_68263 = state_68216__$1;
(statearr_68227_68263[(2)] = inst_68178);

(statearr_68227_68263[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (3))){
var inst_68214 = (state_68216[(2)]);
var state_68216__$1 = state_68216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68216__$1,inst_68214);
} else {
if((state_val_68217 === (12))){
var inst_68164 = (state_68216[(9)]);
var inst_68172 = (state_68216[(2)]);
var inst_68173 = cljs.core.vector_QMARK_.call(null,inst_68164);
var state_68216__$1 = (function (){var statearr_68228 = state_68216;
(statearr_68228[(7)] = inst_68172);

return statearr_68228;
})();
if(inst_68173){
var statearr_68229_68264 = state_68216__$1;
(statearr_68229_68264[(1)] = (14));

} else {
var statearr_68230_68265 = state_68216__$1;
(statearr_68230_68265[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (2))){
var _ = (function (){var statearr_68231 = state_68216;
(statearr_68231[(4)] = cljs.core.cons.call(null,(5),(state_68216[(4)])));

return statearr_68231;
})();
var inst_68157 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_68216__$1 = state_68216;
if(inst_68157){
var statearr_68232_68266 = state_68216__$1;
(statearr_68232_68266[(1)] = (6));

} else {
var statearr_68233_68267 = state_68216__$1;
(statearr_68233_68267[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (23))){
var inst_68189 = (state_68216[(2)]);
var inst_68190 = fluree.db.util.async.throw_err.call(null,inst_68189);
var state_68216__$1 = state_68216;
var statearr_68234_68268 = state_68216__$1;
(statearr_68234_68268[(2)] = inst_68190);

(statearr_68234_68268[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (19))){
var inst_68181 = (state_68216[(2)]);
var state_68216__$1 = state_68216;
var statearr_68235_68269 = state_68216__$1;
(statearr_68235_68269[(2)] = inst_68181);

(statearr_68235_68269[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (11))){
var state_68216__$1 = state_68216;
var statearr_68237_68270 = state_68216__$1;
(statearr_68237_68270[(2)] = path);

(statearr_68237_68270[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (9))){
var inst_68160 = (state_68216[(2)]);
var inst_68161 = fluree.db.util.async.throw_err.call(null,inst_68160);
var state_68216__$1 = state_68216;
var statearr_68238_68271 = state_68216__$1;
(statearr_68238_68271[(2)] = inst_68161);

(statearr_68238_68271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (5))){
var _ = (function (){var statearr_68239 = state_68216;
(statearr_68239[(4)] = cljs.core.rest.call(null,(state_68216[(4)])));

return statearr_68239;
})();
var state_68216__$1 = state_68216;
var ex68236 = (state_68216__$1[(2)]);
var statearr_68240_68272 = state_68216__$1;
(statearr_68240_68272[(5)] = ex68236);


if((ex68236 instanceof Error)){
var statearr_68241_68273 = state_68216__$1;
(statearr_68241_68273[(1)] = (4));

(statearr_68241_68273[(5)] = null);

} else {
throw ex68236;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (14))){
var inst_68164 = (state_68216[(9)]);
var inst_68175 = cljs.core.count.call(null,inst_68164);
var inst_68176 = cljs.core._EQ_.call(null,(1),inst_68175);
var state_68216__$1 = state_68216;
if(inst_68176){
var statearr_68242_68274 = state_68216__$1;
(statearr_68242_68274[(1)] = (17));

} else {
var statearr_68243_68275 = state_68216__$1;
(statearr_68243_68275[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (16))){
var inst_68184 = (state_68216[(8)]);
var inst_68184__$1 = (state_68216[(2)]);
var inst_68185 = cljs.core.int_QMARK_.call(null,inst_68184__$1);
var state_68216__$1 = (function (){var statearr_68244 = state_68216;
(statearr_68244[(8)] = inst_68184__$1);

return statearr_68244;
})();
if(inst_68185){
var statearr_68245_68276 = state_68216__$1;
(statearr_68245_68276[(1)] = (20));

} else {
var statearr_68246_68277 = state_68216__$1;
(statearr_68246_68277[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (10))){
var state_68216__$1 = state_68216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68216__$1,(13),path);
} else {
if((state_val_68217 === (18))){
var inst_68164 = (state_68216[(9)]);
var state_68216__$1 = state_68216;
var statearr_68247_68278 = state_68216__$1;
(statearr_68247_68278[(2)] = inst_68164);

(statearr_68247_68278[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68217 === (8))){
var inst_68164 = (state_68216[(2)]);
var inst_68165 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_68216__$1 = (function (){var statearr_68248 = state_68216;
(statearr_68248[(9)] = inst_68164);

return statearr_68248;
})();
if(inst_68165){
var statearr_68249_68279 = state_68216__$1;
(statearr_68249_68279[(1)] = (10));

} else {
var statearr_68250_68280 = state_68216__$1;
(statearr_68250_68280[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0 = (function (){
var statearr_68251 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_68251[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__);

(statearr_68251[(1)] = (1));

return statearr_68251;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1 = (function (state_68216){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68252){var ex__2749__auto__ = e68252;
var statearr_68253_68281 = state_68216;
(statearr_68253_68281[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68216[(4)]))){
var statearr_68254_68282 = state_68216;
(statearr_68254_68282[(1)] = cljs.core.first.call(null,(state_68216[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68283 = state_68216;
state_68216 = G__68283;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = function(state_68216){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1.call(this,state_68216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68255 = f__2769__auto__.call(null);
(statearr_68255[(6)] = c__2768__auto__);

return statearr_68255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68322){
var state_val_68323 = (state_68322[(1)]);
if((state_val_68323 === (7))){
var state_68322__$1 = state_68322;
var statearr_68324_68348 = state_68322__$1;
(statearr_68324_68348[(2)] = subject);

(statearr_68324_68348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (1))){
var state_68322__$1 = state_68322;
var statearr_68325_68349 = state_68322__$1;
(statearr_68325_68349[(2)] = null);

(statearr_68325_68349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (4))){
var inst_68284 = (state_68322[(2)]);
var state_68322__$1 = state_68322;
var statearr_68326_68350 = state_68322__$1;
(statearr_68326_68350[(2)] = inst_68284);

(statearr_68326_68350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (13))){
var inst_68301 = (state_68322[(2)]);
var inst_68302 = fluree.db.util.async.throw_err.call(null,inst_68301);
var state_68322__$1 = state_68322;
var statearr_68327_68351 = state_68322__$1;
(statearr_68327_68351[(2)] = inst_68302);

(statearr_68327_68351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (6))){
var state_68322__$1 = state_68322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68322__$1,(9),subject);
} else {
if((state_val_68323 === (3))){
var inst_68320 = (state_68322[(2)]);
var state_68322__$1 = state_68322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68322__$1,inst_68320);
} else {
if((state_val_68323 === (12))){
var inst_68297 = (state_68322[(7)]);
var inst_68305 = (state_68322[(2)]);
var inst_68306 = fluree.db.dbfunctions.internal.get_in.call(null,inst_68297,inst_68305);
var inst_68307 = cljs.core.count.call(null,inst_68305);
var inst_68308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68309 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68311 = [inst_68297,inst_68305];
var inst_68312 = (new cljs.core.PersistentVector(null,2,(5),inst_68310,inst_68311,null));
var inst_68313 = ["get-in",inst_68312,inst_68306];
var inst_68314 = cljs.core.PersistentHashMap.fromArrays(inst_68309,inst_68313);
var inst_68315 = [inst_68314,inst_68307];
var inst_68316 = (new cljs.core.PersistentVector(null,2,(5),inst_68308,inst_68315,null));
var inst_68317 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68316);
var _ = (function (){var statearr_68328 = state_68322;
(statearr_68328[(4)] = cljs.core.rest.call(null,(state_68322[(4)])));

return statearr_68328;
})();
var state_68322__$1 = (function (){var statearr_68329 = state_68322;
(statearr_68329[(8)] = inst_68317);

return statearr_68329;
})();
var statearr_68330_68352 = state_68322__$1;
(statearr_68330_68352[(2)] = inst_68306);

(statearr_68330_68352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (2))){
var _ = (function (){var statearr_68331 = state_68322;
(statearr_68331[(4)] = cljs.core.cons.call(null,(5),(state_68322[(4)])));

return statearr_68331;
})();
var inst_68290 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_68322__$1 = state_68322;
if(inst_68290){
var statearr_68332_68353 = state_68322__$1;
(statearr_68332_68353[(1)] = (6));

} else {
var statearr_68333_68354 = state_68322__$1;
(statearr_68333_68354[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (11))){
var state_68322__$1 = state_68322;
var statearr_68335_68355 = state_68322__$1;
(statearr_68335_68355[(2)] = path);

(statearr_68335_68355[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (9))){
var inst_68293 = (state_68322[(2)]);
var inst_68294 = fluree.db.util.async.throw_err.call(null,inst_68293);
var state_68322__$1 = state_68322;
var statearr_68336_68356 = state_68322__$1;
(statearr_68336_68356[(2)] = inst_68294);

(statearr_68336_68356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (5))){
var _ = (function (){var statearr_68337 = state_68322;
(statearr_68337[(4)] = cljs.core.rest.call(null,(state_68322[(4)])));

return statearr_68337;
})();
var state_68322__$1 = state_68322;
var ex68334 = (state_68322__$1[(2)]);
var statearr_68338_68357 = state_68322__$1;
(statearr_68338_68357[(5)] = ex68334);


if((ex68334 instanceof Error)){
var statearr_68339_68358 = state_68322__$1;
(statearr_68339_68358[(1)] = (4));

(statearr_68339_68358[(5)] = null);

} else {
throw ex68334;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68323 === (10))){
var state_68322__$1 = state_68322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68322__$1,(13),path);
} else {
if((state_val_68323 === (8))){
var inst_68297 = (state_68322[(2)]);
var inst_68298 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_68322__$1 = (function (){var statearr_68340 = state_68322;
(statearr_68340[(7)] = inst_68297);

return statearr_68340;
})();
if(inst_68298){
var statearr_68341_68359 = state_68322__$1;
(statearr_68341_68359[(1)] = (10));

} else {
var statearr_68342_68360 = state_68322__$1;
(statearr_68342_68360[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0 = (function (){
var statearr_68343 = [null,null,null,null,null,null,null,null,null];
(statearr_68343[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__);

(statearr_68343[(1)] = (1));

return statearr_68343;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1 = (function (state_68322){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68344){var ex__2749__auto__ = e68344;
var statearr_68345_68361 = state_68322;
(statearr_68345_68361[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68322[(4)]))){
var statearr_68346_68362 = state_68322;
(statearr_68346_68362[(1)] = cljs.core.first.call(null,(state_68322[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68363 = state_68322;
state_68322 = G__68363;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = function(state_68322){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1.call(this,state_68322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68347 = f__2769__auto__.call(null);
(statearr_68347[(6)] = c__2768__auto__);

return statearr_68347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__68364,key_or_ks){
var map__68365 = p__68364;
var map__68365__$1 = cljs.core.__destructure_map.call(null,map__68365);
var _QMARK_ctx = map__68365__$1;
var db = cljs.core.get.call(null,map__68365__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_.call(null,key_or_ks)){
return cljs.core.get_in.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68410){
var state_val_68411 = (state_68410[(1)]);
if((state_val_68411 === (7))){
var state_68410__$1 = state_68410;
var statearr_68412_68441 = state_68410__$1;
(statearr_68412_68441[(2)] = coll);

(statearr_68412_68441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (1))){
var state_68410__$1 = state_68410;
var statearr_68413_68442 = state_68410__$1;
(statearr_68413_68442[(2)] = null);

(statearr_68413_68442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (4))){
var inst_68366 = (state_68410[(2)]);
var state_68410__$1 = state_68410;
var statearr_68414_68443 = state_68410__$1;
(statearr_68414_68443[(2)] = inst_68366);

(statearr_68414_68443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (15))){
var inst_68386 = (state_68410[(7)]);
var inst_68394 = (state_68410[(2)]);
var inst_68395 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_68386,inst_68394);
var inst_68396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68397 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68399 = [inst_68386,inst_68394];
var inst_68400 = (new cljs.core.PersistentVector(null,2,(5),inst_68398,inst_68399,null));
var inst_68401 = ["contains?",inst_68400,inst_68395];
var inst_68402 = cljs.core.PersistentHashMap.fromArrays(inst_68397,inst_68401);
var inst_68403 = [inst_68402,(10)];
var inst_68404 = (new cljs.core.PersistentVector(null,2,(5),inst_68396,inst_68403,null));
var inst_68405 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68404);
var _ = (function (){var statearr_68415 = state_68410;
(statearr_68415[(4)] = cljs.core.rest.call(null,(state_68410[(4)])));

return statearr_68415;
})();
var state_68410__$1 = (function (){var statearr_68416 = state_68410;
(statearr_68416[(8)] = inst_68405);

return statearr_68416;
})();
var statearr_68417_68444 = state_68410__$1;
(statearr_68417_68444[(2)] = inst_68395);

(statearr_68417_68444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (13))){
var state_68410__$1 = state_68410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68410__$1,(16),key);
} else {
if((state_val_68411 === (6))){
var state_68410__$1 = state_68410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68410__$1,(9),coll);
} else {
if((state_val_68411 === (3))){
var inst_68408 = (state_68410[(2)]);
var state_68410__$1 = state_68410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68410__$1,inst_68408);
} else {
if((state_val_68411 === (12))){
var inst_68386 = (state_68410[(2)]);
var inst_68387 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_68410__$1 = (function (){var statearr_68418 = state_68410;
(statearr_68418[(7)] = inst_68386);

return statearr_68418;
})();
if(inst_68387){
var statearr_68419_68445 = state_68410__$1;
(statearr_68419_68445[(1)] = (13));

} else {
var statearr_68420_68446 = state_68410__$1;
(statearr_68420_68446[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (2))){
var _ = (function (){var statearr_68421 = state_68410;
(statearr_68421[(4)] = cljs.core.cons.call(null,(5),(state_68410[(4)])));

return statearr_68421;
})();
var inst_68372 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_68410__$1 = state_68410;
if(inst_68372){
var statearr_68422_68447 = state_68410__$1;
(statearr_68422_68447[(1)] = (6));

} else {
var statearr_68423_68448 = state_68410__$1;
(statearr_68423_68448[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (11))){
var inst_68379 = (state_68410[(9)]);
var inst_68383 = cljs.core.flatten.call(null,inst_68379);
var inst_68384 = cljs.core.set.call(null,inst_68383);
var state_68410__$1 = state_68410;
var statearr_68425_68449 = state_68410__$1;
(statearr_68425_68449[(2)] = inst_68384);

(statearr_68425_68449[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (9))){
var inst_68375 = (state_68410[(2)]);
var inst_68376 = fluree.db.util.async.throw_err.call(null,inst_68375);
var state_68410__$1 = state_68410;
var statearr_68426_68450 = state_68410__$1;
(statearr_68426_68450[(2)] = inst_68376);

(statearr_68426_68450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (5))){
var _ = (function (){var statearr_68427 = state_68410;
(statearr_68427[(4)] = cljs.core.rest.call(null,(state_68410[(4)])));

return statearr_68427;
})();
var state_68410__$1 = state_68410;
var ex68424 = (state_68410__$1[(2)]);
var statearr_68428_68451 = state_68410__$1;
(statearr_68428_68451[(5)] = ex68424);


if((ex68424 instanceof Error)){
var statearr_68429_68452 = state_68410__$1;
(statearr_68429_68452[(1)] = (4));

(statearr_68429_68452[(5)] = null);

} else {
throw ex68424;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (14))){
var state_68410__$1 = state_68410;
var statearr_68430_68453 = state_68410__$1;
(statearr_68430_68453[(2)] = key);

(statearr_68430_68453[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (16))){
var inst_68390 = (state_68410[(2)]);
var inst_68391 = fluree.db.util.async.throw_err.call(null,inst_68390);
var state_68410__$1 = state_68410;
var statearr_68431_68454 = state_68410__$1;
(statearr_68431_68454[(2)] = inst_68391);

(statearr_68431_68454[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (10))){
var inst_68379 = (state_68410[(9)]);
var state_68410__$1 = state_68410;
var statearr_68432_68455 = state_68410__$1;
(statearr_68432_68455[(2)] = inst_68379);

(statearr_68432_68455[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68411 === (8))){
var inst_68379 = (state_68410[(9)]);
var inst_68379__$1 = (state_68410[(2)]);
var inst_68380 = cljs.core.set_QMARK_.call(null,inst_68379__$1);
var state_68410__$1 = (function (){var statearr_68433 = state_68410;
(statearr_68433[(9)] = inst_68379__$1);

return statearr_68433;
})();
if(inst_68380){
var statearr_68434_68456 = state_68410__$1;
(statearr_68434_68456[(1)] = (10));

} else {
var statearr_68435_68457 = state_68410__$1;
(statearr_68435_68457[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_68436 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68436[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__);

(statearr_68436[(1)] = (1));

return statearr_68436;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1 = (function (state_68410){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68437){var ex__2749__auto__ = e68437;
var statearr_68438_68458 = state_68410;
(statearr_68438_68458[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68410[(4)]))){
var statearr_68439_68459 = state_68410;
(statearr_68439_68459[(1)] = cljs.core.first.call(null,(state_68410[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68460 = state_68410;
state_68410 = G__68460;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = function(state_68410){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1.call(this,state_68410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68440 = f__2769__auto__.call(null);
(statearr_68440[(6)] = c__2768__auto__);

return statearr_68440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68532 = arguments.length;
var i__5770__auto___68533 = (0);
while(true){
if((i__5770__auto___68533 < len__5769__auto___68532)){
args__5775__auto__.push((arguments[i__5770__auto___68533]));

var G__68534 = (i__5770__auto___68533 + (1));
i__5770__auto___68533 = G__68534;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68506){
var state_val_68507 = (state_68506[(1)]);
if((state_val_68507 === (7))){
var inst_68472 = (state_68506[(7)]);
var inst_68476 = cljs.core.first.call(null,inst_68472);
var inst_68477 = cljs.core.coll_QMARK_.call(null,inst_68476);
var state_68506__$1 = state_68506;
var statearr_68508_68535 = state_68506__$1;
(statearr_68508_68535[(2)] = inst_68477);

(statearr_68508_68535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (1))){
var state_68506__$1 = state_68506;
var statearr_68509_68536 = state_68506__$1;
(statearr_68509_68536[(2)] = null);

(statearr_68509_68536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (4))){
var inst_68463 = (state_68506[(2)]);
var state_68506__$1 = state_68506;
var statearr_68510_68537 = state_68506__$1;
(statearr_68510_68537[(2)] = inst_68463);

(statearr_68510_68537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (6))){
var inst_68474 = (state_68506[(8)]);
var inst_68472 = (state_68506[(7)]);
var inst_68471 = (state_68506[(2)]);
var inst_68472__$1 = fluree.db.util.async.throw_err.call(null,inst_68471);
var inst_68473 = cljs.core.count.call(null,inst_68472__$1);
var inst_68474__$1 = cljs.core._EQ_.call(null,(1),inst_68473);
var state_68506__$1 = (function (){var statearr_68511 = state_68506;
(statearr_68511[(8)] = inst_68474__$1);

(statearr_68511[(7)] = inst_68472__$1);

return statearr_68511;
})();
if(inst_68474__$1){
var statearr_68512_68538 = state_68506__$1;
(statearr_68512_68538[(1)] = (7));

} else {
var statearr_68513_68539 = state_68506__$1;
(statearr_68513_68539[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (3))){
var inst_68504 = (state_68506[(2)]);
var state_68506__$1 = state_68506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68506__$1,inst_68504);
} else {
if((state_val_68507 === (12))){
var inst_68485 = (state_68506[(2)]);
var inst_68486 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_68485);
var inst_68487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68488 = [inst_68485];
var inst_68489 = (new cljs.core.PersistentVector(null,1,(5),inst_68487,inst_68488,null));
var inst_68490 = cljs.core.count.call(null,inst_68489);
var inst_68491 = ((9) + inst_68490);
var inst_68492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68493 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68495 = [inst_68485];
var inst_68496 = (new cljs.core.PersistentVector(null,1,(5),inst_68494,inst_68495,null));
var inst_68497 = ["hash-set",inst_68496,inst_68486];
var inst_68498 = cljs.core.PersistentHashMap.fromArrays(inst_68493,inst_68497);
var inst_68499 = [inst_68498,inst_68491];
var inst_68500 = (new cljs.core.PersistentVector(null,2,(5),inst_68492,inst_68499,null));
var inst_68501 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68500);
var _ = (function (){var statearr_68514 = state_68506;
(statearr_68514[(4)] = cljs.core.rest.call(null,(state_68506[(4)])));

return statearr_68514;
})();
var state_68506__$1 = (function (){var statearr_68515 = state_68506;
(statearr_68515[(9)] = inst_68501);

return statearr_68515;
})();
var statearr_68516_68540 = state_68506__$1;
(statearr_68516_68540[(2)] = inst_68486);

(statearr_68516_68540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (2))){
var _ = (function (){var statearr_68517 = state_68506;
(statearr_68517[(4)] = cljs.core.cons.call(null,(5),(state_68506[(4)])));

return statearr_68517;
})();
var inst_68469 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68506__$1 = state_68506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68506__$1,(6),inst_68469);
} else {
if((state_val_68507 === (11))){
var inst_68472 = (state_68506[(7)]);
var state_68506__$1 = state_68506;
var statearr_68519_68541 = state_68506__$1;
(statearr_68519_68541[(2)] = inst_68472);

(statearr_68519_68541[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (9))){
var inst_68480 = (state_68506[(2)]);
var state_68506__$1 = state_68506;
if(cljs.core.truth_(inst_68480)){
var statearr_68520_68542 = state_68506__$1;
(statearr_68520_68542[(1)] = (10));

} else {
var statearr_68521_68543 = state_68506__$1;
(statearr_68521_68543[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (5))){
var _ = (function (){var statearr_68522 = state_68506;
(statearr_68522[(4)] = cljs.core.rest.call(null,(state_68506[(4)])));

return statearr_68522;
})();
var state_68506__$1 = state_68506;
var ex68518 = (state_68506__$1[(2)]);
var statearr_68523_68544 = state_68506__$1;
(statearr_68523_68544[(5)] = ex68518);


if((ex68518 instanceof Error)){
var statearr_68524_68545 = state_68506__$1;
(statearr_68524_68545[(1)] = (4));

(statearr_68524_68545[(5)] = null);

} else {
throw ex68518;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (10))){
var inst_68472 = (state_68506[(7)]);
var inst_68482 = cljs.core.first.call(null,inst_68472);
var state_68506__$1 = state_68506;
var statearr_68525_68546 = state_68506__$1;
(statearr_68525_68546[(2)] = inst_68482);

(statearr_68525_68546[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68507 === (8))){
var inst_68474 = (state_68506[(8)]);
var state_68506__$1 = state_68506;
var statearr_68526_68547 = state_68506__$1;
(statearr_68526_68547[(2)] = inst_68474);

(statearr_68526_68547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68527 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68527[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68527[(1)] = (1));

return statearr_68527;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68506){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68528){var ex__2749__auto__ = e68528;
var statearr_68529_68548 = state_68506;
(statearr_68529_68548[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68506[(4)]))){
var statearr_68530_68549 = state_68506;
(statearr_68530_68549[(1)] = cljs.core.first.call(null,(state_68506[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68550 = state_68506;
state_68506 = G__68550;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68506){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68531 = f__2769__auto__.call(null);
(statearr_68531[(6)] = c__2768__auto__);

return statearr_68531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq68461){
var G__68462 = cljs.core.first.call(null,seq68461);
var seq68461__$1 = cljs.core.next.call(null,seq68461);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68462,seq68461__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68600 = arguments.length;
var i__5770__auto___68601 = (0);
while(true){
if((i__5770__auto___68601 < len__5769__auto___68600)){
args__5775__auto__.push((arguments[i__5770__auto___68601]));

var G__68602 = (i__5770__auto___68601 + (1));
i__5770__auto___68601 = G__68602;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68583){
var state_val_68584 = (state_68583[(1)]);
if((state_val_68584 === (1))){
var state_68583__$1 = state_68583;
var statearr_68585_68603 = state_68583__$1;
(statearr_68585_68603[(2)] = null);

(statearr_68585_68603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68584 === (2))){
var _ = (function (){var statearr_68586 = state_68583;
(statearr_68586[(4)] = cljs.core.cons.call(null,(5),(state_68583[(4)])));

return statearr_68586;
})();
var inst_68559 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68583__$1 = state_68583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68583__$1,(6),inst_68559);
} else {
if((state_val_68584 === (3))){
var inst_68581 = (state_68583[(2)]);
var state_68583__$1 = state_68583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68583__$1,inst_68581);
} else {
if((state_val_68584 === (4))){
var inst_68553 = (state_68583[(2)]);
var state_68583__$1 = state_68583;
var statearr_68588_68604 = state_68583__$1;
(statearr_68588_68604[(2)] = inst_68553);

(statearr_68588_68604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68584 === (5))){
var _ = (function (){var statearr_68589 = state_68583;
(statearr_68589[(4)] = cljs.core.rest.call(null,(state_68583[(4)])));

return statearr_68589;
})();
var state_68583__$1 = state_68583;
var ex68587 = (state_68583__$1[(2)]);
var statearr_68590_68605 = state_68583__$1;
(statearr_68590_68605[(5)] = ex68587);


if((ex68587 instanceof Error)){
var statearr_68591_68606 = state_68583__$1;
(statearr_68591_68606[(1)] = (4));

(statearr_68591_68606[(5)] = null);

} else {
throw ex68587;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68584 === (6))){
var inst_68561 = (state_68583[(2)]);
var inst_68562 = fluree.db.util.async.throw_err.call(null,inst_68561);
var inst_68563 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_68562);
var inst_68564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68565 = [inst_68562];
var inst_68566 = (new cljs.core.PersistentVector(null,1,(5),inst_68564,inst_68565,null));
var inst_68567 = cljs.core.count.call(null,inst_68566);
var inst_68568 = ((9) + inst_68567);
var inst_68569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68570 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68572 = [inst_68562];
var inst_68573 = (new cljs.core.PersistentVector(null,1,(5),inst_68571,inst_68572,null));
var inst_68574 = ["==",inst_68573,inst_68563];
var inst_68575 = cljs.core.PersistentHashMap.fromArrays(inst_68570,inst_68574);
var inst_68576 = [inst_68575,inst_68568];
var inst_68577 = (new cljs.core.PersistentVector(null,2,(5),inst_68569,inst_68576,null));
var inst_68578 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68577);
var _ = (function (){var statearr_68592 = state_68583;
(statearr_68592[(4)] = cljs.core.rest.call(null,(state_68583[(4)])));

return statearr_68592;
})();
var state_68583__$1 = (function (){var statearr_68593 = state_68583;
(statearr_68593[(7)] = inst_68578);

return statearr_68593;
})();
var statearr_68594_68607 = state_68583__$1;
(statearr_68594_68607[(2)] = inst_68563);

(statearr_68594_68607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68595 = [null,null,null,null,null,null,null,null];
(statearr_68595[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68595[(1)] = (1));

return statearr_68595;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68583){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68596){var ex__2749__auto__ = e68596;
var statearr_68597_68608 = state_68583;
(statearr_68597_68608[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68583[(4)]))){
var statearr_68598_68609 = state_68583;
(statearr_68598_68609[(1)] = cljs.core.first.call(null,(state_68583[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68610 = state_68583;
state_68583 = G__68610;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68583){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68599 = f__2769__auto__.call(null);
(statearr_68599[(6)] = c__2768__auto__);

return statearr_68599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq68551){
var G__68552 = cljs.core.first.call(null,seq68551);
var seq68551__$1 = cljs.core.next.call(null,seq68551);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68552,seq68551__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68660 = arguments.length;
var i__5770__auto___68661 = (0);
while(true){
if((i__5770__auto___68661 < len__5769__auto___68660)){
args__5775__auto__.push((arguments[i__5770__auto___68661]));

var G__68662 = (i__5770__auto___68661 + (1));
i__5770__auto___68661 = G__68662;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68643){
var state_val_68644 = (state_68643[(1)]);
if((state_val_68644 === (1))){
var state_68643__$1 = state_68643;
var statearr_68645_68663 = state_68643__$1;
(statearr_68645_68663[(2)] = null);

(statearr_68645_68663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68644 === (2))){
var _ = (function (){var statearr_68646 = state_68643;
(statearr_68646[(4)] = cljs.core.cons.call(null,(5),(state_68643[(4)])));

return statearr_68646;
})();
var inst_68619 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68643__$1 = state_68643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68643__$1,(6),inst_68619);
} else {
if((state_val_68644 === (3))){
var inst_68641 = (state_68643[(2)]);
var state_68643__$1 = state_68643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68643__$1,inst_68641);
} else {
if((state_val_68644 === (4))){
var inst_68613 = (state_68643[(2)]);
var state_68643__$1 = state_68643;
var statearr_68648_68664 = state_68643__$1;
(statearr_68648_68664[(2)] = inst_68613);

(statearr_68648_68664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68644 === (5))){
var _ = (function (){var statearr_68649 = state_68643;
(statearr_68649[(4)] = cljs.core.rest.call(null,(state_68643[(4)])));

return statearr_68649;
})();
var state_68643__$1 = state_68643;
var ex68647 = (state_68643__$1[(2)]);
var statearr_68650_68665 = state_68643__$1;
(statearr_68650_68665[(5)] = ex68647);


if((ex68647 instanceof Error)){
var statearr_68651_68666 = state_68643__$1;
(statearr_68651_68666[(1)] = (4));

(statearr_68651_68666[(5)] = null);

} else {
throw ex68647;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68644 === (6))){
var inst_68621 = (state_68643[(2)]);
var inst_68622 = fluree.db.util.async.throw_err.call(null,inst_68621);
var inst_68623 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_68622);
var inst_68624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68625 = [inst_68622];
var inst_68626 = (new cljs.core.PersistentVector(null,1,(5),inst_68624,inst_68625,null));
var inst_68627 = cljs.core.count.call(null,inst_68626);
var inst_68628 = ((9) + inst_68627);
var inst_68629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68630 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68632 = [inst_68622];
var inst_68633 = (new cljs.core.PersistentVector(null,1,(5),inst_68631,inst_68632,null));
var inst_68634 = [">",inst_68633,inst_68623];
var inst_68635 = cljs.core.PersistentHashMap.fromArrays(inst_68630,inst_68634);
var inst_68636 = [inst_68635,inst_68628];
var inst_68637 = (new cljs.core.PersistentVector(null,2,(5),inst_68629,inst_68636,null));
var inst_68638 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68637);
var _ = (function (){var statearr_68652 = state_68643;
(statearr_68652[(4)] = cljs.core.rest.call(null,(state_68643[(4)])));

return statearr_68652;
})();
var state_68643__$1 = (function (){var statearr_68653 = state_68643;
(statearr_68653[(7)] = inst_68638);

return statearr_68653;
})();
var statearr_68654_68667 = state_68643__$1;
(statearr_68654_68667[(2)] = inst_68623);

(statearr_68654_68667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68655 = [null,null,null,null,null,null,null,null];
(statearr_68655[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68655[(1)] = (1));

return statearr_68655;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68643){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68656){var ex__2749__auto__ = e68656;
var statearr_68657_68668 = state_68643;
(statearr_68657_68668[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68643[(4)]))){
var statearr_68658_68669 = state_68643;
(statearr_68658_68669[(1)] = cljs.core.first.call(null,(state_68643[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68670 = state_68643;
state_68643 = G__68670;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68643){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68659 = f__2769__auto__.call(null);
(statearr_68659[(6)] = c__2768__auto__);

return statearr_68659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq68611){
var G__68612 = cljs.core.first.call(null,seq68611);
var seq68611__$1 = cljs.core.next.call(null,seq68611);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68612,seq68611__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68720 = arguments.length;
var i__5770__auto___68721 = (0);
while(true){
if((i__5770__auto___68721 < len__5769__auto___68720)){
args__5775__auto__.push((arguments[i__5770__auto___68721]));

var G__68722 = (i__5770__auto___68721 + (1));
i__5770__auto___68721 = G__68722;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68703){
var state_val_68704 = (state_68703[(1)]);
if((state_val_68704 === (1))){
var state_68703__$1 = state_68703;
var statearr_68705_68723 = state_68703__$1;
(statearr_68705_68723[(2)] = null);

(statearr_68705_68723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68704 === (2))){
var _ = (function (){var statearr_68706 = state_68703;
(statearr_68706[(4)] = cljs.core.cons.call(null,(5),(state_68703[(4)])));

return statearr_68706;
})();
var inst_68679 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68703__$1 = state_68703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68703__$1,(6),inst_68679);
} else {
if((state_val_68704 === (3))){
var inst_68701 = (state_68703[(2)]);
var state_68703__$1 = state_68703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68703__$1,inst_68701);
} else {
if((state_val_68704 === (4))){
var inst_68673 = (state_68703[(2)]);
var state_68703__$1 = state_68703;
var statearr_68708_68724 = state_68703__$1;
(statearr_68708_68724[(2)] = inst_68673);

(statearr_68708_68724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68704 === (5))){
var _ = (function (){var statearr_68709 = state_68703;
(statearr_68709[(4)] = cljs.core.rest.call(null,(state_68703[(4)])));

return statearr_68709;
})();
var state_68703__$1 = state_68703;
var ex68707 = (state_68703__$1[(2)]);
var statearr_68710_68725 = state_68703__$1;
(statearr_68710_68725[(5)] = ex68707);


if((ex68707 instanceof Error)){
var statearr_68711_68726 = state_68703__$1;
(statearr_68711_68726[(1)] = (4));

(statearr_68711_68726[(5)] = null);

} else {
throw ex68707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68704 === (6))){
var inst_68681 = (state_68703[(2)]);
var inst_68682 = fluree.db.util.async.throw_err.call(null,inst_68681);
var inst_68683 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_68682);
var inst_68684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68685 = [inst_68682];
var inst_68686 = (new cljs.core.PersistentVector(null,1,(5),inst_68684,inst_68685,null));
var inst_68687 = cljs.core.count.call(null,inst_68686);
var inst_68688 = ((9) + inst_68687);
var inst_68689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68690 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68692 = [inst_68682];
var inst_68693 = (new cljs.core.PersistentVector(null,1,(5),inst_68691,inst_68692,null));
var inst_68694 = ["<",inst_68693,inst_68683];
var inst_68695 = cljs.core.PersistentHashMap.fromArrays(inst_68690,inst_68694);
var inst_68696 = [inst_68695,inst_68688];
var inst_68697 = (new cljs.core.PersistentVector(null,2,(5),inst_68689,inst_68696,null));
var inst_68698 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68697);
var _ = (function (){var statearr_68712 = state_68703;
(statearr_68712[(4)] = cljs.core.rest.call(null,(state_68703[(4)])));

return statearr_68712;
})();
var state_68703__$1 = (function (){var statearr_68713 = state_68703;
(statearr_68713[(7)] = inst_68698);

return statearr_68713;
})();
var statearr_68714_68727 = state_68703__$1;
(statearr_68714_68727[(2)] = inst_68683);

(statearr_68714_68727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68715 = [null,null,null,null,null,null,null,null];
(statearr_68715[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68715[(1)] = (1));

return statearr_68715;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68703){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68716){var ex__2749__auto__ = e68716;
var statearr_68717_68728 = state_68703;
(statearr_68717_68728[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68703[(4)]))){
var statearr_68718_68729 = state_68703;
(statearr_68718_68729[(1)] = cljs.core.first.call(null,(state_68703[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68730 = state_68703;
state_68703 = G__68730;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68703){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68719 = f__2769__auto__.call(null);
(statearr_68719[(6)] = c__2768__auto__);

return statearr_68719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq68671){
var G__68672 = cljs.core.first.call(null,seq68671);
var seq68671__$1 = cljs.core.next.call(null,seq68671);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68672,seq68671__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68780 = arguments.length;
var i__5770__auto___68781 = (0);
while(true){
if((i__5770__auto___68781 < len__5769__auto___68780)){
args__5775__auto__.push((arguments[i__5770__auto___68781]));

var G__68782 = (i__5770__auto___68781 + (1));
i__5770__auto___68781 = G__68782;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68763){
var state_val_68764 = (state_68763[(1)]);
if((state_val_68764 === (1))){
var state_68763__$1 = state_68763;
var statearr_68765_68783 = state_68763__$1;
(statearr_68765_68783[(2)] = null);

(statearr_68765_68783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68764 === (2))){
var _ = (function (){var statearr_68766 = state_68763;
(statearr_68766[(4)] = cljs.core.cons.call(null,(5),(state_68763[(4)])));

return statearr_68766;
})();
var inst_68739 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68763__$1 = state_68763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68763__$1,(6),inst_68739);
} else {
if((state_val_68764 === (3))){
var inst_68761 = (state_68763[(2)]);
var state_68763__$1 = state_68763;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68763__$1,inst_68761);
} else {
if((state_val_68764 === (4))){
var inst_68733 = (state_68763[(2)]);
var state_68763__$1 = state_68763;
var statearr_68768_68784 = state_68763__$1;
(statearr_68768_68784[(2)] = inst_68733);

(statearr_68768_68784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68764 === (5))){
var _ = (function (){var statearr_68769 = state_68763;
(statearr_68769[(4)] = cljs.core.rest.call(null,(state_68763[(4)])));

return statearr_68769;
})();
var state_68763__$1 = state_68763;
var ex68767 = (state_68763__$1[(2)]);
var statearr_68770_68785 = state_68763__$1;
(statearr_68770_68785[(5)] = ex68767);


if((ex68767 instanceof Error)){
var statearr_68771_68786 = state_68763__$1;
(statearr_68771_68786[(1)] = (4));

(statearr_68771_68786[(5)] = null);

} else {
throw ex68767;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68764 === (6))){
var inst_68741 = (state_68763[(2)]);
var inst_68742 = fluree.db.util.async.throw_err.call(null,inst_68741);
var inst_68743 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_68742);
var inst_68744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68745 = [inst_68742];
var inst_68746 = (new cljs.core.PersistentVector(null,1,(5),inst_68744,inst_68745,null));
var inst_68747 = cljs.core.count.call(null,inst_68746);
var inst_68748 = ((9) + inst_68747);
var inst_68749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68750 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68752 = [inst_68742];
var inst_68753 = (new cljs.core.PersistentVector(null,1,(5),inst_68751,inst_68752,null));
var inst_68754 = ["<=",inst_68753,inst_68743];
var inst_68755 = cljs.core.PersistentHashMap.fromArrays(inst_68750,inst_68754);
var inst_68756 = [inst_68755,inst_68748];
var inst_68757 = (new cljs.core.PersistentVector(null,2,(5),inst_68749,inst_68756,null));
var inst_68758 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68757);
var _ = (function (){var statearr_68772 = state_68763;
(statearr_68772[(4)] = cljs.core.rest.call(null,(state_68763[(4)])));

return statearr_68772;
})();
var state_68763__$1 = (function (){var statearr_68773 = state_68763;
(statearr_68773[(7)] = inst_68758);

return statearr_68773;
})();
var statearr_68774_68787 = state_68763__$1;
(statearr_68774_68787[(2)] = inst_68743);

(statearr_68774_68787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68775 = [null,null,null,null,null,null,null,null];
(statearr_68775[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68775[(1)] = (1));

return statearr_68775;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68763){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68763);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68776){var ex__2749__auto__ = e68776;
var statearr_68777_68788 = state_68763;
(statearr_68777_68788[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68763[(4)]))){
var statearr_68778_68789 = state_68763;
(statearr_68778_68789[(1)] = cljs.core.first.call(null,(state_68763[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68790 = state_68763;
state_68763 = G__68790;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68763){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68779 = f__2769__auto__.call(null);
(statearr_68779[(6)] = c__2768__auto__);

return statearr_68779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq68731){
var G__68732 = cljs.core.first.call(null,seq68731);
var seq68731__$1 = cljs.core.next.call(null,seq68731);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68732,seq68731__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68840 = arguments.length;
var i__5770__auto___68841 = (0);
while(true){
if((i__5770__auto___68841 < len__5769__auto___68840)){
args__5775__auto__.push((arguments[i__5770__auto___68841]));

var G__68842 = (i__5770__auto___68841 + (1));
i__5770__auto___68841 = G__68842;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68823){
var state_val_68824 = (state_68823[(1)]);
if((state_val_68824 === (1))){
var state_68823__$1 = state_68823;
var statearr_68825_68843 = state_68823__$1;
(statearr_68825_68843[(2)] = null);

(statearr_68825_68843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68824 === (2))){
var _ = (function (){var statearr_68826 = state_68823;
(statearr_68826[(4)] = cljs.core.cons.call(null,(5),(state_68823[(4)])));

return statearr_68826;
})();
var inst_68799 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68823__$1 = state_68823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68823__$1,(6),inst_68799);
} else {
if((state_val_68824 === (3))){
var inst_68821 = (state_68823[(2)]);
var state_68823__$1 = state_68823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68823__$1,inst_68821);
} else {
if((state_val_68824 === (4))){
var inst_68793 = (state_68823[(2)]);
var state_68823__$1 = state_68823;
var statearr_68828_68844 = state_68823__$1;
(statearr_68828_68844[(2)] = inst_68793);

(statearr_68828_68844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68824 === (5))){
var _ = (function (){var statearr_68829 = state_68823;
(statearr_68829[(4)] = cljs.core.rest.call(null,(state_68823[(4)])));

return statearr_68829;
})();
var state_68823__$1 = state_68823;
var ex68827 = (state_68823__$1[(2)]);
var statearr_68830_68845 = state_68823__$1;
(statearr_68830_68845[(5)] = ex68827);


if((ex68827 instanceof Error)){
var statearr_68831_68846 = state_68823__$1;
(statearr_68831_68846[(1)] = (4));

(statearr_68831_68846[(5)] = null);

} else {
throw ex68827;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68824 === (6))){
var inst_68801 = (state_68823[(2)]);
var inst_68802 = fluree.db.util.async.throw_err.call(null,inst_68801);
var inst_68803 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_68802);
var inst_68804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68805 = [inst_68802];
var inst_68806 = (new cljs.core.PersistentVector(null,1,(5),inst_68804,inst_68805,null));
var inst_68807 = cljs.core.count.call(null,inst_68806);
var inst_68808 = ((9) + inst_68807);
var inst_68809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68810 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68812 = [inst_68802];
var inst_68813 = (new cljs.core.PersistentVector(null,1,(5),inst_68811,inst_68812,null));
var inst_68814 = [">=",inst_68813,inst_68803];
var inst_68815 = cljs.core.PersistentHashMap.fromArrays(inst_68810,inst_68814);
var inst_68816 = [inst_68815,inst_68808];
var inst_68817 = (new cljs.core.PersistentVector(null,2,(5),inst_68809,inst_68816,null));
var inst_68818 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68817);
var _ = (function (){var statearr_68832 = state_68823;
(statearr_68832[(4)] = cljs.core.rest.call(null,(state_68823[(4)])));

return statearr_68832;
})();
var state_68823__$1 = (function (){var statearr_68833 = state_68823;
(statearr_68833[(7)] = inst_68818);

return statearr_68833;
})();
var statearr_68834_68847 = state_68823__$1;
(statearr_68834_68847[(2)] = inst_68803);

(statearr_68834_68847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68835 = [null,null,null,null,null,null,null,null];
(statearr_68835[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68835[(1)] = (1));

return statearr_68835;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68823){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68836){var ex__2749__auto__ = e68836;
var statearr_68837_68848 = state_68823;
(statearr_68837_68848[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68823[(4)]))){
var statearr_68838_68849 = state_68823;
(statearr_68838_68849[(1)] = cljs.core.first.call(null,(state_68823[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68850 = state_68823;
state_68823 = G__68850;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68823){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68839 = f__2769__auto__.call(null);
(statearr_68839[(6)] = c__2768__auto__);

return statearr_68839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq68791){
var G__68792 = cljs.core.first.call(null,seq68791);
var seq68791__$1 = cljs.core.next.call(null,seq68791);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68792,seq68791__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68900 = arguments.length;
var i__5770__auto___68901 = (0);
while(true){
if((i__5770__auto___68901 < len__5769__auto___68900)){
args__5775__auto__.push((arguments[i__5770__auto___68901]));

var G__68902 = (i__5770__auto___68901 + (1));
i__5770__auto___68901 = G__68902;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68883){
var state_val_68884 = (state_68883[(1)]);
if((state_val_68884 === (1))){
var state_68883__$1 = state_68883;
var statearr_68885_68903 = state_68883__$1;
(statearr_68885_68903[(2)] = null);

(statearr_68885_68903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68884 === (2))){
var _ = (function (){var statearr_68886 = state_68883;
(statearr_68886[(4)] = cljs.core.cons.call(null,(5),(state_68883[(4)])));

return statearr_68886;
})();
var inst_68859 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68883__$1 = state_68883;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68883__$1,(6),inst_68859);
} else {
if((state_val_68884 === (3))){
var inst_68881 = (state_68883[(2)]);
var state_68883__$1 = state_68883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68883__$1,inst_68881);
} else {
if((state_val_68884 === (4))){
var inst_68853 = (state_68883[(2)]);
var state_68883__$1 = state_68883;
var statearr_68888_68904 = state_68883__$1;
(statearr_68888_68904[(2)] = inst_68853);

(statearr_68888_68904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68884 === (5))){
var _ = (function (){var statearr_68889 = state_68883;
(statearr_68889[(4)] = cljs.core.rest.call(null,(state_68883[(4)])));

return statearr_68889;
})();
var state_68883__$1 = state_68883;
var ex68887 = (state_68883__$1[(2)]);
var statearr_68890_68905 = state_68883__$1;
(statearr_68890_68905[(5)] = ex68887);


if((ex68887 instanceof Error)){
var statearr_68891_68906 = state_68883__$1;
(statearr_68891_68906[(1)] = (4));

(statearr_68891_68906[(5)] = null);

} else {
throw ex68887;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68884 === (6))){
var inst_68861 = (state_68883[(2)]);
var inst_68862 = fluree.db.util.async.throw_err.call(null,inst_68861);
var inst_68863 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_68862);
var inst_68864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68865 = [inst_68862];
var inst_68866 = (new cljs.core.PersistentVector(null,1,(5),inst_68864,inst_68865,null));
var inst_68867 = cljs.core.count.call(null,inst_68866);
var inst_68868 = ((9) + inst_68867);
var inst_68869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68870 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68872 = [inst_68862];
var inst_68873 = (new cljs.core.PersistentVector(null,1,(5),inst_68871,inst_68872,null));
var inst_68874 = ["not=",inst_68873,inst_68863];
var inst_68875 = cljs.core.PersistentHashMap.fromArrays(inst_68870,inst_68874);
var inst_68876 = [inst_68875,inst_68868];
var inst_68877 = (new cljs.core.PersistentVector(null,2,(5),inst_68869,inst_68876,null));
var inst_68878 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68877);
var _ = (function (){var statearr_68892 = state_68883;
(statearr_68892[(4)] = cljs.core.rest.call(null,(state_68883[(4)])));

return statearr_68892;
})();
var state_68883__$1 = (function (){var statearr_68893 = state_68883;
(statearr_68893[(7)] = inst_68878);

return statearr_68893;
})();
var statearr_68894_68907 = state_68883__$1;
(statearr_68894_68907[(2)] = inst_68863);

(statearr_68894_68907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68895 = [null,null,null,null,null,null,null,null];
(statearr_68895[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68895[(1)] = (1));

return statearr_68895;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68883){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68896){var ex__2749__auto__ = e68896;
var statearr_68897_68908 = state_68883;
(statearr_68897_68908[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68883[(4)]))){
var statearr_68898_68909 = state_68883;
(statearr_68898_68909[(1)] = cljs.core.first.call(null,(state_68883[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68910 = state_68883;
state_68883 = G__68910;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68883){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68899 = f__2769__auto__.call(null);
(statearr_68899[(6)] = c__2768__auto__);

return statearr_68899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq68851){
var G__68852 = cljs.core.first.call(null,seq68851);
var seq68851__$1 = cljs.core.next.call(null,seq68851);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68852,seq68851__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68960 = arguments.length;
var i__5770__auto___68961 = (0);
while(true){
if((i__5770__auto___68961 < len__5769__auto___68960)){
args__5775__auto__.push((arguments[i__5770__auto___68961]));

var G__68962 = (i__5770__auto___68961 + (1));
i__5770__auto___68961 = G__68962;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68943){
var state_val_68944 = (state_68943[(1)]);
if((state_val_68944 === (1))){
var state_68943__$1 = state_68943;
var statearr_68945_68963 = state_68943__$1;
(statearr_68945_68963[(2)] = null);

(statearr_68945_68963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (2))){
var _ = (function (){var statearr_68946 = state_68943;
(statearr_68946[(4)] = cljs.core.cons.call(null,(5),(state_68943[(4)])));

return statearr_68946;
})();
var inst_68919 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_68943__$1 = state_68943;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68943__$1,(6),inst_68919);
} else {
if((state_val_68944 === (3))){
var inst_68941 = (state_68943[(2)]);
var state_68943__$1 = state_68943;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68943__$1,inst_68941);
} else {
if((state_val_68944 === (4))){
var inst_68913 = (state_68943[(2)]);
var state_68943__$1 = state_68943;
var statearr_68948_68964 = state_68943__$1;
(statearr_68948_68964[(2)] = inst_68913);

(statearr_68948_68964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (5))){
var _ = (function (){var statearr_68949 = state_68943;
(statearr_68949[(4)] = cljs.core.rest.call(null,(state_68943[(4)])));

return statearr_68949;
})();
var state_68943__$1 = state_68943;
var ex68947 = (state_68943__$1[(2)]);
var statearr_68950_68965 = state_68943__$1;
(statearr_68950_68965[(5)] = ex68947);


if((ex68947 instanceof Error)){
var statearr_68951_68966 = state_68943__$1;
(statearr_68951_68966[(1)] = (4));

(statearr_68951_68966[(5)] = null);

} else {
throw ex68947;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68944 === (6))){
var inst_68921 = (state_68943[(2)]);
var inst_68922 = fluree.db.util.async.throw_err.call(null,inst_68921);
var inst_68923 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_68922);
var inst_68924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68925 = [inst_68922];
var inst_68926 = (new cljs.core.PersistentVector(null,1,(5),inst_68924,inst_68925,null));
var inst_68927 = cljs.core.count.call(null,inst_68926);
var inst_68928 = ((9) + inst_68927);
var inst_68929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68930 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68932 = [inst_68922];
var inst_68933 = (new cljs.core.PersistentVector(null,1,(5),inst_68931,inst_68932,null));
var inst_68934 = ["max",inst_68933,inst_68923];
var inst_68935 = cljs.core.PersistentHashMap.fromArrays(inst_68930,inst_68934);
var inst_68936 = [inst_68935,inst_68928];
var inst_68937 = (new cljs.core.PersistentVector(null,2,(5),inst_68929,inst_68936,null));
var inst_68938 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68937);
var _ = (function (){var statearr_68952 = state_68943;
(statearr_68952[(4)] = cljs.core.rest.call(null,(state_68943[(4)])));

return statearr_68952;
})();
var state_68943__$1 = (function (){var statearr_68953 = state_68943;
(statearr_68953[(7)] = inst_68938);

return statearr_68953;
})();
var statearr_68954_68967 = state_68943__$1;
(statearr_68954_68967[(2)] = inst_68923);

(statearr_68954_68967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_68955 = [null,null,null,null,null,null,null,null];
(statearr_68955[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_68955[(1)] = (1));

return statearr_68955;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_68943){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68943);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68956){var ex__2749__auto__ = e68956;
var statearr_68957_68968 = state_68943;
(statearr_68957_68968[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68943[(4)]))){
var statearr_68958_68969 = state_68943;
(statearr_68958_68969[(1)] = cljs.core.first.call(null,(state_68943[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68970 = state_68943;
state_68943 = G__68970;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_68943){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_68943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68959 = f__2769__auto__.call(null);
(statearr_68959[(6)] = c__2768__auto__);

return statearr_68959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq68911){
var G__68912 = cljs.core.first.call(null,seq68911);
var seq68911__$1 = cljs.core.next.call(null,seq68911);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68912,seq68911__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69020 = arguments.length;
var i__5770__auto___69021 = (0);
while(true){
if((i__5770__auto___69021 < len__5769__auto___69020)){
args__5775__auto__.push((arguments[i__5770__auto___69021]));

var G__69022 = (i__5770__auto___69021 + (1));
i__5770__auto___69021 = G__69022;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69003){
var state_val_69004 = (state_69003[(1)]);
if((state_val_69004 === (1))){
var state_69003__$1 = state_69003;
var statearr_69005_69023 = state_69003__$1;
(statearr_69005_69023[(2)] = null);

(statearr_69005_69023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69004 === (2))){
var _ = (function (){var statearr_69006 = state_69003;
(statearr_69006[(4)] = cljs.core.cons.call(null,(5),(state_69003[(4)])));

return statearr_69006;
})();
var inst_68979 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_69003__$1 = state_69003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69003__$1,(6),inst_68979);
} else {
if((state_val_69004 === (3))){
var inst_69001 = (state_69003[(2)]);
var state_69003__$1 = state_69003;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69003__$1,inst_69001);
} else {
if((state_val_69004 === (4))){
var inst_68973 = (state_69003[(2)]);
var state_69003__$1 = state_69003;
var statearr_69008_69024 = state_69003__$1;
(statearr_69008_69024[(2)] = inst_68973);

(statearr_69008_69024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69004 === (5))){
var _ = (function (){var statearr_69009 = state_69003;
(statearr_69009[(4)] = cljs.core.rest.call(null,(state_69003[(4)])));

return statearr_69009;
})();
var state_69003__$1 = state_69003;
var ex69007 = (state_69003__$1[(2)]);
var statearr_69010_69025 = state_69003__$1;
(statearr_69010_69025[(5)] = ex69007);


if((ex69007 instanceof Error)){
var statearr_69011_69026 = state_69003__$1;
(statearr_69011_69026[(1)] = (4));

(statearr_69011_69026[(5)] = null);

} else {
throw ex69007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69004 === (6))){
var inst_68981 = (state_69003[(2)]);
var inst_68982 = fluree.db.util.async.throw_err.call(null,inst_68981);
var inst_68983 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_68982);
var inst_68984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68985 = [inst_68982];
var inst_68986 = (new cljs.core.PersistentVector(null,1,(5),inst_68984,inst_68985,null));
var inst_68987 = cljs.core.count.call(null,inst_68986);
var inst_68988 = ((9) + inst_68987);
var inst_68989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68990 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68992 = [inst_68982];
var inst_68993 = (new cljs.core.PersistentVector(null,1,(5),inst_68991,inst_68992,null));
var inst_68994 = ["min",inst_68993,inst_68983];
var inst_68995 = cljs.core.PersistentHashMap.fromArrays(inst_68990,inst_68994);
var inst_68996 = [inst_68995,inst_68988];
var inst_68997 = (new cljs.core.PersistentVector(null,2,(5),inst_68989,inst_68996,null));
var inst_68998 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68997);
var _ = (function (){var statearr_69012 = state_69003;
(statearr_69012[(4)] = cljs.core.rest.call(null,(state_69003[(4)])));

return statearr_69012;
})();
var state_69003__$1 = (function (){var statearr_69013 = state_69003;
(statearr_69013[(7)] = inst_68998);

return statearr_69013;
})();
var statearr_69014_69027 = state_69003__$1;
(statearr_69014_69027[(2)] = inst_68983);

(statearr_69014_69027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_69015 = [null,null,null,null,null,null,null,null];
(statearr_69015[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_69015[(1)] = (1));

return statearr_69015;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_69003){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69003);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69016){var ex__2749__auto__ = e69016;
var statearr_69017_69028 = state_69003;
(statearr_69017_69028[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69003[(4)]))){
var statearr_69018_69029 = state_69003;
(statearr_69018_69029[(1)] = cljs.core.first.call(null,(state_69003[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69030 = state_69003;
state_69003 = G__69030;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_69003){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_69003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69019 = f__2769__auto__.call(null);
(statearr_69019[(6)] = c__2768__auto__);

return statearr_69019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq68971){
var G__68972 = cljs.core.first.call(null,seq68971);
var seq68971__$1 = cljs.core.next.call(null,seq68971);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68972,seq68971__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__69032 = arguments.length;
switch (G__69032) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69077){
var state_val_69078 = (state_69077[(1)]);
if((state_val_69078 === (7))){
var state_69077__$1 = state_69077;
var statearr_69079_69216 = state_69077__$1;
(statearr_69079_69216[(2)] = query_map);

(statearr_69079_69216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (1))){
var state_69077__$1 = state_69077;
var statearr_69080_69217 = state_69077__$1;
(statearr_69080_69217[(2)] = null);

(statearr_69080_69217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (4))){
var inst_69033 = (state_69077[(2)]);
var state_69077__$1 = state_69077;
var statearr_69081_69218 = state_69077__$1;
(statearr_69081_69218[(2)] = inst_69033);

(statearr_69081_69218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (13))){
var inst_69055 = (state_69077[(7)]);
var inst_69059 = (state_69077[(2)]);
var inst_69060 = fluree.db.util.async.throw_err.call(null,inst_69059);
var inst_69061 = cljs.core.nth.call(null,inst_69060,(0),null);
var inst_69062 = cljs.core.nth.call(null,inst_69060,(1),null);
var inst_69063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69064 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69066 = [inst_69055];
var inst_69067 = (new cljs.core.PersistentVector(null,1,(5),inst_69065,inst_69066,null));
var inst_69068 = ["query",inst_69067,inst_69061];
var inst_69069 = cljs.core.PersistentHashMap.fromArrays(inst_69064,inst_69068);
var inst_69070 = [inst_69069,inst_69062];
var inst_69071 = (new cljs.core.PersistentVector(null,2,(5),inst_69063,inst_69070,null));
var inst_69072 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69071);
var _ = (function (){var statearr_69082 = state_69077;
(statearr_69082[(4)] = cljs.core.rest.call(null,(state_69077[(4)])));

return statearr_69082;
})();
var state_69077__$1 = (function (){var statearr_69083 = state_69077;
(statearr_69083[(8)] = inst_69072);

return statearr_69083;
})();
var statearr_69084_69219 = state_69077__$1;
(statearr_69084_69219[(2)] = inst_69061);

(statearr_69084_69219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (6))){
var state_69077__$1 = state_69077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69077__$1,(9),query_map);
} else {
if((state_val_69078 === (3))){
var inst_69075 = (state_69077[(2)]);
var state_69077__$1 = state_69077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69077__$1,inst_69075);
} else {
if((state_val_69078 === (12))){
var inst_69055 = (state_69077[(7)]);
var inst_69055__$1 = (state_69077[(2)]);
var inst_69056 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_69057 = fluree.db.dbfunctions.internal.query.call(null,inst_69056,inst_69055__$1);
var state_69077__$1 = (function (){var statearr_69085 = state_69077;
(statearr_69085[(7)] = inst_69055__$1);

return statearr_69085;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69077__$1,(13),inst_69057);
} else {
if((state_val_69078 === (2))){
var _ = (function (){var statearr_69086 = state_69077;
(statearr_69086[(4)] = cljs.core.cons.call(null,(5),(state_69077[(4)])));

return statearr_69086;
})();
var inst_69042 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_69077__$1 = state_69077;
if(inst_69042){
var statearr_69087_69220 = state_69077__$1;
(statearr_69087_69220[(1)] = (6));

} else {
var statearr_69088_69221 = state_69077__$1;
(statearr_69088_69221[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (11))){
var inst_69049 = (state_69077[(9)]);
var state_69077__$1 = state_69077;
var statearr_69090_69222 = state_69077__$1;
(statearr_69090_69222[(2)] = inst_69049);

(statearr_69090_69222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (9))){
var inst_69045 = (state_69077[(2)]);
var inst_69046 = fluree.db.util.async.throw_err.call(null,inst_69045);
var state_69077__$1 = state_69077;
var statearr_69091_69223 = state_69077__$1;
(statearr_69091_69223[(2)] = inst_69046);

(statearr_69091_69223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (5))){
var _ = (function (){var statearr_69092 = state_69077;
(statearr_69092[(4)] = cljs.core.rest.call(null,(state_69077[(4)])));

return statearr_69092;
})();
var state_69077__$1 = state_69077;
var ex69089 = (state_69077__$1[(2)]);
var statearr_69093_69224 = state_69077__$1;
(statearr_69093_69224[(5)] = ex69089);


if((ex69089 instanceof Error)){
var statearr_69094_69225 = state_69077__$1;
(statearr_69094_69225[(1)] = (4));

(statearr_69094_69225[(5)] = null);

} else {
throw ex69089;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (10))){
var inst_69049 = (state_69077[(9)]);
var inst_69052 = fluree.db.util.json.parse.call(null,inst_69049);
var state_69077__$1 = state_69077;
var statearr_69095_69226 = state_69077__$1;
(statearr_69095_69226[(2)] = inst_69052);

(statearr_69095_69226[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69078 === (8))){
var inst_69049 = (state_69077[(9)]);
var inst_69049__$1 = (state_69077[(2)]);
var inst_69050 = typeof inst_69049__$1 === 'string';
var state_69077__$1 = (function (){var statearr_69096 = state_69077;
(statearr_69096[(9)] = inst_69049__$1);

return statearr_69096;
})();
if(cljs.core.truth_(inst_69050)){
var statearr_69097_69227 = state_69077__$1;
(statearr_69097_69227[(1)] = (10));

} else {
var statearr_69098_69228 = state_69077__$1;
(statearr_69098_69228[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_69099 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69099[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_69099[(1)] = (1));

return statearr_69099;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_69077){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69100){var ex__2749__auto__ = e69100;
var statearr_69101_69229 = state_69077;
(statearr_69101_69229[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69077[(4)]))){
var statearr_69102_69230 = state_69077;
(statearr_69102_69230[(1)] = cljs.core.first.call(null,(state_69077[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69231 = state_69077;
state_69077 = G__69231;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_69077){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_69077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69103 = f__2769__auto__.call(null);
(statearr_69103[(6)] = c__2768__auto__);

return statearr_69103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69174){
var state_val_69175 = (state_69174[(1)]);
if((state_val_69175 === (7))){
var state_69174__$1 = state_69174;
var statearr_69176_69232 = state_69174__$1;
(statearr_69176_69232[(2)] = select);

(statearr_69176_69232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (20))){
var inst_69144 = (state_69174[(2)]);
var inst_69145 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_69174__$1 = (function (){var statearr_69177 = state_69174;
(statearr_69177[(7)] = inst_69144);

return statearr_69177;
})();
if(inst_69145){
var statearr_69178_69233 = state_69174__$1;
(statearr_69178_69233[(1)] = (22));

} else {
var statearr_69179_69234 = state_69174__$1;
(statearr_69179_69234[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (1))){
var state_69174__$1 = state_69174;
var statearr_69180_69235 = state_69174__$1;
(statearr_69180_69235[(2)] = null);

(statearr_69180_69235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (24))){
var inst_69144 = (state_69174[(7)]);
var inst_69120 = (state_69174[(8)]);
var inst_69128 = (state_69174[(9)]);
var inst_69136 = (state_69174[(10)]);
var inst_69152 = (state_69174[(2)]);
var inst_69153 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_69154 = fluree.db.dbfunctions.internal.query.call(null,inst_69153,inst_69120,inst_69128,inst_69136,inst_69144,inst_69152);
var state_69174__$1 = state_69174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69174__$1,(26),inst_69154);
} else {
if((state_val_69175 === (4))){
var inst_69104 = (state_69174[(2)]);
var state_69174__$1 = state_69174;
var statearr_69181_69236 = state_69174__$1;
(statearr_69181_69236[(2)] = inst_69104);

(statearr_69181_69236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (15))){
var state_69174__$1 = state_69174;
var statearr_69182_69237 = state_69174__$1;
(statearr_69182_69237[(2)] = where);

(statearr_69182_69237[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (21))){
var inst_69140 = (state_69174[(2)]);
var inst_69141 = fluree.db.util.async.throw_err.call(null,inst_69140);
var state_69174__$1 = state_69174;
var statearr_69183_69238 = state_69174__$1;
(statearr_69183_69238[(2)] = inst_69141);

(statearr_69183_69238[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (13))){
var inst_69124 = (state_69174[(2)]);
var inst_69125 = fluree.db.util.async.throw_err.call(null,inst_69124);
var state_69174__$1 = state_69174;
var statearr_69184_69239 = state_69174__$1;
(statearr_69184_69239[(2)] = inst_69125);

(statearr_69184_69239[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (22))){
var state_69174__$1 = state_69174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69174__$1,(25),limit);
} else {
if((state_val_69175 === (6))){
var state_69174__$1 = state_69174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69174__$1,(9),select);
} else {
if((state_val_69175 === (25))){
var inst_69148 = (state_69174[(2)]);
var inst_69149 = fluree.db.util.async.throw_err.call(null,inst_69148);
var state_69174__$1 = state_69174;
var statearr_69185_69240 = state_69174__$1;
(statearr_69185_69240[(2)] = inst_69149);

(statearr_69185_69240[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (17))){
var inst_69132 = (state_69174[(2)]);
var inst_69133 = fluree.db.util.async.throw_err.call(null,inst_69132);
var state_69174__$1 = state_69174;
var statearr_69186_69241 = state_69174__$1;
(statearr_69186_69241[(2)] = inst_69133);

(statearr_69186_69241[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (3))){
var inst_69172 = (state_69174[(2)]);
var state_69174__$1 = state_69174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69174__$1,inst_69172);
} else {
if((state_val_69175 === (12))){
var inst_69128 = (state_69174[(2)]);
var inst_69129 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_69174__$1 = (function (){var statearr_69187 = state_69174;
(statearr_69187[(9)] = inst_69128);

return statearr_69187;
})();
if(inst_69129){
var statearr_69188_69242 = state_69174__$1;
(statearr_69188_69242[(1)] = (14));

} else {
var statearr_69189_69243 = state_69174__$1;
(statearr_69189_69243[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (2))){
var _ = (function (){var statearr_69190 = state_69174;
(statearr_69190[(4)] = cljs.core.cons.call(null,(5),(state_69174[(4)])));

return statearr_69190;
})();
var inst_69113 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_69174__$1 = state_69174;
if(inst_69113){
var statearr_69191_69244 = state_69174__$1;
(statearr_69191_69244[(1)] = (6));

} else {
var statearr_69192_69245 = state_69174__$1;
(statearr_69192_69245[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (23))){
var state_69174__$1 = state_69174;
var statearr_69193_69246 = state_69174__$1;
(statearr_69193_69246[(2)] = limit);

(statearr_69193_69246[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (19))){
var state_69174__$1 = state_69174;
var statearr_69194_69247 = state_69174__$1;
(statearr_69194_69247[(2)] = block);

(statearr_69194_69247[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (11))){
var state_69174__$1 = state_69174;
var statearr_69196_69248 = state_69174__$1;
(statearr_69196_69248[(2)] = from);

(statearr_69196_69248[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (9))){
var inst_69116 = (state_69174[(2)]);
var inst_69117 = fluree.db.util.async.throw_err.call(null,inst_69116);
var state_69174__$1 = state_69174;
var statearr_69197_69249 = state_69174__$1;
(statearr_69197_69249[(2)] = inst_69117);

(statearr_69197_69249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (5))){
var _ = (function (){var statearr_69198 = state_69174;
(statearr_69198[(4)] = cljs.core.rest.call(null,(state_69174[(4)])));

return statearr_69198;
})();
var state_69174__$1 = state_69174;
var ex69195 = (state_69174__$1[(2)]);
var statearr_69199_69250 = state_69174__$1;
(statearr_69199_69250[(5)] = ex69195);


if((ex69195 instanceof Error)){
var statearr_69200_69251 = state_69174__$1;
(statearr_69200_69251[(1)] = (4));

(statearr_69200_69251[(5)] = null);

} else {
throw ex69195;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (14))){
var state_69174__$1 = state_69174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69174__$1,(17),where);
} else {
if((state_val_69175 === (26))){
var inst_69144 = (state_69174[(7)]);
var inst_69120 = (state_69174[(8)]);
var inst_69128 = (state_69174[(9)]);
var inst_69136 = (state_69174[(10)]);
var inst_69156 = (state_69174[(2)]);
var inst_69157 = fluree.db.util.async.throw_err.call(null,inst_69156);
var inst_69158 = cljs.core.nth.call(null,inst_69157,(0),null);
var inst_69159 = cljs.core.nth.call(null,inst_69157,(1),null);
var inst_69160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69161 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69163 = [inst_69120,inst_69128,inst_69136,inst_69144];
var inst_69164 = (new cljs.core.PersistentVector(null,4,(5),inst_69162,inst_69163,null));
var inst_69165 = ["query",inst_69164,inst_69158];
var inst_69166 = cljs.core.PersistentHashMap.fromArrays(inst_69161,inst_69165);
var inst_69167 = [inst_69166,inst_69159];
var inst_69168 = (new cljs.core.PersistentVector(null,2,(5),inst_69160,inst_69167,null));
var inst_69169 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69168);
var _ = (function (){var statearr_69201 = state_69174;
(statearr_69201[(4)] = cljs.core.rest.call(null,(state_69174[(4)])));

return statearr_69201;
})();
var state_69174__$1 = (function (){var statearr_69202 = state_69174;
(statearr_69202[(11)] = inst_69169);

return statearr_69202;
})();
var statearr_69203_69252 = state_69174__$1;
(statearr_69203_69252[(2)] = inst_69158);

(statearr_69203_69252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (16))){
var inst_69136 = (state_69174[(2)]);
var inst_69137 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_69174__$1 = (function (){var statearr_69204 = state_69174;
(statearr_69204[(10)] = inst_69136);

return statearr_69204;
})();
if(inst_69137){
var statearr_69205_69253 = state_69174__$1;
(statearr_69205_69253[(1)] = (18));

} else {
var statearr_69206_69254 = state_69174__$1;
(statearr_69206_69254[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69175 === (10))){
var state_69174__$1 = state_69174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69174__$1,(13),from);
} else {
if((state_val_69175 === (18))){
var state_69174__$1 = state_69174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69174__$1,(21),block);
} else {
if((state_val_69175 === (8))){
var inst_69120 = (state_69174[(2)]);
var inst_69121 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_69174__$1 = (function (){var statearr_69207 = state_69174;
(statearr_69207[(8)] = inst_69120);

return statearr_69207;
})();
if(inst_69121){
var statearr_69208_69255 = state_69174__$1;
(statearr_69208_69255[(1)] = (10));

} else {
var statearr_69209_69256 = state_69174__$1;
(statearr_69209_69256[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_69210 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69210[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_69210[(1)] = (1));

return statearr_69210;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_69174){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69211){var ex__2749__auto__ = e69211;
var statearr_69212_69257 = state_69174;
(statearr_69212_69257[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69174[(4)]))){
var statearr_69213_69258 = state_69174;
(statearr_69213_69258[(1)] = cljs.core.first.call(null,(state_69174[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69259 = state_69174;
state_69174 = G__69259;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_69174){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_69174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69214 = f__2769__auto__.call(null);
(statearr_69214[(6)] = c__2768__auto__);

return statearr_69214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69315){
var state_val_69316 = (state_69315[(1)]);
if((state_val_69316 === (7))){
var state_69315__$1 = state_69315;
var statearr_69317_69348 = state_69315__$1;
(statearr_69317_69348[(2)] = startSubject);

(statearr_69317_69348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (1))){
var state_69315__$1 = state_69315;
var statearr_69318_69349 = state_69315__$1;
(statearr_69318_69349[(2)] = null);

(statearr_69318_69349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (4))){
var inst_69260 = (state_69315[(2)]);
var state_69315__$1 = state_69315;
var statearr_69319_69350 = state_69315__$1;
(statearr_69319_69350[(2)] = inst_69260);

(statearr_69319_69350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (15))){
var inst_69292 = (state_69315[(2)]);
var inst_69293 = fluree.db.util.async.throw_err.call(null,inst_69292);
var inst_69294 = cljs.core.nth.call(null,inst_69293,(0),null);
var inst_69295 = cljs.core.nth.call(null,inst_69293,(1),null);
var inst_69296 = cljs.core.empty_QMARK_.call(null,inst_69294);
var state_69315__$1 = (function (){var statearr_69320 = state_69315;
(statearr_69320[(7)] = inst_69295);

return statearr_69320;
})();
if(inst_69296){
var statearr_69321_69351 = state_69315__$1;
(statearr_69321_69351[(1)] = (16));

} else {
var statearr_69322_69352 = state_69315__$1;
(statearr_69322_69352[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (13))){
var inst_69288 = (state_69315[(8)]);
var inst_69276 = (state_69315[(9)]);
var inst_69280 = (state_69315[(10)]);
var inst_69288__$1 = (state_69315[(2)]);
var inst_69289 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_69290 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_69289,inst_69276,inst_69280,inst_69288__$1);
var state_69315__$1 = (function (){var statearr_69323 = state_69315;
(statearr_69323[(8)] = inst_69288__$1);

return statearr_69323;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69315__$1,(15),inst_69290);
} else {
if((state_val_69316 === (6))){
var state_69315__$1 = state_69315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69315__$1,(9),startSubject);
} else {
if((state_val_69316 === (17))){
var state_69315__$1 = state_69315;
var statearr_69324_69353 = state_69315__$1;
(statearr_69324_69353[(2)] = true);

(statearr_69324_69353[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (3))){
var inst_69313 = (state_69315[(2)]);
var state_69315__$1 = state_69315;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69315__$1,inst_69313);
} else {
if((state_val_69316 === (12))){
var state_69315__$1 = state_69315;
var statearr_69325_69354 = state_69315__$1;
(statearr_69325_69354[(2)] = endSubject);

(statearr_69325_69354[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (2))){
var _ = (function (){var statearr_69326 = state_69315;
(statearr_69326[(4)] = cljs.core.cons.call(null,(5),(state_69315[(4)])));

return statearr_69326;
})();
var inst_69269 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_69315__$1 = state_69315;
if(inst_69269){
var statearr_69327_69355 = state_69315__$1;
(statearr_69327_69355[(1)] = (6));

} else {
var statearr_69328_69356 = state_69315__$1;
(statearr_69328_69356[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (11))){
var state_69315__$1 = state_69315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69315__$1,(14),endSubject);
} else {
if((state_val_69316 === (9))){
var inst_69272 = (state_69315[(2)]);
var inst_69273 = fluree.db.util.async.throw_err.call(null,inst_69272);
var state_69315__$1 = state_69315;
var statearr_69330_69357 = state_69315__$1;
(statearr_69330_69357[(2)] = inst_69273);

(statearr_69330_69357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (5))){
var _ = (function (){var statearr_69331 = state_69315;
(statearr_69331[(4)] = cljs.core.rest.call(null,(state_69315[(4)])));

return statearr_69331;
})();
var state_69315__$1 = state_69315;
var ex69329 = (state_69315__$1[(2)]);
var statearr_69332_69358 = state_69315__$1;
(statearr_69332_69358[(5)] = ex69329);


if((ex69329 instanceof Error)){
var statearr_69333_69359 = state_69315__$1;
(statearr_69333_69359[(1)] = (4));

(statearr_69333_69359[(5)] = null);

} else {
throw ex69329;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (14))){
var inst_69284 = (state_69315[(2)]);
var inst_69285 = fluree.db.util.async.throw_err.call(null,inst_69284);
var state_69315__$1 = state_69315;
var statearr_69334_69360 = state_69315__$1;
(statearr_69334_69360[(2)] = inst_69285);

(statearr_69334_69360[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (16))){
var state_69315__$1 = state_69315;
var statearr_69335_69361 = state_69315__$1;
(statearr_69335_69361[(2)] = false);

(statearr_69335_69361[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (10))){
var inst_69279 = (state_69315[(2)]);
var inst_69280 = fluree.db.util.async.throw_err.call(null,inst_69279);
var inst_69281 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_69315__$1 = (function (){var statearr_69336 = state_69315;
(statearr_69336[(10)] = inst_69280);

return statearr_69336;
})();
if(inst_69281){
var statearr_69337_69362 = state_69315__$1;
(statearr_69337_69362[(1)] = (11));

} else {
var statearr_69338_69363 = state_69315__$1;
(statearr_69338_69363[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (18))){
var inst_69295 = (state_69315[(7)]);
var inst_69288 = (state_69315[(8)]);
var inst_69276 = (state_69315[(9)]);
var inst_69280 = (state_69315[(10)]);
var inst_69300 = (state_69315[(2)]);
var inst_69301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69302 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69304 = [inst_69276,inst_69280,inst_69288];
var inst_69305 = (new cljs.core.PersistentVector(null,3,(5),inst_69303,inst_69304,null));
var inst_69306 = ["relationship?",inst_69305,inst_69300];
var inst_69307 = cljs.core.PersistentHashMap.fromArrays(inst_69302,inst_69306);
var inst_69308 = [inst_69307,inst_69295];
var inst_69309 = (new cljs.core.PersistentVector(null,2,(5),inst_69301,inst_69308,null));
var inst_69310 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69309);
var _ = (function (){var statearr_69339 = state_69315;
(statearr_69339[(4)] = cljs.core.rest.call(null,(state_69315[(4)])));

return statearr_69339;
})();
var state_69315__$1 = (function (){var statearr_69340 = state_69315;
(statearr_69340[(11)] = inst_69310);

return statearr_69340;
})();
var statearr_69341_69364 = state_69315__$1;
(statearr_69341_69364[(2)] = inst_69300);

(statearr_69341_69364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69316 === (8))){
var inst_69276 = (state_69315[(2)]);
var inst_69277 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_69315__$1 = (function (){var statearr_69342 = state_69315;
(statearr_69342[(9)] = inst_69276);

return statearr_69342;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69315__$1,(10),inst_69277);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_69343 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69343[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_69343[(1)] = (1));

return statearr_69343;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_69315){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69344){var ex__2749__auto__ = e69344;
var statearr_69345_69365 = state_69315;
(statearr_69345_69365[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69315[(4)]))){
var statearr_69346_69366 = state_69315;
(statearr_69346_69366[(1)] = cljs.core.first.call(null,(state_69315[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69367 = state_69315;
state_69315 = G__69367;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = function(state_69315){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_69315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69347 = f__2769__auto__.call(null);
(statearr_69347[(6)] = c__2768__auto__);

return statearr_69347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69404){
var state_val_69405 = (state_69404[(1)]);
if((state_val_69405 === (7))){
var state_69404__$1 = state_69404;
var statearr_69406_69426 = state_69404__$1;
(statearr_69406_69426[(2)] = pred_name);

(statearr_69406_69426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69405 === (1))){
var state_69404__$1 = state_69404;
var statearr_69407_69427 = state_69404__$1;
(statearr_69407_69427[(2)] = null);

(statearr_69407_69427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69405 === (4))){
var inst_69368 = (state_69404[(2)]);
var state_69404__$1 = state_69404;
var statearr_69408_69428 = state_69404__$1;
(statearr_69408_69428[(2)] = inst_69368);

(statearr_69408_69428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69405 === (6))){
var state_69404__$1 = state_69404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69404__$1,(9),pred_name);
} else {
if((state_val_69405 === (3))){
var inst_69402 = (state_69404[(2)]);
var state_69404__$1 = state_69404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69404__$1,inst_69402);
} else {
if((state_val_69405 === (2))){
var _ = (function (){var statearr_69410 = state_69404;
(statearr_69410[(4)] = cljs.core.cons.call(null,(5),(state_69404[(4)])));

return statearr_69410;
})();
var inst_69377 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_69404__$1 = state_69404;
if(inst_69377){
var statearr_69411_69429 = state_69404__$1;
(statearr_69411_69429[(1)] = (6));

} else {
var statearr_69412_69430 = state_69404__$1;
(statearr_69412_69430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69405 === (9))){
var inst_69380 = (state_69404[(2)]);
var inst_69381 = fluree.db.util.async.throw_err.call(null,inst_69380);
var state_69404__$1 = state_69404;
var statearr_69413_69431 = state_69404__$1;
(statearr_69413_69431[(2)] = inst_69381);

(statearr_69413_69431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69405 === (5))){
var _ = (function (){var statearr_69414 = state_69404;
(statearr_69414[(4)] = cljs.core.rest.call(null,(state_69404[(4)])));

return statearr_69414;
})();
var state_69404__$1 = state_69404;
var ex69409 = (state_69404__$1[(2)]);
var statearr_69415_69432 = state_69404__$1;
(statearr_69415_69432[(5)] = ex69409);


if((ex69409 instanceof Error)){
var statearr_69416_69433 = state_69404__$1;
(statearr_69416_69433[(1)] = (4));

(statearr_69416_69433[(5)] = null);

} else {
throw ex69409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69405 === (10))){
var inst_69384 = (state_69404[(7)]);
var inst_69388 = (state_69404[(2)]);
var inst_69389 = fluree.db.util.async.throw_err.call(null,inst_69388);
var inst_69390 = cljs.core.nth.call(null,inst_69389,(0),null);
var inst_69391 = cljs.core.nth.call(null,inst_69389,(1),null);
var inst_69392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69393 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69394 = ["max-pred-val",inst_69384,inst_69390];
var inst_69395 = cljs.core.PersistentHashMap.fromArrays(inst_69393,inst_69394);
var inst_69396 = (inst_69391 + (10));
var inst_69397 = [inst_69395,inst_69396];
var inst_69398 = (new cljs.core.PersistentVector(null,2,(5),inst_69392,inst_69397,null));
var inst_69399 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69398);
var _ = (function (){var statearr_69417 = state_69404;
(statearr_69417[(4)] = cljs.core.rest.call(null,(state_69404[(4)])));

return statearr_69417;
})();
var state_69404__$1 = (function (){var statearr_69418 = state_69404;
(statearr_69418[(8)] = inst_69399);

return statearr_69418;
})();
var statearr_69419_69434 = state_69404__$1;
(statearr_69419_69434[(2)] = inst_69390);

(statearr_69419_69434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69405 === (8))){
var inst_69384 = (state_69404[(7)]);
var inst_69384__$1 = (state_69404[(2)]);
var inst_69385 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_69386 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_69385,inst_69384__$1,null);
var state_69404__$1 = (function (){var statearr_69420 = state_69404;
(statearr_69420[(7)] = inst_69384__$1);

return statearr_69420;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69404__$1,(10),inst_69386);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_69421 = [null,null,null,null,null,null,null,null,null];
(statearr_69421[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__);

(statearr_69421[(1)] = (1));

return statearr_69421;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1 = (function (state_69404){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69422){var ex__2749__auto__ = e69422;
var statearr_69423_69435 = state_69404;
(statearr_69423_69435[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69404[(4)]))){
var statearr_69424_69436 = state_69404;
(statearr_69424_69436[(1)] = cljs.core.first.call(null,(state_69404[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69437 = state_69404;
state_69404 = G__69437;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = function(state_69404){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1.call(this,state_69404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69425 = f__2769__auto__.call(null);
(statearr_69425[(6)] = c__2768__auto__);

return statearr_69425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69464){
var state_val_69465 = (state_69464[(1)]);
if((state_val_69465 === (7))){
var state_69464__$1 = state_69464;
var statearr_69466_69485 = state_69464__$1;
(statearr_69466_69485[(2)] = n);

(statearr_69466_69485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69465 === (1))){
var state_69464__$1 = state_69464;
var statearr_69467_69486 = state_69464__$1;
(statearr_69467_69486[(2)] = null);

(statearr_69467_69486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69465 === (4))){
var inst_69438 = (state_69464[(2)]);
var state_69464__$1 = state_69464;
var statearr_69468_69487 = state_69464__$1;
(statearr_69468_69487[(2)] = inst_69438);

(statearr_69468_69487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69465 === (6))){
var state_69464__$1 = state_69464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69464__$1,(9),n);
} else {
if((state_val_69465 === (3))){
var inst_69462 = (state_69464[(2)]);
var state_69464__$1 = state_69464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69464__$1,inst_69462);
} else {
if((state_val_69465 === (2))){
var _ = (function (){var statearr_69470 = state_69464;
(statearr_69470[(4)] = cljs.core.cons.call(null,(5),(state_69464[(4)])));

return statearr_69470;
})();
var inst_69444 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_69464__$1 = state_69464;
if(inst_69444){
var statearr_69471_69488 = state_69464__$1;
(statearr_69471_69488[(1)] = (6));

} else {
var statearr_69472_69489 = state_69464__$1;
(statearr_69472_69489[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69465 === (9))){
var inst_69447 = (state_69464[(2)]);
var inst_69448 = fluree.db.util.async.throw_err.call(null,inst_69447);
var state_69464__$1 = state_69464;
var statearr_69473_69490 = state_69464__$1;
(statearr_69473_69490[(2)] = inst_69448);

(statearr_69473_69490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69465 === (5))){
var _ = (function (){var statearr_69474 = state_69464;
(statearr_69474[(4)] = cljs.core.rest.call(null,(state_69464[(4)])));

return statearr_69474;
})();
var state_69464__$1 = state_69464;
var ex69469 = (state_69464__$1[(2)]);
var statearr_69475_69491 = state_69464__$1;
(statearr_69475_69491[(5)] = ex69469);


if((ex69469 instanceof Error)){
var statearr_69476_69492 = state_69464__$1;
(statearr_69476_69492[(1)] = (4));

(statearr_69476_69492[(5)] = null);

} else {
throw ex69469;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69465 === (8))){
var inst_69451 = (state_69464[(2)]);
var inst_69452 = fluree.db.dbfunctions.internal.inc.call(null,inst_69451);
var inst_69453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69454 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69455 = ["inc",inst_69451,inst_69452];
var inst_69456 = cljs.core.PersistentHashMap.fromArrays(inst_69454,inst_69455);
var inst_69457 = [inst_69456,(10)];
var inst_69458 = (new cljs.core.PersistentVector(null,2,(5),inst_69453,inst_69457,null));
var inst_69459 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69458);
var _ = (function (){var statearr_69477 = state_69464;
(statearr_69477[(4)] = cljs.core.rest.call(null,(state_69464[(4)])));

return statearr_69477;
})();
var state_69464__$1 = (function (){var statearr_69478 = state_69464;
(statearr_69478[(7)] = inst_69459);

return statearr_69478;
})();
var statearr_69479_69493 = state_69464__$1;
(statearr_69479_69493[(2)] = inst_69452);

(statearr_69479_69493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0 = (function (){
var statearr_69480 = [null,null,null,null,null,null,null,null];
(statearr_69480[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__);

(statearr_69480[(1)] = (1));

return statearr_69480;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1 = (function (state_69464){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69481){var ex__2749__auto__ = e69481;
var statearr_69482_69494 = state_69464;
(statearr_69482_69494[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69464[(4)]))){
var statearr_69483_69495 = state_69464;
(statearr_69483_69495[(1)] = cljs.core.first.call(null,(state_69464[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69496 = state_69464;
state_69464 = G__69496;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = function(state_69464){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1.call(this,state_69464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69484 = f__2769__auto__.call(null);
(statearr_69484[(6)] = c__2768__auto__);

return statearr_69484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69523){
var state_val_69524 = (state_69523[(1)]);
if((state_val_69524 === (7))){
var state_69523__$1 = state_69523;
var statearr_69525_69544 = state_69523__$1;
(statearr_69525_69544[(2)] = n);

(statearr_69525_69544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (1))){
var state_69523__$1 = state_69523;
var statearr_69526_69545 = state_69523__$1;
(statearr_69526_69545[(2)] = null);

(statearr_69526_69545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (4))){
var inst_69497 = (state_69523[(2)]);
var state_69523__$1 = state_69523;
var statearr_69527_69546 = state_69523__$1;
(statearr_69527_69546[(2)] = inst_69497);

(statearr_69527_69546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (6))){
var state_69523__$1 = state_69523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69523__$1,(9),n);
} else {
if((state_val_69524 === (3))){
var inst_69521 = (state_69523[(2)]);
var state_69523__$1 = state_69523;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69523__$1,inst_69521);
} else {
if((state_val_69524 === (2))){
var _ = (function (){var statearr_69529 = state_69523;
(statearr_69529[(4)] = cljs.core.cons.call(null,(5),(state_69523[(4)])));

return statearr_69529;
})();
var inst_69503 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_69523__$1 = state_69523;
if(inst_69503){
var statearr_69530_69547 = state_69523__$1;
(statearr_69530_69547[(1)] = (6));

} else {
var statearr_69531_69548 = state_69523__$1;
(statearr_69531_69548[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (9))){
var inst_69506 = (state_69523[(2)]);
var inst_69507 = fluree.db.util.async.throw_err.call(null,inst_69506);
var state_69523__$1 = state_69523;
var statearr_69532_69549 = state_69523__$1;
(statearr_69532_69549[(2)] = inst_69507);

(statearr_69532_69549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (5))){
var _ = (function (){var statearr_69533 = state_69523;
(statearr_69533[(4)] = cljs.core.rest.call(null,(state_69523[(4)])));

return statearr_69533;
})();
var state_69523__$1 = state_69523;
var ex69528 = (state_69523__$1[(2)]);
var statearr_69534_69550 = state_69523__$1;
(statearr_69534_69550[(5)] = ex69528);


if((ex69528 instanceof Error)){
var statearr_69535_69551 = state_69523__$1;
(statearr_69535_69551[(1)] = (4));

(statearr_69535_69551[(5)] = null);

} else {
throw ex69528;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (8))){
var inst_69510 = (state_69523[(2)]);
var inst_69511 = fluree.db.dbfunctions.internal.dec.call(null,inst_69510);
var inst_69512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69513 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69514 = ["dec",inst_69510,inst_69511];
var inst_69515 = cljs.core.PersistentHashMap.fromArrays(inst_69513,inst_69514);
var inst_69516 = [inst_69515,(10)];
var inst_69517 = (new cljs.core.PersistentVector(null,2,(5),inst_69512,inst_69516,null));
var inst_69518 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69517);
var _ = (function (){var statearr_69536 = state_69523;
(statearr_69536[(4)] = cljs.core.rest.call(null,(state_69523[(4)])));

return statearr_69536;
})();
var state_69523__$1 = (function (){var statearr_69537 = state_69523;
(statearr_69537[(7)] = inst_69518);

return statearr_69537;
})();
var statearr_69538_69552 = state_69523__$1;
(statearr_69538_69552[(2)] = inst_69511);

(statearr_69538_69552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0 = (function (){
var statearr_69539 = [null,null,null,null,null,null,null,null];
(statearr_69539[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__);

(statearr_69539[(1)] = (1));

return statearr_69539;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1 = (function (state_69523){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69540){var ex__2749__auto__ = e69540;
var statearr_69541_69553 = state_69523;
(statearr_69541_69553[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69523[(4)]))){
var statearr_69542_69554 = state_69523;
(statearr_69542_69554[(1)] = cljs.core.first.call(null,(state_69523[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69555 = state_69523;
state_69523 = G__69555;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = function(state_69523){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1.call(this,state_69523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69543 = f__2769__auto__.call(null);
(statearr_69543[(6)] = c__2768__auto__);

return statearr_69543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69605 = arguments.length;
var i__5770__auto___69606 = (0);
while(true){
if((i__5770__auto___69606 < len__5769__auto___69605)){
args__5775__auto__.push((arguments[i__5770__auto___69606]));

var G__69607 = (i__5770__auto___69606 + (1));
i__5770__auto___69606 = G__69607;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69588){
var state_val_69589 = (state_69588[(1)]);
if((state_val_69589 === (1))){
var state_69588__$1 = state_69588;
var statearr_69590_69608 = state_69588__$1;
(statearr_69590_69608[(2)] = null);

(statearr_69590_69608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69589 === (2))){
var _ = (function (){var statearr_69591 = state_69588;
(statearr_69591[(4)] = cljs.core.cons.call(null,(5),(state_69588[(4)])));

return statearr_69591;
})();
var inst_69564 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_69588__$1 = state_69588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69588__$1,(6),inst_69564);
} else {
if((state_val_69589 === (3))){
var inst_69586 = (state_69588[(2)]);
var state_69588__$1 = state_69588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69588__$1,inst_69586);
} else {
if((state_val_69589 === (4))){
var inst_69558 = (state_69588[(2)]);
var state_69588__$1 = state_69588;
var statearr_69593_69609 = state_69588__$1;
(statearr_69593_69609[(2)] = inst_69558);

(statearr_69593_69609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69589 === (5))){
var _ = (function (){var statearr_69594 = state_69588;
(statearr_69594[(4)] = cljs.core.rest.call(null,(state_69588[(4)])));

return statearr_69594;
})();
var state_69588__$1 = state_69588;
var ex69592 = (state_69588__$1[(2)]);
var statearr_69595_69610 = state_69588__$1;
(statearr_69595_69610[(5)] = ex69592);


if((ex69592 instanceof Error)){
var statearr_69596_69611 = state_69588__$1;
(statearr_69596_69611[(1)] = (4));

(statearr_69596_69611[(5)] = null);

} else {
throw ex69592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69589 === (6))){
var inst_69566 = (state_69588[(2)]);
var inst_69567 = fluree.db.util.async.throw_err.call(null,inst_69566);
var inst_69568 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_69567);
var inst_69569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69570 = [inst_69567];
var inst_69571 = (new cljs.core.PersistentVector(null,1,(5),inst_69569,inst_69570,null));
var inst_69572 = cljs.core.count.call(null,inst_69571);
var inst_69573 = ((9) + inst_69572);
var inst_69574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69575 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69577 = [inst_69567];
var inst_69578 = (new cljs.core.PersistentVector(null,1,(5),inst_69576,inst_69577,null));
var inst_69579 = ["+",inst_69578,inst_69568];
var inst_69580 = cljs.core.PersistentHashMap.fromArrays(inst_69575,inst_69579);
var inst_69581 = [inst_69580,inst_69573];
var inst_69582 = (new cljs.core.PersistentVector(null,2,(5),inst_69574,inst_69581,null));
var inst_69583 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69582);
var _ = (function (){var statearr_69597 = state_69588;
(statearr_69597[(4)] = cljs.core.rest.call(null,(state_69588[(4)])));

return statearr_69597;
})();
var state_69588__$1 = (function (){var statearr_69598 = state_69588;
(statearr_69598[(7)] = inst_69583);

return statearr_69598;
})();
var statearr_69599_69612 = state_69588__$1;
(statearr_69599_69612[(2)] = inst_69568);

(statearr_69599_69612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_69600 = [null,null,null,null,null,null,null,null];
(statearr_69600[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_69600[(1)] = (1));

return statearr_69600;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_69588){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69601){var ex__2749__auto__ = e69601;
var statearr_69602_69613 = state_69588;
(statearr_69602_69613[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69588[(4)]))){
var statearr_69603_69614 = state_69588;
(statearr_69603_69614[(1)] = cljs.core.first.call(null,(state_69588[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69615 = state_69588;
state_69588 = G__69615;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_69588){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_69588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69604 = f__2769__auto__.call(null);
(statearr_69604[(6)] = c__2768__auto__);

return statearr_69604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq69556){
var G__69557 = cljs.core.first.call(null,seq69556);
var seq69556__$1 = cljs.core.next.call(null,seq69556);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69557,seq69556__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69665 = arguments.length;
var i__5770__auto___69666 = (0);
while(true){
if((i__5770__auto___69666 < len__5769__auto___69665)){
args__5775__auto__.push((arguments[i__5770__auto___69666]));

var G__69667 = (i__5770__auto___69666 + (1));
i__5770__auto___69666 = G__69667;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69648){
var state_val_69649 = (state_69648[(1)]);
if((state_val_69649 === (1))){
var state_69648__$1 = state_69648;
var statearr_69650_69668 = state_69648__$1;
(statearr_69650_69668[(2)] = null);

(statearr_69650_69668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (2))){
var _ = (function (){var statearr_69651 = state_69648;
(statearr_69651[(4)] = cljs.core.cons.call(null,(5),(state_69648[(4)])));

return statearr_69651;
})();
var inst_69624 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_69648__$1 = state_69648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69648__$1,(6),inst_69624);
} else {
if((state_val_69649 === (3))){
var inst_69646 = (state_69648[(2)]);
var state_69648__$1 = state_69648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69648__$1,inst_69646);
} else {
if((state_val_69649 === (4))){
var inst_69618 = (state_69648[(2)]);
var state_69648__$1 = state_69648;
var statearr_69653_69669 = state_69648__$1;
(statearr_69653_69669[(2)] = inst_69618);

(statearr_69653_69669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (5))){
var _ = (function (){var statearr_69654 = state_69648;
(statearr_69654[(4)] = cljs.core.rest.call(null,(state_69648[(4)])));

return statearr_69654;
})();
var state_69648__$1 = state_69648;
var ex69652 = (state_69648__$1[(2)]);
var statearr_69655_69670 = state_69648__$1;
(statearr_69655_69670[(5)] = ex69652);


if((ex69652 instanceof Error)){
var statearr_69656_69671 = state_69648__$1;
(statearr_69656_69671[(1)] = (4));

(statearr_69656_69671[(5)] = null);

} else {
throw ex69652;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (6))){
var inst_69626 = (state_69648[(2)]);
var inst_69627 = fluree.db.util.async.throw_err.call(null,inst_69626);
var inst_69628 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_69627);
var inst_69629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69630 = [inst_69627];
var inst_69631 = (new cljs.core.PersistentVector(null,1,(5),inst_69629,inst_69630,null));
var inst_69632 = cljs.core.count.call(null,inst_69631);
var inst_69633 = ((9) + inst_69632);
var inst_69634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69635 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69637 = [inst_69627];
var inst_69638 = (new cljs.core.PersistentVector(null,1,(5),inst_69636,inst_69637,null));
var inst_69639 = ["-",inst_69638,inst_69628];
var inst_69640 = cljs.core.PersistentHashMap.fromArrays(inst_69635,inst_69639);
var inst_69641 = [inst_69640,inst_69633];
var inst_69642 = (new cljs.core.PersistentVector(null,2,(5),inst_69634,inst_69641,null));
var inst_69643 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69642);
var _ = (function (){var statearr_69657 = state_69648;
(statearr_69657[(4)] = cljs.core.rest.call(null,(state_69648[(4)])));

return statearr_69657;
})();
var state_69648__$1 = (function (){var statearr_69658 = state_69648;
(statearr_69658[(7)] = inst_69643);

return statearr_69658;
})();
var statearr_69659_69672 = state_69648__$1;
(statearr_69659_69672[(2)] = inst_69628);

(statearr_69659_69672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_69660 = [null,null,null,null,null,null,null,null];
(statearr_69660[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_69660[(1)] = (1));

return statearr_69660;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_69648){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69661){var ex__2749__auto__ = e69661;
var statearr_69662_69673 = state_69648;
(statearr_69662_69673[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69648[(4)]))){
var statearr_69663_69674 = state_69648;
(statearr_69663_69674[(1)] = cljs.core.first.call(null,(state_69648[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69675 = state_69648;
state_69648 = G__69675;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_69648){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_69648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69664 = f__2769__auto__.call(null);
(statearr_69664[(6)] = c__2768__auto__);

return statearr_69664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq69616){
var G__69617 = cljs.core.first.call(null,seq69616);
var seq69616__$1 = cljs.core.next.call(null,seq69616);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69617,seq69616__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69725 = arguments.length;
var i__5770__auto___69726 = (0);
while(true){
if((i__5770__auto___69726 < len__5769__auto___69725)){
args__5775__auto__.push((arguments[i__5770__auto___69726]));

var G__69727 = (i__5770__auto___69726 + (1));
i__5770__auto___69726 = G__69727;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69708){
var state_val_69709 = (state_69708[(1)]);
if((state_val_69709 === (1))){
var state_69708__$1 = state_69708;
var statearr_69710_69728 = state_69708__$1;
(statearr_69710_69728[(2)] = null);

(statearr_69710_69728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (2))){
var _ = (function (){var statearr_69711 = state_69708;
(statearr_69711[(4)] = cljs.core.cons.call(null,(5),(state_69708[(4)])));

return statearr_69711;
})();
var inst_69684 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69708__$1,(6),inst_69684);
} else {
if((state_val_69709 === (3))){
var inst_69706 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69708__$1,inst_69706);
} else {
if((state_val_69709 === (4))){
var inst_69678 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
var statearr_69713_69729 = state_69708__$1;
(statearr_69713_69729[(2)] = inst_69678);

(statearr_69713_69729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (5))){
var _ = (function (){var statearr_69714 = state_69708;
(statearr_69714[(4)] = cljs.core.rest.call(null,(state_69708[(4)])));

return statearr_69714;
})();
var state_69708__$1 = state_69708;
var ex69712 = (state_69708__$1[(2)]);
var statearr_69715_69730 = state_69708__$1;
(statearr_69715_69730[(5)] = ex69712);


if((ex69712 instanceof Error)){
var statearr_69716_69731 = state_69708__$1;
(statearr_69716_69731[(1)] = (4));

(statearr_69716_69731[(5)] = null);

} else {
throw ex69712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (6))){
var inst_69686 = (state_69708[(2)]);
var inst_69687 = fluree.db.util.async.throw_err.call(null,inst_69686);
var inst_69688 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_69687);
var inst_69689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69690 = [inst_69687];
var inst_69691 = (new cljs.core.PersistentVector(null,1,(5),inst_69689,inst_69690,null));
var inst_69692 = cljs.core.count.call(null,inst_69691);
var inst_69693 = ((9) + inst_69692);
var inst_69694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69695 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69697 = [inst_69687];
var inst_69698 = (new cljs.core.PersistentVector(null,1,(5),inst_69696,inst_69697,null));
var inst_69699 = ["*",inst_69698,inst_69688];
var inst_69700 = cljs.core.PersistentHashMap.fromArrays(inst_69695,inst_69699);
var inst_69701 = [inst_69700,inst_69693];
var inst_69702 = (new cljs.core.PersistentVector(null,2,(5),inst_69694,inst_69701,null));
var inst_69703 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69702);
var _ = (function (){var statearr_69717 = state_69708;
(statearr_69717[(4)] = cljs.core.rest.call(null,(state_69708[(4)])));

return statearr_69717;
})();
var state_69708__$1 = (function (){var statearr_69718 = state_69708;
(statearr_69718[(7)] = inst_69703);

return statearr_69718;
})();
var statearr_69719_69732 = state_69708__$1;
(statearr_69719_69732[(2)] = inst_69688);

(statearr_69719_69732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_69720 = [null,null,null,null,null,null,null,null];
(statearr_69720[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_69720[(1)] = (1));

return statearr_69720;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_69708){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69721){var ex__2749__auto__ = e69721;
var statearr_69722_69733 = state_69708;
(statearr_69722_69733[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69708[(4)]))){
var statearr_69723_69734 = state_69708;
(statearr_69723_69734[(1)] = cljs.core.first.call(null,(state_69708[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69735 = state_69708;
state_69708 = G__69735;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_69708){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_69708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69724 = f__2769__auto__.call(null);
(statearr_69724[(6)] = c__2768__auto__);

return statearr_69724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq69676){
var G__69677 = cljs.core.first.call(null,seq69676);
var seq69676__$1 = cljs.core.next.call(null,seq69676);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69677,seq69676__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69785 = arguments.length;
var i__5770__auto___69786 = (0);
while(true){
if((i__5770__auto___69786 < len__5769__auto___69785)){
args__5775__auto__.push((arguments[i__5770__auto___69786]));

var G__69787 = (i__5770__auto___69786 + (1));
i__5770__auto___69786 = G__69787;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69768){
var state_val_69769 = (state_69768[(1)]);
if((state_val_69769 === (1))){
var state_69768__$1 = state_69768;
var statearr_69770_69788 = state_69768__$1;
(statearr_69770_69788[(2)] = null);

(statearr_69770_69788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69769 === (2))){
var _ = (function (){var statearr_69771 = state_69768;
(statearr_69771[(4)] = cljs.core.cons.call(null,(5),(state_69768[(4)])));

return statearr_69771;
})();
var inst_69744 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_69768__$1 = state_69768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69768__$1,(6),inst_69744);
} else {
if((state_val_69769 === (3))){
var inst_69766 = (state_69768[(2)]);
var state_69768__$1 = state_69768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69768__$1,inst_69766);
} else {
if((state_val_69769 === (4))){
var inst_69738 = (state_69768[(2)]);
var state_69768__$1 = state_69768;
var statearr_69773_69789 = state_69768__$1;
(statearr_69773_69789[(2)] = inst_69738);

(statearr_69773_69789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69769 === (5))){
var _ = (function (){var statearr_69774 = state_69768;
(statearr_69774[(4)] = cljs.core.rest.call(null,(state_69768[(4)])));

return statearr_69774;
})();
var state_69768__$1 = state_69768;
var ex69772 = (state_69768__$1[(2)]);
var statearr_69775_69790 = state_69768__$1;
(statearr_69775_69790[(5)] = ex69772);


if((ex69772 instanceof Error)){
var statearr_69776_69791 = state_69768__$1;
(statearr_69776_69791[(1)] = (4));

(statearr_69776_69791[(5)] = null);

} else {
throw ex69772;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69769 === (6))){
var inst_69746 = (state_69768[(2)]);
var inst_69747 = fluree.db.util.async.throw_err.call(null,inst_69746);
var inst_69748 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_69747);
var inst_69749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69750 = [inst_69747];
var inst_69751 = (new cljs.core.PersistentVector(null,1,(5),inst_69749,inst_69750,null));
var inst_69752 = cljs.core.count.call(null,inst_69751);
var inst_69753 = ((9) + inst_69752);
var inst_69754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69755 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69757 = [inst_69747];
var inst_69758 = (new cljs.core.PersistentVector(null,1,(5),inst_69756,inst_69757,null));
var inst_69759 = ["/",inst_69758,inst_69748];
var inst_69760 = cljs.core.PersistentHashMap.fromArrays(inst_69755,inst_69759);
var inst_69761 = [inst_69760,inst_69753];
var inst_69762 = (new cljs.core.PersistentVector(null,2,(5),inst_69754,inst_69761,null));
var inst_69763 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69762);
var _ = (function (){var statearr_69777 = state_69768;
(statearr_69777[(4)] = cljs.core.rest.call(null,(state_69768[(4)])));

return statearr_69777;
})();
var state_69768__$1 = (function (){var statearr_69778 = state_69768;
(statearr_69778[(7)] = inst_69763);

return statearr_69778;
})();
var statearr_69779_69792 = state_69768__$1;
(statearr_69779_69792[(2)] = inst_69748);

(statearr_69779_69792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_69780 = [null,null,null,null,null,null,null,null];
(statearr_69780[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_69780[(1)] = (1));

return statearr_69780;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_69768){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69781){var ex__2749__auto__ = e69781;
var statearr_69782_69793 = state_69768;
(statearr_69782_69793[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69768[(4)]))){
var statearr_69783_69794 = state_69768;
(statearr_69783_69794[(1)] = cljs.core.first.call(null,(state_69768[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69795 = state_69768;
state_69768 = G__69795;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_69768){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_69768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69784 = f__2769__auto__.call(null);
(statearr_69784[(6)] = c__2768__auto__);

return statearr_69784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq69736){
var G__69737 = cljs.core.first.call(null,seq69736);
var seq69736__$1 = cljs.core.next.call(null,seq69736);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69737,seq69736__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69833){
var state_val_69834 = (state_69833[(1)]);
if((state_val_69834 === (7))){
var state_69833__$1 = state_69833;
var statearr_69835_69859 = state_69833__$1;
(statearr_69835_69859[(2)] = n);

(statearr_69835_69859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (1))){
var state_69833__$1 = state_69833;
var statearr_69836_69860 = state_69833__$1;
(statearr_69836_69860[(2)] = null);

(statearr_69836_69860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (4))){
var inst_69796 = (state_69833[(2)]);
var state_69833__$1 = state_69833;
var statearr_69837_69861 = state_69833__$1;
(statearr_69837_69861[(2)] = inst_69796);

(statearr_69837_69861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (13))){
var inst_69813 = (state_69833[(2)]);
var inst_69814 = fluree.db.util.async.throw_err.call(null,inst_69813);
var state_69833__$1 = state_69833;
var statearr_69838_69862 = state_69833__$1;
(statearr_69838_69862[(2)] = inst_69814);

(statearr_69838_69862[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (6))){
var state_69833__$1 = state_69833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69833__$1,(9),n);
} else {
if((state_val_69834 === (3))){
var inst_69831 = (state_69833[(2)]);
var state_69833__$1 = state_69833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69833__$1,inst_69831);
} else {
if((state_val_69834 === (12))){
var inst_69809 = (state_69833[(7)]);
var inst_69817 = (state_69833[(2)]);
var inst_69818 = fluree.db.dbfunctions.internal.quot.call(null,inst_69809,inst_69817);
var inst_69819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69820 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69822 = [inst_69809,inst_69817];
var inst_69823 = (new cljs.core.PersistentVector(null,2,(5),inst_69821,inst_69822,null));
var inst_69824 = ["quot",inst_69823,inst_69818];
var inst_69825 = cljs.core.PersistentHashMap.fromArrays(inst_69820,inst_69824);
var inst_69826 = [inst_69825,(2)];
var inst_69827 = (new cljs.core.PersistentVector(null,2,(5),inst_69819,inst_69826,null));
var inst_69828 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69827);
var _ = (function (){var statearr_69839 = state_69833;
(statearr_69839[(4)] = cljs.core.rest.call(null,(state_69833[(4)])));

return statearr_69839;
})();
var state_69833__$1 = (function (){var statearr_69840 = state_69833;
(statearr_69840[(8)] = inst_69828);

return statearr_69840;
})();
var statearr_69841_69863 = state_69833__$1;
(statearr_69841_69863[(2)] = inst_69818);

(statearr_69841_69863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (2))){
var _ = (function (){var statearr_69842 = state_69833;
(statearr_69842[(4)] = cljs.core.cons.call(null,(5),(state_69833[(4)])));

return statearr_69842;
})();
var inst_69802 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_69833__$1 = state_69833;
if(inst_69802){
var statearr_69843_69864 = state_69833__$1;
(statearr_69843_69864[(1)] = (6));

} else {
var statearr_69844_69865 = state_69833__$1;
(statearr_69844_69865[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (11))){
var state_69833__$1 = state_69833;
var statearr_69846_69866 = state_69833__$1;
(statearr_69846_69866[(2)] = d);

(statearr_69846_69866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (9))){
var inst_69805 = (state_69833[(2)]);
var inst_69806 = fluree.db.util.async.throw_err.call(null,inst_69805);
var state_69833__$1 = state_69833;
var statearr_69847_69867 = state_69833__$1;
(statearr_69847_69867[(2)] = inst_69806);

(statearr_69847_69867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (5))){
var _ = (function (){var statearr_69848 = state_69833;
(statearr_69848[(4)] = cljs.core.rest.call(null,(state_69833[(4)])));

return statearr_69848;
})();
var state_69833__$1 = state_69833;
var ex69845 = (state_69833__$1[(2)]);
var statearr_69849_69868 = state_69833__$1;
(statearr_69849_69868[(5)] = ex69845);


if((ex69845 instanceof Error)){
var statearr_69850_69869 = state_69833__$1;
(statearr_69850_69869[(1)] = (4));

(statearr_69850_69869[(5)] = null);

} else {
throw ex69845;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69834 === (10))){
var state_69833__$1 = state_69833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69833__$1,(13),d);
} else {
if((state_val_69834 === (8))){
var inst_69809 = (state_69833[(2)]);
var inst_69810 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_69833__$1 = (function (){var statearr_69851 = state_69833;
(statearr_69851[(7)] = inst_69809);

return statearr_69851;
})();
if(inst_69810){
var statearr_69852_69870 = state_69833__$1;
(statearr_69852_69870[(1)] = (10));

} else {
var statearr_69853_69871 = state_69833__$1;
(statearr_69853_69871[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0 = (function (){
var statearr_69854 = [null,null,null,null,null,null,null,null,null];
(statearr_69854[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__);

(statearr_69854[(1)] = (1));

return statearr_69854;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1 = (function (state_69833){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69855){var ex__2749__auto__ = e69855;
var statearr_69856_69872 = state_69833;
(statearr_69856_69872[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69833[(4)]))){
var statearr_69857_69873 = state_69833;
(statearr_69857_69873[(1)] = cljs.core.first.call(null,(state_69833[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69874 = state_69833;
state_69833 = G__69874;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = function(state_69833){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1.call(this,state_69833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69858 = f__2769__auto__.call(null);
(statearr_69858[(6)] = c__2768__auto__);

return statearr_69858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69912){
var state_val_69913 = (state_69912[(1)]);
if((state_val_69913 === (7))){
var state_69912__$1 = state_69912;
var statearr_69914_69938 = state_69912__$1;
(statearr_69914_69938[(2)] = n);

(statearr_69914_69938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (1))){
var state_69912__$1 = state_69912;
var statearr_69915_69939 = state_69912__$1;
(statearr_69915_69939[(2)] = null);

(statearr_69915_69939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (4))){
var inst_69875 = (state_69912[(2)]);
var state_69912__$1 = state_69912;
var statearr_69916_69940 = state_69912__$1;
(statearr_69916_69940[(2)] = inst_69875);

(statearr_69916_69940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (13))){
var inst_69892 = (state_69912[(2)]);
var inst_69893 = fluree.db.util.async.throw_err.call(null,inst_69892);
var state_69912__$1 = state_69912;
var statearr_69917_69941 = state_69912__$1;
(statearr_69917_69941[(2)] = inst_69893);

(statearr_69917_69941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (6))){
var state_69912__$1 = state_69912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69912__$1,(9),n);
} else {
if((state_val_69913 === (3))){
var inst_69910 = (state_69912[(2)]);
var state_69912__$1 = state_69912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69912__$1,inst_69910);
} else {
if((state_val_69913 === (12))){
var inst_69888 = (state_69912[(7)]);
var inst_69896 = (state_69912[(2)]);
var inst_69897 = fluree.db.dbfunctions.internal.mod.call(null,inst_69888,inst_69896);
var inst_69898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69899 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69901 = [inst_69888,inst_69896];
var inst_69902 = (new cljs.core.PersistentVector(null,2,(5),inst_69900,inst_69901,null));
var inst_69903 = ["mod",inst_69902,inst_69897];
var inst_69904 = cljs.core.PersistentHashMap.fromArrays(inst_69899,inst_69903);
var inst_69905 = [inst_69904,(2)];
var inst_69906 = (new cljs.core.PersistentVector(null,2,(5),inst_69898,inst_69905,null));
var inst_69907 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69906);
var _ = (function (){var statearr_69918 = state_69912;
(statearr_69918[(4)] = cljs.core.rest.call(null,(state_69912[(4)])));

return statearr_69918;
})();
var state_69912__$1 = (function (){var statearr_69919 = state_69912;
(statearr_69919[(8)] = inst_69907);

return statearr_69919;
})();
var statearr_69920_69942 = state_69912__$1;
(statearr_69920_69942[(2)] = inst_69897);

(statearr_69920_69942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (2))){
var _ = (function (){var statearr_69921 = state_69912;
(statearr_69921[(4)] = cljs.core.cons.call(null,(5),(state_69912[(4)])));

return statearr_69921;
})();
var inst_69881 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_69912__$1 = state_69912;
if(inst_69881){
var statearr_69922_69943 = state_69912__$1;
(statearr_69922_69943[(1)] = (6));

} else {
var statearr_69923_69944 = state_69912__$1;
(statearr_69923_69944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (11))){
var state_69912__$1 = state_69912;
var statearr_69925_69945 = state_69912__$1;
(statearr_69925_69945[(2)] = d);

(statearr_69925_69945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (9))){
var inst_69884 = (state_69912[(2)]);
var inst_69885 = fluree.db.util.async.throw_err.call(null,inst_69884);
var state_69912__$1 = state_69912;
var statearr_69926_69946 = state_69912__$1;
(statearr_69926_69946[(2)] = inst_69885);

(statearr_69926_69946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (5))){
var _ = (function (){var statearr_69927 = state_69912;
(statearr_69927[(4)] = cljs.core.rest.call(null,(state_69912[(4)])));

return statearr_69927;
})();
var state_69912__$1 = state_69912;
var ex69924 = (state_69912__$1[(2)]);
var statearr_69928_69947 = state_69912__$1;
(statearr_69928_69947[(5)] = ex69924);


if((ex69924 instanceof Error)){
var statearr_69929_69948 = state_69912__$1;
(statearr_69929_69948[(1)] = (4));

(statearr_69929_69948[(5)] = null);

} else {
throw ex69924;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69913 === (10))){
var state_69912__$1 = state_69912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69912__$1,(13),d);
} else {
if((state_val_69913 === (8))){
var inst_69888 = (state_69912[(2)]);
var inst_69889 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_69912__$1 = (function (){var statearr_69930 = state_69912;
(statearr_69930[(7)] = inst_69888);

return statearr_69930;
})();
if(inst_69889){
var statearr_69931_69949 = state_69912__$1;
(statearr_69931_69949[(1)] = (10));

} else {
var statearr_69932_69950 = state_69912__$1;
(statearr_69932_69950[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0 = (function (){
var statearr_69933 = [null,null,null,null,null,null,null,null,null];
(statearr_69933[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__);

(statearr_69933[(1)] = (1));

return statearr_69933;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1 = (function (state_69912){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69934){var ex__2749__auto__ = e69934;
var statearr_69935_69951 = state_69912;
(statearr_69935_69951[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69912[(4)]))){
var statearr_69936_69952 = state_69912;
(statearr_69936_69952[(1)] = cljs.core.first.call(null,(state_69912[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69953 = state_69912;
state_69912 = G__69953;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = function(state_69912){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1.call(this,state_69912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69937 = f__2769__auto__.call(null);
(statearr_69937[(6)] = c__2768__auto__);

return statearr_69937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69991){
var state_val_69992 = (state_69991[(1)]);
if((state_val_69992 === (7))){
var state_69991__$1 = state_69991;
var statearr_69993_70017 = state_69991__$1;
(statearr_69993_70017[(2)] = n);

(statearr_69993_70017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (1))){
var state_69991__$1 = state_69991;
var statearr_69994_70018 = state_69991__$1;
(statearr_69994_70018[(2)] = null);

(statearr_69994_70018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (4))){
var inst_69954 = (state_69991[(2)]);
var state_69991__$1 = state_69991;
var statearr_69995_70019 = state_69991__$1;
(statearr_69995_70019[(2)] = inst_69954);

(statearr_69995_70019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (13))){
var inst_69971 = (state_69991[(2)]);
var inst_69972 = fluree.db.util.async.throw_err.call(null,inst_69971);
var state_69991__$1 = state_69991;
var statearr_69996_70020 = state_69991__$1;
(statearr_69996_70020[(2)] = inst_69972);

(statearr_69996_70020[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (6))){
var state_69991__$1 = state_69991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69991__$1,(9),n);
} else {
if((state_val_69992 === (3))){
var inst_69989 = (state_69991[(2)]);
var state_69991__$1 = state_69991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69991__$1,inst_69989);
} else {
if((state_val_69992 === (12))){
var inst_69967 = (state_69991[(7)]);
var inst_69975 = (state_69991[(2)]);
var inst_69976 = fluree.db.dbfunctions.internal.rem.call(null,inst_69967,inst_69975);
var inst_69977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69978 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69980 = [inst_69967,inst_69975];
var inst_69981 = (new cljs.core.PersistentVector(null,2,(5),inst_69979,inst_69980,null));
var inst_69982 = ["rem",inst_69981,inst_69976];
var inst_69983 = cljs.core.PersistentHashMap.fromArrays(inst_69978,inst_69982);
var inst_69984 = [inst_69983,(2)];
var inst_69985 = (new cljs.core.PersistentVector(null,2,(5),inst_69977,inst_69984,null));
var inst_69986 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_69985);
var _ = (function (){var statearr_69997 = state_69991;
(statearr_69997[(4)] = cljs.core.rest.call(null,(state_69991[(4)])));

return statearr_69997;
})();
var state_69991__$1 = (function (){var statearr_69998 = state_69991;
(statearr_69998[(8)] = inst_69986);

return statearr_69998;
})();
var statearr_69999_70021 = state_69991__$1;
(statearr_69999_70021[(2)] = inst_69976);

(statearr_69999_70021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (2))){
var _ = (function (){var statearr_70000 = state_69991;
(statearr_70000[(4)] = cljs.core.cons.call(null,(5),(state_69991[(4)])));

return statearr_70000;
})();
var inst_69960 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_69991__$1 = state_69991;
if(inst_69960){
var statearr_70001_70022 = state_69991__$1;
(statearr_70001_70022[(1)] = (6));

} else {
var statearr_70002_70023 = state_69991__$1;
(statearr_70002_70023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (11))){
var state_69991__$1 = state_69991;
var statearr_70004_70024 = state_69991__$1;
(statearr_70004_70024[(2)] = d);

(statearr_70004_70024[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (9))){
var inst_69963 = (state_69991[(2)]);
var inst_69964 = fluree.db.util.async.throw_err.call(null,inst_69963);
var state_69991__$1 = state_69991;
var statearr_70005_70025 = state_69991__$1;
(statearr_70005_70025[(2)] = inst_69964);

(statearr_70005_70025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (5))){
var _ = (function (){var statearr_70006 = state_69991;
(statearr_70006[(4)] = cljs.core.rest.call(null,(state_69991[(4)])));

return statearr_70006;
})();
var state_69991__$1 = state_69991;
var ex70003 = (state_69991__$1[(2)]);
var statearr_70007_70026 = state_69991__$1;
(statearr_70007_70026[(5)] = ex70003);


if((ex70003 instanceof Error)){
var statearr_70008_70027 = state_69991__$1;
(statearr_70008_70027[(1)] = (4));

(statearr_70008_70027[(5)] = null);

} else {
throw ex70003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69992 === (10))){
var state_69991__$1 = state_69991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69991__$1,(13),d);
} else {
if((state_val_69992 === (8))){
var inst_69967 = (state_69991[(2)]);
var inst_69968 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_69991__$1 = (function (){var statearr_70009 = state_69991;
(statearr_70009[(7)] = inst_69967);

return statearr_70009;
})();
if(inst_69968){
var statearr_70010_70028 = state_69991__$1;
(statearr_70010_70028[(1)] = (10));

} else {
var statearr_70011_70029 = state_69991__$1;
(statearr_70011_70029[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0 = (function (){
var statearr_70012 = [null,null,null,null,null,null,null,null,null];
(statearr_70012[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__);

(statearr_70012[(1)] = (1));

return statearr_70012;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1 = (function (state_69991){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70013){var ex__2749__auto__ = e70013;
var statearr_70014_70030 = state_69991;
(statearr_70014_70030[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69991[(4)]))){
var statearr_70015_70031 = state_69991;
(statearr_70015_70031[(1)] = cljs.core.first.call(null,(state_69991[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70032 = state_69991;
state_69991 = G__70032;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = function(state_69991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1.call(this,state_69991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70016 = f__2769__auto__.call(null);
(statearr_70016[(6)] = c__2768__auto__);

return statearr_70016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70059){
var state_val_70060 = (state_70059[(1)]);
if((state_val_70060 === (7))){
var state_70059__$1 = state_70059;
var statearr_70061_70080 = state_70059__$1;
(statearr_70061_70080[(2)] = x);

(statearr_70061_70080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70060 === (1))){
var state_70059__$1 = state_70059;
var statearr_70062_70081 = state_70059__$1;
(statearr_70062_70081[(2)] = null);

(statearr_70062_70081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70060 === (4))){
var inst_70033 = (state_70059[(2)]);
var state_70059__$1 = state_70059;
var statearr_70063_70082 = state_70059__$1;
(statearr_70063_70082[(2)] = inst_70033);

(statearr_70063_70082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70060 === (6))){
var state_70059__$1 = state_70059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70059__$1,(9),x);
} else {
if((state_val_70060 === (3))){
var inst_70057 = (state_70059[(2)]);
var state_70059__$1 = state_70059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70059__$1,inst_70057);
} else {
if((state_val_70060 === (2))){
var _ = (function (){var statearr_70065 = state_70059;
(statearr_70065[(4)] = cljs.core.cons.call(null,(5),(state_70059[(4)])));

return statearr_70065;
})();
var inst_70039 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_70059__$1 = state_70059;
if(inst_70039){
var statearr_70066_70083 = state_70059__$1;
(statearr_70066_70083[(1)] = (6));

} else {
var statearr_70067_70084 = state_70059__$1;
(statearr_70067_70084[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70060 === (9))){
var inst_70042 = (state_70059[(2)]);
var inst_70043 = fluree.db.util.async.throw_err.call(null,inst_70042);
var state_70059__$1 = state_70059;
var statearr_70068_70085 = state_70059__$1;
(statearr_70068_70085[(2)] = inst_70043);

(statearr_70068_70085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70060 === (5))){
var _ = (function (){var statearr_70069 = state_70059;
(statearr_70069[(4)] = cljs.core.rest.call(null,(state_70059[(4)])));

return statearr_70069;
})();
var state_70059__$1 = state_70059;
var ex70064 = (state_70059__$1[(2)]);
var statearr_70070_70086 = state_70059__$1;
(statearr_70070_70086[(5)] = ex70064);


if((ex70064 instanceof Error)){
var statearr_70071_70087 = state_70059__$1;
(statearr_70071_70087[(1)] = (4));

(statearr_70071_70087[(5)] = null);

} else {
throw ex70064;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70060 === (8))){
var inst_70046 = (state_70059[(2)]);
var inst_70047 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_70046);
var inst_70048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70049 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70050 = ["boolean",inst_70046,inst_70047];
var inst_70051 = cljs.core.PersistentHashMap.fromArrays(inst_70049,inst_70050);
var inst_70052 = [inst_70051,(10)];
var inst_70053 = (new cljs.core.PersistentVector(null,2,(5),inst_70048,inst_70052,null));
var inst_70054 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70053);
var _ = (function (){var statearr_70072 = state_70059;
(statearr_70072[(4)] = cljs.core.rest.call(null,(state_70059[(4)])));

return statearr_70072;
})();
var state_70059__$1 = (function (){var statearr_70073 = state_70059;
(statearr_70073[(7)] = inst_70054);

return statearr_70073;
})();
var statearr_70074_70088 = state_70059__$1;
(statearr_70074_70088[(2)] = inst_70047);

(statearr_70074_70088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0 = (function (){
var statearr_70075 = [null,null,null,null,null,null,null,null];
(statearr_70075[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__);

(statearr_70075[(1)] = (1));

return statearr_70075;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1 = (function (state_70059){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70076){var ex__2749__auto__ = e70076;
var statearr_70077_70089 = state_70059;
(statearr_70077_70089[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70059[(4)]))){
var statearr_70078_70090 = state_70059;
(statearr_70078_70090[(1)] = cljs.core.first.call(null,(state_70059[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70091 = state_70059;
state_70059 = G__70091;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = function(state_70059){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1.call(this,state_70059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70079 = f__2769__auto__.call(null);
(statearr_70079[(6)] = c__2768__auto__);

return statearr_70079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70129){
var state_val_70130 = (state_70129[(1)]);
if((state_val_70130 === (7))){
var state_70129__$1 = state_70129;
var statearr_70131_70155 = state_70129__$1;
(statearr_70131_70155[(2)] = pattern);

(statearr_70131_70155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (1))){
var state_70129__$1 = state_70129;
var statearr_70132_70156 = state_70129__$1;
(statearr_70132_70156[(2)] = null);

(statearr_70132_70156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (4))){
var inst_70092 = (state_70129[(2)]);
var state_70129__$1 = state_70129;
var statearr_70133_70157 = state_70129__$1;
(statearr_70133_70157[(2)] = inst_70092);

(statearr_70133_70157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (13))){
var inst_70109 = (state_70129[(2)]);
var inst_70110 = fluree.db.util.async.throw_err.call(null,inst_70109);
var state_70129__$1 = state_70129;
var statearr_70134_70158 = state_70129__$1;
(statearr_70134_70158[(2)] = inst_70110);

(statearr_70134_70158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (6))){
var state_70129__$1 = state_70129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70129__$1,(9),pattern);
} else {
if((state_val_70130 === (3))){
var inst_70127 = (state_70129[(2)]);
var state_70129__$1 = state_70129;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70129__$1,inst_70127);
} else {
if((state_val_70130 === (12))){
var inst_70105 = (state_70129[(7)]);
var inst_70113 = (state_70129[(2)]);
var inst_70114 = fluree.db.dbfunctions.internal.re_find.call(null,inst_70105,inst_70113);
var inst_70115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70116 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70118 = [inst_70105,inst_70113];
var inst_70119 = (new cljs.core.PersistentVector(null,2,(5),inst_70117,inst_70118,null));
var inst_70120 = ["re-find",inst_70119,inst_70114];
var inst_70121 = cljs.core.PersistentHashMap.fromArrays(inst_70116,inst_70120);
var inst_70122 = [inst_70121,(10)];
var inst_70123 = (new cljs.core.PersistentVector(null,2,(5),inst_70115,inst_70122,null));
var inst_70124 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70123);
var _ = (function (){var statearr_70135 = state_70129;
(statearr_70135[(4)] = cljs.core.rest.call(null,(state_70129[(4)])));

return statearr_70135;
})();
var state_70129__$1 = (function (){var statearr_70136 = state_70129;
(statearr_70136[(8)] = inst_70124);

return statearr_70136;
})();
var statearr_70137_70159 = state_70129__$1;
(statearr_70137_70159[(2)] = inst_70114);

(statearr_70137_70159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (2))){
var _ = (function (){var statearr_70138 = state_70129;
(statearr_70138[(4)] = cljs.core.cons.call(null,(5),(state_70129[(4)])));

return statearr_70138;
})();
var inst_70098 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_70129__$1 = state_70129;
if(inst_70098){
var statearr_70139_70160 = state_70129__$1;
(statearr_70139_70160[(1)] = (6));

} else {
var statearr_70140_70161 = state_70129__$1;
(statearr_70140_70161[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (11))){
var state_70129__$1 = state_70129;
var statearr_70142_70162 = state_70129__$1;
(statearr_70142_70162[(2)] = string);

(statearr_70142_70162[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (9))){
var inst_70101 = (state_70129[(2)]);
var inst_70102 = fluree.db.util.async.throw_err.call(null,inst_70101);
var state_70129__$1 = state_70129;
var statearr_70143_70163 = state_70129__$1;
(statearr_70143_70163[(2)] = inst_70102);

(statearr_70143_70163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (5))){
var _ = (function (){var statearr_70144 = state_70129;
(statearr_70144[(4)] = cljs.core.rest.call(null,(state_70129[(4)])));

return statearr_70144;
})();
var state_70129__$1 = state_70129;
var ex70141 = (state_70129__$1[(2)]);
var statearr_70145_70164 = state_70129__$1;
(statearr_70145_70164[(5)] = ex70141);


if((ex70141 instanceof Error)){
var statearr_70146_70165 = state_70129__$1;
(statearr_70146_70165[(1)] = (4));

(statearr_70146_70165[(5)] = null);

} else {
throw ex70141;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70130 === (10))){
var state_70129__$1 = state_70129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70129__$1,(13),string);
} else {
if((state_val_70130 === (8))){
var inst_70105 = (state_70129[(2)]);
var inst_70106 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_70129__$1 = (function (){var statearr_70147 = state_70129;
(statearr_70147[(7)] = inst_70105);

return statearr_70147;
})();
if(inst_70106){
var statearr_70148_70166 = state_70129__$1;
(statearr_70148_70166[(1)] = (10));

} else {
var statearr_70149_70167 = state_70129__$1;
(statearr_70149_70167[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0 = (function (){
var statearr_70150 = [null,null,null,null,null,null,null,null,null];
(statearr_70150[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__);

(statearr_70150[(1)] = (1));

return statearr_70150;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1 = (function (state_70129){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70151){var ex__2749__auto__ = e70151;
var statearr_70152_70168 = state_70129;
(statearr_70152_70168[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70129[(4)]))){
var statearr_70153_70169 = state_70129;
(statearr_70153_70169[(1)] = cljs.core.first.call(null,(state_70129[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70170 = state_70129;
state_70129 = G__70170;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = function(state_70129){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1.call(this,state_70129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70154 = f__2769__auto__.call(null);
(statearr_70154[(6)] = c__2768__auto__);

return statearr_70154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70197){
var state_val_70198 = (state_70197[(1)]);
if((state_val_70198 === (7))){
var state_70197__$1 = state_70197;
var statearr_70199_70218 = state_70197__$1;
(statearr_70199_70218[(2)] = email);

(statearr_70199_70218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70198 === (1))){
var state_70197__$1 = state_70197;
var statearr_70200_70219 = state_70197__$1;
(statearr_70200_70219[(2)] = null);

(statearr_70200_70219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70198 === (4))){
var inst_70171 = (state_70197[(2)]);
var state_70197__$1 = state_70197;
var statearr_70201_70220 = state_70197__$1;
(statearr_70201_70220[(2)] = inst_70171);

(statearr_70201_70220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70198 === (6))){
var state_70197__$1 = state_70197;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70197__$1,(9),email);
} else {
if((state_val_70198 === (3))){
var inst_70195 = (state_70197[(2)]);
var state_70197__$1 = state_70197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70197__$1,inst_70195);
} else {
if((state_val_70198 === (2))){
var _ = (function (){var statearr_70203 = state_70197;
(statearr_70203[(4)] = cljs.core.cons.call(null,(5),(state_70197[(4)])));

return statearr_70203;
})();
var inst_70177 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_70197__$1 = state_70197;
if(inst_70177){
var statearr_70204_70221 = state_70197__$1;
(statearr_70204_70221[(1)] = (6));

} else {
var statearr_70205_70222 = state_70197__$1;
(statearr_70205_70222[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70198 === (9))){
var inst_70180 = (state_70197[(2)]);
var inst_70181 = fluree.db.util.async.throw_err.call(null,inst_70180);
var state_70197__$1 = state_70197;
var statearr_70206_70223 = state_70197__$1;
(statearr_70206_70223[(2)] = inst_70181);

(statearr_70206_70223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70198 === (5))){
var _ = (function (){var statearr_70207 = state_70197;
(statearr_70207[(4)] = cljs.core.rest.call(null,(state_70197[(4)])));

return statearr_70207;
})();
var state_70197__$1 = state_70197;
var ex70202 = (state_70197__$1[(2)]);
var statearr_70208_70224 = state_70197__$1;
(statearr_70208_70224[(5)] = ex70202);


if((ex70202 instanceof Error)){
var statearr_70209_70225 = state_70197__$1;
(statearr_70209_70225[(1)] = (4));

(statearr_70209_70225[(5)] = null);

} else {
throw ex70202;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70198 === (8))){
var inst_70184 = (state_70197[(2)]);
var inst_70185 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_70184);
var inst_70186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70187 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70188 = ["re-find",inst_70184,inst_70185];
var inst_70189 = cljs.core.PersistentHashMap.fromArrays(inst_70187,inst_70188);
var inst_70190 = [inst_70189,(10)];
var inst_70191 = (new cljs.core.PersistentVector(null,2,(5),inst_70186,inst_70190,null));
var inst_70192 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70191);
var _ = (function (){var statearr_70210 = state_70197;
(statearr_70210[(4)] = cljs.core.rest.call(null,(state_70197[(4)])));

return statearr_70210;
})();
var state_70197__$1 = (function (){var statearr_70211 = state_70197;
(statearr_70211[(7)] = inst_70192);

return statearr_70211;
})();
var statearr_70212_70226 = state_70197__$1;
(statearr_70212_70226[(2)] = inst_70185);

(statearr_70212_70226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_70213 = [null,null,null,null,null,null,null,null];
(statearr_70213[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__);

(statearr_70213[(1)] = (1));

return statearr_70213;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1 = (function (state_70197){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70214){var ex__2749__auto__ = e70214;
var statearr_70215_70227 = state_70197;
(statearr_70215_70227[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70197[(4)]))){
var statearr_70216_70228 = state_70197;
(statearr_70216_70228[(1)] = cljs.core.first.call(null,(state_70197[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70229 = state_70197;
state_70197 = G__70229;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = function(state_70197){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1.call(this,state_70197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70217 = f__2769__auto__.call(null);
(statearr_70217[(6)] = c__2768__auto__);

return statearr_70217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70276){
var state_val_70277 = (state_70276[(1)]);
if((state_val_70277 === (7))){
var inst_70246 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70276__$1 = state_70276;
if(cljs.core.truth_(inst_70246)){
var statearr_70278_70305 = state_70276__$1;
(statearr_70278_70305[(1)] = (9));

} else {
var statearr_70279_70306 = state_70276__$1;
(statearr_70279_70306[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (1))){
var state_70276__$1 = state_70276;
var statearr_70280_70307 = state_70276__$1;
(statearr_70280_70307[(2)] = null);

(statearr_70280_70307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (4))){
var inst_70230 = (state_70276[(2)]);
var state_70276__$1 = state_70276;
var statearr_70281_70308 = state_70276__$1;
(statearr_70281_70308[(2)] = inst_70230);

(statearr_70281_70308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (15))){
var inst_70257 = (state_70276[(2)]);
var state_70276__$1 = state_70276;
var statearr_70282_70309 = state_70276__$1;
(statearr_70282_70309[(2)] = inst_70257);

(statearr_70282_70309[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (13))){
var inst_70254 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_70276__$1 = state_70276;
var statearr_70283_70310 = state_70276__$1;
(statearr_70283_70310[(2)] = inst_70254);

(statearr_70283_70310[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (6))){
var inst_70241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70242 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_70243 = [inst_70242,(0)];
var inst_70244 = (new cljs.core.PersistentVector(null,2,(5),inst_70241,inst_70243,null));
var state_70276__$1 = state_70276;
var statearr_70284_70311 = state_70276__$1;
(statearr_70284_70311[(2)] = inst_70244);

(statearr_70284_70311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (3))){
var inst_70274 = (state_70276[(2)]);
var state_70276__$1 = state_70276;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70276__$1,inst_70274);
} else {
if((state_val_70277 === (12))){
var inst_70250 = (state_70276[(2)]);
var inst_70251 = fluree.db.util.async.throw_err.call(null,inst_70250);
var state_70276__$1 = state_70276;
var statearr_70285_70312 = state_70276__$1;
(statearr_70285_70312[(2)] = inst_70251);

(statearr_70285_70312[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (2))){
var _ = (function (){var statearr_70286 = state_70276;
(statearr_70286[(4)] = cljs.core.cons.call(null,(5),(state_70276[(4)])));

return statearr_70286;
})();
var inst_70239 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70276__$1 = state_70276;
if(cljs.core.truth_(inst_70239)){
var statearr_70287_70313 = state_70276__$1;
(statearr_70287_70313[(1)] = (6));

} else {
var statearr_70288_70314 = state_70276__$1;
(statearr_70288_70314[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (11))){
var inst_70259 = (state_70276[(2)]);
var state_70276__$1 = state_70276;
var statearr_70290_70315 = state_70276__$1;
(statearr_70290_70315[(2)] = inst_70259);

(statearr_70290_70315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (9))){
var inst_70248 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_70276__$1 = state_70276;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70276__$1,(12),inst_70248);
} else {
if((state_val_70277 === (5))){
var _ = (function (){var statearr_70291 = state_70276;
(statearr_70291[(4)] = cljs.core.rest.call(null,(state_70276[(4)])));

return statearr_70291;
})();
var state_70276__$1 = state_70276;
var ex70289 = (state_70276__$1[(2)]);
var statearr_70292_70316 = state_70276__$1;
(statearr_70292_70316[(5)] = ex70289);


if((ex70289 instanceof Error)){
var statearr_70293_70317 = state_70276__$1;
(statearr_70293_70317[(1)] = (4));

(statearr_70293_70317[(5)] = null);

} else {
throw ex70289;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (14))){
var state_70276__$1 = state_70276;
var statearr_70294_70318 = state_70276__$1;
(statearr_70294_70318[(2)] = null);

(statearr_70294_70318[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (10))){
var state_70276__$1 = state_70276;
var statearr_70295_70319 = state_70276__$1;
(statearr_70295_70319[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (8))){
var inst_70261 = (state_70276[(2)]);
var inst_70262 = cljs.core.nth.call(null,inst_70261,(0),null);
var inst_70263 = cljs.core.nth.call(null,inst_70261,(1),null);
var inst_70264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70265 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70266 = ["?user_id","?ctx",inst_70262];
var inst_70267 = cljs.core.PersistentHashMap.fromArrays(inst_70265,inst_70266);
var inst_70268 = ((10) + inst_70263);
var inst_70269 = [inst_70267,inst_70268];
var inst_70270 = (new cljs.core.PersistentVector(null,2,(5),inst_70264,inst_70269,null));
var inst_70271 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70270);
var _ = (function (){var statearr_70297 = state_70276;
(statearr_70297[(4)] = cljs.core.rest.call(null,(state_70276[(4)])));

return statearr_70297;
})();
var state_70276__$1 = (function (){var statearr_70298 = state_70276;
(statearr_70298[(7)] = inst_70271);

return statearr_70298;
})();
var statearr_70299_70320 = state_70276__$1;
(statearr_70299_70320[(2)] = inst_70262);

(statearr_70299_70320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0 = (function (){
var statearr_70300 = [null,null,null,null,null,null,null,null];
(statearr_70300[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__);

(statearr_70300[(1)] = (1));

return statearr_70300;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1 = (function (state_70276){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70276);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70301){var ex__2749__auto__ = e70301;
var statearr_70302_70321 = state_70276;
(statearr_70302_70321[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70276[(4)]))){
var statearr_70303_70322 = state_70276;
(statearr_70303_70322[(1)] = cljs.core.first.call(null,(state_70276[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70323 = state_70276;
state_70276 = G__70323;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = function(state_70276){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1.call(this,state_70276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70304 = f__2769__auto__.call(null);
(statearr_70304[(6)] = c__2768__auto__);

return statearr_70304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70351){
var state_val_70352 = (state_70351[(1)]);
if((state_val_70352 === (7))){
var inst_70344 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_70351__$1 = state_70351;
var statearr_70353_70372 = state_70351__$1;
(statearr_70353_70372[(2)] = inst_70344);

(statearr_70353_70372[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70352 === (1))){
var state_70351__$1 = state_70351;
var statearr_70354_70373 = state_70351__$1;
(statearr_70354_70373[(2)] = null);

(statearr_70354_70373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70352 === (4))){
var inst_70324 = (state_70351[(2)]);
var state_70351__$1 = state_70351;
var statearr_70355_70374 = state_70351__$1;
(statearr_70355_70374[(2)] = inst_70324);

(statearr_70355_70374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70352 === (6))){
var inst_70332 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_70351__$1 = state_70351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70351__$1,(9),inst_70332);
} else {
if((state_val_70352 === (3))){
var inst_70349 = (state_70351[(2)]);
var state_70351__$1 = state_70351;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70351__$1,inst_70349);
} else {
if((state_val_70352 === (2))){
var _ = (function (){var statearr_70357 = state_70351;
(statearr_70357[(4)] = cljs.core.cons.call(null,(5),(state_70351[(4)])));

return statearr_70357;
})();
var inst_70330 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70351__$1 = state_70351;
if(cljs.core.truth_(inst_70330)){
var statearr_70358_70375 = state_70351__$1;
(statearr_70358_70375[(1)] = (6));

} else {
var statearr_70359_70376 = state_70351__$1;
(statearr_70359_70376[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70352 === (9))){
var inst_70334 = (state_70351[(2)]);
var inst_70335 = fluree.db.util.async.throw_err.call(null,inst_70334);
var inst_70336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70337 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70338 = ["?auth_id","?ctx",inst_70335];
var inst_70339 = cljs.core.PersistentHashMap.fromArrays(inst_70337,inst_70338);
var inst_70340 = [inst_70339,(10)];
var inst_70341 = (new cljs.core.PersistentVector(null,2,(5),inst_70336,inst_70340,null));
var inst_70342 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70341);
var state_70351__$1 = (function (){var statearr_70360 = state_70351;
(statearr_70360[(7)] = inst_70342);

return statearr_70360;
})();
var statearr_70361_70377 = state_70351__$1;
(statearr_70361_70377[(2)] = inst_70335);

(statearr_70361_70377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70352 === (5))){
var _ = (function (){var statearr_70362 = state_70351;
(statearr_70362[(4)] = cljs.core.rest.call(null,(state_70351[(4)])));

return statearr_70362;
})();
var state_70351__$1 = state_70351;
var ex70356 = (state_70351__$1[(2)]);
var statearr_70363_70378 = state_70351__$1;
(statearr_70363_70378[(5)] = ex70356);


if((ex70356 instanceof Error)){
var statearr_70364_70379 = state_70351__$1;
(statearr_70364_70379[(1)] = (4));

(statearr_70364_70379[(5)] = null);

} else {
throw ex70356;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70352 === (8))){
var inst_70346 = (state_70351[(2)]);
var _ = (function (){var statearr_70365 = state_70351;
(statearr_70365[(4)] = cljs.core.rest.call(null,(state_70351[(4)])));

return statearr_70365;
})();
var state_70351__$1 = state_70351;
var statearr_70366_70380 = state_70351__$1;
(statearr_70366_70380[(2)] = inst_70346);

(statearr_70366_70380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_70367 = [null,null,null,null,null,null,null,null];
(statearr_70367[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_70367[(1)] = (1));

return statearr_70367;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_70351){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70351);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70368){var ex__2749__auto__ = e70368;
var statearr_70369_70381 = state_70351;
(statearr_70369_70381[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70351[(4)]))){
var statearr_70370_70382 = state_70351;
(statearr_70370_70382[(1)] = cljs.core.first.call(null,(state_70351[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70383 = state_70351;
state_70351 = G__70383;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_70351){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_70351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70371 = f__2769__auto__.call(null);
(statearr_70371[(6)] = c__2768__auto__);

return statearr_70371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__70385 = arguments.length;
switch (G__70385) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70427){
var state_val_70428 = (state_70427[(1)]);
if((state_val_70428 === (7))){
var state_70427__$1 = state_70427;
var statearr_70429_70459 = state_70427__$1;
(statearr_70429_70459[(2)] = seed);

(statearr_70429_70459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (1))){
var state_70427__$1 = state_70427;
var statearr_70430_70460 = state_70427__$1;
(statearr_70430_70460[(2)] = null);

(statearr_70430_70460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (4))){
var inst_70386 = (state_70427[(2)]);
var state_70427__$1 = state_70427;
var statearr_70431_70461 = state_70427__$1;
(statearr_70431_70461[(2)] = inst_70386);

(statearr_70431_70461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (15))){
var state_70427__$1 = state_70427;
var statearr_70432_70462 = state_70427__$1;
(statearr_70432_70462[(2)] = (10));

(statearr_70432_70462[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (13))){
var inst_70403 = (state_70427[(2)]);
var inst_70404 = fluree.db.util.async.throw_err.call(null,inst_70403);
var state_70427__$1 = state_70427;
var statearr_70433_70463 = state_70427__$1;
(statearr_70433_70463[(2)] = inst_70404);

(statearr_70433_70463[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (6))){
var state_70427__$1 = state_70427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70427__$1,(9),seed);
} else {
if((state_val_70428 === (3))){
var inst_70425 = (state_70427[(2)]);
var state_70427__$1 = state_70427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70427__$1,inst_70425);
} else {
if((state_val_70428 === (12))){
var inst_70407 = (state_70427[(7)]);
var inst_70407__$1 = (state_70427[(2)]);
var state_70427__$1 = (function (){var statearr_70434 = state_70427;
(statearr_70434[(7)] = inst_70407__$1);

return statearr_70434;
})();
if(cljs.core.truth_(inst_70407__$1)){
var statearr_70435_70464 = state_70427__$1;
(statearr_70435_70464[(1)] = (14));

} else {
var statearr_70436_70465 = state_70427__$1;
(statearr_70436_70465[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (2))){
var _ = (function (){var statearr_70437 = state_70427;
(statearr_70437[(4)] = cljs.core.cons.call(null,(5),(state_70427[(4)])));

return statearr_70437;
})();
var inst_70392 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_70427__$1 = state_70427;
if(inst_70392){
var statearr_70438_70466 = state_70427__$1;
(statearr_70438_70466[(1)] = (6));

} else {
var statearr_70439_70467 = state_70427__$1;
(statearr_70439_70467[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (11))){
var state_70427__$1 = state_70427;
var statearr_70441_70468 = state_70427__$1;
(statearr_70441_70468[(2)] = max);

(statearr_70441_70468[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (9))){
var inst_70395 = (state_70427[(2)]);
var inst_70396 = fluree.db.util.async.throw_err.call(null,inst_70395);
var state_70427__$1 = state_70427;
var statearr_70442_70469 = state_70427__$1;
(statearr_70442_70469[(2)] = inst_70396);

(statearr_70442_70469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (5))){
var _ = (function (){var statearr_70443 = state_70427;
(statearr_70443[(4)] = cljs.core.rest.call(null,(state_70427[(4)])));

return statearr_70443;
})();
var state_70427__$1 = state_70427;
var ex70440 = (state_70427__$1[(2)]);
var statearr_70444_70470 = state_70427__$1;
(statearr_70444_70470[(5)] = ex70440);


if((ex70440 instanceof Error)){
var statearr_70445_70471 = state_70427__$1;
(statearr_70445_70471[(1)] = (4));

(statearr_70445_70471[(5)] = null);

} else {
throw ex70440;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (14))){
var inst_70407 = (state_70427[(7)]);
var state_70427__$1 = state_70427;
var statearr_70446_70472 = state_70427__$1;
(statearr_70446_70472[(2)] = inst_70407);

(statearr_70446_70472[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (16))){
var inst_70399 = (state_70427[(8)]);
var inst_70411 = (state_70427[(2)]);
var inst_70412 = fluree.db.dbfunctions.internal.rand.call(null,inst_70399,inst_70411);
var inst_70413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70414 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70416 = [max,seed];
var inst_70417 = (new cljs.core.PersistentVector(null,2,(5),inst_70415,inst_70416,null));
var inst_70418 = ["rand",inst_70417,inst_70412];
var inst_70419 = cljs.core.PersistentHashMap.fromArrays(inst_70414,inst_70418);
var inst_70420 = [inst_70419,(10)];
var inst_70421 = (new cljs.core.PersistentVector(null,2,(5),inst_70413,inst_70420,null));
var inst_70422 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70421);
var _ = (function (){var statearr_70447 = state_70427;
(statearr_70447[(4)] = cljs.core.rest.call(null,(state_70427[(4)])));

return statearr_70447;
})();
var state_70427__$1 = (function (){var statearr_70448 = state_70427;
(statearr_70448[(9)] = inst_70422);

return statearr_70448;
})();
var statearr_70449_70473 = state_70427__$1;
(statearr_70449_70473[(2)] = inst_70412);

(statearr_70449_70473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70428 === (10))){
var state_70427__$1 = state_70427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70427__$1,(13),max);
} else {
if((state_val_70428 === (8))){
var inst_70399 = (state_70427[(2)]);
var inst_70400 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_70427__$1 = (function (){var statearr_70450 = state_70427;
(statearr_70450[(8)] = inst_70399);

return statearr_70450;
})();
if(inst_70400){
var statearr_70451_70474 = state_70427__$1;
(statearr_70451_70474[(1)] = (10));

} else {
var statearr_70452_70475 = state_70427__$1;
(statearr_70452_70475[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_70453 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70453[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_70453[(1)] = (1));

return statearr_70453;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_70427){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70454){var ex__2749__auto__ = e70454;
var statearr_70455_70476 = state_70427;
(statearr_70455_70476[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70427[(4)]))){
var statearr_70456_70477 = state_70427;
(statearr_70456_70477[(1)] = cljs.core.first.call(null,(state_70427[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70478 = state_70427;
state_70427 = G__70478;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_70427){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_70427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70457 = f__2769__auto__.call(null);
(statearr_70457[(6)] = c__2768__auto__);

return statearr_70457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70499){
var state_val_70500 = (state_70499[(1)]);
if((state_val_70500 === (1))){
var state_70499__$1 = state_70499;
var statearr_70501_70516 = state_70499__$1;
(statearr_70501_70516[(2)] = null);

(statearr_70501_70516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70500 === (2))){
var _ = (function (){var statearr_70502 = state_70499;
(statearr_70502[(4)] = cljs.core.cons.call(null,(5),(state_70499[(4)])));

return statearr_70502;
})();
var inst_70485 = cljs.core.random_uuid.call(null);
var inst_70486 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70485);
var inst_70487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70488 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70489 = cljs.core.PersistentVector.EMPTY;
var inst_70490 = ["uuid",inst_70489,inst_70486];
var inst_70491 = cljs.core.PersistentHashMap.fromArrays(inst_70488,inst_70490);
var inst_70492 = [inst_70491,(10)];
var inst_70493 = (new cljs.core.PersistentVector(null,2,(5),inst_70487,inst_70492,null));
var inst_70494 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70493);
var ___$1 = (function (){var statearr_70503 = state_70499;
(statearr_70503[(4)] = cljs.core.rest.call(null,(state_70499[(4)])));

return statearr_70503;
})();
var state_70499__$1 = (function (){var statearr_70504 = state_70499;
(statearr_70504[(7)] = inst_70494);

return statearr_70504;
})();
var statearr_70505_70517 = state_70499__$1;
(statearr_70505_70517[(2)] = inst_70486);

(statearr_70505_70517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70500 === (3))){
var inst_70497 = (state_70499[(2)]);
var state_70499__$1 = state_70499;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70499__$1,inst_70497);
} else {
if((state_val_70500 === (4))){
var inst_70479 = (state_70499[(2)]);
var state_70499__$1 = state_70499;
var statearr_70507_70518 = state_70499__$1;
(statearr_70507_70518[(2)] = inst_70479);

(statearr_70507_70518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70500 === (5))){
var _ = (function (){var statearr_70508 = state_70499;
(statearr_70508[(4)] = cljs.core.rest.call(null,(state_70499[(4)])));

return statearr_70508;
})();
var state_70499__$1 = state_70499;
var ex70506 = (state_70499__$1[(2)]);
var statearr_70509_70519 = state_70499__$1;
(statearr_70509_70519[(5)] = ex70506);


if((ex70506 instanceof Error)){
var statearr_70510_70520 = state_70499__$1;
(statearr_70510_70520[(1)] = (4));

(statearr_70510_70520[(5)] = null);

} else {
throw ex70506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0 = (function (){
var statearr_70511 = [null,null,null,null,null,null,null,null];
(statearr_70511[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__);

(statearr_70511[(1)] = (1));

return statearr_70511;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1 = (function (state_70499){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70512){var ex__2749__auto__ = e70512;
var statearr_70513_70521 = state_70499;
(statearr_70513_70521[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70499[(4)]))){
var statearr_70514_70522 = state_70499;
(statearr_70514_70522[(1)] = cljs.core.first.call(null,(state_70499[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70523 = state_70499;
state_70499 = G__70523;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = function(state_70499){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1.call(this,state_70499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70515 = f__2769__auto__.call(null);
(statearr_70515[(6)] = c__2768__auto__);

return statearr_70515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70553){
var state_val_70554 = (state_70553[(1)]);
if((state_val_70554 === (7))){
var state_70553__$1 = state_70553;
var statearr_70555_70574 = state_70553__$1;
(statearr_70555_70574[(2)] = num);

(statearr_70555_70574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (1))){
var state_70553__$1 = state_70553;
var statearr_70556_70575 = state_70553__$1;
(statearr_70556_70575[(2)] = null);

(statearr_70556_70575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (4))){
var inst_70524 = (state_70553[(2)]);
var state_70553__$1 = state_70553;
var statearr_70557_70576 = state_70553__$1;
(statearr_70557_70576[(2)] = inst_70524);

(statearr_70557_70576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (6))){
var state_70553__$1 = state_70553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70553__$1,(9),num);
} else {
if((state_val_70554 === (3))){
var inst_70551 = (state_70553[(2)]);
var state_70553__$1 = state_70553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70553__$1,inst_70551);
} else {
if((state_val_70554 === (2))){
var _ = (function (){var statearr_70559 = state_70553;
(statearr_70559[(4)] = cljs.core.cons.call(null,(5),(state_70553[(4)])));

return statearr_70559;
})();
var inst_70530 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_70553__$1 = state_70553;
if(inst_70530){
var statearr_70560_70577 = state_70553__$1;
(statearr_70560_70577[(1)] = (6));

} else {
var statearr_70561_70578 = state_70553__$1;
(statearr_70561_70578[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (9))){
var inst_70533 = (state_70553[(2)]);
var inst_70534 = fluree.db.util.async.throw_err.call(null,inst_70533);
var state_70553__$1 = state_70553;
var statearr_70562_70579 = state_70553__$1;
(statearr_70562_70579[(2)] = inst_70534);

(statearr_70562_70579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (5))){
var _ = (function (){var statearr_70563 = state_70553;
(statearr_70563[(4)] = cljs.core.rest.call(null,(state_70553[(4)])));

return statearr_70563;
})();
var state_70553__$1 = state_70553;
var ex70558 = (state_70553__$1[(2)]);
var statearr_70564_70580 = state_70553__$1;
(statearr_70564_70580[(5)] = ex70558);


if((ex70558 instanceof Error)){
var statearr_70565_70581 = state_70553__$1;
(statearr_70565_70581[(1)] = (4));

(statearr_70565_70581[(5)] = null);

} else {
throw ex70558;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70554 === (8))){
var inst_70537 = (state_70553[(2)]);
var inst_70538 = fluree.db.dbfunctions.internal.ceil.call(null,inst_70537);
var inst_70539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70540 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70542 = [fluree.db.dbfunctions.fns.ceil];
var inst_70543 = (new cljs.core.PersistentVector(null,1,(5),inst_70541,inst_70542,null));
var inst_70544 = ["",inst_70543,inst_70538];
var inst_70545 = cljs.core.PersistentHashMap.fromArrays(inst_70540,inst_70544);
var inst_70546 = [inst_70545,(10)];
var inst_70547 = (new cljs.core.PersistentVector(null,2,(5),inst_70539,inst_70546,null));
var inst_70548 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70547);
var _ = (function (){var statearr_70566 = state_70553;
(statearr_70566[(4)] = cljs.core.rest.call(null,(state_70553[(4)])));

return statearr_70566;
})();
var state_70553__$1 = (function (){var statearr_70567 = state_70553;
(statearr_70567[(7)] = inst_70548);

return statearr_70567;
})();
var statearr_70568_70582 = state_70553__$1;
(statearr_70568_70582[(2)] = inst_70538);

(statearr_70568_70582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0 = (function (){
var statearr_70569 = [null,null,null,null,null,null,null,null];
(statearr_70569[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__);

(statearr_70569[(1)] = (1));

return statearr_70569;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1 = (function (state_70553){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70570){var ex__2749__auto__ = e70570;
var statearr_70571_70583 = state_70553;
(statearr_70571_70583[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70553[(4)]))){
var statearr_70572_70584 = state_70553;
(statearr_70572_70584[(1)] = cljs.core.first.call(null,(state_70553[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70585 = state_70553;
state_70553 = G__70585;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = function(state_70553){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1.call(this,state_70553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70573 = f__2769__auto__.call(null);
(statearr_70573[(6)] = c__2768__auto__);

return statearr_70573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70615){
var state_val_70616 = (state_70615[(1)]);
if((state_val_70616 === (7))){
var state_70615__$1 = state_70615;
var statearr_70617_70636 = state_70615__$1;
(statearr_70617_70636[(2)] = num);

(statearr_70617_70636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70616 === (1))){
var state_70615__$1 = state_70615;
var statearr_70618_70637 = state_70615__$1;
(statearr_70618_70637[(2)] = null);

(statearr_70618_70637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70616 === (4))){
var inst_70586 = (state_70615[(2)]);
var state_70615__$1 = state_70615;
var statearr_70619_70638 = state_70615__$1;
(statearr_70619_70638[(2)] = inst_70586);

(statearr_70619_70638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70616 === (6))){
var state_70615__$1 = state_70615;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70615__$1,(9),num);
} else {
if((state_val_70616 === (3))){
var inst_70613 = (state_70615[(2)]);
var state_70615__$1 = state_70615;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70615__$1,inst_70613);
} else {
if((state_val_70616 === (2))){
var _ = (function (){var statearr_70621 = state_70615;
(statearr_70621[(4)] = cljs.core.cons.call(null,(5),(state_70615[(4)])));

return statearr_70621;
})();
var inst_70592 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_70615__$1 = state_70615;
if(inst_70592){
var statearr_70622_70639 = state_70615__$1;
(statearr_70622_70639[(1)] = (6));

} else {
var statearr_70623_70640 = state_70615__$1;
(statearr_70623_70640[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70616 === (9))){
var inst_70595 = (state_70615[(2)]);
var inst_70596 = fluree.db.util.async.throw_err.call(null,inst_70595);
var state_70615__$1 = state_70615;
var statearr_70624_70641 = state_70615__$1;
(statearr_70624_70641[(2)] = inst_70596);

(statearr_70624_70641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70616 === (5))){
var _ = (function (){var statearr_70625 = state_70615;
(statearr_70625[(4)] = cljs.core.rest.call(null,(state_70615[(4)])));

return statearr_70625;
})();
var state_70615__$1 = state_70615;
var ex70620 = (state_70615__$1[(2)]);
var statearr_70626_70642 = state_70615__$1;
(statearr_70626_70642[(5)] = ex70620);


if((ex70620 instanceof Error)){
var statearr_70627_70643 = state_70615__$1;
(statearr_70627_70643[(1)] = (4));

(statearr_70627_70643[(5)] = null);

} else {
throw ex70620;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70616 === (8))){
var inst_70599 = (state_70615[(2)]);
var inst_70600 = fluree.db.dbfunctions.internal.floor.call(null,inst_70599);
var inst_70601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70602 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70604 = [fluree.db.dbfunctions.fns.floor];
var inst_70605 = (new cljs.core.PersistentVector(null,1,(5),inst_70603,inst_70604,null));
var inst_70606 = ["",inst_70605,inst_70600];
var inst_70607 = cljs.core.PersistentHashMap.fromArrays(inst_70602,inst_70606);
var inst_70608 = [inst_70607,(10)];
var inst_70609 = (new cljs.core.PersistentVector(null,2,(5),inst_70601,inst_70608,null));
var inst_70610 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70609);
var _ = (function (){var statearr_70628 = state_70615;
(statearr_70628[(4)] = cljs.core.rest.call(null,(state_70615[(4)])));

return statearr_70628;
})();
var state_70615__$1 = (function (){var statearr_70629 = state_70615;
(statearr_70629[(7)] = inst_70610);

return statearr_70629;
})();
var statearr_70630_70644 = state_70615__$1;
(statearr_70630_70644[(2)] = inst_70600);

(statearr_70630_70644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0 = (function (){
var statearr_70631 = [null,null,null,null,null,null,null,null];
(statearr_70631[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__);

(statearr_70631[(1)] = (1));

return statearr_70631;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1 = (function (state_70615){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70615);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70632){var ex__2749__auto__ = e70632;
var statearr_70633_70645 = state_70615;
(statearr_70633_70645[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70615[(4)]))){
var statearr_70634_70646 = state_70615;
(statearr_70634_70646[(1)] = cljs.core.first.call(null,(state_70615[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70647 = state_70615;
state_70615 = G__70647;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = function(state_70615){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1.call(this,state_70615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70635 = f__2769__auto__.call(null);
(statearr_70635[(6)] = c__2768__auto__);

return statearr_70635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70672){
var state_val_70673 = (state_70672[(1)]);
if((state_val_70673 === (1))){
var state_70672__$1 = state_70672;
var statearr_70674_70689 = state_70672__$1;
(statearr_70674_70689[(2)] = null);

(statearr_70674_70689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70673 === (2))){
var _ = (function (){var statearr_70675 = state_70672;
(statearr_70675[(4)] = cljs.core.cons.call(null,(5),(state_70672[(4)])));

return statearr_70675;
})();
var inst_70654 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_70672__$1 = state_70672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70672__$1,(6),inst_70654);
} else {
if((state_val_70673 === (3))){
var inst_70670 = (state_70672[(2)]);
var state_70672__$1 = state_70672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70672__$1,inst_70670);
} else {
if((state_val_70673 === (4))){
var inst_70648 = (state_70672[(2)]);
var state_70672__$1 = state_70672;
var statearr_70677_70690 = state_70672__$1;
(statearr_70677_70690[(2)] = inst_70648);

(statearr_70677_70690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70673 === (5))){
var _ = (function (){var statearr_70678 = state_70672;
(statearr_70678[(4)] = cljs.core.rest.call(null,(state_70672[(4)])));

return statearr_70678;
})();
var state_70672__$1 = state_70672;
var ex70676 = (state_70672__$1[(2)]);
var statearr_70679_70691 = state_70672__$1;
(statearr_70679_70691[(5)] = ex70676);


if((ex70676 instanceof Error)){
var statearr_70680_70692 = state_70672__$1;
(statearr_70680_70692[(1)] = (4));

(statearr_70680_70692[(5)] = null);

} else {
throw ex70676;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70673 === (6))){
var inst_70656 = (state_70672[(2)]);
var inst_70657 = fluree.db.util.async.throw_err.call(null,inst_70656);
var inst_70658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70659 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70661 = [compare_val,new_val];
var inst_70662 = (new cljs.core.PersistentVector(null,2,(5),inst_70660,inst_70661,null));
var inst_70663 = ["",inst_70662,inst_70657];
var inst_70664 = cljs.core.PersistentHashMap.fromArrays(inst_70659,inst_70663);
var inst_70665 = [inst_70664,(10)];
var inst_70666 = (new cljs.core.PersistentVector(null,2,(5),inst_70658,inst_70665,null));
var inst_70667 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70666);
var _ = (function (){var statearr_70681 = state_70672;
(statearr_70681[(4)] = cljs.core.rest.call(null,(state_70672[(4)])));

return statearr_70681;
})();
var state_70672__$1 = (function (){var statearr_70682 = state_70672;
(statearr_70682[(7)] = inst_70667);

return statearr_70682;
})();
var statearr_70683_70693 = state_70672__$1;
(statearr_70683_70693[(2)] = inst_70657);

(statearr_70683_70693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_70684 = [null,null,null,null,null,null,null,null];
(statearr_70684[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__);

(statearr_70684[(1)] = (1));

return statearr_70684;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1 = (function (state_70672){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70685){var ex__2749__auto__ = e70685;
var statearr_70686_70694 = state_70672;
(statearr_70686_70694[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70672[(4)]))){
var statearr_70687_70695 = state_70672;
(statearr_70687_70695[(1)] = cljs.core.first.call(null,(state_70672[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70696 = state_70672;
state_70672 = G__70696;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = function(state_70672){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1.call(this,state_70672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70688 = f__2769__auto__.call(null);
(statearr_70688[(6)] = c__2768__auto__);

return statearr_70688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
