// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__19808_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19808_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19812 = coll;
var vec__19813 = G__19812;
var seq__19814 = cljs.core.seq.call(null,vec__19813);
var first__19815 = cljs.core.first.call(null,seq__19814);
var seq__19814__$1 = cljs.core.next.call(null,seq__19814);
var clause = first__19815;
var r = seq__19814__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19812__$1 = G__19812;
var res__$1 = res;
while(true){
var vec__19819 = G__19812__$1;
var seq__19820 = cljs.core.seq.call(null,vec__19819);
var first__19821 = cljs.core.first.call(null,seq__19820);
var seq__19820__$1 = cljs.core.next.call(null,seq__19820);
var clause__$1 = first__19821;
var r__$1 = seq__19820__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19822 = r__$1;
var G__19823 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19812__$1 = G__19822;
res__$1 = G__19823;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__19824){
var map__19825 = p__19824;
var map__19825__$1 = cljs.core.__destructure_map.call(null,map__19825);
var optional = cljs.core.get.call(null,map__19825__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19829 = coll;
var vec__19830 = G__19829;
var seq__19831 = cljs.core.seq.call(null,vec__19830);
var first__19832 = cljs.core.first.call(null,seq__19831);
var seq__19831__$1 = cljs.core.next.call(null,seq__19831);
var clause = first__19832;
var r = seq__19831__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19829__$1 = G__19829;
var res__$1 = res;
while(true){
var vec__19836 = G__19829__$1;
var seq__19837 = cljs.core.seq.call(null,vec__19836);
var first__19838 = cljs.core.first.call(null,seq__19837);
var seq__19837__$1 = cljs.core.next.call(null,seq__19837);
var clause__$1 = first__19838;
var r__$1 = seq__19837__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19839 = r__$1;
var G__19840 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__19829__$1 = G__19839;
res__$1 = G__19840;
continue;
} else {
var G__19841 = r__$1;
var G__19842 = res__$2;
G__19829__$1 = G__19841;
res__$1 = G__19842;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19846 = coll;
var vec__19847 = G__19846;
var seq__19848 = cljs.core.seq.call(null,vec__19847);
var first__19849 = cljs.core.first.call(null,seq__19848);
var seq__19848__$1 = cljs.core.next.call(null,seq__19848);
var clause = first__19849;
var r = seq__19848__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19846__$1 = G__19846;
var res__$1 = res;
while(true){
var vec__19853 = G__19846__$1;
var seq__19854 = cljs.core.seq.call(null,vec__19853);
var first__19855 = cljs.core.first.call(null,seq__19854);
var seq__19854__$1 = cljs.core.next.call(null,seq__19854);
var clause__$1 = first__19855;
var r__$1 = seq__19854__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19856 = r__$1;
var G__19857 = res__$2;
G__19846__$1 = G__19856;
res__$1 = G__19857;
continue;
} else {
var G__19858 = r__$1;
var G__19859 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19846__$1 = G__19858;
res__$1 = G__19859;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19862 = clause;
var G__19862__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__19862):G__19862);
var G__19862__$2 = clojure.string.join.call(null," ",G__19862__$1)
;
var G__19862__$3 = (function (p1__19860_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19860_SHARP_)," ."].join('');
}).call(null,G__19862__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__19861_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19861_SHARP_),"}"].join('');
}).call(null,G__19862__$3);
} else {
return G__19862__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__19866 = opts;
var map__19866__$1 = cljs.core.__destructure_map.call(null,map__19866);
var limit = cljs.core.get.call(null,map__19866__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__19866__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__19866__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__19866__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__19866__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__19863_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19863_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19864_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19864_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19865_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19865_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19880){
var state_val_19881 = (state_19880[(1)]);
if((state_val_19881 === (1))){
var inst_19867 = fluree.db.util.core.url_encode.call(null,query);
var inst_19868 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19867)].join('');
var inst_19869 = ["User-Agent","Accept"];
var inst_19870 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19871 = cljs.core.PersistentHashMap.fromArrays(inst_19869,inst_19870);
var inst_19872 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19873 = [inst_19871,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19874 = cljs.core.PersistentHashMap.fromArrays(inst_19872,inst_19873);
var inst_19875 = fluree.db.util.xhttp.get.call(null,inst_19868,inst_19874);
var state_19880__$1 = state_19880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19880__$1,(2),inst_19875);
} else {
if((state_val_19881 === (2))){
var inst_19877 = (state_19880[(2)]);
var inst_19878 = fluree.db.util.async.throw_err.call(null,inst_19877);
var state_19880__$1 = state_19880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19880__$1,inst_19878);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19882 = [null,null,null,null,null,null,null];
(statearr_19882[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__);

(statearr_19882[(1)] = (1));

return statearr_19882;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19880){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19883){var ex__2749__auto__ = e19883;
var statearr_19884_19887 = state_19880;
(statearr_19884_19887[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19880[(4)]))){
var statearr_19885_19888 = state_19880;
(statearr_19885_19888[(1)] = cljs.core.first.call(null,(state_19880[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19889 = state_19880;
state_19880 = G__19889;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = function(state_19880){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19886 = f__2769__auto__.call(null);
(statearr_19886[(6)] = c__2768__auto__);

return statearr_19886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19907){
var state_val_19908 = (state_19907[(1)]);
if((state_val_19908 === (1))){
var inst_19890 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_19907__$1 = state_19907;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19907__$1,(2),inst_19890);
} else {
if((state_val_19908 === (2))){
var inst_19893 = (state_19907[(7)]);
var inst_19892 = (state_19907[(2)]);
var inst_19893__$1 = fluree.db.util.async.throw_err.call(null,inst_19892);
var inst_19894 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19893__$1);
var inst_19895 = cljs.core.not_EQ_.call(null,(200),inst_19894);
var state_19907__$1 = (function (){var statearr_19909 = state_19907;
(statearr_19909[(7)] = inst_19893__$1);

return statearr_19909;
})();
if(inst_19895){
var statearr_19910_19919 = state_19907__$1;
(statearr_19910_19919[(1)] = (3));

} else {
var statearr_19911_19920 = state_19907__$1;
(statearr_19911_19920[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19908 === (3))){
var inst_19893 = (state_19907[(7)]);
var state_19907__$1 = state_19907;
var statearr_19912_19921 = state_19907__$1;
(statearr_19912_19921[(2)] = inst_19893);

(statearr_19912_19921[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19908 === (4))){
var inst_19893 = (state_19907[(7)]);
var inst_19898 = (function (){var body = inst_19893;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19899 = cljs.core.second.call(null,inst_19893);
var inst_19900 = cljs.core.second.call(null,inst_19899);
var inst_19901 = cljs.core.first.call(null,inst_19900);
var inst_19902 = cljs.core.second.call(null,inst_19901);
var inst_19903 = cljs.core.mapv.call(null,inst_19898,inst_19902);
var state_19907__$1 = state_19907;
var statearr_19913_19922 = state_19907__$1;
(statearr_19913_19922[(2)] = inst_19903);

(statearr_19913_19922[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19908 === (5))){
var inst_19905 = (state_19907[(2)]);
var state_19907__$1 = state_19907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19907__$1,inst_19905);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19914 = [null,null,null,null,null,null,null,null];
(statearr_19914[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__);

(statearr_19914[(1)] = (1));

return statearr_19914;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19907){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19915){var ex__2749__auto__ = e19915;
var statearr_19916_19923 = state_19907;
(statearr_19916_19923[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19907[(4)]))){
var statearr_19917_19924 = state_19907;
(statearr_19917_19924[(1)] = cljs.core.first.call(null,(state_19907[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19925 = state_19907;
state_19907 = G__19925;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = function(state_19907){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19918 = f__2769__auto__.call(null);
(statearr_19918[(6)] = c__2768__auto__);

return statearr_19918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__19926_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19926_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__19927_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19927_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__19928_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__19928_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19974){
var state_val_19975 = (state_19974[(1)]);
if((state_val_19975 === (7))){
var inst_19939 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_19974__$1 = state_19974;
var statearr_19976_20004 = state_19974__$1;
(statearr_19976_20004[(2)] = inst_19939);

(statearr_19976_20004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (1))){
var state_19974__$1 = state_19974;
var statearr_19977_20005 = state_19974__$1;
(statearr_19977_20005[(2)] = null);

(statearr_19977_20005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (4))){
var inst_19929 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
var statearr_19978_20006 = state_19974__$1;
(statearr_19978_20006[(2)] = inst_19929);

(statearr_19978_20006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (15))){
var inst_19947 = (state_19974[(7)]);
var inst_19948 = (state_19974[(8)]);
var inst_19953 = (state_19974[(9)]);
var inst_19958 = (state_19974[(2)]);
var inst_19959 = cljs.core.subs.call(null,inst_19953,(0),inst_19958);
var inst_19960 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19961 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_19947);
var inst_19962 = [inst_19948,inst_19961];
var inst_19963 = cljs.core.PersistentHashMap.fromArrays(inst_19960,inst_19962);
var inst_19964 = cljs.core.ex_info.call(null,inst_19959,inst_19963);
var inst_19965 = (function(){throw inst_19964})();
var state_19974__$1 = state_19974;
var statearr_19979_20007 = state_19974__$1;
(statearr_19979_20007[(2)] = inst_19965);

(statearr_19979_20007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (13))){
var inst_19952 = (state_19974[(10)]);
var state_19974__$1 = state_19974;
var statearr_19980_20008 = state_19974__$1;
(statearr_19980_20008[(2)] = inst_19952);

(statearr_19980_20008[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (6))){
var state_19974__$1 = state_19974;
var statearr_19981_20009 = state_19974__$1;
(statearr_19981_20009[(2)] = null);

(statearr_19981_20009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (3))){
var inst_19972 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19974__$1,inst_19972);
} else {
if((state_val_19975 === (12))){
var inst_19969 = (state_19974[(2)]);
var _ = (function (){var statearr_19982 = state_19974;
(statearr_19982[(4)] = cljs.core.rest.call(null,(state_19974[(4)])));

return statearr_19982;
})();
var state_19974__$1 = state_19974;
var statearr_19983_20010 = state_19974__$1;
(statearr_19983_20010[(2)] = inst_19969);

(statearr_19983_20010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (2))){
var _ = (function (){var statearr_19984 = state_19974;
(statearr_19984[(4)] = cljs.core.cons.call(null,(5),(state_19974[(4)])));

return statearr_19984;
})();
var inst_19936 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_19974__$1 = state_19974;
if(inst_19936){
var statearr_19985_20011 = state_19974__$1;
(statearr_19985_20011[(1)] = (6));

} else {
var statearr_19986_20012 = state_19974__$1;
(statearr_19986_20012[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (11))){
var inst_19947 = (state_19974[(7)]);
var inst_19967 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_19947,all_vars);
var state_19974__$1 = state_19974;
var statearr_19988_20013 = state_19974__$1;
(statearr_19988_20013[(2)] = inst_19967);

(statearr_19988_20013[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (9))){
var inst_19947 = (state_19974[(7)]);
var inst_19948 = (state_19974[(8)]);
var inst_19945 = (state_19974[(2)]);
var inst_19946 = fluree.db.util.async.throw_err.call(null,inst_19945);
var inst_19947__$1 = cljs.core.__destructure_map.call(null,inst_19946);
var inst_19948__$1 = cljs.core.get.call(null,inst_19947__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_19949 = cljs.core.get.call(null,inst_19947__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_19950 = cljs.core._EQ_.call(null,(400),inst_19948__$1);
var state_19974__$1 = (function (){var statearr_19989 = state_19974;
(statearr_19989[(7)] = inst_19947__$1);

(statearr_19989[(8)] = inst_19948__$1);

(statearr_19989[(11)] = inst_19949);

return statearr_19989;
})();
if(inst_19950){
var statearr_19990_20014 = state_19974__$1;
(statearr_19990_20014[(1)] = (10));

} else {
var statearr_19991_20015 = state_19974__$1;
(statearr_19991_20015[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (5))){
var _ = (function (){var statearr_19992 = state_19974;
(statearr_19992[(4)] = cljs.core.rest.call(null,(state_19974[(4)])));

return statearr_19992;
})();
var state_19974__$1 = state_19974;
var ex19987 = (state_19974__$1[(2)]);
var statearr_19993_20016 = state_19974__$1;
(statearr_19993_20016[(5)] = ex19987);


if((ex19987 instanceof Error)){
var statearr_19994_20017 = state_19974__$1;
(statearr_19994_20017[(1)] = (4));

(statearr_19994_20017[(5)] = null);

} else {
throw ex19987;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (14))){
var state_19974__$1 = state_19974;
var statearr_19995_20018 = state_19974__$1;
(statearr_19995_20018[(2)] = (1000));

(statearr_19995_20018[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (10))){
var inst_19947 = (state_19974[(7)]);
var inst_19952 = (state_19974[(10)]);
var inst_19949 = (state_19974[(11)]);
var inst_19952__$1 = cljs.core.count.call(null,inst_19949);
var inst_19953 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_19947);
var inst_19954 = (inst_19952__$1 < (1000));
var state_19974__$1 = (function (){var statearr_19996 = state_19974;
(statearr_19996[(10)] = inst_19952__$1);

(statearr_19996[(9)] = inst_19953);

return statearr_19996;
})();
if(cljs.core.truth_(inst_19954)){
var statearr_19997_20019 = state_19974__$1;
(statearr_19997_20019[(1)] = (13));

} else {
var statearr_19998_20020 = state_19974__$1;
(statearr_19998_20020[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (8))){
var inst_19941 = (state_19974[(2)]);
var inst_19942 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_19941,optional_clauses);
var inst_19943 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_19942);
var state_19974__$1 = state_19974;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19974__$1,(9),inst_19943);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_19999 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19999[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__);

(statearr_19999[(1)] = (1));

return statearr_19999;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1 = (function (state_19974){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20000){var ex__2749__auto__ = e20000;
var statearr_20001_20021 = state_19974;
(statearr_20001_20021[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19974[(4)]))){
var statearr_20002_20022 = state_19974;
(statearr_20002_20022[(1)] = cljs.core.first.call(null,(state_19974[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20023 = state_19974;
state_19974 = G__20023;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = function(state_19974){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1.call(this,state_19974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20003 = f__2769__auto__.call(null);
(statearr_20003[(6)] = c__2768__auto__);

return statearr_20003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
