// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21775 = arguments.length;
switch (G__21775) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21936){
var state_val_21937 = (state_21936[(1)]);
if((state_val_21937 === (7))){
var inst_21931 = (state_21936[(2)]);
var _ = (function (){var statearr_21938 = state_21936;
(statearr_21938[(4)] = cljs.core.rest.call(null,(state_21936[(4)])));

return statearr_21938;
})();
var state_21936__$1 = state_21936;
var statearr_21939_22021 = state_21936__$1;
(statearr_21939_22021[(2)] = inst_21931);

(statearr_21939_22021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (20))){
var inst_21858 = (state_21936[(7)]);
var state_21936__$1 = state_21936;
var statearr_21940_22022 = state_21936__$1;
(statearr_21940_22022[(2)] = inst_21858);

(statearr_21940_22022[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (27))){
var inst_21813 = (state_21936[(8)]);
var state_21936__$1 = state_21936;
if(cljs.core.truth_(inst_21813)){
var statearr_21941_22023 = state_21936__$1;
(statearr_21941_22023[(1)] = (29));

} else {
var statearr_21942_22024 = state_21936__$1;
(statearr_21942_22024[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (1))){
var state_21936__$1 = state_21936;
var statearr_21943_22025 = state_21936__$1;
(statearr_21943_22025[(2)] = null);

(statearr_21943_22025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (24))){
var inst_21814 = (state_21936[(9)]);
var state_21936__$1 = state_21936;
var statearr_21944_22026 = state_21936__$1;
(statearr_21944_22026[(2)] = inst_21814);

(statearr_21944_22026[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (39))){
var inst_21850 = (state_21936[(10)]);
var state_21936__$1 = state_21936;
var statearr_21945_22027 = state_21936__$1;
(statearr_21945_22027[(2)] = inst_21850);

(statearr_21945_22027[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (46))){
var inst_21815 = (state_21936[(11)]);
var state_21936__$1 = state_21936;
var statearr_21946_22028 = state_21936__$1;
(statearr_21946_22028[(2)] = inst_21815);

(statearr_21946_22028[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (4))){
var inst_21777 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_21947_22029 = state_21936__$1;
(statearr_21947_22029[(2)] = inst_21777);

(statearr_21947_22029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (15))){
var inst_21826 = (state_21936[(12)]);
var inst_21832 = cljs.core.count.call(null,inst_21826);
var inst_21833 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21832,max_fuel);
var state_21936__$1 = state_21936;
var statearr_21948_22030 = state_21936__$1;
(statearr_21948_22030[(2)] = inst_21833);

(statearr_21948_22030[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (48))){
var inst_21795 = (state_21936[(13)]);
var inst_21802 = (state_21936[(14)]);
var inst_21917 = (state_21936[(15)]);
var inst_21925 = (state_21936[(2)]);
var inst_21926 = cljs.core.assoc.call(null,inst_21795,inst_21925,inst_21917);
var inst_21794 = inst_21802;
var inst_21795__$1 = inst_21926;
var state_21936__$1 = (function (){var statearr_21949 = state_21936;
(statearr_21949[(13)] = inst_21795__$1);

(statearr_21949[(16)] = inst_21794);

return statearr_21949;
})();
var statearr_21950_22031 = state_21936__$1;
(statearr_21950_22031[(2)] = null);

(statearr_21950_22031[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (50))){
var inst_21817 = (state_21936[(17)]);
var state_21936__$1 = state_21936;
var statearr_21951_22032 = state_21936__$1;
(statearr_21951_22032[(2)] = inst_21817);

(statearr_21951_22032[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (21))){
var inst_21814 = (state_21936[(9)]);
var state_21936__$1 = state_21936;
if(cljs.core.truth_(inst_21814)){
var statearr_21953_22033 = state_21936__$1;
(statearr_21953_22033[(1)] = (23));

} else {
var statearr_21954_22034 = state_21936__$1;
(statearr_21954_22034[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (31))){
var inst_21874 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
if(cljs.core.truth_(inst_21874)){
var statearr_21955_22035 = state_21936__$1;
(statearr_21955_22035[(1)] = (32));

} else {
var statearr_21956_22036 = state_21936__$1;
(statearr_21956_22036[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (32))){
var inst_21850 = (state_21936[(10)]);
var inst_21857 = (state_21936[(18)]);
var inst_21849 = (state_21936[(19)]);
var inst_21876 = (inst_21849 + (1));
var tmp21952 = inst_21850;
var inst_21848 = inst_21857;
var inst_21849__$1 = inst_21876;
var inst_21850__$1 = tmp21952;
var state_21936__$1 = (function (){var statearr_21957 = state_21936;
(statearr_21957[(10)] = inst_21850__$1);

(statearr_21957[(20)] = inst_21848);

(statearr_21957[(19)] = inst_21849__$1);

return statearr_21957;
})();
var statearr_21958_22037 = state_21936__$1;
(statearr_21958_22037[(2)] = null);

(statearr_21958_22037[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (40))){
var state_21936__$1 = state_21936;
if(cljs.core.truth_(fuel)){
var statearr_21959_22038 = state_21936__$1;
(statearr_21959_22038[(1)] = (42));

} else {
var statearr_21960_22039 = state_21936__$1;
(statearr_21960_22039[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (33))){
var state_21936__$1 = state_21936;
var statearr_21961_22040 = state_21936__$1;
(statearr_21961_22040[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (13))){
var inst_21826 = (state_21936[(12)]);
var state_21936__$1 = state_21936;
var statearr_21963_22041 = state_21936__$1;
(statearr_21963_22041[(2)] = inst_21826);

(statearr_21963_22041[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (22))){
var inst_21867 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
if(cljs.core.truth_(inst_21867)){
var statearr_21964_22042 = state_21936__$1;
(statearr_21964_22042[(1)] = (26));

} else {
var statearr_21965_22043 = state_21936__$1;
(statearr_21965_22043[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (36))){
var state_21936__$1 = state_21936;
var statearr_21966_22044 = state_21936__$1;
(statearr_21966_22044[(2)] = null);

(statearr_21966_22044[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (41))){
var inst_21857 = (state_21936[(18)]);
var inst_21849 = (state_21936[(19)]);
var inst_21906 = (state_21936[(2)]);
var inst_21907 = (inst_21849 + (1));
var inst_21848 = inst_21857;
var inst_21849__$1 = inst_21907;
var inst_21850 = inst_21906;
var state_21936__$1 = (function (){var statearr_21967 = state_21936;
(statearr_21967[(10)] = inst_21850);

(statearr_21967[(20)] = inst_21848);

(statearr_21967[(19)] = inst_21849__$1);

return statearr_21967;
})();
var statearr_21968_22045 = state_21936__$1;
(statearr_21968_22045[(2)] = null);

(statearr_21968_22045[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (43))){
var state_21936__$1 = state_21936;
var statearr_21969_22046 = state_21936__$1;
(statearr_21969_22046[(2)] = null);

(statearr_21969_22046[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (29))){
var inst_21813 = (state_21936[(8)]);
var inst_21849 = (state_21936[(19)]);
var inst_21871 = (inst_21849 < inst_21813);
var state_21936__$1 = state_21936;
var statearr_21970_22047 = state_21936__$1;
(statearr_21970_22047[(2)] = inst_21871);

(statearr_21970_22047[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (44))){
var inst_21886 = (state_21936[(21)]);
var inst_21890 = (state_21936[(22)]);
var inst_21899 = (state_21936[(2)]);
var inst_21900 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21890,inst_21886);
var state_21936__$1 = (function (){var statearr_21971 = state_21936;
(statearr_21971[(23)] = inst_21899);

return statearr_21971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21936__$1,(45),inst_21900);
} else {
if((state_val_21937 === (6))){
var inst_21794 = (state_21936[(16)]);
var inst_21801 = (state_21936[(24)]);
var inst_21800 = cljs.core.seq.call(null,inst_21794);
var inst_21801__$1 = cljs.core.first.call(null,inst_21800);
var inst_21802 = cljs.core.next.call(null,inst_21800);
var inst_21803 = cljs.core.not.call(null,inst_21801__$1);
var state_21936__$1 = (function (){var statearr_21972 = state_21936;
(statearr_21972[(14)] = inst_21802);

(statearr_21972[(24)] = inst_21801__$1);

return statearr_21972;
})();
if(inst_21803){
var statearr_21973_22048 = state_21936__$1;
(statearr_21973_22048[(1)] = (8));

} else {
var statearr_21974_22049 = state_21936__$1;
(statearr_21974_22049[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (28))){
var inst_21915 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_21975_22050 = state_21936__$1;
(statearr_21975_22050[(2)] = inst_21915);

(statearr_21975_22050[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (51))){
var inst_21923 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_21976_22051 = state_21936__$1;
(statearr_21976_22051[(2)] = inst_21923);

(statearr_21976_22051[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (25))){
var inst_21865 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_21977_22052 = state_21936__$1;
(statearr_21977_22052[(2)] = inst_21865);

(statearr_21977_22052[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (34))){
var inst_21913 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_21978_22053 = state_21936__$1;
(statearr_21978_22053[(2)] = inst_21913);

(statearr_21978_22053[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (17))){
var inst_21826 = (state_21936[(12)]);
var inst_21836 = (state_21936[(2)]);
var inst_21844 = cljs.core.seq.call(null,inst_21826);
var inst_21845 = cljs.core.first.call(null,inst_21844);
var inst_21846 = cljs.core.next.call(null,inst_21844);
var inst_21847 = cljs.core.PersistentVector.EMPTY;
var inst_21848 = inst_21826;
var inst_21849 = (0);
var inst_21850 = inst_21847;
var state_21936__$1 = (function (){var statearr_21979 = state_21936;
(statearr_21979[(25)] = inst_21845);

(statearr_21979[(26)] = inst_21846);

(statearr_21979[(10)] = inst_21850);

(statearr_21979[(20)] = inst_21848);

(statearr_21979[(27)] = inst_21836);

(statearr_21979[(19)] = inst_21849);

return statearr_21979;
})();
var statearr_21980_22054 = state_21936__$1;
(statearr_21980_22054[(2)] = null);

(statearr_21980_22054[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (3))){
var inst_21934 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21936__$1,inst_21934);
} else {
if((state_val_21937 === (12))){
var state_21936__$1 = state_21936;
var statearr_21981_22055 = state_21936__$1;
(statearr_21981_22055[(2)] = fuel);

(statearr_21981_22055[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (2))){
var _ = (function (){var statearr_21982 = state_21936;
(statearr_21982[(4)] = cljs.core.cons.call(null,(5),(state_21936[(4)])));

return statearr_21982;
})();
var inst_21790 = reverse_refs_specs;
var inst_21791 = cljs.core.seq.call(null,inst_21790);
var inst_21792 = cljs.core.first.call(null,inst_21791);
var inst_21793 = cljs.core.next.call(null,inst_21791);
var inst_21794 = inst_21790;
var inst_21795 = null;
var state_21936__$1 = (function (){var statearr_21983 = state_21936;
(statearr_21983[(13)] = inst_21795);

(statearr_21983[(16)] = inst_21794);

(statearr_21983[(28)] = inst_21793);

(statearr_21983[(29)] = inst_21792);

return statearr_21983;
})();
var statearr_21984_22056 = state_21936__$1;
(statearr_21984_22056[(2)] = null);

(statearr_21984_22056[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (23))){
var inst_21814 = (state_21936[(9)]);
var inst_21849 = (state_21936[(19)]);
var inst_21862 = (inst_21849 >= inst_21814);
var state_21936__$1 = state_21936;
var statearr_21985_22057 = state_21936__$1;
(statearr_21985_22057[(2)] = inst_21862);

(statearr_21985_22057[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (47))){
var inst_21816 = (state_21936[(30)]);
var state_21936__$1 = state_21936;
if(cljs.core.truth_(inst_21816)){
var statearr_21986_22058 = state_21936__$1;
(statearr_21986_22058[(1)] = (49));

} else {
var statearr_21987_22059 = state_21936__$1;
(statearr_21987_22059[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (35))){
var inst_21856 = (state_21936[(31)]);
var inst_21880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21881 = [inst_21856];
var inst_21882 = (new cljs.core.PersistentVector(null,1,(5),inst_21880,inst_21881,null));
var inst_21883 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21882);
var state_21936__$1 = state_21936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21936__$1,(38),inst_21883);
} else {
if((state_val_21937 === (19))){
var inst_21815 = (state_21936[(11)]);
var inst_21917 = (state_21936[(2)]);
var state_21936__$1 = (function (){var statearr_21988 = state_21936;
(statearr_21988[(15)] = inst_21917);

return statearr_21988;
})();
if(cljs.core.truth_(inst_21815)){
var statearr_21989_22060 = state_21936__$1;
(statearr_21989_22060[(1)] = (46));

} else {
var statearr_21990_22061 = state_21936__$1;
(statearr_21990_22061[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (11))){
var inst_21826 = (state_21936[(12)]);
var inst_21823 = (state_21936[(2)]);
var inst_21824 = fluree.db.util.async.throw_err.call(null,inst_21823);
var inst_21825 = cljs.core.map.call(null,fluree.db.flake.s,inst_21824);
var inst_21826__$1 = cljs.core.not_empty.call(null,inst_21825);
var state_21936__$1 = (function (){var statearr_21992 = state_21936;
(statearr_21992[(12)] = inst_21826__$1);

return statearr_21992;
})();
if(cljs.core.truth_(inst_21826__$1)){
var statearr_21993_22062 = state_21936__$1;
(statearr_21993_22062[(1)] = (12));

} else {
var statearr_21994_22063 = state_21936__$1;
(statearr_21994_22063[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (9))){
var inst_21811 = (state_21936[(32)]);
var inst_21801 = (state_21936[(24)]);
var inst_21810 = cljs.core.nth.call(null,inst_21801,(0),null);
var inst_21811__$1 = cljs.core.nth.call(null,inst_21801,(1),null);
var inst_21812 = cljs.core.__destructure_map.call(null,inst_21811__$1);
var inst_21813 = cljs.core.get.call(null,inst_21812,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21814 = cljs.core.get.call(null,inst_21812,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21815 = cljs.core.get.call(null,inst_21812,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21816 = cljs.core.get.call(null,inst_21812,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21817 = cljs.core.get.call(null,inst_21812,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21819 = [subject_id,inst_21810];
var inst_21820 = (new cljs.core.PersistentVector(null,2,(5),inst_21818,inst_21819,null));
var inst_21821 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21820);
var state_21936__$1 = (function (){var statearr_21995 = state_21936;
(statearr_21995[(8)] = inst_21813);

(statearr_21995[(30)] = inst_21816);

(statearr_21995[(11)] = inst_21815);

(statearr_21995[(32)] = inst_21811__$1);

(statearr_21995[(9)] = inst_21814);

(statearr_21995[(17)] = inst_21817);

return statearr_21995;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21936__$1,(11),inst_21821);
} else {
if((state_val_21937 === (5))){
var _ = (function (){var statearr_21996 = state_21936;
(statearr_21996[(4)] = cljs.core.rest.call(null,(state_21936[(4)])));

return statearr_21996;
})();
var state_21936__$1 = state_21936;
var ex21991 = (state_21936__$1[(2)]);
var statearr_21997_22064 = state_21936__$1;
(statearr_21997_22064[(5)] = ex21991);


if((ex21991 instanceof Error)){
var statearr_21998_22065 = state_21936__$1;
(statearr_21998_22065[(1)] = (4));

(statearr_21998_22065[(5)] = null);

} else {
throw ex21991;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (14))){
var inst_21830 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
if(cljs.core.truth_(inst_21830)){
var statearr_21999_22066 = state_21936__$1;
(statearr_21999_22066[(1)] = (15));

} else {
var statearr_22000_22067 = state_21936__$1;
(statearr_22000_22067[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (45))){
var inst_21850 = (state_21936[(10)]);
var inst_21902 = (state_21936[(2)]);
var inst_21903 = fluree.db.util.async.throw_err.call(null,inst_21902);
var inst_21904 = cljs.core.conj.call(null,inst_21850,inst_21903);
var state_21936__$1 = state_21936;
var statearr_22001_22068 = state_21936__$1;
(statearr_22001_22068[(2)] = inst_21904);

(statearr_22001_22068[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (26))){
var inst_21850 = (state_21936[(10)]);
var state_21936__$1 = state_21936;
var statearr_22002_22069 = state_21936__$1;
(statearr_22002_22069[(2)] = inst_21850);

(statearr_22002_22069[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (16))){
var state_21936__$1 = state_21936;
var statearr_22003_22070 = state_21936__$1;
(statearr_22003_22070[(2)] = null);

(statearr_22003_22070[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (38))){
var inst_21886 = (state_21936[(21)]);
var inst_21811 = (state_21936[(32)]);
var inst_21885 = (state_21936[(2)]);
var inst_21886__$1 = fluree.db.util.async.throw_err.call(null,inst_21885);
var inst_21887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21888 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21889 = (new cljs.core.PersistentVector(null,4,(5),inst_21887,inst_21888,null));
var inst_21890 = cljs.core.select_keys.call(null,inst_21811,inst_21889);
var inst_21891 = cljs.core.empty_QMARK_.call(null,inst_21886__$1);
var state_21936__$1 = (function (){var statearr_22004 = state_21936;
(statearr_22004[(21)] = inst_21886__$1);

(statearr_22004[(22)] = inst_21890);

return statearr_22004;
})();
if(inst_21891){
var statearr_22005_22071 = state_21936__$1;
(statearr_22005_22071[(1)] = (39));

} else {
var statearr_22006_22072 = state_21936__$1;
(statearr_22006_22072[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (30))){
var inst_21813 = (state_21936[(8)]);
var state_21936__$1 = state_21936;
var statearr_22007_22073 = state_21936__$1;
(statearr_22007_22073[(2)] = inst_21813);

(statearr_22007_22073[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (10))){
var inst_21929 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_22008_22074 = state_21936__$1;
(statearr_22008_22074[(2)] = inst_21929);

(statearr_22008_22074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (18))){
var inst_21856 = (state_21936[(31)]);
var inst_21848 = (state_21936[(20)]);
var inst_21858 = (state_21936[(7)]);
var inst_21855 = cljs.core.seq.call(null,inst_21848);
var inst_21856__$1 = cljs.core.first.call(null,inst_21855);
var inst_21857 = cljs.core.next.call(null,inst_21855);
var inst_21858__$1 = cljs.core.not.call(null,inst_21856__$1);
var state_21936__$1 = (function (){var statearr_22009 = state_21936;
(statearr_22009[(31)] = inst_21856__$1);

(statearr_22009[(18)] = inst_21857);

(statearr_22009[(7)] = inst_21858__$1);

return statearr_22009;
})();
if(inst_21858__$1){
var statearr_22010_22075 = state_21936__$1;
(statearr_22010_22075[(1)] = (20));

} else {
var statearr_22011_22076 = state_21936__$1;
(statearr_22011_22076[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (42))){
var inst_21886 = (state_21936[(21)]);
var inst_21895 = cljs.core.count.call(null,inst_21886);
var inst_21896 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21895,max_fuel);
var state_21936__$1 = state_21936;
var statearr_22012_22077 = state_21936__$1;
(statearr_22012_22077[(2)] = inst_21896);

(statearr_22012_22077[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (37))){
var inst_21911 = (state_21936[(2)]);
var state_21936__$1 = state_21936;
var statearr_22013_22078 = state_21936__$1;
(statearr_22013_22078[(2)] = inst_21911);

(statearr_22013_22078[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (8))){
var inst_21795 = (state_21936[(13)]);
var state_21936__$1 = state_21936;
var statearr_22014_22079 = state_21936__$1;
(statearr_22014_22079[(2)] = inst_21795);

(statearr_22014_22079[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21937 === (49))){
var inst_21816 = (state_21936[(30)]);
var state_21936__$1 = state_21936;
var statearr_22015_22080 = state_21936__$1;
(statearr_22015_22080[(2)] = inst_21816);

(statearr_22015_22080[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0 = (function (){
var statearr_22016 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22016[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__);

(statearr_22016[(1)] = (1));

return statearr_22016;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1 = (function (state_21936){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22017){var ex__2749__auto__ = e22017;
var statearr_22018_22081 = state_21936;
(statearr_22018_22081[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21936[(4)]))){
var statearr_22019_22082 = state_21936;
(statearr_22019_22082[(1)] = cljs.core.first.call(null,(state_21936[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22083 = state_21936;
state_21936 = G__22083;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = function(state_21936){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1.call(this,state_21936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22020 = f__2769__auto__.call(null);
(statearr_22020[(6)] = c__2768__auto__);

return statearr_22020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__22085 = arguments.length;
switch (G__22085) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22087 = null;
var G__22087__0 = (function (){
return xf.call(null);
});
var G__22087__1 = (function (result){
return xf.call(null,result);
});
var G__22087__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22087 = function(result,flake){
switch(arguments.length){
case 0:
return G__22087__0.call(this);
case 1:
return G__22087__1.call(this,result);
case 2:
return G__22087__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22087.cljs$core$IFn$_invoke$arity$0 = G__22087__0;
G__22087.cljs$core$IFn$_invoke$arity$1 = G__22087__1;
G__22087.cljs$core$IFn$_invoke$arity$2 = G__22087__2;
return G__22087;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o.call(null,flake);
var recur_pred = fluree.db.flake.p.call(null,flake);
var map__22088 = select_spec;
var map__22088__$1 = cljs.core.__destructure_map.call(null,map__22088);
var recur_seen = cljs.core.get.call(null,map__22088__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__22088__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22202){
var state_val_22203 = (state_22202[(1)]);
if((state_val_22203 === (7))){
var inst_22114 = flakes;
var inst_22115 = cljs.core.seq.call(null,inst_22114);
var inst_22116 = cljs.core.first.call(null,inst_22115);
var inst_22117 = cljs.core.next.call(null,inst_22115);
var inst_22118 = cljs.core.PersistentVector.EMPTY;
var inst_22119 = inst_22114;
var inst_22120 = (0);
var inst_22121 = inst_22118;
var state_22202__$1 = (function (){var statearr_22204 = state_22202;
(statearr_22204[(7)] = inst_22116);

(statearr_22204[(8)] = inst_22119);

(statearr_22204[(9)] = inst_22117);

(statearr_22204[(10)] = inst_22121);

(statearr_22204[(11)] = inst_22120);

return statearr_22204;
})();
var statearr_22205_22271 = state_22202__$1;
(statearr_22205_22271[(2)] = null);

(statearr_22205_22271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (20))){
var state_22202__$1 = state_22202;
var statearr_22206_22272 = state_22202__$1;
(statearr_22206_22272[(2)] = results);

(statearr_22206_22272[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (27))){
var state_22202__$1 = state_22202;
var statearr_22207_22273 = state_22202__$1;
(statearr_22207_22273[(2)] = null);

(statearr_22207_22273[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (1))){
var state_22202__$1 = state_22202;
var statearr_22208_22274 = state_22202__$1;
(statearr_22208_22274[(2)] = null);

(statearr_22208_22274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (24))){
var state_22202__$1 = state_22202;
var statearr_22209_22275 = state_22202__$1;
(statearr_22209_22275[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (39))){
var inst_22128 = (state_22202[(12)]);
var inst_22183 = (state_22202[(13)]);
var inst_22121 = (state_22202[(10)]);
var inst_22186 = (state_22202[(2)]);
var inst_22187 = fluree.db.util.async.throw_err.call(null,inst_22186);
var inst_22188 = cljs.core.conj.call(null,inst_22121,inst_22187);
var inst_22119 = inst_22128;
var inst_22120 = inst_22183;
var inst_22121__$1 = inst_22188;
var state_22202__$1 = (function (){var statearr_22211 = state_22202;
(statearr_22211[(8)] = inst_22119);

(statearr_22211[(10)] = inst_22121__$1);

(statearr_22211[(11)] = inst_22120);

return statearr_22211;
})();
var statearr_22212_22276 = state_22202__$1;
(statearr_22212_22276[(2)] = null);

(statearr_22212_22276[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (4))){
var inst_22089 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22213_22277 = state_22202__$1;
(statearr_22213_22277[(2)] = inst_22089);

(statearr_22213_22277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (15))){
var inst_22102 = (state_22202[(14)]);
var state_22202__$1 = state_22202;
var statearr_22214_22278 = state_22202__$1;
(statearr_22214_22278[(2)] = inst_22102);

(statearr_22214_22278[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (21))){
var inst_22098 = (state_22202[(15)]);
var state_22202__$1 = state_22202;
if(cljs.core.truth_(inst_22098)){
var statearr_22215_22279 = state_22202__$1;
(statearr_22215_22279[(1)] = (23));

} else {
var statearr_22216_22280 = state_22202__$1;
(statearr_22216_22280[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (31))){
var inst_22166 = (state_22202[(16)]);
var state_22202__$1 = state_22202;
var statearr_22217_22281 = state_22202__$1;
(statearr_22217_22281[(2)] = inst_22166);

(statearr_22217_22281[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (32))){
var inst_22158 = (state_22202[(17)]);
var inst_22172 = (state_22202[(2)]);
var state_22202__$1 = (function (){var statearr_22218 = state_22202;
(statearr_22218[(18)] = inst_22172);

return statearr_22218;
})();
if(cljs.core.truth_(inst_22158)){
var statearr_22219_22282 = state_22202__$1;
(statearr_22219_22282[(1)] = (33));

} else {
var statearr_22220_22283 = state_22202__$1;
(statearr_22220_22283[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (33))){
var inst_22158 = (state_22202[(17)]);
var state_22202__$1 = state_22202;
var statearr_22221_22284 = state_22202__$1;
(statearr_22221_22284[(2)] = inst_22158);

(statearr_22221_22284[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (13))){
var inst_22138 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
if(cljs.core.truth_(inst_22138)){
var statearr_22223_22285 = state_22202__$1;
(statearr_22223_22285[(1)] = (17));

} else {
var statearr_22224_22286 = state_22202__$1;
(statearr_22224_22286[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (22))){
var inst_22155 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22225_22287 = state_22202__$1;
(statearr_22225_22287[(2)] = inst_22155);

(statearr_22225_22287[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (36))){
var inst_22128 = (state_22202[(12)]);
var inst_22121 = (state_22202[(10)]);
var inst_22120 = (state_22202[(11)]);
var inst_22180 = (inst_22120 + (1));
var tmp22222 = inst_22121;
var inst_22119 = inst_22128;
var inst_22120__$1 = inst_22180;
var inst_22121__$1 = tmp22222;
var state_22202__$1 = (function (){var statearr_22226 = state_22202;
(statearr_22226[(8)] = inst_22119);

(statearr_22226[(10)] = inst_22121__$1);

(statearr_22226[(11)] = inst_22120__$1);

return statearr_22226;
})();
var statearr_22227_22288 = state_22202__$1;
(statearr_22227_22288[(2)] = null);

(statearr_22227_22288[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (29))){
var inst_22165 = (state_22202[(2)]);
var inst_22166 = fluree.db.util.async.throw_err.call(null,inst_22165);
var state_22202__$1 = (function (){var statearr_22228 = state_22202;
(statearr_22228[(16)] = inst_22166);

return statearr_22228;
})();
if(cljs.core.truth_(fuel)){
var statearr_22229_22289 = state_22202__$1;
(statearr_22229_22289[(1)] = (30));

} else {
var statearr_22230_22290 = state_22202__$1;
(statearr_22230_22290[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (6))){
var state_22202__$1 = state_22202;
var statearr_22231_22291 = state_22202__$1;
(statearr_22231_22291[(2)] = results);

(statearr_22231_22291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (28))){
var inst_22151 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22232_22292 = state_22202__$1;
(statearr_22232_22292[(2)] = inst_22151);

(statearr_22232_22292[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (25))){
var inst_22153 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22233_22293 = state_22202__$1;
(statearr_22233_22293[(2)] = inst_22153);

(statearr_22233_22293[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (34))){
var inst_22172 = (state_22202[(18)]);
var inst_22175 = cljs.core.empty_QMARK_.call(null,inst_22172);
var state_22202__$1 = state_22202;
var statearr_22234_22294 = state_22202__$1;
(statearr_22234_22294[(2)] = inst_22175);

(statearr_22234_22294[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (17))){
var inst_22121 = (state_22202[(10)]);
var inst_22140 = cljs.core.empty_QMARK_.call(null,inst_22121);
var state_22202__$1 = state_22202;
if(inst_22140){
var statearr_22235_22295 = state_22202__$1;
(statearr_22235_22295[(1)] = (20));

} else {
var statearr_22236_22296 = state_22202__$1;
(statearr_22236_22296[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (3))){
var inst_22200 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22202__$1,inst_22200);
} else {
if((state_val_22203 === (12))){
var inst_22102 = (state_22202[(14)]);
var state_22202__$1 = state_22202;
if(cljs.core.truth_(inst_22102)){
var statearr_22237_22297 = state_22202__$1;
(statearr_22237_22297[(1)] = (14));

} else {
var statearr_22238_22298 = state_22202__$1;
(statearr_22238_22298[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (2))){
var _ = (function (){var statearr_22239 = state_22202;
(statearr_22239[(4)] = cljs.core.cons.call(null,(5),(state_22202[(4)])));

return statearr_22239;
})();
var inst_22096 = select_spec;
var inst_22097 = cljs.core.__destructure_map.call(null,inst_22096);
var inst_22098 = cljs.core.get.call(null,inst_22097,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22099 = cljs.core.get.call(null,inst_22097,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22100 = cljs.core.get.call(null,inst_22097,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22101 = cljs.core.get.call(null,inst_22097,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22102 = cljs.core.get.call(null,inst_22097,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22103 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_22104 = (inst_22101 > inst_22103);
var state_22202__$1 = (function (){var statearr_22240 = state_22202;
(statearr_22240[(19)] = inst_22099);

(statearr_22240[(15)] = inst_22098);

(statearr_22240[(20)] = inst_22100);

(statearr_22240[(14)] = inst_22102);

return statearr_22240;
})();
if(cljs.core.truth_(inst_22104)){
var statearr_22241_22299 = state_22202__$1;
(statearr_22241_22299[(1)] = (6));

} else {
var statearr_22242_22300 = state_22202__$1;
(statearr_22242_22300[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (23))){
var inst_22099 = (state_22202[(19)]);
var inst_22121 = (state_22202[(10)]);
var inst_22144 = cljs.core.assoc.call(null,results,inst_22099,inst_22121);
var state_22202__$1 = state_22202;
var statearr_22243_22301 = state_22202__$1;
(statearr_22243_22301[(2)] = inst_22144);

(statearr_22243_22301[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (35))){
var inst_22127 = (state_22202[(21)]);
var inst_22177 = (state_22202[(2)]);
var inst_22178 = fluree.db.query.fql_resp.recur_select_spec.call(null,select_spec,inst_22127);
var state_22202__$1 = (function (){var statearr_22244 = state_22202;
(statearr_22244[(22)] = inst_22178);

return statearr_22244;
})();
if(cljs.core.truth_(inst_22177)){
var statearr_22245_22302 = state_22202__$1;
(statearr_22245_22302[(1)] = (36));

} else {
var statearr_22246_22303 = state_22202__$1;
(statearr_22246_22303[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (19))){
var inst_22193 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22247_22304 = state_22202__$1;
(statearr_22247_22304[(2)] = inst_22193);

(statearr_22247_22304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (11))){
var inst_22129 = (state_22202[(23)]);
var state_22202__$1 = state_22202;
var statearr_22249_22305 = state_22202__$1;
(statearr_22249_22305[(2)] = inst_22129);

(statearr_22249_22305[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (9))){
var inst_22119 = (state_22202[(8)]);
var inst_22129 = (state_22202[(23)]);
var inst_22127 = (state_22202[(21)]);
var inst_22126 = cljs.core.seq.call(null,inst_22119);
var inst_22127__$1 = cljs.core.first.call(null,inst_22126);
var inst_22128 = cljs.core.next.call(null,inst_22126);
var inst_22129__$1 = cljs.core.not.call(null,inst_22127__$1);
var state_22202__$1 = (function (){var statearr_22250 = state_22202;
(statearr_22250[(23)] = inst_22129__$1);

(statearr_22250[(12)] = inst_22128);

(statearr_22250[(21)] = inst_22127__$1);

return statearr_22250;
})();
if(inst_22129__$1){
var statearr_22251_22306 = state_22202__$1;
(statearr_22251_22306[(1)] = (11));

} else {
var statearr_22252_22307 = state_22202__$1;
(statearr_22252_22307[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (5))){
var _ = (function (){var statearr_22253 = state_22202;
(statearr_22253[(4)] = cljs.core.rest.call(null,(state_22202[(4)])));

return statearr_22253;
})();
var state_22202__$1 = state_22202;
var ex22248 = (state_22202__$1[(2)]);
var statearr_22254_22308 = state_22202__$1;
(statearr_22254_22308[(5)] = ex22248);


if((ex22248 instanceof Error)){
var statearr_22255_22309 = state_22202__$1;
(statearr_22255_22309[(1)] = (4));

(statearr_22255_22309[(5)] = null);

} else {
throw ex22248;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (14))){
var inst_22102 = (state_22202[(14)]);
var inst_22120 = (state_22202[(11)]);
var inst_22133 = (inst_22120 < inst_22102);
var state_22202__$1 = state_22202;
var statearr_22256_22310 = state_22202__$1;
(statearr_22256_22310[(2)] = inst_22133);

(statearr_22256_22310[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (26))){
var inst_22099 = (state_22202[(19)]);
var inst_22121 = (state_22202[(10)]);
var inst_22147 = cljs.core.first.call(null,inst_22121);
var inst_22148 = cljs.core.assoc.call(null,results,inst_22099,inst_22147);
var state_22202__$1 = state_22202;
var statearr_22257_22311 = state_22202__$1;
(statearr_22257_22311[(2)] = inst_22148);

(statearr_22257_22311[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (16))){
var inst_22136 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22258_22312 = state_22202__$1;
(statearr_22258_22312[(2)] = inst_22136);

(statearr_22258_22312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (38))){
var inst_22191 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22259_22313 = state_22202__$1;
(statearr_22259_22313[(2)] = inst_22191);

(statearr_22259_22313[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (30))){
var inst_22166 = (state_22202[(16)]);
var inst_22168 = fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22169 = cljs.core.sequence.call(null,inst_22168,inst_22166);
var state_22202__$1 = state_22202;
var statearr_22260_22314 = state_22202__$1;
(statearr_22260_22314[(2)] = inst_22169);

(statearr_22260_22314[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (10))){
var inst_22195 = (state_22202[(2)]);
var state_22202__$1 = state_22202;
var statearr_22261_22315 = state_22202__$1;
(statearr_22261_22315[(2)] = inst_22195);

(statearr_22261_22315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22203 === (18))){
var inst_22127 = (state_22202[(21)]);
var inst_22100 = (state_22202[(20)]);
var inst_22157 = fluree.db.flake.o.call(null,inst_22127);
var inst_22158 = cljs.core.contains_QMARK_.call(null,inst_22100,inst_22157);
var inst_22160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22161 = [inst_22157];
var inst_22162 = (new cljs.core.PersistentVector(null,1,(5),inst_22160,inst_22161,null));
var inst_22163 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22162);
var state_22202__$1 = (function (){var statearr_22262 = state_22202;
(statearr_22262[(17)] = inst_22158);

return statearr_22262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22202__$1,(29),inst_22163);
} else {
if((state_val_22203 === (37))){
var inst_22178 = (state_22202[(22)]);
var inst_22172 = (state_22202[(18)]);
var inst_22120 = (state_22202[(11)]);
var inst_22183 = (inst_22120 + (1));
var inst_22184 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22178,inst_22172);
var state_22202__$1 = (function (){var statearr_22263 = state_22202;
(statearr_22263[(13)] = inst_22183);

return statearr_22263;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22202__$1,(39),inst_22184);
} else {
if((state_val_22203 === (8))){
var inst_22197 = (state_22202[(2)]);
var _ = (function (){var statearr_22264 = state_22202;
(statearr_22264[(4)] = cljs.core.rest.call(null,(state_22202[(4)])));

return statearr_22264;
})();
var state_22202__$1 = state_22202;
var statearr_22265_22316 = state_22202__$1;
(statearr_22265_22316[(2)] = inst_22197);

(statearr_22265_22316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_22266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22266[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__);

(statearr_22266[(1)] = (1));

return statearr_22266;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1 = (function (state_22202){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22267){var ex__2749__auto__ = e22267;
var statearr_22268_22317 = state_22202;
(statearr_22268_22317[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22202[(4)]))){
var statearr_22269_22318 = state_22202;
(statearr_22269_22318[(1)] = cljs.core.first.call(null,(state_22202[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22319 = state_22202;
state_22202 = G__22319;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = function(state_22202){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1.call(this,state_22202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22270 = f__2769__auto__.call(null);
(statearr_22270[(6)] = c__2768__auto__);

return statearr_22270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__22323 = arguments.length;
switch (G__22323) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22762){
var state_val_22763 = (state_22762[(1)]);
if((state_val_22763 === (121))){
var inst_22685 = (state_22762[(2)]);
var inst_22686 = fluree.db.util.async.throw_err.call(null,inst_22685);
var inst_22687 = cljs.core.seq.call(null,inst_22686);
var state_22762__$1 = state_22762;
if(inst_22687){
var statearr_22764_22978 = state_22762__$1;
(statearr_22764_22978[(1)] = (122));

} else {
var statearr_22765_22979 = state_22762__$1;
(statearr_22765_22979[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (65))){
var inst_22478 = (state_22762[(7)]);
var inst_22477 = (state_22762[(2)]);
var inst_22478__$1 = fluree.db.util.async.throw_err.call(null,inst_22477);
var inst_22479 = cljs.core.seq.call(null,inst_22478__$1);
var state_22762__$1 = (function (){var statearr_22766 = state_22762;
(statearr_22766[(7)] = inst_22478__$1);

return statearr_22766;
})();
if(inst_22479){
var statearr_22767_22980 = state_22762__$1;
(statearr_22767_22980[(1)] = (66));

} else {
var statearr_22768_22981 = state_22762__$1;
(statearr_22768_22981[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (70))){
var inst_22478 = (state_22762[(7)]);
var inst_22489 = cljs.core.count.call(null,inst_22478);
var inst_22490 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22489);
var state_22762__$1 = state_22762;
var statearr_22769_22982 = state_22762__$1;
(statearr_22769_22982[(2)] = inst_22490);

(statearr_22769_22982[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (62))){
var inst_22468 = (state_22762[(8)]);
var inst_22471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22472 = fluree.db.flake.o.call(null,inst_22468);
var inst_22473 = [inst_22472];
var inst_22474 = (new cljs.core.PersistentVector(null,1,(5),inst_22471,inst_22473,null));
var inst_22475 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22474);
var state_22762__$1 = state_22762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22762__$1,(65),inst_22475);
} else {
if((state_val_22763 === (74))){
var inst_22462 = (state_22762[(9)]);
var state_22762__$1 = state_22762;
var statearr_22770_22983 = state_22762__$1;
(statearr_22770_22983[(2)] = inst_22462);

(statearr_22770_22983[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (110))){
var inst_22647 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22648 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22647);
var inst_22649 = inst_22648 === true;
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22649)){
var statearr_22771_22984 = state_22762__$1;
(statearr_22771_22984[(1)] = (113));

} else {
var statearr_22772_22985 = state_22762__$1;
(statearr_22772_22985[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (130))){
var inst_22757 = (state_22762[(2)]);
var _ = (function (){var statearr_22773 = state_22762;
(statearr_22773[(4)] = cljs.core.rest.call(null,(state_22762[(4)])));

return statearr_22773;
})();
var state_22762__$1 = state_22762;
var statearr_22774_22986 = state_22762__$1;
(statearr_22774_22986[(2)] = inst_22757);

(statearr_22774_22986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (128))){
var inst_22732 = (state_22762[(10)]);
var inst_22735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22736 = [acc,inst_22732];
var inst_22737 = (new cljs.core.PersistentVector(null,2,(5),inst_22735,inst_22736,null));
var state_22762__$1 = state_22762;
var statearr_22775_22987 = state_22762__$1;
(statearr_22775_22987[(2)] = inst_22737);

(statearr_22775_22987[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (7))){
var inst_22335 = (state_22762[(11)]);
var state_22762__$1 = state_22762;
var statearr_22776_22988 = state_22762__$1;
(statearr_22776_22988[(2)] = inst_22335);

(statearr_22776_22988[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (59))){
var inst_22726 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22777_22989 = state_22762__$1;
(statearr_22777_22989[(2)] = inst_22726);

(statearr_22777_22989[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (86))){
var inst_22556 = (state_22762[(12)]);
var inst_22556__$1 = (state_22762[(2)]);
var state_22762__$1 = (function (){var statearr_22778 = state_22762;
(statearr_22778[(12)] = inst_22556__$1);

return statearr_22778;
})();
if(cljs.core.truth_(inst_22556__$1)){
var statearr_22779_22990 = state_22762__$1;
(statearr_22779_22990[(1)] = (88));

} else {
var statearr_22780_22991 = state_22762__$1;
(statearr_22780_22991[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (20))){
var inst_22377 = (state_22762[(13)]);
var inst_22376 = (state_22762[(14)]);
var inst_22364 = (state_22762[(15)]);
var inst_22375 = (state_22762[(2)]);
var inst_22376__$1 = cljs.core.__destructure_map.call(null,inst_22364);
var inst_22377__$1 = cljs.core.get.call(null,inst_22376__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22378 = cljs.core.get.call(null,inst_22376__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22379 = cljs.core.get.call(null,inst_22376__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22380 = cljs.core.get.call(null,inst_22376__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22381 = cljs.core.get.call(null,inst_22376__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22382 = cljs.core.get.call(null,inst_22376__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22762__$1 = (function (){var statearr_22781 = state_22762;
(statearr_22781[(16)] = inst_22380);

(statearr_22781[(17)] = inst_22382);

(statearr_22781[(18)] = inst_22381);

(statearr_22781[(13)] = inst_22377__$1);

(statearr_22781[(19)] = inst_22375);

(statearr_22781[(14)] = inst_22376__$1);

(statearr_22781[(20)] = inst_22379);

(statearr_22781[(21)] = inst_22378);

return statearr_22781;
})();
if(cljs.core.truth_(inst_22377__$1)){
var statearr_22782_22992 = state_22762__$1;
(statearr_22782_22992[(1)] = (24));

} else {
var statearr_22783_22993 = state_22762__$1;
(statearr_22783_22993[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (72))){
var inst_22487 = (state_22762[(22)]);
var inst_22493 = (state_22762[(2)]);
var inst_22494 = cljs.core.seq.call(null,inst_22487);
var state_22762__$1 = (function (){var statearr_22784 = state_22762;
(statearr_22784[(23)] = inst_22493);

return statearr_22784;
})();
if(inst_22494){
var statearr_22785_22994 = state_22762__$1;
(statearr_22785_22994[(1)] = (73));

} else {
var statearr_22786_22995 = state_22762__$1;
(statearr_22786_22995[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (58))){
var inst_22364 = (state_22762[(15)]);
var inst_22509 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22364);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22509)){
var statearr_22787_22996 = state_22762__$1;
(statearr_22787_22996[(1)] = (76));

} else {
var statearr_22788_22997 = state_22762__$1;
(statearr_22788_22997[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (60))){
var inst_22461 = (state_22762[(24)]);
var inst_22468 = (state_22762[(8)]);
var inst_22467 = cljs.core.seq.call(null,inst_22461);
var inst_22468__$1 = cljs.core.first.call(null,inst_22467);
var inst_22469 = cljs.core.next.call(null,inst_22467);
var state_22762__$1 = (function (){var statearr_22789 = state_22762;
(statearr_22789[(25)] = inst_22469);

(statearr_22789[(8)] = inst_22468__$1);

return statearr_22789;
})();
if(cljs.core.truth_(inst_22468__$1)){
var statearr_22790_22998 = state_22762__$1;
(statearr_22790_22998[(1)] = (62));

} else {
var statearr_22791_22999 = state_22762__$1;
(statearr_22791_22999[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (27))){
var inst_22381 = (state_22762[(18)]);
var inst_22385 = (state_22762[(26)]);
var inst_22385__$1 = cljs.core.not_EQ_.call(null,(0),inst_22381);
var state_22762__$1 = (function (){var statearr_22792 = state_22762;
(statearr_22792[(26)] = inst_22385__$1);

return statearr_22792;
})();
if(inst_22385__$1){
var statearr_22793_23000 = state_22762__$1;
(statearr_22793_23000[(1)] = (30));

} else {
var statearr_22794_23001 = state_22762__$1;
(statearr_22794_23001[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (1))){
var state_22762__$1 = state_22762;
var statearr_22795_23002 = state_22762__$1;
(statearr_22795_23002[(2)] = null);

(statearr_22795_23002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (69))){
var inst_22483 = (state_22762[(2)]);
var inst_22484 = fluree.db.util.async.throw_err.call(null,inst_22483);
var state_22762__$1 = state_22762;
var statearr_22796_23003 = state_22762__$1;
(statearr_22796_23003[(2)] = inst_22484);

(statearr_22796_23003[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (101))){
var inst_22640 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22797_23004 = state_22762__$1;
(statearr_22797_23004[(2)] = inst_22640);

(statearr_22797_23004[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (24))){
var inst_22381 = (state_22762[(18)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22381)){
var statearr_22798_23005 = state_22762__$1;
(statearr_22798_23005[(1)] = (27));

} else {
var statearr_22799_23006 = state_22762__$1;
(statearr_22799_23006[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (102))){
var inst_22612 = (state_22762[(27)]);
var inst_22611 = (state_22762[(2)]);
var inst_22612__$1 = fluree.db.util.async.throw_err.call(null,inst_22611);
var inst_22613 = cljs.core.empty_QMARK_.call(null,inst_22612__$1);
var state_22762__$1 = (function (){var statearr_22800 = state_22762;
(statearr_22800[(27)] = inst_22612__$1);

return statearr_22800;
})();
if(inst_22613){
var statearr_22801_23007 = state_22762__$1;
(statearr_22801_23007[(1)] = (103));

} else {
var statearr_22802_23008 = state_22762__$1;
(statearr_22802_23008[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (135))){
var state_22762__$1 = state_22762;
var statearr_22803_23009 = state_22762__$1;
(statearr_22803_23009[(2)] = null);

(statearr_22803_23009[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (55))){
var inst_22364 = (state_22762[(15)]);
var inst_22437 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22364);
var state_22762__$1 = state_22762;
var statearr_22804_23010 = state_22762__$1;
(statearr_22804_23010[(2)] = inst_22437);

(statearr_22804_23010[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (85))){
var inst_22531 = (state_22762[(28)]);
var inst_22364 = (state_22762[(15)]);
var inst_22543 = fluree.db.flake.o.call(null,inst_22531);
var inst_22544 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22364);
var inst_22545 = fluree.db.dbproto._tag.call(null,db,inst_22543,inst_22544);
var state_22762__$1 = state_22762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22762__$1,(87),inst_22545);
} else {
if((state_val_22763 === (39))){
var inst_22380 = (state_22762[(16)]);
var inst_22412 = (state_22762[(29)]);
var inst_22412__$1 = cljs.core.not.call(null,inst_22380);
var state_22762__$1 = (function (){var statearr_22805 = state_22762;
(statearr_22805[(29)] = inst_22412__$1);

return statearr_22805;
})();
if(inst_22412__$1){
var statearr_22806_23011 = state_22762__$1;
(statearr_22806_23011[(1)] = (42));

} else {
var statearr_22807_23012 = state_22762__$1;
(statearr_22807_23012[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (88))){
var inst_22556 = (state_22762[(12)]);
var inst_22525 = (state_22762[(30)]);
var inst_22558 = cljs.core.conj.call(null,inst_22525,inst_22556);
var state_22762__$1 = state_22762;
var statearr_22808_23013 = state_22762__$1;
(statearr_22808_23013[(2)] = inst_22558);

(statearr_22808_23013[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (46))){
var inst_22379 = (state_22762[(20)]);
var state_22762__$1 = state_22762;
var statearr_22809_23014 = state_22762__$1;
(statearr_22809_23014[(2)] = inst_22379);

(statearr_22809_23014[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (4))){
var inst_22324 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22810_23015 = state_22762__$1;
(statearr_22810_23015[(2)] = inst_22324);

(statearr_22810_23015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (77))){
var inst_22571 = (state_22762[(31)]);
var inst_22571__$1 = componentFollow_QMARK_;
var state_22762__$1 = (function (){var statearr_22811 = state_22762;
(statearr_22811[(31)] = inst_22571__$1);

return statearr_22811;
})();
if(cljs.core.truth_(inst_22571__$1)){
var statearr_22812_23016 = state_22762__$1;
(statearr_22812_23016[(1)] = (91));

} else {
var statearr_22813_23017 = state_22762__$1;
(statearr_22813_23017[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (106))){
var inst_22592 = (state_22762[(32)]);
var inst_22626 = (state_22762[(2)]);
var inst_22627 = fluree.db.util.async.throw_err.call(null,inst_22626);
var inst_22628 = cljs.core.conj.call(null,inst_22592,inst_22627);
var state_22762__$1 = state_22762;
var statearr_22814_23018 = state_22762__$1;
(statearr_22814_23018[(2)] = inst_22628);

(statearr_22814_23018[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (119))){
var inst_22670 = (state_22762[(33)]);
var inst_22700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22701 = [inst_22670,offset_map];
var inst_22702 = (new cljs.core.PersistentVector(null,2,(5),inst_22700,inst_22701,null));
var state_22762__$1 = state_22762;
var statearr_22815_23019 = state_22762__$1;
(statearr_22815_23019[(2)] = inst_22702);

(statearr_22815_23019[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (95))){
var inst_22378 = (state_22762[(21)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22378)){
var statearr_22816_23020 = state_22762__$1;
(statearr_22816_23020[(1)] = (110));

} else {
var statearr_22817_23021 = state_22762__$1;
(statearr_22817_23021[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (54))){
var inst_22434 = (state_22762[(34)]);
var state_22762__$1 = state_22762;
var statearr_22818_23022 = state_22762__$1;
(statearr_22818_23022[(2)] = inst_22434);

(statearr_22818_23022[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (92))){
var inst_22571 = (state_22762[(31)]);
var state_22762__$1 = state_22762;
var statearr_22819_23023 = state_22762__$1;
(statearr_22819_23023[(2)] = inst_22571);

(statearr_22819_23023[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (104))){
var inst_22612 = (state_22762[(27)]);
var inst_22334 = (state_22762[(35)]);
var inst_22621 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22622 = [true,inst_22334];
var inst_22623 = cljs.core.PersistentHashMap.fromArrays(inst_22621,inst_22622);
var inst_22624 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22623,inst_22612);
var state_22762__$1 = state_22762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22762__$1,(106),inst_22624);
} else {
if((state_val_22763 === (15))){
var inst_22357 = (state_22762[(36)]);
var inst_22334 = (state_22762[(35)]);
var inst_22361 = cljs.core.assoc.call(null,inst_22357,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22334);
var state_22762__$1 = state_22762;
var statearr_22820_23024 = state_22762__$1;
(statearr_22820_23024[(2)] = inst_22361);

(statearr_22820_23024[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (48))){
var inst_22428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22429 = [null,offset_map];
var inst_22430 = (new cljs.core.PersistentVector(null,2,(5),inst_22428,inst_22429,null));
var state_22762__$1 = state_22762;
var statearr_22821_23025 = state_22762__$1;
(statearr_22821_23025[(2)] = inst_22430);

(statearr_22821_23025[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (50))){
var inst_22728 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22822_23026 = state_22762__$1;
(statearr_22822_23026[(2)] = inst_22728);

(statearr_22822_23026[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (116))){
var inst_22676 = (state_22762[(37)]);
var inst_22669 = (state_22762[(38)]);
var inst_22675 = cljs.core.seq.call(null,inst_22669);
var inst_22676__$1 = cljs.core.first.call(null,inst_22675);
var inst_22677 = cljs.core.next.call(null,inst_22675);
var state_22762__$1 = (function (){var statearr_22823 = state_22762;
(statearr_22823[(37)] = inst_22676__$1);

(statearr_22823[(39)] = inst_22677);

return statearr_22823;
})();
if(cljs.core.truth_(inst_22676__$1)){
var statearr_22824_23027 = state_22762__$1;
(statearr_22824_23027[(1)] = (118));

} else {
var statearr_22825_23028 = state_22762__$1;
(statearr_22825_23028[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (75))){
var inst_22469 = (state_22762[(25)]);
var inst_22499 = (state_22762[(2)]);
var inst_22461 = inst_22469;
var inst_22462 = inst_22499;
var state_22762__$1 = (function (){var statearr_22826 = state_22762;
(statearr_22826[(9)] = inst_22462);

(statearr_22826[(24)] = inst_22461);

return statearr_22826;
})();
var statearr_22827_23029 = state_22762__$1;
(statearr_22827_23029[(2)] = null);

(statearr_22827_23029[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (99))){
var inst_22598 = (state_22762[(40)]);
var inst_22364 = (state_22762[(15)]);
var inst_22601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22602 = fluree.db.flake.o.call(null,inst_22598);
var inst_22603 = [inst_22602];
var inst_22604 = (new cljs.core.PersistentVector(null,1,(5),inst_22601,inst_22603,null));
var inst_22605 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22606 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22364);
var inst_22607 = [inst_22606];
var inst_22608 = cljs.core.PersistentHashMap.fromArrays(inst_22605,inst_22607);
var inst_22609 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22604,inst_22608);
var state_22762__$1 = state_22762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22762__$1,(102),inst_22609);
} else {
if((state_val_22763 === (21))){
var inst_22368 = (state_22762[(41)]);
var state_22762__$1 = state_22762;
var statearr_22828_23030 = state_22762__$1;
(statearr_22828_23030[(2)] = inst_22368);

(statearr_22828_23030[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (31))){
var inst_22385 = (state_22762[(26)]);
var state_22762__$1 = state_22762;
var statearr_22829_23031 = state_22762__$1;
(statearr_22829_23031[(2)] = inst_22385);

(statearr_22829_23031[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (113))){
var inst_22380 = (state_22762[(16)]);
var inst_22382 = (state_22762[(17)]);
var inst_22381 = (state_22762[(18)]);
var inst_22377 = (state_22762[(13)]);
var inst_22334 = (state_22762[(35)]);
var inst_22349 = (state_22762[(42)]);
var inst_22375 = (state_22762[(19)]);
var inst_22376 = (state_22762[(14)]);
var inst_22379 = (state_22762[(20)]);
var inst_22378 = (state_22762[(21)]);
var inst_22364 = (state_22762[(15)]);
var inst_22651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22652 = (function (){var map__22330 = inst_22376;
var p = inst_22382;
var pred_spec__$1 = inst_22349;
var orderBy = inst_22380;
var multi_QMARK_ = inst_22377;
var limit = inst_22379;
var offset = inst_22381;
var k = inst_22375;
var compact_QMARK_ = inst_22334;
var pred_spec_SINGLEQUOTE_ = inst_22364;
var ref_QMARK_ = inst_22378;
return (function (p1__22320_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o.call(null,p1__22320_SHARP_)]);
});
})();
var inst_22653 = cljs.core.mapv.call(null,inst_22652,flakes);
var inst_22654 = [inst_22653,offset_map];
var inst_22655 = (new cljs.core.PersistentVector(null,2,(5),inst_22651,inst_22654,null));
var state_22762__$1 = state_22762;
var statearr_22830_23032 = state_22762__$1;
(statearr_22830_23032[(2)] = inst_22655);

(statearr_22830_23032[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (32))){
var inst_22391 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22831_23033 = state_22762__$1;
(statearr_22831_23033[(2)] = inst_22391);

(statearr_22831_23033[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (136))){
var inst_22753 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22832_23034 = state_22762__$1;
(statearr_22832_23034[(2)] = inst_22753);

(statearr_22832_23034[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (40))){
var inst_22377 = (state_22762[(13)]);
var state_22762__$1 = state_22762;
var statearr_22833_23035 = state_22762__$1;
(statearr_22833_23035[(2)] = inst_22377);

(statearr_22833_23035[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (129))){
var inst_22377 = (state_22762[(13)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22377)){
var statearr_22834_23036 = state_22762__$1;
(statearr_22834_23036[(1)] = (131));

} else {
var statearr_22835_23037 = state_22762__$1;
(statearr_22835_23037[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (91))){
var inst_22364 = (state_22762[(15)]);
var inst_22573 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22364);
var state_22762__$1 = state_22762;
var statearr_22836_23038 = state_22762__$1;
(statearr_22836_23038[(2)] = inst_22573);

(statearr_22836_23038[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (117))){
var inst_22706 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22837_23039 = state_22762__$1;
(statearr_22837_23039[(2)] = inst_22706);

(statearr_22837_23039[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (108))){
var state_22762__$1 = state_22762;
var statearr_22838_23040 = state_22762__$1;
(statearr_22838_23040[(2)] = null);

(statearr_22838_23040[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (56))){
var inst_22439 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22839_23041 = state_22762__$1;
(statearr_22839_23041[(2)] = inst_22439);

(statearr_22839_23041[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (33))){
var inst_22382 = (state_22762[(17)]);
var inst_22399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22400 = cljs.core.get.call(null,offset_map,inst_22382);
var state_22762__$1 = (function (){var statearr_22840 = state_22762;
(statearr_22840[(43)] = inst_22399);

return statearr_22840;
})();
if(cljs.core.truth_(inst_22400)){
var statearr_22841_23042 = state_22762__$1;
(statearr_22841_23042[(1)] = (36));

} else {
var statearr_22842_23043 = state_22762__$1;
(statearr_22842_23043[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (13))){
var inst_22349 = (state_22762[(42)]);
var state_22762__$1 = state_22762;
var statearr_22843_23044 = state_22762__$1;
(statearr_22843_23044[(2)] = inst_22349);

(statearr_22843_23044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (22))){
var inst_22364 = (state_22762[(15)]);
var inst_22371 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22364);
var state_22762__$1 = state_22762;
var statearr_22844_23045 = state_22762__$1;
(statearr_22844_23045[(2)] = inst_22371);

(statearr_22844_23045[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (90))){
var inst_22532 = (state_22762[(44)]);
var inst_22561 = (state_22762[(2)]);
var inst_22524 = inst_22532;
var inst_22525 = inst_22561;
var state_22762__$1 = (function (){var statearr_22845 = state_22762;
(statearr_22845[(45)] = inst_22524);

(statearr_22845[(30)] = inst_22525);

return statearr_22845;
})();
var statearr_22846_23046 = state_22762__$1;
(statearr_22846_23046[(2)] = null);

(statearr_22846_23046[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (109))){
var inst_22599 = (state_22762[(46)]);
var inst_22630 = (state_22762[(47)]);
var inst_22636 = (state_22762[(2)]);
var inst_22591 = inst_22599;
var inst_22592 = inst_22630;
var state_22762__$1 = (function (){var statearr_22847 = state_22762;
(statearr_22847[(32)] = inst_22592);

(statearr_22847[(48)] = inst_22591);

(statearr_22847[(49)] = inst_22636);

return statearr_22847;
})();
var statearr_22848_23047 = state_22762__$1;
(statearr_22848_23047[(2)] = null);

(statearr_22848_23047[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (36))){
var inst_22382 = (state_22762[(17)]);
var inst_22402 = cljs.core.update.call(null,offset_map,inst_22382,cljs.core.dec);
var state_22762__$1 = state_22762;
var statearr_22849_23048 = state_22762__$1;
(statearr_22849_23048[(2)] = inst_22402);

(statearr_22849_23048[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (41))){
var inst_22426 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22426)){
var statearr_22850_23049 = state_22762__$1;
(statearr_22850_23049[(1)] = (48));

} else {
var statearr_22851_23050 = state_22762__$1;
(statearr_22851_23050[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (118))){
var inst_22676 = (state_22762[(37)]);
var inst_22679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22680 = fluree.db.flake.o.call(null,inst_22676);
var inst_22681 = [inst_22680];
var inst_22682 = (new cljs.core.PersistentVector(null,1,(5),inst_22679,inst_22681,null));
var inst_22683 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22682);
var state_22762__$1 = state_22762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22762__$1,(121),inst_22683);
} else {
if((state_val_22763 === (89))){
var inst_22525 = (state_22762[(30)]);
var state_22762__$1 = state_22762;
var statearr_22852_23051 = state_22762__$1;
(statearr_22852_23051[(2)] = inst_22525);

(statearr_22852_23051[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (100))){
var inst_22592 = (state_22762[(32)]);
var state_22762__$1 = state_22762;
var statearr_22853_23052 = state_22762__$1;
(statearr_22853_23052[(2)] = inst_22592);

(statearr_22853_23052[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (131))){
var inst_22375 = (state_22762[(19)]);
var inst_22732 = (state_22762[(10)]);
var inst_22731 = (state_22762[(50)]);
var inst_22740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22741 = cljs.core.assoc.call(null,acc,inst_22375,inst_22731);
var inst_22742 = [inst_22741,inst_22732];
var inst_22743 = (new cljs.core.PersistentVector(null,2,(5),inst_22740,inst_22742,null));
var state_22762__$1 = state_22762;
var statearr_22854_23053 = state_22762__$1;
(statearr_22854_23053[(2)] = inst_22743);

(statearr_22854_23053[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (122))){
var inst_22676 = (state_22762[(37)]);
var inst_22670 = (state_22762[(33)]);
var inst_22677 = (state_22762[(39)]);
var inst_22689 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22690 = fluree.db.flake.o.call(null,inst_22676);
var inst_22691 = [inst_22690];
var inst_22692 = cljs.core.PersistentHashMap.fromArrays(inst_22689,inst_22691);
var inst_22693 = cljs.core.conj.call(null,inst_22670,inst_22692);
var inst_22669 = inst_22677;
var inst_22670__$1 = inst_22693;
var state_22762__$1 = (function (){var statearr_22855 = state_22762;
(statearr_22855[(33)] = inst_22670__$1);

(statearr_22855[(38)] = inst_22669);

return statearr_22855;
})();
var statearr_22856_23054 = state_22762__$1;
(statearr_22856_23054[(2)] = null);

(statearr_22856_23054[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (43))){
var inst_22412 = (state_22762[(29)]);
var state_22762__$1 = state_22762;
var statearr_22857_23055 = state_22762__$1;
(statearr_22857_23055[(2)] = inst_22412);

(statearr_22857_23055[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (61))){
var inst_22448 = (state_22762[(51)]);
var inst_22505 = (state_22762[(2)]);
var inst_22506 = [inst_22505,offset_map];
var inst_22507 = (new cljs.core.PersistentVector(null,2,(5),inst_22448,inst_22506,null));
var state_22762__$1 = state_22762;
var statearr_22858_23056 = state_22762__$1;
(statearr_22858_23056[(2)] = inst_22507);

(statearr_22858_23056[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (29))){
var inst_22394 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22859_23057 = state_22762__$1;
(statearr_22859_23057[(2)] = inst_22394);

(statearr_22859_23057[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (44))){
var inst_22423 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22860_23058 = state_22762__$1;
(statearr_22860_23058[(2)] = inst_22423);

(statearr_22860_23058[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (93))){
var inst_22576 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22576)){
var statearr_22861_23059 = state_22762__$1;
(statearr_22861_23059[(1)] = (94));

} else {
var statearr_22862_23060 = state_22762__$1;
(statearr_22862_23060[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (6))){
var inst_22337 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22338 = (inst_22337 == null);
var state_22762__$1 = state_22762;
var statearr_22863_23061 = state_22762__$1;
(statearr_22863_23061[(2)] = inst_22338);

(statearr_22863_23061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (111))){
var state_22762__$1 = state_22762;
var statearr_22864_23062 = state_22762__$1;
(statearr_22864_23062[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (28))){
var inst_22381 = (state_22762[(18)]);
var state_22762__$1 = state_22762;
var statearr_22866_23063 = state_22762__$1;
(statearr_22866_23063[(2)] = inst_22381);

(statearr_22866_23063[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (134))){
var inst_22375 = (state_22762[(19)]);
var inst_22732 = (state_22762[(10)]);
var inst_22731 = (state_22762[(50)]);
var inst_22746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22747 = cljs.core.first.call(null,inst_22731);
var inst_22748 = cljs.core.assoc.call(null,acc,inst_22375,inst_22747);
var inst_22749 = [inst_22748,inst_22732];
var inst_22750 = (new cljs.core.PersistentVector(null,2,(5),inst_22746,inst_22749,null));
var state_22762__$1 = state_22762;
var statearr_22867_23064 = state_22762__$1;
(statearr_22867_23064[(2)] = inst_22750);

(statearr_22867_23064[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (64))){
var inst_22503 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22868_23065 = state_22762__$1;
(statearr_22868_23065[(2)] = inst_22503);

(statearr_22868_23065[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (103))){
var inst_22598 = (state_22762[(40)]);
var inst_22592 = (state_22762[(32)]);
var inst_22615 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22616 = fluree.db.flake.o.call(null,inst_22598);
var inst_22617 = [inst_22616];
var inst_22618 = cljs.core.PersistentHashMap.fromArrays(inst_22615,inst_22617);
var inst_22619 = cljs.core.conj.call(null,inst_22592,inst_22618);
var state_22762__$1 = state_22762;
var statearr_22869_23066 = state_22762__$1;
(statearr_22869_23066[(2)] = inst_22619);

(statearr_22869_23066[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (51))){
var inst_22434 = (state_22762[(34)]);
var inst_22364 = (state_22762[(15)]);
var inst_22434__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22364);
var state_22762__$1 = (function (){var statearr_22870 = state_22762;
(statearr_22870[(34)] = inst_22434__$1);

return statearr_22870;
})();
if(cljs.core.truth_(inst_22434__$1)){
var statearr_22871_23067 = state_22762__$1;
(statearr_22871_23067[(1)] = (54));

} else {
var statearr_22872_23068 = state_22762__$1;
(statearr_22872_23068[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (25))){
var inst_22377 = (state_22762[(13)]);
var state_22762__$1 = state_22762;
var statearr_22873_23069 = state_22762__$1;
(statearr_22873_23069[(2)] = inst_22377);

(statearr_22873_23069[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (34))){
var inst_22377 = (state_22762[(13)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22377)){
var statearr_22874_23070 = state_22762__$1;
(statearr_22874_23070[(1)] = (39));

} else {
var statearr_22875_23071 = state_22762__$1;
(statearr_22875_23071[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (125))){
var inst_22380 = (state_22762[(16)]);
var inst_22382 = (state_22762[(17)]);
var inst_22381 = (state_22762[(18)]);
var inst_22377 = (state_22762[(13)]);
var inst_22334 = (state_22762[(35)]);
var inst_22349 = (state_22762[(42)]);
var inst_22375 = (state_22762[(19)]);
var inst_22376 = (state_22762[(14)]);
var inst_22379 = (state_22762[(20)]);
var inst_22378 = (state_22762[(21)]);
var inst_22364 = (state_22762[(15)]);
var inst_22711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22712 = (function (){var map__22330 = inst_22376;
var p = inst_22382;
var pred_spec__$1 = inst_22349;
var orderBy = inst_22380;
var multi_QMARK_ = inst_22377;
var limit = inst_22379;
var offset = inst_22381;
var k = inst_22375;
var compact_QMARK_ = inst_22334;
var pred_spec_SINGLEQUOTE_ = inst_22364;
var ref_QMARK_ = inst_22378;
return (function (p1__22321_SHARP_){
return fluree.db.flake.o.call(null,p1__22321_SHARP_);
});
})();
var inst_22713 = cljs.core.mapv.call(null,inst_22712,flakes);
var inst_22714 = [inst_22713,offset_map];
var inst_22715 = (new cljs.core.PersistentVector(null,2,(5),inst_22711,inst_22714,null));
var state_22762__$1 = state_22762;
var statearr_22876_23072 = state_22762__$1;
(statearr_22876_23072[(2)] = inst_22715);

(statearr_22876_23072[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (17))){
var inst_22365 = (state_22762[(52)]);
var inst_22364 = (state_22762[(15)]);
var inst_22364__$1 = (state_22762[(2)]);
var inst_22365__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22364__$1);
var state_22762__$1 = (function (){var statearr_22877 = state_22762;
(statearr_22877[(52)] = inst_22365__$1);

(statearr_22877[(15)] = inst_22364__$1);

return statearr_22877;
})();
if(cljs.core.truth_(inst_22365__$1)){
var statearr_22878_23073 = state_22762__$1;
(statearr_22878_23073[(1)] = (18));

} else {
var statearr_22879_23074 = state_22762__$1;
(statearr_22879_23074[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (3))){
var inst_22760 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22762__$1,inst_22760);
} else {
if((state_val_22763 === (12))){
var inst_22349 = (state_22762[(42)]);
var inst_22354 = cljs.core.assoc.call(null,inst_22349,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22762__$1 = state_22762;
var statearr_22880_23075 = state_22762__$1;
(statearr_22880_23075[(2)] = inst_22354);

(statearr_22880_23075[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (2))){
var inst_22335 = (state_22762[(11)]);
var _ = (function (){var statearr_22881 = state_22762;
(statearr_22881[(4)] = cljs.core.cons.call(null,(5),(state_22762[(4)])));

return statearr_22881;
})();
var inst_22334 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22335__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22762__$1 = (function (){var statearr_22882 = state_22762;
(statearr_22882[(11)] = inst_22335__$1);

(statearr_22882[(35)] = inst_22334);

return statearr_22882;
})();
if(cljs.core.truth_(inst_22335__$1)){
var statearr_22883_23076 = state_22762__$1;
(statearr_22883_23076[(1)] = (6));

} else {
var statearr_22884_23077 = state_22762__$1;
(statearr_22884_23077[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (66))){
var inst_22447 = (state_22762[(53)]);
var inst_22478 = (state_22762[(7)]);
var inst_22481 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22447,inst_22478);
var state_22762__$1 = state_22762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22762__$1,(69),inst_22481);
} else {
if((state_val_22763 === (107))){
var inst_22612 = (state_22762[(27)]);
var inst_22632 = cljs.core.count.call(null,inst_22612);
var inst_22633 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22632);
var state_22762__$1 = state_22762;
var statearr_22885_23078 = state_22762__$1;
(statearr_22885_23078[(2)] = inst_22633);

(statearr_22885_23078[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (23))){
var inst_22373 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22886_23079 = state_22762__$1;
(statearr_22886_23079[(2)] = inst_22373);

(statearr_22886_23079[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (47))){
var inst_22420 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22887_23080 = state_22762__$1;
(statearr_22887_23080[(2)] = inst_22420);

(statearr_22887_23080[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (35))){
var inst_22731 = (state_22762[(50)]);
var inst_22730 = (state_22762[(2)]);
var inst_22731__$1 = cljs.core.nth.call(null,inst_22730,(0),null);
var inst_22732 = cljs.core.nth.call(null,inst_22730,(1),null);
var inst_22733 = cljs.core.empty_QMARK_.call(null,inst_22731__$1);
var state_22762__$1 = (function (){var statearr_22888 = state_22762;
(statearr_22888[(10)] = inst_22732);

(statearr_22888[(50)] = inst_22731__$1);

return statearr_22888;
})();
if(inst_22733){
var statearr_22889_23081 = state_22762__$1;
(statearr_22889_23081[(1)] = (128));

} else {
var statearr_22890_23082 = state_22762__$1;
(statearr_22890_23082[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (127))){
var inst_22718 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22891_23083 = state_22762__$1;
(statearr_22891_23083[(2)] = inst_22718);

(statearr_22891_23083[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (82))){
var inst_22525 = (state_22762[(30)]);
var state_22762__$1 = state_22762;
var statearr_22892_23084 = state_22762__$1;
(statearr_22892_23084[(2)] = inst_22525);

(statearr_22892_23084[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (76))){
var inst_22511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22519 = flakes;
var inst_22520 = cljs.core.seq.call(null,inst_22519);
var inst_22521 = cljs.core.first.call(null,inst_22520);
var inst_22522 = cljs.core.next.call(null,inst_22520);
var inst_22523 = cljs.core.PersistentVector.EMPTY;
var inst_22524 = inst_22519;
var inst_22525 = inst_22523;
var state_22762__$1 = (function (){var statearr_22893 = state_22762;
(statearr_22893[(54)] = inst_22511);

(statearr_22893[(45)] = inst_22524);

(statearr_22893[(55)] = inst_22522);

(statearr_22893[(56)] = inst_22521);

(statearr_22893[(30)] = inst_22525);

return statearr_22893;
})();
var statearr_22894_23085 = state_22762__$1;
(statearr_22894_23085[(2)] = null);

(statearr_22894_23085[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (97))){
var inst_22598 = (state_22762[(40)]);
var inst_22591 = (state_22762[(48)]);
var inst_22597 = cljs.core.seq.call(null,inst_22591);
var inst_22598__$1 = cljs.core.first.call(null,inst_22597);
var inst_22599 = cljs.core.next.call(null,inst_22597);
var state_22762__$1 = (function (){var statearr_22895 = state_22762;
(statearr_22895[(46)] = inst_22599);

(statearr_22895[(40)] = inst_22598__$1);

return statearr_22895;
})();
if(cljs.core.truth_(inst_22598__$1)){
var statearr_22896_23086 = state_22762__$1;
(statearr_22896_23086[(1)] = (99));

} else {
var statearr_22897_23087 = state_22762__$1;
(statearr_22897_23087[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (19))){
var inst_22368 = (state_22762[(41)]);
var inst_22364 = (state_22762[(15)]);
var inst_22368__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22364);
var state_22762__$1 = (function (){var statearr_22898 = state_22762;
(statearr_22898[(41)] = inst_22368__$1);

return statearr_22898;
})();
if(cljs.core.truth_(inst_22368__$1)){
var statearr_22899_23088 = state_22762__$1;
(statearr_22899_23088[(1)] = (21));

} else {
var statearr_22900_23089 = state_22762__$1;
(statearr_22900_23089[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (57))){
var inst_22364 = (state_22762[(15)]);
var inst_22444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22445 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22446 = (new cljs.core.PersistentVector(null,3,(5),inst_22444,inst_22445,null));
var inst_22447 = cljs.core.select_keys.call(null,inst_22364,inst_22446);
var inst_22448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22456 = flakes;
var inst_22457 = cljs.core.seq.call(null,inst_22456);
var inst_22458 = cljs.core.first.call(null,inst_22457);
var inst_22459 = cljs.core.next.call(null,inst_22457);
var inst_22460 = cljs.core.PersistentVector.EMPTY;
var inst_22461 = inst_22456;
var inst_22462 = inst_22460;
var state_22762__$1 = (function (){var statearr_22901 = state_22762;
(statearr_22901[(51)] = inst_22448);

(statearr_22901[(9)] = inst_22462);

(statearr_22901[(57)] = inst_22459);

(statearr_22901[(53)] = inst_22447);

(statearr_22901[(24)] = inst_22461);

(statearr_22901[(58)] = inst_22458);

return statearr_22901;
})();
var statearr_22902_23090 = state_22762__$1;
(statearr_22902_23090[(2)] = null);

(statearr_22902_23090[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (68))){
var inst_22487 = (state_22762[(2)]);
var state_22762__$1 = (function (){var statearr_22903 = state_22762;
(statearr_22903[(22)] = inst_22487);

return statearr_22903;
})();
if(cljs.core.truth_(fuel)){
var statearr_22904_23091 = state_22762__$1;
(statearr_22904_23091[(1)] = (70));

} else {
var statearr_22905_23092 = state_22762__$1;
(statearr_22905_23092[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (11))){
var inst_22349 = (state_22762[(42)]);
var inst_22349__$1 = (state_22762[(2)]);
var inst_22351 = cljs.core.contains_QMARK_.call(null,inst_22349__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22352 = (!(inst_22351));
var state_22762__$1 = (function (){var statearr_22906 = state_22762;
(statearr_22906[(42)] = inst_22349__$1);

return statearr_22906;
})();
if(inst_22352){
var statearr_22907_23093 = state_22762__$1;
(statearr_22907_23093[(1)] = (12));

} else {
var statearr_22908_23094 = state_22762__$1;
(statearr_22908_23094[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (115))){
var inst_22708 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22910_23095 = state_22762__$1;
(statearr_22910_23095[(2)] = inst_22708);

(statearr_22910_23095[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (9))){
var inst_22343 = cljs.core.first.call(null,flakes);
var inst_22344 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22343);
var inst_22345 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22346 = fluree.db.query.fql_resp.wildcard_pred_spec.call(null,db,cache,inst_22344,inst_22345);
var state_22762__$1 = state_22762;
var statearr_22911_23096 = state_22762__$1;
(statearr_22911_23096[(2)] = inst_22346);

(statearr_22911_23096[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (5))){
var _ = (function (){var statearr_22912 = state_22762;
(statearr_22912[(4)] = cljs.core.rest.call(null,(state_22762[(4)])));

return statearr_22912;
})();
var state_22762__$1 = state_22762;
var ex22909 = (state_22762__$1[(2)]);
var statearr_22913_23097 = state_22762__$1;
(statearr_22913_23097[(5)] = ex22909);


if((ex22909 instanceof Error)){
var statearr_22914_23098 = state_22762__$1;
(statearr_22914_23098[(1)] = (4));

(statearr_22914_23098[(5)] = null);

} else {
throw ex22909;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (112))){
var inst_22720 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22915_23099 = state_22762__$1;
(statearr_22915_23099[(2)] = inst_22720);

(statearr_22915_23099[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (83))){
var inst_22565 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22916_23100 = state_22762__$1;
(statearr_22916_23100[(2)] = inst_22565);

(statearr_22916_23100[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (14))){
var inst_22349 = (state_22762[(42)]);
var inst_22357 = (state_22762[(2)]);
var inst_22358 = cljs.core.contains_QMARK_.call(null,inst_22349,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22359 = (!(inst_22358));
var state_22762__$1 = (function (){var statearr_22917 = state_22762;
(statearr_22917[(36)] = inst_22357);

return statearr_22917;
})();
if(inst_22359){
var statearr_22918_23101 = state_22762__$1;
(statearr_22918_23101[(1)] = (15));

} else {
var statearr_22919_23102 = state_22762__$1;
(statearr_22919_23102[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (45))){
var inst_22375 = (state_22762[(19)]);
var inst_22379 = (state_22762[(20)]);
var inst_22415 = cljs.core.get.call(null,acc,inst_22375);
var inst_22416 = cljs.core.count.call(null,inst_22415);
var inst_22417 = (inst_22416 >= inst_22379);
var state_22762__$1 = state_22762;
var statearr_22920_23103 = state_22762__$1;
(statearr_22920_23103[(2)] = inst_22417);

(statearr_22920_23103[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (53))){
var inst_22442 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22442)){
var statearr_22921_23104 = state_22762__$1;
(statearr_22921_23104[(1)] = (57));

} else {
var statearr_22922_23105 = state_22762__$1;
(statearr_22922_23105[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (78))){
var inst_22724 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22923_23106 = state_22762__$1;
(statearr_22923_23106[(2)] = inst_22724);

(statearr_22923_23106[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (132))){
var state_22762__$1 = state_22762;
var statearr_22925_23107 = state_22762__$1;
(statearr_22925_23107[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (26))){
var inst_22397 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22397)){
var statearr_22927_23108 = state_22762__$1;
(statearr_22927_23108[(1)] = (33));

} else {
var statearr_22928_23109 = state_22762__$1;
(statearr_22928_23109[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (123))){
var inst_22670 = (state_22762[(33)]);
var inst_22677 = (state_22762[(39)]);
var tmp22924 = inst_22670;
var inst_22669 = inst_22677;
var inst_22670__$1 = tmp22924;
var state_22762__$1 = (function (){var statearr_22929 = state_22762;
(statearr_22929[(33)] = inst_22670__$1);

(statearr_22929[(38)] = inst_22669);

return statearr_22929;
})();
var statearr_22930_23110 = state_22762__$1;
(statearr_22930_23110[(2)] = null);

(statearr_22930_23110[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (16))){
var inst_22357 = (state_22762[(36)]);
var state_22762__$1 = state_22762;
var statearr_22931_23111 = state_22762__$1;
(statearr_22931_23111[(2)] = inst_22357);

(statearr_22931_23111[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (133))){
var inst_22755 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22932_23112 = state_22762__$1;
(statearr_22932_23112[(2)] = inst_22755);

(statearr_22932_23112[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (81))){
var inst_22531 = (state_22762[(28)]);
var inst_22540 = (state_22762[(59)]);
var inst_22364 = (state_22762[(15)]);
var inst_22534 = cljs.core.deref.call(null,cache);
var inst_22535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22536 = fluree.db.flake.o.call(null,inst_22531);
var inst_22537 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22364);
var inst_22538 = [inst_22536,inst_22537];
var inst_22539 = (new cljs.core.PersistentVector(null,2,(5),inst_22535,inst_22538,null));
var inst_22540__$1 = cljs.core.get.call(null,inst_22534,inst_22539);
var state_22762__$1 = (function (){var statearr_22933 = state_22762;
(statearr_22933[(59)] = inst_22540__$1);

return statearr_22933;
})();
if(cljs.core.truth_(inst_22540__$1)){
var statearr_22934_23113 = state_22762__$1;
(statearr_22934_23113[(1)] = (84));

} else {
var statearr_22935_23114 = state_22762__$1;
(statearr_22935_23114[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (120))){
var inst_22704 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22936_23115 = state_22762__$1;
(statearr_22936_23115[(2)] = inst_22704);

(statearr_22936_23115[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (79))){
var inst_22531 = (state_22762[(28)]);
var inst_22524 = (state_22762[(45)]);
var inst_22530 = cljs.core.seq.call(null,inst_22524);
var inst_22531__$1 = cljs.core.first.call(null,inst_22530);
var inst_22532 = cljs.core.next.call(null,inst_22530);
var state_22762__$1 = (function (){var statearr_22937 = state_22762;
(statearr_22937[(28)] = inst_22531__$1);

(statearr_22937[(44)] = inst_22532);

return statearr_22937;
})();
if(cljs.core.truth_(inst_22531__$1)){
var statearr_22938_23116 = state_22762__$1;
(statearr_22938_23116[(1)] = (81));

} else {
var statearr_22939_23117 = state_22762__$1;
(statearr_22939_23117[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (38))){
var inst_22399 = (state_22762[(43)]);
var inst_22407 = (state_22762[(2)]);
var inst_22408 = [null,inst_22407];
var inst_22409 = (new cljs.core.PersistentVector(null,2,(5),inst_22399,inst_22408,null));
var state_22762__$1 = state_22762;
var statearr_22940_23118 = state_22762__$1;
(statearr_22940_23118[(2)] = inst_22409);

(statearr_22940_23118[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (126))){
var state_22762__$1 = state_22762;
var statearr_22941_23119 = state_22762__$1;
(statearr_22941_23119[(2)] = null);

(statearr_22941_23119[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (98))){
var inst_22578 = (state_22762[(60)]);
var inst_22642 = (state_22762[(2)]);
var inst_22643 = [inst_22642,offset_map];
var inst_22644 = (new cljs.core.PersistentVector(null,2,(5),inst_22578,inst_22643,null));
var state_22762__$1 = state_22762;
var statearr_22942_23120 = state_22762__$1;
(statearr_22942_23120[(2)] = inst_22644);

(statearr_22942_23120[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (124))){
var inst_22698 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22943_23121 = state_22762__$1;
(statearr_22943_23121[(2)] = inst_22698);

(statearr_22943_23121[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (87))){
var inst_22531 = (state_22762[(28)]);
var inst_22364 = (state_22762[(15)]);
var inst_22547 = (state_22762[(2)]);
var inst_22548 = fluree.db.util.async.throw_err.call(null,inst_22547);
var inst_22549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22550 = fluree.db.flake.o.call(null,inst_22531);
var inst_22551 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22364);
var inst_22552 = [inst_22550,inst_22551];
var inst_22553 = (new cljs.core.PersistentVector(null,2,(5),inst_22549,inst_22552,null));
var inst_22554 = fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_22553,inst_22548);
var state_22762__$1 = (function (){var statearr_22944 = state_22762;
(statearr_22944[(61)] = inst_22554);

return statearr_22944;
})();
var statearr_22945_23122 = state_22762__$1;
(statearr_22945_23122[(2)] = inst_22548);

(statearr_22945_23122[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (30))){
var inst_22382 = (state_22762[(17)]);
var inst_22387 = cljs.core.get.call(null,offset_map,inst_22382);
var inst_22388 = cljs.core.not_EQ_.call(null,(0),inst_22387);
var state_22762__$1 = state_22762;
var statearr_22946_23123 = state_22762__$1;
(statearr_22946_23123[(2)] = inst_22388);

(statearr_22946_23123[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (73))){
var inst_22462 = (state_22762[(9)]);
var inst_22487 = (state_22762[(22)]);
var inst_22496 = cljs.core.conj.call(null,inst_22462,inst_22487);
var state_22762__$1 = state_22762;
var statearr_22947_23124 = state_22762__$1;
(statearr_22947_23124[(2)] = inst_22496);

(statearr_22947_23124[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (96))){
var inst_22722 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
var statearr_22948_23125 = state_22762__$1;
(statearr_22948_23125[(2)] = inst_22722);

(statearr_22948_23125[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (10))){
var state_22762__$1 = state_22762;
var statearr_22949_23126 = state_22762__$1;
(statearr_22949_23126[(2)] = pred_spec);

(statearr_22949_23126[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (18))){
var inst_22365 = (state_22762[(52)]);
var state_22762__$1 = state_22762;
var statearr_22950_23127 = state_22762__$1;
(statearr_22950_23127[(2)] = inst_22365);

(statearr_22950_23127[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (105))){
var inst_22630 = (state_22762[(2)]);
var state_22762__$1 = (function (){var statearr_22951 = state_22762;
(statearr_22951[(47)] = inst_22630);

return statearr_22951;
})();
if(cljs.core.truth_(fuel)){
var statearr_22952_23128 = state_22762__$1;
(statearr_22952_23128[(1)] = (107));

} else {
var statearr_22953_23129 = state_22762__$1;
(statearr_22953_23129[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (52))){
var inst_22432 = (state_22762[(62)]);
var state_22762__$1 = state_22762;
var statearr_22954_23130 = state_22762__$1;
(statearr_22954_23130[(2)] = inst_22432);

(statearr_22954_23130[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (114))){
var inst_22664 = flakes;
var inst_22665 = cljs.core.seq.call(null,inst_22664);
var inst_22666 = cljs.core.first.call(null,inst_22665);
var inst_22667 = cljs.core.next.call(null,inst_22665);
var inst_22668 = cljs.core.PersistentVector.EMPTY;
var inst_22669 = inst_22664;
var inst_22670 = inst_22668;
var state_22762__$1 = (function (){var statearr_22955 = state_22762;
(statearr_22955[(63)] = inst_22667);

(statearr_22955[(33)] = inst_22670);

(statearr_22955[(38)] = inst_22669);

(statearr_22955[(64)] = inst_22666);

return statearr_22955;
})();
var statearr_22956_23131 = state_22762__$1;
(statearr_22956_23131[(2)] = null);

(statearr_22956_23131[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (67))){
var state_22762__$1 = state_22762;
var statearr_22957_23132 = state_22762__$1;
(statearr_22957_23132[(2)] = null);

(statearr_22957_23132[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (71))){
var state_22762__$1 = state_22762;
var statearr_22958_23133 = state_22762__$1;
(statearr_22958_23133[(2)] = null);

(statearr_22958_23133[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (42))){
var inst_22379 = (state_22762[(20)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22379)){
var statearr_22959_23134 = state_22762__$1;
(statearr_22959_23134[(1)] = (45));

} else {
var statearr_22960_23135 = state_22762__$1;
(statearr_22960_23135[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (80))){
var inst_22511 = (state_22762[(54)]);
var inst_22567 = (state_22762[(2)]);
var inst_22568 = [inst_22567,offset_map];
var inst_22569 = (new cljs.core.PersistentVector(null,2,(5),inst_22511,inst_22568,null));
var state_22762__$1 = state_22762;
var statearr_22961_23136 = state_22762__$1;
(statearr_22961_23136[(2)] = inst_22569);

(statearr_22961_23136[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (37))){
var inst_22382 = (state_22762[(17)]);
var inst_22381 = (state_22762[(18)]);
var inst_22404 = (inst_22381 - (1));
var inst_22405 = cljs.core.assoc.call(null,offset_map,inst_22382,inst_22404);
var state_22762__$1 = state_22762;
var statearr_22962_23137 = state_22762__$1;
(statearr_22962_23137[(2)] = inst_22405);

(statearr_22962_23137[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (63))){
var inst_22462 = (state_22762[(9)]);
var state_22762__$1 = state_22762;
var statearr_22963_23138 = state_22762__$1;
(statearr_22963_23138[(2)] = inst_22462);

(statearr_22963_23138[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (94))){
var inst_22578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22586 = flakes;
var inst_22587 = cljs.core.seq.call(null,inst_22586);
var inst_22588 = cljs.core.first.call(null,inst_22587);
var inst_22589 = cljs.core.next.call(null,inst_22587);
var inst_22590 = cljs.core.PersistentVector.EMPTY;
var inst_22591 = inst_22586;
var inst_22592 = inst_22590;
var state_22762__$1 = (function (){var statearr_22964 = state_22762;
(statearr_22964[(60)] = inst_22578);

(statearr_22964[(65)] = inst_22588);

(statearr_22964[(32)] = inst_22592);

(statearr_22964[(48)] = inst_22591);

(statearr_22964[(66)] = inst_22589);

return statearr_22964;
})();
var statearr_22965_23139 = state_22762__$1;
(statearr_22965_23139[(2)] = null);

(statearr_22965_23139[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (8))){
var inst_22341 = (state_22762[(2)]);
var state_22762__$1 = state_22762;
if(cljs.core.truth_(inst_22341)){
var statearr_22966_23140 = state_22762__$1;
(statearr_22966_23140[(1)] = (9));

} else {
var statearr_22967_23141 = state_22762__$1;
(statearr_22967_23141[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (49))){
var inst_22432 = (state_22762[(62)]);
var inst_22432__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_22762__$1 = (function (){var statearr_22968 = state_22762;
(statearr_22968[(62)] = inst_22432__$1);

return statearr_22968;
})();
if(inst_22432__$1){
var statearr_22969_23142 = state_22762__$1;
(statearr_22969_23142[(1)] = (51));

} else {
var statearr_22970_23143 = state_22762__$1;
(statearr_22970_23143[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22763 === (84))){
var inst_22540 = (state_22762[(59)]);
var state_22762__$1 = state_22762;
var statearr_22971_23144 = state_22762__$1;
(statearr_22971_23144[(2)] = inst_22540);

(statearr_22971_23144[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2746__auto____0 = (function (){
var statearr_22972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22972[(0)] = fluree$db$query$fql_resp$state_machine__2746__auto__);

(statearr_22972[(1)] = (1));

return statearr_22972;
});
var fluree$db$query$fql_resp$state_machine__2746__auto____1 = (function (state_22762){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22973){var ex__2749__auto__ = e22973;
var statearr_22974_23145 = state_22762;
(statearr_22974_23145[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22762[(4)]))){
var statearr_22975_23146 = state_22762;
(statearr_22975_23146[(1)] = cljs.core.first.call(null,(state_22762[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23147 = state_22762;
state_22762 = G__23147;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2746__auto__ = function(state_22762){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2746__auto____1.call(this,state_22762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2746__auto____0;
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2746__auto____1;
return fluree$db$query$fql_resp$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22976 = f__2769__auto__.call(null);
(statearr_22976[(6)] = c__2768__auto__);

return statearr_22976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__23149 = res;
var G__23149__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__23148_SHARP_){
return cljs.core.get.call(null,p1__23148_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__23149):G__23149);
var G__23149__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__23149__$1):G__23149__$1);
var G__23149__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__23149__$2):G__23149__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__23149__$3);
} else {
return G__23149__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23330){
var state_val_23331 = (state_23330[(1)]);
if((state_val_23331 === (7))){
var state_23330__$1 = state_23330;
var statearr_23332_23418 = state_23330__$1;
(statearr_23332_23418[(2)] = null);

(statearr_23332_23418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (20))){
var inst_23188 = cljs.core.PersistentHashMap.EMPTY;
var state_23330__$1 = state_23330;
var statearr_23333_23419 = state_23330__$1;
(statearr_23333_23419[(2)] = inst_23188);

(statearr_23333_23419[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (27))){
var inst_23176 = (state_23330[(7)]);
var inst_23170 = (state_23330[(8)]);
var inst_23206 = (state_23330[(9)]);
var inst_23190 = (state_23330[(10)]);
var inst_23309 = (state_23330[(2)]);
var inst_23310 = (function (){var top_level_subject = inst_23170;
var select_spec = inst_23176;
var base_acc = inst_23190;
var acc_PLUS_refs = inst_23206;
var result = inst_23309;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23311 = cljs.core.PersistentVector.EMPTY;
var inst_23312 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23176);
var inst_23313 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23312);
var inst_23314 = cljs.core.vals.call(null,inst_23313);
var inst_23315 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23176);
var inst_23316 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23315);
var inst_23317 = cljs.core.vals.call(null,inst_23316);
var inst_23318 = cljs.core.concat.call(null,inst_23314,inst_23317);
var inst_23319 = cljs.core.reduce.call(null,inst_23310,inst_23311,inst_23318);
var inst_23321 = (function (){var top_level_subject = inst_23170;
var select_spec = inst_23176;
var base_acc = inst_23190;
var acc_PLUS_refs = inst_23206;
var result = inst_23309;
var sort_preds = inst_23319;
return (function (acc,p__23320){
var vec__23334 = p__23320;
var selectPred = cljs.core.nth.call(null,vec__23334,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23334,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23334,(2),null);
var limit = cljs.core.nth.call(null,vec__23334,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23322 = cljs.core.reduce.call(null,inst_23321,inst_23309,inst_23319);
var state_23330__$1 = state_23330;
var statearr_23337_23420 = state_23330__$1;
(statearr_23337_23420[(2)] = inst_23322);

(statearr_23337_23420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (1))){
var state_23330__$1 = state_23330;
var statearr_23338_23421 = state_23330__$1;
(statearr_23338_23421[(2)] = null);

(statearr_23338_23421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (24))){
var inst_23206 = (state_23330[(9)]);
var inst_23206__$1 = (state_23330[(2)]);
var inst_23207 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23208 = cljs.core.PersistentHashMap.EMPTY;
var inst_23209 = inst_23207;
var inst_23210 = inst_23206__$1;
var inst_23211 = inst_23208;
var state_23330__$1 = (function (){var statearr_23339 = state_23330;
(statearr_23339[(11)] = inst_23210);

(statearr_23339[(12)] = inst_23211);

(statearr_23339[(9)] = inst_23206__$1);

(statearr_23339[(13)] = inst_23209);

return statearr_23339;
})();
var statearr_23340_23422 = state_23330__$1;
(statearr_23340_23422[(2)] = null);

(statearr_23340_23422[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (39))){
var inst_23226 = (state_23330[(14)]);
var inst_23219 = (state_23330[(15)]);
var inst_23176 = (state_23330[(7)]);
var inst_23210 = (state_23330[(11)]);
var inst_23255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23256 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23210,inst_23176,inst_23219,inst_23226,false);
var state_23330__$1 = (function (){var statearr_23341 = state_23330;
(statearr_23341[(16)] = inst_23255);

return statearr_23341;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23330__$1,(42),inst_23256);
} else {
if((state_val_23331 === (46))){
var inst_23219 = (state_23330[(15)]);
var inst_23211 = (state_23330[(12)]);
var inst_23209 = (state_23330[(13)]);
var inst_23273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23274 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23275 = cljs.core.first.call(null,inst_23219);
var inst_23276 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23275);
var inst_23277 = [inst_23276];
var inst_23278 = cljs.core.PersistentHashMap.fromArrays(inst_23274,inst_23277);
var inst_23279 = cljs.core.rest.call(null,inst_23209);
var inst_23280 = [inst_23278,inst_23279,inst_23211];
var inst_23281 = (new cljs.core.PersistentVector(null,3,(5),inst_23273,inst_23280,null));
var state_23330__$1 = state_23330;
var statearr_23342_23423 = state_23330__$1;
(statearr_23342_23423[(2)] = inst_23281);

(statearr_23342_23423[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (4))){
var inst_23150 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
var statearr_23343_23424 = state_23330__$1;
(statearr_23343_23424[(2)] = inst_23150);

(statearr_23343_23424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (15))){
var inst_23177 = (state_23330[(17)]);
var inst_23176 = (state_23330[(7)]);
var inst_23176__$1 = (state_23330[(2)]);
var inst_23177__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23176__$1);
var state_23330__$1 = (function (){var statearr_23344 = state_23330;
(statearr_23344[(17)] = inst_23177__$1);

(statearr_23344[(7)] = inst_23176__$1);

return statearr_23344;
})();
if(cljs.core.truth_(inst_23177__$1)){
var statearr_23345_23425 = state_23330__$1;
(statearr_23345_23425[(1)] = (16));

} else {
var statearr_23346_23426 = state_23330__$1;
(statearr_23346_23426[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (48))){
var inst_23292 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
var statearr_23347_23427 = state_23330__$1;
(statearr_23347_23427[(2)] = inst_23292);

(statearr_23347_23427[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (50))){
var state_23330__$1 = state_23330;
var statearr_23348_23428 = state_23330__$1;
(statearr_23348_23428[(2)] = null);

(statearr_23348_23428[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (21))){
var inst_23176 = (state_23330[(7)]);
var inst_23190 = (state_23330[(2)]);
var inst_23191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23192 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23193 = (new cljs.core.PersistentVector(null,2,(5),inst_23191,inst_23192,null));
var inst_23194 = cljs.core.get_in.call(null,inst_23176,inst_23193);
var state_23330__$1 = (function (){var statearr_23349 = state_23330;
(statearr_23349[(10)] = inst_23190);

return statearr_23349;
})();
if(cljs.core.truth_(inst_23194)){
var statearr_23350_23429 = state_23330__$1;
(statearr_23350_23429[(1)] = (22));

} else {
var statearr_23351_23430 = state_23330__$1;
(statearr_23351_23430[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (31))){
var inst_23225 = (state_23330[(18)]);
var inst_23219 = (state_23330[(15)]);
var inst_23210 = (state_23330[(11)]);
var inst_23229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23230 = fluree.db.query.fql_resp.flake__GT_recur.call(null,db,inst_23219,inst_23225,inst_23210,fuel,max_fuel,cache);
var state_23330__$1 = (function (){var statearr_23352 = state_23330;
(statearr_23352[(19)] = inst_23229);

return statearr_23352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23330__$1,(34),inst_23230);
} else {
if((state_val_23331 === (32))){
var inst_23225 = (state_23330[(18)]);
var state_23330__$1 = state_23330;
if(cljs.core.truth_(inst_23225)){
var statearr_23353_23431 = state_23330__$1;
(statearr_23353_23431[(1)] = (35));

} else {
var statearr_23354_23432 = state_23330__$1;
(statearr_23354_23432[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (40))){
var inst_23176 = (state_23330[(7)]);
var inst_23266 = (state_23330[(20)]);
var inst_23265 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23176);
var inst_23266__$1 = cljs.core.empty_QMARK_.call(null,inst_23265);
var state_23330__$1 = (function (){var statearr_23355 = state_23330;
(statearr_23355[(20)] = inst_23266__$1);

return statearr_23355;
})();
if(inst_23266__$1){
var statearr_23356_23433 = state_23330__$1;
(statearr_23356_23433[(1)] = (43));

} else {
var statearr_23357_23434 = state_23330__$1;
(statearr_23357_23434[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (33))){
var inst_23219 = (state_23330[(15)]);
var inst_23298 = (state_23330[(2)]);
var inst_23299 = cljs.core.nth.call(null,inst_23298,(0),null);
var inst_23300 = cljs.core.nth.call(null,inst_23298,(1),null);
var inst_23301 = cljs.core.nth.call(null,inst_23298,(2),null);
var inst_23302 = cljs.core.first.call(null,inst_23219);
var inst_23303 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23302);
var inst_23304 = cljs.core.assoc.call(null,inst_23299,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23303);
var inst_23209 = inst_23300;
var inst_23210 = inst_23304;
var inst_23211 = inst_23301;
var state_23330__$1 = (function (){var statearr_23358 = state_23330;
(statearr_23358[(11)] = inst_23210);

(statearr_23358[(12)] = inst_23211);

(statearr_23358[(13)] = inst_23209);

return statearr_23358;
})();
var statearr_23359_23435 = state_23330__$1;
(statearr_23359_23435[(2)] = null);

(statearr_23359_23435[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (13))){
var inst_23170 = (state_23330[(8)]);
var inst_23173 = fluree.db.query.fql_resp.full_select_spec.call(null,db,cache,base_select_spec,inst_23170);
var state_23330__$1 = state_23330;
var statearr_23360_23436 = state_23330__$1;
(statearr_23360_23436[(2)] = inst_23173);

(statearr_23360_23436[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (22))){
var inst_23176 = (state_23330[(7)]);
var inst_23196 = cljs.core.first.call(null,flakes);
var inst_23197 = fluree.db.flake.s.call(null,inst_23196);
var inst_23198 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs.call(null,inst_23176);
var inst_23199 = fluree.db.query.fql_resp.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23197,inst_23198);
var state_23330__$1 = state_23330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23330__$1,(25),inst_23199);
} else {
if((state_val_23331 === (36))){
var inst_23176 = (state_23330[(7)]);
var inst_23253 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23176);
var state_23330__$1 = state_23330;
if(cljs.core.truth_(inst_23253)){
var statearr_23361_23437 = state_23330__$1;
(statearr_23361_23437[(1)] = (39));

} else {
var statearr_23362_23438 = state_23330__$1;
(statearr_23362_23438[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (41))){
var inst_23294 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
var statearr_23363_23439 = state_23330__$1;
(statearr_23363_23439[(2)] = inst_23294);

(statearr_23363_23439[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (43))){
var inst_23176 = (state_23330[(7)]);
var inst_23268 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23176);
var state_23330__$1 = state_23330;
var statearr_23364_23440 = state_23330__$1;
(statearr_23364_23440[(2)] = inst_23268);

(statearr_23364_23440[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (29))){
var inst_23225 = (state_23330[(18)]);
var inst_23219 = (state_23330[(15)]);
var inst_23176 = (state_23330[(7)]);
var inst_23209 = (state_23330[(13)]);
var inst_23219__$1 = cljs.core.first.call(null,inst_23209);
var inst_23220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23221 = cljs.core.first.call(null,inst_23219__$1);
var inst_23222 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23221);
var inst_23223 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23222];
var inst_23224 = (new cljs.core.PersistentVector(null,3,(5),inst_23220,inst_23223,null));
var inst_23225__$1 = cljs.core.get_in.call(null,inst_23176,inst_23224);
var inst_23226 = fluree.db.query.fql_resp.component_follow_QMARK_.call(null,inst_23225__$1,inst_23176);
var inst_23227 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23225__$1);
var state_23330__$1 = (function (){var statearr_23365 = state_23330;
(statearr_23365[(14)] = inst_23226);

(statearr_23365[(18)] = inst_23225__$1);

(statearr_23365[(15)] = inst_23219__$1);

return statearr_23365;
})();
if(cljs.core.truth_(inst_23227)){
var statearr_23366_23441 = state_23330__$1;
(statearr_23366_23441[(1)] = (31));

} else {
var statearr_23367_23442 = state_23330__$1;
(statearr_23367_23442[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (44))){
var inst_23266 = (state_23330[(20)]);
var state_23330__$1 = state_23330;
var statearr_23368_23443 = state_23330__$1;
(statearr_23368_23443[(2)] = inst_23266);

(statearr_23368_23443[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (6))){
var state_23330__$1 = state_23330;
var statearr_23369_23444 = state_23330__$1;
(statearr_23369_23444[(2)] = null);

(statearr_23369_23444[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (28))){
var inst_23210 = (state_23330[(11)]);
var state_23330__$1 = state_23330;
var statearr_23370_23445 = state_23330__$1;
(statearr_23370_23445[(2)] = inst_23210);

(statearr_23370_23445[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (51))){
var inst_23290 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
var statearr_23371_23446 = state_23330__$1;
(statearr_23371_23446[(2)] = inst_23290);

(statearr_23371_23446[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (25))){
var inst_23190 = (state_23330[(10)]);
var inst_23201 = (state_23330[(2)]);
var inst_23202 = fluree.db.util.async.throw_err.call(null,inst_23201);
var inst_23203 = cljs.core.merge.call(null,inst_23190,inst_23202);
var state_23330__$1 = state_23330;
var statearr_23372_23447 = state_23330__$1;
(statearr_23372_23447[(2)] = inst_23203);

(statearr_23372_23447[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (34))){
var inst_23211 = (state_23330[(12)]);
var inst_23229 = (state_23330[(19)]);
var inst_23209 = (state_23330[(13)]);
var inst_23232 = (state_23330[(2)]);
var inst_23233 = fluree.db.util.async.throw_err.call(null,inst_23232);
var inst_23234 = cljs.core.rest.call(null,inst_23209);
var inst_23235 = [inst_23233,inst_23234,inst_23211];
var inst_23236 = (new cljs.core.PersistentVector(null,3,(5),inst_23229,inst_23235,null));
var state_23330__$1 = state_23330;
var statearr_23373_23448 = state_23330__$1;
(statearr_23373_23448[(2)] = inst_23236);

(statearr_23373_23448[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (17))){
var inst_23176 = (state_23330[(7)]);
var inst_23180 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23176);
var state_23330__$1 = state_23330;
var statearr_23375_23449 = state_23330__$1;
(statearr_23375_23449[(2)] = inst_23180);

(statearr_23375_23449[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (3))){
var inst_23328 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23330__$1,inst_23328);
} else {
if((state_val_23331 === (12))){
var _ = (function (){var statearr_23376 = state_23330;
(statearr_23376[(4)] = cljs.core.rest.call(null,(state_23330[(4)])));

return statearr_23376;
})();
var state_23330__$1 = state_23330;
var ex23374 = (state_23330__$1[(2)]);
var statearr_23377_23450 = state_23330__$1;
(statearr_23377_23450[(5)] = ex23374);


var statearr_23378_23451 = state_23330__$1;
(statearr_23378_23451[(1)] = (11));

(statearr_23378_23451[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (2))){
var _ = (function (){var statearr_23379 = state_23330;
(statearr_23379[(4)] = cljs.core.cons.call(null,(5),(state_23330[(4)])));

return statearr_23379;
})();
var inst_23156 = cljs.core.not_empty.call(null,flakes);
var state_23330__$1 = state_23330;
if(cljs.core.truth_(inst_23156)){
var statearr_23380_23452 = state_23330__$1;
(statearr_23380_23452[(1)] = (6));

} else {
var statearr_23381_23453 = state_23330__$1;
(statearr_23381_23453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (23))){
var inst_23190 = (state_23330[(10)]);
var state_23330__$1 = state_23330;
var statearr_23382_23454 = state_23330__$1;
(statearr_23382_23454[(2)] = inst_23190);

(statearr_23382_23454[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (47))){
var state_23330__$1 = state_23330;
var statearr_23383_23455 = state_23330__$1;
(statearr_23383_23455[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (35))){
var inst_23226 = (state_23330[(14)]);
var inst_23225 = (state_23330[(18)]);
var inst_23219 = (state_23330[(15)]);
var inst_23210 = (state_23330[(11)]);
var inst_23211 = (state_23330[(12)]);
var inst_23242 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23210,inst_23225,inst_23219,inst_23226,false,inst_23211);
var state_23330__$1 = state_23330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23330__$1,(38),inst_23242);
} else {
if((state_val_23331 === (19))){
var inst_23170 = (state_23330[(8)]);
var inst_23184 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23185 = [inst_23170];
var inst_23186 = cljs.core.PersistentHashMap.fromArrays(inst_23184,inst_23185);
var state_23330__$1 = state_23330;
var statearr_23385_23456 = state_23330__$1;
(statearr_23385_23456[(2)] = inst_23186);

(statearr_23385_23456[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (11))){
var inst_23158 = (state_23330[(2)]);
var inst_23159 = fluree.db.util.log.error.call(null,inst_23158);
var inst_23160 = (function(){throw inst_23158})();
var state_23330__$1 = (function (){var statearr_23387 = state_23330;
(statearr_23387[(21)] = inst_23159);

return statearr_23387;
})();
var statearr_23388_23457 = state_23330__$1;
(statearr_23388_23457[(2)] = inst_23160);

(statearr_23388_23457[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (9))){
var _ = (function (){var statearr_23389 = state_23330;
(statearr_23389[(4)] = cljs.core.cons.call(null,(12),(state_23330[(4)])));

return statearr_23389;
})();
var inst_23166 = cljs.core.first.call(null,flakes);
var inst_23167 = fluree.db.flake.s.call(null,inst_23166);
var ___$1 = (function (){var statearr_23390 = state_23330;
(statearr_23390[(4)] = cljs.core.rest.call(null,(state_23330[(4)])));

return statearr_23390;
})();
var state_23330__$1 = state_23330;
var statearr_23391_23458 = state_23330__$1;
(statearr_23391_23458[(2)] = inst_23167);

(statearr_23391_23458[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (5))){
var _ = (function (){var statearr_23392 = state_23330;
(statearr_23392[(4)] = cljs.core.rest.call(null,(state_23330[(4)])));

return statearr_23392;
})();
var state_23330__$1 = state_23330;
var ex23386 = (state_23330__$1[(2)]);
var statearr_23393_23459 = state_23330__$1;
(statearr_23393_23459[(5)] = ex23386);


if((ex23386 instanceof Error)){
var statearr_23394_23460 = state_23330__$1;
(statearr_23394_23460[(1)] = (4));

(statearr_23394_23460[(5)] = null);

} else {
throw ex23386;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (14))){
var state_23330__$1 = state_23330;
var statearr_23395_23461 = state_23330__$1;
(statearr_23395_23461[(2)] = base_select_spec);

(statearr_23395_23461[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (45))){
var inst_23271 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
if(cljs.core.truth_(inst_23271)){
var statearr_23396_23462 = state_23330__$1;
(statearr_23396_23462[(1)] = (46));

} else {
var statearr_23397_23463 = state_23330__$1;
(statearr_23397_23463[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (26))){
var inst_23209 = (state_23330[(13)]);
var inst_23213 = cljs.core.empty_QMARK_.call(null,inst_23209);
var state_23330__$1 = state_23330;
if(inst_23213){
var statearr_23398_23464 = state_23330__$1;
(statearr_23398_23464[(1)] = (28));

} else {
var statearr_23399_23465 = state_23330__$1;
(statearr_23399_23465[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (16))){
var inst_23177 = (state_23330[(17)]);
var state_23330__$1 = state_23330;
var statearr_23400_23466 = state_23330__$1;
(statearr_23400_23466[(2)] = inst_23177);

(statearr_23400_23466[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (38))){
var inst_23209 = (state_23330[(13)]);
var inst_23244 = (state_23330[(2)]);
var inst_23245 = fluree.db.util.async.throw_err.call(null,inst_23244);
var inst_23246 = cljs.core.nth.call(null,inst_23245,(0),null);
var inst_23247 = cljs.core.nth.call(null,inst_23245,(1),null);
var inst_23248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23249 = cljs.core.rest.call(null,inst_23209);
var inst_23250 = [inst_23246,inst_23249,inst_23247];
var inst_23251 = (new cljs.core.PersistentVector(null,3,(5),inst_23248,inst_23250,null));
var state_23330__$1 = state_23330;
var statearr_23401_23467 = state_23330__$1;
(statearr_23401_23467[(2)] = inst_23251);

(statearr_23401_23467[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (30))){
var inst_23307 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
var statearr_23402_23468 = state_23330__$1;
(statearr_23402_23468[(2)] = inst_23307);

(statearr_23402_23468[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (10))){
var inst_23170 = (state_23330[(2)]);
var inst_23171 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23330__$1 = (function (){var statearr_23403 = state_23330;
(statearr_23403[(8)] = inst_23170);

return statearr_23403;
})();
if(cljs.core.truth_(inst_23171)){
var statearr_23404_23469 = state_23330__$1;
(statearr_23404_23469[(1)] = (13));

} else {
var statearr_23405_23470 = state_23330__$1;
(statearr_23405_23470[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (18))){
var inst_23182 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
if(cljs.core.truth_(inst_23182)){
var statearr_23406_23471 = state_23330__$1;
(statearr_23406_23471[(1)] = (19));

} else {
var statearr_23407_23472 = state_23330__$1;
(statearr_23407_23472[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (42))){
var inst_23255 = (state_23330[(16)]);
var inst_23211 = (state_23330[(12)]);
var inst_23209 = (state_23330[(13)]);
var inst_23258 = (state_23330[(2)]);
var inst_23259 = fluree.db.util.async.throw_err.call(null,inst_23258);
var inst_23260 = cljs.core.first.call(null,inst_23259);
var inst_23261 = cljs.core.rest.call(null,inst_23209);
var inst_23262 = [inst_23260,inst_23261,inst_23211];
var inst_23263 = (new cljs.core.PersistentVector(null,3,(5),inst_23255,inst_23262,null));
var state_23330__$1 = state_23330;
var statearr_23408_23473 = state_23330__$1;
(statearr_23408_23473[(2)] = inst_23263);

(statearr_23408_23473[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (37))){
var inst_23296 = (state_23330[(2)]);
var state_23330__$1 = state_23330;
var statearr_23409_23474 = state_23330__$1;
(statearr_23409_23474[(2)] = inst_23296);

(statearr_23409_23474[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (8))){
var inst_23325 = (state_23330[(2)]);
var _ = (function (){var statearr_23410 = state_23330;
(statearr_23410[(4)] = cljs.core.rest.call(null,(state_23330[(4)])));

return statearr_23410;
})();
var state_23330__$1 = state_23330;
var statearr_23411_23475 = state_23330__$1;
(statearr_23411_23475[(2)] = inst_23325);

(statearr_23411_23475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23331 === (49))){
var inst_23210 = (state_23330[(11)]);
var inst_23211 = (state_23330[(12)]);
var inst_23209 = (state_23330[(13)]);
var inst_23284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23285 = cljs.core.rest.call(null,inst_23209);
var inst_23286 = [inst_23210,inst_23285,inst_23211];
var inst_23287 = (new cljs.core.PersistentVector(null,3,(5),inst_23284,inst_23286,null));
var state_23330__$1 = state_23330;
var statearr_23412_23476 = state_23330__$1;
(statearr_23412_23476[(2)] = inst_23287);

(statearr_23412_23476[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0 = (function (){
var statearr_23413 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23413[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__);

(statearr_23413[(1)] = (1));

return statearr_23413;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1 = (function (state_23330){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23414){var ex__2749__auto__ = e23414;
var statearr_23415_23477 = state_23330;
(statearr_23415_23477[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23330[(4)]))){
var statearr_23416_23478 = state_23330;
(statearr_23416_23478[(1)] = cljs.core.first.call(null,(state_23330[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23479 = state_23330;
state_23330 = G__23479;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = function(state_23330){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1.call(this,state_23330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23417 = f__2769__auto__.call(null);
(statearr_23417[(6)] = c__2768__auto__);

return statearr_23417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
