// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k26872,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__26876 = k26872;
var G__26876__$1 = (((G__26876 instanceof cljs.core.Keyword))?G__26876.fqn:null);
switch (G__26876__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26872,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__26877){
var vec__26878 = p__26877;
var k__5367__auto__ = cljs.core.nth.call(null,vec__26878,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__26878,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26871){
var self__ = this;
var G__26871__$1 = this;
return (new cljs.core.RecordIter((0),G__26871__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26873,other26874){
var self__ = this;
var this26873__$1 = this;
return (((!((other26874 == null)))) && ((((this26873__$1.constructor === other26874.constructor)) && (((cljs.core._EQ_.call(null,this26873__$1.conn,other26874.conn)) && (((cljs.core._EQ_.call(null,this26873__$1.network,other26874.network)) && (((cljs.core._EQ_.call(null,this26873__$1.ledger_id,other26874.ledger_id)) && (((cljs.core._EQ_.call(null,this26873__$1.db_name,other26874.db_name)) && (((cljs.core._EQ_.call(null,this26873__$1.update_chan,other26874.update_chan)) && (((cljs.core._EQ_.call(null,this26873__$1.transact_chan,other26874.transact_chan)) && (((cljs.core._EQ_.call(null,this26873__$1.state,other26874.state)) && (((cljs.core._EQ_.call(null,this26873__$1.schema_cache,other26874.schema_cache)) && (((cljs.core._EQ_.call(null,this26873__$1.blank_db,other26874.blank_db)) && (((cljs.core._EQ_.call(null,this26873__$1.close,other26874.close)) && (((cljs.core._EQ_.call(null,this26873__$1.id,other26874.id)) && (cljs.core._EQ_.call(null,this26873__$1.__extmap,other26874.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k26872){
var self__ = this;
var this__5350__auto____$1 = this;
var G__26881 = k26872;
var G__26881__$1 = (((G__26881 instanceof cljs.core.Keyword))?G__26881.fqn:null);
switch (G__26881__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k26872);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__26871){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__26882 = cljs.core.keyword_identical_QMARK_;
var expr__26883 = k__5352__auto__;
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26883))){
return (new fluree.db.session.DbSession(G__26871,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,G__26871,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__26871,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__26871,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__26871,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__26871,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__26871,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__26871,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__26871,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__26871,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26882.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__26883))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__26871,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__26871),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__26871){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__26871,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__26875){
var extmap__5385__auto__ = (function (){var G__26885 = cljs.core.dissoc.call(null,G__26875,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__26875)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__26885);
} else {
return G__26885;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__26875),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__26875),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__26888 = session;
var map__26888__$1 = cljs.core.__destructure_map.call(null,map__26888);
var network = cljs.core.get.call(null,map__26888__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__26888__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26930){
var state_val_26931 = (state_26930[(1)]);
if((state_val_26931 === (7))){
var inst_26904 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_26905 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26906 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_26907 = cljs.core.PersistentHashMap.fromArrays(inst_26905,inst_26906);
var inst_26908 = cljs.core.ex_info.call(null,inst_26904,inst_26907);
var inst_26909 = (function(){throw inst_26908})();
var state_26930__$1 = state_26930;
var statearr_26932_26955 = state_26930__$1;
(statearr_26932_26955[(2)] = inst_26909);

(statearr_26932_26955[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (1))){
var state_26930__$1 = state_26930;
var statearr_26933_26956 = state_26930__$1;
(statearr_26933_26956[(2)] = null);

(statearr_26933_26956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (4))){
var inst_26889 = (state_26930[(2)]);
var state_26930__$1 = state_26930;
var statearr_26934_26957 = state_26930__$1;
(statearr_26934_26957[(2)] = inst_26889);

(statearr_26934_26957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (6))){
var inst_26901 = (state_26930[(7)]);
var inst_26900 = (state_26930[(2)]);
var inst_26901__$1 = fluree.db.util.async.throw_err.call(null,inst_26900);
var inst_26902 = cljs.core.empty_QMARK_.call(null,inst_26901__$1);
var state_26930__$1 = (function (){var statearr_26935 = state_26930;
(statearr_26935[(7)] = inst_26901__$1);

return statearr_26935;
})();
if(inst_26902){
var statearr_26936_26958 = state_26930__$1;
(statearr_26936_26958[(1)] = (7));

} else {
var statearr_26937_26959 = state_26930__$1;
(statearr_26937_26959[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (3))){
var inst_26928 = (state_26930[(2)]);
var state_26930__$1 = state_26930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26930__$1,inst_26928);
} else {
if((state_val_26931 === (12))){
var inst_26923 = (state_26930[(2)]);
var state_26930__$1 = state_26930;
var statearr_26938_26960 = state_26930__$1;
(statearr_26938_26960[(2)] = inst_26923);

(statearr_26938_26960[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (2))){
var _ = (function (){var statearr_26939 = state_26930;
(statearr_26939[(4)] = cljs.core.cons.call(null,(5),(state_26930[(4)])));

return statearr_26939;
})();
var inst_26895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26896 = [network,ledger_id];
var inst_26897 = (new cljs.core.PersistentVector(null,2,(5),inst_26895,inst_26896,null));
var inst_26898 = fluree.db.operations.ledger_info_async.call(null,conn,inst_26897);
var state_26930__$1 = state_26930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26930__$1,(6),inst_26898);
} else {
if((state_val_26931 === (11))){
var inst_26901 = (state_26930[(7)]);
var state_26930__$1 = state_26930;
var statearr_26941_26961 = state_26930__$1;
(statearr_26941_26961[(2)] = inst_26901);

(statearr_26941_26961[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (9))){
var inst_26925 = (state_26930[(2)]);
var _ = (function (){var statearr_26942 = state_26930;
(statearr_26942[(4)] = cljs.core.rest.call(null,(state_26930[(4)])));

return statearr_26942;
})();
var state_26930__$1 = state_26930;
var statearr_26943_26962 = state_26930__$1;
(statearr_26943_26962[(2)] = inst_26925);

(statearr_26943_26962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (5))){
var _ = (function (){var statearr_26944 = state_26930;
(statearr_26944[(4)] = cljs.core.rest.call(null,(state_26930[(4)])));

return statearr_26944;
})();
var state_26930__$1 = state_26930;
var ex26940 = (state_26930__$1[(2)]);
var statearr_26945_26963 = state_26930__$1;
(statearr_26945_26963[(5)] = ex26940);


if((ex26940 instanceof Error)){
var statearr_26946_26964 = state_26930__$1;
(statearr_26946_26964[(1)] = (4));

(statearr_26946_26964[(5)] = null);

} else {
throw ex26940;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (10))){
var inst_26901 = (state_26930[(7)]);
var inst_26914 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_26901);
var inst_26915 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26914),"."].join('');
var inst_26916 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26917 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_26918 = cljs.core.PersistentHashMap.fromArrays(inst_26916,inst_26917);
var inst_26919 = cljs.core.ex_info.call(null,inst_26915,inst_26918);
var inst_26920 = (function(){throw inst_26919})();
var state_26930__$1 = state_26930;
var statearr_26947_26965 = state_26930__$1;
(statearr_26947_26965[(2)] = inst_26920);

(statearr_26947_26965[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26931 === (8))){
var inst_26901 = (state_26930[(7)]);
var inst_26911 = fluree.db.session.ready_QMARK_.call(null,inst_26901);
var inst_26912 = (!(inst_26911));
var state_26930__$1 = state_26930;
if(inst_26912){
var statearr_26948_26966 = state_26930__$1;
(statearr_26948_26966[(1)] = (10));

} else {
var statearr_26949_26967 = state_26930__$1;
(statearr_26949_26967[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0 = (function (){
var statearr_26950 = [null,null,null,null,null,null,null,null];
(statearr_26950[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2746__auto__);

(statearr_26950[(1)] = (1));

return statearr_26950;
});
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1 = (function (state_26930){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26951){var ex__2749__auto__ = e26951;
var statearr_26952_26968 = state_26930;
(statearr_26952_26968[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26930[(4)]))){
var statearr_26953_26969 = state_26930;
(statearr_26953_26969[(1)] = cljs.core.first.call(null,(state_26930[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26970 = state_26930;
state_26930 = G__26970;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = function(state_26930){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1.call(this,state_26930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26954 = f__2769__auto__.call(null);
(statearr_26954[(6)] = c__2768__auto__);

return statearr_26954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__26971){
var map__26972 = p__26971;
var map__26972__$1 = cljs.core.__destructure_map.call(null,map__26972);
var blank_db = map__26972__$1;
var network = cljs.core.get.call(null,map__26972__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__26972__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27047){
var state_val_27048 = (state_27047[(1)]);
if((state_val_27048 === (7))){
var inst_26990 = (state_27047[(7)]);
var inst_26989 = (state_27047[(2)]);
var inst_26990__$1 = fluree.db.util.async.throw_err.call(null,inst_26989);
var state_27047__$1 = (function (){var statearr_27049 = state_27047;
(statearr_27049[(7)] = inst_26990__$1);

return statearr_27049;
})();
if(cljs.core.truth_(inst_26990__$1)){
var statearr_27050_27085 = state_27047__$1;
(statearr_27050_27085[(1)] = (8));

} else {
var statearr_27051_27086 = state_27047__$1;
(statearr_27051_27086[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (20))){
var inst_26995 = (state_27047[(8)]);
var inst_27028 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26995)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27029 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27030 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27031 = cljs.core.PersistentHashMap.fromArrays(inst_27029,inst_27030);
var inst_27032 = cljs.core.ex_info.call(null,inst_27028,inst_27031);
var inst_27033 = (function(){throw inst_27032})();
var state_27047__$1 = state_27047;
var statearr_27052_27087 = state_27047__$1;
(statearr_27052_27087[(2)] = inst_27033);

(statearr_27052_27087[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (1))){
var state_27047__$1 = state_27047;
var statearr_27053_27088 = state_27047__$1;
(statearr_27053_27088[(2)] = null);

(statearr_27053_27088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (4))){
var inst_26973 = (state_27047[(2)]);
var state_27047__$1 = state_27047;
var statearr_27054_27089 = state_27047__$1;
(statearr_27054_27089[(2)] = inst_26973);

(statearr_27054_27089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (15))){
var inst_27037 = (state_27047[(2)]);
var state_27047__$1 = state_27047;
var statearr_27055_27090 = state_27047__$1;
(statearr_27055_27090[(2)] = inst_27037);

(statearr_27055_27090[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (21))){
var inst_27035 = (state_27047[(2)]);
var state_27047__$1 = state_27047;
var statearr_27056_27091 = state_27047__$1;
(statearr_27056_27091[(2)] = inst_27035);

(statearr_27056_27091[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (13))){
var inst_26994 = (state_27047[(9)]);
var inst_26999 = fluree.db.query.schema.schema_map.call(null,inst_26994);
var inst_27000 = fluree.db.query.schema.setting_map.call(null,inst_26994);
var inst_27001 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_26994);
var inst_27002 = cljs.core.swap_BANG_.call(null,inst_27001,cljs.core.empty);
var state_27047__$1 = (function (){var statearr_27057 = state_27047;
(statearr_27057[(10)] = inst_27002);

(statearr_27057[(11)] = inst_27000);

return statearr_27057;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27047__$1,(16),inst_26999);
} else {
if((state_val_27048 === (22))){
var inst_26995 = (state_27047[(8)]);
var inst_27023 = (state_27047[(2)]);
var inst_27024 = fluree.db.util.async.throw_err.call(null,inst_27023);
var inst_27025 = (inst_26995 + (1));
var inst_26994 = inst_27024;
var inst_26995__$1 = inst_27025;
var state_27047__$1 = (function (){var statearr_27058 = state_27047;
(statearr_27058[(8)] = inst_26995__$1);

(statearr_27058[(9)] = inst_26994);

return statearr_27058;
})();
var statearr_27059_27092 = state_27047__$1;
(statearr_27059_27092[(2)] = null);

(statearr_27059_27092[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (6))){
var inst_26982 = (state_27047[(2)]);
var inst_26983 = fluree.db.util.async.throw_err.call(null,inst_26982);
var inst_26984 = cljs.core.__destructure_map.call(null,inst_26983);
var inst_26985 = cljs.core.get.call(null,inst_26984,new cljs.core.Keyword(null,"block","block",664686210));
var inst_26986 = cljs.core.get.call(null,inst_26984,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_26987 = fluree.db.storage.core.reify_db.call(null,conn,network,ledger_id,blank_db,inst_26986);
var state_27047__$1 = (function (){var statearr_27060 = state_27047;
(statearr_27060[(12)] = inst_26985);

return statearr_27060;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27047__$1,(7),inst_26987);
} else {
if((state_val_27048 === (17))){
var inst_27005 = (state_27047[(13)]);
var inst_26994 = (state_27047[(9)]);
var inst_27007 = (state_27047[(2)]);
var inst_27008 = fluree.db.util.async.throw_err.call(null,inst_27007);
var inst_27009 = cljs.core.assoc.call(null,inst_26994,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27005,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27008);
var state_27047__$1 = state_27047;
var statearr_27061_27093 = state_27047__$1;
(statearr_27061_27093[(2)] = inst_27009);

(statearr_27061_27093[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (3))){
var inst_27045 = (state_27047[(2)]);
var state_27047__$1 = state_27047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27047__$1,inst_27045);
} else {
if((state_val_27048 === (12))){
var inst_27039 = (state_27047[(2)]);
var state_27047__$1 = state_27047;
var statearr_27062_27094 = state_27047__$1;
(statearr_27062_27094[(2)] = inst_27039);

(statearr_27062_27094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (2))){
var _ = (function (){var statearr_27063 = state_27047;
(statearr_27063[(4)] = cljs.core.cons.call(null,(5),(state_27047[(4)])));

return statearr_27063;
})();
var inst_26980 = fluree.db.session.load_ledger_info.call(null,conn,network,ledger_id);
var state_27047__$1 = state_27047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27047__$1,(6),inst_26980);
} else {
if((state_val_27048 === (19))){
var inst_27014 = (state_27047[(14)]);
var inst_26994 = (state_27047[(9)]);
var inst_27017 = cljs.core.__destructure_map.call(null,inst_27014);
var inst_27018 = cljs.core.get.call(null,inst_27017,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27019 = cljs.core.get.call(null,inst_27017,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27020 = cljs.core.get.call(null,inst_27017,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27021 = fluree.db.dbproto._with.call(null,inst_26994,inst_27019,inst_27018);
var state_27047__$1 = (function (){var statearr_27064 = state_27047;
(statearr_27064[(15)] = inst_27020);

return statearr_27064;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27047__$1,(22),inst_27021);
} else {
if((state_val_27048 === (11))){
var inst_26995 = (state_27047[(8)]);
var inst_26985 = (state_27047[(12)]);
var inst_26997 = (inst_26995 > inst_26985);
var state_27047__$1 = state_27047;
if(cljs.core.truth_(inst_26997)){
var statearr_27066_27095 = state_27047__$1;
(statearr_27066_27095[(1)] = (13));

} else {
var statearr_27067_27096 = state_27047__$1;
(statearr_27067_27096[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (9))){
var state_27047__$1 = state_27047;
var statearr_27068_27097 = state_27047__$1;
(statearr_27068_27097[(2)] = null);

(statearr_27068_27097[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (5))){
var _ = (function (){var statearr_27069 = state_27047;
(statearr_27069[(4)] = cljs.core.rest.call(null,(state_27047[(4)])));

return statearr_27069;
})();
var state_27047__$1 = state_27047;
var ex27065 = (state_27047__$1[(2)]);
var statearr_27070_27098 = state_27047__$1;
(statearr_27070_27098[(5)] = ex27065);


if((ex27065 instanceof Error)){
var statearr_27071_27099 = state_27047__$1;
(statearr_27071_27099[(1)] = (4));

(statearr_27071_27099[(5)] = null);

} else {
throw ex27065;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (14))){
var inst_26995 = (state_27047[(8)]);
var inst_27011 = fluree.db.storage.core.read_block.call(null,conn,network,ledger_id,inst_26995);
var state_27047__$1 = state_27047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27047__$1,(18),inst_27011);
} else {
if((state_val_27048 === (16))){
var inst_27000 = (state_27047[(11)]);
var inst_27004 = (state_27047[(2)]);
var inst_27005 = fluree.db.util.async.throw_err.call(null,inst_27004);
var state_27047__$1 = (function (){var statearr_27072 = state_27047;
(statearr_27072[(13)] = inst_27005);

return statearr_27072;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27047__$1,(17),inst_27000);
} else {
if((state_val_27048 === (10))){
var inst_27042 = (state_27047[(2)]);
var _ = (function (){var statearr_27073 = state_27047;
(statearr_27073[(4)] = cljs.core.rest.call(null,(state_27047[(4)])));

return statearr_27073;
})();
var state_27047__$1 = state_27047;
var statearr_27074_27100 = state_27047__$1;
(statearr_27074_27100[(2)] = inst_27042);

(statearr_27074_27100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (18))){
var inst_27014 = (state_27047[(14)]);
var inst_27013 = (state_27047[(2)]);
var inst_27014__$1 = fluree.db.util.async.throw_err.call(null,inst_27013);
var state_27047__$1 = (function (){var statearr_27075 = state_27047;
(statearr_27075[(14)] = inst_27014__$1);

return statearr_27075;
})();
if(cljs.core.truth_(inst_27014__$1)){
var statearr_27076_27101 = state_27047__$1;
(statearr_27076_27101[(1)] = (19));

} else {
var statearr_27077_27102 = state_27047__$1;
(statearr_27077_27102[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27048 === (8))){
var inst_26990 = (state_27047[(7)]);
var inst_26992 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26990);
var inst_26993 = (inst_26992 + (1));
var inst_26994 = inst_26990;
var inst_26995 = inst_26993;
var state_27047__$1 = (function (){var statearr_27078 = state_27047;
(statearr_27078[(8)] = inst_26995);

(statearr_27078[(9)] = inst_26994);

return statearr_27078;
})();
var statearr_27079_27103 = state_27047__$1;
(statearr_27079_27103[(2)] = null);

(statearr_27079_27103[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2746__auto____0 = (function (){
var statearr_27080 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27080[(0)] = fluree$db$session$load_current_db_$_state_machine__2746__auto__);

(statearr_27080[(1)] = (1));

return statearr_27080;
});
var fluree$db$session$load_current_db_$_state_machine__2746__auto____1 = (function (state_27047){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27081){var ex__2749__auto__ = e27081;
var statearr_27082_27104 = state_27047;
(statearr_27082_27104[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27047[(4)]))){
var statearr_27083_27105 = state_27047;
(statearr_27083_27105[(1)] = cljs.core.first.call(null,(state_27047[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27106 = state_27047;
state_27047 = G__27106;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2746__auto__ = function(state_27047){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____1.call(this,state_27047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2746__auto____0;
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2746__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27084 = f__2769__auto__.call(null);
(statearr_27084[(6)] = c__2768__auto__);

return statearr_27084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27107,old_db_ch,new_db_ch){
var map__27108 = p__27107;
var map__27108__$1 = cljs.core.__destructure_map.call(null,map__27108);
var state = cljs.core.get.call(null,map__27108__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__27109){
var map__27110 = p__27109;
var map__27110__$1 = cljs.core.__destructure_map.call(null,map__27110);
var s = map__27110__$1;
var current = cljs.core.get.call(null,map__27110__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27111){
var map__27112 = p__27111;
var map__27112__$1 = cljs.core.__destructure_map.call(null,map__27112);
var state = cljs.core.get.call(null,map__27112__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27113){
var map__27114 = p__27113;
var map__27114__$1 = cljs.core.__destructure_map.call(null,map__27114);
var conn = cljs.core.get.call(null,map__27114__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__27114__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__27114__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2768__auto___27151 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27134){
var state_val_27135 = (state_27134[(1)]);
if((state_val_27135 === (1))){
var state_27134__$1 = state_27134;
var statearr_27136_27152 = state_27134__$1;
(statearr_27136_27152[(2)] = null);

(statearr_27136_27152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27135 === (2))){
var _ = (function (){var statearr_27137 = state_27134;
(statearr_27137[(4)] = cljs.core.cons.call(null,(5),(state_27134[(4)])));

return statearr_27137;
})();
var inst_27124 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27134__$1 = state_27134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27134__$1,(6),inst_27124);
} else {
if((state_val_27135 === (3))){
var inst_27132 = (state_27134[(2)]);
var state_27134__$1 = state_27134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27134__$1,inst_27132);
} else {
if((state_val_27135 === (4))){
var inst_27115 = (state_27134[(2)]);
var inst_27116 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27117 = fluree.db.util.log.error.call(null,inst_27115,"Error reloading db");
var inst_27118 = cljs.core.async.put_BANG_.call(null,db_ch,inst_27115);
var state_27134__$1 = (function (){var statearr_27139 = state_27134;
(statearr_27139[(7)] = inst_27116);

(statearr_27139[(8)] = inst_27117);

return statearr_27139;
})();
var statearr_27140_27153 = state_27134__$1;
(statearr_27140_27153[(2)] = inst_27118);

(statearr_27140_27153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27135 === (5))){
var _ = (function (){var statearr_27141 = state_27134;
(statearr_27141[(4)] = cljs.core.rest.call(null,(state_27134[(4)])));

return statearr_27141;
})();
var state_27134__$1 = state_27134;
var ex27138 = (state_27134__$1[(2)]);
var statearr_27142_27154 = state_27134__$1;
(statearr_27142_27154[(5)] = ex27138);


var statearr_27143_27155 = state_27134__$1;
(statearr_27143_27155[(1)] = (4));

(statearr_27143_27155[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27135 === (6))){
var inst_27126 = (state_27134[(2)]);
var inst_27127 = fluree.db.util.async.throw_err.call(null,inst_27126);
var state_27134__$1 = state_27134;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27134__$1,(7),db_ch,inst_27127);
} else {
if((state_val_27135 === (7))){
var inst_27129 = (state_27134[(2)]);
var _ = (function (){var statearr_27144 = state_27134;
(statearr_27144[(4)] = cljs.core.rest.call(null,(state_27134[(4)])));

return statearr_27144;
})();
var state_27134__$1 = state_27134;
var statearr_27145_27156 = state_27134__$1;
(statearr_27145_27156[(2)] = inst_27129);

(statearr_27145_27156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0 = (function (){
var statearr_27146 = [null,null,null,null,null,null,null,null,null];
(statearr_27146[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__);

(statearr_27146[(1)] = (1));

return statearr_27146;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1 = (function (state_27134){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27147){var ex__2749__auto__ = e27147;
var statearr_27148_27157 = state_27134;
(statearr_27148_27157[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27134[(4)]))){
var statearr_27149_27158 = state_27134;
(statearr_27149_27158[(1)] = cljs.core.first.call(null,(state_27134[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27159 = state_27134;
state_27134 = G__27159;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = function(state_27134){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1.call(this,state_27134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27150 = f__2769__auto__.call(null);
(statearr_27150[(6)] = c__2768__auto___27151);

return statearr_27150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27161 = arguments.length;
switch (G__27161) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27162){
var map__27163 = p__27162;
var map__27163__$1 = cljs.core.__destructure_map.call(null,map__27163);
var session = map__27163__$1;
var blank_db = cljs.core.get.call(null,map__27163__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27164,blank_db){
var map__27165 = p__27164;
var map__27165__$1 = cljs.core.__destructure_map.call(null,map__27165);
var session = map__27165__$1;
var conn = cljs.core.get.call(null,map__27165__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__27165__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__2768__auto___27203 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27185){
var state_val_27186 = (state_27185[(1)]);
if((state_val_27186 === (1))){
var state_27185__$1 = state_27185;
var statearr_27187_27204 = state_27185__$1;
(statearr_27187_27204[(2)] = null);

(statearr_27187_27204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27186 === (2))){
var _ = (function (){var statearr_27188 = state_27185;
(statearr_27188[(4)] = cljs.core.cons.call(null,(5),(state_27185[(4)])));

return statearr_27188;
})();
var inst_27175 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27185__$1 = state_27185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27185__$1,(6),inst_27175);
} else {
if((state_val_27186 === (3))){
var inst_27183 = (state_27185[(2)]);
var state_27185__$1 = state_27185;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27185__$1,inst_27183);
} else {
if((state_val_27186 === (4))){
var inst_27166 = (state_27185[(2)]);
var inst_27167 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27168 = fluree.db.util.log.error.call(null,inst_27166,"Error loading current db");
var inst_27169 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_27166);
var state_27185__$1 = (function (){var statearr_27190 = state_27185;
(statearr_27190[(7)] = inst_27167);

(statearr_27190[(8)] = inst_27168);

return statearr_27190;
})();
var statearr_27191_27205 = state_27185__$1;
(statearr_27191_27205[(2)] = inst_27169);

(statearr_27191_27205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27186 === (5))){
var _ = (function (){var statearr_27192 = state_27185;
(statearr_27192[(4)] = cljs.core.rest.call(null,(state_27185[(4)])));

return statearr_27192;
})();
var state_27185__$1 = state_27185;
var ex27189 = (state_27185__$1[(2)]);
var statearr_27193_27206 = state_27185__$1;
(statearr_27193_27206[(5)] = ex27189);


var statearr_27194_27207 = state_27185__$1;
(statearr_27194_27207[(1)] = (4));

(statearr_27194_27207[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27186 === (6))){
var inst_27177 = (state_27185[(2)]);
var inst_27178 = fluree.db.util.async.throw_err.call(null,inst_27177);
var state_27185__$1 = state_27185;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27185__$1,(7),cur_ch,inst_27178);
} else {
if((state_val_27186 === (7))){
var inst_27180 = (state_27185[(2)]);
var _ = (function (){var statearr_27195 = state_27185;
(statearr_27195[(4)] = cljs.core.rest.call(null,(state_27185[(4)])));

return statearr_27195;
})();
var state_27185__$1 = state_27185;
var statearr_27196_27208 = state_27185__$1;
(statearr_27196_27208[(2)] = inst_27180);

(statearr_27196_27208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27197 = [null,null,null,null,null,null,null,null,null];
(statearr_27197[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27197[(1)] = (1));

return statearr_27197;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27185){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27185);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27198){var ex__2749__auto__ = e27198;
var statearr_27199_27209 = state_27185;
(statearr_27199_27209[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27185[(4)]))){
var statearr_27200_27210 = state_27185;
(statearr_27200_27210[(1)] = cljs.core.first.call(null,(state_27185[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27211 = state_27185;
state_27185 = G__27211;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27185){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27201 = f__2769__auto__.call(null);
(statearr_27201[(6)] = c__2768__auto___27203);

return statearr_27201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27213){
var state_val_27214 = (state_27213[(1)]);
if((state_val_27214 === (1))){
var state_27213__$1 = state_27213;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27213__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27215 = [null,null,null,null,null,null,null];
(statearr_27215[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27215[(1)] = (1));

return statearr_27215;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27213){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27213);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27216){var ex__2749__auto__ = e27216;
var statearr_27217_27220 = state_27213;
(statearr_27217_27220[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27213[(4)]))){
var statearr_27218_27221 = state_27213;
(statearr_27218_27221[(1)] = cljs.core.first.call(null,(state_27213[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27222 = state_27213;
state_27213 = G__27222;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27213){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27219 = f__2769__auto__.call(null);
(statearr_27219[(6)] = c__2768__auto__);

return statearr_27219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27223){
var map__27224 = p__27223;
var map__27224__$1 = cljs.core.__destructure_map.call(null,map__27224);
var data = map__27224__$1;
var block = cljs.core.get.call(null,map__27224__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27224__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27224__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27283){
var state_val_27284 = (state_27283[(1)]);
if((state_val_27284 === (7))){
var inst_27235 = (state_27283[(7)]);
var inst_27238 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27239 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27240 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27238),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27239),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27235),". No-op."].join('');
var inst_27241 = fluree.db.util.log.info.call(null,inst_27240);
var state_27283__$1 = state_27283;
var statearr_27285_27319 = state_27283__$1;
(statearr_27285_27319[(2)] = inst_27241);

(statearr_27285_27319[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (1))){
var state_27283__$1 = state_27283;
var statearr_27286_27320 = state_27283__$1;
(statearr_27286_27320[(2)] = null);

(statearr_27286_27320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (4))){
var inst_27225 = (state_27283[(2)]);
var state_27283__$1 = state_27283;
var statearr_27287_27321 = state_27283__$1;
(statearr_27287_27321[(2)] = inst_27225);

(statearr_27287_27321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (15))){
var inst_27264 = (state_27283[(2)]);
var state_27283__$1 = state_27283;
var statearr_27288_27322 = state_27283__$1;
(statearr_27288_27322[(2)] = inst_27264);

(statearr_27288_27322[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (13))){
var inst_27255 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27257 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27258 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27259 = [inst_27257,inst_27258];
var inst_27260 = (new cljs.core.PersistentVector(null,2,(5),inst_27256,inst_27259,null));
var inst_27261 = fluree.db.conn_events.process_event.call(null,inst_27255,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_27260,data);
var state_27283__$1 = state_27283;
var statearr_27289_27323 = state_27283__$1;
(statearr_27289_27323[(2)] = inst_27261);

(statearr_27289_27323[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (6))){
var inst_27234 = (state_27283[(8)]);
var inst_27235 = (state_27283[(7)]);
var inst_27233 = (state_27283[(2)]);
var inst_27234__$1 = fluree.db.util.async.throw_err.call(null,inst_27233);
var inst_27235__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27234__$1);
var inst_27236 = (block <= inst_27235__$1);
var state_27283__$1 = (function (){var statearr_27290 = state_27283;
(statearr_27290[(8)] = inst_27234__$1);

(statearr_27290[(7)] = inst_27235__$1);

return statearr_27290;
})();
if(cljs.core.truth_(inst_27236)){
var statearr_27291_27324 = state_27283__$1;
(statearr_27291_27324[(1)] = (7));

} else {
var statearr_27292_27325 = state_27283__$1;
(statearr_27292_27325[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (17))){
var state_27283__$1 = state_27283;
var statearr_27293_27326 = state_27283__$1;
(statearr_27293_27326[(2)] = null);

(statearr_27293_27326[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (3))){
var inst_27281 = (state_27283[(2)]);
var state_27283__$1 = state_27283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27283__$1,inst_27281);
} else {
if((state_val_27284 === (12))){
var inst_27276 = (state_27283[(2)]);
var state_27283__$1 = state_27283;
var statearr_27294_27327 = state_27283__$1;
(statearr_27294_27327[(2)] = inst_27276);

(statearr_27294_27327[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (2))){
var inst_27231 = (state_27283[(9)]);
var _ = (function (){var statearr_27295 = state_27283;
(statearr_27295[(4)] = cljs.core.cons.call(null,(5),(state_27283[(4)])));

return statearr_27295;
})();
var inst_27231__$1 = fluree.db.session.current_db.call(null,session);
var state_27283__$1 = (function (){var statearr_27296 = state_27283;
(statearr_27296[(9)] = inst_27231__$1);

return statearr_27296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27283__$1,(6),inst_27231__$1);
} else {
if((state_val_27284 === (11))){
var state_27283__$1 = state_27283;
var statearr_27298_27328 = state_27283__$1;
(statearr_27298_27328[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (9))){
var inst_27278 = (state_27283[(2)]);
var _ = (function (){var statearr_27300 = state_27283;
(statearr_27300[(4)] = cljs.core.rest.call(null,(state_27283[(4)])));

return statearr_27300;
})();
var state_27283__$1 = state_27283;
var statearr_27301_27329 = state_27283__$1;
(statearr_27301_27329[(2)] = inst_27278);

(statearr_27301_27329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (5))){
var _ = (function (){var statearr_27302 = state_27283;
(statearr_27302[(4)] = cljs.core.rest.call(null,(state_27283[(4)])));

return statearr_27302;
})();
var state_27283__$1 = state_27283;
var ex27297 = (state_27283__$1[(2)]);
var statearr_27303_27330 = state_27283__$1;
(statearr_27303_27330[(5)] = ex27297);


if((ex27297 instanceof Error)){
var statearr_27304_27331 = state_27283__$1;
(statearr_27304_27331[(1)] = (4));

(statearr_27304_27331[(5)] = null);

} else {
throw ex27297;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (14))){
var state_27283__$1 = state_27283;
var statearr_27305_27332 = state_27283__$1;
(statearr_27305_27332[(2)] = null);

(statearr_27305_27332[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (16))){
var inst_27235 = (state_27283[(7)]);
var inst_27267 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27268 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27269 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27267),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27268),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27235),". Forcing a db reload."].join('');
var inst_27270 = fluree.db.util.log.info.call(null,inst_27269);
var inst_27271 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27283__$1 = (function (){var statearr_27306 = state_27283;
(statearr_27306[(10)] = inst_27270);

return statearr_27306;
})();
var statearr_27307_27333 = state_27283__$1;
(statearr_27307_27333[(2)] = inst_27271);

(statearr_27307_27333[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (10))){
var inst_27231 = (state_27283[(9)]);
var inst_27234 = (state_27283[(8)]);
var inst_27235 = (state_27283[(7)]);
var inst_27246 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27247 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27248 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27246),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27247),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27249 = fluree.db.util.log.trace.call(null,inst_27248);
var inst_27250 = (function (){var current_db_ch = inst_27231;
var current_db = inst_27234;
var current_block = inst_27235;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_27251 = cljs.core.map.call(null,inst_27250,flakes);
var inst_27252 = fluree.db.dbproto._with.call(null,inst_27234,block,inst_27251);
var inst_27253 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27231,inst_27252);
var state_27283__$1 = (function (){var statearr_27308 = state_27283;
(statearr_27308[(11)] = inst_27249);

return statearr_27308;
})();
if(inst_27253){
var statearr_27309_27334 = state_27283__$1;
(statearr_27309_27334[(1)] = (13));

} else {
var statearr_27310_27335 = state_27283__$1;
(statearr_27310_27335[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (18))){
var inst_27274 = (state_27283[(2)]);
var state_27283__$1 = state_27283;
var statearr_27311_27336 = state_27283__$1;
(statearr_27311_27336[(2)] = inst_27274);

(statearr_27311_27336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27284 === (8))){
var inst_27235 = (state_27283[(7)]);
var inst_27243 = ((1) + inst_27235);
var inst_27244 = cljs.core._EQ_.call(null,block,inst_27243);
var state_27283__$1 = state_27283;
if(inst_27244){
var statearr_27312_27337 = state_27283__$1;
(statearr_27312_27337[(1)] = (10));

} else {
var statearr_27313_27338 = state_27283__$1;
(statearr_27313_27338[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27314 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27314[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27314[(1)] = (1));

return statearr_27314;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27283){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27315){var ex__2749__auto__ = e27315;
var statearr_27316_27339 = state_27283;
(statearr_27316_27339[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27283[(4)]))){
var statearr_27317_27340 = state_27283;
(statearr_27317_27340[(1)] = cljs.core.first.call(null,(state_27283[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27341 = state_27283;
state_27283 = G__27341;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27283){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27318 = f__2769__auto__.call(null);
(statearr_27318[(6)] = c__2768__auto__);

return statearr_27318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27348){
var state_val_27349 = (state_27348[(1)]);
if((state_val_27349 === (1))){
var inst_27342 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27343 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27344 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27345 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27343),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27344)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27346 = fluree.db.util.log.debug.call(null,inst_27345);
var state_27348__$1 = (function (){var statearr_27350 = state_27348;
(statearr_27350[(7)] = inst_27346);

(statearr_27350[(8)] = inst_27342);

return statearr_27350;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27348__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27351 = [null,null,null,null,null,null,null,null,null];
(statearr_27351[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27351[(1)] = (1));

return statearr_27351;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27348){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27348);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27352){var ex__2749__auto__ = e27352;
var statearr_27353_27356 = state_27348;
(statearr_27353_27356[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27348[(4)]))){
var statearr_27354_27357 = state_27348;
(statearr_27354_27357[(1)] = cljs.core.first.call(null,(state_27348[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27358 = state_27348;
state_27348 = G__27358;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27348){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27355 = f__2769__auto__.call(null);
(statearr_27355[(6)] = c__2768__auto__);

return statearr_27355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27360 = arguments.length;
switch (G__27360) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27361){
var map__27362 = p__27361;
var map__27362__$1 = cljs.core.__destructure_map.call(null,map__27362);
var session = map__27362__$1;
var conn = cljs.core.get.call(null,map__27362__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27362__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27362__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27362__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27362__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27362__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.call(null,map__27362__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27415){
var state_val_27416 = (state_27415[(1)]);
if((state_val_27416 === (7))){
var inst_27411 = (state_27415[(2)]);
var state_27415__$1 = state_27415;
var statearr_27417_27448 = state_27415__$1;
(statearr_27417_27448[(2)] = inst_27411);

(statearr_27417_27448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (1))){
var state_27415__$1 = state_27415;
var statearr_27418_27449 = state_27415__$1;
(statearr_27418_27449[(2)] = null);

(statearr_27418_27449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (4))){
var inst_27367 = (state_27415[(7)]);
var inst_27366 = (state_27415[(2)]);
var inst_27367__$1 = fluree.db.util.async.throw_err.call(null,inst_27366);
var inst_27368 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27369 = (inst_27367__$1 == null);
var state_27415__$1 = (function (){var statearr_27419 = state_27415;
(statearr_27419[(7)] = inst_27367__$1);

(statearr_27419[(8)] = inst_27368);

return statearr_27419;
})();
if(cljs.core.truth_(inst_27369)){
var statearr_27420_27450 = state_27415__$1;
(statearr_27420_27450[(1)] = (5));

} else {
var statearr_27421_27451 = state_27415__$1;
(statearr_27421_27451[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (15))){
var inst_27403 = (state_27415[(2)]);
var state_27415__$1 = (function (){var statearr_27422 = state_27415;
(statearr_27422[(9)] = inst_27403);

return statearr_27422;
})();
var statearr_27423_27452 = state_27415__$1;
(statearr_27423_27452[(2)] = null);

(statearr_27423_27452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (13))){
var inst_27407 = (state_27415[(2)]);
var state_27415__$1 = state_27415;
var statearr_27425_27453 = state_27415__$1;
(statearr_27425_27453[(2)] = inst_27407);

(statearr_27425_27453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (6))){
var inst_27368 = (state_27415[(8)]);
var inst_27374 = (inst_27368 == null);
var state_27415__$1 = state_27415;
if(cljs.core.truth_(inst_27374)){
var statearr_27426_27454 = state_27415__$1;
(statearr_27426_27454[(1)] = (8));

} else {
var statearr_27427_27455 = state_27415__$1;
(statearr_27427_27455[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (17))){
var _ = (function (){var statearr_27428 = state_27415;
(statearr_27428[(4)] = cljs.core.rest.call(null,(state_27415[(4)])));

return statearr_27428;
})();
var state_27415__$1 = state_27415;
var ex27424 = (state_27415__$1[(2)]);
var statearr_27429_27456 = state_27415__$1;
(statearr_27429_27456[(5)] = ex27424);


var statearr_27430_27457 = state_27415__$1;
(statearr_27430_27457[(1)] = (16));

(statearr_27430_27457[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (3))){
var inst_27413 = (state_27415[(2)]);
var state_27415__$1 = state_27415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27415__$1,inst_27413);
} else {
if((state_val_27416 === (12))){
var state_27415__$1 = state_27415;
var statearr_27431_27458 = state_27415__$1;
(statearr_27431_27458[(2)] = null);

(statearr_27431_27458[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (2))){
var state_27415__$1 = state_27415;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27415__$1,(4),update_chan);
} else {
if((state_val_27416 === (11))){
var state_27415__$1 = state_27415;
var statearr_27432_27459 = state_27415__$1;
(statearr_27432_27459[(2)] = null);

(statearr_27432_27459[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (9))){
var state_27415__$1 = state_27415;
var statearr_27433_27460 = state_27415__$1;
(statearr_27433_27460[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (5))){
var inst_27371 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27372 = fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27371);
var state_27415__$1 = state_27415;
var statearr_27435_27461 = state_27415__$1;
(statearr_27435_27461[(2)] = inst_27372);

(statearr_27435_27461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (14))){
var inst_27367 = (state_27415[(7)]);
var inst_27368 = (state_27415[(8)]);
var _ = (function (){var statearr_27436 = state_27415;
(statearr_27436[(4)] = cljs.core.cons.call(null,(17),(state_27415[(4)])));

return statearr_27436;
})();
var inst_27391 = cljs.core.nth.call(null,inst_27367,(0),null);
var inst_27392 = cljs.core.nth.call(null,inst_27367,(1),null);
var inst_27393 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27394 = cljs.core.pr_str.call(null,inst_27367);
var inst_27395 = fluree.db.util.core.trunc.call(null,inst_27394,(200));
var inst_27396 = fluree.db.util.log.trace.call(null,inst_27393,inst_27395);
var inst_27397 = fluree.db.session.process_ledger_update.call(null,inst_27368,inst_27391,inst_27392);
var state_27415__$1 = (function (){var statearr_27437 = state_27415;
(statearr_27437[(10)] = inst_27396);

return statearr_27437;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27415__$1,(18),inst_27397);
} else {
if((state_val_27416 === (16))){
var inst_27367 = (state_27415[(7)]);
var inst_27381 = (state_27415[(2)]);
var inst_27382 = fluree.db.util.log.error.call(null,inst_27381,"Exception processing ledger updates for message: ",inst_27367);
var state_27415__$1 = state_27415;
var statearr_27438_27462 = state_27415__$1;
(statearr_27438_27462[(2)] = inst_27382);

(statearr_27438_27462[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (10))){
var inst_27409 = (state_27415[(2)]);
var state_27415__$1 = state_27415;
var statearr_27439_27463 = state_27415__$1;
(statearr_27439_27463[(2)] = inst_27409);

(statearr_27439_27463[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (18))){
var inst_27399 = (state_27415[(2)]);
var inst_27400 = fluree.db.util.async.throw_err.call(null,inst_27399);
var _ = (function (){var statearr_27440 = state_27415;
(statearr_27440[(4)] = cljs.core.rest.call(null,(state_27415[(4)])));

return statearr_27440;
})();
var state_27415__$1 = state_27415;
var statearr_27441_27464 = state_27415__$1;
(statearr_27441_27464[(2)] = inst_27400);

(statearr_27441_27464[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27416 === (8))){
var inst_27367 = (state_27415[(7)]);
var inst_27376 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27377 = cljs.core.first.call(null,inst_27367);
var inst_27378 = fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27376,"Message: ",inst_27377);
var state_27415__$1 = state_27415;
var statearr_27442_27465 = state_27415__$1;
(statearr_27442_27465[(2)] = inst_27378);

(statearr_27442_27465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0 = (function (){
var statearr_27443 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27443[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__);

(statearr_27443[(1)] = (1));

return statearr_27443;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1 = (function (state_27415){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27444){var ex__2749__auto__ = e27444;
var statearr_27445_27466 = state_27415;
(statearr_27445_27466[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27415[(4)]))){
var statearr_27446_27467 = state_27415;
(statearr_27446_27467[(1)] = cljs.core.first.call(null,(state_27415[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27468 = state_27415;
state_27415 = G__27468;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = function(state_27415){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1.call(this,state_27415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27447 = f__2769__auto__.call(null);
(statearr_27447[(6)] = c__2768__auto__);

return statearr_27447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27469){
var map__27470 = p__27469;
var map__27470__$1 = cljs.core.__destructure_map.call(null,map__27470);
var network = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27470__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27474 = block_result;
var map__27474__$1 = cljs.core.__destructure_map.call(null,map__27474);
var block = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27475 = tx_result;
var map__27475__$1 = cljs.core.__destructure_map.call(null,map__27475);
var t = cljs.core.get.call(null,map__27475__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27475__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27471_SHARP_){
return cljs.core._EQ_.call(null,t,fluree.db.flake.t.call(null,p1__27471_SHARP_));
}):(function (p1__27472_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27472_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27473_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27473_SHARP_))){
return cljs.core.nth.call(null,p1__27473_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27476 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27476,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27476,(1),null);
var error = cljs.core.nth.call(null,vec__27476,(2),null);
var message = cljs.core.nth.call(null,vec__27476,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27480 = arguments.length;
switch (G__27480) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27481){
var map__27482 = p__27481;
var map__27482__$1 = cljs.core.__destructure_map.call(null,map__27482);
var state = cljs.core.get.call(null,map__27482__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__27482__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__27482__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__27482__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27483 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__27483,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__27483,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__27483,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27486 = cljs.core.seq.call(null,tids);
var chunk__27487 = null;
var count__27488 = (0);
var i__27489 = (0);
while(true){
if((i__27489 < count__27488)){
var tid = cljs.core._nth.call(null,chunk__27487,i__27489);
var temp__5804__auto___27602__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27602__$1)){
var keyed_callbacks_27603 = temp__5804__auto___27602__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27604 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27530_27605 = cljs.core.seq.call(null,keyed_callbacks_27603);
var chunk__27531_27606 = null;
var count__27532_27607 = (0);
var i__27533_27608 = (0);
while(true){
if((i__27533_27608 < count__27532_27607)){
var vec__27542_27609 = cljs.core._nth.call(null,chunk__27531_27606,i__27533_27608);
var k_27610 = cljs.core.nth.call(null,vec__27542_27609,(0),null);
var f_27611 = cljs.core.nth.call(null,vec__27542_27609,(1),null);
try{f_27611.call(null,tx_response_27604);
}catch (e27545){var e_27612 = e27545;
fluree.db.util.log.error.call(null,e_27612,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27613 = seq__27530_27605;
var G__27614 = chunk__27531_27606;
var G__27615 = count__27532_27607;
var G__27616 = (i__27533_27608 + (1));
seq__27530_27605 = G__27613;
chunk__27531_27606 = G__27614;
count__27532_27607 = G__27615;
i__27533_27608 = G__27616;
continue;
} else {
var temp__5804__auto___27617__$2 = cljs.core.seq.call(null,seq__27530_27605);
if(temp__5804__auto___27617__$2){
var seq__27530_27618__$1 = temp__5804__auto___27617__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27530_27618__$1)){
var c__5568__auto___27619 = cljs.core.chunk_first.call(null,seq__27530_27618__$1);
var G__27620 = cljs.core.chunk_rest.call(null,seq__27530_27618__$1);
var G__27621 = c__5568__auto___27619;
var G__27622 = cljs.core.count.call(null,c__5568__auto___27619);
var G__27623 = (0);
seq__27530_27605 = G__27620;
chunk__27531_27606 = G__27621;
count__27532_27607 = G__27622;
i__27533_27608 = G__27623;
continue;
} else {
var vec__27546_27624 = cljs.core.first.call(null,seq__27530_27618__$1);
var k_27625 = cljs.core.nth.call(null,vec__27546_27624,(0),null);
var f_27626 = cljs.core.nth.call(null,vec__27546_27624,(1),null);
try{f_27626.call(null,tx_response_27604);
}catch (e27549){var e_27627 = e27549;
fluree.db.util.log.error.call(null,e_27627,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27628 = cljs.core.next.call(null,seq__27530_27618__$1);
var G__27629 = null;
var G__27630 = (0);
var G__27631 = (0);
seq__27530_27605 = G__27628;
chunk__27531_27606 = G__27629;
count__27532_27607 = G__27630;
i__27533_27608 = G__27631;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27632 = seq__27486;
var G__27633 = chunk__27487;
var G__27634 = count__27488;
var G__27635 = (i__27489 + (1));
seq__27486 = G__27632;
chunk__27487 = G__27633;
count__27488 = G__27634;
i__27489 = G__27635;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__27486);
if(temp__5804__auto____$1){
var seq__27486__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27486__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27486__$1);
var G__27636 = cljs.core.chunk_rest.call(null,seq__27486__$1);
var G__27637 = c__5568__auto__;
var G__27638 = cljs.core.count.call(null,c__5568__auto__);
var G__27639 = (0);
seq__27486 = G__27636;
chunk__27487 = G__27637;
count__27488 = G__27638;
i__27489 = G__27639;
continue;
} else {
var tid = cljs.core.first.call(null,seq__27486__$1);
var temp__5804__auto___27640__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27640__$2)){
var keyed_callbacks_27641 = temp__5804__auto___27640__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27642 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27550_27643 = cljs.core.seq.call(null,keyed_callbacks_27641);
var chunk__27551_27644 = null;
var count__27552_27645 = (0);
var i__27553_27646 = (0);
while(true){
if((i__27553_27646 < count__27552_27645)){
var vec__27562_27647 = cljs.core._nth.call(null,chunk__27551_27644,i__27553_27646);
var k_27648 = cljs.core.nth.call(null,vec__27562_27647,(0),null);
var f_27649 = cljs.core.nth.call(null,vec__27562_27647,(1),null);
try{f_27649.call(null,tx_response_27642);
}catch (e27565){var e_27650 = e27565;
fluree.db.util.log.error.call(null,e_27650,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27651 = seq__27550_27643;
var G__27652 = chunk__27551_27644;
var G__27653 = count__27552_27645;
var G__27654 = (i__27553_27646 + (1));
seq__27550_27643 = G__27651;
chunk__27551_27644 = G__27652;
count__27552_27645 = G__27653;
i__27553_27646 = G__27654;
continue;
} else {
var temp__5804__auto___27655__$3 = cljs.core.seq.call(null,seq__27550_27643);
if(temp__5804__auto___27655__$3){
var seq__27550_27656__$1 = temp__5804__auto___27655__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27550_27656__$1)){
var c__5568__auto___27657 = cljs.core.chunk_first.call(null,seq__27550_27656__$1);
var G__27658 = cljs.core.chunk_rest.call(null,seq__27550_27656__$1);
var G__27659 = c__5568__auto___27657;
var G__27660 = cljs.core.count.call(null,c__5568__auto___27657);
var G__27661 = (0);
seq__27550_27643 = G__27658;
chunk__27551_27644 = G__27659;
count__27552_27645 = G__27660;
i__27553_27646 = G__27661;
continue;
} else {
var vec__27566_27662 = cljs.core.first.call(null,seq__27550_27656__$1);
var k_27663 = cljs.core.nth.call(null,vec__27566_27662,(0),null);
var f_27664 = cljs.core.nth.call(null,vec__27566_27662,(1),null);
try{f_27664.call(null,tx_response_27642);
}catch (e27569){var e_27665 = e27569;
fluree.db.util.log.error.call(null,e_27665,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27666 = cljs.core.next.call(null,seq__27550_27656__$1);
var G__27667 = null;
var G__27668 = (0);
var G__27669 = (0);
seq__27550_27643 = G__27666;
chunk__27551_27644 = G__27667;
count__27552_27645 = G__27668;
i__27553_27646 = G__27669;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27670 = cljs.core.next.call(null,seq__27486__$1);
var G__27671 = null;
var G__27672 = (0);
var G__27673 = (0);
seq__27486 = G__27670;
chunk__27487 = G__27671;
count__27488 = G__27672;
i__27489 = G__27673;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27674 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2768__auto___27675 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27586){
var state_val_27587 = (state_27586[(1)]);
if((state_val_27587 === (1))){
var state_27586__$1 = state_27586;
var statearr_27588_27676 = state_27586__$1;
(statearr_27588_27676[(2)] = null);

(statearr_27588_27676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27587 === (2))){
var inst_27571 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27586__$1 = state_27586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27586__$1,(4),inst_27571);
} else {
if((state_val_27587 === (3))){
var inst_27584 = (state_27586[(2)]);
var state_27586__$1 = state_27586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27586__$1,inst_27584);
} else {
if((state_val_27587 === (4))){
var inst_27573 = (state_27586[(7)]);
var inst_27573__$1 = (state_27586[(2)]);
var inst_27574 = (inst_27573__$1 == null);
var state_27586__$1 = (function (){var statearr_27589 = state_27586;
(statearr_27589[(7)] = inst_27573__$1);

return statearr_27589;
})();
if(cljs.core.truth_(inst_27574)){
var statearr_27590_27677 = state_27586__$1;
(statearr_27590_27677[(1)] = (5));

} else {
var statearr_27591_27678 = state_27586__$1;
(statearr_27591_27678[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27587 === (5))){
var inst_27576 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27577 = fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27576);
var state_27586__$1 = state_27586;
var statearr_27592_27679 = state_27586__$1;
(statearr_27592_27679[(2)] = inst_27577);

(statearr_27592_27679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27587 === (6))){
var inst_27573 = (state_27586[(7)]);
var inst_27579 = transact_handler_27674.call(null,conn,inst_27573);
var state_27586__$1 = (function (){var statearr_27593 = state_27586;
(statearr_27593[(8)] = inst_27579);

return statearr_27593;
})();
var statearr_27594_27680 = state_27586__$1;
(statearr_27594_27680[(2)] = null);

(statearr_27594_27680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27587 === (7))){
var inst_27582 = (state_27586[(2)]);
var state_27586__$1 = state_27586;
var statearr_27595_27681 = state_27586__$1;
(statearr_27595_27681[(2)] = inst_27582);

(statearr_27595_27681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27596 = [null,null,null,null,null,null,null,null,null];
(statearr_27596[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27596[(1)] = (1));

return statearr_27596;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27586){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27597){var ex__2749__auto__ = e27597;
var statearr_27598_27682 = state_27586;
(statearr_27598_27682[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27586[(4)]))){
var statearr_27599_27683 = state_27586;
(statearr_27599_27683[(1)] = cljs.core.first.call(null,(state_27586[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27684 = state_27586;
state_27586 = G__27684;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27586){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27600 = f__2769__auto__.call(null);
(statearr_27600[(6)] = c__2768__auto___27675);

return statearr_27600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27687 = arguments.length;
switch (G__27687) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27688 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__27685_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__27685_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27688);
} else {
return G__27688;
}
})();
var seq__27689 = cljs.core.seq.call(null,sessions);
var chunk__27690 = null;
var count__27691 = (0);
var i__27692 = (0);
while(true){
if((i__27692 < count__27691)){
var session = cljs.core._nth.call(null,chunk__27690,i__27692);
fluree.db.session.close.call(null,session);


var G__27694 = seq__27689;
var G__27695 = chunk__27690;
var G__27696 = count__27691;
var G__27697 = (i__27692 + (1));
seq__27689 = G__27694;
chunk__27690 = G__27695;
count__27691 = G__27696;
i__27692 = G__27697;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__27689);
if(temp__5804__auto__){
var seq__27689__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27689__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27689__$1);
var G__27698 = cljs.core.chunk_rest.call(null,seq__27689__$1);
var G__27699 = c__5568__auto__;
var G__27700 = cljs.core.count.call(null,c__5568__auto__);
var G__27701 = (0);
seq__27689 = G__27698;
chunk__27690 = G__27699;
count__27691 = G__27700;
i__27692 = G__27701;
continue;
} else {
var session = cljs.core.first.call(null,seq__27689__$1);
fluree.db.session.close.call(null,session);


var G__27702 = cljs.core.next.call(null,seq__27689__$1);
var G__27703 = null;
var G__27704 = (0);
var G__27705 = (0);
seq__27689 = G__27702;
chunk__27690 = G__27703;
count__27691 = G__27704;
i__27692 = G__27705;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
