// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_17181 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_17181.call(null,s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_17182 = (function (s,d){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,d);
} else {
var m__5392__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,d);
} else {
throw cljs.core.missing_protocol.call(null,"Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_17182.call(null,s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_17183 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_17183.call(null,s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_17184 = (function (s,k,data){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k,data);
} else {
var m__5392__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k,data);
} else {
throw cljs.core.missing_protocol.call(null,"Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_17184.call(null,s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_17185 = (function (s,old_key,new_key){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,old_key,new_key);
} else {
var m__5392__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,old_key,new_key);
} else {
throw cljs.core.missing_protocol.call(null,"Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_17185.call(null,s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_17186 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_17186.call(null,s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix.call(null,network,ldgr_id);
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17208){
var state_val_17209 = (state_17208[(1)]);
if((state_val_17209 === (7))){
var inst_17197 = (state_17208[(7)]);
var inst_17199 = fluree.db.storage.core.serde.call(null,conn);
var inst_17200 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17199,inst_17197);
var state_17208__$1 = state_17208;
var statearr_17210_17229 = state_17208__$1;
(statearr_17210_17229[(2)] = inst_17200);

(statearr_17210_17229[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17209 === (1))){
var state_17208__$1 = state_17208;
var statearr_17211_17230 = state_17208__$1;
(statearr_17211_17230[(2)] = null);

(statearr_17211_17230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17209 === (4))){
var inst_17187 = (state_17208[(2)]);
var state_17208__$1 = state_17208;
var statearr_17212_17231 = state_17208__$1;
(statearr_17212_17231[(2)] = inst_17187);

(statearr_17212_17231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17209 === (6))){
var inst_17197 = (state_17208[(7)]);
var inst_17196 = (state_17208[(2)]);
var inst_17197__$1 = fluree.db.util.async.throw_err.call(null,inst_17196);
var state_17208__$1 = (function (){var statearr_17213 = state_17208;
(statearr_17213[(7)] = inst_17197__$1);

return statearr_17213;
})();
if(cljs.core.truth_(inst_17197__$1)){
var statearr_17214_17232 = state_17208__$1;
(statearr_17214_17232[(1)] = (7));

} else {
var statearr_17215_17233 = state_17208__$1;
(statearr_17215_17233[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17209 === (3))){
var inst_17206 = (state_17208[(2)]);
var state_17208__$1 = state_17208;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17208__$1,inst_17206);
} else {
if((state_val_17209 === (2))){
var _ = (function (){var statearr_17217 = state_17208;
(statearr_17217[(4)] = cljs.core.cons.call(null,(5),(state_17208[(4)])));

return statearr_17217;
})();
var inst_17193 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17194 = fluree.db.storage.core.read.call(null,conn,inst_17193);
var state_17208__$1 = state_17208;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17208__$1,(6),inst_17194);
} else {
if((state_val_17209 === (9))){
var inst_17203 = (state_17208[(2)]);
var _ = (function (){var statearr_17218 = state_17208;
(statearr_17218[(4)] = cljs.core.rest.call(null,(state_17208[(4)])));

return statearr_17218;
})();
var state_17208__$1 = state_17208;
var statearr_17219_17234 = state_17208__$1;
(statearr_17219_17234[(2)] = inst_17203);

(statearr_17219_17234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17209 === (5))){
var _ = (function (){var statearr_17220 = state_17208;
(statearr_17220[(4)] = cljs.core.rest.call(null,(state_17208[(4)])));

return statearr_17220;
})();
var state_17208__$1 = state_17208;
var ex17216 = (state_17208__$1[(2)]);
var statearr_17221_17235 = state_17208__$1;
(statearr_17221_17235[(5)] = ex17216);


if((ex17216 instanceof Error)){
var statearr_17222_17236 = state_17208__$1;
(statearr_17222_17236[(1)] = (4));

(statearr_17222_17236[(5)] = null);

} else {
throw ex17216;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17209 === (8))){
var state_17208__$1 = state_17208;
var statearr_17223_17237 = state_17208__$1;
(statearr_17223_17237[(2)] = null);

(statearr_17223_17237[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____0 = (function (){
var statearr_17224 = [null,null,null,null,null,null,null,null];
(statearr_17224[(0)] = fluree$db$storage$core$read_block_$_state_machine__2746__auto__);

(statearr_17224[(1)] = (1));

return statearr_17224;
});
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____1 = (function (state_17208){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17208);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17225){var ex__2749__auto__ = e17225;
var statearr_17226_17238 = state_17208;
(statearr_17226_17238[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17208[(4)]))){
var statearr_17227_17239 = state_17208;
(statearr_17227_17239[(1)] = cljs.core.first.call(null,(state_17208[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17240 = state_17208;
state_17208 = G__17240;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = function(state_17208){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____1.call(this,state_17208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17228 = f__2769__auto__.call(null);
(statearr_17228[(6)] = c__2768__auto__);

return statearr_17228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17263){
var state_val_17264 = (state_17263[(1)]);
if((state_val_17264 === (7))){
var inst_17252 = (state_17263[(7)]);
var inst_17254 = fluree.db.storage.core.serde.call(null,conn);
var inst_17255 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17254,inst_17252);
var state_17263__$1 = state_17263;
var statearr_17265_17284 = state_17263__$1;
(statearr_17265_17284[(2)] = inst_17255);

(statearr_17265_17284[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (1))){
var state_17263__$1 = state_17263;
var statearr_17266_17285 = state_17263__$1;
(statearr_17266_17285[(2)] = null);

(statearr_17266_17285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (4))){
var inst_17241 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17267_17286 = state_17263__$1;
(statearr_17267_17286[(2)] = inst_17241);

(statearr_17267_17286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (6))){
var inst_17252 = (state_17263[(7)]);
var inst_17251 = (state_17263[(2)]);
var inst_17252__$1 = fluree.db.util.async.throw_err.call(null,inst_17251);
var state_17263__$1 = (function (){var statearr_17268 = state_17263;
(statearr_17268[(7)] = inst_17252__$1);

return statearr_17268;
})();
if(cljs.core.truth_(inst_17252__$1)){
var statearr_17269_17287 = state_17263__$1;
(statearr_17269_17287[(1)] = (7));

} else {
var statearr_17270_17288 = state_17263__$1;
(statearr_17270_17288[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (3))){
var inst_17261 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17263__$1,inst_17261);
} else {
if((state_val_17264 === (2))){
var _ = (function (){var statearr_17272 = state_17263;
(statearr_17272[(4)] = cljs.core.cons.call(null,(5),(state_17263[(4)])));

return statearr_17272;
})();
var inst_17247 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17248 = [inst_17247,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17249 = fluree.db.storage.core.read.call(null,conn,inst_17248);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17263__$1,(6),inst_17249);
} else {
if((state_val_17264 === (9))){
var inst_17258 = (state_17263[(2)]);
var _ = (function (){var statearr_17273 = state_17263;
(statearr_17273[(4)] = cljs.core.rest.call(null,(state_17263[(4)])));

return statearr_17273;
})();
var state_17263__$1 = state_17263;
var statearr_17274_17289 = state_17263__$1;
(statearr_17274_17289[(2)] = inst_17258);

(statearr_17274_17289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (5))){
var _ = (function (){var statearr_17275 = state_17263;
(statearr_17275[(4)] = cljs.core.rest.call(null,(state_17263[(4)])));

return statearr_17275;
})();
var state_17263__$1 = state_17263;
var ex17271 = (state_17263__$1[(2)]);
var statearr_17276_17290 = state_17263__$1;
(statearr_17276_17290[(5)] = ex17271);


if((ex17271 instanceof Error)){
var statearr_17277_17291 = state_17263__$1;
(statearr_17277_17291[(1)] = (4));

(statearr_17277_17291[(5)] = null);

} else {
throw ex17271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (8))){
var state_17263__$1 = state_17263;
var statearr_17278_17292 = state_17263__$1;
(statearr_17278_17292[(2)] = null);

(statearr_17278_17292[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_17279 = [null,null,null,null,null,null,null,null];
(statearr_17279[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__);

(statearr_17279[(1)] = (1));

return statearr_17279;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1 = (function (state_17263){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17280){var ex__2749__auto__ = e17280;
var statearr_17281_17293 = state_17263;
(statearr_17281_17293[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17263[(4)]))){
var statearr_17282_17294 = state_17263;
(statearr_17282_17294[(1)] = cljs.core.first.call(null,(state_17263[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17295 = state_17263;
state_17263 = G__17295;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = function(state_17263){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1.call(this,state_17263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17283 = f__2769__auto__.call(null);
(statearr_17283[(6)] = c__2768__auto__);

return statearr_17283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17319){
var state_val_17320 = (state_17319[(1)]);
if((state_val_17320 === (1))){
var state_17319__$1 = state_17319;
var statearr_17321_17335 = state_17319__$1;
(statearr_17321_17335[(2)] = null);

(statearr_17321_17335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17320 === (2))){
var _ = (function (){var statearr_17322 = state_17319;
(statearr_17322[(4)] = cljs.core.cons.call(null,(5),(state_17319[(4)])));

return statearr_17322;
})();
var inst_17302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17303 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17304 = (new cljs.core.PersistentVector(null,3,(5),inst_17302,inst_17303,null));
var inst_17305 = cljs.core.select_keys.call(null,block_data,inst_17304);
var inst_17306 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17305);
var inst_17307 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_17306);
var inst_17308 = [inst_17307,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17309 = fluree.db.storage.core.serde.call(null,conn);
var inst_17310 = fluree.db.serde.protocol._serialize_block.call(null,inst_17309,inst_17305);
var inst_17311 = fluree.db.storage.core.write.call(null,conn,inst_17308,inst_17310);
var state_17319__$1 = state_17319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17319__$1,(6),inst_17311);
} else {
if((state_val_17320 === (3))){
var inst_17317 = (state_17319[(2)]);
var state_17319__$1 = state_17319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17319__$1,inst_17317);
} else {
if((state_val_17320 === (4))){
var inst_17296 = (state_17319[(2)]);
var state_17319__$1 = state_17319;
var statearr_17324_17336 = state_17319__$1;
(statearr_17324_17336[(2)] = inst_17296);

(statearr_17324_17336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17320 === (5))){
var _ = (function (){var statearr_17325 = state_17319;
(statearr_17325[(4)] = cljs.core.rest.call(null,(state_17319[(4)])));

return statearr_17325;
})();
var state_17319__$1 = state_17319;
var ex17323 = (state_17319__$1[(2)]);
var statearr_17326_17337 = state_17319__$1;
(statearr_17326_17337[(5)] = ex17323);


if((ex17323 instanceof Error)){
var statearr_17327_17338 = state_17319__$1;
(statearr_17327_17338[(1)] = (4));

(statearr_17327_17338[(5)] = null);

} else {
throw ex17323;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17320 === (6))){
var inst_17313 = (state_17319[(2)]);
var inst_17314 = fluree.db.util.async.throw_err.call(null,inst_17313);
var _ = (function (){var statearr_17328 = state_17319;
(statearr_17328[(4)] = cljs.core.rest.call(null,(state_17319[(4)])));

return statearr_17328;
})();
var state_17319__$1 = state_17319;
var statearr_17329_17339 = state_17319__$1;
(statearr_17329_17339[(2)] = inst_17314);

(statearr_17329_17339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_17330 = [null,null,null,null,null,null,null];
(statearr_17330[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__);

(statearr_17330[(1)] = (1));

return statearr_17330;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1 = (function (state_17319){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17331){var ex__2749__auto__ = e17331;
var statearr_17332_17340 = state_17319;
(statearr_17332_17340[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17319[(4)]))){
var statearr_17333_17341 = state_17319;
(statearr_17333_17341[(1)] = cljs.core.first.call(null,(state_17319[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17342 = state_17319;
state_17319 = G__17342;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = function(state_17319){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1.call(this,state_17319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17334 = f__2769__auto__.call(null);
(statearr_17334[(6)] = c__2768__auto__);

return statearr_17334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17365){
var state_val_17366 = (state_17365[(1)]);
if((state_val_17366 === (1))){
var state_17365__$1 = state_17365;
var statearr_17367_17381 = state_17365__$1;
(statearr_17367_17381[(2)] = null);

(statearr_17367_17381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17366 === (2))){
var _ = (function (){var statearr_17368 = state_17365;
(statearr_17368[(4)] = cljs.core.cons.call(null,(5),(state_17365[(4)])));

return statearr_17368;
})();
var inst_17349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17350 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17351 = (new cljs.core.PersistentVector(null,3,(5),inst_17349,inst_17350,null));
var inst_17352 = cljs.core.select_keys.call(null,block_data,inst_17351);
var inst_17353 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17352);
var inst_17354 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_17353);
var inst_17355 = fluree.db.storage.core.serde.call(null,conn);
var inst_17356 = fluree.db.serde.protocol._serialize_block.call(null,inst_17355,inst_17352);
var inst_17357 = fluree.db.storage.core.write.call(null,conn,inst_17354,inst_17356);
var state_17365__$1 = state_17365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17365__$1,(6),inst_17357);
} else {
if((state_val_17366 === (3))){
var inst_17363 = (state_17365[(2)]);
var state_17365__$1 = state_17365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17365__$1,inst_17363);
} else {
if((state_val_17366 === (4))){
var inst_17343 = (state_17365[(2)]);
var state_17365__$1 = state_17365;
var statearr_17370_17382 = state_17365__$1;
(statearr_17370_17382[(2)] = inst_17343);

(statearr_17370_17382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17366 === (5))){
var _ = (function (){var statearr_17371 = state_17365;
(statearr_17371[(4)] = cljs.core.rest.call(null,(state_17365[(4)])));

return statearr_17371;
})();
var state_17365__$1 = state_17365;
var ex17369 = (state_17365__$1[(2)]);
var statearr_17372_17383 = state_17365__$1;
(statearr_17372_17383[(5)] = ex17369);


if((ex17369 instanceof Error)){
var statearr_17373_17384 = state_17365__$1;
(statearr_17373_17384[(1)] = (4));

(statearr_17373_17384[(5)] = null);

} else {
throw ex17369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17366 === (6))){
var inst_17359 = (state_17365[(2)]);
var inst_17360 = fluree.db.util.async.throw_err.call(null,inst_17359);
var _ = (function (){var statearr_17374 = state_17365;
(statearr_17374[(4)] = cljs.core.rest.call(null,(state_17365[(4)])));

return statearr_17374;
})();
var state_17365__$1 = state_17365;
var statearr_17375_17385 = state_17365__$1;
(statearr_17375_17385[(2)] = inst_17360);

(statearr_17375_17385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____0 = (function (){
var statearr_17376 = [null,null,null,null,null,null,null];
(statearr_17376[(0)] = fluree$db$storage$core$write_block_$_state_machine__2746__auto__);

(statearr_17376[(1)] = (1));

return statearr_17376;
});
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____1 = (function (state_17365){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17377){var ex__2749__auto__ = e17377;
var statearr_17378_17386 = state_17365;
(statearr_17378_17386[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17365[(4)]))){
var statearr_17379_17387 = state_17365;
(statearr_17379_17387[(1)] = cljs.core.first.call(null,(state_17365[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17388 = state_17365;
state_17365 = G__17388;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = function(state_17365){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____1.call(this,state_17365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17380 = f__2769__auto__.call(null);
(statearr_17380[(6)] = c__2768__auto__);

return statearr_17380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__17390 = arguments.length;
switch (G__17390) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.call(null,conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__17391){
var map__17392 = p__17391;
var map__17392__$1 = cljs.core.__destructure_map.call(null,map__17392);
var leaf = map__17392__$1;
var flakes = cljs.core.get.call(null,map__17392__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17413){
var state_val_17414 = (state_17413[(1)]);
if((state_val_17414 === (1))){
var state_17413__$1 = state_17413;
var statearr_17415_17431 = state_17413__$1;
(statearr_17415_17431[(2)] = null);

(statearr_17415_17431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17414 === (2))){
var _ = (function (){var statearr_17416 = state_17413;
(statearr_17416[(4)] = cljs.core.cons.call(null,(5),(state_17413[(4)])));

return statearr_17416;
})();
var inst_17399 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17400 = [flakes];
var inst_17401 = cljs.core.PersistentHashMap.fromArrays(inst_17399,inst_17400);
var inst_17402 = fluree.db.storage.core.serde.call(null,conn);
var inst_17403 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_17402,inst_17401);
var inst_17404 = fluree.db.storage.core.write.call(null,conn,leaf_id,inst_17403);
var state_17413__$1 = state_17413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17413__$1,(6),inst_17404);
} else {
if((state_val_17414 === (3))){
var inst_17411 = (state_17413[(2)]);
var state_17413__$1 = state_17413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17413__$1,inst_17411);
} else {
if((state_val_17414 === (4))){
var inst_17393 = (state_17413[(2)]);
var state_17413__$1 = state_17413;
var statearr_17418_17432 = state_17413__$1;
(statearr_17418_17432[(2)] = inst_17393);

(statearr_17418_17432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17414 === (5))){
var _ = (function (){var statearr_17419 = state_17413;
(statearr_17419[(4)] = cljs.core.rest.call(null,(state_17413[(4)])));

return statearr_17419;
})();
var state_17413__$1 = state_17413;
var ex17417 = (state_17413__$1[(2)]);
var statearr_17420_17433 = state_17413__$1;
(statearr_17420_17433[(5)] = ex17417);


if((ex17417 instanceof Error)){
var statearr_17421_17434 = state_17413__$1;
(statearr_17421_17434[(1)] = (4));

(statearr_17421_17434[(5)] = null);

} else {
throw ex17417;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17414 === (6))){
var inst_17406 = (state_17413[(2)]);
var inst_17407 = fluree.db.util.async.throw_err.call(null,inst_17406);
var inst_17408 = cljs.core.assoc.call(null,leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_17422 = state_17413;
(statearr_17422[(4)] = cljs.core.rest.call(null,(state_17413[(4)])));

return statearr_17422;
})();
var state_17413__$1 = (function (){var statearr_17423 = state_17413;
(statearr_17423[(7)] = inst_17407);

return statearr_17423;
})();
var statearr_17424_17435 = state_17413__$1;
(statearr_17424_17435[(2)] = inst_17408);

(statearr_17424_17435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17425 = [null,null,null,null,null,null,null,null];
(statearr_17425[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17425[(1)] = (1));

return statearr_17425;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17413){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17426){var ex__2749__auto__ = e17426;
var statearr_17427_17436 = state_17413;
(statearr_17427_17436[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17413[(4)]))){
var statearr_17428_17437 = state_17413;
(statearr_17428_17437[(1)] = cljs.core.first.call(null,(state_17413[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17438 = state_17413;
state_17413 = G__17438;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17413){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17429 = f__2769__auto__.call(null);
(statearr_17429[(6)] = c__2768__auto__);

return statearr_17429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17455){
var state_val_17456 = (state_17455[(1)]);
if((state_val_17456 === (1))){
var state_17455__$1 = state_17455;
var statearr_17457_17472 = state_17455__$1;
(statearr_17457_17472[(2)] = null);

(statearr_17457_17472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17456 === (2))){
var _ = (function (){var statearr_17458 = state_17455;
(statearr_17458[(4)] = cljs.core.cons.call(null,(5),(state_17455[(4)])));

return statearr_17458;
})();
var inst_17445 = fluree.db.storage.core.serde.call(null,conn);
var inst_17446 = fluree.db.serde.protocol._serialize_branch.call(null,inst_17445,data);
var inst_17447 = fluree.db.storage.core.write.call(null,conn,key,inst_17446);
var state_17455__$1 = state_17455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17455__$1,(6),inst_17447);
} else {
if((state_val_17456 === (3))){
var inst_17453 = (state_17455[(2)]);
var state_17455__$1 = state_17455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17455__$1,inst_17453);
} else {
if((state_val_17456 === (4))){
var inst_17439 = (state_17455[(2)]);
var state_17455__$1 = state_17455;
var statearr_17460_17473 = state_17455__$1;
(statearr_17460_17473[(2)] = inst_17439);

(statearr_17460_17473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17456 === (5))){
var _ = (function (){var statearr_17461 = state_17455;
(statearr_17461[(4)] = cljs.core.rest.call(null,(state_17455[(4)])));

return statearr_17461;
})();
var state_17455__$1 = state_17455;
var ex17459 = (state_17455__$1[(2)]);
var statearr_17462_17474 = state_17455__$1;
(statearr_17462_17474[(5)] = ex17459);


if((ex17459 instanceof Error)){
var statearr_17463_17475 = state_17455__$1;
(statearr_17463_17475[(1)] = (4));

(statearr_17463_17475[(5)] = null);

} else {
throw ex17459;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17456 === (6))){
var inst_17449 = (state_17455[(2)]);
var inst_17450 = fluree.db.util.async.throw_err.call(null,inst_17449);
var _ = (function (){var statearr_17464 = state_17455;
(statearr_17464[(4)] = cljs.core.rest.call(null,(state_17455[(4)])));

return statearr_17464;
})();
var state_17455__$1 = (function (){var statearr_17465 = state_17455;
(statearr_17465[(7)] = inst_17450);

return statearr_17465;
})();
var statearr_17466_17476 = state_17455__$1;
(statearr_17466_17476[(2)] = key);

(statearr_17466_17476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0 = (function (){
var statearr_17467 = [null,null,null,null,null,null,null,null];
(statearr_17467[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__);

(statearr_17467[(1)] = (1));

return statearr_17467;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1 = (function (state_17455){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17468){var ex__2749__auto__ = e17468;
var statearr_17469_17477 = state_17455;
(statearr_17469_17477[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17455[(4)]))){
var statearr_17470_17478 = state_17455;
(statearr_17470_17478[(1)] = cljs.core.first.call(null,(state_17455[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17479 = state_17455;
state_17455 = G__17479;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = function(state_17455){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1.call(this,state_17455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17471 = f__2769__auto__.call(null);
(statearr_17471[(6)] = c__2768__auto__);

return statearr_17471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__17481 = arguments.length;
switch (G__17481) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.call(null,conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__17482){
var map__17483 = p__17482;
var map__17483__$1 = cljs.core.__destructure_map.call(null,map__17483);
var branch = map__17483__$1;
var children = cljs.core.get.call(null,map__17483__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17509){
var state_val_17510 = (state_17509[(1)]);
if((state_val_17510 === (1))){
var state_17509__$1 = state_17509;
var statearr_17511_17528 = state_17509__$1;
(statearr_17511_17528[(2)] = null);

(statearr_17511_17528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17510 === (2))){
var _ = (function (){var statearr_17512 = state_17509;
(statearr_17512[(4)] = cljs.core.cons.call(null,(5),(state_17509[(4)])));

return statearr_17512;
})();
var inst_17490 = cljs.core.map.call(null,cljs.core.val,children);
var inst_17491 = cljs.core.mapv.call(null,fluree.db.storage.core.child_data,inst_17490);
var inst_17492 = cljs.core.first.call(null,inst_17491);
var inst_17493 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_17492);
var inst_17494 = cljs.core.rseq.call(null,inst_17491);
var inst_17495 = cljs.core.first.call(null,inst_17494);
var inst_17496 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_17495);
var inst_17497 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_17498 = [inst_17491];
var inst_17499 = cljs.core.PersistentHashMap.fromArrays(inst_17497,inst_17498);
var inst_17500 = fluree.db.storage.core.write_branch_data.call(null,conn,branch_id,inst_17499);
var state_17509__$1 = (function (){var statearr_17513 = state_17509;
(statearr_17513[(7)] = inst_17493);

(statearr_17513[(8)] = inst_17496);

return statearr_17513;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17509__$1,(6),inst_17500);
} else {
if((state_val_17510 === (3))){
var inst_17507 = (state_17509[(2)]);
var state_17509__$1 = state_17509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17509__$1,inst_17507);
} else {
if((state_val_17510 === (4))){
var inst_17484 = (state_17509[(2)]);
var state_17509__$1 = state_17509;
var statearr_17515_17529 = state_17509__$1;
(statearr_17515_17529[(2)] = inst_17484);

(statearr_17515_17529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17510 === (5))){
var _ = (function (){var statearr_17516 = state_17509;
(statearr_17516[(4)] = cljs.core.rest.call(null,(state_17509[(4)])));

return statearr_17516;
})();
var state_17509__$1 = state_17509;
var ex17514 = (state_17509__$1[(2)]);
var statearr_17517_17530 = state_17509__$1;
(statearr_17517_17530[(5)] = ex17514);


if((ex17514 instanceof Error)){
var statearr_17518_17531 = state_17509__$1;
(statearr_17518_17531[(1)] = (4));

(statearr_17518_17531[(5)] = null);

} else {
throw ex17514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17510 === (6))){
var inst_17502 = (state_17509[(2)]);
var inst_17503 = fluree.db.util.async.throw_err.call(null,inst_17502);
var inst_17504 = cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_17519 = state_17509;
(statearr_17519[(4)] = cljs.core.rest.call(null,(state_17509[(4)])));

return statearr_17519;
})();
var state_17509__$1 = (function (){var statearr_17520 = state_17509;
(statearr_17520[(9)] = inst_17503);

return statearr_17520;
})();
var statearr_17521_17532 = state_17509__$1;
(statearr_17521_17532[(2)] = inst_17504);

(statearr_17521_17532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17522 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17522[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17522[(1)] = (1));

return statearr_17522;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17509){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17523){var ex__2749__auto__ = e17523;
var statearr_17524_17533 = state_17509;
(statearr_17524_17533[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17509[(4)]))){
var statearr_17525_17534 = state_17509;
(statearr_17525_17534[(1)] = cljs.core.first.call(null,(state_17509[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17535 = state_17509;
state_17509 = G__17535;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17509){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17526 = f__2769__auto__.call(null);
(statearr_17526[(6)] = c__2768__auto__);

return statearr_17526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17563){
var state_val_17564 = (state_17563[(1)]);
if((state_val_17564 === (1))){
var state_17563__$1 = state_17563;
var statearr_17565_17581 = state_17563__$1;
(statearr_17565_17581[(2)] = null);

(statearr_17565_17581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17564 === (2))){
var inst_17549 = (state_17563[(7)]);
var _ = (function (){var statearr_17566 = state_17563;
(statearr_17566[(4)] = cljs.core.cons.call(null,(5),(state_17563[(4)])));

return statearr_17566;
})();
var inst_17543 = db;
var inst_17544 = cljs.core.__destructure_map.call(null,inst_17543);
var inst_17545 = cljs.core.get.call(null,inst_17544,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17546 = cljs.core.get.call(null,inst_17544,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17547 = cljs.core.get.call(null,inst_17544,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17548 = cljs.core.get.call(null,inst_17544,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17549__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_17546,inst_17547,inst_17548);
var inst_17550 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17551 = [inst_17547,inst_17548,garbage];
var inst_17552 = cljs.core.PersistentHashMap.fromArrays(inst_17550,inst_17551);
var inst_17553 = fluree.db.storage.core.serde.call(null,inst_17545);
var inst_17554 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_17553,inst_17552);
var inst_17555 = fluree.db.storage.core.write.call(null,inst_17545,inst_17549__$1,inst_17554);
var state_17563__$1 = (function (){var statearr_17567 = state_17563;
(statearr_17567[(7)] = inst_17549__$1);

return statearr_17567;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17563__$1,(6),inst_17555);
} else {
if((state_val_17564 === (3))){
var inst_17561 = (state_17563[(2)]);
var state_17563__$1 = state_17563;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17563__$1,inst_17561);
} else {
if((state_val_17564 === (4))){
var inst_17536 = (state_17563[(2)]);
var state_17563__$1 = state_17563;
var statearr_17569_17582 = state_17563__$1;
(statearr_17569_17582[(2)] = inst_17536);

(statearr_17569_17582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17564 === (5))){
var _ = (function (){var statearr_17570 = state_17563;
(statearr_17570[(4)] = cljs.core.rest.call(null,(state_17563[(4)])));

return statearr_17570;
})();
var state_17563__$1 = state_17563;
var ex17568 = (state_17563__$1[(2)]);
var statearr_17571_17583 = state_17563__$1;
(statearr_17571_17583[(5)] = ex17568);


if((ex17568 instanceof Error)){
var statearr_17572_17584 = state_17563__$1;
(statearr_17572_17584[(1)] = (4));

(statearr_17572_17584[(5)] = null);

} else {
throw ex17568;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17564 === (6))){
var inst_17549 = (state_17563[(7)]);
var inst_17557 = (state_17563[(2)]);
var inst_17558 = fluree.db.util.async.throw_err.call(null,inst_17557);
var _ = (function (){var statearr_17573 = state_17563;
(statearr_17573[(4)] = cljs.core.rest.call(null,(state_17563[(4)])));

return statearr_17573;
})();
var state_17563__$1 = (function (){var statearr_17574 = state_17563;
(statearr_17574[(8)] = inst_17558);

return statearr_17574;
})();
var statearr_17575_17585 = state_17563__$1;
(statearr_17575_17585[(2)] = inst_17549);

(statearr_17575_17585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_17576 = [null,null,null,null,null,null,null,null,null];
(statearr_17576[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__);

(statearr_17576[(1)] = (1));

return statearr_17576;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1 = (function (state_17563){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17577){var ex__2749__auto__ = e17577;
var statearr_17578_17586 = state_17563;
(statearr_17578_17586[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17563[(4)]))){
var statearr_17579_17587 = state_17563;
(statearr_17579_17587[(1)] = cljs.core.first.call(null,(state_17563[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17588 = state_17563;
state_17563 = G__17588;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = function(state_17563){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1.call(this,state_17563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17580 = f__2769__auto__.call(null);
(statearr_17580[(6)] = c__2768__auto__);

return statearr_17580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17590 = arguments.length;
switch (G__17590) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17648){
var state_val_17649 = (state_17648[(1)]);
if((state_val_17649 === (7))){
var state_17648__$1 = state_17648;
var statearr_17650_17676 = state_17648__$1;
(statearr_17650_17676[(2)] = (0));

(statearr_17650_17676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (1))){
var state_17648__$1 = state_17648;
var statearr_17651_17677 = state_17648__$1;
(statearr_17651_17677[(2)] = null);

(statearr_17651_17677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (4))){
var inst_17591 = (state_17648[(2)]);
var state_17648__$1 = state_17648;
var statearr_17652_17678 = state_17648__$1;
(statearr_17652_17678[(2)] = inst_17591);

(statearr_17652_17678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (6))){
var inst_17617 = (state_17648[(7)]);
var state_17648__$1 = state_17648;
var statearr_17653_17679 = state_17648__$1;
(statearr_17653_17679[(2)] = inst_17617);

(statearr_17653_17679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (3))){
var inst_17646 = (state_17648[(2)]);
var state_17648__$1 = state_17648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17648__$1,inst_17646);
} else {
if((state_val_17649 === (12))){
var inst_17614 = (state_17648[(8)]);
var inst_17642 = (state_17648[(2)]);
var inst_17643 = fluree.db.util.async.throw_err.call(null,inst_17642);
var _ = (function (){var statearr_17654 = state_17648;
(statearr_17654[(4)] = cljs.core.rest.call(null,(state_17648[(4)])));

return statearr_17654;
})();
var state_17648__$1 = (function (){var statearr_17655 = state_17648;
(statearr_17655[(9)] = inst_17643);

return statearr_17655;
})();
var statearr_17656_17680 = state_17648__$1;
(statearr_17656_17680[(2)] = inst_17614);

(statearr_17656_17680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (2))){
var inst_17604 = (state_17648[(10)]);
var inst_17617 = (state_17648[(7)]);
var inst_17609 = (state_17648[(11)]);
var inst_17606 = (state_17648[(12)]);
var _ = (function (){var statearr_17657 = state_17648;
(statearr_17657[(4)] = cljs.core.cons.call(null,(5),(state_17648[(4)])));

return statearr_17657;
})();
var inst_17598 = db;
var inst_17599 = cljs.core.__destructure_map.call(null,inst_17598);
var inst_17600 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17601 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17602 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17603 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17604__$1 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17605 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17606__$1 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17607 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17608 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_17609__$1 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17610 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17611 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17612 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17613 = cljs.core.get.call(null,inst_17599,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17614 = fluree.db.storage.core.ledger_root_key.call(null,inst_17600,inst_17609__$1,inst_17606__$1);
var inst_17615 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17616 = fluree.db.storage.core.child_data.call(null,inst_17607);
var inst_17617__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17604__$1);
var state_17648__$1 = (function (){var statearr_17658 = state_17648;
(statearr_17658[(13)] = inst_17605);

(statearr_17658[(14)] = inst_17603);

(statearr_17658[(15)] = inst_17612);

(statearr_17658[(10)] = inst_17604__$1);

(statearr_17658[(16)] = inst_17610);

(statearr_17658[(17)] = inst_17602);

(statearr_17658[(18)] = inst_17601);

(statearr_17658[(19)] = inst_17616);

(statearr_17658[(7)] = inst_17617__$1);

(statearr_17658[(11)] = inst_17609__$1);

(statearr_17658[(20)] = inst_17613);

(statearr_17658[(21)] = inst_17615);

(statearr_17658[(22)] = inst_17611);

(statearr_17658[(12)] = inst_17606__$1);

(statearr_17658[(8)] = inst_17614);

(statearr_17658[(23)] = inst_17608);

return statearr_17658;
})();
if(cljs.core.truth_(inst_17617__$1)){
var statearr_17659_17681 = state_17648__$1;
(statearr_17659_17681[(1)] = (6));

} else {
var statearr_17660_17682 = state_17648__$1;
(statearr_17660_17682[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (11))){
var inst_17605 = (state_17648[(13)]);
var inst_17603 = (state_17648[(14)]);
var inst_17612 = (state_17648[(15)]);
var inst_17604 = (state_17648[(10)]);
var inst_17602 = (state_17648[(17)]);
var inst_17601 = (state_17648[(18)]);
var inst_17616 = (state_17648[(19)]);
var inst_17621 = (state_17648[(24)]);
var inst_17622 = (state_17648[(25)]);
var inst_17609 = (state_17648[(11)]);
var inst_17613 = (state_17648[(20)]);
var inst_17615 = (state_17648[(21)]);
var inst_17611 = (state_17648[(22)]);
var inst_17606 = (state_17648[(12)]);
var inst_17614 = (state_17648[(8)]);
var inst_17627 = (state_17648[(2)]);
var inst_17628 = fluree.db.storage.core.child_data.call(null,inst_17611);
var inst_17629 = fluree.db.storage.core.child_data.call(null,inst_17613);
var inst_17630 = fluree.db.util.core.current_time_millis.call(null);
var inst_17631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17632 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17633 = (new cljs.core.PersistentVector(null,2,(5),inst_17631,inst_17632,null));
var inst_17634 = cljs.core.select_keys.call(null,inst_17604,inst_17633);
var inst_17635 = fluree.db.storage.core.child_data.call(null,inst_17603);
var inst_17636 = [inst_17606,inst_17616,inst_17621,inst_17609,inst_17622,inst_17627,inst_17628,inst_17629,inst_17601,inst_17630,inst_17602,inst_17612,inst_17634,inst_17635];
var inst_17637 = cljs.core.PersistentHashMap.fromArrays(inst_17615,inst_17636);
var inst_17638 = fluree.db.storage.core.serde.call(null,inst_17605);
var inst_17639 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_17638,inst_17637);
var inst_17640 = fluree.db.storage.core.write.call(null,inst_17605,inst_17614,inst_17639);
var state_17648__$1 = state_17648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17648__$1,(12),inst_17640);
} else {
if((state_val_17649 === (9))){
var inst_17623 = (state_17648[(26)]);
var state_17648__$1 = state_17648;
var statearr_17662_17683 = state_17648__$1;
(statearr_17662_17683[(2)] = inst_17623);

(statearr_17662_17683[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (5))){
var _ = (function (){var statearr_17663 = state_17648;
(statearr_17663[(4)] = cljs.core.rest.call(null,(state_17648[(4)])));

return statearr_17663;
})();
var state_17648__$1 = state_17648;
var ex17661 = (state_17648__$1[(2)]);
var statearr_17664_17684 = state_17648__$1;
(statearr_17664_17684[(5)] = ex17661);


if((ex17661 instanceof Error)){
var statearr_17665_17685 = state_17648__$1;
(statearr_17665_17685[(1)] = (4));

(statearr_17665_17685[(5)] = null);

} else {
throw ex17661;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (10))){
var inst_17610 = (state_17648[(16)]);
var state_17648__$1 = state_17648;
var statearr_17666_17686 = state_17648__$1;
(statearr_17666_17686[(2)] = inst_17610);

(statearr_17666_17686[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17649 === (8))){
var inst_17623 = (state_17648[(26)]);
var inst_17608 = (state_17648[(23)]);
var inst_17621 = (state_17648[(2)]);
var inst_17622 = fluree.db.storage.core.child_data.call(null,inst_17608);
var inst_17623__$1 = custom_ecount;
var state_17648__$1 = (function (){var statearr_17667 = state_17648;
(statearr_17667[(26)] = inst_17623__$1);

(statearr_17667[(24)] = inst_17621);

(statearr_17667[(25)] = inst_17622);

return statearr_17667;
})();
if(cljs.core.truth_(inst_17623__$1)){
var statearr_17668_17687 = state_17648__$1;
(statearr_17668_17687[(1)] = (9));

} else {
var statearr_17669_17688 = state_17648__$1;
(statearr_17669_17688[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17670[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17670[(1)] = (1));

return statearr_17670;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17648){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17671){var ex__2749__auto__ = e17671;
var statearr_17672_17689 = state_17648;
(statearr_17672_17689[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17648[(4)]))){
var statearr_17673_17690 = state_17648;
(statearr_17673_17690[(1)] = cljs.core.first.call(null,(state_17648[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17691 = state_17648;
state_17648 = G__17691;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17648){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17674 = f__2769__auto__.call(null);
(statearr_17674[(6)] = c__2768__auto__);

return statearr_17674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__17692,key){
var map__17693 = p__17692;
var map__17693__$1 = cljs.core.__destructure_map.call(null,map__17693);
var conn = map__17693__$1;
var serializer = cljs.core.get.call(null,map__17693__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17713){
var state_val_17714 = (state_17713[(1)]);
if((state_val_17714 === (7))){
var inst_17703 = (state_17713[(7)]);
var inst_17705 = fluree.db.serde.protocol._deserialize_branch.call(null,serializer,inst_17703);
var state_17713__$1 = state_17713;
var statearr_17715_17734 = state_17713__$1;
(statearr_17715_17734[(2)] = inst_17705);

(statearr_17715_17734[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (1))){
var state_17713__$1 = state_17713;
var statearr_17716_17735 = state_17713__$1;
(statearr_17716_17735[(2)] = null);

(statearr_17716_17735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (4))){
var inst_17694 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17717_17736 = state_17713__$1;
(statearr_17717_17736[(2)] = inst_17694);

(statearr_17717_17736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (6))){
var inst_17703 = (state_17713[(7)]);
var inst_17702 = (state_17713[(2)]);
var inst_17703__$1 = fluree.db.util.async.throw_err.call(null,inst_17702);
var state_17713__$1 = (function (){var statearr_17718 = state_17713;
(statearr_17718[(7)] = inst_17703__$1);

return statearr_17718;
})();
if(cljs.core.truth_(inst_17703__$1)){
var statearr_17719_17737 = state_17713__$1;
(statearr_17719_17737[(1)] = (7));

} else {
var statearr_17720_17738 = state_17713__$1;
(statearr_17720_17738[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (3))){
var inst_17711 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17713__$1,inst_17711);
} else {
if((state_val_17714 === (2))){
var _ = (function (){var statearr_17722 = state_17713;
(statearr_17722[(4)] = cljs.core.cons.call(null,(5),(state_17713[(4)])));

return statearr_17722;
})();
var inst_17700 = fluree.db.storage.core.read.call(null,conn,key);
var state_17713__$1 = state_17713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17713__$1,(6),inst_17700);
} else {
if((state_val_17714 === (9))){
var inst_17708 = (state_17713[(2)]);
var _ = (function (){var statearr_17723 = state_17713;
(statearr_17723[(4)] = cljs.core.rest.call(null,(state_17713[(4)])));

return statearr_17723;
})();
var state_17713__$1 = state_17713;
var statearr_17724_17739 = state_17713__$1;
(statearr_17724_17739[(2)] = inst_17708);

(statearr_17724_17739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (5))){
var _ = (function (){var statearr_17725 = state_17713;
(statearr_17725[(4)] = cljs.core.rest.call(null,(state_17713[(4)])));

return statearr_17725;
})();
var state_17713__$1 = state_17713;
var ex17721 = (state_17713__$1[(2)]);
var statearr_17726_17740 = state_17713__$1;
(statearr_17726_17740[(5)] = ex17721);


if((ex17721 instanceof Error)){
var statearr_17727_17741 = state_17713__$1;
(statearr_17727_17741[(1)] = (4));

(statearr_17727_17741[(5)] = null);

} else {
throw ex17721;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (8))){
var state_17713__$1 = state_17713;
var statearr_17728_17742 = state_17713__$1;
(statearr_17728_17742[(2)] = null);

(statearr_17728_17742[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0 = (function (){
var statearr_17729 = [null,null,null,null,null,null,null,null];
(statearr_17729[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2746__auto__);

(statearr_17729[(1)] = (1));

return statearr_17729;
});
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1 = (function (state_17713){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17730){var ex__2749__auto__ = e17730;
var statearr_17731_17743 = state_17713;
(statearr_17731_17743[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17713[(4)]))){
var statearr_17732_17744 = state_17713;
(statearr_17732_17744[(1)] = cljs.core.first.call(null,(state_17713[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17745 = state_17713;
state_17713 = G__17745;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = function(state_17713){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1.call(this,state_17713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17733 = f__2769__auto__.call(null);
(statearr_17733[(6)] = c__2768__auto__);

return statearr_17733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17746,key){
var map__17747 = p__17746;
var map__17747__$1 = cljs.core.__destructure_map.call(null,map__17747);
var conn = map__17747__$1;
var serializer = cljs.core.get.call(null,map__17747__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17767){
var state_val_17768 = (state_17767[(1)]);
if((state_val_17768 === (7))){
var inst_17757 = (state_17767[(7)]);
var inst_17759 = fluree.db.serde.protocol._deserialize_leaf.call(null,serializer,inst_17757);
var state_17767__$1 = state_17767;
var statearr_17769_17788 = state_17767__$1;
(statearr_17769_17788[(2)] = inst_17759);

(statearr_17769_17788[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17768 === (1))){
var state_17767__$1 = state_17767;
var statearr_17770_17789 = state_17767__$1;
(statearr_17770_17789[(2)] = null);

(statearr_17770_17789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17768 === (4))){
var inst_17748 = (state_17767[(2)]);
var state_17767__$1 = state_17767;
var statearr_17771_17790 = state_17767__$1;
(statearr_17771_17790[(2)] = inst_17748);

(statearr_17771_17790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17768 === (6))){
var inst_17757 = (state_17767[(7)]);
var inst_17756 = (state_17767[(2)]);
var inst_17757__$1 = fluree.db.util.async.throw_err.call(null,inst_17756);
var state_17767__$1 = (function (){var statearr_17772 = state_17767;
(statearr_17772[(7)] = inst_17757__$1);

return statearr_17772;
})();
if(cljs.core.truth_(inst_17757__$1)){
var statearr_17773_17791 = state_17767__$1;
(statearr_17773_17791[(1)] = (7));

} else {
var statearr_17774_17792 = state_17767__$1;
(statearr_17774_17792[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17768 === (3))){
var inst_17765 = (state_17767[(2)]);
var state_17767__$1 = state_17767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17767__$1,inst_17765);
} else {
if((state_val_17768 === (2))){
var _ = (function (){var statearr_17776 = state_17767;
(statearr_17776[(4)] = cljs.core.cons.call(null,(5),(state_17767[(4)])));

return statearr_17776;
})();
var inst_17754 = fluree.db.storage.core.read.call(null,conn,key);
var state_17767__$1 = state_17767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17767__$1,(6),inst_17754);
} else {
if((state_val_17768 === (9))){
var inst_17762 = (state_17767[(2)]);
var _ = (function (){var statearr_17777 = state_17767;
(statearr_17777[(4)] = cljs.core.rest.call(null,(state_17767[(4)])));

return statearr_17777;
})();
var state_17767__$1 = state_17767;
var statearr_17778_17793 = state_17767__$1;
(statearr_17778_17793[(2)] = inst_17762);

(statearr_17778_17793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17768 === (5))){
var _ = (function (){var statearr_17779 = state_17767;
(statearr_17779[(4)] = cljs.core.rest.call(null,(state_17767[(4)])));

return statearr_17779;
})();
var state_17767__$1 = state_17767;
var ex17775 = (state_17767__$1[(2)]);
var statearr_17780_17794 = state_17767__$1;
(statearr_17780_17794[(5)] = ex17775);


if((ex17775 instanceof Error)){
var statearr_17781_17795 = state_17767__$1;
(statearr_17781_17795[(1)] = (4));

(statearr_17781_17795[(5)] = null);

} else {
throw ex17775;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17768 === (8))){
var state_17767__$1 = state_17767;
var statearr_17782_17796 = state_17767__$1;
(statearr_17782_17796[(2)] = null);

(statearr_17782_17796[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_17783 = [null,null,null,null,null,null,null,null];
(statearr_17783[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__);

(statearr_17783[(1)] = (1));

return statearr_17783;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1 = (function (state_17767){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17784){var ex__2749__auto__ = e17784;
var statearr_17785_17797 = state_17767;
(statearr_17785_17797[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17767[(4)]))){
var statearr_17786_17798 = state_17767;
(statearr_17786_17798[(1)] = cljs.core.first.call(null,(state_17767[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17799 = state_17767;
state_17767 = G__17799;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = function(state_17767){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1.call(this,state_17767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17787 = f__2769__auto__.call(null);
(statearr_17787[(6)] = c__2768__auto__);

return statearr_17787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17800,index,index_data){
var map__17801 = p__17800;
var map__17801__$1 = cljs.core.__destructure_map.call(null,map__17801);
var network = cljs.core.get.call(null,map__17801__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__17801__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.call(null,map__17801__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.call(null,map__17801__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17801__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__5045__auto__ = cljs.core.get.call(null,comparators,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db index root: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17802 = index_data;
var G__17802__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17802,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17802);
var G__17802__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17802__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17802__$1);
return cljs.core.assoc.call(null,G__17802__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true);

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17803 = root_data;
var map__17803__$1 = cljs.core.__destructure_map.call(null,map__17803);
var block = cljs.core.get.call(null,map__17803__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17803__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__17803__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__17803__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root.call(null,conn,db,idx,cljs.core.get.call(null,root_data,idx));
return cljs.core.assoc.call(null,db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17825){
var state_val_17826 = (state_17825[(1)]);
if((state_val_17826 === (7))){
var state_17825__$1 = state_17825;
var statearr_17827_17847 = state_17825__$1;
(statearr_17827_17847[(2)] = null);

(statearr_17827_17847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17826 === (1))){
var state_17825__$1 = state_17825;
var statearr_17828_17848 = state_17825__$1;
(statearr_17828_17848[(2)] = null);

(statearr_17828_17848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17826 === (4))){
var inst_17804 = (state_17825[(2)]);
var state_17825__$1 = state_17825;
var statearr_17829_17849 = state_17825__$1;
(statearr_17829_17849[(2)] = inst_17804);

(statearr_17829_17849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17826 === (6))){
var inst_17811 = (state_17825[(7)]);
var inst_17813 = fluree.db.storage.core.serde.call(null,conn);
var state_17825__$1 = (function (){var statearr_17830 = state_17825;
(statearr_17830[(8)] = inst_17813);

return statearr_17830;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17825__$1,(9),inst_17811);
} else {
if((state_val_17826 === (3))){
var inst_17823 = (state_17825[(2)]);
var state_17825__$1 = state_17825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17825__$1,inst_17823);
} else {
if((state_val_17826 === (2))){
var inst_17811 = (state_17825[(7)]);
var _ = (function (){var statearr_17832 = state_17825;
(statearr_17832[(4)] = cljs.core.cons.call(null,(5),(state_17825[(4)])));

return statearr_17832;
})();
var inst_17810 = fluree.db.storage.core.ledger_garbage_key.call(null,network,ledger_id,block);
var inst_17811__$1 = fluree.db.storage.core.read.call(null,conn,inst_17810);
var state_17825__$1 = (function (){var statearr_17833 = state_17825;
(statearr_17833[(7)] = inst_17811__$1);

return statearr_17833;
})();
if(cljs.core.truth_(inst_17811__$1)){
var statearr_17834_17850 = state_17825__$1;
(statearr_17834_17850[(1)] = (6));

} else {
var statearr_17835_17851 = state_17825__$1;
(statearr_17835_17851[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17826 === (9))){
var inst_17813 = (state_17825[(8)]);
var inst_17815 = (state_17825[(2)]);
var inst_17816 = fluree.db.util.async.throw_err.call(null,inst_17815);
var inst_17817 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_17813,inst_17816);
var state_17825__$1 = state_17825;
var statearr_17836_17852 = state_17825__$1;
(statearr_17836_17852[(2)] = inst_17817);

(statearr_17836_17852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17826 === (5))){
var _ = (function (){var statearr_17837 = state_17825;
(statearr_17837[(4)] = cljs.core.rest.call(null,(state_17825[(4)])));

return statearr_17837;
})();
var state_17825__$1 = state_17825;
var ex17831 = (state_17825__$1[(2)]);
var statearr_17838_17853 = state_17825__$1;
(statearr_17838_17853[(5)] = ex17831);


if((ex17831 instanceof Error)){
var statearr_17839_17854 = state_17825__$1;
(statearr_17839_17854[(1)] = (4));

(statearr_17839_17854[(5)] = null);

} else {
throw ex17831;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17826 === (8))){
var inst_17820 = (state_17825[(2)]);
var _ = (function (){var statearr_17840 = state_17825;
(statearr_17840[(4)] = cljs.core.rest.call(null,(state_17825[(4)])));

return statearr_17840;
})();
var state_17825__$1 = state_17825;
var statearr_17841_17855 = state_17825__$1;
(statearr_17841_17855[(2)] = inst_17820);

(statearr_17841_17855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_17842 = [null,null,null,null,null,null,null,null,null];
(statearr_17842[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__);

(statearr_17842[(1)] = (1));

return statearr_17842;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1 = (function (state_17825){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17843){var ex__2749__auto__ = e17843;
var statearr_17844_17856 = state_17825;
(statearr_17844_17856[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17825[(4)]))){
var statearr_17845_17857 = state_17825;
(statearr_17845_17857[(1)] = cljs.core.first.call(null,(state_17825[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17858 = state_17825;
state_17825 = G__17858;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = function(state_17825){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1.call(this,state_17825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17846 = f__2769__auto__.call(null);
(statearr_17846[(6)] = c__2768__auto__);

return statearr_17846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17880){
var state_val_17881 = (state_17880[(1)]);
if((state_val_17881 === (7))){
var inst_17869 = (state_17880[(7)]);
var inst_17871 = fluree.db.storage.core.serde.call(null,conn);
var inst_17872 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_17871,inst_17869);
var state_17880__$1 = state_17880;
var statearr_17882_17901 = state_17880__$1;
(statearr_17882_17901[(2)] = inst_17872);

(statearr_17882_17901[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17881 === (1))){
var state_17880__$1 = state_17880;
var statearr_17883_17902 = state_17880__$1;
(statearr_17883_17902[(2)] = null);

(statearr_17883_17902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17881 === (4))){
var inst_17859 = (state_17880[(2)]);
var state_17880__$1 = state_17880;
var statearr_17884_17903 = state_17880__$1;
(statearr_17884_17903[(2)] = inst_17859);

(statearr_17884_17903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17881 === (6))){
var inst_17869 = (state_17880[(7)]);
var inst_17868 = (state_17880[(2)]);
var inst_17869__$1 = fluree.db.util.async.throw_err.call(null,inst_17868);
var state_17880__$1 = (function (){var statearr_17885 = state_17880;
(statearr_17885[(7)] = inst_17869__$1);

return statearr_17885;
})();
if(cljs.core.truth_(inst_17869__$1)){
var statearr_17886_17904 = state_17880__$1;
(statearr_17886_17904[(1)] = (7));

} else {
var statearr_17887_17905 = state_17880__$1;
(statearr_17887_17905[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17881 === (3))){
var inst_17878 = (state_17880[(2)]);
var state_17880__$1 = state_17880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17880__$1,inst_17878);
} else {
if((state_val_17881 === (2))){
var _ = (function (){var statearr_17889 = state_17880;
(statearr_17889[(4)] = cljs.core.cons.call(null,(5),(state_17880[(4)])));

return statearr_17889;
})();
var inst_17865 = fluree.db.storage.core.ledger_root_key.call(null,network,ledger_id,block);
var inst_17866 = fluree.db.storage.core.read.call(null,conn,inst_17865);
var state_17880__$1 = state_17880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17880__$1,(6),inst_17866);
} else {
if((state_val_17881 === (9))){
var inst_17875 = (state_17880[(2)]);
var _ = (function (){var statearr_17890 = state_17880;
(statearr_17890[(4)] = cljs.core.rest.call(null,(state_17880[(4)])));

return statearr_17890;
})();
var state_17880__$1 = state_17880;
var statearr_17891_17906 = state_17880__$1;
(statearr_17891_17906[(2)] = inst_17875);

(statearr_17891_17906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17881 === (5))){
var _ = (function (){var statearr_17892 = state_17880;
(statearr_17892[(4)] = cljs.core.rest.call(null,(state_17880[(4)])));

return statearr_17892;
})();
var state_17880__$1 = state_17880;
var ex17888 = (state_17880__$1[(2)]);
var statearr_17893_17907 = state_17880__$1;
(statearr_17893_17907[(5)] = ex17888);


if((ex17888 instanceof Error)){
var statearr_17894_17908 = state_17880__$1;
(statearr_17894_17908[(1)] = (4));

(statearr_17894_17908[(5)] = null);

} else {
throw ex17888;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17881 === (8))){
var state_17880__$1 = state_17880;
var statearr_17895_17909 = state_17880__$1;
(statearr_17895_17909[(2)] = null);

(statearr_17895_17909[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0 = (function (){
var statearr_17896 = [null,null,null,null,null,null,null,null];
(statearr_17896[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__);

(statearr_17896[(1)] = (1));

return statearr_17896;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1 = (function (state_17880){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17897){var ex__2749__auto__ = e17897;
var statearr_17898_17910 = state_17880;
(statearr_17898_17910[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17880[(4)]))){
var statearr_17899_17911 = state_17880;
(statearr_17899_17911[(1)] = cljs.core.first.call(null,(state_17880[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17912 = state_17880;
state_17880 = G__17912;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = function(state_17880){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1.call(this,state_17880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17900 = f__2769__auto__.call(null);
(statearr_17900[(6)] = c__2768__auto__);

return statearr_17900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17949){
var state_val_17950 = (state_17949[(1)]);
if((state_val_17950 === (7))){
var inst_17919 = (state_17949[(7)]);
var state_17949__$1 = state_17949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17949__$1,(9),inst_17919);
} else {
if((state_val_17950 === (1))){
var state_17949__$1 = state_17949;
var statearr_17951_17972 = state_17949__$1;
(statearr_17951_17972[(2)] = null);

(statearr_17951_17972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17950 === (4))){
var inst_17913 = (state_17949[(2)]);
var state_17949__$1 = state_17949;
var statearr_17952_17973 = state_17949__$1;
(statearr_17952_17973[(2)] = inst_17913);

(statearr_17952_17973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17950 === (6))){
var inst_17922 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17923 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17924 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17925 = cljs.core.PersistentHashMap.fromArrays(inst_17923,inst_17924);
var inst_17926 = cljs.core.ex_info.call(null,inst_17922,inst_17925);
var inst_17927 = (function(){throw inst_17926})();
var state_17949__$1 = state_17949;
var statearr_17953_17974 = state_17949__$1;
(statearr_17953_17974[(2)] = inst_17927);

(statearr_17953_17974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17950 === (3))){
var inst_17947 = (state_17949[(2)]);
var state_17949__$1 = state_17949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17949__$1,inst_17947);
} else {
if((state_val_17950 === (2))){
var inst_17919 = (state_17949[(7)]);
var _ = (function (){var statearr_17954 = state_17949;
(statearr_17954[(4)] = cljs.core.cons.call(null,(5),(state_17949[(4)])));

return statearr_17954;
})();
var inst_17919__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,ledger_id,index);
var inst_17920 = cljs.core.not.call(null,inst_17919__$1);
var state_17949__$1 = (function (){var statearr_17955 = state_17949;
(statearr_17955[(7)] = inst_17919__$1);

return statearr_17955;
})();
if(inst_17920){
var statearr_17956_17975 = state_17949__$1;
(statearr_17956_17975[(1)] = (6));

} else {
var statearr_17957_17976 = state_17949__$1;
(statearr_17957_17976[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17950 === (11))){
var inst_17937 = (state_17949[(8)]);
var inst_17940 = (state_17949[(2)]);
var inst_17941 = fluree.db.util.async.throw_err.call(null,inst_17940);
var inst_17942 = cljs.core.assoc.call(null,inst_17937,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17941);
var state_17949__$1 = state_17949;
var statearr_17959_17977 = state_17949__$1;
(statearr_17959_17977[(2)] = inst_17942);

(statearr_17959_17977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17950 === (9))){
var inst_17932 = (state_17949[(9)]);
var inst_17930 = (state_17949[(2)]);
var inst_17931 = fluree.db.util.async.throw_err.call(null,inst_17930);
var inst_17932__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_17931);
var inst_17933 = fluree.db.query.schema.schema_map.call(null,inst_17932__$1);
var state_17949__$1 = (function (){var statearr_17960 = state_17949;
(statearr_17960[(9)] = inst_17932__$1);

return statearr_17960;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17949__$1,(10),inst_17933);
} else {
if((state_val_17950 === (5))){
var _ = (function (){var statearr_17961 = state_17949;
(statearr_17961[(4)] = cljs.core.rest.call(null,(state_17949[(4)])));

return statearr_17961;
})();
var state_17949__$1 = state_17949;
var ex17958 = (state_17949__$1[(2)]);
var statearr_17962_17978 = state_17949__$1;
(statearr_17962_17978[(5)] = ex17958);


if((ex17958 instanceof Error)){
var statearr_17963_17979 = state_17949__$1;
(statearr_17963_17979[(1)] = (4));

(statearr_17963_17979[(5)] = null);

} else {
throw ex17958;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17950 === (10))){
var inst_17932 = (state_17949[(9)]);
var inst_17937 = (state_17949[(8)]);
var inst_17935 = (state_17949[(2)]);
var inst_17936 = fluree.db.util.async.throw_err.call(null,inst_17935);
var inst_17937__$1 = cljs.core.assoc.call(null,inst_17932,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17936);
var inst_17938 = fluree.db.query.schema.setting_map.call(null,inst_17937__$1);
var state_17949__$1 = (function (){var statearr_17964 = state_17949;
(statearr_17964[(8)] = inst_17937__$1);

return statearr_17964;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17949__$1,(11),inst_17938);
} else {
if((state_val_17950 === (8))){
var inst_17944 = (state_17949[(2)]);
var _ = (function (){var statearr_17965 = state_17949;
(statearr_17965[(4)] = cljs.core.rest.call(null,(state_17949[(4)])));

return statearr_17965;
})();
var state_17949__$1 = state_17949;
var statearr_17966_17980 = state_17949__$1;
(statearr_17966_17980[(2)] = inst_17944);

(statearr_17966_17980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0 = (function (){
var statearr_17967 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17967[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2746__auto__);

(statearr_17967[(1)] = (1));

return statearr_17967;
});
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1 = (function (state_17949){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17968){var ex__2749__auto__ = e17968;
var statearr_17969_17981 = state_17949;
(statearr_17969_17981[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17949[(4)]))){
var statearr_17970_17982 = state_17949;
(statearr_17970_17982[(1)] = cljs.core.first.call(null,(state_17949[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17983 = state_17949;
state_17949 = G__17983;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = function(state_17949){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1.call(this,state_17949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17971 = f__2769__auto__.call(null);
(statearr_17971[(6)] = c__2768__auto__);

return statearr_17971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__17984){
var map__17985 = p__17984;
var map__17985__$1 = cljs.core.__destructure_map.call(null,map__17985);
var branch = map__17985__$1;
var id = cljs.core.get.call(null,map__17985__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__17985__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.call(null,map__17985__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18022){
var state_val_18023 = (state_18022[(1)]);
if((state_val_18023 === (7))){
var inst_17995 = (state_18022[(7)]);
var inst_17998 = cljs.core.__destructure_map.call(null,inst_17995);
var inst_17999 = cljs.core.get.call(null,inst_17998,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18001 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_18002 = (new cljs.core.PersistentVector(null,7,(5),inst_18000,inst_18001,null));
var inst_18003 = cljs.core.select_keys.call(null,branch,inst_18002);
var inst_18004 = (function (){var temp__5802__auto__ = inst_17995;
var map__17997 = inst_17998;
var children = inst_17999;
var branch_metadata = inst_18003;
return (function (i,child){
return cljs.core.merge.call(null,cljs.core.assoc.call(null,branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (i === (0));
} else {
return and__5043__auto__;
}
})()),child);
});
})();
var inst_18005 = cljs.core.map_indexed.call(null,inst_18004,inst_17999);
var inst_18006 = cljs.core.juxt.call(null,new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_18007 = cljs.core.mapcat.call(null,inst_18006,inst_18005);
var inst_18008 = cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,comparator,inst_18007);
var state_18022__$1 = state_18022;
var statearr_18024_18043 = state_18022__$1;
(statearr_18024_18043[(2)] = inst_18008);

(statearr_18024_18043[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18023 === (1))){
var state_18022__$1 = state_18022;
var statearr_18025_18044 = state_18022__$1;
(statearr_18025_18044[(2)] = null);

(statearr_18025_18044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18023 === (4))){
var inst_17986 = (state_18022[(2)]);
var state_18022__$1 = state_18022;
var statearr_18026_18045 = state_18022__$1;
(statearr_18026_18045[(2)] = inst_17986);

(statearr_18026_18045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18023 === (6))){
var inst_17995 = (state_18022[(7)]);
var inst_17994 = (state_18022[(2)]);
var inst_17995__$1 = fluree.db.util.async.throw_err.call(null,inst_17994);
var state_18022__$1 = (function (){var statearr_18027 = state_18022;
(statearr_18027[(7)] = inst_17995__$1);

return statearr_18027;
})();
if(cljs.core.truth_(inst_17995__$1)){
var statearr_18028_18046 = state_18022__$1;
(statearr_18028_18046[(1)] = (7));

} else {
var statearr_18029_18047 = state_18022__$1;
(statearr_18029_18047[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18023 === (3))){
var inst_18020 = (state_18022[(2)]);
var state_18022__$1 = state_18022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18022__$1,inst_18020);
} else {
if((state_val_18023 === (2))){
var _ = (function (){var statearr_18031 = state_18022;
(statearr_18031[(4)] = cljs.core.cons.call(null,(5),(state_18022[(4)])));

return statearr_18031;
})();
var inst_17992 = fluree.db.storage.core.read_branch.call(null,conn,id);
var state_18022__$1 = state_18022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18022__$1,(6),inst_17992);
} else {
if((state_val_18023 === (9))){
var inst_18017 = (state_18022[(2)]);
var _ = (function (){var statearr_18032 = state_18022;
(statearr_18032[(4)] = cljs.core.rest.call(null,(state_18022[(4)])));

return statearr_18032;
})();
var state_18022__$1 = state_18022;
var statearr_18033_18048 = state_18022__$1;
(statearr_18033_18048[(2)] = inst_18017);

(statearr_18033_18048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18023 === (5))){
var _ = (function (){var statearr_18034 = state_18022;
(statearr_18034[(4)] = cljs.core.rest.call(null,(state_18022[(4)])));

return statearr_18034;
})();
var state_18022__$1 = state_18022;
var ex18030 = (state_18022__$1[(2)]);
var statearr_18035_18049 = state_18022__$1;
(statearr_18035_18049[(5)] = ex18030);


if((ex18030 instanceof Error)){
var statearr_18036_18050 = state_18022__$1;
(statearr_18036_18050[(1)] = (4));

(statearr_18036_18050[(5)] = null);

} else {
throw ex18030;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18023 === (8))){
var inst_18010 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_18011 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18012 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18013 = cljs.core.PersistentHashMap.fromArrays(inst_18011,inst_18012);
var inst_18014 = cljs.core.ex_info.call(null,inst_18010,inst_18013);
var inst_18015 = (function(){throw inst_18014})();
var state_18022__$1 = state_18022;
var statearr_18037_18051 = state_18022__$1;
(statearr_18037_18051[(2)] = inst_18015);

(statearr_18037_18051[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0 = (function (){
var statearr_18038 = [null,null,null,null,null,null,null,null];
(statearr_18038[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__);

(statearr_18038[(1)] = (1));

return statearr_18038;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1 = (function (state_18022){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18039){var ex__2749__auto__ = e18039;
var statearr_18040_18052 = state_18022;
(statearr_18040_18052[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18022[(4)]))){
var statearr_18041_18053 = state_18022;
(statearr_18041_18053[(1)] = cljs.core.first.call(null,(state_18022[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18054 = state_18022;
state_18022 = G__18054;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__ = function(state_18022){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1.call(this,state_18022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18042 = f__2769__auto__.call(null);
(statearr_18042[(6)] = c__2768__auto__);

return statearr_18042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__18055){
var map__18056 = p__18055;
var map__18056__$1 = cljs.core.__destructure_map.call(null,map__18056);
var id = cljs.core.get.call(null,map__18056__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__18056__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18085){
var state_val_18086 = (state_18085[(1)]);
if((state_val_18086 === (7))){
var inst_18066 = (state_18085[(7)]);
var inst_18069 = cljs.core.__destructure_map.call(null,inst_18066);
var inst_18070 = cljs.core.get.call(null,inst_18069,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18071 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,comparator,inst_18070);
var state_18085__$1 = state_18085;
var statearr_18087_18106 = state_18085__$1;
(statearr_18087_18106[(2)] = inst_18071);

(statearr_18087_18106[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (1))){
var state_18085__$1 = state_18085;
var statearr_18088_18107 = state_18085__$1;
(statearr_18088_18107[(2)] = null);

(statearr_18088_18107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (4))){
var inst_18057 = (state_18085[(2)]);
var state_18085__$1 = state_18085;
var statearr_18089_18108 = state_18085__$1;
(statearr_18089_18108[(2)] = inst_18057);

(statearr_18089_18108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (6))){
var inst_18066 = (state_18085[(7)]);
var inst_18065 = (state_18085[(2)]);
var inst_18066__$1 = fluree.db.util.async.throw_err.call(null,inst_18065);
var state_18085__$1 = (function (){var statearr_18090 = state_18085;
(statearr_18090[(7)] = inst_18066__$1);

return statearr_18090;
})();
if(cljs.core.truth_(inst_18066__$1)){
var statearr_18091_18109 = state_18085__$1;
(statearr_18091_18109[(1)] = (7));

} else {
var statearr_18092_18110 = state_18085__$1;
(statearr_18092_18110[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (3))){
var inst_18083 = (state_18085[(2)]);
var state_18085__$1 = state_18085;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18085__$1,inst_18083);
} else {
if((state_val_18086 === (2))){
var _ = (function (){var statearr_18094 = state_18085;
(statearr_18094[(4)] = cljs.core.cons.call(null,(5),(state_18085[(4)])));

return statearr_18094;
})();
var inst_18063 = fluree.db.storage.core.read_leaf.call(null,conn,id);
var state_18085__$1 = state_18085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18085__$1,(6),inst_18063);
} else {
if((state_val_18086 === (9))){
var inst_18080 = (state_18085[(2)]);
var _ = (function (){var statearr_18095 = state_18085;
(statearr_18095[(4)] = cljs.core.rest.call(null,(state_18085[(4)])));

return statearr_18095;
})();
var state_18085__$1 = state_18085;
var statearr_18096_18111 = state_18085__$1;
(statearr_18096_18111[(2)] = inst_18080);

(statearr_18096_18111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (5))){
var _ = (function (){var statearr_18097 = state_18085;
(statearr_18097[(4)] = cljs.core.rest.call(null,(state_18085[(4)])));

return statearr_18097;
})();
var state_18085__$1 = state_18085;
var ex18093 = (state_18085__$1[(2)]);
var statearr_18098_18112 = state_18085__$1;
(statearr_18098_18112[(5)] = ex18093);


if((ex18093 instanceof Error)){
var statearr_18099_18113 = state_18085__$1;
(statearr_18099_18113[(1)] = (4));

(statearr_18099_18113[(5)] = null);

} else {
throw ex18093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18086 === (8))){
var inst_18073 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_18074 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18075 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18076 = cljs.core.PersistentHashMap.fromArrays(inst_18074,inst_18075);
var inst_18077 = cljs.core.ex_info.call(null,inst_18073,inst_18076);
var inst_18078 = (function(){throw inst_18077})();
var state_18085__$1 = state_18085;
var statearr_18100_18114 = state_18085__$1;
(statearr_18100_18114[(2)] = inst_18078);

(statearr_18100_18114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_18101 = [null,null,null,null,null,null,null,null];
(statearr_18101[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__);

(statearr_18101[(1)] = (1));

return statearr_18101;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1 = (function (state_18085){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18102){var ex__2749__auto__ = e18102;
var statearr_18103_18115 = state_18085;
(statearr_18103_18115[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18085[(4)]))){
var statearr_18104_18116 = state_18085;
(statearr_18104_18116[(1)] = cljs.core.first.call(null,(state_18085[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18117 = state_18085;
state_18085 = G__18117;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__ = function(state_18085){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1.call(this,state_18085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18105 = f__2769__auto__.call(null);
(statearr_18105[(6)] = c__2768__auto__);

return statearr_18105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__18119 = arguments.length;
switch (G__18119) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.call(null,node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__18120,error_fn){
var map__18121 = p__18120;
var map__18121__$1 = cljs.core.__destructure_map.call(null,map__18121);
var node = map__18121__$1;
var comparator = cljs.core.get.call(null,map__18121__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.call(null,map__18121__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.call(null);
var c__2768__auto___18193 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18165){
var state_val_18166 = (state_18165[(1)]);
if((state_val_18166 === (7))){
var inst_18130 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
var statearr_18167_18194 = state_18165__$1;
(statearr_18167_18194[(2)] = inst_18130);

(statearr_18167_18194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (1))){
var state_18165__$1 = state_18165;
var statearr_18168_18195 = state_18165__$1;
(statearr_18168_18195[(2)] = null);

(statearr_18168_18195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (4))){
var inst_18122 = (state_18165[(7)]);
var inst_18122__$1 = (state_18165[(2)]);
var inst_18123 = fluree.db.util.log.error.call(null,inst_18122__$1,"Error resolving index node");
var state_18165__$1 = (function (){var statearr_18169 = state_18165;
(statearr_18169[(8)] = inst_18123);

(statearr_18169[(7)] = inst_18122__$1);

return statearr_18169;
})();
if(cljs.core.truth_(error_fn)){
var statearr_18170_18196 = state_18165__$1;
(statearr_18170_18196[(1)] = (5));

} else {
var statearr_18171_18197 = state_18165__$1;
(statearr_18171_18197[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (13))){
var inst_18148 = (state_18165[(9)]);
var inst_18151 = (state_18165[(2)]);
var inst_18152 = fluree.db.util.async.throw_err.call(null,inst_18151);
var inst_18153 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_18152];
var inst_18154 = (new cljs.core.PersistentVector(null,2,(5),inst_18148,inst_18153,null));
var state_18165__$1 = state_18165;
var statearr_18172_18198 = state_18165__$1;
(statearr_18172_18198[(2)] = inst_18154);

(statearr_18172_18198[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (6))){
var state_18165__$1 = state_18165;
var statearr_18173_18199 = state_18165__$1;
(statearr_18173_18199[(2)] = null);

(statearr_18173_18199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (3))){
var inst_18163 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18165__$1,inst_18163);
} else {
if((state_val_18166 === (12))){
var inst_18140 = (state_18165[(10)]);
var inst_18143 = (state_18165[(2)]);
var inst_18144 = fluree.db.util.async.throw_err.call(null,inst_18143);
var inst_18145 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18144];
var inst_18146 = (new cljs.core.PersistentVector(null,2,(5),inst_18140,inst_18145,null));
var state_18165__$1 = state_18165;
var statearr_18174_18200 = state_18165__$1;
(statearr_18174_18200[(2)] = inst_18146);

(statearr_18174_18200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (2))){
var _ = (function (){var statearr_18175 = state_18165;
(statearr_18175[(4)] = cljs.core.cons.call(null,(8),(state_18165[(4)])));

return statearr_18175;
})();
var state_18165__$1 = state_18165;
if(cljs.core.truth_(leaf)){
var statearr_18176_18201 = state_18165__$1;
(statearr_18176_18201[(1)] = (9));

} else {
var statearr_18177_18202 = state_18165__$1;
(statearr_18177_18202[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (11))){
var inst_18156 = (state_18165[(2)]);
var inst_18157 = cljs.core.nth.call(null,inst_18156,(0),null);
var inst_18158 = cljs.core.nth.call(null,inst_18156,(1),null);
var inst_18159 = cljs.core.assoc.call(null,node,inst_18157,inst_18158);
var inst_18160 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18159);
var _ = (function (){var statearr_18178 = state_18165;
(statearr_18178[(4)] = cljs.core.rest.call(null,(state_18165[(4)])));

return statearr_18178;
})();
var state_18165__$1 = state_18165;
var statearr_18179_18203 = state_18165__$1;
(statearr_18179_18203[(2)] = inst_18160);

(statearr_18179_18203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (9))){
var inst_18140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18141 = fluree.db.storage.core.fetch_leaf_flakes.call(null,conn,node);
var state_18165__$1 = (function (){var statearr_18180 = state_18165;
(statearr_18180[(10)] = inst_18140);

return statearr_18180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18165__$1,(12),inst_18141);
} else {
if((state_val_18166 === (5))){
var inst_18122 = (state_18165[(7)]);
var inst_18125 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18122);
var inst_18126 = cljs.core.async.close_BANG_.call(null,return_ch);
var inst_18127 = error_fn.call(null,inst_18125,inst_18126);
var state_18165__$1 = state_18165;
var statearr_18182_18204 = state_18165__$1;
(statearr_18182_18204[(2)] = inst_18127);

(statearr_18182_18204[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (10))){
var inst_18148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18149 = fluree.db.storage.core.fetch_child_attributes.call(null,conn,node);
var state_18165__$1 = (function (){var statearr_18183 = state_18165;
(statearr_18183[(9)] = inst_18148);

return statearr_18183;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18165__$1,(13),inst_18149);
} else {
if((state_val_18166 === (8))){
var _ = (function (){var statearr_18184 = state_18165;
(statearr_18184[(4)] = cljs.core.rest.call(null,(state_18165[(4)])));

return statearr_18184;
})();
var state_18165__$1 = state_18165;
var ex18181 = (state_18165__$1[(2)]);
var statearr_18185_18205 = state_18165__$1;
(statearr_18185_18205[(5)] = ex18181);


var statearr_18186_18206 = state_18165__$1;
(statearr_18186_18206[(1)] = (4));

(statearr_18186_18206[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_18187 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18187[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_18187[(1)] = (1));

return statearr_18187;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_18165){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18188){var ex__2749__auto__ = e18188;
var statearr_18189_18207 = state_18165;
(statearr_18189_18207[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18165[(4)]))){
var statearr_18190_18208 = state_18165;
(statearr_18190_18208[(1)] = cljs.core.first.call(null,(state_18165[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18209 = state_18165;
state_18165 = G__18209;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_18165){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_18165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18191 = f__2769__auto__.call(null);
(statearr_18191[(6)] = c__2768__auto___18193);

return statearr_18191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__18210){
var map__18211 = p__18210;
var map__18211__$1 = cljs.core.__destructure_map.call(null,map__18211);
var node = map__18211__$1;
var comparator = cljs.core.get.call(null,map__18211__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.call(null);
var empty_set = fluree.db.flake.sorted_set_by.call(null,comparator);
var empty_node = cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.call(null,ch,empty_node);

return ch;
});
