// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_12315){
var state_val_12316 = (state_12315[(1)]);
if((state_val_12316 === (7))){
var inst_12310 = (state_12315[(2)]);
var _ = (function (){var statearr_12317 = state_12315;
(statearr_12317[(4)] = cljs.core.rest.call(null,(state_12315[(4)])));

return statearr_12317;
})();
var state_12315__$1 = state_12315;
var statearr_12318_12340 = state_12315__$1;
(statearr_12318_12340[(2)] = inst_12310);

(statearr_12318_12340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (1))){
var state_12315__$1 = state_12315;
var statearr_12319_12341 = state_12315__$1;
(statearr_12319_12341[(2)] = null);

(statearr_12319_12341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (4))){
var inst_12272 = (state_12315[(2)]);
var state_12315__$1 = state_12315;
var statearr_12320_12342 = state_12315__$1;
(statearr_12320_12342[(2)] = inst_12272);

(statearr_12320_12342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (6))){
var inst_12290 = (state_12315[(7)]);
var inst_12297 = (state_12315[(8)]);
var inst_12296 = cljs.core.seq.call(null,inst_12290);
var inst_12297__$1 = cljs.core.first.call(null,inst_12296);
var inst_12298 = cljs.core.next.call(null,inst_12296);
var inst_12299 = cljs.core.not.call(null,inst_12297__$1);
var state_12315__$1 = (function (){var statearr_12321 = state_12315;
(statearr_12321[(9)] = inst_12298);

(statearr_12321[(8)] = inst_12297__$1);

return statearr_12321;
})();
if(inst_12299){
var statearr_12322_12343 = state_12315__$1;
(statearr_12322_12343[(1)] = (8));

} else {
var statearr_12323_12344 = state_12315__$1;
(statearr_12323_12344[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (3))){
var inst_12313 = (state_12315[(2)]);
var state_12315__$1 = state_12315;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12315__$1,inst_12313);
} else {
if((state_val_12316 === (2))){
var _ = (function (){var statearr_12324 = state_12315;
(statearr_12324[(4)] = cljs.core.cons.call(null,(5),(state_12315[(4)])));

return statearr_12324;
})();
var inst_12285 = chs;
var inst_12286 = cljs.core.seq.call(null,inst_12285);
var inst_12287 = cljs.core.first.call(null,inst_12286);
var inst_12288 = cljs.core.next.call(null,inst_12286);
var inst_12289 = coll;
var inst_12290 = inst_12285;
var inst_12291 = inst_12289;
var state_12315__$1 = (function (){var statearr_12325 = state_12315;
(statearr_12325[(10)] = inst_12288);

(statearr_12325[(7)] = inst_12290);

(statearr_12325[(11)] = inst_12287);

(statearr_12325[(12)] = inst_12291);

return statearr_12325;
})();
var statearr_12326_12345 = state_12315__$1;
(statearr_12326_12345[(2)] = null);

(statearr_12326_12345[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (11))){
var inst_12298 = (state_12315[(9)]);
var inst_12291 = (state_12315[(12)]);
var inst_12303 = (state_12315[(2)]);
var inst_12304 = fluree.db.util.async.throw_err.call(null,inst_12303);
var inst_12305 = cljs.core.conj.call(null,inst_12291,inst_12304);
var inst_12290 = inst_12298;
var inst_12291__$1 = inst_12305;
var state_12315__$1 = (function (){var statearr_12328 = state_12315;
(statearr_12328[(7)] = inst_12290);

(statearr_12328[(12)] = inst_12291__$1);

return statearr_12328;
})();
var statearr_12329_12346 = state_12315__$1;
(statearr_12329_12346[(2)] = null);

(statearr_12329_12346[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (9))){
var inst_12297 = (state_12315[(8)]);
var state_12315__$1 = state_12315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12315__$1,(11),inst_12297);
} else {
if((state_val_12316 === (5))){
var _ = (function (){var statearr_12330 = state_12315;
(statearr_12330[(4)] = cljs.core.rest.call(null,(state_12315[(4)])));

return statearr_12330;
})();
var state_12315__$1 = state_12315;
var ex12327 = (state_12315__$1[(2)]);
var statearr_12331_12347 = state_12315__$1;
(statearr_12331_12347[(5)] = ex12327);


var statearr_12332_12348 = state_12315__$1;
(statearr_12332_12348[(1)] = (4));

(statearr_12332_12348[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (10))){
var inst_12308 = (state_12315[(2)]);
var state_12315__$1 = state_12315;
var statearr_12333_12349 = state_12315__$1;
(statearr_12333_12349[(2)] = inst_12308);

(statearr_12333_12349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12316 === (8))){
var inst_12291 = (state_12315[(12)]);
var state_12315__$1 = state_12315;
var statearr_12334_12350 = state_12315__$1;
(statearr_12334_12350[(2)] = inst_12291);

(statearr_12334_12350[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_12335 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12335[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__);

(statearr_12335[(1)] = (1));

return statearr_12335;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1 = (function (state_12315){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_12315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e12336){var ex__2749__auto__ = e12336;
var statearr_12337_12351 = state_12315;
(statearr_12337_12351[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_12315[(4)]))){
var statearr_12338_12352 = state_12315;
(statearr_12338_12352[(1)] = cljs.core.first.call(null,(state_12315[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12353 = state_12315;
state_12315 = G__12353;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = function(state_12315){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1.call(this,state_12315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_12339 = f__2769__auto__.call(null);
(statearr_12339[(6)] = c__2768__auto__);

return statearr_12339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_12379){
var state_val_12380 = (state_12379[(1)]);
if((state_val_12380 === (7))){
var inst_12374 = (state_12379[(2)]);
var _ = (function (){var statearr_12381 = state_12379;
(statearr_12381[(4)] = cljs.core.rest.call(null,(state_12379[(4)])));

return statearr_12381;
})();
var state_12379__$1 = state_12379;
var statearr_12382_12404 = state_12379__$1;
(statearr_12382_12404[(2)] = inst_12374);

(statearr_12382_12404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (1))){
var state_12379__$1 = state_12379;
var statearr_12383_12405 = state_12379__$1;
(statearr_12383_12405[(2)] = null);

(statearr_12383_12405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (4))){
var inst_12354 = (state_12379[(2)]);
var state_12379__$1 = state_12379;
var statearr_12384_12406 = state_12379__$1;
(statearr_12384_12406[(2)] = inst_12354);

(statearr_12384_12406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (6))){
var state_12379__$1 = state_12379;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12379__$1,(8),chan);
} else {
if((state_val_12380 === (3))){
var inst_12377 = (state_12379[(2)]);
var state_12379__$1 = state_12379;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12379__$1,inst_12377);
} else {
if((state_val_12380 === (2))){
var _ = (function (){var statearr_12385 = state_12379;
(statearr_12385[(4)] = cljs.core.cons.call(null,(5),(state_12379[(4)])));

return statearr_12385;
})();
var inst_12360 = coll;
var inst_12361 = inst_12360;
var state_12379__$1 = (function (){var statearr_12386 = state_12379;
(statearr_12386[(7)] = inst_12361);

return statearr_12386;
})();
var statearr_12387_12407 = state_12379__$1;
(statearr_12387_12407[(2)] = null);

(statearr_12387_12407[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (11))){
var inst_12372 = (state_12379[(2)]);
var state_12379__$1 = state_12379;
var statearr_12389_12408 = state_12379__$1;
(statearr_12389_12408[(2)] = inst_12372);

(statearr_12389_12408[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (9))){
var inst_12361 = (state_12379[(7)]);
var state_12379__$1 = state_12379;
var statearr_12390_12409 = state_12379__$1;
(statearr_12390_12409[(2)] = inst_12361);

(statearr_12390_12409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (5))){
var _ = (function (){var statearr_12391 = state_12379;
(statearr_12391[(4)] = cljs.core.rest.call(null,(state_12379[(4)])));

return statearr_12391;
})();
var state_12379__$1 = state_12379;
var ex12388 = (state_12379__$1[(2)]);
var statearr_12392_12410 = state_12379__$1;
(statearr_12392_12410[(5)] = ex12388);


var statearr_12393_12411 = state_12379__$1;
(statearr_12393_12411[(1)] = (4));

(statearr_12393_12411[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (10))){
var inst_12361 = (state_12379[(7)]);
var inst_12365 = (state_12379[(8)]);
var inst_12369 = cljs.core.conj.call(null,inst_12361,inst_12365);
var inst_12361__$1 = inst_12369;
var state_12379__$1 = (function (){var statearr_12394 = state_12379;
(statearr_12394[(7)] = inst_12361__$1);

return statearr_12394;
})();
var statearr_12395_12412 = state_12379__$1;
(statearr_12395_12412[(2)] = null);

(statearr_12395_12412[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12380 === (8))){
var inst_12365 = (state_12379[(8)]);
var inst_12364 = (state_12379[(2)]);
var inst_12365__$1 = fluree.db.util.async.throw_err.call(null,inst_12364);
var inst_12366 = (inst_12365__$1 == null);
var state_12379__$1 = (function (){var statearr_12396 = state_12379;
(statearr_12396[(8)] = inst_12365__$1);

return statearr_12396;
})();
if(cljs.core.truth_(inst_12366)){
var statearr_12397_12413 = state_12379__$1;
(statearr_12397_12413[(1)] = (9));

} else {
var statearr_12398_12414 = state_12379__$1;
(statearr_12398_12414[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_12399 = [null,null,null,null,null,null,null,null,null];
(statearr_12399[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__);

(statearr_12399[(1)] = (1));

return statearr_12399;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1 = (function (state_12379){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_12379);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e12400){var ex__2749__auto__ = e12400;
var statearr_12401_12415 = state_12379;
(statearr_12401_12415[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_12379[(4)]))){
var statearr_12402_12416 = state_12379;
(statearr_12402_12416[(1)] = cljs.core.first.call(null,(state_12379[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12417 = state_12379;
state_12379 = G__12417;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = function(state_12379){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1.call(this,state_12379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_12403 = f__2769__auto__.call(null);
(statearr_12403[(6)] = c__2768__auto__);

return statearr_12403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
