// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs._init_state = (function flureenjs$_init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a value from the user's context if set. Provide the key or key sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path + query costs"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,803,null,803,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,803,null,new cljs.core.Symbol(null,"any","any",-948528346,null),803,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,7,546,null,546,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,546,null,new cljs.core.Symbol(null,"any","any",-948528346,null),546,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,7,372,null,372,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,372,null,new cljs.core.Symbol(null,"any","any",-948528346,null),372,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,135,null,135,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,135,null,new cljs.core.Symbol(null,"any","any",-948528346,null),135,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,363,null,363,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null))),"Returns a value from the user's context if set. Provide the key or key sequence.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ctx","fluree.db.dbfunctions.fns/ctx",570947084,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__68364","p__68364",1795272748,null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null)),null,cljs.core.list(null,null),1,false,363,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null),363,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null))),"Returns a value from the user's context if set. Provide the key or key sequence.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,504,null,504,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),504,null,504,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,7,775,null,775,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,775,null,new cljs.core.Symbol(null,"any","any",-948528346,null),775,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,684,null,684,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,684,null,new cljs.core.Symbol(null,"any","any",-948528346,null),684,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,570,null,570,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,570,null,new cljs.core.Symbol(null,"any","any",-948528346,null),570,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,426,null,426,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),426,null,new cljs.core.Symbol(null,"any","any",-948528346,null),426,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,7,825,null,825,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,825,null,new cljs.core.Symbol(null,"any","any",-948528346,null),825,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,7,303,null,303,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,303,null,new cljs.core.Symbol(null,"any","any",-948528346,null),303,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,171,null,171,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,171,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),171,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,763,null,763,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,763,null,new cljs.core.Symbol(null,"any","any",-948528346,null),763,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,813,null,813,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,813,null,new cljs.core.Symbol(null,"any","any",-948528346,null),813,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),41,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),41,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,41,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),41,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,439,null,439,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),439,null,new cljs.core.Symbol(null,"any","any",-948528346,null),439,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,619,null,619,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),619,null,new cljs.core.Symbol(null,"any","any",-948528346,null),619,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,491,null,491,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),491,null,new cljs.core.Symbol(null,"any","any",-948528346,null),491,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,272,null,272,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__67875","p__67875",338246139,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,272,null,new cljs.core.Symbol(null,"any","any",-948528346,null),272,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,315,null,315,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,315,null,new cljs.core.Symbol(null,"any","any",-948528346,null),315,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,7,111,null,111,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,111,null,new cljs.core.Symbol(null,"any","any",-948528346,null),111,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,645,null,645,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,645,null,new cljs.core.Symbol(null,"any","any",-948528346,null),645,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,583,null,583,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,583,null,new cljs.core.Symbol(null,"any","any",-948528346,null),583,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,465,null,465,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),465,null,new cljs.core.Symbol(null,"any","any",-948528346,null),465,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),52,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),52,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,52,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),52,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,75,null,75,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,75,null,new cljs.core.Symbol(null,"any","any",-948528346,null),75,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,787,null,787,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),787,null,787,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,413,null,413,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),413,null,new cljs.core.Symbol(null,"any","any",-948528346,null),413,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,658,null,658,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,658,null,new cljs.core.Symbol(null,"any","any",-948528346,null),658,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,7,147,null,147,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,147,null,new cljs.core.Symbol(null,"any","any",-948528346,null),147,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,606,null,606,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),606,null,new cljs.core.Symbol(null,"any","any",-948528346,null),606,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,386,null,386,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns a hash-set of values","9 + count of items in hash-set"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),386,null,new cljs.core.Symbol(null,"any","any",-948528346,null),386,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values","9 + count of items in hash-set"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,245,null,245,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),245,null,new cljs.core.Symbol(null,"any","any",-948528346,null),245,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,7,709,null,709,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,709,null,new cljs.core.Symbol(null,"any","any",-948528346,null),709,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),22,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),22,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,22,new cljs.core.Symbol(null,"any","any",-948528346,null),22,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,203,null,203,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),203,null,203,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,671,null,671,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,671,null,new cljs.core.Symbol(null,"any","any",-948528346,null),671,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,60,null,60,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,60,null,new cljs.core.Symbol(null,"any","any",-948528346,null),60,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,88,null,88,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,88,null,new cljs.core.Symbol(null,"any","any",-948528346,null),88,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,837,null,837,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,837,null,new cljs.core.Symbol(null,"any","any",-948528346,null),837,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,696,null,696,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,696,null,new cljs.core.Symbol(null,"any","any",-948528346,null),696,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,100,null,100,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,100,null,new cljs.core.Symbol(null,"any","any",-948528346,null),100,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),632,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,452,null,452,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),452,null,new cljs.core.Symbol(null,"any","any",-948528346,null),452,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,7,159,null,159,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,159,null,new cljs.core.Symbol(null,"any","any",-948528346,null),159,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,558,null,558,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,558,null,new cljs.core.Symbol(null,"any","any",-948528346,null),558,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,593,null,593,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),593,null,new cljs.core.Symbol(null,"any","any",-948528346,null),593,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,123,null,123,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),123,null,new cljs.core.Symbol(null,"any","any",-948528346,null),123,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,751,null,751,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,751,null,new cljs.core.Symbol(null,"any","any",-948528346,null),751,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,478,null,478,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),478,null,new cljs.core.Symbol(null,"any","any",-948528346,null),478,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,400,null,400,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),400,null,new cljs.core.Symbol(null,"any","any",-948528346,null),400,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,7,258,null,258,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,258,null,new cljs.core.Symbol(null,"any","any",-948528346,null),258,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,328,null,328,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.","9 + length of path + query costs"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,328,null,new cljs.core.Symbol(null,"any","any",-948528346,null),328,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.","9 + length of path + query costs"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,216,null,216,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),216,null,216,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),35,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),35,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,35,new cljs.core.Symbol(null,"any","any",-948528346,null),35,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,7,739,null,739,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,739,null,new cljs.core.Symbol(null,"any","any",-948528346,null),739,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),14,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,14,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),14,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,7,721,null,721,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,721,null,new cljs.core.Symbol(null,"any","any",-948528346,null),721,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,7,531,null,531,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,531,null,new cljs.core.Symbol(null,"any","any",-948528346,null),531,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,232,null,232,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),232,null,new cljs.core.Symbol(null,"any","any",-948528346,null),232,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,190,null,190,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,190,null,new cljs.core.Symbol(null,"any","any",-948528346,null),190,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,7,349,null,349,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,349,null,new cljs.core.Symbol(null,"any","any",-948528346,null),349,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 29, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"get","get",1683182755),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"cache","cache",-1237023054),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"fine","fine",-873037193),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"ctx","ctx",-493610118),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 29, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"ctx","ctx",-493610118),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null,cljs.core.PersistentArrayMap.EMPTY]));
});
flureenjs._ns_state = cljs.js.empty_state.call(null,flureenjs._init_state);
var st_81885 = flureenjs._ns_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_81885,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs._app_state !== 'undefined')){
} else {
flureenjs._app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v1.0.0-rc21"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)));
flureenjs._njs_crypto = (function (){try{return require("crypto");
}catch (e81886){var ex = e81886;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Error: Unable to access Node.js crypto module:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join('')], null));

fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Private key generation is not available."], null));

return null;
}})();
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureenjs.setLogging = (function flureenjs$setLogging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__81888 = opts_SINGLEQUOTE_;
var map__81888__$1 = cljs.core.__destructure_map.call(null,map__81888);
var level = cljs.core.get.call(null,map__81888__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.setLogging', flureenjs.setLogging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.accountId = (function flureenjs$accountId(var_args){
var G__81890 = arguments.length;
switch (G__81890) {
case 1:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.accountId', flureenjs.accountId);

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.accountId.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.httpSignature = (function flureenjs$httpSignature(var_args){
var G__81893 = arguments.length;
switch (G__81893) {
case 4:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.httpSignature', flureenjs.httpSignature);

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.httpSignature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.httpSignature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.publicKeyFromPrivate = (function flureenjs$publicKeyFromPrivate(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.publicKeyFromPrivate', flureenjs.publicKeyFromPrivate);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.publicKey = (function flureenjs$publicKey(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.publicKey', flureenjs.publicKey);
/**
 * Generates a private-public key pair using the Node.js
 *     crypto module. The JavaScript code looks like:
 * 
 *        const ecdh = crypto.createECDH('secp256k1');
 *        ecdh.generateKeys()
 *        return { private: ecdh.getPrivateKey('hex'),
 *                 public:  ecdh.getPublicKey('hex','compressed')};
 *     
 */
flureenjs._generate_key_pair = (function flureenjs$_generate_key_pair(){
if(cljs.core.truth_(flureenjs._njs_crypto)){
var ecdh = cljs.core.js_invoke.call(null,flureenjs._njs_crypto,"createECDH","secp256k1");
var _ = cljs.core.js_invoke.call(null,ecdh,"generateKeys");
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),cljs.core.js_invoke.call(null,ecdh,"getPrivateKey","hex"),new cljs.core.Keyword(null,"public","public",1566243851),cljs.core.js_invoke.call(null,ecdh,"getPublicKey","hex","compressed")], null);
} else {
throw "Node.js crypto module not accessible";
}
});
/**
 * Generates a new private key, returned in a map along with
 *    the public key and account id. Return keys are :public,
 *    :private, and :id.
 *    
 */
flureenjs.newPrivateKey = (function flureenjs$newPrivateKey(){
try{var kp = flureenjs._generate_key_pair.call(null);
var account = fluree.crypto.account_id_from_private.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(kp));
return cljs.core.assoc.call(null,kp,new cljs.core.Keyword(null,"id","id",-1388402092),account);
}catch (e81895){var e = e81895;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Unable to generate private key. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e)].join('')], null));

throw e;
}});
goog.exportSymbol('flureenjs.newPrivateKey', flureenjs.newPrivateKey);
/**
 * Returns a signature for a message given a private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or db level.
 *    This will only succeed if signed by the default private key for the tx-group,
 *    or if setting for a ledger-id, either the tx-group or network.
 * 
 *    It will overwrite any existing default private key.
 * 
 *    It will respond with true or false.
 * 
 *    Returns promise that eventually contains the results. 
 */
flureenjs.setDefaultKey = (function flureenjs$setDefaultKey(var_args){
var G__81897 = arguments.length;
switch (G__81897) {
case 2:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.setDefaultKey', flureenjs.setDefaultKey);

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.setDefaultKey.call(null,conn,null,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,ledger_id,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,ledger_id,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,private_key,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_81956){
var state_val_81957 = (state_81956[(1)]);
if((state_val_81957 === (7))){
var inst_81915 = (state_81956[(7)]);
var state_81956__$1 = state_81956;
var statearr_81958_81999 = state_81956__$1;
(statearr_81958_81999[(2)] = inst_81915);

(statearr_81958_81999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (20))){
var inst_81927 = (state_81956[(8)]);
var inst_81945 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_81927);
var state_81956__$1 = state_81956;
var statearr_81959_82000 = state_81956__$1;
(statearr_81959_82000[(2)] = inst_81945);

(statearr_81959_82000[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (1))){
var state_81956__$1 = state_81956;
var statearr_81960_82001 = state_81956__$1;
(statearr_81960_82001[(2)] = null);

(statearr_81960_82001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (4))){
var inst_81898 = (state_81956[(2)]);
var inst_81899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81900 = [inst_81898];
var inst_81901 = (new cljs.core.PersistentVector(null,1,(5),inst_81899,inst_81900,null));
var inst_81902 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_81901);
var inst_81903 = reject.call(null,inst_81898);
var state_81956__$1 = (function (){var statearr_81961 = state_81956;
(statearr_81961[(9)] = inst_81902);

return statearr_81961;
})();
var statearr_81962_82002 = state_81956__$1;
(statearr_81962_82002[(2)] = inst_81903);

(statearr_81962_82002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (15))){
var inst_81914 = (state_81956[(10)]);
var inst_81933 = (state_81956[(11)]);
var inst_81935 = fluree.crypto.sign_message.call(null,inst_81933,inst_81914);
var state_81956__$1 = state_81956;
var statearr_81963_82003 = state_81956__$1;
(statearr_81963_82003[(2)] = inst_81935);

(statearr_81963_82003[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (21))){
var inst_81947 = (state_81956[(2)]);
var state_81956__$1 = state_81956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81956__$1,(18),inst_81947);
} else {
if((state_val_81957 === (13))){
var state_81956__$1 = state_81956;
var statearr_81964_82004 = state_81956__$1;
(statearr_81964_82004[(2)] = null);

(statearr_81964_82004[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (6))){
var inst_81912 = (state_81956[(12)]);
var state_81956__$1 = state_81956;
var statearr_81965_82005 = state_81956__$1;
(statearr_81965_82005[(2)] = inst_81912);

(statearr_81965_82005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (17))){
var inst_81914 = (state_81956[(10)]);
var inst_81938 = (state_81956[(2)]);
var state_81956__$1 = (function (){var statearr_81966 = state_81956;
(statearr_81966[(13)] = inst_81938);

return statearr_81966;
})();
if(cljs.core.truth_(inst_81914)){
var statearr_81967_82006 = state_81956__$1;
(statearr_81967_82006[(1)] = (19));

} else {
var statearr_81968_82007 = state_81956__$1;
(statearr_81968_82007[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (3))){
var inst_81954 = (state_81956[(2)]);
var state_81956__$1 = state_81956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81956__$1,inst_81954);
} else {
if((state_val_81957 === (12))){
var inst_81927 = (state_81956[(8)]);
var inst_81929 = fluree.db.util.core.without_nils.call(null,inst_81927);
var inst_81930 = fluree.db.util.json.stringify.call(null,inst_81929);
var state_81956__$1 = state_81956;
var statearr_81969_82008 = state_81956__$1;
(statearr_81969_82008[(2)] = inst_81930);

(statearr_81969_82008[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (2))){
var inst_81912 = (state_81956[(12)]);
var _ = (function (){var statearr_81970 = state_81956;
(statearr_81970[(4)] = cljs.core.cons.call(null,(5),(state_81956[(4)])));

return statearr_81970;
})();
var inst_81910 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_81911 = cljs.core.__destructure_map.call(null,inst_81910);
var inst_81912__$1 = cljs.core.get.call(null,inst_81911,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_81913 = cljs.core.get.call(null,inst_81911,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_81914 = cljs.core.get.call(null,inst_81911,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_81915 = fluree.db.util.core.current_time_millis.call(null);
var state_81956__$1 = (function (){var statearr_81971 = state_81956;
(statearr_81971[(14)] = inst_81913);

(statearr_81971[(7)] = inst_81915);

(statearr_81971[(12)] = inst_81912__$1);

(statearr_81971[(10)] = inst_81914);

return statearr_81971;
})();
if(cljs.core.truth_(inst_81912__$1)){
var statearr_81972_82009 = state_81956__$1;
(statearr_81972_82009[(1)] = (6));

} else {
var statearr_81973_82010 = state_81956__$1;
(statearr_81973_82010[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (19))){
var inst_81938 = (state_81956[(13)]);
var inst_81933 = (state_81956[(11)]);
var inst_81940 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_81941 = [inst_81933,inst_81938];
var inst_81942 = cljs.core.PersistentHashMap.fromArrays(inst_81940,inst_81941);
var inst_81943 = fluree.db.operations.command_async.call(null,conn,inst_81942);
var state_81956__$1 = state_81956;
var statearr_81974_82011 = state_81956__$1;
(statearr_81974_82011[(2)] = inst_81943);

(statearr_81974_82011[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (11))){
var inst_81919 = (state_81956[(15)]);
var inst_81914 = (state_81956[(10)]);
var inst_81924 = (state_81956[(2)]);
var inst_81925 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_81926 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,ledger_id,private_key,inst_81919,inst_81924];
var inst_81927 = cljs.core.PersistentHashMap.fromArrays(inst_81925,inst_81926);
var state_81956__$1 = (function (){var statearr_81976 = state_81956;
(statearr_81976[(8)] = inst_81927);

return statearr_81976;
})();
if(cljs.core.truth_(inst_81914)){
var statearr_81977_82012 = state_81956__$1;
(statearr_81977_82012[(1)] = (12));

} else {
var statearr_81978_82013 = state_81956__$1;
(statearr_81978_82013[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (9))){
var inst_81913 = (state_81956[(14)]);
var state_81956__$1 = state_81956;
var statearr_81979_82014 = state_81956__$1;
(statearr_81979_82014[(2)] = inst_81913);

(statearr_81979_82014[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (5))){
var _ = (function (){var statearr_81980 = state_81956;
(statearr_81980[(4)] = cljs.core.rest.call(null,(state_81956[(4)])));

return statearr_81980;
})();
var state_81956__$1 = state_81956;
var ex81975 = (state_81956__$1[(2)]);
var statearr_81981_82015 = state_81956__$1;
(statearr_81981_82015[(5)] = ex81975);


var statearr_81982_82016 = state_81956__$1;
(statearr_81982_82016[(1)] = (4));

(statearr_81982_82016[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (14))){
var inst_81914 = (state_81956[(10)]);
var inst_81933 = (state_81956[(2)]);
var state_81956__$1 = (function (){var statearr_81983 = state_81956;
(statearr_81983[(11)] = inst_81933);

return statearr_81983;
})();
if(cljs.core.truth_(inst_81914)){
var statearr_81984_82017 = state_81956__$1;
(statearr_81984_82017[(1)] = (15));

} else {
var statearr_81985_82018 = state_81956__$1;
(statearr_81985_82018[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (16))){
var state_81956__$1 = state_81956;
var statearr_81986_82019 = state_81956__$1;
(statearr_81986_82019[(2)] = null);

(statearr_81986_82019[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (10))){
var inst_81915 = (state_81956[(7)]);
var inst_81922 = (inst_81915 + (30000));
var state_81956__$1 = state_81956;
var statearr_81987_82020 = state_81956__$1;
(statearr_81987_82020[(2)] = inst_81922);

(statearr_81987_82020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (18))){
var inst_81949 = (state_81956[(2)]);
var inst_81950 = cljs.core.clj__GT_js.call(null,inst_81949);
var inst_81951 = resolve.call(null,inst_81950);
var _ = (function (){var statearr_81988 = state_81956;
(statearr_81988[(4)] = cljs.core.rest.call(null,(state_81956[(4)])));

return statearr_81988;
})();
var state_81956__$1 = state_81956;
var statearr_81989_82021 = state_81956__$1;
(statearr_81989_82021[(2)] = inst_81951);

(statearr_81989_82021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81957 === (8))){
var inst_81913 = (state_81956[(14)]);
var inst_81919 = (state_81956[(2)]);
var state_81956__$1 = (function (){var statearr_81990 = state_81956;
(statearr_81990[(15)] = inst_81919);

return statearr_81990;
})();
if(cljs.core.truth_(inst_81913)){
var statearr_81991_82022 = state_81956__$1;
(statearr_81991_82022[(1)] = (9));

} else {
var statearr_81992_82023 = state_81956__$1;
(statearr_81992_82023[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_81993 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81993[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_81993[(1)] = (1));

return statearr_81993;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_81956){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_81956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e81994){var ex__2749__auto__ = e81994;
var statearr_81995_82024 = state_81956;
(statearr_81995_82024[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_81956[(4)]))){
var statearr_81996_82025 = state_81956;
(statearr_81996_82025[(1)] = cljs.core.first.call(null,(state_81956[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82026 = state_81956;
state_81956 = G__82026;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_81956){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_81956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_81997 = f__2769__auto__.call(null);
(statearr_81997[(6)] = c__2768__auto__);

return statearr_81997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.setDefaultKey.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 *     Returns a promise that eventually contains the connection object.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___82033 = arguments.length;
var i__5770__auto___82034 = (0);
while(true){
if((i__5770__auto___82034 < len__5769__auto___82033)){
args__5775__auto__.push((arguments[i__5770__auto___82034]));

var G__82035 = (i__5770__auto___82034 + (1));
i__5770__auto___82034 = G__82035;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__82029){
var vec__82030 = p__82029;
var opts = cljs.core.nth.call(null,vec__82030,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq82027){
var G__82028 = cljs.core.first.call(null,seq82027);
var seq82027__$1 = cljs.core.next.call(null,seq82027);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82028,seq82027__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *    Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordGenerate = (function flureenjs$passwordGenerate(var_args){
var G__82037 = arguments.length;
switch (G__82037) {
case 4:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordGenerate', flureenjs.passwordGenerate);

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.passwordGenerate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.passwordGenerate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 * 
 *    Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordLogin = (function flureenjs$passwordLogin(var_args){
var G__82040 = arguments.length;
switch (G__82040) {
case 4:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordLogin', flureenjs.passwordLogin);

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.passwordLogin.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureenjs.renewToken = (function flureenjs$renewToken(var_args){
var G__82043 = arguments.length;
switch (G__82043) {
case 2:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renewToken', flureenjs.renewToken);

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renewToken.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *    :retracted key containing maps of data organized by subject
 *    and containing full predicate names.
 */
flureenjs.blockEventToMap = (function flureenjs$blockEventToMap(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82077){
var state_val_82078 = (state_82077[(1)]);
if((state_val_82078 === (1))){
var state_82077__$1 = state_82077;
var statearr_82079_82094 = state_82077__$1;
(statearr_82079_82094[(2)] = null);

(statearr_82079_82094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82078 === (2))){
var _ = (function (){var statearr_82080 = state_82077;
(statearr_82080[(4)] = cljs.core.cons.call(null,(5),(state_82077[(4)])));

return statearr_82080;
})();
var inst_82058 = flureenjs._db_instance.call(null,conn,ledger);
var state_82077__$1 = state_82077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82077__$1,(6),inst_82058);
} else {
if((state_val_82078 === (3))){
var inst_82075 = (state_82077[(2)]);
var state_82077__$1 = state_82077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82077__$1,inst_82075);
} else {
if((state_val_82078 === (4))){
var inst_82046 = (state_82077[(2)]);
var inst_82047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82048 = [inst_82046];
var inst_82049 = (new cljs.core.PersistentVector(null,1,(5),inst_82047,inst_82048,null));
var inst_82050 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82049);
var inst_82051 = reject.call(null,inst_82046);
var state_82077__$1 = (function (){var statearr_82082 = state_82077;
(statearr_82082[(7)] = inst_82050);

return statearr_82082;
})();
var statearr_82083_82095 = state_82077__$1;
(statearr_82083_82095[(2)] = inst_82051);

(statearr_82083_82095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82078 === (5))){
var _ = (function (){var statearr_82084 = state_82077;
(statearr_82084[(4)] = cljs.core.rest.call(null,(state_82077[(4)])));

return statearr_82084;
})();
var state_82077__$1 = state_82077;
var ex82081 = (state_82077__$1[(2)]);
var statearr_82085_82096 = state_82077__$1;
(statearr_82085_82096[(5)] = ex82081);


var statearr_82086_82097 = state_82077__$1;
(statearr_82086_82097[(1)] = (4));

(statearr_82086_82097[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82078 === (6))){
var inst_82060 = (state_82077[(2)]);
var inst_82061 = fluree.db.util.async.throw_err.call(null,inst_82060);
var inst_82062 = (function (){var db = inst_82061;
return (function (p1__82045_SHARP_){
return cljs.core.nth.call(null,p1__82045_SHARP_,(4));
});
})();
var inst_82063 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_82064 = cljs.core.group_by.call(null,inst_82062,inst_82063);
var inst_82065 = cljs.core.__destructure_map.call(null,inst_82064);
var inst_82066 = cljs.core.get.call(null,inst_82065,true);
var inst_82067 = cljs.core.get.call(null,inst_82065,false);
var inst_82068 = (function (){var db = inst_82061;
var map__82057 = inst_82065;
var add = inst_82066;
var retract = inst_82067;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_82069 = inst_82068.call(null,inst_82066);
var inst_82070 = inst_82068.call(null,inst_82067);
var inst_82071 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_82069,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_82070);
var inst_82072 = resolve.call(null,inst_82071);
var _ = (function (){var statearr_82087 = state_82077;
(statearr_82087[(4)] = cljs.core.rest.call(null,(state_82077[(4)])));

return statearr_82087;
})();
var state_82077__$1 = state_82077;
var statearr_82088_82098 = state_82077__$1;
(statearr_82088_82098[(2)] = inst_82072);

(statearr_82088_82098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$blockEventToMap_$_state_machine__2746__auto__ = null;
var flureenjs$blockEventToMap_$_state_machine__2746__auto____0 = (function (){
var statearr_82089 = [null,null,null,null,null,null,null,null];
(statearr_82089[(0)] = flureenjs$blockEventToMap_$_state_machine__2746__auto__);

(statearr_82089[(1)] = (1));

return statearr_82089;
});
var flureenjs$blockEventToMap_$_state_machine__2746__auto____1 = (function (state_82077){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82090){var ex__2749__auto__ = e82090;
var statearr_82091_82099 = state_82077;
(statearr_82091_82099[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82077[(4)]))){
var statearr_82092_82100 = state_82077;
(statearr_82092_82100[(1)] = cljs.core.first.call(null,(state_82077[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82101 = state_82077;
state_82077 = G__82101;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$blockEventToMap_$_state_machine__2746__auto__ = function(state_82077){
switch(arguments.length){
case 0:
return flureenjs$blockEventToMap_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$blockEventToMap_$_state_machine__2746__auto____1.call(this,state_82077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$blockEventToMap_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$blockEventToMap_$_state_machine__2746__auto____0;
flureenjs$blockEventToMap_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$blockEventToMap_$_state_machine__2746__auto____1;
return flureenjs$blockEventToMap_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82093 = f__2769__auto__.call(null);
(statearr_82093[(6)] = c__2768__auto__);

return statearr_82093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.closeListener = (function flureenjs$closeListener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.closeListener', flureenjs.closeListener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs._db_instance = (function flureenjs$_db_instance(var_args){
var G__82103 = arguments.length;
switch (G__82103) {
case 2:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs._db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___82179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82152){
var state_val_82153 = (state_82152[(1)]);
if((state_val_82153 === (7))){
var inst_82123 = (state_82152[(7)]);
var state_82152__$1 = state_82152;
if(cljs.core.truth_(inst_82123)){
var statearr_82154_82180 = state_82152__$1;
(statearr_82154_82180[(1)] = (9));

} else {
var statearr_82155_82181 = state_82152__$1;
(statearr_82155_82181[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (1))){
var state_82152__$1 = state_82152;
var statearr_82156_82182 = state_82152__$1;
(statearr_82156_82182[(2)] = null);

(statearr_82156_82182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (4))){
var inst_82104 = (state_82152[(2)]);
var inst_82105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82106 = [inst_82104];
var inst_82107 = (new cljs.core.PersistentVector(null,1,(5),inst_82105,inst_82106,null));
var inst_82108 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82107);
var inst_82109 = cljs.core.async.put_BANG_.call(null,pc,inst_82104);
var inst_82110 = cljs.core.async.close_BANG_.call(null,pc);
var state_82152__$1 = (function (){var statearr_82157 = state_82152;
(statearr_82157[(8)] = inst_82108);

(statearr_82157[(9)] = inst_82109);

return statearr_82157;
})();
var statearr_82158_82183 = state_82152__$1;
(statearr_82158_82183[(2)] = inst_82110);

(statearr_82158_82183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (6))){
var inst_82122 = (state_82152[(10)]);
var state_82152__$1 = state_82152;
var statearr_82159_82184 = state_82152__$1;
(statearr_82159_82184[(2)] = inst_82122);

(statearr_82159_82184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (3))){
var inst_82150 = (state_82152[(2)]);
var state_82152__$1 = state_82152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82152__$1,inst_82150);
} else {
if((state_val_82153 === (12))){
var inst_82126 = (state_82152[(11)]);
var inst_82127 = (state_82152[(12)]);
var inst_82144 = (state_82152[(2)]);
var inst_82145 = fluree.db.util.async.throw_err.call(null,inst_82144);
var inst_82146 = cljs.core.assoc.call(null,inst_82145,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_82126,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_82127);
var inst_82147 = cljs.core.async.put_BANG_.call(null,pc,inst_82146);
var _ = (function (){var statearr_82160 = state_82152;
(statearr_82160[(4)] = cljs.core.rest.call(null,(state_82152[(4)])));

return statearr_82160;
})();
var state_82152__$1 = state_82152;
var statearr_82161_82185 = state_82152__$1;
(statearr_82161_82185[(2)] = inst_82147);

(statearr_82161_82185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (2))){
var inst_82122 = (state_82152[(10)]);
var _ = (function (){var statearr_82162 = state_82152;
(statearr_82162[(4)] = cljs.core.cons.call(null,(5),(state_82152[(4)])));

return statearr_82162;
})();
var inst_82120 = opts;
var inst_82121 = cljs.core.__destructure_map.call(null,inst_82120);
var inst_82122__$1 = cljs.core.get.call(null,inst_82121,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_82123 = cljs.core.get.call(null,inst_82121,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_82124 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_82125 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_82126 = cljs.core.nth.call(null,inst_82125,(0),null);
var inst_82127 = cljs.core.nth.call(null,inst_82125,(1),null);
var state_82152__$1 = (function (){var statearr_82163 = state_82152;
(statearr_82163[(7)] = inst_82123);

(statearr_82163[(11)] = inst_82126);

(statearr_82163[(13)] = inst_82124);

(statearr_82163[(10)] = inst_82122__$1);

(statearr_82163[(12)] = inst_82127);

return statearr_82163;
})();
if(cljs.core.truth_(inst_82122__$1)){
var statearr_82164_82186 = state_82152__$1;
(statearr_82164_82186[(1)] = (6));

} else {
var statearr_82165_82187 = state_82152__$1;
(statearr_82165_82187[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (11))){
var inst_82138 = (state_82152[(2)]);
var state_82152__$1 = state_82152;
var statearr_82167_82188 = state_82152__$1;
(statearr_82167_82188[(2)] = inst_82138);

(statearr_82167_82188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (9))){
var inst_82123 = (state_82152[(7)]);
var inst_82131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82132 = fluree.db.connection_js.validate_token.call(null,conn,inst_82123);
var inst_82133 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_82132);
var inst_82134 = ["_auth/id",inst_82133];
var inst_82135 = (new cljs.core.PersistentVector(null,2,(5),inst_82131,inst_82134,null));
var state_82152__$1 = state_82152;
var statearr_82168_82189 = state_82152__$1;
(statearr_82168_82189[(2)] = inst_82135);

(statearr_82168_82189[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (5))){
var _ = (function (){var statearr_82169 = state_82152;
(statearr_82169[(4)] = cljs.core.rest.call(null,(state_82152[(4)])));

return statearr_82169;
})();
var state_82152__$1 = state_82152;
var ex82166 = (state_82152__$1[(2)]);
var statearr_82170_82190 = state_82152__$1;
(statearr_82170_82190[(5)] = ex82166);


var statearr_82171_82191 = state_82152__$1;
(statearr_82171_82191[(1)] = (4));

(statearr_82171_82191[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (10))){
var state_82152__$1 = state_82152;
var statearr_82172_82192 = state_82152__$1;
(statearr_82172_82192[(2)] = null);

(statearr_82172_82192[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82153 === (8))){
var inst_82140 = (state_82152[(2)]);
var inst_82141 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_82140);
var inst_82142 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_82141);
var state_82152__$1 = state_82152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82152__$1,(12),inst_82142);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_82173 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82173[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_82173[(1)] = (1));

return statearr_82173;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_82152){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82174){var ex__2749__auto__ = e82174;
var statearr_82175_82193 = state_82152;
(statearr_82175_82193[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82152[(4)]))){
var statearr_82176_82194 = state_82152;
(statearr_82176_82194[(1)] = cljs.core.first.call(null,(state_82152[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82195 = state_82152;
state_82152 = G__82195;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_82152){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_82152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82177 = f__2769__auto__.call(null);
(statearr_82177[(6)] = c__2768__auto___82179);

return statearr_82177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(flureenjs._db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___82238 = arguments.length;
var i__5770__auto___82239 = (0);
while(true){
if((i__5770__auto___82239 < len__5769__auto___82238)){
args__5775__auto__.push((arguments[i__5770__auto___82239]));

var G__82240 = (i__5770__auto___82239 + (1));
i__5770__auto___82239 = G__82240;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__82199){
var vec__82200 = p__82199;
var opts = cljs.core.nth.call(null,vec__82200,(0),null);
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82221){
var state_val_82222 = (state_82221[(1)]);
if((state_val_82222 === (1))){
var state_82221__$1 = state_82221;
var statearr_82223_82241 = state_82221__$1;
(statearr_82223_82241[(2)] = null);

(statearr_82223_82241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82222 === (2))){
var _ = (function (){var statearr_82224 = state_82221;
(statearr_82224[(4)] = cljs.core.cons.call(null,(5),(state_82221[(4)])));

return statearr_82224;
})();
var inst_82214 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_82215 = flureenjs._db_instance.call(null,conn,ledger,inst_82214);
var inst_82216 = resolve.call(null,inst_82215);
var ___$1 = (function (){var statearr_82225 = state_82221;
(statearr_82225[(4)] = cljs.core.rest.call(null,(state_82221[(4)])));

return statearr_82225;
})();
var state_82221__$1 = state_82221;
var statearr_82226_82242 = state_82221__$1;
(statearr_82226_82242[(2)] = inst_82216);

(statearr_82226_82242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82222 === (3))){
var inst_82219 = (state_82221[(2)]);
var state_82221__$1 = state_82221;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82221__$1,inst_82219);
} else {
if((state_val_82222 === (4))){
var inst_82203 = (state_82221[(2)]);
var inst_82204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82205 = [inst_82203];
var inst_82206 = (new cljs.core.PersistentVector(null,1,(5),inst_82204,inst_82205,null));
var inst_82207 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82206);
var inst_82208 = reject.call(null,inst_82203);
var state_82221__$1 = (function (){var statearr_82228 = state_82221;
(statearr_82228[(7)] = inst_82207);

return statearr_82228;
})();
var statearr_82229_82243 = state_82221__$1;
(statearr_82229_82243[(2)] = inst_82208);

(statearr_82229_82243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82222 === (5))){
var _ = (function (){var statearr_82230 = state_82221;
(statearr_82230[(4)] = cljs.core.rest.call(null,(state_82221[(4)])));

return statearr_82230;
})();
var state_82221__$1 = state_82221;
var ex82227 = (state_82221__$1[(2)]);
var statearr_82231_82244 = state_82221__$1;
(statearr_82231_82244[(5)] = ex82227);


var statearr_82232_82245 = state_82221__$1;
(statearr_82232_82245[(1)] = (4));

(statearr_82232_82245[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_82233 = [null,null,null,null,null,null,null,null];
(statearr_82233[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_82233[(1)] = (1));

return statearr_82233;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_82221){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82221);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82234){var ex__2749__auto__ = e82234;
var statearr_82235_82246 = state_82221;
(statearr_82235_82246[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82221[(4)]))){
var statearr_82236_82247 = state_82221;
(statearr_82236_82247[(1)] = cljs.core.first.call(null,(state_82221[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82248 = state_82221;
state_82221 = G__82248;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_82221){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_82221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82237 = f__2769__auto__.call(null);
(statearr_82237[(6)] = c__2768__auto__);

return statearr_82237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq82196){
var G__82197 = cljs.core.first.call(null,seq82196);
var seq82196__$1 = cljs.core.next.call(null,seq82196);
var G__82198 = cljs.core.first.call(null,seq82196__$1);
var seq82196__$2 = cljs.core.next.call(null,seq82196__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82197,G__82198,seq82196__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *    If collection doesn't exist, returns nil.
 */
flureenjs.collectionId = (function flureenjs$collectionId(db,collection){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82271){
var state_val_82272 = (state_82271[(1)]);
if((state_val_82272 === (1))){
var state_82271__$1 = state_82271;
var statearr_82273_82289 = state_82271__$1;
(statearr_82273_82289[(2)] = null);

(statearr_82273_82289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82272 === (2))){
var _ = (function (){var statearr_82274 = state_82271;
(statearr_82274[(4)] = cljs.core.cons.call(null,(5),(state_82271[(4)])));

return statearr_82274;
})();
var inst_82260 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82271__$1 = (function (){var statearr_82275 = state_82271;
(statearr_82275[(7)] = inst_82260);

return statearr_82275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82271__$1,(6),db);
} else {
if((state_val_82272 === (3))){
var inst_82269 = (state_82271[(2)]);
var state_82271__$1 = state_82271;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82271__$1,inst_82269);
} else {
if((state_val_82272 === (4))){
var inst_82249 = (state_82271[(2)]);
var inst_82250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82251 = [inst_82249];
var inst_82252 = (new cljs.core.PersistentVector(null,1,(5),inst_82250,inst_82251,null));
var inst_82253 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82252);
var inst_82254 = reject.call(null,inst_82249);
var state_82271__$1 = (function (){var statearr_82277 = state_82271;
(statearr_82277[(8)] = inst_82253);

return statearr_82277;
})();
var statearr_82278_82290 = state_82271__$1;
(statearr_82278_82290[(2)] = inst_82254);

(statearr_82278_82290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82272 === (5))){
var _ = (function (){var statearr_82279 = state_82271;
(statearr_82279[(4)] = cljs.core.rest.call(null,(state_82271[(4)])));

return statearr_82279;
})();
var state_82271__$1 = state_82271;
var ex82276 = (state_82271__$1[(2)]);
var statearr_82280_82291 = state_82271__$1;
(statearr_82280_82291[(5)] = ex82276);


var statearr_82281_82292 = state_82271__$1;
(statearr_82281_82292[(1)] = (4));

(statearr_82281_82292[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82272 === (6))){
var inst_82260 = (state_82271[(7)]);
var inst_82262 = (state_82271[(2)]);
var inst_82263 = fluree.db.util.async.throw_err.call(null,inst_82262);
var inst_82264 = fluree.db.dbproto._c_prop.call(null,inst_82263,new cljs.core.Keyword(null,"id","id",-1388402092),inst_82260);
var inst_82265 = cljs.core.clj__GT_js.call(null,inst_82264);
var inst_82266 = resolve.call(null,inst_82265);
var _ = (function (){var statearr_82282 = state_82271;
(statearr_82282[(4)] = cljs.core.rest.call(null,(state_82271[(4)])));

return statearr_82282;
})();
var state_82271__$1 = state_82271;
var statearr_82283_82293 = state_82271__$1;
(statearr_82283_82293[(2)] = inst_82266);

(statearr_82283_82293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionId_$_state_machine__2746__auto__ = null;
var flureenjs$collectionId_$_state_machine__2746__auto____0 = (function (){
var statearr_82284 = [null,null,null,null,null,null,null,null,null];
(statearr_82284[(0)] = flureenjs$collectionId_$_state_machine__2746__auto__);

(statearr_82284[(1)] = (1));

return statearr_82284;
});
var flureenjs$collectionId_$_state_machine__2746__auto____1 = (function (state_82271){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82285){var ex__2749__auto__ = e82285;
var statearr_82286_82294 = state_82271;
(statearr_82286_82294[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82271[(4)]))){
var statearr_82287_82295 = state_82271;
(statearr_82287_82295[(1)] = cljs.core.first.call(null,(state_82271[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82296 = state_82271;
state_82271 = G__82296;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$collectionId_$_state_machine__2746__auto__ = function(state_82271){
switch(arguments.length){
case 0:
return flureenjs$collectionId_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$collectionId_$_state_machine__2746__auto____1.call(this,state_82271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionId_$_state_machine__2746__auto____0;
flureenjs$collectionId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionId_$_state_machine__2746__auto____1;
return flureenjs$collectionId_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82288 = f__2769__auto__.call(null);
(statearr_82288[(6)] = c__2768__auto__);

return statearr_82288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionId', flureenjs.collectionId);
/**
 * Returns promise containing predicate id given a predicate.
 *    If predicate doesn't exist, returns nil.
 */
flureenjs.predicateId = (function flureenjs$predicateId(db,predicate){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82319){
var state_val_82320 = (state_82319[(1)]);
if((state_val_82320 === (1))){
var state_82319__$1 = state_82319;
var statearr_82321_82337 = state_82319__$1;
(statearr_82321_82337[(2)] = null);

(statearr_82321_82337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82320 === (2))){
var _ = (function (){var statearr_82322 = state_82319;
(statearr_82322[(4)] = cljs.core.cons.call(null,(5),(state_82319[(4)])));

return statearr_82322;
})();
var inst_82308 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82319__$1 = (function (){var statearr_82323 = state_82319;
(statearr_82323[(7)] = inst_82308);

return statearr_82323;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82319__$1,(6),db);
} else {
if((state_val_82320 === (3))){
var inst_82317 = (state_82319[(2)]);
var state_82319__$1 = state_82319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82319__$1,inst_82317);
} else {
if((state_val_82320 === (4))){
var inst_82297 = (state_82319[(2)]);
var inst_82298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82299 = [inst_82297];
var inst_82300 = (new cljs.core.PersistentVector(null,1,(5),inst_82298,inst_82299,null));
var inst_82301 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82300);
var inst_82302 = reject.call(null,inst_82297);
var state_82319__$1 = (function (){var statearr_82325 = state_82319;
(statearr_82325[(8)] = inst_82301);

return statearr_82325;
})();
var statearr_82326_82338 = state_82319__$1;
(statearr_82326_82338[(2)] = inst_82302);

(statearr_82326_82338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82320 === (5))){
var _ = (function (){var statearr_82327 = state_82319;
(statearr_82327[(4)] = cljs.core.rest.call(null,(state_82319[(4)])));

return statearr_82327;
})();
var state_82319__$1 = state_82319;
var ex82324 = (state_82319__$1[(2)]);
var statearr_82328_82339 = state_82319__$1;
(statearr_82328_82339[(5)] = ex82324);


var statearr_82329_82340 = state_82319__$1;
(statearr_82329_82340[(1)] = (4));

(statearr_82329_82340[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82320 === (6))){
var inst_82308 = (state_82319[(7)]);
var inst_82310 = (state_82319[(2)]);
var inst_82311 = fluree.db.util.async.throw_err.call(null,inst_82310);
var inst_82312 = fluree.db.dbproto._p_prop.call(null,inst_82311,new cljs.core.Keyword(null,"id","id",-1388402092),inst_82308);
var inst_82313 = cljs.core.clj__GT_js.call(null,inst_82312);
var inst_82314 = resolve.call(null,inst_82313);
var _ = (function (){var statearr_82330 = state_82319;
(statearr_82330[(4)] = cljs.core.rest.call(null,(state_82319[(4)])));

return statearr_82330;
})();
var state_82319__$1 = state_82319;
var statearr_82331_82341 = state_82319__$1;
(statearr_82331_82341[(2)] = inst_82314);

(statearr_82331_82341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateId_$_state_machine__2746__auto__ = null;
var flureenjs$predicateId_$_state_machine__2746__auto____0 = (function (){
var statearr_82332 = [null,null,null,null,null,null,null,null,null];
(statearr_82332[(0)] = flureenjs$predicateId_$_state_machine__2746__auto__);

(statearr_82332[(1)] = (1));

return statearr_82332;
});
var flureenjs$predicateId_$_state_machine__2746__auto____1 = (function (state_82319){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82333){var ex__2749__auto__ = e82333;
var statearr_82334_82342 = state_82319;
(statearr_82334_82342[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82319[(4)]))){
var statearr_82335_82343 = state_82319;
(statearr_82335_82343[(1)] = cljs.core.first.call(null,(state_82319[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82344 = state_82319;
state_82319 = G__82344;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$predicateId_$_state_machine__2746__auto__ = function(state_82319){
switch(arguments.length){
case 0:
return flureenjs$predicateId_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$predicateId_$_state_machine__2746__auto____1.call(this,state_82319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateId_$_state_machine__2746__auto____0;
flureenjs$predicateId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateId_$_state_machine__2746__auto____1;
return flureenjs$predicateId_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82336 = f__2769__auto__.call(null);
(statearr_82336[(6)] = c__2768__auto__);

return statearr_82336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateId', flureenjs.predicateId);
/**
 * Returns promise containing predicate name given a predicate.
 *    If predicate doesn't exist, returns nil.
 */
flureenjs.predicateName = (function flureenjs$predicateName(db,predicate){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82367){
var state_val_82368 = (state_82367[(1)]);
if((state_val_82368 === (1))){
var state_82367__$1 = state_82367;
var statearr_82369_82385 = state_82367__$1;
(statearr_82369_82385[(2)] = null);

(statearr_82369_82385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82368 === (2))){
var _ = (function (){var statearr_82370 = state_82367;
(statearr_82370[(4)] = cljs.core.cons.call(null,(5),(state_82367[(4)])));

return statearr_82370;
})();
var inst_82356 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82367__$1 = (function (){var statearr_82371 = state_82367;
(statearr_82371[(7)] = inst_82356);

return statearr_82371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82367__$1,(6),db);
} else {
if((state_val_82368 === (3))){
var inst_82365 = (state_82367[(2)]);
var state_82367__$1 = state_82367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82367__$1,inst_82365);
} else {
if((state_val_82368 === (4))){
var inst_82345 = (state_82367[(2)]);
var inst_82346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82347 = [inst_82345];
var inst_82348 = (new cljs.core.PersistentVector(null,1,(5),inst_82346,inst_82347,null));
var inst_82349 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82348);
var inst_82350 = reject.call(null,inst_82345);
var state_82367__$1 = (function (){var statearr_82373 = state_82367;
(statearr_82373[(8)] = inst_82349);

return statearr_82373;
})();
var statearr_82374_82386 = state_82367__$1;
(statearr_82374_82386[(2)] = inst_82350);

(statearr_82374_82386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82368 === (5))){
var _ = (function (){var statearr_82375 = state_82367;
(statearr_82375[(4)] = cljs.core.rest.call(null,(state_82367[(4)])));

return statearr_82375;
})();
var state_82367__$1 = state_82367;
var ex82372 = (state_82367__$1[(2)]);
var statearr_82376_82387 = state_82367__$1;
(statearr_82376_82387[(5)] = ex82372);


var statearr_82377_82388 = state_82367__$1;
(statearr_82377_82388[(1)] = (4));

(statearr_82377_82388[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82368 === (6))){
var inst_82356 = (state_82367[(7)]);
var inst_82358 = (state_82367[(2)]);
var inst_82359 = fluree.db.util.async.throw_err.call(null,inst_82358);
var inst_82360 = fluree.db.dbproto._p_prop.call(null,inst_82359,new cljs.core.Keyword(null,"name","name",1843675177),inst_82356);
var inst_82361 = cljs.core.clj__GT_js.call(null,inst_82360);
var inst_82362 = resolve.call(null,inst_82361);
var _ = (function (){var statearr_82378 = state_82367;
(statearr_82378[(4)] = cljs.core.rest.call(null,(state_82367[(4)])));

return statearr_82378;
})();
var state_82367__$1 = state_82367;
var statearr_82379_82389 = state_82367__$1;
(statearr_82379_82389[(2)] = inst_82362);

(statearr_82379_82389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateName_$_state_machine__2746__auto__ = null;
var flureenjs$predicateName_$_state_machine__2746__auto____0 = (function (){
var statearr_82380 = [null,null,null,null,null,null,null,null,null];
(statearr_82380[(0)] = flureenjs$predicateName_$_state_machine__2746__auto__);

(statearr_82380[(1)] = (1));

return statearr_82380;
});
var flureenjs$predicateName_$_state_machine__2746__auto____1 = (function (state_82367){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82381){var ex__2749__auto__ = e82381;
var statearr_82382_82390 = state_82367;
(statearr_82382_82390[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82367[(4)]))){
var statearr_82383_82391 = state_82367;
(statearr_82383_82391[(1)] = cljs.core.first.call(null,(state_82367[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82392 = state_82367;
state_82367 = G__82392;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$predicateName_$_state_machine__2746__auto__ = function(state_82367){
switch(arguments.length){
case 0:
return flureenjs$predicateName_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$predicateName_$_state_machine__2746__auto____1.call(this,state_82367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateName_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateName_$_state_machine__2746__auto____0;
flureenjs$predicateName_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateName_$_state_machine__2746__auto____1;
return flureenjs$predicateName_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82384 = f__2769__auto__.call(null);
(statearr_82384[(6)] = c__2768__auto__);

return statearr_82384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateName', flureenjs.predicateName);
/**
 * Returns promise containing subject id given a subject
 *    identity or a subject id.
 *    If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82418){
var state_val_82419 = (state_82418[(1)]);
if((state_val_82419 === (1))){
var state_82418__$1 = state_82418;
var statearr_82420_82436 = state_82418__$1;
(statearr_82420_82436[(2)] = null);

(statearr_82420_82436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82419 === (2))){
var _ = (function (){var statearr_82421 = state_82418;
(statearr_82421[(4)] = cljs.core.cons.call(null,(5),(state_82418[(4)])));

return statearr_82421;
})();
var inst_82404 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82418__$1 = (function (){var statearr_82422 = state_82418;
(statearr_82422[(7)] = inst_82404);

return statearr_82422;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82418__$1,(7),db);
} else {
if((state_val_82419 === (3))){
var inst_82416 = (state_82418[(2)]);
var state_82418__$1 = state_82418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82418__$1,inst_82416);
} else {
if((state_val_82419 === (4))){
var inst_82393 = (state_82418[(2)]);
var inst_82394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82395 = [inst_82393];
var inst_82396 = (new cljs.core.PersistentVector(null,1,(5),inst_82394,inst_82395,null));
var inst_82397 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82396);
var inst_82398 = reject.call(null,inst_82393);
var state_82418__$1 = (function (){var statearr_82424 = state_82418;
(statearr_82424[(8)] = inst_82397);

return statearr_82424;
})();
var statearr_82425_82437 = state_82418__$1;
(statearr_82425_82437[(2)] = inst_82398);

(statearr_82425_82437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82419 === (5))){
var _ = (function (){var statearr_82426 = state_82418;
(statearr_82426[(4)] = cljs.core.rest.call(null,(state_82418[(4)])));

return statearr_82426;
})();
var state_82418__$1 = state_82418;
var ex82423 = (state_82418__$1[(2)]);
var statearr_82427_82438 = state_82418__$1;
(statearr_82427_82438[(5)] = ex82423);


var statearr_82428_82439 = state_82418__$1;
(statearr_82428_82439[(1)] = (4));

(statearr_82428_82439[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82419 === (6))){
var inst_82410 = (state_82418[(2)]);
var inst_82411 = fluree.db.util.async.throw_err.call(null,inst_82410);
var inst_82412 = cljs.core.clj__GT_js.call(null,inst_82411);
var inst_82413 = resolve.call(null,inst_82412);
var _ = (function (){var statearr_82429 = state_82418;
(statearr_82429[(4)] = cljs.core.rest.call(null,(state_82418[(4)])));

return statearr_82429;
})();
var state_82418__$1 = state_82418;
var statearr_82430_82440 = state_82418__$1;
(statearr_82430_82440[(2)] = inst_82413);

(statearr_82430_82440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82419 === (7))){
var inst_82404 = (state_82418[(7)]);
var inst_82406 = (state_82418[(2)]);
var inst_82407 = fluree.db.util.async.throw_err.call(null,inst_82406);
var inst_82408 = fluree.db.dbproto._subid.call(null,inst_82407,inst_82404,false);
var state_82418__$1 = state_82418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82418__$1,(6),inst_82408);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__2746__auto__ = null;
var flureenjs$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_82431 = [null,null,null,null,null,null,null,null,null];
(statearr_82431[(0)] = flureenjs$subid_$_state_machine__2746__auto__);

(statearr_82431[(1)] = (1));

return statearr_82431;
});
var flureenjs$subid_$_state_machine__2746__auto____1 = (function (state_82418){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82432){var ex__2749__auto__ = e82432;
var statearr_82433_82441 = state_82418;
(statearr_82433_82441[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82418[(4)]))){
var statearr_82434_82442 = state_82418;
(statearr_82434_82442[(1)] = cljs.core.first.call(null,(state_82418[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82443 = state_82418;
state_82418 = G__82443;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__2746__auto__ = function(state_82418){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__2746__auto____1.call(this,state_82418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__2746__auto____0;
flureenjs$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__2746__auto____1;
return flureenjs$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82435 = f__2769__auto__.call(null);
(statearr_82435[(6)] = c__2768__auto__);

return statearr_82435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.deleteLedger = (function flureenjs$deleteLedger(var_args){
var G__82445 = arguments.length;
switch (G__82445) {
case 2:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.deleteLedger', flureenjs.deleteLedger);

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.deleteLedger.call(null,conn,ledger,null);
}));

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82518){
var state_val_82519 = (state_82518[(1)]);
if((state_val_82519 === (7))){
var inst_82461 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82518__$1 = state_82518;
var statearr_82520_82565 = state_82518__$1;
(statearr_82520_82565[(2)] = inst_82461);

(statearr_82520_82565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (20))){
var inst_82469 = (state_82518[(7)]);
var inst_82493 = (state_82518[(2)]);
var state_82518__$1 = (function (){var statearr_82521 = state_82518;
(statearr_82521[(8)] = inst_82493);

return statearr_82521;
})();
if(cljs.core.truth_(inst_82469)){
var statearr_82522_82566 = state_82518__$1;
(statearr_82522_82566[(1)] = (21));

} else {
var statearr_82523_82567 = state_82518__$1;
(statearr_82523_82567[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (1))){
var state_82518__$1 = state_82518;
var statearr_82524_82568 = state_82518__$1;
(statearr_82524_82568[(2)] = null);

(statearr_82524_82568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (24))){
var inst_82500 = (state_82518[(2)]);
var inst_82501 = fluree.db.util.async.throw_err.call(null,inst_82500);
var state_82518__$1 = state_82518;
var statearr_82525_82569 = state_82518__$1;
(statearr_82525_82569[(2)] = inst_82501);

(statearr_82525_82569[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (4))){
var inst_82446 = (state_82518[(2)]);
var inst_82447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82448 = [inst_82446];
var inst_82449 = (new cljs.core.PersistentVector(null,1,(5),inst_82447,inst_82448,null));
var inst_82450 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82449);
var inst_82451 = reject.call(null,inst_82446);
var state_82518__$1 = (function (){var statearr_82526 = state_82518;
(statearr_82526[(9)] = inst_82450);

return statearr_82526;
})();
var statearr_82527_82570 = state_82518__$1;
(statearr_82527_82570[(2)] = inst_82451);

(statearr_82527_82570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (15))){
var inst_82482 = (state_82518[(10)]);
var inst_82484 = fluree.db.util.core.without_nils.call(null,inst_82482);
var inst_82485 = fluree.db.util.json.stringify.call(null,inst_82484);
var state_82518__$1 = state_82518;
var statearr_82528_82571 = state_82518__$1;
(statearr_82528_82571[(2)] = inst_82485);

(statearr_82528_82571[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (21))){
var inst_82493 = (state_82518[(8)]);
var inst_82488 = (state_82518[(11)]);
var inst_82495 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_82496 = [inst_82488,inst_82493];
var inst_82497 = cljs.core.PersistentHashMap.fromArrays(inst_82495,inst_82496);
var inst_82498 = fluree.db.operations.command_async.call(null,conn,inst_82497);
var state_82518__$1 = state_82518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82518__$1,(24),inst_82498);
} else {
if((state_val_82519 === (13))){
var inst_82470 = (state_82518[(12)]);
var inst_82477 = (inst_82470 + (30000));
var state_82518__$1 = state_82518;
var statearr_82529_82572 = state_82518__$1;
(statearr_82529_82572[(2)] = inst_82477);

(statearr_82529_82572[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (22))){
var inst_82482 = (state_82518[(10)]);
var inst_82503 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_82482);
var state_82518__$1 = state_82518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82518__$1,(25),inst_82503);
} else {
if((state_val_82519 === (6))){
var state_82518__$1 = state_82518;
var statearr_82530_82573 = state_82518__$1;
(statearr_82530_82573[(2)] = null);

(statearr_82530_82573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (25))){
var inst_82505 = (state_82518[(2)]);
var inst_82506 = fluree.db.util.async.throw_err.call(null,inst_82505);
var state_82518__$1 = state_82518;
var statearr_82531_82574 = state_82518__$1;
(statearr_82531_82574[(2)] = inst_82506);

(statearr_82531_82574[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (17))){
var inst_82469 = (state_82518[(7)]);
var inst_82488 = (state_82518[(2)]);
var state_82518__$1 = (function (){var statearr_82532 = state_82518;
(statearr_82532[(11)] = inst_82488);

return statearr_82532;
})();
if(cljs.core.truth_(inst_82469)){
var statearr_82533_82575 = state_82518__$1;
(statearr_82533_82575[(1)] = (18));

} else {
var statearr_82534_82576 = state_82518__$1;
(statearr_82534_82576[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (3))){
var inst_82516 = (state_82518[(2)]);
var state_82518__$1 = state_82518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82518__$1,inst_82516);
} else {
if((state_val_82519 === (12))){
var inst_82467 = (state_82518[(13)]);
var state_82518__$1 = state_82518;
var statearr_82535_82577 = state_82518__$1;
(statearr_82535_82577[(2)] = inst_82467);

(statearr_82535_82577[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (2))){
var _ = (function (){var statearr_82536 = state_82518;
(statearr_82536[(4)] = cljs.core.cons.call(null,(5),(state_82518[(4)])));

return statearr_82536;
})();
var inst_82458 = (opts == null);
var state_82518__$1 = state_82518;
if(cljs.core.truth_(inst_82458)){
var statearr_82537_82578 = state_82518__$1;
(statearr_82537_82578[(1)] = (6));

} else {
var statearr_82538_82579 = state_82518__$1;
(statearr_82538_82579[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (23))){
var inst_82508 = (state_82518[(2)]);
var inst_82509 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_82510 = [(200),inst_82508];
var inst_82511 = cljs.core.PersistentHashMap.fromArrays(inst_82509,inst_82510);
var inst_82512 = cljs.core.clj__GT_js.call(null,inst_82511);
var inst_82513 = resolve.call(null,inst_82512);
var _ = (function (){var statearr_82539 = state_82518;
(statearr_82539[(4)] = cljs.core.rest.call(null,(state_82518[(4)])));

return statearr_82539;
})();
var state_82518__$1 = state_82518;
var statearr_82540_82580 = state_82518__$1;
(statearr_82540_82580[(2)] = inst_82513);

(statearr_82540_82580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (19))){
var state_82518__$1 = state_82518;
var statearr_82541_82581 = state_82518__$1;
(statearr_82541_82581[(2)] = null);

(statearr_82541_82581[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (11))){
var inst_82467 = (state_82518[(13)]);
var inst_82474 = (state_82518[(2)]);
var state_82518__$1 = (function (){var statearr_82543 = state_82518;
(statearr_82543[(14)] = inst_82474);

return statearr_82543;
})();
if(cljs.core.truth_(inst_82467)){
var statearr_82544_82582 = state_82518__$1;
(statearr_82544_82582[(1)] = (12));

} else {
var statearr_82545_82583 = state_82518__$1;
(statearr_82545_82583[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (9))){
var inst_82466 = (state_82518[(15)]);
var state_82518__$1 = state_82518;
var statearr_82546_82584 = state_82518__$1;
(statearr_82546_82584[(2)] = inst_82466);

(statearr_82546_82584[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (5))){
var _ = (function (){var statearr_82547 = state_82518;
(statearr_82547[(4)] = cljs.core.rest.call(null,(state_82518[(4)])));

return statearr_82547;
})();
var state_82518__$1 = state_82518;
var ex82542 = (state_82518__$1[(2)]);
var statearr_82548_82585 = state_82518__$1;
(statearr_82548_82585[(5)] = ex82542);


var statearr_82549_82586 = state_82518__$1;
(statearr_82549_82586[(1)] = (4));

(statearr_82549_82586[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (14))){
var inst_82469 = (state_82518[(7)]);
var inst_82474 = (state_82518[(14)]);
var inst_82479 = (state_82518[(2)]);
var inst_82480 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_82481 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_82474,inst_82479];
var inst_82482 = cljs.core.PersistentHashMap.fromArrays(inst_82480,inst_82481);
var state_82518__$1 = (function (){var statearr_82550 = state_82518;
(statearr_82550[(10)] = inst_82482);

return statearr_82550;
})();
if(cljs.core.truth_(inst_82469)){
var statearr_82551_82587 = state_82518__$1;
(statearr_82551_82587[(1)] = (15));

} else {
var statearr_82552_82588 = state_82518__$1;
(statearr_82552_82588[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (16))){
var state_82518__$1 = state_82518;
var statearr_82553_82589 = state_82518__$1;
(statearr_82553_82589[(2)] = null);

(statearr_82553_82589[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (10))){
var inst_82470 = (state_82518[(12)]);
var state_82518__$1 = state_82518;
var statearr_82554_82590 = state_82518__$1;
(statearr_82554_82590[(2)] = inst_82470);

(statearr_82554_82590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (18))){
var inst_82469 = (state_82518[(7)]);
var inst_82488 = (state_82518[(11)]);
var inst_82490 = fluree.crypto.sign_message.call(null,inst_82488,inst_82469);
var state_82518__$1 = state_82518;
var statearr_82555_82591 = state_82518__$1;
(statearr_82555_82591[(2)] = inst_82490);

(statearr_82555_82591[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82519 === (8))){
var inst_82466 = (state_82518[(15)]);
var inst_82463 = (state_82518[(2)]);
var inst_82464 = fluree.db.connection_js.check_connection.call(null,conn,inst_82463);
var inst_82465 = cljs.core.__destructure_map.call(null,inst_82463);
var inst_82466__$1 = cljs.core.get.call(null,inst_82465,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_82467 = cljs.core.get.call(null,inst_82465,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_82468 = cljs.core.get.call(null,inst_82465,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_82469 = cljs.core.get.call(null,inst_82465,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_82470 = fluree.db.util.core.current_time_millis.call(null);
var state_82518__$1 = (function (){var statearr_82556 = state_82518;
(statearr_82556[(13)] = inst_82467);

(statearr_82556[(12)] = inst_82470);

(statearr_82556[(7)] = inst_82469);

(statearr_82556[(16)] = inst_82464);

(statearr_82556[(15)] = inst_82466__$1);

(statearr_82556[(17)] = inst_82468);

return statearr_82556;
})();
if(cljs.core.truth_(inst_82466__$1)){
var statearr_82557_82592 = state_82518__$1;
(statearr_82557_82592[(1)] = (9));

} else {
var statearr_82558_82593 = state_82518__$1;
(statearr_82558_82593[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_82559 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82559[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_82559[(1)] = (1));

return statearr_82559;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_82518){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82560){var ex__2749__auto__ = e82560;
var statearr_82561_82594 = state_82518;
(statearr_82561_82594[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82518[(4)]))){
var statearr_82562_82595 = state_82518;
(statearr_82562_82595[(1)] = cljs.core.first.call(null,(state_82518[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82596 = state_82518;
state_82518 = G__82596;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_82518){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_82518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82563 = f__2769__auto__.call(null);
(statearr_82563[(6)] = c__2768__auto__);

return statearr_82563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.deleteLedger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *    If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledgerInfo = (function flureenjs$ledgerInfo(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82618){
var state_val_82619 = (state_82618[(1)]);
if((state_val_82619 === (1))){
var state_82618__$1 = state_82618;
var statearr_82620_82635 = state_82618__$1;
(statearr_82620_82635[(2)] = null);

(statearr_82620_82635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82619 === (2))){
var _ = (function (){var statearr_82621 = state_82618;
(statearr_82621[(4)] = cljs.core.cons.call(null,(5),(state_82618[(4)])));

return statearr_82621;
})();
var inst_82608 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_82618__$1 = state_82618;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82618__$1,(6),inst_82608);
} else {
if((state_val_82619 === (3))){
var inst_82616 = (state_82618[(2)]);
var state_82618__$1 = state_82618;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82618__$1,inst_82616);
} else {
if((state_val_82619 === (4))){
var inst_82597 = (state_82618[(2)]);
var inst_82598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82599 = [inst_82597];
var inst_82600 = (new cljs.core.PersistentVector(null,1,(5),inst_82598,inst_82599,null));
var inst_82601 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82600);
var inst_82602 = reject.call(null,inst_82597);
var state_82618__$1 = (function (){var statearr_82623 = state_82618;
(statearr_82623[(7)] = inst_82601);

return statearr_82623;
})();
var statearr_82624_82636 = state_82618__$1;
(statearr_82624_82636[(2)] = inst_82602);

(statearr_82624_82636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82619 === (5))){
var _ = (function (){var statearr_82625 = state_82618;
(statearr_82625[(4)] = cljs.core.rest.call(null,(state_82618[(4)])));

return statearr_82625;
})();
var state_82618__$1 = state_82618;
var ex82622 = (state_82618__$1[(2)]);
var statearr_82626_82637 = state_82618__$1;
(statearr_82626_82637[(5)] = ex82622);


var statearr_82627_82638 = state_82618__$1;
(statearr_82627_82638[(1)] = (4));

(statearr_82627_82638[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82619 === (6))){
var inst_82610 = (state_82618[(2)]);
var inst_82611 = fluree.db.util.async.throw_err.call(null,inst_82610);
var inst_82612 = cljs.core.clj__GT_js.call(null,inst_82611);
var inst_82613 = resolve.call(null,inst_82612);
var _ = (function (){var statearr_82628 = state_82618;
(statearr_82628[(4)] = cljs.core.rest.call(null,(state_82618[(4)])));

return statearr_82628;
})();
var state_82618__$1 = state_82618;
var statearr_82629_82639 = state_82618__$1;
(statearr_82629_82639[(2)] = inst_82613);

(statearr_82629_82639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerInfo_$_state_machine__2746__auto__ = null;
var flureenjs$ledgerInfo_$_state_machine__2746__auto____0 = (function (){
var statearr_82630 = [null,null,null,null,null,null,null,null];
(statearr_82630[(0)] = flureenjs$ledgerInfo_$_state_machine__2746__auto__);

(statearr_82630[(1)] = (1));

return statearr_82630;
});
var flureenjs$ledgerInfo_$_state_machine__2746__auto____1 = (function (state_82618){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82631){var ex__2749__auto__ = e82631;
var statearr_82632_82640 = state_82618;
(statearr_82632_82640[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82618[(4)]))){
var statearr_82633_82641 = state_82618;
(statearr_82633_82641[(1)] = cljs.core.first.call(null,(state_82618[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82642 = state_82618;
state_82618 = G__82642;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$ledgerInfo_$_state_machine__2746__auto__ = function(state_82618){
switch(arguments.length){
case 0:
return flureenjs$ledgerInfo_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$ledgerInfo_$_state_machine__2746__auto____1.call(this,state_82618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerInfo_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerInfo_$_state_machine__2746__auto____0;
flureenjs$ledgerInfo_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerInfo_$_state_machine__2746__auto____1;
return flureenjs$ledgerInfo_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82634 = f__2769__auto__.call(null);
(statearr_82634[(6)] = c__2768__auto__);

return statearr_82634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerInfo', flureenjs.ledgerInfo);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledgerList = (function flureenjs$ledgerList(conn){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82664){
var state_val_82665 = (state_82664[(1)]);
if((state_val_82665 === (1))){
var state_82664__$1 = state_82664;
var statearr_82666_82681 = state_82664__$1;
(statearr_82666_82681[(2)] = null);

(statearr_82666_82681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82665 === (2))){
var _ = (function (){var statearr_82667 = state_82664;
(statearr_82667[(4)] = cljs.core.cons.call(null,(5),(state_82664[(4)])));

return statearr_82667;
})();
var inst_82654 = fluree.db.operations.ledgers_async.call(null,conn);
var state_82664__$1 = state_82664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82664__$1,(6),inst_82654);
} else {
if((state_val_82665 === (3))){
var inst_82662 = (state_82664[(2)]);
var state_82664__$1 = state_82664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82664__$1,inst_82662);
} else {
if((state_val_82665 === (4))){
var inst_82643 = (state_82664[(2)]);
var inst_82644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82645 = [inst_82643];
var inst_82646 = (new cljs.core.PersistentVector(null,1,(5),inst_82644,inst_82645,null));
var inst_82647 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82646);
var inst_82648 = reject.call(null,inst_82643);
var state_82664__$1 = (function (){var statearr_82669 = state_82664;
(statearr_82669[(7)] = inst_82647);

return statearr_82669;
})();
var statearr_82670_82682 = state_82664__$1;
(statearr_82670_82682[(2)] = inst_82648);

(statearr_82670_82682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82665 === (5))){
var _ = (function (){var statearr_82671 = state_82664;
(statearr_82671[(4)] = cljs.core.rest.call(null,(state_82664[(4)])));

return statearr_82671;
})();
var state_82664__$1 = state_82664;
var ex82668 = (state_82664__$1[(2)]);
var statearr_82672_82683 = state_82664__$1;
(statearr_82672_82683[(5)] = ex82668);


var statearr_82673_82684 = state_82664__$1;
(statearr_82673_82684[(1)] = (4));

(statearr_82673_82684[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82665 === (6))){
var inst_82656 = (state_82664[(2)]);
var inst_82657 = fluree.db.util.async.throw_err.call(null,inst_82656);
var inst_82658 = cljs.core.clj__GT_js.call(null,inst_82657);
var inst_82659 = resolve.call(null,inst_82658);
var _ = (function (){var statearr_82674 = state_82664;
(statearr_82674[(4)] = cljs.core.rest.call(null,(state_82664[(4)])));

return statearr_82674;
})();
var state_82664__$1 = state_82664;
var statearr_82675_82685 = state_82664__$1;
(statearr_82675_82685[(2)] = inst_82659);

(statearr_82675_82685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerList_$_state_machine__2746__auto__ = null;
var flureenjs$ledgerList_$_state_machine__2746__auto____0 = (function (){
var statearr_82676 = [null,null,null,null,null,null,null,null];
(statearr_82676[(0)] = flureenjs$ledgerList_$_state_machine__2746__auto__);

(statearr_82676[(1)] = (1));

return statearr_82676;
});
var flureenjs$ledgerList_$_state_machine__2746__auto____1 = (function (state_82664){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82677){var ex__2749__auto__ = e82677;
var statearr_82678_82686 = state_82664;
(statearr_82678_82686[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82664[(4)]))){
var statearr_82679_82687 = state_82664;
(statearr_82679_82687[(1)] = cljs.core.first.call(null,(state_82664[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82688 = state_82664;
state_82664 = G__82688;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$ledgerList_$_state_machine__2746__auto__ = function(state_82664){
switch(arguments.length){
case 0:
return flureenjs$ledgerList_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$ledgerList_$_state_machine__2746__auto____1.call(this,state_82664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerList_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerList_$_state_machine__2746__auto____0;
flureenjs$ledgerList_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerList_$_state_machine__2746__auto____1;
return flureenjs$ledgerList_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82680 = f__2769__auto__.call(null);
(statearr_82680[(6)] = c__2768__auto__);

return statearr_82680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerList', flureenjs.ledgerList);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 *     
 */
flureenjs.newLedger = (function flureenjs$newLedger(var_args){
var G__82690 = arguments.length;
switch (G__82690) {
case 2:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.newLedger', flureenjs.newLedger);

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.newLedger.call(null,conn,ledger,null);
}));

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82811){
var state_val_82812 = (state_82811[(1)]);
if((state_val_82812 === (7))){
var inst_82716 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_82811__$1 = state_82811;
var statearr_82813_82878 = state_82811__$1;
(statearr_82813_82878[(2)] = inst_82716);

(statearr_82813_82878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (20))){
var inst_82723 = (state_82811[(7)]);
var inst_82761 = (state_82811[(2)]);
var inst_82762 = fluree.db.util.core.current_time_millis.call(null);
var state_82811__$1 = (function (){var statearr_82814 = state_82811;
(statearr_82814[(8)] = inst_82762);

(statearr_82814[(9)] = inst_82761);

return statearr_82814;
})();
if(cljs.core.truth_(inst_82723)){
var statearr_82815_82879 = state_82811__$1;
(statearr_82815_82879[(1)] = (21));

} else {
var statearr_82816_82880 = state_82811__$1;
(statearr_82816_82880[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (27))){
var inst_82775 = (state_82811[(10)]);
var inst_82777 = fluree.db.util.core.without_nils.call(null,inst_82775);
var inst_82778 = fluree.db.util.json.stringify.call(null,inst_82777);
var state_82811__$1 = state_82811;
var statearr_82817_82881 = state_82811__$1;
(statearr_82817_82881[(2)] = inst_82778);

(statearr_82817_82881[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (1))){
var state_82811__$1 = state_82811;
var statearr_82818_82882 = state_82811__$1;
(statearr_82818_82882[(2)] = null);

(statearr_82818_82882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (24))){
var inst_82729 = (state_82811[(11)]);
var state_82811__$1 = state_82811;
var statearr_82819_82883 = state_82811__$1;
(statearr_82819_82883[(2)] = inst_82729);

(statearr_82819_82883[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (4))){
var inst_82691 = (state_82811[(2)]);
var inst_82692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82693 = [inst_82691];
var inst_82694 = (new cljs.core.PersistentVector(null,1,(5),inst_82692,inst_82693,null));
var inst_82695 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82694);
var inst_82696 = cljs.core.ex_data.call(null,inst_82691);
var inst_82697 = cljs.core.ex_message.call(null,inst_82691);
var inst_82698 = cljs.core.assoc.call(null,inst_82696,new cljs.core.Keyword(null,"message","message",-406056002),inst_82697);
var inst_82699 = cljs.core.clj__GT_js.call(null,inst_82698);
var inst_82700 = reject.call(null,inst_82699);
var state_82811__$1 = (function (){var statearr_82820 = state_82811;
(statearr_82820[(12)] = inst_82695);

return statearr_82820;
})();
var statearr_82821_82884 = state_82811__$1;
(statearr_82821_82884[(2)] = inst_82700);

(statearr_82821_82884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (15))){
var inst_82751 = (state_82811[(13)]);
var inst_82753 = fluree.db.graphdb.validate_ledger_name.call(null,inst_82751,"alias");
var state_82811__$1 = state_82811;
var statearr_82822_82885 = state_82811__$1;
(statearr_82822_82885[(2)] = inst_82753);

(statearr_82822_82885[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (21))){
var inst_82723 = (state_82811[(7)]);
var state_82811__$1 = state_82811;
var statearr_82823_82886 = state_82811__$1;
(statearr_82823_82886[(2)] = inst_82723);

(statearr_82823_82886[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (31))){
var state_82811__$1 = state_82811;
var statearr_82824_82887 = state_82811__$1;
(statearr_82824_82887[(2)] = null);

(statearr_82824_82887[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (32))){
var inst_82725 = (state_82811[(14)]);
var inst_82786 = (state_82811[(2)]);
var state_82811__$1 = (function (){var statearr_82825 = state_82811;
(statearr_82825[(15)] = inst_82786);

return statearr_82825;
})();
if(cljs.core.truth_(inst_82725)){
var statearr_82826_82888 = state_82811__$1;
(statearr_82826_82888[(1)] = (33));

} else {
var statearr_82827_82889 = state_82811__$1;
(statearr_82827_82889[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (33))){
var inst_82786 = (state_82811[(15)]);
var inst_82781 = (state_82811[(16)]);
var inst_82788 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_82789 = [inst_82781,inst_82786];
var inst_82790 = cljs.core.PersistentHashMap.fromArrays(inst_82788,inst_82789);
var inst_82791 = fluree.db.operations.command_async.call(null,conn,inst_82790);
var state_82811__$1 = state_82811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82811__$1,(36),inst_82791);
} else {
if((state_val_82812 === (13))){
var state_82811__$1 = state_82811;
var statearr_82828_82890 = state_82811__$1;
(statearr_82828_82890[(2)] = null);

(statearr_82828_82890[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (22))){
var inst_82762 = (state_82811[(8)]);
var state_82811__$1 = state_82811;
var statearr_82829_82891 = state_82811__$1;
(statearr_82829_82891[(2)] = inst_82762);

(statearr_82829_82891[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (36))){
var inst_82793 = (state_82811[(2)]);
var inst_82794 = fluree.db.util.async.throw_err.call(null,inst_82793);
var state_82811__$1 = state_82811;
var statearr_82830_82892 = state_82811__$1;
(statearr_82830_82892[(2)] = inst_82794);

(statearr_82830_82892[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (29))){
var inst_82725 = (state_82811[(14)]);
var inst_82781 = (state_82811[(2)]);
var state_82811__$1 = (function (){var statearr_82831 = state_82811;
(statearr_82831[(16)] = inst_82781);

return statearr_82831;
})();
if(cljs.core.truth_(inst_82725)){
var statearr_82832_82893 = state_82811__$1;
(statearr_82832_82893[(1)] = (30));

} else {
var statearr_82833_82894 = state_82811__$1;
(statearr_82833_82894[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (6))){
var state_82811__$1 = state_82811;
var statearr_82834_82895 = state_82811__$1;
(statearr_82834_82895[(2)] = null);

(statearr_82834_82895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (28))){
var state_82811__$1 = state_82811;
var statearr_82835_82896 = state_82811__$1;
(statearr_82835_82896[(2)] = null);

(statearr_82835_82896[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (25))){
var inst_82762 = (state_82811[(8)]);
var inst_82769 = (inst_82762 + (30000));
var state_82811__$1 = state_82811;
var statearr_82836_82897 = state_82811__$1;
(statearr_82836_82897[(2)] = inst_82769);

(statearr_82836_82897[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (34))){
var inst_82775 = (state_82811[(10)]);
var inst_82796 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_82775);
var state_82811__$1 = state_82811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82811__$1,(37),inst_82796);
} else {
if((state_val_82812 === (17))){
var inst_82732 = (state_82811[(17)]);
var inst_82756 = (state_82811[(2)]);
var state_82811__$1 = (function (){var statearr_82837 = state_82811;
(statearr_82837[(18)] = inst_82756);

return statearr_82837;
})();
if(cljs.core.truth_(inst_82732)){
var statearr_82838_82898 = state_82811__$1;
(statearr_82838_82898[(1)] = (18));

} else {
var statearr_82839_82899 = state_82811__$1;
(statearr_82839_82899[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (3))){
var inst_82809 = (state_82811[(2)]);
var state_82811__$1 = state_82811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82811__$1,inst_82809);
} else {
if((state_val_82812 === (12))){
var inst_82746 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_82811__$1 = state_82811;
var statearr_82840_82900 = state_82811__$1;
(statearr_82840_82900[(2)] = inst_82746);

(statearr_82840_82900[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (2))){
var _ = (function (){var statearr_82841 = state_82811;
(statearr_82841[(4)] = cljs.core.cons.call(null,(5),(state_82811[(4)])));

return statearr_82841;
})();
var inst_82713 = (opts == null);
var state_82811__$1 = state_82811;
if(cljs.core.truth_(inst_82713)){
var statearr_82842_82901 = state_82811__$1;
(statearr_82842_82901[(1)] = (6));

} else {
var statearr_82843_82902 = state_82811__$1;
(statearr_82843_82902[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (23))){
var inst_82729 = (state_82811[(11)]);
var inst_82766 = (state_82811[(2)]);
var state_82811__$1 = (function (){var statearr_82844 = state_82811;
(statearr_82844[(19)] = inst_82766);

return statearr_82844;
})();
if(cljs.core.truth_(inst_82729)){
var statearr_82845_82903 = state_82811__$1;
(statearr_82845_82903[(1)] = (24));

} else {
var statearr_82846_82904 = state_82811__$1;
(statearr_82846_82904[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (35))){
var inst_82801 = (state_82811[(2)]);
var inst_82802 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_82803 = [(200),inst_82801];
var inst_82804 = cljs.core.PersistentHashMap.fromArrays(inst_82802,inst_82803);
var inst_82805 = cljs.core.clj__GT_js.call(null,inst_82804);
var inst_82806 = resolve.call(null,inst_82805);
var _ = (function (){var statearr_82847 = state_82811;
(statearr_82847[(4)] = cljs.core.rest.call(null,(state_82811[(4)])));

return statearr_82847;
})();
var state_82811__$1 = state_82811;
var statearr_82848_82905 = state_82811__$1;
(statearr_82848_82905[(2)] = inst_82806);

(statearr_82848_82905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (19))){
var state_82811__$1 = state_82811;
var statearr_82849_82906 = state_82811__$1;
(statearr_82849_82906[(2)] = null);

(statearr_82849_82906[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (11))){
var inst_82735 = (state_82811[(20)]);
var inst_82742 = (state_82811[(21)]);
var inst_82732 = (state_82811[(17)]);
var inst_82742__$1 = (state_82811[(2)]);
var inst_82743 = fluree.db.graphdb.validate_ledger_name.call(null,inst_82742__$1,"ledger");
var inst_82744 = fluree.db.graphdb.validate_ledger_name.call(null,inst_82735,"network");
var state_82811__$1 = (function (){var statearr_82851 = state_82811;
(statearr_82851[(22)] = inst_82744);

(statearr_82851[(21)] = inst_82742__$1);

(statearr_82851[(23)] = inst_82743);

return statearr_82851;
})();
if(cljs.core.truth_(inst_82732)){
var statearr_82852_82907 = state_82811__$1;
(statearr_82852_82907[(1)] = (12));

} else {
var statearr_82853_82908 = state_82811__$1;
(statearr_82853_82908[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (9))){
var inst_82736 = (state_82811[(24)]);
var inst_82739 = cljs.core.subs.call(null,inst_82736,(1));
var state_82811__$1 = state_82811;
var statearr_82854_82909 = state_82811__$1;
(statearr_82854_82909[(2)] = inst_82739);

(statearr_82854_82909[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (5))){
var _ = (function (){var statearr_82855 = state_82811;
(statearr_82855[(4)] = cljs.core.rest.call(null,(state_82811[(4)])));

return statearr_82855;
})();
var state_82811__$1 = state_82811;
var ex82850 = (state_82811__$1[(2)]);
var statearr_82856_82910 = state_82811__$1;
(statearr_82856_82910[(5)] = ex82850);


var statearr_82857_82911 = state_82811__$1;
(statearr_82857_82911[(1)] = (4));

(statearr_82857_82911[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (14))){
var inst_82732 = (state_82811[(17)]);
var inst_82749 = (state_82811[(2)]);
var inst_82750 = cljs.core.nth.call(null,inst_82749,(0),null);
var inst_82751 = cljs.core.nth.call(null,inst_82749,(1),null);
var state_82811__$1 = (function (){var statearr_82858 = state_82811;
(statearr_82858[(25)] = inst_82750);

(statearr_82858[(13)] = inst_82751);

return statearr_82858;
})();
if(cljs.core.truth_(inst_82732)){
var statearr_82859_82912 = state_82811__$1;
(statearr_82859_82912[(1)] = (15));

} else {
var statearr_82860_82913 = state_82811__$1;
(statearr_82860_82913[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (26))){
var inst_82733 = (state_82811[(26)]);
var inst_82726 = (state_82811[(27)]);
var inst_82735 = (state_82811[(20)]);
var inst_82730 = (state_82811[(28)]);
var inst_82731 = (state_82811[(29)]);
var inst_82722 = (state_82811[(30)]);
var inst_82742 = (state_82811[(21)]);
var inst_82725 = (state_82811[(14)]);
var inst_82728 = (state_82811[(31)]);
var inst_82724 = (state_82811[(32)]);
var inst_82727 = (state_82811[(33)]);
var inst_82766 = (state_82811[(19)]);
var inst_82761 = (state_82811[(9)]);
var inst_82771 = (state_82811[(2)]);
var inst_82772 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_82773 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82735),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82742)].join('');
var inst_82774 = [inst_82773,inst_82727,inst_82728,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_82771,inst_82730,inst_82761,inst_82733,inst_82731,inst_82722,inst_82766,inst_82724,inst_82726];
var inst_82775 = cljs.core.PersistentHashMap.fromArrays(inst_82772,inst_82774);
var state_82811__$1 = (function (){var statearr_82861 = state_82811;
(statearr_82861[(10)] = inst_82775);

return statearr_82861;
})();
if(cljs.core.truth_(inst_82725)){
var statearr_82862_82914 = state_82811__$1;
(statearr_82862_82914[(1)] = (27));

} else {
var statearr_82863_82915 = state_82811__$1;
(statearr_82863_82915[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (16))){
var state_82811__$1 = state_82811;
var statearr_82864_82916 = state_82811__$1;
(statearr_82864_82916[(2)] = null);

(statearr_82864_82916[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (30))){
var inst_82781 = (state_82811[(16)]);
var inst_82725 = (state_82811[(14)]);
var inst_82783 = fluree.crypto.sign_message.call(null,inst_82781,inst_82725);
var state_82811__$1 = state_82811;
var statearr_82865_82917 = state_82811__$1;
(statearr_82865_82917[(2)] = inst_82783);

(statearr_82865_82917[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (10))){
var inst_82736 = (state_82811[(24)]);
var state_82811__$1 = state_82811;
var statearr_82866_82918 = state_82811__$1;
(statearr_82866_82918[(2)] = inst_82736);

(statearr_82866_82918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (18))){
var inst_82750 = (state_82811[(25)]);
var inst_82751 = (state_82811[(13)]);
var inst_82758 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82750),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82751)].join('');
var state_82811__$1 = state_82811;
var statearr_82867_82919 = state_82811__$1;
(statearr_82867_82919[(2)] = inst_82758);

(statearr_82867_82919[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (37))){
var inst_82798 = (state_82811[(2)]);
var inst_82799 = fluree.db.util.async.throw_err.call(null,inst_82798);
var state_82811__$1 = state_82811;
var statearr_82868_82920 = state_82811__$1;
(statearr_82868_82920[(2)] = inst_82799);

(statearr_82868_82920[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82812 === (8))){
var inst_82736 = (state_82811[(24)]);
var inst_82718 = (state_82811[(2)]);
var inst_82719 = fluree.db.connection_js.check_connection.call(null,conn,inst_82718);
var inst_82720 = cljs.core.__destructure_map.call(null,inst_82718);
var inst_82721 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_82722 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_82723 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_82724 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_82725 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_82726 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_82727 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_82728 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_82729 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_82730 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_82731 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_82732 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_82733 = cljs.core.get.call(null,inst_82720,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_82734 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_82735 = cljs.core.nth.call(null,inst_82734,(0),null);
var inst_82736__$1 = cljs.core.nth.call(null,inst_82734,(1),null);
var inst_82737 = clojure.string.starts_with_QMARK_.call(null,inst_82736__$1,"$");
var state_82811__$1 = (function (){var statearr_82869 = state_82811;
(statearr_82869[(26)] = inst_82733);

(statearr_82869[(27)] = inst_82726);

(statearr_82869[(20)] = inst_82735);

(statearr_82869[(34)] = inst_82721);

(statearr_82869[(28)] = inst_82730);

(statearr_82869[(29)] = inst_82731);

(statearr_82869[(30)] = inst_82722);

(statearr_82869[(7)] = inst_82723);

(statearr_82869[(14)] = inst_82725);

(statearr_82869[(24)] = inst_82736__$1);

(statearr_82869[(31)] = inst_82728);

(statearr_82869[(35)] = inst_82719);

(statearr_82869[(32)] = inst_82724);

(statearr_82869[(33)] = inst_82727);

(statearr_82869[(11)] = inst_82729);

(statearr_82869[(17)] = inst_82732);

return statearr_82869;
})();
if(inst_82737){
var statearr_82870_82921 = state_82811__$1;
(statearr_82870_82921[(1)] = (9));

} else {
var statearr_82871_82922 = state_82811__$1;
(statearr_82871_82922[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_82872 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82872[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_82872[(1)] = (1));

return statearr_82872;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_82811){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82873){var ex__2749__auto__ = e82873;
var statearr_82874_82923 = state_82811;
(statearr_82874_82923[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82811[(4)]))){
var statearr_82875_82924 = state_82811;
(statearr_82875_82924[(1)] = cljs.core.first.call(null,(state_82811[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82925 = state_82811;
state_82811 = G__82925;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_82811){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_82811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82876 = f__2769__auto__.call(null);
(statearr_82876[(6)] = c__2768__auto__);

return statearr_82876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.newLedger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *    tuple of either [network ledger alias] or [network ledger].
 * 
 *    An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *    the provided name is a ledger id.
 * 
 *    If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *    can be used for the name portion of the db-ident.
 * 
 *    i.e.
 *    - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *    - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolveLedger = (function flureenjs$resolveLedger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82944){
var state_val_82945 = (state_82944[(1)]);
if((state_val_82945 === (1))){
var state_82944__$1 = state_82944;
var statearr_82946_82961 = state_82944__$1;
(statearr_82946_82961[(2)] = null);

(statearr_82946_82961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82945 === (2))){
var _ = (function (){var statearr_82947 = state_82944;
(statearr_82947[(4)] = cljs.core.cons.call(null,(5),(state_82944[(4)])));

return statearr_82947;
})();
var inst_82937 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_82938 = cljs.core.clj__GT_js.call(null,inst_82937);
var inst_82939 = resolve.call(null,inst_82938);
var ___$1 = (function (){var statearr_82948 = state_82944;
(statearr_82948[(4)] = cljs.core.rest.call(null,(state_82944[(4)])));

return statearr_82948;
})();
var state_82944__$1 = state_82944;
var statearr_82949_82962 = state_82944__$1;
(statearr_82949_82962[(2)] = inst_82939);

(statearr_82949_82962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82945 === (3))){
var inst_82942 = (state_82944[(2)]);
var state_82944__$1 = state_82944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82944__$1,inst_82942);
} else {
if((state_val_82945 === (4))){
var inst_82926 = (state_82944[(2)]);
var inst_82927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82928 = [inst_82926];
var inst_82929 = (new cljs.core.PersistentVector(null,1,(5),inst_82927,inst_82928,null));
var inst_82930 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82929);
var inst_82931 = reject.call(null,inst_82926);
var state_82944__$1 = (function (){var statearr_82951 = state_82944;
(statearr_82951[(7)] = inst_82930);

return statearr_82951;
})();
var statearr_82952_82963 = state_82944__$1;
(statearr_82952_82963[(2)] = inst_82931);

(statearr_82952_82963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82945 === (5))){
var _ = (function (){var statearr_82953 = state_82944;
(statearr_82953[(4)] = cljs.core.rest.call(null,(state_82944[(4)])));

return statearr_82953;
})();
var state_82944__$1 = state_82944;
var ex82950 = (state_82944__$1[(2)]);
var statearr_82954_82964 = state_82944__$1;
(statearr_82954_82964[(5)] = ex82950);


var statearr_82955_82965 = state_82944__$1;
(statearr_82955_82965[(1)] = (4));

(statearr_82955_82965[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolveLedger_$_state_machine__2746__auto__ = null;
var flureenjs$resolveLedger_$_state_machine__2746__auto____0 = (function (){
var statearr_82956 = [null,null,null,null,null,null,null,null];
(statearr_82956[(0)] = flureenjs$resolveLedger_$_state_machine__2746__auto__);

(statearr_82956[(1)] = (1));

return statearr_82956;
});
var flureenjs$resolveLedger_$_state_machine__2746__auto____1 = (function (state_82944){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e82957){var ex__2749__auto__ = e82957;
var statearr_82958_82966 = state_82944;
(statearr_82958_82966[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82944[(4)]))){
var statearr_82959_82967 = state_82944;
(statearr_82959_82967[(1)] = cljs.core.first.call(null,(state_82944[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82968 = state_82944;
state_82944 = G__82968;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$resolveLedger_$_state_machine__2746__auto__ = function(state_82944){
switch(arguments.length){
case 0:
return flureenjs$resolveLedger_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$resolveLedger_$_state_machine__2746__auto____1.call(this,state_82944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolveLedger_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolveLedger_$_state_machine__2746__auto____0;
flureenjs$resolveLedger_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolveLedger_$_state_machine__2746__auto____1;
return flureenjs$resolveLedger_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_82960 = f__2769__auto__.call(null);
(statearr_82960[(6)] = c__2768__auto__);

return statearr_82960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.resolveLedger', flureenjs.resolveLedger);
/**
 * Returns session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_82987){
var state_val_82988 = (state_82987[(1)]);
if((state_val_82988 === (1))){
var state_82987__$1 = state_82987;
var statearr_82989_83004 = state_82987__$1;
(statearr_82989_83004[(2)] = null);

(statearr_82989_83004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82988 === (2))){
var _ = (function (){var statearr_82990 = state_82987;
(statearr_82990[(4)] = cljs.core.cons.call(null,(5),(state_82987[(4)])));

return statearr_82990;
})();
var inst_82980 = fluree.db.session.session.call(null,conn,ledger);
var inst_82981 = cljs.core.clj__GT_js.call(null,inst_82980);
var inst_82982 = resolve.call(null,inst_82981);
var ___$1 = (function (){var statearr_82991 = state_82987;
(statearr_82991[(4)] = cljs.core.rest.call(null,(state_82987[(4)])));

return statearr_82991;
})();
var state_82987__$1 = state_82987;
var statearr_82992_83005 = state_82987__$1;
(statearr_82992_83005[(2)] = inst_82982);

(statearr_82992_83005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82988 === (3))){
var inst_82985 = (state_82987[(2)]);
var state_82987__$1 = state_82987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82987__$1,inst_82985);
} else {
if((state_val_82988 === (4))){
var inst_82969 = (state_82987[(2)]);
var inst_82970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82971 = [inst_82969];
var inst_82972 = (new cljs.core.PersistentVector(null,1,(5),inst_82970,inst_82971,null));
var inst_82973 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_82972);
var inst_82974 = reject.call(null,inst_82969);
var state_82987__$1 = (function (){var statearr_82994 = state_82987;
(statearr_82994[(7)] = inst_82973);

return statearr_82994;
})();
var statearr_82995_83006 = state_82987__$1;
(statearr_82995_83006[(2)] = inst_82974);

(statearr_82995_83006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82988 === (5))){
var _ = (function (){var statearr_82996 = state_82987;
(statearr_82996[(4)] = cljs.core.rest.call(null,(state_82987[(4)])));

return statearr_82996;
})();
var state_82987__$1 = state_82987;
var ex82993 = (state_82987__$1[(2)]);
var statearr_82997_83007 = state_82987__$1;
(statearr_82997_83007[(5)] = ex82993);


var statearr_82998_83008 = state_82987__$1;
(statearr_82998_83008[(1)] = (4));

(statearr_82998_83008[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__2746__auto__ = null;
var flureenjs$session_$_state_machine__2746__auto____0 = (function (){
var statearr_82999 = [null,null,null,null,null,null,null,null];
(statearr_82999[(0)] = flureenjs$session_$_state_machine__2746__auto__);

(statearr_82999[(1)] = (1));

return statearr_82999;
});
var flureenjs$session_$_state_machine__2746__auto____1 = (function (state_82987){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_82987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83000){var ex__2749__auto__ = e83000;
var statearr_83001_83009 = state_82987;
(statearr_83001_83009[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_82987[(4)]))){
var statearr_83002_83010 = state_82987;
(statearr_83002_83010[(1)] = cljs.core.first.call(null,(state_82987[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83011 = state_82987;
state_82987 = G__83011;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__2746__auto__ = function(state_82987){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__2746__auto____1.call(this,state_82987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__2746__auto____0;
flureenjs$session_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__2746__auto____1;
return flureenjs$session_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83003 = f__2769__auto__.call(null);
(statearr_83003[(6)] = c__2768__auto__);

return statearr_83003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83038){
var state_val_83039 = (state_83038[(1)]);
if((state_val_83039 === (1))){
var state_83038__$1 = state_83038;
var statearr_83040_83056 = state_83038__$1;
(statearr_83040_83056[(2)] = null);

(statearr_83040_83056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83039 === (2))){
var _ = (function (){var statearr_83041 = state_83038;
(statearr_83041[(4)] = cljs.core.cons.call(null,(5),(state_83038[(4)])));

return statearr_83041;
})();
var inst_83023 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_83038__$1 = (function (){var statearr_83042 = state_83038;
(statearr_83042[(7)] = inst_83023);

return statearr_83042;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83038__$1,(7),db);
} else {
if((state_val_83039 === (3))){
var inst_83036 = (state_83038[(2)]);
var state_83038__$1 = state_83038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83038__$1,inst_83036);
} else {
if((state_val_83039 === (4))){
var inst_83012 = (state_83038[(2)]);
var inst_83013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83014 = [inst_83012];
var inst_83015 = (new cljs.core.PersistentVector(null,1,(5),inst_83013,inst_83014,null));
var inst_83016 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83015);
var inst_83017 = reject.call(null,inst_83012);
var state_83038__$1 = (function (){var statearr_83044 = state_83038;
(statearr_83044[(8)] = inst_83016);

return statearr_83044;
})();
var statearr_83045_83057 = state_83038__$1;
(statearr_83045_83057[(2)] = inst_83017);

(statearr_83045_83057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83039 === (5))){
var _ = (function (){var statearr_83046 = state_83038;
(statearr_83046[(4)] = cljs.core.rest.call(null,(state_83038[(4)])));

return statearr_83046;
})();
var state_83038__$1 = state_83038;
var ex83043 = (state_83038__$1[(2)]);
var statearr_83047_83058 = state_83038__$1;
(statearr_83047_83058[(5)] = ex83043);


var statearr_83048_83059 = state_83038__$1;
(statearr_83048_83059[(1)] = (4));

(statearr_83048_83059[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83039 === (6))){
var inst_83029 = (state_83038[(2)]);
var inst_83030 = fluree.db.util.async.throw_err.call(null,inst_83029);
var inst_83031 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_83030);
var inst_83032 = cljs.core.clj__GT_js.call(null,inst_83031);
var inst_83033 = resolve.call(null,inst_83032);
var _ = (function (){var statearr_83049 = state_83038;
(statearr_83049[(4)] = cljs.core.rest.call(null,(state_83038[(4)])));

return statearr_83049;
})();
var state_83038__$1 = state_83038;
var statearr_83050_83060 = state_83038__$1;
(statearr_83050_83060[(2)] = inst_83033);

(statearr_83050_83060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83039 === (7))){
var inst_83023 = (state_83038[(7)]);
var inst_83025 = (state_83038[(2)]);
var inst_83026 = fluree.db.util.async.throw_err.call(null,inst_83025);
var inst_83027 = fluree.db.dbproto._search.call(null,inst_83026,inst_83023);
var state_83038__$1 = state_83038;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83038__$1,(6),inst_83027);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__2746__auto__ = null;
var flureenjs$search_$_state_machine__2746__auto____0 = (function (){
var statearr_83051 = [null,null,null,null,null,null,null,null,null];
(statearr_83051[(0)] = flureenjs$search_$_state_machine__2746__auto__);

(statearr_83051[(1)] = (1));

return statearr_83051;
});
var flureenjs$search_$_state_machine__2746__auto____1 = (function (state_83038){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83052){var ex__2749__auto__ = e83052;
var statearr_83053_83061 = state_83038;
(statearr_83053_83061[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83038[(4)]))){
var statearr_83054_83062 = state_83038;
(statearr_83054_83062[(1)] = cljs.core.first.call(null,(state_83038[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83063 = state_83038;
state_83038 = G__83063;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__2746__auto__ = function(state_83038){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__2746__auto____1.call(this,state_83038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__2746__auto____0;
flureenjs$search_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__2746__auto____1;
return flureenjs$search_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83055 = f__2769__auto__.call(null);
(statearr_83055[(6)] = c__2768__auto__);

return statearr_83055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 *     including the provided flakes. Flakes can contain one or more 't's,
 *     but should be sequential and start after the current 't' of the provided
 *     db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 *     't' is negative and thus should be in descending order.
 * 
 *     A forward-time-travel db can be further forward-time-traveled.
 * 
 *     A forward-time travel DB is held in memory, and is not shared across servers.
 *     Ensure you have adequate memory to hold the flakes you generate and add. If
 *     access is provided via an external API, do any desired size restrictions or
 *     controls within your API endpoint.
 * 
 *     Remember schema operations done via forward-time-travel should be done in a
 *     't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forwardTimeTravel = (function flureenjs$forwardTimeTravel(db,flakes){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83087){
var state_val_83088 = (state_83087[(1)]);
if((state_val_83088 === (1))){
var state_83087__$1 = state_83087;
var statearr_83089_83105 = state_83087__$1;
(statearr_83089_83105[(2)] = null);

(statearr_83089_83105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83088 === (2))){
var _ = (function (){var statearr_83090 = state_83087;
(statearr_83090[(4)] = cljs.core.cons.call(null,(5),(state_83087[(4)])));

return statearr_83090;
})();
var inst_83075 = cljs.core.js__GT_clj.call(null,flakes);
var inst_83076 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_83075);
var state_83087__$1 = (function (){var statearr_83091 = state_83087;
(statearr_83091[(7)] = inst_83076);

return statearr_83091;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83087__$1,(6),db);
} else {
if((state_val_83088 === (3))){
var inst_83085 = (state_83087[(2)]);
var state_83087__$1 = state_83087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83087__$1,inst_83085);
} else {
if((state_val_83088 === (4))){
var inst_83064 = (state_83087[(2)]);
var inst_83065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83066 = [inst_83064];
var inst_83067 = (new cljs.core.PersistentVector(null,1,(5),inst_83065,inst_83066,null));
var inst_83068 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83067);
var inst_83069 = reject.call(null,inst_83064);
var state_83087__$1 = (function (){var statearr_83093 = state_83087;
(statearr_83093[(8)] = inst_83068);

return statearr_83093;
})();
var statearr_83094_83106 = state_83087__$1;
(statearr_83094_83106[(2)] = inst_83069);

(statearr_83094_83106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83088 === (5))){
var _ = (function (){var statearr_83095 = state_83087;
(statearr_83095[(4)] = cljs.core.rest.call(null,(state_83087[(4)])));

return statearr_83095;
})();
var state_83087__$1 = state_83087;
var ex83092 = (state_83087__$1[(2)]);
var statearr_83096_83107 = state_83087__$1;
(statearr_83096_83107[(5)] = ex83092);


var statearr_83097_83108 = state_83087__$1;
(statearr_83097_83108[(1)] = (4));

(statearr_83097_83108[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83088 === (6))){
var inst_83076 = (state_83087[(7)]);
var inst_83078 = (state_83087[(2)]);
var inst_83079 = fluree.db.util.async.throw_err.call(null,inst_83078);
var inst_83080 = fluree.db.graphdb.forward_time_travel.call(null,inst_83079,null,inst_83076);
var inst_83081 = cljs.core.clj__GT_js.call(null,inst_83080);
var inst_83082 = resolve.call(null,inst_83081);
var _ = (function (){var statearr_83098 = state_83087;
(statearr_83098[(4)] = cljs.core.rest.call(null,(state_83087[(4)])));

return statearr_83098;
})();
var state_83087__$1 = state_83087;
var statearr_83099_83109 = state_83087__$1;
(statearr_83099_83109[(2)] = inst_83082);

(statearr_83099_83109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forwardTimeTravel_$_state_machine__2746__auto__ = null;
var flureenjs$forwardTimeTravel_$_state_machine__2746__auto____0 = (function (){
var statearr_83100 = [null,null,null,null,null,null,null,null,null];
(statearr_83100[(0)] = flureenjs$forwardTimeTravel_$_state_machine__2746__auto__);

(statearr_83100[(1)] = (1));

return statearr_83100;
});
var flureenjs$forwardTimeTravel_$_state_machine__2746__auto____1 = (function (state_83087){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83101){var ex__2749__auto__ = e83101;
var statearr_83102_83110 = state_83087;
(statearr_83102_83110[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83087[(4)]))){
var statearr_83103_83111 = state_83087;
(statearr_83103_83111[(1)] = cljs.core.first.call(null,(state_83087[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83112 = state_83087;
state_83087 = G__83112;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$forwardTimeTravel_$_state_machine__2746__auto__ = function(state_83087){
switch(arguments.length){
case 0:
return flureenjs$forwardTimeTravel_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$forwardTimeTravel_$_state_machine__2746__auto____1.call(this,state_83087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forwardTimeTravel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forwardTimeTravel_$_state_machine__2746__auto____0;
flureenjs$forwardTimeTravel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forwardTimeTravel_$_state_machine__2746__auto____1;
return flureenjs$forwardTimeTravel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83104 = f__2769__auto__.call(null);
(statearr_83104[(6)] = c__2768__auto__);

return statearr_83104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.forwardTimeTravel', flureenjs.forwardTimeTravel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.isForwardTimeTravelDb = (function flureenjs$isForwardTimeTravelDb(db){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83139){
var state_val_83140 = (state_83139[(1)]);
if((state_val_83140 === (7))){
var state_83139__$1 = state_83139;
var statearr_83141_83160 = state_83139__$1;
(statearr_83141_83160[(2)] = db);

(statearr_83141_83160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83140 === (1))){
var state_83139__$1 = state_83139;
var statearr_83142_83161 = state_83139__$1;
(statearr_83142_83161[(2)] = null);

(statearr_83142_83161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83140 === (4))){
var inst_83113 = (state_83139[(2)]);
var inst_83114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83115 = [inst_83113];
var inst_83116 = (new cljs.core.PersistentVector(null,1,(5),inst_83114,inst_83115,null));
var inst_83117 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83116);
var inst_83118 = reject.call(null,inst_83113);
var state_83139__$1 = (function (){var statearr_83143 = state_83139;
(statearr_83143[(7)] = inst_83117);

return statearr_83143;
})();
var statearr_83144_83162 = state_83139__$1;
(statearr_83144_83162[(2)] = inst_83118);

(statearr_83144_83162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83140 === (6))){
var state_83139__$1 = state_83139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83139__$1,(9),db);
} else {
if((state_val_83140 === (3))){
var inst_83137 = (state_83139[(2)]);
var state_83139__$1 = state_83139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83139__$1,inst_83137);
} else {
if((state_val_83140 === (2))){
var _ = (function (){var statearr_83146 = state_83139;
(statearr_83146[(4)] = cljs.core.cons.call(null,(5),(state_83139[(4)])));

return statearr_83146;
})();
var inst_83124 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_83139__$1 = state_83139;
if(inst_83124){
var statearr_83147_83163 = state_83139__$1;
(statearr_83147_83163[(1)] = (6));

} else {
var statearr_83148_83164 = state_83139__$1;
(statearr_83148_83164[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83140 === (9))){
var inst_83127 = (state_83139[(2)]);
var inst_83128 = fluree.db.util.async.throw_err.call(null,inst_83127);
var state_83139__$1 = state_83139;
var statearr_83149_83165 = state_83139__$1;
(statearr_83149_83165[(2)] = inst_83128);

(statearr_83149_83165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83140 === (5))){
var _ = (function (){var statearr_83150 = state_83139;
(statearr_83150[(4)] = cljs.core.rest.call(null,(state_83139[(4)])));

return statearr_83150;
})();
var state_83139__$1 = state_83139;
var ex83145 = (state_83139__$1[(2)]);
var statearr_83151_83166 = state_83139__$1;
(statearr_83151_83166[(5)] = ex83145);


var statearr_83152_83167 = state_83139__$1;
(statearr_83152_83167[(1)] = (4));

(statearr_83152_83167[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83140 === (8))){
var inst_83131 = (state_83139[(2)]);
var inst_83132 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_83131);
var inst_83133 = cljs.core.clj__GT_js.call(null,inst_83132);
var inst_83134 = resolve.call(null,inst_83133);
var _ = (function (){var statearr_83153 = state_83139;
(statearr_83153[(4)] = cljs.core.rest.call(null,(state_83139[(4)])));

return statearr_83153;
})();
var state_83139__$1 = state_83139;
var statearr_83154_83168 = state_83139__$1;
(statearr_83154_83168[(2)] = inst_83134);

(statearr_83154_83168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__ = null;
var flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____0 = (function (){
var statearr_83155 = [null,null,null,null,null,null,null,null];
(statearr_83155[(0)] = flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__);

(statearr_83155[(1)] = (1));

return statearr_83155;
});
var flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____1 = (function (state_83139){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83156){var ex__2749__auto__ = e83156;
var statearr_83157_83169 = state_83139;
(statearr_83157_83169[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83139[(4)]))){
var statearr_83158_83170 = state_83139;
(statearr_83158_83170[(1)] = cljs.core.first.call(null,(state_83139[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83171 = state_83139;
state_83139 = G__83171;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__ = function(state_83139){
switch(arguments.length){
case 0:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____1.call(this,state_83139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____0;
flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____1;
return flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83159 = f__2769__auto__.call(null);
(statearr_83159[(6)] = c__2768__auto__);

return statearr_83159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.isForwardTimeTravelDb', flureenjs.isForwardTimeTravelDb);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitorTx = (function flureenjs$monitorTx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83194){
var state_val_83195 = (state_83194[(1)]);
if((state_val_83195 === (1))){
var state_83194__$1 = state_83194;
var statearr_83196_83212 = state_83194__$1;
(statearr_83196_83212[(2)] = null);

(statearr_83196_83212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83195 === (2))){
var _ = (function (){var statearr_83197 = state_83194;
(statearr_83197[(4)] = cljs.core.cons.call(null,(5),(state_83194[(4)])));

return statearr_83197;
})();
var inst_83184 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_83185 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_83194__$1 = (function (){var statearr_83198 = state_83194;
(statearr_83198[(7)] = inst_83184);

return statearr_83198;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83194__$1,(6),inst_83185);
} else {
if((state_val_83195 === (3))){
var inst_83192 = (state_83194[(2)]);
var state_83194__$1 = state_83194;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83194__$1,inst_83192);
} else {
if((state_val_83195 === (4))){
var inst_83172 = (state_83194[(2)]);
var inst_83173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83174 = [inst_83172];
var inst_83175 = (new cljs.core.PersistentVector(null,1,(5),inst_83173,inst_83174,null));
var inst_83176 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83175);
var inst_83177 = cljs.core.clj__GT_js.call(null,inst_83172);
var inst_83178 = reject.call(null,inst_83177);
var state_83194__$1 = (function (){var statearr_83200 = state_83194;
(statearr_83200[(8)] = inst_83176);

return statearr_83200;
})();
var statearr_83201_83213 = state_83194__$1;
(statearr_83201_83213[(2)] = inst_83178);

(statearr_83201_83213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83195 === (5))){
var _ = (function (){var statearr_83202 = state_83194;
(statearr_83202[(4)] = cljs.core.rest.call(null,(state_83194[(4)])));

return statearr_83202;
})();
var state_83194__$1 = state_83194;
var ex83199 = (state_83194__$1[(2)]);
var statearr_83203_83214 = state_83194__$1;
(statearr_83203_83214[(5)] = ex83199);


var statearr_83204_83215 = state_83194__$1;
(statearr_83204_83215[(1)] = (4));

(statearr_83204_83215[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83195 === (6))){
var inst_83187 = (state_83194[(2)]);
var inst_83188 = cljs.core.clj__GT_js.call(null,inst_83187);
var inst_83189 = resolve.call(null,inst_83188);
var _ = (function (){var statearr_83205 = state_83194;
(statearr_83205[(4)] = cljs.core.rest.call(null,(state_83194[(4)])));

return statearr_83205;
})();
var state_83194__$1 = state_83194;
var statearr_83206_83216 = state_83194__$1;
(statearr_83206_83216[(2)] = inst_83189);

(statearr_83206_83216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitorTx_$_state_machine__2746__auto__ = null;
var flureenjs$monitorTx_$_state_machine__2746__auto____0 = (function (){
var statearr_83207 = [null,null,null,null,null,null,null,null,null];
(statearr_83207[(0)] = flureenjs$monitorTx_$_state_machine__2746__auto__);

(statearr_83207[(1)] = (1));

return statearr_83207;
});
var flureenjs$monitorTx_$_state_machine__2746__auto____1 = (function (state_83194){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83194);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83208){var ex__2749__auto__ = e83208;
var statearr_83209_83217 = state_83194;
(statearr_83209_83217[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83194[(4)]))){
var statearr_83210_83218 = state_83194;
(statearr_83210_83218[(1)] = cljs.core.first.call(null,(state_83194[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83219 = state_83194;
state_83194 = G__83219;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$monitorTx_$_state_machine__2746__auto__ = function(state_83194){
switch(arguments.length){
case 0:
return flureenjs$monitorTx_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$monitorTx_$_state_machine__2746__auto____1.call(this,state_83194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitorTx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitorTx_$_state_machine__2746__auto____0;
flureenjs$monitorTx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitorTx_$_state_machine__2746__auto____1;
return flureenjs$monitorTx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83211 = f__2769__auto__.call(null);
(statearr_83211[(6)] = c__2768__auto__);

return statearr_83211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.monitorTx', flureenjs.monitorTx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *    producing a signed command.
 * 
 *    Optional opts is a map with the following keys. If not provided,
 *    defaults will be attempted.
 *    - auth        - The auth id for the auth record being used. The private key must
 *                    correspond to this auth record, or an authority of this auth record.
 *    - expire      - When this transaction should expire if not yet attempted.
 *                    Defaults to 5 minutes.
 *    - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                    By default epoch milliseconds is used.
 *    - deps        - Not yet implemented, list of dependent transactions.
 * 
 *    If successful, will return a map with four keys:
 *      - cmd  - a map with the command/transaction data as a JSON string
 *      - sig  - the signature of the above stringified map
 *      - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *      - db   - the ledger for this transaction
 */
flureenjs.txToCommand = (function flureenjs$txToCommand(var_args){
var G__83221 = arguments.length;
switch (G__83221) {
case 3:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.txToCommand.call(null,ledger,txn,private_key,null);
}));

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83336){
var state_val_83337 = (state_83336[(1)]);
if((state_val_83337 === (7))){
var state_83336__$1 = state_83336;
var statearr_83338_83405 = state_83336__$1;
(statearr_83338_83405[(2)] = ledger);

(statearr_83338_83405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (20))){
var inst_83250 = (state_83336[(7)]);
var inst_83290 = (state_83336[(2)]);
var inst_83291 = cljs.core.nth.call(null,inst_83290,(0),null);
var inst_83292 = cljs.core.nth.call(null,inst_83290,(1),null);
var inst_83293 = fluree.db.util.core.current_time_millis.call(null);
var state_83336__$1 = (function (){var statearr_83339 = state_83336;
(statearr_83339[(8)] = inst_83293);

(statearr_83339[(9)] = inst_83291);

(statearr_83339[(10)] = inst_83292);

return statearr_83339;
})();
if(cljs.core.truth_(inst_83250)){
var statearr_83340_83406 = state_83336__$1;
(statearr_83340_83406[(1)] = (27));

} else {
var statearr_83341_83407 = state_83336__$1;
(statearr_83341_83407[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (27))){
var inst_83250 = (state_83336[(7)]);
var state_83336__$1 = state_83336;
var statearr_83342_83408 = state_83336__$1;
(statearr_83342_83408[(2)] = inst_83250);

(statearr_83342_83408[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (1))){
var state_83336__$1 = state_83336;
var statearr_83343_83409 = state_83336__$1;
(statearr_83343_83409[(2)] = null);

(statearr_83343_83409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (24))){
var inst_83264 = (state_83336[(11)]);
var inst_83281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83282 = [inst_83264,null];
var inst_83283 = (new cljs.core.PersistentVector(null,2,(5),inst_83281,inst_83282,null));
var state_83336__$1 = state_83336;
var statearr_83344_83410 = state_83336__$1;
(statearr_83344_83410[(2)] = inst_83283);

(statearr_83344_83410[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (4))){
var inst_83222 = (state_83336[(2)]);
var inst_83223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83224 = [inst_83222];
var inst_83225 = (new cljs.core.PersistentVector(null,1,(5),inst_83223,inst_83224,null));
var inst_83226 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83225);
var inst_83227 = cljs.core.clj__GT_js.call(null,inst_83222);
var inst_83228 = reject.call(null,inst_83227);
var state_83336__$1 = (function (){var statearr_83345 = state_83336;
(statearr_83345[(12)] = inst_83226);

return statearr_83345;
})();
var statearr_83346_83411 = state_83336__$1;
(statearr_83346_83411[(2)] = inst_83228);

(statearr_83346_83411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (15))){
var inst_83264 = (state_83336[(11)]);
var inst_83248 = (state_83336[(13)]);
var inst_83266 = cljs.core.not_EQ_.call(null,inst_83248,inst_83264);
var state_83336__$1 = state_83336;
var statearr_83347_83412 = state_83336__$1;
(statearr_83347_83412[(2)] = inst_83266);

(statearr_83347_83412[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (21))){
var inst_83248 = (state_83336[(13)]);
var inst_83276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83277 = [inst_83248,null];
var inst_83278 = (new cljs.core.PersistentVector(null,2,(5),inst_83276,inst_83277,null));
var state_83336__$1 = state_83336;
var statearr_83348_83413 = state_83336__$1;
(statearr_83348_83413[(2)] = inst_83278);

(statearr_83348_83413[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (31))){
var inst_83293 = (state_83336[(8)]);
var inst_83300 = (inst_83293 + (30000));
var state_83336__$1 = state_83336;
var statearr_83349_83414 = state_83336__$1;
(statearr_83349_83414[(2)] = inst_83300);

(statearr_83349_83414[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (32))){
var inst_83302 = (state_83336[(2)]);
var state_83336__$1 = (function (){var statearr_83350 = state_83336;
(statearr_83350[(14)] = inst_83302);

return statearr_83350;
})();
var statearr_83351_83415 = state_83336__$1;
(statearr_83351_83415[(2)] = null);

(statearr_83351_83415[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (33))){
var inst_83291 = (state_83336[(9)]);
var inst_83292 = (state_83336[(10)]);
var inst_83302 = (state_83336[(14)]);
var inst_83297 = (state_83336[(15)]);
var inst_83251 = (state_83336[(16)]);
var inst_83245 = (state_83336[(17)]);
var _ = (function (){var statearr_83352 = state_83336;
(statearr_83352[(4)] = cljs.core.cons.call(null,(36),(state_83336[(4)])));

return statearr_83352;
})();
var inst_83318 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_83319 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_83245,txn,inst_83297,inst_83291,inst_83292,inst_83302,inst_83251];
var inst_83320 = cljs.core.PersistentHashMap.fromArrays(inst_83318,inst_83319);
var inst_83321 = fluree.db.util.core.without_nils.call(null,inst_83320);
var inst_83322 = fluree.db.util.json.stringify.call(null,inst_83321);
var ___$1 = (function (){var statearr_83353 = state_83336;
(statearr_83353[(4)] = cljs.core.rest.call(null,(state_83336[(4)])));

return statearr_83353;
})();
var state_83336__$1 = state_83336;
var statearr_83354_83416 = state_83336__$1;
(statearr_83354_83416[(2)] = inst_83322);

(statearr_83354_83416[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (13))){
var inst_83256 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_83257 = (new Error(inst_83256));
var inst_83258 = (function(){throw inst_83257})();
var state_83336__$1 = state_83336;
var statearr_83356_83417 = state_83336__$1;
(statearr_83356_83417[(2)] = inst_83258);

(statearr_83356_83417[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (22))){
var state_83336__$1 = state_83336;
var statearr_83357_83418 = state_83336__$1;
(statearr_83357_83418[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (36))){
var _ = (function (){var statearr_83359 = state_83336;
(statearr_83359[(4)] = cljs.core.rest.call(null,(state_83336[(4)])));

return statearr_83359;
})();
var state_83336__$1 = state_83336;
var ex83355 = (state_83336__$1[(2)]);
var statearr_83360_83419 = state_83336__$1;
(statearr_83360_83419[(5)] = ex83355);


var statearr_83361_83420 = state_83336__$1;
(statearr_83361_83420[(1)] = (35));

(statearr_83361_83420[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (29))){
var inst_83249 = (state_83336[(18)]);
var inst_83297 = (state_83336[(2)]);
var state_83336__$1 = (function (){var statearr_83362 = state_83336;
(statearr_83362[(15)] = inst_83297);

return statearr_83362;
})();
if(cljs.core.truth_(inst_83249)){
var statearr_83363_83421 = state_83336__$1;
(statearr_83363_83421[(1)] = (30));

} else {
var statearr_83364_83422 = state_83336__$1;
(statearr_83364_83422[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (6))){
var inst_83240 = cljs.core.first.call(null,ledger);
var inst_83241 = cljs.core.second.call(null,ledger);
var inst_83242 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83240),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83241)].join('');
var state_83336__$1 = state_83336;
var statearr_83365_83423 = state_83336__$1;
(statearr_83365_83423[(2)] = inst_83242);

(statearr_83365_83423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (28))){
var inst_83293 = (state_83336[(8)]);
var state_83336__$1 = state_83336;
var statearr_83366_83424 = state_83336__$1;
(statearr_83366_83424[(2)] = inst_83293);

(statearr_83366_83424[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (25))){
var state_83336__$1 = state_83336;
var statearr_83367_83425 = state_83336__$1;
(statearr_83367_83425[(2)] = null);

(statearr_83367_83425[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (34))){
var inst_83325 = (state_83336[(2)]);
var inst_83326 = fluree.crypto.sign_message.call(null,inst_83325,private_key);
var inst_83327 = fluree.crypto.sha3_256.call(null,inst_83325);
var inst_83328 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"db","db",993250759)];
var inst_83329 = [inst_83325,inst_83326,inst_83327,ledger];
var inst_83330 = cljs.core.PersistentHashMap.fromArrays(inst_83328,inst_83329);
var inst_83331 = resolve.call(null,inst_83330);
var _ = (function (){var statearr_83368 = state_83336;
(statearr_83368[(4)] = cljs.core.rest.call(null,(state_83336[(4)])));

return statearr_83368;
})();
var state_83336__$1 = state_83336;
var statearr_83369_83426 = state_83336__$1;
(statearr_83369_83426[(2)] = inst_83331);

(statearr_83369_83426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (17))){
var inst_83269 = (state_83336[(2)]);
var state_83336__$1 = state_83336;
if(cljs.core.truth_(inst_83269)){
var statearr_83370_83427 = state_83336__$1;
(statearr_83370_83427[(1)] = (18));

} else {
var statearr_83371_83428 = state_83336__$1;
(statearr_83371_83428[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (3))){
var inst_83334 = (state_83336[(2)]);
var state_83336__$1 = state_83336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83336__$1,inst_83334);
} else {
if((state_val_83337 === (12))){
var state_83336__$1 = state_83336;
var statearr_83372_83429 = state_83336__$1;
(statearr_83372_83429[(2)] = null);

(statearr_83372_83429[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (2))){
var _ = (function (){var statearr_83373 = state_83336;
(statearr_83373[(4)] = cljs.core.cons.call(null,(5),(state_83336[(4)])));

return statearr_83373;
})();
var inst_83238 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_83336__$1 = state_83336;
if(inst_83238){
var statearr_83374_83430 = state_83336__$1;
(statearr_83374_83430[(1)] = (6));

} else {
var statearr_83375_83431 = state_83336__$1;
(statearr_83375_83431[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (23))){
var inst_83288 = (state_83336[(2)]);
var state_83336__$1 = state_83336;
var statearr_83376_83432 = state_83336__$1;
(statearr_83376_83432[(2)] = inst_83288);

(statearr_83376_83432[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (35))){
var inst_83303 = (state_83336[(2)]);
var inst_83304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83305 = [inst_83303];
var inst_83306 = (new cljs.core.PersistentVector(null,1,(5),inst_83304,inst_83305,null));
var inst_83307 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83306);
var inst_83308 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83309 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_83310 = cljs.core.PersistentHashMap.fromArrays(inst_83308,inst_83309);
var inst_83311 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_83310);
var inst_83312 = (function(){throw inst_83311})();
var state_83336__$1 = (function (){var statearr_83377 = state_83336;
(statearr_83377[(19)] = inst_83307);

return statearr_83377;
})();
var statearr_83378_83433 = state_83336__$1;
(statearr_83378_83433[(2)] = inst_83312);

(statearr_83378_83433[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (19))){
var inst_83248 = (state_83336[(13)]);
var state_83336__$1 = state_83336;
if(cljs.core.truth_(inst_83248)){
var statearr_83379_83434 = state_83336__$1;
(statearr_83379_83434[(1)] = (21));

} else {
var statearr_83380_83435 = state_83336__$1;
(statearr_83380_83435[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (11))){
var inst_83248 = (state_83336[(13)]);
var inst_83263 = (state_83336[(2)]);
var inst_83264 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_83336__$1 = (function (){var statearr_83382 = state_83336;
(statearr_83382[(11)] = inst_83264);

(statearr_83382[(20)] = inst_83263);

return statearr_83382;
})();
if(cljs.core.truth_(inst_83248)){
var statearr_83383_83436 = state_83336__$1;
(statearr_83383_83436[(1)] = (15));

} else {
var statearr_83384_83437 = state_83336__$1;
(statearr_83384_83437[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (9))){
var inst_83251 = (state_83336[(16)]);
var inst_83253 = cljs.core.sequential_QMARK_.call(null,inst_83251);
var state_83336__$1 = state_83336;
if(inst_83253){
var statearr_83385_83438 = state_83336__$1;
(statearr_83385_83438[(1)] = (12));

} else {
var statearr_83386_83439 = state_83336__$1;
(statearr_83386_83439[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (5))){
var _ = (function (){var statearr_83387 = state_83336;
(statearr_83387[(4)] = cljs.core.rest.call(null,(state_83336[(4)])));

return statearr_83387;
})();
var state_83336__$1 = state_83336;
var ex83381 = (state_83336__$1[(2)]);
var statearr_83388_83440 = state_83336__$1;
(statearr_83388_83440[(5)] = ex83381);


var statearr_83389_83441 = state_83336__$1;
(statearr_83389_83441[(1)] = (4));

(statearr_83389_83441[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (14))){
var inst_83260 = (state_83336[(2)]);
var state_83336__$1 = state_83336;
var statearr_83390_83442 = state_83336__$1;
(statearr_83390_83442[(2)] = inst_83260);

(statearr_83390_83442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (26))){
var inst_83286 = (state_83336[(2)]);
var state_83336__$1 = state_83336;
var statearr_83391_83443 = state_83336__$1;
(statearr_83391_83443[(2)] = inst_83286);

(statearr_83391_83443[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (16))){
var inst_83248 = (state_83336[(13)]);
var state_83336__$1 = state_83336;
var statearr_83392_83444 = state_83336__$1;
(statearr_83392_83444[(2)] = inst_83248);

(statearr_83392_83444[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (30))){
var inst_83249 = (state_83336[(18)]);
var state_83336__$1 = state_83336;
var statearr_83393_83445 = state_83336__$1;
(statearr_83393_83445[(2)] = inst_83249);

(statearr_83393_83445[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (10))){
var state_83336__$1 = state_83336;
var statearr_83394_83446 = state_83336__$1;
(statearr_83394_83446[(2)] = null);

(statearr_83394_83446[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (18))){
var inst_83264 = (state_83336[(11)]);
var inst_83248 = (state_83336[(13)]);
var inst_83271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83272 = [inst_83248,inst_83264];
var inst_83273 = (new cljs.core.PersistentVector(null,2,(5),inst_83271,inst_83272,null));
var state_83336__$1 = state_83336;
var statearr_83395_83447 = state_83336__$1;
(statearr_83395_83447[(2)] = inst_83273);

(statearr_83395_83447[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83337 === (8))){
var inst_83251 = (state_83336[(16)]);
var inst_83245 = (state_83336[(2)]);
var inst_83246 = opts;
var inst_83247 = cljs.core.__destructure_map.call(null,inst_83246);
var inst_83248 = cljs.core.get.call(null,inst_83247,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_83249 = cljs.core.get.call(null,inst_83247,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_83250 = cljs.core.get.call(null,inst_83247,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_83251__$1 = cljs.core.get.call(null,inst_83247,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_83336__$1 = (function (){var statearr_83396 = state_83336;
(statearr_83396[(7)] = inst_83250);

(statearr_83396[(18)] = inst_83249);

(statearr_83396[(16)] = inst_83251__$1);

(statearr_83396[(17)] = inst_83245);

(statearr_83396[(13)] = inst_83248);

return statearr_83396;
})();
if(cljs.core.truth_(inst_83251__$1)){
var statearr_83397_83448 = state_83336__$1;
(statearr_83397_83448[(1)] = (9));

} else {
var statearr_83398_83449 = state_83336__$1;
(statearr_83398_83449[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_83399 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83399[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_83399[(1)] = (1));

return statearr_83399;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_83336){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83400){var ex__2749__auto__ = e83400;
var statearr_83401_83450 = state_83336;
(statearr_83401_83450[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83336[(4)]))){
var statearr_83402_83451 = state_83336;
(statearr_83402_83451[(1)] = cljs.core.first.call(null,(state_83336[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83452 = state_83336;
state_83336 = G__83452;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_83336){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_83336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83403 = f__2769__auto__.call(null);
(statearr_83403[(6)] = c__2768__auto__);

return statearr_83403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.txToCommand.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__83454 = arguments.length;
switch (G__83454) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83483){
var state_val_83484 = (state_83483[(1)]);
if((state_val_83484 === (7))){
var inst_83469 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_83483__$1 = state_83483;
var statearr_83485_83506 = state_83483__$1;
(statearr_83485_83506[(2)] = inst_83469);

(statearr_83485_83506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83484 === (1))){
var state_83483__$1 = state_83483;
var statearr_83486_83507 = state_83483__$1;
(statearr_83486_83507[(2)] = null);

(statearr_83486_83507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83484 === (4))){
var inst_83455 = (state_83483[(2)]);
var inst_83456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83457 = [inst_83455];
var inst_83458 = (new cljs.core.PersistentVector(null,1,(5),inst_83456,inst_83457,null));
var inst_83459 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83458);
var inst_83460 = reject.call(null,inst_83455);
var state_83483__$1 = (function (){var statearr_83487 = state_83483;
(statearr_83487[(7)] = inst_83459);

return statearr_83487;
})();
var statearr_83488_83508 = state_83483__$1;
(statearr_83488_83508[(2)] = inst_83460);

(statearr_83488_83508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83484 === (6))){
var state_83483__$1 = state_83483;
var statearr_83489_83509 = state_83483__$1;
(statearr_83489_83509[(2)] = null);

(statearr_83489_83509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83484 === (3))){
var inst_83481 = (state_83483[(2)]);
var state_83483__$1 = state_83483;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83483__$1,inst_83481);
} else {
if((state_val_83484 === (2))){
var _ = (function (){var statearr_83491 = state_83483;
(statearr_83491[(4)] = cljs.core.cons.call(null,(5),(state_83483[(4)])));

return statearr_83491;
})();
var inst_83466 = (opts == null);
var state_83483__$1 = state_83483;
if(cljs.core.truth_(inst_83466)){
var statearr_83492_83510 = state_83483__$1;
(statearr_83492_83510[(1)] = (6));

} else {
var statearr_83493_83511 = state_83483__$1;
(statearr_83493_83511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83484 === (9))){
var inst_83476 = (state_83483[(2)]);
var inst_83477 = cljs.core.clj__GT_js.call(null,inst_83476);
var inst_83478 = resolve.call(null,inst_83477);
var _ = (function (){var statearr_83494 = state_83483;
(statearr_83494[(4)] = cljs.core.rest.call(null,(state_83483[(4)])));

return statearr_83494;
})();
var state_83483__$1 = state_83483;
var statearr_83495_83512 = state_83483__$1;
(statearr_83495_83512[(2)] = inst_83478);

(statearr_83495_83512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83484 === (5))){
var _ = (function (){var statearr_83496 = state_83483;
(statearr_83496[(4)] = cljs.core.rest.call(null,(state_83483[(4)])));

return statearr_83496;
})();
var state_83483__$1 = state_83483;
var ex83490 = (state_83483__$1[(2)]);
var statearr_83497_83513 = state_83483__$1;
(statearr_83497_83513[(5)] = ex83490);


var statearr_83498_83514 = state_83483__$1;
(statearr_83498_83514[(1)] = (4));

(statearr_83498_83514[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83484 === (8))){
var inst_83471 = (state_83483[(2)]);
var inst_83472 = fluree.db.connection_js.check_connection.call(null,conn,inst_83471);
var inst_83473 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83474 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_83473,inst_83471);
var state_83483__$1 = (function (){var statearr_83499 = state_83483;
(statearr_83499[(8)] = inst_83472);

return statearr_83499;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83483__$1,(9),inst_83474);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_83500 = [null,null,null,null,null,null,null,null,null];
(statearr_83500[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_83500[(1)] = (1));

return statearr_83500;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_83483){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83483);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83501){var ex__2749__auto__ = e83501;
var statearr_83502_83515 = state_83483;
(statearr_83502_83515[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83483[(4)]))){
var statearr_83503_83516 = state_83483;
(statearr_83503_83516[(1)] = cljs.core.first.call(null,(state_83483[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83517 = state_83483;
state_83483 = G__83517;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_83483){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_83483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83504 = f__2769__auto__.call(null);
(statearr_83504[(6)] = c__2768__auto__);

return statearr_83504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureenjs.blockRangeWithTxn = (function flureenjs$blockRangeWithTxn(var_args){
var G__83519 = arguments.length;
switch (G__83519) {
case 3:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRangeWithTxn', flureenjs.blockRangeWithTxn);

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.blockRangeWithTxn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83551){
var state_val_83552 = (state_83551[(1)]);
if((state_val_83552 === (1))){
var state_83551__$1 = state_83551;
var statearr_83553_83570 = state_83551__$1;
(statearr_83553_83570[(2)] = null);

(statearr_83553_83570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83552 === (2))){
var inst_83532 = (state_83551[(7)]);
var _ = (function (){var statearr_83554 = state_83551;
(statearr_83554[(4)] = cljs.core.cons.call(null,(5),(state_83551[(4)])));

return statearr_83554;
})();
var inst_83532__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83533 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83534 = cljs.core.__destructure_map.call(null,inst_83533);
var inst_83535 = cljs.core.get.call(null,inst_83534,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_83536 = cljs.core.get.call(null,inst_83534,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_83537 = flureenjs._db_instance.call(null,conn,ledger,inst_83532__$1);
var state_83551__$1 = (function (){var statearr_83555 = state_83551;
(statearr_83555[(8)] = inst_83535);

(statearr_83555[(9)] = inst_83536);

(statearr_83555[(7)] = inst_83532__$1);

return statearr_83555;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83551__$1,(6),inst_83537);
} else {
if((state_val_83552 === (3))){
var inst_83549 = (state_83551[(2)]);
var state_83551__$1 = state_83551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83551__$1,inst_83549);
} else {
if((state_val_83552 === (4))){
var inst_83520 = (state_83551[(2)]);
var inst_83521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83522 = [inst_83520];
var inst_83523 = (new cljs.core.PersistentVector(null,1,(5),inst_83521,inst_83522,null));
var inst_83524 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83523);
var inst_83525 = reject.call(null,inst_83520);
var state_83551__$1 = (function (){var statearr_83557 = state_83551;
(statearr_83557[(10)] = inst_83524);

return statearr_83557;
})();
var statearr_83558_83571 = state_83551__$1;
(statearr_83558_83571[(2)] = inst_83525);

(statearr_83558_83571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83552 === (5))){
var _ = (function (){var statearr_83559 = state_83551;
(statearr_83559[(4)] = cljs.core.rest.call(null,(state_83551[(4)])));

return statearr_83559;
})();
var state_83551__$1 = state_83551;
var ex83556 = (state_83551__$1[(2)]);
var statearr_83560_83572 = state_83551__$1;
(statearr_83560_83572[(5)] = ex83556);


var statearr_83561_83573 = state_83551__$1;
(statearr_83561_83573[(1)] = (4));

(statearr_83561_83573[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83552 === (6))){
var inst_83535 = (state_83551[(8)]);
var inst_83536 = (state_83551[(9)]);
var inst_83532 = (state_83551[(7)]);
var inst_83539 = (state_83551[(2)]);
var inst_83540 = fluree.db.query.block.block_range.call(null,inst_83539,inst_83535,inst_83536,inst_83532);
var state_83551__$1 = state_83551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83551__$1,(7),inst_83540);
} else {
if((state_val_83552 === (7))){
var inst_83542 = (state_83551[(2)]);
var inst_83543 = fluree.db.util.async.throw_err.call(null,inst_83542);
var inst_83544 = fluree.db.query.range.block_with_tx_data.call(null,inst_83543);
var inst_83545 = cljs.core.clj__GT_js.call(null,inst_83544);
var inst_83546 = resolve.call(null,inst_83545);
var _ = (function (){var statearr_83562 = state_83551;
(statearr_83562[(4)] = cljs.core.rest.call(null,(state_83551[(4)])));

return statearr_83562;
})();
var state_83551__$1 = state_83551;
var statearr_83563_83574 = state_83551__$1;
(statearr_83563_83574[(2)] = inst_83546);

(statearr_83563_83574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_83564 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_83564[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_83564[(1)] = (1));

return statearr_83564;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_83551){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83565){var ex__2749__auto__ = e83565;
var statearr_83566_83575 = state_83551;
(statearr_83566_83575[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83551[(4)]))){
var statearr_83567_83576 = state_83551;
(statearr_83567_83576[(1)] = cljs.core.first.call(null,(state_83551[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83577 = state_83551;
state_83551 = G__83577;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_83551){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_83551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83568 = f__2769__auto__.call(null);
(statearr_83568[(6)] = c__2768__auto__);

return statearr_83568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.blockRangeWithTxn.cljs$lang$maxFixedArity = 4);

flureenjs.blockQuery = (function flureenjs$blockQuery(var_args){
var G__83579 = arguments.length;
switch (G__83579) {
case 3:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockQuery', flureenjs.blockQuery);

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.blockQuery.call(null,conn,ledger,query_map,null);
}));

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83640){
var state_val_83641 = (state_83640[(1)]);
if((state_val_83641 === (7))){
var state_83640__$1 = state_83640;
var statearr_83642_83683 = state_83640__$1;
(statearr_83642_83683[(2)] = null);

(statearr_83642_83683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (20))){
var inst_83619 = (state_83640[(2)]);
var state_83640__$1 = state_83640;
var statearr_83643_83684 = state_83640__$1;
(statearr_83643_83684[(2)] = inst_83619);

(statearr_83643_83684[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (1))){
var state_83640__$1 = state_83640;
var statearr_83644_83685 = state_83640__$1;
(statearr_83644_83685[(2)] = null);

(statearr_83644_83685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (4))){
var inst_83580 = (state_83640[(2)]);
var inst_83581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83582 = [inst_83580];
var inst_83583 = (new cljs.core.PersistentVector(null,1,(5),inst_83581,inst_83582,null));
var inst_83584 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83583);
var inst_83585 = reject.call(null,inst_83580);
var state_83640__$1 = (function (){var statearr_83645 = state_83640;
(statearr_83645[(7)] = inst_83584);

return statearr_83645;
})();
var statearr_83646_83686 = state_83640__$1;
(statearr_83646_83686[(2)] = inst_83585);

(statearr_83646_83686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (15))){
var state_83640__$1 = state_83640;
var statearr_83647_83687 = state_83640__$1;
(statearr_83647_83687[(2)] = null);

(statearr_83647_83687[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (21))){
var inst_83632 = (state_83640[(2)]);
var inst_83633 = fluree.db.util.async.throw_err.call(null,inst_83632);
var inst_83634 = cljs.core.clj__GT_js.call(null,inst_83633);
var inst_83635 = resolve.call(null,inst_83634);
var _ = (function (){var statearr_83648 = state_83640;
(statearr_83648[(4)] = cljs.core.rest.call(null,(state_83640[(4)])));

return statearr_83648;
})();
var state_83640__$1 = state_83640;
var statearr_83649_83688 = state_83640__$1;
(statearr_83649_83688[(2)] = inst_83635);

(statearr_83649_83688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (13))){
var inst_83607 = (state_83640[(8)]);
var inst_83598 = (state_83640[(9)]);
var inst_83607__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_83598);
var inst_83608 = (inst_83607__$1 == null);
var state_83640__$1 = (function (){var statearr_83650 = state_83640;
(statearr_83650[(8)] = inst_83607__$1);

return statearr_83650;
})();
if(cljs.core.truth_(inst_83608)){
var statearr_83651_83689 = state_83640__$1;
(statearr_83651_83689[(1)] = (15));

} else {
var statearr_83652_83690 = state_83640__$1;
(statearr_83652_83690[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (6))){
var inst_83594 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_83640__$1 = state_83640;
var statearr_83653_83691 = state_83640__$1;
(statearr_83653_83691[(2)] = inst_83594);

(statearr_83653_83691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (17))){
var inst_83613 = (state_83640[(10)]);
var inst_83613__$1 = (state_83640[(2)]);
var inst_83614 = (inst_83613__$1 == null);
var state_83640__$1 = (function (){var statearr_83654 = state_83640;
(statearr_83654[(10)] = inst_83613__$1);

return statearr_83654;
})();
if(cljs.core.truth_(inst_83614)){
var statearr_83655_83692 = state_83640__$1;
(statearr_83655_83692[(1)] = (18));

} else {
var statearr_83656_83693 = state_83640__$1;
(statearr_83656_83693[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (3))){
var inst_83638 = (state_83640[(2)]);
var state_83640__$1 = state_83640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83640__$1,inst_83638);
} else {
if((state_val_83641 === (12))){
var inst_83603 = (state_83640[(11)]);
var state_83640__$1 = state_83640;
var statearr_83657_83694 = state_83640__$1;
(statearr_83657_83694[(2)] = inst_83603);

(statearr_83657_83694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (2))){
var inst_83591 = (state_83640[(12)]);
var _ = (function (){var statearr_83658 = state_83640;
(statearr_83658[(4)] = cljs.core.cons.call(null,(5),(state_83640[(4)])));

return statearr_83658;
})();
var inst_83591__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83592 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_83591__$1);
var state_83640__$1 = (function (){var statearr_83659 = state_83640;
(statearr_83659[(12)] = inst_83591__$1);

(statearr_83659[(13)] = inst_83592);

return statearr_83659;
})();
if(cljs.core.truth_(opts)){
var statearr_83660_83695 = state_83640__$1;
(statearr_83660_83695[(1)] = (6));

} else {
var statearr_83661_83696 = state_83640__$1;
(statearr_83661_83696[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (19))){
var inst_83613 = (state_83640[(10)]);
var inst_83617 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_83613);
var state_83640__$1 = state_83640;
var statearr_83662_83697 = state_83640__$1;
(statearr_83662_83697[(2)] = inst_83617);

(statearr_83662_83697[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (11))){
var inst_83591 = (state_83640[(12)]);
var inst_83598 = (state_83640[(9)]);
var inst_83623 = (state_83640[(2)]);
var inst_83624 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_83625 = [inst_83623];
var inst_83626 = cljs.core.PersistentHashMap.fromArrays(inst_83624,inst_83625);
var inst_83627 = fluree.db.util.core.without_nils.call(null,inst_83626);
var inst_83628 = cljs.core.merge.call(null,inst_83598,inst_83627);
var inst_83629 = cljs.core.update.call(null,inst_83591,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_83628);
var inst_83630 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_83629);
var state_83640__$1 = state_83640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83640__$1,(21),inst_83630);
} else {
if((state_val_83641 === (9))){
var inst_83600 = (state_83640[(14)]);
var state_83640__$1 = state_83640;
var statearr_83664_83698 = state_83640__$1;
(statearr_83664_83698[(2)] = inst_83600);

(statearr_83664_83698[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (5))){
var _ = (function (){var statearr_83665 = state_83640;
(statearr_83665[(4)] = cljs.core.rest.call(null,(state_83640[(4)])));

return statearr_83665;
})();
var state_83640__$1 = state_83640;
var ex83663 = (state_83640__$1[(2)]);
var statearr_83666_83699 = state_83640__$1;
(statearr_83666_83699[(5)] = ex83663);


var statearr_83667_83700 = state_83640__$1;
(statearr_83667_83700[(1)] = (4));

(statearr_83667_83700[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (14))){
var inst_83621 = (state_83640[(2)]);
var state_83640__$1 = state_83640;
var statearr_83668_83701 = state_83640__$1;
(statearr_83668_83701[(2)] = inst_83621);

(statearr_83668_83701[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (16))){
var inst_83607 = (state_83640[(8)]);
var inst_83611 = fluree.db.connection_js.validate_token.call(null,conn,inst_83607);
var state_83640__$1 = state_83640;
var statearr_83669_83702 = state_83640__$1;
(statearr_83669_83702[(2)] = inst_83611);

(statearr_83669_83702[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (10))){
var inst_83598 = (state_83640[(9)]);
var inst_83603 = (state_83640[(11)]);
var inst_83603__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_83598);
var state_83640__$1 = (function (){var statearr_83670 = state_83640;
(statearr_83670[(11)] = inst_83603__$1);

return statearr_83670;
})();
if(cljs.core.truth_(inst_83603__$1)){
var statearr_83671_83703 = state_83640__$1;
(statearr_83671_83703[(1)] = (12));

} else {
var statearr_83672_83704 = state_83640__$1;
(statearr_83672_83704[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (18))){
var state_83640__$1 = state_83640;
var statearr_83673_83705 = state_83640__$1;
(statearr_83673_83705[(2)] = null);

(statearr_83673_83705[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83641 === (8))){
var inst_83600 = (state_83640[(14)]);
var inst_83592 = (state_83640[(13)]);
var inst_83598 = (state_83640[(9)]);
var inst_83597 = (state_83640[(2)]);
var inst_83598__$1 = cljs.core.merge.call(null,inst_83592,inst_83597);
var inst_83599 = fluree.db.connection_js.check_connection.call(null,conn,inst_83598__$1);
var inst_83600__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_83598__$1);
var state_83640__$1 = (function (){var statearr_83674 = state_83640;
(statearr_83674[(14)] = inst_83600__$1);

(statearr_83674[(15)] = inst_83599);

(statearr_83674[(9)] = inst_83598__$1);

return statearr_83674;
})();
if(cljs.core.truth_(inst_83600__$1)){
var statearr_83675_83706 = state_83640__$1;
(statearr_83675_83706[(1)] = (9));

} else {
var statearr_83676_83707 = state_83640__$1;
(statearr_83676_83707[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_83677 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83677[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_83677[(1)] = (1));

return statearr_83677;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_83640){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83678){var ex__2749__auto__ = e83678;
var statearr_83679_83708 = state_83640;
(statearr_83679_83708[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83640[(4)]))){
var statearr_83680_83709 = state_83640;
(statearr_83680_83709[(1)] = cljs.core.first.call(null,(state_83640[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83710 = state_83640;
state_83640 = G__83710;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_83640){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_83640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83681 = f__2769__auto__.call(null);
(statearr_83681[(6)] = c__2768__auto__);

return statearr_83681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.blockQuery.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 *     to end if provided (exclusive).
 * 
 *     Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.blockRange = (function flureenjs$blockRange(var_args){
var G__83712 = arguments.length;
switch (G__83712) {
case 2:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRange', flureenjs.blockRange);

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.blockRange.call(null,db,start,null,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.blockRange.call(null,db,start,end,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83739){
var state_val_83740 = (state_83739[(1)]);
if((state_val_83740 === (1))){
var state_83739__$1 = state_83739;
var statearr_83741_83758 = state_83739__$1;
(statearr_83741_83758[(2)] = null);

(statearr_83741_83758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83740 === (2))){
var _ = (function (){var statearr_83742 = state_83739;
(statearr_83742[(4)] = cljs.core.cons.call(null,(5),(state_83739[(4)])));

return statearr_83742;
})();
var inst_83724 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_83739__$1 = (function (){var statearr_83743 = state_83739;
(statearr_83743[(7)] = inst_83724);

return statearr_83743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83739__$1,(7),db);
} else {
if((state_val_83740 === (3))){
var inst_83737 = (state_83739[(2)]);
var state_83739__$1 = state_83739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83739__$1,inst_83737);
} else {
if((state_val_83740 === (4))){
var inst_83713 = (state_83739[(2)]);
var inst_83714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83715 = [inst_83713];
var inst_83716 = (new cljs.core.PersistentVector(null,1,(5),inst_83714,inst_83715,null));
var inst_83717 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83716);
var inst_83718 = reject.call(null,inst_83713);
var state_83739__$1 = (function (){var statearr_83745 = state_83739;
(statearr_83745[(8)] = inst_83717);

return statearr_83745;
})();
var statearr_83746_83759 = state_83739__$1;
(statearr_83746_83759[(2)] = inst_83718);

(statearr_83746_83759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83740 === (5))){
var _ = (function (){var statearr_83747 = state_83739;
(statearr_83747[(4)] = cljs.core.rest.call(null,(state_83739[(4)])));

return statearr_83747;
})();
var state_83739__$1 = state_83739;
var ex83744 = (state_83739__$1[(2)]);
var statearr_83748_83760 = state_83739__$1;
(statearr_83748_83760[(5)] = ex83744);


var statearr_83749_83761 = state_83739__$1;
(statearr_83749_83761[(1)] = (4));

(statearr_83749_83761[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83740 === (6))){
var inst_83730 = (state_83739[(2)]);
var inst_83731 = fluree.db.util.async.throw_err.call(null,inst_83730);
var inst_83732 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_83731);
var inst_83733 = cljs.core.clj__GT_js.call(null,inst_83732);
var inst_83734 = resolve.call(null,inst_83733);
var _ = (function (){var statearr_83750 = state_83739;
(statearr_83750[(4)] = cljs.core.rest.call(null,(state_83739[(4)])));

return statearr_83750;
})();
var state_83739__$1 = state_83739;
var statearr_83751_83762 = state_83739__$1;
(statearr_83751_83762[(2)] = inst_83734);

(statearr_83751_83762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83740 === (7))){
var inst_83724 = (state_83739[(7)]);
var inst_83726 = (state_83739[(2)]);
var inst_83727 = fluree.db.util.async.throw_err.call(null,inst_83726);
var inst_83728 = fluree.db.query.block.block_range.call(null,inst_83727,start,end,inst_83724);
var state_83739__$1 = state_83739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83739__$1,(6),inst_83728);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_83752 = [null,null,null,null,null,null,null,null,null];
(statearr_83752[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_83752[(1)] = (1));

return statearr_83752;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_83739){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83753){var ex__2749__auto__ = e83753;
var statearr_83754_83763 = state_83739;
(statearr_83754_83763[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83739[(4)]))){
var statearr_83755_83764 = state_83739;
(statearr_83755_83764[(1)] = cljs.core.first.call(null,(state_83739[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83765 = state_83739;
state_83739 = G__83765;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_83739){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_83739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83756 = f__2769__auto__.call(null);
(statearr_83756[(6)] = c__2768__auto__);

return statearr_83756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.blockRange.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collectionFlakes = (function flureenjs$collectionFlakes(db,collection){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83791){
var state_val_83792 = (state_83791[(1)]);
if((state_val_83792 === (1))){
var state_83791__$1 = state_83791;
var statearr_83793_83808 = state_83791__$1;
(statearr_83793_83808[(2)] = null);

(statearr_83793_83808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83792 === (2))){
var _ = (function (){var statearr_83794 = state_83791;
(statearr_83794[(4)] = cljs.core.cons.call(null,(5),(state_83791[(4)])));

return statearr_83794;
})();
var state_83791__$1 = state_83791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83791__$1,(7),db);
} else {
if((state_val_83792 === (3))){
var inst_83789 = (state_83791[(2)]);
var state_83791__$1 = state_83791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83791__$1,inst_83789);
} else {
if((state_val_83792 === (4))){
var inst_83766 = (state_83791[(2)]);
var inst_83767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83768 = [inst_83766];
var inst_83769 = (new cljs.core.PersistentVector(null,1,(5),inst_83767,inst_83768,null));
var inst_83770 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83769);
var inst_83771 = reject.call(null,inst_83766);
var state_83791__$1 = (function (){var statearr_83796 = state_83791;
(statearr_83796[(7)] = inst_83770);

return statearr_83796;
})();
var statearr_83797_83809 = state_83791__$1;
(statearr_83797_83809[(2)] = inst_83771);

(statearr_83797_83809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83792 === (5))){
var _ = (function (){var statearr_83798 = state_83791;
(statearr_83798[(4)] = cljs.core.rest.call(null,(state_83791[(4)])));

return statearr_83798;
})();
var state_83791__$1 = state_83791;
var ex83795 = (state_83791__$1[(2)]);
var statearr_83799_83810 = state_83791__$1;
(statearr_83799_83810[(5)] = ex83795);


var statearr_83800_83811 = state_83791__$1;
(statearr_83800_83811[(1)] = (4));

(statearr_83800_83811[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83792 === (6))){
var inst_83782 = (state_83791[(2)]);
var inst_83783 = fluree.db.util.async.throw_err.call(null,inst_83782);
var inst_83784 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_83783);
var inst_83785 = cljs.core.clj__GT_js.call(null,inst_83784);
var inst_83786 = resolve.call(null,inst_83785);
var _ = (function (){var statearr_83801 = state_83791;
(statearr_83801[(4)] = cljs.core.rest.call(null,(state_83791[(4)])));

return statearr_83801;
})();
var state_83791__$1 = state_83791;
var statearr_83802_83812 = state_83791__$1;
(statearr_83802_83812[(2)] = inst_83786);

(statearr_83802_83812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83792 === (7))){
var inst_83778 = (state_83791[(2)]);
var inst_83779 = fluree.db.util.async.throw_err.call(null,inst_83778);
var inst_83780 = fluree.db.query.range.collection.call(null,inst_83779,collection);
var state_83791__$1 = state_83791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83791__$1,(6),inst_83780);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionFlakes_$_state_machine__2746__auto__ = null;
var flureenjs$collectionFlakes_$_state_machine__2746__auto____0 = (function (){
var statearr_83803 = [null,null,null,null,null,null,null,null];
(statearr_83803[(0)] = flureenjs$collectionFlakes_$_state_machine__2746__auto__);

(statearr_83803[(1)] = (1));

return statearr_83803;
});
var flureenjs$collectionFlakes_$_state_machine__2746__auto____1 = (function (state_83791){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83804){var ex__2749__auto__ = e83804;
var statearr_83805_83813 = state_83791;
(statearr_83805_83813[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83791[(4)]))){
var statearr_83806_83814 = state_83791;
(statearr_83806_83814[(1)] = cljs.core.first.call(null,(state_83791[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83815 = state_83791;
state_83791 = G__83815;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$collectionFlakes_$_state_machine__2746__auto__ = function(state_83791){
switch(arguments.length){
case 0:
return flureenjs$collectionFlakes_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$collectionFlakes_$_state_machine__2746__auto____1.call(this,state_83791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionFlakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionFlakes_$_state_machine__2746__auto____0;
flureenjs$collectionFlakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionFlakes_$_state_machine__2746__auto____1;
return flureenjs$collectionFlakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83807 = f__2769__auto__.call(null);
(statearr_83807[(6)] = c__2768__auto__);

return statearr_83807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionFlakes', flureenjs.collectionFlakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__83817 = arguments.length;
switch (G__83817) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_83922){
var state_val_83923 = (state_83922[(1)]);
if((state_val_83923 === (7))){
var state_83922__$1 = state_83922;
var statearr_83924_83976 = state_83922__$1;
(statearr_83924_83976[(2)] = null);

(statearr_83924_83976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (20))){
var inst_83839 = (state_83922[(7)]);
var inst_83850 = (state_83922[(8)]);
var inst_83846 = (state_83922[(9)]);
var inst_83871 = cljs.core.dissoc.call(null,inst_83850,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_83872 = cljs.core.assoc.call(null,inst_83871,new cljs.core.Keyword(null,"opts","opts",155075701),inst_83839);
var inst_83873 = fluree.db.api.query.history_query_async.call(null,inst_83846,inst_83872);
var state_83922__$1 = state_83922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83922__$1,(23),inst_83873);
} else {
if((state_val_83923 === (27))){
var inst_83885 = (state_83922[(2)]);
var inst_83886 = fluree.db.util.async.throw_err.call(null,inst_83885);
var state_83922__$1 = state_83922;
var statearr_83925_83977 = state_83922__$1;
(statearr_83925_83977[(2)] = inst_83886);

(statearr_83925_83977[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (1))){
var state_83922__$1 = state_83922;
var statearr_83926_83978 = state_83922__$1;
(statearr_83926_83978[(2)] = null);

(statearr_83926_83978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (24))){
var inst_83839 = (state_83922[(7)]);
var inst_83850 = (state_83922[(8)]);
var inst_83881 = cljs.core.dissoc.call(null,inst_83850,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_83882 = cljs.core.assoc.call(null,inst_83881,new cljs.core.Keyword(null,"opts","opts",155075701),inst_83839);
var inst_83883 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_83882);
var state_83922__$1 = state_83922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83922__$1,(27),inst_83883);
} else {
if((state_val_83923 === (4))){
var inst_83818 = (state_83922[(2)]);
var inst_83819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83820 = [inst_83818];
var inst_83821 = (new cljs.core.PersistentVector(null,1,(5),inst_83819,inst_83820,null));
var inst_83822 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_83821);
var inst_83823 = cljs.core.clj__GT_js.call(null,inst_83818);
var inst_83824 = reject.call(null,inst_83823);
var state_83922__$1 = (function (){var statearr_83927 = state_83922;
(statearr_83927[(10)] = inst_83822);

return statearr_83927;
})();
var statearr_83928_83979 = state_83922__$1;
(statearr_83928_83979[(2)] = inst_83824);

(statearr_83928_83979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (15))){
var inst_83850 = (state_83922[(8)]);
var inst_83868 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_83850);
var inst_83869 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_83868);
var state_83922__$1 = state_83922;
if(inst_83869){
var statearr_83929_83980 = state_83922__$1;
(statearr_83929_83980[(1)] = (20));

} else {
var statearr_83930_83981 = state_83922__$1;
(statearr_83930_83981[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (21))){
var inst_83850 = (state_83922[(8)]);
var inst_83878 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_83850);
var inst_83879 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_83878);
var state_83922__$1 = state_83922;
if(inst_83879){
var statearr_83931_83982 = state_83922__$1;
(statearr_83931_83982[(1)] = (24));

} else {
var statearr_83932_83983 = state_83922__$1;
(statearr_83932_83983[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (31))){
var inst_83893 = (state_83922[(2)]);
var inst_83894 = fluree.db.util.async.throw_err.call(null,inst_83893);
var state_83922__$1 = state_83922;
var statearr_83933_83984 = state_83922__$1;
(statearr_83933_83984[(2)] = inst_83894);

(statearr_83933_83984[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (32))){
var inst_83843 = (state_83922[(11)]);
var inst_83839 = (state_83922[(7)]);
var inst_83850 = (state_83922[(8)]);
var inst_83897 = cljs.core.dissoc.call(null,inst_83850,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_83898 = cljs.core.assoc.call(null,inst_83897,new cljs.core.Keyword(null,"opts","opts",155075701),inst_83839);
var inst_83899 = fluree.db.api.query.multi_query_async.call(null,inst_83843,inst_83898);
var state_83922__$1 = state_83922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83922__$1,(35),inst_83899);
} else {
if((state_val_83923 === (33))){
var state_83922__$1 = state_83922;
var statearr_83934_83985 = state_83922__$1;
(statearr_83934_83985[(2)] = null);

(statearr_83934_83985[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (13))){
var inst_83915 = (state_83922[(2)]);
var inst_83916 = cljs.core.clj__GT_js.call(null,inst_83915);
var inst_83917 = resolve.call(null,inst_83916);
var _ = (function (){var statearr_83935 = state_83922;
(statearr_83935[(4)] = cljs.core.rest.call(null,(state_83922[(4)])));

return statearr_83935;
})();
var state_83922__$1 = state_83922;
var statearr_83936_83986 = state_83922__$1;
(statearr_83936_83986[(2)] = inst_83917);

(statearr_83936_83986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (22))){
var inst_83911 = (state_83922[(2)]);
var state_83922__$1 = state_83922;
var statearr_83937_83987 = state_83922__$1;
(statearr_83937_83987[(2)] = inst_83911);

(statearr_83937_83987[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (29))){
var state_83922__$1 = state_83922;
var statearr_83938_83988 = state_83922__$1;
(statearr_83938_83988[(1)] = (32));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (6))){
var inst_83835 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_83922__$1 = state_83922;
var statearr_83940_83989 = state_83922__$1;
(statearr_83940_83989[(2)] = inst_83835);

(statearr_83940_83989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (28))){
var inst_83839 = (state_83922[(7)]);
var inst_83850 = (state_83922[(8)]);
var inst_83890 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_83850);
var inst_83891 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_83890,inst_83839);
var state_83922__$1 = state_83922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83922__$1,(31),inst_83891);
} else {
if((state_val_83923 === (25))){
var inst_83850 = (state_83922[(8)]);
var inst_83888 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_83850);
var state_83922__$1 = state_83922;
if(cljs.core.truth_(inst_83888)){
var statearr_83941_83990 = state_83922__$1;
(statearr_83941_83990[(1)] = (28));

} else {
var statearr_83942_83991 = state_83922__$1;
(statearr_83942_83991[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (34))){
var inst_83905 = (state_83922[(2)]);
var state_83922__$1 = state_83922;
var statearr_83943_83992 = state_83922__$1;
(statearr_83943_83992[(2)] = inst_83905);

(statearr_83943_83992[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (17))){
var inst_83850 = (state_83922[(8)]);
var inst_83862 = cljs.core.dissoc.call(null,inst_83850,new cljs.core.Keyword(null,"type","type",1174270348));
var state_83922__$1 = state_83922;
var statearr_83944_83993 = state_83922__$1;
(statearr_83944_83993[(2)] = inst_83862);

(statearr_83944_83993[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (3))){
var inst_83920 = (state_83922[(2)]);
var state_83922__$1 = state_83922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_83922__$1,inst_83920);
} else {
if((state_val_83923 === (12))){
var inst_83850 = (state_83922[(8)]);
var inst_83854 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_83855 = (new cljs.core.PersistentArrayMap(null,2,inst_83854,null));
var inst_83856 = (new cljs.core.PersistentHashSet(null,inst_83855,null));
var inst_83857 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_83850);
var inst_83858 = inst_83856.call(null,inst_83857);
var state_83922__$1 = state_83922;
if(cljs.core.truth_(inst_83858)){
var statearr_83945_83994 = state_83922__$1;
(statearr_83945_83994[(1)] = (14));

} else {
var statearr_83946_83995 = state_83922__$1;
(statearr_83946_83995[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (2))){
var inst_83832 = (state_83922[(12)]);
var _ = (function (){var statearr_83947 = state_83922;
(statearr_83947[(4)] = cljs.core.cons.call(null,(5),(state_83922[(4)])));

return statearr_83947;
})();
var inst_83831 = fluree.db.util.json.parse.call(null,param);
var inst_83832__$1 = cljs.core.js__GT_clj.call(null,inst_83831,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_83833 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_83832__$1);
var state_83922__$1 = (function (){var statearr_83948 = state_83922;
(statearr_83948[(13)] = inst_83833);

(statearr_83948[(12)] = inst_83832__$1);

return statearr_83948;
})();
if(cljs.core.truth_(opts)){
var statearr_83949_83996 = state_83922__$1;
(statearr_83949_83996[(1)] = (6));

} else {
var statearr_83950_83997 = state_83922__$1;
(statearr_83950_83997[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (23))){
var inst_83875 = (state_83922[(2)]);
var inst_83876 = fluree.db.util.async.throw_err.call(null,inst_83875);
var state_83922__$1 = state_83922;
var statearr_83951_83998 = state_83922__$1;
(statearr_83951_83998[(2)] = inst_83876);

(statearr_83951_83998[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (35))){
var inst_83901 = (state_83922[(2)]);
var inst_83902 = fluree.db.util.async.throw_err.call(null,inst_83901);
var state_83922__$1 = state_83922;
var statearr_83952_83999 = state_83922__$1;
(statearr_83952_83999[(2)] = inst_83902);

(statearr_83952_83999[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (19))){
var inst_83866 = (state_83922[(2)]);
var state_83922__$1 = state_83922;
var statearr_83953_84000 = state_83922__$1;
(statearr_83953_84000[(2)] = inst_83866);

(statearr_83953_84000[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (11))){
var inst_83850 = (state_83922[(8)]);
var state_83922__$1 = state_83922;
var statearr_83955_84001 = state_83922__$1;
(statearr_83955_84001[(2)] = inst_83850);

(statearr_83955_84001[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (9))){
var inst_83842 = (state_83922[(14)]);
var inst_83841 = (state_83922[(15)]);
var inst_83839 = (state_83922[(7)]);
var inst_83846 = (state_83922[(9)]);
var inst_83845 = (state_83922[(2)]);
var inst_83846__$1 = fluree.db.util.async.throw_err.call(null,inst_83845);
var inst_83847 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_83846__$1,inst_83841,inst_83842,inst_83839);
var state_83922__$1 = (function (){var statearr_83956 = state_83922;
(statearr_83956[(9)] = inst_83846__$1);

return statearr_83956;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83922__$1,(10),inst_83847);
} else {
if((state_val_83923 === (5))){
var _ = (function (){var statearr_83957 = state_83922;
(statearr_83957[(4)] = cljs.core.rest.call(null,(state_83922[(4)])));

return statearr_83957;
})();
var state_83922__$1 = state_83922;
var ex83954 = (state_83922__$1[(2)]);
var statearr_83958_84002 = state_83922__$1;
(statearr_83958_84002[(5)] = ex83954);


var statearr_83959_84003 = state_83922__$1;
(statearr_83959_84003[(1)] = (4));

(statearr_83959_84003[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (14))){
var inst_83839 = (state_83922[(7)]);
var inst_83860 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_83839);
var state_83922__$1 = state_83922;
if(cljs.core.truth_(inst_83860)){
var statearr_83960_84004 = state_83922__$1;
(statearr_83960_84004[(1)] = (17));

} else {
var statearr_83961_84005 = state_83922__$1;
(statearr_83961_84005[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (26))){
var inst_83909 = (state_83922[(2)]);
var state_83922__$1 = state_83922;
var statearr_83962_84006 = state_83922__$1;
(statearr_83962_84006[(2)] = inst_83909);

(statearr_83962_84006[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (16))){
var inst_83913 = (state_83922[(2)]);
var state_83922__$1 = state_83922;
var statearr_83963_84007 = state_83922__$1;
(statearr_83963_84007[(2)] = inst_83913);

(statearr_83963_84007[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (30))){
var inst_83907 = (state_83922[(2)]);
var state_83922__$1 = state_83922;
var statearr_83964_84008 = state_83922__$1;
(statearr_83964_84008[(2)] = inst_83907);

(statearr_83964_84008[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (10))){
var inst_83850 = (state_83922[(8)]);
var inst_83849 = (state_83922[(2)]);
var inst_83850__$1 = fluree.db.util.async.throw_err.call(null,inst_83849);
var inst_83851 = fluree.db.util.core.exception_QMARK_.call(null,inst_83850__$1);
var state_83922__$1 = (function (){var statearr_83965 = state_83922;
(statearr_83965[(8)] = inst_83850__$1);

return statearr_83965;
})();
if(inst_83851){
var statearr_83966_84009 = state_83922__$1;
(statearr_83966_84009[(1)] = (11));

} else {
var statearr_83967_84010 = state_83922__$1;
(statearr_83967_84010[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (18))){
var inst_83850 = (state_83922[(8)]);
var inst_83864 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_83850);
var state_83922__$1 = state_83922;
var statearr_83968_84011 = state_83922__$1;
(statearr_83968_84011[(2)] = inst_83864);

(statearr_83968_84011[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83923 === (8))){
var inst_83833 = (state_83922[(13)]);
var inst_83832 = (state_83922[(12)]);
var inst_83843 = (state_83922[(11)]);
var inst_83839 = (state_83922[(7)]);
var inst_83838 = (state_83922[(2)]);
var inst_83839__$1 = cljs.core.merge.call(null,inst_83833,inst_83838);
var inst_83840 = cljs.core.__destructure_map.call(null,inst_83832);
var inst_83841 = cljs.core.get.call(null,inst_83840,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_83842 = cljs.core.get.call(null,inst_83840,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_83843__$1 = flureenjs._db_instance.call(null,conn,ledger,inst_83839__$1);
var state_83922__$1 = (function (){var statearr_83969 = state_83922;
(statearr_83969[(14)] = inst_83842);

(statearr_83969[(11)] = inst_83843__$1);

(statearr_83969[(15)] = inst_83841);

(statearr_83969[(7)] = inst_83839__$1);

return statearr_83969;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_83922__$1,(9),inst_83843__$1);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_83970 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83970[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_83970[(1)] = (1));

return statearr_83970;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_83922){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_83922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e83971){var ex__2749__auto__ = e83971;
var statearr_83972_84012 = state_83922;
(statearr_83972_84012[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_83922[(4)]))){
var statearr_83973_84013 = state_83922;
(statearr_83973_84013[(1)] = cljs.core.first.call(null,(state_83922[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84014 = state_83922;
state_83922 = G__84014;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_83922){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_83922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_83974 = f__2769__auto__.call(null);
(statearr_83974[(6)] = c__2768__auto__);

return statearr_83974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.historyQuery = (function flureenjs$historyQuery(var_args){
var G__84016 = arguments.length;
switch (G__84016) {
case 2:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.historyQuery', flureenjs.historyQuery);

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.historyQuery.call(null,sources,query_map,null);
}));

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_84046){
var state_val_84047 = (state_84046[(1)]);
if((state_val_84047 === (1))){
var state_84046__$1 = state_84046;
var statearr_84048_84064 = state_84046__$1;
(statearr_84048_84064[(2)] = null);

(statearr_84048_84064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84047 === (2))){
var _ = (function (){var statearr_84049 = state_84046;
(statearr_84049[(4)] = cljs.core.cons.call(null,(5),(state_84046[(4)])));

return statearr_84049;
})();
var inst_84028 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84029 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_84028);
var inst_84030 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84031 = cljs.core.merge.call(null,inst_84029,inst_84030);
var inst_84032 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_84033 = [inst_84031];
var inst_84034 = cljs.core.PersistentHashMap.fromArrays(inst_84032,inst_84033);
var inst_84035 = cljs.core.merge.call(null,inst_84028,inst_84034);
var inst_84036 = fluree.db.api.query.history_query_async.call(null,sources,inst_84035);
var state_84046__$1 = state_84046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84046__$1,(6),inst_84036);
} else {
if((state_val_84047 === (3))){
var inst_84044 = (state_84046[(2)]);
var state_84046__$1 = state_84046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84046__$1,inst_84044);
} else {
if((state_val_84047 === (4))){
var inst_84017 = (state_84046[(2)]);
var inst_84018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84019 = [inst_84017];
var inst_84020 = (new cljs.core.PersistentVector(null,1,(5),inst_84018,inst_84019,null));
var inst_84021 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_84020);
var inst_84022 = reject.call(null,inst_84017);
var state_84046__$1 = (function (){var statearr_84051 = state_84046;
(statearr_84051[(7)] = inst_84021);

return statearr_84051;
})();
var statearr_84052_84065 = state_84046__$1;
(statearr_84052_84065[(2)] = inst_84022);

(statearr_84052_84065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84047 === (5))){
var _ = (function (){var statearr_84053 = state_84046;
(statearr_84053[(4)] = cljs.core.rest.call(null,(state_84046[(4)])));

return statearr_84053;
})();
var state_84046__$1 = state_84046;
var ex84050 = (state_84046__$1[(2)]);
var statearr_84054_84066 = state_84046__$1;
(statearr_84054_84066[(5)] = ex84050);


var statearr_84055_84067 = state_84046__$1;
(statearr_84055_84067[(1)] = (4));

(statearr_84055_84067[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84047 === (6))){
var inst_84038 = (state_84046[(2)]);
var inst_84039 = fluree.db.util.async.throw_err.call(null,inst_84038);
var inst_84040 = cljs.core.clj__GT_js.call(null,inst_84039);
var inst_84041 = resolve.call(null,inst_84040);
var _ = (function (){var statearr_84056 = state_84046;
(statearr_84056[(4)] = cljs.core.rest.call(null,(state_84046[(4)])));

return statearr_84056;
})();
var state_84046__$1 = state_84046;
var statearr_84057_84068 = state_84046__$1;
(statearr_84057_84068[(2)] = inst_84041);

(statearr_84057_84068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_84058 = [null,null,null,null,null,null,null,null];
(statearr_84058[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_84058[(1)] = (1));

return statearr_84058;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_84046){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_84046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e84059){var ex__2749__auto__ = e84059;
var statearr_84060_84069 = state_84046;
(statearr_84060_84069[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_84046[(4)]))){
var statearr_84061_84070 = state_84046;
(statearr_84061_84070[(1)] = cljs.core.first.call(null,(state_84046[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84071 = state_84046;
state_84046 = G__84071;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_84046){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_84046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_84062 = f__2769__auto__.call(null);
(statearr_84062[(6)] = c__2768__auto__);

return statearr_84062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.historyQuery.cljs$lang$maxFixedArity = 3);

flureenjs.multiQuery = (function flureenjs$multiQuery(var_args){
var G__84073 = arguments.length;
switch (G__84073) {
case 2:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multiQuery', flureenjs.multiQuery);

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multiQuery.call(null,source,multi_query_map,null);
}));

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_84103){
var state_val_84104 = (state_84103[(1)]);
if((state_val_84104 === (1))){
var state_84103__$1 = state_84103;
var statearr_84105_84121 = state_84103__$1;
(statearr_84105_84121[(2)] = null);

(statearr_84105_84121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84104 === (2))){
var _ = (function (){var statearr_84106 = state_84103;
(statearr_84106[(4)] = cljs.core.cons.call(null,(5),(state_84103[(4)])));

return statearr_84106;
})();
var inst_84085 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84086 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_84085);
var inst_84087 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84088 = cljs.core.merge.call(null,inst_84086,inst_84087);
var inst_84089 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_84090 = [inst_84088];
var inst_84091 = cljs.core.PersistentHashMap.fromArrays(inst_84089,inst_84090);
var inst_84092 = cljs.core.merge.call(null,inst_84085,inst_84091);
var inst_84093 = fluree.db.api.query.multi_query_async.call(null,source,inst_84092);
var state_84103__$1 = state_84103;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84103__$1,(6),inst_84093);
} else {
if((state_val_84104 === (3))){
var inst_84101 = (state_84103[(2)]);
var state_84103__$1 = state_84103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84103__$1,inst_84101);
} else {
if((state_val_84104 === (4))){
var inst_84074 = (state_84103[(2)]);
var inst_84075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84076 = [inst_84074];
var inst_84077 = (new cljs.core.PersistentVector(null,1,(5),inst_84075,inst_84076,null));
var inst_84078 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_84077);
var inst_84079 = reject.call(null,inst_84074);
var state_84103__$1 = (function (){var statearr_84108 = state_84103;
(statearr_84108[(7)] = inst_84078);

return statearr_84108;
})();
var statearr_84109_84122 = state_84103__$1;
(statearr_84109_84122[(2)] = inst_84079);

(statearr_84109_84122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84104 === (5))){
var _ = (function (){var statearr_84110 = state_84103;
(statearr_84110[(4)] = cljs.core.rest.call(null,(state_84103[(4)])));

return statearr_84110;
})();
var state_84103__$1 = state_84103;
var ex84107 = (state_84103__$1[(2)]);
var statearr_84111_84123 = state_84103__$1;
(statearr_84111_84123[(5)] = ex84107);


var statearr_84112_84124 = state_84103__$1;
(statearr_84112_84124[(1)] = (4));

(statearr_84112_84124[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84104 === (6))){
var inst_84095 = (state_84103[(2)]);
var inst_84096 = fluree.db.util.async.throw_err.call(null,inst_84095);
var inst_84097 = cljs.core.clj__GT_js.call(null,inst_84096);
var inst_84098 = resolve.call(null,inst_84097);
var _ = (function (){var statearr_84113 = state_84103;
(statearr_84113[(4)] = cljs.core.rest.call(null,(state_84103[(4)])));

return statearr_84113;
})();
var state_84103__$1 = state_84103;
var statearr_84114_84125 = state_84103__$1;
(statearr_84114_84125[(2)] = inst_84098);

(statearr_84114_84125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_84115 = [null,null,null,null,null,null,null,null];
(statearr_84115[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_84115[(1)] = (1));

return statearr_84115;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_84103){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_84103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e84116){var ex__2749__auto__ = e84116;
var statearr_84117_84126 = state_84103;
(statearr_84117_84126[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_84103[(4)]))){
var statearr_84118_84127 = state_84103;
(statearr_84118_84127[(1)] = cljs.core.first.call(null,(state_84103[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84128 = state_84103;
state_84103 = G__84128;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_84103){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_84103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_84119 = f__2769__auto__.call(null);
(statearr_84119[(6)] = c__2768__auto__);

return statearr_84119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.multiQuery.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise that eventually contains the results or
 *    an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_84152){
var state_val_84153 = (state_84152[(1)]);
if((state_val_84153 === (1))){
var state_84152__$1 = state_84152;
var statearr_84154_84169 = state_84152__$1;
(statearr_84154_84169[(2)] = null);

(statearr_84154_84169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84153 === (2))){
var _ = (function (){var statearr_84155 = state_84152;
(statearr_84155[(4)] = cljs.core.cons.call(null,(5),(state_84152[(4)])));

return statearr_84155;
})();
var inst_84141 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84142 = fluree.db.api.query.query.call(null,source,inst_84141);
var state_84152__$1 = state_84152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84152__$1,(6),inst_84142);
} else {
if((state_val_84153 === (3))){
var inst_84150 = (state_84152[(2)]);
var state_84152__$1 = state_84152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84152__$1,inst_84150);
} else {
if((state_val_84153 === (4))){
var inst_84129 = (state_84152[(2)]);
var inst_84130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84131 = [inst_84129];
var inst_84132 = (new cljs.core.PersistentVector(null,1,(5),inst_84130,inst_84131,null));
var inst_84133 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_84132);
var inst_84134 = cljs.core.clj__GT_js.call(null,inst_84129);
var inst_84135 = reject.call(null,inst_84134);
var state_84152__$1 = (function (){var statearr_84157 = state_84152;
(statearr_84157[(7)] = inst_84133);

return statearr_84157;
})();
var statearr_84158_84170 = state_84152__$1;
(statearr_84158_84170[(2)] = inst_84135);

(statearr_84158_84170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84153 === (5))){
var _ = (function (){var statearr_84159 = state_84152;
(statearr_84159[(4)] = cljs.core.rest.call(null,(state_84152[(4)])));

return statearr_84159;
})();
var state_84152__$1 = state_84152;
var ex84156 = (state_84152__$1[(2)]);
var statearr_84160_84171 = state_84152__$1;
(statearr_84160_84171[(5)] = ex84156);


var statearr_84161_84172 = state_84152__$1;
(statearr_84161_84172[(1)] = (4));

(statearr_84161_84172[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84153 === (6))){
var inst_84144 = (state_84152[(2)]);
var inst_84145 = fluree.db.util.async.throw_err.call(null,inst_84144);
var inst_84146 = cljs.core.clj__GT_js.call(null,inst_84145);
var inst_84147 = resolve.call(null,inst_84146);
var _ = (function (){var statearr_84162 = state_84152;
(statearr_84162[(4)] = cljs.core.rest.call(null,(state_84152[(4)])));

return statearr_84162;
})();
var state_84152__$1 = state_84152;
var statearr_84163_84173 = state_84152__$1;
(statearr_84163_84173[(2)] = inst_84147);

(statearr_84163_84173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__2746__auto__ = null;
var flureenjs$query_$_state_machine__2746__auto____0 = (function (){
var statearr_84164 = [null,null,null,null,null,null,null,null];
(statearr_84164[(0)] = flureenjs$query_$_state_machine__2746__auto__);

(statearr_84164[(1)] = (1));

return statearr_84164;
});
var flureenjs$query_$_state_machine__2746__auto____1 = (function (state_84152){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_84152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e84165){var ex__2749__auto__ = e84165;
var statearr_84166_84174 = state_84152;
(statearr_84166_84174[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_84152[(4)]))){
var statearr_84167_84175 = state_84152;
(statearr_84167_84175[(1)] = cljs.core.first.call(null,(state_84152[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84176 = state_84152;
state_84152 = G__84176;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__2746__auto__ = function(state_84152){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__2746__auto____1.call(this,state_84152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__2746__auto____0;
flureenjs$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__2746__auto____1;
return flureenjs$query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_84168 = f__2769__auto__.call(null);
(statearr_84168[(6)] = c__2768__auto__);

return statearr_84168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *    given flakes applied.
 * 
 *    Returns promise that eventually contains the results or
 *    an exception.
 */
flureenjs.queryWith = (function flureenjs$queryWith(db,param){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_84209){
var state_val_84210 = (state_84209[(1)]);
if((state_val_84210 === (1))){
var state_84209__$1 = state_84209;
var statearr_84211_84227 = state_84209__$1;
(statearr_84211_84227[(2)] = null);

(statearr_84211_84227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84210 === (2))){
var _ = (function (){var statearr_84212 = state_84209;
(statearr_84212[(4)] = cljs.core.cons.call(null,(5),(state_84209[(4)])));

return statearr_84212;
})();
var inst_84190 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84191 = cljs.core.__destructure_map.call(null,inst_84190);
var inst_84192 = cljs.core.get.call(null,inst_84191,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_84193 = cljs.core.get.call(null,inst_84191,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_84194 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_84193);
var state_84209__$1 = (function (){var statearr_84213 = state_84209;
(statearr_84213[(7)] = inst_84194);

(statearr_84213[(8)] = inst_84192);

return statearr_84213;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84209__$1,(6),db);
} else {
if((state_val_84210 === (3))){
var inst_84207 = (state_84209[(2)]);
var state_84209__$1 = state_84209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84209__$1,inst_84207);
} else {
if((state_val_84210 === (4))){
var inst_84177 = (state_84209[(2)]);
var inst_84178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84179 = [inst_84177];
var inst_84180 = (new cljs.core.PersistentVector(null,1,(5),inst_84178,inst_84179,null));
var inst_84181 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_84180);
var inst_84182 = cljs.core.clj__GT_js.call(null,inst_84177);
var inst_84183 = reject.call(null,inst_84182);
var state_84209__$1 = (function (){var statearr_84215 = state_84209;
(statearr_84215[(9)] = inst_84181);

return statearr_84215;
})();
var statearr_84216_84228 = state_84209__$1;
(statearr_84216_84228[(2)] = inst_84183);

(statearr_84216_84228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84210 === (5))){
var _ = (function (){var statearr_84217 = state_84209;
(statearr_84217[(4)] = cljs.core.rest.call(null,(state_84209[(4)])));

return statearr_84217;
})();
var state_84209__$1 = state_84209;
var ex84214 = (state_84209__$1[(2)]);
var statearr_84218_84229 = state_84209__$1;
(statearr_84218_84229[(5)] = ex84214);


var statearr_84219_84230 = state_84209__$1;
(statearr_84219_84230[(1)] = (4));

(statearr_84219_84230[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84210 === (6))){
var inst_84194 = (state_84209[(7)]);
var inst_84192 = (state_84209[(8)]);
var inst_84196 = (state_84209[(2)]);
var inst_84197 = fluree.db.util.async.throw_err.call(null,inst_84196);
var inst_84198 = fluree.db.dbproto._forward_time_travel.call(null,inst_84197,inst_84194);
var inst_84199 = fluree.db.api.query.query.call(null,inst_84198,inst_84192);
var state_84209__$1 = state_84209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84209__$1,(7),inst_84199);
} else {
if((state_val_84210 === (7))){
var inst_84201 = (state_84209[(2)]);
var inst_84202 = fluree.db.util.async.throw_err.call(null,inst_84201);
var inst_84203 = cljs.core.clj__GT_js.call(null,inst_84202);
var inst_84204 = resolve.call(null,inst_84203);
var _ = (function (){var statearr_84220 = state_84209;
(statearr_84220[(4)] = cljs.core.rest.call(null,(state_84209[(4)])));

return statearr_84220;
})();
var state_84209__$1 = state_84209;
var statearr_84221_84231 = state_84209__$1;
(statearr_84221_84231[(2)] = inst_84204);

(statearr_84221_84231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$queryWith_$_state_machine__2746__auto__ = null;
var flureenjs$queryWith_$_state_machine__2746__auto____0 = (function (){
var statearr_84222 = [null,null,null,null,null,null,null,null,null,null];
(statearr_84222[(0)] = flureenjs$queryWith_$_state_machine__2746__auto__);

(statearr_84222[(1)] = (1));

return statearr_84222;
});
var flureenjs$queryWith_$_state_machine__2746__auto____1 = (function (state_84209){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_84209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e84223){var ex__2749__auto__ = e84223;
var statearr_84224_84232 = state_84209;
(statearr_84224_84232[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_84209[(4)]))){
var statearr_84225_84233 = state_84209;
(statearr_84225_84233[(1)] = cljs.core.first.call(null,(state_84209[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84234 = state_84209;
state_84209 = G__84234;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$queryWith_$_state_machine__2746__auto__ = function(state_84209){
switch(arguments.length){
case 0:
return flureenjs$queryWith_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$queryWith_$_state_machine__2746__auto____1.call(this,state_84209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$queryWith_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$queryWith_$_state_machine__2746__auto____0;
flureenjs$queryWith_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$queryWith_$_state_machine__2746__auto____1;
return flureenjs$queryWith_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_84226 = f__2769__auto__.call(null);
(statearr_84226[(6)] = c__2768__auto__);

return statearr_84226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.queryWith', flureenjs.queryWith);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__84236 = arguments.length;
switch (G__84236) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_84269){
var state_val_84270 = (state_84269[(1)]);
if((state_val_84270 === (7))){
var state_84269__$1 = state_84269;
var statearr_84271_84292 = state_84269__$1;
(statearr_84271_84292[(2)] = null);

(statearr_84271_84292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84270 === (1))){
var state_84269__$1 = state_84269;
var statearr_84272_84293 = state_84269__$1;
(statearr_84272_84293[(2)] = null);

(statearr_84272_84293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84270 === (4))){
var inst_84237 = (state_84269[(2)]);
var inst_84238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84239 = [inst_84237];
var inst_84240 = (new cljs.core.PersistentVector(null,1,(5),inst_84238,inst_84239,null));
var inst_84241 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_84240);
var inst_84242 = cljs.core.clj__GT_js.call(null,inst_84237);
var inst_84243 = reject.call(null,inst_84242);
var state_84269__$1 = (function (){var statearr_84273 = state_84269;
(statearr_84273[(7)] = inst_84241);

return statearr_84273;
})();
var statearr_84274_84294 = state_84269__$1;
(statearr_84274_84294[(2)] = inst_84243);

(statearr_84274_84294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84270 === (6))){
var inst_84253 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_84269__$1 = state_84269;
var statearr_84275_84295 = state_84269__$1;
(statearr_84275_84295[(2)] = inst_84253);

(statearr_84275_84295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84270 === (3))){
var inst_84267 = (state_84269[(2)]);
var state_84269__$1 = state_84269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84269__$1,inst_84267);
} else {
if((state_val_84270 === (2))){
var inst_84250 = (state_84269[(8)]);
var _ = (function (){var statearr_84277 = state_84269;
(statearr_84277[(4)] = cljs.core.cons.call(null,(5),(state_84269[(4)])));

return statearr_84277;
})();
var inst_84249 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_84250__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_84249);
var inst_84251 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_84250__$1);
var state_84269__$1 = (function (){var statearr_84278 = state_84269;
(statearr_84278[(8)] = inst_84250__$1);

(statearr_84278[(9)] = inst_84251);

return statearr_84278;
})();
if(cljs.core.truth_(opts)){
var statearr_84279_84296 = state_84269__$1;
(statearr_84279_84296[(1)] = (6));

} else {
var statearr_84280_84297 = state_84269__$1;
(statearr_84280_84297[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84270 === (9))){
var inst_84261 = (state_84269[(2)]);
var inst_84262 = fluree.db.util.async.throw_err.call(null,inst_84261);
var inst_84263 = cljs.core.clj__GT_js.call(null,inst_84262);
var inst_84264 = resolve.call(null,inst_84263);
var _ = (function (){var statearr_84281 = state_84269;
(statearr_84281[(4)] = cljs.core.rest.call(null,(state_84269[(4)])));

return statearr_84281;
})();
var state_84269__$1 = state_84269;
var statearr_84282_84298 = state_84269__$1;
(statearr_84282_84298[(2)] = inst_84264);

(statearr_84282_84298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84270 === (5))){
var _ = (function (){var statearr_84283 = state_84269;
(statearr_84283[(4)] = cljs.core.rest.call(null,(state_84269[(4)])));

return statearr_84283;
})();
var state_84269__$1 = state_84269;
var ex84276 = (state_84269__$1[(2)]);
var statearr_84284_84299 = state_84269__$1;
(statearr_84284_84299[(5)] = ex84276);


var statearr_84285_84300 = state_84269__$1;
(statearr_84285_84300[(1)] = (4));

(statearr_84285_84300[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84270 === (8))){
var inst_84250 = (state_84269[(8)]);
var inst_84251 = (state_84269[(9)]);
var inst_84256 = (state_84269[(2)]);
var inst_84257 = cljs.core.merge.call(null,inst_84251,inst_84256);
var inst_84258 = cljs.core.assoc.call(null,inst_84250,new cljs.core.Keyword(null,"opts","opts",155075701),inst_84257);
var inst_84259 = fluree.db.api.query.query_async.call(null,db,inst_84258);
var state_84269__$1 = state_84269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84269__$1,(9),inst_84259);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_84286 = [null,null,null,null,null,null,null,null,null,null];
(statearr_84286[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_84286[(1)] = (1));

return statearr_84286;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_84269){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_84269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e84287){var ex__2749__auto__ = e84287;
var statearr_84288_84301 = state_84269;
(statearr_84288_84301[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_84269[(4)]))){
var statearr_84289_84302 = state_84269;
(statearr_84289_84302[(1)] = cljs.core.first.call(null,(state_84269[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84303 = state_84269;
state_84269 = G__84303;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_84269){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_84269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_84290 = f__2769__auto__.call(null);
(statearr_84290[(6)] = c__2768__auto__);

return statearr_84290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__84305 = arguments.length;
switch (G__84305) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_84332){
var state_val_84333 = (state_84332[(1)]);
if((state_val_84333 === (1))){
var state_84332__$1 = state_84332;
var statearr_84334_84350 = state_84332__$1;
(statearr_84334_84350[(2)] = null);

(statearr_84334_84350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84333 === (2))){
var _ = (function (){var statearr_84335 = state_84332;
(statearr_84335[(4)] = cljs.core.cons.call(null,(5),(state_84332[(4)])));

return statearr_84335;
})();
var inst_84318 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_84319 = fluree.db.util.json.parse.call(null,sql_str);
var inst_84320 = fluree.db.query.sql.parse.call(null,inst_84319);
var inst_84321 = cljs.core.update.call(null,inst_84320,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_84318);
var inst_84322 = fluree.db.api.query.query_async.call(null,db,inst_84321);
var state_84332__$1 = state_84332;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_84332__$1,(6),inst_84322);
} else {
if((state_val_84333 === (3))){
var inst_84330 = (state_84332[(2)]);
var state_84332__$1 = state_84332;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_84332__$1,inst_84330);
} else {
if((state_val_84333 === (4))){
var inst_84306 = (state_84332[(2)]);
var inst_84307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84308 = [inst_84306];
var inst_84309 = (new cljs.core.PersistentVector(null,1,(5),inst_84307,inst_84308,null));
var inst_84310 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_84309);
var inst_84311 = cljs.core.clj__GT_js.call(null,inst_84306);
var inst_84312 = reject.call(null,inst_84311);
var state_84332__$1 = (function (){var statearr_84337 = state_84332;
(statearr_84337[(7)] = inst_84310);

return statearr_84337;
})();
var statearr_84338_84351 = state_84332__$1;
(statearr_84338_84351[(2)] = inst_84312);

(statearr_84338_84351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84333 === (5))){
var _ = (function (){var statearr_84339 = state_84332;
(statearr_84339[(4)] = cljs.core.rest.call(null,(state_84332[(4)])));

return statearr_84339;
})();
var state_84332__$1 = state_84332;
var ex84336 = (state_84332__$1[(2)]);
var statearr_84340_84352 = state_84332__$1;
(statearr_84340_84352[(5)] = ex84336);


var statearr_84341_84353 = state_84332__$1;
(statearr_84341_84353[(1)] = (4));

(statearr_84341_84353[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84333 === (6))){
var inst_84324 = (state_84332[(2)]);
var inst_84325 = fluree.db.util.async.throw_err.call(null,inst_84324);
var inst_84326 = cljs.core.clj__GT_js.call(null,inst_84325);
var inst_84327 = resolve.call(null,inst_84326);
var _ = (function (){var statearr_84342 = state_84332;
(statearr_84342[(4)] = cljs.core.rest.call(null,(state_84332[(4)])));

return statearr_84342;
})();
var state_84332__$1 = state_84332;
var statearr_84343_84354 = state_84332__$1;
(statearr_84343_84354[(2)] = inst_84327);

(statearr_84343_84354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_84344 = [null,null,null,null,null,null,null,null];
(statearr_84344[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_84344[(1)] = (1));

return statearr_84344;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_84332){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_84332);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e84345){var ex__2749__auto__ = e84345;
var statearr_84346_84355 = state_84332;
(statearr_84346_84355[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_84332[(4)]))){
var statearr_84347_84356 = state_84332;
(statearr_84347_84356[(1)] = cljs.core.first.call(null,(state_84332[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84357 = state_84332;
state_84332 = G__84357;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_84332){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_84332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_84348 = f__2769__auto__.call(null);
(statearr_84348[(6)] = c__2768__auto__);

return statearr_84348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

