// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.evaluator');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.interop');
goog.require('sci.impl.macros');
goog.require('sci.impl.records');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.evaluator.macros = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol(null,"fn","fn",465265323,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"defn","defn",-126010802,null),"null",new cljs.core.Symbol(null,"syntax-quote","syntax-quote",407366680,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
/**
 * The and macro from clojure.core. Note: and is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_and = (function sci$impl$evaluator$eval_and(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first.call(null,args__$2);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
if(cljs.core.truth_(v)){
var xs = cljs.core.next.call(null,args__$2);
if(xs){
var G__36520 = xs;
args__$2 = G__36520;
continue;
} else {
return v;
}
} else {
return v;
}
} else {
return true;
}
break;
}
});
/**
 * The or macro from clojure.core. Note: or is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_or = (function sci$impl$evaluator$eval_or(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first.call(null,args__$2);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
if(cljs.core.truth_(v)){
return v;
} else {
var xs = cljs.core.next.call(null,args__$2);
if(xs){
var G__36521 = xs;
args__$2 = G__36521;
continue;
} else {
return v;
}
}
} else {
return null;
}
break;
}
});
/**
 * The let macro from clojure.core
 */
sci.impl.evaluator.eval_let = (function sci$impl$evaluator$eval_let(ctx,bindings,let_bindings,exprs,idxs){
var vec__36522 = (function (){var ctx__$1 = ctx;
var bindings__$1 = bindings;
var let_bindings__$1 = let_bindings;
var idx = (0);
while(true){
var let_name = cljs.core.first.call(null,let_bindings__$1);
if(cljs.core.truth_(let_name)){
var let_bindings__$2 = cljs.core.rest.call(null,let_bindings__$1);
var let_val = cljs.core.first.call(null,let_bindings__$2);
var rest_let_bindings = cljs.core.next.call(null,let_bindings__$2);
var v = sci.impl.types.eval.call(null,let_val,ctx__$1,bindings__$1);
(bindings__$1[cljs.core.nth.call(null,idxs,idx)] = v);

var G__36525 = ctx__$1;
var G__36526 = bindings__$1;
var G__36527 = rest_let_bindings;
var G__36528 = (idx + (1));
ctx__$1 = G__36525;
bindings__$1 = G__36526;
let_bindings__$1 = G__36527;
idx = G__36528;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx__$1,bindings__$1], null);
}
break;
}
})();
var ctx__$1 = cljs.core.nth.call(null,vec__36522,(0),null);
var bindings__$1 = cljs.core.nth.call(null,vec__36522,(1),null);
return sci.impl.types.eval.call(null,exprs,ctx__$1,bindings__$1);
});
sci.impl.evaluator.eval_def = (function sci$impl$evaluator$eval_def(ctx,bindings,var_name,init,m){
var init__$1 = sci.impl.types.eval.call(null,init,ctx,bindings);
var m__$1 = sci.impl.types.eval.call(null,m,ctx,bindings);
var cnn = sci.impl.vars.getName.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m__$1));
var assoc_in_env = (function (env){
var the_current_ns = cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn);
var prev = cljs.core.get.call(null,the_current_ns,var_name);
var prev__$1 = (((!(sci.impl.vars.var_QMARK_.call(null,prev))))?sci.impl.vars.__GT_SciVar.call(null,prev,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnn),cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_name)),cljs.core.meta.call(null,prev),false):prev);
var v = (((sci.impl.utils.var_unbound === init__$1))?(function (){var G__36529 = prev__$1;
cljs.core.alter_meta_BANG_.call(null,G__36529,cljs.core.merge,m__$1);

return G__36529;
})():(function (){
sci.impl.vars.bindRoot.call(null,prev__$1,init__$1);

cljs.core.alter_meta_BANG_.call(null,prev__$1,cljs.core.merge,m__$1);

return prev__$1;
})()
);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,var_name,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});
var env = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),assoc_in_env);
return cljs.core.get.call(null,cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn),var_name);
});
var ret__5824__auto___36530 = sci.impl.evaluator.resolve_symbol = (function sci$impl$evaluator$resolve_symbol(_AMPERSAND_form,_AMPERSAND_env,bindings,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,".get",".get",1446963300,null),null,(1),null)),(new cljs.core.List(null,cljs.core.with_meta.call(null,bindings,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"java.util.Map","java.util.Map",981564201,null)], null)),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)))));
});
(sci.impl.evaluator.resolve_symbol.cljs$lang$macro = true);

sci.impl.evaluator.eval_case = (function sci$impl$evaluator$eval_case(var_args){
var G__36532 = arguments.length;
switch (G__36532) {
case 4:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,case_map,case_val){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__36533 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__36533,(0),null);
var found = cljs.core.nth.call(null,vec__36533,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')));
}
}));

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5 = (function (ctx,bindings,case_map,case_val,case_default){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__36536 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__36536,(0),null);
var found = cljs.core.nth.call(null,vec__36536,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
return sci.impl.types.eval.call(null,case_default,ctx,bindings);
}
}));

(sci.impl.evaluator.eval_case.cljs$lang$maxFixedArity = 5);

sci.impl.evaluator.eval_try = (function sci$impl$evaluator$eval_try(ctx,bindings,body,catches,finally$){
try{var _STAR_in_try_STAR__orig_val__36544 = sci.impl.utils._STAR_in_try_STAR_;
var _STAR_in_try_STAR__temp_val__36545 = true;
(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__temp_val__36545);

try{return sci.impl.types.eval.call(null,body,ctx,bindings);
}finally {(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__orig_val__36544);
}}catch (e36540){var e = e36540;
var temp__5802__auto__ = cljs.core.reduce.call(null,(function (_,c){
var clazz = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(c);
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"default","default",-1987822328),clazz);
if(or__5045__auto__){
return or__5045__auto__;
} else {
if((clazz instanceof sci.impl.types.NodeR)){
var c__5078__auto__ = sci.impl.types.eval.call(null,clazz,ctx,bindings);
var x__5079__auto__ = e;
return (x__5079__auto__ instanceof c__5078__auto__);
} else {
return (e instanceof clazz);
}
}
})())){
return cljs.core.reduced.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sci.impl.evaluator","try-result","sci.impl.evaluator/try-result",-1394897780),(function (){
(bindings[new cljs.core.Keyword(null,"ex-idx","ex-idx",795118805).cljs$core$IFn$_invoke$arity$1(c)] = e);

return sci.impl.types.eval.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(c),ctx,bindings);
})()
], null));
} else {
return null;
}
}),null,catches);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__36541 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__36541,(0),null);
var r = cljs.core.nth.call(null,vec__36541,(1),null);
return r;
} else {
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e,body);
}
}finally {sci.impl.types.eval.call(null,finally$,ctx,bindings);
}});
sci.impl.evaluator.eval_static_method_invocation = (function sci$impl$evaluator$eval_static_method_invocation(ctx,bindings,expr){
return sci.impl.interop.invoke_static_method.call(null,cljs.core.first.call(null,expr),cljs.core.map.call(null,(function (p1__36546_SHARP_){
return sci.impl.types.eval.call(null,p1__36546_SHARP_,ctx,bindings);
}),cljs.core.rest.call(null,expr)));
});
sci.impl.evaluator.eval_instance_method_invocation = (function sci$impl$evaluator$eval_instance_method_invocation(ctx,bindings,instance_expr,method_str,field_access,args,allowed){
var instance_meta = cljs.core.meta.call(null,instance_expr);
var tag_class = new cljs.core.Keyword(null,"tag-class","tag-class",714967874).cljs$core$IFn$_invoke$arity$1(instance_meta);
var instance_expr_STAR_ = sci.impl.types.eval.call(null,instance_expr,ctx,bindings);
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.map_QMARK_.call(null,instance_expr_STAR_);
if(and__5043__auto__){
return new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,instance_expr_STAR_));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.get.call(null,instance_expr_STAR_,cljs.core.keyword.call(null,method_str));
} else {
var instance_class = (function (){var or__5045__auto__ = tag_class;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.type.call(null,instance_expr_STAR_);
}
})();
var class__GT_opts = new cljs.core.Keyword(null,"class->opts","class->opts",2061906477).cljs$core$IFn$_invoke$arity$1(ctx);
var allowed_QMARK_ = (function (){var or__5045__auto__ = allowed;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,class__GT_opts,new cljs.core.Keyword(null,"allow","allow",-1857325745));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = (function (){var instance_class_name = instance_class.name;
var instance_class_symbol = cljs.core.symbol.call(null,instance_class_name);
return cljs.core.get.call(null,class__GT_opts,instance_class_symbol);
})();
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return console.log(cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str));
}
}
}
})();
var target_class = (cljs.core.truth_(allowed_QMARK_)?instance_class:(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"public-class","public-class",1127293019).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5804__auto__)){
var f = temp__5804__auto__;
return f.call(null,instance_expr_STAR_);
} else {
return null;
}
})());
if(cljs.core.truth_(allowed_QMARK_)){
} else {
sci.impl.utils.throw_error_with_location.call(null,["Method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_class)," not allowed!"].join(''),instance_expr);
}

if(cljs.core.truth_(field_access)){
return sci.impl.interop.invoke_instance_field.call(null,instance_expr_STAR_,target_class,method_str);
} else {
var args__$1 = cljs.core.map.call(null,(function (p1__36548_SHARP_){
return sci.impl.types.eval.call(null,p1__36548_SHARP_,ctx,bindings);
}),args);
return sci.impl.interop.invoke_instance_method.call(null,instance_expr_STAR_,target_class,method_str,args__$1);
}
}
});
sci.impl.evaluator.eval_resolve = (function sci$impl$evaluator$eval_resolve(var_args){
var G__36550 = arguments.length;
switch (G__36550) {
case 3:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3 = (function (ctx,bindings,sym){
return sci.impl.evaluator.eval_resolve.call(null,ctx,bindings,null,sym);
}));

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,env,sym){
if(((cljs.core.not.call(null,env)) || ((!(cljs.core.contains_QMARK_.call(null,env,sym)))))){
var sym__$1 = sci.impl.types.eval.call(null,sym,ctx,bindings);
var res = cljs.core.second.call(null,cljs.core.deref.call(null,sci.impl.utils.lookup).call(null,ctx,sym__$1,false));
if((res instanceof sci.impl.types.NodeR)){
return null;
} else {
return res;
}
} else {
return null;
}
}));

(sci.impl.evaluator.eval_resolve.cljs$lang$maxFixedArity = 4);

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_resolve_state,sci.impl.evaluator.eval_resolve);
sci.impl.evaluator.eval_import = (function sci$impl$evaluator$eval_import(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36558 = arguments.length;
var i__5770__auto___36559 = (0);
while(true){
if((i__5770__auto___36559 < len__5769__auto___36558)){
args__5775__auto__.push((arguments[i__5770__auto___36559]));

var G__36560 = (i__5770__auto___36559 + (1));
i__5770__auto___36559 = G__36560;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,import_symbols_or_lists){
var specs = cljs.core.map.call(null,(function (p1__36552_SHARP_){
if(((cljs.core.seq_QMARK_.call(null,p1__36552_SHARP_)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,p1__36552_SHARP_))))){
return cljs.core.second.call(null,p1__36552_SHARP_);
} else {
return p1__36552_SHARP_;
}
}),import_symbols_or_lists);
var env = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
return cljs.core.reduce.call(null,(function (_,spec){
var vec__36555 = (((spec instanceof cljs.core.Symbol))?(function (){var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec);
var last_dot = clojure.string.last_index_of.call(null,s,".");
var package_PLUS_class_name = (cljs.core.truth_(last_dot)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(0),last_dot)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(last_dot + (1)),((s).length)))], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec], null)], null));
return package_PLUS_class_name;
})():(function (){var p = cljs.core.first.call(null,spec);
var cs = cljs.core.rest.call(null,spec);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cs], null);
})());
var package$ = cljs.core.nth.call(null,vec__36555,(0),null);
var classes = cljs.core.nth.call(null,vec__36555,(1),null);
return cljs.core.reduce.call(null,(function (___$1,class$){
var fq_class_name = cljs.core.symbol.call(null,(cljs.core.truth_(package$)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(package$),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join(''):class$));
var temp__5802__auto__ = sci.impl.interop.resolve_class.call(null,ctx,fq_class_name);
if(cljs.core.truth_(temp__5802__auto__)){
var clazz = temp__5802__auto__;
var cnn = sci.impl.vars.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"imports","imports",-1249933394),class$], null),fq_class_name);

return clazz;
} else {
var temp__5802__auto____$1 = sci.impl.records.resolve_record_or_protocol_class.call(null,ctx,package$,class$);
if(cljs.core.truth_(temp__5802__auto____$1)){
var rec = temp__5802__auto____$1;
var cnn = sci.impl.vars.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,class$], null),rec);

return rec;
} else {
throw (new Error(["Unable to resolve classname: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fq_class_name)].join('')));
}
}
}),null,classes);
}),null,specs);
}));

(sci.impl.evaluator.eval_import.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.evaluator.eval_import.cljs$lang$applyTo = (function (seq36553){
var G__36554 = cljs.core.first.call(null,seq36553);
var seq36553__$1 = cljs.core.next.call(null,seq36553);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36554,seq36553__$1);
}));

/**
 * Note: various arities of do have already been unrolled in the analyzer.
 */
sci.impl.evaluator.eval_do = (function sci$impl$evaluator$eval_do(ctx,bindings,exprs){
var exprs__$1 = cljs.core.seq.call(null,exprs);
var exprs__$2 = exprs__$1;
while(true){
if(exprs__$2){
var ret = sci.impl.types.eval.call(null,cljs.core.first.call(null,exprs__$2),ctx,bindings);
var temp__5802__auto__ = cljs.core.next.call(null,exprs__$2);
if(temp__5802__auto__){
var exprs__$3 = temp__5802__auto__;
var G__36561 = exprs__$3;
exprs__$2 = G__36561;
continue;
} else {
return ret;
}
} else {
return null;
}
break;
}
});
cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_do_STAR_,sci.impl.evaluator.eval_do);
sci.impl.evaluator.fn_call = (function sci$impl$evaluator$fn_call(ctx,bindings,f,args){
var G__36756 = cljs.core.count.call(null,args);
switch (G__36756) {
case (0):
return f.call(null);

break;
case (1):
var arg36566 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
return f.call(null,arg36566);

break;
case (2):
var arg36567 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36568 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
return f.call(null,arg36567,arg36568);

break;
case (3):
var arg36569 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36570 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36571 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
return f.call(null,arg36569,arg36570,arg36571);

break;
case (4):
var arg36572 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36573 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36574 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36575 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
return f.call(null,arg36572,arg36573,arg36574,arg36575);

break;
case (5):
var arg36576 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36577 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36578 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36579 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36580 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
return f.call(null,arg36576,arg36577,arg36578,arg36579,arg36580);

break;
case (6):
var arg36581 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36582 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36583 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36584 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36585 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36586 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
return f.call(null,arg36581,arg36582,arg36583,arg36584,arg36585,arg36586);

break;
case (7):
var arg36587 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36588 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36589 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36590 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36591 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36592 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36593 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
return f.call(null,arg36587,arg36588,arg36589,arg36590,arg36591,arg36592,arg36593);

break;
case (8):
var arg36594 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36595 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36596 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36597 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36598 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36599 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36600 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36601 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
return f.call(null,arg36594,arg36595,arg36596,arg36597,arg36598,arg36599,arg36600,arg36601);

break;
case (9):
var arg36602 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36603 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36604 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36605 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36606 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36607 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36608 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36609 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36610 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
return f.call(null,arg36602,arg36603,arg36604,arg36605,arg36606,arg36607,arg36608,arg36609,arg36610);

break;
case (10):
var arg36611 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36612 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36613 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36614 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36615 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36616 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36617 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36618 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36619 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36620 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
return f.call(null,arg36611,arg36612,arg36613,arg36614,arg36615,arg36616,arg36617,arg36618,arg36619,arg36620);

break;
case (11):
var arg36621 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36622 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36623 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36624 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36625 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36626 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36627 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36628 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36629 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36630 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36631 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
return f.call(null,arg36621,arg36622,arg36623,arg36624,arg36625,arg36626,arg36627,arg36628,arg36629,arg36630,arg36631);

break;
case (12):
var arg36632 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36633 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36634 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36635 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36636 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36637 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36638 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36639 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36640 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36641 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36642 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36643 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
return f.call(null,arg36632,arg36633,arg36634,arg36635,arg36636,arg36637,arg36638,arg36639,arg36640,arg36641,arg36642,arg36643);

break;
case (13):
var arg36644 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36645 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36646 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36647 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36648 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36649 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36650 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36651 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36652 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36653 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36654 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36655 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg36656 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
return f.call(null,arg36644,arg36645,arg36646,arg36647,arg36648,arg36649,arg36650,arg36651,arg36652,arg36653,arg36654,arg36655,arg36656);

break;
case (14):
var arg36657 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36658 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36659 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36660 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36661 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36662 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36663 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36664 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36665 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36666 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36667 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36668 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg36669 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg36670 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
return f.call(null,arg36657,arg36658,arg36659,arg36660,arg36661,arg36662,arg36663,arg36664,arg36665,arg36666,arg36667,arg36668,arg36669,arg36670);

break;
case (15):
var arg36671 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36672 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36673 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36674 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36675 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36676 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36677 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36678 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36679 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36680 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36681 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36682 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg36683 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg36684 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg36685 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
return f.call(null,arg36671,arg36672,arg36673,arg36674,arg36675,arg36676,arg36677,arg36678,arg36679,arg36680,arg36681,arg36682,arg36683,arg36684,arg36685);

break;
case (16):
var arg36686 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36687 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36688 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36689 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36690 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36691 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36692 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36693 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36694 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36695 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36696 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36697 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg36698 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg36699 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg36700 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg36701 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
return f.call(null,arg36686,arg36687,arg36688,arg36689,arg36690,arg36691,arg36692,arg36693,arg36694,arg36695,arg36696,arg36697,arg36698,arg36699,arg36700,arg36701);

break;
case (17):
var arg36702 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36703 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36704 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36705 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36706 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36707 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36708 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36709 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36710 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36711 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36712 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36713 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg36714 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg36715 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg36716 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg36717 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg36718 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
return f.call(null,arg36702,arg36703,arg36704,arg36705,arg36706,arg36707,arg36708,arg36709,arg36710,arg36711,arg36712,arg36713,arg36714,arg36715,arg36716,arg36717,arg36718);

break;
case (18):
var arg36719 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36720 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36721 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36722 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36723 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36724 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36725 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36726 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36727 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36728 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36729 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36730 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg36731 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg36732 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg36733 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg36734 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg36735 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg36736 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
return f.call(null,arg36719,arg36720,arg36721,arg36722,arg36723,arg36724,arg36725,arg36726,arg36727,arg36728,arg36729,arg36730,arg36731,arg36732,arg36733,arg36734,arg36735,arg36736);

break;
case (19):
var arg36737 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg36738 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg36739 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg36740 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg36741 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg36742 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg36743 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg36744 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg36745 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg36746 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg36747 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg36748 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg36749 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg36750 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg36751 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg36752 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg36753 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg36754 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
var arg36755 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$18),ctx,bindings);
var args__$19 = cljs.core.rest.call(null,args__$18);
return f.call(null,arg36737,arg36738,arg36739,arg36740,arg36741,arg36742,arg36743,arg36744,arg36745,arg36746,arg36747,arg36748,arg36749,arg36750,arg36751,arg36752,arg36753,arg36754,arg36755);

break;
default:
var args__$1 = cljs.core.mapv.call(null,(function (p1__36276_SHARP_){
return sci.impl.types.eval.call(null,p1__36276_SHARP_,ctx,bindings);
}),args);
return cljs.core.apply.call(null,f,args__$1);

}
});
