// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__73820 = arguments.length;
switch (G__73820) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___73859 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73841){
var state_val_73842 = (state_73841[(1)]);
if((state_val_73842 === (1))){
var state_73841__$1 = state_73841;
var statearr_73843_73860 = state_73841__$1;
(statearr_73843_73860[(2)] = null);

(statearr_73843_73860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73842 === (2))){
var _ = (function (){var statearr_73844 = state_73841;
(statearr_73844[(4)] = cljs.core.cons((5),(state_73841[(4)])));

return statearr_73844;
})();
var inst_73827 = fluree.db.session.db(conn,ledger,null);
var state_73841__$1 = state_73841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73841__$1,(7),inst_73827);
} else {
if((state_val_73842 === (3))){
var inst_73837 = (state_73841[(2)]);
var inst_73838 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73837);
var inst_73839 = cljs.core.async.close_BANG_(pc);
var state_73841__$1 = (function (){var statearr_73846 = state_73841;
(statearr_73846[(7)] = inst_73838);

return statearr_73846;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73841__$1,inst_73839);
} else {
if((state_val_73842 === (4))){
var inst_73821 = (state_73841[(2)]);
var state_73841__$1 = state_73841;
var statearr_73847_73861 = state_73841__$1;
(statearr_73847_73861[(2)] = inst_73821);

(statearr_73847_73861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73842 === (5))){
var _ = (function (){var statearr_73848 = state_73841;
(statearr_73848[(4)] = cljs.core.rest((state_73841[(4)])));

return statearr_73848;
})();
var state_73841__$1 = state_73841;
var ex73845 = (state_73841__$1[(2)]);
var statearr_73849_73862 = state_73841__$1;
(statearr_73849_73862[(5)] = ex73845);


var statearr_73850_73863 = state_73841__$1;
(statearr_73850_73863[(1)] = (4));

(statearr_73850_73863[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73842 === (6))){
var inst_73833 = (state_73841[(2)]);
var inst_73834 = fluree.db.util.async.throw_err(inst_73833);
var _ = (function (){var statearr_73851 = state_73841;
(statearr_73851[(4)] = cljs.core.rest((state_73841[(4)])));

return statearr_73851;
})();
var state_73841__$1 = state_73841;
var statearr_73852_73864 = state_73841__$1;
(statearr_73852_73864[(2)] = inst_73834);

(statearr_73852_73864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73842 === (7))){
var inst_73829 = (state_73841[(2)]);
var inst_73830 = fluree.db.util.async.throw_err(inst_73829);
var inst_73831 = fluree.db.time_travel.as_of_block(inst_73830,block);
var state_73841__$1 = state_73841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73841__$1,(6),inst_73831);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_73853 = [null,null,null,null,null,null,null,null];
(statearr_73853[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_73853[(1)] = (1));

return statearr_73853;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_73841){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73841);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73854){var ex__2730__auto__ = e73854;
var statearr_73855_73865 = state_73841;
(statearr_73855_73865[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73841[(4)]))){
var statearr_73856_73866 = state_73841;
(statearr_73856_73866[(1)] = cljs.core.first((state_73841[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73867 = state_73841;
state_73841 = G__73867;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_73841){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_73841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73857 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73857[(6)] = c__2749__auto___73859);

return statearr_73857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73908){
var state_val_73909 = (state_73908[(1)]);
if((state_val_73909 === (7))){
var inst_73877 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_73908__$1 = state_73908;
if(inst_73877){
var statearr_73910_73941 = state_73908__$1;
(statearr_73910_73941[(1)] = (9));

} else {
var statearr_73911_73942 = state_73908__$1;
(statearr_73911_73942[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (1))){
var state_73908__$1 = state_73908;
var statearr_73912_73943 = state_73908__$1;
(statearr_73912_73943[(2)] = null);

(statearr_73912_73943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (4))){
var inst_73868 = (state_73908[(2)]);
var state_73908__$1 = state_73908;
var statearr_73913_73944 = state_73908__$1;
(statearr_73913_73944[(2)] = inst_73868);

(statearr_73913_73944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (15))){
var inst_73885 = (state_73908[(7)]);
var inst_73884 = (state_73908[(2)]);
var inst_73885__$1 = fluree.db.util.async.throw_err(inst_73884);
var state_73908__$1 = (function (){var statearr_73914 = state_73908;
(statearr_73914[(7)] = inst_73885__$1);

return statearr_73914;
})();
if(cljs.core.truth_(inst_73885__$1)){
var statearr_73915_73945 = state_73908__$1;
(statearr_73915_73945[(1)] = (16));

} else {
var statearr_73916_73946 = state_73908__$1;
(statearr_73916_73946[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (13))){
var state_73908__$1 = state_73908;
var statearr_73917_73947 = state_73908__$1;
(statearr_73917_73947[(2)] = null);

(statearr_73917_73947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (6))){
var state_73908__$1 = state_73908;
var statearr_73918_73948 = state_73908__$1;
(statearr_73918_73948[(2)] = db);

(statearr_73918_73948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (17))){
var inst_73889 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_73890 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73891 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_73892 = cljs.core.PersistentHashMap.fromArrays(inst_73890,inst_73891);
var inst_73893 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73889,inst_73892);
var inst_73894 = (function(){throw inst_73893})();
var state_73908__$1 = state_73908;
var statearr_73919_73949 = state_73908__$1;
(statearr_73919_73949[(2)] = inst_73894);

(statearr_73919_73949[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (3))){
var inst_73906 = (state_73908[(2)]);
var state_73908__$1 = state_73908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73908__$1,inst_73906);
} else {
if((state_val_73909 === (12))){
var inst_73882 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_73908__$1 = state_73908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73908__$1,(15),inst_73882);
} else {
if((state_val_73909 === (2))){
var _ = (function (){var statearr_73920 = state_73908;
(statearr_73920[(4)] = cljs.core.cons((5),(state_73908[(4)])));

return statearr_73920;
})();
var inst_73874 = cljs.core.not(auth);
var state_73908__$1 = state_73908;
if(inst_73874){
var statearr_73921_73950 = state_73908__$1;
(statearr_73921_73950[(1)] = (6));

} else {
var statearr_73922_73951 = state_73908__$1;
(statearr_73922_73951[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (11))){
var inst_73901 = (state_73908[(2)]);
var state_73908__$1 = state_73908;
var statearr_73924_73952 = state_73908__$1;
(statearr_73924_73952[(2)] = inst_73901);

(statearr_73924_73952[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (9))){
var inst_73879 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_73908__$1 = state_73908;
var statearr_73925_73953 = state_73908__$1;
(statearr_73925_73953[(2)] = inst_73879);

(statearr_73925_73953[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (5))){
var _ = (function (){var statearr_73926 = state_73908;
(statearr_73926[(4)] = cljs.core.rest((state_73908[(4)])));

return statearr_73926;
})();
var state_73908__$1 = state_73908;
var ex73923 = (state_73908__$1[(2)]);
var statearr_73927_73954 = state_73908__$1;
(statearr_73927_73954[(5)] = ex73923);


if((ex73923 instanceof Error)){
var statearr_73928_73955 = state_73908__$1;
(statearr_73928_73955[(1)] = (4));

(statearr_73928_73955[(5)] = null);

} else {
throw ex73923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (14))){
var inst_73899 = (state_73908[(2)]);
var state_73908__$1 = state_73908;
var statearr_73929_73956 = state_73908__$1;
(statearr_73929_73956[(2)] = inst_73899);

(statearr_73929_73956[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (16))){
var inst_73885 = (state_73908[(7)]);
var inst_73887 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_73885);
var state_73908__$1 = state_73908;
var statearr_73930_73957 = state_73908__$1;
(statearr_73930_73957[(2)] = inst_73887);

(statearr_73930_73957[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (10))){
var state_73908__$1 = state_73908;
var statearr_73931_73958 = state_73908__$1;
(statearr_73931_73958[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (18))){
var inst_73896 = (state_73908[(2)]);
var state_73908__$1 = state_73908;
var statearr_73933_73959 = state_73908__$1;
(statearr_73933_73959[(2)] = inst_73896);

(statearr_73933_73959[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73909 === (8))){
var inst_73903 = (state_73908[(2)]);
var _ = (function (){var statearr_73934 = state_73908;
(statearr_73934[(4)] = cljs.core.rest((state_73908[(4)])));

return statearr_73934;
})();
var state_73908__$1 = state_73908;
var statearr_73935_73960 = state_73908__$1;
(statearr_73935_73960[(2)] = inst_73903);

(statearr_73935_73960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_73936 = [null,null,null,null,null,null,null,null];
(statearr_73936[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_73936[(1)] = (1));

return statearr_73936;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_73908){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73908);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73937){var ex__2730__auto__ = e73937;
var statearr_73938_73961 = state_73908;
(statearr_73938_73961[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73908[(4)]))){
var statearr_73939_73962 = state_73908;
(statearr_73939_73962[(1)] = cljs.core.first((state_73908[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73963 = state_73908;
state_73908 = G__73963;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_73908){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_73908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73940 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73940[(6)] = c__2749__auto__);

return statearr_73940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74035){
var state_val_74036 = (state_74035[(1)]);
if((state_val_74036 === (7))){
var inst_73973 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_74035__$1 = state_74035;
if(inst_73973){
var statearr_74037_74091 = state_74035__$1;
(statearr_74037_74091[(1)] = (9));

} else {
var statearr_74038_74092 = state_74035__$1;
(statearr_74038_74092[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (20))){
var inst_73997 = (state_74035[(7)]);
var state_74035__$1 = state_74035;
if(cljs.core.truth_(inst_73997)){
var statearr_74039_74093 = state_74035__$1;
(statearr_74039_74093[(1)] = (22));

} else {
var statearr_74040_74094 = state_74035__$1;
(statearr_74040_74094[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (27))){
var state_74035__$1 = state_74035;
var statearr_74041_74095 = state_74035__$1;
(statearr_74041_74095[(2)] = null);

(statearr_74041_74095[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (1))){
var state_74035__$1 = state_74035;
var statearr_74042_74096 = state_74035__$1;
(statearr_74042_74096[(2)] = null);

(statearr_74042_74096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (24))){
var inst_74011 = (state_74035[(2)]);
var state_74035__$1 = state_74035;
var statearr_74043_74097 = state_74035__$1;
(statearr_74043_74097[(2)] = inst_74011);

(statearr_74043_74097[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (4))){
var inst_73964 = (state_74035[(2)]);
var state_74035__$1 = state_74035;
var statearr_74044_74098 = state_74035__$1;
(statearr_74044_74098[(2)] = inst_73964);

(statearr_74044_74098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (15))){
var inst_73980 = (state_74035[(8)]);
var inst_73979 = (state_74035[(2)]);
var inst_73980__$1 = fluree.db.util.async.throw_err(inst_73979);
var state_74035__$1 = (function (){var statearr_74045 = state_74035;
(statearr_74045[(8)] = inst_73980__$1);

return statearr_74045;
})();
if(cljs.core.truth_(inst_73980__$1)){
var statearr_74046_74099 = state_74035__$1;
(statearr_74046_74099[(1)] = (16));

} else {
var statearr_74047_74100 = state_74035__$1;
(statearr_74047_74100[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (21))){
var inst_74013 = (state_74035[(9)]);
var inst_74013__$1 = (state_74035[(2)]);
var state_74035__$1 = (function (){var statearr_74048 = state_74035;
(statearr_74048[(9)] = inst_74013__$1);

return statearr_74048;
})();
if(cljs.core.truth_(inst_74013__$1)){
var statearr_74049_74101 = state_74035__$1;
(statearr_74049_74101[(1)] = (29));

} else {
var statearr_74050_74102 = state_74035__$1;
(statearr_74050_74102[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (31))){
var inst_74013 = (state_74035[(9)]);
var inst_74021 = (state_74035[(2)]);
var state_74035__$1 = (function (){var statearr_74051 = state_74035;
(statearr_74051[(10)] = inst_74021);

return statearr_74051;
})();
if(cljs.core.truth_(inst_74013)){
var statearr_74052_74103 = state_74035__$1;
(statearr_74052_74103[(1)] = (33));

} else {
var statearr_74053_74104 = state_74035__$1;
(statearr_74053_74104[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (32))){
var inst_74017 = (state_74035[(2)]);
var inst_74018 = fluree.db.util.async.throw_err(inst_74017);
var state_74035__$1 = state_74035;
var statearr_74054_74105 = state_74035__$1;
(statearr_74054_74105[(2)] = inst_74018);

(statearr_74054_74105[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (33))){
var inst_74013 = (state_74035[(9)]);
var inst_74023 = fluree.db.permissions.permission_map(db,inst_74013,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74035__$1 = state_74035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74035__$1,(36),inst_74023);
} else {
if((state_val_74036 === (13))){
var state_74035__$1 = state_74035;
var statearr_74055_74106 = state_74035__$1;
(statearr_74055_74106[(2)] = null);

(statearr_74055_74106[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (22))){
var inst_73997 = (state_74035[(7)]);
var inst_74001 = fluree.db.auth.roles(db,inst_73997);
var state_74035__$1 = state_74035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74035__$1,(25),inst_74001);
} else {
if((state_val_74036 === (36))){
var inst_74025 = (state_74035[(2)]);
var inst_74026 = fluree.db.util.async.throw_err(inst_74025);
var state_74035__$1 = state_74035;
var statearr_74056_74107 = state_74035__$1;
(statearr_74056_74107[(2)] = inst_74026);

(statearr_74056_74107[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (29))){
var inst_74013 = (state_74035[(9)]);
var inst_73997 = (state_74035[(7)]);
var inst_74015 = fluree.db.dbfunctions.ctx.build(db,inst_73997,inst_74013);
var state_74035__$1 = state_74035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74035__$1,(32),inst_74015);
} else {
if((state_val_74036 === (6))){
var state_74035__$1 = state_74035;
var statearr_74057_74108 = state_74035__$1;
(statearr_74057_74108[(2)] = null);

(statearr_74057_74108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (28))){
var inst_74009 = (state_74035[(2)]);
var state_74035__$1 = state_74035;
var statearr_74058_74109 = state_74035__$1;
(statearr_74058_74109[(2)] = inst_74009);

(statearr_74058_74109[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (25))){
var inst_74003 = (state_74035[(2)]);
var inst_74004 = fluree.db.util.async.throw_err(inst_74003);
var state_74035__$1 = state_74035;
var statearr_74059_74110 = state_74035__$1;
(statearr_74059_74110[(2)] = inst_74004);

(statearr_74059_74110[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (34))){
var state_74035__$1 = state_74035;
var statearr_74060_74111 = state_74035__$1;
(statearr_74060_74111[(2)] = null);

(statearr_74060_74111[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (17))){
var inst_73983 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_73984 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73985 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_73986 = cljs.core.PersistentHashMap.fromArrays(inst_73984,inst_73985);
var inst_73987 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73983,inst_73986);
var inst_73988 = (function(){throw inst_73987})();
var state_74035__$1 = state_74035;
var statearr_74061_74112 = state_74035__$1;
(statearr_74061_74112[(2)] = inst_73988);

(statearr_74061_74112[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (3))){
var inst_74033 = (state_74035[(2)]);
var state_74035__$1 = state_74035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74035__$1,inst_74033);
} else {
if((state_val_74036 === (12))){
var inst_73977 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_74035__$1 = state_74035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74035__$1,(15),inst_73977);
} else {
if((state_val_74036 === (2))){
var _ = (function (){var statearr_74062 = state_74035;
(statearr_74062[(4)] = cljs.core.cons((5),(state_74035[(4)])));

return statearr_74062;
})();
var inst_73970 = (auth == null);
var state_74035__$1 = state_74035;
if(cljs.core.truth_(inst_73970)){
var statearr_74063_74113 = state_74035__$1;
(statearr_74063_74113[(1)] = (6));

} else {
var statearr_74064_74114 = state_74035__$1;
(statearr_74064_74114[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (23))){
var state_74035__$1 = state_74035;
var statearr_74065_74115 = state_74035__$1;
(statearr_74065_74115[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (35))){
var inst_74013 = (state_74035[(9)]);
var inst_73997 = (state_74035[(7)]);
var inst_74021 = (state_74035[(10)]);
var inst_74029 = (state_74035[(2)]);
var inst_74030 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_73997,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_74013,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_74029,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_74021], 0));
var _ = (function (){var statearr_74067 = state_74035;
(statearr_74067[(4)] = cljs.core.rest((state_74035[(4)])));

return statearr_74067;
})();
var state_74035__$1 = state_74035;
var statearr_74068_74116 = state_74035__$1;
(statearr_74068_74116[(2)] = inst_74030);

(statearr_74068_74116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (19))){
var state_74035__$1 = state_74035;
var statearr_74069_74117 = state_74035__$1;
(statearr_74069_74117[(2)] = roles);

(statearr_74069_74117[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (11))){
var inst_73995 = (state_74035[(2)]);
var state_74035__$1 = state_74035;
var statearr_74071_74118 = state_74035__$1;
(statearr_74071_74118[(2)] = inst_73995);

(statearr_74071_74118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (9))){
var state_74035__$1 = state_74035;
var statearr_74072_74119 = state_74035__$1;
(statearr_74072_74119[(2)] = (0));

(statearr_74072_74119[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (5))){
var _ = (function (){var statearr_74073 = state_74035;
(statearr_74073[(4)] = cljs.core.rest((state_74035[(4)])));

return statearr_74073;
})();
var state_74035__$1 = state_74035;
var ex74070 = (state_74035__$1[(2)]);
var statearr_74074_74120 = state_74035__$1;
(statearr_74074_74120[(5)] = ex74070);


if((ex74070 instanceof Error)){
var statearr_74075_74121 = state_74035__$1;
(statearr_74075_74121[(1)] = (4));

(statearr_74075_74121[(5)] = null);

} else {
throw ex74070;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (14))){
var inst_73993 = (state_74035[(2)]);
var state_74035__$1 = state_74035;
var statearr_74076_74122 = state_74035__$1;
(statearr_74076_74122[(2)] = inst_73993);

(statearr_74076_74122[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (26))){
var state_74035__$1 = state_74035;
var statearr_74077_74123 = state_74035__$1;
(statearr_74077_74123[(2)] = null);

(statearr_74077_74123[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (16))){
var inst_73980 = (state_74035[(8)]);
var state_74035__$1 = state_74035;
var statearr_74078_74124 = state_74035__$1;
(statearr_74078_74124[(2)] = inst_73980);

(statearr_74078_74124[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (30))){
var state_74035__$1 = state_74035;
var statearr_74079_74125 = state_74035__$1;
(statearr_74079_74125[(2)] = null);

(statearr_74079_74125[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (10))){
var state_74035__$1 = state_74035;
if(cljs.core.truth_(auth)){
var statearr_74080_74126 = state_74035__$1;
(statearr_74080_74126[(1)] = (12));

} else {
var statearr_74081_74127 = state_74035__$1;
(statearr_74081_74127[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (18))){
var inst_73990 = (state_74035[(2)]);
var state_74035__$1 = state_74035;
var statearr_74082_74128 = state_74035__$1;
(statearr_74082_74128[(2)] = inst_73990);

(statearr_74082_74128[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74036 === (8))){
var inst_73997 = (state_74035[(2)]);
var state_74035__$1 = (function (){var statearr_74083 = state_74035;
(statearr_74083[(7)] = inst_73997);

return statearr_74083;
})();
if(cljs.core.truth_(roles)){
var statearr_74084_74129 = state_74035__$1;
(statearr_74084_74129[(1)] = (19));

} else {
var statearr_74085_74130 = state_74035__$1;
(statearr_74085_74130[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_74086 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74086[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_74086[(1)] = (1));

return statearr_74086;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_74035){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74035);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74087){var ex__2730__auto__ = e74087;
var statearr_74088_74131 = state_74035;
(statearr_74088_74131[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74035[(4)]))){
var statearr_74089_74132 = state_74035;
(statearr_74089_74132[(1)] = cljs.core.first((state_74035[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74133 = state_74035;
state_74035 = G__74133;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_74035){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_74035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74090 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74090[(6)] = c__2749__auto__);

return statearr_74090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__74134 = db;
var map__74134__$1 = cljs.core.__destructure_map(map__74134);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74134__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74134__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74134__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74141){
var state_val_74142 = (state_74141[(1)]);
if((state_val_74142 === (1))){
var inst_74135 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_74136 = fluree.db.session.db(conn,inst_74135,null);
var state_74141__$1 = state_74141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74141__$1,(2),inst_74136);
} else {
if((state_val_74142 === (2))){
var inst_74138 = (state_74141[(2)]);
var inst_74139 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_74138);
var state_74141__$1 = state_74141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74141__$1,inst_74139);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_74143 = [null,null,null,null,null,null,null];
(statearr_74143[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_74143[(1)] = (1));

return statearr_74143;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_74141){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74141);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74144){var ex__2730__auto__ = e74144;
var statearr_74145_74172 = state_74141;
(statearr_74145_74172[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74141[(4)]))){
var statearr_74146_74173 = state_74141;
(statearr_74146_74173[(1)] = cljs.core.first((state_74141[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74174 = state_74141;
state_74141 = G__74174;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_74141){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_74141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74147 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74147[(6)] = c__2749__auto__);

return statearr_74147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74160){
var state_val_74161 = (state_74160[(1)]);
if((state_val_74161 === (1))){
var inst_74148 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_74149 = fluree.db.session.db(conn,inst_74148,null);
var state_74160__$1 = state_74160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74160__$1,(2),inst_74149);
} else {
if((state_val_74161 === (2))){
var inst_74151 = (state_74160[(7)]);
var inst_74151__$1 = (state_74160[(2)]);
var inst_74152 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74151__$1);
var inst_74153 = newer_block_QMARK_(inst_74152);
var state_74160__$1 = (function (){var statearr_74162 = state_74160;
(statearr_74162[(7)] = inst_74151__$1);

return statearr_74162;
})();
if(inst_74153){
var statearr_74163_74175 = state_74160__$1;
(statearr_74163_74175[(1)] = (3));

} else {
var statearr_74164_74176 = state_74160__$1;
(statearr_74164_74176[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74161 === (3))){
var inst_74151 = (state_74160[(7)]);
var inst_74155 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_74151);
var state_74160__$1 = state_74160;
var statearr_74165_74177 = state_74160__$1;
(statearr_74165_74177[(2)] = inst_74155);

(statearr_74165_74177[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74161 === (4))){
var state_74160__$1 = state_74160;
var statearr_74166_74178 = state_74160__$1;
(statearr_74166_74178[(2)] = null);

(statearr_74166_74178[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74161 === (5))){
var inst_74158 = (state_74160[(2)]);
var state_74160__$1 = state_74160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74160__$1,inst_74158);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_74167 = [null,null,null,null,null,null,null,null];
(statearr_74167[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_74167[(1)] = (1));

return statearr_74167;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_74160){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74160);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74168){var ex__2730__auto__ = e74168;
var statearr_74169_74179 = state_74160;
(statearr_74169_74179[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74160[(4)]))){
var statearr_74170_74180 = state_74160;
(statearr_74170_74180[(1)] = cljs.core.first((state_74160[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74181 = state_74160;
state_74160 = G__74181;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_74160){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_74160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74171 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74171[(6)] = c__2749__auto__);

return statearr_74171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__74182 = db;
var map__74182__$1 = cljs.core.__destructure_map(map__74182);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74182__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74182__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74182__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___74258 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74232){
var state_val_74233 = (state_74232[(1)]);
if((state_val_74233 === (7))){
var inst_74198 = (state_74232[(7)]);
var inst_74209 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74198,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_74232__$1 = state_74232;
if(inst_74209){
var statearr_74234_74259 = state_74232__$1;
(statearr_74234_74259[(1)] = (9));

} else {
var statearr_74235_74260 = state_74232__$1;
(statearr_74235_74260[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (1))){
var inst_74183 = (state_74232[(8)]);
var inst_74191 = (state_74232[(9)]);
var inst_74183__$1 = cljs.core.async.timeout(timeout);
var inst_74191__$1 = res_port;
var inst_74192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74193 = [inst_74183__$1,inst_74191__$1];
var inst_74194 = (new cljs.core.PersistentVector(null,2,(5),inst_74192,inst_74193,null));
var state_74232__$1 = (function (){var statearr_74236 = state_74232;
(statearr_74236[(8)] = inst_74183__$1);

(statearr_74236[(9)] = inst_74191__$1);

return statearr_74236;
})();
return cljs.core.async.ioc_alts_BANG_(state_74232__$1,(2),inst_74194);
} else {
if((state_val_74233 === (4))){
var inst_74191 = (state_74232[(9)]);
var inst_74198 = (state_74232[(7)]);
var inst_74202 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74198,inst_74191);
var state_74232__$1 = state_74232;
if(inst_74202){
var statearr_74237_74261 = state_74232__$1;
(statearr_74237_74261[(1)] = (6));

} else {
var statearr_74238_74262 = state_74232__$1;
(statearr_74238_74262[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (13))){
var inst_74217 = (state_74232[(10)]);
var inst_74228 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74217);
var state_74232__$1 = state_74232;
var statearr_74239_74263 = state_74232__$1;
(statearr_74239_74263[(2)] = inst_74228);

(statearr_74239_74263[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (6))){
var inst_74196 = (state_74232[(11)]);
var inst_74207 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74196,(0),null);
var state_74232__$1 = state_74232;
var statearr_74240_74264 = state_74232__$1;
(statearr_74240_74264[(2)] = inst_74207);

(statearr_74240_74264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (3))){
var state_74232__$1 = state_74232;
var statearr_74241_74265 = state_74232__$1;
(statearr_74241_74265[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_74241_74265[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (12))){
var inst_74221 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_74222 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74223 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_74224 = cljs.core.PersistentHashMap.fromArrays(inst_74222,inst_74223);
var inst_74225 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74221,inst_74224);
var inst_74226 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74225);
var state_74232__$1 = state_74232;
var statearr_74242_74266 = state_74232__$1;
(statearr_74242_74266[(2)] = inst_74226);

(statearr_74242_74266[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (2))){
var inst_74196 = (state_74232[(11)]);
var inst_74183 = (state_74232[(8)]);
var inst_74198 = (state_74232[(7)]);
var inst_74196__$1 = (state_74232[(2)]);
var inst_74197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74196__$1,(0),null);
var inst_74198__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74196__$1,(1),null);
var inst_74199 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74198__$1,inst_74183);
var state_74232__$1 = (function (){var statearr_74243 = state_74232;
(statearr_74243[(11)] = inst_74196__$1);

(statearr_74243[(12)] = inst_74197);

(statearr_74243[(7)] = inst_74198__$1);

return statearr_74243;
})();
if(inst_74199){
var statearr_74244_74267 = state_74232__$1;
(statearr_74244_74267[(1)] = (3));

} else {
var statearr_74245_74268 = state_74232__$1;
(statearr_74245_74268[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (11))){
var inst_74213 = (state_74232[(2)]);
var state_74232__$1 = state_74232;
var statearr_74246_74269 = state_74232__$1;
(statearr_74246_74269[(2)] = inst_74213);

(statearr_74246_74269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (9))){
var inst_74197 = (state_74232[(12)]);
var state_74232__$1 = state_74232;
var statearr_74247_74270 = state_74232__$1;
(statearr_74247_74270[(2)] = inst_74197);

(statearr_74247_74270[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (5))){
var inst_74217 = (state_74232[(10)]);
var inst_74217__$1 = (state_74232[(2)]);
var inst_74218 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_74219 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_74217__$1);
var state_74232__$1 = (function (){var statearr_74248 = state_74232;
(statearr_74248[(10)] = inst_74217__$1);

(statearr_74248[(13)] = inst_74218);

return statearr_74248;
})();
if(inst_74219){
var statearr_74249_74271 = state_74232__$1;
(statearr_74249_74271[(1)] = (12));

} else {
var statearr_74250_74272 = state_74232__$1;
(statearr_74250_74272[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (14))){
var inst_74230 = (state_74232[(2)]);
var state_74232__$1 = state_74232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74232__$1,inst_74230);
} else {
if((state_val_74233 === (10))){
var state_74232__$1 = state_74232;
var statearr_74251_74273 = state_74232__$1;
(statearr_74251_74273[(2)] = null);

(statearr_74251_74273[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74233 === (8))){
var inst_74215 = (state_74232[(2)]);
var state_74232__$1 = state_74232;
var statearr_74252_74274 = state_74232__$1;
(statearr_74252_74274[(2)] = inst_74215);

(statearr_74252_74274[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_74253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74253[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_74253[(1)] = (1));

return statearr_74253;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_74232){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74232);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74254){var ex__2730__auto__ = e74254;
var statearr_74255_74275 = state_74232;
(statearr_74255_74275[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74232[(4)]))){
var statearr_74256_74276 = state_74232;
(statearr_74256_74276[(1)] = cljs.core.first((state_74232[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74277 = state_74232;
state_74232 = G__74277;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_74232){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_74232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74257 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74257[(6)] = c__2749__auto___74258);

return statearr_74257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__74279 = arguments.length;
switch (G__74279) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__74280){
var map__74281 = p__74280;
var map__74281__$1 = cljs.core.__destructure_map(map__74281);
var opts = map__74281__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74281__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74281__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74281__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74281__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74281__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___74370 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74332){
var state_val_74333 = (state_74332[(1)]);
if((state_val_74333 === (7))){
var inst_74294 = (state_74332[(7)]);
var inst_74296 = fluree.db.api.ledger.syncTo_db(inst_74294,syncTo,syncTimeout);
var state_74332__$1 = state_74332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74332__$1,(10),inst_74296);
} else {
if((state_val_74333 === (20))){
var inst_74318 = (state_74332[(8)]);
var state_74332__$1 = state_74332;
var statearr_74334_74371 = state_74332__$1;
(statearr_74334_74371[(2)] = inst_74318);

(statearr_74334_74371[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (1))){
var state_74332__$1 = state_74332;
var statearr_74335_74372 = state_74332__$1;
(statearr_74335_74372[(2)] = null);

(statearr_74335_74372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (4))){
var inst_74282 = (state_74332[(2)]);
var inst_74283 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74282);
var inst_74284 = cljs.core.async.close_BANG_(pc);
var state_74332__$1 = (function (){var statearr_74336 = state_74332;
(statearr_74336[(9)] = inst_74283);

return statearr_74336;
})();
var statearr_74337_74373 = state_74332__$1;
(statearr_74337_74373[(2)] = inst_74284);

(statearr_74337_74373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (15))){
var inst_74310 = (state_74332[(10)]);
var inst_74312 = fluree.db.api.ledger.add_db_permissions(inst_74310,auth,roles);
var state_74332__$1 = state_74332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74332__$1,(18),inst_74312);
} else {
if((state_val_74333 === (21))){
var inst_74326 = (state_74332[(2)]);
var inst_74327 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74326);
var _ = (function (){var statearr_74338 = state_74332;
(statearr_74338[(4)] = cljs.core.rest((state_74332[(4)])));

return statearr_74338;
})();
var state_74332__$1 = state_74332;
var statearr_74339_74374 = state_74332__$1;
(statearr_74339_74374[(2)] = inst_74327);

(statearr_74339_74374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (13))){
var inst_74310 = (state_74332[(2)]);
var state_74332__$1 = (function (){var statearr_74340 = state_74332;
(statearr_74340[(10)] = inst_74310);

return statearr_74340;
})();
if(cljs.core.truth_(roles)){
var statearr_74341_74375 = state_74332__$1;
(statearr_74341_74375[(1)] = (15));

} else {
var statearr_74342_74376 = state_74332__$1;
(statearr_74342_74376[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (22))){
var inst_74322 = (state_74332[(2)]);
var inst_74323 = fluree.db.util.async.throw_err(inst_74322);
var state_74332__$1 = state_74332;
var statearr_74343_74377 = state_74332__$1;
(statearr_74343_74377[(2)] = inst_74323);

(statearr_74343_74377[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (6))){
var inst_74293 = (state_74332[(2)]);
var inst_74294 = fluree.db.util.async.throw_err(inst_74293);
var state_74332__$1 = (function (){var statearr_74344 = state_74332;
(statearr_74344[(7)] = inst_74294);

return statearr_74344;
})();
if(cljs.core.truth_(syncTo)){
var statearr_74345_74378 = state_74332__$1;
(statearr_74345_74378[(1)] = (7));

} else {
var statearr_74346_74379 = state_74332__$1;
(statearr_74346_74379[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (17))){
var inst_74318 = (state_74332[(2)]);
var state_74332__$1 = (function (){var statearr_74347 = state_74332;
(statearr_74347[(8)] = inst_74318);

return statearr_74347;
})();
if(cljs.core.truth_(auth)){
var statearr_74348_74380 = state_74332__$1;
(statearr_74348_74380[(1)] = (19));

} else {
var statearr_74349_74381 = state_74332__$1;
(statearr_74349_74381[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (3))){
var inst_74330 = (state_74332[(2)]);
var state_74332__$1 = state_74332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74332__$1,inst_74330);
} else {
if((state_val_74333 === (12))){
var inst_74302 = (state_74332[(11)]);
var state_74332__$1 = state_74332;
var statearr_74350_74382 = state_74332__$1;
(statearr_74350_74382[(2)] = inst_74302);

(statearr_74350_74382[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (2))){
var _ = (function (){var statearr_74351 = state_74332;
(statearr_74351[(4)] = cljs.core.cons((5),(state_74332[(4)])));

return statearr_74351;
})();
var inst_74291 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_74332__$1 = state_74332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74332__$1,(6),inst_74291);
} else {
if((state_val_74333 === (19))){
var inst_74318 = (state_74332[(8)]);
var inst_74320 = fluree.db.api.ledger.add_db_permissions(inst_74318,auth,roles);
var state_74332__$1 = state_74332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74332__$1,(22),inst_74320);
} else {
if((state_val_74333 === (11))){
var inst_74302 = (state_74332[(11)]);
var inst_74304 = fluree.db.time_travel.as_of_block(inst_74302,block);
var state_74332__$1 = state_74332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74332__$1,(14),inst_74304);
} else {
if((state_val_74333 === (9))){
var inst_74302 = (state_74332[(2)]);
var state_74332__$1 = (function (){var statearr_74353 = state_74332;
(statearr_74353[(11)] = inst_74302);

return statearr_74353;
})();
if(cljs.core.truth_(block)){
var statearr_74354_74383 = state_74332__$1;
(statearr_74354_74383[(1)] = (11));

} else {
var statearr_74355_74384 = state_74332__$1;
(statearr_74355_74384[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (5))){
var _ = (function (){var statearr_74356 = state_74332;
(statearr_74356[(4)] = cljs.core.rest((state_74332[(4)])));

return statearr_74356;
})();
var state_74332__$1 = state_74332;
var ex74352 = (state_74332__$1[(2)]);
var statearr_74357_74385 = state_74332__$1;
(statearr_74357_74385[(5)] = ex74352);


var statearr_74358_74386 = state_74332__$1;
(statearr_74358_74386[(1)] = (4));

(statearr_74358_74386[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (14))){
var inst_74306 = (state_74332[(2)]);
var inst_74307 = fluree.db.util.async.throw_err(inst_74306);
var state_74332__$1 = state_74332;
var statearr_74359_74387 = state_74332__$1;
(statearr_74359_74387[(2)] = inst_74307);

(statearr_74359_74387[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (16))){
var inst_74310 = (state_74332[(10)]);
var state_74332__$1 = state_74332;
var statearr_74360_74388 = state_74332__$1;
(statearr_74360_74388[(2)] = inst_74310);

(statearr_74360_74388[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (10))){
var inst_74298 = (state_74332[(2)]);
var inst_74299 = fluree.db.util.async.throw_err(inst_74298);
var state_74332__$1 = state_74332;
var statearr_74361_74389 = state_74332__$1;
(statearr_74361_74389[(2)] = inst_74299);

(statearr_74361_74389[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (18))){
var inst_74314 = (state_74332[(2)]);
var inst_74315 = fluree.db.util.async.throw_err(inst_74314);
var state_74332__$1 = state_74332;
var statearr_74362_74390 = state_74332__$1;
(statearr_74362_74390[(2)] = inst_74315);

(statearr_74362_74390[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74333 === (8))){
var inst_74294 = (state_74332[(7)]);
var state_74332__$1 = state_74332;
var statearr_74363_74391 = state_74332__$1;
(statearr_74363_74391[(2)] = inst_74294);

(statearr_74363_74391[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_74364 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74364[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_74364[(1)] = (1));

return statearr_74364;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_74332){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74332);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74365){var ex__2730__auto__ = e74365;
var statearr_74366_74392 = state_74332;
(statearr_74366_74392[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74332[(4)]))){
var statearr_74367_74393 = state_74332;
(statearr_74367_74393[(1)] = cljs.core.first((state_74332[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74394 = state_74332;
state_74332 = G__74394;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_74332){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_74332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74368 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74368[(6)] = c__2749__auto___74370);

return statearr_74368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

