// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28010 = arguments.length;
var i__5770__auto___28011 = (0);
while(true){
if((i__5770__auto___28011 < len__5769__auto___28010)){
args__5775__auto__.push((arguments[i__5770__auto___28011]));

var G__28012 = (i__5770__auto___28011 + (1));
i__5770__auto___28011 = G__28012;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__28005_28013 = e;
var G__28006_28014 = "Function Error: ";
var G__28007_28015 = function_name;
var G__28008_28016 = "args: ";
var G__28009_28017 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__28005_28013,G__28006_28014,G__28007_28015,G__28008_28016,G__28009_28017) : fluree.db.util.log.error.call(null,G__28005_28013,G__28006_28014,G__28007_28015,G__28008_28016,G__28009_28017));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28002){
var G__28003 = cljs.core.first(seq28002);
var seq28002__$1 = cljs.core.next(seq28002);
var G__28004 = cljs.core.first(seq28002__$1);
var seq28002__$2 = cljs.core.next(seq28002__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28003,G__28004,seq28002__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28018){var e = e28018;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28019){var e = e28019;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28020){var e = e28020;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28021){var e = e28021;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28022){var e = e28022;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28025 = arguments.length;
var i__5770__auto___28026 = (0);
while(true){
if((i__5770__auto___28026 < len__5769__auto___28025)){
args__5775__auto__.push((arguments[i__5770__auto___28026]));

var G__28027 = (i__5770__auto___28026 + (1));
i__5770__auto___28026 = G__28027;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28024){var e = e28024;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28023){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28023));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28030 = arguments.length;
var i__5770__auto___28031 = (0);
while(true){
if((i__5770__auto___28031 < len__5769__auto___28030)){
args__5775__auto__.push((arguments[i__5770__auto___28031]));

var G__28032 = (i__5770__auto___28031 + (1));
i__5770__auto___28031 = G__28032;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28029){var e = e28029;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28028){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28028));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28033){var e = e28033;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28036 = arguments.length;
var i__5770__auto___28037 = (0);
while(true){
if((i__5770__auto___28037 < len__5769__auto___28036)){
args__5775__auto__.push((arguments[i__5770__auto___28037]));

var G__28038 = (i__5770__auto___28037 + (1));
i__5770__auto___28037 = G__28038;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28035){var e = e28035;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28034){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28034));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28041 = arguments.length;
var i__5770__auto___28042 = (0);
while(true){
if((i__5770__auto___28042 < len__5769__auto___28041)){
args__5775__auto__.push((arguments[i__5770__auto___28042]));

var G__28043 = (i__5770__auto___28042 + (1));
i__5770__auto___28042 = G__28043;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28040){var e = e28040;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28039){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28039));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28044){var e = e28044;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28045){var e = e28045;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28048 = arguments.length;
var i__5770__auto___28049 = (0);
while(true){
if((i__5770__auto___28049 < len__5769__auto___28048)){
args__5775__auto__.push((arguments[i__5770__auto___28049]));

var G__28050 = (i__5770__auto___28049 + (1));
i__5770__auto___28049 = G__28050;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28047){var e = e28047;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28046){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28046));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28053 = arguments.length;
var i__5770__auto___28054 = (0);
while(true){
if((i__5770__auto___28054 < len__5769__auto___28053)){
args__5775__auto__.push((arguments[i__5770__auto___28054]));

var G__28055 = (i__5770__auto___28054 + (1));
i__5770__auto___28054 = G__28055;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28052){var e = e28052;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28051){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28051));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28058 = arguments.length;
var i__5770__auto___28059 = (0);
while(true){
if((i__5770__auto___28059 < len__5769__auto___28058)){
args__5775__auto__.push((arguments[i__5770__auto___28059]));

var G__28060 = (i__5770__auto___28059 + (1));
i__5770__auto___28059 = G__28060;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28057){var e = e28057;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28056){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28056));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28063 = arguments.length;
var i__5770__auto___28064 = (0);
while(true){
if((i__5770__auto___28064 < len__5769__auto___28063)){
args__5775__auto__.push((arguments[i__5770__auto___28064]));

var G__28065 = (i__5770__auto___28064 + (1));
i__5770__auto___28064 = G__28065;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28062){var e = e28062;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28061){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28061));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28068 = arguments.length;
var i__5770__auto___28069 = (0);
while(true){
if((i__5770__auto___28069 < len__5769__auto___28068)){
args__5775__auto__.push((arguments[i__5770__auto___28069]));

var G__28070 = (i__5770__auto___28069 + (1));
i__5770__auto___28069 = G__28070;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28067){var e = e28067;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28066){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28066));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28073 = arguments.length;
var i__5770__auto___28074 = (0);
while(true){
if((i__5770__auto___28074 < len__5769__auto___28073)){
args__5775__auto__.push((arguments[i__5770__auto___28074]));

var G__28075 = (i__5770__auto___28074 + (1));
i__5770__auto___28074 = G__28075;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28072){var e = e28072;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28071){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28071));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28078 = arguments.length;
var i__5770__auto___28079 = (0);
while(true){
if((i__5770__auto___28079 < len__5769__auto___28078)){
args__5775__auto__.push((arguments[i__5770__auto___28079]));

var G__28080 = (i__5770__auto___28079 + (1));
i__5770__auto___28079 = G__28080;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28077){var e = e28077;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28076){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28076));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28082 = arguments.length;
switch (G__28082) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28110){
var state_val_28111 = (state_28110[(1)]);
if((state_val_28111 === (7))){
var inst_28095 = (state_28110[(7)]);
var inst_28098 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28095,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28110__$1 = state_28110;
var statearr_28112_28198 = state_28110__$1;
(statearr_28112_28198[(2)] = inst_28098);

(statearr_28112_28198[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28111 === (1))){
var state_28110__$1 = state_28110;
var statearr_28113_28199 = state_28110__$1;
(statearr_28113_28199[(2)] = null);

(statearr_28113_28199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28111 === (4))){
var inst_28083 = (state_28110[(2)]);
var state_28110__$1 = state_28110;
var statearr_28114_28200 = state_28110__$1;
(statearr_28114_28200[(2)] = inst_28083);

(statearr_28114_28200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28111 === (6))){
var inst_28095 = (state_28110[(7)]);
var inst_28095__$1 = (state_28110[(2)]);
var inst_28096 = fluree.db.util.core.exception_QMARK_(inst_28095__$1);
var state_28110__$1 = (function (){var statearr_28115 = state_28110;
(statearr_28115[(7)] = inst_28095__$1);

return statearr_28115;
})();
if(inst_28096){
var statearr_28116_28201 = state_28110__$1;
(statearr_28116_28201[(1)] = (7));

} else {
var statearr_28117_28202 = state_28110__$1;
(statearr_28117_28202[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28111 === (3))){
var inst_28108 = (state_28110[(2)]);
var state_28110__$1 = state_28110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28110__$1,inst_28108);
} else {
if((state_val_28111 === (2))){
var inst_28089 = (state_28110[(8)]);
var _ = (function (){var statearr_28119 = state_28110;
(statearr_28119[(4)] = cljs.core.cons((5),(state_28110[(4)])));

return statearr_28119;
})();
var inst_28089__$1 = cljs.core.volatile_BANG_((0));
var inst_28090 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28091 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28090,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28089__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28092 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28091);
var inst_28093 = fluree.db.query.fql.query(db,inst_28092);
var state_28110__$1 = (function (){var statearr_28120 = state_28110;
(statearr_28120[(8)] = inst_28089__$1);

return statearr_28120;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28110__$1,(6),inst_28093);
} else {
if((state_val_28111 === (9))){
var inst_28105 = (state_28110[(2)]);
var _ = (function (){var statearr_28121 = state_28110;
(statearr_28121[(4)] = cljs.core.rest((state_28110[(4)])));

return statearr_28121;
})();
var state_28110__$1 = state_28110;
var statearr_28122_28203 = state_28110__$1;
(statearr_28122_28203[(2)] = inst_28105);

(statearr_28122_28203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28111 === (5))){
var _ = (function (){var statearr_28123 = state_28110;
(statearr_28123[(4)] = cljs.core.rest((state_28110[(4)])));

return statearr_28123;
})();
var state_28110__$1 = state_28110;
var ex28118 = (state_28110__$1[(2)]);
var statearr_28124_28204 = state_28110__$1;
(statearr_28124_28204[(5)] = ex28118);


if((ex28118 instanceof Error)){
var statearr_28125_28205 = state_28110__$1;
(statearr_28125_28205[(1)] = (4));

(statearr_28125_28205[(5)] = null);

} else {
throw ex28118;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28111 === (8))){
var inst_28089 = (state_28110[(8)]);
var inst_28095 = (state_28110[(7)]);
var inst_28100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28101 = cljs.core.deref(inst_28089);
var inst_28102 = [inst_28095,inst_28101];
var inst_28103 = (new cljs.core.PersistentVector(null,2,(5),inst_28100,inst_28102,null));
var state_28110__$1 = state_28110;
var statearr_28126_28206 = state_28110__$1;
(statearr_28126_28206[(2)] = inst_28103);

(statearr_28126_28206[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28127 = [null,null,null,null,null,null,null,null,null];
(statearr_28127[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28127[(1)] = (1));

return statearr_28127;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28110){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28110);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28128){var ex__2730__auto__ = e28128;
var statearr_28129_28207 = state_28110;
(statearr_28129_28207[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28110[(4)]))){
var statearr_28130_28208 = state_28110;
(statearr_28130_28208[(1)] = cljs.core.first((state_28110[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28209 = state_28110;
state_28110 = G__28209;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28110){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28131 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28131[(6)] = c__2749__auto__);

return statearr_28131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28176){
var state_val_28177 = (state_28176[(1)]);
if((state_val_28177 === (7))){
var inst_28162 = (state_28176[(2)]);
var inst_28163 = fluree.db.query.fql.query(db,inst_28162);
var state_28176__$1 = state_28176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28176__$1,(8),inst_28163);
} else {
if((state_val_28177 === (1))){
var inst_28132 = typeof select === 'string';
var state_28176__$1 = state_28176;
if(cljs.core.truth_(inst_28132)){
var statearr_28178_28210 = state_28176__$1;
(statearr_28178_28210[(1)] = (2));

} else {
var statearr_28179_28211 = state_28176__$1;
(statearr_28179_28211[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (4))){
var inst_28138 = (state_28176[(7)]);
var inst_28145 = (state_28176[(8)]);
var inst_28137 = (state_28176[(2)]);
var inst_28138__$1 = cljs.core.volatile_BANG_((0));
var inst_28139 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28140 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28141 = [inst_28138__$1,(100000)];
var inst_28142 = cljs.core.PersistentHashMap.fromArrays(inst_28140,inst_28141);
var inst_28143 = [inst_28137,from,where,block,limit,inst_28142];
var inst_28144 = cljs.core.PersistentHashMap.fromArrays(inst_28139,inst_28143);
var inst_28145__$1 = fluree.db.util.core.without_nils(inst_28144);
var inst_28146 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28145__$1);
var inst_28147 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28145__$1);
var inst_28148 = cljs.core.first(inst_28147);
var inst_28149 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28148], 0));
var inst_28150 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28149);
var inst_28151 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28145__$1);
var inst_28152 = cljs.core.last(inst_28151);
var inst_28153 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28152], 0));
var inst_28154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28153);
var inst_28155 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28146,inst_28150,inst_28154], 0));
var state_28176__$1 = (function (){var statearr_28180 = state_28176;
(statearr_28180[(7)] = inst_28138__$1);

(statearr_28180[(8)] = inst_28145__$1);

return statearr_28180;
})();
if(cljs.core.truth_(inst_28155)){
var statearr_28181_28212 = state_28176__$1;
(statearr_28181_28212[(1)] = (5));

} else {
var statearr_28182_28213 = state_28176__$1;
(statearr_28182_28213[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (6))){
var inst_28145 = (state_28176[(8)]);
var state_28176__$1 = state_28176;
var statearr_28183_28214 = state_28176__$1;
(statearr_28183_28214[(2)] = inst_28145);

(statearr_28183_28214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (3))){
var state_28176__$1 = state_28176;
var statearr_28184_28215 = state_28176__$1;
(statearr_28184_28215[(2)] = select);

(statearr_28184_28215[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (2))){
var inst_28134 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28176__$1 = state_28176;
var statearr_28185_28216 = state_28176__$1;
(statearr_28185_28216[(2)] = inst_28134);

(statearr_28185_28216[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (11))){
var inst_28174 = (state_28176[(2)]);
var state_28176__$1 = state_28176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28176__$1,inst_28174);
} else {
if((state_val_28177 === (9))){
var inst_28165 = (state_28176[(9)]);
var state_28176__$1 = state_28176;
var statearr_28186_28217 = state_28176__$1;
(statearr_28186_28217[(2)] = inst_28165);

(statearr_28186_28217[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (5))){
var inst_28145 = (state_28176[(8)]);
var inst_28157 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28145);
var inst_28158 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28157);
var inst_28159 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28145,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28158);
var state_28176__$1 = state_28176;
var statearr_28187_28218 = state_28176__$1;
(statearr_28187_28218[(2)] = inst_28159);

(statearr_28187_28218[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (10))){
var inst_28165 = (state_28176[(9)]);
var inst_28138 = (state_28176[(7)]);
var inst_28169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28170 = cljs.core.deref(inst_28138);
var inst_28171 = [inst_28165,inst_28170];
var inst_28172 = (new cljs.core.PersistentVector(null,2,(5),inst_28169,inst_28171,null));
var state_28176__$1 = state_28176;
var statearr_28188_28219 = state_28176__$1;
(statearr_28188_28219[(2)] = inst_28172);

(statearr_28188_28219[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28177 === (8))){
var inst_28165 = (state_28176[(9)]);
var inst_28165__$1 = (state_28176[(2)]);
var inst_28166 = fluree.db.util.core.exception_QMARK_(inst_28165__$1);
var state_28176__$1 = (function (){var statearr_28189 = state_28176;
(statearr_28189[(9)] = inst_28165__$1);

return statearr_28189;
})();
if(inst_28166){
var statearr_28190_28220 = state_28176__$1;
(statearr_28190_28220[(1)] = (9));

} else {
var statearr_28191_28221 = state_28176__$1;
(statearr_28191_28221[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28192 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28192[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28192[(1)] = (1));

return statearr_28192;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28176){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28176);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28193){var ex__2730__auto__ = e28193;
var statearr_28194_28222 = state_28176;
(statearr_28194_28222[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28176[(4)]))){
var statearr_28195_28223 = state_28176;
(statearr_28195_28223[(1)] = cljs.core.first((state_28176[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28224 = state_28176;
state_28176 = G__28224;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28176){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28196 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28196[(6)] = c__2749__auto__);

return statearr_28196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28228 = path;
var vec__28229 = G__28228;
var seq__28230 = cljs.core.seq(vec__28229);
var first__28231 = cljs.core.first(seq__28230);
var seq__28230__$1 = cljs.core.next(seq__28230);
var var$ = first__28231;
var r = seq__28230__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28228__$1 = G__28228;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28235 = G__28228__$1;
var seq__28236 = cljs.core.seq(vec__28235);
var first__28237 = cljs.core.first(seq__28236);
var seq__28236__$1 = cljs.core.next(seq__28236);
var var$__$1 = first__28237;
var r__$1 = seq__28236__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28238 = r__$1;
var G__28239 = n__$2;
var G__28240 = next_clauses;
G__28228__$1 = G__28238;
n__$1 = G__28239;
where_clauses__$1 = G__28240;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28241 = r__$1;
var G__28242 = next_n;
var G__28243 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28228__$1 = G__28241;
n__$1 = G__28242;
where_clauses__$1 = G__28243;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28280){
var state_val_28281 = (state_28280[(1)]);
if((state_val_28281 === (7))){
var inst_28253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28254 = [path];
var inst_28255 = (new cljs.core.PersistentVector(null,1,(5),inst_28253,inst_28254,null));
var state_28280__$1 = state_28280;
var statearr_28282_28310 = state_28280__$1;
(statearr_28282_28310[(2)] = inst_28255);

(statearr_28282_28310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (1))){
var state_28280__$1 = state_28280;
var statearr_28283_28311 = state_28280__$1;
(statearr_28283_28311[(2)] = null);

(statearr_28283_28311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (4))){
var inst_28244 = (state_28280[(2)]);
var state_28280__$1 = state_28280;
var statearr_28284_28312 = state_28280__$1;
(statearr_28284_28312[(2)] = inst_28244);

(statearr_28284_28312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (13))){
var inst_28271 = (state_28280[(2)]);
var inst_28272 = fluree.db.util.async.throw_err(inst_28271);
var _ = (function (){var statearr_28285 = state_28280;
(statearr_28285[(4)] = cljs.core.rest((state_28280[(4)])));

return statearr_28285;
})();
var state_28280__$1 = state_28280;
var statearr_28286_28313 = state_28280__$1;
(statearr_28286_28313[(2)] = inst_28272);

(statearr_28286_28313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (6))){
var state_28280__$1 = state_28280;
var statearr_28288_28314 = state_28280__$1;
(statearr_28288_28314[(2)] = path);

(statearr_28288_28314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (3))){
var inst_28278 = (state_28280[(2)]);
var state_28280__$1 = state_28280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28280__$1,inst_28278);
} else {
if((state_val_28281 === (12))){
var _ = (function (){var statearr_28289 = state_28280;
(statearr_28289[(4)] = cljs.core.rest((state_28280[(4)])));

return statearr_28289;
})();
var state_28280__$1 = state_28280;
var ex28287 = (state_28280__$1[(2)]);
var statearr_28290_28315 = state_28280__$1;
(statearr_28290_28315[(5)] = ex28287);


var statearr_28291_28316 = state_28280__$1;
(statearr_28291_28316[(1)] = (11));

(statearr_28291_28316[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (2))){
var _ = (function (){var statearr_28292 = state_28280;
(statearr_28292[(4)] = cljs.core.cons((5),(state_28280[(4)])));

return statearr_28292;
})();
var inst_28250 = cljs.core.vector_QMARK_(path);
var state_28280__$1 = state_28280;
if(inst_28250){
var statearr_28293_28317 = state_28280__$1;
(statearr_28293_28317[(1)] = (6));

} else {
var statearr_28294_28318 = state_28280__$1;
(statearr_28294_28318[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (11))){
var inst_28257 = (state_28280[(7)]);
var inst_28262 = (state_28280[(2)]);
var inst_28263 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28262,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28257,endSubject], 0));
var state_28280__$1 = state_28280;
var statearr_28296_28319 = state_28280__$1;
(statearr_28296_28319[(2)] = inst_28263);

(statearr_28296_28319[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (9))){
var inst_28261 = (state_28280[(8)]);
var _ = (function (){var statearr_28297 = state_28280;
(statearr_28297[(4)] = cljs.core.cons((12),(state_28280[(4)])));

return statearr_28297;
})();
var inst_28269 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28261);
var state_28280__$1 = state_28280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28280__$1,(13),inst_28269);
} else {
if((state_val_28281 === (5))){
var _ = (function (){var statearr_28298 = state_28280;
(statearr_28298[(4)] = cljs.core.rest((state_28280[(4)])));

return statearr_28298;
})();
var state_28280__$1 = state_28280;
var ex28295 = (state_28280__$1[(2)]);
var statearr_28299_28320 = state_28280__$1;
(statearr_28299_28320[(5)] = ex28295);


if((ex28295 instanceof Error)){
var statearr_28300_28321 = state_28280__$1;
(statearr_28300_28321[(1)] = (4));

(statearr_28300_28321[(5)] = null);

} else {
throw ex28295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (10))){
var inst_28275 = (state_28280[(2)]);
var _ = (function (){var statearr_28301 = state_28280;
(statearr_28301[(4)] = cljs.core.rest((state_28280[(4)])));

return statearr_28301;
})();
var state_28280__$1 = state_28280;
var statearr_28302_28322 = state_28280__$1;
(statearr_28302_28322[(2)] = inst_28275);

(statearr_28302_28322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28281 === (8))){
var inst_28257 = (state_28280[(7)]);
var inst_28257__$1 = (state_28280[(2)]);
var inst_28258 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28257__$1,endSubject);
var inst_28259 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28260 = ["?var1",inst_28258];
var inst_28261 = cljs.core.PersistentHashMap.fromArrays(inst_28259,inst_28260);
var state_28280__$1 = (function (){var statearr_28303 = state_28280;
(statearr_28303[(8)] = inst_28261);

(statearr_28303[(7)] = inst_28257__$1);

return statearr_28303;
})();
var statearr_28304_28323 = state_28280__$1;
(statearr_28304_28323[(2)] = null);

(statearr_28304_28323[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_28305 = [null,null,null,null,null,null,null,null,null];
(statearr_28305[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_28305[(1)] = (1));

return statearr_28305;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_28280){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28280);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28306){var ex__2730__auto__ = e28306;
var statearr_28307_28324 = state_28280;
(statearr_28307_28324[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28280[(4)]))){
var statearr_28308_28325 = state_28280;
(statearr_28308_28325[(1)] = cljs.core.first((state_28280[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28326 = state_28280;
state_28280 = G__28326;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = function(state_28280){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_28280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28309 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28309[(6)] = c__2749__auto__);

return statearr_28309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28327){var e = e28327;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28328){var e = e28328;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28329){var e = e28329;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28383){
var state_val_28384 = (state_28383[(1)]);
if((state_val_28384 === (7))){
var state_28383__$1 = state_28383;
var statearr_28385_28423 = state_28383__$1;
(statearr_28385_28423[(2)] = pred);

(statearr_28385_28423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (20))){
var inst_28366 = (state_28383[(7)]);
var inst_28362 = (state_28383[(8)]);
var inst_28370 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_28366,inst_28362);
var state_28383__$1 = state_28383;
var statearr_28386_28424 = state_28383__$1;
(statearr_28386_28424[(2)] = inst_28370);

(statearr_28386_28424[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (1))){
var state_28383__$1 = state_28383;
var statearr_28387_28425 = state_28383__$1;
(statearr_28387_28425[(2)] = null);

(statearr_28387_28425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (4))){
var inst_28330 = (state_28383[(2)]);
var state_28383__$1 = state_28383;
var statearr_28388_28426 = state_28383__$1;
(statearr_28388_28426[(2)] = inst_28330);

(statearr_28388_28426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (15))){
var state_28383__$1 = state_28383;
var statearr_28389_28427 = state_28383__$1;
(statearr_28389_28427[(2)] = fluree.db.flake.o);

(statearr_28389_28427[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (21))){
var inst_28366 = (state_28383[(7)]);
var inst_28362 = (state_28383[(8)]);
var inst_28372 = cljs.core.first(inst_28362);
var inst_28373 = (inst_28366.cljs$core$IFn$_invoke$arity$1 ? inst_28366.cljs$core$IFn$_invoke$arity$1(inst_28372) : inst_28366.call(null,inst_28372));
var state_28383__$1 = state_28383;
var statearr_28390_28428 = state_28383__$1;
(statearr_28390_28428[(2)] = inst_28373);

(statearr_28390_28428[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (13))){
var inst_28359 = (state_28383[(2)]);
var inst_28360 = fluree.db.util.async.throw_err(inst_28359);
var state_28383__$1 = state_28383;
var statearr_28391_28429 = state_28383__$1;
(statearr_28391_28429[(2)] = inst_28360);

(statearr_28391_28429[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (22))){
var inst_28375 = (state_28383[(2)]);
var state_28383__$1 = state_28383;
var statearr_28392_28430 = state_28383__$1;
(statearr_28392_28430[(2)] = inst_28375);

(statearr_28392_28430[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (6))){
var inst_28340 = clojure.string.replace(pred,"/_","/");
var state_28383__$1 = state_28383;
var statearr_28393_28431 = state_28383__$1;
(statearr_28393_28431[(2)] = inst_28340);

(statearr_28393_28431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (17))){
var inst_28344 = (state_28383[(9)]);
var state_28383__$1 = state_28383;
if(cljs.core.truth_(inst_28344)){
var statearr_28394_28432 = state_28383__$1;
(statearr_28394_28432[(1)] = (20));

} else {
var statearr_28395_28433 = state_28383__$1;
(statearr_28395_28433[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (3))){
var inst_28381 = (state_28383[(2)]);
var state_28383__$1 = state_28383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28383__$1,inst_28381);
} else {
if((state_val_28384 === (12))){
var inst_28351 = (state_28383[(2)]);
var inst_28352 = fluree.db.util.async.throw_err(inst_28351);
var state_28383__$1 = state_28383;
var statearr_28396_28434 = state_28383__$1;
(statearr_28396_28434[(2)] = inst_28352);

(statearr_28396_28434[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (2))){
var inst_28338 = (state_28383[(10)]);
var _ = (function (){var statearr_28397 = state_28383;
(statearr_28397[(4)] = cljs.core.cons((5),(state_28383[(4)])));

return statearr_28397;
})();
var inst_28336 = typeof pred === 'string';
var inst_28337 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_28338__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28336,inst_28337], 0));
var state_28383__$1 = (function (){var statearr_28398 = state_28383;
(statearr_28398[(10)] = inst_28338__$1);

return statearr_28398;
})();
if(cljs.core.truth_(inst_28338__$1)){
var statearr_28399_28435 = state_28383__$1;
(statearr_28399_28435[(1)] = (6));

} else {
var statearr_28400_28436 = state_28383__$1;
(statearr_28400_28436[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (19))){
var inst_28378 = (state_28383[(2)]);
var _ = (function (){var statearr_28401 = state_28383;
(statearr_28401[(4)] = cljs.core.rest((state_28383[(4)])));

return statearr_28401;
})();
var state_28383__$1 = state_28383;
var statearr_28402_28437 = state_28383__$1;
(statearr_28402_28437[(2)] = inst_28378);

(statearr_28402_28437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (11))){
var inst_28338 = (state_28383[(10)]);
var inst_28362 = (state_28383[(2)]);
var state_28383__$1 = (function (){var statearr_28404 = state_28383;
(statearr_28404[(8)] = inst_28362);

return statearr_28404;
})();
if(cljs.core.truth_(inst_28338)){
var statearr_28405_28438 = state_28383__$1;
(statearr_28405_28438[(1)] = (14));

} else {
var statearr_28406_28439 = state_28383__$1;
(statearr_28406_28439[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (9))){
var inst_28343 = (state_28383[(11)]);
var inst_28346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28347 = [sid,inst_28343];
var inst_28348 = (new cljs.core.PersistentVector(null,2,(5),inst_28346,inst_28347,null));
var inst_28349 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_28348);
var state_28383__$1 = state_28383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28383__$1,(12),inst_28349);
} else {
if((state_val_28384 === (5))){
var _ = (function (){var statearr_28407 = state_28383;
(statearr_28407[(4)] = cljs.core.rest((state_28383[(4)])));

return statearr_28407;
})();
var state_28383__$1 = state_28383;
var ex28403 = (state_28383__$1[(2)]);
var statearr_28408_28440 = state_28383__$1;
(statearr_28408_28440[(5)] = ex28403);


if((ex28403 instanceof Error)){
var statearr_28409_28441 = state_28383__$1;
(statearr_28409_28441[(1)] = (4));

(statearr_28409_28441[(5)] = null);

} else {
throw ex28403;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (14))){
var state_28383__$1 = state_28383;
var statearr_28410_28442 = state_28383__$1;
(statearr_28410_28442[(2)] = fluree.db.flake.s);

(statearr_28410_28442[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (16))){
var inst_28362 = (state_28383[(8)]);
var inst_28366 = (state_28383[(2)]);
var inst_28367 = cljs.core.seq(inst_28362);
var state_28383__$1 = (function (){var statearr_28411 = state_28383;
(statearr_28411[(7)] = inst_28366);

return statearr_28411;
})();
if(inst_28367){
var statearr_28412_28443 = state_28383__$1;
(statearr_28412_28443[(1)] = (17));

} else {
var statearr_28413_28444 = state_28383__$1;
(statearr_28413_28444[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (10))){
var inst_28343 = (state_28383[(11)]);
var inst_28354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28355 = [sid,inst_28343];
var inst_28356 = (new cljs.core.PersistentVector(null,2,(5),inst_28354,inst_28355,null));
var inst_28357 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28356);
var state_28383__$1 = state_28383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28383__$1,(13),inst_28357);
} else {
if((state_val_28384 === (18))){
var state_28383__$1 = state_28383;
var statearr_28414_28445 = state_28383__$1;
(statearr_28414_28445[(2)] = null);

(statearr_28414_28445[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28384 === (8))){
var inst_28338 = (state_28383[(10)]);
var inst_28343 = (state_28383[(11)]);
var inst_28343__$1 = (state_28383[(2)]);
var inst_28344 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28343__$1);
var state_28383__$1 = (function (){var statearr_28415 = state_28383;
(statearr_28415[(9)] = inst_28344);

(statearr_28415[(11)] = inst_28343__$1);

return statearr_28415;
})();
if(cljs.core.truth_(inst_28338)){
var statearr_28416_28446 = state_28383__$1;
(statearr_28416_28446[(1)] = (9));

} else {
var statearr_28417_28447 = state_28383__$1;
(statearr_28417_28447[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0 = (function (){
var statearr_28418 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28418[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__);

(statearr_28418[(1)] = (1));

return statearr_28418;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1 = (function (state_28383){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28383);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28419){var ex__2730__auto__ = e28419;
var statearr_28420_28448 = state_28383;
(statearr_28420_28448[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28383[(4)]))){
var statearr_28421_28449 = state_28383;
(statearr_28421_28449[(1)] = cljs.core.first((state_28383[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28450 = state_28383;
state_28383 = G__28450;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = function(state_28383){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1.call(this,state_28383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28422 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28422[(6)] = c__2749__auto__);

return statearr_28422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28451){var e = e28451;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28454 = arguments.length;
var i__5770__auto___28455 = (0);
while(true){
if((i__5770__auto___28455 < len__5769__auto___28454)){
args__5775__auto__.push((arguments[i__5770__auto___28455]));

var G__28456 = (i__5770__auto___28455 + (1));
i__5770__auto___28455 = G__28456;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28453){var e = e28453;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28452){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28452));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28459 = arguments.length;
var i__5770__auto___28460 = (0);
while(true){
if((i__5770__auto___28460 < len__5769__auto___28459)){
args__5775__auto__.push((arguments[i__5770__auto___28460]));

var G__28461 = (i__5770__auto___28460 + (1));
i__5770__auto___28460 = G__28461;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28458){var e = e28458;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28457){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28457));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28464 = arguments.length;
var i__5770__auto___28465 = (0);
while(true){
if((i__5770__auto___28465 < len__5769__auto___28464)){
args__5775__auto__.push((arguments[i__5770__auto___28465]));

var G__28466 = (i__5770__auto___28465 + (1));
i__5770__auto___28465 = G__28466;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28463){var e = e28463;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28462){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28462));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28469 = arguments.length;
var i__5770__auto___28470 = (0);
while(true){
if((i__5770__auto___28470 < len__5769__auto___28469)){
args__5775__auto__.push((arguments[i__5770__auto___28470]));

var G__28471 = (i__5770__auto___28470 + (1));
i__5770__auto___28470 = G__28471;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28468){var e = e28468;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28467){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28467));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28472){var e = e28472;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28473){var e = e28473;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28474){var e = e28474;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28475){var e = e28475;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28476){var e = e28476;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28482 = path;
var vec__28483 = G__28482;
var seq__28484 = cljs.core.seq(vec__28483);
var first__28485 = cljs.core.first(seq__28484);
var seq__28484__$1 = cljs.core.next(seq__28484);
var pred = first__28485;
var r = seq__28484__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28482__$1 = G__28482;
var subjects__$1 = subjects;
while(true){
var vec__28489 = G__28482__$1;
var seq__28490 = cljs.core.seq(vec__28489);
var first__28491 = cljs.core.first(seq__28490);
var seq__28490__$1 = cljs.core.next(seq__28490);
var pred__$1 = first__28491;
var r__$1 = seq__28490__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28482__$1,subjects__$1,vec__28489,seq__28490,first__28491,seq__28490__$1,pred__$1,r__$1,subjects__$2,G__28482,vec__28483,seq__28484,first__28485,seq__28484__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28482__$1,subjects__$1,vec__28489,seq__28490,first__28491,seq__28490__$1,pred__$1,r__$1,subjects__$2,G__28482,vec__28483,seq__28484,first__28485,seq__28484__$1,pred,r,subjects){
return (function (p1__28477_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28477_SHARP_,pred__$1);
});})(G__28482__$1,subjects__$1,vec__28489,seq__28490,first__28491,seq__28490__$1,pred__$1,r__$1,subjects__$2,G__28482,vec__28483,seq__28484,first__28485,seq__28484__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28482__$1,subjects__$1,vec__28489,seq__28490,first__28491,seq__28490__$1,pred__$1,r__$1,subjects__$2,G__28482,vec__28483,seq__28484,first__28485,seq__28484__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__28492 = r__$1;
var G__28493 = next_subjects;
G__28482__$1 = G__28492;
subjects__$1 = G__28493;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28478){var e = e28478;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28533){
var state_val_28534 = (state_28533[(1)]);
if((state_val_28534 === (7))){
var state_28533__$1 = state_28533;
var statearr_28535_28554 = state_28533__$1;
(statearr_28535_28554[(2)] = path);

(statearr_28535_28554[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28534 === (1))){
var state_28533__$1 = state_28533;
var statearr_28536_28555 = state_28533__$1;
(statearr_28536_28555[(2)] = null);

(statearr_28536_28555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28534 === (4))){
var inst_28494 = (state_28533[(2)]);
var inst_28495 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28494,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_28533__$1 = state_28533;
var statearr_28537_28556 = state_28533__$1;
(statearr_28537_28556[(2)] = inst_28495);

(statearr_28537_28556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28534 === (6))){
var inst_28512 = (state_28533[(2)]);
var inst_28513 = fluree.db.util.async.throw_err(inst_28512);
var inst_28514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28513,(0),null);
var inst_28515 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28513,(1),null);
var inst_28516 = cljs.core.last(path);
var inst_28517 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_28516);
var state_28533__$1 = (function (){var statearr_28538 = state_28533;
(statearr_28538[(7)] = inst_28514);

(statearr_28538[(8)] = inst_28515);

return statearr_28538;
})();
if(inst_28517){
var statearr_28539_28557 = state_28533__$1;
(statearr_28539_28557[(1)] = (7));

} else {
var statearr_28540_28558 = state_28533__$1;
(statearr_28540_28558[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28534 === (3))){
var inst_28531 = (state_28533[(2)]);
var state_28533__$1 = state_28533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28533__$1,inst_28531);
} else {
if((state_val_28534 === (2))){
var _ = (function (){var statearr_28542 = state_28533;
(statearr_28542[(4)] = cljs.core.cons((5),(state_28533[(4)])));

return statearr_28542;
})();
var inst_28504 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_28505 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28506 = cljs.core.PersistentHashMap.EMPTY;
var inst_28507 = [inst_28504,sid,inst_28506];
var inst_28508 = cljs.core.PersistentHashMap.fromArrays(inst_28505,inst_28507);
var inst_28509 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28510 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28509,inst_28508);
var state_28533__$1 = state_28533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28533__$1,(6),inst_28510);
} else {
if((state_val_28534 === (9))){
var inst_28514 = (state_28533[(7)]);
var inst_28515 = (state_28533[(8)]);
var inst_28522 = (state_28533[(2)]);
var inst_28523 = fluree.db.dbfunctions.internal.get_all(inst_28514,inst_28522);
var inst_28524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28525 = fluree.db.dbfunctions.internal.count(path);
var inst_28526 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28515,inst_28525,(9)], 0));
var inst_28527 = [inst_28523,inst_28526];
var inst_28528 = (new cljs.core.PersistentVector(null,2,(5),inst_28524,inst_28527,null));
var _ = (function (){var statearr_28543 = state_28533;
(statearr_28543[(4)] = cljs.core.rest((state_28533[(4)])));

return statearr_28543;
})();
var state_28533__$1 = state_28533;
var statearr_28544_28559 = state_28533__$1;
(statearr_28544_28559[(2)] = inst_28528);

(statearr_28544_28559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28534 === (5))){
var _ = (function (){var statearr_28545 = state_28533;
(statearr_28545[(4)] = cljs.core.rest((state_28533[(4)])));

return statearr_28545;
})();
var state_28533__$1 = state_28533;
var ex28541 = (state_28533__$1[(2)]);
var statearr_28546_28560 = state_28533__$1;
(statearr_28546_28560[(5)] = ex28541);


var statearr_28547_28561 = state_28533__$1;
(statearr_28547_28561[(1)] = (4));

(statearr_28547_28561[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28534 === (8))){
var inst_28520 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_28533__$1 = state_28533;
var statearr_28548_28562 = state_28533__$1;
(statearr_28548_28562[(2)] = inst_28520);

(statearr_28548_28562[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0 = (function (){
var statearr_28549 = [null,null,null,null,null,null,null,null,null];
(statearr_28549[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__);

(statearr_28549[(1)] = (1));

return statearr_28549;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1 = (function (state_28533){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28533);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28550){var ex__2730__auto__ = e28550;
var statearr_28551_28563 = state_28533;
(statearr_28551_28563[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28533[(4)]))){
var statearr_28552_28564 = state_28533;
(statearr_28552_28564[(1)] = cljs.core.first((state_28533[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28565 = state_28533;
state_28533 = G__28565;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = function(state_28533){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1.call(this,state_28533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28553 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28553[(6)] = c__2749__auto__);

return statearr_28553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28566){var e = e28566;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__28567_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__28567_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__28567_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e28568){var e = e28568;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28571 = arguments.length;
var i__5770__auto___28572 = (0);
while(true){
if((i__5770__auto___28572 < len__5769__auto___28571)){
args__5775__auto__.push((arguments[i__5770__auto___28572]));

var G__28573 = (i__5770__auto___28572 + (1));
i__5770__auto___28572 = G__28573;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28570){var e = e28570;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28569){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28569));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28574){var e = e28574;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28577 = arguments.length;
var i__5770__auto___28578 = (0);
while(true){
if((i__5770__auto___28578 < len__5769__auto___28577)){
args__5775__auto__.push((arguments[i__5770__auto___28578]));

var G__28579 = (i__5770__auto___28578 + (1));
i__5770__auto___28578 = G__28579;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28576){var e = e28576;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28575){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28575));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28580){var e = e28580;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28637){
var state_val_28638 = (state_28637[(1)]);
if((state_val_28638 === (7))){
var inst_28583 = (state_28637[(2)]);
var state_28637__$1 = state_28637;
var statearr_28639_28673 = state_28637__$1;
(statearr_28639_28673[(2)] = inst_28583);

(statearr_28639_28673[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (1))){
var state_28637__$1 = state_28637;
var statearr_28640_28674 = state_28637__$1;
(statearr_28640_28674[(2)] = null);

(statearr_28640_28674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (4))){
var inst_28582 = (state_28637[(2)]);
var state_28637__$1 = (function (){var statearr_28641 = state_28637;
(statearr_28641[(7)] = inst_28582);

return statearr_28641;
})();
var statearr_28642_28675 = state_28637__$1;
(statearr_28642_28675[(2)] = null);

(statearr_28642_28675[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (15))){
var inst_28608 = (state_28637[(8)]);
var inst_28620 = (state_28637[(9)]);
var inst_28605 = (state_28637[(10)]);
var inst_28607 = (state_28637[(11)]);
var inst_28617 = (state_28637[(12)]);
var inst_28618 = (state_28637[(13)]);
var inst_28624 = (function (){var db = inst_28605;
var prevT = inst_28607;
var db_SINGLEQUOTE_ = inst_28608;
var prev_vals = inst_28617;
var fuel = inst_28618;
var G__28619 = inst_28620;
return (function (p1__28581_SHARP_){
var f = p1__28581_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_28625 = (inst_28624.cljs$core$IFn$_invoke$arity$1 ? inst_28624.cljs$core$IFn$_invoke$arity$1(inst_28620) : inst_28624.call(null,inst_28620));
var state_28637__$1 = state_28637;
var statearr_28643_28676 = state_28637__$1;
(statearr_28643_28676[(2)] = inst_28625);

(statearr_28643_28676[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (13))){
var inst_28620 = (state_28637[(9)]);
var inst_28617 = (state_28637[(12)]);
var inst_28616 = (state_28637[(2)]);
var inst_28617__$1 = fluree.db.util.async.throw_err(inst_28616);
var inst_28618 = fluree.db.dbfunctions.internal.count(inst_28617__$1);
var inst_28620__$1 = cljs.core.first(inst_28617__$1);
var inst_28621 = (inst_28620__$1 == null);
var state_28637__$1 = (function (){var statearr_28644 = state_28637;
(statearr_28644[(9)] = inst_28620__$1);

(statearr_28644[(12)] = inst_28617__$1);

(statearr_28644[(13)] = inst_28618);

return statearr_28644;
})();
if(cljs.core.truth_(inst_28621)){
var statearr_28645_28677 = state_28637__$1;
(statearr_28645_28677[(1)] = (14));

} else {
var statearr_28646_28678 = state_28637__$1;
(statearr_28646_28678[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (6))){
var inst_28592 = (state_28637[(2)]);
var state_28637__$1 = state_28637;
var statearr_28647_28679 = state_28637__$1;
(statearr_28647_28679[(2)] = inst_28592);

(statearr_28647_28679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (3))){
var inst_28635 = (state_28637[(2)]);
var state_28637__$1 = state_28637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28637__$1,inst_28635);
} else {
if((state_val_28638 === (12))){
var inst_28632 = (state_28637[(2)]);
var _ = (function (){var statearr_28648 = state_28637;
(statearr_28648[(4)] = cljs.core.rest((state_28637[(4)])));

return statearr_28648;
})();
var state_28637__$1 = state_28637;
var statearr_28649_28680 = state_28637__$1;
(statearr_28649_28680[(2)] = inst_28632);

(statearr_28649_28680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (2))){
var _ = (function (){var statearr_28651 = state_28637;
(statearr_28651[(4)] = cljs.core.cons((9),(state_28637[(4)])));

return statearr_28651;
})();
var inst_28598 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28599 = typeof inst_28598 === 'string';
var state_28637__$1 = state_28637;
if(cljs.core.truth_(inst_28599)){
var statearr_28652_28681 = state_28637__$1;
(statearr_28652_28681[(1)] = (10));

} else {
var statearr_28653_28682 = state_28637__$1;
(statearr_28653_28682[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (11))){
var inst_28608 = (state_28637[(8)]);
var inst_28605 = (state_28637[(10)]);
var inst_28607 = (state_28637[(11)]);
var inst_28605__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28606 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28605__$1);
var inst_28607__$1 = fluree.db.dbfunctions.internal.inc(inst_28606);
var inst_28608__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28605__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28607__$1);
var inst_28609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28610 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28611 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28612 = [inst_28610,inst_28611];
var inst_28613 = (new cljs.core.PersistentVector(null,2,(5),inst_28609,inst_28612,null));
var inst_28614 = fluree.db.dbproto._search(inst_28608__$1,inst_28613);
var state_28637__$1 = (function (){var statearr_28654 = state_28637;
(statearr_28654[(8)] = inst_28608__$1);

(statearr_28654[(10)] = inst_28605__$1);

(statearr_28654[(11)] = inst_28607__$1);

return statearr_28654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28637__$1,(13),inst_28614);
} else {
if((state_val_28638 === (9))){
var _ = (function (){var statearr_28655 = state_28637;
(statearr_28655[(4)] = cljs.core.rest((state_28637[(4)])));

return statearr_28655;
})();
var state_28637__$1 = state_28637;
var ex28650 = (state_28637__$1[(2)]);
var statearr_28656_28683 = state_28637__$1;
(statearr_28656_28683[(5)] = ex28650);


var statearr_28657_28684 = state_28637__$1;
(statearr_28657_28684[(1)] = (4));

(statearr_28657_28684[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (5))){
var inst_28582 = (state_28637[(7)]);
var _ = (function (){var statearr_28658 = state_28637;
(statearr_28658[(4)] = cljs.core.cons((8),(state_28637[(4)])));

return statearr_28658;
})();
var inst_28589 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28582,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_28659 = state_28637;
(statearr_28659[(4)] = cljs.core.rest((state_28637[(4)])));

return statearr_28659;
})();
var state_28637__$1 = state_28637;
var statearr_28660_28685 = state_28637__$1;
(statearr_28660_28685[(2)] = inst_28589);

(statearr_28660_28685[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (14))){
var state_28637__$1 = state_28637;
var statearr_28661_28686 = state_28637__$1;
(statearr_28661_28686[(2)] = null);

(statearr_28661_28686[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (16))){
var inst_28618 = (state_28637[(13)]);
var inst_28627 = (state_28637[(2)]);
var inst_28628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28629 = [inst_28627,inst_28618];
var inst_28630 = (new cljs.core.PersistentVector(null,2,(5),inst_28628,inst_28629,null));
var state_28637__$1 = state_28637;
var statearr_28663_28687 = state_28637__$1;
(statearr_28663_28687[(2)] = inst_28630);

(statearr_28663_28687[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (10))){
var inst_28601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28602 = [null,(0)];
var inst_28603 = (new cljs.core.PersistentVector(null,2,(5),inst_28601,inst_28602,null));
var state_28637__$1 = state_28637;
var statearr_28664_28688 = state_28637__$1;
(statearr_28664_28688[(2)] = inst_28603);

(statearr_28664_28688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28638 === (8))){
var _ = (function (){var statearr_28665 = state_28637;
(statearr_28665[(4)] = cljs.core.rest((state_28637[(4)])));

return statearr_28665;
})();
var state_28637__$1 = state_28637;
var ex28662 = (state_28637__$1[(2)]);
var statearr_28666_28689 = state_28637__$1;
(statearr_28666_28689[(5)] = ex28662);


var statearr_28667_28690 = state_28637__$1;
(statearr_28667_28690[(1)] = (7));

(statearr_28667_28690[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_28668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28668[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_28668[(1)] = (1));

return statearr_28668;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_28637){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28637);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28669){var ex__2730__auto__ = e28669;
var statearr_28670_28691 = state_28637;
(statearr_28670_28691[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28637[(4)]))){
var statearr_28671_28692 = state_28637;
(statearr_28671_28692[(1)] = cljs.core.first((state_28637[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28693 = state_28637;
state_28637 = G__28693;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = function(state_28637){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_28637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28672 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28672[(6)] = c__2749__auto__);

return statearr_28672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28745){
var state_val_28746 = (state_28745[(1)]);
if((state_val_28746 === (7))){
var inst_28695 = (state_28745[(2)]);
var state_28745__$1 = state_28745;
var statearr_28747_28776 = state_28745__$1;
(statearr_28747_28776[(2)] = inst_28695);

(statearr_28747_28776[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (1))){
var state_28745__$1 = state_28745;
var statearr_28748_28777 = state_28745__$1;
(statearr_28748_28777[(2)] = null);

(statearr_28748_28777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (4))){
var inst_28694 = (state_28745[(2)]);
var state_28745__$1 = (function (){var statearr_28749 = state_28745;
(statearr_28749[(7)] = inst_28694);

return statearr_28749;
})();
var statearr_28750_28778 = state_28745__$1;
(statearr_28750_28778[(2)] = null);

(statearr_28750_28778[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (13))){
var inst_28740 = (state_28745[(2)]);
var _ = (function (){var statearr_28751 = state_28745;
(statearr_28751[(4)] = cljs.core.rest((state_28745[(4)])));

return statearr_28751;
})();
var state_28745__$1 = state_28745;
var statearr_28752_28779 = state_28745__$1;
(statearr_28752_28779[(2)] = inst_28740);

(statearr_28752_28779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (6))){
var inst_28704 = (state_28745[(2)]);
var state_28745__$1 = state_28745;
var statearr_28753_28780 = state_28745__$1;
(statearr_28753_28780[(2)] = inst_28704);

(statearr_28753_28780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (3))){
var inst_28743 = (state_28745[(2)]);
var state_28745__$1 = state_28745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28745__$1,inst_28743);
} else {
if((state_val_28746 === (12))){
var inst_28727 = (state_28745[(8)]);
var inst_28736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28737 = [null,inst_28727];
var inst_28738 = (new cljs.core.PersistentVector(null,2,(5),inst_28736,inst_28737,null));
var state_28745__$1 = state_28745;
var statearr_28754_28781 = state_28745__$1;
(statearr_28754_28781[(2)] = inst_28738);

(statearr_28754_28781[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (2))){
var _ = (function (){var statearr_28756 = state_28745;
(statearr_28756[(4)] = cljs.core.cons((9),(state_28745[(4)])));

return statearr_28756;
})();
var inst_28713 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28716 = [null,pred_name,"?o"];
var inst_28717 = (new cljs.core.PersistentVector(null,3,(5),inst_28715,inst_28716,null));
var inst_28718 = [inst_28717];
var inst_28719 = (new cljs.core.PersistentVector(null,1,(5),inst_28714,inst_28718,null));
var inst_28720 = ["?o",inst_28719,opts];
var inst_28721 = cljs.core.PersistentHashMap.fromArrays(inst_28713,inst_28720);
var inst_28722 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28721);
var state_28745__$1 = state_28745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28745__$1,(10),inst_28722);
} else {
if((state_val_28746 === (11))){
var inst_28726 = (state_28745[(9)]);
var inst_28727 = (state_28745[(8)]);
var inst_28731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28732 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_28726);
var inst_28733 = [inst_28732,inst_28727];
var inst_28734 = (new cljs.core.PersistentVector(null,2,(5),inst_28731,inst_28733,null));
var state_28745__$1 = state_28745;
var statearr_28757_28782 = state_28745__$1;
(statearr_28757_28782[(2)] = inst_28734);

(statearr_28757_28782[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (9))){
var _ = (function (){var statearr_28758 = state_28745;
(statearr_28758[(4)] = cljs.core.rest((state_28745[(4)])));

return statearr_28758;
})();
var state_28745__$1 = state_28745;
var ex28755 = (state_28745__$1[(2)]);
var statearr_28759_28783 = state_28745__$1;
(statearr_28759_28783[(5)] = ex28755);


var statearr_28760_28784 = state_28745__$1;
(statearr_28760_28784[(1)] = (4));

(statearr_28760_28784[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (5))){
var inst_28694 = (state_28745[(7)]);
var _ = (function (){var statearr_28762 = state_28745;
(statearr_28762[(4)] = cljs.core.cons((8),(state_28745[(4)])));

return statearr_28762;
})();
var inst_28701 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28694,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_28763 = state_28745;
(statearr_28763[(4)] = cljs.core.rest((state_28745[(4)])));

return statearr_28763;
})();
var state_28745__$1 = state_28745;
var statearr_28764_28785 = state_28745__$1;
(statearr_28764_28785[(2)] = inst_28701);

(statearr_28764_28785[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (10))){
var inst_28726 = (state_28745[(9)]);
var inst_28724 = (state_28745[(2)]);
var inst_28725 = fluree.db.util.async.throw_err(inst_28724);
var inst_28726__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28725,(0),null);
var inst_28727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28725,(1),null);
var inst_28728 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_28726__$1);
var inst_28729 = cljs.core.not(inst_28728);
var state_28745__$1 = (function (){var statearr_28765 = state_28745;
(statearr_28765[(9)] = inst_28726__$1);

(statearr_28765[(8)] = inst_28727);

return statearr_28765;
})();
if(inst_28729){
var statearr_28766_28786 = state_28745__$1;
(statearr_28766_28786[(1)] = (11));

} else {
var statearr_28767_28787 = state_28745__$1;
(statearr_28767_28787[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28746 === (8))){
var _ = (function (){var statearr_28768 = state_28745;
(statearr_28768[(4)] = cljs.core.rest((state_28745[(4)])));

return statearr_28768;
})();
var state_28745__$1 = state_28745;
var ex28761 = (state_28745__$1[(2)]);
var statearr_28769_28788 = state_28745__$1;
(statearr_28769_28788[(5)] = ex28761);


var statearr_28770_28789 = state_28745__$1;
(statearr_28770_28789[(1)] = (7));

(statearr_28770_28789[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_28771 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28771[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__);

(statearr_28771[(1)] = (1));

return statearr_28771;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1 = (function (state_28745){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28745);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28772){var ex__2730__auto__ = e28772;
var statearr_28773_28790 = state_28745;
(statearr_28773_28790[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28745[(4)]))){
var statearr_28774_28791 = state_28745;
(statearr_28774_28791[(1)] = cljs.core.first((state_28745[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28792 = state_28745;
state_28745 = G__28792;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = function(state_28745){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1.call(this,state_28745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28775 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28775[(6)] = c__2749__auto__);

return statearr_28775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e28793){var e = e28793;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28795 = arguments.length;
switch (G__28795) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28865){
var state_val_28866 = (state_28865[(1)]);
if((state_val_28866 === (7))){
var inst_28797 = (state_28865[(2)]);
var state_28865__$1 = state_28865;
var statearr_28867_28911 = state_28865__$1;
(statearr_28867_28911[(2)] = inst_28797);

(statearr_28867_28911[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (20))){
var inst_28841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28842 = ["*"];
var inst_28843 = (new cljs.core.PersistentVector(null,1,(5),inst_28841,inst_28842,null));
var state_28865__$1 = state_28865;
var statearr_28868_28912 = state_28865__$1;
(statearr_28868_28912[(2)] = inst_28843);

(statearr_28868_28912[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (1))){
var state_28865__$1 = state_28865;
var statearr_28869_28913 = state_28865__$1;
(statearr_28869_28913[(2)] = null);

(statearr_28869_28913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (4))){
var inst_28796 = (state_28865[(2)]);
var state_28865__$1 = (function (){var statearr_28870 = state_28865;
(statearr_28870[(7)] = inst_28796);

return statearr_28870;
})();
var statearr_28871_28914 = state_28865__$1;
(statearr_28871_28914[(2)] = null);

(statearr_28871_28914[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (15))){
var inst_28860 = (state_28865[(2)]);
var _ = (function (){var statearr_28872 = state_28865;
(statearr_28872[(4)] = cljs.core.rest((state_28865[(4)])));

return statearr_28872;
})();
var state_28865__$1 = state_28865;
var statearr_28873_28915 = state_28865__$1;
(statearr_28873_28915[(2)] = inst_28860);

(statearr_28873_28915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (21))){
var inst_28831 = (state_28865[(8)]);
var inst_28824 = (state_28865[(9)]);
var inst_28845 = (state_28865[(2)]);
var inst_28846 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28847 = cljs.core.PersistentHashMap.EMPTY;
var inst_28848 = [inst_28845,inst_28831,inst_28847];
var inst_28849 = cljs.core.PersistentHashMap.fromArrays(inst_28846,inst_28848);
var inst_28850 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28824,inst_28849);
var state_28865__$1 = state_28865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28865__$1,(22),inst_28850);
} else {
if((state_val_28866 === (13))){
var inst_28819 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28865__$1 = state_28865;
var statearr_28874_28916 = state_28865__$1;
(statearr_28874_28916[(2)] = inst_28819);

(statearr_28874_28916[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (22))){
var inst_28852 = (state_28865[(2)]);
var inst_28853 = fluree.db.util.async.throw_err(inst_28852);
var inst_28854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28853,(0),null);
var inst_28855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28853,(1),null);
var inst_28856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28857 = [inst_28854,inst_28855];
var inst_28858 = (new cljs.core.PersistentVector(null,2,(5),inst_28856,inst_28857,null));
var state_28865__$1 = state_28865;
var statearr_28875_28917 = state_28865__$1;
(statearr_28875_28917[(2)] = inst_28858);

(statearr_28875_28917[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (6))){
var inst_28806 = (state_28865[(2)]);
var state_28865__$1 = state_28865;
var statearr_28876_28918 = state_28865__$1;
(statearr_28876_28918[(2)] = inst_28806);

(statearr_28876_28918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (17))){
var inst_28828 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28829 = fluree.db.dbfunctions.internal.get(inst_28828,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28865__$1 = state_28865;
var statearr_28877_28919 = state_28865__$1;
(statearr_28877_28919[(2)] = inst_28829);

(statearr_28877_28919[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (3))){
var inst_28863 = (state_28865[(2)]);
var state_28865__$1 = state_28865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28865__$1,inst_28863);
} else {
if((state_val_28866 === (12))){
var inst_28817 = (state_28865[(2)]);
var state_28865__$1 = state_28865;
if(cljs.core.truth_(inst_28817)){
var statearr_28878_28920 = state_28865__$1;
(statearr_28878_28920[(1)] = (13));

} else {
var statearr_28879_28921 = state_28865__$1;
(statearr_28879_28921[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (2))){
var inst_28812 = (state_28865[(10)]);
var _ = (function (){var statearr_28880 = state_28865;
(statearr_28880[(4)] = cljs.core.cons((9),(state_28865[(4)])));

return statearr_28880;
})();
var inst_28812__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28865__$1 = (function (){var statearr_28881 = state_28865;
(statearr_28881[(10)] = inst_28812__$1);

return statearr_28881;
})();
if(cljs.core.truth_(inst_28812__$1)){
var statearr_28882_28922 = state_28865__$1;
(statearr_28882_28922[(1)] = (10));

} else {
var statearr_28883_28923 = state_28865__$1;
(statearr_28883_28923[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (19))){
var inst_28833 = cljs.core.PersistentVector.EMPTY;
var inst_28834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28835 = ["*"];
var inst_28836 = (new cljs.core.PersistentVector(null,1,(5),inst_28834,inst_28835,null));
var inst_28837 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28838 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28836,inst_28837);
var inst_28839 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28833,inst_28838);
var state_28865__$1 = state_28865;
var statearr_28885_28924 = state_28865__$1;
(statearr_28885_28924[(2)] = inst_28839);

(statearr_28885_28924[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (11))){
var inst_28812 = (state_28865[(10)]);
var state_28865__$1 = state_28865;
var statearr_28886_28925 = state_28865__$1;
(statearr_28886_28925[(2)] = inst_28812);

(statearr_28886_28925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (9))){
var _ = (function (){var statearr_28887 = state_28865;
(statearr_28887[(4)] = cljs.core.rest((state_28865[(4)])));

return statearr_28887;
})();
var state_28865__$1 = state_28865;
var ex28884 = (state_28865__$1[(2)]);
var statearr_28888_28926 = state_28865__$1;
(statearr_28888_28926[(5)] = ex28884);


var statearr_28889_28927 = state_28865__$1;
(statearr_28889_28927[(1)] = (4));

(statearr_28889_28927[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (5))){
var inst_28796 = (state_28865[(7)]);
var _ = (function (){var statearr_28890 = state_28865;
(statearr_28890[(4)] = cljs.core.cons((8),(state_28865[(4)])));

return statearr_28890;
})();
var inst_28803 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28796,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_28891 = state_28865;
(statearr_28891[(4)] = cljs.core.rest((state_28865[(4)])));

return statearr_28891;
})();
var state_28865__$1 = state_28865;
var statearr_28892_28928 = state_28865__$1;
(statearr_28892_28928[(2)] = inst_28803);

(statearr_28892_28928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (14))){
var inst_28825 = (state_28865[(11)]);
var inst_28824 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28825__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28865__$1 = (function (){var statearr_28893 = state_28865;
(statearr_28893[(11)] = inst_28825__$1);

(statearr_28893[(9)] = inst_28824);

return statearr_28893;
})();
if(cljs.core.truth_(inst_28825__$1)){
var statearr_28894_28929 = state_28865__$1;
(statearr_28894_28929[(1)] = (16));

} else {
var statearr_28895_28930 = state_28865__$1;
(statearr_28895_28930[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (16))){
var inst_28825 = (state_28865[(11)]);
var state_28865__$1 = state_28865;
var statearr_28896_28931 = state_28865__$1;
(statearr_28896_28931[(2)] = inst_28825);

(statearr_28896_28931[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (10))){
var inst_28814 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_28865__$1 = state_28865;
var statearr_28898_28932 = state_28865__$1;
(statearr_28898_28932[(2)] = inst_28814);

(statearr_28898_28932[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (18))){
var inst_28831 = (state_28865[(2)]);
var state_28865__$1 = (function (){var statearr_28899 = state_28865;
(statearr_28899[(8)] = inst_28831);

return statearr_28899;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28900_28933 = state_28865__$1;
(statearr_28900_28933[(1)] = (19));

} else {
var statearr_28901_28934 = state_28865__$1;
(statearr_28901_28934[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28866 === (8))){
var _ = (function (){var statearr_28902 = state_28865;
(statearr_28902[(4)] = cljs.core.rest((state_28865[(4)])));

return statearr_28902;
})();
var state_28865__$1 = state_28865;
var ex28897 = (state_28865__$1[(2)]);
var statearr_28903_28935 = state_28865__$1;
(statearr_28903_28935[(5)] = ex28897);


var statearr_28904_28936 = state_28865__$1;
(statearr_28904_28936[(1)] = (7));

(statearr_28904_28936[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28905 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28905[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28905[(1)] = (1));

return statearr_28905;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28865){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28865);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28906){var ex__2730__auto__ = e28906;
var statearr_28907_28937 = state_28865;
(statearr_28907_28937[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28865[(4)]))){
var statearr_28908_28938 = state_28865;
(statearr_28908_28938[(1)] = cljs.core.first((state_28865[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28939 = state_28865;
state_28865 = G__28939;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28909 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28909[(6)] = c__2749__auto__);

return statearr_28909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28941 = arguments.length;
switch (G__28941) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28985){
var state_val_28986 = (state_28985[(1)]);
if((state_val_28986 === (7))){
var inst_28963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28964 = ["*"];
var inst_28965 = (new cljs.core.PersistentVector(null,1,(5),inst_28963,inst_28964,null));
var state_28985__$1 = state_28985;
var statearr_28987_29007 = state_28985__$1;
(statearr_28987_29007[(2)] = inst_28965);

(statearr_28987_29007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (1))){
var state_28985__$1 = state_28985;
var statearr_28988_29008 = state_28985__$1;
(statearr_28988_29008[(2)] = null);

(statearr_28988_29008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (4))){
var inst_28942 = (state_28985[(2)]);
var inst_28943 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28942,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_28985__$1 = state_28985;
var statearr_28989_29009 = state_28985__$1;
(statearr_28989_29009[(2)] = inst_28943);

(statearr_28989_29009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (6))){
var inst_28955 = cljs.core.PersistentVector.EMPTY;
var inst_28956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28957 = ["*"];
var inst_28958 = (new cljs.core.PersistentVector(null,1,(5),inst_28956,inst_28957,null));
var inst_28959 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28960 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28958,inst_28959);
var inst_28961 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28955,inst_28960);
var state_28985__$1 = state_28985;
var statearr_28990_29010 = state_28985__$1;
(statearr_28990_29010[(2)] = inst_28961);

(statearr_28990_29010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (3))){
var inst_28983 = (state_28985[(2)]);
var state_28985__$1 = state_28985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28985__$1,inst_28983);
} else {
if((state_val_28986 === (2))){
var _ = (function (){var statearr_28992 = state_28985;
(statearr_28992[(4)] = cljs.core.cons((5),(state_28985[(4)])));

return statearr_28992;
})();
var inst_28952 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28953 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28985__$1 = (function (){var statearr_28993 = state_28985;
(statearr_28993[(7)] = inst_28952);

(statearr_28993[(8)] = inst_28953);

return statearr_28993;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28994_29011 = state_28985__$1;
(statearr_28994_29011[(1)] = (6));

} else {
var statearr_28995_29012 = state_28985__$1;
(statearr_28995_29012[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (9))){
var inst_28974 = (state_28985[(2)]);
var inst_28975 = fluree.db.util.async.throw_err(inst_28974);
var inst_28976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28975,(0),null);
var inst_28977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28975,(1),null);
var inst_28978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28979 = [inst_28976,inst_28977];
var inst_28980 = (new cljs.core.PersistentVector(null,2,(5),inst_28978,inst_28979,null));
var _ = (function (){var statearr_28996 = state_28985;
(statearr_28996[(4)] = cljs.core.rest((state_28985[(4)])));

return statearr_28996;
})();
var state_28985__$1 = state_28985;
var statearr_28997_29013 = state_28985__$1;
(statearr_28997_29013[(2)] = inst_28980);

(statearr_28997_29013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (5))){
var _ = (function (){var statearr_28998 = state_28985;
(statearr_28998[(4)] = cljs.core.rest((state_28985[(4)])));

return statearr_28998;
})();
var state_28985__$1 = state_28985;
var ex28991 = (state_28985__$1[(2)]);
var statearr_28999_29014 = state_28985__$1;
(statearr_28999_29014[(5)] = ex28991);


var statearr_29000_29015 = state_28985__$1;
(statearr_29000_29015[(1)] = (4));

(statearr_29000_29015[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (8))){
var inst_28952 = (state_28985[(7)]);
var inst_28953 = (state_28985[(8)]);
var inst_28967 = (state_28985[(2)]);
var inst_28968 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28969 = cljs.core.PersistentHashMap.EMPTY;
var inst_28970 = [inst_28967,inst_28953,inst_28969];
var inst_28971 = cljs.core.PersistentHashMap.fromArrays(inst_28968,inst_28970);
var inst_28972 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28952,inst_28971);
var state_28985__$1 = state_28985;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28985__$1,(9),inst_28972);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_29001 = [null,null,null,null,null,null,null,null,null];
(statearr_29001[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_29001[(1)] = (1));

return statearr_29001;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28985){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28985);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29002){var ex__2730__auto__ = e29002;
var statearr_29003_29016 = state_28985;
(statearr_29003_29016[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28985[(4)]))){
var statearr_29004_29017 = state_28985;
(statearr_29004_29017[(1)] = cljs.core.first((state_28985[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29018 = state_28985;
state_28985 = G__29018;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28985){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29005 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29005[(6)] = c__2749__auto__);

return statearr_29005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29062){
var state_val_29063 = (state_29062[(1)]);
if((state_val_29063 === (1))){
var state_29062__$1 = state_29062;
var statearr_29064_29078 = state_29062__$1;
(statearr_29064_29078[(2)] = null);

(statearr_29064_29078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (2))){
var _ = (function (){var statearr_29065 = state_29062;
(statearr_29065[(4)] = cljs.core.cons((5),(state_29062[(4)])));

return statearr_29065;
})();
var inst_29029 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29031 = ["_user/_auth"];
var inst_29032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29033 = ["*"];
var inst_29034 = (new cljs.core.PersistentVector(null,1,(5),inst_29032,inst_29033,null));
var inst_29035 = [inst_29034];
var inst_29036 = cljs.core.PersistentHashMap.fromArrays(inst_29031,inst_29035);
var inst_29037 = [inst_29036];
var inst_29038 = (new cljs.core.PersistentVector(null,1,(5),inst_29030,inst_29037,null));
var inst_29039 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29040 = cljs.core.PersistentHashMap.EMPTY;
var inst_29041 = [inst_29038,inst_29039,inst_29040];
var inst_29042 = cljs.core.PersistentHashMap.fromArrays(inst_29029,inst_29041);
var inst_29043 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29044 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29043,inst_29042);
var state_29062__$1 = state_29062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29062__$1,(6),inst_29044);
} else {
if((state_val_29063 === (3))){
var inst_29060 = (state_29062[(2)]);
var state_29062__$1 = state_29062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29062__$1,inst_29060);
} else {
if((state_val_29063 === (4))){
var inst_29019 = (state_29062[(2)]);
var inst_29020 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29019,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29062__$1 = state_29062;
var statearr_29067_29079 = state_29062__$1;
(statearr_29067_29079[(2)] = inst_29020);

(statearr_29067_29079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (5))){
var _ = (function (){var statearr_29068 = state_29062;
(statearr_29068[(4)] = cljs.core.rest((state_29062[(4)])));

return statearr_29068;
})();
var state_29062__$1 = state_29062;
var ex29066 = (state_29062__$1[(2)]);
var statearr_29069_29080 = state_29062__$1;
(statearr_29069_29080[(5)] = ex29066);


var statearr_29070_29081 = state_29062__$1;
(statearr_29070_29081[(1)] = (4));

(statearr_29070_29081[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (6))){
var inst_29046 = (state_29062[(2)]);
var inst_29047 = fluree.db.util.async.throw_err(inst_29046);
var inst_29048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29047,(0),null);
var inst_29049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29047,(1),null);
var inst_29050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29051 = ["_user/_auth","_id"];
var inst_29052 = (new cljs.core.PersistentVector(null,2,(5),inst_29050,inst_29051,null));
var inst_29053 = fluree.db.dbfunctions.internal.get_in(inst_29048,inst_29052);
var inst_29054 = cljs.core.first(inst_29053);
var inst_29055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29056 = [inst_29054,inst_29049];
var inst_29057 = (new cljs.core.PersistentVector(null,2,(5),inst_29055,inst_29056,null));
var _ = (function (){var statearr_29071 = state_29062;
(statearr_29071[(4)] = cljs.core.rest((state_29062[(4)])));

return statearr_29071;
})();
var state_29062__$1 = state_29062;
var statearr_29072_29082 = state_29062__$1;
(statearr_29072_29082[(2)] = inst_29057);

(statearr_29072_29082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0 = (function (){
var statearr_29073 = [null,null,null,null,null,null,null];
(statearr_29073[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__);

(statearr_29073[(1)] = (1));

return statearr_29073;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1 = (function (state_29062){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29062);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29074){var ex__2730__auto__ = e29074;
var statearr_29075_29083 = state_29062;
(statearr_29075_29083[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29062[(4)]))){
var statearr_29076_29084 = state_29062;
(statearr_29076_29084[(1)] = cljs.core.first((state_29062[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29085 = state_29062;
state_29062 = G__29085;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = function(state_29062){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1.call(this,state_29062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29077 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29077[(6)] = c__2749__auto__);

return statearr_29077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29107){
var state_val_29108 = (state_29107[(1)]);
if((state_val_29108 === (7))){
var inst_29092 = (state_29107[(7)]);
var inst_29096 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29097 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29096,inst_29092);
var state_29107__$1 = state_29107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29107__$1,(9),inst_29097);
} else {
if((state_val_29108 === (1))){
var state_29107__$1 = state_29107;
var statearr_29109_29128 = state_29107__$1;
(statearr_29109_29128[(2)] = null);

(statearr_29109_29128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29108 === (4))){
var inst_29086 = (state_29107[(2)]);
var state_29107__$1 = state_29107;
var statearr_29110_29129 = state_29107__$1;
(statearr_29110_29129[(2)] = inst_29086);

(statearr_29110_29129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29108 === (6))){
var inst_29092 = (state_29107[(7)]);
var state_29107__$1 = state_29107;
var statearr_29111_29130 = state_29107__$1;
(statearr_29111_29130[(2)] = inst_29092);

(statearr_29111_29130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29108 === (3))){
var inst_29105 = (state_29107[(2)]);
var state_29107__$1 = state_29107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29107__$1,inst_29105);
} else {
if((state_val_29108 === (2))){
var inst_29092 = (state_29107[(7)]);
var _ = (function (){var statearr_29113 = state_29107;
(statearr_29113[(4)] = cljs.core.cons((5),(state_29107[(4)])));

return statearr_29113;
})();
var inst_29092__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29093 = typeof inst_29092__$1 === 'number';
var state_29107__$1 = (function (){var statearr_29114 = state_29107;
(statearr_29114[(7)] = inst_29092__$1);

return statearr_29114;
})();
if(cljs.core.truth_(inst_29093)){
var statearr_29115_29131 = state_29107__$1;
(statearr_29115_29131[(1)] = (6));

} else {
var statearr_29116_29132 = state_29107__$1;
(statearr_29116_29132[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29108 === (9))){
var inst_29099 = (state_29107[(2)]);
var inst_29100 = fluree.db.util.async.throw_err(inst_29099);
var state_29107__$1 = state_29107;
var statearr_29117_29133 = state_29107__$1;
(statearr_29117_29133[(2)] = inst_29100);

(statearr_29117_29133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29108 === (5))){
var _ = (function (){var statearr_29118 = state_29107;
(statearr_29118[(4)] = cljs.core.rest((state_29107[(4)])));

return statearr_29118;
})();
var state_29107__$1 = state_29107;
var ex29112 = (state_29107__$1[(2)]);
var statearr_29119_29134 = state_29107__$1;
(statearr_29119_29134[(5)] = ex29112);


if((ex29112 instanceof Error)){
var statearr_29120_29135 = state_29107__$1;
(statearr_29120_29135[(1)] = (4));

(statearr_29120_29135[(5)] = null);

} else {
throw ex29112;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29108 === (8))){
var inst_29102 = (state_29107[(2)]);
var _ = (function (){var statearr_29121 = state_29107;
(statearr_29121[(4)] = cljs.core.rest((state_29107[(4)])));

return statearr_29121;
})();
var state_29107__$1 = state_29107;
var statearr_29122_29136 = state_29107__$1;
(statearr_29122_29136[(2)] = inst_29102);

(statearr_29122_29136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_29123 = [null,null,null,null,null,null,null,null];
(statearr_29123[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_29123[(1)] = (1));

return statearr_29123;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_29107){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29107);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29124){var ex__2730__auto__ = e29124;
var statearr_29125_29137 = state_29107;
(statearr_29125_29137[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29107[(4)]))){
var statearr_29126_29138 = state_29107;
(statearr_29126_29138[(1)] = cljs.core.first((state_29107[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29139 = state_29107;
state_29107 = G__29139;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_29107){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_29107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29127 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29127[(6)] = c__2749__auto__);

return statearr_29127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29140_SHARP_){
return fluree.db.flake.op(p1__29140_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29141_SHARP_){
return fluree.db.flake.o(p1__29141_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29142){var e = e29142;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29143_SHARP_){
return fluree.db.flake.op(p1__29143_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29144_SHARP_){
return fluree.db.flake.o(p1__29144_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29145){var e = e29145;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29147 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29147);
})() | (0));
return num;
}catch (e29146){var e = e29146;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29227){
var state_val_29228 = (state_29227[(1)]);
if((state_val_29228 === (7))){
var inst_29166 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29167 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29168 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29169 = cljs.core.PersistentHashMap.fromArrays(inst_29167,inst_29168);
var inst_29170 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29166,inst_29169);
var inst_29171 = (function(){throw inst_29170})();
var state_29227__$1 = state_29227;
var statearr_29229_29264 = state_29227__$1;
(statearr_29229_29264[(2)] = inst_29171);

(statearr_29229_29264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (1))){
var state_29227__$1 = state_29227;
var statearr_29230_29265 = state_29227__$1;
(statearr_29230_29265[(2)] = null);

(statearr_29230_29265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (4))){
var inst_29148 = (state_29227[(2)]);
var state_29227__$1 = state_29227;
var statearr_29231_29266 = state_29227__$1;
(statearr_29231_29266[(2)] = inst_29148);

(statearr_29231_29266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (15))){
var inst_29211 = (state_29227[(7)]);
var inst_29207 = (state_29227[(2)]);
var inst_29208 = fluree.db.util.async.throw_err(inst_29207);
var inst_29209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29208,(0),null);
var inst_29210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29208,(1),null);
var inst_29211__$1 = cljs.core.first(inst_29209);
var inst_29212 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29211__$1,compare_val);
var state_29227__$1 = (function (){var statearr_29232 = state_29227;
(statearr_29232[(7)] = inst_29211__$1);

(statearr_29232[(8)] = inst_29210);

return statearr_29232;
})();
if(inst_29212){
var statearr_29233_29267 = state_29227__$1;
(statearr_29233_29267[(1)] = (16));

} else {
var statearr_29234_29268 = state_29227__$1;
(statearr_29234_29268[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (13))){
var state_29227__$1 = state_29227;
var statearr_29235_29269 = state_29227__$1;
(statearr_29235_29269[(2)] = null);

(statearr_29235_29269[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (6))){
var state_29227__$1 = state_29227;
var statearr_29236_29270 = state_29227__$1;
(statearr_29236_29270[(2)] = null);

(statearr_29236_29270[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (17))){
var inst_29211 = (state_29227[(7)]);
var inst_29215 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29211)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29216 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29217 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29218 = cljs.core.PersistentHashMap.fromArrays(inst_29216,inst_29217);
var inst_29219 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29215,inst_29218);
var inst_29220 = (function(){throw inst_29219})();
var state_29227__$1 = state_29227;
var statearr_29237_29271 = state_29227__$1;
(statearr_29237_29271[(2)] = inst_29220);

(statearr_29237_29271[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (3))){
var inst_29225 = (state_29227[(2)]);
var state_29227__$1 = state_29227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29227__$1,inst_29225);
} else {
if((state_val_29228 === (12))){
var inst_29163 = (state_29227[(9)]);
var inst_29186 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29163], 0));
var inst_29187 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29188 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29189 = cljs.core.PersistentHashMap.fromArrays(inst_29187,inst_29188);
var inst_29190 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29186,inst_29189);
var inst_29191 = (function(){throw inst_29190})();
var state_29227__$1 = state_29227;
var statearr_29238_29272 = state_29227__$1;
(statearr_29238_29272[(2)] = inst_29191);

(statearr_29238_29272[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (2))){
var inst_29161 = (state_29227[(10)]);
var inst_29162 = (state_29227[(11)]);
var inst_29160 = (state_29227[(12)]);
var _ = (function (){var statearr_29239 = state_29227;
(statearr_29239[(4)] = cljs.core.cons((5),(state_29227[(4)])));

return statearr_29239;
})();
var inst_29158 = _QMARK_ctx;
var inst_29159 = cljs.core.__destructure_map(inst_29158);
var inst_29160__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29159,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29161__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29159,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29162__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29159,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29163 = fluree.db.dbproto._p_prop(inst_29162__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29161__$1);
var state_29227__$1 = (function (){var statearr_29240 = state_29227;
(statearr_29240[(10)] = inst_29161__$1);

(statearr_29240[(11)] = inst_29162__$1);

(statearr_29240[(12)] = inst_29160__$1);

(statearr_29240[(9)] = inst_29163);

return statearr_29240;
})();
if(cljs.core.truth_(inst_29160__$1)){
var statearr_29241_29273 = state_29227__$1;
(statearr_29241_29273[(1)] = (6));

} else {
var statearr_29242_29274 = state_29227__$1;
(statearr_29242_29274[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (11))){
var inst_29161 = (state_29227[(10)]);
var inst_29162 = (state_29227[(11)]);
var inst_29183 = (state_29227[(2)]);
var inst_29184 = fluree.db.dbproto._p_prop(inst_29162,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29161);
var state_29227__$1 = (function (){var statearr_29244 = state_29227;
(statearr_29244[(13)] = inst_29183);

return statearr_29244;
})();
if(cljs.core.truth_(inst_29184)){
var statearr_29245_29275 = state_29227__$1;
(statearr_29245_29275[(1)] = (12));

} else {
var statearr_29246_29276 = state_29227__$1;
(statearr_29246_29276[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (9))){
var state_29227__$1 = state_29227;
var statearr_29247_29277 = state_29227__$1;
(statearr_29247_29277[(2)] = null);

(statearr_29247_29277[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (5))){
var _ = (function (){var statearr_29248 = state_29227;
(statearr_29248[(4)] = cljs.core.rest((state_29227[(4)])));

return statearr_29248;
})();
var state_29227__$1 = state_29227;
var ex29243 = (state_29227__$1[(2)]);
var statearr_29249_29278 = state_29227__$1;
(statearr_29249_29278[(5)] = ex29243);


if((ex29243 instanceof Error)){
var statearr_29250_29279 = state_29227__$1;
(statearr_29250_29279[(1)] = (4));

(statearr_29250_29279[(5)] = null);

} else {
throw ex29243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (14))){
var inst_29162 = (state_29227[(11)]);
var inst_29160 = (state_29227[(12)]);
var inst_29163 = (state_29227[(9)]);
var inst_29194 = (state_29227[(2)]);
var inst_29195 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29198 = [inst_29160,inst_29163,"?current-val"];
var inst_29199 = (new cljs.core.PersistentVector(null,3,(5),inst_29197,inst_29198,null));
var inst_29200 = [inst_29199];
var inst_29201 = (new cljs.core.PersistentVector(null,1,(5),inst_29196,inst_29200,null));
var inst_29202 = cljs.core.PersistentHashMap.EMPTY;
var inst_29203 = ["?current-val",inst_29201,inst_29202];
var inst_29204 = cljs.core.PersistentHashMap.fromArrays(inst_29195,inst_29203);
var inst_29205 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29162,inst_29204);
var state_29227__$1 = (function (){var statearr_29251 = state_29227;
(statearr_29251[(14)] = inst_29194);

return statearr_29251;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29227__$1,(15),inst_29205);
} else {
if((state_val_29228 === (16))){
var state_29227__$1 = state_29227;
var statearr_29252_29280 = state_29227__$1;
(statearr_29252_29280[(2)] = new_val);

(statearr_29252_29280[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (10))){
var inst_29176 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29177 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29178 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29179 = cljs.core.PersistentHashMap.fromArrays(inst_29177,inst_29178);
var inst_29180 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29176,inst_29179);
var inst_29181 = (function(){throw inst_29180})();
var state_29227__$1 = state_29227;
var statearr_29253_29281 = state_29227__$1;
(statearr_29253_29281[(2)] = inst_29181);

(statearr_29253_29281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (18))){
var inst_29222 = (state_29227[(2)]);
var _ = (function (){var statearr_29254 = state_29227;
(statearr_29254[(4)] = cljs.core.rest((state_29227[(4)])));

return statearr_29254;
})();
var state_29227__$1 = state_29227;
var statearr_29255_29282 = state_29227__$1;
(statearr_29255_29282[(2)] = inst_29222);

(statearr_29255_29282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29228 === (8))){
var inst_29163 = (state_29227[(9)]);
var inst_29173 = (state_29227[(2)]);
var state_29227__$1 = (function (){var statearr_29256 = state_29227;
(statearr_29256[(15)] = inst_29173);

return statearr_29256;
})();
if(cljs.core.truth_(inst_29163)){
var statearr_29257_29283 = state_29227__$1;
(statearr_29257_29283[(1)] = (9));

} else {
var statearr_29258_29284 = state_29227__$1;
(statearr_29258_29284[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_29259 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29259[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__);

(statearr_29259[(1)] = (1));

return statearr_29259;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1 = (function (state_29227){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29227);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29260){var ex__2730__auto__ = e29260;
var statearr_29261_29285 = state_29227;
(statearr_29261_29285[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29227[(4)]))){
var statearr_29262_29286 = state_29227;
(statearr_29262_29286[(1)] = cljs.core.first((state_29227[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29287 = state_29227;
state_29227 = G__29287;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = function(state_29227){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1.call(this,state_29227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29263 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29263[(6)] = c__2749__auto__);

return statearr_29263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
