// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set(cljs.core.keys(fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_14652 = (function (r,node){
var x__5393__auto__ = (((r == null))?null:r);
var m__5394__auto__ = (fluree.db.index.resolve[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5394__auto__.call(null,r,node));
} else {
var m__5392__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5392__auto__.call(null,r,node));
} else {
throw cljs.core.missing_protocol("Resolver.resolve",r);
}
}
});
/**
 * Populate index branch and leaf node maps with either their child node
 *   attributes or the flakes the store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_14652(r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14674){
var state_val_14675 = (state_14674[(1)]);
if((state_val_14675 === (1))){
var state_14674__$1 = state_14674;
var statearr_14676_14691 = state_14674__$1;
(statearr_14676_14691[(2)] = null);

(statearr_14676_14691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14675 === (2))){
var _ = (function (){var statearr_14677 = state_14674;
(statearr_14677[(4)] = cljs.core.cons((6),(state_14674[(4)])));

return statearr_14677;
})();
var inst_14666 = fluree.db.index.resolve(r,node);
var state_14674__$1 = state_14674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14674__$1,(7),inst_14666);
} else {
if((state_val_14675 === (3))){
var inst_14672 = (state_14674[(2)]);
var state_14674__$1 = state_14674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14674__$1,inst_14672);
} else {
if((state_val_14675 === (4))){
var inst_14653 = (state_14674[(2)]);
var inst_14654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14655 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_14656 = (new cljs.core.PersistentVector(null,3,(5),inst_14654,inst_14655,null));
var inst_14657 = cljs.core.select_keys(node,inst_14656);
var inst_14658 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_14653,"Error resolving index node:",inst_14657) : fluree.db.util.log.error.call(null,inst_14653,"Error resolving index node:",inst_14657));
var state_14674__$1 = (function (){var statearr_14679 = state_14674;
(statearr_14679[(7)] = inst_14658);

return statearr_14679;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14674__$1,(5),error_ch,inst_14653);
} else {
if((state_val_14675 === (5))){
var inst_14660 = (state_14674[(2)]);
var state_14674__$1 = state_14674;
var statearr_14680_14692 = state_14674__$1;
(statearr_14680_14692[(2)] = inst_14660);

(statearr_14680_14692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14675 === (6))){
var _ = (function (){var statearr_14681 = state_14674;
(statearr_14681[(4)] = cljs.core.rest((state_14674[(4)])));

return statearr_14681;
})();
var state_14674__$1 = state_14674;
var ex14678 = (state_14674__$1[(2)]);
var statearr_14682_14693 = state_14674__$1;
(statearr_14682_14693[(5)] = ex14678);


var statearr_14683_14694 = state_14674__$1;
(statearr_14683_14694[(1)] = (4));

(statearr_14683_14694[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14675 === (7))){
var inst_14668 = (state_14674[(2)]);
var inst_14669 = fluree.db.util.async.throw_err(inst_14668);
var _ = (function (){var statearr_14684 = state_14674;
(statearr_14684[(4)] = cljs.core.rest((state_14674[(4)])));

return statearr_14684;
})();
var state_14674__$1 = state_14674;
var statearr_14685_14695 = state_14674__$1;
(statearr_14685_14695[(2)] = inst_14669);

(statearr_14685_14695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2727__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2727__auto____0 = (function (){
var statearr_14686 = [null,null,null,null,null,null,null,null];
(statearr_14686[(0)] = fluree$db$index$try_resolve_$_state_machine__2727__auto__);

(statearr_14686[(1)] = (1));

return statearr_14686;
});
var fluree$db$index$try_resolve_$_state_machine__2727__auto____1 = (function (state_14674){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14674);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14687){var ex__2730__auto__ = e14687;
var statearr_14688_14696 = state_14674;
(statearr_14688_14696[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14674[(4)]))){
var statearr_14689_14697 = state_14674;
(statearr_14689_14697[(1)] = cljs.core.first((state_14674[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14698 = state_14674;
state_14674 = G__14698;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2727__auto__ = function(state_14674){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____1.call(this,state_14674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2727__auto____0;
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2727__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14690 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14690[(6)] = c__2749__auto__);

return statearr_14690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.index.branch_QMARK_(branch);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(branch);
} else {
return and__5043__auto__;
}
})())){
var map__14699 = branch;
var map__14699__$1 = cljs.core.__destructure_map(map__14699);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14699__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val((function (){var or__5045__auto__ = clojure.data.avl.nearest(children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.first(children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14735){
var state_val_14736 = (state_14735[(1)]);
if((state_val_14736 === (7))){
var inst_14706 = (state_14735[(7)]);
var state_14735__$1 = state_14735;
var statearr_14737_14768 = state_14735__$1;
(statearr_14737_14768[(2)] = inst_14706);

(statearr_14737_14768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (1))){
var state_14735__$1 = state_14735;
var statearr_14738_14769 = state_14735__$1;
(statearr_14738_14769[(2)] = null);

(statearr_14738_14769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (4))){
var inst_14700 = (state_14735[(2)]);
var state_14735__$1 = state_14735;
var statearr_14739_14770 = state_14735__$1;
(statearr_14739_14770[(2)] = inst_14700);

(statearr_14739_14770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (15))){
var inst_14714 = (state_14735[(8)]);
var inst_14719 = fluree.db.index.resolve(r,inst_14714);
var state_14735__$1 = state_14735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14735__$1,(17),inst_14719);
} else {
if((state_val_14736 === (13))){
var inst_14727 = (state_14735[(2)]);
var state_14735__$1 = state_14735;
var statearr_14740_14771 = state_14735__$1;
(statearr_14740_14771[(2)] = inst_14727);

(statearr_14740_14771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (6))){
var inst_14708 = fluree.db.index.resolved_QMARK_(branch);
var state_14735__$1 = state_14735;
var statearr_14741_14772 = state_14735__$1;
(statearr_14741_14772[(2)] = inst_14708);

(statearr_14741_14772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (17))){
var inst_14721 = (state_14735[(2)]);
var inst_14722 = fluree.db.util.async.throw_err(inst_14721);
var inst_14714 = inst_14722;
var state_14735__$1 = (function (){var statearr_14742 = state_14735;
(statearr_14742[(8)] = inst_14714);

return statearr_14742;
})();
var statearr_14743_14773 = state_14735__$1;
(statearr_14743_14773[(2)] = null);

(statearr_14743_14773[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (3))){
var inst_14733 = (state_14735[(2)]);
var state_14735__$1 = state_14735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14735__$1,inst_14733);
} else {
if((state_val_14736 === (12))){
var inst_14714 = (state_14735[(8)]);
var inst_14716 = fluree.db.index.leaf_QMARK_(inst_14714);
var state_14735__$1 = state_14735;
if(inst_14716){
var statearr_14744_14774 = state_14735__$1;
(statearr_14744_14774[(1)] = (14));

} else {
var statearr_14745_14775 = state_14735__$1;
(statearr_14745_14775[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (2))){
var inst_14706 = (state_14735[(7)]);
var _ = (function (){var statearr_14746 = state_14735;
(statearr_14746[(4)] = cljs.core.cons((5),(state_14735[(4)])));

return statearr_14746;
})();
var inst_14706__$1 = fluree.db.index.branch_QMARK_(branch);
var state_14735__$1 = (function (){var statearr_14747 = state_14735;
(statearr_14747[(7)] = inst_14706__$1);

return statearr_14747;
})();
if(inst_14706__$1){
var statearr_14748_14776 = state_14735__$1;
(statearr_14748_14776[(1)] = (6));

} else {
var statearr_14749_14777 = state_14735__$1;
(statearr_14749_14777[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (11))){
var inst_14730 = (state_14735[(2)]);
var _ = (function (){var statearr_14751 = state_14735;
(statearr_14751[(4)] = cljs.core.rest((state_14735[(4)])));

return statearr_14751;
})();
var state_14735__$1 = state_14735;
var statearr_14752_14778 = state_14735__$1;
(statearr_14752_14778[(2)] = inst_14730);

(statearr_14752_14778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (9))){
var inst_14713 = fluree.db.index.lookup(branch,flake);
var inst_14714 = inst_14713;
var state_14735__$1 = (function (){var statearr_14753 = state_14735;
(statearr_14753[(8)] = inst_14714);

return statearr_14753;
})();
var statearr_14754_14779 = state_14735__$1;
(statearr_14754_14779[(2)] = null);

(statearr_14754_14779[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (5))){
var _ = (function (){var statearr_14755 = state_14735;
(statearr_14755[(4)] = cljs.core.rest((state_14735[(4)])));

return statearr_14755;
})();
var state_14735__$1 = state_14735;
var ex14750 = (state_14735__$1[(2)]);
var statearr_14756_14780 = state_14735__$1;
(statearr_14756_14780[(5)] = ex14750);


if((ex14750 instanceof Error)){
var statearr_14757_14781 = state_14735__$1;
(statearr_14757_14781[(1)] = (4));

(statearr_14757_14781[(5)] = null);

} else {
throw ex14750;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (14))){
var inst_14714 = (state_14735[(8)]);
var state_14735__$1 = state_14735;
var statearr_14758_14782 = state_14735__$1;
(statearr_14758_14782[(2)] = inst_14714);

(statearr_14758_14782[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (16))){
var inst_14725 = (state_14735[(2)]);
var state_14735__$1 = state_14735;
var statearr_14759_14783 = state_14735__$1;
(statearr_14759_14783[(2)] = inst_14725);

(statearr_14759_14783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (10))){
var state_14735__$1 = state_14735;
var statearr_14760_14784 = state_14735__$1;
(statearr_14760_14784[(2)] = null);

(statearr_14760_14784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (8))){
var inst_14711 = (state_14735[(2)]);
var state_14735__$1 = state_14735;
if(cljs.core.truth_(inst_14711)){
var statearr_14761_14785 = state_14735__$1;
(statearr_14761_14785[(1)] = (9));

} else {
var statearr_14762_14786 = state_14735__$1;
(statearr_14762_14786[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_14763 = [null,null,null,null,null,null,null,null,null];
(statearr_14763[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2727__auto__);

(statearr_14763[(1)] = (1));

return statearr_14763;
});
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1 = (function (state_14735){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14735);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14764){var ex__2730__auto__ = e14764;
var statearr_14765_14787 = state_14735;
(statearr_14765_14787[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14735[(4)]))){
var statearr_14766_14788 = state_14735;
(statearr_14766_14788[(1)] = cljs.core.first((state_14735[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14789 = state_14735;
state_14735 = G__14789;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = function(state_14735){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1.call(this,state_14735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14767 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14767[(6)] = c__2749__auto__);

return statearr_14767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14790 = new_leaf;
var G__14790__$1 = (((G__14790 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14790));
if((G__14790__$1 == null)){
return null;
} else {
return cljs.core.first(G__14790__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14791 = new_leaf;
var G__14791__$1 = (((G__14791 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14791));
if((G__14791__$1 == null)){
return null;
} else {
return cljs.core.first(G__14791__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by(cmp);
return fluree.db.index.add_flakes(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(fluree.db.index.empty_leaf(network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14792,p__14793){
var map__14794 = p__14792;
var map__14794__$1 = cljs.core.__destructure_map(map__14794);
var branch = map__14794__$1;
var cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14794__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14794__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14794__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14794__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14795 = p__14793;
var map__14795__$1 = cljs.core.__destructure_map(map__14795);
var node = map__14795__$1;
var node_first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14795__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14795__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_(branch)))){
return false;
} else {
var and__5043__auto__ = (function (){var or__5045__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(first_flake,node_first) : cmp.call(null,first_flake,node_first)) > (0))));
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(node_rhs,rhs) : cmp.call(null,node_rhs,rhs)) > (0))))))));
} else {
return and__5043__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14796){
var map__14797 = p__14796;
var map__14797__$1 = cljs.core.__destructure_map(map__14797);
var node = map__14797__$1;
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14797__$1,new cljs.core.Keyword(null,"first","first",-644103046));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__5775__auto__ = [];
var len__5769__auto___14800 = arguments.length;
var i__5770__auto___14801 = (0);
while(true){
if((i__5770__auto___14801 < len__5769__auto___14800)){
args__5775__auto__.push((arguments[i__5770__auto___14801]));

var G__14802 = (i__5770__auto___14801 + (1));
i__5770__auto___14801 = G__14802;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fluree.db.index.child_entry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_nodes], 0)));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14798){
var G__14799 = cljs.core.first(seq14798);
var seq14798__$1 = cljs.core.next(seq14798);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14799,seq14798__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf(network,ledger_id,cmp);
var children = fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_node], 0));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14803,new_child_nodes){
var map__14804 = p__14803;
var map__14804__$1 = cljs.core.__destructure_map(map__14804);
var branch = map__14804__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14804__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14804__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__5045__auto__ = (function (){var G__14805 = new_kids;
var G__14805__$1 = (((G__14805 == null))?null:cljs.core.first(G__14805));
if((G__14805__$1 == null)){
return null;
} else {
return cljs.core.key(G__14805__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids], 0));
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children(fluree.db.index.empty_branch(network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t(flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all(flakes,fluree.db.index.filter_after(t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14806,through_t,novelty){
var map__14807 = p__14806;
var map__14807__$1 = cljs.core.__destructure_map(map__14807);
var node = map__14807__$1;
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14807__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14807__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14807__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through(through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (flakes__$1){
var last_flake = cljs.core.last(flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op(last_flake))){
return cljs.core.butlast(flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t)),flakes))], 0));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14808,novelty,from_t,to_t){
var map__14809 = p__14808;
var map__14809__$1 = cljs.core.__destructure_map(map__14809);
var leaf = map__14809__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14809__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14809__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14810 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all(G__14810,fluree.db.index.novelty_subrange(leaf,to_t,novelty));
} else {
return G__14810;
}
})();
var stale_flakes = fluree.db.index.stale_by(from_t,latest);
var subsequent = fluree.db.index.filter_after(to_t,latest);
var out_of_range = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(stale_flakes,subsequent);
return fluree.db.flake.disj_all(latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14816){
var self__ = this;
var map__14817 = p__14816;
var map__14817__$1 = cljs.core.__destructure_map(map__14817);
var node = map__14817__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14817__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14817__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14817__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_(node)){
return fluree.db.index.resolve(self__.node_resolver,node);
} else {
var G__14818 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null);
var G__14819 = (function (___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14837){
var state_val_14838 = (state_14837[(1)]);
if((state_val_14838 === (1))){
var state_14837__$1 = state_14837;
var statearr_14839_14874 = state_14837__$1;
(statearr_14839_14874[(2)] = null);

(statearr_14839_14874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14838 === (2))){
var ___$3 = (function (){var statearr_14840 = state_14837;
(statearr_14840[(4)] = cljs.core.cons((5),(state_14837[(4)])));

return statearr_14840;
})();
var inst_14826 = fluree.db.index.resolve(self__.node_resolver,node);
var state_14837__$1 = state_14837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14837__$1,(6),inst_14826);
} else {
if((state_val_14838 === (3))){
var inst_14835 = (state_14837[(2)]);
var state_14837__$1 = state_14837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14837__$1,inst_14835);
} else {
if((state_val_14838 === (4))){
var inst_14820 = (state_14837[(2)]);
var state_14837__$1 = state_14837;
var statearr_14842_14875 = state_14837__$1;
(statearr_14842_14875[(2)] = inst_14820);

(statearr_14842_14875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14838 === (5))){
var ___$3 = (function (){var statearr_14843 = state_14837;
(statearr_14843[(4)] = cljs.core.rest((state_14837[(4)])));

return statearr_14843;
})();
var state_14837__$1 = state_14837;
var ex14841 = (state_14837__$1[(2)]);
var statearr_14844_14876 = state_14837__$1;
(statearr_14844_14876[(5)] = ex14841);


if((ex14841 instanceof Error)){
var statearr_14845_14877 = state_14837__$1;
(statearr_14845_14877[(1)] = (4));

(statearr_14845_14877[(5)] = null);

} else {
throw ex14841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14838 === (6))){
var inst_14828 = (state_14837[(2)]);
var inst_14829 = fluree.db.util.async.throw_err(inst_14828);
var inst_14830 = fluree.db.index.t_range(inst_14829,self__.novelty,self__.from_t,self__.to_t);
var inst_14831 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_14829,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14832 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_14831,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14830], 0));
var ___$3 = (function (){var statearr_14846 = state_14837;
(statearr_14846[(4)] = cljs.core.rest((state_14837[(4)])));

return statearr_14846;
})();
var state_14837__$1 = state_14837;
var statearr_14847_14878 = state_14837__$1;
(statearr_14847_14878[(2)] = inst_14832);

(statearr_14847_14878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14848 = [null,null,null,null,null,null,null];
(statearr_14848[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14848[(1)] = (1));

return statearr_14848;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14837){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14837);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14849){var ex__2730__auto__ = e14849;
var statearr_14850_14879 = state_14837;
(statearr_14850_14879[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14837[(4)]))){
var statearr_14851_14880 = state_14837;
(statearr_14851_14880[(1)] = cljs.core.first((state_14837[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14881 = state_14837;
state_14837 = G__14881;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14837){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14852 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14852[(6)] = c__2749__auto__);

return statearr_14852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__14818,G__14819) : self__.async_cache.call(null,G__14818,G__14819));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k14812,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__14853 = k14812;
var G__14853__$1 = (((G__14853 instanceof cljs.core.Keyword))?G__14853.fqn:null);
switch (G__14853__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14812,else__5346__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__14854){
var vec__14855 = p__14854;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14855,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14855,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14811){
var self__ = this;
var G__14811__$1 = this;
return (new cljs.core.RecordIter((0),G__14811__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__14858 = (function (coll__5340__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__14858(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14813,other14814){
var self__ = this;
var this14813__$1 = this;
return (((!((other14814 == null)))) && ((((this14813__$1.constructor === other14814.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14813__$1.node_resolver,other14814.node_resolver)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14813__$1.novelty,other14814.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14813__$1.from_t,other14814.from_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14813__$1.to_t,other14814.to_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14813__$1.async_cache,other14814.async_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14813__$1.__extmap,other14814.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k14812){
var self__ = this;
var this__5350__auto____$1 = this;
var G__14859 = k14812;
var G__14859__$1 = (((G__14859 instanceof cljs.core.Keyword))?G__14859.fqn:null);
switch (G__14859__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14812);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__14811){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__14860 = cljs.core.keyword_identical_QMARK_;
var expr__14861 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__14863 = new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078);
var G__14864 = expr__14861;
return (pred__14860.cljs$core$IFn$_invoke$arity$2 ? pred__14860.cljs$core$IFn$_invoke$arity$2(G__14863,G__14864) : pred__14860.call(null,G__14863,G__14864));
})())){
return (new fluree.db.index.CachedTRangeResolver(G__14811,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14865 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__14866 = expr__14861;
return (pred__14860.cljs$core$IFn$_invoke$arity$2 ? pred__14860.cljs$core$IFn$_invoke$arity$2(G__14865,G__14866) : pred__14860.call(null,G__14865,G__14866));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14811,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14867 = new cljs.core.Keyword(null,"from-t","from-t",1730913525);
var G__14868 = expr__14861;
return (pred__14860.cljs$core$IFn$_invoke$arity$2 ? pred__14860.cljs$core$IFn$_invoke$arity$2(G__14867,G__14868) : pred__14860.call(null,G__14867,G__14868));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14811,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14869 = new cljs.core.Keyword(null,"to-t","to-t",569467359);
var G__14870 = expr__14861;
return (pred__14860.cljs$core$IFn$_invoke$arity$2 ? pred__14860.cljs$core$IFn$_invoke$arity$2(G__14869,G__14870) : pred__14860.call(null,G__14869,G__14870));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14811,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14871 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__14872 = expr__14861;
return (pred__14860.cljs$core$IFn$_invoke$arity$2 ? pred__14860.cljs$core$IFn$_invoke$arity$2(G__14871,G__14872) : pred__14860.call(null,G__14871,G__14872));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14811,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__14811),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__14811){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14811,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14815){
var extmap__5385__auto__ = (function (){var G__14873 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14815,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], 0));
if(cljs.core.record_QMARK_(G__14815)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14873);
} else {
return G__14873;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14815),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14815),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14815),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14815),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14815),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14884,t,idx_novelty){
var map__14885 = p__14884;
var map__14885__$1 = cljs.core.__destructure_map(map__14885);
var leaf = map__14885__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14885__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14885__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14885__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14885__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(leaf_t,t)){
return leaf;
} else {
var G__14886 = leaf;
var G__14886__$1 = (((leaf_t > t))?fluree.db.index.add_flakes(G__14886,fluree.db.index.novelty_subrange(leaf,t,idx_novelty)):G__14886);
var G__14886__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes(G__14886__$1,fluree.db.index.filter_after(t,flakes)):G__14886__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14886__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_((resolve_QMARK_.cljs$core$IFn$_invoke$arity$1 ? resolve_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : resolve_QMARK_.call(null,node)))){
return fluree.db.index.try_resolve(r,error_ch,node);
} else {
var G__14887 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(G__14887,node);

return G__14887;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_(branch))){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14888){
var vec__14889 = p__14888;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14889,(0),null);
var child = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14889,(1),null);
return fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14894){
var state_val_14895 = (state_14894[(1)]);
if((state_val_14895 === (1))){
var inst_14892 = cljs.core.PersistentVector.EMPTY;
var state_14894__$1 = state_14894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14894__$1,inst_14892);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0 = (function (){
var statearr_14896 = [null,null,null,null,null,null,null];
(statearr_14896[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2727__auto__);

(statearr_14896[(1)] = (1));

return statearr_14896;
});
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1 = (function (state_14894){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14894);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14897){var ex__2730__auto__ = e14897;
var statearr_14898_14901 = state_14894;
(statearr_14898_14901[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14894[(4)]))){
var statearr_14899_14902 = state_14894;
(statearr_14899_14902[(1)] = cljs.core.first((state_14894[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14903 = state_14894;
state_14894 = G__14903;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = function(state_14894){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1.call(this,state_14894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14900 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14900[(6)] = c__2749__auto__);

return statearr_14900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14905 = arguments.length;
switch (G__14905) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(n,xf);
var c__2749__auto___14983 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14951){
var state_val_14952 = (state_14951[(1)]);
if((state_val_14952 === (7))){
var inst_14946 = (state_14951[(2)]);
var state_14951__$1 = state_14951;
var statearr_14953_14984 = state_14951__$1;
(statearr_14953_14984[(2)] = inst_14946);

(statearr_14953_14984[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (1))){
var inst_14906 = fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,root);
var state_14951__$1 = state_14951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14951__$1,(2),inst_14906);
} else {
if((state_val_14952 === (4))){
var inst_14948 = (state_14951[(2)]);
var inst_14949 = cljs.core.async.close_BANG_(out);
var state_14951__$1 = (function (){var statearr_14954 = state_14951;
(statearr_14954[(7)] = inst_14948);

return statearr_14954;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14951__$1,inst_14949);
} else {
if((state_val_14952 === (15))){
var state_14951__$1 = state_14951;
var statearr_14955_14985 = state_14951__$1;
(statearr_14955_14985[(2)] = null);

(statearr_14955_14985[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (13))){
var inst_14943 = (state_14951[(2)]);
var state_14951__$1 = state_14951;
var statearr_14956_14986 = state_14951__$1;
(statearr_14956_14986[(2)] = inst_14943);

(statearr_14956_14986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (6))){
var state_14951__$1 = state_14951;
var statearr_14957_14987 = state_14951__$1;
(statearr_14957_14987[(2)] = null);

(statearr_14957_14987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (17))){
var inst_14928 = (state_14951[(2)]);
var state_14951__$1 = state_14951;
var statearr_14958_14988 = state_14951__$1;
(statearr_14958_14988[(2)] = inst_14928);

(statearr_14958_14988[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (3))){
var inst_14914 = (state_14951[(8)]);
var inst_14912 = (state_14951[(9)]);
var inst_14914__$1 = cljs.core.peek(inst_14912);
var state_14951__$1 = (function (){var statearr_14959 = state_14951;
(statearr_14959[(8)] = inst_14914__$1);

return statearr_14959;
})();
if(cljs.core.truth_(inst_14914__$1)){
var statearr_14960_14989 = state_14951__$1;
(statearr_14960_14989[(1)] = (5));

} else {
var statearr_14961_14990 = state_14951__$1;
(statearr_14961_14990[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (12))){
var inst_14914 = (state_14951[(8)]);
var inst_14934 = fluree.db.index.resolve_children_when(r,resolve_QMARK_,error_ch,inst_14914);
var state_14951__$1 = state_14951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14951__$1,(18),inst_14934);
} else {
if((state_val_14952 === (2))){
var inst_14908 = (state_14951[(2)]);
var inst_14909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14910 = [inst_14908];
var inst_14911 = (new cljs.core.PersistentVector(null,1,(5),inst_14909,inst_14910,null));
var inst_14912 = inst_14911;
var state_14951__$1 = (function (){var statearr_14962 = state_14951;
(statearr_14962[(9)] = inst_14912);

return statearr_14962;
})();
var statearr_14963_14991 = state_14951__$1;
(statearr_14963_14991[(2)] = null);

(statearr_14963_14991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (11))){
var inst_14914 = (state_14951[(8)]);
var inst_14924 = (include_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_14914) : include_QMARK_.call(null,inst_14914));
var state_14951__$1 = state_14951;
if(cljs.core.truth_(inst_14924)){
var statearr_14964_14992 = state_14951__$1;
(statearr_14964_14992[(1)] = (14));

} else {
var statearr_14965_14993 = state_14951__$1;
(statearr_14965_14993[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (9))){
var inst_14914 = (state_14951[(8)]);
var inst_14920 = fluree.db.index.expanded_QMARK_(inst_14914);
var state_14951__$1 = state_14951;
var statearr_14966_14994 = state_14951__$1;
(statearr_14966_14994[(2)] = inst_14920);

(statearr_14966_14994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (5))){
var inst_14917 = (state_14951[(10)]);
var inst_14914 = (state_14951[(8)]);
var inst_14912 = (state_14951[(9)]);
var inst_14916 = cljs.core.pop(inst_14912);
var inst_14917__$1 = fluree.db.index.leaf_QMARK_(inst_14914);
var state_14951__$1 = (function (){var statearr_14967 = state_14951;
(statearr_14967[(10)] = inst_14917__$1);

(statearr_14967[(11)] = inst_14916);

return statearr_14967;
})();
if(inst_14917__$1){
var statearr_14968_14995 = state_14951__$1;
(statearr_14968_14995[(1)] = (8));

} else {
var statearr_14969_14996 = state_14951__$1;
(statearr_14969_14996[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (14))){
var inst_14914 = (state_14951[(8)]);
var inst_14926 = fluree.db.index.unmark_expanded(inst_14914);
var state_14951__$1 = state_14951;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14951__$1,(17),out,inst_14926);
} else {
if((state_val_14952 === (16))){
var inst_14916 = (state_14951[(11)]);
var inst_14931 = (state_14951[(2)]);
var inst_14912 = inst_14916;
var state_14951__$1 = (function (){var statearr_14970 = state_14951;
(statearr_14970[(12)] = inst_14931);

(statearr_14970[(9)] = inst_14912);

return statearr_14970;
})();
var statearr_14971_14997 = state_14951__$1;
(statearr_14971_14997[(2)] = null);

(statearr_14971_14997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (10))){
var inst_14922 = (state_14951[(2)]);
var state_14951__$1 = state_14951;
if(cljs.core.truth_(inst_14922)){
var statearr_14972_14998 = state_14951__$1;
(statearr_14972_14998[(1)] = (11));

} else {
var statearr_14973_14999 = state_14951__$1;
(statearr_14973_14999[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (18))){
var inst_14914 = (state_14951[(8)]);
var inst_14916 = (state_14951[(11)]);
var inst_14936 = (state_14951[(2)]);
var inst_14937 = fluree.db.index.mark_expanded(inst_14914);
var inst_14938 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14916,inst_14937);
var inst_14939 = cljs.core.rseq(inst_14936);
var inst_14940 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14938,inst_14939);
var inst_14912 = inst_14940;
var state_14951__$1 = (function (){var statearr_14974 = state_14951;
(statearr_14974[(9)] = inst_14912);

return statearr_14974;
})();
var statearr_14975_15000 = state_14951__$1;
(statearr_14975_15000[(2)] = null);

(statearr_14975_15000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14952 === (8))){
var inst_14917 = (state_14951[(10)]);
var state_14951__$1 = state_14951;
var statearr_14976_15001 = state_14951__$1;
(statearr_14976_15001[(2)] = inst_14917);

(statearr_14976_15001[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14977 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14977[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14977[(1)] = (1));

return statearr_14977;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14951){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14951);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14978){var ex__2730__auto__ = e14978;
var statearr_14979_15002 = state_14951;
(statearr_14979_15002[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14951[(4)]))){
var statearr_14980_15003 = state_14951;
(statearr_14980_15003[(1)] = cljs.core.first((state_14951[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15004 = state_14951;
state_14951 = G__15004;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14951){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14981 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14981[(6)] = c__2749__auto___14983);

return statearr_14981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

