// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19914_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19914_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19918 = coll;
var vec__19919 = G__19918;
var seq__19920 = cljs.core.seq(vec__19919);
var first__19921 = cljs.core.first(seq__19920);
var seq__19920__$1 = cljs.core.next(seq__19920);
var clause = first__19921;
var r = seq__19920__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19918__$1 = G__19918;
var res__$1 = res;
while(true){
var vec__19925 = G__19918__$1;
var seq__19926 = cljs.core.seq(vec__19925);
var first__19927 = cljs.core.first(seq__19926);
var seq__19926__$1 = cljs.core.next(seq__19926);
var clause__$1 = first__19927;
var r__$1 = seq__19926__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19928 = r__$1;
var G__19929 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19918__$1 = G__19928;
res__$1 = G__19929;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__19930){
var map__19931 = p__19930;
var map__19931__$1 = cljs.core.__destructure_map(map__19931);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19931__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19935 = coll;
var vec__19936 = G__19935;
var seq__19937 = cljs.core.seq(vec__19936);
var first__19938 = cljs.core.first(seq__19937);
var seq__19937__$1 = cljs.core.next(seq__19937);
var clause = first__19938;
var r = seq__19937__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19935__$1 = G__19935;
var res__$1 = res;
while(true){
var vec__19942 = G__19935__$1;
var seq__19943 = cljs.core.seq(vec__19942);
var first__19944 = cljs.core.first(seq__19943);
var seq__19943__$1 = cljs.core.next(seq__19943);
var clause__$1 = first__19944;
var r__$1 = seq__19943__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19945 = r__$1;
var G__19946 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__19935__$1 = G__19945;
res__$1 = G__19946;
continue;
} else {
var G__19947 = r__$1;
var G__19948 = res__$2;
G__19935__$1 = G__19947;
res__$1 = G__19948;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19952 = coll;
var vec__19953 = G__19952;
var seq__19954 = cljs.core.seq(vec__19953);
var first__19955 = cljs.core.first(seq__19954);
var seq__19954__$1 = cljs.core.next(seq__19954);
var clause = first__19955;
var r = seq__19954__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19952__$1 = G__19952;
var res__$1 = res;
while(true){
var vec__19959 = G__19952__$1;
var seq__19960 = cljs.core.seq(vec__19959);
var first__19961 = cljs.core.first(seq__19960);
var seq__19960__$1 = cljs.core.next(seq__19960);
var clause__$1 = first__19961;
var r__$1 = seq__19960__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19962 = r__$1;
var G__19963 = res__$2;
G__19952__$1 = G__19962;
res__$1 = G__19963;
continue;
} else {
var G__19964 = r__$1;
var G__19965 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19952__$1 = G__19964;
res__$1 = G__19965;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19968 = clause;
var G__19968__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__19968):G__19968);
var G__19968__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__19968__$1)
;
var G__19968__$3 = (function (){var fexpr__19969 = (function (p1__19966_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19966_SHARP_)," ."].join('');
});
return fexpr__19969(G__19968__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__19970 = (function (p1__19967_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19967_SHARP_),"}"].join('');
});
return fexpr__19970(G__19968__$3);
} else {
return G__19968__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__19974 = opts;
var map__19974__$1 = cljs.core.__destructure_map(map__19974);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19974__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19974__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19974__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19974__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19974__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19971_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19971_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19972_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19972_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19973_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19973_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19988){
var state_val_19989 = (state_19988[(1)]);
if((state_val_19989 === (1))){
var inst_19975 = fluree.db.util.core.url_encode(query);
var inst_19976 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19975)].join('');
var inst_19977 = ["User-Agent","Accept"];
var inst_19978 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19979 = cljs.core.PersistentHashMap.fromArrays(inst_19977,inst_19978);
var inst_19980 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19981 = [inst_19979,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19982 = cljs.core.PersistentHashMap.fromArrays(inst_19980,inst_19981);
var inst_19983 = fluree.db.util.xhttp.get(inst_19976,inst_19982);
var state_19988__$1 = state_19988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19988__$1,(2),inst_19983);
} else {
if((state_val_19989 === (2))){
var inst_19985 = (state_19988[(2)]);
var inst_19986 = fluree.db.util.async.throw_err(inst_19985);
var state_19988__$1 = state_19988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19988__$1,inst_19986);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_19990 = [null,null,null,null,null,null,null];
(statearr_19990[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__);

(statearr_19990[(1)] = (1));

return statearr_19990;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1 = (function (state_19988){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19988);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19991){var ex__2730__auto__ = e19991;
var statearr_19992_19995 = state_19988;
(statearr_19992_19995[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19988[(4)]))){
var statearr_19993_19996 = state_19988;
(statearr_19993_19996[(1)] = cljs.core.first((state_19988[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19997 = state_19988;
state_19988 = G__19997;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = function(state_19988){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1.call(this,state_19988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19994 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19994[(6)] = c__2749__auto__);

return statearr_19994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20015){
var state_val_20016 = (state_20015[(1)]);
if((state_val_20016 === (1))){
var inst_19998 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_20015__$1 = state_20015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20015__$1,(2),inst_19998);
} else {
if((state_val_20016 === (2))){
var inst_20001 = (state_20015[(7)]);
var inst_20000 = (state_20015[(2)]);
var inst_20001__$1 = fluree.db.util.async.throw_err(inst_20000);
var inst_20002 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20001__$1);
var inst_20003 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_20002);
var state_20015__$1 = (function (){var statearr_20017 = state_20015;
(statearr_20017[(7)] = inst_20001__$1);

return statearr_20017;
})();
if(inst_20003){
var statearr_20018_20027 = state_20015__$1;
(statearr_20018_20027[(1)] = (3));

} else {
var statearr_20019_20028 = state_20015__$1;
(statearr_20019_20028[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20016 === (3))){
var inst_20001 = (state_20015[(7)]);
var state_20015__$1 = state_20015;
var statearr_20020_20029 = state_20015__$1;
(statearr_20020_20029[(2)] = inst_20001);

(statearr_20020_20029[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20016 === (4))){
var inst_20001 = (state_20015[(7)]);
var inst_20006 = (function (){var body = inst_20001;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20007 = cljs.core.second(inst_20001);
var inst_20008 = cljs.core.second(inst_20007);
var inst_20009 = cljs.core.first(inst_20008);
var inst_20010 = cljs.core.second(inst_20009);
var inst_20011 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20006,inst_20010);
var state_20015__$1 = state_20015;
var statearr_20021_20030 = state_20015__$1;
(statearr_20021_20030[(2)] = inst_20011);

(statearr_20021_20030[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20016 === (5))){
var inst_20013 = (state_20015[(2)]);
var state_20015__$1 = state_20015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20015__$1,inst_20013);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_20022 = [null,null,null,null,null,null,null,null];
(statearr_20022[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__);

(statearr_20022[(1)] = (1));

return statearr_20022;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1 = (function (state_20015){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20015);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20023){var ex__2730__auto__ = e20023;
var statearr_20024_20031 = state_20015;
(statearr_20024_20031[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20015[(4)]))){
var statearr_20025_20032 = state_20015;
(statearr_20025_20032[(1)] = cljs.core.first((state_20015[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20033 = state_20015;
state_20015 = G__20033;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = function(state_20015){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1.call(this,state_20015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20026 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20026[(6)] = c__2749__auto__);

return statearr_20026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20034_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20034_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20035_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20035_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20036_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20036_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20036_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20036_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20082){
var state_val_20083 = (state_20082[(1)]);
if((state_val_20083 === (7))){
var inst_20047 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20082__$1 = state_20082;
var statearr_20084_20112 = state_20082__$1;
(statearr_20084_20112[(2)] = inst_20047);

(statearr_20084_20112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (1))){
var state_20082__$1 = state_20082;
var statearr_20085_20113 = state_20082__$1;
(statearr_20085_20113[(2)] = null);

(statearr_20085_20113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (4))){
var inst_20037 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
var statearr_20086_20114 = state_20082__$1;
(statearr_20086_20114[(2)] = inst_20037);

(statearr_20086_20114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (15))){
var inst_20061 = (state_20082[(7)]);
var inst_20056 = (state_20082[(8)]);
var inst_20055 = (state_20082[(9)]);
var inst_20066 = (state_20082[(2)]);
var inst_20067 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20061,(0),inst_20066);
var inst_20068 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20069 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20055);
var inst_20070 = [inst_20056,inst_20069];
var inst_20071 = cljs.core.PersistentHashMap.fromArrays(inst_20068,inst_20070);
var inst_20072 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20067,inst_20071);
var inst_20073 = (function(){throw inst_20072})();
var state_20082__$1 = state_20082;
var statearr_20087_20115 = state_20082__$1;
(statearr_20087_20115[(2)] = inst_20073);

(statearr_20087_20115[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (13))){
var inst_20060 = (state_20082[(10)]);
var state_20082__$1 = state_20082;
var statearr_20088_20116 = state_20082__$1;
(statearr_20088_20116[(2)] = inst_20060);

(statearr_20088_20116[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (6))){
var state_20082__$1 = state_20082;
var statearr_20089_20117 = state_20082__$1;
(statearr_20089_20117[(2)] = null);

(statearr_20089_20117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (3))){
var inst_20080 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20082__$1,inst_20080);
} else {
if((state_val_20083 === (12))){
var inst_20077 = (state_20082[(2)]);
var _ = (function (){var statearr_20090 = state_20082;
(statearr_20090[(4)] = cljs.core.rest((state_20082[(4)])));

return statearr_20090;
})();
var state_20082__$1 = state_20082;
var statearr_20091_20118 = state_20082__$1;
(statearr_20091_20118[(2)] = inst_20077);

(statearr_20091_20118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (2))){
var _ = (function (){var statearr_20092 = state_20082;
(statearr_20092[(4)] = cljs.core.cons((5),(state_20082[(4)])));

return statearr_20092;
})();
var inst_20044 = cljs.core.empty_QMARK_(matching_vars);
var state_20082__$1 = state_20082;
if(inst_20044){
var statearr_20093_20119 = state_20082__$1;
(statearr_20093_20119[(1)] = (6));

} else {
var statearr_20094_20120 = state_20082__$1;
(statearr_20094_20120[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (11))){
var inst_20055 = (state_20082[(9)]);
var inst_20075 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20055,all_vars);
var state_20082__$1 = state_20082;
var statearr_20096_20121 = state_20082__$1;
(statearr_20096_20121[(2)] = inst_20075);

(statearr_20096_20121[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (9))){
var inst_20056 = (state_20082[(8)]);
var inst_20055 = (state_20082[(9)]);
var inst_20053 = (state_20082[(2)]);
var inst_20054 = fluree.db.util.async.throw_err(inst_20053);
var inst_20055__$1 = cljs.core.__destructure_map(inst_20054);
var inst_20056__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20055__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20057 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20055__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20058 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20056__$1);
var state_20082__$1 = (function (){var statearr_20097 = state_20082;
(statearr_20097[(11)] = inst_20057);

(statearr_20097[(8)] = inst_20056__$1);

(statearr_20097[(9)] = inst_20055__$1);

return statearr_20097;
})();
if(inst_20058){
var statearr_20098_20122 = state_20082__$1;
(statearr_20098_20122[(1)] = (10));

} else {
var statearr_20099_20123 = state_20082__$1;
(statearr_20099_20123[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (5))){
var _ = (function (){var statearr_20100 = state_20082;
(statearr_20100[(4)] = cljs.core.rest((state_20082[(4)])));

return statearr_20100;
})();
var state_20082__$1 = state_20082;
var ex20095 = (state_20082__$1[(2)]);
var statearr_20101_20124 = state_20082__$1;
(statearr_20101_20124[(5)] = ex20095);


if((ex20095 instanceof Error)){
var statearr_20102_20125 = state_20082__$1;
(statearr_20102_20125[(1)] = (4));

(statearr_20102_20125[(5)] = null);

} else {
throw ex20095;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (14))){
var state_20082__$1 = state_20082;
var statearr_20103_20126 = state_20082__$1;
(statearr_20103_20126[(2)] = (1000));

(statearr_20103_20126[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (10))){
var inst_20060 = (state_20082[(10)]);
var inst_20057 = (state_20082[(11)]);
var inst_20055 = (state_20082[(9)]);
var inst_20060__$1 = cljs.core.count(inst_20057);
var inst_20061 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20055);
var inst_20062 = (inst_20060__$1 < (1000));
var state_20082__$1 = (function (){var statearr_20104 = state_20082;
(statearr_20104[(10)] = inst_20060__$1);

(statearr_20104[(7)] = inst_20061);

return statearr_20104;
})();
if(cljs.core.truth_(inst_20062)){
var statearr_20105_20127 = state_20082__$1;
(statearr_20105_20127[(1)] = (13));

} else {
var statearr_20106_20128 = state_20082__$1;
(statearr_20106_20128[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (8))){
var inst_20049 = (state_20082[(2)]);
var inst_20050 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20049,optional_clauses);
var inst_20051 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20050);
var state_20082__$1 = state_20082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20082__$1,(9),inst_20051);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20107 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20107[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__);

(statearr_20107[(1)] = (1));

return statearr_20107;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1 = (function (state_20082){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20082);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20108){var ex__2730__auto__ = e20108;
var statearr_20109_20129 = state_20082;
(statearr_20109_20129[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20082[(4)]))){
var statearr_20110_20130 = state_20082;
(statearr_20110_20130[(1)] = cljs.core.first((state_20082[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20131 = state_20082;
state_20082 = G__20131;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = function(state_20082){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1.call(this,state_20082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20111 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20111[(6)] = c__2749__auto__);

return statearr_20111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
