// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21903 = arguments.length;
switch (G__21903) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__21904 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__21904) : f.call(null,G__21904));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__21905 = cljs.core._deref(vol);
var G__21906 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__21905,G__21906) : f.call(null,G__21905,G__21906));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__21907 = cljs.core._deref(vol);
var G__21908 = arg1;
var G__21909 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__21907,G__21908,G__21909) : f.call(null,G__21907,G__21908,G__21909));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__21910 = cljs.core._deref(vol);
var G__21911 = arg1;
var G__21912 = arg2;
var G__21913 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__21910,G__21911,G__21912,G__21913) : f.call(null,G__21910,G__21911,G__21912,G__21913));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22074){
var state_val_22075 = (state_22074[(1)]);
if((state_val_22075 === (7))){
var inst_22069 = (state_22074[(2)]);
var _ = (function (){var statearr_22076 = state_22074;
(statearr_22076[(4)] = cljs.core.rest((state_22074[(4)])));

return statearr_22076;
})();
var state_22074__$1 = state_22074;
var statearr_22077_22159 = state_22074__$1;
(statearr_22077_22159[(2)] = inst_22069);

(statearr_22077_22159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (20))){
var inst_21996 = (state_22074[(7)]);
var state_22074__$1 = state_22074;
var statearr_22078_22160 = state_22074__$1;
(statearr_22078_22160[(2)] = inst_21996);

(statearr_22078_22160[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (27))){
var inst_21951 = (state_22074[(8)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21951)){
var statearr_22079_22161 = state_22074__$1;
(statearr_22079_22161[(1)] = (29));

} else {
var statearr_22080_22162 = state_22074__$1;
(statearr_22080_22162[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (1))){
var state_22074__$1 = state_22074;
var statearr_22081_22163 = state_22074__$1;
(statearr_22081_22163[(2)] = null);

(statearr_22081_22163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (24))){
var inst_21952 = (state_22074[(9)]);
var state_22074__$1 = state_22074;
var statearr_22082_22164 = state_22074__$1;
(statearr_22082_22164[(2)] = inst_21952);

(statearr_22082_22164[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (39))){
var inst_21988 = (state_22074[(10)]);
var state_22074__$1 = state_22074;
var statearr_22083_22165 = state_22074__$1;
(statearr_22083_22165[(2)] = inst_21988);

(statearr_22083_22165[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (46))){
var inst_21953 = (state_22074[(11)]);
var state_22074__$1 = state_22074;
var statearr_22084_22166 = state_22074__$1;
(statearr_22084_22166[(2)] = inst_21953);

(statearr_22084_22166[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (4))){
var inst_21915 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22085_22167 = state_22074__$1;
(statearr_22085_22167[(2)] = inst_21915);

(statearr_22085_22167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (15))){
var inst_21964 = (state_22074[(12)]);
var inst_21970 = cljs.core.count(inst_21964);
var inst_21971 = fluree.db.query.fql_resp.add_fuel(fuel,inst_21970,max_fuel);
var state_22074__$1 = state_22074;
var statearr_22086_22168 = state_22074__$1;
(statearr_22086_22168[(2)] = inst_21971);

(statearr_22086_22168[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (48))){
var inst_22055 = (state_22074[(13)]);
var inst_21933 = (state_22074[(14)]);
var inst_21940 = (state_22074[(15)]);
var inst_22063 = (state_22074[(2)]);
var inst_22064 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21933,inst_22063,inst_22055);
var inst_21932 = inst_21940;
var inst_21933__$1 = inst_22064;
var state_22074__$1 = (function (){var statearr_22087 = state_22074;
(statearr_22087[(16)] = inst_21932);

(statearr_22087[(14)] = inst_21933__$1);

return statearr_22087;
})();
var statearr_22088_22169 = state_22074__$1;
(statearr_22088_22169[(2)] = null);

(statearr_22088_22169[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (50))){
var inst_21955 = (state_22074[(17)]);
var state_22074__$1 = state_22074;
var statearr_22089_22170 = state_22074__$1;
(statearr_22089_22170[(2)] = inst_21955);

(statearr_22089_22170[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (21))){
var inst_21952 = (state_22074[(9)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21952)){
var statearr_22091_22171 = state_22074__$1;
(statearr_22091_22171[(1)] = (23));

} else {
var statearr_22092_22172 = state_22074__$1;
(statearr_22092_22172[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (31))){
var inst_22012 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_22012)){
var statearr_22093_22173 = state_22074__$1;
(statearr_22093_22173[(1)] = (32));

} else {
var statearr_22094_22174 = state_22074__$1;
(statearr_22094_22174[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (32))){
var inst_21987 = (state_22074[(18)]);
var inst_21988 = (state_22074[(10)]);
var inst_21995 = (state_22074[(19)]);
var inst_22014 = (inst_21987 + (1));
var tmp22090 = inst_21988;
var inst_21986 = inst_21995;
var inst_21987__$1 = inst_22014;
var inst_21988__$1 = tmp22090;
var state_22074__$1 = (function (){var statearr_22095 = state_22074;
(statearr_22095[(20)] = inst_21986);

(statearr_22095[(18)] = inst_21987__$1);

(statearr_22095[(10)] = inst_21988__$1);

return statearr_22095;
})();
var statearr_22096_22175 = state_22074__$1;
(statearr_22096_22175[(2)] = null);

(statearr_22096_22175[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (40))){
var state_22074__$1 = state_22074;
if(cljs.core.truth_(fuel)){
var statearr_22097_22176 = state_22074__$1;
(statearr_22097_22176[(1)] = (42));

} else {
var statearr_22098_22177 = state_22074__$1;
(statearr_22098_22177[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (33))){
var state_22074__$1 = state_22074;
var statearr_22099_22178 = state_22074__$1;
(statearr_22099_22178[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (13))){
var inst_21964 = (state_22074[(12)]);
var state_22074__$1 = state_22074;
var statearr_22101_22179 = state_22074__$1;
(statearr_22101_22179[(2)] = inst_21964);

(statearr_22101_22179[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (22))){
var inst_22005 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_22005)){
var statearr_22102_22180 = state_22074__$1;
(statearr_22102_22180[(1)] = (26));

} else {
var statearr_22103_22181 = state_22074__$1;
(statearr_22103_22181[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (36))){
var state_22074__$1 = state_22074;
var statearr_22104_22182 = state_22074__$1;
(statearr_22104_22182[(2)] = null);

(statearr_22104_22182[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (41))){
var inst_21987 = (state_22074[(18)]);
var inst_21995 = (state_22074[(19)]);
var inst_22044 = (state_22074[(2)]);
var inst_22045 = (inst_21987 + (1));
var inst_21986 = inst_21995;
var inst_21987__$1 = inst_22045;
var inst_21988 = inst_22044;
var state_22074__$1 = (function (){var statearr_22105 = state_22074;
(statearr_22105[(20)] = inst_21986);

(statearr_22105[(18)] = inst_21987__$1);

(statearr_22105[(10)] = inst_21988);

return statearr_22105;
})();
var statearr_22106_22183 = state_22074__$1;
(statearr_22106_22183[(2)] = null);

(statearr_22106_22183[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (43))){
var state_22074__$1 = state_22074;
var statearr_22107_22184 = state_22074__$1;
(statearr_22107_22184[(2)] = null);

(statearr_22107_22184[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (29))){
var inst_21951 = (state_22074[(8)]);
var inst_21987 = (state_22074[(18)]);
var inst_22009 = (inst_21987 < inst_21951);
var state_22074__$1 = state_22074;
var statearr_22108_22185 = state_22074__$1;
(statearr_22108_22185[(2)] = inst_22009);

(statearr_22108_22185[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (44))){
var inst_22028 = (state_22074[(21)]);
var inst_22024 = (state_22074[(22)]);
var inst_22037 = (state_22074[(2)]);
var inst_22038 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22028,inst_22024) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22028,inst_22024));
var state_22074__$1 = (function (){var statearr_22109 = state_22074;
(statearr_22109[(23)] = inst_22037);

return statearr_22109;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22074__$1,(45),inst_22038);
} else {
if((state_val_22075 === (6))){
var inst_21939 = (state_22074[(24)]);
var inst_21932 = (state_22074[(16)]);
var inst_21938 = cljs.core.seq(inst_21932);
var inst_21939__$1 = cljs.core.first(inst_21938);
var inst_21940 = cljs.core.next(inst_21938);
var inst_21941 = cljs.core.not(inst_21939__$1);
var state_22074__$1 = (function (){var statearr_22110 = state_22074;
(statearr_22110[(24)] = inst_21939__$1);

(statearr_22110[(15)] = inst_21940);

return statearr_22110;
})();
if(inst_21941){
var statearr_22111_22186 = state_22074__$1;
(statearr_22111_22186[(1)] = (8));

} else {
var statearr_22112_22187 = state_22074__$1;
(statearr_22112_22187[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (28))){
var inst_22053 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22113_22188 = state_22074__$1;
(statearr_22113_22188[(2)] = inst_22053);

(statearr_22113_22188[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (51))){
var inst_22061 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22114_22189 = state_22074__$1;
(statearr_22114_22189[(2)] = inst_22061);

(statearr_22114_22189[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (25))){
var inst_22003 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22115_22190 = state_22074__$1;
(statearr_22115_22190[(2)] = inst_22003);

(statearr_22115_22190[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (34))){
var inst_22051 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22116_22191 = state_22074__$1;
(statearr_22116_22191[(2)] = inst_22051);

(statearr_22116_22191[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (17))){
var inst_21964 = (state_22074[(12)]);
var inst_21974 = (state_22074[(2)]);
var inst_21982 = cljs.core.seq(inst_21964);
var inst_21983 = cljs.core.first(inst_21982);
var inst_21984 = cljs.core.next(inst_21982);
var inst_21985 = cljs.core.PersistentVector.EMPTY;
var inst_21986 = inst_21964;
var inst_21987 = (0);
var inst_21988 = inst_21985;
var state_22074__$1 = (function (){var statearr_22117 = state_22074;
(statearr_22117[(25)] = inst_21984);

(statearr_22117[(26)] = inst_21983);

(statearr_22117[(20)] = inst_21986);

(statearr_22117[(27)] = inst_21974);

(statearr_22117[(18)] = inst_21987);

(statearr_22117[(10)] = inst_21988);

return statearr_22117;
})();
var statearr_22118_22192 = state_22074__$1;
(statearr_22118_22192[(2)] = null);

(statearr_22118_22192[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (3))){
var inst_22072 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22074__$1,inst_22072);
} else {
if((state_val_22075 === (12))){
var state_22074__$1 = state_22074;
var statearr_22119_22193 = state_22074__$1;
(statearr_22119_22193[(2)] = fuel);

(statearr_22119_22193[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (2))){
var _ = (function (){var statearr_22120 = state_22074;
(statearr_22120[(4)] = cljs.core.cons((5),(state_22074[(4)])));

return statearr_22120;
})();
var inst_21928 = reverse_refs_specs;
var inst_21929 = cljs.core.seq(inst_21928);
var inst_21930 = cljs.core.first(inst_21929);
var inst_21931 = cljs.core.next(inst_21929);
var inst_21932 = inst_21928;
var inst_21933 = null;
var state_22074__$1 = (function (){var statearr_22121 = state_22074;
(statearr_22121[(28)] = inst_21930);

(statearr_22121[(16)] = inst_21932);

(statearr_22121[(14)] = inst_21933);

(statearr_22121[(29)] = inst_21931);

return statearr_22121;
})();
var statearr_22122_22194 = state_22074__$1;
(statearr_22122_22194[(2)] = null);

(statearr_22122_22194[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (23))){
var inst_21952 = (state_22074[(9)]);
var inst_21987 = (state_22074[(18)]);
var inst_22000 = (inst_21987 >= inst_21952);
var state_22074__$1 = state_22074;
var statearr_22123_22195 = state_22074__$1;
(statearr_22123_22195[(2)] = inst_22000);

(statearr_22123_22195[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (47))){
var inst_21954 = (state_22074[(30)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21954)){
var statearr_22124_22196 = state_22074__$1;
(statearr_22124_22196[(1)] = (49));

} else {
var statearr_22125_22197 = state_22074__$1;
(statearr_22125_22197[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (35))){
var inst_21994 = (state_22074[(31)]);
var inst_22018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22019 = [inst_21994];
var inst_22020 = (new cljs.core.PersistentVector(null,1,(5),inst_22018,inst_22019,null));
var inst_22021 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22020);
var state_22074__$1 = state_22074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22074__$1,(38),inst_22021);
} else {
if((state_val_22075 === (19))){
var inst_21953 = (state_22074[(11)]);
var inst_22055 = (state_22074[(2)]);
var state_22074__$1 = (function (){var statearr_22126 = state_22074;
(statearr_22126[(13)] = inst_22055);

return statearr_22126;
})();
if(cljs.core.truth_(inst_21953)){
var statearr_22127_22198 = state_22074__$1;
(statearr_22127_22198[(1)] = (46));

} else {
var statearr_22128_22199 = state_22074__$1;
(statearr_22128_22199[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (11))){
var inst_21964 = (state_22074[(12)]);
var inst_21961 = (state_22074[(2)]);
var inst_21962 = fluree.db.util.async.throw_err(inst_21961);
var inst_21963 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.s,inst_21962);
var inst_21964__$1 = cljs.core.not_empty(inst_21963);
var state_22074__$1 = (function (){var statearr_22130 = state_22074;
(statearr_22130[(12)] = inst_21964__$1);

return statearr_22130;
})();
if(cljs.core.truth_(inst_21964__$1)){
var statearr_22131_22200 = state_22074__$1;
(statearr_22131_22200[(1)] = (12));

} else {
var statearr_22132_22201 = state_22074__$1;
(statearr_22132_22201[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (9))){
var inst_21939 = (state_22074[(24)]);
var inst_21949 = (state_22074[(32)]);
var inst_21948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21939,(0),null);
var inst_21949__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21939,(1),null);
var inst_21950 = cljs.core.__destructure_map(inst_21949__$1);
var inst_21951 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21950,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21950,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21950,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21950,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21950,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21957 = [subject_id,inst_21948];
var inst_21958 = (new cljs.core.PersistentVector(null,2,(5),inst_21956,inst_21957,null));
var inst_21959 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21958);
var state_22074__$1 = (function (){var statearr_22133 = state_22074;
(statearr_22133[(9)] = inst_21952);

(statearr_22133[(30)] = inst_21954);

(statearr_22133[(8)] = inst_21951);

(statearr_22133[(32)] = inst_21949__$1);

(statearr_22133[(17)] = inst_21955);

(statearr_22133[(11)] = inst_21953);

return statearr_22133;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22074__$1,(11),inst_21959);
} else {
if((state_val_22075 === (5))){
var _ = (function (){var statearr_22134 = state_22074;
(statearr_22134[(4)] = cljs.core.rest((state_22074[(4)])));

return statearr_22134;
})();
var state_22074__$1 = state_22074;
var ex22129 = (state_22074__$1[(2)]);
var statearr_22135_22202 = state_22074__$1;
(statearr_22135_22202[(5)] = ex22129);


if((ex22129 instanceof Error)){
var statearr_22136_22203 = state_22074__$1;
(statearr_22136_22203[(1)] = (4));

(statearr_22136_22203[(5)] = null);

} else {
throw ex22129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (14))){
var inst_21968 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
if(cljs.core.truth_(inst_21968)){
var statearr_22137_22204 = state_22074__$1;
(statearr_22137_22204[(1)] = (15));

} else {
var statearr_22138_22205 = state_22074__$1;
(statearr_22138_22205[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (45))){
var inst_21988 = (state_22074[(10)]);
var inst_22040 = (state_22074[(2)]);
var inst_22041 = fluree.db.util.async.throw_err(inst_22040);
var inst_22042 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21988,inst_22041);
var state_22074__$1 = state_22074;
var statearr_22139_22206 = state_22074__$1;
(statearr_22139_22206[(2)] = inst_22042);

(statearr_22139_22206[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (26))){
var inst_21988 = (state_22074[(10)]);
var state_22074__$1 = state_22074;
var statearr_22140_22207 = state_22074__$1;
(statearr_22140_22207[(2)] = inst_21988);

(statearr_22140_22207[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (16))){
var state_22074__$1 = state_22074;
var statearr_22141_22208 = state_22074__$1;
(statearr_22141_22208[(2)] = null);

(statearr_22141_22208[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (38))){
var inst_22024 = (state_22074[(22)]);
var inst_21949 = (state_22074[(32)]);
var inst_22023 = (state_22074[(2)]);
var inst_22024__$1 = fluree.db.util.async.throw_err(inst_22023);
var inst_22025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22026 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22027 = (new cljs.core.PersistentVector(null,4,(5),inst_22025,inst_22026,null));
var inst_22028 = cljs.core.select_keys(inst_21949,inst_22027);
var inst_22029 = cljs.core.empty_QMARK_(inst_22024__$1);
var state_22074__$1 = (function (){var statearr_22142 = state_22074;
(statearr_22142[(21)] = inst_22028);

(statearr_22142[(22)] = inst_22024__$1);

return statearr_22142;
})();
if(inst_22029){
var statearr_22143_22209 = state_22074__$1;
(statearr_22143_22209[(1)] = (39));

} else {
var statearr_22144_22210 = state_22074__$1;
(statearr_22144_22210[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (30))){
var inst_21951 = (state_22074[(8)]);
var state_22074__$1 = state_22074;
var statearr_22145_22211 = state_22074__$1;
(statearr_22145_22211[(2)] = inst_21951);

(statearr_22145_22211[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (10))){
var inst_22067 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22146_22212 = state_22074__$1;
(statearr_22146_22212[(2)] = inst_22067);

(statearr_22146_22212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (18))){
var inst_21996 = (state_22074[(7)]);
var inst_21986 = (state_22074[(20)]);
var inst_21994 = (state_22074[(31)]);
var inst_21993 = cljs.core.seq(inst_21986);
var inst_21994__$1 = cljs.core.first(inst_21993);
var inst_21995 = cljs.core.next(inst_21993);
var inst_21996__$1 = cljs.core.not(inst_21994__$1);
var state_22074__$1 = (function (){var statearr_22147 = state_22074;
(statearr_22147[(7)] = inst_21996__$1);

(statearr_22147[(31)] = inst_21994__$1);

(statearr_22147[(19)] = inst_21995);

return statearr_22147;
})();
if(inst_21996__$1){
var statearr_22148_22213 = state_22074__$1;
(statearr_22148_22213[(1)] = (20));

} else {
var statearr_22149_22214 = state_22074__$1;
(statearr_22149_22214[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (42))){
var inst_22024 = (state_22074[(22)]);
var inst_22033 = cljs.core.count(inst_22024);
var inst_22034 = fluree.db.query.fql_resp.add_fuel(fuel,inst_22033,max_fuel);
var state_22074__$1 = state_22074;
var statearr_22150_22215 = state_22074__$1;
(statearr_22150_22215[(2)] = inst_22034);

(statearr_22150_22215[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (37))){
var inst_22049 = (state_22074[(2)]);
var state_22074__$1 = state_22074;
var statearr_22151_22216 = state_22074__$1;
(statearr_22151_22216[(2)] = inst_22049);

(statearr_22151_22216[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (8))){
var inst_21933 = (state_22074[(14)]);
var state_22074__$1 = state_22074;
var statearr_22152_22217 = state_22074__$1;
(statearr_22152_22217[(2)] = inst_21933);

(statearr_22152_22217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22075 === (49))){
var inst_21954 = (state_22074[(30)]);
var state_22074__$1 = state_22074;
var statearr_22153_22218 = state_22074__$1;
(statearr_22153_22218[(2)] = inst_21954);

(statearr_22153_22218[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0 = (function (){
var statearr_22154 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22154[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__);

(statearr_22154[(1)] = (1));

return statearr_22154;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1 = (function (state_22074){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22074);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22155){var ex__2730__auto__ = e22155;
var statearr_22156_22219 = state_22074;
(statearr_22156_22219[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22074[(4)]))){
var statearr_22157_22220 = state_22074;
(statearr_22157_22220[(1)] = cljs.core.first((state_22074[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22221 = state_22074;
state_22074 = G__22221;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = function(state_22074){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1.call(this,state_22074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22158 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22158[(6)] = c__2749__auto__);

return statearr_22158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__22223 = arguments.length;
switch (G__22223) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22225 = null;
var G__22225__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22225__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22225__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22225 = function(result,flake){
switch(arguments.length){
case 0:
return G__22225__0.call(this);
case 1:
return G__22225__1.call(this,result);
case 2:
return G__22225__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22225.cljs$core$IFn$_invoke$arity$0 = G__22225__0;
G__22225.cljs$core$IFn$_invoke$arity$1 = G__22225__1;
G__22225.cljs$core$IFn$_invoke$arity$2 = G__22225__2;
return G__22225;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o(flake);
var recur_pred = fluree.db.flake.p(flake);
var map__22226 = select_spec;
var map__22226__$1 = cljs.core.__destructure_map(map__22226);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22226__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22226__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22340){
var state_val_22341 = (state_22340[(1)]);
if((state_val_22341 === (7))){
var inst_22252 = flakes;
var inst_22253 = cljs.core.seq(inst_22252);
var inst_22254 = cljs.core.first(inst_22253);
var inst_22255 = cljs.core.next(inst_22253);
var inst_22256 = cljs.core.PersistentVector.EMPTY;
var inst_22257 = inst_22252;
var inst_22258 = (0);
var inst_22259 = inst_22256;
var state_22340__$1 = (function (){var statearr_22342 = state_22340;
(statearr_22342[(7)] = inst_22259);

(statearr_22342[(8)] = inst_22254);

(statearr_22342[(9)] = inst_22258);

(statearr_22342[(10)] = inst_22255);

(statearr_22342[(11)] = inst_22257);

return statearr_22342;
})();
var statearr_22343_22409 = state_22340__$1;
(statearr_22343_22409[(2)] = null);

(statearr_22343_22409[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (20))){
var state_22340__$1 = state_22340;
var statearr_22344_22410 = state_22340__$1;
(statearr_22344_22410[(2)] = results);

(statearr_22344_22410[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (27))){
var state_22340__$1 = state_22340;
var statearr_22345_22411 = state_22340__$1;
(statearr_22345_22411[(2)] = null);

(statearr_22345_22411[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (1))){
var state_22340__$1 = state_22340;
var statearr_22346_22412 = state_22340__$1;
(statearr_22346_22412[(2)] = null);

(statearr_22346_22412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (24))){
var state_22340__$1 = state_22340;
var statearr_22347_22413 = state_22340__$1;
(statearr_22347_22413[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (39))){
var inst_22259 = (state_22340[(7)]);
var inst_22321 = (state_22340[(12)]);
var inst_22266 = (state_22340[(13)]);
var inst_22324 = (state_22340[(2)]);
var inst_22325 = fluree.db.util.async.throw_err(inst_22324);
var inst_22326 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22259,inst_22325);
var inst_22257 = inst_22266;
var inst_22258 = inst_22321;
var inst_22259__$1 = inst_22326;
var state_22340__$1 = (function (){var statearr_22349 = state_22340;
(statearr_22349[(7)] = inst_22259__$1);

(statearr_22349[(9)] = inst_22258);

(statearr_22349[(11)] = inst_22257);

return statearr_22349;
})();
var statearr_22350_22414 = state_22340__$1;
(statearr_22350_22414[(2)] = null);

(statearr_22350_22414[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (4))){
var inst_22227 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22351_22415 = state_22340__$1;
(statearr_22351_22415[(2)] = inst_22227);

(statearr_22351_22415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (15))){
var inst_22240 = (state_22340[(14)]);
var state_22340__$1 = state_22340;
var statearr_22352_22416 = state_22340__$1;
(statearr_22352_22416[(2)] = inst_22240);

(statearr_22352_22416[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (21))){
var inst_22236 = (state_22340[(15)]);
var state_22340__$1 = state_22340;
if(cljs.core.truth_(inst_22236)){
var statearr_22353_22417 = state_22340__$1;
(statearr_22353_22417[(1)] = (23));

} else {
var statearr_22354_22418 = state_22340__$1;
(statearr_22354_22418[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (31))){
var inst_22304 = (state_22340[(16)]);
var state_22340__$1 = state_22340;
var statearr_22355_22419 = state_22340__$1;
(statearr_22355_22419[(2)] = inst_22304);

(statearr_22355_22419[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (32))){
var inst_22296 = (state_22340[(17)]);
var inst_22310 = (state_22340[(2)]);
var state_22340__$1 = (function (){var statearr_22356 = state_22340;
(statearr_22356[(18)] = inst_22310);

return statearr_22356;
})();
if(cljs.core.truth_(inst_22296)){
var statearr_22357_22420 = state_22340__$1;
(statearr_22357_22420[(1)] = (33));

} else {
var statearr_22358_22421 = state_22340__$1;
(statearr_22358_22421[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (33))){
var inst_22296 = (state_22340[(17)]);
var state_22340__$1 = state_22340;
var statearr_22359_22422 = state_22340__$1;
(statearr_22359_22422[(2)] = inst_22296);

(statearr_22359_22422[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (13))){
var inst_22276 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
if(cljs.core.truth_(inst_22276)){
var statearr_22361_22423 = state_22340__$1;
(statearr_22361_22423[(1)] = (17));

} else {
var statearr_22362_22424 = state_22340__$1;
(statearr_22362_22424[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (22))){
var inst_22293 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22363_22425 = state_22340__$1;
(statearr_22363_22425[(2)] = inst_22293);

(statearr_22363_22425[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (36))){
var inst_22259 = (state_22340[(7)]);
var inst_22258 = (state_22340[(9)]);
var inst_22266 = (state_22340[(13)]);
var inst_22318 = (inst_22258 + (1));
var tmp22360 = inst_22259;
var inst_22257 = inst_22266;
var inst_22258__$1 = inst_22318;
var inst_22259__$1 = tmp22360;
var state_22340__$1 = (function (){var statearr_22364 = state_22340;
(statearr_22364[(7)] = inst_22259__$1);

(statearr_22364[(9)] = inst_22258__$1);

(statearr_22364[(11)] = inst_22257);

return statearr_22364;
})();
var statearr_22365_22426 = state_22340__$1;
(statearr_22365_22426[(2)] = null);

(statearr_22365_22426[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (29))){
var inst_22303 = (state_22340[(2)]);
var inst_22304 = fluree.db.util.async.throw_err(inst_22303);
var state_22340__$1 = (function (){var statearr_22366 = state_22340;
(statearr_22366[(16)] = inst_22304);

return statearr_22366;
})();
if(cljs.core.truth_(fuel)){
var statearr_22367_22427 = state_22340__$1;
(statearr_22367_22427[(1)] = (30));

} else {
var statearr_22368_22428 = state_22340__$1;
(statearr_22368_22428[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (6))){
var state_22340__$1 = state_22340;
var statearr_22369_22429 = state_22340__$1;
(statearr_22369_22429[(2)] = results);

(statearr_22369_22429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (28))){
var inst_22289 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22370_22430 = state_22340__$1;
(statearr_22370_22430[(2)] = inst_22289);

(statearr_22370_22430[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (25))){
var inst_22291 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22371_22431 = state_22340__$1;
(statearr_22371_22431[(2)] = inst_22291);

(statearr_22371_22431[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (34))){
var inst_22310 = (state_22340[(18)]);
var inst_22313 = cljs.core.empty_QMARK_(inst_22310);
var state_22340__$1 = state_22340;
var statearr_22372_22432 = state_22340__$1;
(statearr_22372_22432[(2)] = inst_22313);

(statearr_22372_22432[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (17))){
var inst_22259 = (state_22340[(7)]);
var inst_22278 = cljs.core.empty_QMARK_(inst_22259);
var state_22340__$1 = state_22340;
if(inst_22278){
var statearr_22373_22433 = state_22340__$1;
(statearr_22373_22433[(1)] = (20));

} else {
var statearr_22374_22434 = state_22340__$1;
(statearr_22374_22434[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (3))){
var inst_22338 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22340__$1,inst_22338);
} else {
if((state_val_22341 === (12))){
var inst_22240 = (state_22340[(14)]);
var state_22340__$1 = state_22340;
if(cljs.core.truth_(inst_22240)){
var statearr_22375_22435 = state_22340__$1;
(statearr_22375_22435[(1)] = (14));

} else {
var statearr_22376_22436 = state_22340__$1;
(statearr_22376_22436[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (2))){
var _ = (function (){var statearr_22377 = state_22340;
(statearr_22377[(4)] = cljs.core.cons((5),(state_22340[(4)])));

return statearr_22377;
})();
var inst_22234 = select_spec;
var inst_22235 = cljs.core.__destructure_map(inst_22234);
var inst_22236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22235,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22237 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22235,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22235,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22239 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22235,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22240 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22235,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22241 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_22242 = (inst_22239 > inst_22241);
var state_22340__$1 = (function (){var statearr_22378 = state_22340;
(statearr_22378[(19)] = inst_22237);

(statearr_22378[(20)] = inst_22238);

(statearr_22378[(15)] = inst_22236);

(statearr_22378[(14)] = inst_22240);

return statearr_22378;
})();
if(cljs.core.truth_(inst_22242)){
var statearr_22379_22437 = state_22340__$1;
(statearr_22379_22437[(1)] = (6));

} else {
var statearr_22380_22438 = state_22340__$1;
(statearr_22380_22438[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (23))){
var inst_22237 = (state_22340[(19)]);
var inst_22259 = (state_22340[(7)]);
var inst_22282 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_22237,inst_22259);
var state_22340__$1 = state_22340;
var statearr_22381_22439 = state_22340__$1;
(statearr_22381_22439[(2)] = inst_22282);

(statearr_22381_22439[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (35))){
var inst_22265 = (state_22340[(21)]);
var inst_22315 = (state_22340[(2)]);
var inst_22316 = fluree.db.query.fql_resp.recur_select_spec(select_spec,inst_22265);
var state_22340__$1 = (function (){var statearr_22382 = state_22340;
(statearr_22382[(22)] = inst_22316);

return statearr_22382;
})();
if(cljs.core.truth_(inst_22315)){
var statearr_22383_22440 = state_22340__$1;
(statearr_22383_22440[(1)] = (36));

} else {
var statearr_22384_22441 = state_22340__$1;
(statearr_22384_22441[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (19))){
var inst_22331 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22385_22442 = state_22340__$1;
(statearr_22385_22442[(2)] = inst_22331);

(statearr_22385_22442[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (11))){
var inst_22267 = (state_22340[(23)]);
var state_22340__$1 = state_22340;
var statearr_22387_22443 = state_22340__$1;
(statearr_22387_22443[(2)] = inst_22267);

(statearr_22387_22443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (9))){
var inst_22267 = (state_22340[(23)]);
var inst_22265 = (state_22340[(21)]);
var inst_22257 = (state_22340[(11)]);
var inst_22264 = cljs.core.seq(inst_22257);
var inst_22265__$1 = cljs.core.first(inst_22264);
var inst_22266 = cljs.core.next(inst_22264);
var inst_22267__$1 = cljs.core.not(inst_22265__$1);
var state_22340__$1 = (function (){var statearr_22388 = state_22340;
(statearr_22388[(23)] = inst_22267__$1);

(statearr_22388[(21)] = inst_22265__$1);

(statearr_22388[(13)] = inst_22266);

return statearr_22388;
})();
if(inst_22267__$1){
var statearr_22389_22444 = state_22340__$1;
(statearr_22389_22444[(1)] = (11));

} else {
var statearr_22390_22445 = state_22340__$1;
(statearr_22390_22445[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (5))){
var _ = (function (){var statearr_22391 = state_22340;
(statearr_22391[(4)] = cljs.core.rest((state_22340[(4)])));

return statearr_22391;
})();
var state_22340__$1 = state_22340;
var ex22386 = (state_22340__$1[(2)]);
var statearr_22392_22446 = state_22340__$1;
(statearr_22392_22446[(5)] = ex22386);


if((ex22386 instanceof Error)){
var statearr_22393_22447 = state_22340__$1;
(statearr_22393_22447[(1)] = (4));

(statearr_22393_22447[(5)] = null);

} else {
throw ex22386;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (14))){
var inst_22258 = (state_22340[(9)]);
var inst_22240 = (state_22340[(14)]);
var inst_22271 = (inst_22258 < inst_22240);
var state_22340__$1 = state_22340;
var statearr_22394_22448 = state_22340__$1;
(statearr_22394_22448[(2)] = inst_22271);

(statearr_22394_22448[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (26))){
var inst_22237 = (state_22340[(19)]);
var inst_22259 = (state_22340[(7)]);
var inst_22285 = cljs.core.first(inst_22259);
var inst_22286 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_22237,inst_22285);
var state_22340__$1 = state_22340;
var statearr_22395_22449 = state_22340__$1;
(statearr_22395_22449[(2)] = inst_22286);

(statearr_22395_22449[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (16))){
var inst_22274 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22396_22450 = state_22340__$1;
(statearr_22396_22450[(2)] = inst_22274);

(statearr_22396_22450[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (38))){
var inst_22329 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22397_22451 = state_22340__$1;
(statearr_22397_22451[(2)] = inst_22329);

(statearr_22397_22451[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (30))){
var inst_22304 = (state_22340[(16)]);
var inst_22306 = fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_22307 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22306,inst_22304);
var state_22340__$1 = state_22340;
var statearr_22398_22452 = state_22340__$1;
(statearr_22398_22452[(2)] = inst_22307);

(statearr_22398_22452[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (10))){
var inst_22333 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22399_22453 = state_22340__$1;
(statearr_22399_22453[(2)] = inst_22333);

(statearr_22399_22453[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (18))){
var inst_22238 = (state_22340[(20)]);
var inst_22265 = (state_22340[(21)]);
var inst_22295 = fluree.db.flake.o(inst_22265);
var inst_22296 = cljs.core.contains_QMARK_(inst_22238,inst_22295);
var inst_22298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22299 = [inst_22295];
var inst_22300 = (new cljs.core.PersistentVector(null,1,(5),inst_22298,inst_22299,null));
var inst_22301 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22300);
var state_22340__$1 = (function (){var statearr_22400 = state_22340;
(statearr_22400[(17)] = inst_22296);

return statearr_22400;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22340__$1,(29),inst_22301);
} else {
if((state_val_22341 === (37))){
var inst_22316 = (state_22340[(22)]);
var inst_22310 = (state_22340[(18)]);
var inst_22258 = (state_22340[(9)]);
var inst_22321 = (inst_22258 + (1));
var inst_22322 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22316,inst_22310) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22316,inst_22310));
var state_22340__$1 = (function (){var statearr_22401 = state_22340;
(statearr_22401[(12)] = inst_22321);

return statearr_22401;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22340__$1,(39),inst_22322);
} else {
if((state_val_22341 === (8))){
var inst_22335 = (state_22340[(2)]);
var _ = (function (){var statearr_22402 = state_22340;
(statearr_22402[(4)] = cljs.core.rest((state_22340[(4)])));

return statearr_22402;
})();
var state_22340__$1 = state_22340;
var statearr_22403_22454 = state_22340__$1;
(statearr_22403_22454[(2)] = inst_22335);

(statearr_22403_22454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_22404 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22404[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__);

(statearr_22404[(1)] = (1));

return statearr_22404;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1 = (function (state_22340){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22340);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22405){var ex__2730__auto__ = e22405;
var statearr_22406_22455 = state_22340;
(statearr_22406_22455[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22340[(4)]))){
var statearr_22407_22456 = state_22340;
(statearr_22407_22456[(1)] = cljs.core.first((state_22340[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22457 = state_22340;
state_22340 = G__22457;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = function(state_22340){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1.call(this,state_22340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22408 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22408[(6)] = c__2749__auto__);

return statearr_22408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__22461 = arguments.length;
switch (G__22461) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22900){
var state_val_22901 = (state_22900[(1)]);
if((state_val_22901 === (121))){
var inst_22823 = (state_22900[(2)]);
var inst_22824 = fluree.db.util.async.throw_err(inst_22823);
var inst_22825 = cljs.core.seq(inst_22824);
var state_22900__$1 = state_22900;
if(inst_22825){
var statearr_22902_23116 = state_22900__$1;
(statearr_22902_23116[(1)] = (122));

} else {
var statearr_22903_23117 = state_22900__$1;
(statearr_22903_23117[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (65))){
var inst_22616 = (state_22900[(7)]);
var inst_22615 = (state_22900[(2)]);
var inst_22616__$1 = fluree.db.util.async.throw_err(inst_22615);
var inst_22617 = cljs.core.seq(inst_22616__$1);
var state_22900__$1 = (function (){var statearr_22904 = state_22900;
(statearr_22904[(7)] = inst_22616__$1);

return statearr_22904;
})();
if(inst_22617){
var statearr_22905_23118 = state_22900__$1;
(statearr_22905_23118[(1)] = (66));

} else {
var statearr_22906_23119 = state_22900__$1;
(statearr_22906_23119[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (70))){
var inst_22616 = (state_22900[(7)]);
var inst_22627 = cljs.core.count(inst_22616);
var inst_22628 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22627);
var state_22900__$1 = state_22900;
var statearr_22907_23120 = state_22900__$1;
(statearr_22907_23120[(2)] = inst_22628);

(statearr_22907_23120[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (62))){
var inst_22606 = (state_22900[(8)]);
var inst_22609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22610 = fluree.db.flake.o(inst_22606);
var inst_22611 = [inst_22610];
var inst_22612 = (new cljs.core.PersistentVector(null,1,(5),inst_22609,inst_22611,null));
var inst_22613 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22612);
var state_22900__$1 = state_22900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22900__$1,(65),inst_22613);
} else {
if((state_val_22901 === (74))){
var inst_22600 = (state_22900[(9)]);
var state_22900__$1 = state_22900;
var statearr_22908_23121 = state_22900__$1;
(statearr_22908_23121[(2)] = inst_22600);

(statearr_22908_23121[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (110))){
var inst_22785 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22786 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22785);
var inst_22787 = inst_22786 === true;
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22787)){
var statearr_22909_23122 = state_22900__$1;
(statearr_22909_23122[(1)] = (113));

} else {
var statearr_22910_23123 = state_22900__$1;
(statearr_22910_23123[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (130))){
var inst_22895 = (state_22900[(2)]);
var _ = (function (){var statearr_22911 = state_22900;
(statearr_22911[(4)] = cljs.core.rest((state_22900[(4)])));

return statearr_22911;
})();
var state_22900__$1 = state_22900;
var statearr_22912_23124 = state_22900__$1;
(statearr_22912_23124[(2)] = inst_22895);

(statearr_22912_23124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (128))){
var inst_22870 = (state_22900[(10)]);
var inst_22873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22874 = [acc,inst_22870];
var inst_22875 = (new cljs.core.PersistentVector(null,2,(5),inst_22873,inst_22874,null));
var state_22900__$1 = state_22900;
var statearr_22913_23125 = state_22900__$1;
(statearr_22913_23125[(2)] = inst_22875);

(statearr_22913_23125[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (7))){
var inst_22473 = (state_22900[(11)]);
var state_22900__$1 = state_22900;
var statearr_22914_23126 = state_22900__$1;
(statearr_22914_23126[(2)] = inst_22473);

(statearr_22914_23126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (59))){
var inst_22864 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22915_23127 = state_22900__$1;
(statearr_22915_23127[(2)] = inst_22864);

(statearr_22915_23127[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (86))){
var inst_22694 = (state_22900[(12)]);
var inst_22694__$1 = (state_22900[(2)]);
var state_22900__$1 = (function (){var statearr_22916 = state_22900;
(statearr_22916[(12)] = inst_22694__$1);

return statearr_22916;
})();
if(cljs.core.truth_(inst_22694__$1)){
var statearr_22917_23128 = state_22900__$1;
(statearr_22917_23128[(1)] = (88));

} else {
var statearr_22918_23129 = state_22900__$1;
(statearr_22918_23129[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (20))){
var inst_22514 = (state_22900[(13)]);
var inst_22515 = (state_22900[(14)]);
var inst_22502 = (state_22900[(15)]);
var inst_22513 = (state_22900[(2)]);
var inst_22514__$1 = cljs.core.__destructure_map(inst_22502);
var inst_22515__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22514__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22514__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22514__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22514__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22519 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22514__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22514__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22900__$1 = (function (){var statearr_22919 = state_22900;
(statearr_22919[(16)] = inst_22517);

(statearr_22919[(13)] = inst_22514__$1);

(statearr_22919[(17)] = inst_22519);

(statearr_22919[(14)] = inst_22515__$1);

(statearr_22919[(18)] = inst_22516);

(statearr_22919[(19)] = inst_22518);

(statearr_22919[(20)] = inst_22513);

(statearr_22919[(21)] = inst_22520);

return statearr_22919;
})();
if(cljs.core.truth_(inst_22515__$1)){
var statearr_22920_23130 = state_22900__$1;
(statearr_22920_23130[(1)] = (24));

} else {
var statearr_22921_23131 = state_22900__$1;
(statearr_22921_23131[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (72))){
var inst_22625 = (state_22900[(22)]);
var inst_22631 = (state_22900[(2)]);
var inst_22632 = cljs.core.seq(inst_22625);
var state_22900__$1 = (function (){var statearr_22922 = state_22900;
(statearr_22922[(23)] = inst_22631);

return statearr_22922;
})();
if(inst_22632){
var statearr_22923_23132 = state_22900__$1;
(statearr_22923_23132[(1)] = (73));

} else {
var statearr_22924_23133 = state_22900__$1;
(statearr_22924_23133[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (58))){
var inst_22502 = (state_22900[(15)]);
var inst_22647 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22502);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22647)){
var statearr_22925_23134 = state_22900__$1;
(statearr_22925_23134[(1)] = (76));

} else {
var statearr_22926_23135 = state_22900__$1;
(statearr_22926_23135[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (60))){
var inst_22599 = (state_22900[(24)]);
var inst_22606 = (state_22900[(8)]);
var inst_22605 = cljs.core.seq(inst_22599);
var inst_22606__$1 = cljs.core.first(inst_22605);
var inst_22607 = cljs.core.next(inst_22605);
var state_22900__$1 = (function (){var statearr_22927 = state_22900;
(statearr_22927[(25)] = inst_22607);

(statearr_22927[(8)] = inst_22606__$1);

return statearr_22927;
})();
if(cljs.core.truth_(inst_22606__$1)){
var statearr_22928_23136 = state_22900__$1;
(statearr_22928_23136[(1)] = (62));

} else {
var statearr_22929_23137 = state_22900__$1;
(statearr_22929_23137[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (27))){
var inst_22523 = (state_22900[(26)]);
var inst_22519 = (state_22900[(17)]);
var inst_22523__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22519);
var state_22900__$1 = (function (){var statearr_22930 = state_22900;
(statearr_22930[(26)] = inst_22523__$1);

return statearr_22930;
})();
if(inst_22523__$1){
var statearr_22931_23138 = state_22900__$1;
(statearr_22931_23138[(1)] = (30));

} else {
var statearr_22932_23139 = state_22900__$1;
(statearr_22932_23139[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (1))){
var state_22900__$1 = state_22900;
var statearr_22933_23140 = state_22900__$1;
(statearr_22933_23140[(2)] = null);

(statearr_22933_23140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (69))){
var inst_22621 = (state_22900[(2)]);
var inst_22622 = fluree.db.util.async.throw_err(inst_22621);
var state_22900__$1 = state_22900;
var statearr_22934_23141 = state_22900__$1;
(statearr_22934_23141[(2)] = inst_22622);

(statearr_22934_23141[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (101))){
var inst_22778 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22935_23142 = state_22900__$1;
(statearr_22935_23142[(2)] = inst_22778);

(statearr_22935_23142[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (24))){
var inst_22519 = (state_22900[(17)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22519)){
var statearr_22936_23143 = state_22900__$1;
(statearr_22936_23143[(1)] = (27));

} else {
var statearr_22937_23144 = state_22900__$1;
(statearr_22937_23144[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (102))){
var inst_22750 = (state_22900[(27)]);
var inst_22749 = (state_22900[(2)]);
var inst_22750__$1 = fluree.db.util.async.throw_err(inst_22749);
var inst_22751 = cljs.core.empty_QMARK_(inst_22750__$1);
var state_22900__$1 = (function (){var statearr_22938 = state_22900;
(statearr_22938[(27)] = inst_22750__$1);

return statearr_22938;
})();
if(inst_22751){
var statearr_22939_23145 = state_22900__$1;
(statearr_22939_23145[(1)] = (103));

} else {
var statearr_22940_23146 = state_22900__$1;
(statearr_22940_23146[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (135))){
var state_22900__$1 = state_22900;
var statearr_22941_23147 = state_22900__$1;
(statearr_22941_23147[(2)] = null);

(statearr_22941_23147[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (55))){
var inst_22502 = (state_22900[(15)]);
var inst_22575 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22502);
var state_22900__$1 = state_22900;
var statearr_22942_23148 = state_22900__$1;
(statearr_22942_23148[(2)] = inst_22575);

(statearr_22942_23148[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (85))){
var inst_22669 = (state_22900[(28)]);
var inst_22502 = (state_22900[(15)]);
var inst_22681 = fluree.db.flake.o(inst_22669);
var inst_22682 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22502);
var inst_22683 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22681,inst_22682);
var state_22900__$1 = state_22900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22900__$1,(87),inst_22683);
} else {
if((state_val_22901 === (39))){
var inst_22550 = (state_22900[(29)]);
var inst_22518 = (state_22900[(19)]);
var inst_22550__$1 = cljs.core.not(inst_22518);
var state_22900__$1 = (function (){var statearr_22943 = state_22900;
(statearr_22943[(29)] = inst_22550__$1);

return statearr_22943;
})();
if(inst_22550__$1){
var statearr_22944_23149 = state_22900__$1;
(statearr_22944_23149[(1)] = (42));

} else {
var statearr_22945_23150 = state_22900__$1;
(statearr_22945_23150[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (88))){
var inst_22694 = (state_22900[(12)]);
var inst_22663 = (state_22900[(30)]);
var inst_22696 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22663,inst_22694);
var state_22900__$1 = state_22900;
var statearr_22946_23151 = state_22900__$1;
(statearr_22946_23151[(2)] = inst_22696);

(statearr_22946_23151[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (46))){
var inst_22517 = (state_22900[(16)]);
var state_22900__$1 = state_22900;
var statearr_22947_23152 = state_22900__$1;
(statearr_22947_23152[(2)] = inst_22517);

(statearr_22947_23152[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (4))){
var inst_22462 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22948_23153 = state_22900__$1;
(statearr_22948_23153[(2)] = inst_22462);

(statearr_22948_23153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (77))){
var inst_22709 = (state_22900[(31)]);
var inst_22709__$1 = componentFollow_QMARK_;
var state_22900__$1 = (function (){var statearr_22949 = state_22900;
(statearr_22949[(31)] = inst_22709__$1);

return statearr_22949;
})();
if(cljs.core.truth_(inst_22709__$1)){
var statearr_22950_23154 = state_22900__$1;
(statearr_22950_23154[(1)] = (91));

} else {
var statearr_22951_23155 = state_22900__$1;
(statearr_22951_23155[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (106))){
var inst_22730 = (state_22900[(32)]);
var inst_22764 = (state_22900[(2)]);
var inst_22765 = fluree.db.util.async.throw_err(inst_22764);
var inst_22766 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22730,inst_22765);
var state_22900__$1 = state_22900;
var statearr_22952_23156 = state_22900__$1;
(statearr_22952_23156[(2)] = inst_22766);

(statearr_22952_23156[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (119))){
var inst_22808 = (state_22900[(33)]);
var inst_22838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22839 = [inst_22808,offset_map];
var inst_22840 = (new cljs.core.PersistentVector(null,2,(5),inst_22838,inst_22839,null));
var state_22900__$1 = state_22900;
var statearr_22953_23157 = state_22900__$1;
(statearr_22953_23157[(2)] = inst_22840);

(statearr_22953_23157[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (95))){
var inst_22516 = (state_22900[(18)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22516)){
var statearr_22954_23158 = state_22900__$1;
(statearr_22954_23158[(1)] = (110));

} else {
var statearr_22955_23159 = state_22900__$1;
(statearr_22955_23159[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (54))){
var inst_22572 = (state_22900[(34)]);
var state_22900__$1 = state_22900;
var statearr_22956_23160 = state_22900__$1;
(statearr_22956_23160[(2)] = inst_22572);

(statearr_22956_23160[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (92))){
var inst_22709 = (state_22900[(31)]);
var state_22900__$1 = state_22900;
var statearr_22957_23161 = state_22900__$1;
(statearr_22957_23161[(2)] = inst_22709);

(statearr_22957_23161[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (104))){
var inst_22750 = (state_22900[(27)]);
var inst_22472 = (state_22900[(35)]);
var inst_22759 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22760 = [true,inst_22472];
var inst_22761 = cljs.core.PersistentHashMap.fromArrays(inst_22759,inst_22760);
var inst_22762 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22761,inst_22750) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22761,inst_22750));
var state_22900__$1 = state_22900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22900__$1,(106),inst_22762);
} else {
if((state_val_22901 === (15))){
var inst_22495 = (state_22900[(36)]);
var inst_22472 = (state_22900[(35)]);
var inst_22499 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22495,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22472);
var state_22900__$1 = state_22900;
var statearr_22958_23162 = state_22900__$1;
(statearr_22958_23162[(2)] = inst_22499);

(statearr_22958_23162[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (48))){
var inst_22566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22567 = [null,offset_map];
var inst_22568 = (new cljs.core.PersistentVector(null,2,(5),inst_22566,inst_22567,null));
var state_22900__$1 = state_22900;
var statearr_22959_23163 = state_22900__$1;
(statearr_22959_23163[(2)] = inst_22568);

(statearr_22959_23163[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (50))){
var inst_22866 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22960_23164 = state_22900__$1;
(statearr_22960_23164[(2)] = inst_22866);

(statearr_22960_23164[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (116))){
var inst_22807 = (state_22900[(37)]);
var inst_22814 = (state_22900[(38)]);
var inst_22813 = cljs.core.seq(inst_22807);
var inst_22814__$1 = cljs.core.first(inst_22813);
var inst_22815 = cljs.core.next(inst_22813);
var state_22900__$1 = (function (){var statearr_22961 = state_22900;
(statearr_22961[(39)] = inst_22815);

(statearr_22961[(38)] = inst_22814__$1);

return statearr_22961;
})();
if(cljs.core.truth_(inst_22814__$1)){
var statearr_22962_23165 = state_22900__$1;
(statearr_22962_23165[(1)] = (118));

} else {
var statearr_22963_23166 = state_22900__$1;
(statearr_22963_23166[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (75))){
var inst_22607 = (state_22900[(25)]);
var inst_22637 = (state_22900[(2)]);
var inst_22599 = inst_22607;
var inst_22600 = inst_22637;
var state_22900__$1 = (function (){var statearr_22964 = state_22900;
(statearr_22964[(24)] = inst_22599);

(statearr_22964[(9)] = inst_22600);

return statearr_22964;
})();
var statearr_22965_23167 = state_22900__$1;
(statearr_22965_23167[(2)] = null);

(statearr_22965_23167[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (99))){
var inst_22736 = (state_22900[(40)]);
var inst_22502 = (state_22900[(15)]);
var inst_22739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22740 = fluree.db.flake.o(inst_22736);
var inst_22741 = [inst_22740];
var inst_22742 = (new cljs.core.PersistentVector(null,1,(5),inst_22739,inst_22741,null));
var inst_22743 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22744 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22502);
var inst_22745 = [inst_22744];
var inst_22746 = cljs.core.PersistentHashMap.fromArrays(inst_22743,inst_22745);
var inst_22747 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22742,inst_22746);
var state_22900__$1 = state_22900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22900__$1,(102),inst_22747);
} else {
if((state_val_22901 === (21))){
var inst_22506 = (state_22900[(41)]);
var state_22900__$1 = state_22900;
var statearr_22966_23168 = state_22900__$1;
(statearr_22966_23168[(2)] = inst_22506);

(statearr_22966_23168[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (31))){
var inst_22523 = (state_22900[(26)]);
var state_22900__$1 = state_22900;
var statearr_22967_23169 = state_22900__$1;
(statearr_22967_23169[(2)] = inst_22523);

(statearr_22967_23169[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (113))){
var inst_22517 = (state_22900[(16)]);
var inst_22514 = (state_22900[(13)]);
var inst_22519 = (state_22900[(17)]);
var inst_22515 = (state_22900[(14)]);
var inst_22516 = (state_22900[(18)]);
var inst_22518 = (state_22900[(19)]);
var inst_22487 = (state_22900[(42)]);
var inst_22513 = (state_22900[(20)]);
var inst_22502 = (state_22900[(15)]);
var inst_22520 = (state_22900[(21)]);
var inst_22472 = (state_22900[(35)]);
var inst_22789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22790 = (function (){var map__22468 = inst_22514;
var p = inst_22520;
var pred_spec__$1 = inst_22487;
var orderBy = inst_22518;
var multi_QMARK_ = inst_22515;
var limit = inst_22517;
var offset = inst_22519;
var k = inst_22513;
var compact_QMARK_ = inst_22472;
var pred_spec_SINGLEQUOTE_ = inst_22502;
var ref_QMARK_ = inst_22516;
return (function (p1__22458_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o(p1__22458_SHARP_)]);
});
})();
var inst_22791 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22790,flakes);
var inst_22792 = [inst_22791,offset_map];
var inst_22793 = (new cljs.core.PersistentVector(null,2,(5),inst_22789,inst_22792,null));
var state_22900__$1 = state_22900;
var statearr_22968_23170 = state_22900__$1;
(statearr_22968_23170[(2)] = inst_22793);

(statearr_22968_23170[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (32))){
var inst_22529 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22969_23171 = state_22900__$1;
(statearr_22969_23171[(2)] = inst_22529);

(statearr_22969_23171[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (136))){
var inst_22891 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22970_23172 = state_22900__$1;
(statearr_22970_23172[(2)] = inst_22891);

(statearr_22970_23172[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (40))){
var inst_22515 = (state_22900[(14)]);
var state_22900__$1 = state_22900;
var statearr_22971_23173 = state_22900__$1;
(statearr_22971_23173[(2)] = inst_22515);

(statearr_22971_23173[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (129))){
var inst_22515 = (state_22900[(14)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22515)){
var statearr_22972_23174 = state_22900__$1;
(statearr_22972_23174[(1)] = (131));

} else {
var statearr_22973_23175 = state_22900__$1;
(statearr_22973_23175[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (91))){
var inst_22502 = (state_22900[(15)]);
var inst_22711 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22502);
var state_22900__$1 = state_22900;
var statearr_22974_23176 = state_22900__$1;
(statearr_22974_23176[(2)] = inst_22711);

(statearr_22974_23176[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (117))){
var inst_22844 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22975_23177 = state_22900__$1;
(statearr_22975_23177[(2)] = inst_22844);

(statearr_22975_23177[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (108))){
var state_22900__$1 = state_22900;
var statearr_22976_23178 = state_22900__$1;
(statearr_22976_23178[(2)] = null);

(statearr_22976_23178[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (56))){
var inst_22577 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22977_23179 = state_22900__$1;
(statearr_22977_23179[(2)] = inst_22577);

(statearr_22977_23179[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (33))){
var inst_22520 = (state_22900[(21)]);
var inst_22537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22520);
var state_22900__$1 = (function (){var statearr_22978 = state_22900;
(statearr_22978[(43)] = inst_22537);

return statearr_22978;
})();
if(cljs.core.truth_(inst_22538)){
var statearr_22979_23180 = state_22900__$1;
(statearr_22979_23180[(1)] = (36));

} else {
var statearr_22980_23181 = state_22900__$1;
(statearr_22980_23181[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (13))){
var inst_22487 = (state_22900[(42)]);
var state_22900__$1 = state_22900;
var statearr_22981_23182 = state_22900__$1;
(statearr_22981_23182[(2)] = inst_22487);

(statearr_22981_23182[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (22))){
var inst_22502 = (state_22900[(15)]);
var inst_22509 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22502);
var state_22900__$1 = state_22900;
var statearr_22982_23183 = state_22900__$1;
(statearr_22982_23183[(2)] = inst_22509);

(statearr_22982_23183[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (90))){
var inst_22670 = (state_22900[(44)]);
var inst_22699 = (state_22900[(2)]);
var inst_22662 = inst_22670;
var inst_22663 = inst_22699;
var state_22900__$1 = (function (){var statearr_22983 = state_22900;
(statearr_22983[(30)] = inst_22663);

(statearr_22983[(45)] = inst_22662);

return statearr_22983;
})();
var statearr_22984_23184 = state_22900__$1;
(statearr_22984_23184[(2)] = null);

(statearr_22984_23184[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (109))){
var inst_22768 = (state_22900[(46)]);
var inst_22737 = (state_22900[(47)]);
var inst_22774 = (state_22900[(2)]);
var inst_22729 = inst_22737;
var inst_22730 = inst_22768;
var state_22900__$1 = (function (){var statearr_22985 = state_22900;
(statearr_22985[(48)] = inst_22729);

(statearr_22985[(32)] = inst_22730);

(statearr_22985[(49)] = inst_22774);

return statearr_22985;
})();
var statearr_22986_23185 = state_22900__$1;
(statearr_22986_23185[(2)] = null);

(statearr_22986_23185[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (36))){
var inst_22520 = (state_22900[(21)]);
var inst_22540 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22520,cljs.core.dec);
var state_22900__$1 = state_22900;
var statearr_22987_23186 = state_22900__$1;
(statearr_22987_23186[(2)] = inst_22540);

(statearr_22987_23186[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (41))){
var inst_22564 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22564)){
var statearr_22988_23187 = state_22900__$1;
(statearr_22988_23187[(1)] = (48));

} else {
var statearr_22989_23188 = state_22900__$1;
(statearr_22989_23188[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (118))){
var inst_22814 = (state_22900[(38)]);
var inst_22817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22818 = fluree.db.flake.o(inst_22814);
var inst_22819 = [inst_22818];
var inst_22820 = (new cljs.core.PersistentVector(null,1,(5),inst_22817,inst_22819,null));
var inst_22821 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22820);
var state_22900__$1 = state_22900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22900__$1,(121),inst_22821);
} else {
if((state_val_22901 === (89))){
var inst_22663 = (state_22900[(30)]);
var state_22900__$1 = state_22900;
var statearr_22990_23189 = state_22900__$1;
(statearr_22990_23189[(2)] = inst_22663);

(statearr_22990_23189[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (100))){
var inst_22730 = (state_22900[(32)]);
var state_22900__$1 = state_22900;
var statearr_22991_23190 = state_22900__$1;
(statearr_22991_23190[(2)] = inst_22730);

(statearr_22991_23190[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (131))){
var inst_22870 = (state_22900[(10)]);
var inst_22869 = (state_22900[(50)]);
var inst_22513 = (state_22900[(20)]);
var inst_22878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22879 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22513,inst_22869);
var inst_22880 = [inst_22879,inst_22870];
var inst_22881 = (new cljs.core.PersistentVector(null,2,(5),inst_22878,inst_22880,null));
var state_22900__$1 = state_22900;
var statearr_22992_23191 = state_22900__$1;
(statearr_22992_23191[(2)] = inst_22881);

(statearr_22992_23191[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (122))){
var inst_22808 = (state_22900[(33)]);
var inst_22815 = (state_22900[(39)]);
var inst_22814 = (state_22900[(38)]);
var inst_22827 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22828 = fluree.db.flake.o(inst_22814);
var inst_22829 = [inst_22828];
var inst_22830 = cljs.core.PersistentHashMap.fromArrays(inst_22827,inst_22829);
var inst_22831 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22808,inst_22830);
var inst_22807 = inst_22815;
var inst_22808__$1 = inst_22831;
var state_22900__$1 = (function (){var statearr_22993 = state_22900;
(statearr_22993[(33)] = inst_22808__$1);

(statearr_22993[(37)] = inst_22807);

return statearr_22993;
})();
var statearr_22994_23192 = state_22900__$1;
(statearr_22994_23192[(2)] = null);

(statearr_22994_23192[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (43))){
var inst_22550 = (state_22900[(29)]);
var state_22900__$1 = state_22900;
var statearr_22995_23193 = state_22900__$1;
(statearr_22995_23193[(2)] = inst_22550);

(statearr_22995_23193[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (61))){
var inst_22586 = (state_22900[(51)]);
var inst_22643 = (state_22900[(2)]);
var inst_22644 = [inst_22643,offset_map];
var inst_22645 = (new cljs.core.PersistentVector(null,2,(5),inst_22586,inst_22644,null));
var state_22900__$1 = state_22900;
var statearr_22996_23194 = state_22900__$1;
(statearr_22996_23194[(2)] = inst_22645);

(statearr_22996_23194[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (29))){
var inst_22532 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22997_23195 = state_22900__$1;
(statearr_22997_23195[(2)] = inst_22532);

(statearr_22997_23195[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (44))){
var inst_22561 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_22998_23196 = state_22900__$1;
(statearr_22998_23196[(2)] = inst_22561);

(statearr_22998_23196[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (93))){
var inst_22714 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22714)){
var statearr_22999_23197 = state_22900__$1;
(statearr_22999_23197[(1)] = (94));

} else {
var statearr_23000_23198 = state_22900__$1;
(statearr_23000_23198[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (6))){
var inst_22475 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22476 = (inst_22475 == null);
var state_22900__$1 = state_22900;
var statearr_23001_23199 = state_22900__$1;
(statearr_23001_23199[(2)] = inst_22476);

(statearr_23001_23199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (111))){
var state_22900__$1 = state_22900;
var statearr_23002_23200 = state_22900__$1;
(statearr_23002_23200[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (28))){
var inst_22519 = (state_22900[(17)]);
var state_22900__$1 = state_22900;
var statearr_23004_23201 = state_22900__$1;
(statearr_23004_23201[(2)] = inst_22519);

(statearr_23004_23201[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (134))){
var inst_22870 = (state_22900[(10)]);
var inst_22869 = (state_22900[(50)]);
var inst_22513 = (state_22900[(20)]);
var inst_22884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22885 = cljs.core.first(inst_22869);
var inst_22886 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22513,inst_22885);
var inst_22887 = [inst_22886,inst_22870];
var inst_22888 = (new cljs.core.PersistentVector(null,2,(5),inst_22884,inst_22887,null));
var state_22900__$1 = state_22900;
var statearr_23005_23202 = state_22900__$1;
(statearr_23005_23202[(2)] = inst_22888);

(statearr_23005_23202[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (64))){
var inst_22641 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23006_23203 = state_22900__$1;
(statearr_23006_23203[(2)] = inst_22641);

(statearr_23006_23203[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (103))){
var inst_22730 = (state_22900[(32)]);
var inst_22736 = (state_22900[(40)]);
var inst_22753 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22754 = fluree.db.flake.o(inst_22736);
var inst_22755 = [inst_22754];
var inst_22756 = cljs.core.PersistentHashMap.fromArrays(inst_22753,inst_22755);
var inst_22757 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22730,inst_22756);
var state_22900__$1 = state_22900;
var statearr_23007_23204 = state_22900__$1;
(statearr_23007_23204[(2)] = inst_22757);

(statearr_23007_23204[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (51))){
var inst_22572 = (state_22900[(34)]);
var inst_22502 = (state_22900[(15)]);
var inst_22572__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22502);
var state_22900__$1 = (function (){var statearr_23008 = state_22900;
(statearr_23008[(34)] = inst_22572__$1);

return statearr_23008;
})();
if(cljs.core.truth_(inst_22572__$1)){
var statearr_23009_23205 = state_22900__$1;
(statearr_23009_23205[(1)] = (54));

} else {
var statearr_23010_23206 = state_22900__$1;
(statearr_23010_23206[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (25))){
var inst_22515 = (state_22900[(14)]);
var state_22900__$1 = state_22900;
var statearr_23011_23207 = state_22900__$1;
(statearr_23011_23207[(2)] = inst_22515);

(statearr_23011_23207[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (34))){
var inst_22515 = (state_22900[(14)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22515)){
var statearr_23012_23208 = state_22900__$1;
(statearr_23012_23208[(1)] = (39));

} else {
var statearr_23013_23209 = state_22900__$1;
(statearr_23013_23209[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (125))){
var inst_22517 = (state_22900[(16)]);
var inst_22514 = (state_22900[(13)]);
var inst_22519 = (state_22900[(17)]);
var inst_22515 = (state_22900[(14)]);
var inst_22516 = (state_22900[(18)]);
var inst_22518 = (state_22900[(19)]);
var inst_22487 = (state_22900[(42)]);
var inst_22513 = (state_22900[(20)]);
var inst_22502 = (state_22900[(15)]);
var inst_22520 = (state_22900[(21)]);
var inst_22472 = (state_22900[(35)]);
var inst_22849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22850 = (function (){var map__22468 = inst_22514;
var p = inst_22520;
var pred_spec__$1 = inst_22487;
var orderBy = inst_22518;
var multi_QMARK_ = inst_22515;
var limit = inst_22517;
var offset = inst_22519;
var k = inst_22513;
var compact_QMARK_ = inst_22472;
var pred_spec_SINGLEQUOTE_ = inst_22502;
var ref_QMARK_ = inst_22516;
return (function (p1__22459_SHARP_){
return fluree.db.flake.o(p1__22459_SHARP_);
});
})();
var inst_22851 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22850,flakes);
var inst_22852 = [inst_22851,offset_map];
var inst_22853 = (new cljs.core.PersistentVector(null,2,(5),inst_22849,inst_22852,null));
var state_22900__$1 = state_22900;
var statearr_23014_23210 = state_22900__$1;
(statearr_23014_23210[(2)] = inst_22853);

(statearr_23014_23210[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (17))){
var inst_22502 = (state_22900[(15)]);
var inst_22503 = (state_22900[(52)]);
var inst_22502__$1 = (state_22900[(2)]);
var inst_22503__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22502__$1);
var state_22900__$1 = (function (){var statearr_23015 = state_22900;
(statearr_23015[(15)] = inst_22502__$1);

(statearr_23015[(52)] = inst_22503__$1);

return statearr_23015;
})();
if(cljs.core.truth_(inst_22503__$1)){
var statearr_23016_23211 = state_22900__$1;
(statearr_23016_23211[(1)] = (18));

} else {
var statearr_23017_23212 = state_22900__$1;
(statearr_23017_23212[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (3))){
var inst_22898 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22900__$1,inst_22898);
} else {
if((state_val_22901 === (12))){
var inst_22487 = (state_22900[(42)]);
var inst_22492 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22487,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22900__$1 = state_22900;
var statearr_23018_23213 = state_22900__$1;
(statearr_23018_23213[(2)] = inst_22492);

(statearr_23018_23213[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (2))){
var inst_22473 = (state_22900[(11)]);
var _ = (function (){var statearr_23019 = state_22900;
(statearr_23019[(4)] = cljs.core.cons((5),(state_22900[(4)])));

return statearr_23019;
})();
var inst_22472 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22473__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22900__$1 = (function (){var statearr_23020 = state_22900;
(statearr_23020[(11)] = inst_22473__$1);

(statearr_23020[(35)] = inst_22472);

return statearr_23020;
})();
if(cljs.core.truth_(inst_22473__$1)){
var statearr_23021_23214 = state_22900__$1;
(statearr_23021_23214[(1)] = (6));

} else {
var statearr_23022_23215 = state_22900__$1;
(statearr_23022_23215[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (66))){
var inst_22616 = (state_22900[(7)]);
var inst_22585 = (state_22900[(53)]);
var inst_22619 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22585,inst_22616) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22585,inst_22616));
var state_22900__$1 = state_22900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22900__$1,(69),inst_22619);
} else {
if((state_val_22901 === (107))){
var inst_22750 = (state_22900[(27)]);
var inst_22770 = cljs.core.count(inst_22750);
var inst_22771 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22770);
var state_22900__$1 = state_22900;
var statearr_23023_23216 = state_22900__$1;
(statearr_23023_23216[(2)] = inst_22771);

(statearr_23023_23216[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (23))){
var inst_22511 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23024_23217 = state_22900__$1;
(statearr_23024_23217[(2)] = inst_22511);

(statearr_23024_23217[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (47))){
var inst_22558 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23025_23218 = state_22900__$1;
(statearr_23025_23218[(2)] = inst_22558);

(statearr_23025_23218[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (35))){
var inst_22869 = (state_22900[(50)]);
var inst_22868 = (state_22900[(2)]);
var inst_22869__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22868,(0),null);
var inst_22870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22868,(1),null);
var inst_22871 = cljs.core.empty_QMARK_(inst_22869__$1);
var state_22900__$1 = (function (){var statearr_23026 = state_22900;
(statearr_23026[(10)] = inst_22870);

(statearr_23026[(50)] = inst_22869__$1);

return statearr_23026;
})();
if(inst_22871){
var statearr_23027_23219 = state_22900__$1;
(statearr_23027_23219[(1)] = (128));

} else {
var statearr_23028_23220 = state_22900__$1;
(statearr_23028_23220[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (127))){
var inst_22856 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23029_23221 = state_22900__$1;
(statearr_23029_23221[(2)] = inst_22856);

(statearr_23029_23221[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (82))){
var inst_22663 = (state_22900[(30)]);
var state_22900__$1 = state_22900;
var statearr_23030_23222 = state_22900__$1;
(statearr_23030_23222[(2)] = inst_22663);

(statearr_23030_23222[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (76))){
var inst_22649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22657 = flakes;
var inst_22658 = cljs.core.seq(inst_22657);
var inst_22659 = cljs.core.first(inst_22658);
var inst_22660 = cljs.core.next(inst_22658);
var inst_22661 = cljs.core.PersistentVector.EMPTY;
var inst_22662 = inst_22657;
var inst_22663 = inst_22661;
var state_22900__$1 = (function (){var statearr_23031 = state_22900;
(statearr_23031[(54)] = inst_22659);

(statearr_23031[(55)] = inst_22649);

(statearr_23031[(56)] = inst_22660);

(statearr_23031[(30)] = inst_22663);

(statearr_23031[(45)] = inst_22662);

return statearr_23031;
})();
var statearr_23032_23223 = state_22900__$1;
(statearr_23032_23223[(2)] = null);

(statearr_23032_23223[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (97))){
var inst_22729 = (state_22900[(48)]);
var inst_22736 = (state_22900[(40)]);
var inst_22735 = cljs.core.seq(inst_22729);
var inst_22736__$1 = cljs.core.first(inst_22735);
var inst_22737 = cljs.core.next(inst_22735);
var state_22900__$1 = (function (){var statearr_23033 = state_22900;
(statearr_23033[(40)] = inst_22736__$1);

(statearr_23033[(47)] = inst_22737);

return statearr_23033;
})();
if(cljs.core.truth_(inst_22736__$1)){
var statearr_23034_23224 = state_22900__$1;
(statearr_23034_23224[(1)] = (99));

} else {
var statearr_23035_23225 = state_22900__$1;
(statearr_23035_23225[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (19))){
var inst_22506 = (state_22900[(41)]);
var inst_22502 = (state_22900[(15)]);
var inst_22506__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22502);
var state_22900__$1 = (function (){var statearr_23036 = state_22900;
(statearr_23036[(41)] = inst_22506__$1);

return statearr_23036;
})();
if(cljs.core.truth_(inst_22506__$1)){
var statearr_23037_23226 = state_22900__$1;
(statearr_23037_23226[(1)] = (21));

} else {
var statearr_23038_23227 = state_22900__$1;
(statearr_23038_23227[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (57))){
var inst_22502 = (state_22900[(15)]);
var inst_22582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22583 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22584 = (new cljs.core.PersistentVector(null,3,(5),inst_22582,inst_22583,null));
var inst_22585 = cljs.core.select_keys(inst_22502,inst_22584);
var inst_22586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22594 = flakes;
var inst_22595 = cljs.core.seq(inst_22594);
var inst_22596 = cljs.core.first(inst_22595);
var inst_22597 = cljs.core.next(inst_22595);
var inst_22598 = cljs.core.PersistentVector.EMPTY;
var inst_22599 = inst_22594;
var inst_22600 = inst_22598;
var state_22900__$1 = (function (){var statearr_23039 = state_22900;
(statearr_23039[(51)] = inst_22586);

(statearr_23039[(24)] = inst_22599);

(statearr_23039[(57)] = inst_22597);

(statearr_23039[(9)] = inst_22600);

(statearr_23039[(53)] = inst_22585);

(statearr_23039[(58)] = inst_22596);

return statearr_23039;
})();
var statearr_23040_23228 = state_22900__$1;
(statearr_23040_23228[(2)] = null);

(statearr_23040_23228[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (68))){
var inst_22625 = (state_22900[(2)]);
var state_22900__$1 = (function (){var statearr_23041 = state_22900;
(statearr_23041[(22)] = inst_22625);

return statearr_23041;
})();
if(cljs.core.truth_(fuel)){
var statearr_23042_23229 = state_22900__$1;
(statearr_23042_23229[(1)] = (70));

} else {
var statearr_23043_23230 = state_22900__$1;
(statearr_23043_23230[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (11))){
var inst_22487 = (state_22900[(42)]);
var inst_22487__$1 = (state_22900[(2)]);
var inst_22489 = cljs.core.contains_QMARK_(inst_22487__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22490 = (!(inst_22489));
var state_22900__$1 = (function (){var statearr_23044 = state_22900;
(statearr_23044[(42)] = inst_22487__$1);

return statearr_23044;
})();
if(inst_22490){
var statearr_23045_23231 = state_22900__$1;
(statearr_23045_23231[(1)] = (12));

} else {
var statearr_23046_23232 = state_22900__$1;
(statearr_23046_23232[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (115))){
var inst_22846 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23048_23233 = state_22900__$1;
(statearr_23048_23233[(2)] = inst_22846);

(statearr_23048_23233[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (9))){
var inst_22481 = cljs.core.first(flakes);
var inst_22482 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22481);
var inst_22483 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22484 = fluree.db.query.fql_resp.wildcard_pred_spec(db,cache,inst_22482,inst_22483);
var state_22900__$1 = state_22900;
var statearr_23049_23234 = state_22900__$1;
(statearr_23049_23234[(2)] = inst_22484);

(statearr_23049_23234[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (5))){
var _ = (function (){var statearr_23050 = state_22900;
(statearr_23050[(4)] = cljs.core.rest((state_22900[(4)])));

return statearr_23050;
})();
var state_22900__$1 = state_22900;
var ex23047 = (state_22900__$1[(2)]);
var statearr_23051_23235 = state_22900__$1;
(statearr_23051_23235[(5)] = ex23047);


if((ex23047 instanceof Error)){
var statearr_23052_23236 = state_22900__$1;
(statearr_23052_23236[(1)] = (4));

(statearr_23052_23236[(5)] = null);

} else {
throw ex23047;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (112))){
var inst_22858 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23053_23237 = state_22900__$1;
(statearr_23053_23237[(2)] = inst_22858);

(statearr_23053_23237[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (83))){
var inst_22703 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23054_23238 = state_22900__$1;
(statearr_23054_23238[(2)] = inst_22703);

(statearr_23054_23238[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (14))){
var inst_22487 = (state_22900[(42)]);
var inst_22495 = (state_22900[(2)]);
var inst_22496 = cljs.core.contains_QMARK_(inst_22487,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22497 = (!(inst_22496));
var state_22900__$1 = (function (){var statearr_23055 = state_22900;
(statearr_23055[(36)] = inst_22495);

return statearr_23055;
})();
if(inst_22497){
var statearr_23056_23239 = state_22900__$1;
(statearr_23056_23239[(1)] = (15));

} else {
var statearr_23057_23240 = state_22900__$1;
(statearr_23057_23240[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (45))){
var inst_22517 = (state_22900[(16)]);
var inst_22513 = (state_22900[(20)]);
var inst_22553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22513);
var inst_22554 = cljs.core.count(inst_22553);
var inst_22555 = (inst_22554 >= inst_22517);
var state_22900__$1 = state_22900;
var statearr_23058_23241 = state_22900__$1;
(statearr_23058_23241[(2)] = inst_22555);

(statearr_23058_23241[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (53))){
var inst_22580 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22580)){
var statearr_23059_23242 = state_22900__$1;
(statearr_23059_23242[(1)] = (57));

} else {
var statearr_23060_23243 = state_22900__$1;
(statearr_23060_23243[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (78))){
var inst_22862 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23061_23244 = state_22900__$1;
(statearr_23061_23244[(2)] = inst_22862);

(statearr_23061_23244[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (132))){
var state_22900__$1 = state_22900;
var statearr_23063_23245 = state_22900__$1;
(statearr_23063_23245[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (26))){
var inst_22535 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22535)){
var statearr_23065_23246 = state_22900__$1;
(statearr_23065_23246[(1)] = (33));

} else {
var statearr_23066_23247 = state_22900__$1;
(statearr_23066_23247[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (123))){
var inst_22808 = (state_22900[(33)]);
var inst_22815 = (state_22900[(39)]);
var tmp23062 = inst_22808;
var inst_22807 = inst_22815;
var inst_22808__$1 = tmp23062;
var state_22900__$1 = (function (){var statearr_23067 = state_22900;
(statearr_23067[(33)] = inst_22808__$1);

(statearr_23067[(37)] = inst_22807);

return statearr_23067;
})();
var statearr_23068_23248 = state_22900__$1;
(statearr_23068_23248[(2)] = null);

(statearr_23068_23248[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (16))){
var inst_22495 = (state_22900[(36)]);
var state_22900__$1 = state_22900;
var statearr_23069_23249 = state_22900__$1;
(statearr_23069_23249[(2)] = inst_22495);

(statearr_23069_23249[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (133))){
var inst_22893 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23070_23250 = state_22900__$1;
(statearr_23070_23250[(2)] = inst_22893);

(statearr_23070_23250[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (81))){
var inst_22678 = (state_22900[(59)]);
var inst_22669 = (state_22900[(28)]);
var inst_22502 = (state_22900[(15)]);
var inst_22672 = cljs.core.deref(cache);
var inst_22673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22674 = fluree.db.flake.o(inst_22669);
var inst_22675 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22502);
var inst_22676 = [inst_22674,inst_22675];
var inst_22677 = (new cljs.core.PersistentVector(null,2,(5),inst_22673,inst_22676,null));
var inst_22678__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22672,inst_22677);
var state_22900__$1 = (function (){var statearr_23071 = state_22900;
(statearr_23071[(59)] = inst_22678__$1);

return statearr_23071;
})();
if(cljs.core.truth_(inst_22678__$1)){
var statearr_23072_23251 = state_22900__$1;
(statearr_23072_23251[(1)] = (84));

} else {
var statearr_23073_23252 = state_22900__$1;
(statearr_23073_23252[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (120))){
var inst_22842 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23074_23253 = state_22900__$1;
(statearr_23074_23253[(2)] = inst_22842);

(statearr_23074_23253[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (79))){
var inst_22669 = (state_22900[(28)]);
var inst_22662 = (state_22900[(45)]);
var inst_22668 = cljs.core.seq(inst_22662);
var inst_22669__$1 = cljs.core.first(inst_22668);
var inst_22670 = cljs.core.next(inst_22668);
var state_22900__$1 = (function (){var statearr_23075 = state_22900;
(statearr_23075[(44)] = inst_22670);

(statearr_23075[(28)] = inst_22669__$1);

return statearr_23075;
})();
if(cljs.core.truth_(inst_22669__$1)){
var statearr_23076_23254 = state_22900__$1;
(statearr_23076_23254[(1)] = (81));

} else {
var statearr_23077_23255 = state_22900__$1;
(statearr_23077_23255[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (38))){
var inst_22537 = (state_22900[(43)]);
var inst_22545 = (state_22900[(2)]);
var inst_22546 = [null,inst_22545];
var inst_22547 = (new cljs.core.PersistentVector(null,2,(5),inst_22537,inst_22546,null));
var state_22900__$1 = state_22900;
var statearr_23078_23256 = state_22900__$1;
(statearr_23078_23256[(2)] = inst_22547);

(statearr_23078_23256[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (126))){
var state_22900__$1 = state_22900;
var statearr_23079_23257 = state_22900__$1;
(statearr_23079_23257[(2)] = null);

(statearr_23079_23257[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (98))){
var inst_22716 = (state_22900[(60)]);
var inst_22780 = (state_22900[(2)]);
var inst_22781 = [inst_22780,offset_map];
var inst_22782 = (new cljs.core.PersistentVector(null,2,(5),inst_22716,inst_22781,null));
var state_22900__$1 = state_22900;
var statearr_23080_23258 = state_22900__$1;
(statearr_23080_23258[(2)] = inst_22782);

(statearr_23080_23258[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (124))){
var inst_22836 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23081_23259 = state_22900__$1;
(statearr_23081_23259[(2)] = inst_22836);

(statearr_23081_23259[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (87))){
var inst_22669 = (state_22900[(28)]);
var inst_22502 = (state_22900[(15)]);
var inst_22685 = (state_22900[(2)]);
var inst_22686 = fluree.db.util.async.throw_err(inst_22685);
var inst_22687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22688 = fluree.db.flake.o(inst_22669);
var inst_22689 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22502);
var inst_22690 = [inst_22688,inst_22689];
var inst_22691 = (new cljs.core.PersistentVector(null,2,(5),inst_22687,inst_22690,null));
var inst_22692 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_22691,inst_22686);
var state_22900__$1 = (function (){var statearr_23082 = state_22900;
(statearr_23082[(61)] = inst_22692);

return statearr_23082;
})();
var statearr_23083_23260 = state_22900__$1;
(statearr_23083_23260[(2)] = inst_22686);

(statearr_23083_23260[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (30))){
var inst_22520 = (state_22900[(21)]);
var inst_22525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22520);
var inst_22526 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22525);
var state_22900__$1 = state_22900;
var statearr_23084_23261 = state_22900__$1;
(statearr_23084_23261[(2)] = inst_22526);

(statearr_23084_23261[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (73))){
var inst_22600 = (state_22900[(9)]);
var inst_22625 = (state_22900[(22)]);
var inst_22634 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22600,inst_22625);
var state_22900__$1 = state_22900;
var statearr_23085_23262 = state_22900__$1;
(statearr_23085_23262[(2)] = inst_22634);

(statearr_23085_23262[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (96))){
var inst_22860 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
var statearr_23086_23263 = state_22900__$1;
(statearr_23086_23263[(2)] = inst_22860);

(statearr_23086_23263[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (10))){
var state_22900__$1 = state_22900;
var statearr_23087_23264 = state_22900__$1;
(statearr_23087_23264[(2)] = pred_spec);

(statearr_23087_23264[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (18))){
var inst_22503 = (state_22900[(52)]);
var state_22900__$1 = state_22900;
var statearr_23088_23265 = state_22900__$1;
(statearr_23088_23265[(2)] = inst_22503);

(statearr_23088_23265[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (105))){
var inst_22768 = (state_22900[(2)]);
var state_22900__$1 = (function (){var statearr_23089 = state_22900;
(statearr_23089[(46)] = inst_22768);

return statearr_23089;
})();
if(cljs.core.truth_(fuel)){
var statearr_23090_23266 = state_22900__$1;
(statearr_23090_23266[(1)] = (107));

} else {
var statearr_23091_23267 = state_22900__$1;
(statearr_23091_23267[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (52))){
var inst_22570 = (state_22900[(62)]);
var state_22900__$1 = state_22900;
var statearr_23092_23268 = state_22900__$1;
(statearr_23092_23268[(2)] = inst_22570);

(statearr_23092_23268[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (114))){
var inst_22802 = flakes;
var inst_22803 = cljs.core.seq(inst_22802);
var inst_22804 = cljs.core.first(inst_22803);
var inst_22805 = cljs.core.next(inst_22803);
var inst_22806 = cljs.core.PersistentVector.EMPTY;
var inst_22807 = inst_22802;
var inst_22808 = inst_22806;
var state_22900__$1 = (function (){var statearr_23093 = state_22900;
(statearr_23093[(63)] = inst_22804);

(statearr_23093[(64)] = inst_22805);

(statearr_23093[(33)] = inst_22808);

(statearr_23093[(37)] = inst_22807);

return statearr_23093;
})();
var statearr_23094_23269 = state_22900__$1;
(statearr_23094_23269[(2)] = null);

(statearr_23094_23269[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (67))){
var state_22900__$1 = state_22900;
var statearr_23095_23270 = state_22900__$1;
(statearr_23095_23270[(2)] = null);

(statearr_23095_23270[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (71))){
var state_22900__$1 = state_22900;
var statearr_23096_23271 = state_22900__$1;
(statearr_23096_23271[(2)] = null);

(statearr_23096_23271[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (42))){
var inst_22517 = (state_22900[(16)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22517)){
var statearr_23097_23272 = state_22900__$1;
(statearr_23097_23272[(1)] = (45));

} else {
var statearr_23098_23273 = state_22900__$1;
(statearr_23098_23273[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (80))){
var inst_22649 = (state_22900[(55)]);
var inst_22705 = (state_22900[(2)]);
var inst_22706 = [inst_22705,offset_map];
var inst_22707 = (new cljs.core.PersistentVector(null,2,(5),inst_22649,inst_22706,null));
var state_22900__$1 = state_22900;
var statearr_23099_23274 = state_22900__$1;
(statearr_23099_23274[(2)] = inst_22707);

(statearr_23099_23274[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (37))){
var inst_22519 = (state_22900[(17)]);
var inst_22520 = (state_22900[(21)]);
var inst_22542 = (inst_22519 - (1));
var inst_22543 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22520,inst_22542);
var state_22900__$1 = state_22900;
var statearr_23100_23275 = state_22900__$1;
(statearr_23100_23275[(2)] = inst_22543);

(statearr_23100_23275[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (63))){
var inst_22600 = (state_22900[(9)]);
var state_22900__$1 = state_22900;
var statearr_23101_23276 = state_22900__$1;
(statearr_23101_23276[(2)] = inst_22600);

(statearr_23101_23276[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (94))){
var inst_22716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22724 = flakes;
var inst_22725 = cljs.core.seq(inst_22724);
var inst_22726 = cljs.core.first(inst_22725);
var inst_22727 = cljs.core.next(inst_22725);
var inst_22728 = cljs.core.PersistentVector.EMPTY;
var inst_22729 = inst_22724;
var inst_22730 = inst_22728;
var state_22900__$1 = (function (){var statearr_23102 = state_22900;
(statearr_23102[(65)] = inst_22726);

(statearr_23102[(60)] = inst_22716);

(statearr_23102[(48)] = inst_22729);

(statearr_23102[(32)] = inst_22730);

(statearr_23102[(66)] = inst_22727);

return statearr_23102;
})();
var statearr_23103_23277 = state_22900__$1;
(statearr_23103_23277[(2)] = null);

(statearr_23103_23277[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (8))){
var inst_22479 = (state_22900[(2)]);
var state_22900__$1 = state_22900;
if(cljs.core.truth_(inst_22479)){
var statearr_23104_23278 = state_22900__$1;
(statearr_23104_23278[(1)] = (9));

} else {
var statearr_23105_23279 = state_22900__$1;
(statearr_23105_23279[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (49))){
var inst_22570 = (state_22900[(62)]);
var inst_22570__$1 = cljs.core.not(recur_QMARK_);
var state_22900__$1 = (function (){var statearr_23106 = state_22900;
(statearr_23106[(62)] = inst_22570__$1);

return statearr_23106;
})();
if(inst_22570__$1){
var statearr_23107_23280 = state_22900__$1;
(statearr_23107_23280[(1)] = (51));

} else {
var statearr_23108_23281 = state_22900__$1;
(statearr_23108_23281[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22901 === (84))){
var inst_22678 = (state_22900[(59)]);
var state_22900__$1 = state_22900;
var statearr_23109_23282 = state_22900__$1;
(statearr_23109_23282[(2)] = inst_22678);

(statearr_23109_23282[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2727__auto____0 = (function (){
var statearr_23110 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23110[(0)] = fluree$db$query$fql_resp$state_machine__2727__auto__);

(statearr_23110[(1)] = (1));

return statearr_23110;
});
var fluree$db$query$fql_resp$state_machine__2727__auto____1 = (function (state_22900){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22900);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23111){var ex__2730__auto__ = e23111;
var statearr_23112_23283 = state_22900;
(statearr_23112_23283[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22900[(4)]))){
var statearr_23113_23284 = state_22900;
(statearr_23113_23284[(1)] = cljs.core.first((state_22900[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23285 = state_22900;
state_22900 = G__23285;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2727__auto__ = function(state_22900){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2727__auto____1.call(this,state_22900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2727__auto____0;
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2727__auto____1;
return fluree$db$query$fql_resp$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23114 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23114[(6)] = c__2749__auto__);

return statearr_23114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__23287 = res;
var G__23287__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__23286_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__23286_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__23287):G__23287);
var G__23287__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__23287__$1):G__23287__$1);
var G__23287__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__23287__$2):G__23287__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__23287__$3);
} else {
return G__23287__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23468){
var state_val_23469 = (state_23468[(1)]);
if((state_val_23469 === (7))){
var state_23468__$1 = state_23468;
var statearr_23470_23556 = state_23468__$1;
(statearr_23470_23556[(2)] = null);

(statearr_23470_23556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (20))){
var inst_23326 = cljs.core.PersistentHashMap.EMPTY;
var state_23468__$1 = state_23468;
var statearr_23471_23557 = state_23468__$1;
(statearr_23471_23557[(2)] = inst_23326);

(statearr_23471_23557[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (27))){
var inst_23308 = (state_23468[(7)]);
var inst_23328 = (state_23468[(8)]);
var inst_23314 = (state_23468[(9)]);
var inst_23344 = (state_23468[(10)]);
var inst_23447 = (state_23468[(2)]);
var inst_23448 = (function (){var top_level_subject = inst_23308;
var select_spec = inst_23314;
var base_acc = inst_23328;
var acc_PLUS_refs = inst_23344;
var result = inst_23447;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23449 = cljs.core.PersistentVector.EMPTY;
var inst_23450 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23314);
var inst_23451 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23450);
var inst_23452 = cljs.core.vals(inst_23451);
var inst_23453 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23314);
var inst_23454 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23453);
var inst_23455 = cljs.core.vals(inst_23454);
var inst_23456 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23452,inst_23455);
var inst_23457 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23448,inst_23449,inst_23456);
var inst_23459 = (function (){var top_level_subject = inst_23308;
var select_spec = inst_23314;
var base_acc = inst_23328;
var acc_PLUS_refs = inst_23344;
var result = inst_23447;
var sort_preds = inst_23457;
return (function (acc,p__23458){
var vec__23472 = p__23458;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23472,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23472,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23472,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23472,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23460 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23459,inst_23447,inst_23457);
var state_23468__$1 = state_23468;
var statearr_23475_23558 = state_23468__$1;
(statearr_23475_23558[(2)] = inst_23460);

(statearr_23475_23558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (1))){
var state_23468__$1 = state_23468;
var statearr_23476_23559 = state_23468__$1;
(statearr_23476_23559[(2)] = null);

(statearr_23476_23559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (24))){
var inst_23344 = (state_23468[(10)]);
var inst_23344__$1 = (state_23468[(2)]);
var inst_23345 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23346 = cljs.core.PersistentHashMap.EMPTY;
var inst_23347 = inst_23345;
var inst_23348 = inst_23344__$1;
var inst_23349 = inst_23346;
var state_23468__$1 = (function (){var statearr_23477 = state_23468;
(statearr_23477[(11)] = inst_23348);

(statearr_23477[(10)] = inst_23344__$1);

(statearr_23477[(12)] = inst_23349);

(statearr_23477[(13)] = inst_23347);

return statearr_23477;
})();
var statearr_23478_23560 = state_23468__$1;
(statearr_23478_23560[(2)] = null);

(statearr_23478_23560[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (39))){
var inst_23364 = (state_23468[(14)]);
var inst_23348 = (state_23468[(11)]);
var inst_23357 = (state_23468[(15)]);
var inst_23314 = (state_23468[(9)]);
var inst_23393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23394 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23348,inst_23314,inst_23357,inst_23364,false);
var state_23468__$1 = (function (){var statearr_23479 = state_23468;
(statearr_23479[(16)] = inst_23393);

return statearr_23479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23468__$1,(42),inst_23394);
} else {
if((state_val_23469 === (46))){
var inst_23357 = (state_23468[(15)]);
var inst_23349 = (state_23468[(12)]);
var inst_23347 = (state_23468[(13)]);
var inst_23411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23412 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23413 = cljs.core.first(inst_23357);
var inst_23414 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23413);
var inst_23415 = [inst_23414];
var inst_23416 = cljs.core.PersistentHashMap.fromArrays(inst_23412,inst_23415);
var inst_23417 = cljs.core.rest(inst_23347);
var inst_23418 = [inst_23416,inst_23417,inst_23349];
var inst_23419 = (new cljs.core.PersistentVector(null,3,(5),inst_23411,inst_23418,null));
var state_23468__$1 = state_23468;
var statearr_23480_23561 = state_23468__$1;
(statearr_23480_23561[(2)] = inst_23419);

(statearr_23480_23561[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (4))){
var inst_23288 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
var statearr_23481_23562 = state_23468__$1;
(statearr_23481_23562[(2)] = inst_23288);

(statearr_23481_23562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (15))){
var inst_23315 = (state_23468[(17)]);
var inst_23314 = (state_23468[(9)]);
var inst_23314__$1 = (state_23468[(2)]);
var inst_23315__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23314__$1);
var state_23468__$1 = (function (){var statearr_23482 = state_23468;
(statearr_23482[(17)] = inst_23315__$1);

(statearr_23482[(9)] = inst_23314__$1);

return statearr_23482;
})();
if(cljs.core.truth_(inst_23315__$1)){
var statearr_23483_23563 = state_23468__$1;
(statearr_23483_23563[(1)] = (16));

} else {
var statearr_23484_23564 = state_23468__$1;
(statearr_23484_23564[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (48))){
var inst_23430 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
var statearr_23485_23565 = state_23468__$1;
(statearr_23485_23565[(2)] = inst_23430);

(statearr_23485_23565[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (50))){
var state_23468__$1 = state_23468;
var statearr_23486_23566 = state_23468__$1;
(statearr_23486_23566[(2)] = null);

(statearr_23486_23566[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (21))){
var inst_23314 = (state_23468[(9)]);
var inst_23328 = (state_23468[(2)]);
var inst_23329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23330 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23331 = (new cljs.core.PersistentVector(null,2,(5),inst_23329,inst_23330,null));
var inst_23332 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23314,inst_23331);
var state_23468__$1 = (function (){var statearr_23487 = state_23468;
(statearr_23487[(8)] = inst_23328);

return statearr_23487;
})();
if(cljs.core.truth_(inst_23332)){
var statearr_23488_23567 = state_23468__$1;
(statearr_23488_23567[(1)] = (22));

} else {
var statearr_23489_23568 = state_23468__$1;
(statearr_23489_23568[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (31))){
var inst_23348 = (state_23468[(11)]);
var inst_23363 = (state_23468[(18)]);
var inst_23357 = (state_23468[(15)]);
var inst_23367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23368 = fluree.db.query.fql_resp.flake__GT_recur(db,inst_23357,inst_23363,inst_23348,fuel,max_fuel,cache);
var state_23468__$1 = (function (){var statearr_23490 = state_23468;
(statearr_23490[(19)] = inst_23367);

return statearr_23490;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23468__$1,(34),inst_23368);
} else {
if((state_val_23469 === (32))){
var inst_23363 = (state_23468[(18)]);
var state_23468__$1 = state_23468;
if(cljs.core.truth_(inst_23363)){
var statearr_23491_23569 = state_23468__$1;
(statearr_23491_23569[(1)] = (35));

} else {
var statearr_23492_23570 = state_23468__$1;
(statearr_23492_23570[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (40))){
var inst_23314 = (state_23468[(9)]);
var inst_23404 = (state_23468[(20)]);
var inst_23403 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23314);
var inst_23404__$1 = cljs.core.empty_QMARK_(inst_23403);
var state_23468__$1 = (function (){var statearr_23493 = state_23468;
(statearr_23493[(20)] = inst_23404__$1);

return statearr_23493;
})();
if(inst_23404__$1){
var statearr_23494_23571 = state_23468__$1;
(statearr_23494_23571[(1)] = (43));

} else {
var statearr_23495_23572 = state_23468__$1;
(statearr_23495_23572[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (33))){
var inst_23357 = (state_23468[(15)]);
var inst_23436 = (state_23468[(2)]);
var inst_23437 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23436,(0),null);
var inst_23438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23436,(1),null);
var inst_23439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23436,(2),null);
var inst_23440 = cljs.core.first(inst_23357);
var inst_23441 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23440);
var inst_23442 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23437,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23441);
var inst_23347 = inst_23438;
var inst_23348 = inst_23442;
var inst_23349 = inst_23439;
var state_23468__$1 = (function (){var statearr_23496 = state_23468;
(statearr_23496[(11)] = inst_23348);

(statearr_23496[(12)] = inst_23349);

(statearr_23496[(13)] = inst_23347);

return statearr_23496;
})();
var statearr_23497_23573 = state_23468__$1;
(statearr_23497_23573[(2)] = null);

(statearr_23497_23573[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (13))){
var inst_23308 = (state_23468[(7)]);
var inst_23311 = fluree.db.query.fql_resp.full_select_spec(db,cache,base_select_spec,inst_23308);
var state_23468__$1 = state_23468;
var statearr_23498_23574 = state_23468__$1;
(statearr_23498_23574[(2)] = inst_23311);

(statearr_23498_23574[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (22))){
var inst_23314 = (state_23468[(9)]);
var inst_23334 = cljs.core.first(flakes);
var inst_23335 = fluree.db.flake.s(inst_23334);
var inst_23336 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs(inst_23314);
var inst_23337 = fluree.db.query.fql_resp.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23335,inst_23336);
var state_23468__$1 = state_23468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23468__$1,(25),inst_23337);
} else {
if((state_val_23469 === (36))){
var inst_23314 = (state_23468[(9)]);
var inst_23391 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23314);
var state_23468__$1 = state_23468;
if(cljs.core.truth_(inst_23391)){
var statearr_23499_23575 = state_23468__$1;
(statearr_23499_23575[(1)] = (39));

} else {
var statearr_23500_23576 = state_23468__$1;
(statearr_23500_23576[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (41))){
var inst_23432 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
var statearr_23501_23577 = state_23468__$1;
(statearr_23501_23577[(2)] = inst_23432);

(statearr_23501_23577[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (43))){
var inst_23314 = (state_23468[(9)]);
var inst_23406 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23314);
var state_23468__$1 = state_23468;
var statearr_23502_23578 = state_23468__$1;
(statearr_23502_23578[(2)] = inst_23406);

(statearr_23502_23578[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (29))){
var inst_23363 = (state_23468[(18)]);
var inst_23357 = (state_23468[(15)]);
var inst_23314 = (state_23468[(9)]);
var inst_23347 = (state_23468[(13)]);
var inst_23357__$1 = cljs.core.first(inst_23347);
var inst_23358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23359 = cljs.core.first(inst_23357__$1);
var inst_23360 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23359);
var inst_23361 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23360];
var inst_23362 = (new cljs.core.PersistentVector(null,3,(5),inst_23358,inst_23361,null));
var inst_23363__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23314,inst_23362);
var inst_23364 = fluree.db.query.fql_resp.component_follow_QMARK_(inst_23363__$1,inst_23314);
var inst_23365 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23363__$1);
var state_23468__$1 = (function (){var statearr_23503 = state_23468;
(statearr_23503[(14)] = inst_23364);

(statearr_23503[(18)] = inst_23363__$1);

(statearr_23503[(15)] = inst_23357__$1);

return statearr_23503;
})();
if(cljs.core.truth_(inst_23365)){
var statearr_23504_23579 = state_23468__$1;
(statearr_23504_23579[(1)] = (31));

} else {
var statearr_23505_23580 = state_23468__$1;
(statearr_23505_23580[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (44))){
var inst_23404 = (state_23468[(20)]);
var state_23468__$1 = state_23468;
var statearr_23506_23581 = state_23468__$1;
(statearr_23506_23581[(2)] = inst_23404);

(statearr_23506_23581[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (6))){
var state_23468__$1 = state_23468;
var statearr_23507_23582 = state_23468__$1;
(statearr_23507_23582[(2)] = null);

(statearr_23507_23582[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (28))){
var inst_23348 = (state_23468[(11)]);
var state_23468__$1 = state_23468;
var statearr_23508_23583 = state_23468__$1;
(statearr_23508_23583[(2)] = inst_23348);

(statearr_23508_23583[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (51))){
var inst_23428 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
var statearr_23509_23584 = state_23468__$1;
(statearr_23509_23584[(2)] = inst_23428);

(statearr_23509_23584[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (25))){
var inst_23328 = (state_23468[(8)]);
var inst_23339 = (state_23468[(2)]);
var inst_23340 = fluree.db.util.async.throw_err(inst_23339);
var inst_23341 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23328,inst_23340], 0));
var state_23468__$1 = state_23468;
var statearr_23510_23585 = state_23468__$1;
(statearr_23510_23585[(2)] = inst_23341);

(statearr_23510_23585[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (34))){
var inst_23367 = (state_23468[(19)]);
var inst_23349 = (state_23468[(12)]);
var inst_23347 = (state_23468[(13)]);
var inst_23370 = (state_23468[(2)]);
var inst_23371 = fluree.db.util.async.throw_err(inst_23370);
var inst_23372 = cljs.core.rest(inst_23347);
var inst_23373 = [inst_23371,inst_23372,inst_23349];
var inst_23374 = (new cljs.core.PersistentVector(null,3,(5),inst_23367,inst_23373,null));
var state_23468__$1 = state_23468;
var statearr_23511_23586 = state_23468__$1;
(statearr_23511_23586[(2)] = inst_23374);

(statearr_23511_23586[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (17))){
var inst_23314 = (state_23468[(9)]);
var inst_23318 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23314);
var state_23468__$1 = state_23468;
var statearr_23513_23587 = state_23468__$1;
(statearr_23513_23587[(2)] = inst_23318);

(statearr_23513_23587[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (3))){
var inst_23466 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23468__$1,inst_23466);
} else {
if((state_val_23469 === (12))){
var _ = (function (){var statearr_23514 = state_23468;
(statearr_23514[(4)] = cljs.core.rest((state_23468[(4)])));

return statearr_23514;
})();
var state_23468__$1 = state_23468;
var ex23512 = (state_23468__$1[(2)]);
var statearr_23515_23588 = state_23468__$1;
(statearr_23515_23588[(5)] = ex23512);


var statearr_23516_23589 = state_23468__$1;
(statearr_23516_23589[(1)] = (11));

(statearr_23516_23589[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (2))){
var _ = (function (){var statearr_23517 = state_23468;
(statearr_23517[(4)] = cljs.core.cons((5),(state_23468[(4)])));

return statearr_23517;
})();
var inst_23294 = cljs.core.not_empty(flakes);
var state_23468__$1 = state_23468;
if(cljs.core.truth_(inst_23294)){
var statearr_23518_23590 = state_23468__$1;
(statearr_23518_23590[(1)] = (6));

} else {
var statearr_23519_23591 = state_23468__$1;
(statearr_23519_23591[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (23))){
var inst_23328 = (state_23468[(8)]);
var state_23468__$1 = state_23468;
var statearr_23520_23592 = state_23468__$1;
(statearr_23520_23592[(2)] = inst_23328);

(statearr_23520_23592[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (47))){
var state_23468__$1 = state_23468;
var statearr_23521_23593 = state_23468__$1;
(statearr_23521_23593[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (35))){
var inst_23364 = (state_23468[(14)]);
var inst_23348 = (state_23468[(11)]);
var inst_23363 = (state_23468[(18)]);
var inst_23357 = (state_23468[(15)]);
var inst_23349 = (state_23468[(12)]);
var inst_23380 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23348,inst_23363,inst_23357,inst_23364,false,inst_23349);
var state_23468__$1 = state_23468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23468__$1,(38),inst_23380);
} else {
if((state_val_23469 === (19))){
var inst_23308 = (state_23468[(7)]);
var inst_23322 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23323 = [inst_23308];
var inst_23324 = cljs.core.PersistentHashMap.fromArrays(inst_23322,inst_23323);
var state_23468__$1 = state_23468;
var statearr_23523_23594 = state_23468__$1;
(statearr_23523_23594[(2)] = inst_23324);

(statearr_23523_23594[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (11))){
var inst_23296 = (state_23468[(2)]);
var inst_23297 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(inst_23296) : fluree.db.util.log.error.call(null,inst_23296));
var inst_23298 = (function(){throw inst_23296})();
var state_23468__$1 = (function (){var statearr_23525 = state_23468;
(statearr_23525[(21)] = inst_23297);

return statearr_23525;
})();
var statearr_23526_23595 = state_23468__$1;
(statearr_23526_23595[(2)] = inst_23298);

(statearr_23526_23595[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (9))){
var _ = (function (){var statearr_23527 = state_23468;
(statearr_23527[(4)] = cljs.core.cons((12),(state_23468[(4)])));

return statearr_23527;
})();
var inst_23304 = cljs.core.first(flakes);
var inst_23305 = fluree.db.flake.s(inst_23304);
var ___$1 = (function (){var statearr_23528 = state_23468;
(statearr_23528[(4)] = cljs.core.rest((state_23468[(4)])));

return statearr_23528;
})();
var state_23468__$1 = state_23468;
var statearr_23529_23596 = state_23468__$1;
(statearr_23529_23596[(2)] = inst_23305);

(statearr_23529_23596[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (5))){
var _ = (function (){var statearr_23530 = state_23468;
(statearr_23530[(4)] = cljs.core.rest((state_23468[(4)])));

return statearr_23530;
})();
var state_23468__$1 = state_23468;
var ex23524 = (state_23468__$1[(2)]);
var statearr_23531_23597 = state_23468__$1;
(statearr_23531_23597[(5)] = ex23524);


if((ex23524 instanceof Error)){
var statearr_23532_23598 = state_23468__$1;
(statearr_23532_23598[(1)] = (4));

(statearr_23532_23598[(5)] = null);

} else {
throw ex23524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (14))){
var state_23468__$1 = state_23468;
var statearr_23533_23599 = state_23468__$1;
(statearr_23533_23599[(2)] = base_select_spec);

(statearr_23533_23599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (45))){
var inst_23409 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
if(cljs.core.truth_(inst_23409)){
var statearr_23534_23600 = state_23468__$1;
(statearr_23534_23600[(1)] = (46));

} else {
var statearr_23535_23601 = state_23468__$1;
(statearr_23535_23601[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (26))){
var inst_23347 = (state_23468[(13)]);
var inst_23351 = cljs.core.empty_QMARK_(inst_23347);
var state_23468__$1 = state_23468;
if(inst_23351){
var statearr_23536_23602 = state_23468__$1;
(statearr_23536_23602[(1)] = (28));

} else {
var statearr_23537_23603 = state_23468__$1;
(statearr_23537_23603[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (16))){
var inst_23315 = (state_23468[(17)]);
var state_23468__$1 = state_23468;
var statearr_23538_23604 = state_23468__$1;
(statearr_23538_23604[(2)] = inst_23315);

(statearr_23538_23604[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (38))){
var inst_23347 = (state_23468[(13)]);
var inst_23382 = (state_23468[(2)]);
var inst_23383 = fluree.db.util.async.throw_err(inst_23382);
var inst_23384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23383,(0),null);
var inst_23385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23383,(1),null);
var inst_23386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23387 = cljs.core.rest(inst_23347);
var inst_23388 = [inst_23384,inst_23387,inst_23385];
var inst_23389 = (new cljs.core.PersistentVector(null,3,(5),inst_23386,inst_23388,null));
var state_23468__$1 = state_23468;
var statearr_23539_23605 = state_23468__$1;
(statearr_23539_23605[(2)] = inst_23389);

(statearr_23539_23605[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (30))){
var inst_23445 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
var statearr_23540_23606 = state_23468__$1;
(statearr_23540_23606[(2)] = inst_23445);

(statearr_23540_23606[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (10))){
var inst_23308 = (state_23468[(2)]);
var inst_23309 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_(base_select_spec);
var state_23468__$1 = (function (){var statearr_23541 = state_23468;
(statearr_23541[(7)] = inst_23308);

return statearr_23541;
})();
if(cljs.core.truth_(inst_23309)){
var statearr_23542_23607 = state_23468__$1;
(statearr_23542_23607[(1)] = (13));

} else {
var statearr_23543_23608 = state_23468__$1;
(statearr_23543_23608[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (18))){
var inst_23320 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
if(cljs.core.truth_(inst_23320)){
var statearr_23544_23609 = state_23468__$1;
(statearr_23544_23609[(1)] = (19));

} else {
var statearr_23545_23610 = state_23468__$1;
(statearr_23545_23610[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (42))){
var inst_23393 = (state_23468[(16)]);
var inst_23349 = (state_23468[(12)]);
var inst_23347 = (state_23468[(13)]);
var inst_23396 = (state_23468[(2)]);
var inst_23397 = fluree.db.util.async.throw_err(inst_23396);
var inst_23398 = cljs.core.first(inst_23397);
var inst_23399 = cljs.core.rest(inst_23347);
var inst_23400 = [inst_23398,inst_23399,inst_23349];
var inst_23401 = (new cljs.core.PersistentVector(null,3,(5),inst_23393,inst_23400,null));
var state_23468__$1 = state_23468;
var statearr_23546_23611 = state_23468__$1;
(statearr_23546_23611[(2)] = inst_23401);

(statearr_23546_23611[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (37))){
var inst_23434 = (state_23468[(2)]);
var state_23468__$1 = state_23468;
var statearr_23547_23612 = state_23468__$1;
(statearr_23547_23612[(2)] = inst_23434);

(statearr_23547_23612[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (8))){
var inst_23463 = (state_23468[(2)]);
var _ = (function (){var statearr_23548 = state_23468;
(statearr_23548[(4)] = cljs.core.rest((state_23468[(4)])));

return statearr_23548;
})();
var state_23468__$1 = state_23468;
var statearr_23549_23613 = state_23468__$1;
(statearr_23549_23613[(2)] = inst_23463);

(statearr_23549_23613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23469 === (49))){
var inst_23348 = (state_23468[(11)]);
var inst_23349 = (state_23468[(12)]);
var inst_23347 = (state_23468[(13)]);
var inst_23422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23423 = cljs.core.rest(inst_23347);
var inst_23424 = [inst_23348,inst_23423,inst_23349];
var inst_23425 = (new cljs.core.PersistentVector(null,3,(5),inst_23422,inst_23424,null));
var state_23468__$1 = state_23468;
var statearr_23550_23614 = state_23468__$1;
(statearr_23550_23614[(2)] = inst_23425);

(statearr_23550_23614[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0 = (function (){
var statearr_23551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23551[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__);

(statearr_23551[(1)] = (1));

return statearr_23551;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1 = (function (state_23468){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23468);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23552){var ex__2730__auto__ = e23552;
var statearr_23553_23615 = state_23468;
(statearr_23553_23615[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23468[(4)]))){
var statearr_23554_23616 = state_23468;
(statearr_23554_23616[(1)] = cljs.core.first((state_23468[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23617 = state_23468;
state_23468 = G__23617;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = function(state_23468){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1.call(this,state_23468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23555 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23555[(6)] = c__2749__auto__);

return statearr_23555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
