// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__15007 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15007,(5),null);
var G__15010 = idx;
var G__15010__$1 = (((G__15010 instanceof cljs.core.Keyword))?G__15010.fqn:null);
switch (G__15010__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate(db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15010__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__15012 = idx;
var G__15012__$1 = (((G__15012 instanceof cljs.core.Keyword))?G__15012.fqn:null);
switch (G__15012__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15012__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__15014 = idx;
var G__15014__$1 = (((G__15014 instanceof cljs.core.Keyword))?G__15014.fqn:null);
switch (G__15014__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15014__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15054){
var state_val_15055 = (state_15054[(1)]);
if((state_val_15055 === (7))){
var inst_15031 = (state_15054[(7)]);
var inst_15038 = (state_15054[(2)]);
var inst_15039 = fluree.db.util.async.throw_err(inst_15038);
var state_15054__$1 = (function (){var statearr_15056 = state_15054;
(statearr_15056[(8)] = inst_15039);

return statearr_15056;
})();
if(cljs.core.truth_(inst_15031)){
var statearr_15057_15081 = state_15054__$1;
(statearr_15057_15081[(1)] = (8));

} else {
var statearr_15058_15082 = state_15054__$1;
(statearr_15058_15082[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (1))){
var state_15054__$1 = state_15054;
var statearr_15059_15083 = state_15054__$1;
(statearr_15059_15083[(2)] = null);

(statearr_15059_15083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (4))){
var inst_15016 = (state_15054[(2)]);
var state_15054__$1 = state_15054;
var statearr_15060_15084 = state_15054__$1;
(statearr_15060_15084[(2)] = inst_15016);

(statearr_15060_15084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (13))){
var inst_15046 = (state_15054[(2)]);
var state_15054__$1 = state_15054;
var statearr_15061_15085 = state_15054__$1;
(statearr_15061_15085[(2)] = inst_15046);

(statearr_15061_15085[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (6))){
var inst_15028 = (state_15054[(9)]);
var inst_15034 = (state_15054[(2)]);
var inst_15035 = fluree.db.util.async.throw_err(inst_15034);
var inst_15036 = fluree.db.query.range.resolve_subid(db,inst_15028);
var state_15054__$1 = (function (){var statearr_15062 = state_15054;
(statearr_15062[(10)] = inst_15035);

return statearr_15062;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15054__$1,(7),inst_15036);
} else {
if((state_val_15055 === (3))){
var inst_15052 = (state_15054[(2)]);
var state_15054__$1 = state_15054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15054__$1,inst_15052);
} else {
if((state_val_15055 === (12))){
var state_15054__$1 = state_15054;
var statearr_15063_15086 = state_15054__$1;
(statearr_15063_15086[(2)] = (2147483647));

(statearr_15063_15086[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (2))){
var _ = (function (){var statearr_15064 = state_15054;
(statearr_15064[(4)] = cljs.core.cons((5),(state_15054[(4)])));

return statearr_15064;
})();
var inst_15025 = parts;
var inst_15026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15025,(0),null);
var inst_15027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15025,(1),null);
var inst_15028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15025,(2),null);
var inst_15029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15025,(3),null);
var inst_15030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15025,(4),null);
var inst_15031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15025,(5),null);
var inst_15032 = fluree.db.query.range.resolve_subid(db,inst_15026);
var state_15054__$1 = (function (){var statearr_15065 = state_15054;
(statearr_15065[(9)] = inst_15028);

(statearr_15065[(11)] = inst_15027);

(statearr_15065[(12)] = inst_15030);

(statearr_15065[(13)] = inst_15029);

(statearr_15065[(7)] = inst_15031);

return statearr_15065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15054__$1,(6),inst_15032);
} else {
if((state_val_15055 === (11))){
var state_15054__$1 = state_15054;
var statearr_15067_15087 = state_15054__$1;
(statearr_15067_15087[(2)] = (-2147483647));

(statearr_15067_15087[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (9))){
var inst_15042 = (cljs.core._GT__EQ_ === test);
var state_15054__$1 = state_15054;
if(cljs.core.truth_(inst_15042)){
var statearr_15068_15088 = state_15054__$1;
(statearr_15068_15088[(1)] = (11));

} else {
var statearr_15069_15089 = state_15054__$1;
(statearr_15069_15089[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (5))){
var _ = (function (){var statearr_15070 = state_15054;
(statearr_15070[(4)] = cljs.core.rest((state_15054[(4)])));

return statearr_15070;
})();
var state_15054__$1 = state_15054;
var ex15066 = (state_15054__$1[(2)]);
var statearr_15071_15090 = state_15054__$1;
(statearr_15071_15090[(5)] = ex15066);


if((ex15066 instanceof Error)){
var statearr_15072_15091 = state_15054__$1;
(statearr_15072_15091[(1)] = (4));

(statearr_15072_15091[(5)] = null);

} else {
throw ex15066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (10))){
var inst_15039 = (state_15054[(8)]);
var inst_15027 = (state_15054[(11)]);
var inst_15030 = (state_15054[(12)]);
var inst_15029 = (state_15054[(13)]);
var inst_15035 = (state_15054[(10)]);
var inst_15048 = (state_15054[(2)]);
var inst_15049 = fluree.db.flake.__GT_Flake(inst_15035,inst_15027,inst_15039,inst_15029,inst_15030,inst_15048);
var _ = (function (){var statearr_15073 = state_15054;
(statearr_15073[(4)] = cljs.core.rest((state_15054[(4)])));

return statearr_15073;
})();
var state_15054__$1 = state_15054;
var statearr_15074_15092 = state_15054__$1;
(statearr_15074_15092[(2)] = inst_15049);

(statearr_15074_15092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15055 === (8))){
var inst_15031 = (state_15054[(7)]);
var state_15054__$1 = state_15054;
var statearr_15075_15093 = state_15054__$1;
(statearr_15075_15093[(2)] = inst_15031);

(statearr_15075_15093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_15076 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15076[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__);

(statearr_15076[(1)] = (1));

return statearr_15076;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1 = (function (state_15054){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15054);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15077){var ex__2730__auto__ = e15077;
var statearr_15078_15094 = state_15054;
(statearr_15078_15094[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15054[(4)]))){
var statearr_15079_15095 = state_15054;
(statearr_15079_15095[(1)] = cljs.core.first((state_15054[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15096 = state_15054;
state_15054 = G__15096;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = function(state_15054){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1.call(this,state_15054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15080 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15080[(6)] = c__2749__auto__);

return statearr_15080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__5043__auto__ = fluree.db.index.leaf_QMARK_(node);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(node);
} else {
return and__5043__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.flake.lower_than_all_QMARK_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core.not(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__15097){
var map__15098 = p__15097;
var map__15098__$1 = cljs.core.__destructure_map(map__15098);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15098__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15098__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15098__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__15099 = cljs.core.PersistentVector.EMPTY;
var G__15099__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15099,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15100 = fluree.db.flake.s(f);
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__15100) : subject_fn.call(null,G__15100));
}))):G__15099);
var G__15099__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15099__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15101 = fluree.db.flake.p(f);
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__15101) : predicate_fn.call(null,G__15101));
}))):G__15099__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15099__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15102 = fluree.db.flake.o(f);
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15102) : object_fn.call(null,G__15102));
})));
} else {
return G__15099__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__15103){
var map__15104 = p__15103;
var map__15104__$1 = cljs.core.__destructure_map(map__15104);
var opts = map__15104__$1;
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter(opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__15105,root,novelty,error_ch,p__15106){
var map__15107 = p__15105;
var map__15107__$1 = cljs.core.__destructure_map(map__15107);
var conn = map__15107__$1;
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15107__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__15108 = p__15106;
var map__15108__$1 = cljs.core.__destructure_map(map__15108);
var opts = map__15108__$1;
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15108__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15108__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15108__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15108__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_flake,end_flake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes(opts);
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15139){
var state_val_15140 = (state_15139[(1)]);
if((state_val_15140 === (7))){
var inst_15122 = (state_15139[(7)]);
var state_15139__$1 = state_15139;
var statearr_15141_15165 = state_15139__$1;
(statearr_15141_15165[(2)] = inst_15122);

(statearr_15141_15165[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (1))){
var state_15139__$1 = state_15139;
var statearr_15142_15166 = state_15139__$1;
(statearr_15142_15166[(2)] = null);

(statearr_15142_15166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (4))){
var inst_15109 = (state_15139[(2)]);
var inst_15110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15111 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_15112 = (new cljs.core.PersistentVector(null,3,(5),inst_15110,inst_15111,null));
var inst_15113 = cljs.core.select_keys(db,inst_15112);
var inst_15114 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_15109,"Error authorizing flake in ledger",inst_15113) : fluree.db.util.log.error.call(null,inst_15109,"Error authorizing flake in ledger",inst_15113));
var state_15139__$1 = (function (){var statearr_15144 = state_15139;
(statearr_15144[(8)] = inst_15114);

return statearr_15144;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15139__$1,(5),error_ch,inst_15109);
} else {
if((state_val_15140 === (13))){
var inst_15134 = (state_15139[(2)]);
var _ = (function (){var statearr_15145 = state_15139;
(statearr_15145[(4)] = cljs.core.rest((state_15139[(4)])));

return statearr_15145;
})();
var state_15139__$1 = state_15139;
var statearr_15146_15167 = state_15139__$1;
(statearr_15146_15167[(2)] = inst_15134);

(statearr_15146_15167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (6))){
var _ = (function (){var statearr_15147 = state_15139;
(statearr_15147[(4)] = cljs.core.rest((state_15139[(4)])));

return statearr_15147;
})();
var state_15139__$1 = state_15139;
var ex15143 = (state_15139__$1[(2)]);
var statearr_15148_15168 = state_15139__$1;
(statearr_15148_15168[(5)] = ex15143);


var statearr_15149_15169 = state_15139__$1;
(statearr_15149_15169[(1)] = (4));

(statearr_15149_15169[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (3))){
var inst_15137 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15139__$1,inst_15137);
} else {
if((state_val_15140 === (12))){
var state_15139__$1 = state_15139;
var statearr_15150_15170 = state_15139__$1;
(statearr_15150_15170[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_15150_15170[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (2))){
var inst_15122 = (state_15139[(7)]);
var _ = (function (){var statearr_15151 = state_15139;
(statearr_15151[(4)] = cljs.core.cons((6),(state_15139[(4)])));

return statearr_15151;
})();
var inst_15122__$1 = fluree.db.util.schema.is_schema_flake_QMARK_(flake);
var state_15139__$1 = (function (){var statearr_15152 = state_15139;
(statearr_15152[(7)] = inst_15122__$1);

return statearr_15152;
})();
if(inst_15122__$1){
var statearr_15153_15171 = state_15139__$1;
(statearr_15153_15171[(1)] = (7));

} else {
var statearr_15154_15172 = state_15139__$1;
(statearr_15154_15172[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (11))){
var state_15139__$1 = state_15139;
var statearr_15155_15173 = state_15139__$1;
(statearr_15155_15173[(2)] = flake);

(statearr_15155_15173[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (9))){
var inst_15130 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
if(cljs.core.truth_(inst_15130)){
var statearr_15156_15174 = state_15139__$1;
(statearr_15156_15174[(1)] = (11));

} else {
var statearr_15157_15175 = state_15139__$1;
(statearr_15157_15175[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (5))){
var inst_15116 = (state_15139[(2)]);
var state_15139__$1 = state_15139;
var statearr_15158_15176 = state_15139__$1;
(statearr_15158_15176[(2)] = inst_15116);

(statearr_15158_15176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (10))){
var inst_15127 = (state_15139[(2)]);
var inst_15128 = fluree.db.util.async.throw_err(inst_15127);
var state_15139__$1 = state_15139;
var statearr_15159_15177 = state_15139__$1;
(statearr_15159_15177[(2)] = inst_15128);

(statearr_15159_15177[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15140 === (8))){
var inst_15125 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,flake);
var state_15139__$1 = state_15139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15139__$1,(10),inst_15125);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_15160 = [null,null,null,null,null,null,null,null,null];
(statearr_15160[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__);

(statearr_15160[(1)] = (1));

return statearr_15160;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1 = (function (state_15139){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15139);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15161){var ex__2730__auto__ = e15161;
var statearr_15162_15178 = state_15139;
(statearr_15162_15178[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15139[(4)]))){
var statearr_15163_15179 = state_15139;
(statearr_15163_15179[(1)] = cljs.core.first((state_15139[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15180 = state_15139;
state_15139 = G__15180;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = function(state_15139){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1.call(this,state_15139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15164 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15164[(6)] = c__2749__auto__);

return statearr_15164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function() { 
var G__15181__delegate = function (fs){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$1(fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__15181 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__15182__i = 0, G__15182__a = new Array(arguments.length -  0);
while (G__15182__i < G__15182__a.length) {G__15182__a[G__15182__i] = arguments[G__15182__i + 0]; ++G__15182__i;}
  fs = new cljs.core.IndexedSeq(G__15182__a,0,null);
} 
return G__15181__delegate.call(this,fs);};
G__15181.cljs$lang$maxFixedArity = 0;
G__15181.cljs$lang$applyTo = (function (arglist__15183){
var fs = cljs.core.seq(arglist__15183);
return G__15181__delegate(fs);
});
G__15181.cljs$core$IFn$_invoke$arity$variadic = G__15181__delegate;
return G__15181;
})()
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__15184,start,end,error_ch,flake_slices){
var map__15185 = p__15184;
var map__15185__$1 = cljs.core.__destructure_map(map__15185);
var db = map__15185__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15185__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__15186 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s)], null);
var G__15186__$1 = (cljs.core.truth_(offset)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15186,cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset)):G__15186);
var G__15186__$2 = (cljs.core.truth_(limit)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15186__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit)):G__15186__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15186__$2,cljs.core.cat);

})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__15187 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__15187__$1 = (cljs.core.truth_((function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return offset;
}
})())?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15187,fluree.db.query.range.filter_subject_page(limit,offset)):G__15187);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15187__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(flake_limit));
} else {
return G__15187__$1;
}
})();
var page_xf = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,page_xfs);
return cljs.core.async.transduce(page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__15188,error_ch,p__15189){
var map__15190 = p__15188;
var map__15190__$1 = cljs.core.__destructure_map(map__15190);
var db = map__15190__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15190__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__15191 = p__15189;
var map__15191__$1 = cljs.core.__destructure_map(map__15191);
var opts = map__15191__$1;
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15191__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15191__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15191__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15191__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15191__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15191__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var idx_cmp = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page(limit,offset,flake_limit,fluree.db.query.range.filter_authorized(db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices(conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__15192 = cljs.core.identical_QMARK_;
var expr__15193 = test;
if(cljs.core.truth_((pred__15192.cljs$core$IFn$_invoke$arity$2 ? pred__15192.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__15193) : pred__15192.call(null,cljs.core._EQ_,expr__15193)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15192.cljs$core$IFn$_invoke$arity$2 ? pred__15192.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__15193) : pred__15192.call(null,cljs.core._LT_,expr__15193)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__15192.cljs$core$IFn$_invoke$arity$2 ? pred__15192.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__15193) : pred__15192.call(null,cljs.core._LT__EQ_,expr__15193)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15192.cljs$core$IFn$_invoke$arity$2 ? pred__15192.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__15193) : pred__15192.call(null,cljs.core._GT_,expr__15193)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__15192.cljs$core$IFn$_invoke$arity$2 ? pred__15192.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__15193) : pred__15192.call(null,cljs.core._GT__EQ_,expr__15193)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15193)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__15196 = arguments.length;
switch (G__15196) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15197 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15197,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15197,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15197,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15197,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15200,idx,start_test,start_match,end_test,end_match,opts){
var map__15201 = p__15200;
var map__15201__$1 = cljs.core.__destructure_map(map__15201);
var db = map__15201__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15201__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15202 = opts;
var map__15202__$1 = cljs.core.__destructure_map(map__15202);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15202__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15202__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15202__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15264){
var state_val_15265 = (state_15264[(1)]);
if((state_val_15265 === (7))){
var inst_15212 = (state_15264[(7)]);
var inst_15217 = (state_15264[(8)]);
var inst_15221 = (state_15264[(9)]);
var inst_15215 = (state_15264[(2)]);
var inst_15216 = fluree.db.util.async.throw_err(inst_15215);
var inst_15217__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15218 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_15219 = [idx,from_t,to_t,start_test,inst_15212,end_test,inst_15216,limit];
var inst_15220 = cljs.core.PersistentHashMap.fromArrays(inst_15218,inst_15219);
var inst_15221__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15217__$1,inst_15220);
var inst_15229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15230 = [inst_15217__$1,inst_15221__$1];
var inst_15231 = (new cljs.core.PersistentVector(null,2,(5),inst_15229,inst_15230,null));
var state_15264__$1 = (function (){var statearr_15266 = state_15264;
(statearr_15266[(8)] = inst_15217__$1);

(statearr_15266[(9)] = inst_15221__$1);

return statearr_15266;
})();
return cljs.core.async.ioc_alts_BANG_(state_15264__$1,(8),inst_15231);
} else {
if((state_val_15265 === (1))){
var state_15264__$1 = state_15264;
var statearr_15267_15296 = state_15264__$1;
(statearr_15267_15296[(2)] = null);

(statearr_15267_15296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (4))){
var inst_15203 = (state_15264[(2)]);
var state_15264__$1 = state_15264;
var statearr_15268_15297 = state_15264__$1;
(statearr_15268_15297[(2)] = inst_15203);

(statearr_15268_15297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (15))){
var inst_15234 = (state_15264[(10)]);
var state_15264__$1 = state_15264;
var statearr_15269_15298 = state_15264__$1;
(statearr_15269_15298[(2)] = inst_15234);

(statearr_15269_15298[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (13))){
var inst_15235 = (state_15264[(11)]);
var inst_15251 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15235,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15264__$1 = state_15264;
if(inst_15251){
var statearr_15270_15299 = state_15264__$1;
(statearr_15270_15299[(1)] = (15));

} else {
var statearr_15271_15300 = state_15264__$1;
(statearr_15271_15300[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (6))){
var inst_15211 = (state_15264[(2)]);
var inst_15212 = fluree.db.util.async.throw_err(inst_15211);
var inst_15213 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_15264__$1 = (function (){var statearr_15272 = state_15264;
(statearr_15272[(7)] = inst_15212);

return statearr_15272;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15264__$1,(7),inst_15213);
} else {
if((state_val_15265 === (17))){
var inst_15255 = (state_15264[(2)]);
var state_15264__$1 = state_15264;
var statearr_15273_15301 = state_15264__$1;
(statearr_15273_15301[(2)] = inst_15255);

(statearr_15273_15301[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (3))){
var inst_15262 = (state_15264[(2)]);
var state_15264__$1 = state_15264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15264__$1,inst_15262);
} else {
if((state_val_15265 === (12))){
var inst_15233 = (state_15264[(12)]);
var inst_15249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15233,(0),null);
var state_15264__$1 = state_15264;
var statearr_15274_15302 = state_15264__$1;
(statearr_15274_15302[(2)] = inst_15249);

(statearr_15274_15302[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (2))){
var _ = (function (){var statearr_15275 = state_15264;
(statearr_15275[(4)] = cljs.core.cons((5),(state_15264[(4)])));

return statearr_15275;
})();
var inst_15209 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_15264__$1 = state_15264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15264__$1,(6),inst_15209);
} else {
if((state_val_15265 === (11))){
var inst_15259 = (state_15264[(2)]);
var _ = (function (){var statearr_15277 = state_15264;
(statearr_15277[(4)] = cljs.core.rest((state_15264[(4)])));

return statearr_15277;
})();
var state_15264__$1 = state_15264;
var statearr_15278_15303 = state_15264__$1;
(statearr_15278_15303[(2)] = inst_15259);

(statearr_15278_15303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (9))){
var inst_15233 = (state_15264[(12)]);
var inst_15241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15233,(0),null);
var inst_15242 = (function(){throw inst_15241})();
var state_15264__$1 = state_15264;
var statearr_15279_15304 = state_15264__$1;
(statearr_15279_15304[(2)] = inst_15242);

(statearr_15279_15304[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (5))){
var _ = (function (){var statearr_15280 = state_15264;
(statearr_15280[(4)] = cljs.core.rest((state_15264[(4)])));

return statearr_15280;
})();
var state_15264__$1 = state_15264;
var ex15276 = (state_15264__$1[(2)]);
var statearr_15281_15305 = state_15264__$1;
(statearr_15281_15305[(5)] = ex15276);


if((ex15276 instanceof Error)){
var statearr_15282_15306 = state_15264__$1;
(statearr_15282_15306[(1)] = (4));

(statearr_15282_15306[(5)] = null);

} else {
throw ex15276;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (14))){
var inst_15257 = (state_15264[(2)]);
var state_15264__$1 = state_15264;
var statearr_15283_15307 = state_15264__$1;
(statearr_15283_15307[(2)] = inst_15257);

(statearr_15283_15307[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (16))){
var state_15264__$1 = state_15264;
var statearr_15284_15308 = state_15264__$1;
(statearr_15284_15308[(2)] = null);

(statearr_15284_15308[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (10))){
var inst_15235 = (state_15264[(11)]);
var inst_15221 = (state_15264[(9)]);
var inst_15244 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15235,inst_15221);
var state_15264__$1 = state_15264;
if(inst_15244){
var statearr_15285_15309 = state_15264__$1;
(statearr_15285_15309[(1)] = (12));

} else {
var statearr_15286_15310 = state_15264__$1;
(statearr_15286_15310[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (8))){
var inst_15233 = (state_15264[(12)]);
var inst_15217 = (state_15264[(8)]);
var inst_15235 = (state_15264[(11)]);
var inst_15233__$1 = (state_15264[(2)]);
var inst_15234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15233__$1,(0),null);
var inst_15235__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15233__$1,(1),null);
var inst_15236 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15235__$1,inst_15217);
var state_15264__$1 = (function (){var statearr_15287 = state_15264;
(statearr_15287[(12)] = inst_15233__$1);

(statearr_15287[(11)] = inst_15235__$1);

(statearr_15287[(10)] = inst_15234);

return statearr_15287;
})();
if(inst_15236){
var statearr_15288_15311 = state_15264__$1;
(statearr_15288_15311[(1)] = (9));

} else {
var statearr_15289_15312 = state_15264__$1;
(statearr_15289_15312[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15290 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15290[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15290[(1)] = (1));

return statearr_15290;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15264){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15264);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15291){var ex__2730__auto__ = e15291;
var statearr_15292_15313 = state_15264;
(statearr_15292_15313[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15264[(4)]))){
var statearr_15293_15314 = state_15264;
(statearr_15293_15314[(1)] = cljs.core.first((state_15264[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15315 = state_15264;
state_15264 = G__15315;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15264){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15294 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15294[(6)] = c__2749__auto__);

return statearr_15294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15317 = arguments.length;
switch (G__15317) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15318 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15318,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15318,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15318,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15318,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15321,idx,start_test,start_match,end_test,end_match,p__15322){
var map__15323 = p__15321;
var map__15323__$1 = cljs.core.__destructure_map(map__15323);
var db = map__15323__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15323__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15323__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15324 = p__15322;
var map__15324__$1 = cljs.core.__destructure_map(map__15324);
var opts = map__15324__$1;
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15324__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__15325 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15325,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15325,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15325,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15325,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15325,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15325,(5),null);
var vec__15328 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15328,(5),null);
var vec__15331 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__15334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15334,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15334,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15331,(1),null);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15402){
var state_val_15403 = (state_15402[(1)]);
if((state_val_15403 === (7))){
var inst_15357 = (state_15402[(7)]);
var inst_15349 = (state_15402[(8)]);
var inst_15359 = (state_15402[(9)]);
var inst_15355 = (state_15402[(2)]);
var inst_15356 = fluree.db.util.async.throw_err(inst_15355);
var inst_15357__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15358 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_15349,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_15356,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1], 0));
var inst_15359__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15357__$1,inst_15358);
var inst_15367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15368 = [inst_15357__$1,inst_15359__$1];
var inst_15369 = (new cljs.core.PersistentVector(null,2,(5),inst_15367,inst_15368,null));
var state_15402__$1 = (function (){var statearr_15404 = state_15402;
(statearr_15404[(7)] = inst_15357__$1);

(statearr_15404[(9)] = inst_15359__$1);

return statearr_15404;
})();
return cljs.core.async.ioc_alts_BANG_(state_15402__$1,(8),inst_15369);
} else {
if((state_val_15403 === (1))){
var state_15402__$1 = state_15402;
var statearr_15405_15434 = state_15402__$1;
(statearr_15405_15434[(2)] = null);

(statearr_15405_15434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (4))){
var inst_15337 = (state_15402[(2)]);
var state_15402__$1 = state_15402;
var statearr_15406_15435 = state_15402__$1;
(statearr_15406_15435[(2)] = inst_15337);

(statearr_15406_15435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (15))){
var inst_15372 = (state_15402[(10)]);
var state_15402__$1 = state_15402;
var statearr_15407_15436 = state_15402__$1;
(statearr_15407_15436[(2)] = inst_15372);

(statearr_15407_15436[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (13))){
var inst_15373 = (state_15402[(11)]);
var inst_15389 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15373,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15402__$1 = state_15402;
if(inst_15389){
var statearr_15408_15437 = state_15402__$1;
(statearr_15408_15437[(1)] = (15));

} else {
var statearr_15409_15438 = state_15402__$1;
(statearr_15409_15438[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (6))){
var inst_15348 = (state_15402[(2)]);
var inst_15349 = fluree.db.util.async.throw_err(inst_15348);
var inst_15350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15351 = [s2,p2,o2__$1,t2,op2,m2];
var inst_15352 = (new cljs.core.PersistentVector(null,6,(5),inst_15350,inst_15351,null));
var inst_15353 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_15352);
var state_15402__$1 = (function (){var statearr_15410 = state_15402;
(statearr_15410[(8)] = inst_15349);

return statearr_15410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15402__$1,(7),inst_15353);
} else {
if((state_val_15403 === (17))){
var inst_15393 = (state_15402[(2)]);
var state_15402__$1 = state_15402;
var statearr_15411_15439 = state_15402__$1;
(statearr_15411_15439[(2)] = inst_15393);

(statearr_15411_15439[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (3))){
var inst_15400 = (state_15402[(2)]);
var state_15402__$1 = state_15402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15402__$1,inst_15400);
} else {
if((state_val_15403 === (12))){
var inst_15371 = (state_15402[(12)]);
var inst_15387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15371,(0),null);
var state_15402__$1 = state_15402;
var statearr_15412_15440 = state_15402__$1;
(statearr_15412_15440[(2)] = inst_15387);

(statearr_15412_15440[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (2))){
var _ = (function (){var statearr_15413 = state_15402;
(statearr_15413[(4)] = cljs.core.cons((5),(state_15402[(4)])));

return statearr_15413;
})();
var inst_15343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15344 = [s1,p1,o1__$1,t1,op1,m1];
var inst_15345 = (new cljs.core.PersistentVector(null,6,(5),inst_15343,inst_15344,null));
var inst_15346 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_15345);
var state_15402__$1 = state_15402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15402__$1,(6),inst_15346);
} else {
if((state_val_15403 === (11))){
var inst_15397 = (state_15402[(2)]);
var _ = (function (){var statearr_15415 = state_15402;
(statearr_15415[(4)] = cljs.core.rest((state_15402[(4)])));

return statearr_15415;
})();
var state_15402__$1 = state_15402;
var statearr_15416_15441 = state_15402__$1;
(statearr_15416_15441[(2)] = inst_15397);

(statearr_15416_15441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (9))){
var inst_15371 = (state_15402[(12)]);
var inst_15379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15371,(0),null);
var inst_15380 = (function(){throw inst_15379})();
var state_15402__$1 = state_15402;
var statearr_15417_15442 = state_15402__$1;
(statearr_15417_15442[(2)] = inst_15380);

(statearr_15417_15442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (5))){
var _ = (function (){var statearr_15418 = state_15402;
(statearr_15418[(4)] = cljs.core.rest((state_15402[(4)])));

return statearr_15418;
})();
var state_15402__$1 = state_15402;
var ex15414 = (state_15402__$1[(2)]);
var statearr_15419_15443 = state_15402__$1;
(statearr_15419_15443[(5)] = ex15414);


if((ex15414 instanceof Error)){
var statearr_15420_15444 = state_15402__$1;
(statearr_15420_15444[(1)] = (4));

(statearr_15420_15444[(5)] = null);

} else {
throw ex15414;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (14))){
var inst_15395 = (state_15402[(2)]);
var state_15402__$1 = state_15402;
var statearr_15421_15445 = state_15402__$1;
(statearr_15421_15445[(2)] = inst_15395);

(statearr_15421_15445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (16))){
var state_15402__$1 = state_15402;
var statearr_15422_15446 = state_15402__$1;
(statearr_15422_15446[(2)] = null);

(statearr_15422_15446[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (10))){
var inst_15373 = (state_15402[(11)]);
var inst_15359 = (state_15402[(9)]);
var inst_15382 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15373,inst_15359);
var state_15402__$1 = state_15402;
if(inst_15382){
var statearr_15423_15447 = state_15402__$1;
(statearr_15423_15447[(1)] = (12));

} else {
var statearr_15424_15448 = state_15402__$1;
(statearr_15424_15448[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15403 === (8))){
var inst_15371 = (state_15402[(12)]);
var inst_15357 = (state_15402[(7)]);
var inst_15373 = (state_15402[(11)]);
var inst_15371__$1 = (state_15402[(2)]);
var inst_15372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15371__$1,(0),null);
var inst_15373__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15371__$1,(1),null);
var inst_15374 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15373__$1,inst_15357);
var state_15402__$1 = (function (){var statearr_15425 = state_15402;
(statearr_15425[(12)] = inst_15371__$1);

(statearr_15425[(11)] = inst_15373__$1);

(statearr_15425[(10)] = inst_15372);

return statearr_15425;
})();
if(inst_15374){
var statearr_15426_15449 = state_15402__$1;
(statearr_15426_15449[(1)] = (9));

} else {
var statearr_15427_15450 = state_15402__$1;
(statearr_15427_15450[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15428 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15428[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15428[(1)] = (1));

return statearr_15428;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15402){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15402);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15429){var ex__2730__auto__ = e15429;
var statearr_15430_15451 = state_15402;
(statearr_15430_15451[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15402[(4)]))){
var statearr_15431_15452 = state_15402;
(statearr_15431_15452[(1)] = cljs.core.first((state_15402[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15453 = state_15402;
state_15402 = G__15453;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15402){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15432 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15432[(6)] = c__2749__auto__);

return statearr_15432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o(f))) && ((fluree.db.flake.o(f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15509){
var state_val_15510 = (state_15509[(1)]);
if((state_val_15510 === (7))){
var inst_15473 = (state_15509[(7)]);
var inst_15483 = (state_15509[(8)]);
var inst_15481 = fluree.db.flake.Flake__GT_parts(inst_15473);
var inst_15482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15481,(0),null);
var inst_15483__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15481,(1),null);
var inst_15484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15481,(2),null);
var inst_15485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15481,(3),null);
var inst_15486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15481,(4),null);
var inst_15487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15481,(5),null);
var inst_15488 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15484,inst_15483__$1);
var state_15509__$1 = (function (){var statearr_15511 = state_15509;
(statearr_15511[(9)] = inst_15486);

(statearr_15511[(8)] = inst_15483__$1);

(statearr_15511[(10)] = inst_15485);

(statearr_15511[(11)] = inst_15482);

(statearr_15511[(12)] = inst_15487);

return statearr_15511;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15509__$1,(10),inst_15488);
} else {
if((state_val_15510 === (1))){
var inst_15461 = flakes;
var inst_15462 = cljs.core.seq(inst_15461);
var inst_15463 = cljs.core.first(inst_15462);
var inst_15464 = cljs.core.next(inst_15462);
var inst_15465 = cljs.core.PersistentVector.EMPTY;
var inst_15466 = inst_15461;
var inst_15467 = inst_15465;
var state_15509__$1 = (function (){var statearr_15512 = state_15509;
(statearr_15512[(13)] = inst_15466);

(statearr_15512[(14)] = inst_15467);

(statearr_15512[(15)] = inst_15464);

(statearr_15512[(16)] = inst_15463);

return statearr_15512;
})();
var statearr_15513_15531 = state_15509__$1;
(statearr_15513_15531[(2)] = null);

(statearr_15513_15531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15510 === (4))){
var inst_15473 = (state_15509[(7)]);
var inst_15476 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15473);
var state_15509__$1 = state_15509;
if(inst_15476){
var statearr_15514_15532 = state_15509__$1;
(statearr_15514_15532[(1)] = (7));

} else {
var statearr_15515_15533 = state_15509__$1;
(statearr_15515_15533[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15510 === (6))){
var inst_15505 = (state_15509[(2)]);
var state_15509__$1 = state_15509;
var statearr_15516_15534 = state_15509__$1;
(statearr_15516_15534[(2)] = inst_15505);

(statearr_15516_15534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15510 === (3))){
var inst_15507 = (state_15509[(2)]);
var state_15509__$1 = state_15509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15509__$1,inst_15507);
} else {
if((state_val_15510 === (2))){
var inst_15466 = (state_15509[(13)]);
var inst_15473 = (state_15509[(7)]);
var inst_15472 = cljs.core.seq(inst_15466);
var inst_15473__$1 = cljs.core.first(inst_15472);
var inst_15474 = cljs.core.next(inst_15472);
var state_15509__$1 = (function (){var statearr_15517 = state_15509;
(statearr_15517[(7)] = inst_15473__$1);

(statearr_15517[(17)] = inst_15474);

return statearr_15517;
})();
if(cljs.core.truth_(inst_15473__$1)){
var statearr_15518_15535 = state_15509__$1;
(statearr_15518_15535[(1)] = (4));

} else {
var statearr_15519_15536 = state_15509__$1;
(statearr_15519_15536[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15510 === (9))){
var inst_15502 = (state_15509[(2)]);
var state_15509__$1 = state_15509;
var statearr_15520_15537 = state_15509__$1;
(statearr_15520_15537[(2)] = inst_15502);

(statearr_15520_15537[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15510 === (5))){
var inst_15467 = (state_15509[(14)]);
var state_15509__$1 = state_15509;
var statearr_15521_15538 = state_15509__$1;
(statearr_15521_15538[(2)] = inst_15467);

(statearr_15521_15538[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15510 === (10))){
var inst_15486 = (state_15509[(9)]);
var inst_15467 = (state_15509[(14)]);
var inst_15483 = (state_15509[(8)]);
var inst_15485 = (state_15509[(10)]);
var inst_15474 = (state_15509[(17)]);
var inst_15482 = (state_15509[(11)]);
var inst_15487 = (state_15509[(12)]);
var inst_15490 = (state_15509[(2)]);
var inst_15491 = fluree.db.util.async.throw_err(inst_15490);
var inst_15492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15493 = [inst_15482,inst_15483,inst_15491,inst_15485,inst_15486,inst_15487];
var inst_15494 = (new cljs.core.PersistentVector(null,6,(5),inst_15492,inst_15493,null));
var inst_15495 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15494);
var inst_15496 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15467,inst_15495);
var inst_15466 = inst_15474;
var inst_15467__$1 = inst_15496;
var state_15509__$1 = (function (){var statearr_15522 = state_15509;
(statearr_15522[(13)] = inst_15466);

(statearr_15522[(14)] = inst_15467__$1);

return statearr_15522;
})();
var statearr_15523_15539 = state_15509__$1;
(statearr_15523_15539[(2)] = null);

(statearr_15523_15539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15510 === (8))){
var inst_15473 = (state_15509[(7)]);
var inst_15467 = (state_15509[(14)]);
var inst_15474 = (state_15509[(17)]);
var inst_15499 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15467,inst_15473);
var inst_15466 = inst_15474;
var inst_15467__$1 = inst_15499;
var state_15509__$1 = (function (){var statearr_15524 = state_15509;
(statearr_15524[(13)] = inst_15466);

(statearr_15524[(14)] = inst_15467__$1);

return statearr_15524;
})();
var statearr_15525_15540 = state_15509__$1;
(statearr_15525_15540[(2)] = null);

(statearr_15525_15540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_15526 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15526[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__);

(statearr_15526[(1)] = (1));

return statearr_15526;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1 = (function (state_15509){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15509);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15527){var ex__2730__auto__ = e15527;
var statearr_15528_15541 = state_15509;
(statearr_15528_15541[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15509[(4)]))){
var statearr_15529_15542 = state_15509;
(statearr_15529_15542[(1)] = cljs.core.first((state_15509[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15543 = state_15509;
state_15509 = G__15543;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = function(state_15509){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1.call(this,state_15509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15530 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15530[(6)] = c__2749__auto__);

return statearr_15530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15545 = arguments.length;
switch (G__15545) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15727){
var state_val_15728 = (state_15727[(1)]);
if((state_val_15728 === (65))){
var inst_15596 = (state_15727[(7)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15596)){
var statearr_15729_15833 = state_15727__$1;
(statearr_15729_15833[(1)] = (68));

} else {
var statearr_15730_15834 = state_15727__$1;
(statearr_15730_15834[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (70))){
var inst_15706 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15731_15835 = state_15727__$1;
(statearr_15731_15835[(2)] = inst_15706);

(statearr_15731_15835[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (62))){
var inst_15672 = (state_15727[(2)]);
var inst_15673 = fluree.db.util.async.throw_err(inst_15672);
var inst_15674 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15673);
var state_15727__$1 = state_15727;
var statearr_15732_15836 = state_15727__$1;
(statearr_15732_15836[(2)] = inst_15674);

(statearr_15732_15836[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (74))){
var inst_15722 = (state_15727[(2)]);
var _ = (function (){var statearr_15733 = state_15727;
(statearr_15733[(4)] = cljs.core.rest((state_15727[(4)])));

return statearr_15733;
})();
var state_15727__$1 = state_15727;
var statearr_15734_15837 = state_15727__$1;
(statearr_15734_15837[(2)] = inst_15722);

(statearr_15734_15837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (7))){
var state_15727__$1 = state_15727;
var statearr_15735_15838 = state_15727__$1;
(statearr_15735_15838[(2)] = false);

(statearr_15735_15838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (59))){
var inst_15596 = (state_15727[(7)]);
var inst_15666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15667 = [inst_15596];
var inst_15668 = (new cljs.core.PersistentVector(null,1,(5),inst_15666,inst_15667,null));
var inst_15669 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15670 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15668,inst_15669);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(62),inst_15670);
} else {
if((state_val_15728 === (20))){
var state_15727__$1 = state_15727;
var statearr_15736_15839 = state_15727__$1;
(statearr_15736_15839[(2)] = null);

(statearr_15736_15839[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (72))){
var inst_15714 = (state_15727[(8)]);
var inst_15716 = fluree.db.query.range.coerce_tag_flakes(db,inst_15714);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(75),inst_15716);
} else {
if((state_val_15728 === (58))){
var inst_15664 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15664)){
var statearr_15737_15840 = state_15727__$1;
(statearr_15737_15840[(1)] = (59));

} else {
var statearr_15738_15841 = state_15727__$1;
(statearr_15738_15841[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (60))){
var inst_15658 = (state_15727[(9)]);
var inst_15556 = (state_15727[(10)]);
var inst_15557 = (state_15727[(11)]);
var inst_15559 = (state_15727[(12)]);
var inst_15676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15677 = [inst_15557,inst_15556,null,inst_15559];
var inst_15678 = (new cljs.core.PersistentVector(null,4,(5),inst_15676,inst_15677,null));
var inst_15679 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15658);
var inst_15680 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15678,inst_15679);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(63),inst_15680);
} else {
if((state_val_15728 === (27))){
var inst_15556 = (state_15727[(10)]);
var inst_15596 = (state_15727[(7)]);
var inst_15557 = (state_15727[(11)]);
var inst_15559 = (state_15727[(12)]);
var inst_15608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15609 = [inst_15556,inst_15557,inst_15596,inst_15559];
var inst_15610 = (new cljs.core.PersistentVector(null,4,(5),inst_15608,inst_15609,null));
var inst_15611 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15610,opts);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(30),inst_15611);
} else {
if((state_val_15728 === (1))){
var state_15727__$1 = state_15727;
var statearr_15739_15842 = state_15727__$1;
(statearr_15739_15842[(2)] = null);

(statearr_15739_15842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (69))){
var state_15727__$1 = state_15727;
var statearr_15740_15843 = state_15727__$1;
(statearr_15740_15843[(2)] = null);

(statearr_15740_15843[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (24))){
var inst_15557 = (state_15727[(11)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15557)){
var statearr_15741_15844 = state_15727__$1;
(statearr_15741_15844[(1)] = (31));

} else {
var statearr_15742_15845 = state_15727__$1;
(statearr_15742_15845[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (55))){
var inst_15659 = (state_15727[(13)]);
var inst_15557 = (state_15727[(11)]);
var inst_15658 = (state_15727[(2)]);
var inst_15659__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15557);
var state_15727__$1 = (function (){var statearr_15743 = state_15727;
(statearr_15743[(9)] = inst_15658);

(statearr_15743[(13)] = inst_15659__$1);

return statearr_15743;
})();
if(inst_15659__$1){
var statearr_15744_15846 = state_15727__$1;
(statearr_15744_15846[(1)] = (56));

} else {
var statearr_15745_15847 = state_15727__$1;
(statearr_15745_15847[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (39))){
var inst_15626 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15746_15848 = state_15727__$1;
(statearr_15746_15848[(2)] = inst_15626);

(statearr_15746_15848[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (46))){
var inst_15650 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15650)){
var statearr_15747_15849 = state_15727__$1;
(statearr_15747_15849[(1)] = (50));

} else {
var statearr_15748_15850 = state_15727__$1;
(statearr_15748_15850[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (4))){
var inst_15546 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15749_15851 = state_15727__$1;
(statearr_15749_15851[(2)] = inst_15546);

(statearr_15749_15851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (54))){
var inst_15560 = (state_15727[(14)]);
var inst_15556 = (state_15727[(10)]);
var inst_15571 = (state_15727[(15)]);
var inst_15555 = (state_15727[(16)]);
var inst_15566 = (state_15727[(17)]);
var inst_15596 = (state_15727[(7)]);
var inst_15557 = (state_15727[(11)]);
var inst_15559 = (state_15727[(12)]);
var inst_15652 = (state_15727[(18)]);
var inst_15656 = (function (){var t = inst_15559;
var vec__15552 = inst_15555;
var temp__5802__auto__ = inst_15652;
var p = inst_15557;
var idx_predicate_QMARK_ = inst_15560;
var o = inst_15596;
var tag_predicate_QMARK_ = inst_15566;
var s = inst_15556;
var o_coerce_QMARK_ = inst_15571;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15727__$1 = state_15727;
var statearr_15750_15852 = state_15727__$1;
(statearr_15750_15852[(2)] = inst_15656);

(statearr_15750_15852[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (15))){
var inst_15558 = (state_15727[(19)]);
var inst_15577 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15558);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(18),inst_15577);
} else {
if((state_val_15728 === (48))){
var inst_15643 = (state_15727[(20)]);
var state_15727__$1 = state_15727;
var statearr_15751_15853 = state_15727__$1;
(statearr_15751_15853[(2)] = inst_15643);

(statearr_15751_15853[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (50))){
var inst_15652 = (state_15727[(18)]);
var inst_15652__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15727__$1 = (function (){var statearr_15752 = state_15727;
(statearr_15752[(18)] = inst_15652__$1);

return statearr_15752;
})();
if(cljs.core.truth_(inst_15652__$1)){
var statearr_15753_15854 = state_15727__$1;
(statearr_15753_15854[(1)] = (53));

} else {
var statearr_15754_15855 = state_15727__$1;
(statearr_15754_15855[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (75))){
var inst_15718 = (state_15727[(2)]);
var inst_15719 = fluree.db.util.async.throw_err(inst_15718);
var state_15727__$1 = state_15727;
var statearr_15755_15856 = state_15727__$1;
(statearr_15755_15856[(2)] = inst_15719);

(statearr_15755_15856[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (21))){
var inst_15592 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15756_15857 = state_15727__$1;
(statearr_15756_15857[(2)] = inst_15592);

(statearr_15756_15857[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (31))){
var inst_15596 = (state_15727[(7)]);
var inst_15619 = (state_15727[(21)]);
var inst_15619__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15596);
var state_15727__$1 = (function (){var statearr_15757 = state_15727;
(statearr_15757[(21)] = inst_15619__$1);

return statearr_15757;
})();
if(inst_15619__$1){
var statearr_15758_15858 = state_15727__$1;
(statearr_15758_15858[(1)] = (34));

} else {
var statearr_15759_15859 = state_15727__$1;
(statearr_15759_15859[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (32))){
var inst_15557 = (state_15727[(11)]);
var state_15727__$1 = state_15727;
var statearr_15760_15860 = state_15727__$1;
(statearr_15760_15860[(2)] = inst_15557);

(statearr_15760_15860[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (40))){
var inst_15556 = (state_15727[(10)]);
var inst_15596 = (state_15727[(7)]);
var inst_15557 = (state_15727[(11)]);
var inst_15559 = (state_15727[(12)]);
var inst_15634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15635 = [inst_15557,inst_15596,inst_15556,inst_15559];
var inst_15636 = (new cljs.core.PersistentVector(null,4,(5),inst_15634,inst_15635,null));
var inst_15637 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15636,opts);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(43),inst_15637);
} else {
if((state_val_15728 === (56))){
var inst_15596 = (state_15727[(7)]);
var inst_15661 = cljs.core.int_QMARK_(inst_15596);
var state_15727__$1 = state_15727;
var statearr_15761_15861 = state_15727__$1;
(statearr_15761_15861[(2)] = inst_15661);

(statearr_15761_15861[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (33))){
var inst_15632 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15632)){
var statearr_15762_15862 = state_15727__$1;
(statearr_15762_15862[(1)] = (40));

} else {
var statearr_15763_15863 = state_15727__$1;
(statearr_15763_15863[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (13))){
var inst_15558 = (state_15727[(19)]);
var inst_15575 = fluree.db.query.range.tag_string_QMARK_(inst_15558);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15575)){
var statearr_15764_15864 = state_15727__$1;
(statearr_15764_15864[(1)] = (15));

} else {
var statearr_15765_15865 = state_15727__$1;
(statearr_15765_15865[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (22))){
var inst_15588 = (state_15727[(2)]);
var inst_15589 = fluree.db.util.async.throw_err(inst_15588);
var state_15727__$1 = state_15727;
var statearr_15766_15866 = state_15727__$1;
(statearr_15766_15866[(2)] = inst_15589);

(statearr_15766_15866[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (36))){
var inst_15629 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15767_15867 = state_15727__$1;
(statearr_15767_15867[(2)] = inst_15629);

(statearr_15767_15867[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (41))){
var inst_15557 = (state_15727[(11)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15557)){
var statearr_15768_15868 = state_15727__$1;
(statearr_15768_15868[(1)] = (44));

} else {
var statearr_15769_15869 = state_15727__$1;
(statearr_15769_15869[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (43))){
var inst_15639 = (state_15727[(2)]);
var inst_15640 = fluree.db.util.async.throw_err(inst_15639);
var state_15727__$1 = state_15727;
var statearr_15770_15870 = state_15727__$1;
(statearr_15770_15870[(2)] = inst_15640);

(statearr_15770_15870[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (61))){
var inst_15685 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15771_15871 = state_15727__$1;
(statearr_15771_15871[(2)] = inst_15685);

(statearr_15771_15871[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (29))){
var inst_15605 = (state_15727[(2)]);
var inst_15606 = fluree.db.util.async.throw_err(inst_15605);
var state_15727__$1 = state_15727;
var statearr_15772_15872 = state_15727__$1;
(statearr_15772_15872[(2)] = inst_15606);

(statearr_15772_15872[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (44))){
var inst_15560 = (state_15727[(14)]);
var inst_15643 = (state_15727[(20)]);
var inst_15643__$1 = cljs.core.not(inst_15560);
var state_15727__$1 = (function (){var statearr_15773 = state_15727;
(statearr_15773[(20)] = inst_15643__$1);

return statearr_15773;
})();
if(inst_15643__$1){
var statearr_15774_15873 = state_15727__$1;
(statearr_15774_15873[(1)] = (47));

} else {
var statearr_15775_15874 = state_15727__$1;
(statearr_15775_15874[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (6))){
var inst_15557 = (state_15727[(11)]);
var inst_15562 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15557);
var inst_15563 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15562);
var state_15727__$1 = state_15727;
var statearr_15776_15875 = state_15727__$1;
(statearr_15776_15875[(2)] = inst_15563);

(statearr_15776_15875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (28))){
var inst_15616 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15777_15876 = state_15727__$1;
(statearr_15777_15876[(2)] = inst_15616);

(statearr_15777_15876[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (64))){
var inst_15556 = (state_15727[(10)]);
var inst_15596 = (state_15727[(7)]);
var inst_15557 = (state_15727[(11)]);
var inst_15559 = (state_15727[(12)]);
var inst_15688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15689 = [inst_15557,inst_15556,inst_15596,inst_15559];
var inst_15690 = (new cljs.core.PersistentVector(null,4,(5),inst_15688,inst_15689,null));
var inst_15691 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15690,opts);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(67),inst_15691);
} else {
if((state_val_15728 === (51))){
var inst_15557 = (state_15727[(11)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15557)){
var statearr_15778_15877 = state_15727__$1;
(statearr_15778_15877[(1)] = (64));

} else {
var statearr_15779_15878 = state_15727__$1;
(statearr_15779_15878[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (25))){
var inst_15566 = (state_15727[(17)]);
var inst_15714 = (state_15727[(2)]);
var state_15727__$1 = (function (){var statearr_15780 = state_15727;
(statearr_15780[(8)] = inst_15714);

return statearr_15780;
})();
if(cljs.core.truth_(inst_15566)){
var statearr_15781_15879 = state_15727__$1;
(statearr_15781_15879[(1)] = (72));

} else {
var statearr_15782_15880 = state_15727__$1;
(statearr_15782_15880[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (34))){
var inst_15560 = (state_15727[(14)]);
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15560)){
var statearr_15783_15881 = state_15727__$1;
(statearr_15783_15881[(1)] = (37));

} else {
var statearr_15784_15882 = state_15727__$1;
(statearr_15784_15882[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (17))){
var inst_15594 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15785_15883 = state_15727__$1;
(statearr_15785_15883[(2)] = inst_15594);

(statearr_15785_15883[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (3))){
var inst_15725 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15727__$1,inst_15725);
} else {
if((state_val_15728 === (12))){
var inst_15558 = (state_15727[(19)]);
var state_15727__$1 = state_15727;
var statearr_15786_15884 = state_15727__$1;
(statearr_15786_15884[(2)] = inst_15558);

(statearr_15786_15884[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (2))){
var inst_15555 = (state_15727[(16)]);
var inst_15557 = (state_15727[(11)]);
var _ = (function (){var statearr_15787 = state_15727;
(statearr_15787[(4)] = cljs.core.cons((5),(state_15727[(4)])));

return statearr_15787;
})();
var inst_15555__$1 = fparts;
var inst_15556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15555__$1,(0),null);
var inst_15557__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15555__$1,(1),null);
var inst_15558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15555__$1,(2),null);
var inst_15559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15555__$1,(3),null);
var inst_15560 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15557__$1);
var state_15727__$1 = (function (){var statearr_15788 = state_15727;
(statearr_15788[(14)] = inst_15560);

(statearr_15788[(19)] = inst_15558);

(statearr_15788[(10)] = inst_15556);

(statearr_15788[(16)] = inst_15555__$1);

(statearr_15788[(11)] = inst_15557__$1);

(statearr_15788[(12)] = inst_15559);

return statearr_15788;
})();
if(cljs.core.truth_(inst_15557__$1)){
var statearr_15789_15885 = state_15727__$1;
(statearr_15789_15885[(1)] = (6));

} else {
var statearr_15790_15886 = state_15727__$1;
(statearr_15790_15886[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (66))){
var inst_15708 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15791_15887 = state_15727__$1;
(statearr_15791_15887[(2)] = inst_15708);

(statearr_15791_15887[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (23))){
var inst_15557 = (state_15727[(11)]);
var inst_15598 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15557);
var state_15727__$1 = state_15727;
if(inst_15598){
var statearr_15792_15888 = state_15727__$1;
(statearr_15792_15888[(1)] = (26));

} else {
var statearr_15793_15889 = state_15727__$1;
(statearr_15793_15889[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (47))){
var inst_15596 = (state_15727[(7)]);
var state_15727__$1 = state_15727;
var statearr_15794_15890 = state_15727__$1;
(statearr_15794_15890[(2)] = inst_15596);

(statearr_15794_15890[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (35))){
var inst_15619 = (state_15727[(21)]);
var state_15727__$1 = state_15727;
var statearr_15795_15891 = state_15727__$1;
(statearr_15795_15891[(2)] = inst_15619);

(statearr_15795_15891[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (19))){
var inst_15558 = (state_15727[(19)]);
var inst_15557 = (state_15727[(11)]);
var inst_15584 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15557);
var inst_15585 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15584),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15558)].join('');
var inst_15586 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15585);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(22),inst_15586);
} else {
if((state_val_15728 === (57))){
var inst_15659 = (state_15727[(13)]);
var state_15727__$1 = state_15727;
var statearr_15796_15892 = state_15727__$1;
(statearr_15796_15892[(2)] = inst_15659);

(statearr_15796_15892[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (68))){
var inst_15556 = (state_15727[(10)]);
var inst_15596 = (state_15727[(7)]);
var inst_15557 = (state_15727[(11)]);
var inst_15559 = (state_15727[(12)]);
var inst_15697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15698 = [inst_15596,inst_15557,inst_15556,inst_15559];
var inst_15699 = (new cljs.core.PersistentVector(null,4,(5),inst_15697,inst_15698,null));
var inst_15700 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15699,opts);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(71),inst_15700);
} else {
if((state_val_15728 === (11))){
var inst_15571 = (state_15727[(15)]);
var inst_15571__$1 = (state_15727[(2)]);
var inst_15572 = cljs.core.not(inst_15571__$1);
var state_15727__$1 = (function (){var statearr_15798 = state_15727;
(statearr_15798[(15)] = inst_15571__$1);

return statearr_15798;
})();
if(inst_15572){
var statearr_15799_15893 = state_15727__$1;
(statearr_15799_15893[(1)] = (12));

} else {
var statearr_15800_15894 = state_15727__$1;
(statearr_15800_15894[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (9))){
var inst_15558 = (state_15727[(19)]);
var inst_15568 = typeof inst_15558 === 'string';
var state_15727__$1 = state_15727;
var statearr_15801_15895 = state_15727__$1;
(statearr_15801_15895[(2)] = inst_15568);

(statearr_15801_15895[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (5))){
var _ = (function (){var statearr_15802 = state_15727;
(statearr_15802[(4)] = cljs.core.rest((state_15727[(4)])));

return statearr_15802;
})();
var state_15727__$1 = state_15727;
var ex15797 = (state_15727__$1[(2)]);
var statearr_15803_15896 = state_15727__$1;
(statearr_15803_15896[(5)] = ex15797);


if((ex15797 instanceof Error)){
var statearr_15804_15897 = state_15727__$1;
(statearr_15804_15897[(1)] = (4));

(statearr_15804_15897[(5)] = null);

} else {
throw ex15797;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (14))){
var inst_15556 = (state_15727[(10)]);
var inst_15596 = (state_15727[(2)]);
var state_15727__$1 = (function (){var statearr_15805 = state_15727;
(statearr_15805[(7)] = inst_15596);

return statearr_15805;
})();
if(cljs.core.truth_(inst_15556)){
var statearr_15806_15898 = state_15727__$1;
(statearr_15806_15898[(1)] = (23));

} else {
var statearr_15807_15899 = state_15727__$1;
(statearr_15807_15899[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (45))){
var inst_15557 = (state_15727[(11)]);
var state_15727__$1 = state_15727;
var statearr_15808_15900 = state_15727__$1;
(statearr_15808_15900[(2)] = inst_15557);

(statearr_15808_15900[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (53))){
var inst_15560 = (state_15727[(14)]);
var inst_15556 = (state_15727[(10)]);
var inst_15571 = (state_15727[(15)]);
var inst_15555 = (state_15727[(16)]);
var inst_15566 = (state_15727[(17)]);
var inst_15596 = (state_15727[(7)]);
var inst_15557 = (state_15727[(11)]);
var inst_15559 = (state_15727[(12)]);
var inst_15652 = (state_15727[(18)]);
var inst_15654 = (function (){var obj_fn = inst_15652;
var t = inst_15559;
var vec__15552 = inst_15555;
var temp__5802__auto__ = inst_15652;
var p = inst_15557;
var idx_predicate_QMARK_ = inst_15560;
var o = inst_15596;
var tag_predicate_QMARK_ = inst_15566;
var s = inst_15556;
var o_coerce_QMARK_ = inst_15571;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_15727__$1 = state_15727;
var statearr_15809_15901 = state_15727__$1;
(statearr_15809_15901[(2)] = inst_15654);

(statearr_15809_15901[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (26))){
var inst_15556 = (state_15727[(10)]);
var inst_15559 = (state_15727[(12)]);
var inst_15600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15601 = [inst_15556,null,null,inst_15559];
var inst_15602 = (new cljs.core.PersistentVector(null,4,(5),inst_15600,inst_15601,null));
var inst_15603 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15602,opts);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15727__$1,(29),inst_15603);
} else {
if((state_val_15728 === (16))){
var inst_15558 = (state_15727[(19)]);
var inst_15582 = typeof inst_15558 === 'string';
var state_15727__$1 = state_15727;
if(cljs.core.truth_(inst_15582)){
var statearr_15810_15902 = state_15727__$1;
(statearr_15810_15902[(1)] = (19));

} else {
var statearr_15811_15903 = state_15727__$1;
(statearr_15811_15903[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (38))){
var inst_15560 = (state_15727[(14)]);
var state_15727__$1 = state_15727;
var statearr_15812_15904 = state_15727__$1;
(statearr_15812_15904[(2)] = inst_15560);

(statearr_15812_15904[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (30))){
var inst_15613 = (state_15727[(2)]);
var inst_15614 = fluree.db.util.async.throw_err(inst_15613);
var state_15727__$1 = state_15727;
var statearr_15813_15905 = state_15727__$1;
(statearr_15813_15905[(2)] = inst_15614);

(statearr_15813_15905[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (73))){
var inst_15714 = (state_15727[(8)]);
var state_15727__$1 = state_15727;
var statearr_15814_15906 = state_15727__$1;
(statearr_15814_15906[(2)] = inst_15714);

(statearr_15814_15906[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (10))){
var inst_15566 = (state_15727[(17)]);
var state_15727__$1 = state_15727;
var statearr_15815_15907 = state_15727__$1;
(statearr_15815_15907[(2)] = inst_15566);

(statearr_15815_15907[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (18))){
var inst_15579 = (state_15727[(2)]);
var inst_15580 = fluree.db.util.async.throw_err(inst_15579);
var state_15727__$1 = state_15727;
var statearr_15816_15908 = state_15727__$1;
(statearr_15816_15908[(2)] = inst_15580);

(statearr_15816_15908[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (52))){
var inst_15710 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15817_15909 = state_15727__$1;
(statearr_15817_15909[(2)] = inst_15710);

(statearr_15817_15909[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (67))){
var inst_15693 = (state_15727[(2)]);
var inst_15694 = fluree.db.util.async.throw_err(inst_15693);
var state_15727__$1 = state_15727;
var statearr_15818_15910 = state_15727__$1;
(statearr_15818_15910[(2)] = inst_15694);

(statearr_15818_15910[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (71))){
var inst_15702 = (state_15727[(2)]);
var inst_15703 = fluree.db.util.async.throw_err(inst_15702);
var state_15727__$1 = state_15727;
var statearr_15819_15911 = state_15727__$1;
(statearr_15819_15911[(2)] = inst_15703);

(statearr_15819_15911[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (42))){
var inst_15712 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15820_15912 = state_15727__$1;
(statearr_15820_15912[(2)] = inst_15712);

(statearr_15820_15912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (37))){
var inst_15596 = (state_15727[(7)]);
var inst_15622 = cljs.core.fn_QMARK_(inst_15596);
var inst_15623 = (!(inst_15622));
var state_15727__$1 = state_15727;
var statearr_15821_15913 = state_15727__$1;
(statearr_15821_15913[(2)] = inst_15623);

(statearr_15821_15913[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (63))){
var inst_15682 = (state_15727[(2)]);
var inst_15683 = fluree.db.util.async.throw_err(inst_15682);
var state_15727__$1 = state_15727;
var statearr_15822_15914 = state_15727__$1;
(statearr_15822_15914[(2)] = inst_15683);

(statearr_15822_15914[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (8))){
var inst_15566 = (state_15727[(17)]);
var inst_15566__$1 = (state_15727[(2)]);
var state_15727__$1 = (function (){var statearr_15823 = state_15727;
(statearr_15823[(17)] = inst_15566__$1);

return statearr_15823;
})();
if(cljs.core.truth_(inst_15566__$1)){
var statearr_15824_15915 = state_15727__$1;
(statearr_15824_15915[(1)] = (9));

} else {
var statearr_15825_15916 = state_15727__$1;
(statearr_15825_15916[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (49))){
var inst_15647 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15826_15917 = state_15727__$1;
(statearr_15826_15917[(2)] = inst_15647);

(statearr_15826_15917[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15827[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15827[(1)] = (1));

return statearr_15827;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15727){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15727);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15828){var ex__2730__auto__ = e15828;
var statearr_15829_15918 = state_15727;
(statearr_15829_15918[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15727[(4)]))){
var statearr_15830_15919 = state_15727;
(statearr_15830_15919[(1)] = cljs.core.first((state_15727[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15920 = state_15727;
state_15727 = G__15920;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15727){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15831 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15831[(6)] = c__2749__auto__);

return statearr_15831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15922 = arguments.length;
switch (G__15922) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15957){
var state_val_15958 = (state_15957[(1)]);
if((state_val_15958 === (7))){
var inst_15944 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15945 = ["Invalid collection name: ",inst_15944].join('');
var inst_15946 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15947 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15948 = cljs.core.PersistentHashMap.fromArrays(inst_15946,inst_15947);
var inst_15949 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15945,inst_15948);
var inst_15950 = (function(){throw inst_15949})();
var state_15957__$1 = state_15957;
var statearr_15959_15979 = state_15957__$1;
(statearr_15959_15979[(2)] = inst_15950);

(statearr_15959_15979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15958 === (1))){
var state_15957__$1 = state_15957;
var statearr_15960_15980 = state_15957__$1;
(statearr_15960_15980[(2)] = null);

(statearr_15960_15980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15958 === (4))){
var inst_15923 = (state_15957[(2)]);
var state_15957__$1 = state_15957;
var statearr_15961_15981 = state_15957__$1;
(statearr_15961_15981[(2)] = inst_15923);

(statearr_15961_15981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15958 === (6))){
var inst_15929 = (state_15957[(7)]);
var inst_15931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15932 = fluree.db.flake.max_subject_id(inst_15929);
var inst_15933 = [inst_15932];
var inst_15934 = (new cljs.core.PersistentVector(null,1,(5),inst_15931,inst_15933,null));
var inst_15935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15936 = fluree.db.flake.min_subject_id(inst_15929);
var inst_15937 = [inst_15936];
var inst_15938 = (new cljs.core.PersistentVector(null,1,(5),inst_15935,inst_15937,null));
var inst_15939 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15934,cljs.core._LT__EQ_,inst_15938,opts);
var state_15957__$1 = state_15957;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15957__$1,(9),inst_15939);
} else {
if((state_val_15958 === (3))){
var inst_15955 = (state_15957[(2)]);
var state_15957__$1 = state_15957;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15957__$1,inst_15955);
} else {
if((state_val_15958 === (2))){
var inst_15929 = (state_15957[(7)]);
var _ = (function (){var statearr_15963 = state_15957;
(statearr_15963[(4)] = cljs.core.cons((5),(state_15957[(4)])));

return statearr_15963;
})();
var inst_15929__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15957__$1 = (function (){var statearr_15964 = state_15957;
(statearr_15964[(7)] = inst_15929__$1);

return statearr_15964;
})();
if(cljs.core.truth_(inst_15929__$1)){
var statearr_15965_15982 = state_15957__$1;
(statearr_15965_15982[(1)] = (6));

} else {
var statearr_15966_15983 = state_15957__$1;
(statearr_15966_15983[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15958 === (9))){
var inst_15941 = (state_15957[(2)]);
var inst_15942 = fluree.db.util.async.throw_err(inst_15941);
var state_15957__$1 = state_15957;
var statearr_15967_15984 = state_15957__$1;
(statearr_15967_15984[(2)] = inst_15942);

(statearr_15967_15984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15958 === (5))){
var _ = (function (){var statearr_15968 = state_15957;
(statearr_15968[(4)] = cljs.core.rest((state_15957[(4)])));

return statearr_15968;
})();
var state_15957__$1 = state_15957;
var ex15962 = (state_15957__$1[(2)]);
var statearr_15969_15985 = state_15957__$1;
(statearr_15969_15985[(5)] = ex15962);


var statearr_15970_15986 = state_15957__$1;
(statearr_15970_15986[(1)] = (4));

(statearr_15970_15986[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15958 === (8))){
var inst_15952 = (state_15957[(2)]);
var _ = (function (){var statearr_15971 = state_15957;
(statearr_15971[(4)] = cljs.core.rest((state_15957[(4)])));

return statearr_15971;
})();
var state_15957__$1 = state_15957;
var statearr_15972_15987 = state_15957__$1;
(statearr_15972_15987[(2)] = inst_15952);

(statearr_15972_15987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15973 = [null,null,null,null,null,null,null,null];
(statearr_15973[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15973[(1)] = (1));

return statearr_15973;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15957){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15957);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15974){var ex__2730__auto__ = e15974;
var statearr_15975_15988 = state_15957;
(statearr_15975_15988[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15957[(4)]))){
var statearr_15976_15989 = state_15957;
(statearr_15976_15989[(1)] = cljs.core.first((state_15957[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15990 = state_15957;
state_15957 = G__15990;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15957){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15977 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15977[(6)] = c__2749__auto__);

return statearr_15977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15994 = flakes;
var vec__15995 = G__15994;
var seq__15996 = cljs.core.seq(vec__15995);
var first__15997 = cljs.core.first(seq__15996);
var seq__15996__$1 = cljs.core.next(seq__15996);
var flake_SINGLEQUOTE_ = first__15997;
var r = seq__15996__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15994__$1 = G__15994;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16003 = G__15994__$1;
var seq__16004 = cljs.core.seq(vec__16003);
var first__16005 = cljs.core.first(seq__16004);
var seq__16004__$1 = cljs.core.next(seq__16004);
var flake_SINGLEQUOTE___$1 = first__16005;
var r__$1 = seq__16004__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o(flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e16007){var e = e16007;
return null;
}})();
var map__16006 = cmd_map;
var map__16006__$1 = cljs.core.__destructure_map(map__16006);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16006__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16006__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16006__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16006__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16006__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16006__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16008 = r__$1;
var G__16009 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15994__$1 = G__16008;
result_STAR___$1 = G__16009;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16018 = blocks;
var vec__16019 = G__16018;
var seq__16020 = cljs.core.seq(vec__16019);
var first__16021 = cljs.core.first(seq__16020);
var seq__16020__$1 = cljs.core.next(seq__16020);
var block_SINGLEQUOTE_ = first__16021;
var r = seq__16020__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16018__$1 = G__16018;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16026 = G__16018__$1;
var seq__16027 = cljs.core.seq(vec__16026);
var first__16028 = cljs.core.first(seq__16027);
var seq__16027__$1 = cljs.core.next(seq__16027);
var block_SINGLEQUOTE___$1 = first__16028;
var r__$1 = seq__16027__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16029 = block_SINGLEQUOTE___$1;
var map__16029__$1 = cljs.core.__destructure_map(map__16029);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16029__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16029__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16029__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16010_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16010_SHARP_),(2))){
return fluree.db.flake.o(p1__16010_SHARP_);
} else {
return null;
}
});})(G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16011_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16011_SHARP_),(1))){
return fluree.db.flake.o(p1__16011_SHARP_);
} else {
return null;
}
});})(G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,hash,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16012_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16012_SHARP_),(5))){
return fluree.db.flake.o(p1__16012_SHARP_);
} else {
return null;
}
});})(G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,hash,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,hash,instant,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16013_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16013_SHARP_),(7))){
return fluree.db.flake.o(p1__16013_SHARP_);
} else {
return null;
}
});})(G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,hash,instant,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16014_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__16014_SHARP_),(106));
});})(G__16018__$1,result_STAR___$1,map__16029,map__16029__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16026,seq__16027,first__16028,seq__16027__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16018,vec__16019,seq__16020,first__16021,seq__16020__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__16030 = r__$1;
var G__16031 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16018__$1 = G__16030;
result_STAR___$1 = G__16031;
continue;
}
break;
}
});
