// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27080,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27084 = k27080;
var G__27084__$1 = (((G__27084 instanceof cljs.core.Keyword))?G__27084.fqn:null);
switch (G__27084__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27080,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__27085){
var vec__27086 = p__27085;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27086,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27086,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27079){
var self__ = this;
var G__27079__$1 = this;
return (new cljs.core.RecordIter((0),G__27079__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27089 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27089(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27081,other27082){
var self__ = this;
var this27081__$1 = this;
return (((!((other27082 == null)))) && ((((this27081__$1.constructor === other27082.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.conn,other27082.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.network,other27082.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.ledger_id,other27082.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.db_name,other27082.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.update_chan,other27082.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.transact_chan,other27082.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.state,other27082.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.schema_cache,other27082.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.blank_db,other27082.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.close,other27082.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.id,other27082.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27081__$1.__extmap,other27082.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27080){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27090 = k27080;
var G__27090__$1 = (((G__27090 instanceof cljs.core.Keyword))?G__27090.fqn:null);
switch (G__27090__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27080);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27079){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27091 = cljs.core.keyword_identical_QMARK_;
var expr__27092 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27094 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27095 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27094,G__27095) : pred__27091.call(null,G__27094,G__27095));
})())){
return (new fluree.db.session.DbSession(G__27079,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27096 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27097 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27096,G__27097) : pred__27091.call(null,G__27096,G__27097));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27079,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27098 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27099 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27098,G__27099) : pred__27091.call(null,G__27098,G__27099));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27079,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27100 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27101 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27100,G__27101) : pred__27091.call(null,G__27100,G__27101));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__27079,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27102 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27103 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27102,G__27103) : pred__27091.call(null,G__27102,G__27103));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__27079,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27104 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27105 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27104,G__27105) : pred__27091.call(null,G__27104,G__27105));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__27079,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27106 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27107 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27106,G__27107) : pred__27091.call(null,G__27106,G__27107));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__27079,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27108 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27109 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27108,G__27109) : pred__27091.call(null,G__27108,G__27109));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27079,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27110 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27111 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27110,G__27111) : pred__27091.call(null,G__27110,G__27111));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27079,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27112 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27113 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27112,G__27113) : pred__27091.call(null,G__27112,G__27113));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27079,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27114 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27115 = expr__27092;
return (pred__27091.cljs$core$IFn$_invoke$arity$2 ? pred__27091.cljs$core$IFn$_invoke$arity$2(G__27114,G__27115) : pred__27091.call(null,G__27114,G__27115));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27079,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__27079),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27079){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27079,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27083){
var extmap__5385__auto__ = (function (){var G__27116 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27083,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27083)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27116);
} else {
return G__27116;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27083),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27083),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27119 = session;
var map__27119__$1 = cljs.core.__destructure_map(map__27119);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27119__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27119__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27161){
var state_val_27162 = (state_27161[(1)]);
if((state_val_27162 === (7))){
var inst_27135 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_27136 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27137 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27138 = cljs.core.PersistentHashMap.fromArrays(inst_27136,inst_27137);
var inst_27139 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27135,inst_27138);
var inst_27140 = (function(){throw inst_27139})();
var state_27161__$1 = state_27161;
var statearr_27163_27186 = state_27161__$1;
(statearr_27163_27186[(2)] = inst_27140);

(statearr_27163_27186[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (1))){
var state_27161__$1 = state_27161;
var statearr_27164_27187 = state_27161__$1;
(statearr_27164_27187[(2)] = null);

(statearr_27164_27187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (4))){
var inst_27120 = (state_27161[(2)]);
var state_27161__$1 = state_27161;
var statearr_27165_27188 = state_27161__$1;
(statearr_27165_27188[(2)] = inst_27120);

(statearr_27165_27188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (6))){
var inst_27132 = (state_27161[(7)]);
var inst_27131 = (state_27161[(2)]);
var inst_27132__$1 = fluree.db.util.async.throw_err(inst_27131);
var inst_27133 = cljs.core.empty_QMARK_(inst_27132__$1);
var state_27161__$1 = (function (){var statearr_27166 = state_27161;
(statearr_27166[(7)] = inst_27132__$1);

return statearr_27166;
})();
if(inst_27133){
var statearr_27167_27189 = state_27161__$1;
(statearr_27167_27189[(1)] = (7));

} else {
var statearr_27168_27190 = state_27161__$1;
(statearr_27168_27190[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (3))){
var inst_27159 = (state_27161[(2)]);
var state_27161__$1 = state_27161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27161__$1,inst_27159);
} else {
if((state_val_27162 === (12))){
var inst_27154 = (state_27161[(2)]);
var state_27161__$1 = state_27161;
var statearr_27169_27191 = state_27161__$1;
(statearr_27169_27191[(2)] = inst_27154);

(statearr_27169_27191[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (2))){
var _ = (function (){var statearr_27170 = state_27161;
(statearr_27170[(4)] = cljs.core.cons((5),(state_27161[(4)])));

return statearr_27170;
})();
var inst_27126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27127 = [network,ledger_id];
var inst_27128 = (new cljs.core.PersistentVector(null,2,(5),inst_27126,inst_27127,null));
var inst_27129 = fluree.db.operations.ledger_info_async(conn,inst_27128);
var state_27161__$1 = state_27161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27161__$1,(6),inst_27129);
} else {
if((state_val_27162 === (11))){
var inst_27132 = (state_27161[(7)]);
var state_27161__$1 = state_27161;
var statearr_27172_27192 = state_27161__$1;
(statearr_27172_27192[(2)] = inst_27132);

(statearr_27172_27192[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (9))){
var inst_27156 = (state_27161[(2)]);
var _ = (function (){var statearr_27173 = state_27161;
(statearr_27173[(4)] = cljs.core.rest((state_27161[(4)])));

return statearr_27173;
})();
var state_27161__$1 = state_27161;
var statearr_27174_27193 = state_27161__$1;
(statearr_27174_27193[(2)] = inst_27156);

(statearr_27174_27193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (5))){
var _ = (function (){var statearr_27175 = state_27161;
(statearr_27175[(4)] = cljs.core.rest((state_27161[(4)])));

return statearr_27175;
})();
var state_27161__$1 = state_27161;
var ex27171 = (state_27161__$1[(2)]);
var statearr_27176_27194 = state_27161__$1;
(statearr_27176_27194[(5)] = ex27171);


if((ex27171 instanceof Error)){
var statearr_27177_27195 = state_27161__$1;
(statearr_27177_27195[(1)] = (4));

(statearr_27177_27195[(5)] = null);

} else {
throw ex27171;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (10))){
var inst_27132 = (state_27161[(7)]);
var inst_27145 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27132);
var inst_27146 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27145),"."].join('');
var inst_27147 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27148 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27149 = cljs.core.PersistentHashMap.fromArrays(inst_27147,inst_27148);
var inst_27150 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27146,inst_27149);
var inst_27151 = (function(){throw inst_27150})();
var state_27161__$1 = state_27161;
var statearr_27178_27196 = state_27161__$1;
(statearr_27178_27196[(2)] = inst_27151);

(statearr_27178_27196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (8))){
var inst_27132 = (state_27161[(7)]);
var inst_27142 = fluree.db.session.ready_QMARK_(inst_27132);
var inst_27143 = (!(inst_27142));
var state_27161__$1 = state_27161;
if(inst_27143){
var statearr_27179_27197 = state_27161__$1;
(statearr_27179_27197[(1)] = (10));

} else {
var statearr_27180_27198 = state_27161__$1;
(statearr_27180_27198[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0 = (function (){
var statearr_27181 = [null,null,null,null,null,null,null,null];
(statearr_27181[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2727__auto__);

(statearr_27181[(1)] = (1));

return statearr_27181;
});
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1 = (function (state_27161){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27161);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27182){var ex__2730__auto__ = e27182;
var statearr_27183_27199 = state_27161;
(statearr_27183_27199[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27161[(4)]))){
var statearr_27184_27200 = state_27161;
(statearr_27184_27200[(1)] = cljs.core.first((state_27161[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27201 = state_27161;
state_27161 = G__27201;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__ = function(state_27161){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1.call(this,state_27161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27185 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27185[(6)] = c__2749__auto__);

return statearr_27185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__27202){
var map__27203 = p__27202;
var map__27203__$1 = cljs.core.__destructure_map(map__27203);
var blank_db = map__27203__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27203__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27203__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27278){
var state_val_27279 = (state_27278[(1)]);
if((state_val_27279 === (7))){
var inst_27221 = (state_27278[(7)]);
var inst_27220 = (state_27278[(2)]);
var inst_27221__$1 = fluree.db.util.async.throw_err(inst_27220);
var state_27278__$1 = (function (){var statearr_27280 = state_27278;
(statearr_27280[(7)] = inst_27221__$1);

return statearr_27280;
})();
if(cljs.core.truth_(inst_27221__$1)){
var statearr_27281_27316 = state_27278__$1;
(statearr_27281_27316[(1)] = (8));

} else {
var statearr_27282_27317 = state_27278__$1;
(statearr_27282_27317[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (20))){
var inst_27226 = (state_27278[(8)]);
var inst_27259 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27226)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27260 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27261 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27262 = cljs.core.PersistentHashMap.fromArrays(inst_27260,inst_27261);
var inst_27263 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27259,inst_27262);
var inst_27264 = (function(){throw inst_27263})();
var state_27278__$1 = state_27278;
var statearr_27283_27318 = state_27278__$1;
(statearr_27283_27318[(2)] = inst_27264);

(statearr_27283_27318[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (1))){
var state_27278__$1 = state_27278;
var statearr_27284_27319 = state_27278__$1;
(statearr_27284_27319[(2)] = null);

(statearr_27284_27319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (4))){
var inst_27204 = (state_27278[(2)]);
var state_27278__$1 = state_27278;
var statearr_27285_27320 = state_27278__$1;
(statearr_27285_27320[(2)] = inst_27204);

(statearr_27285_27320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (15))){
var inst_27268 = (state_27278[(2)]);
var state_27278__$1 = state_27278;
var statearr_27286_27321 = state_27278__$1;
(statearr_27286_27321[(2)] = inst_27268);

(statearr_27286_27321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (21))){
var inst_27266 = (state_27278[(2)]);
var state_27278__$1 = state_27278;
var statearr_27287_27322 = state_27278__$1;
(statearr_27287_27322[(2)] = inst_27266);

(statearr_27287_27322[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (13))){
var inst_27225 = (state_27278[(9)]);
var inst_27230 = fluree.db.query.schema.schema_map(inst_27225);
var inst_27231 = fluree.db.query.schema.setting_map(inst_27225);
var inst_27232 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_27225);
var inst_27233 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27232,cljs.core.empty);
var state_27278__$1 = (function (){var statearr_27288 = state_27278;
(statearr_27288[(10)] = inst_27233);

(statearr_27288[(11)] = inst_27231);

return statearr_27288;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27278__$1,(16),inst_27230);
} else {
if((state_val_27279 === (22))){
var inst_27226 = (state_27278[(8)]);
var inst_27254 = (state_27278[(2)]);
var inst_27255 = fluree.db.util.async.throw_err(inst_27254);
var inst_27256 = (inst_27226 + (1));
var inst_27225 = inst_27255;
var inst_27226__$1 = inst_27256;
var state_27278__$1 = (function (){var statearr_27289 = state_27278;
(statearr_27289[(8)] = inst_27226__$1);

(statearr_27289[(9)] = inst_27225);

return statearr_27289;
})();
var statearr_27290_27323 = state_27278__$1;
(statearr_27290_27323[(2)] = null);

(statearr_27290_27323[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (6))){
var inst_27213 = (state_27278[(2)]);
var inst_27214 = fluree.db.util.async.throw_err(inst_27213);
var inst_27215 = cljs.core.__destructure_map(inst_27214);
var inst_27216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27215,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27215,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_27218 = fluree.db.storage.core.reify_db(conn,network,ledger_id,blank_db,inst_27217);
var state_27278__$1 = (function (){var statearr_27291 = state_27278;
(statearr_27291[(12)] = inst_27216);

return statearr_27291;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27278__$1,(7),inst_27218);
} else {
if((state_val_27279 === (17))){
var inst_27236 = (state_27278[(13)]);
var inst_27225 = (state_27278[(9)]);
var inst_27238 = (state_27278[(2)]);
var inst_27239 = fluree.db.util.async.throw_err(inst_27238);
var inst_27240 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_27225,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27236,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27239], 0));
var state_27278__$1 = state_27278;
var statearr_27292_27324 = state_27278__$1;
(statearr_27292_27324[(2)] = inst_27240);

(statearr_27292_27324[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (3))){
var inst_27276 = (state_27278[(2)]);
var state_27278__$1 = state_27278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27278__$1,inst_27276);
} else {
if((state_val_27279 === (12))){
var inst_27270 = (state_27278[(2)]);
var state_27278__$1 = state_27278;
var statearr_27293_27325 = state_27278__$1;
(statearr_27293_27325[(2)] = inst_27270);

(statearr_27293_27325[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (2))){
var _ = (function (){var statearr_27294 = state_27278;
(statearr_27294[(4)] = cljs.core.cons((5),(state_27278[(4)])));

return statearr_27294;
})();
var inst_27211 = fluree.db.session.load_ledger_info(conn,network,ledger_id);
var state_27278__$1 = state_27278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27278__$1,(6),inst_27211);
} else {
if((state_val_27279 === (19))){
var inst_27245 = (state_27278[(14)]);
var inst_27225 = (state_27278[(9)]);
var inst_27248 = cljs.core.__destructure_map(inst_27245);
var inst_27249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27248,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27248,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27248,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27252 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27225,inst_27250,inst_27249);
var state_27278__$1 = (function (){var statearr_27295 = state_27278;
(statearr_27295[(15)] = inst_27251);

return statearr_27295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27278__$1,(22),inst_27252);
} else {
if((state_val_27279 === (11))){
var inst_27226 = (state_27278[(8)]);
var inst_27216 = (state_27278[(12)]);
var inst_27228 = (inst_27226 > inst_27216);
var state_27278__$1 = state_27278;
if(cljs.core.truth_(inst_27228)){
var statearr_27297_27326 = state_27278__$1;
(statearr_27297_27326[(1)] = (13));

} else {
var statearr_27298_27327 = state_27278__$1;
(statearr_27298_27327[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (9))){
var state_27278__$1 = state_27278;
var statearr_27299_27328 = state_27278__$1;
(statearr_27299_27328[(2)] = null);

(statearr_27299_27328[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (5))){
var _ = (function (){var statearr_27300 = state_27278;
(statearr_27300[(4)] = cljs.core.rest((state_27278[(4)])));

return statearr_27300;
})();
var state_27278__$1 = state_27278;
var ex27296 = (state_27278__$1[(2)]);
var statearr_27301_27329 = state_27278__$1;
(statearr_27301_27329[(5)] = ex27296);


if((ex27296 instanceof Error)){
var statearr_27302_27330 = state_27278__$1;
(statearr_27302_27330[(1)] = (4));

(statearr_27302_27330[(5)] = null);

} else {
throw ex27296;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (14))){
var inst_27226 = (state_27278[(8)]);
var inst_27242 = fluree.db.storage.core.read_block(conn,network,ledger_id,inst_27226);
var state_27278__$1 = state_27278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27278__$1,(18),inst_27242);
} else {
if((state_val_27279 === (16))){
var inst_27231 = (state_27278[(11)]);
var inst_27235 = (state_27278[(2)]);
var inst_27236 = fluree.db.util.async.throw_err(inst_27235);
var state_27278__$1 = (function (){var statearr_27303 = state_27278;
(statearr_27303[(13)] = inst_27236);

return statearr_27303;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27278__$1,(17),inst_27231);
} else {
if((state_val_27279 === (10))){
var inst_27273 = (state_27278[(2)]);
var _ = (function (){var statearr_27304 = state_27278;
(statearr_27304[(4)] = cljs.core.rest((state_27278[(4)])));

return statearr_27304;
})();
var state_27278__$1 = state_27278;
var statearr_27305_27331 = state_27278__$1;
(statearr_27305_27331[(2)] = inst_27273);

(statearr_27305_27331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (18))){
var inst_27245 = (state_27278[(14)]);
var inst_27244 = (state_27278[(2)]);
var inst_27245__$1 = fluree.db.util.async.throw_err(inst_27244);
var state_27278__$1 = (function (){var statearr_27306 = state_27278;
(statearr_27306[(14)] = inst_27245__$1);

return statearr_27306;
})();
if(cljs.core.truth_(inst_27245__$1)){
var statearr_27307_27332 = state_27278__$1;
(statearr_27307_27332[(1)] = (19));

} else {
var statearr_27308_27333 = state_27278__$1;
(statearr_27308_27333[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27279 === (8))){
var inst_27221 = (state_27278[(7)]);
var inst_27223 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27221);
var inst_27224 = (inst_27223 + (1));
var inst_27225 = inst_27221;
var inst_27226 = inst_27224;
var state_27278__$1 = (function (){var statearr_27309 = state_27278;
(statearr_27309[(8)] = inst_27226);

(statearr_27309[(9)] = inst_27225);

return statearr_27309;
})();
var statearr_27310_27334 = state_27278__$1;
(statearr_27310_27334[(2)] = null);

(statearr_27310_27334[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2727__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2727__auto____0 = (function (){
var statearr_27311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27311[(0)] = fluree$db$session$load_current_db_$_state_machine__2727__auto__);

(statearr_27311[(1)] = (1));

return statearr_27311;
});
var fluree$db$session$load_current_db_$_state_machine__2727__auto____1 = (function (state_27278){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27278);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27312){var ex__2730__auto__ = e27312;
var statearr_27313_27335 = state_27278;
(statearr_27313_27335[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27278[(4)]))){
var statearr_27314_27336 = state_27278;
(statearr_27314_27336[(1)] = cljs.core.first((state_27278[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27337 = state_27278;
state_27278 = G__27337;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2727__auto__ = function(state_27278){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2727__auto____1.call(this,state_27278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2727__auto____0;
fluree$db$session$load_current_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2727__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27315 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27315[(6)] = c__2749__auto__);

return statearr_27315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27338,old_db_ch,new_db_ch){
var map__27339 = p__27338;
var map__27339__$1 = cljs.core.__destructure_map(map__27339);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27339__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__27340){
var map__27341 = p__27340;
var map__27341__$1 = cljs.core.__destructure_map(map__27341);
var s = map__27341__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27341__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27342){
var map__27343 = p__27342;
var map__27343__$1 = cljs.core.__destructure_map(map__27343);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27343__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27344){
var map__27345 = p__27344;
var map__27345__$1 = cljs.core.__destructure_map(map__27345);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27345__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27345__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27345__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2749__auto___27382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27365){
var state_val_27366 = (state_27365[(1)]);
if((state_val_27366 === (1))){
var state_27365__$1 = state_27365;
var statearr_27367_27383 = state_27365__$1;
(statearr_27367_27383[(2)] = null);

(statearr_27367_27383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27366 === (2))){
var _ = (function (){var statearr_27368 = state_27365;
(statearr_27368[(4)] = cljs.core.cons((5),(state_27365[(4)])));

return statearr_27368;
})();
var inst_27355 = fluree.db.session.load_current_db(conn,blank_db);
var state_27365__$1 = state_27365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27365__$1,(6),inst_27355);
} else {
if((state_val_27366 === (3))){
var inst_27363 = (state_27365[(2)]);
var state_27365__$1 = state_27365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27365__$1,inst_27363);
} else {
if((state_val_27366 === (4))){
var inst_27346 = (state_27365[(2)]);
var inst_27347 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27348 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27346,"Error reloading db") : fluree.db.util.log.error.call(null,inst_27346,"Error reloading db"));
var inst_27349 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_27346);
var state_27365__$1 = (function (){var statearr_27370 = state_27365;
(statearr_27370[(7)] = inst_27348);

(statearr_27370[(8)] = inst_27347);

return statearr_27370;
})();
var statearr_27371_27384 = state_27365__$1;
(statearr_27371_27384[(2)] = inst_27349);

(statearr_27371_27384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27366 === (5))){
var _ = (function (){var statearr_27372 = state_27365;
(statearr_27372[(4)] = cljs.core.rest((state_27365[(4)])));

return statearr_27372;
})();
var state_27365__$1 = state_27365;
var ex27369 = (state_27365__$1[(2)]);
var statearr_27373_27385 = state_27365__$1;
(statearr_27373_27385[(5)] = ex27369);


var statearr_27374_27386 = state_27365__$1;
(statearr_27374_27386[(1)] = (4));

(statearr_27374_27386[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27366 === (6))){
var inst_27357 = (state_27365[(2)]);
var inst_27358 = fluree.db.util.async.throw_err(inst_27357);
var state_27365__$1 = state_27365;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27365__$1,(7),db_ch,inst_27358);
} else {
if((state_val_27366 === (7))){
var inst_27360 = (state_27365[(2)]);
var _ = (function (){var statearr_27375 = state_27365;
(statearr_27375[(4)] = cljs.core.rest((state_27365[(4)])));

return statearr_27375;
})();
var state_27365__$1 = state_27365;
var statearr_27376_27387 = state_27365__$1;
(statearr_27376_27387[(2)] = inst_27360);

(statearr_27376_27387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0 = (function (){
var statearr_27377 = [null,null,null,null,null,null,null,null,null];
(statearr_27377[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__);

(statearr_27377[(1)] = (1));

return statearr_27377;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1 = (function (state_27365){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27365);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27378){var ex__2730__auto__ = e27378;
var statearr_27379_27388 = state_27365;
(statearr_27379_27388[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27365[(4)]))){
var statearr_27380_27389 = state_27365;
(statearr_27380_27389[(1)] = cljs.core.first((state_27365[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27390 = state_27365;
state_27365 = G__27390;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__ = function(state_27365){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1.call(this,state_27365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27381 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27381[(6)] = c__2749__auto___27382);

return statearr_27381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27392 = arguments.length;
switch (G__27392) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27393){
var map__27394 = p__27393;
var map__27394__$1 = cljs.core.__destructure_map(map__27394);
var session = map__27394__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27394__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27395,blank_db){
var map__27396 = p__27395;
var map__27396__$1 = cljs.core.__destructure_map(map__27396);
var session = map__27396__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27396__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27396__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis()),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__2749__auto___27434 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27416){
var state_val_27417 = (state_27416[(1)]);
if((state_val_27417 === (1))){
var state_27416__$1 = state_27416;
var statearr_27418_27435 = state_27416__$1;
(statearr_27418_27435[(2)] = null);

(statearr_27418_27435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (2))){
var _ = (function (){var statearr_27419 = state_27416;
(statearr_27419[(4)] = cljs.core.cons((5),(state_27416[(4)])));

return statearr_27419;
})();
var inst_27406 = fluree.db.session.load_current_db(conn,blank_db);
var state_27416__$1 = state_27416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27416__$1,(6),inst_27406);
} else {
if((state_val_27417 === (3))){
var inst_27414 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27416__$1,inst_27414);
} else {
if((state_val_27417 === (4))){
var inst_27397 = (state_27416[(2)]);
var inst_27398 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27399 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27397,"Error loading current db") : fluree.db.util.log.error.call(null,inst_27397,"Error loading current db"));
var inst_27400 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_27397);
var state_27416__$1 = (function (){var statearr_27421 = state_27416;
(statearr_27421[(7)] = inst_27398);

(statearr_27421[(8)] = inst_27399);

return statearr_27421;
})();
var statearr_27422_27436 = state_27416__$1;
(statearr_27422_27436[(2)] = inst_27400);

(statearr_27422_27436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (5))){
var _ = (function (){var statearr_27423 = state_27416;
(statearr_27423[(4)] = cljs.core.rest((state_27416[(4)])));

return statearr_27423;
})();
var state_27416__$1 = state_27416;
var ex27420 = (state_27416__$1[(2)]);
var statearr_27424_27437 = state_27416__$1;
(statearr_27424_27437[(5)] = ex27420);


var statearr_27425_27438 = state_27416__$1;
(statearr_27425_27438[(1)] = (4));

(statearr_27425_27438[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (6))){
var inst_27408 = (state_27416[(2)]);
var inst_27409 = fluree.db.util.async.throw_err(inst_27408);
var state_27416__$1 = state_27416;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27416__$1,(7),cur_ch,inst_27409);
} else {
if((state_val_27417 === (7))){
var inst_27411 = (state_27416[(2)]);
var _ = (function (){var statearr_27426 = state_27416;
(statearr_27426[(4)] = cljs.core.rest((state_27416[(4)])));

return statearr_27426;
})();
var state_27416__$1 = state_27416;
var statearr_27427_27439 = state_27416__$1;
(statearr_27427_27439[(2)] = inst_27411);

(statearr_27427_27439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27428 = [null,null,null,null,null,null,null,null,null];
(statearr_27428[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27428[(1)] = (1));

return statearr_27428;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27416){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27416);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27429){var ex__2730__auto__ = e27429;
var statearr_27430_27440 = state_27416;
(statearr_27430_27440[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27416[(4)]))){
var statearr_27431_27441 = state_27416;
(statearr_27431_27441[(1)] = cljs.core.first((state_27416[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27442 = state_27416;
state_27416 = G__27442;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27416){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27432 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27432[(6)] = c__2749__auto___27434);

return statearr_27432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__27443 = cljs.core.get_global_hierarchy;
return (fexpr__27443.cljs$core$IFn$_invoke$arity$0 ? fexpr__27443.cljs$core$IFn$_invoke$arity$0() : fexpr__27443.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27445){
var state_val_27446 = (state_27445[(1)]);
if((state_val_27446 === (1))){
var state_27445__$1 = state_27445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27445__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27447 = [null,null,null,null,null,null,null];
(statearr_27447[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27447[(1)] = (1));

return statearr_27447;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27445){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27445);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27448){var ex__2730__auto__ = e27448;
var statearr_27449_27452 = state_27445;
(statearr_27449_27452[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27445[(4)]))){
var statearr_27450_27453 = state_27445;
(statearr_27450_27453[(1)] = cljs.core.first((state_27445[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27454 = state_27445;
state_27445 = G__27454;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27445){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27451 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27451[(6)] = c__2749__auto__);

return statearr_27451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27455){
var map__27456 = p__27455;
var map__27456__$1 = cljs.core.__destructure_map(map__27456);
var data = map__27456__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27456__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27456__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27456__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27515){
var state_val_27516 = (state_27515[(1)]);
if((state_val_27516 === (7))){
var inst_27467 = (state_27515[(7)]);
var inst_27470 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27471 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27472 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27470),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27471),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27467),". No-op."].join('');
var inst_27473 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27472) : fluree.db.util.log.info.call(null,inst_27472));
var state_27515__$1 = state_27515;
var statearr_27517_27555 = state_27515__$1;
(statearr_27517_27555[(2)] = inst_27473);

(statearr_27517_27555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (1))){
var state_27515__$1 = state_27515;
var statearr_27518_27556 = state_27515__$1;
(statearr_27518_27556[(2)] = null);

(statearr_27518_27556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (4))){
var inst_27457 = (state_27515[(2)]);
var state_27515__$1 = state_27515;
var statearr_27519_27557 = state_27515__$1;
(statearr_27519_27557[(2)] = inst_27457);

(statearr_27519_27557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (15))){
var inst_27496 = (state_27515[(2)]);
var state_27515__$1 = state_27515;
var statearr_27520_27558 = state_27515__$1;
(statearr_27520_27558[(2)] = inst_27496);

(statearr_27520_27558[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (13))){
var inst_27487 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27489 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27490 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27491 = [inst_27489,inst_27490];
var inst_27492 = (new cljs.core.PersistentVector(null,2,(5),inst_27488,inst_27491,null));
var inst_27493 = (function (){var G__27521 = inst_27487;
var G__27522 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__27523 = inst_27492;
var G__27524 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__27521,G__27522,G__27523,G__27524) : fluree.db.conn_events.process_event.call(null,G__27521,G__27522,G__27523,G__27524));
})();
var state_27515__$1 = state_27515;
var statearr_27525_27559 = state_27515__$1;
(statearr_27525_27559[(2)] = inst_27493);

(statearr_27525_27559[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (6))){
var inst_27467 = (state_27515[(7)]);
var inst_27466 = (state_27515[(8)]);
var inst_27465 = (state_27515[(2)]);
var inst_27466__$1 = fluree.db.util.async.throw_err(inst_27465);
var inst_27467__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27466__$1);
var inst_27468 = (block <= inst_27467__$1);
var state_27515__$1 = (function (){var statearr_27526 = state_27515;
(statearr_27526[(7)] = inst_27467__$1);

(statearr_27526[(8)] = inst_27466__$1);

return statearr_27526;
})();
if(cljs.core.truth_(inst_27468)){
var statearr_27527_27560 = state_27515__$1;
(statearr_27527_27560[(1)] = (7));

} else {
var statearr_27528_27561 = state_27515__$1;
(statearr_27528_27561[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (17))){
var state_27515__$1 = state_27515;
var statearr_27529_27562 = state_27515__$1;
(statearr_27529_27562[(2)] = null);

(statearr_27529_27562[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (3))){
var inst_27513 = (state_27515[(2)]);
var state_27515__$1 = state_27515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27515__$1,inst_27513);
} else {
if((state_val_27516 === (12))){
var inst_27508 = (state_27515[(2)]);
var state_27515__$1 = state_27515;
var statearr_27530_27563 = state_27515__$1;
(statearr_27530_27563[(2)] = inst_27508);

(statearr_27530_27563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (2))){
var inst_27463 = (state_27515[(9)]);
var _ = (function (){var statearr_27531 = state_27515;
(statearr_27531[(4)] = cljs.core.cons((5),(state_27515[(4)])));

return statearr_27531;
})();
var inst_27463__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_27515__$1 = (function (){var statearr_27532 = state_27515;
(statearr_27532[(9)] = inst_27463__$1);

return statearr_27532;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27515__$1,(6),inst_27463__$1);
} else {
if((state_val_27516 === (11))){
var state_27515__$1 = state_27515;
var statearr_27534_27564 = state_27515__$1;
(statearr_27534_27564[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (9))){
var inst_27510 = (state_27515[(2)]);
var _ = (function (){var statearr_27536 = state_27515;
(statearr_27536[(4)] = cljs.core.rest((state_27515[(4)])));

return statearr_27536;
})();
var state_27515__$1 = state_27515;
var statearr_27537_27565 = state_27515__$1;
(statearr_27537_27565[(2)] = inst_27510);

(statearr_27537_27565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (5))){
var _ = (function (){var statearr_27538 = state_27515;
(statearr_27538[(4)] = cljs.core.rest((state_27515[(4)])));

return statearr_27538;
})();
var state_27515__$1 = state_27515;
var ex27533 = (state_27515__$1[(2)]);
var statearr_27539_27566 = state_27515__$1;
(statearr_27539_27566[(5)] = ex27533);


if((ex27533 instanceof Error)){
var statearr_27540_27567 = state_27515__$1;
(statearr_27540_27567[(1)] = (4));

(statearr_27540_27567[(5)] = null);

} else {
throw ex27533;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (14))){
var state_27515__$1 = state_27515;
var statearr_27541_27568 = state_27515__$1;
(statearr_27541_27568[(2)] = null);

(statearr_27541_27568[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (16))){
var inst_27467 = (state_27515[(7)]);
var inst_27499 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27500 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27501 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27499),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27500),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27467),". Forcing a db reload."].join('');
var inst_27502 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27501) : fluree.db.util.log.info.call(null,inst_27501));
var inst_27503 = fluree.db.session.reload_db_BANG_(session);
var state_27515__$1 = (function (){var statearr_27542 = state_27515;
(statearr_27542[(10)] = inst_27502);

return statearr_27542;
})();
var statearr_27543_27569 = state_27515__$1;
(statearr_27543_27569[(2)] = inst_27503);

(statearr_27543_27569[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (10))){
var inst_27467 = (state_27515[(7)]);
var inst_27463 = (state_27515[(9)]);
var inst_27466 = (state_27515[(8)]);
var inst_27478 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27479 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27480 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27478),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27479),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27481 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1(inst_27480) : fluree.db.util.log.trace.call(null,inst_27480));
var inst_27482 = (function (){var current_db_ch = inst_27463;
var current_db = inst_27466;
var current_block = inst_27467;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_27483 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27482,flakes);
var inst_27484 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27466,block,inst_27483);
var inst_27485 = fluree.db.session.cas_db_BANG_(session,inst_27463,inst_27484);
var state_27515__$1 = (function (){var statearr_27544 = state_27515;
(statearr_27544[(11)] = inst_27481);

return statearr_27544;
})();
if(inst_27485){
var statearr_27545_27570 = state_27515__$1;
(statearr_27545_27570[(1)] = (13));

} else {
var statearr_27546_27571 = state_27515__$1;
(statearr_27546_27571[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (18))){
var inst_27506 = (state_27515[(2)]);
var state_27515__$1 = state_27515;
var statearr_27547_27572 = state_27515__$1;
(statearr_27547_27572[(2)] = inst_27506);

(statearr_27547_27572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27516 === (8))){
var inst_27467 = (state_27515[(7)]);
var inst_27475 = ((1) + inst_27467);
var inst_27476 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27475);
var state_27515__$1 = state_27515;
if(inst_27476){
var statearr_27548_27573 = state_27515__$1;
(statearr_27548_27573[(1)] = (10));

} else {
var statearr_27549_27574 = state_27515__$1;
(statearr_27549_27574[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27550 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27550[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27550[(1)] = (1));

return statearr_27550;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27515){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27515);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27551){var ex__2730__auto__ = e27551;
var statearr_27552_27575 = state_27515;
(statearr_27552_27575[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27515[(4)]))){
var statearr_27553_27576 = state_27515;
(statearr_27553_27576[(1)] = cljs.core.first((state_27515[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27577 = state_27515;
state_27515 = G__27577;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27515){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27554 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27554[(6)] = c__2749__auto__);

return statearr_27554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27584){
var state_val_27585 = (state_27584[(1)]);
if((state_val_27585 === (1))){
var inst_27578 = fluree.db.session.clear_db_BANG_(session);
var inst_27579 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27580 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27581 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27579),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27580)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27582 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1(inst_27581) : fluree.db.util.log.debug.call(null,inst_27581));
var state_27584__$1 = (function (){var statearr_27586 = state_27584;
(statearr_27586[(7)] = inst_27582);

(statearr_27586[(8)] = inst_27578);

return statearr_27586;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27584__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27587 = [null,null,null,null,null,null,null,null,null];
(statearr_27587[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27587[(1)] = (1));

return statearr_27587;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27584){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27584);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27588){var ex__2730__auto__ = e27588;
var statearr_27589_27592 = state_27584;
(statearr_27589_27592[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27584[(4)]))){
var statearr_27590_27593 = state_27584;
(statearr_27590_27593[(1)] = cljs.core.first((state_27584[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27594 = state_27584;
state_27584 = G__27594;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27584){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27591 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27591[(6)] = c__2749__auto__);

return statearr_27591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27596 = arguments.length;
switch (G__27596) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27597){
var map__27598 = p__27597;
var map__27598__$1 = cljs.core.__destructure_map(map__27598);
var session = map__27598__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27598__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27598__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27598__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27598__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27598__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27598__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27598__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__27599_27602 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27599_27602.cljs$core$IFn$_invoke$arity$3 ? fexpr__27599_27602.cljs$core$IFn$_invoke$arity$3(network,ledger_id,id) : fexpr__27599_27602.call(null,network,ledger_id,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,ledger_id);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__27600_27603 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__27600_27603.cljs$core$IFn$_invoke$arity$0 ? fexpr__27600_27603.cljs$core$IFn$_invoke$arity$0() : fexpr__27600_27603.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27655){
var state_val_27656 = (state_27655[(1)]);
if((state_val_27656 === (7))){
var inst_27651 = (state_27655[(2)]);
var state_27655__$1 = state_27655;
var statearr_27657_27688 = state_27655__$1;
(statearr_27657_27688[(2)] = inst_27651);

(statearr_27657_27688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (1))){
var state_27655__$1 = state_27655;
var statearr_27658_27689 = state_27655__$1;
(statearr_27658_27689[(2)] = null);

(statearr_27658_27689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (4))){
var inst_27607 = (state_27655[(7)]);
var inst_27606 = (state_27655[(2)]);
var inst_27607__$1 = fluree.db.util.async.throw_err(inst_27606);
var inst_27608 = fluree.db.session.from_cache(network,ledger_id);
var inst_27609 = (inst_27607__$1 == null);
var state_27655__$1 = (function (){var statearr_27659 = state_27655;
(statearr_27659[(8)] = inst_27608);

(statearr_27659[(7)] = inst_27607__$1);

return statearr_27659;
})();
if(cljs.core.truth_(inst_27609)){
var statearr_27660_27690 = state_27655__$1;
(statearr_27660_27690[(1)] = (5));

} else {
var statearr_27661_27691 = state_27655__$1;
(statearr_27661_27691[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (15))){
var inst_27643 = (state_27655[(2)]);
var state_27655__$1 = (function (){var statearr_27662 = state_27655;
(statearr_27662[(9)] = inst_27643);

return statearr_27662;
})();
var statearr_27663_27692 = state_27655__$1;
(statearr_27663_27692[(2)] = null);

(statearr_27663_27692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (13))){
var inst_27647 = (state_27655[(2)]);
var state_27655__$1 = state_27655;
var statearr_27665_27693 = state_27655__$1;
(statearr_27665_27693[(2)] = inst_27647);

(statearr_27665_27693[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (6))){
var inst_27608 = (state_27655[(8)]);
var inst_27614 = (inst_27608 == null);
var state_27655__$1 = state_27655;
if(cljs.core.truth_(inst_27614)){
var statearr_27666_27694 = state_27655__$1;
(statearr_27666_27694[(1)] = (8));

} else {
var statearr_27667_27695 = state_27655__$1;
(statearr_27667_27695[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (17))){
var _ = (function (){var statearr_27668 = state_27655;
(statearr_27668[(4)] = cljs.core.rest((state_27655[(4)])));

return statearr_27668;
})();
var state_27655__$1 = state_27655;
var ex27664 = (state_27655__$1[(2)]);
var statearr_27669_27696 = state_27655__$1;
(statearr_27669_27696[(5)] = ex27664);


var statearr_27670_27697 = state_27655__$1;
(statearr_27670_27697[(1)] = (16));

(statearr_27670_27697[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (3))){
var inst_27653 = (state_27655[(2)]);
var state_27655__$1 = state_27655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27655__$1,inst_27653);
} else {
if((state_val_27656 === (12))){
var state_27655__$1 = state_27655;
var statearr_27671_27698 = state_27655__$1;
(statearr_27671_27698[(2)] = null);

(statearr_27671_27698[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (2))){
var state_27655__$1 = state_27655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27655__$1,(4),update_chan);
} else {
if((state_val_27656 === (11))){
var state_27655__$1 = state_27655;
var statearr_27672_27699 = state_27655__$1;
(statearr_27672_27699[(2)] = null);

(statearr_27672_27699[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (9))){
var state_27655__$1 = state_27655;
var statearr_27673_27700 = state_27655__$1;
(statearr_27673_27700[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (5))){
var inst_27611 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27612 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Channel closed for session updates for:",inst_27611) : fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27611));
var state_27655__$1 = state_27655;
var statearr_27675_27701 = state_27655__$1;
(statearr_27675_27701[(2)] = inst_27612);

(statearr_27675_27701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (14))){
var inst_27608 = (state_27655[(8)]);
var inst_27607 = (state_27655[(7)]);
var _ = (function (){var statearr_27676 = state_27655;
(statearr_27676[(4)] = cljs.core.cons((17),(state_27655[(4)])));

return statearr_27676;
})();
var inst_27631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27607,(0),null);
var inst_27632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27607,(1),null);
var inst_27633 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27634 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27607], 0));
var inst_27635 = fluree.db.util.core.trunc(inst_27634,(200));
var inst_27636 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(inst_27633,inst_27635) : fluree.db.util.log.trace.call(null,inst_27633,inst_27635));
var inst_27637 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_27608,inst_27631,inst_27632) : fluree.db.session.process_ledger_update.call(null,inst_27608,inst_27631,inst_27632));
var state_27655__$1 = (function (){var statearr_27677 = state_27655;
(statearr_27677[(10)] = inst_27636);

return statearr_27677;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27655__$1,(18),inst_27637);
} else {
if((state_val_27656 === (16))){
var inst_27607 = (state_27655[(7)]);
var inst_27621 = (state_27655[(2)]);
var inst_27622 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_27621,"Exception processing ledger updates for message: ",inst_27607) : fluree.db.util.log.error.call(null,inst_27621,"Exception processing ledger updates for message: ",inst_27607));
var state_27655__$1 = state_27655;
var statearr_27678_27702 = state_27655__$1;
(statearr_27678_27702[(2)] = inst_27622);

(statearr_27678_27702[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (10))){
var inst_27649 = (state_27655[(2)]);
var state_27655__$1 = state_27655;
var statearr_27679_27703 = state_27655__$1;
(statearr_27679_27703[(2)] = inst_27649);

(statearr_27679_27703[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (18))){
var inst_27639 = (state_27655[(2)]);
var inst_27640 = fluree.db.util.async.throw_err(inst_27639);
var _ = (function (){var statearr_27680 = state_27655;
(statearr_27680[(4)] = cljs.core.rest((state_27655[(4)])));

return statearr_27680;
})();
var state_27655__$1 = state_27655;
var statearr_27681_27704 = state_27655__$1;
(statearr_27681_27704[(2)] = inst_27640);

(statearr_27681_27704[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27656 === (8))){
var inst_27607 = (state_27655[(7)]);
var inst_27616 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27617 = cljs.core.first(inst_27607);
var inst_27618 = (fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4("Ledger update received for session that is no longer open:",inst_27616,"Message: ",inst_27617) : fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27616,"Message: ",inst_27617));
var state_27655__$1 = state_27655;
var statearr_27682_27705 = state_27655__$1;
(statearr_27682_27705[(2)] = inst_27618);

(statearr_27682_27705[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0 = (function (){
var statearr_27683 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27683[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__);

(statearr_27683[(1)] = (1));

return statearr_27683;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1 = (function (state_27655){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27655);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27684){var ex__2730__auto__ = e27684;
var statearr_27685_27706 = state_27655;
(statearr_27685_27706[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27655[(4)]))){
var statearr_27686_27707 = state_27655;
(statearr_27686_27707[(1)] = cljs.core.first((state_27655[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27708 = state_27655;
state_27655 = G__27708;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = function(state_27655){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1.call(this,state_27655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27687 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27687[(6)] = c__2749__auto__);

return statearr_27687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27709){
var map__27710 = p__27709;
var map__27710__$1 = cljs.core.__destructure_map(map__27710);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27710__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27714 = block_result;
var map__27714__$1 = cljs.core.__destructure_map(map__27714);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27714__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27714__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27714__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27714__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27714__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__27715 = tx_result;
var map__27715__$1 = cljs.core.__destructure_map(map__27715);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27715__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27715__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__27711_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,fluree.db.flake.t(p1__27711_SHARP_));
}):(function (p1__27712_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27712_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__27713_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__27713_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27713_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27716 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27716,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27716,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27716,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27716,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var G__27719_27721 = "Create and cache session. Opt keys: ";
var G__27720_27722 = cljs.core.keys(opts);
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(G__27719_27721,G__27720_27722) : fluree.db.util.log.trace.call(null,G__27719_27721,G__27720_27722));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27724 = arguments.length;
switch (G__27724) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27725){
var map__27726 = p__27725;
var map__27726__$1 = cljs.core.__destructure_map(map__27726);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27726__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27726__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27726__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27726__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27727 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27727,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27727,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27727,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__27731_27883 = network;
var G__27732_27884 = ledger_id;
var G__27733_27885 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__27734_27886 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27735 = cljs.core.seq(tids);
var chunk__27736 = null;
var count__27737 = (0);
var i__27738 = (0);
while(true){
if((i__27738 < count__27737)){
var tid = chunk__27736.cljs$core$IIndexed$_nth$arity$2(null,i__27738);
var temp__5804__auto___27888__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___27888__$1)){
var keyed_callbacks_27889 = temp__5804__auto___27888__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27890 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27795_27891 = cljs.core.seq(keyed_callbacks_27889);
var chunk__27796_27892 = null;
var count__27797_27893 = (0);
var i__27798_27894 = (0);
while(true){
if((i__27798_27894 < count__27797_27893)){
var vec__27811_27895 = chunk__27796_27892.cljs$core$IIndexed$_nth$arity$2(null,i__27798_27894);
var k_27896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27811_27895,(0),null);
var f_27897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27811_27895,(1),null);
try{(f_27897.cljs$core$IFn$_invoke$arity$1 ? f_27897.cljs$core$IFn$_invoke$arity$1(tx_response_27890) : f_27897.call(null,tx_response_27890));
}catch (e27814){var e_27898 = e27814;
var G__27815_27899 = e_27898;
var G__27816_27900 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27815_27899,G__27816_27900) : fluree.db.util.log.error.call(null,G__27815_27899,G__27816_27900));
}

var G__27901 = seq__27795_27891;
var G__27902 = chunk__27796_27892;
var G__27903 = count__27797_27893;
var G__27904 = (i__27798_27894 + (1));
seq__27795_27891 = G__27901;
chunk__27796_27892 = G__27902;
count__27797_27893 = G__27903;
i__27798_27894 = G__27904;
continue;
} else {
var temp__5804__auto___27905__$2 = cljs.core.seq(seq__27795_27891);
if(temp__5804__auto___27905__$2){
var seq__27795_27906__$1 = temp__5804__auto___27905__$2;
if(cljs.core.chunked_seq_QMARK_(seq__27795_27906__$1)){
var c__5568__auto___27907 = cljs.core.chunk_first(seq__27795_27906__$1);
var G__27908 = cljs.core.chunk_rest(seq__27795_27906__$1);
var G__27909 = c__5568__auto___27907;
var G__27910 = cljs.core.count(c__5568__auto___27907);
var G__27911 = (0);
seq__27795_27891 = G__27908;
chunk__27796_27892 = G__27909;
count__27797_27893 = G__27910;
i__27798_27894 = G__27911;
continue;
} else {
var vec__27817_27912 = cljs.core.first(seq__27795_27906__$1);
var k_27913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27817_27912,(0),null);
var f_27914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27817_27912,(1),null);
try{(f_27914.cljs$core$IFn$_invoke$arity$1 ? f_27914.cljs$core$IFn$_invoke$arity$1(tx_response_27890) : f_27914.call(null,tx_response_27890));
}catch (e27820){var e_27915 = e27820;
var G__27821_27916 = e_27915;
var G__27822_27917 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27821_27916,G__27822_27917) : fluree.db.util.log.error.call(null,G__27821_27916,G__27822_27917));
}

var G__27918 = cljs.core.next(seq__27795_27906__$1);
var G__27919 = null;
var G__27920 = (0);
var G__27921 = (0);
seq__27795_27891 = G__27918;
chunk__27796_27892 = G__27919;
count__27797_27893 = G__27920;
i__27798_27894 = G__27921;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27922 = seq__27735;
var G__27923 = chunk__27736;
var G__27924 = count__27737;
var G__27925 = (i__27738 + (1));
seq__27735 = G__27922;
chunk__27736 = G__27923;
count__27737 = G__27924;
i__27738 = G__27925;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__27735);
if(temp__5804__auto____$1){
var seq__27735__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__27735__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__27735__$1);
var G__27926 = cljs.core.chunk_rest(seq__27735__$1);
var G__27927 = c__5568__auto__;
var G__27928 = cljs.core.count(c__5568__auto__);
var G__27929 = (0);
seq__27735 = G__27926;
chunk__27736 = G__27927;
count__27737 = G__27928;
i__27738 = G__27929;
continue;
} else {
var tid = cljs.core.first(seq__27735__$1);
var temp__5804__auto___27930__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___27930__$2)){
var keyed_callbacks_27931 = temp__5804__auto___27930__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27932 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27823_27933 = cljs.core.seq(keyed_callbacks_27931);
var chunk__27824_27934 = null;
var count__27825_27935 = (0);
var i__27826_27936 = (0);
while(true){
if((i__27826_27936 < count__27825_27935)){
var vec__27839_27937 = chunk__27824_27934.cljs$core$IIndexed$_nth$arity$2(null,i__27826_27936);
var k_27938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27839_27937,(0),null);
var f_27939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27839_27937,(1),null);
try{(f_27939.cljs$core$IFn$_invoke$arity$1 ? f_27939.cljs$core$IFn$_invoke$arity$1(tx_response_27932) : f_27939.call(null,tx_response_27932));
}catch (e27842){var e_27940 = e27842;
var G__27843_27941 = e_27940;
var G__27844_27942 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27843_27941,G__27844_27942) : fluree.db.util.log.error.call(null,G__27843_27941,G__27844_27942));
}

var G__27943 = seq__27823_27933;
var G__27944 = chunk__27824_27934;
var G__27945 = count__27825_27935;
var G__27946 = (i__27826_27936 + (1));
seq__27823_27933 = G__27943;
chunk__27824_27934 = G__27944;
count__27825_27935 = G__27945;
i__27826_27936 = G__27946;
continue;
} else {
var temp__5804__auto___27947__$3 = cljs.core.seq(seq__27823_27933);
if(temp__5804__auto___27947__$3){
var seq__27823_27948__$1 = temp__5804__auto___27947__$3;
if(cljs.core.chunked_seq_QMARK_(seq__27823_27948__$1)){
var c__5568__auto___27949 = cljs.core.chunk_first(seq__27823_27948__$1);
var G__27950 = cljs.core.chunk_rest(seq__27823_27948__$1);
var G__27951 = c__5568__auto___27949;
var G__27952 = cljs.core.count(c__5568__auto___27949);
var G__27953 = (0);
seq__27823_27933 = G__27950;
chunk__27824_27934 = G__27951;
count__27825_27935 = G__27952;
i__27826_27936 = G__27953;
continue;
} else {
var vec__27845_27954 = cljs.core.first(seq__27823_27948__$1);
var k_27955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27845_27954,(0),null);
var f_27956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27845_27954,(1),null);
try{(f_27956.cljs$core$IFn$_invoke$arity$1 ? f_27956.cljs$core$IFn$_invoke$arity$1(tx_response_27932) : f_27956.call(null,tx_response_27932));
}catch (e27848){var e_27957 = e27848;
var G__27849_27958 = e_27957;
var G__27850_27959 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27849_27958,G__27850_27959) : fluree.db.util.log.error.call(null,G__27849_27958,G__27850_27959));
}

var G__27960 = cljs.core.next(seq__27823_27948__$1);
var G__27961 = null;
var G__27962 = (0);
var G__27963 = (0);
seq__27823_27933 = G__27960;
chunk__27824_27934 = G__27961;
count__27825_27935 = G__27962;
i__27826_27936 = G__27963;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27964 = cljs.core.next(seq__27735__$1);
var G__27965 = null;
var G__27966 = (0);
var G__27967 = (0);
seq__27735 = G__27964;
chunk__27736 = G__27965;
count__27737 = G__27966;
i__27738 = G__27967;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__27730_27887 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27730_27887.cljs$core$IFn$_invoke$arity$4 ? fexpr__27730_27887.cljs$core$IFn$_invoke$arity$4(G__27731_27883,G__27732_27884,G__27733_27885,G__27734_27886) : fexpr__27730_27887.call(null,G__27731_27883,G__27732_27884,G__27733_27885,G__27734_27886));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27968 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2749__auto___27969 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27867){
var state_val_27868 = (state_27867[(1)]);
if((state_val_27868 === (1))){
var state_27867__$1 = state_27867;
var statearr_27869_27970 = state_27867__$1;
(statearr_27869_27970[(2)] = null);

(statearr_27869_27970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27868 === (2))){
var inst_27852 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27867__$1 = state_27867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27867__$1,(4),inst_27852);
} else {
if((state_val_27868 === (3))){
var inst_27865 = (state_27867[(2)]);
var state_27867__$1 = state_27867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27867__$1,inst_27865);
} else {
if((state_val_27868 === (4))){
var inst_27854 = (state_27867[(7)]);
var inst_27854__$1 = (state_27867[(2)]);
var inst_27855 = (inst_27854__$1 == null);
var state_27867__$1 = (function (){var statearr_27870 = state_27867;
(statearr_27870[(7)] = inst_27854__$1);

return statearr_27870;
})();
if(cljs.core.truth_(inst_27855)){
var statearr_27871_27971 = state_27867__$1;
(statearr_27871_27971[(1)] = (5));

} else {
var statearr_27872_27972 = state_27867__$1;
(statearr_27872_27972[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27868 === (5))){
var inst_27857 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27858 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Transactor session closing for db:",inst_27857) : fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27857));
var state_27867__$1 = state_27867;
var statearr_27873_27973 = state_27867__$1;
(statearr_27873_27973[(2)] = inst_27858);

(statearr_27873_27973[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27868 === (6))){
var inst_27854 = (state_27867[(7)]);
var inst_27860 = (transact_handler_27968.cljs$core$IFn$_invoke$arity$2 ? transact_handler_27968.cljs$core$IFn$_invoke$arity$2(conn,inst_27854) : transact_handler_27968.call(null,conn,inst_27854));
var state_27867__$1 = (function (){var statearr_27874 = state_27867;
(statearr_27874[(8)] = inst_27860);

return statearr_27874;
})();
var statearr_27875_27974 = state_27867__$1;
(statearr_27875_27974[(2)] = null);

(statearr_27875_27974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27868 === (7))){
var inst_27863 = (state_27867[(2)]);
var state_27867__$1 = state_27867;
var statearr_27876_27975 = state_27867__$1;
(statearr_27876_27975[(2)] = inst_27863);

(statearr_27876_27975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27877 = [null,null,null,null,null,null,null,null,null];
(statearr_27877[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27877[(1)] = (1));

return statearr_27877;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27867){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27867);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27878){var ex__2730__auto__ = e27878;
var statearr_27879_27976 = state_27867;
(statearr_27879_27976[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27867[(4)]))){
var statearr_27880_27977 = state_27867;
(statearr_27880_27977[(1)] = cljs.core.first((state_27867[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27978 = state_27867;
state_27867 = G__27978;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27867){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27881 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27881[(6)] = c__2749__auto___27969);

return statearr_27881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27981 = arguments.length;
switch (G__27981) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27982 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__27979_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__27979_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27982);
} else {
return G__27982;
}
})();
var seq__27983 = cljs.core.seq(sessions);
var chunk__27984 = null;
var count__27985 = (0);
var i__27986 = (0);
while(true){
if((i__27986 < count__27985)){
var session = chunk__27984.cljs$core$IIndexed$_nth$arity$2(null,i__27986);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27988 = seq__27983;
var G__27989 = chunk__27984;
var G__27990 = count__27985;
var G__27991 = (i__27986 + (1));
seq__27983 = G__27988;
chunk__27984 = G__27989;
count__27985 = G__27990;
i__27986 = G__27991;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__27983);
if(temp__5804__auto__){
var seq__27983__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27983__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__27983__$1);
var G__27992 = cljs.core.chunk_rest(seq__27983__$1);
var G__27993 = c__5568__auto__;
var G__27994 = cljs.core.count(c__5568__auto__);
var G__27995 = (0);
seq__27983 = G__27992;
chunk__27984 = G__27993;
count__27985 = G__27994;
i__27986 = G__27995;
continue;
} else {
var session = cljs.core.first(seq__27983__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27996 = cljs.core.next(seq__27983__$1);
var G__27997 = null;
var G__27998 = (0);
var G__27999 = (0);
seq__27983 = G__27996;
chunk__27984 = G__27997;
count__27985 = G__27998;
i__27986 = G__27999;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
