// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_17228 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_17228(s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_17229 = (function (s,d){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5394__auto__.call(null,s,d));
} else {
var m__5392__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5392__auto__.call(null,s,d));
} else {
throw cljs.core.missing_protocol("Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_17229(s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_17230 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_17230(s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_17231 = (function (s,k,data){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5394__auto__.call(null,s,k,data));
} else {
var m__5392__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5392__auto__.call(null,s,k,data));
} else {
throw cljs.core.missing_protocol("Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_17231(s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_17232 = (function (s,old_key,new_key){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5394__auto__.call(null,s,old_key,new_key));
} else {
var m__5392__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5392__auto__.call(null,s,old_key,new_key));
} else {
throw cljs.core.missing_protocol("Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_17232(s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_17233 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_17233(s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix(network,ldgr_id);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17255){
var state_val_17256 = (state_17255[(1)]);
if((state_val_17256 === (7))){
var inst_17244 = (state_17255[(7)]);
var inst_17246 = fluree.db.storage.core.serde(conn);
var inst_17247 = fluree.db.serde.protocol._deserialize_block(inst_17246,inst_17244);
var state_17255__$1 = state_17255;
var statearr_17257_17276 = state_17255__$1;
(statearr_17257_17276[(2)] = inst_17247);

(statearr_17257_17276[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17256 === (1))){
var state_17255__$1 = state_17255;
var statearr_17258_17277 = state_17255__$1;
(statearr_17258_17277[(2)] = null);

(statearr_17258_17277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17256 === (4))){
var inst_17234 = (state_17255[(2)]);
var state_17255__$1 = state_17255;
var statearr_17259_17278 = state_17255__$1;
(statearr_17259_17278[(2)] = inst_17234);

(statearr_17259_17278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17256 === (6))){
var inst_17244 = (state_17255[(7)]);
var inst_17243 = (state_17255[(2)]);
var inst_17244__$1 = fluree.db.util.async.throw_err(inst_17243);
var state_17255__$1 = (function (){var statearr_17260 = state_17255;
(statearr_17260[(7)] = inst_17244__$1);

return statearr_17260;
})();
if(cljs.core.truth_(inst_17244__$1)){
var statearr_17261_17279 = state_17255__$1;
(statearr_17261_17279[(1)] = (7));

} else {
var statearr_17262_17280 = state_17255__$1;
(statearr_17262_17280[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17256 === (3))){
var inst_17253 = (state_17255[(2)]);
var state_17255__$1 = state_17255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17255__$1,inst_17253);
} else {
if((state_val_17256 === (2))){
var _ = (function (){var statearr_17264 = state_17255;
(statearr_17264[(4)] = cljs.core.cons((5),(state_17255[(4)])));

return statearr_17264;
})();
var inst_17240 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17241 = fluree.db.storage.core.read(conn,inst_17240);
var state_17255__$1 = state_17255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17255__$1,(6),inst_17241);
} else {
if((state_val_17256 === (9))){
var inst_17250 = (state_17255[(2)]);
var _ = (function (){var statearr_17265 = state_17255;
(statearr_17265[(4)] = cljs.core.rest((state_17255[(4)])));

return statearr_17265;
})();
var state_17255__$1 = state_17255;
var statearr_17266_17281 = state_17255__$1;
(statearr_17266_17281[(2)] = inst_17250);

(statearr_17266_17281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17256 === (5))){
var _ = (function (){var statearr_17267 = state_17255;
(statearr_17267[(4)] = cljs.core.rest((state_17255[(4)])));

return statearr_17267;
})();
var state_17255__$1 = state_17255;
var ex17263 = (state_17255__$1[(2)]);
var statearr_17268_17282 = state_17255__$1;
(statearr_17268_17282[(5)] = ex17263);


if((ex17263 instanceof Error)){
var statearr_17269_17283 = state_17255__$1;
(statearr_17269_17283[(1)] = (4));

(statearr_17269_17283[(5)] = null);

} else {
throw ex17263;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17256 === (8))){
var state_17255__$1 = state_17255;
var statearr_17270_17284 = state_17255__$1;
(statearr_17270_17284[(2)] = null);

(statearr_17270_17284[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____0 = (function (){
var statearr_17271 = [null,null,null,null,null,null,null,null];
(statearr_17271[(0)] = fluree$db$storage$core$read_block_$_state_machine__2727__auto__);

(statearr_17271[(1)] = (1));

return statearr_17271;
});
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____1 = (function (state_17255){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17255);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17272){var ex__2730__auto__ = e17272;
var statearr_17273_17285 = state_17255;
(statearr_17273_17285[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17255[(4)]))){
var statearr_17274_17286 = state_17255;
(statearr_17274_17286[(1)] = cljs.core.first((state_17255[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17287 = state_17255;
state_17255 = G__17287;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = function(state_17255){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____1.call(this,state_17255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17275 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17275[(6)] = c__2749__auto__);

return statearr_17275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17310){
var state_val_17311 = (state_17310[(1)]);
if((state_val_17311 === (7))){
var inst_17299 = (state_17310[(7)]);
var inst_17301 = fluree.db.storage.core.serde(conn);
var inst_17302 = fluree.db.serde.protocol._deserialize_block(inst_17301,inst_17299);
var state_17310__$1 = state_17310;
var statearr_17312_17331 = state_17310__$1;
(statearr_17312_17331[(2)] = inst_17302);

(statearr_17312_17331[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17311 === (1))){
var state_17310__$1 = state_17310;
var statearr_17313_17332 = state_17310__$1;
(statearr_17313_17332[(2)] = null);

(statearr_17313_17332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17311 === (4))){
var inst_17288 = (state_17310[(2)]);
var state_17310__$1 = state_17310;
var statearr_17314_17333 = state_17310__$1;
(statearr_17314_17333[(2)] = inst_17288);

(statearr_17314_17333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17311 === (6))){
var inst_17299 = (state_17310[(7)]);
var inst_17298 = (state_17310[(2)]);
var inst_17299__$1 = fluree.db.util.async.throw_err(inst_17298);
var state_17310__$1 = (function (){var statearr_17315 = state_17310;
(statearr_17315[(7)] = inst_17299__$1);

return statearr_17315;
})();
if(cljs.core.truth_(inst_17299__$1)){
var statearr_17316_17334 = state_17310__$1;
(statearr_17316_17334[(1)] = (7));

} else {
var statearr_17317_17335 = state_17310__$1;
(statearr_17317_17335[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17311 === (3))){
var inst_17308 = (state_17310[(2)]);
var state_17310__$1 = state_17310;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17310__$1,inst_17308);
} else {
if((state_val_17311 === (2))){
var _ = (function (){var statearr_17319 = state_17310;
(statearr_17319[(4)] = cljs.core.cons((5),(state_17310[(4)])));

return statearr_17319;
})();
var inst_17294 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17295 = [inst_17294,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17296 = fluree.db.storage.core.read(conn,inst_17295);
var state_17310__$1 = state_17310;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17310__$1,(6),inst_17296);
} else {
if((state_val_17311 === (9))){
var inst_17305 = (state_17310[(2)]);
var _ = (function (){var statearr_17320 = state_17310;
(statearr_17320[(4)] = cljs.core.rest((state_17310[(4)])));

return statearr_17320;
})();
var state_17310__$1 = state_17310;
var statearr_17321_17336 = state_17310__$1;
(statearr_17321_17336[(2)] = inst_17305);

(statearr_17321_17336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17311 === (5))){
var _ = (function (){var statearr_17322 = state_17310;
(statearr_17322[(4)] = cljs.core.rest((state_17310[(4)])));

return statearr_17322;
})();
var state_17310__$1 = state_17310;
var ex17318 = (state_17310__$1[(2)]);
var statearr_17323_17337 = state_17310__$1;
(statearr_17323_17337[(5)] = ex17318);


if((ex17318 instanceof Error)){
var statearr_17324_17338 = state_17310__$1;
(statearr_17324_17338[(1)] = (4));

(statearr_17324_17338[(5)] = null);

} else {
throw ex17318;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17311 === (8))){
var state_17310__$1 = state_17310;
var statearr_17325_17339 = state_17310__$1;
(statearr_17325_17339[(2)] = null);

(statearr_17325_17339[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_17326 = [null,null,null,null,null,null,null,null];
(statearr_17326[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__);

(statearr_17326[(1)] = (1));

return statearr_17326;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1 = (function (state_17310){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17310);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17327){var ex__2730__auto__ = e17327;
var statearr_17328_17340 = state_17310;
(statearr_17328_17340[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17310[(4)]))){
var statearr_17329_17341 = state_17310;
(statearr_17329_17341[(1)] = cljs.core.first((state_17310[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17342 = state_17310;
state_17310 = G__17342;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = function(state_17310){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1.call(this,state_17310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17330 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17330[(6)] = c__2749__auto__);

return statearr_17330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17366){
var state_val_17367 = (state_17366[(1)]);
if((state_val_17367 === (1))){
var state_17366__$1 = state_17366;
var statearr_17368_17382 = state_17366__$1;
(statearr_17368_17382[(2)] = null);

(statearr_17368_17382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17367 === (2))){
var _ = (function (){var statearr_17369 = state_17366;
(statearr_17369[(4)] = cljs.core.cons((5),(state_17366[(4)])));

return statearr_17369;
})();
var inst_17349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17350 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17351 = (new cljs.core.PersistentVector(null,3,(5),inst_17349,inst_17350,null));
var inst_17352 = cljs.core.select_keys(block_data,inst_17351);
var inst_17353 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17352);
var inst_17354 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17353);
var inst_17355 = [inst_17354,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17356 = fluree.db.storage.core.serde(conn);
var inst_17357 = fluree.db.serde.protocol._serialize_block(inst_17356,inst_17352);
var inst_17358 = fluree.db.storage.core.write(conn,inst_17355,inst_17357);
var state_17366__$1 = state_17366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17366__$1,(6),inst_17358);
} else {
if((state_val_17367 === (3))){
var inst_17364 = (state_17366[(2)]);
var state_17366__$1 = state_17366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17366__$1,inst_17364);
} else {
if((state_val_17367 === (4))){
var inst_17343 = (state_17366[(2)]);
var state_17366__$1 = state_17366;
var statearr_17371_17383 = state_17366__$1;
(statearr_17371_17383[(2)] = inst_17343);

(statearr_17371_17383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17367 === (5))){
var _ = (function (){var statearr_17372 = state_17366;
(statearr_17372[(4)] = cljs.core.rest((state_17366[(4)])));

return statearr_17372;
})();
var state_17366__$1 = state_17366;
var ex17370 = (state_17366__$1[(2)]);
var statearr_17373_17384 = state_17366__$1;
(statearr_17373_17384[(5)] = ex17370);


if((ex17370 instanceof Error)){
var statearr_17374_17385 = state_17366__$1;
(statearr_17374_17385[(1)] = (4));

(statearr_17374_17385[(5)] = null);

} else {
throw ex17370;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17367 === (6))){
var inst_17360 = (state_17366[(2)]);
var inst_17361 = fluree.db.util.async.throw_err(inst_17360);
var _ = (function (){var statearr_17375 = state_17366;
(statearr_17375[(4)] = cljs.core.rest((state_17366[(4)])));

return statearr_17375;
})();
var state_17366__$1 = state_17366;
var statearr_17376_17386 = state_17366__$1;
(statearr_17376_17386[(2)] = inst_17361);

(statearr_17376_17386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_17377 = [null,null,null,null,null,null,null];
(statearr_17377[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__);

(statearr_17377[(1)] = (1));

return statearr_17377;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1 = (function (state_17366){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17366);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17378){var ex__2730__auto__ = e17378;
var statearr_17379_17387 = state_17366;
(statearr_17379_17387[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17366[(4)]))){
var statearr_17380_17388 = state_17366;
(statearr_17380_17388[(1)] = cljs.core.first((state_17366[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17389 = state_17366;
state_17366 = G__17389;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = function(state_17366){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1.call(this,state_17366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17381 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17381[(6)] = c__2749__auto__);

return statearr_17381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17412){
var state_val_17413 = (state_17412[(1)]);
if((state_val_17413 === (1))){
var state_17412__$1 = state_17412;
var statearr_17414_17428 = state_17412__$1;
(statearr_17414_17428[(2)] = null);

(statearr_17414_17428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17413 === (2))){
var _ = (function (){var statearr_17415 = state_17412;
(statearr_17415[(4)] = cljs.core.cons((5),(state_17412[(4)])));

return statearr_17415;
})();
var inst_17396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17397 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17398 = (new cljs.core.PersistentVector(null,3,(5),inst_17396,inst_17397,null));
var inst_17399 = cljs.core.select_keys(block_data,inst_17398);
var inst_17400 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17399);
var inst_17401 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17400);
var inst_17402 = fluree.db.storage.core.serde(conn);
var inst_17403 = fluree.db.serde.protocol._serialize_block(inst_17402,inst_17399);
var inst_17404 = fluree.db.storage.core.write(conn,inst_17401,inst_17403);
var state_17412__$1 = state_17412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17412__$1,(6),inst_17404);
} else {
if((state_val_17413 === (3))){
var inst_17410 = (state_17412[(2)]);
var state_17412__$1 = state_17412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17412__$1,inst_17410);
} else {
if((state_val_17413 === (4))){
var inst_17390 = (state_17412[(2)]);
var state_17412__$1 = state_17412;
var statearr_17417_17429 = state_17412__$1;
(statearr_17417_17429[(2)] = inst_17390);

(statearr_17417_17429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17413 === (5))){
var _ = (function (){var statearr_17418 = state_17412;
(statearr_17418[(4)] = cljs.core.rest((state_17412[(4)])));

return statearr_17418;
})();
var state_17412__$1 = state_17412;
var ex17416 = (state_17412__$1[(2)]);
var statearr_17419_17430 = state_17412__$1;
(statearr_17419_17430[(5)] = ex17416);


if((ex17416 instanceof Error)){
var statearr_17420_17431 = state_17412__$1;
(statearr_17420_17431[(1)] = (4));

(statearr_17420_17431[(5)] = null);

} else {
throw ex17416;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17413 === (6))){
var inst_17406 = (state_17412[(2)]);
var inst_17407 = fluree.db.util.async.throw_err(inst_17406);
var _ = (function (){var statearr_17421 = state_17412;
(statearr_17421[(4)] = cljs.core.rest((state_17412[(4)])));

return statearr_17421;
})();
var state_17412__$1 = state_17412;
var statearr_17422_17432 = state_17412__$1;
(statearr_17422_17432[(2)] = inst_17407);

(statearr_17422_17432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____0 = (function (){
var statearr_17423 = [null,null,null,null,null,null,null];
(statearr_17423[(0)] = fluree$db$storage$core$write_block_$_state_machine__2727__auto__);

(statearr_17423[(1)] = (1));

return statearr_17423;
});
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____1 = (function (state_17412){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17412);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17424){var ex__2730__auto__ = e17424;
var statearr_17425_17433 = state_17412;
(statearr_17425_17433[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17412[(4)]))){
var statearr_17426_17434 = state_17412;
(statearr_17426_17434[(1)] = cljs.core.first((state_17412[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17435 = state_17412;
state_17412 = G__17435;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = function(state_17412){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____1.call(this,state_17412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17427 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17427[(6)] = c__2749__auto__);

return statearr_17427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__17437 = arguments.length;
switch (G__17437) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__17438){
var map__17439 = p__17438;
var map__17439__$1 = cljs.core.__destructure_map(map__17439);
var leaf = map__17439__$1;
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17439__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17460){
var state_val_17461 = (state_17460[(1)]);
if((state_val_17461 === (1))){
var state_17460__$1 = state_17460;
var statearr_17462_17478 = state_17460__$1;
(statearr_17462_17478[(2)] = null);

(statearr_17462_17478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17461 === (2))){
var _ = (function (){var statearr_17463 = state_17460;
(statearr_17463[(4)] = cljs.core.cons((5),(state_17460[(4)])));

return statearr_17463;
})();
var inst_17446 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17447 = [flakes];
var inst_17448 = cljs.core.PersistentHashMap.fromArrays(inst_17446,inst_17447);
var inst_17449 = fluree.db.storage.core.serde(conn);
var inst_17450 = fluree.db.serde.protocol._serialize_leaf(inst_17449,inst_17448);
var inst_17451 = fluree.db.storage.core.write(conn,leaf_id,inst_17450);
var state_17460__$1 = state_17460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17460__$1,(6),inst_17451);
} else {
if((state_val_17461 === (3))){
var inst_17458 = (state_17460[(2)]);
var state_17460__$1 = state_17460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17460__$1,inst_17458);
} else {
if((state_val_17461 === (4))){
var inst_17440 = (state_17460[(2)]);
var state_17460__$1 = state_17460;
var statearr_17465_17479 = state_17460__$1;
(statearr_17465_17479[(2)] = inst_17440);

(statearr_17465_17479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17461 === (5))){
var _ = (function (){var statearr_17466 = state_17460;
(statearr_17466[(4)] = cljs.core.rest((state_17460[(4)])));

return statearr_17466;
})();
var state_17460__$1 = state_17460;
var ex17464 = (state_17460__$1[(2)]);
var statearr_17467_17480 = state_17460__$1;
(statearr_17467_17480[(5)] = ex17464);


if((ex17464 instanceof Error)){
var statearr_17468_17481 = state_17460__$1;
(statearr_17468_17481[(1)] = (4));

(statearr_17468_17481[(5)] = null);

} else {
throw ex17464;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17461 === (6))){
var inst_17453 = (state_17460[(2)]);
var inst_17454 = fluree.db.util.async.throw_err(inst_17453);
var inst_17455 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_17469 = state_17460;
(statearr_17469[(4)] = cljs.core.rest((state_17460[(4)])));

return statearr_17469;
})();
var state_17460__$1 = (function (){var statearr_17470 = state_17460;
(statearr_17470[(7)] = inst_17454);

return statearr_17470;
})();
var statearr_17471_17482 = state_17460__$1;
(statearr_17471_17482[(2)] = inst_17455);

(statearr_17471_17482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17472 = [null,null,null,null,null,null,null,null];
(statearr_17472[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17472[(1)] = (1));

return statearr_17472;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17460){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17460);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17473){var ex__2730__auto__ = e17473;
var statearr_17474_17483 = state_17460;
(statearr_17474_17483[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17460[(4)]))){
var statearr_17475_17484 = state_17460;
(statearr_17475_17484[(1)] = cljs.core.first((state_17460[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17485 = state_17460;
state_17460 = G__17485;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17460){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17476 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17476[(6)] = c__2749__auto__);

return statearr_17476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17502){
var state_val_17503 = (state_17502[(1)]);
if((state_val_17503 === (1))){
var state_17502__$1 = state_17502;
var statearr_17504_17519 = state_17502__$1;
(statearr_17504_17519[(2)] = null);

(statearr_17504_17519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17503 === (2))){
var _ = (function (){var statearr_17505 = state_17502;
(statearr_17505[(4)] = cljs.core.cons((5),(state_17502[(4)])));

return statearr_17505;
})();
var inst_17492 = fluree.db.storage.core.serde(conn);
var inst_17493 = fluree.db.serde.protocol._serialize_branch(inst_17492,data);
var inst_17494 = fluree.db.storage.core.write(conn,key,inst_17493);
var state_17502__$1 = state_17502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17502__$1,(6),inst_17494);
} else {
if((state_val_17503 === (3))){
var inst_17500 = (state_17502[(2)]);
var state_17502__$1 = state_17502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17502__$1,inst_17500);
} else {
if((state_val_17503 === (4))){
var inst_17486 = (state_17502[(2)]);
var state_17502__$1 = state_17502;
var statearr_17507_17520 = state_17502__$1;
(statearr_17507_17520[(2)] = inst_17486);

(statearr_17507_17520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17503 === (5))){
var _ = (function (){var statearr_17508 = state_17502;
(statearr_17508[(4)] = cljs.core.rest((state_17502[(4)])));

return statearr_17508;
})();
var state_17502__$1 = state_17502;
var ex17506 = (state_17502__$1[(2)]);
var statearr_17509_17521 = state_17502__$1;
(statearr_17509_17521[(5)] = ex17506);


if((ex17506 instanceof Error)){
var statearr_17510_17522 = state_17502__$1;
(statearr_17510_17522[(1)] = (4));

(statearr_17510_17522[(5)] = null);

} else {
throw ex17506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17503 === (6))){
var inst_17496 = (state_17502[(2)]);
var inst_17497 = fluree.db.util.async.throw_err(inst_17496);
var _ = (function (){var statearr_17511 = state_17502;
(statearr_17511[(4)] = cljs.core.rest((state_17502[(4)])));

return statearr_17511;
})();
var state_17502__$1 = (function (){var statearr_17512 = state_17502;
(statearr_17512[(7)] = inst_17497);

return statearr_17512;
})();
var statearr_17513_17523 = state_17502__$1;
(statearr_17513_17523[(2)] = key);

(statearr_17513_17523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0 = (function (){
var statearr_17514 = [null,null,null,null,null,null,null,null];
(statearr_17514[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__);

(statearr_17514[(1)] = (1));

return statearr_17514;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1 = (function (state_17502){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17502);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17515){var ex__2730__auto__ = e17515;
var statearr_17516_17524 = state_17502;
(statearr_17516_17524[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17502[(4)]))){
var statearr_17517_17525 = state_17502;
(statearr_17517_17525[(1)] = cljs.core.first((state_17502[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17526 = state_17502;
state_17502 = G__17526;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = function(state_17502){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1.call(this,state_17502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17518 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17518[(6)] = c__2749__auto__);

return statearr_17518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__17528 = arguments.length;
switch (G__17528) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__17529){
var map__17530 = p__17529;
var map__17530__$1 = cljs.core.__destructure_map(map__17530);
var branch = map__17530__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17530__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17556){
var state_val_17557 = (state_17556[(1)]);
if((state_val_17557 === (1))){
var state_17556__$1 = state_17556;
var statearr_17558_17575 = state_17556__$1;
(statearr_17558_17575[(2)] = null);

(statearr_17558_17575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17557 === (2))){
var _ = (function (){var statearr_17559 = state_17556;
(statearr_17559[(4)] = cljs.core.cons((5),(state_17556[(4)])));

return statearr_17559;
})();
var inst_17537 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.val,children);
var inst_17538 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.storage.core.child_data,inst_17537);
var inst_17539 = cljs.core.first(inst_17538);
var inst_17540 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_17539);
var inst_17541 = cljs.core.rseq(inst_17538);
var inst_17542 = cljs.core.first(inst_17541);
var inst_17543 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_17542);
var inst_17544 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_17545 = [inst_17538];
var inst_17546 = cljs.core.PersistentHashMap.fromArrays(inst_17544,inst_17545);
var inst_17547 = fluree.db.storage.core.write_branch_data(conn,branch_id,inst_17546);
var state_17556__$1 = (function (){var statearr_17560 = state_17556;
(statearr_17560[(7)] = inst_17540);

(statearr_17560[(8)] = inst_17543);

return statearr_17560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17556__$1,(6),inst_17547);
} else {
if((state_val_17557 === (3))){
var inst_17554 = (state_17556[(2)]);
var state_17556__$1 = state_17556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17556__$1,inst_17554);
} else {
if((state_val_17557 === (4))){
var inst_17531 = (state_17556[(2)]);
var state_17556__$1 = state_17556;
var statearr_17562_17576 = state_17556__$1;
(statearr_17562_17576[(2)] = inst_17531);

(statearr_17562_17576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17557 === (5))){
var _ = (function (){var statearr_17563 = state_17556;
(statearr_17563[(4)] = cljs.core.rest((state_17556[(4)])));

return statearr_17563;
})();
var state_17556__$1 = state_17556;
var ex17561 = (state_17556__$1[(2)]);
var statearr_17564_17577 = state_17556__$1;
(statearr_17564_17577[(5)] = ex17561);


if((ex17561 instanceof Error)){
var statearr_17565_17578 = state_17556__$1;
(statearr_17565_17578[(1)] = (4));

(statearr_17565_17578[(5)] = null);

} else {
throw ex17561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17557 === (6))){
var inst_17549 = (state_17556[(2)]);
var inst_17550 = fluree.db.util.async.throw_err(inst_17549);
var inst_17551 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_17566 = state_17556;
(statearr_17566[(4)] = cljs.core.rest((state_17556[(4)])));

return statearr_17566;
})();
var state_17556__$1 = (function (){var statearr_17567 = state_17556;
(statearr_17567[(9)] = inst_17550);

return statearr_17567;
})();
var statearr_17568_17579 = state_17556__$1;
(statearr_17568_17579[(2)] = inst_17551);

(statearr_17568_17579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17569 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17569[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17569[(1)] = (1));

return statearr_17569;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17556){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17556);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17570){var ex__2730__auto__ = e17570;
var statearr_17571_17580 = state_17556;
(statearr_17571_17580[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17556[(4)]))){
var statearr_17572_17581 = state_17556;
(statearr_17572_17581[(1)] = cljs.core.first((state_17556[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17582 = state_17556;
state_17556 = G__17582;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17556){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17573 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17573[(6)] = c__2749__auto__);

return statearr_17573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17610){
var state_val_17611 = (state_17610[(1)]);
if((state_val_17611 === (1))){
var state_17610__$1 = state_17610;
var statearr_17612_17628 = state_17610__$1;
(statearr_17612_17628[(2)] = null);

(statearr_17612_17628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (2))){
var inst_17596 = (state_17610[(7)]);
var _ = (function (){var statearr_17613 = state_17610;
(statearr_17613[(4)] = cljs.core.cons((5),(state_17610[(4)])));

return statearr_17613;
})();
var inst_17590 = db;
var inst_17591 = cljs.core.__destructure_map(inst_17590);
var inst_17592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17591,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17593 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17591,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17591,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17591,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17596__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17593,inst_17594,inst_17595);
var inst_17597 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17598 = [inst_17594,inst_17595,garbage];
var inst_17599 = cljs.core.PersistentHashMap.fromArrays(inst_17597,inst_17598);
var inst_17600 = fluree.db.storage.core.serde(inst_17592);
var inst_17601 = fluree.db.serde.protocol._serialize_garbage(inst_17600,inst_17599);
var inst_17602 = fluree.db.storage.core.write(inst_17592,inst_17596__$1,inst_17601);
var state_17610__$1 = (function (){var statearr_17614 = state_17610;
(statearr_17614[(7)] = inst_17596__$1);

return statearr_17614;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17610__$1,(6),inst_17602);
} else {
if((state_val_17611 === (3))){
var inst_17608 = (state_17610[(2)]);
var state_17610__$1 = state_17610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17610__$1,inst_17608);
} else {
if((state_val_17611 === (4))){
var inst_17583 = (state_17610[(2)]);
var state_17610__$1 = state_17610;
var statearr_17616_17629 = state_17610__$1;
(statearr_17616_17629[(2)] = inst_17583);

(statearr_17616_17629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (5))){
var _ = (function (){var statearr_17617 = state_17610;
(statearr_17617[(4)] = cljs.core.rest((state_17610[(4)])));

return statearr_17617;
})();
var state_17610__$1 = state_17610;
var ex17615 = (state_17610__$1[(2)]);
var statearr_17618_17630 = state_17610__$1;
(statearr_17618_17630[(5)] = ex17615);


if((ex17615 instanceof Error)){
var statearr_17619_17631 = state_17610__$1;
(statearr_17619_17631[(1)] = (4));

(statearr_17619_17631[(5)] = null);

} else {
throw ex17615;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (6))){
var inst_17596 = (state_17610[(7)]);
var inst_17604 = (state_17610[(2)]);
var inst_17605 = fluree.db.util.async.throw_err(inst_17604);
var _ = (function (){var statearr_17620 = state_17610;
(statearr_17620[(4)] = cljs.core.rest((state_17610[(4)])));

return statearr_17620;
})();
var state_17610__$1 = (function (){var statearr_17621 = state_17610;
(statearr_17621[(8)] = inst_17605);

return statearr_17621;
})();
var statearr_17622_17632 = state_17610__$1;
(statearr_17622_17632[(2)] = inst_17596);

(statearr_17622_17632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_17623 = [null,null,null,null,null,null,null,null,null];
(statearr_17623[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__);

(statearr_17623[(1)] = (1));

return statearr_17623;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1 = (function (state_17610){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17610);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17624){var ex__2730__auto__ = e17624;
var statearr_17625_17633 = state_17610;
(statearr_17625_17633[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17610[(4)]))){
var statearr_17626_17634 = state_17610;
(statearr_17626_17634[(1)] = cljs.core.first((state_17610[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17635 = state_17610;
state_17610 = G__17635;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = function(state_17610){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1.call(this,state_17610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17627 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17627[(6)] = c__2749__auto__);

return statearr_17627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17637 = arguments.length;
switch (G__17637) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17695){
var state_val_17696 = (state_17695[(1)]);
if((state_val_17696 === (7))){
var state_17695__$1 = state_17695;
var statearr_17697_17723 = state_17695__$1;
(statearr_17697_17723[(2)] = (0));

(statearr_17697_17723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (1))){
var state_17695__$1 = state_17695;
var statearr_17698_17724 = state_17695__$1;
(statearr_17698_17724[(2)] = null);

(statearr_17698_17724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (4))){
var inst_17638 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
var statearr_17699_17725 = state_17695__$1;
(statearr_17699_17725[(2)] = inst_17638);

(statearr_17699_17725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (6))){
var inst_17664 = (state_17695[(7)]);
var state_17695__$1 = state_17695;
var statearr_17700_17726 = state_17695__$1;
(statearr_17700_17726[(2)] = inst_17664);

(statearr_17700_17726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (3))){
var inst_17693 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17695__$1,inst_17693);
} else {
if((state_val_17696 === (12))){
var inst_17661 = (state_17695[(8)]);
var inst_17689 = (state_17695[(2)]);
var inst_17690 = fluree.db.util.async.throw_err(inst_17689);
var _ = (function (){var statearr_17701 = state_17695;
(statearr_17701[(4)] = cljs.core.rest((state_17695[(4)])));

return statearr_17701;
})();
var state_17695__$1 = (function (){var statearr_17702 = state_17695;
(statearr_17702[(9)] = inst_17690);

return statearr_17702;
})();
var statearr_17703_17727 = state_17695__$1;
(statearr_17703_17727[(2)] = inst_17661);

(statearr_17703_17727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (2))){
var inst_17653 = (state_17695[(10)]);
var inst_17651 = (state_17695[(11)]);
var inst_17656 = (state_17695[(12)]);
var inst_17664 = (state_17695[(7)]);
var _ = (function (){var statearr_17704 = state_17695;
(statearr_17704[(4)] = cljs.core.cons((5),(state_17695[(4)])));

return statearr_17704;
})();
var inst_17645 = db;
var inst_17646 = cljs.core.__destructure_map(inst_17645);
var inst_17647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17651__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17653__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_17656__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17646,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17661 = fluree.db.storage.core.ledger_root_key(inst_17647,inst_17656__$1,inst_17653__$1);
var inst_17662 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17663 = fluree.db.storage.core.child_data(inst_17654);
var inst_17664__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17651__$1);
var state_17695__$1 = (function (){var statearr_17705 = state_17695;
(statearr_17705[(10)] = inst_17653__$1);

(statearr_17705[(13)] = inst_17659);

(statearr_17705[(8)] = inst_17661);

(statearr_17705[(14)] = inst_17658);

(statearr_17705[(11)] = inst_17651__$1);

(statearr_17705[(12)] = inst_17656__$1);

(statearr_17705[(15)] = inst_17650);

(statearr_17705[(16)] = inst_17657);

(statearr_17705[(17)] = inst_17662);

(statearr_17705[(7)] = inst_17664__$1);

(statearr_17705[(18)] = inst_17660);

(statearr_17705[(19)] = inst_17655);

(statearr_17705[(20)] = inst_17663);

(statearr_17705[(21)] = inst_17648);

(statearr_17705[(22)] = inst_17649);

(statearr_17705[(23)] = inst_17652);

return statearr_17705;
})();
if(cljs.core.truth_(inst_17664__$1)){
var statearr_17706_17728 = state_17695__$1;
(statearr_17706_17728[(1)] = (6));

} else {
var statearr_17707_17729 = state_17695__$1;
(statearr_17707_17729[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (11))){
var inst_17653 = (state_17695[(10)]);
var inst_17659 = (state_17695[(13)]);
var inst_17661 = (state_17695[(8)]);
var inst_17658 = (state_17695[(14)]);
var inst_17651 = (state_17695[(11)]);
var inst_17656 = (state_17695[(12)]);
var inst_17650 = (state_17695[(15)]);
var inst_17662 = (state_17695[(17)]);
var inst_17660 = (state_17695[(18)]);
var inst_17663 = (state_17695[(20)]);
var inst_17648 = (state_17695[(21)]);
var inst_17649 = (state_17695[(22)]);
var inst_17652 = (state_17695[(23)]);
var inst_17669 = (state_17695[(24)]);
var inst_17668 = (state_17695[(25)]);
var inst_17674 = (state_17695[(2)]);
var inst_17675 = fluree.db.storage.core.child_data(inst_17658);
var inst_17676 = fluree.db.storage.core.child_data(inst_17660);
var inst_17677 = fluree.db.util.core.current_time_millis();
var inst_17678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17679 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17680 = (new cljs.core.PersistentVector(null,2,(5),inst_17678,inst_17679,null));
var inst_17681 = cljs.core.select_keys(inst_17651,inst_17680);
var inst_17682 = fluree.db.storage.core.child_data(inst_17650);
var inst_17683 = [inst_17653,inst_17663,inst_17668,inst_17656,inst_17669,inst_17674,inst_17675,inst_17676,inst_17648,inst_17677,inst_17649,inst_17659,inst_17681,inst_17682];
var inst_17684 = cljs.core.PersistentHashMap.fromArrays(inst_17662,inst_17683);
var inst_17685 = fluree.db.storage.core.serde(inst_17652);
var inst_17686 = fluree.db.serde.protocol._serialize_db_root(inst_17685,inst_17684);
var inst_17687 = fluree.db.storage.core.write(inst_17652,inst_17661,inst_17686);
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17695__$1,(12),inst_17687);
} else {
if((state_val_17696 === (9))){
var inst_17670 = (state_17695[(26)]);
var state_17695__$1 = state_17695;
var statearr_17709_17730 = state_17695__$1;
(statearr_17709_17730[(2)] = inst_17670);

(statearr_17709_17730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (5))){
var _ = (function (){var statearr_17710 = state_17695;
(statearr_17710[(4)] = cljs.core.rest((state_17695[(4)])));

return statearr_17710;
})();
var state_17695__$1 = state_17695;
var ex17708 = (state_17695__$1[(2)]);
var statearr_17711_17731 = state_17695__$1;
(statearr_17711_17731[(5)] = ex17708);


if((ex17708 instanceof Error)){
var statearr_17712_17732 = state_17695__$1;
(statearr_17712_17732[(1)] = (4));

(statearr_17712_17732[(5)] = null);

} else {
throw ex17708;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (10))){
var inst_17657 = (state_17695[(16)]);
var state_17695__$1 = state_17695;
var statearr_17713_17733 = state_17695__$1;
(statearr_17713_17733[(2)] = inst_17657);

(statearr_17713_17733[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (8))){
var inst_17670 = (state_17695[(26)]);
var inst_17655 = (state_17695[(19)]);
var inst_17668 = (state_17695[(2)]);
var inst_17669 = fluree.db.storage.core.child_data(inst_17655);
var inst_17670__$1 = custom_ecount;
var state_17695__$1 = (function (){var statearr_17714 = state_17695;
(statearr_17714[(26)] = inst_17670__$1);

(statearr_17714[(24)] = inst_17669);

(statearr_17714[(25)] = inst_17668);

return statearr_17714;
})();
if(cljs.core.truth_(inst_17670__$1)){
var statearr_17715_17734 = state_17695__$1;
(statearr_17715_17734[(1)] = (9));

} else {
var statearr_17716_17735 = state_17695__$1;
(statearr_17716_17735[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17717[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17717[(1)] = (1));

return statearr_17717;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17695){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17695);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17718){var ex__2730__auto__ = e17718;
var statearr_17719_17736 = state_17695;
(statearr_17719_17736[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17695[(4)]))){
var statearr_17720_17737 = state_17695;
(statearr_17720_17737[(1)] = cljs.core.first((state_17695[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17738 = state_17695;
state_17695 = G__17738;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17695){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17721 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17721[(6)] = c__2749__auto__);

return statearr_17721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__17739,key){
var map__17740 = p__17739;
var map__17740__$1 = cljs.core.__destructure_map(map__17740);
var conn = map__17740__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17740__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17760){
var state_val_17761 = (state_17760[(1)]);
if((state_val_17761 === (7))){
var inst_17750 = (state_17760[(7)]);
var inst_17752 = fluree.db.serde.protocol._deserialize_branch(serializer,inst_17750);
var state_17760__$1 = state_17760;
var statearr_17762_17781 = state_17760__$1;
(statearr_17762_17781[(2)] = inst_17752);

(statearr_17762_17781[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (1))){
var state_17760__$1 = state_17760;
var statearr_17763_17782 = state_17760__$1;
(statearr_17763_17782[(2)] = null);

(statearr_17763_17782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (4))){
var inst_17741 = (state_17760[(2)]);
var state_17760__$1 = state_17760;
var statearr_17764_17783 = state_17760__$1;
(statearr_17764_17783[(2)] = inst_17741);

(statearr_17764_17783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (6))){
var inst_17750 = (state_17760[(7)]);
var inst_17749 = (state_17760[(2)]);
var inst_17750__$1 = fluree.db.util.async.throw_err(inst_17749);
var state_17760__$1 = (function (){var statearr_17765 = state_17760;
(statearr_17765[(7)] = inst_17750__$1);

return statearr_17765;
})();
if(cljs.core.truth_(inst_17750__$1)){
var statearr_17766_17784 = state_17760__$1;
(statearr_17766_17784[(1)] = (7));

} else {
var statearr_17767_17785 = state_17760__$1;
(statearr_17767_17785[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (3))){
var inst_17758 = (state_17760[(2)]);
var state_17760__$1 = state_17760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17760__$1,inst_17758);
} else {
if((state_val_17761 === (2))){
var _ = (function (){var statearr_17769 = state_17760;
(statearr_17769[(4)] = cljs.core.cons((5),(state_17760[(4)])));

return statearr_17769;
})();
var inst_17747 = fluree.db.storage.core.read(conn,key);
var state_17760__$1 = state_17760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17760__$1,(6),inst_17747);
} else {
if((state_val_17761 === (9))){
var inst_17755 = (state_17760[(2)]);
var _ = (function (){var statearr_17770 = state_17760;
(statearr_17770[(4)] = cljs.core.rest((state_17760[(4)])));

return statearr_17770;
})();
var state_17760__$1 = state_17760;
var statearr_17771_17786 = state_17760__$1;
(statearr_17771_17786[(2)] = inst_17755);

(statearr_17771_17786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (5))){
var _ = (function (){var statearr_17772 = state_17760;
(statearr_17772[(4)] = cljs.core.rest((state_17760[(4)])));

return statearr_17772;
})();
var state_17760__$1 = state_17760;
var ex17768 = (state_17760__$1[(2)]);
var statearr_17773_17787 = state_17760__$1;
(statearr_17773_17787[(5)] = ex17768);


if((ex17768 instanceof Error)){
var statearr_17774_17788 = state_17760__$1;
(statearr_17774_17788[(1)] = (4));

(statearr_17774_17788[(5)] = null);

} else {
throw ex17768;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (8))){
var state_17760__$1 = state_17760;
var statearr_17775_17789 = state_17760__$1;
(statearr_17775_17789[(2)] = null);

(statearr_17775_17789[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_17776 = [null,null,null,null,null,null,null,null];
(statearr_17776[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2727__auto__);

(statearr_17776[(1)] = (1));

return statearr_17776;
});
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1 = (function (state_17760){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17760);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17777){var ex__2730__auto__ = e17777;
var statearr_17778_17790 = state_17760;
(statearr_17778_17790[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17760[(4)]))){
var statearr_17779_17791 = state_17760;
(statearr_17779_17791[(1)] = cljs.core.first((state_17760[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17792 = state_17760;
state_17760 = G__17792;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = function(state_17760){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1.call(this,state_17760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17780 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17780[(6)] = c__2749__auto__);

return statearr_17780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17793,key){
var map__17794 = p__17793;
var map__17794__$1 = cljs.core.__destructure_map(map__17794);
var conn = map__17794__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17794__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17814){
var state_val_17815 = (state_17814[(1)]);
if((state_val_17815 === (7))){
var inst_17804 = (state_17814[(7)]);
var inst_17806 = fluree.db.serde.protocol._deserialize_leaf(serializer,inst_17804);
var state_17814__$1 = state_17814;
var statearr_17816_17835 = state_17814__$1;
(statearr_17816_17835[(2)] = inst_17806);

(statearr_17816_17835[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17815 === (1))){
var state_17814__$1 = state_17814;
var statearr_17817_17836 = state_17814__$1;
(statearr_17817_17836[(2)] = null);

(statearr_17817_17836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17815 === (4))){
var inst_17795 = (state_17814[(2)]);
var state_17814__$1 = state_17814;
var statearr_17818_17837 = state_17814__$1;
(statearr_17818_17837[(2)] = inst_17795);

(statearr_17818_17837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17815 === (6))){
var inst_17804 = (state_17814[(7)]);
var inst_17803 = (state_17814[(2)]);
var inst_17804__$1 = fluree.db.util.async.throw_err(inst_17803);
var state_17814__$1 = (function (){var statearr_17819 = state_17814;
(statearr_17819[(7)] = inst_17804__$1);

return statearr_17819;
})();
if(cljs.core.truth_(inst_17804__$1)){
var statearr_17820_17838 = state_17814__$1;
(statearr_17820_17838[(1)] = (7));

} else {
var statearr_17821_17839 = state_17814__$1;
(statearr_17821_17839[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17815 === (3))){
var inst_17812 = (state_17814[(2)]);
var state_17814__$1 = state_17814;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17814__$1,inst_17812);
} else {
if((state_val_17815 === (2))){
var _ = (function (){var statearr_17823 = state_17814;
(statearr_17823[(4)] = cljs.core.cons((5),(state_17814[(4)])));

return statearr_17823;
})();
var inst_17801 = fluree.db.storage.core.read(conn,key);
var state_17814__$1 = state_17814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17814__$1,(6),inst_17801);
} else {
if((state_val_17815 === (9))){
var inst_17809 = (state_17814[(2)]);
var _ = (function (){var statearr_17824 = state_17814;
(statearr_17824[(4)] = cljs.core.rest((state_17814[(4)])));

return statearr_17824;
})();
var state_17814__$1 = state_17814;
var statearr_17825_17840 = state_17814__$1;
(statearr_17825_17840[(2)] = inst_17809);

(statearr_17825_17840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17815 === (5))){
var _ = (function (){var statearr_17826 = state_17814;
(statearr_17826[(4)] = cljs.core.rest((state_17814[(4)])));

return statearr_17826;
})();
var state_17814__$1 = state_17814;
var ex17822 = (state_17814__$1[(2)]);
var statearr_17827_17841 = state_17814__$1;
(statearr_17827_17841[(5)] = ex17822);


if((ex17822 instanceof Error)){
var statearr_17828_17842 = state_17814__$1;
(statearr_17828_17842[(1)] = (4));

(statearr_17828_17842[(5)] = null);

} else {
throw ex17822;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17815 === (8))){
var state_17814__$1 = state_17814;
var statearr_17829_17843 = state_17814__$1;
(statearr_17829_17843[(2)] = null);

(statearr_17829_17843[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_17830 = [null,null,null,null,null,null,null,null];
(statearr_17830[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__);

(statearr_17830[(1)] = (1));

return statearr_17830;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1 = (function (state_17814){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17814);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17831){var ex__2730__auto__ = e17831;
var statearr_17832_17844 = state_17814;
(statearr_17832_17844[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17814[(4)]))){
var statearr_17833_17845 = state_17814;
(statearr_17833_17845[(1)] = cljs.core.first((state_17814[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17846 = state_17814;
state_17814 = G__17846;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = function(state_17814){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1.call(this,state_17814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17834 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17834[(6)] = c__2749__auto__);

return statearr_17834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17847,index,index_data){
var map__17848 = p__17847;
var map__17848__$1 = cljs.core.__destructure_map(map__17848);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17848__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17848__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17848__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17848__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17848__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db index root: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17849 = index_data;
var G__17849__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17849,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17849);
var G__17849__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17849__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17849__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__17849__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0));

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17850 = root_data;
var map__17850__$1 = cljs.core.__destructure_map(map__17850);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17850__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17850__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17850__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17850__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root(conn,db,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17872){
var state_val_17873 = (state_17872[(1)]);
if((state_val_17873 === (7))){
var state_17872__$1 = state_17872;
var statearr_17874_17894 = state_17872__$1;
(statearr_17874_17894[(2)] = null);

(statearr_17874_17894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17873 === (1))){
var state_17872__$1 = state_17872;
var statearr_17875_17895 = state_17872__$1;
(statearr_17875_17895[(2)] = null);

(statearr_17875_17895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17873 === (4))){
var inst_17851 = (state_17872[(2)]);
var state_17872__$1 = state_17872;
var statearr_17876_17896 = state_17872__$1;
(statearr_17876_17896[(2)] = inst_17851);

(statearr_17876_17896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17873 === (6))){
var inst_17858 = (state_17872[(7)]);
var inst_17860 = fluree.db.storage.core.serde(conn);
var state_17872__$1 = (function (){var statearr_17877 = state_17872;
(statearr_17877[(8)] = inst_17860);

return statearr_17877;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17872__$1,(9),inst_17858);
} else {
if((state_val_17873 === (3))){
var inst_17870 = (state_17872[(2)]);
var state_17872__$1 = state_17872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17872__$1,inst_17870);
} else {
if((state_val_17873 === (2))){
var inst_17858 = (state_17872[(7)]);
var _ = (function (){var statearr_17879 = state_17872;
(statearr_17879[(4)] = cljs.core.cons((5),(state_17872[(4)])));

return statearr_17879;
})();
var inst_17857 = fluree.db.storage.core.ledger_garbage_key(network,ledger_id,block);
var inst_17858__$1 = fluree.db.storage.core.read(conn,inst_17857);
var state_17872__$1 = (function (){var statearr_17880 = state_17872;
(statearr_17880[(7)] = inst_17858__$1);

return statearr_17880;
})();
if(cljs.core.truth_(inst_17858__$1)){
var statearr_17881_17897 = state_17872__$1;
(statearr_17881_17897[(1)] = (6));

} else {
var statearr_17882_17898 = state_17872__$1;
(statearr_17882_17898[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17873 === (9))){
var inst_17860 = (state_17872[(8)]);
var inst_17862 = (state_17872[(2)]);
var inst_17863 = fluree.db.util.async.throw_err(inst_17862);
var inst_17864 = fluree.db.serde.protocol._deserialize_garbage(inst_17860,inst_17863);
var state_17872__$1 = state_17872;
var statearr_17883_17899 = state_17872__$1;
(statearr_17883_17899[(2)] = inst_17864);

(statearr_17883_17899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17873 === (5))){
var _ = (function (){var statearr_17884 = state_17872;
(statearr_17884[(4)] = cljs.core.rest((state_17872[(4)])));

return statearr_17884;
})();
var state_17872__$1 = state_17872;
var ex17878 = (state_17872__$1[(2)]);
var statearr_17885_17900 = state_17872__$1;
(statearr_17885_17900[(5)] = ex17878);


if((ex17878 instanceof Error)){
var statearr_17886_17901 = state_17872__$1;
(statearr_17886_17901[(1)] = (4));

(statearr_17886_17901[(5)] = null);

} else {
throw ex17878;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17873 === (8))){
var inst_17867 = (state_17872[(2)]);
var _ = (function (){var statearr_17887 = state_17872;
(statearr_17887[(4)] = cljs.core.rest((state_17872[(4)])));

return statearr_17887;
})();
var state_17872__$1 = state_17872;
var statearr_17888_17902 = state_17872__$1;
(statearr_17888_17902[(2)] = inst_17867);

(statearr_17888_17902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_17889 = [null,null,null,null,null,null,null,null,null];
(statearr_17889[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__);

(statearr_17889[(1)] = (1));

return statearr_17889;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1 = (function (state_17872){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17872);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17890){var ex__2730__auto__ = e17890;
var statearr_17891_17903 = state_17872;
(statearr_17891_17903[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17872[(4)]))){
var statearr_17892_17904 = state_17872;
(statearr_17892_17904[(1)] = cljs.core.first((state_17872[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17905 = state_17872;
state_17872 = G__17905;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = function(state_17872){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1.call(this,state_17872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17893 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17893[(6)] = c__2749__auto__);

return statearr_17893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17927){
var state_val_17928 = (state_17927[(1)]);
if((state_val_17928 === (7))){
var inst_17916 = (state_17927[(7)]);
var inst_17918 = fluree.db.storage.core.serde(conn);
var inst_17919 = fluree.db.serde.protocol._deserialize_db_root(inst_17918,inst_17916);
var state_17927__$1 = state_17927;
var statearr_17929_17948 = state_17927__$1;
(statearr_17929_17948[(2)] = inst_17919);

(statearr_17929_17948[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (1))){
var state_17927__$1 = state_17927;
var statearr_17930_17949 = state_17927__$1;
(statearr_17930_17949[(2)] = null);

(statearr_17930_17949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (4))){
var inst_17906 = (state_17927[(2)]);
var state_17927__$1 = state_17927;
var statearr_17931_17950 = state_17927__$1;
(statearr_17931_17950[(2)] = inst_17906);

(statearr_17931_17950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (6))){
var inst_17916 = (state_17927[(7)]);
var inst_17915 = (state_17927[(2)]);
var inst_17916__$1 = fluree.db.util.async.throw_err(inst_17915);
var state_17927__$1 = (function (){var statearr_17932 = state_17927;
(statearr_17932[(7)] = inst_17916__$1);

return statearr_17932;
})();
if(cljs.core.truth_(inst_17916__$1)){
var statearr_17933_17951 = state_17927__$1;
(statearr_17933_17951[(1)] = (7));

} else {
var statearr_17934_17952 = state_17927__$1;
(statearr_17934_17952[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (3))){
var inst_17925 = (state_17927[(2)]);
var state_17927__$1 = state_17927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17927__$1,inst_17925);
} else {
if((state_val_17928 === (2))){
var _ = (function (){var statearr_17936 = state_17927;
(statearr_17936[(4)] = cljs.core.cons((5),(state_17927[(4)])));

return statearr_17936;
})();
var inst_17912 = fluree.db.storage.core.ledger_root_key(network,ledger_id,block);
var inst_17913 = fluree.db.storage.core.read(conn,inst_17912);
var state_17927__$1 = state_17927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17927__$1,(6),inst_17913);
} else {
if((state_val_17928 === (9))){
var inst_17922 = (state_17927[(2)]);
var _ = (function (){var statearr_17937 = state_17927;
(statearr_17937[(4)] = cljs.core.rest((state_17927[(4)])));

return statearr_17937;
})();
var state_17927__$1 = state_17927;
var statearr_17938_17953 = state_17927__$1;
(statearr_17938_17953[(2)] = inst_17922);

(statearr_17938_17953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (5))){
var _ = (function (){var statearr_17939 = state_17927;
(statearr_17939[(4)] = cljs.core.rest((state_17927[(4)])));

return statearr_17939;
})();
var state_17927__$1 = state_17927;
var ex17935 = (state_17927__$1[(2)]);
var statearr_17940_17954 = state_17927__$1;
(statearr_17940_17954[(5)] = ex17935);


if((ex17935 instanceof Error)){
var statearr_17941_17955 = state_17927__$1;
(statearr_17941_17955[(1)] = (4));

(statearr_17941_17955[(5)] = null);

} else {
throw ex17935;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (8))){
var state_17927__$1 = state_17927;
var statearr_17942_17956 = state_17927__$1;
(statearr_17942_17956[(2)] = null);

(statearr_17942_17956[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0 = (function (){
var statearr_17943 = [null,null,null,null,null,null,null,null];
(statearr_17943[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__);

(statearr_17943[(1)] = (1));

return statearr_17943;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1 = (function (state_17927){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17927);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17944){var ex__2730__auto__ = e17944;
var statearr_17945_17957 = state_17927;
(statearr_17945_17957[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17927[(4)]))){
var statearr_17946_17958 = state_17927;
(statearr_17946_17958[(1)] = cljs.core.first((state_17927[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17959 = state_17927;
state_17927 = G__17959;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = function(state_17927){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1.call(this,state_17927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17947 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17947[(6)] = c__2749__auto__);

return statearr_17947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17996){
var state_val_17997 = (state_17996[(1)]);
if((state_val_17997 === (7))){
var inst_17966 = (state_17996[(7)]);
var state_17996__$1 = state_17996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17996__$1,(9),inst_17966);
} else {
if((state_val_17997 === (1))){
var state_17996__$1 = state_17996;
var statearr_17998_18019 = state_17996__$1;
(statearr_17998_18019[(2)] = null);

(statearr_17998_18019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (4))){
var inst_17960 = (state_17996[(2)]);
var state_17996__$1 = state_17996;
var statearr_17999_18020 = state_17996__$1;
(statearr_17999_18020[(2)] = inst_17960);

(statearr_17999_18020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (6))){
var inst_17969 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17970 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17971 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17972 = cljs.core.PersistentHashMap.fromArrays(inst_17970,inst_17971);
var inst_17973 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17969,inst_17972);
var inst_17974 = (function(){throw inst_17973})();
var state_17996__$1 = state_17996;
var statearr_18000_18021 = state_17996__$1;
(statearr_18000_18021[(2)] = inst_17974);

(statearr_18000_18021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (3))){
var inst_17994 = (state_17996[(2)]);
var state_17996__$1 = state_17996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17996__$1,inst_17994);
} else {
if((state_val_17997 === (2))){
var inst_17966 = (state_17996[(7)]);
var _ = (function (){var statearr_18001 = state_17996;
(statearr_18001[(4)] = cljs.core.cons((5),(state_17996[(4)])));

return statearr_18001;
})();
var inst_17966__$1 = fluree.db.storage.core.read_db_root(conn,network,ledger_id,index);
var inst_17967 = cljs.core.not(inst_17966__$1);
var state_17996__$1 = (function (){var statearr_18002 = state_17996;
(statearr_18002[(7)] = inst_17966__$1);

return statearr_18002;
})();
if(inst_17967){
var statearr_18003_18022 = state_17996__$1;
(statearr_18003_18022[(1)] = (6));

} else {
var statearr_18004_18023 = state_17996__$1;
(statearr_18004_18023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (11))){
var inst_17984 = (state_17996[(8)]);
var inst_17987 = (state_17996[(2)]);
var inst_17988 = fluree.db.util.async.throw_err(inst_17987);
var inst_17989 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17984,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17988);
var state_17996__$1 = state_17996;
var statearr_18006_18024 = state_17996__$1;
(statearr_18006_18024[(2)] = inst_17989);

(statearr_18006_18024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (9))){
var inst_17979 = (state_17996[(9)]);
var inst_17977 = (state_17996[(2)]);
var inst_17978 = fluree.db.util.async.throw_err(inst_17977);
var inst_17979__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_17978);
var inst_17980 = fluree.db.query.schema.schema_map(inst_17979__$1);
var state_17996__$1 = (function (){var statearr_18007 = state_17996;
(statearr_18007[(9)] = inst_17979__$1);

return statearr_18007;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17996__$1,(10),inst_17980);
} else {
if((state_val_17997 === (5))){
var _ = (function (){var statearr_18008 = state_17996;
(statearr_18008[(4)] = cljs.core.rest((state_17996[(4)])));

return statearr_18008;
})();
var state_17996__$1 = state_17996;
var ex18005 = (state_17996__$1[(2)]);
var statearr_18009_18025 = state_17996__$1;
(statearr_18009_18025[(5)] = ex18005);


if((ex18005 instanceof Error)){
var statearr_18010_18026 = state_17996__$1;
(statearr_18010_18026[(1)] = (4));

(statearr_18010_18026[(5)] = null);

} else {
throw ex18005;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (10))){
var inst_17984 = (state_17996[(8)]);
var inst_17979 = (state_17996[(9)]);
var inst_17982 = (state_17996[(2)]);
var inst_17983 = fluree.db.util.async.throw_err(inst_17982);
var inst_17984__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17979,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17983);
var inst_17985 = fluree.db.query.schema.setting_map(inst_17984__$1);
var state_17996__$1 = (function (){var statearr_18011 = state_17996;
(statearr_18011[(8)] = inst_17984__$1);

return statearr_18011;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17996__$1,(11),inst_17985);
} else {
if((state_val_17997 === (8))){
var inst_17991 = (state_17996[(2)]);
var _ = (function (){var statearr_18012 = state_17996;
(statearr_18012[(4)] = cljs.core.rest((state_17996[(4)])));

return statearr_18012;
})();
var state_17996__$1 = state_17996;
var statearr_18013_18027 = state_17996__$1;
(statearr_18013_18027[(2)] = inst_17991);

(statearr_18013_18027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0 = (function (){
var statearr_18014 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18014[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2727__auto__);

(statearr_18014[(1)] = (1));

return statearr_18014;
});
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1 = (function (state_17996){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17996);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18015){var ex__2730__auto__ = e18015;
var statearr_18016_18028 = state_17996;
(statearr_18016_18028[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17996[(4)]))){
var statearr_18017_18029 = state_17996;
(statearr_18017_18029[(1)] = cljs.core.first((state_17996[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18030 = state_17996;
state_17996 = G__18030;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = function(state_17996){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1.call(this,state_17996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18018 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18018[(6)] = c__2749__auto__);

return statearr_18018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__18031){
var map__18032 = p__18031;
var map__18032__$1 = cljs.core.__destructure_map(map__18032);
var branch = map__18032__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18032__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18032__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18032__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18069){
var state_val_18070 = (state_18069[(1)]);
if((state_val_18070 === (7))){
var inst_18042 = (state_18069[(7)]);
var inst_18045 = cljs.core.__destructure_map(inst_18042);
var inst_18046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18045,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18048 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_18049 = (new cljs.core.PersistentVector(null,7,(5),inst_18047,inst_18048,null));
var inst_18050 = cljs.core.select_keys(branch,inst_18049);
var inst_18051 = (function (){var temp__5802__auto__ = inst_18042;
var map__18044 = inst_18045;
var children = inst_18046;
var branch_metadata = inst_18050;
return (function (i,child){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (i === (0));
} else {
return and__5043__auto__;
}
})()),child], 0));
});
})();
var inst_18052 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18051,inst_18046);
var inst_18053 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_18054 = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(inst_18053,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18052], 0));
var inst_18055 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,comparator,inst_18054);
var state_18069__$1 = state_18069;
var statearr_18071_18090 = state_18069__$1;
(statearr_18071_18090[(2)] = inst_18055);

(statearr_18071_18090[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18070 === (1))){
var state_18069__$1 = state_18069;
var statearr_18072_18091 = state_18069__$1;
(statearr_18072_18091[(2)] = null);

(statearr_18072_18091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18070 === (4))){
var inst_18033 = (state_18069[(2)]);
var state_18069__$1 = state_18069;
var statearr_18073_18092 = state_18069__$1;
(statearr_18073_18092[(2)] = inst_18033);

(statearr_18073_18092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18070 === (6))){
var inst_18042 = (state_18069[(7)]);
var inst_18041 = (state_18069[(2)]);
var inst_18042__$1 = fluree.db.util.async.throw_err(inst_18041);
var state_18069__$1 = (function (){var statearr_18074 = state_18069;
(statearr_18074[(7)] = inst_18042__$1);

return statearr_18074;
})();
if(cljs.core.truth_(inst_18042__$1)){
var statearr_18075_18093 = state_18069__$1;
(statearr_18075_18093[(1)] = (7));

} else {
var statearr_18076_18094 = state_18069__$1;
(statearr_18076_18094[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18070 === (3))){
var inst_18067 = (state_18069[(2)]);
var state_18069__$1 = state_18069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18069__$1,inst_18067);
} else {
if((state_val_18070 === (2))){
var _ = (function (){var statearr_18078 = state_18069;
(statearr_18078[(4)] = cljs.core.cons((5),(state_18069[(4)])));

return statearr_18078;
})();
var inst_18039 = fluree.db.storage.core.read_branch(conn,id);
var state_18069__$1 = state_18069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18069__$1,(6),inst_18039);
} else {
if((state_val_18070 === (9))){
var inst_18064 = (state_18069[(2)]);
var _ = (function (){var statearr_18079 = state_18069;
(statearr_18079[(4)] = cljs.core.rest((state_18069[(4)])));

return statearr_18079;
})();
var state_18069__$1 = state_18069;
var statearr_18080_18095 = state_18069__$1;
(statearr_18080_18095[(2)] = inst_18064);

(statearr_18080_18095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18070 === (5))){
var _ = (function (){var statearr_18081 = state_18069;
(statearr_18081[(4)] = cljs.core.rest((state_18069[(4)])));

return statearr_18081;
})();
var state_18069__$1 = state_18069;
var ex18077 = (state_18069__$1[(2)]);
var statearr_18082_18096 = state_18069__$1;
(statearr_18082_18096[(5)] = ex18077);


if((ex18077 instanceof Error)){
var statearr_18083_18097 = state_18069__$1;
(statearr_18083_18097[(1)] = (4));

(statearr_18083_18097[(5)] = null);

} else {
throw ex18077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18070 === (8))){
var inst_18057 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_18058 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18059 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18060 = cljs.core.PersistentHashMap.fromArrays(inst_18058,inst_18059);
var inst_18061 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18057,inst_18060);
var inst_18062 = (function(){throw inst_18061})();
var state_18069__$1 = state_18069;
var statearr_18084_18098 = state_18069__$1;
(statearr_18084_18098[(2)] = inst_18062);

(statearr_18084_18098[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0 = (function (){
var statearr_18085 = [null,null,null,null,null,null,null,null];
(statearr_18085[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__);

(statearr_18085[(1)] = (1));

return statearr_18085;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1 = (function (state_18069){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18069);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18086){var ex__2730__auto__ = e18086;
var statearr_18087_18099 = state_18069;
(statearr_18087_18099[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18069[(4)]))){
var statearr_18088_18100 = state_18069;
(statearr_18088_18100[(1)] = cljs.core.first((state_18069[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18101 = state_18069;
state_18069 = G__18101;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = function(state_18069){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1.call(this,state_18069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18089 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18089[(6)] = c__2749__auto__);

return statearr_18089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__18102){
var map__18103 = p__18102;
var map__18103__$1 = cljs.core.__destructure_map(map__18103);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18103__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18103__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18132){
var state_val_18133 = (state_18132[(1)]);
if((state_val_18133 === (7))){
var inst_18113 = (state_18132[(7)]);
var inst_18116 = cljs.core.__destructure_map(inst_18113);
var inst_18117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18116,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18118 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,comparator,inst_18117);
var state_18132__$1 = state_18132;
var statearr_18134_18153 = state_18132__$1;
(statearr_18134_18153[(2)] = inst_18118);

(statearr_18134_18153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18133 === (1))){
var state_18132__$1 = state_18132;
var statearr_18135_18154 = state_18132__$1;
(statearr_18135_18154[(2)] = null);

(statearr_18135_18154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18133 === (4))){
var inst_18104 = (state_18132[(2)]);
var state_18132__$1 = state_18132;
var statearr_18136_18155 = state_18132__$1;
(statearr_18136_18155[(2)] = inst_18104);

(statearr_18136_18155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18133 === (6))){
var inst_18113 = (state_18132[(7)]);
var inst_18112 = (state_18132[(2)]);
var inst_18113__$1 = fluree.db.util.async.throw_err(inst_18112);
var state_18132__$1 = (function (){var statearr_18137 = state_18132;
(statearr_18137[(7)] = inst_18113__$1);

return statearr_18137;
})();
if(cljs.core.truth_(inst_18113__$1)){
var statearr_18138_18156 = state_18132__$1;
(statearr_18138_18156[(1)] = (7));

} else {
var statearr_18139_18157 = state_18132__$1;
(statearr_18139_18157[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18133 === (3))){
var inst_18130 = (state_18132[(2)]);
var state_18132__$1 = state_18132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18132__$1,inst_18130);
} else {
if((state_val_18133 === (2))){
var _ = (function (){var statearr_18141 = state_18132;
(statearr_18141[(4)] = cljs.core.cons((5),(state_18132[(4)])));

return statearr_18141;
})();
var inst_18110 = fluree.db.storage.core.read_leaf(conn,id);
var state_18132__$1 = state_18132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18132__$1,(6),inst_18110);
} else {
if((state_val_18133 === (9))){
var inst_18127 = (state_18132[(2)]);
var _ = (function (){var statearr_18142 = state_18132;
(statearr_18142[(4)] = cljs.core.rest((state_18132[(4)])));

return statearr_18142;
})();
var state_18132__$1 = state_18132;
var statearr_18143_18158 = state_18132__$1;
(statearr_18143_18158[(2)] = inst_18127);

(statearr_18143_18158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18133 === (5))){
var _ = (function (){var statearr_18144 = state_18132;
(statearr_18144[(4)] = cljs.core.rest((state_18132[(4)])));

return statearr_18144;
})();
var state_18132__$1 = state_18132;
var ex18140 = (state_18132__$1[(2)]);
var statearr_18145_18159 = state_18132__$1;
(statearr_18145_18159[(5)] = ex18140);


if((ex18140 instanceof Error)){
var statearr_18146_18160 = state_18132__$1;
(statearr_18146_18160[(1)] = (4));

(statearr_18146_18160[(5)] = null);

} else {
throw ex18140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18133 === (8))){
var inst_18120 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_18121 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18122 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18123 = cljs.core.PersistentHashMap.fromArrays(inst_18121,inst_18122);
var inst_18124 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18120,inst_18123);
var inst_18125 = (function(){throw inst_18124})();
var state_18132__$1 = state_18132;
var statearr_18147_18161 = state_18132__$1;
(statearr_18147_18161[(2)] = inst_18125);

(statearr_18147_18161[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_18148 = [null,null,null,null,null,null,null,null];
(statearr_18148[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__);

(statearr_18148[(1)] = (1));

return statearr_18148;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1 = (function (state_18132){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18132);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18149){var ex__2730__auto__ = e18149;
var statearr_18150_18162 = state_18132;
(statearr_18150_18162[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18132[(4)]))){
var statearr_18151_18163 = state_18132;
(statearr_18151_18163[(1)] = cljs.core.first((state_18132[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18164 = state_18132;
state_18132 = G__18164;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = function(state_18132){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1.call(this,state_18132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18152 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18152[(6)] = c__2749__auto__);

return statearr_18152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__18166 = arguments.length;
switch (G__18166) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2(node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__18167,error_fn){
var map__18168 = p__18167;
var map__18168__$1 = cljs.core.__destructure_map(map__18168);
var node = map__18168__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18168__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18168__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18240 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18212){
var state_val_18213 = (state_18212[(1)]);
if((state_val_18213 === (7))){
var inst_18177 = (state_18212[(2)]);
var state_18212__$1 = state_18212;
var statearr_18214_18241 = state_18212__$1;
(statearr_18214_18241[(2)] = inst_18177);

(statearr_18214_18241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (1))){
var state_18212__$1 = state_18212;
var statearr_18215_18242 = state_18212__$1;
(statearr_18215_18242[(2)] = null);

(statearr_18215_18242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (4))){
var inst_18169 = (state_18212[(7)]);
var inst_18169__$1 = (state_18212[(2)]);
var inst_18170 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_18169__$1,"Error resolving index node") : fluree.db.util.log.error.call(null,inst_18169__$1,"Error resolving index node"));
var state_18212__$1 = (function (){var statearr_18216 = state_18212;
(statearr_18216[(7)] = inst_18169__$1);

(statearr_18216[(8)] = inst_18170);

return statearr_18216;
})();
if(cljs.core.truth_(error_fn)){
var statearr_18217_18243 = state_18212__$1;
(statearr_18217_18243[(1)] = (5));

} else {
var statearr_18218_18244 = state_18212__$1;
(statearr_18218_18244[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (13))){
var inst_18195 = (state_18212[(9)]);
var inst_18198 = (state_18212[(2)]);
var inst_18199 = fluree.db.util.async.throw_err(inst_18198);
var inst_18200 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_18199];
var inst_18201 = (new cljs.core.PersistentVector(null,2,(5),inst_18195,inst_18200,null));
var state_18212__$1 = state_18212;
var statearr_18219_18245 = state_18212__$1;
(statearr_18219_18245[(2)] = inst_18201);

(statearr_18219_18245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (6))){
var state_18212__$1 = state_18212;
var statearr_18220_18246 = state_18212__$1;
(statearr_18220_18246[(2)] = null);

(statearr_18220_18246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (3))){
var inst_18210 = (state_18212[(2)]);
var state_18212__$1 = state_18212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18212__$1,inst_18210);
} else {
if((state_val_18213 === (12))){
var inst_18187 = (state_18212[(10)]);
var inst_18190 = (state_18212[(2)]);
var inst_18191 = fluree.db.util.async.throw_err(inst_18190);
var inst_18192 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18191];
var inst_18193 = (new cljs.core.PersistentVector(null,2,(5),inst_18187,inst_18192,null));
var state_18212__$1 = state_18212;
var statearr_18221_18247 = state_18212__$1;
(statearr_18221_18247[(2)] = inst_18193);

(statearr_18221_18247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (2))){
var _ = (function (){var statearr_18222 = state_18212;
(statearr_18222[(4)] = cljs.core.cons((8),(state_18212[(4)])));

return statearr_18222;
})();
var state_18212__$1 = state_18212;
if(cljs.core.truth_(leaf)){
var statearr_18223_18248 = state_18212__$1;
(statearr_18223_18248[(1)] = (9));

} else {
var statearr_18224_18249 = state_18212__$1;
(statearr_18224_18249[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (11))){
var inst_18203 = (state_18212[(2)]);
var inst_18204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18203,(0),null);
var inst_18205 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18203,(1),null);
var inst_18206 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,inst_18204,inst_18205);
var inst_18207 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18206);
var _ = (function (){var statearr_18225 = state_18212;
(statearr_18225[(4)] = cljs.core.rest((state_18212[(4)])));

return statearr_18225;
})();
var state_18212__$1 = state_18212;
var statearr_18226_18250 = state_18212__$1;
(statearr_18226_18250[(2)] = inst_18207);

(statearr_18226_18250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (9))){
var inst_18187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18188 = fluree.db.storage.core.fetch_leaf_flakes(conn,node);
var state_18212__$1 = (function (){var statearr_18227 = state_18212;
(statearr_18227[(10)] = inst_18187);

return statearr_18227;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18212__$1,(12),inst_18188);
} else {
if((state_val_18213 === (5))){
var inst_18169 = (state_18212[(7)]);
var inst_18172 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18169);
var inst_18173 = cljs.core.async.close_BANG_(return_ch);
var inst_18174 = (error_fn.cljs$core$IFn$_invoke$arity$2 ? error_fn.cljs$core$IFn$_invoke$arity$2(inst_18172,inst_18173) : error_fn.call(null,inst_18172,inst_18173));
var state_18212__$1 = state_18212;
var statearr_18229_18251 = state_18212__$1;
(statearr_18229_18251[(2)] = inst_18174);

(statearr_18229_18251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18213 === (10))){
var inst_18195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18196 = fluree.db.storage.core.fetch_child_attributes(conn,node);
var state_18212__$1 = (function (){var statearr_18230 = state_18212;
(statearr_18230[(9)] = inst_18195);

return statearr_18230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18212__$1,(13),inst_18196);
} else {
if((state_val_18213 === (8))){
var _ = (function (){var statearr_18231 = state_18212;
(statearr_18231[(4)] = cljs.core.rest((state_18212[(4)])));

return statearr_18231;
})();
var state_18212__$1 = state_18212;
var ex18228 = (state_18212__$1[(2)]);
var statearr_18232_18252 = state_18212__$1;
(statearr_18232_18252[(5)] = ex18228);


var statearr_18233_18253 = state_18212__$1;
(statearr_18233_18253[(1)] = (4));

(statearr_18233_18253[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_18234 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18234[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_18234[(1)] = (1));

return statearr_18234;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_18212){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18212);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18235){var ex__2730__auto__ = e18235;
var statearr_18236_18254 = state_18212;
(statearr_18236_18254[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18212[(4)]))){
var statearr_18237_18255 = state_18212;
(statearr_18237_18255[(1)] = cljs.core.first((state_18212[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18256 = state_18212;
state_18212 = G__18256;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_18212){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_18212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18238 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18238[(6)] = c__2749__auto___18240);

return statearr_18238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__18257){
var map__18258 = p__18257;
var map__18258__$1 = cljs.core.__destructure_map(map__18258);
var node = map__18258__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18258__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var empty_set = fluree.db.flake.sorted_set_by(comparator);
var empty_node = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,empty_node);

return ch;
});
