// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_12296){
var state_val_12297 = (state_12296[(1)]);
if((state_val_12297 === (7))){
var inst_12291 = (state_12296[(2)]);
var _ = (function (){var statearr_12298 = state_12296;
(statearr_12298[(4)] = cljs.core.rest((state_12296[(4)])));

return statearr_12298;
})();
var state_12296__$1 = state_12296;
var statearr_12299_12321 = state_12296__$1;
(statearr_12299_12321[(2)] = inst_12291);

(statearr_12299_12321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (1))){
var state_12296__$1 = state_12296;
var statearr_12300_12322 = state_12296__$1;
(statearr_12300_12322[(2)] = null);

(statearr_12300_12322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (4))){
var inst_12253 = (state_12296[(2)]);
var state_12296__$1 = state_12296;
var statearr_12301_12323 = state_12296__$1;
(statearr_12301_12323[(2)] = inst_12253);

(statearr_12301_12323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (6))){
var inst_12278 = (state_12296[(7)]);
var inst_12271 = (state_12296[(8)]);
var inst_12277 = cljs.core.seq(inst_12271);
var inst_12278__$1 = cljs.core.first(inst_12277);
var inst_12279 = cljs.core.next(inst_12277);
var inst_12280 = cljs.core.not(inst_12278__$1);
var state_12296__$1 = (function (){var statearr_12302 = state_12296;
(statearr_12302[(9)] = inst_12279);

(statearr_12302[(7)] = inst_12278__$1);

return statearr_12302;
})();
if(inst_12280){
var statearr_12303_12324 = state_12296__$1;
(statearr_12303_12324[(1)] = (8));

} else {
var statearr_12304_12325 = state_12296__$1;
(statearr_12304_12325[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (3))){
var inst_12294 = (state_12296[(2)]);
var state_12296__$1 = state_12296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12296__$1,inst_12294);
} else {
if((state_val_12297 === (2))){
var _ = (function (){var statearr_12305 = state_12296;
(statearr_12305[(4)] = cljs.core.cons((5),(state_12296[(4)])));

return statearr_12305;
})();
var inst_12266 = chs;
var inst_12267 = cljs.core.seq(inst_12266);
var inst_12268 = cljs.core.first(inst_12267);
var inst_12269 = cljs.core.next(inst_12267);
var inst_12270 = coll;
var inst_12271 = inst_12266;
var inst_12272 = inst_12270;
var state_12296__$1 = (function (){var statearr_12306 = state_12296;
(statearr_12306[(10)] = inst_12268);

(statearr_12306[(8)] = inst_12271);

(statearr_12306[(11)] = inst_12269);

(statearr_12306[(12)] = inst_12272);

return statearr_12306;
})();
var statearr_12307_12326 = state_12296__$1;
(statearr_12307_12326[(2)] = null);

(statearr_12307_12326[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (11))){
var inst_12279 = (state_12296[(9)]);
var inst_12272 = (state_12296[(12)]);
var inst_12284 = (state_12296[(2)]);
var inst_12285 = fluree.db.util.async.throw_err(inst_12284);
var inst_12286 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12272,inst_12285);
var inst_12271 = inst_12279;
var inst_12272__$1 = inst_12286;
var state_12296__$1 = (function (){var statearr_12309 = state_12296;
(statearr_12309[(8)] = inst_12271);

(statearr_12309[(12)] = inst_12272__$1);

return statearr_12309;
})();
var statearr_12310_12327 = state_12296__$1;
(statearr_12310_12327[(2)] = null);

(statearr_12310_12327[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (9))){
var inst_12278 = (state_12296[(7)]);
var state_12296__$1 = state_12296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12296__$1,(11),inst_12278);
} else {
if((state_val_12297 === (5))){
var _ = (function (){var statearr_12311 = state_12296;
(statearr_12311[(4)] = cljs.core.rest((state_12296[(4)])));

return statearr_12311;
})();
var state_12296__$1 = state_12296;
var ex12308 = (state_12296__$1[(2)]);
var statearr_12312_12328 = state_12296__$1;
(statearr_12312_12328[(5)] = ex12308);


var statearr_12313_12329 = state_12296__$1;
(statearr_12313_12329[(1)] = (4));

(statearr_12313_12329[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (10))){
var inst_12289 = (state_12296[(2)]);
var state_12296__$1 = state_12296;
var statearr_12314_12330 = state_12296__$1;
(statearr_12314_12330[(2)] = inst_12289);

(statearr_12314_12330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (8))){
var inst_12272 = (state_12296[(12)]);
var state_12296__$1 = state_12296;
var statearr_12315_12331 = state_12296__$1;
(statearr_12315_12331[(2)] = inst_12272);

(statearr_12315_12331[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_12316 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12316[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__);

(statearr_12316[(1)] = (1));

return statearr_12316;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1 = (function (state_12296){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_12296);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e12317){var ex__2730__auto__ = e12317;
var statearr_12318_12332 = state_12296;
(statearr_12318_12332[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_12296[(4)]))){
var statearr_12319_12333 = state_12296;
(statearr_12319_12333[(1)] = cljs.core.first((state_12296[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12334 = state_12296;
state_12296 = G__12334;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = function(state_12296){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1.call(this,state_12296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_12320 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_12320[(6)] = c__2749__auto__);

return statearr_12320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_12360){
var state_val_12361 = (state_12360[(1)]);
if((state_val_12361 === (7))){
var inst_12355 = (state_12360[(2)]);
var _ = (function (){var statearr_12362 = state_12360;
(statearr_12362[(4)] = cljs.core.rest((state_12360[(4)])));

return statearr_12362;
})();
var state_12360__$1 = state_12360;
var statearr_12363_12385 = state_12360__$1;
(statearr_12363_12385[(2)] = inst_12355);

(statearr_12363_12385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (1))){
var state_12360__$1 = state_12360;
var statearr_12364_12386 = state_12360__$1;
(statearr_12364_12386[(2)] = null);

(statearr_12364_12386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (4))){
var inst_12335 = (state_12360[(2)]);
var state_12360__$1 = state_12360;
var statearr_12365_12387 = state_12360__$1;
(statearr_12365_12387[(2)] = inst_12335);

(statearr_12365_12387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (6))){
var state_12360__$1 = state_12360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12360__$1,(8),chan);
} else {
if((state_val_12361 === (3))){
var inst_12358 = (state_12360[(2)]);
var state_12360__$1 = state_12360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12360__$1,inst_12358);
} else {
if((state_val_12361 === (2))){
var _ = (function (){var statearr_12366 = state_12360;
(statearr_12366[(4)] = cljs.core.cons((5),(state_12360[(4)])));

return statearr_12366;
})();
var inst_12341 = coll;
var inst_12342 = inst_12341;
var state_12360__$1 = (function (){var statearr_12367 = state_12360;
(statearr_12367[(7)] = inst_12342);

return statearr_12367;
})();
var statearr_12368_12388 = state_12360__$1;
(statearr_12368_12388[(2)] = null);

(statearr_12368_12388[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (11))){
var inst_12353 = (state_12360[(2)]);
var state_12360__$1 = state_12360;
var statearr_12370_12389 = state_12360__$1;
(statearr_12370_12389[(2)] = inst_12353);

(statearr_12370_12389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (9))){
var inst_12342 = (state_12360[(7)]);
var state_12360__$1 = state_12360;
var statearr_12371_12390 = state_12360__$1;
(statearr_12371_12390[(2)] = inst_12342);

(statearr_12371_12390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (5))){
var _ = (function (){var statearr_12372 = state_12360;
(statearr_12372[(4)] = cljs.core.rest((state_12360[(4)])));

return statearr_12372;
})();
var state_12360__$1 = state_12360;
var ex12369 = (state_12360__$1[(2)]);
var statearr_12373_12391 = state_12360__$1;
(statearr_12373_12391[(5)] = ex12369);


var statearr_12374_12392 = state_12360__$1;
(statearr_12374_12392[(1)] = (4));

(statearr_12374_12392[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (10))){
var inst_12346 = (state_12360[(8)]);
var inst_12342 = (state_12360[(7)]);
var inst_12350 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12342,inst_12346);
var inst_12342__$1 = inst_12350;
var state_12360__$1 = (function (){var statearr_12375 = state_12360;
(statearr_12375[(7)] = inst_12342__$1);

return statearr_12375;
})();
var statearr_12376_12393 = state_12360__$1;
(statearr_12376_12393[(2)] = null);

(statearr_12376_12393[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12361 === (8))){
var inst_12346 = (state_12360[(8)]);
var inst_12345 = (state_12360[(2)]);
var inst_12346__$1 = fluree.db.util.async.throw_err(inst_12345);
var inst_12347 = (inst_12346__$1 == null);
var state_12360__$1 = (function (){var statearr_12377 = state_12360;
(statearr_12377[(8)] = inst_12346__$1);

return statearr_12377;
})();
if(cljs.core.truth_(inst_12347)){
var statearr_12378_12394 = state_12360__$1;
(statearr_12378_12394[(1)] = (9));

} else {
var statearr_12379_12395 = state_12360__$1;
(statearr_12379_12395[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_12380 = [null,null,null,null,null,null,null,null,null];
(statearr_12380[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__);

(statearr_12380[(1)] = (1));

return statearr_12380;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1 = (function (state_12360){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_12360);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e12381){var ex__2730__auto__ = e12381;
var statearr_12382_12396 = state_12360;
(statearr_12382_12396[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_12360[(4)]))){
var statearr_12383_12397 = state_12360;
(statearr_12383_12397[(1)] = cljs.core.first((state_12360[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12398 = state_12360;
state_12360 = G__12398;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = function(state_12360){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1.call(this,state_12360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_12384 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_12384[(6)] = c__2749__auto__);

return statearr_12384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
