// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__74397 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74397__$1 = cljs.core.__destructure_map(map__74397);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74397__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74397__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__74398 = cljs.core.get_global_hierarchy;
return (fexpr__74398.cljs$core$IFn$_invoke$arity$0 ? fexpr__74398.cljs$core$IFn$_invoke$arity$0() : fexpr__74398.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__74399__delegate = function (conn_id,event,_){
return event;
};
var G__74399 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__74400__i = 0, G__74400__a = new Array(arguments.length -  2);
while (G__74400__i < G__74400__a.length) {G__74400__a[G__74400__i] = arguments[G__74400__i + 2]; ++G__74400__i;}
  _ = new cljs.core.IndexedSeq(G__74400__a,0,null);
} 
return G__74399__delegate.call(this,conn_id,event,_);};
G__74399.cljs$lang$maxFixedArity = 2;
G__74399.cljs$lang$applyTo = (function (arglist__74401){
var conn_id = cljs.core.first(arglist__74401);
arglist__74401 = cljs.core.next(arglist__74401);
var event = cljs.core.first(arglist__74401);
var _ = cljs.core.rest(arglist__74401);
return G__74399__delegate(conn_id,event,_);
});
G__74399.cljs$core$IFn$_invoke$arity$variadic = G__74399__delegate;
return G__74399;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__5045__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74419){
var state_val_74420 = (state_74419[(1)]);
if((state_val_74420 === (1))){
var inst_74402 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_74403 = flureeworker.conn_id__GT_db(conn_id,inst_74402);
var inst_74404 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_74405 = fluree.db.api.query.query(inst_74403,inst_74404);
var state_74419__$1 = state_74419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74419__$1,(2),inst_74405);
} else {
if((state_val_74420 === (2))){
var inst_74407 = (state_74419[(7)]);
var inst_74407__$1 = (state_74419[(2)]);
var inst_74408 = fluree.db.util.core.exception_QMARK_(inst_74407__$1);
var state_74419__$1 = (function (){var statearr_74421 = state_74419;
(statearr_74421[(7)] = inst_74407__$1);

return statearr_74421;
})();
if(inst_74408){
var statearr_74422_74435 = state_74419__$1;
(statearr_74422_74435[(1)] = (3));

} else {
var statearr_74423_74436 = state_74419__$1;
(statearr_74423_74436[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74420 === (3))){
var inst_74407 = (state_74419[(7)]);
var inst_74410 = flureeworker.error_return_map(inst_74407);
var state_74419__$1 = state_74419;
var statearr_74424_74437 = state_74419__$1;
(statearr_74424_74437[(2)] = inst_74410);

(statearr_74424_74437[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74420 === (4))){
var inst_74407 = (state_74419[(7)]);
var inst_74412 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_74413 = [inst_74407,"loaded"];
var inst_74414 = cljs.core.PersistentHashMap.fromArrays(inst_74412,inst_74413);
var state_74419__$1 = state_74419;
var statearr_74425_74438 = state_74419__$1;
(statearr_74425_74438[(2)] = inst_74414);

(statearr_74425_74438[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74420 === (5))){
var inst_74416 = (state_74419[(2)]);
var inst_74417 = (function (){var G__74426 = conn_id;
var G__74427 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__74428 = id;
var G__74429 = inst_74416;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74426,G__74427,G__74428,G__74429) : flureeworker.worker_action.call(null,G__74426,G__74427,G__74428,G__74429));
})();
var state_74419__$1 = state_74419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74419__$1,inst_74417);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2727__auto__ = null;
var flureeworker$process_query_$_state_machine__2727__auto____0 = (function (){
var statearr_74430 = [null,null,null,null,null,null,null,null];
(statearr_74430[(0)] = flureeworker$process_query_$_state_machine__2727__auto__);

(statearr_74430[(1)] = (1));

return statearr_74430;
});
var flureeworker$process_query_$_state_machine__2727__auto____1 = (function (state_74419){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74419);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74431){var ex__2730__auto__ = e74431;
var statearr_74432_74439 = state_74419;
(statearr_74432_74439[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74419[(4)]))){
var statearr_74433_74440 = state_74419;
(statearr_74433_74440[(1)] = cljs.core.first((state_74419[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74441 = state_74419;
state_74419 = G__74441;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2727__auto__ = function(state_74419){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2727__auto____1.call(this,state_74419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2727__auto____0;
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2727__auto____1;
return flureeworker$process_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74434 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74434[(6)] = c__2749__auto__);

return statearr_74434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__74442 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74442__$1 = cljs.core.__destructure_map(map__74442);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74442__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74442__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__74443 = cljs.core.seq(query_ids);
var chunk__74444 = null;
var count__74445 = (0);
var i__74446 = (0);
while(true){
if((i__74446 < count__74445)){
var id = chunk__74444.cljs$core$IIndexed$_nth$arity$2(null,i__74446);
flureeworker.process_query(conn_id,id,opts);


var G__74447 = seq__74443;
var G__74448 = chunk__74444;
var G__74449 = count__74445;
var G__74450 = (i__74446 + (1));
seq__74443 = G__74447;
chunk__74444 = G__74448;
count__74445 = G__74449;
i__74446 = G__74450;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__74443);
if(temp__5804__auto__){
var seq__74443__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__74443__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__74443__$1);
var G__74451 = cljs.core.chunk_rest(seq__74443__$1);
var G__74452 = c__5568__auto__;
var G__74453 = cljs.core.count(c__5568__auto__);
var G__74454 = (0);
seq__74443 = G__74451;
chunk__74444 = G__74452;
count__74445 = G__74453;
i__74446 = G__74454;
continue;
} else {
var id = cljs.core.first(seq__74443__$1);
flureeworker.process_query(conn_id,id,opts);


var G__74455 = cljs.core.next(seq__74443__$1);
var G__74456 = null;
var G__74457 = (0);
var G__74458 = (0);
seq__74443 = G__74455;
chunk__74444 = G__74456;
count__74445 = G__74457;
i__74446 = G__74458;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__74459 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74459,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74459,(1),null);
var cb = (function (header,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74467){
var state_val_74468 = (state_74467[(1)]);
if((state_val_74468 === (1))){
var inst_74462 = cljs.core.async.timeout((100));
var state_74467__$1 = state_74467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74467__$1,(2),inst_74462);
} else {
if((state_val_74468 === (2))){
var inst_74464 = (state_74467[(2)]);
var inst_74465 = flureeworker.process_all_queries(conn_id);
var state_74467__$1 = (function (){var statearr_74469 = state_74467;
(statearr_74469[(7)] = inst_74464);

return statearr_74469;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_74467__$1,inst_74465);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2727__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2727__auto____0 = (function (){
var statearr_74470 = [null,null,null,null,null,null,null,null];
(statearr_74470[(0)] = flureeworker$ledger_listener_$_state_machine__2727__auto__);

(statearr_74470[(1)] = (1));

return statearr_74470;
});
var flureeworker$ledger_listener_$_state_machine__2727__auto____1 = (function (state_74467){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74467);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74471){var ex__2730__auto__ = e74471;
var statearr_74472_74475 = state_74467;
(statearr_74472_74475[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74467[(4)]))){
var statearr_74473_74476 = state_74467;
(statearr_74473_74476[(1)] = cljs.core.first((state_74467[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74477 = state_74467;
state_74467 = G__74477;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2727__auto__ = function(state_74467){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2727__auto____1.call(this,state_74467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2727__auto____0;
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2727__auto____1;
return flureeworker$ledger_listener_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74474 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74474[(6)] = c__2749__auto__);

return statearr_74474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__74478 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74478,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74478,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__74481 = config;
var map__74481__$1 = cljs.core.__destructure_map(map__74481);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74481__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74481__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74481__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74481__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74481__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74481__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__5045__auto__ = queries;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74482 = conn_data;
var map__74482__$1 = cljs.core.__destructure_map(map__74482);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74482__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74482__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74482__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__74483 = config;
var map__74483__$1 = cljs.core.__destructure_map(map__74483);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74483__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74483__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74483__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74483__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74489){
var state_val_74490 = (state_74489[(1)]);
if((state_val_74490 === (1))){
var inst_74484 = cljs.core.async.timeout((100));
var state_74489__$1 = state_74489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74489__$1,(2),inst_74484);
} else {
if((state_val_74490 === (2))){
var inst_74486 = (state_74489[(2)]);
var inst_74487 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_74489__$1 = (function (){var statearr_74491 = state_74489;
(statearr_74491[(7)] = inst_74486);

return statearr_74491;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_74489__$1,inst_74487);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2727__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2727__auto____0 = (function (){
var statearr_74492 = [null,null,null,null,null,null,null,null];
(statearr_74492[(0)] = flureeworker$connect_STAR__$_state_machine__2727__auto__);

(statearr_74492[(1)] = (1));

return statearr_74492;
});
var flureeworker$connect_STAR__$_state_machine__2727__auto____1 = (function (state_74489){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74489);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74493){var ex__2730__auto__ = e74493;
var statearr_74494_74505 = state_74489;
(statearr_74494_74505[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74489[(4)]))){
var statearr_74495_74506 = state_74489;
(statearr_74495_74506[(1)] = cljs.core.first((state_74489[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74507 = state_74489;
state_74489 = G__74507;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2727__auto__ = function(state_74489){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2727__auto____1.call(this,state_74489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2727__auto____0;
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2727__auto____1;
return flureeworker$connect_STAR__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74496 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74496[(6)] = c__2749__auto__);

return statearr_74496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__74497_74508 = conn_id;
var G__74498_74509 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__74499_74510 = ref;
var G__74500_74511 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74497_74508,G__74498_74509,G__74499_74510,G__74500_74511) : flureeworker.worker_action.call(null,G__74497_74508,G__74498_74509,G__74499_74510,G__74500_74511));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__74501 = conn_id;
var G__74502 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__74503 = ref;
var G__74504 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74501,G__74502,G__74503,G__74504) : flureeworker.worker_action.call(null,G__74501,G__74502,G__74503,G__74504));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__74513 = arguments.length;
switch (G__74513) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74514 = conn_data;
var map__74514__$1 = cljs.core.__destructure_map(map__74514);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74514__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74514__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74514__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74514__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__74521 = conn_id;
var G__74522 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__74523 = ref;
var G__74524 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74521,G__74522,G__74523,G__74524) : flureeworker.worker_action.call(null,G__74521,G__74522,G__74523,G__74524));
}catch (e74516){var e = e74516;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__74517 = conn_id;
var G__74518 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__74519 = ref;
var G__74520 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74517,G__74518,G__74519,G__74520) : flureeworker.worker_action.call(null,G__74517,G__74518,G__74519,G__74520));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e74525){var e = e74525;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__74526 = conn_id;
var G__74527 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__74528 = ref;
var G__74529 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74526,G__74527,G__74528,G__74529) : flureeworker.worker_action.call(null,G__74526,G__74527,G__74528,G__74529));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__74530 = config_STAR_;
var map__74530__$1 = cljs.core.__destructure_map(map__74530);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74530__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74530__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74530__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74530__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74536){
var state_val_74537 = (state_74536[(1)]);
if((state_val_74537 === (1))){
var inst_74531 = cljs.core.async.timeout((100));
var state_74536__$1 = state_74536;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74536__$1,(2),inst_74531);
} else {
if((state_val_74537 === (2))){
var inst_74533 = (state_74536[(2)]);
var inst_74534 = flureeworker.connect_STAR_(id,ref);
var state_74536__$1 = (function (){var statearr_74538 = state_74536;
(statearr_74538[(7)] = inst_74533);

return statearr_74538;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_74536__$1,inst_74534);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2727__auto__ = null;
var flureeworker$connect_p_$_state_machine__2727__auto____0 = (function (){
var statearr_74539 = [null,null,null,null,null,null,null,null];
(statearr_74539[(0)] = flureeworker$connect_p_$_state_machine__2727__auto__);

(statearr_74539[(1)] = (1));

return statearr_74539;
});
var flureeworker$connect_p_$_state_machine__2727__auto____1 = (function (state_74536){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74536);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74540){var ex__2730__auto__ = e74540;
var statearr_74541_74552 = state_74536;
(statearr_74541_74552[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74536[(4)]))){
var statearr_74542_74553 = state_74536;
(statearr_74542_74553[(1)] = cljs.core.first((state_74536[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74554 = state_74536;
state_74536 = G__74554;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2727__auto__ = function(state_74536){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2727__auto____1.call(this,state_74536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2727__auto____0;
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2727__auto____1;
return flureeworker$connect_p_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74543 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74543[(6)] = c__2749__auto__);

return statearr_74543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__74544 = id;
var G__74545 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__74546 = ref;
var G__74547 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74544,G__74545,G__74546,G__74547) : flureeworker.worker_action.call(null,G__74544,G__74545,G__74546,G__74547));
})).catch((function (error){
var G__74548 = id;
var G__74549 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__74550 = ref;
var G__74551 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74548,G__74549,G__74550,G__74551) : flureeworker.worker_action.call(null,G__74548,G__74549,G__74550,G__74551));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__5775__auto__ = [];
var len__5769__auto___74622 = arguments.length;
var i__5770__auto___74623 = (0);
while(true){
if((i__5770__auto___74623 < len__5769__auto___74622)){
args__5775__auto__.push((arguments[i__5770__auto___74623]));

var G__74624 = (i__5770__auto___74623 + (1));
i__5770__auto___74623 = G__74624;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((4) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5776__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__74560){
var vec__74561 = p__74560;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74561,(0),null);
var map__74564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74564__$1 = cljs.core.__destructure_map(map__74564);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74564__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74564__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74564__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__74565 = conn_id;
var G__74566 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74567 = ref;
var G__74568 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74565,G__74566,G__74567,G__74568) : flureeworker.worker_action.call(null,G__74565,G__74566,G__74567,G__74568));
})());
var auth = null;
var c__2749__auto___74625 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74589){
var state_val_74590 = (state_74589[(1)]);
if((state_val_74590 === (1))){
var state_74589__$1 = state_74589;
var statearr_74591_74626 = state_74589__$1;
(statearr_74591_74626[(2)] = null);

(statearr_74591_74626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74590 === (2))){
var ___$1 = (function (){var statearr_74592 = state_74589;
(statearr_74592[(4)] = cljs.core.cons((5),(state_74589[(4)])));

return statearr_74592;
})();
var inst_74580 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_74581 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__74593 = conn_id;
var G__74594 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74595 = ref;
var G__74596 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74593,G__74594,G__74595,G__74596) : flureeworker.worker_action.call(null,G__74593,G__74594,G__74595,G__74596));
});
})();
var inst_74582 = inst_74580.then(inst_74581);
var inst_74583 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e74597){var ___$2 = e74597;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__74598 = conn_id;
var G__74599 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74600 = ref;
var G__74601 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74598,G__74599,G__74600,G__74601) : flureeworker.worker_action.call(null,G__74598,G__74599,G__74600,G__74601));
} else {
var G__74602 = conn_id;
var G__74603 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74604 = ref;
var G__74605 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74602,G__74603,G__74604,G__74605) : flureeworker.worker_action.call(null,G__74602,G__74603,G__74604,G__74605));

}
});
})();
var inst_74584 = inst_74582.catch(inst_74583);
var ___$2 = (function (){var statearr_74606 = state_74589;
(statearr_74606[(4)] = cljs.core.rest((state_74589[(4)])));

return statearr_74606;
})();
var state_74589__$1 = state_74589;
var statearr_74607_74627 = state_74589__$1;
(statearr_74607_74627[(2)] = inst_74584);

(statearr_74607_74627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74590 === (3))){
var inst_74587 = (state_74589[(2)]);
var state_74589__$1 = state_74589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74589__$1,inst_74587);
} else {
if((state_val_74590 === (4))){
var inst_74569 = (state_74589[(2)]);
var inst_74570 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74571 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74569);
var inst_74572 = [(400),inst_74571];
var inst_74573 = cljs.core.PersistentHashMap.fromArrays(inst_74570,inst_74572);
var inst_74574 = (function (){var G__74609 = conn_id;
var G__74610 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74611 = ref;
var G__74612 = inst_74573;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74609,G__74610,G__74611,G__74612) : flureeworker.worker_action.call(null,G__74609,G__74610,G__74611,G__74612));
})();
var state_74589__$1 = state_74589;
var statearr_74613_74628 = state_74589__$1;
(statearr_74613_74628[(2)] = inst_74574);

(statearr_74613_74628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74590 === (5))){
var ___$1 = (function (){var statearr_74614 = state_74589;
(statearr_74614[(4)] = cljs.core.rest((state_74589[(4)])));

return statearr_74614;
})();
var state_74589__$1 = state_74589;
var ex74608 = (state_74589__$1[(2)]);
var statearr_74615_74629 = state_74589__$1;
(statearr_74615_74629[(5)] = ex74608);


var statearr_74616_74630 = state_74589__$1;
(statearr_74616_74630[(1)] = (4));

(statearr_74616_74630[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2727__auto__ = null;
var flureeworker$state_machine__2727__auto____0 = (function (){
var statearr_74617 = [null,null,null,null,null,null,null];
(statearr_74617[(0)] = flureeworker$state_machine__2727__auto__);

(statearr_74617[(1)] = (1));

return statearr_74617;
});
var flureeworker$state_machine__2727__auto____1 = (function (state_74589){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74589);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74618){var ex__2730__auto__ = e74618;
var statearr_74619_74631 = state_74589;
(statearr_74619_74631[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74589[(4)]))){
var statearr_74620_74632 = state_74589;
(statearr_74620_74632[(1)] = cljs.core.first((state_74589[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74633 = state_74589;
state_74589 = G__74633;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$state_machine__2727__auto__ = function(state_74589){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$state_machine__2727__auto____1.call(this,state_74589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2727__auto____0;
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2727__auto____1;
return flureeworker$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74621 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74621[(6)] = c__2749__auto___74625);

return statearr_74621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq74555){
var G__74556 = cljs.core.first(seq74555);
var seq74555__$1 = cljs.core.next(seq74555);
var G__74557 = cljs.core.first(seq74555__$1);
var seq74555__$2 = cljs.core.next(seq74555__$1);
var G__74558 = cljs.core.first(seq74555__$2);
var seq74555__$3 = cljs.core.next(seq74555__$2);
var G__74559 = cljs.core.first(seq74555__$3);
var seq74555__$4 = cljs.core.next(seq74555__$3);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74556,G__74557,G__74558,G__74559,seq74555__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__74634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74634__$1 = cljs.core.__destructure_map(map__74634);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74634__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74634__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__74636 = conn_id;
var G__74637 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74638 = ref;
var G__74639 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74636,G__74637,G__74638,G__74639) : flureeworker.worker_action.call(null,G__74636,G__74637,G__74638,G__74639));
})());
var map__74635 = map_data;
var map__74635__$1 = cljs.core.__destructure_map(map__74635);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74635__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74635__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74635__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2749__auto___74693 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74660){
var state_val_74661 = (state_74660[(1)]);
if((state_val_74661 === (1))){
var state_74660__$1 = state_74660;
var statearr_74662_74694 = state_74660__$1;
(statearr_74662_74694[(2)] = null);

(statearr_74662_74694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74661 === (2))){
var ___$1 = (function (){var statearr_74663 = state_74660;
(statearr_74663[(4)] = cljs.core.cons((5),(state_74660[(4)])));

return statearr_74663;
})();
var inst_74651 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_74652 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__74664 = conn_id;
var G__74665 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74666 = ref;
var G__74667 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74664,G__74665,G__74666,G__74667) : flureeworker.worker_action.call(null,G__74664,G__74665,G__74666,G__74667));
});
})();
var inst_74653 = inst_74651.then(inst_74652);
var inst_74654 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e74668){var ___$2 = e74668;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__74669 = conn_id;
var G__74670 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74671 = ref;
var G__74672 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74669,G__74670,G__74671,G__74672) : flureeworker.worker_action.call(null,G__74669,G__74670,G__74671,G__74672));
} else {
var G__74673 = conn_id;
var G__74674 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74675 = ref;
var G__74676 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74673,G__74674,G__74675,G__74676) : flureeworker.worker_action.call(null,G__74673,G__74674,G__74675,G__74676));

}
});
})();
var inst_74655 = inst_74653.catch(inst_74654);
var ___$2 = (function (){var statearr_74677 = state_74660;
(statearr_74677[(4)] = cljs.core.rest((state_74660[(4)])));

return statearr_74677;
})();
var state_74660__$1 = state_74660;
var statearr_74678_74695 = state_74660__$1;
(statearr_74678_74695[(2)] = inst_74655);

(statearr_74678_74695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74661 === (3))){
var inst_74658 = (state_74660[(2)]);
var state_74660__$1 = state_74660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74660__$1,inst_74658);
} else {
if((state_val_74661 === (4))){
var inst_74640 = (state_74660[(2)]);
var inst_74641 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74642 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74640);
var inst_74643 = [(400),inst_74642];
var inst_74644 = cljs.core.PersistentHashMap.fromArrays(inst_74641,inst_74643);
var inst_74645 = (function (){var G__74680 = conn_id;
var G__74681 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74682 = ref;
var G__74683 = inst_74644;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74680,G__74681,G__74682,G__74683) : flureeworker.worker_action.call(null,G__74680,G__74681,G__74682,G__74683));
})();
var state_74660__$1 = state_74660;
var statearr_74684_74696 = state_74660__$1;
(statearr_74684_74696[(2)] = inst_74645);

(statearr_74684_74696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74661 === (5))){
var ___$1 = (function (){var statearr_74685 = state_74660;
(statearr_74685[(4)] = cljs.core.rest((state_74660[(4)])));

return statearr_74685;
})();
var state_74660__$1 = state_74660;
var ex74679 = (state_74660__$1[(2)]);
var statearr_74686_74697 = state_74660__$1;
(statearr_74686_74697[(5)] = ex74679);


var statearr_74687_74698 = state_74660__$1;
(statearr_74687_74698[(1)] = (4));

(statearr_74687_74698[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2727__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_74688 = [null,null,null,null,null,null,null];
(statearr_74688[(0)] = flureeworker$pw_generate_$_state_machine__2727__auto__);

(statearr_74688[(1)] = (1));

return statearr_74688;
});
var flureeworker$pw_generate_$_state_machine__2727__auto____1 = (function (state_74660){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74660);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74689){var ex__2730__auto__ = e74689;
var statearr_74690_74699 = state_74660;
(statearr_74690_74699[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74660[(4)]))){
var statearr_74691_74700 = state_74660;
(statearr_74691_74700[(1)] = cljs.core.first((state_74660[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74701 = state_74660;
state_74660 = G__74701;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2727__auto__ = function(state_74660){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2727__auto____1.call(this,state_74660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2727__auto____0;
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2727__auto____1;
return flureeworker$pw_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74692 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74692[(6)] = c__2749__auto___74693);

return statearr_74692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__74702_SHARP_){
return (js_array[p1__74702_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e74703){var e = e74703;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___74704 = cljs.core.not(self.document);
if(temp__5804__auto___74704){
var worker_QMARK__74705 = temp__5804__auto___74704;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__74706_74708 = null;
var G__74707_74709 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__74706_74708,G__74707_74709) : flureeworker.worker_action.call(null,G__74706_74708,G__74707_74709));
