// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__71656_71837 = cljs.core.seq(servers);
var chunk__71657_71838 = null;
var count__71658_71839 = (0);
var i__71659_71840 = (0);
while(true){
if((i__71659_71840 < count__71658_71839)){
var server_71841 = chunk__71657_71838.cljs$core$IIndexed$_nth$arity$2(null,i__71659_71840);
var healthcheck_uri_71842 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71841),"/fdb/health"].join('');
var resp_chan_71843 = fluree.db.util.xhttp.post_json(healthcheck_uri_71842,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___71844 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71844,healthcheck_uri_71842,resp_chan_71843,server_71841){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71844,healthcheck_uri_71842,resp_chan_71843,server_71841){
return (function (state_71729){
var state_val_71730 = (state_71729[(1)]);
if((state_val_71730 === (1))){
var state_71729__$1 = state_71729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71729__$1,(2),resp_chan_71843);
} else {
if((state_val_71730 === (2))){
var inst_71715 = (state_71729[(7)]);
var inst_71715__$1 = (state_71729[(2)]);
var inst_71716 = fluree.db.util.core.exception_QMARK_(inst_71715__$1);
var state_71729__$1 = (function (){var statearr_71731 = state_71729;
(statearr_71731[(7)] = inst_71715__$1);

return statearr_71731;
})();
if(inst_71716){
var statearr_71732_71845 = state_71729__$1;
(statearr_71732_71845[(1)] = (3));

} else {
var statearr_71733_71846 = state_71729__$1;
(statearr_71733_71846[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71730 === (3))){
var inst_71715 = (state_71729[(7)]);
var inst_71718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71719 = cljs.core.ex_message(inst_71715);
var inst_71720 = cljs.core.ex_data(inst_71715);
var inst_71721 = ["Server contact error: ",inst_71719,inst_71720];
var inst_71722 = (new cljs.core.PersistentVector(null,3,(5),inst_71718,inst_71721,null));
var inst_71723 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71722);
var state_71729__$1 = state_71729;
var statearr_71734_71847 = state_71729__$1;
(statearr_71734_71847[(2)] = inst_71723);

(statearr_71734_71847[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71730 === (4))){
var inst_71725 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_71841);
var state_71729__$1 = state_71729;
var statearr_71735_71848 = state_71729__$1;
(statearr_71735_71848[(2)] = inst_71725);

(statearr_71735_71848[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71730 === (5))){
var inst_71727 = (state_71729[(2)]);
var state_71729__$1 = state_71729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71729__$1,inst_71727);
} else {
return null;
}
}
}
}
}
});})(seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71844,healthcheck_uri_71842,resp_chan_71843,server_71841))
;
return ((function (seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,switch__2726__auto__,c__2749__auto___71844,healthcheck_uri_71842,resp_chan_71843,server_71841){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71736 = [null,null,null,null,null,null,null,null];
(statearr_71736[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71736[(1)] = (1));

return statearr_71736;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71729){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71729);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71737){var ex__2730__auto__ = e71737;
var statearr_71738_71849 = state_71729;
(statearr_71738_71849[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71729[(4)]))){
var statearr_71739_71850 = state_71729;
(statearr_71739_71850[(1)] = cljs.core.first((state_71729[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71851 = state_71729;
state_71729 = G__71851;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71729){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,switch__2726__auto__,c__2749__auto___71844,healthcheck_uri_71842,resp_chan_71843,server_71841))
})();
var state__2751__auto__ = (function (){var statearr_71740 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71740[(6)] = c__2749__auto___71844);

return statearr_71740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71844,healthcheck_uri_71842,resp_chan_71843,server_71841))
);



var G__71852 = seq__71656_71837;
var G__71853 = chunk__71657_71838;
var G__71854 = count__71658_71839;
var G__71855 = (i__71659_71840 + (1));
seq__71656_71837 = G__71852;
chunk__71657_71838 = G__71853;
count__71658_71839 = G__71854;
i__71659_71840 = G__71855;
continue;
} else {
var temp__5804__auto___71856 = cljs.core.seq(seq__71656_71837);
if(temp__5804__auto___71856){
var seq__71656_71857__$1 = temp__5804__auto___71856;
if(cljs.core.chunked_seq_QMARK_(seq__71656_71857__$1)){
var c__5568__auto___71858 = cljs.core.chunk_first(seq__71656_71857__$1);
var G__71859 = cljs.core.chunk_rest(seq__71656_71857__$1);
var G__71860 = c__5568__auto___71858;
var G__71861 = cljs.core.count(c__5568__auto___71858);
var G__71862 = (0);
seq__71656_71837 = G__71859;
chunk__71657_71838 = G__71860;
count__71658_71839 = G__71861;
i__71659_71840 = G__71862;
continue;
} else {
var server_71863 = cljs.core.first(seq__71656_71857__$1);
var healthcheck_uri_71864 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71863),"/fdb/health"].join('');
var resp_chan_71865 = fluree.db.util.xhttp.post_json(healthcheck_uri_71864,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___71866 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71866,healthcheck_uri_71864,resp_chan_71865,server_71863,seq__71656_71857__$1,temp__5804__auto___71856){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71866,healthcheck_uri_71864,resp_chan_71865,server_71863,seq__71656_71857__$1,temp__5804__auto___71856){
return (function (state_71756){
var state_val_71757 = (state_71756[(1)]);
if((state_val_71757 === (1))){
var state_71756__$1 = state_71756;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71756__$1,(2),resp_chan_71865);
} else {
if((state_val_71757 === (2))){
var inst_71742 = (state_71756[(7)]);
var inst_71742__$1 = (state_71756[(2)]);
var inst_71743 = fluree.db.util.core.exception_QMARK_(inst_71742__$1);
var state_71756__$1 = (function (){var statearr_71758 = state_71756;
(statearr_71758[(7)] = inst_71742__$1);

return statearr_71758;
})();
if(inst_71743){
var statearr_71759_71867 = state_71756__$1;
(statearr_71759_71867[(1)] = (3));

} else {
var statearr_71760_71868 = state_71756__$1;
(statearr_71760_71868[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71757 === (3))){
var inst_71742 = (state_71756[(7)]);
var inst_71745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71746 = cljs.core.ex_message(inst_71742);
var inst_71747 = cljs.core.ex_data(inst_71742);
var inst_71748 = ["Server contact error: ",inst_71746,inst_71747];
var inst_71749 = (new cljs.core.PersistentVector(null,3,(5),inst_71745,inst_71748,null));
var inst_71750 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_71749);
var state_71756__$1 = state_71756;
var statearr_71761_71869 = state_71756__$1;
(statearr_71761_71869[(2)] = inst_71750);

(statearr_71761_71869[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71757 === (4))){
var inst_71752 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_71863);
var state_71756__$1 = state_71756;
var statearr_71762_71870 = state_71756__$1;
(statearr_71762_71870[(2)] = inst_71752);

(statearr_71762_71870[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71757 === (5))){
var inst_71754 = (state_71756[(2)]);
var state_71756__$1 = state_71756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71756__$1,inst_71754);
} else {
return null;
}
}
}
}
}
});})(seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71866,healthcheck_uri_71864,resp_chan_71865,server_71863,seq__71656_71857__$1,temp__5804__auto___71856))
;
return ((function (seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,switch__2726__auto__,c__2749__auto___71866,healthcheck_uri_71864,resp_chan_71865,server_71863,seq__71656_71857__$1,temp__5804__auto___71856){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71763 = [null,null,null,null,null,null,null,null];
(statearr_71763[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71763[(1)] = (1));

return statearr_71763;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71756){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71756);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71764){var ex__2730__auto__ = e71764;
var statearr_71765_71871 = state_71756;
(statearr_71765_71871[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71756[(4)]))){
var statearr_71766_71872 = state_71756;
(statearr_71766_71872[(1)] = cljs.core.first((state_71756[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71873 = state_71756;
state_71756 = G__71873;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71756){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,switch__2726__auto__,c__2749__auto___71866,healthcheck_uri_71864,resp_chan_71865,server_71863,seq__71656_71857__$1,temp__5804__auto___71856))
})();
var state__2751__auto__ = (function (){var statearr_71767 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71767[(6)] = c__2749__auto___71866);

return statearr_71767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__71656_71837,chunk__71657_71838,count__71658_71839,i__71659_71840,c__2749__auto___71866,healthcheck_uri_71864,resp_chan_71865,server_71863,seq__71656_71857__$1,temp__5804__auto___71856))
);



var G__71874 = cljs.core.next(seq__71656_71857__$1);
var G__71875 = null;
var G__71876 = (0);
var G__71877 = (0);
seq__71656_71837 = G__71874;
chunk__71657_71838 = G__71875;
count__71658_71839 = G__71876;
i__71659_71840 = G__71877;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71811){
var state_val_71812 = (state_71811[(1)]);
if((state_val_71812 === (7))){
var inst_71783 = (state_71811[(7)]);
var inst_71790 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71783,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_71811__$1 = state_71811;
if(inst_71790){
var statearr_71813_71878 = state_71811__$1;
(statearr_71813_71878[(1)] = (9));

} else {
var statearr_71814_71879 = state_71811__$1;
(statearr_71814_71879[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (1))){
var inst_71776 = (state_71811[(8)]);
var inst_71775 = (state_71811[(9)]);
var inst_71775__$1 = promise_chan;
var inst_71776__$1 = cljs.core.async.timeout((60000));
var inst_71777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71778 = [inst_71775__$1,inst_71776__$1];
var inst_71779 = (new cljs.core.PersistentVector(null,2,(5),inst_71777,inst_71778,null));
var state_71811__$1 = (function (){var statearr_71815 = state_71811;
(statearr_71815[(8)] = inst_71776__$1);

(statearr_71815[(9)] = inst_71775__$1);

return statearr_71815;
})();
return cljs.core.async.ioc_alts_BANG_(state_71811__$1,(2),inst_71779);
} else {
if((state_val_71812 === (4))){
var inst_71776 = (state_71811[(8)]);
var inst_71783 = (state_71811[(7)]);
var inst_71787 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71783,inst_71776);
var state_71811__$1 = state_71811;
if(inst_71787){
var statearr_71816_71880 = state_71811__$1;
(statearr_71816_71880[(1)] = (6));

} else {
var statearr_71817_71881 = state_71811__$1;
(statearr_71817_71881[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (13))){
var state_71811__$1 = state_71811;
var statearr_71818_71882 = state_71811__$1;
(statearr_71818_71882[(2)] = null);

(statearr_71818_71882[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (6))){
var state_71811__$1 = state_71811;
var statearr_71819_71883 = state_71811__$1;
(statearr_71819_71883[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_71819_71883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (3))){
var state_71811__$1 = state_71811;
var statearr_71820_71884 = state_71811__$1;
(statearr_71820_71884[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_71820_71884[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (12))){
var inst_71801 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_71802 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71803 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_71804 = cljs.core.PersistentHashMap.fromArrays(inst_71802,inst_71803);
var inst_71805 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_71804);
var inst_71806 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_71805);
var state_71811__$1 = (function (){var statearr_71821 = state_71811;
(statearr_71821[(10)] = inst_71801);

return statearr_71821;
})();
var statearr_71822_71885 = state_71811__$1;
(statearr_71822_71885[(2)] = inst_71806);

(statearr_71822_71885[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (2))){
var inst_71775 = (state_71811[(9)]);
var inst_71783 = (state_71811[(7)]);
var inst_71781 = (state_71811[(2)]);
var inst_71782 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71781,(0),null);
var inst_71783__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71781,(1),null);
var inst_71784 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71783__$1,inst_71775);
var state_71811__$1 = (function (){var statearr_71823 = state_71811;
(statearr_71823[(11)] = inst_71782);

(statearr_71823[(7)] = inst_71783__$1);

return statearr_71823;
})();
if(inst_71784){
var statearr_71824_71886 = state_71811__$1;
(statearr_71824_71886[(1)] = (3));

} else {
var statearr_71825_71887 = state_71811__$1;
(statearr_71825_71887[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (11))){
var inst_71794 = (state_71811[(2)]);
var state_71811__$1 = state_71811;
var statearr_71826_71888 = state_71811__$1;
(statearr_71826_71888[(2)] = inst_71794);

(statearr_71826_71888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (9))){
var inst_71782 = (state_71811[(11)]);
var state_71811__$1 = state_71811;
var statearr_71827_71889 = state_71811__$1;
(statearr_71827_71889[(2)] = inst_71782);

(statearr_71827_71889[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (5))){
var inst_71798 = (state_71811[(2)]);
var inst_71799 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_71798);
var state_71811__$1 = state_71811;
if(inst_71799){
var statearr_71828_71890 = state_71811__$1;
(statearr_71828_71890[(1)] = (12));

} else {
var statearr_71829_71891 = state_71811__$1;
(statearr_71829_71891[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (14))){
var inst_71809 = (state_71811[(2)]);
var state_71811__$1 = state_71811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71811__$1,inst_71809);
} else {
if((state_val_71812 === (10))){
var state_71811__$1 = state_71811;
var statearr_71830_71892 = state_71811__$1;
(statearr_71830_71892[(2)] = null);

(statearr_71830_71892[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71812 === (8))){
var inst_71796 = (state_71811[(2)]);
var state_71811__$1 = state_71811;
var statearr_71831_71893 = state_71811__$1;
(statearr_71831_71893[(2)] = inst_71796);

(statearr_71831_71893[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_71832 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71832[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_71832[(1)] = (1));

return statearr_71832;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_71811){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71811);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71833){var ex__2730__auto__ = e71833;
var statearr_71834_71894 = state_71811;
(statearr_71834_71894[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71811[(4)]))){
var statearr_71835_71895 = state_71811;
(statearr_71835_71895[(1)] = cljs.core.first((state_71811[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71896 = state_71811;
state_71811 = G__71896;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_71811){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_71811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71836 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71836[(6)] = c__2749__auto__);

return statearr_71836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_71940){
var state_val_71941 = (state_71940[(1)]);
if((state_val_71941 === (7))){
var state_71940__$1 = state_71940;
var statearr_71942_71968 = state_71940__$1;
(statearr_71942_71968[(2)] = null);

(statearr_71942_71968[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (1))){
var state_71940__$1 = state_71940;
var statearr_71943_71969 = state_71940__$1;
(statearr_71943_71969[(2)] = null);

(statearr_71943_71969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (4))){
var inst_71897 = (state_71940[(2)]);
var state_71940__$1 = state_71940;
var statearr_71944_71970 = state_71940__$1;
(statearr_71944_71970[(2)] = inst_71897);

(statearr_71944_71970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (6))){
var inst_71919 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_71940__$1 = state_71940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71940__$1,(9),inst_71919);
} else {
if((state_val_71941 === (3))){
var inst_71938 = (state_71940[(2)]);
var state_71940__$1 = state_71940;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71940__$1,inst_71938);
} else {
if((state_val_71941 === (12))){
var inst_71932 = (state_71940[(2)]);
var state_71940__$1 = state_71940;
var statearr_71945_71971 = state_71940__$1;
(statearr_71945_71971[(2)] = inst_71932);

(statearr_71945_71971[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (2))){
var inst_71908 = (state_71940[(7)]);
var inst_71913 = (state_71940[(8)]);
var inst_71903 = (state_71940[(9)]);
var _ = (function (){var statearr_71946 = state_71940;
(statearr_71946[(4)] = cljs.core.cons((5),(state_71940[(4)])));

return statearr_71946;
})();
var inst_71903__$1 = cljs.core.random_uuid();
var inst_71904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71905 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_71906 = (new cljs.core.PersistentVector(null,2,(5),inst_71904,inst_71905,null));
var inst_71907 = (function (){var lock_id = inst_71903__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_71908__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_71906,inst_71907);
var inst_71909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71910 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_71911 = (new cljs.core.PersistentVector(null,3,(5),inst_71909,inst_71910,null));
var inst_71912 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71908__$1,inst_71911);
var inst_71913__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71903__$1,inst_71912);
var inst_71914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71915 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71916 = (new cljs.core.PersistentVector(null,3,(5),inst_71914,inst_71915,null));
var inst_71917 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_71908__$1,inst_71916);
var state_71940__$1 = (function (){var statearr_71947 = state_71940;
(statearr_71947[(7)] = inst_71908__$1);

(statearr_71947[(10)] = inst_71917);

(statearr_71947[(8)] = inst_71913__$1);

(statearr_71947[(9)] = inst_71903__$1);

return statearr_71947;
})();
if(inst_71913__$1){
var statearr_71948_71972 = state_71940__$1;
(statearr_71948_71972[(1)] = (6));

} else {
var statearr_71949_71973 = state_71940__$1;
(statearr_71949_71973[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (11))){
var inst_71917 = (state_71940[(10)]);
var inst_71924 = (state_71940[(11)]);
var inst_71923 = (state_71940[(12)]);
var inst_71930 = fluree.db.util.xhttp.try_socket(inst_71923,sub_chan,pub_chan,inst_71917,(60000),inst_71924);
var state_71940__$1 = state_71940;
var statearr_71951_71974 = state_71940__$1;
(statearr_71951_71974[(2)] = inst_71930);

(statearr_71951_71974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (9))){
var inst_71908 = (state_71940[(7)]);
var inst_71917 = (state_71940[(10)]);
var inst_71913 = (state_71940[(8)]);
var inst_71923 = (state_71940[(12)]);
var inst_71921 = (state_71940[(13)]);
var inst_71903 = (state_71940[(9)]);
var inst_71921__$1 = (state_71940[(2)]);
var inst_71922 = clojure.string.replace(inst_71921__$1,"http","ws");
var inst_71923__$1 = [inst_71922,"/fdb/ws"].join('');
var inst_71924 = (function (){var lock_id = inst_71903;
var state = inst_71908;
var have_lock_QMARK_ = inst_71913;
var resp_chan = inst_71917;
var healthy_server = inst_71921__$1;
var ws_url = inst_71923__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_71925 = fluree.db.util.core.exception_QMARK_(inst_71921__$1);
var state_71940__$1 = (function (){var statearr_71952 = state_71940;
(statearr_71952[(11)] = inst_71924);

(statearr_71952[(12)] = inst_71923__$1);

(statearr_71952[(13)] = inst_71921__$1);

return statearr_71952;
})();
if(inst_71925){
var statearr_71953_71975 = state_71940__$1;
(statearr_71953_71975[(1)] = (10));

} else {
var statearr_71954_71976 = state_71940__$1;
(statearr_71954_71976[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (5))){
var _ = (function (){var statearr_71955 = state_71940;
(statearr_71955[(4)] = cljs.core.rest((state_71940[(4)])));

return statearr_71955;
})();
var state_71940__$1 = state_71940;
var ex71950 = (state_71940__$1[(2)]);
var statearr_71956_71977 = state_71940__$1;
(statearr_71956_71977[(5)] = ex71950);


if((ex71950 instanceof Error)){
var statearr_71957_71978 = state_71940__$1;
(statearr_71957_71978[(1)] = (4));

(statearr_71957_71978[(5)] = null);

} else {
throw ex71950;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (10))){
var inst_71917 = (state_71940[(10)]);
var inst_71921 = (state_71940[(13)]);
var inst_71927 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_71928 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_71917,inst_71921);
var state_71940__$1 = (function (){var statearr_71958 = state_71940;
(statearr_71958[(14)] = inst_71927);

return statearr_71958;
})();
var statearr_71959_71979 = state_71940__$1;
(statearr_71959_71979[(2)] = inst_71928);

(statearr_71959_71979[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71941 === (8))){
var inst_71917 = (state_71940[(10)]);
var inst_71935 = (state_71940[(2)]);
var _ = (function (){var statearr_71960 = state_71940;
(statearr_71960[(4)] = cljs.core.rest((state_71940[(4)])));

return statearr_71960;
})();
var state_71940__$1 = (function (){var statearr_71961 = state_71940;
(statearr_71961[(15)] = inst_71935);

return statearr_71961;
})();
var statearr_71962_71980 = state_71940__$1;
(statearr_71962_71980[(2)] = inst_71917);

(statearr_71962_71980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_71963 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71963[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_71963[(1)] = (1));

return statearr_71963;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_71940){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_71940);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e71964){var ex__2730__auto__ = e71964;
var statearr_71965_71981 = state_71940;
(statearr_71965_71981[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_71940[(4)]))){
var statearr_71966_71982 = state_71940;
(statearr_71966_71982[(1)] = cljs.core.first((state_71940[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71983 = state_71940;
state_71940 = G__71983;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_71940){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_71940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_71967 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_71967[(6)] = c__2749__auto__);

return statearr_71967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k71985,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__71989 = k71985;
var G__71989__$1 = (((G__71989 instanceof cljs.core.Keyword))?G__71989.fqn:null);
switch (G__71989__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k71985,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__71990){
var vec__71991 = p__71990;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71991,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71991,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71984){
var self__ = this;
var G__71984__$1 = this;
return (new cljs.core.RecordIter((0),G__71984__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__71994 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__71994(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71986,other71987){
var self__ = this;
var this71986__$1 = this;
return (((!((other71987 == null)))) && ((((this71986__$1.constructor === other71987.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.id,other71987.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.servers,other71987.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.state,other71987.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.req_chan,other71987.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.sub_chan,other71987.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.pub_chan,other71987.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.group,other71987.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.storage_read,other71987.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.storage_list,other71987.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.storage_write,other71987.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.storage_exists,other71987.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.storage_rename,other71987.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.storage_delete,other71987.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.object_cache,other71987.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.async_cache,other71987.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.parallelism,other71987.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.serializer,other71987.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.default_network,other71987.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.transactor_QMARK_,other71987.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.publish,other71987.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.transact_handler,other71987.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.tx_private_key,other71987.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.tx_key_id,other71987.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.meta,other71987.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.add_listener,other71987.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.remove_listener,other71987.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.close,other71987.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71986__$1.__extmap,other71987.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__71995){
var self__ = this;
var map__71996 = p__71995;
var map__71996__$1 = cljs.core.__destructure_map(map__71996);
var node = map__71996__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71996__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71996__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71996__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__71997 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__71998 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__71999 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__72000 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__71999,G__72000) : self__.async_cache.call(null,G__71999,G__72000));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__71997,G__71998) : self__.async_cache.call(null,G__71997,G__71998));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k71985){
var self__ = this;
var this__5350__auto____$1 = this;
var G__72001 = k71985;
var G__72001__$1 = (((G__72001 instanceof cljs.core.Keyword))?G__72001.fqn:null);
switch (G__72001__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k71985);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__71984){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__72002 = cljs.core.keyword_identical_QMARK_;
var expr__72003 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__72005 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__72006 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72005,G__72006) : pred__72002.call(null,G__72005,G__72006));
})())){
return (new fluree.db.connection.Connection(G__71984,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72007 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__72008 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72007,G__72008) : pred__72002.call(null,G__72007,G__72008));
})())){
return (new fluree.db.connection.Connection(self__.id,G__71984,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72009 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__72010 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72009,G__72010) : pred__72002.call(null,G__72009,G__72010));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__71984,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72011 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__72012 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72011,G__72012) : pred__72002.call(null,G__72011,G__72012));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__71984,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72013 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__72014 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72013,G__72014) : pred__72002.call(null,G__72013,G__72014));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__71984,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72015 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__72016 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72015,G__72016) : pred__72002.call(null,G__72015,G__72016));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__71984,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72017 = new cljs.core.Keyword(null,"group","group",582596132);
var G__72018 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72017,G__72018) : pred__72002.call(null,G__72017,G__72018));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__71984,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72019 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__72020 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72019,G__72020) : pred__72002.call(null,G__72019,G__72020));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__71984,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72021 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__72022 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72021,G__72022) : pred__72002.call(null,G__72021,G__72022));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__71984,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72023 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__72024 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72023,G__72024) : pred__72002.call(null,G__72023,G__72024));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__71984,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72025 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__72026 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72025,G__72026) : pred__72002.call(null,G__72025,G__72026));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__71984,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72027 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__72028 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72027,G__72028) : pred__72002.call(null,G__72027,G__72028));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__71984,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72029 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__72030 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72029,G__72030) : pred__72002.call(null,G__72029,G__72030));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__71984,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72031 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__72032 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72031,G__72032) : pred__72002.call(null,G__72031,G__72032));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__71984,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72033 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__72034 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72033,G__72034) : pred__72002.call(null,G__72033,G__72034));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__71984,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72035 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__72036 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72035,G__72036) : pred__72002.call(null,G__72035,G__72036));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__71984,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72037 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__72038 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72037,G__72038) : pred__72002.call(null,G__72037,G__72038));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__71984,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72039 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__72040 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72039,G__72040) : pred__72002.call(null,G__72039,G__72040));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__71984,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72041 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__72042 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72041,G__72042) : pred__72002.call(null,G__72041,G__72042));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__71984,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72043 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__72044 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72043,G__72044) : pred__72002.call(null,G__72043,G__72044));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__71984,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72045 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__72046 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72045,G__72046) : pred__72002.call(null,G__72045,G__72046));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__71984,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72047 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__72048 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72047,G__72048) : pred__72002.call(null,G__72047,G__72048));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__71984,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72049 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__72050 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72049,G__72050) : pred__72002.call(null,G__72049,G__72050));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__71984,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72051 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__72052 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72051,G__72052) : pred__72002.call(null,G__72051,G__72052));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__71984,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72053 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__72054 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72053,G__72054) : pred__72002.call(null,G__72053,G__72054));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__71984,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72055 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__72056 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72055,G__72056) : pred__72002.call(null,G__72055,G__72056));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__71984,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72057 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__72058 = expr__72003;
return (pred__72002.cljs$core$IFn$_invoke$arity$2 ? pred__72002.cljs$core$IFn$_invoke$arity$2(G__72057,G__72058) : pred__72002.call(null,G__72057,G__72058));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__71984,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__71984),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__71984){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__71984,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__71988){
var extmap__5385__auto__ = (function (){var G__72059 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__71988,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__71988)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__72059);
} else {
return G__72059;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__71988),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__71988),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__72065 = servers_STAR_;
var vec__72066 = G__72065;
var seq__72067 = cljs.core.seq(vec__72066);
var first__72068 = cljs.core.first(seq__72067);
var seq__72067__$1 = cljs.core.next(seq__72067);
var server = first__72068;
var r = seq__72067__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__72065__$1 = G__72065;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__72072 = G__72065__$1;
var seq__72073 = cljs.core.seq(vec__72072);
var first__72074 = cljs.core.first(seq__72073);
var seq__72073__$1 = cljs.core.next(seq__72073);
var server__$1 = first__72074;
var r__$1 = seq__72073__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__72075 = r__$1;
var G__72076 = is_https_QMARK_;
var G__72077 = result_STAR_;
G__72065__$1 = G__72075;
https_QMARK___$1 = G__72076;
result__$1 = G__72077;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__72078 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__72078 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__72078);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72107){
var state_val_72108 = (state_72107[(1)]);
if((state_val_72108 === (7))){
var inst_72093 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72094 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72095 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72096 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72097 = fluree.db.connection.establish_socket(inst_72093,inst_72094,inst_72095,inst_72096);
var state_72107__$1 = state_72107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72107__$1,(9),inst_72097);
} else {
if((state_val_72108 === (1))){
var state_72107__$1 = state_72107;
var statearr_72109_72128 = state_72107__$1;
(statearr_72109_72128[(2)] = null);

(statearr_72109_72128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72108 === (4))){
var inst_72079 = (state_72107[(2)]);
var state_72107__$1 = state_72107;
var statearr_72110_72129 = state_72107__$1;
(statearr_72110_72129[(2)] = inst_72079);

(statearr_72110_72129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72108 === (6))){
var inst_72090 = (state_72107[(7)]);
var state_72107__$1 = state_72107;
var statearr_72111_72130 = state_72107__$1;
(statearr_72111_72130[(2)] = inst_72090);

(statearr_72111_72130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72108 === (3))){
var inst_72105 = (state_72107[(2)]);
var state_72107__$1 = state_72107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72107__$1,inst_72105);
} else {
if((state_val_72108 === (2))){
var inst_72090 = (state_72107[(7)]);
var _ = (function (){var statearr_72113 = state_72107;
(statearr_72113[(4)] = cljs.core.cons((5),(state_72107[(4)])));

return statearr_72113;
})();
var inst_72085 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_72086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72087 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72088 = [inst_72087,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_72089 = (new cljs.core.PersistentVector(null,3,(5),inst_72086,inst_72088,null));
var inst_72090__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72085,inst_72089);
var state_72107__$1 = (function (){var statearr_72114 = state_72107;
(statearr_72114[(7)] = inst_72090__$1);

return statearr_72114;
})();
if(cljs.core.truth_(inst_72090__$1)){
var statearr_72115_72131 = state_72107__$1;
(statearr_72115_72131[(1)] = (6));

} else {
var statearr_72116_72132 = state_72107__$1;
(statearr_72116_72132[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72108 === (9))){
var inst_72099 = (state_72107[(2)]);
var inst_72100 = fluree.db.util.async.throw_err(inst_72099);
var state_72107__$1 = state_72107;
var statearr_72117_72133 = state_72107__$1;
(statearr_72117_72133[(2)] = inst_72100);

(statearr_72117_72133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72108 === (5))){
var _ = (function (){var statearr_72118 = state_72107;
(statearr_72118[(4)] = cljs.core.rest((state_72107[(4)])));

return statearr_72118;
})();
var state_72107__$1 = state_72107;
var ex72112 = (state_72107__$1[(2)]);
var statearr_72119_72134 = state_72107__$1;
(statearr_72119_72134[(5)] = ex72112);


if((ex72112 instanceof Error)){
var statearr_72120_72135 = state_72107__$1;
(statearr_72120_72135[(1)] = (4));

(statearr_72120_72135[(5)] = null);

} else {
throw ex72112;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72108 === (8))){
var inst_72102 = (state_72107[(2)]);
var _ = (function (){var statearr_72121 = state_72107;
(statearr_72121[(4)] = cljs.core.rest((state_72107[(4)])));

return statearr_72121;
})();
var state_72107__$1 = state_72107;
var statearr_72122_72136 = state_72107__$1;
(statearr_72122_72136[(2)] = inst_72102);

(statearr_72122_72136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_72123 = [null,null,null,null,null,null,null,null];
(statearr_72123[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_72123[(1)] = (1));

return statearr_72123;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_72107){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72107);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72124){var ex__2730__auto__ = e72124;
var statearr_72125_72137 = state_72107;
(statearr_72125_72137[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72107[(4)]))){
var statearr_72126_72138 = state_72107;
(statearr_72126_72138[(1)] = cljs.core.first((state_72107[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72139 = state_72107;
state_72107 = G__72139;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_72107){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_72107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72127 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72127[(6)] = c__2749__auto__);

return statearr_72127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e72140){var e = e72140;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__72142){
var map__72143 = p__72142;
var map__72143__$1 = cljs.core.__destructure_map(map__72143);
var conn = map__72143__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72143__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72143__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72143__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72289){
var state_val_72290 = (state_72289[(1)]);
if((state_val_72290 === (7))){
var inst_72285 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
var statearr_72292_72366 = state_72289__$1;
(statearr_72292_72366[(2)] = inst_72285);

(statearr_72292_72366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (20))){
var _ = (function (){var statearr_72293 = state_72289;
(statearr_72293[(4)] = cljs.core.rest((state_72289[(4)])));

return statearr_72293;
})();
var state_72289__$1 = state_72289;
var ex72291 = (state_72289__$1[(2)]);
var statearr_72294_72367 = state_72289__$1;
(statearr_72294_72367[(5)] = ex72291);


var statearr_72295_72368 = state_72289__$1;
(statearr_72295_72368[(1)] = (10));

(statearr_72295_72368[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (27))){
var inst_72246 = (state_72289[(7)]);
var inst_72246__$1 = (state_72289[(2)]);
var inst_72247 = inst_72246__$1 === true;
var state_72289__$1 = (function (){var statearr_72296 = state_72289;
(statearr_72296[(7)] = inst_72246__$1);

return statearr_72296;
})();
if(cljs.core.truth_(inst_72247)){
var statearr_72297_72369 = state_72289__$1;
(statearr_72297_72369[(1)] = (28));

} else {
var statearr_72298_72370 = state_72289__$1;
(statearr_72298_72370[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (1))){
var inst_72144 = (0);
var state_72289__$1 = (function (){var statearr_72299 = state_72289;
(statearr_72299[(8)] = inst_72144);

return statearr_72299;
})();
var statearr_72300_72371 = state_72289__$1;
(statearr_72300_72371[(2)] = null);

(statearr_72300_72371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (24))){
var inst_72236 = (state_72289[(9)]);
var state_72289__$1 = state_72289;
var statearr_72301_72372 = state_72289__$1;
(statearr_72301_72372[(2)] = inst_72236);

(statearr_72301_72372[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (39))){
var inst_72271 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
var statearr_72302_72373 = state_72289__$1;
(statearr_72302_72373[(2)] = inst_72271);

(statearr_72302_72373[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (4))){
var inst_72147 = (state_72289[(10)]);
var inst_72147__$1 = (state_72289[(2)]);
var state_72289__$1 = (function (){var statearr_72303 = state_72289;
(statearr_72303[(10)] = inst_72147__$1);

return statearr_72303;
})();
if(cljs.core.truth_(inst_72147__$1)){
var statearr_72304_72374 = state_72289__$1;
(statearr_72304_72374[(1)] = (5));

} else {
var statearr_72305_72375 = state_72289__$1;
(statearr_72305_72375[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (15))){
var inst_72160 = (state_72289[(11)]);
var state_72289__$1 = state_72289;
var statearr_72306_72376 = state_72289__$1;
(statearr_72306_72376[(2)] = inst_72160);

(statearr_72306_72376[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (21))){
var inst_72144 = (state_72289[(8)]);
var inst_72147 = (state_72289[(10)]);
var inst_72190 = (state_72289[(12)]);
var inst_72193 = (state_72289[(13)]);
var inst_72194 = (state_72289[(14)]);
var inst_72198 = (state_72289[(15)]);
var inst_72197 = (state_72289[(16)]);
var inst_72189 = (state_72289[(17)]);
var inst_72191 = (state_72289[(18)]);
var inst_72192 = (state_72289[(19)]);
var inst_72200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72201 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_72197];
var inst_72202 = (new cljs.core.PersistentVector(null,2,(5),inst_72200,inst_72201,null));
var inst_72203 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_72202,inst_72192);
var inst_72230 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_72231 = (function (){var resp_chan = inst_72192;
var timeout = inst_72198;
var c__2749__auto____$1 = inst_72230;
var i = inst_72144;
var data = inst_72191;
var vec__72182 = inst_72147;
var map__72185 = inst_72194;
var _ = inst_72189;
var req_id = inst_72197;
var operation = inst_72190;
var msg = inst_72147;
var temp__5804__auto__ = inst_72147;
var opts = inst_72193;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72228){
var state_val_72229 = (state_72228[(1)]);
if((state_val_72229 === (1))){
var inst_72207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72208 = cljs.core.async.timeout(timeout);
var inst_72209 = [resp_chan,inst_72208];
var inst_72210 = (new cljs.core.PersistentVector(null,2,(5),inst_72207,inst_72209,null));
var state_72228__$1 = state_72228;
return cljs.core.async.ioc_alts_BANG_(state_72228__$1,(2),inst_72210);
} else {
if((state_val_72229 === (2))){
var inst_72213 = (state_72228[(7)]);
var inst_72212 = (state_72228[(2)]);
var inst_72213__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72212,(0),null);
var inst_72214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72212,(1),null);
var inst_72215 = (function (){var vec__72204 = inst_72212;
var resp = inst_72213__$1;
var c = inst_72214;
return (function (p1__72141_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__72141_SHARP_,req_id);
});
})();
var inst_72216 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_72215);
var inst_72217 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72214,resp_chan);
var state_72228__$1 = (function (){var statearr_72307 = state_72228;
(statearr_72307[(7)] = inst_72213__$1);

(statearr_72307[(8)] = inst_72216);

return statearr_72307;
})();
if(inst_72217){
var statearr_72308_72377 = state_72228__$1;
(statearr_72308_72377[(1)] = (3));

} else {
var statearr_72309_72378 = state_72228__$1;
(statearr_72309_72378[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72229 === (3))){
var inst_72213 = (state_72228[(7)]);
var state_72228__$1 = state_72228;
var statearr_72310_72379 = state_72228__$1;
(statearr_72310_72379[(2)] = inst_72213);

(statearr_72310_72379[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72229 === (4))){
var inst_72220 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_72221 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72222 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_72223 = cljs.core.PersistentHashMap.fromArrays(inst_72221,inst_72222);
var inst_72224 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72220,inst_72223);
var state_72228__$1 = state_72228;
var statearr_72311_72380 = state_72228__$1;
(statearr_72311_72380[(2)] = inst_72224);

(statearr_72311_72380[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72229 === (5))){
var inst_72226 = (state_72228[(2)]);
var state_72228__$1 = state_72228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72228__$1,inst_72226);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_72312 = [null,null,null,null,null,null,null,null,null];
(statearr_72312[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_72312[(1)] = (1));

return statearr_72312;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_72228){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72228);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72313){var ex__2730__auto__ = e72313;
var statearr_72314_72381 = state_72228;
(statearr_72314_72381[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72228[(4)]))){
var statearr_72315_72382 = state_72228;
(statearr_72315_72382[(1)] = cljs.core.first((state_72228[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72383 = state_72228;
state_72228 = G__72383;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_72228){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_72228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72316 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72316[(6)] = c__2749__auto____$1);

return statearr_72316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_72232 = cljs.core.async.impl.dispatch.run(inst_72231);
var state_72289__$1 = (function (){var statearr_72317 = state_72289;
(statearr_72317[(20)] = inst_72232);

(statearr_72317[(21)] = inst_72203);

return statearr_72317;
})();
var statearr_72318_72384 = state_72289__$1;
(statearr_72318_72384[(2)] = inst_72230);

(statearr_72318_72384[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (31))){
var inst_72246 = (state_72289[(7)]);
var inst_72252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72253 = [inst_72246,"Error processing message in producer."];
var inst_72254 = (new cljs.core.PersistentVector(null,2,(5),inst_72252,inst_72253,null));
var inst_72255 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72254);
var state_72289__$1 = state_72289;
var statearr_72319_72385 = state_72289__$1;
(statearr_72319_72385[(2)] = inst_72255);

(statearr_72319_72385[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (32))){
var inst_72246 = (state_72289[(7)]);
var inst_72257 = (inst_72246 == null);
var state_72289__$1 = state_72289;
if(cljs.core.truth_(inst_72257)){
var statearr_72320_72386 = state_72289__$1;
(statearr_72320_72386[(1)] = (34));

} else {
var statearr_72321_72387 = state_72289__$1;
(statearr_72321_72387[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (33))){
var inst_72275 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
var statearr_72322_72388 = state_72289__$1;
(statearr_72322_72388[(2)] = inst_72275);

(statearr_72322_72388[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (13))){
var inst_72160 = (state_72289[(11)]);
var inst_72157 = (state_72289[(2)]);
var inst_72158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72157,(0),null);
var inst_72159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72157,(1),null);
var inst_72160__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72157,(2),null);
var state_72289__$1 = (function (){var statearr_72323 = state_72289;
(statearr_72323[(11)] = inst_72160__$1);

(statearr_72323[(22)] = inst_72158);

(statearr_72323[(23)] = inst_72159);

return statearr_72323;
})();
if(cljs.core.truth_(inst_72160__$1)){
var statearr_72324_72389 = state_72289__$1;
(statearr_72324_72389[(1)] = (14));

} else {
var statearr_72325_72390 = state_72289__$1;
(statearr_72325_72390[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (22))){
var state_72289__$1 = state_72289;
var statearr_72326_72391 = state_72289__$1;
(statearr_72326_72391[(2)] = null);

(statearr_72326_72391[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (36))){
var inst_72273 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
var statearr_72327_72392 = state_72289__$1;
(statearr_72327_72392[(2)] = inst_72273);

(statearr_72327_72392[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (29))){
var inst_72246 = (state_72289[(7)]);
var inst_72250 = fluree.db.util.core.exception_QMARK_(inst_72246);
var state_72289__$1 = state_72289;
if(inst_72250){
var statearr_72328_72393 = state_72289__$1;
(statearr_72328_72393[(1)] = (31));

} else {
var statearr_72329_72394 = state_72289__$1;
(statearr_72329_72394[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (6))){
var state_72289__$1 = state_72289;
var statearr_72330_72395 = state_72289__$1;
(statearr_72330_72395[(2)] = null);

(statearr_72330_72395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (28))){
var state_72289__$1 = state_72289;
var statearr_72331_72396 = state_72289__$1;
(statearr_72331_72396[(2)] = null);

(statearr_72331_72396[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (25))){
var state_72289__$1 = state_72289;
var statearr_72332_72397 = state_72289__$1;
(statearr_72332_72397[(2)] = fluree.db.connection.default_publish_fn);

(statearr_72332_72397[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (34))){
var inst_72259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72260 = ["Error processing message in producer. Socket closed."];
var inst_72261 = (new cljs.core.PersistentVector(null,1,(5),inst_72259,inst_72260,null));
var inst_72262 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72261);
var state_72289__$1 = state_72289;
var statearr_72333_72398 = state_72289__$1;
(statearr_72333_72398[(2)] = inst_72262);

(statearr_72333_72398[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (17))){
var inst_72160 = (state_72289[(11)]);
var inst_72149 = (state_72289[(24)]);
var inst_72167 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72160,inst_72149);
var state_72289__$1 = state_72289;
var statearr_72334_72399 = state_72289__$1;
(statearr_72334_72399[(2)] = inst_72167);

(statearr_72334_72399[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (3))){
var inst_72287 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72289__$1,inst_72287);
} else {
if((state_val_72290 === (12))){
var state_72289__$1 = state_72289;
var statearr_72335_72400 = state_72289__$1;
(statearr_72335_72400[(2)] = null);

(statearr_72335_72400[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (2))){
var state_72289__$1 = state_72289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72289__$1,(4),req_chan);
} else {
if((state_val_72290 === (23))){
var inst_72236 = (state_72289[(9)]);
var inst_72235 = (state_72289[(2)]);
var inst_72236__$1 = publish;
var state_72289__$1 = (function (){var statearr_72336 = state_72289;
(statearr_72336[(25)] = inst_72235);

(statearr_72336[(9)] = inst_72236__$1);

return statearr_72336;
})();
if(cljs.core.truth_(inst_72236__$1)){
var statearr_72337_72401 = state_72289__$1;
(statearr_72337_72401[(1)] = (24));

} else {
var statearr_72338_72402 = state_72289__$1;
(statearr_72338_72402[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (35))){
var state_72289__$1 = state_72289;
var statearr_72339_72403 = state_72289__$1;
(statearr_72339_72403[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (19))){
var inst_72176 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
var statearr_72341_72404 = state_72289__$1;
(statearr_72341_72404[(2)] = inst_72176);

(statearr_72341_72404[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (11))){
var inst_72147 = (state_72289[(10)]);
var state_72289__$1 = state_72289;
var statearr_72342_72405 = state_72289__$1;
(statearr_72342_72405[(2)] = inst_72147);

(statearr_72342_72405[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (9))){
var inst_72144 = (state_72289[(8)]);
var inst_72280 = (state_72289[(2)]);
var inst_72281 = (inst_72144 + (1));
var inst_72144__$1 = inst_72281;
var state_72289__$1 = (function (){var statearr_72343 = state_72289;
(statearr_72343[(8)] = inst_72144__$1);

(statearr_72343[(26)] = inst_72280);

return statearr_72343;
})();
var statearr_72344_72406 = state_72289__$1;
(statearr_72344_72406[(2)] = null);

(statearr_72344_72406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (5))){
var state_72289__$1 = state_72289;
var statearr_72345_72407 = state_72289__$1;
(statearr_72345_72407[(2)] = null);

(statearr_72345_72407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (14))){
var inst_72160 = (state_72289[(11)]);
var inst_72162 = fluree.db.util.async.channel_QMARK_(inst_72160);
var state_72289__$1 = state_72289;
var statearr_72346_72408 = state_72289__$1;
(statearr_72346_72408[(2)] = inst_72162);

(statearr_72346_72408[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (26))){
var inst_72190 = (state_72289[(12)]);
var inst_72197 = (state_72289[(16)]);
var inst_72191 = (state_72289[(18)]);
var inst_72240 = (state_72289[(2)]);
var inst_72241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72242 = [inst_72190,inst_72197,inst_72191];
var inst_72243 = (new cljs.core.PersistentVector(null,3,(5),inst_72241,inst_72242,null));
var inst_72244 = (inst_72240.cljs$core$IFn$_invoke$arity$2 ? inst_72240.cljs$core$IFn$_invoke$arity$2(conn,inst_72243) : inst_72240.call(null,conn,inst_72243));
var state_72289__$1 = state_72289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72289__$1,(27),inst_72244);
} else {
if((state_val_72290 === (16))){
var inst_72165 = (state_72289[(2)]);
var state_72289__$1 = state_72289;
if(cljs.core.truth_(inst_72165)){
var statearr_72347_72409 = state_72289__$1;
(statearr_72347_72409[(1)] = (17));

} else {
var statearr_72348_72410 = state_72289__$1;
(statearr_72348_72410[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (38))){
var state_72289__$1 = state_72289;
var statearr_72349_72411 = state_72289__$1;
(statearr_72349_72411[(2)] = null);

(statearr_72349_72411[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (30))){
var inst_72277 = (state_72289[(2)]);
var _ = (function (){var statearr_72350 = state_72289;
(statearr_72350[(4)] = cljs.core.rest((state_72289[(4)])));

return statearr_72350;
})();
var state_72289__$1 = state_72289;
var statearr_72351_72412 = state_72289__$1;
(statearr_72351_72412[(2)] = inst_72277);

(statearr_72351_72412[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (10))){
var inst_72147 = (state_72289[(10)]);
var inst_72149 = (state_72289[(2)]);
var inst_72153 = cljs.core.sequential_QMARK_(inst_72147);
var state_72289__$1 = (function (){var statearr_72352 = state_72289;
(statearr_72352[(24)] = inst_72149);

return statearr_72352;
})();
if(inst_72153){
var statearr_72353_72413 = state_72289__$1;
(statearr_72353_72413[(1)] = (11));

} else {
var statearr_72354_72414 = state_72289__$1;
(statearr_72354_72414[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (18))){
var inst_72147 = (state_72289[(10)]);
var inst_72149 = (state_72289[(24)]);
var inst_72169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72170 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_72147], 0));
var inst_72171 = ["Error processing ledger request, no valid return channel: ",inst_72170].join('');
var inst_72172 = [inst_72149,inst_72171];
var inst_72173 = (new cljs.core.PersistentVector(null,2,(5),inst_72169,inst_72172,null));
var inst_72174 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72173);
var state_72289__$1 = state_72289;
var statearr_72355_72415 = state_72289__$1;
(statearr_72355_72415[(2)] = inst_72174);

(statearr_72355_72415[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (37))){
var inst_72246 = (state_72289[(7)]);
var inst_72265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72266 = ["Error processing message in producer. Socket closed. Published result",inst_72246];
var inst_72267 = (new cljs.core.PersistentVector(null,2,(5),inst_72265,inst_72266,null));
var inst_72268 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72267);
var state_72289__$1 = state_72289;
var statearr_72356_72416 = state_72289__$1;
(statearr_72356_72416[(2)] = inst_72268);

(statearr_72356_72416[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72290 === (8))){
var inst_72147 = (state_72289[(10)]);
var inst_72193 = (state_72289[(13)]);
var inst_72194 = (state_72289[(14)]);
var inst_72192 = (state_72289[(19)]);
var _ = (function (){var statearr_72357 = state_72289;
(statearr_72357[(4)] = cljs.core.cons((20),(state_72289[(4)])));

return statearr_72357;
})();
var inst_72186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72187 = ["Outgoing message to websocket: ",inst_72147];
var inst_72188 = (new cljs.core.PersistentVector(null,2,(5),inst_72186,inst_72187,null));
var inst_72189 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72188);
var inst_72190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72147,(0),null);
var inst_72191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72147,(1),null);
var inst_72192__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72147,(2),null);
var inst_72193__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72147,(3),null);
var inst_72194__$1 = cljs.core.__destructure_map(inst_72193__$1);
var inst_72195 = cljs.core.random_uuid();
var inst_72196 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72195);
var inst_72197 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_72194__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_72196);
var inst_72198 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_72194__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_72289__$1 = (function (){var statearr_72358 = state_72289;
(statearr_72358[(12)] = inst_72190);

(statearr_72358[(13)] = inst_72193__$1);

(statearr_72358[(14)] = inst_72194__$1);

(statearr_72358[(15)] = inst_72198);

(statearr_72358[(16)] = inst_72197);

(statearr_72358[(17)] = inst_72189);

(statearr_72358[(18)] = inst_72191);

(statearr_72358[(19)] = inst_72192__$1);

return statearr_72358;
})();
if(cljs.core.truth_(inst_72192__$1)){
var statearr_72359_72417 = state_72289__$1;
(statearr_72359_72417[(1)] = (21));

} else {
var statearr_72360_72418 = state_72289__$1;
(statearr_72360_72418[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_72361 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72361[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_72361[(1)] = (1));

return statearr_72361;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_72289){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72289);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72362){var ex__2730__auto__ = e72362;
var statearr_72363_72419 = state_72289;
(statearr_72363_72419[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72289[(4)]))){
var statearr_72364_72420 = state_72289;
(statearr_72364_72420[(1)] = cljs.core.first((state_72289[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72421 = state_72289;
state_72289 = G__72421;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_72289){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_72289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72365 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72365[(6)] = c__2749__auto__);

return statearr_72365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72459){
var state_val_72460 = (state_72459[(1)]);
if((state_val_72460 === (7))){
var inst_72430 = (state_72459[(7)]);
var state_72459__$1 = state_72459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72459__$1,(9),inst_72430);
} else {
if((state_val_72460 === (1))){
var inst_72422 = (1);
var state_72459__$1 = (function (){var statearr_72461 = state_72459;
(statearr_72461[(8)] = inst_72422);

return statearr_72461;
})();
var statearr_72462_72485 = state_72459__$1;
(statearr_72462_72485[(2)] = null);

(statearr_72462_72485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (4))){
var inst_72427 = (state_72459[(2)]);
var inst_72428 = fluree.db.connection.get_socket(conn);
var state_72459__$1 = (function (){var statearr_72463 = state_72459;
(statearr_72463[(9)] = inst_72427);

return statearr_72463;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72459__$1,(5),inst_72428);
} else {
if((state_val_72460 === (15))){
var inst_72455 = (state_72459[(2)]);
var state_72459__$1 = state_72459;
var statearr_72464_72486 = state_72459__$1;
(statearr_72464_72486[(2)] = inst_72455);

(statearr_72464_72486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (13))){
var inst_72437 = (state_72459[(10)]);
var inst_72422 = (state_72459[(8)]);
var inst_72445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72446 = [inst_72437,"Cannot establish connection to a healthy server, backing off:",inst_72422,"s."];
var inst_72447 = (new cljs.core.PersistentVector(null,4,(5),inst_72445,inst_72446,null));
var inst_72448 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72447);
var inst_72449 = ((2) * inst_72422);
var inst_72450 = ((60) * (2));
var inst_72451 = ((inst_72449 < inst_72450) ? inst_72449 : inst_72450);
var inst_72422__$1 = inst_72451;
var state_72459__$1 = (function (){var statearr_72465 = state_72459;
(statearr_72465[(11)] = inst_72448);

(statearr_72465[(8)] = inst_72422__$1);

return statearr_72465;
})();
var statearr_72466_72487 = state_72459__$1;
(statearr_72466_72487[(2)] = null);

(statearr_72466_72487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (6))){
var inst_72430 = (state_72459[(7)]);
var state_72459__$1 = state_72459;
var statearr_72467_72488 = state_72459__$1;
(statearr_72467_72488[(2)] = inst_72430);

(statearr_72467_72488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (3))){
var inst_72457 = (state_72459[(2)]);
var state_72459__$1 = state_72459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72459__$1,inst_72457);
} else {
if((state_val_72460 === (12))){
var inst_72443 = (state_72459[(2)]);
var state_72459__$1 = state_72459;
if(cljs.core.truth_(inst_72443)){
var statearr_72468_72489 = state_72459__$1;
(statearr_72468_72489[(1)] = (13));

} else {
var statearr_72469_72490 = state_72459__$1;
(statearr_72469_72490[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (2))){
var inst_72422 = (state_72459[(8)]);
var inst_72424 = (inst_72422 * (1000));
var inst_72425 = cljs.core.async.timeout(inst_72424);
var state_72459__$1 = state_72459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72459__$1,(4),inst_72425);
} else {
if((state_val_72460 === (11))){
var inst_72437 = (state_72459[(10)]);
var inst_72441 = fluree.db.util.core.exception_QMARK_(inst_72437);
var state_72459__$1 = state_72459;
var statearr_72470_72491 = state_72459__$1;
(statearr_72470_72491[(2)] = inst_72441);

(statearr_72470_72491[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (9))){
var inst_72435 = (state_72459[(2)]);
var state_72459__$1 = state_72459;
var statearr_72471_72492 = state_72459__$1;
(statearr_72471_72492[(2)] = inst_72435);

(statearr_72471_72492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (5))){
var inst_72430 = (state_72459[(7)]);
var inst_72430__$1 = (state_72459[(2)]);
var inst_72431 = fluree.db.util.core.exception_QMARK_(inst_72430__$1);
var state_72459__$1 = (function (){var statearr_72472 = state_72459;
(statearr_72472[(7)] = inst_72430__$1);

return statearr_72472;
})();
if(inst_72431){
var statearr_72473_72493 = state_72459__$1;
(statearr_72473_72493[(1)] = (6));

} else {
var statearr_72474_72494 = state_72459__$1;
(statearr_72474_72494[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (14))){
var inst_72437 = (state_72459[(10)]);
var state_72459__$1 = state_72459;
var statearr_72475_72495 = state_72459__$1;
(statearr_72475_72495[(2)] = inst_72437);

(statearr_72475_72495[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (10))){
var inst_72438 = (state_72459[(12)]);
var state_72459__$1 = state_72459;
var statearr_72476_72496 = state_72459__$1;
(statearr_72476_72496[(2)] = inst_72438);

(statearr_72476_72496[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72460 === (8))){
var inst_72437 = (state_72459[(10)]);
var inst_72438 = (state_72459[(12)]);
var inst_72437__$1 = (state_72459[(2)]);
var inst_72438__$1 = (inst_72437__$1 == null);
var state_72459__$1 = (function (){var statearr_72477 = state_72459;
(statearr_72477[(10)] = inst_72437__$1);

(statearr_72477[(12)] = inst_72438__$1);

return statearr_72477;
})();
if(cljs.core.truth_(inst_72438__$1)){
var statearr_72478_72497 = state_72459__$1;
(statearr_72478_72497[(1)] = (10));

} else {
var statearr_72479_72498 = state_72459__$1;
(statearr_72479_72498[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0 = (function (){
var statearr_72480 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72480[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__);

(statearr_72480[(1)] = (1));

return statearr_72480;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1 = (function (state_72459){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72459);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72481){var ex__2730__auto__ = e72481;
var statearr_72482_72499 = state_72459;
(statearr_72482_72499[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72459[(4)]))){
var statearr_72483_72500 = state_72459;
(statearr_72483_72500[(1)] = cljs.core.first((state_72459[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72501 = state_72459;
state_72459 = G__72501;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = function(state_72459){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1.call(this,state_72459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72484 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72484[(6)] = c__2749__auto__);

return statearr_72484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__72502){
var map__72503 = p__72502;
var map__72503__$1 = cljs.core.__destructure_map(map__72503);
var conn = map__72503__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72503__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72503__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72503__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72503__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72614){
var state_val_72615 = (state_72614[(1)]);
if((state_val_72615 === (7))){
var inst_72610 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72616_72672 = state_72614__$1;
(statearr_72616_72672[(2)] = inst_72610);

(statearr_72616_72672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (20))){
var inst_72561 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72617_72673 = state_72614__$1;
(statearr_72617_72673[(2)] = inst_72561);

(statearr_72617_72673[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (27))){
var inst_72579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72580 = ["Connection closed."];
var inst_72581 = (new cljs.core.PersistentVector(null,1,(5),inst_72579,inst_72580,null));
var inst_72582 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_72581);
var state_72614__$1 = state_72614;
var statearr_72618_72674 = state_72614__$1;
(statearr_72618_72674[(2)] = inst_72582);

(statearr_72618_72674[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (1))){
var inst_72504 = (0);
var state_72614__$1 = (function (){var statearr_72619 = state_72614;
(statearr_72619[(7)] = inst_72504);

return statearr_72619;
})();
var statearr_72620_72675 = state_72614__$1;
(statearr_72620_72675[(2)] = null);

(statearr_72620_72675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (24))){
var inst_72548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72549 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_72550 = [keep_alive_fn];
var inst_72551 = cljs.core.PersistentHashMap.fromArrays(inst_72549,inst_72550);
var inst_72552 = ["Unsupported callback registered",inst_72551];
var inst_72553 = (new cljs.core.PersistentVector(null,2,(5),inst_72548,inst_72552,null));
var inst_72554 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72553);
var state_72614__$1 = state_72614;
var statearr_72621_72676 = state_72614__$1;
(statearr_72621_72676[(2)] = inst_72554);

(statearr_72621_72676[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (4))){
var inst_72509 = (state_72614[(8)]);
var inst_72514 = (state_72614[(2)]);
var inst_72515 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72514,(0),null);
var inst_72516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72514,(1),null);
var inst_72517 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72516,inst_72509);
var state_72614__$1 = (function (){var statearr_72622 = state_72614;
(statearr_72622[(9)] = inst_72515);

return statearr_72622;
})();
if(inst_72517){
var statearr_72623_72677 = state_72614__$1;
(statearr_72623_72677[(1)] = (5));

} else {
var statearr_72624_72678 = state_72614__$1;
(statearr_72624_72678[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (15))){
var inst_72534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72535 = ["No keep-alive callback is registered"];
var inst_72536 = (new cljs.core.PersistentVector(null,1,(5),inst_72534,inst_72535,null));
var inst_72537 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72536);
var state_72614__$1 = state_72614;
var statearr_72625_72679 = state_72614__$1;
(statearr_72625_72679[(2)] = inst_72537);

(statearr_72625_72679[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (21))){
var inst_72545 = cljs.core.eval(keep_alive_fn);
var state_72614__$1 = state_72614;
var statearr_72626_72680 = state_72614__$1;
(statearr_72626_72680[(2)] = inst_72545);

(statearr_72626_72680[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (31))){
var state_72614__$1 = state_72614;
var statearr_72627_72681 = state_72614__$1;
(statearr_72627_72681[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (32))){
var inst_72606 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72629_72682 = state_72614__$1;
(statearr_72629_72682[(2)] = inst_72606);

(statearr_72629_72682[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (33))){
var inst_72515 = (state_72614[(9)]);
var inst_72593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72594 = fluree.db.util.json.parse(inst_72515);
var inst_72595 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_72594], 0));
var inst_72596 = ["Received message:",inst_72595];
var inst_72597 = (new cljs.core.PersistentVector(null,2,(5),inst_72593,inst_72596,null));
var inst_72598 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_72597);
var inst_72599 = fluree.db.util.json.parse(inst_72515);
var inst_72600 = fluree.db.conn_events.process_events(conn,inst_72599);
var inst_72504 = (0);
var state_72614__$1 = (function (){var statearr_72630 = state_72614;
(statearr_72630[(10)] = inst_72600);

(statearr_72630[(7)] = inst_72504);

(statearr_72630[(11)] = inst_72598);

return statearr_72630;
})();
var statearr_72631_72683 = state_72614__$1;
(statearr_72631_72683[(2)] = null);

(statearr_72631_72683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (13))){
var inst_72569 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72632_72684 = state_72614__$1;
(statearr_72632_72684[(2)] = inst_72569);

(statearr_72632_72684[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (22))){
var state_72614__$1 = state_72614;
var statearr_72633_72685 = state_72614__$1;
(statearr_72633_72685[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (29))){
var inst_72608 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72635_72686 = state_72614__$1;
(statearr_72635_72686[(2)] = inst_72608);

(statearr_72635_72686[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (6))){
var inst_72515 = (state_72614[(9)]);
var inst_72577 = (inst_72515 == null);
var state_72614__$1 = state_72614;
if(cljs.core.truth_(inst_72577)){
var statearr_72636_72687 = state_72614__$1;
(statearr_72636_72687[(1)] = (27));

} else {
var statearr_72637_72688 = state_72614__$1;
(statearr_72637_72688[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (28))){
var inst_72515 = (state_72614[(9)]);
var inst_72584 = fluree.db.util.core.exception_QMARK_(inst_72515);
var state_72614__$1 = state_72614;
if(inst_72584){
var statearr_72638_72689 = state_72614__$1;
(statearr_72638_72689[(1)] = (30));

} else {
var statearr_72639_72690 = state_72614__$1;
(statearr_72639_72690[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (25))){
var state_72614__$1 = state_72614;
var statearr_72640_72691 = state_72614__$1;
(statearr_72640_72691[(2)] = null);

(statearr_72640_72691[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (34))){
var state_72614__$1 = state_72614;
var statearr_72641_72692 = state_72614__$1;
(statearr_72641_72692[(2)] = null);

(statearr_72641_72692[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (17))){
var inst_72563 = (state_72614[(2)]);
var inst_72564 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72565 = fluree.db.connection.close_websocket(inst_72564);
var inst_72566 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72567 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_72566);
var state_72614__$1 = (function (){var statearr_72642 = state_72614;
(statearr_72642[(12)] = inst_72563);

(statearr_72642[(13)] = inst_72565);

return statearr_72642;
})();
var statearr_72643_72693 = state_72614__$1;
(statearr_72643_72693[(2)] = inst_72567);

(statearr_72643_72693[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (3))){
var inst_72612 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72614__$1,inst_72612);
} else {
if((state_val_72615 === (12))){
var inst_72527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72528 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_72529 = (new cljs.core.PersistentVector(null,1,(5),inst_72527,inst_72528,null));
var inst_72530 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_72529);
var inst_72531 = keep_alive_fn;
var inst_72532 = (keep_alive_fn == null);
var state_72614__$1 = (function (){var statearr_72644 = state_72614;
(statearr_72644[(14)] = inst_72530);

(statearr_72644[(15)] = inst_72531);

return statearr_72644;
})();
if(cljs.core.truth_(inst_72532)){
var statearr_72645_72694 = state_72614__$1;
(statearr_72645_72694[(1)] = (15));

} else {
var statearr_72646_72695 = state_72614__$1;
(statearr_72646_72695[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (2))){
var inst_72509 = (state_72614[(8)]);
var inst_72509__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_72510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72511 = [sub_chan,inst_72509__$1];
var inst_72512 = (new cljs.core.PersistentVector(null,2,(5),inst_72510,inst_72511,null));
var state_72614__$1 = (function (){var statearr_72647 = state_72614;
(statearr_72647[(8)] = inst_72509__$1);

return statearr_72647;
})();
return cljs.core.async.ioc_alts_BANG_(state_72614__$1,(4),inst_72512);
} else {
if((state_val_72615 === (23))){
var inst_72559 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72648_72696 = state_72614__$1;
(statearr_72648_72696[(2)] = inst_72559);

(statearr_72648_72696[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (35))){
var inst_72604 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72649_72697 = state_72614__$1;
(statearr_72649_72697[(2)] = inst_72604);

(statearr_72649_72697[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (19))){
var inst_72543 = typeof keep_alive_fn === 'string';
var state_72614__$1 = state_72614;
if(cljs.core.truth_(inst_72543)){
var statearr_72650_72698 = state_72614__$1;
(statearr_72650_72698[(1)] = (21));

} else {
var statearr_72651_72699 = state_72614__$1;
(statearr_72651_72699[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (11))){
var inst_72522 = fluree.db.connection.reconnect_conn(conn);
var state_72614__$1 = state_72614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72614__$1,(14),inst_72522);
} else {
if((state_val_72615 === (9))){
var inst_72504 = (state_72614[(7)]);
var inst_72571 = fluree.db.connection.ping_transactor(req_chan);
var inst_72572 = (inst_72504 + (1));
var inst_72504__$1 = inst_72572;
var state_72614__$1 = (function (){var statearr_72652 = state_72614;
(statearr_72652[(16)] = inst_72571);

(statearr_72652[(7)] = inst_72504__$1);

return statearr_72652;
})();
var statearr_72653_72700 = state_72614__$1;
(statearr_72653_72700[(2)] = null);

(statearr_72653_72700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (5))){
var inst_72504 = (state_72614[(7)]);
var inst_72519 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_72504);
var state_72614__$1 = state_72614;
if(inst_72519){
var statearr_72654_72701 = state_72614__$1;
(statearr_72654_72701[(1)] = (8));

} else {
var statearr_72655_72702 = state_72614__$1;
(statearr_72655_72702[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (14))){
var inst_72524 = (state_72614[(2)]);
var inst_72504 = (0);
var state_72614__$1 = (function (){var statearr_72656 = state_72614;
(statearr_72656[(7)] = inst_72504);

(statearr_72656[(17)] = inst_72524);

return statearr_72656;
})();
var statearr_72657_72703 = state_72614__$1;
(statearr_72657_72703[(2)] = null);

(statearr_72657_72703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (26))){
var inst_72557 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72658_72704 = state_72614__$1;
(statearr_72658_72704[(2)] = inst_72557);

(statearr_72658_72704[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (16))){
var inst_72539 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_72614__$1 = state_72614;
if(inst_72539){
var statearr_72659_72705 = state_72614__$1;
(statearr_72659_72705[(1)] = (18));

} else {
var statearr_72660_72706 = state_72614__$1;
(statearr_72660_72706[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (30))){
var inst_72515 = (state_72614[(9)]);
var inst_72586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72587 = [inst_72515];
var inst_72588 = (new cljs.core.PersistentVector(null,1,(5),inst_72586,inst_72587,null));
var inst_72589 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72588);
var inst_72504 = (0);
var state_72614__$1 = (function (){var statearr_72661 = state_72614;
(statearr_72661[(18)] = inst_72589);

(statearr_72661[(7)] = inst_72504);

return statearr_72661;
})();
var statearr_72662_72707 = state_72614__$1;
(statearr_72662_72707[(2)] = null);

(statearr_72662_72707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (10))){
var inst_72575 = (state_72614[(2)]);
var state_72614__$1 = state_72614;
var statearr_72663_72708 = state_72614__$1;
(statearr_72663_72708[(2)] = inst_72575);

(statearr_72663_72708[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (18))){
var inst_72541 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_72614__$1 = state_72614;
var statearr_72664_72709 = state_72614__$1;
(statearr_72664_72709[(2)] = inst_72541);

(statearr_72664_72709[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72615 === (8))){
var state_72614__$1 = state_72614;
if(cljs.core.truth_(keep_alive)){
var statearr_72665_72710 = state_72614__$1;
(statearr_72665_72710[(1)] = (11));

} else {
var statearr_72666_72711 = state_72614__$1;
(statearr_72666_72711[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_72667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72667[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_72667[(1)] = (1));

return statearr_72667;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_72614){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72614);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72668){var ex__2730__auto__ = e72668;
var statearr_72669_72712 = state_72614;
(statearr_72669_72712[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72614[(4)]))){
var statearr_72670_72713 = state_72614;
(statearr_72670_72713[(1)] = cljs.core.first((state_72614[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72714 = state_72614;
state_72614 = G__72714;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_72614){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_72614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72671 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72671[(6)] = c__2749__auto__);

return statearr_72671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__72716 = arguments.length;
switch (G__72716) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__72717 = opts;
var map__72717__$1 = cljs.core.__destructure_map(map__72717);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72717__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72717__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72769){
var state_val_72770 = (state_72769[(1)]);
if((state_val_72770 === (7))){
var inst_72727 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_72728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72729 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72730 = (new cljs.core.PersistentVector(null,2,(5),inst_72728,inst_72729,null));
var inst_72731 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72727,inst_72730);
var state_72769__$1 = state_72769;
var statearr_72771_72802 = state_72769__$1;
(statearr_72771_72802[(2)] = inst_72731);

(statearr_72771_72802[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (1))){
var state_72769__$1 = state_72769;
var statearr_72772_72803 = state_72769__$1;
(statearr_72772_72803[(2)] = null);

(statearr_72772_72803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (4))){
var inst_72718 = (state_72769[(2)]);
var state_72769__$1 = state_72769;
var statearr_72773_72804 = state_72769__$1;
(statearr_72773_72804[(2)] = inst_72718);

(statearr_72773_72804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (15))){
var inst_72738 = (state_72769[(7)]);
var inst_72757 = (state_72769[(2)]);
var inst_72758 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_72759 = [(5000),inst_72757,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_72760 = cljs.core.PersistentHashMap.fromArrays(inst_72758,inst_72759);
var inst_72761 = fluree.db.util.xhttp.get(inst_72738,inst_72760);
var state_72769__$1 = state_72769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72769__$1,(16),inst_72761);
} else {
if((state_val_72770 === (13))){
var inst_72748 = (state_72769[(8)]);
var inst_72738 = (state_72769[(7)]);
var inst_72750 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_72751 = [inst_72748];
var inst_72752 = cljs.core.PersistentHashMap.fromArrays(inst_72750,inst_72751);
var inst_72753 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_72738,inst_72752,private$);
var inst_72754 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_72753);
var state_72769__$1 = state_72769;
var statearr_72774_72805 = state_72769__$1;
(statearr_72774_72805[(2)] = inst_72754);

(statearr_72774_72805[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (6))){
var inst_72724 = (state_72769[(9)]);
var state_72769__$1 = state_72769;
var statearr_72775_72806 = state_72769__$1;
(statearr_72775_72806[(2)] = inst_72724);

(statearr_72775_72806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (3))){
var inst_72767 = (state_72769[(2)]);
var state_72769__$1 = state_72769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72769__$1,inst_72767);
} else {
if((state_val_72770 === (12))){
var inst_72748 = (state_72769[(2)]);
var state_72769__$1 = (function (){var statearr_72776 = state_72769;
(statearr_72776[(8)] = inst_72748);

return statearr_72776;
})();
if(cljs.core.truth_(private$)){
var statearr_72777_72807 = state_72769__$1;
(statearr_72777_72807[(1)] = (13));

} else {
var statearr_72778_72808 = state_72769__$1;
(statearr_72778_72808[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (2))){
var inst_72724 = (state_72769[(9)]);
var _ = (function (){var statearr_72779 = state_72769;
(statearr_72779[(4)] = cljs.core.cons((5),(state_72769[(4)])));

return statearr_72779;
})();
var inst_72724__$1 = jwt;
var state_72769__$1 = (function (){var statearr_72780 = state_72769;
(statearr_72780[(9)] = inst_72724__$1);

return statearr_72780;
})();
if(cljs.core.truth_(inst_72724__$1)){
var statearr_72781_72809 = state_72769__$1;
(statearr_72781_72809[(1)] = (6));

} else {
var statearr_72782_72810 = state_72769__$1;
(statearr_72782_72810[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (11))){
var inst_72742 = (state_72769[(10)]);
var state_72769__$1 = state_72769;
var statearr_72784_72811 = state_72769__$1;
(statearr_72784_72811[(2)] = inst_72742);

(statearr_72784_72811[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (9))){
var inst_72734 = (state_72769[(11)]);
var inst_72733 = (state_72769[(12)]);
var inst_72737 = (state_72769[(2)]);
var inst_72738 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72737),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72734)].join('');
var inst_72740 = ["Accept"];
var inst_72741 = ["application/json"];
var inst_72742 = cljs.core.PersistentHashMap.fromArrays(inst_72740,inst_72741);
var state_72769__$1 = (function (){var statearr_72785 = state_72769;
(statearr_72785[(7)] = inst_72738);

(statearr_72785[(10)] = inst_72742);

return statearr_72785;
})();
if(cljs.core.truth_(inst_72733)){
var statearr_72786_72812 = state_72769__$1;
(statearr_72786_72812[(1)] = (10));

} else {
var statearr_72787_72813 = state_72769__$1;
(statearr_72787_72813[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (5))){
var _ = (function (){var statearr_72788 = state_72769;
(statearr_72788[(4)] = cljs.core.rest((state_72769[(4)])));

return statearr_72788;
})();
var state_72769__$1 = state_72769;
var ex72783 = (state_72769__$1[(2)]);
var statearr_72789_72814 = state_72769__$1;
(statearr_72789_72814[(5)] = ex72783);


if((ex72783 instanceof Error)){
var statearr_72790_72815 = state_72769__$1;
(statearr_72790_72815[(1)] = (4));

(statearr_72790_72815[(5)] = null);

} else {
throw ex72783;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (14))){
var inst_72748 = (state_72769[(8)]);
var state_72769__$1 = state_72769;
var statearr_72791_72816 = state_72769__$1;
(statearr_72791_72816[(2)] = inst_72748);

(statearr_72791_72816[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (16))){
var inst_72763 = (state_72769[(2)]);
var inst_72764 = fluree.db.util.async.throw_err(inst_72763);
var _ = (function (){var statearr_72792 = state_72769;
(statearr_72792[(4)] = cljs.core.rest((state_72769[(4)])));

return statearr_72792;
})();
var state_72769__$1 = state_72769;
var statearr_72793_72817 = state_72769__$1;
(statearr_72793_72817[(2)] = inst_72764);

(statearr_72793_72817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (10))){
var inst_72733 = (state_72769[(12)]);
var inst_72742 = (state_72769[(10)]);
var inst_72744 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72733)].join('');
var inst_72745 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_72742,"Authorization",inst_72744);
var state_72769__$1 = state_72769;
var statearr_72794_72818 = state_72769__$1;
(statearr_72794_72818[(2)] = inst_72745);

(statearr_72794_72818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72770 === (8))){
var inst_72733 = (state_72769[(2)]);
var inst_72734 = clojure.string.replace(k,"_","/");
var inst_72735 = fluree.db.connection.get_server(conn_id,servers);
var state_72769__$1 = (function (){var statearr_72795 = state_72769;
(statearr_72795[(11)] = inst_72734);

(statearr_72795[(12)] = inst_72733);

return statearr_72795;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72769__$1,(9),inst_72735);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_72796 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72796[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_72796[(1)] = (1));

return statearr_72796;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_72769){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72769);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72797){var ex__2730__auto__ = e72797;
var statearr_72798_72819 = state_72769;
(statearr_72798_72819[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72769[(4)]))){
var statearr_72799_72820 = state_72769;
(statearr_72799_72820[(1)] = cljs.core.first((state_72769[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72821 = state_72769;
state_72769 = G__72821;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_72769){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_72769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72800 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72800[(6)] = c__2749__auto__);

return statearr_72800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___72846 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___72846)){
var v_72847 = temp__5802__auto___72846;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_72847);
} else {
var c__2749__auto___72848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72833){
var state_val_72834 = (state_72833[(1)]);
if((state_val_72834 === (1))){
var inst_72822 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_72833__$1 = state_72833;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72833__$1,(2),inst_72822);
} else {
if((state_val_72834 === (2))){
var inst_72824 = (state_72833[(7)]);
var inst_72824__$1 = (state_72833[(2)]);
var inst_72825 = fluree.db.util.core.exception_QMARK_(inst_72824__$1);
var state_72833__$1 = (function (){var statearr_72835 = state_72833;
(statearr_72835[(7)] = inst_72824__$1);

return statearr_72835;
})();
if(inst_72825){
var statearr_72836_72849 = state_72833__$1;
(statearr_72836_72849[(1)] = (3));

} else {
var statearr_72837_72850 = state_72833__$1;
(statearr_72837_72850[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72834 === (3))){
var state_72833__$1 = state_72833;
var statearr_72838_72851 = state_72833__$1;
(statearr_72838_72851[(2)] = null);

(statearr_72838_72851[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72834 === (4))){
var inst_72824 = (state_72833[(7)]);
var inst_72828 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_72824);
var state_72833__$1 = state_72833;
var statearr_72839_72852 = state_72833__$1;
(statearr_72839_72852[(2)] = inst_72828);

(statearr_72839_72852[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72834 === (5))){
var inst_72824 = (state_72833[(7)]);
var inst_72830 = (state_72833[(2)]);
var inst_72831 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_72824);
var state_72833__$1 = (function (){var statearr_72840 = state_72833;
(statearr_72840[(8)] = inst_72830);

return statearr_72840;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72833__$1,inst_72831);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_72841 = [null,null,null,null,null,null,null,null,null];
(statearr_72841[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__);

(statearr_72841[(1)] = (1));

return statearr_72841;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1 = (function (state_72833){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72833);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72842){var ex__2730__auto__ = e72842;
var statearr_72843_72853 = state_72833;
(statearr_72843_72853[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72833[(4)]))){
var statearr_72844_72854 = state_72833;
(statearr_72844_72854[(1)] = cljs.core.first((state_72833[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72855 = state_72833;
state_72833 = G__72855;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = function(state_72833){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1.call(this,state_72833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72845 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72845[(6)] = c__2749__auto___72848);

return statearr_72845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__72856_SHARP_){
if(cljs.core.truth_(p1__72856_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__72857_SHARP_){
var or__5045__auto__ = p1__72857_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e72858){var e = e72858;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__72859 = opts;
var map__72859__$1 = cljs.core.__destructure_map(map__72859);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__72859__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72859__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__72860_72861 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__72860_72861.cljs$core$IFn$_invoke$arity$0 ? fexpr__72860_72861.cljs$core$IFn$_invoke$arity$0() : fexpr__72860_72861.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___72905 = arguments.length;
var i__5770__auto___72906 = (0);
while(true){
if((i__5770__auto___72906 < len__5769__auto___72905)){
args__5775__auto__.push((arguments[i__5770__auto___72906]));

var G__72907 = (i__5770__auto___72906 + (1));
i__5770__auto___72906 = G__72907;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__72864){
var vec__72865 = p__72864;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72865,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___72908 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72888){
var state_val_72889 = (state_72888[(1)]);
if((state_val_72889 === (1))){
var inst_72868 = fluree.db.connection.get_socket(conn);
var state_72888__$1 = state_72888;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72888__$1,(2),inst_72868);
} else {
if((state_val_72889 === (2))){
var inst_72870 = (state_72888[(7)]);
var inst_72871 = (state_72888[(8)]);
var inst_72870__$1 = (state_72888[(2)]);
var inst_72871__$1 = (inst_72870__$1 == null);
var state_72888__$1 = (function (){var statearr_72890 = state_72888;
(statearr_72890[(7)] = inst_72870__$1);

(statearr_72890[(8)] = inst_72871__$1);

return statearr_72890;
})();
if(cljs.core.truth_(inst_72871__$1)){
var statearr_72891_72909 = state_72888__$1;
(statearr_72891_72909[(1)] = (3));

} else {
var statearr_72892_72910 = state_72888__$1;
(statearr_72892_72910[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (3))){
var inst_72871 = (state_72888[(8)]);
var state_72888__$1 = state_72888;
var statearr_72893_72911 = state_72888__$1;
(statearr_72893_72911[(2)] = inst_72871);

(statearr_72893_72911[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (4))){
var inst_72870 = (state_72888[(7)]);
var inst_72874 = fluree.db.util.core.exception_QMARK_(inst_72870);
var state_72888__$1 = state_72888;
var statearr_72894_72912 = state_72888__$1;
(statearr_72894_72912[(2)] = inst_72874);

(statearr_72894_72912[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (5))){
var inst_72876 = (state_72888[(2)]);
var state_72888__$1 = state_72888;
if(cljs.core.truth_(inst_72876)){
var statearr_72895_72913 = state_72888__$1;
(statearr_72895_72913[(1)] = (6));

} else {
var statearr_72896_72914 = state_72888__$1;
(statearr_72896_72914[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (6))){
var inst_72870 = (state_72888[(7)]);
var inst_72878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72879 = [inst_72870,"Cannot establish connection to a healthy server, disconnecting."];
var inst_72880 = (new cljs.core.PersistentVector(null,2,(5),inst_72878,inst_72879,null));
var inst_72881 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72880);
var inst_72882 = cljs.core.async.close_BANG_(conn);
var state_72888__$1 = (function (){var statearr_72897 = state_72888;
(statearr_72897[(9)] = inst_72881);

return statearr_72897;
})();
var statearr_72898_72915 = state_72888__$1;
(statearr_72898_72915[(2)] = inst_72882);

(statearr_72898_72915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (7))){
var inst_72884 = fluree.db.connection.msg_consumer(conn);
var state_72888__$1 = state_72888;
var statearr_72899_72916 = state_72888__$1;
(statearr_72899_72916[(2)] = inst_72884);

(statearr_72899_72916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72889 === (8))){
var inst_72886 = (state_72888[(2)]);
var state_72888__$1 = state_72888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72888__$1,inst_72886);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_72900 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72900[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_72900[(1)] = (1));

return statearr_72900;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_72888){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72888);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72901){var ex__2730__auto__ = e72901;
var statearr_72902_72917 = state_72888;
(statearr_72902_72917[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72888[(4)]))){
var statearr_72903_72918 = state_72888;
(statearr_72903_72918[(1)] = cljs.core.first((state_72888[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72919 = state_72888;
state_72888 = G__72919;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_72888){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_72888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72904 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_72904[(6)] = c__2749__auto___72908);

return statearr_72904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq72862){
var G__72863 = cljs.core.first(seq72862);
var seq72862__$1 = cljs.core.next(seq72862);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72863,seq72862__$1);
}));

