// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__72930 = arguments.length;
switch (G__72930) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72975){
var state_val_72976 = (state_72975[(1)]);
if((state_val_72976 === (7))){
var inst_72945 = typeof user === 'string';
var state_72975__$1 = state_72975;
if(cljs.core.truth_(inst_72945)){
var statearr_72977_73006 = state_72975__$1;
(statearr_72977_73006[(1)] = (9));

} else {
var statearr_72978_73007 = state_72975__$1;
(statearr_72978_73007[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (1))){
var state_72975__$1 = state_72975;
var statearr_72979_73008 = state_72975__$1;
(statearr_72979_73008[(2)] = null);

(statearr_72979_73008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (4))){
var inst_72931 = (state_72975[(2)]);
var inst_72932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72933 = [inst_72931];
var inst_72934 = (new cljs.core.PersistentVector(null,1,(5),inst_72932,inst_72933,null));
var inst_72935 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72934);
var inst_72936 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72931) : reject.call(null,inst_72931));
var state_72975__$1 = (function (){var statearr_72980 = state_72975;
(statearr_72980[(7)] = inst_72935);

return statearr_72980;
})();
var statearr_72981_73009 = state_72975__$1;
(statearr_72981_73009[(2)] = inst_72936);

(statearr_72981_73009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (15))){
var inst_72964 = (state_72975[(2)]);
var inst_72965 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_72964);
var inst_72966 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72967 = cljs.core.constantly(inst_72965);
var inst_72968 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72966,inst_72967);
var inst_72969 = fluree.db.connection.add_token(conn,inst_72965);
var inst_72970 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_72964) : resolve.call(null,inst_72964));
var _ = (function (){var statearr_72982 = state_72975;
(statearr_72982[(4)] = cljs.core.rest((state_72975[(4)])));

return statearr_72982;
})();
var state_72975__$1 = (function (){var statearr_72983 = state_72975;
(statearr_72983[(8)] = inst_72969);

(statearr_72983[(9)] = inst_72968);

return statearr_72983;
})();
var statearr_72984_73010 = state_72975__$1;
(statearr_72984_73010[(2)] = inst_72970);

(statearr_72984_73010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (13))){
var state_72975__$1 = state_72975;
var statearr_72985_73011 = state_72975__$1;
(statearr_72985_73011[(2)] = null);

(statearr_72985_73011[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (6))){
var state_72975__$1 = state_72975;
var statearr_72986_73012 = state_72975__$1;
(statearr_72986_73012[(2)] = user);

(statearr_72986_73012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (3))){
var inst_72973 = (state_72975[(2)]);
var state_72975__$1 = state_72975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72975__$1,inst_72973);
} else {
if((state_val_72976 === (12))){
var state_72975__$1 = state_72975;
var statearr_72987_73013 = state_72975__$1;
(statearr_72987_73013[(2)] = user);

(statearr_72987_73013[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (2))){
var _ = (function (){var statearr_72988 = state_72975;
(statearr_72988[(4)] = cljs.core.cons((5),(state_72975[(4)])));

return statearr_72988;
})();
var inst_72942 = typeof user === 'number';
var state_72975__$1 = state_72975;
if(cljs.core.truth_(inst_72942)){
var statearr_72989_73014 = state_72975__$1;
(statearr_72989_73014[(1)] = (6));

} else {
var statearr_72990_73015 = state_72975__$1;
(statearr_72990_73015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (11))){
var inst_72956 = (state_72975[(2)]);
var state_72975__$1 = state_72975;
var statearr_72992_73016 = state_72975__$1;
(statearr_72992_73016[(2)] = inst_72956);

(statearr_72992_73016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (9))){
var inst_72947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72948 = ["_user/username",user];
var inst_72949 = (new cljs.core.PersistentVector(null,2,(5),inst_72947,inst_72948,null));
var state_72975__$1 = state_72975;
var statearr_72993_73017 = state_72975__$1;
(statearr_72993_73017[(2)] = inst_72949);

(statearr_72993_73017[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (5))){
var _ = (function (){var statearr_72994 = state_72975;
(statearr_72994[(4)] = cljs.core.rest((state_72975[(4)])));

return statearr_72994;
})();
var state_72975__$1 = state_72975;
var ex72991 = (state_72975__$1[(2)]);
var statearr_72995_73018 = state_72975__$1;
(statearr_72995_73018[(5)] = ex72991);


var statearr_72996_73019 = state_72975__$1;
(statearr_72996_73019[(1)] = (4));

(statearr_72996_73019[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (14))){
var inst_72954 = (state_72975[(2)]);
var state_72975__$1 = state_72975;
var statearr_72997_73020 = state_72975__$1;
(statearr_72997_73020[(2)] = inst_72954);

(statearr_72997_73020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (10))){
var state_72975__$1 = state_72975;
var statearr_72998_73021 = state_72975__$1;
(statearr_72998_73021[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72976 === (8))){
var inst_72958 = (state_72975[(2)]);
var inst_72959 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_72960 = [account,inst_72958,password,expireSeconds,syncTo];
var inst_72961 = cljs.core.PersistentHashMap.fromArrays(inst_72959,inst_72960);
var inst_72962 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_72961);
var state_72975__$1 = state_72975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72975__$1,(15),inst_72962);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73000 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73000[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73000[(1)] = (1));

return statearr_73000;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_72975){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_72975);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73001){var ex__2730__auto__ = e73001;
var statearr_73002_73022 = state_72975;
(statearr_73002_73022[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_72975[(4)]))){
var statearr_73003_73023 = state_72975;
(statearr_73003_73023[(1)] = cljs.core.first((state_72975[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73024 = state_72975;
state_72975 = G__73024;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_72975){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_72975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73004 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73004[(6)] = c__2749__auto__);

return statearr_73004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__73026 = arguments.length;
switch (G__73026) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73035){
var state_val_73036 = (state_73035[(1)]);
if((state_val_73036 === (1))){
var inst_73027 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73029 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_73030 = (new cljs.core.PersistentVector(null,4,(5),inst_73028,inst_73029,null));
var inst_73031 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73027,inst_73030);
var inst_73032 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__73037 = cljs.core.seq(cljs.core.keys(x));
var chunk__73038 = null;
var count__73039 = (0);
var i__73040 = (0);
while(true){
if((i__73040 < count__73039)){
var k = chunk__73038.cljs$core$IIndexed$_nth$arity$2(null,i__73040);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__73048 = seq__73037;
var G__73049 = chunk__73038;
var G__73050 = count__73039;
var G__73051 = (i__73040 + (1));
seq__73037 = G__73048;
chunk__73038 = G__73049;
count__73039 = G__73050;
i__73040 = G__73051;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__73037);
if(temp__5804__auto__){
var seq__73037__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__73037__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__73037__$1);
var G__73052 = cljs.core.chunk_rest(seq__73037__$1);
var G__73053 = c__5568__auto__;
var G__73054 = cljs.core.count(c__5568__auto__);
var G__73055 = (0);
seq__73037 = G__73052;
chunk__73038 = G__73053;
count__73039 = G__73054;
i__73040 = G__73055;
continue;
} else {
var k = cljs.core.first(seq__73037__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__73056 = cljs.core.next(seq__73037__$1);
var G__73057 = null;
var G__73058 = (0);
var G__73059 = (0);
seq__73037 = G__73056;
chunk__73038 = G__73057;
count__73039 = G__73058;
i__73040 = G__73059;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_73033 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73032);
var state_73035__$1 = (function (){var statearr_73041 = state_73035;
(statearr_73041[(7)] = inst_73031);

return statearr_73041;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73035__$1,inst_73033);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73042 = [null,null,null,null,null,null,null,null];
(statearr_73042[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73042[(1)] = (1));

return statearr_73042;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_73035){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73035);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73043){var ex__2730__auto__ = e73043;
var statearr_73044_73060 = state_73035;
(statearr_73044_73060[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73035[(4)]))){
var statearr_73045_73061 = state_73035;
(statearr_73045_73061[(1)] = cljs.core.first((state_73035[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73062 = state_73035;
state_73035 = G__73062;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_73035){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_73035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73046 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73046[(6)] = c__2749__auto__);

return statearr_73046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__73064 = arguments.length;
switch (G__73064) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73101){
var state_val_73102 = (state_73101[(1)]);
if((state_val_73102 === (1))){
var state_73101__$1 = state_73101;
var statearr_73103_73124 = state_73101__$1;
(statearr_73103_73124[(2)] = null);

(statearr_73103_73124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73102 === (2))){
var _ = (function (){var statearr_73104 = state_73101;
(statearr_73104[(4)] = cljs.core.cons((5),(state_73101[(4)])));

return statearr_73104;
})();
var inst_73076 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_73077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73078 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_73079 = (new cljs.core.PersistentVector(null,1,(5),inst_73077,inst_73078,null));
var inst_73080 = cljs.core.PersistentHashMap.EMPTY;
var inst_73081 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_73080);
var inst_73082 = cljs.core.assoc_in(inst_73076,inst_73079,inst_73081);
var inst_73083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73084 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73085 = (new cljs.core.PersistentVector(null,1,(5),inst_73083,inst_73084,null));
var inst_73086 = cljs.core.PersistentHashMap.EMPTY;
var inst_73087 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_73086);
var inst_73088 = cljs.core.assoc_in(inst_73082,inst_73085,inst_73087);
var inst_73089 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73090 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_73088);
var inst_73091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73092 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_73089,null];
var inst_73093 = (new cljs.core.PersistentVector(null,4,(5),inst_73091,inst_73092,null));
var inst_73094 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73090,inst_73093);
var inst_73095 = (function (){var conn = inst_73088;
var pc = inst_73089;
return (function (x){
if((x == null)){
} else {
var seq__73105_73125 = cljs.core.seq(cljs.core.keys(x));
var chunk__73106_73126 = null;
var count__73107_73127 = (0);
var i__73108_73128 = (0);
while(true){
if((i__73108_73128 < count__73107_73127)){
var k_73129 = chunk__73106_73126.cljs$core$IIndexed$_nth$arity$2(null,i__73108_73128);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73129], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_73129,null));


var G__73130 = seq__73105_73125;
var G__73131 = chunk__73106_73126;
var G__73132 = count__73107_73127;
var G__73133 = (i__73108_73128 + (1));
seq__73105_73125 = G__73130;
chunk__73106_73126 = G__73131;
count__73107_73127 = G__73132;
i__73108_73128 = G__73133;
continue;
} else {
var temp__5804__auto___73134 = cljs.core.seq(seq__73105_73125);
if(temp__5804__auto___73134){
var seq__73105_73135__$1 = temp__5804__auto___73134;
if(cljs.core.chunked_seq_QMARK_(seq__73105_73135__$1)){
var c__5568__auto___73136 = cljs.core.chunk_first(seq__73105_73135__$1);
var G__73137 = cljs.core.chunk_rest(seq__73105_73135__$1);
var G__73138 = c__5568__auto___73136;
var G__73139 = cljs.core.count(c__5568__auto___73136);
var G__73140 = (0);
seq__73105_73125 = G__73137;
chunk__73106_73126 = G__73138;
count__73107_73127 = G__73139;
i__73108_73128 = G__73140;
continue;
} else {
var k_73141 = cljs.core.first(seq__73105_73135__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73141], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_73141,null));


var G__73142 = cljs.core.next(seq__73105_73135__$1);
var G__73143 = null;
var G__73144 = (0);
var G__73145 = (0);
seq__73105_73125 = G__73142;
chunk__73106_73126 = G__73143;
count__73107_73127 = G__73144;
i__73108_73128 = G__73145;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_73096 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73089,inst_73095);
var ___$1 = (function (){var statearr_73109 = state_73101;
(statearr_73109[(4)] = cljs.core.rest((state_73101[(4)])));

return statearr_73109;
})();
var state_73101__$1 = (function (){var statearr_73110 = state_73101;
(statearr_73110[(7)] = inst_73094);

return statearr_73110;
})();
var statearr_73111_73146 = state_73101__$1;
(statearr_73111_73146[(2)] = inst_73096);

(statearr_73111_73146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73102 === (3))){
var inst_73099 = (state_73101[(2)]);
var state_73101__$1 = state_73101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73101__$1,inst_73099);
} else {
if((state_val_73102 === (4))){
var inst_73065 = (state_73101[(2)]);
var inst_73066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73067 = [inst_73065];
var inst_73068 = (new cljs.core.PersistentVector(null,1,(5),inst_73066,inst_73067,null));
var inst_73069 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73068);
var inst_73070 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73065) : reject.call(null,inst_73065));
var state_73101__$1 = (function (){var statearr_73113 = state_73101;
(statearr_73113[(8)] = inst_73069);

return statearr_73113;
})();
var statearr_73114_73147 = state_73101__$1;
(statearr_73114_73147[(2)] = inst_73070);

(statearr_73114_73147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73102 === (5))){
var _ = (function (){var statearr_73115 = state_73101;
(statearr_73115[(4)] = cljs.core.rest((state_73101[(4)])));

return statearr_73115;
})();
var state_73101__$1 = state_73101;
var ex73112 = (state_73101__$1[(2)]);
var statearr_73116_73148 = state_73101__$1;
(statearr_73116_73148[(5)] = ex73112);


var statearr_73117_73149 = state_73101__$1;
(statearr_73117_73149[(1)] = (4));

(statearr_73117_73149[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73118 = [null,null,null,null,null,null,null,null,null];
(statearr_73118[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73118[(1)] = (1));

return statearr_73118;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_73101){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73101);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73119){var ex__2730__auto__ = e73119;
var statearr_73120_73150 = state_73101;
(statearr_73120_73150[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73101[(4)]))){
var statearr_73121_73151 = state_73101;
(statearr_73121_73151[(1)] = cljs.core.first((state_73101[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73152 = state_73101;
state_73101 = G__73152;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_73101){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_73101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73122 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73122[(6)] = c__2749__auto__);

return statearr_73122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__73154 = arguments.length;
switch (G__73154) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__73156 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73156,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73156,(1),null);
var cb_STAR_ = (function (header,data){
var G__73159 = cljs.core.clj__GT_js(header);
var G__73160 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__73159,G__73160) : callback.call(null,G__73159,G__73160));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__73161 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73161,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73161,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73214){
var state_val_73215 = (state_73214[(1)]);
if((state_val_73215 === (7))){
var inst_73175 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73176 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73177 = cljs.core.PersistentHashMap.fromArrays(inst_73175,inst_73176);
var inst_73178 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73177);
var inst_73179 = (function(){throw inst_73178})();
var state_73214__$1 = state_73214;
var statearr_73216_73248 = state_73214__$1;
(statearr_73216_73248[(2)] = inst_73179);

(statearr_73216_73248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (1))){
var state_73214__$1 = state_73214;
var statearr_73217_73249 = state_73214__$1;
(statearr_73217_73249[(2)] = null);

(statearr_73217_73249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (4))){
var inst_73164 = (state_73214[(2)]);
var inst_73165 = cljs.core.clj__GT_js(inst_73164);
var inst_73166 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73165) : reject.call(null,inst_73165));
var state_73214__$1 = state_73214;
var statearr_73218_73250 = state_73214__$1;
(statearr_73218_73250[(2)] = inst_73166);

(statearr_73218_73250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (13))){
var inst_73193 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73194 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73195 = cljs.core.PersistentHashMap.fromArrays(inst_73193,inst_73194);
var inst_73196 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_73195);
var inst_73197 = (function(){throw inst_73196})();
var state_73214__$1 = state_73214;
var statearr_73219_73251 = state_73214__$1;
(statearr_73219_73251[(2)] = inst_73197);

(statearr_73219_73251[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (6))){
var state_73214__$1 = state_73214;
var statearr_73220_73252 = state_73214__$1;
(statearr_73220_73252[(2)] = null);

(statearr_73220_73252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (3))){
var inst_73212 = (state_73214[(2)]);
var state_73214__$1 = state_73214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73214__$1,inst_73212);
} else {
if((state_val_73215 === (12))){
var state_73214__$1 = state_73214;
var statearr_73221_73253 = state_73214__$1;
(statearr_73221_73253[(2)] = null);

(statearr_73221_73253[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (2))){
var _ = (function (){var statearr_73222 = state_73214;
(statearr_73222[(4)] = cljs.core.cons((5),(state_73214[(4)])));

return statearr_73222;
})();
var inst_73172 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_73214__$1 = state_73214;
if(cljs.core.truth_(inst_73172)){
var statearr_73223_73254 = state_73214__$1;
(statearr_73223_73254[(1)] = (6));

} else {
var statearr_73224_73255 = state_73214__$1;
(statearr_73224_73255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (11))){
var inst_73190 = (state_73214[(2)]);
var state_73214__$1 = (function (){var statearr_73226 = state_73214;
(statearr_73226[(7)] = inst_73190);

return statearr_73226;
})();
if(cljs.core.truth_(password)){
var statearr_73227_73256 = state_73214__$1;
(statearr_73227_73256[(1)] = (12));

} else {
var statearr_73228_73257 = state_73214__$1;
(statearr_73228_73257[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (9))){
var state_73214__$1 = state_73214;
var statearr_73229_73258 = state_73214__$1;
(statearr_73229_73258[(2)] = null);

(statearr_73229_73258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (5))){
var _ = (function (){var statearr_73230 = state_73214;
(statearr_73230[(4)] = cljs.core.rest((state_73214[(4)])));

return statearr_73230;
})();
var state_73214__$1 = state_73214;
var ex73225 = (state_73214__$1[(2)]);
var statearr_73231_73259 = state_73214__$1;
(statearr_73231_73259[(5)] = ex73225);


var statearr_73232_73260 = state_73214__$1;
(statearr_73232_73260[(1)] = (4));

(statearr_73232_73260[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (14))){
var inst_73199 = (state_73214[(2)]);
var inst_73200 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_73201 = fluree.db.util.core.without_nils(inst_73200);
var inst_73202 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73203 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73205 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_73201,inst_73202,null];
var inst_73206 = (new cljs.core.PersistentVector(null,4,(5),inst_73204,inst_73205,null));
var inst_73207 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73203,inst_73206);
var inst_73208 = (function (){var _ = inst_73199;
var data = inst_73201;
var pc = inst_73202;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__73233 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73233) : reject.call(null,G__73233));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__73234 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73234) : reject.call(null,G__73234));
} else {
var G__73235 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__73235) : resolve.call(null,G__73235));

}
}
});
})();
var inst_73209 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73202,inst_73208);
var _ = (function (){var statearr_73236 = state_73214;
(statearr_73236[(4)] = cljs.core.rest((state_73214[(4)])));

return statearr_73236;
})();
var state_73214__$1 = (function (){var statearr_73237 = state_73214;
(statearr_73237[(8)] = inst_73207);

return statearr_73237;
})();
var statearr_73238_73261 = state_73214__$1;
(statearr_73238_73261[(2)] = inst_73209);

(statearr_73238_73261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (10))){
var inst_73184 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73185 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73186 = cljs.core.PersistentHashMap.fromArrays(inst_73184,inst_73185);
var inst_73187 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_73186);
var inst_73188 = (function(){throw inst_73187})();
var state_73214__$1 = state_73214;
var statearr_73239_73262 = state_73214__$1;
(statearr_73239_73262[(2)] = inst_73188);

(statearr_73239_73262[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73215 === (8))){
var inst_73181 = (state_73214[(2)]);
var state_73214__$1 = (function (){var statearr_73240 = state_73214;
(statearr_73240[(9)] = inst_73181);

return statearr_73240;
})();
if(cljs.core.truth_(ledger)){
var statearr_73241_73263 = state_73214__$1;
(statearr_73241_73263[(1)] = (9));

} else {
var statearr_73242_73264 = state_73214__$1;
(statearr_73242_73264[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_73243 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73243[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_73243[(1)] = (1));

return statearr_73243;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_73214){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73214);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73244){var ex__2730__auto__ = e73244;
var statearr_73245_73265 = state_73214;
(statearr_73245_73265[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73214[(4)]))){
var statearr_73246_73266 = state_73214;
(statearr_73246_73266[(1)] = cljs.core.first((state_73214[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73267 = state_73214;
state_73214 = G__73267;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_73214){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_73214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73247 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73247[(6)] = c__2749__auto__);

return statearr_73247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__73269 = arguments.length;
switch (G__73269) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73336){
var state_val_73337 = (state_73336[(1)]);
if((state_val_73337 === (7))){
var inst_73281 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73282 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73283 = cljs.core.PersistentHashMap.fromArrays(inst_73281,inst_73282);
var inst_73284 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73283);
var inst_73285 = (function(){throw inst_73284})();
var state_73336__$1 = state_73336;
var statearr_73338_73380 = state_73336__$1;
(statearr_73338_73380[(2)] = inst_73285);

(statearr_73338_73380[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (20))){
var inst_73319 = (state_73336[(2)]);
var inst_73320 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73321 = [ledger,password,user,auth,expire];
var inst_73322 = cljs.core.PersistentHashMap.fromArrays(inst_73320,inst_73321);
var inst_73323 = fluree.db.util.core.without_nils(inst_73322);
var inst_73324 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73325 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73327 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_73323,inst_73324,null];
var inst_73328 = (new cljs.core.PersistentVector(null,4,(5),inst_73326,inst_73327,null));
var inst_73329 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73325,inst_73328);
var inst_73330 = (function (){var _ = inst_73319;
var data = inst_73323;
var pc = inst_73324;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__73339 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73339) : reject.call(null,G__73339));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__73340 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73340) : reject.call(null,G__73340));
} else {
fluree.db.connection.add_token(conn,result);

var G__73341 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__73341) : resolve.call(null,G__73341));

}
}
});
})();
var inst_73331 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73324,inst_73330);
var _ = (function (){var statearr_73342 = state_73336;
(statearr_73342[(4)] = cljs.core.rest((state_73336[(4)])));

return statearr_73342;
})();
var state_73336__$1 = (function (){var statearr_73343 = state_73336;
(statearr_73343[(7)] = inst_73329);

return statearr_73343;
})();
var statearr_73344_73381 = state_73336__$1;
(statearr_73344_73381[(2)] = inst_73331);

(statearr_73344_73381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (1))){
var state_73336__$1 = state_73336;
var statearr_73345_73382 = state_73336__$1;
(statearr_73345_73382[(2)] = null);

(statearr_73345_73382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (4))){
var inst_73270 = (state_73336[(2)]);
var inst_73271 = cljs.core.clj__GT_js(inst_73270);
var inst_73272 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73271) : reject.call(null,inst_73271));
var state_73336__$1 = state_73336;
var statearr_73346_73383 = state_73336__$1;
(statearr_73346_73383[(2)] = inst_73272);

(statearr_73346_73383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (15))){
var inst_73306 = (state_73336[(8)]);
var state_73336__$1 = state_73336;
var statearr_73347_73384 = state_73336__$1;
(statearr_73347_73384[(2)] = inst_73306);

(statearr_73347_73384[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (13))){
var inst_73299 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73300 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73301 = cljs.core.PersistentHashMap.fromArrays(inst_73299,inst_73300);
var inst_73302 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_73301);
var inst_73303 = (function(){throw inst_73302})();
var state_73336__$1 = state_73336;
var statearr_73348_73385 = state_73336__$1;
(statearr_73348_73385[(2)] = inst_73303);

(statearr_73348_73385[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (6))){
var state_73336__$1 = state_73336;
var statearr_73349_73386 = state_73336__$1;
(statearr_73349_73386[(2)] = null);

(statearr_73349_73386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (17))){
var inst_73310 = (state_73336[(2)]);
var state_73336__$1 = state_73336;
if(cljs.core.truth_(inst_73310)){
var statearr_73350_73387 = state_73336__$1;
(statearr_73350_73387[(1)] = (18));

} else {
var statearr_73351_73388 = state_73336__$1;
(statearr_73351_73388[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (3))){
var inst_73334 = (state_73336[(2)]);
var state_73336__$1 = state_73336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73336__$1,inst_73334);
} else {
if((state_val_73337 === (12))){
var state_73336__$1 = state_73336;
var statearr_73352_73389 = state_73336__$1;
(statearr_73352_73389[(2)] = null);

(statearr_73352_73389[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (2))){
var _ = (function (){var statearr_73353 = state_73336;
(statearr_73353[(4)] = cljs.core.cons((5),(state_73336[(4)])));

return statearr_73353;
})();
var inst_73278 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_73336__$1 = state_73336;
if(cljs.core.truth_(inst_73278)){
var statearr_73354_73390 = state_73336__$1;
(statearr_73354_73390[(1)] = (6));

} else {
var statearr_73355_73391 = state_73336__$1;
(statearr_73355_73391[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (19))){
var inst_73313 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73314 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73315 = cljs.core.PersistentHashMap.fromArrays(inst_73313,inst_73314);
var inst_73316 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_73315);
var inst_73317 = (function(){throw inst_73316})();
var state_73336__$1 = state_73336;
var statearr_73356_73392 = state_73336__$1;
(statearr_73356_73392[(2)] = inst_73317);

(statearr_73356_73392[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (11))){
var inst_73296 = (state_73336[(2)]);
var state_73336__$1 = (function (){var statearr_73358 = state_73336;
(statearr_73358[(9)] = inst_73296);

return statearr_73358;
})();
if(cljs.core.truth_(password)){
var statearr_73359_73393 = state_73336__$1;
(statearr_73359_73393[(1)] = (12));

} else {
var statearr_73360_73394 = state_73336__$1;
(statearr_73360_73394[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (9))){
var state_73336__$1 = state_73336;
var statearr_73361_73395 = state_73336__$1;
(statearr_73361_73395[(2)] = null);

(statearr_73361_73395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (5))){
var _ = (function (){var statearr_73362 = state_73336;
(statearr_73362[(4)] = cljs.core.rest((state_73336[(4)])));

return statearr_73362;
})();
var state_73336__$1 = state_73336;
var ex73357 = (state_73336__$1[(2)]);
var statearr_73363_73396 = state_73336__$1;
(statearr_73363_73396[(5)] = ex73357);


var statearr_73364_73397 = state_73336__$1;
(statearr_73364_73397[(1)] = (4));

(statearr_73364_73397[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (14))){
var inst_73306 = (state_73336[(8)]);
var inst_73305 = (state_73336[(2)]);
var inst_73306__$1 = user;
var state_73336__$1 = (function (){var statearr_73365 = state_73336;
(statearr_73365[(10)] = inst_73305);

(statearr_73365[(8)] = inst_73306__$1);

return statearr_73365;
})();
if(cljs.core.truth_(inst_73306__$1)){
var statearr_73366_73398 = state_73336__$1;
(statearr_73366_73398[(1)] = (15));

} else {
var statearr_73367_73399 = state_73336__$1;
(statearr_73367_73399[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (16))){
var state_73336__$1 = state_73336;
var statearr_73368_73400 = state_73336__$1;
(statearr_73368_73400[(2)] = auth);

(statearr_73368_73400[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (10))){
var inst_73290 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73291 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73292 = cljs.core.PersistentHashMap.fromArrays(inst_73290,inst_73291);
var inst_73293 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_73292);
var inst_73294 = (function(){throw inst_73293})();
var state_73336__$1 = state_73336;
var statearr_73369_73401 = state_73336__$1;
(statearr_73369_73401[(2)] = inst_73294);

(statearr_73369_73401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (18))){
var state_73336__$1 = state_73336;
var statearr_73370_73402 = state_73336__$1;
(statearr_73370_73402[(2)] = null);

(statearr_73370_73402[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73337 === (8))){
var inst_73287 = (state_73336[(2)]);
var state_73336__$1 = (function (){var statearr_73371 = state_73336;
(statearr_73371[(11)] = inst_73287);

return statearr_73371;
})();
if(cljs.core.truth_(ledger)){
var statearr_73372_73403 = state_73336__$1;
(statearr_73372_73403[(1)] = (9));

} else {
var statearr_73373_73404 = state_73336__$1;
(statearr_73373_73404[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73374 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73374[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73374[(1)] = (1));

return statearr_73374;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_73336){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73336);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73375){var ex__2730__auto__ = e73375;
var statearr_73376_73405 = state_73336;
(statearr_73376_73405[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73336[(4)]))){
var statearr_73377_73406 = state_73336;
(statearr_73377_73406[(1)] = cljs.core.first((state_73336[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73407 = state_73336;
state_73336 = G__73407;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_73336){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_73336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73378 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73378[(6)] = c__2749__auto__);

return statearr_73378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__73409 = arguments.length;
switch (G__73409) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73444){
var state_val_73445 = (state_73444[(1)]);
if((state_val_73445 === (1))){
var state_73444__$1 = state_73444;
var statearr_73446_73468 = state_73444__$1;
(statearr_73446_73468[(2)] = null);

(statearr_73446_73468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73445 === (2))){
var _ = (function (){var statearr_73447 = state_73444;
(statearr_73447[(4)] = cljs.core.cons((5),(state_73444[(4)])));

return statearr_73447;
})();
var inst_73418 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_73444__$1 = state_73444;
if(cljs.core.truth_(inst_73418)){
var statearr_73448_73469 = state_73444__$1;
(statearr_73448_73469[(1)] = (6));

} else {
var statearr_73449_73470 = state_73444__$1;
(statearr_73449_73470[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73445 === (3))){
var inst_73442 = (state_73444[(2)]);
var state_73444__$1 = state_73444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73444__$1,inst_73442);
} else {
if((state_val_73445 === (4))){
var inst_73410 = (state_73444[(2)]);
var inst_73411 = cljs.core.clj__GT_js(inst_73410);
var inst_73412 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73411) : reject.call(null,inst_73411));
var state_73444__$1 = state_73444;
var statearr_73451_73471 = state_73444__$1;
(statearr_73451_73471[(2)] = inst_73412);

(statearr_73451_73471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73445 === (5))){
var _ = (function (){var statearr_73452 = state_73444;
(statearr_73452[(4)] = cljs.core.rest((state_73444[(4)])));

return statearr_73452;
})();
var state_73444__$1 = state_73444;
var ex73450 = (state_73444__$1[(2)]);
var statearr_73453_73472 = state_73444__$1;
(statearr_73453_73472[(5)] = ex73450);


var statearr_73454_73473 = state_73444__$1;
(statearr_73454_73473[(1)] = (4));

(statearr_73454_73473[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73445 === (6))){
var state_73444__$1 = state_73444;
var statearr_73455_73474 = state_73444__$1;
(statearr_73455_73474[(2)] = null);

(statearr_73455_73474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73445 === (7))){
var inst_73421 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73422 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73423 = cljs.core.PersistentHashMap.fromArrays(inst_73421,inst_73422);
var inst_73424 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73423);
var inst_73425 = (function(){throw inst_73424})();
var state_73444__$1 = state_73444;
var statearr_73456_73475 = state_73444__$1;
(statearr_73456_73475[(2)] = inst_73425);

(statearr_73456_73475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73445 === (8))){
var inst_73427 = (state_73444[(2)]);
var inst_73428 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73429 = [jwt,expire];
var inst_73430 = cljs.core.PersistentHashMap.fromArrays(inst_73428,inst_73429);
var inst_73431 = fluree.db.util.core.without_nils(inst_73430);
var inst_73432 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73433 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73435 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_73431,inst_73432,null];
var inst_73436 = (new cljs.core.PersistentVector(null,4,(5),inst_73434,inst_73435,null));
var inst_73437 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73433,inst_73436);
var inst_73438 = (function (){var _ = inst_73427;
var data = inst_73431;
var pc = inst_73432;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__73457 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73457) : reject.call(null,G__73457));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__73458 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__73458) : resolve.call(null,G__73458));

}
});
})();
var inst_73439 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73432,inst_73438);
var _ = (function (){var statearr_73459 = state_73444;
(statearr_73459[(4)] = cljs.core.rest((state_73444[(4)])));

return statearr_73459;
})();
var state_73444__$1 = (function (){var statearr_73460 = state_73444;
(statearr_73460[(7)] = inst_73437);

return statearr_73460;
})();
var statearr_73461_73476 = state_73444__$1;
(statearr_73461_73476[(2)] = inst_73439);

(statearr_73461_73476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_73462 = [null,null,null,null,null,null,null,null];
(statearr_73462[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_73462[(1)] = (1));

return statearr_73462;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_73444){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73444);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73463){var ex__2730__auto__ = e73463;
var statearr_73464_73477 = state_73444;
(statearr_73464_73477[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73444[(4)]))){
var statearr_73465_73478 = state_73444;
(statearr_73465_73478[(1)] = cljs.core.first((state_73444[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73479 = state_73444;
state_73444 = G__73479;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_73444){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_73444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73466 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73466[(6)] = c__2749__auto__);

return statearr_73466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

