// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37820 = arguments.length;
var i__5770__auto___37821 = (0);
while(true){
if((i__5770__auto___37821 < len__5769__auto___37820)){
args__5775__auto__.push((arguments[i__5770__auto___37821]));

var G__37822 = (i__5770__auto___37821 + (1));
i__5770__auto___37821 = G__37822;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__37815_37823 = e;
var G__37816_37824 = "Function Error: ";
var G__37817_37825 = function_name;
var G__37818_37826 = "args: ";
var G__37819_37827 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__37815_37823,G__37816_37824,G__37817_37825,G__37818_37826,G__37819_37827) : fluree.db.util.log.error.call(null,G__37815_37823,G__37816_37824,G__37817_37825,G__37818_37826,G__37819_37827));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq37812){
var G__37813 = cljs.core.first(seq37812);
var seq37812__$1 = cljs.core.next(seq37812);
var G__37814 = cljs.core.first(seq37812__$1);
var seq37812__$2 = cljs.core.next(seq37812__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37813,G__37814,seq37812__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e37828){var e = e37828;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e37829){var e = e37829;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e37830){var e = e37830;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e37831){var e = e37831;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e37832){var e = e37832;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37835 = arguments.length;
var i__5770__auto___37836 = (0);
while(true){
if((i__5770__auto___37836 < len__5769__auto___37835)){
args__5775__auto__.push((arguments[i__5770__auto___37836]));

var G__37837 = (i__5770__auto___37836 + (1));
i__5770__auto___37836 = G__37837;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e37834){var e = e37834;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq37833){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37833));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37840 = arguments.length;
var i__5770__auto___37841 = (0);
while(true){
if((i__5770__auto___37841 < len__5769__auto___37840)){
args__5775__auto__.push((arguments[i__5770__auto___37841]));

var G__37842 = (i__5770__auto___37841 + (1));
i__5770__auto___37841 = G__37842;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e37839){var e = e37839;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq37838){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37838));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e37843){var e = e37843;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37846 = arguments.length;
var i__5770__auto___37847 = (0);
while(true){
if((i__5770__auto___37847 < len__5769__auto___37846)){
args__5775__auto__.push((arguments[i__5770__auto___37847]));

var G__37848 = (i__5770__auto___37847 + (1));
i__5770__auto___37847 = G__37848;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e37845){var e = e37845;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq37844){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37844));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37851 = arguments.length;
var i__5770__auto___37852 = (0);
while(true){
if((i__5770__auto___37852 < len__5769__auto___37851)){
args__5775__auto__.push((arguments[i__5770__auto___37852]));

var G__37853 = (i__5770__auto___37852 + (1));
i__5770__auto___37852 = G__37853;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e37850){var e = e37850;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq37849){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37849));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e37854){var e = e37854;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e37855){var e = e37855;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37858 = arguments.length;
var i__5770__auto___37859 = (0);
while(true){
if((i__5770__auto___37859 < len__5769__auto___37858)){
args__5775__auto__.push((arguments[i__5770__auto___37859]));

var G__37860 = (i__5770__auto___37859 + (1));
i__5770__auto___37859 = G__37860;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e37857){var e = e37857;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq37856){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37856));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37863 = arguments.length;
var i__5770__auto___37864 = (0);
while(true){
if((i__5770__auto___37864 < len__5769__auto___37863)){
args__5775__auto__.push((arguments[i__5770__auto___37864]));

var G__37865 = (i__5770__auto___37864 + (1));
i__5770__auto___37864 = G__37865;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e37862){var e = e37862;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq37861){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37861));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37868 = arguments.length;
var i__5770__auto___37869 = (0);
while(true){
if((i__5770__auto___37869 < len__5769__auto___37868)){
args__5775__auto__.push((arguments[i__5770__auto___37869]));

var G__37870 = (i__5770__auto___37869 + (1));
i__5770__auto___37869 = G__37870;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e37867){var e = e37867;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq37866){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37866));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37873 = arguments.length;
var i__5770__auto___37874 = (0);
while(true){
if((i__5770__auto___37874 < len__5769__auto___37873)){
args__5775__auto__.push((arguments[i__5770__auto___37874]));

var G__37875 = (i__5770__auto___37874 + (1));
i__5770__auto___37874 = G__37875;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e37872){var e = e37872;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq37871){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37871));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37878 = arguments.length;
var i__5770__auto___37879 = (0);
while(true){
if((i__5770__auto___37879 < len__5769__auto___37878)){
args__5775__auto__.push((arguments[i__5770__auto___37879]));

var G__37880 = (i__5770__auto___37879 + (1));
i__5770__auto___37879 = G__37880;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e37877){var e = e37877;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq37876){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37876));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37883 = arguments.length;
var i__5770__auto___37884 = (0);
while(true){
if((i__5770__auto___37884 < len__5769__auto___37883)){
args__5775__auto__.push((arguments[i__5770__auto___37884]));

var G__37885 = (i__5770__auto___37884 + (1));
i__5770__auto___37884 = G__37885;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e37882){var e = e37882;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq37881){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37881));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___37888 = arguments.length;
var i__5770__auto___37889 = (0);
while(true){
if((i__5770__auto___37889 < len__5769__auto___37888)){
args__5775__auto__.push((arguments[i__5770__auto___37889]));

var G__37890 = (i__5770__auto___37889 + (1));
i__5770__auto___37889 = G__37890;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e37887){var e = e37887;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq37886){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37886));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__37892 = arguments.length;
switch (G__37892) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_37920){
var state_val_37921 = (state_37920[(1)]);
if((state_val_37921 === (7))){
var inst_37905 = (state_37920[(7)]);
var inst_37908 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_37905,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_37920__$1 = state_37920;
var statearr_37922_38008 = state_37920__$1;
(statearr_37922_38008[(2)] = inst_37908);

(statearr_37922_38008[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37921 === (1))){
var state_37920__$1 = state_37920;
var statearr_37923_38009 = state_37920__$1;
(statearr_37923_38009[(2)] = null);

(statearr_37923_38009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37921 === (4))){
var inst_37893 = (state_37920[(2)]);
var state_37920__$1 = state_37920;
var statearr_37924_38010 = state_37920__$1;
(statearr_37924_38010[(2)] = inst_37893);

(statearr_37924_38010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37921 === (6))){
var inst_37905 = (state_37920[(7)]);
var inst_37905__$1 = (state_37920[(2)]);
var inst_37906 = fluree.db.util.core.exception_QMARK_(inst_37905__$1);
var state_37920__$1 = (function (){var statearr_37925 = state_37920;
(statearr_37925[(7)] = inst_37905__$1);

return statearr_37925;
})();
if(inst_37906){
var statearr_37926_38011 = state_37920__$1;
(statearr_37926_38011[(1)] = (7));

} else {
var statearr_37927_38012 = state_37920__$1;
(statearr_37927_38012[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37921 === (3))){
var inst_37918 = (state_37920[(2)]);
var state_37920__$1 = state_37920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37920__$1,inst_37918);
} else {
if((state_val_37921 === (2))){
var inst_37899 = (state_37920[(8)]);
var _ = (function (){var statearr_37929 = state_37920;
(statearr_37929[(4)] = cljs.core.cons((5),(state_37920[(4)])));

return statearr_37929;
})();
var inst_37899__$1 = cljs.core.volatile_BANG_((0));
var inst_37900 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_37901 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_37900,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_37899__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_37902 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_37901);
var inst_37903 = fluree.db.query.fql.query(db,inst_37902);
var state_37920__$1 = (function (){var statearr_37930 = state_37920;
(statearr_37930[(8)] = inst_37899__$1);

return statearr_37930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37920__$1,(6),inst_37903);
} else {
if((state_val_37921 === (9))){
var inst_37915 = (state_37920[(2)]);
var _ = (function (){var statearr_37931 = state_37920;
(statearr_37931[(4)] = cljs.core.rest((state_37920[(4)])));

return statearr_37931;
})();
var state_37920__$1 = state_37920;
var statearr_37932_38013 = state_37920__$1;
(statearr_37932_38013[(2)] = inst_37915);

(statearr_37932_38013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37921 === (5))){
var _ = (function (){var statearr_37933 = state_37920;
(statearr_37933[(4)] = cljs.core.rest((state_37920[(4)])));

return statearr_37933;
})();
var state_37920__$1 = state_37920;
var ex37928 = (state_37920__$1[(2)]);
var statearr_37934_38014 = state_37920__$1;
(statearr_37934_38014[(5)] = ex37928);


if((ex37928 instanceof Error)){
var statearr_37935_38015 = state_37920__$1;
(statearr_37935_38015[(1)] = (4));

(statearr_37935_38015[(5)] = null);

} else {
throw ex37928;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37921 === (8))){
var inst_37899 = (state_37920[(8)]);
var inst_37905 = (state_37920[(7)]);
var inst_37910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37911 = cljs.core.deref(inst_37899);
var inst_37912 = [inst_37905,inst_37911];
var inst_37913 = (new cljs.core.PersistentVector(null,2,(5),inst_37910,inst_37912,null));
var state_37920__$1 = state_37920;
var statearr_37936_38016 = state_37920__$1;
(statearr_37936_38016[(2)] = inst_37913);

(statearr_37936_38016[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_37937 = [null,null,null,null,null,null,null,null,null];
(statearr_37937[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_37937[(1)] = (1));

return statearr_37937;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_37920){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_37920);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e37938){var ex__2730__auto__ = e37938;
var statearr_37939_38017 = state_37920;
(statearr_37939_38017[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_37920[(4)]))){
var statearr_37940_38018 = state_37920;
(statearr_37940_38018[(1)] = cljs.core.first((state_37920[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38019 = state_37920;
state_37920 = G__38019;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_37920){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_37920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_37941 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_37941[(6)] = c__2749__auto__);

return statearr_37941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_37986){
var state_val_37987 = (state_37986[(1)]);
if((state_val_37987 === (7))){
var inst_37972 = (state_37986[(2)]);
var inst_37973 = fluree.db.query.fql.query(db,inst_37972);
var state_37986__$1 = state_37986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37986__$1,(8),inst_37973);
} else {
if((state_val_37987 === (1))){
var inst_37942 = typeof select === 'string';
var state_37986__$1 = state_37986;
if(cljs.core.truth_(inst_37942)){
var statearr_37988_38020 = state_37986__$1;
(statearr_37988_38020[(1)] = (2));

} else {
var statearr_37989_38021 = state_37986__$1;
(statearr_37989_38021[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (4))){
var inst_37948 = (state_37986[(7)]);
var inst_37955 = (state_37986[(8)]);
var inst_37947 = (state_37986[(2)]);
var inst_37948__$1 = cljs.core.volatile_BANG_((0));
var inst_37949 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37950 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_37951 = [inst_37948__$1,(100000)];
var inst_37952 = cljs.core.PersistentHashMap.fromArrays(inst_37950,inst_37951);
var inst_37953 = [inst_37947,from,where,block,limit,inst_37952];
var inst_37954 = cljs.core.PersistentHashMap.fromArrays(inst_37949,inst_37953);
var inst_37955__$1 = fluree.db.util.core.without_nils(inst_37954);
var inst_37956 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_37955__$1);
var inst_37957 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_37955__$1);
var inst_37958 = cljs.core.first(inst_37957);
var inst_37959 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37958], 0));
var inst_37960 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_37959);
var inst_37961 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_37955__$1);
var inst_37962 = cljs.core.last(inst_37961);
var inst_37963 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37962], 0));
var inst_37964 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_37963);
var inst_37965 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37956,inst_37960,inst_37964], 0));
var state_37986__$1 = (function (){var statearr_37990 = state_37986;
(statearr_37990[(7)] = inst_37948__$1);

(statearr_37990[(8)] = inst_37955__$1);

return statearr_37990;
})();
if(cljs.core.truth_(inst_37965)){
var statearr_37991_38022 = state_37986__$1;
(statearr_37991_38022[(1)] = (5));

} else {
var statearr_37992_38023 = state_37986__$1;
(statearr_37992_38023[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (6))){
var inst_37955 = (state_37986[(8)]);
var state_37986__$1 = state_37986;
var statearr_37993_38024 = state_37986__$1;
(statearr_37993_38024[(2)] = inst_37955);

(statearr_37993_38024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (3))){
var state_37986__$1 = state_37986;
var statearr_37994_38025 = state_37986__$1;
(statearr_37994_38025[(2)] = select);

(statearr_37994_38025[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (2))){
var inst_37944 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_37986__$1 = state_37986;
var statearr_37995_38026 = state_37986__$1;
(statearr_37995_38026[(2)] = inst_37944);

(statearr_37995_38026[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (11))){
var inst_37984 = (state_37986[(2)]);
var state_37986__$1 = state_37986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37986__$1,inst_37984);
} else {
if((state_val_37987 === (9))){
var inst_37975 = (state_37986[(9)]);
var state_37986__$1 = state_37986;
var statearr_37996_38027 = state_37986__$1;
(statearr_37996_38027[(2)] = inst_37975);

(statearr_37996_38027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (5))){
var inst_37955 = (state_37986[(8)]);
var inst_37967 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_37955);
var inst_37968 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_37967);
var inst_37969 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37955,new cljs.core.Keyword(null,"where","where",-2044795965),inst_37968);
var state_37986__$1 = state_37986;
var statearr_37997_38028 = state_37986__$1;
(statearr_37997_38028[(2)] = inst_37969);

(statearr_37997_38028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (10))){
var inst_37975 = (state_37986[(9)]);
var inst_37948 = (state_37986[(7)]);
var inst_37979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37980 = cljs.core.deref(inst_37948);
var inst_37981 = [inst_37975,inst_37980];
var inst_37982 = (new cljs.core.PersistentVector(null,2,(5),inst_37979,inst_37981,null));
var state_37986__$1 = state_37986;
var statearr_37998_38029 = state_37986__$1;
(statearr_37998_38029[(2)] = inst_37982);

(statearr_37998_38029[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37987 === (8))){
var inst_37975 = (state_37986[(9)]);
var inst_37975__$1 = (state_37986[(2)]);
var inst_37976 = fluree.db.util.core.exception_QMARK_(inst_37975__$1);
var state_37986__$1 = (function (){var statearr_37999 = state_37986;
(statearr_37999[(9)] = inst_37975__$1);

return statearr_37999;
})();
if(inst_37976){
var statearr_38000_38030 = state_37986__$1;
(statearr_38000_38030[(1)] = (9));

} else {
var statearr_38001_38031 = state_37986__$1;
(statearr_38001_38031[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_38002 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38002[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_38002[(1)] = (1));

return statearr_38002;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_37986){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_37986);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38003){var ex__2730__auto__ = e38003;
var statearr_38004_38032 = state_37986;
(statearr_38004_38032[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_37986[(4)]))){
var statearr_38005_38033 = state_37986;
(statearr_38005_38033[(1)] = cljs.core.first((state_37986[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38034 = state_37986;
state_37986 = G__38034;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_37986){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_37986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38006 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38006[(6)] = c__2749__auto__);

return statearr_38006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__38038 = path;
var vec__38039 = G__38038;
var seq__38040 = cljs.core.seq(vec__38039);
var first__38041 = cljs.core.first(seq__38040);
var seq__38040__$1 = cljs.core.next(seq__38040);
var var$ = first__38041;
var r = seq__38040__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__38038__$1 = G__38038;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__38045 = G__38038__$1;
var seq__38046 = cljs.core.seq(vec__38045);
var first__38047 = cljs.core.first(seq__38046);
var seq__38046__$1 = cljs.core.next(seq__38046);
var var$__$1 = first__38047;
var r__$1 = seq__38046__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__38048 = r__$1;
var G__38049 = n__$2;
var G__38050 = next_clauses;
G__38038__$1 = G__38048;
n__$1 = G__38049;
where_clauses__$1 = G__38050;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__38051 = r__$1;
var G__38052 = next_n;
var G__38053 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__38038__$1 = G__38051;
n__$1 = G__38052;
where_clauses__$1 = G__38053;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38090){
var state_val_38091 = (state_38090[(1)]);
if((state_val_38091 === (7))){
var inst_38063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38064 = [path];
var inst_38065 = (new cljs.core.PersistentVector(null,1,(5),inst_38063,inst_38064,null));
var state_38090__$1 = state_38090;
var statearr_38092_38120 = state_38090__$1;
(statearr_38092_38120[(2)] = inst_38065);

(statearr_38092_38120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (1))){
var state_38090__$1 = state_38090;
var statearr_38093_38121 = state_38090__$1;
(statearr_38093_38121[(2)] = null);

(statearr_38093_38121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (4))){
var inst_38054 = (state_38090[(2)]);
var state_38090__$1 = state_38090;
var statearr_38094_38122 = state_38090__$1;
(statearr_38094_38122[(2)] = inst_38054);

(statearr_38094_38122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (13))){
var inst_38081 = (state_38090[(2)]);
var inst_38082 = fluree.db.util.async.throw_err(inst_38081);
var _ = (function (){var statearr_38095 = state_38090;
(statearr_38095[(4)] = cljs.core.rest((state_38090[(4)])));

return statearr_38095;
})();
var state_38090__$1 = state_38090;
var statearr_38096_38123 = state_38090__$1;
(statearr_38096_38123[(2)] = inst_38082);

(statearr_38096_38123[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (6))){
var state_38090__$1 = state_38090;
var statearr_38098_38124 = state_38090__$1;
(statearr_38098_38124[(2)] = path);

(statearr_38098_38124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (3))){
var inst_38088 = (state_38090[(2)]);
var state_38090__$1 = state_38090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38090__$1,inst_38088);
} else {
if((state_val_38091 === (12))){
var _ = (function (){var statearr_38099 = state_38090;
(statearr_38099[(4)] = cljs.core.rest((state_38090[(4)])));

return statearr_38099;
})();
var state_38090__$1 = state_38090;
var ex38097 = (state_38090__$1[(2)]);
var statearr_38100_38125 = state_38090__$1;
(statearr_38100_38125[(5)] = ex38097);


var statearr_38101_38126 = state_38090__$1;
(statearr_38101_38126[(1)] = (11));

(statearr_38101_38126[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (2))){
var _ = (function (){var statearr_38102 = state_38090;
(statearr_38102[(4)] = cljs.core.cons((5),(state_38090[(4)])));

return statearr_38102;
})();
var inst_38060 = cljs.core.vector_QMARK_(path);
var state_38090__$1 = state_38090;
if(inst_38060){
var statearr_38103_38127 = state_38090__$1;
(statearr_38103_38127[(1)] = (6));

} else {
var statearr_38104_38128 = state_38090__$1;
(statearr_38104_38128[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (11))){
var inst_38067 = (state_38090[(7)]);
var inst_38072 = (state_38090[(2)]);
var inst_38073 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38072,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_38067,endSubject], 0));
var state_38090__$1 = state_38090;
var statearr_38106_38129 = state_38090__$1;
(statearr_38106_38129[(2)] = inst_38073);

(statearr_38106_38129[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (9))){
var inst_38071 = (state_38090[(8)]);
var _ = (function (){var statearr_38107 = state_38090;
(statearr_38107[(4)] = cljs.core.cons((12),(state_38090[(4)])));

return statearr_38107;
})();
var inst_38079 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_38071);
var state_38090__$1 = state_38090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38090__$1,(13),inst_38079);
} else {
if((state_val_38091 === (5))){
var _ = (function (){var statearr_38108 = state_38090;
(statearr_38108[(4)] = cljs.core.rest((state_38090[(4)])));

return statearr_38108;
})();
var state_38090__$1 = state_38090;
var ex38105 = (state_38090__$1[(2)]);
var statearr_38109_38130 = state_38090__$1;
(statearr_38109_38130[(5)] = ex38105);


if((ex38105 instanceof Error)){
var statearr_38110_38131 = state_38090__$1;
(statearr_38110_38131[(1)] = (4));

(statearr_38110_38131[(5)] = null);

} else {
throw ex38105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (10))){
var inst_38085 = (state_38090[(2)]);
var _ = (function (){var statearr_38111 = state_38090;
(statearr_38111[(4)] = cljs.core.rest((state_38090[(4)])));

return statearr_38111;
})();
var state_38090__$1 = state_38090;
var statearr_38112_38132 = state_38090__$1;
(statearr_38112_38132[(2)] = inst_38085);

(statearr_38112_38132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38091 === (8))){
var inst_38067 = (state_38090[(7)]);
var inst_38067__$1 = (state_38090[(2)]);
var inst_38068 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_38067__$1,endSubject);
var inst_38069 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_38070 = ["?var1",inst_38068];
var inst_38071 = cljs.core.PersistentHashMap.fromArrays(inst_38069,inst_38070);
var state_38090__$1 = (function (){var statearr_38113 = state_38090;
(statearr_38113[(7)] = inst_38067__$1);

(statearr_38113[(8)] = inst_38071);

return statearr_38113;
})();
var statearr_38114_38133 = state_38090__$1;
(statearr_38114_38133[(2)] = null);

(statearr_38114_38133[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_38115 = [null,null,null,null,null,null,null,null,null];
(statearr_38115[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_38115[(1)] = (1));

return statearr_38115;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_38090){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38090);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38116){var ex__2730__auto__ = e38116;
var statearr_38117_38134 = state_38090;
(statearr_38117_38134[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38090[(4)]))){
var statearr_38118_38135 = state_38090;
(statearr_38118_38135[(1)] = cljs.core.first((state_38090[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38136 = state_38090;
state_38090 = G__38136;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = function(state_38090){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_38090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38119 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38119[(6)] = c__2749__auto__);

return statearr_38119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e38137){var e = e38137;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e38138){var e = e38138;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e38139){var e = e38139;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38193){
var state_val_38194 = (state_38193[(1)]);
if((state_val_38194 === (7))){
var state_38193__$1 = state_38193;
var statearr_38195_38233 = state_38193__$1;
(statearr_38195_38233[(2)] = pred);

(statearr_38195_38233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (20))){
var inst_38176 = (state_38193[(7)]);
var inst_38172 = (state_38193[(8)]);
var inst_38180 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_38176,inst_38172);
var state_38193__$1 = state_38193;
var statearr_38196_38234 = state_38193__$1;
(statearr_38196_38234[(2)] = inst_38180);

(statearr_38196_38234[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (1))){
var state_38193__$1 = state_38193;
var statearr_38197_38235 = state_38193__$1;
(statearr_38197_38235[(2)] = null);

(statearr_38197_38235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (4))){
var inst_38140 = (state_38193[(2)]);
var state_38193__$1 = state_38193;
var statearr_38198_38236 = state_38193__$1;
(statearr_38198_38236[(2)] = inst_38140);

(statearr_38198_38236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (15))){
var state_38193__$1 = state_38193;
var statearr_38199_38237 = state_38193__$1;
(statearr_38199_38237[(2)] = fluree.db.flake.o);

(statearr_38199_38237[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (21))){
var inst_38176 = (state_38193[(7)]);
var inst_38172 = (state_38193[(8)]);
var inst_38182 = cljs.core.first(inst_38172);
var inst_38183 = (inst_38176.cljs$core$IFn$_invoke$arity$1 ? inst_38176.cljs$core$IFn$_invoke$arity$1(inst_38182) : inst_38176.call(null,inst_38182));
var state_38193__$1 = state_38193;
var statearr_38200_38238 = state_38193__$1;
(statearr_38200_38238[(2)] = inst_38183);

(statearr_38200_38238[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (13))){
var inst_38169 = (state_38193[(2)]);
var inst_38170 = fluree.db.util.async.throw_err(inst_38169);
var state_38193__$1 = state_38193;
var statearr_38201_38239 = state_38193__$1;
(statearr_38201_38239[(2)] = inst_38170);

(statearr_38201_38239[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (22))){
var inst_38185 = (state_38193[(2)]);
var state_38193__$1 = state_38193;
var statearr_38202_38240 = state_38193__$1;
(statearr_38202_38240[(2)] = inst_38185);

(statearr_38202_38240[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (6))){
var inst_38150 = clojure.string.replace(pred,"/_","/");
var state_38193__$1 = state_38193;
var statearr_38203_38241 = state_38193__$1;
(statearr_38203_38241[(2)] = inst_38150);

(statearr_38203_38241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (17))){
var inst_38154 = (state_38193[(9)]);
var state_38193__$1 = state_38193;
if(cljs.core.truth_(inst_38154)){
var statearr_38204_38242 = state_38193__$1;
(statearr_38204_38242[(1)] = (20));

} else {
var statearr_38205_38243 = state_38193__$1;
(statearr_38205_38243[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (3))){
var inst_38191 = (state_38193[(2)]);
var state_38193__$1 = state_38193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38193__$1,inst_38191);
} else {
if((state_val_38194 === (12))){
var inst_38161 = (state_38193[(2)]);
var inst_38162 = fluree.db.util.async.throw_err(inst_38161);
var state_38193__$1 = state_38193;
var statearr_38206_38244 = state_38193__$1;
(statearr_38206_38244[(2)] = inst_38162);

(statearr_38206_38244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (2))){
var inst_38148 = (state_38193[(10)]);
var _ = (function (){var statearr_38207 = state_38193;
(statearr_38207[(4)] = cljs.core.cons((5),(state_38193[(4)])));

return statearr_38207;
})();
var inst_38146 = typeof pred === 'string';
var inst_38147 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_38148__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38146,inst_38147], 0));
var state_38193__$1 = (function (){var statearr_38208 = state_38193;
(statearr_38208[(10)] = inst_38148__$1);

return statearr_38208;
})();
if(cljs.core.truth_(inst_38148__$1)){
var statearr_38209_38245 = state_38193__$1;
(statearr_38209_38245[(1)] = (6));

} else {
var statearr_38210_38246 = state_38193__$1;
(statearr_38210_38246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (19))){
var inst_38188 = (state_38193[(2)]);
var _ = (function (){var statearr_38211 = state_38193;
(statearr_38211[(4)] = cljs.core.rest((state_38193[(4)])));

return statearr_38211;
})();
var state_38193__$1 = state_38193;
var statearr_38212_38247 = state_38193__$1;
(statearr_38212_38247[(2)] = inst_38188);

(statearr_38212_38247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (11))){
var inst_38148 = (state_38193[(10)]);
var inst_38172 = (state_38193[(2)]);
var state_38193__$1 = (function (){var statearr_38214 = state_38193;
(statearr_38214[(8)] = inst_38172);

return statearr_38214;
})();
if(cljs.core.truth_(inst_38148)){
var statearr_38215_38248 = state_38193__$1;
(statearr_38215_38248[(1)] = (14));

} else {
var statearr_38216_38249 = state_38193__$1;
(statearr_38216_38249[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (9))){
var inst_38153 = (state_38193[(11)]);
var inst_38156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38157 = [sid,inst_38153];
var inst_38158 = (new cljs.core.PersistentVector(null,2,(5),inst_38156,inst_38157,null));
var inst_38159 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_38158);
var state_38193__$1 = state_38193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38193__$1,(12),inst_38159);
} else {
if((state_val_38194 === (5))){
var _ = (function (){var statearr_38217 = state_38193;
(statearr_38217[(4)] = cljs.core.rest((state_38193[(4)])));

return statearr_38217;
})();
var state_38193__$1 = state_38193;
var ex38213 = (state_38193__$1[(2)]);
var statearr_38218_38250 = state_38193__$1;
(statearr_38218_38250[(5)] = ex38213);


if((ex38213 instanceof Error)){
var statearr_38219_38251 = state_38193__$1;
(statearr_38219_38251[(1)] = (4));

(statearr_38219_38251[(5)] = null);

} else {
throw ex38213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (14))){
var state_38193__$1 = state_38193;
var statearr_38220_38252 = state_38193__$1;
(statearr_38220_38252[(2)] = fluree.db.flake.s);

(statearr_38220_38252[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (16))){
var inst_38172 = (state_38193[(8)]);
var inst_38176 = (state_38193[(2)]);
var inst_38177 = cljs.core.seq(inst_38172);
var state_38193__$1 = (function (){var statearr_38221 = state_38193;
(statearr_38221[(7)] = inst_38176);

return statearr_38221;
})();
if(inst_38177){
var statearr_38222_38253 = state_38193__$1;
(statearr_38222_38253[(1)] = (17));

} else {
var statearr_38223_38254 = state_38193__$1;
(statearr_38223_38254[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (10))){
var inst_38153 = (state_38193[(11)]);
var inst_38164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38165 = [sid,inst_38153];
var inst_38166 = (new cljs.core.PersistentVector(null,2,(5),inst_38164,inst_38165,null));
var inst_38167 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_38166);
var state_38193__$1 = state_38193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38193__$1,(13),inst_38167);
} else {
if((state_val_38194 === (18))){
var state_38193__$1 = state_38193;
var statearr_38224_38255 = state_38193__$1;
(statearr_38224_38255[(2)] = null);

(statearr_38224_38255[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38194 === (8))){
var inst_38153 = (state_38193[(11)]);
var inst_38148 = (state_38193[(10)]);
var inst_38153__$1 = (state_38193[(2)]);
var inst_38154 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_38153__$1);
var state_38193__$1 = (function (){var statearr_38225 = state_38193;
(statearr_38225[(11)] = inst_38153__$1);

(statearr_38225[(9)] = inst_38154);

return statearr_38225;
})();
if(cljs.core.truth_(inst_38148)){
var statearr_38226_38256 = state_38193__$1;
(statearr_38226_38256[(1)] = (9));

} else {
var statearr_38227_38257 = state_38193__$1;
(statearr_38227_38257[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0 = (function (){
var statearr_38228 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38228[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__);

(statearr_38228[(1)] = (1));

return statearr_38228;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1 = (function (state_38193){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38193);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38229){var ex__2730__auto__ = e38229;
var statearr_38230_38258 = state_38193;
(statearr_38230_38258[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38193[(4)]))){
var statearr_38231_38259 = state_38193;
(statearr_38231_38259[(1)] = cljs.core.first((state_38193[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38260 = state_38193;
state_38193 = G__38260;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = function(state_38193){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1.call(this,state_38193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38232 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38232[(6)] = c__2749__auto__);

return statearr_38232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e38261){var e = e38261;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38264 = arguments.length;
var i__5770__auto___38265 = (0);
while(true){
if((i__5770__auto___38265 < len__5769__auto___38264)){
args__5775__auto__.push((arguments[i__5770__auto___38265]));

var G__38266 = (i__5770__auto___38265 + (1));
i__5770__auto___38265 = G__38266;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e38263){var e = e38263;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq38262){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38262));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38269 = arguments.length;
var i__5770__auto___38270 = (0);
while(true){
if((i__5770__auto___38270 < len__5769__auto___38269)){
args__5775__auto__.push((arguments[i__5770__auto___38270]));

var G__38271 = (i__5770__auto___38270 + (1));
i__5770__auto___38270 = G__38271;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e38268){var e = e38268;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq38267){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38267));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38274 = arguments.length;
var i__5770__auto___38275 = (0);
while(true){
if((i__5770__auto___38275 < len__5769__auto___38274)){
args__5775__auto__.push((arguments[i__5770__auto___38275]));

var G__38276 = (i__5770__auto___38275 + (1));
i__5770__auto___38275 = G__38276;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e38273){var e = e38273;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq38272){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38272));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38279 = arguments.length;
var i__5770__auto___38280 = (0);
while(true){
if((i__5770__auto___38280 < len__5769__auto___38279)){
args__5775__auto__.push((arguments[i__5770__auto___38280]));

var G__38281 = (i__5770__auto___38280 + (1));
i__5770__auto___38280 = G__38281;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e38278){var e = e38278;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq38277){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38277));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e38282){var e = e38282;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e38283){var e = e38283;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e38284){var e = e38284;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e38285){var e = e38285;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e38286){var e = e38286;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__38292 = path;
var vec__38293 = G__38292;
var seq__38294 = cljs.core.seq(vec__38293);
var first__38295 = cljs.core.first(seq__38294);
var seq__38294__$1 = cljs.core.next(seq__38294);
var pred = first__38295;
var r = seq__38294__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__38292__$1 = G__38292;
var subjects__$1 = subjects;
while(true){
var vec__38299 = G__38292__$1;
var seq__38300 = cljs.core.seq(vec__38299);
var first__38301 = cljs.core.first(seq__38300);
var seq__38300__$1 = cljs.core.next(seq__38300);
var pred__$1 = first__38301;
var r__$1 = seq__38300__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__38292__$1,subjects__$1,vec__38299,seq__38300,first__38301,seq__38300__$1,pred__$1,r__$1,subjects__$2,G__38292,vec__38293,seq__38294,first__38295,seq__38294__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__38292__$1,subjects__$1,vec__38299,seq__38300,first__38301,seq__38300__$1,pred__$1,r__$1,subjects__$2,G__38292,vec__38293,seq__38294,first__38295,seq__38294__$1,pred,r,subjects){
return (function (p1__38287_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__38287_SHARP_,pred__$1);
});})(G__38292__$1,subjects__$1,vec__38299,seq__38300,first__38301,seq__38300__$1,pred__$1,r__$1,subjects__$2,G__38292,vec__38293,seq__38294,first__38295,seq__38294__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__38292__$1,subjects__$1,vec__38299,seq__38300,first__38301,seq__38300__$1,pred__$1,r__$1,subjects__$2,G__38292,vec__38293,seq__38294,first__38295,seq__38294__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__38302 = r__$1;
var G__38303 = next_subjects;
G__38292__$1 = G__38302;
subjects__$1 = G__38303;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e38288){var e = e38288;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38343){
var state_val_38344 = (state_38343[(1)]);
if((state_val_38344 === (7))){
var state_38343__$1 = state_38343;
var statearr_38345_38364 = state_38343__$1;
(statearr_38345_38364[(2)] = path);

(statearr_38345_38364[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38344 === (1))){
var state_38343__$1 = state_38343;
var statearr_38346_38365 = state_38343__$1;
(statearr_38346_38365[(2)] = null);

(statearr_38346_38365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38344 === (4))){
var inst_38304 = (state_38343[(2)]);
var inst_38305 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38304,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_38343__$1 = state_38343;
var statearr_38347_38366 = state_38343__$1;
(statearr_38347_38366[(2)] = inst_38305);

(statearr_38347_38366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38344 === (6))){
var inst_38322 = (state_38343[(2)]);
var inst_38323 = fluree.db.util.async.throw_err(inst_38322);
var inst_38324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38323,(0),null);
var inst_38325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38323,(1),null);
var inst_38326 = cljs.core.last(path);
var inst_38327 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_38326);
var state_38343__$1 = (function (){var statearr_38348 = state_38343;
(statearr_38348[(7)] = inst_38324);

(statearr_38348[(8)] = inst_38325);

return statearr_38348;
})();
if(inst_38327){
var statearr_38349_38367 = state_38343__$1;
(statearr_38349_38367[(1)] = (7));

} else {
var statearr_38350_38368 = state_38343__$1;
(statearr_38350_38368[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38344 === (3))){
var inst_38341 = (state_38343[(2)]);
var state_38343__$1 = state_38343;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38343__$1,inst_38341);
} else {
if((state_val_38344 === (2))){
var _ = (function (){var statearr_38352 = state_38343;
(statearr_38352[(4)] = cljs.core.cons((5),(state_38343[(4)])));

return statearr_38352;
})();
var inst_38314 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_38315 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38316 = cljs.core.PersistentHashMap.EMPTY;
var inst_38317 = [inst_38314,sid,inst_38316];
var inst_38318 = cljs.core.PersistentHashMap.fromArrays(inst_38315,inst_38317);
var inst_38319 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38320 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38319,inst_38318);
var state_38343__$1 = state_38343;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38343__$1,(6),inst_38320);
} else {
if((state_val_38344 === (9))){
var inst_38324 = (state_38343[(7)]);
var inst_38325 = (state_38343[(8)]);
var inst_38332 = (state_38343[(2)]);
var inst_38333 = fluree.db.dbfunctions.internal.get_all(inst_38324,inst_38332);
var inst_38334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38335 = fluree.db.dbfunctions.internal.count(path);
var inst_38336 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38325,inst_38335,(9)], 0));
var inst_38337 = [inst_38333,inst_38336];
var inst_38338 = (new cljs.core.PersistentVector(null,2,(5),inst_38334,inst_38337,null));
var _ = (function (){var statearr_38353 = state_38343;
(statearr_38353[(4)] = cljs.core.rest((state_38343[(4)])));

return statearr_38353;
})();
var state_38343__$1 = state_38343;
var statearr_38354_38369 = state_38343__$1;
(statearr_38354_38369[(2)] = inst_38338);

(statearr_38354_38369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38344 === (5))){
var _ = (function (){var statearr_38355 = state_38343;
(statearr_38355[(4)] = cljs.core.rest((state_38343[(4)])));

return statearr_38355;
})();
var state_38343__$1 = state_38343;
var ex38351 = (state_38343__$1[(2)]);
var statearr_38356_38370 = state_38343__$1;
(statearr_38356_38370[(5)] = ex38351);


var statearr_38357_38371 = state_38343__$1;
(statearr_38357_38371[(1)] = (4));

(statearr_38357_38371[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38344 === (8))){
var inst_38330 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_38343__$1 = state_38343;
var statearr_38358_38372 = state_38343__$1;
(statearr_38358_38372[(2)] = inst_38330);

(statearr_38358_38372[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0 = (function (){
var statearr_38359 = [null,null,null,null,null,null,null,null,null];
(statearr_38359[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__);

(statearr_38359[(1)] = (1));

return statearr_38359;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1 = (function (state_38343){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38343);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38360){var ex__2730__auto__ = e38360;
var statearr_38361_38373 = state_38343;
(statearr_38361_38373[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38343[(4)]))){
var statearr_38362_38374 = state_38343;
(statearr_38362_38374[(1)] = cljs.core.first((state_38343[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38375 = state_38343;
state_38343 = G__38375;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = function(state_38343){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1.call(this,state_38343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38363 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38363[(6)] = c__2749__auto__);

return statearr_38363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e38376){var e = e38376;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__38377_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__38377_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__38377_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e38378){var e = e38378;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38381 = arguments.length;
var i__5770__auto___38382 = (0);
while(true){
if((i__5770__auto___38382 < len__5769__auto___38381)){
args__5775__auto__.push((arguments[i__5770__auto___38382]));

var G__38383 = (i__5770__auto___38382 + (1));
i__5770__auto___38382 = G__38383;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e38380){var e = e38380;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq38379){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38379));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e38384){var e = e38384;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___38387 = arguments.length;
var i__5770__auto___38388 = (0);
while(true){
if((i__5770__auto___38388 < len__5769__auto___38387)){
args__5775__auto__.push((arguments[i__5770__auto___38388]));

var G__38389 = (i__5770__auto___38388 + (1));
i__5770__auto___38388 = G__38389;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e38386){var e = e38386;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq38385){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38385));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e38390){var e = e38390;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38447){
var state_val_38448 = (state_38447[(1)]);
if((state_val_38448 === (7))){
var inst_38393 = (state_38447[(2)]);
var state_38447__$1 = state_38447;
var statearr_38449_38483 = state_38447__$1;
(statearr_38449_38483[(2)] = inst_38393);

(statearr_38449_38483[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (1))){
var state_38447__$1 = state_38447;
var statearr_38450_38484 = state_38447__$1;
(statearr_38450_38484[(2)] = null);

(statearr_38450_38484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (4))){
var inst_38392 = (state_38447[(2)]);
var state_38447__$1 = (function (){var statearr_38451 = state_38447;
(statearr_38451[(7)] = inst_38392);

return statearr_38451;
})();
var statearr_38452_38485 = state_38447__$1;
(statearr_38452_38485[(2)] = null);

(statearr_38452_38485[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (15))){
var inst_38427 = (state_38447[(8)]);
var inst_38417 = (state_38447[(9)]);
var inst_38430 = (state_38447[(10)]);
var inst_38418 = (state_38447[(11)]);
var inst_38428 = (state_38447[(12)]);
var inst_38415 = (state_38447[(13)]);
var inst_38434 = (function (){var db = inst_38415;
var prevT = inst_38417;
var db_SINGLEQUOTE_ = inst_38418;
var prev_vals = inst_38427;
var fuel = inst_38428;
var G__38429 = inst_38430;
return (function (p1__38391_SHARP_){
var f = p1__38391_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_38435 = (inst_38434.cljs$core$IFn$_invoke$arity$1 ? inst_38434.cljs$core$IFn$_invoke$arity$1(inst_38430) : inst_38434.call(null,inst_38430));
var state_38447__$1 = state_38447;
var statearr_38453_38486 = state_38447__$1;
(statearr_38453_38486[(2)] = inst_38435);

(statearr_38453_38486[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (13))){
var inst_38427 = (state_38447[(8)]);
var inst_38430 = (state_38447[(10)]);
var inst_38426 = (state_38447[(2)]);
var inst_38427__$1 = fluree.db.util.async.throw_err(inst_38426);
var inst_38428 = fluree.db.dbfunctions.internal.count(inst_38427__$1);
var inst_38430__$1 = cljs.core.first(inst_38427__$1);
var inst_38431 = (inst_38430__$1 == null);
var state_38447__$1 = (function (){var statearr_38454 = state_38447;
(statearr_38454[(8)] = inst_38427__$1);

(statearr_38454[(10)] = inst_38430__$1);

(statearr_38454[(12)] = inst_38428);

return statearr_38454;
})();
if(cljs.core.truth_(inst_38431)){
var statearr_38455_38487 = state_38447__$1;
(statearr_38455_38487[(1)] = (14));

} else {
var statearr_38456_38488 = state_38447__$1;
(statearr_38456_38488[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (6))){
var inst_38402 = (state_38447[(2)]);
var state_38447__$1 = state_38447;
var statearr_38457_38489 = state_38447__$1;
(statearr_38457_38489[(2)] = inst_38402);

(statearr_38457_38489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (3))){
var inst_38445 = (state_38447[(2)]);
var state_38447__$1 = state_38447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38447__$1,inst_38445);
} else {
if((state_val_38448 === (12))){
var inst_38442 = (state_38447[(2)]);
var _ = (function (){var statearr_38458 = state_38447;
(statearr_38458[(4)] = cljs.core.rest((state_38447[(4)])));

return statearr_38458;
})();
var state_38447__$1 = state_38447;
var statearr_38459_38490 = state_38447__$1;
(statearr_38459_38490[(2)] = inst_38442);

(statearr_38459_38490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (2))){
var _ = (function (){var statearr_38461 = state_38447;
(statearr_38461[(4)] = cljs.core.cons((9),(state_38447[(4)])));

return statearr_38461;
})();
var inst_38408 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38409 = typeof inst_38408 === 'string';
var state_38447__$1 = state_38447;
if(cljs.core.truth_(inst_38409)){
var statearr_38462_38491 = state_38447__$1;
(statearr_38462_38491[(1)] = (10));

} else {
var statearr_38463_38492 = state_38447__$1;
(statearr_38463_38492[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (11))){
var inst_38417 = (state_38447[(9)]);
var inst_38418 = (state_38447[(11)]);
var inst_38415 = (state_38447[(13)]);
var inst_38415__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38416 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_38415__$1);
var inst_38417__$1 = fluree.db.dbfunctions.internal.inc(inst_38416);
var inst_38418__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38415__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_38417__$1);
var inst_38419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38420 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38421 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38422 = [inst_38420,inst_38421];
var inst_38423 = (new cljs.core.PersistentVector(null,2,(5),inst_38419,inst_38422,null));
var inst_38424 = fluree.db.dbproto._search(inst_38418__$1,inst_38423);
var state_38447__$1 = (function (){var statearr_38464 = state_38447;
(statearr_38464[(9)] = inst_38417__$1);

(statearr_38464[(11)] = inst_38418__$1);

(statearr_38464[(13)] = inst_38415__$1);

return statearr_38464;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38447__$1,(13),inst_38424);
} else {
if((state_val_38448 === (9))){
var _ = (function (){var statearr_38465 = state_38447;
(statearr_38465[(4)] = cljs.core.rest((state_38447[(4)])));

return statearr_38465;
})();
var state_38447__$1 = state_38447;
var ex38460 = (state_38447__$1[(2)]);
var statearr_38466_38493 = state_38447__$1;
(statearr_38466_38493[(5)] = ex38460);


var statearr_38467_38494 = state_38447__$1;
(statearr_38467_38494[(1)] = (4));

(statearr_38467_38494[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (5))){
var inst_38392 = (state_38447[(7)]);
var _ = (function (){var statearr_38468 = state_38447;
(statearr_38468[(4)] = cljs.core.cons((8),(state_38447[(4)])));

return statearr_38468;
})();
var inst_38399 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38392,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_38469 = state_38447;
(statearr_38469[(4)] = cljs.core.rest((state_38447[(4)])));

return statearr_38469;
})();
var state_38447__$1 = state_38447;
var statearr_38470_38495 = state_38447__$1;
(statearr_38470_38495[(2)] = inst_38399);

(statearr_38470_38495[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (14))){
var state_38447__$1 = state_38447;
var statearr_38471_38496 = state_38447__$1;
(statearr_38471_38496[(2)] = null);

(statearr_38471_38496[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (16))){
var inst_38428 = (state_38447[(12)]);
var inst_38437 = (state_38447[(2)]);
var inst_38438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38439 = [inst_38437,inst_38428];
var inst_38440 = (new cljs.core.PersistentVector(null,2,(5),inst_38438,inst_38439,null));
var state_38447__$1 = state_38447;
var statearr_38473_38497 = state_38447__$1;
(statearr_38473_38497[(2)] = inst_38440);

(statearr_38473_38497[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (10))){
var inst_38411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38412 = [null,(0)];
var inst_38413 = (new cljs.core.PersistentVector(null,2,(5),inst_38411,inst_38412,null));
var state_38447__$1 = state_38447;
var statearr_38474_38498 = state_38447__$1;
(statearr_38474_38498[(2)] = inst_38413);

(statearr_38474_38498[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38448 === (8))){
var _ = (function (){var statearr_38475 = state_38447;
(statearr_38475[(4)] = cljs.core.rest((state_38447[(4)])));

return statearr_38475;
})();
var state_38447__$1 = state_38447;
var ex38472 = (state_38447__$1[(2)]);
var statearr_38476_38499 = state_38447__$1;
(statearr_38476_38499[(5)] = ex38472);


var statearr_38477_38500 = state_38447__$1;
(statearr_38477_38500[(1)] = (7));

(statearr_38477_38500[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_38478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38478[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_38478[(1)] = (1));

return statearr_38478;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_38447){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38447);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38479){var ex__2730__auto__ = e38479;
var statearr_38480_38501 = state_38447;
(statearr_38480_38501[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38447[(4)]))){
var statearr_38481_38502 = state_38447;
(statearr_38481_38502[(1)] = cljs.core.first((state_38447[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38503 = state_38447;
state_38447 = G__38503;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = function(state_38447){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_38447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38482 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38482[(6)] = c__2749__auto__);

return statearr_38482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38555){
var state_val_38556 = (state_38555[(1)]);
if((state_val_38556 === (7))){
var inst_38505 = (state_38555[(2)]);
var state_38555__$1 = state_38555;
var statearr_38557_38586 = state_38555__$1;
(statearr_38557_38586[(2)] = inst_38505);

(statearr_38557_38586[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (1))){
var state_38555__$1 = state_38555;
var statearr_38558_38587 = state_38555__$1;
(statearr_38558_38587[(2)] = null);

(statearr_38558_38587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (4))){
var inst_38504 = (state_38555[(2)]);
var state_38555__$1 = (function (){var statearr_38559 = state_38555;
(statearr_38559[(7)] = inst_38504);

return statearr_38559;
})();
var statearr_38560_38588 = state_38555__$1;
(statearr_38560_38588[(2)] = null);

(statearr_38560_38588[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (13))){
var inst_38550 = (state_38555[(2)]);
var _ = (function (){var statearr_38561 = state_38555;
(statearr_38561[(4)] = cljs.core.rest((state_38555[(4)])));

return statearr_38561;
})();
var state_38555__$1 = state_38555;
var statearr_38562_38589 = state_38555__$1;
(statearr_38562_38589[(2)] = inst_38550);

(statearr_38562_38589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (6))){
var inst_38514 = (state_38555[(2)]);
var state_38555__$1 = state_38555;
var statearr_38563_38590 = state_38555__$1;
(statearr_38563_38590[(2)] = inst_38514);

(statearr_38563_38590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (3))){
var inst_38553 = (state_38555[(2)]);
var state_38555__$1 = state_38555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38555__$1,inst_38553);
} else {
if((state_val_38556 === (12))){
var inst_38537 = (state_38555[(8)]);
var inst_38546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38547 = [null,inst_38537];
var inst_38548 = (new cljs.core.PersistentVector(null,2,(5),inst_38546,inst_38547,null));
var state_38555__$1 = state_38555;
var statearr_38564_38591 = state_38555__$1;
(statearr_38564_38591[(2)] = inst_38548);

(statearr_38564_38591[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (2))){
var _ = (function (){var statearr_38566 = state_38555;
(statearr_38566[(4)] = cljs.core.cons((9),(state_38555[(4)])));

return statearr_38566;
})();
var inst_38523 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38526 = [null,pred_name,"?o"];
var inst_38527 = (new cljs.core.PersistentVector(null,3,(5),inst_38525,inst_38526,null));
var inst_38528 = [inst_38527];
var inst_38529 = (new cljs.core.PersistentVector(null,1,(5),inst_38524,inst_38528,null));
var inst_38530 = ["?o",inst_38529,opts];
var inst_38531 = cljs.core.PersistentHashMap.fromArrays(inst_38523,inst_38530);
var inst_38532 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_38531);
var state_38555__$1 = state_38555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38555__$1,(10),inst_38532);
} else {
if((state_val_38556 === (11))){
var inst_38537 = (state_38555[(8)]);
var inst_38536 = (state_38555[(9)]);
var inst_38541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38542 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_38536);
var inst_38543 = [inst_38542,inst_38537];
var inst_38544 = (new cljs.core.PersistentVector(null,2,(5),inst_38541,inst_38543,null));
var state_38555__$1 = state_38555;
var statearr_38567_38592 = state_38555__$1;
(statearr_38567_38592[(2)] = inst_38544);

(statearr_38567_38592[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (9))){
var _ = (function (){var statearr_38568 = state_38555;
(statearr_38568[(4)] = cljs.core.rest((state_38555[(4)])));

return statearr_38568;
})();
var state_38555__$1 = state_38555;
var ex38565 = (state_38555__$1[(2)]);
var statearr_38569_38593 = state_38555__$1;
(statearr_38569_38593[(5)] = ex38565);


var statearr_38570_38594 = state_38555__$1;
(statearr_38570_38594[(1)] = (4));

(statearr_38570_38594[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (5))){
var inst_38504 = (state_38555[(7)]);
var _ = (function (){var statearr_38572 = state_38555;
(statearr_38572[(4)] = cljs.core.cons((8),(state_38555[(4)])));

return statearr_38572;
})();
var inst_38511 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38504,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_38573 = state_38555;
(statearr_38573[(4)] = cljs.core.rest((state_38555[(4)])));

return statearr_38573;
})();
var state_38555__$1 = state_38555;
var statearr_38574_38595 = state_38555__$1;
(statearr_38574_38595[(2)] = inst_38511);

(statearr_38574_38595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (10))){
var inst_38536 = (state_38555[(9)]);
var inst_38534 = (state_38555[(2)]);
var inst_38535 = fluree.db.util.async.throw_err(inst_38534);
var inst_38536__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38535,(0),null);
var inst_38537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38535,(1),null);
var inst_38538 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_38536__$1);
var inst_38539 = cljs.core.not(inst_38538);
var state_38555__$1 = (function (){var statearr_38575 = state_38555;
(statearr_38575[(8)] = inst_38537);

(statearr_38575[(9)] = inst_38536__$1);

return statearr_38575;
})();
if(inst_38539){
var statearr_38576_38596 = state_38555__$1;
(statearr_38576_38596[(1)] = (11));

} else {
var statearr_38577_38597 = state_38555__$1;
(statearr_38577_38597[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (8))){
var _ = (function (){var statearr_38578 = state_38555;
(statearr_38578[(4)] = cljs.core.rest((state_38555[(4)])));

return statearr_38578;
})();
var state_38555__$1 = state_38555;
var ex38571 = (state_38555__$1[(2)]);
var statearr_38579_38598 = state_38555__$1;
(statearr_38579_38598[(5)] = ex38571);


var statearr_38580_38599 = state_38555__$1;
(statearr_38580_38599[(1)] = (7));

(statearr_38580_38599[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_38581 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38581[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__);

(statearr_38581[(1)] = (1));

return statearr_38581;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1 = (function (state_38555){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38555);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38582){var ex__2730__auto__ = e38582;
var statearr_38583_38600 = state_38555;
(statearr_38583_38600[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38555[(4)]))){
var statearr_38584_38601 = state_38555;
(statearr_38584_38601[(1)] = cljs.core.first((state_38555[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38602 = state_38555;
state_38555 = G__38602;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = function(state_38555){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1.call(this,state_38555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38585 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38585[(6)] = c__2749__auto__);

return statearr_38585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e38603){var e = e38603;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__38605 = arguments.length;
switch (G__38605) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38675){
var state_val_38676 = (state_38675[(1)]);
if((state_val_38676 === (7))){
var inst_38607 = (state_38675[(2)]);
var state_38675__$1 = state_38675;
var statearr_38677_38721 = state_38675__$1;
(statearr_38677_38721[(2)] = inst_38607);

(statearr_38677_38721[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (20))){
var inst_38651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38652 = ["*"];
var inst_38653 = (new cljs.core.PersistentVector(null,1,(5),inst_38651,inst_38652,null));
var state_38675__$1 = state_38675;
var statearr_38678_38722 = state_38675__$1;
(statearr_38678_38722[(2)] = inst_38653);

(statearr_38678_38722[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (1))){
var state_38675__$1 = state_38675;
var statearr_38679_38723 = state_38675__$1;
(statearr_38679_38723[(2)] = null);

(statearr_38679_38723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (4))){
var inst_38606 = (state_38675[(2)]);
var state_38675__$1 = (function (){var statearr_38680 = state_38675;
(statearr_38680[(7)] = inst_38606);

return statearr_38680;
})();
var statearr_38681_38724 = state_38675__$1;
(statearr_38681_38724[(2)] = null);

(statearr_38681_38724[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (15))){
var inst_38670 = (state_38675[(2)]);
var _ = (function (){var statearr_38682 = state_38675;
(statearr_38682[(4)] = cljs.core.rest((state_38675[(4)])));

return statearr_38682;
})();
var state_38675__$1 = state_38675;
var statearr_38683_38725 = state_38675__$1;
(statearr_38683_38725[(2)] = inst_38670);

(statearr_38683_38725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (21))){
var inst_38634 = (state_38675[(8)]);
var inst_38641 = (state_38675[(9)]);
var inst_38655 = (state_38675[(2)]);
var inst_38656 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38657 = cljs.core.PersistentHashMap.EMPTY;
var inst_38658 = [inst_38655,inst_38641,inst_38657];
var inst_38659 = cljs.core.PersistentHashMap.fromArrays(inst_38656,inst_38658);
var inst_38660 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38634,inst_38659);
var state_38675__$1 = state_38675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38675__$1,(22),inst_38660);
} else {
if((state_val_38676 === (13))){
var inst_38629 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38675__$1 = state_38675;
var statearr_38684_38726 = state_38675__$1;
(statearr_38684_38726[(2)] = inst_38629);

(statearr_38684_38726[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (22))){
var inst_38662 = (state_38675[(2)]);
var inst_38663 = fluree.db.util.async.throw_err(inst_38662);
var inst_38664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38663,(0),null);
var inst_38665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38663,(1),null);
var inst_38666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38667 = [inst_38664,inst_38665];
var inst_38668 = (new cljs.core.PersistentVector(null,2,(5),inst_38666,inst_38667,null));
var state_38675__$1 = state_38675;
var statearr_38685_38727 = state_38675__$1;
(statearr_38685_38727[(2)] = inst_38668);

(statearr_38685_38727[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (6))){
var inst_38616 = (state_38675[(2)]);
var state_38675__$1 = state_38675;
var statearr_38686_38728 = state_38675__$1;
(statearr_38686_38728[(2)] = inst_38616);

(statearr_38686_38728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (17))){
var inst_38638 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38639 = fluree.db.dbfunctions.internal.get(inst_38638,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_38675__$1 = state_38675;
var statearr_38687_38729 = state_38675__$1;
(statearr_38687_38729[(2)] = inst_38639);

(statearr_38687_38729[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (3))){
var inst_38673 = (state_38675[(2)]);
var state_38675__$1 = state_38675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38675__$1,inst_38673);
} else {
if((state_val_38676 === (12))){
var inst_38627 = (state_38675[(2)]);
var state_38675__$1 = state_38675;
if(cljs.core.truth_(inst_38627)){
var statearr_38688_38730 = state_38675__$1;
(statearr_38688_38730[(1)] = (13));

} else {
var statearr_38689_38731 = state_38675__$1;
(statearr_38689_38731[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (2))){
var inst_38622 = (state_38675[(10)]);
var _ = (function (){var statearr_38690 = state_38675;
(statearr_38690[(4)] = cljs.core.cons((9),(state_38675[(4)])));

return statearr_38690;
})();
var inst_38622__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38675__$1 = (function (){var statearr_38691 = state_38675;
(statearr_38691[(10)] = inst_38622__$1);

return statearr_38691;
})();
if(cljs.core.truth_(inst_38622__$1)){
var statearr_38692_38732 = state_38675__$1;
(statearr_38692_38732[(1)] = (10));

} else {
var statearr_38693_38733 = state_38675__$1;
(statearr_38693_38733[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (19))){
var inst_38643 = cljs.core.PersistentVector.EMPTY;
var inst_38644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38645 = ["*"];
var inst_38646 = (new cljs.core.PersistentVector(null,1,(5),inst_38644,inst_38645,null));
var inst_38647 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_38648 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38646,inst_38647);
var inst_38649 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38643,inst_38648);
var state_38675__$1 = state_38675;
var statearr_38695_38734 = state_38675__$1;
(statearr_38695_38734[(2)] = inst_38649);

(statearr_38695_38734[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (11))){
var inst_38622 = (state_38675[(10)]);
var state_38675__$1 = state_38675;
var statearr_38696_38735 = state_38675__$1;
(statearr_38696_38735[(2)] = inst_38622);

(statearr_38696_38735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (9))){
var _ = (function (){var statearr_38697 = state_38675;
(statearr_38697[(4)] = cljs.core.rest((state_38675[(4)])));

return statearr_38697;
})();
var state_38675__$1 = state_38675;
var ex38694 = (state_38675__$1[(2)]);
var statearr_38698_38736 = state_38675__$1;
(statearr_38698_38736[(5)] = ex38694);


var statearr_38699_38737 = state_38675__$1;
(statearr_38699_38737[(1)] = (4));

(statearr_38699_38737[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (5))){
var inst_38606 = (state_38675[(7)]);
var _ = (function (){var statearr_38700 = state_38675;
(statearr_38700[(4)] = cljs.core.cons((8),(state_38675[(4)])));

return statearr_38700;
})();
var inst_38613 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38606,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_38701 = state_38675;
(statearr_38701[(4)] = cljs.core.rest((state_38675[(4)])));

return statearr_38701;
})();
var state_38675__$1 = state_38675;
var statearr_38702_38738 = state_38675__$1;
(statearr_38702_38738[(2)] = inst_38613);

(statearr_38702_38738[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (14))){
var inst_38635 = (state_38675[(11)]);
var inst_38634 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38635__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38675__$1 = (function (){var statearr_38703 = state_38675;
(statearr_38703[(8)] = inst_38634);

(statearr_38703[(11)] = inst_38635__$1);

return statearr_38703;
})();
if(cljs.core.truth_(inst_38635__$1)){
var statearr_38704_38739 = state_38675__$1;
(statearr_38704_38739[(1)] = (16));

} else {
var statearr_38705_38740 = state_38675__$1;
(statearr_38705_38740[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (16))){
var inst_38635 = (state_38675[(11)]);
var state_38675__$1 = state_38675;
var statearr_38706_38741 = state_38675__$1;
(statearr_38706_38741[(2)] = inst_38635);

(statearr_38706_38741[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (10))){
var inst_38624 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_38675__$1 = state_38675;
var statearr_38708_38742 = state_38675__$1;
(statearr_38708_38742[(2)] = inst_38624);

(statearr_38708_38742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (18))){
var inst_38641 = (state_38675[(2)]);
var state_38675__$1 = (function (){var statearr_38709 = state_38675;
(statearr_38709[(9)] = inst_38641);

return statearr_38709;
})();
if(cljs.core.truth_(additional_params)){
var statearr_38710_38743 = state_38675__$1;
(statearr_38710_38743[(1)] = (19));

} else {
var statearr_38711_38744 = state_38675__$1;
(statearr_38711_38744[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38676 === (8))){
var _ = (function (){var statearr_38712 = state_38675;
(statearr_38712[(4)] = cljs.core.rest((state_38675[(4)])));

return statearr_38712;
})();
var state_38675__$1 = state_38675;
var ex38707 = (state_38675__$1[(2)]);
var statearr_38713_38745 = state_38675__$1;
(statearr_38713_38745[(5)] = ex38707);


var statearr_38714_38746 = state_38675__$1;
(statearr_38714_38746[(1)] = (7));

(statearr_38714_38746[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_38715 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38715[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_38715[(1)] = (1));

return statearr_38715;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_38675){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38675);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38716){var ex__2730__auto__ = e38716;
var statearr_38717_38747 = state_38675;
(statearr_38717_38747[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38675[(4)]))){
var statearr_38718_38748 = state_38675;
(statearr_38718_38748[(1)] = cljs.core.first((state_38675[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38749 = state_38675;
state_38675 = G__38749;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_38675){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_38675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38719 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38719[(6)] = c__2749__auto__);

return statearr_38719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__38751 = arguments.length;
switch (G__38751) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38795){
var state_val_38796 = (state_38795[(1)]);
if((state_val_38796 === (7))){
var inst_38773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38774 = ["*"];
var inst_38775 = (new cljs.core.PersistentVector(null,1,(5),inst_38773,inst_38774,null));
var state_38795__$1 = state_38795;
var statearr_38797_38817 = state_38795__$1;
(statearr_38797_38817[(2)] = inst_38775);

(statearr_38797_38817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38796 === (1))){
var state_38795__$1 = state_38795;
var statearr_38798_38818 = state_38795__$1;
(statearr_38798_38818[(2)] = null);

(statearr_38798_38818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38796 === (4))){
var inst_38752 = (state_38795[(2)]);
var inst_38753 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38752,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_38795__$1 = state_38795;
var statearr_38799_38819 = state_38795__$1;
(statearr_38799_38819[(2)] = inst_38753);

(statearr_38799_38819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38796 === (6))){
var inst_38765 = cljs.core.PersistentVector.EMPTY;
var inst_38766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38767 = ["*"];
var inst_38768 = (new cljs.core.PersistentVector(null,1,(5),inst_38766,inst_38767,null));
var inst_38769 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_38770 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38768,inst_38769);
var inst_38771 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38765,inst_38770);
var state_38795__$1 = state_38795;
var statearr_38800_38820 = state_38795__$1;
(statearr_38800_38820[(2)] = inst_38771);

(statearr_38800_38820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38796 === (3))){
var inst_38793 = (state_38795[(2)]);
var state_38795__$1 = state_38795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38795__$1,inst_38793);
} else {
if((state_val_38796 === (2))){
var _ = (function (){var statearr_38802 = state_38795;
(statearr_38802[(4)] = cljs.core.cons((5),(state_38795[(4)])));

return statearr_38802;
})();
var inst_38762 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38763 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_38795__$1 = (function (){var statearr_38803 = state_38795;
(statearr_38803[(7)] = inst_38763);

(statearr_38803[(8)] = inst_38762);

return statearr_38803;
})();
if(cljs.core.truth_(additional_params)){
var statearr_38804_38821 = state_38795__$1;
(statearr_38804_38821[(1)] = (6));

} else {
var statearr_38805_38822 = state_38795__$1;
(statearr_38805_38822[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38796 === (9))){
var inst_38784 = (state_38795[(2)]);
var inst_38785 = fluree.db.util.async.throw_err(inst_38784);
var inst_38786 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38785,(0),null);
var inst_38787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38785,(1),null);
var inst_38788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38789 = [inst_38786,inst_38787];
var inst_38790 = (new cljs.core.PersistentVector(null,2,(5),inst_38788,inst_38789,null));
var _ = (function (){var statearr_38806 = state_38795;
(statearr_38806[(4)] = cljs.core.rest((state_38795[(4)])));

return statearr_38806;
})();
var state_38795__$1 = state_38795;
var statearr_38807_38823 = state_38795__$1;
(statearr_38807_38823[(2)] = inst_38790);

(statearr_38807_38823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38796 === (5))){
var _ = (function (){var statearr_38808 = state_38795;
(statearr_38808[(4)] = cljs.core.rest((state_38795[(4)])));

return statearr_38808;
})();
var state_38795__$1 = state_38795;
var ex38801 = (state_38795__$1[(2)]);
var statearr_38809_38824 = state_38795__$1;
(statearr_38809_38824[(5)] = ex38801);


var statearr_38810_38825 = state_38795__$1;
(statearr_38810_38825[(1)] = (4));

(statearr_38810_38825[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38796 === (8))){
var inst_38763 = (state_38795[(7)]);
var inst_38762 = (state_38795[(8)]);
var inst_38777 = (state_38795[(2)]);
var inst_38778 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38779 = cljs.core.PersistentHashMap.EMPTY;
var inst_38780 = [inst_38777,inst_38763,inst_38779];
var inst_38781 = cljs.core.PersistentHashMap.fromArrays(inst_38778,inst_38780);
var inst_38782 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38762,inst_38781);
var state_38795__$1 = state_38795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38795__$1,(9),inst_38782);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_38811 = [null,null,null,null,null,null,null,null,null];
(statearr_38811[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_38811[(1)] = (1));

return statearr_38811;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_38795){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38795);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38812){var ex__2730__auto__ = e38812;
var statearr_38813_38826 = state_38795;
(statearr_38813_38826[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38795[(4)]))){
var statearr_38814_38827 = state_38795;
(statearr_38814_38827[(1)] = cljs.core.first((state_38795[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38828 = state_38795;
state_38795 = G__38828;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_38795){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_38795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38815 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38815[(6)] = c__2749__auto__);

return statearr_38815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38872){
var state_val_38873 = (state_38872[(1)]);
if((state_val_38873 === (1))){
var state_38872__$1 = state_38872;
var statearr_38874_38888 = state_38872__$1;
(statearr_38874_38888[(2)] = null);

(statearr_38874_38888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38873 === (2))){
var _ = (function (){var statearr_38875 = state_38872;
(statearr_38875[(4)] = cljs.core.cons((5),(state_38872[(4)])));

return statearr_38875;
})();
var inst_38839 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38841 = ["_user/_auth"];
var inst_38842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38843 = ["*"];
var inst_38844 = (new cljs.core.PersistentVector(null,1,(5),inst_38842,inst_38843,null));
var inst_38845 = [inst_38844];
var inst_38846 = cljs.core.PersistentHashMap.fromArrays(inst_38841,inst_38845);
var inst_38847 = [inst_38846];
var inst_38848 = (new cljs.core.PersistentVector(null,1,(5),inst_38840,inst_38847,null));
var inst_38849 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38850 = cljs.core.PersistentHashMap.EMPTY;
var inst_38851 = [inst_38848,inst_38849,inst_38850];
var inst_38852 = cljs.core.PersistentHashMap.fromArrays(inst_38839,inst_38851);
var inst_38853 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38854 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38853,inst_38852);
var state_38872__$1 = state_38872;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38872__$1,(6),inst_38854);
} else {
if((state_val_38873 === (3))){
var inst_38870 = (state_38872[(2)]);
var state_38872__$1 = state_38872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38872__$1,inst_38870);
} else {
if((state_val_38873 === (4))){
var inst_38829 = (state_38872[(2)]);
var inst_38830 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_38829,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_38872__$1 = state_38872;
var statearr_38877_38889 = state_38872__$1;
(statearr_38877_38889[(2)] = inst_38830);

(statearr_38877_38889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38873 === (5))){
var _ = (function (){var statearr_38878 = state_38872;
(statearr_38878[(4)] = cljs.core.rest((state_38872[(4)])));

return statearr_38878;
})();
var state_38872__$1 = state_38872;
var ex38876 = (state_38872__$1[(2)]);
var statearr_38879_38890 = state_38872__$1;
(statearr_38879_38890[(5)] = ex38876);


var statearr_38880_38891 = state_38872__$1;
(statearr_38880_38891[(1)] = (4));

(statearr_38880_38891[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38873 === (6))){
var inst_38856 = (state_38872[(2)]);
var inst_38857 = fluree.db.util.async.throw_err(inst_38856);
var inst_38858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38857,(0),null);
var inst_38859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38857,(1),null);
var inst_38860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38861 = ["_user/_auth","_id"];
var inst_38862 = (new cljs.core.PersistentVector(null,2,(5),inst_38860,inst_38861,null));
var inst_38863 = fluree.db.dbfunctions.internal.get_in(inst_38858,inst_38862);
var inst_38864 = cljs.core.first(inst_38863);
var inst_38865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38866 = [inst_38864,inst_38859];
var inst_38867 = (new cljs.core.PersistentVector(null,2,(5),inst_38865,inst_38866,null));
var _ = (function (){var statearr_38881 = state_38872;
(statearr_38881[(4)] = cljs.core.rest((state_38872[(4)])));

return statearr_38881;
})();
var state_38872__$1 = state_38872;
var statearr_38882_38892 = state_38872__$1;
(statearr_38882_38892[(2)] = inst_38867);

(statearr_38882_38892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0 = (function (){
var statearr_38883 = [null,null,null,null,null,null,null];
(statearr_38883[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__);

(statearr_38883[(1)] = (1));

return statearr_38883;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1 = (function (state_38872){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38872);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38884){var ex__2730__auto__ = e38884;
var statearr_38885_38893 = state_38872;
(statearr_38885_38893[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38872[(4)]))){
var statearr_38886_38894 = state_38872;
(statearr_38886_38894[(1)] = cljs.core.first((state_38872[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38895 = state_38872;
state_38872 = G__38895;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = function(state_38872){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1.call(this,state_38872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38887 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38887[(6)] = c__2749__auto__);

return statearr_38887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_38917){
var state_val_38918 = (state_38917[(1)]);
if((state_val_38918 === (7))){
var inst_38902 = (state_38917[(7)]);
var inst_38906 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38907 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_38906,inst_38902);
var state_38917__$1 = state_38917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38917__$1,(9),inst_38907);
} else {
if((state_val_38918 === (1))){
var state_38917__$1 = state_38917;
var statearr_38919_38938 = state_38917__$1;
(statearr_38919_38938[(2)] = null);

(statearr_38919_38938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38918 === (4))){
var inst_38896 = (state_38917[(2)]);
var state_38917__$1 = state_38917;
var statearr_38920_38939 = state_38917__$1;
(statearr_38920_38939[(2)] = inst_38896);

(statearr_38920_38939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38918 === (6))){
var inst_38902 = (state_38917[(7)]);
var state_38917__$1 = state_38917;
var statearr_38921_38940 = state_38917__$1;
(statearr_38921_38940[(2)] = inst_38902);

(statearr_38921_38940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38918 === (3))){
var inst_38915 = (state_38917[(2)]);
var state_38917__$1 = state_38917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38917__$1,inst_38915);
} else {
if((state_val_38918 === (2))){
var inst_38902 = (state_38917[(7)]);
var _ = (function (){var statearr_38923 = state_38917;
(statearr_38923[(4)] = cljs.core.cons((5),(state_38917[(4)])));

return statearr_38923;
})();
var inst_38902__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_38903 = typeof inst_38902__$1 === 'number';
var state_38917__$1 = (function (){var statearr_38924 = state_38917;
(statearr_38924[(7)] = inst_38902__$1);

return statearr_38924;
})();
if(cljs.core.truth_(inst_38903)){
var statearr_38925_38941 = state_38917__$1;
(statearr_38925_38941[(1)] = (6));

} else {
var statearr_38926_38942 = state_38917__$1;
(statearr_38926_38942[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38918 === (9))){
var inst_38909 = (state_38917[(2)]);
var inst_38910 = fluree.db.util.async.throw_err(inst_38909);
var state_38917__$1 = state_38917;
var statearr_38927_38943 = state_38917__$1;
(statearr_38927_38943[(2)] = inst_38910);

(statearr_38927_38943[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38918 === (5))){
var _ = (function (){var statearr_38928 = state_38917;
(statearr_38928[(4)] = cljs.core.rest((state_38917[(4)])));

return statearr_38928;
})();
var state_38917__$1 = state_38917;
var ex38922 = (state_38917__$1[(2)]);
var statearr_38929_38944 = state_38917__$1;
(statearr_38929_38944[(5)] = ex38922);


if((ex38922 instanceof Error)){
var statearr_38930_38945 = state_38917__$1;
(statearr_38930_38945[(1)] = (4));

(statearr_38930_38945[(5)] = null);

} else {
throw ex38922;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38918 === (8))){
var inst_38912 = (state_38917[(2)]);
var _ = (function (){var statearr_38931 = state_38917;
(statearr_38931[(4)] = cljs.core.rest((state_38917[(4)])));

return statearr_38931;
})();
var state_38917__$1 = state_38917;
var statearr_38932_38946 = state_38917__$1;
(statearr_38932_38946[(2)] = inst_38912);

(statearr_38932_38946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_38933 = [null,null,null,null,null,null,null,null];
(statearr_38933[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_38933[(1)] = (1));

return statearr_38933;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_38917){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_38917);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e38934){var ex__2730__auto__ = e38934;
var statearr_38935_38947 = state_38917;
(statearr_38935_38947[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_38917[(4)]))){
var statearr_38936_38948 = state_38917;
(statearr_38936_38948[(1)] = cljs.core.first((state_38917[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38949 = state_38917;
state_38917 = G__38949;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_38917){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_38917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_38937 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_38937[(6)] = c__2749__auto__);

return statearr_38937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__38950_SHARP_){
return fluree.db.flake.op(p1__38950_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38951_SHARP_){
return fluree.db.flake.o(p1__38951_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e38952){var e = e38952;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__38953_SHARP_){
return fluree.db.flake.op(p1__38953_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38954_SHARP_){
return fluree.db.flake.o(p1__38954_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e38955){var e = e38955;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__38957 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__38957);
})() | (0));
return num;
}catch (e38956){var e = e38956;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_39037){
var state_val_39038 = (state_39037[(1)]);
if((state_val_39038 === (7))){
var inst_38976 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_38977 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38978 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_38979 = cljs.core.PersistentHashMap.fromArrays(inst_38977,inst_38978);
var inst_38980 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38976,inst_38979);
var inst_38981 = (function(){throw inst_38980})();
var state_39037__$1 = state_39037;
var statearr_39039_39074 = state_39037__$1;
(statearr_39039_39074[(2)] = inst_38981);

(statearr_39039_39074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (1))){
var state_39037__$1 = state_39037;
var statearr_39040_39075 = state_39037__$1;
(statearr_39040_39075[(2)] = null);

(statearr_39040_39075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (4))){
var inst_38958 = (state_39037[(2)]);
var state_39037__$1 = state_39037;
var statearr_39041_39076 = state_39037__$1;
(statearr_39041_39076[(2)] = inst_38958);

(statearr_39041_39076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (15))){
var inst_39021 = (state_39037[(7)]);
var inst_39017 = (state_39037[(2)]);
var inst_39018 = fluree.db.util.async.throw_err(inst_39017);
var inst_39019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39018,(0),null);
var inst_39020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39018,(1),null);
var inst_39021__$1 = cljs.core.first(inst_39019);
var inst_39022 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39021__$1,compare_val);
var state_39037__$1 = (function (){var statearr_39042 = state_39037;
(statearr_39042[(7)] = inst_39021__$1);

(statearr_39042[(8)] = inst_39020);

return statearr_39042;
})();
if(inst_39022){
var statearr_39043_39077 = state_39037__$1;
(statearr_39043_39077[(1)] = (16));

} else {
var statearr_39044_39078 = state_39037__$1;
(statearr_39044_39078[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (13))){
var state_39037__$1 = state_39037;
var statearr_39045_39079 = state_39037__$1;
(statearr_39045_39079[(2)] = null);

(statearr_39045_39079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (6))){
var state_39037__$1 = state_39037;
var statearr_39046_39080 = state_39037__$1;
(statearr_39046_39080[(2)] = null);

(statearr_39046_39080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (17))){
var inst_39021 = (state_39037[(7)]);
var inst_39025 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39021)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_39026 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39027 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39028 = cljs.core.PersistentHashMap.fromArrays(inst_39026,inst_39027);
var inst_39029 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39025,inst_39028);
var inst_39030 = (function(){throw inst_39029})();
var state_39037__$1 = state_39037;
var statearr_39047_39081 = state_39037__$1;
(statearr_39047_39081[(2)] = inst_39030);

(statearr_39047_39081[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (3))){
var inst_39035 = (state_39037[(2)]);
var state_39037__$1 = state_39037;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39037__$1,inst_39035);
} else {
if((state_val_39038 === (12))){
var inst_38973 = (state_39037[(9)]);
var inst_38996 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_38973], 0));
var inst_38997 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38998 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_38999 = cljs.core.PersistentHashMap.fromArrays(inst_38997,inst_38998);
var inst_39000 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38996,inst_38999);
var inst_39001 = (function(){throw inst_39000})();
var state_39037__$1 = state_39037;
var statearr_39048_39082 = state_39037__$1;
(statearr_39048_39082[(2)] = inst_39001);

(statearr_39048_39082[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (2))){
var inst_38972 = (state_39037[(10)]);
var inst_38971 = (state_39037[(11)]);
var inst_38970 = (state_39037[(12)]);
var _ = (function (){var statearr_39049 = state_39037;
(statearr_39049[(4)] = cljs.core.cons((5),(state_39037[(4)])));

return statearr_39049;
})();
var inst_38968 = _QMARK_ctx;
var inst_38969 = cljs.core.__destructure_map(inst_38968);
var inst_38970__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38969,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_38971__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38969,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_38972__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38969,new cljs.core.Keyword(null,"db","db",993250759));
var inst_38973 = fluree.db.dbproto._p_prop(inst_38972__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_38971__$1);
var state_39037__$1 = (function (){var statearr_39050 = state_39037;
(statearr_39050[(9)] = inst_38973);

(statearr_39050[(10)] = inst_38972__$1);

(statearr_39050[(11)] = inst_38971__$1);

(statearr_39050[(12)] = inst_38970__$1);

return statearr_39050;
})();
if(cljs.core.truth_(inst_38970__$1)){
var statearr_39051_39083 = state_39037__$1;
(statearr_39051_39083[(1)] = (6));

} else {
var statearr_39052_39084 = state_39037__$1;
(statearr_39052_39084[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (11))){
var inst_38972 = (state_39037[(10)]);
var inst_38971 = (state_39037[(11)]);
var inst_38993 = (state_39037[(2)]);
var inst_38994 = fluree.db.dbproto._p_prop(inst_38972,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_38971);
var state_39037__$1 = (function (){var statearr_39054 = state_39037;
(statearr_39054[(13)] = inst_38993);

return statearr_39054;
})();
if(cljs.core.truth_(inst_38994)){
var statearr_39055_39085 = state_39037__$1;
(statearr_39055_39085[(1)] = (12));

} else {
var statearr_39056_39086 = state_39037__$1;
(statearr_39056_39086[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (9))){
var state_39037__$1 = state_39037;
var statearr_39057_39087 = state_39037__$1;
(statearr_39057_39087[(2)] = null);

(statearr_39057_39087[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (5))){
var _ = (function (){var statearr_39058 = state_39037;
(statearr_39058[(4)] = cljs.core.rest((state_39037[(4)])));

return statearr_39058;
})();
var state_39037__$1 = state_39037;
var ex39053 = (state_39037__$1[(2)]);
var statearr_39059_39088 = state_39037__$1;
(statearr_39059_39088[(5)] = ex39053);


if((ex39053 instanceof Error)){
var statearr_39060_39089 = state_39037__$1;
(statearr_39060_39089[(1)] = (4));

(statearr_39060_39089[(5)] = null);

} else {
throw ex39053;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (14))){
var inst_38973 = (state_39037[(9)]);
var inst_38972 = (state_39037[(10)]);
var inst_38970 = (state_39037[(12)]);
var inst_39004 = (state_39037[(2)]);
var inst_39005 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39008 = [inst_38970,inst_38973,"?current-val"];
var inst_39009 = (new cljs.core.PersistentVector(null,3,(5),inst_39007,inst_39008,null));
var inst_39010 = [inst_39009];
var inst_39011 = (new cljs.core.PersistentVector(null,1,(5),inst_39006,inst_39010,null));
var inst_39012 = cljs.core.PersistentHashMap.EMPTY;
var inst_39013 = ["?current-val",inst_39011,inst_39012];
var inst_39014 = cljs.core.PersistentHashMap.fromArrays(inst_39005,inst_39013);
var inst_39015 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_38972,inst_39014);
var state_39037__$1 = (function (){var statearr_39061 = state_39037;
(statearr_39061[(14)] = inst_39004);

return statearr_39061;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39037__$1,(15),inst_39015);
} else {
if((state_val_39038 === (16))){
var state_39037__$1 = state_39037;
var statearr_39062_39090 = state_39037__$1;
(statearr_39062_39090[(2)] = new_val);

(statearr_39062_39090[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (10))){
var inst_38986 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_38987 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38988 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_38989 = cljs.core.PersistentHashMap.fromArrays(inst_38987,inst_38988);
var inst_38990 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38986,inst_38989);
var inst_38991 = (function(){throw inst_38990})();
var state_39037__$1 = state_39037;
var statearr_39063_39091 = state_39037__$1;
(statearr_39063_39091[(2)] = inst_38991);

(statearr_39063_39091[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (18))){
var inst_39032 = (state_39037[(2)]);
var _ = (function (){var statearr_39064 = state_39037;
(statearr_39064[(4)] = cljs.core.rest((state_39037[(4)])));

return statearr_39064;
})();
var state_39037__$1 = state_39037;
var statearr_39065_39092 = state_39037__$1;
(statearr_39065_39092[(2)] = inst_39032);

(statearr_39065_39092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39038 === (8))){
var inst_38973 = (state_39037[(9)]);
var inst_38983 = (state_39037[(2)]);
var state_39037__$1 = (function (){var statearr_39066 = state_39037;
(statearr_39066[(15)] = inst_38983);

return statearr_39066;
})();
if(cljs.core.truth_(inst_38973)){
var statearr_39067_39093 = state_39037__$1;
(statearr_39067_39093[(1)] = (9));

} else {
var statearr_39068_39094 = state_39037__$1;
(statearr_39068_39094[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_39069 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39069[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__);

(statearr_39069[(1)] = (1));

return statearr_39069;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1 = (function (state_39037){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_39037);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e39070){var ex__2730__auto__ = e39070;
var statearr_39071_39095 = state_39037;
(statearr_39071_39095[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_39037[(4)]))){
var statearr_39072_39096 = state_39037;
(statearr_39072_39096[(1)] = cljs.core.first((state_39037[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39097 = state_39037;
state_39037 = G__39097;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = function(state_39037){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1.call(this,state_39037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_39073 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_39073[(6)] = c__2749__auto__);

return statearr_39073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
