// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16052){
var state_val_16053 = (state_16052[(1)]);
if((state_val_16053 === (1))){
var state_16052__$1 = state_16052;
var statearr_16054_16068 = state_16052__$1;
(statearr_16054_16068[(2)] = null);

(statearr_16054_16068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16053 === (2))){
var _ = (function (){var statearr_16055 = state_16052;
(statearr_16055[(4)] = cljs.core.cons((5),(state_16052[(4)])));

return statearr_16055;
})();
var inst_16043 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_16052__$1 = state_16052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16052__$1,(6),inst_16043);
} else {
if((state_val_16053 === (3))){
var inst_16050 = (state_16052[(2)]);
var state_16052__$1 = state_16052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16052__$1,inst_16050);
} else {
if((state_val_16053 === (4))){
var inst_16037 = (state_16052[(2)]);
var state_16052__$1 = state_16052;
var statearr_16057_16069 = state_16052__$1;
(statearr_16057_16069[(2)] = inst_16037);

(statearr_16057_16069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16053 === (5))){
var _ = (function (){var statearr_16058 = state_16052;
(statearr_16058[(4)] = cljs.core.rest((state_16052[(4)])));

return statearr_16058;
})();
var state_16052__$1 = state_16052;
var ex16056 = (state_16052__$1[(2)]);
var statearr_16059_16070 = state_16052__$1;
(statearr_16059_16070[(5)] = ex16056);


if((ex16056 instanceof Error)){
var statearr_16060_16071 = state_16052__$1;
(statearr_16060_16071[(1)] = (4));

(statearr_16060_16071[(5)] = null);

} else {
throw ex16056;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16053 === (6))){
var inst_16045 = (state_16052[(2)]);
var inst_16046 = fluree.db.util.async.throw_err(inst_16045);
var inst_16047 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16046);
var _ = (function (){var statearr_16061 = state_16052;
(statearr_16061[(4)] = cljs.core.rest((state_16052[(4)])));

return statearr_16061;
})();
var state_16052__$1 = state_16052;
var statearr_16062_16072 = state_16052__$1;
(statearr_16062_16072[(2)] = inst_16047);

(statearr_16062_16072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0 = (function (){
var statearr_16063 = [null,null,null,null,null,null,null];
(statearr_16063[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__);

(statearr_16063[(1)] = (1));

return statearr_16063;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1 = (function (state_16052){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16052);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16064){var ex__2730__auto__ = e16064;
var statearr_16065_16073 = state_16052;
(statearr_16065_16073[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16052[(4)]))){
var statearr_16066_16074 = state_16052;
(statearr_16066_16074[(1)] = cljs.core.first((state_16052[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16075 = state_16052;
state_16052 = G__16075;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = function(state_16052){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1.call(this,state_16052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16067 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16067[(6)] = c__2749__auto__);

return statearr_16067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16107){
var state_val_16108 = (state_16107[(1)]);
if((state_val_16108 === (7))){
var inst_16091 = (state_16107[(7)]);
var inst_16093 = cljs.core.empty_QMARK_(inst_16091);
var inst_16094 = (!(inst_16093));
var state_16107__$1 = state_16107;
var statearr_16109_16133 = state_16107__$1;
(statearr_16109_16133[(2)] = inst_16094);

(statearr_16109_16133[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (1))){
var state_16107__$1 = state_16107;
var statearr_16110_16134 = state_16107__$1;
(statearr_16110_16134[(2)] = null);

(statearr_16110_16134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (4))){
var inst_16077 = (state_16107[(2)]);
var state_16107__$1 = state_16107;
var statearr_16111_16135 = state_16107__$1;
(statearr_16111_16135[(2)] = inst_16077);

(statearr_16111_16135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (6))){
var inst_16083 = (state_16107[(8)]);
var inst_16091 = (state_16107[(7)]);
var inst_16089 = (state_16107[(2)]);
var inst_16090 = fluree.db.util.async.throw_err(inst_16089);
var inst_16091__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16083,inst_16090);
var state_16107__$1 = (function (){var statearr_16112 = state_16107;
(statearr_16112[(7)] = inst_16091__$1);

return statearr_16112;
})();
if(cljs.core.truth_(inst_16091__$1)){
var statearr_16113_16136 = state_16107__$1;
(statearr_16113_16136[(1)] = (7));

} else {
var statearr_16114_16137 = state_16107__$1;
(statearr_16114_16137[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (3))){
var inst_16105 = (state_16107[(2)]);
var state_16107__$1 = state_16107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16107__$1,inst_16105);
} else {
if((state_val_16108 === (12))){
var inst_16102 = (state_16107[(2)]);
var _ = (function (){var statearr_16115 = state_16107;
(statearr_16115[(4)] = cljs.core.rest((state_16107[(4)])));

return statearr_16115;
})();
var state_16107__$1 = state_16107;
var statearr_16116_16138 = state_16107__$1;
(statearr_16116_16138[(2)] = inst_16102);

(statearr_16116_16138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (2))){
var _ = (function (){var statearr_16117 = state_16107;
(statearr_16117[(4)] = cljs.core.cons((5),(state_16107[(4)])));

return statearr_16117;
})();
var inst_16083 = (function (){return (function (p1__16076_SHARP_){
return fluree.db.flake.o(p1__16076_SHARP_);
});
})();
var inst_16084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16085 = [pred_id];
var inst_16086 = (new cljs.core.PersistentVector(null,1,(5),inst_16084,inst_16085,null));
var inst_16087 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16086);
var state_16107__$1 = (function (){var statearr_16118 = state_16107;
(statearr_16118[(8)] = inst_16083);

return statearr_16118;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16107__$1,(6),inst_16087);
} else {
if((state_val_16108 === (11))){
var state_16107__$1 = state_16107;
var statearr_16120_16139 = state_16107__$1;
(statearr_16120_16139[(2)] = true);

(statearr_16120_16139[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (9))){
var inst_16097 = (state_16107[(2)]);
var state_16107__$1 = state_16107;
if(cljs.core.truth_(inst_16097)){
var statearr_16121_16140 = state_16107__$1;
(statearr_16121_16140[(1)] = (10));

} else {
var statearr_16122_16141 = state_16107__$1;
(statearr_16122_16141[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (5))){
var _ = (function (){var statearr_16123 = state_16107;
(statearr_16123[(4)] = cljs.core.rest((state_16107[(4)])));

return statearr_16123;
})();
var state_16107__$1 = state_16107;
var ex16119 = (state_16107__$1[(2)]);
var statearr_16124_16142 = state_16107__$1;
(statearr_16124_16142[(5)] = ex16119);


if((ex16119 instanceof Error)){
var statearr_16125_16143 = state_16107__$1;
(statearr_16125_16143[(1)] = (4));

(statearr_16125_16143[(5)] = null);

} else {
throw ex16119;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (10))){
var inst_16091 = (state_16107[(7)]);
var inst_16099 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_16091);
var state_16107__$1 = state_16107;
var statearr_16126_16144 = state_16107__$1;
(statearr_16126_16144[(2)] = inst_16099);

(statearr_16126_16144[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16108 === (8))){
var inst_16091 = (state_16107[(7)]);
var state_16107__$1 = state_16107;
var statearr_16127_16145 = state_16107__$1;
(statearr_16127_16145[(2)] = inst_16091);

(statearr_16127_16145[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_16128 = [null,null,null,null,null,null,null,null,null];
(statearr_16128[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__);

(statearr_16128[(1)] = (1));

return statearr_16128;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1 = (function (state_16107){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16107);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16129){var ex__2730__auto__ = e16129;
var statearr_16130_16146 = state_16107;
(statearr_16130_16146[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16107[(4)]))){
var statearr_16131_16147 = state_16107;
(statearr_16131_16147[(1)] = cljs.core.first((state_16107[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16148 = state_16107;
state_16107 = G__16148;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = function(state_16107){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1.call(this,state_16107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16132 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16132[(6)] = c__2749__auto__);

return statearr_16132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16229){
var state_val_16230 = (state_16229[(1)]);
if((state_val_16230 === (7))){
var state_16229__$1 = state_16229;
var statearr_16231_16269 = state_16229__$1;
(statearr_16231_16269[(2)] = flakes);

(statearr_16231_16269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (20))){
var inst_16186 = (state_16229[(7)]);
var inst_16219 = (state_16229[(2)]);
var inst_16178 = inst_16186;
var inst_16179 = inst_16219;
var state_16229__$1 = (function (){var statearr_16232 = state_16229;
(statearr_16232[(8)] = inst_16179);

(statearr_16232[(9)] = inst_16178);

return statearr_16232;
})();
var statearr_16233_16270 = state_16229__$1;
(statearr_16233_16270[(2)] = null);

(statearr_16233_16270[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (1))){
var state_16229__$1 = state_16229;
var statearr_16234_16271 = state_16229__$1;
(statearr_16234_16271[(2)] = null);

(statearr_16234_16271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (4))){
var inst_16151 = (state_16229[(2)]);
var state_16229__$1 = state_16229;
var statearr_16235_16272 = state_16229__$1;
(statearr_16235_16272[(2)] = inst_16151);

(statearr_16235_16272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (15))){
var inst_16185 = (state_16229[(10)]);
var inst_16203 = fluree.db.flake.o(inst_16185);
var state_16229__$1 = state_16229;
var statearr_16236_16273 = state_16229__$1;
(statearr_16236_16273[(2)] = inst_16203);

(statearr_16236_16273[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (13))){
var inst_16222 = (state_16229[(2)]);
var state_16229__$1 = state_16229;
var statearr_16237_16274 = state_16229__$1;
(statearr_16237_16274[(2)] = inst_16222);

(statearr_16237_16274[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (6))){
var inst_16158 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16229__$1 = state_16229;
var statearr_16238_16275 = state_16229__$1;
(statearr_16238_16275[(2)] = inst_16158);

(statearr_16238_16275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (17))){
var inst_16200 = (state_16229[(2)]);
var inst_16201 = fluree.db.util.async.throw_err(inst_16200);
var state_16229__$1 = state_16229;
var statearr_16239_16276 = state_16229__$1;
(statearr_16239_16276[(2)] = inst_16201);

(statearr_16239_16276[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (3))){
var inst_16227 = (state_16229[(2)]);
var state_16229__$1 = state_16229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16229__$1,inst_16227);
} else {
if((state_val_16230 === (12))){
var inst_16192 = (state_16229[(11)]);
var inst_16185 = (state_16229[(10)]);
var inst_16190 = fluree.db.flake.p(inst_16185);
var inst_16191 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16190);
var inst_16192__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_16191);
var inst_16193 = fluree.db.flake.op(inst_16185);
var inst_16194 = inst_16193 === false;
var inst_16195 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_16192__$1);
var state_16229__$1 = (function (){var statearr_16240 = state_16229;
(statearr_16240[(11)] = inst_16192__$1);

(statearr_16240[(12)] = inst_16194);

return statearr_16240;
})();
if(inst_16195){
var statearr_16241_16277 = state_16229__$1;
(statearr_16241_16277[(1)] = (14));

} else {
var statearr_16242_16278 = state_16229__$1;
(statearr_16242_16278[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (2))){
var _ = (function (){var statearr_16243 = state_16229;
(statearr_16243[(4)] = cljs.core.cons((5),(state_16229[(4)])));

return statearr_16243;
})();
var state_16229__$1 = state_16229;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16244_16279 = state_16229__$1;
(statearr_16244_16279[(1)] = (6));

} else {
var statearr_16245_16280 = state_16229__$1;
(statearr_16245_16280[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (19))){
var inst_16192 = (state_16229[(11)]);
var inst_16205 = (state_16229[(13)]);
var inst_16179 = (state_16229[(8)]);
var inst_16185 = (state_16229[(10)]);
var inst_16213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16214 = fluree.db.flake.s(inst_16185);
var inst_16215 = [inst_16214,inst_16192,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16216 = (new cljs.core.PersistentVector(null,3,(5),inst_16213,inst_16215,null));
var inst_16217 = cljs.core.assoc_in(inst_16179,inst_16216,inst_16205);
var state_16229__$1 = state_16229;
var statearr_16246_16281 = state_16229__$1;
(statearr_16246_16281[(2)] = inst_16217);

(statearr_16246_16281[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (11))){
var inst_16179 = (state_16229[(8)]);
var state_16229__$1 = state_16229;
var statearr_16248_16282 = state_16229__$1;
(statearr_16248_16282[(2)] = inst_16179);

(statearr_16248_16282[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (9))){
var inst_16178 = (state_16229[(9)]);
var inst_16185 = (state_16229[(10)]);
var inst_16184 = cljs.core.seq(inst_16178);
var inst_16185__$1 = cljs.core.first(inst_16184);
var inst_16186 = cljs.core.next(inst_16184);
var inst_16187 = cljs.core.not(inst_16185__$1);
var state_16229__$1 = (function (){var statearr_16249 = state_16229;
(statearr_16249[(7)] = inst_16186);

(statearr_16249[(10)] = inst_16185__$1);

return statearr_16249;
})();
if(inst_16187){
var statearr_16250_16283 = state_16229__$1;
(statearr_16250_16283[(1)] = (11));

} else {
var statearr_16251_16284 = state_16229__$1;
(statearr_16251_16284[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (5))){
var _ = (function (){var statearr_16252 = state_16229;
(statearr_16252[(4)] = cljs.core.rest((state_16229[(4)])));

return statearr_16252;
})();
var state_16229__$1 = state_16229;
var ex16247 = (state_16229__$1[(2)]);
var statearr_16253_16285 = state_16229__$1;
(statearr_16253_16285[(5)] = ex16247);


if((ex16247 instanceof Error)){
var statearr_16254_16286 = state_16229__$1;
(statearr_16254_16286[(1)] = (4));

(statearr_16254_16286[(5)] = null);

} else {
throw ex16247;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (14))){
var inst_16185 = (state_16229[(10)]);
var inst_16197 = fluree.db.flake.o(inst_16185);
var inst_16198 = fluree.db.query.schema.convert_type_to_kw(inst_16197,db);
var state_16229__$1 = state_16229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16229__$1,(17),inst_16198);
} else {
if((state_val_16230 === (16))){
var inst_16194 = (state_16229[(12)]);
var inst_16205 = (state_16229[(2)]);
var state_16229__$1 = (function (){var statearr_16255 = state_16229;
(statearr_16255[(13)] = inst_16205);

return statearr_16255;
})();
if(cljs.core.truth_(inst_16194)){
var statearr_16256_16287 = state_16229__$1;
(statearr_16256_16287[(1)] = (18));

} else {
var statearr_16257_16288 = state_16229__$1;
(statearr_16257_16288[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (10))){
var inst_16224 = (state_16229[(2)]);
var _ = (function (){var statearr_16258 = state_16229;
(statearr_16258[(4)] = cljs.core.rest((state_16229[(4)])));

return statearr_16258;
})();
var state_16229__$1 = state_16229;
var statearr_16259_16289 = state_16229__$1;
(statearr_16259_16289[(2)] = inst_16224);

(statearr_16259_16289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (18))){
var inst_16192 = (state_16229[(11)]);
var inst_16205 = (state_16229[(13)]);
var inst_16179 = (state_16229[(8)]);
var inst_16185 = (state_16229[(10)]);
var inst_16207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16208 = fluree.db.flake.s(inst_16185);
var inst_16209 = [inst_16208,inst_16192,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16210 = (new cljs.core.PersistentVector(null,3,(5),inst_16207,inst_16209,null));
var inst_16211 = cljs.core.assoc_in(inst_16179,inst_16210,inst_16205);
var state_16229__$1 = state_16229;
var statearr_16260_16290 = state_16229__$1;
(statearr_16260_16290[(2)] = inst_16211);

(statearr_16260_16290[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16230 === (8))){
var inst_16161 = (state_16229[(2)]);
var inst_16162 = cljs.core.PersistentHashSet.EMPTY;
var inst_16163 = cljs.core.vals(tempids);
var inst_16164 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16162,inst_16163);
var inst_16165 = (function (){var pred_flakes = inst_16161;
var is_new_QMARK_ = inst_16164;
return (function (p1__16150_SHARP_,p2__16149_SHARP_){
var f = p2__16149_SHARP_;
return cljs.core.assoc_in(p1__16150_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s(f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16261 = fluree.db.flake.s(f);
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16261) : is_new_QMARK_.call(null,G__16261));
})()));
});
})();
var inst_16166 = cljs.core.PersistentHashMap.EMPTY;
var inst_16167 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16165,inst_16166,inst_16161);
var inst_16175 = cljs.core.seq(inst_16161);
var inst_16176 = cljs.core.first(inst_16175);
var inst_16177 = cljs.core.next(inst_16175);
var inst_16178 = inst_16161;
var inst_16179 = inst_16167;
var state_16229__$1 = (function (){var statearr_16262 = state_16229;
(statearr_16262[(14)] = inst_16176);

(statearr_16262[(15)] = inst_16177);

(statearr_16262[(8)] = inst_16179);

(statearr_16262[(9)] = inst_16178);

return statearr_16262;
})();
var statearr_16263_16291 = state_16229__$1;
(statearr_16263_16291[(2)] = null);

(statearr_16263_16291[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0 = (function (){
var statearr_16264 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16264[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__);

(statearr_16264[(1)] = (1));

return statearr_16264;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1 = (function (state_16229){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16229);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16265){var ex__2730__auto__ = e16265;
var statearr_16266_16292 = state_16229;
(statearr_16266_16292[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16229[(4)]))){
var statearr_16267_16293 = state_16229;
(statearr_16267_16293[(1)] = cljs.core.first((state_16229[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16294 = state_16229;
state_16229 = G__16294;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = function(state_16229){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1.call(this,state_16229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16268 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16268[(6)] = c__2749__auto__);

return statearr_16268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16296 = arguments.length;
switch (G__16296) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16299 = arguments.length;
switch (G__16299) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16611){
var state_val_16612 = (state_16611[(1)]);
if((state_val_16612 === (121))){
var inst_16566 = (state_16611[(7)]);
var state_16611__$1 = state_16611;
var statearr_16613_16806 = state_16611__$1;
(statearr_16613_16806[(2)] = inst_16566);

(statearr_16613_16806[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (65))){
var inst_16465 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16465)){
var statearr_16614_16807 = state_16611__$1;
(statearr_16614_16807[(1)] = (66));

} else {
var statearr_16615_16808 = state_16611__$1;
(statearr_16615_16808[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (70))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16475 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16476 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16475,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,3,inst_16475,null));
var inst_16477 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16476,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16476,null));
var inst_16478 = (inst_16477.cljs$core$IFn$_invoke$arity$1 ? inst_16477.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16477.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16478)){
var statearr_16616_16809 = state_16611__$1;
(statearr_16616_16809[(1)] = (72));

} else {
var statearr_16617_16810 = state_16611__$1;
(statearr_16617_16810[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (62))){
var inst_16455 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16618_16811 = state_16611__$1;
(statearr_16618_16811[(2)] = inst_16455);

(statearr_16618_16811[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (74))){
var inst_16561 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16619_16812 = state_16611__$1;
(statearr_16619_16812[(2)] = inst_16561);

(statearr_16619_16812[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (110))){
var inst_16588 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16588)){
var statearr_16620_16813 = state_16611__$1;
(statearr_16620_16813[(1)] = (117));

} else {
var statearr_16621_16814 = state_16611__$1;
(statearr_16621_16814[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (7))){
var inst_16606 = (state_16611[(2)]);
var _ = (function (){var statearr_16622 = state_16611;
(statearr_16622[(4)] = cljs.core.rest((state_16611[(4)])));

return statearr_16622;
})();
var state_16611__$1 = state_16611;
var statearr_16623_16815 = state_16611__$1;
(statearr_16623_16815[(2)] = inst_16606);

(statearr_16623_16815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (59))){
var inst_16339 = (state_16611[(10)]);
var inst_16459 = (state_16611[(11)]);
var inst_16458 = (state_16611[(2)]);
var inst_16459__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16339);
var state_16611__$1 = (function (){var statearr_16624 = state_16611;
(statearr_16624[(12)] = inst_16458);

(statearr_16624[(11)] = inst_16459__$1);

return statearr_16624;
})();
if(cljs.core.truth_(inst_16459__$1)){
var statearr_16625_16816 = state_16611__$1;
(statearr_16625_16816[(1)] = (63));

} else {
var statearr_16626_16817 = state_16611__$1;
(statearr_16626_16817[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (86))){
var inst_16501 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16627_16818 = state_16611__$1;
(statearr_16627_16818[(2)] = inst_16501);

(statearr_16627_16818[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (20))){
var inst_16339 = (state_16611[(10)]);
var inst_16365 = (state_16611[(13)]);
var inst_16365__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16339);
var state_16611__$1 = (function (){var statearr_16628 = state_16611;
(statearr_16628[(13)] = inst_16365__$1);

return statearr_16628;
})();
if(cljs.core.truth_(inst_16365__$1)){
var statearr_16629_16819 = state_16611__$1;
(statearr_16629_16819[(1)] = (23));

} else {
var statearr_16630_16820 = state_16611__$1;
(statearr_16630_16820[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (72))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16480 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16631_16821 = state_16611__$1;
(statearr_16631_16821[(2)] = inst_16480);

(statearr_16631_16821[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (58))){
var inst_16420 = (state_16611[(14)]);
var state_16611__$1 = state_16611;
var statearr_16632_16822 = state_16611__$1;
(statearr_16632_16822[(2)] = inst_16420);

(statearr_16632_16822[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (60))){
var inst_16338 = (state_16611[(15)]);
var inst_16327 = (state_16611[(16)]);
var inst_16446 = fluree.db.dbproto._p_prop(inst_16327,new cljs.core.Keyword(null,"name","name",1843675177),inst_16338);
var inst_16447 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16446)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16448 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16449 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16450 = cljs.core.PersistentHashMap.fromArrays(inst_16448,inst_16449);
var inst_16451 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16447,inst_16450);
var inst_16452 = (function(){throw inst_16451})();
var state_16611__$1 = state_16611;
var statearr_16633_16823 = state_16611__$1;
(statearr_16633_16823[(2)] = inst_16452);

(statearr_16633_16823[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (27))){
var inst_16368 = (state_16611[(17)]);
var state_16611__$1 = state_16611;
var statearr_16634_16824 = state_16611__$1;
(statearr_16634_16824[(2)] = inst_16368);

(statearr_16634_16824[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (1))){
var state_16611__$1 = state_16611;
var statearr_16635_16825 = state_16611__$1;
(statearr_16635_16825[(2)] = null);

(statearr_16635_16825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (69))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16636_16826 = state_16611__$1;
(statearr_16636_16826[(2)] = inst_16458);

(statearr_16636_16826[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (101))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16539 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16637_16827 = state_16611__$1;
(statearr_16637_16827[(2)] = inst_16539);

(statearr_16637_16827[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (24))){
var inst_16365 = (state_16611[(13)]);
var state_16611__$1 = state_16611;
var statearr_16638_16828 = state_16611__$1;
(statearr_16638_16828[(2)] = inst_16365);

(statearr_16638_16828[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (102))){
var inst_16541 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16639_16829 = state_16611__$1;
(statearr_16639_16829[(2)] = inst_16541);

(statearr_16639_16829[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (55))){
var inst_16437 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16640_16830 = state_16611__$1;
(statearr_16640_16830[(2)] = inst_16437);

(statearr_16640_16830[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (85))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16499 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16641_16831 = state_16611__$1;
(statearr_16641_16831[(2)] = inst_16499);

(statearr_16641_16831[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (39))){
var inst_16402 = (state_16611[(18)]);
var state_16611__$1 = state_16611;
var statearr_16642_16832 = state_16611__$1;
(statearr_16642_16832[(2)] = inst_16402);

(statearr_16642_16832[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (88))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16643_16833 = state_16611__$1;
(statearr_16643_16833[(2)] = inst_16458);

(statearr_16643_16833[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (46))){
var inst_16339 = (state_16611[(10)]);
var inst_16421 = (state_16611[(19)]);
var inst_16420 = (state_16611[(2)]);
var inst_16421__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16339);
var state_16611__$1 = (function (){var statearr_16644 = state_16611;
(statearr_16644[(14)] = inst_16420);

(statearr_16644[(19)] = inst_16421__$1);

return statearr_16644;
})();
if(cljs.core.truth_(inst_16421__$1)){
var statearr_16645_16834 = state_16611__$1;
(statearr_16645_16834[(1)] = (47));

} else {
var statearr_16646_16835 = state_16611__$1;
(statearr_16646_16835[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (4))){
var inst_16300 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16647_16836 = state_16611__$1;
(statearr_16647_16836[(2)] = inst_16300);

(statearr_16647_16836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (77))){
var inst_16559 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16648_16837 = state_16611__$1;
(statearr_16648_16837[(2)] = inst_16559);

(statearr_16648_16837[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (106))){
var inst_16551 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16649_16838 = state_16611__$1;
(statearr_16649_16838[(2)] = inst_16551);

(statearr_16649_16838[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (119))){
var inst_16337 = (state_16611[(20)]);
var inst_16601 = (state_16611[(2)]);
var inst_16326 = inst_16337;
var inst_16327 = inst_16601;
var state_16611__$1 = (function (){var statearr_16650 = state_16611;
(statearr_16650[(21)] = inst_16326);

(statearr_16650[(16)] = inst_16327);

return statearr_16650;
})();
var statearr_16651_16839 = state_16611__$1;
(statearr_16651_16839[(2)] = null);

(statearr_16651_16839[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (95))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16523 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16524 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16523,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,5,inst_16523,null));
var inst_16525 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16524,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16524,null));
var inst_16526 = (inst_16525.cljs$core$IFn$_invoke$arity$1 ? inst_16525.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16525.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16526)){
var statearr_16652_16840 = state_16611__$1;
(statearr_16652_16840[(1)] = (96));

} else {
var statearr_16653_16841 = state_16611__$1;
(statearr_16653_16841[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (54))){
var inst_16428 = (state_16611[(22)]);
var state_16611__$1 = state_16611;
var statearr_16654_16842 = state_16611__$1;
(statearr_16654_16842[(2)] = inst_16428);

(statearr_16654_16842[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (92))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16655_16843 = state_16611__$1;
(statearr_16655_16843[(2)] = inst_16458);

(statearr_16655_16843[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (104))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16656_16844 = state_16611__$1;
(statearr_16656_16844[(2)] = inst_16458);

(statearr_16656_16844[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (15))){
var inst_16347 = (state_16611[(23)]);
var state_16611__$1 = state_16611;
var statearr_16657_16845 = state_16611__$1;
(statearr_16657_16845[(2)] = inst_16347);

(statearr_16657_16845[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (48))){
var inst_16421 = (state_16611[(19)]);
var state_16611__$1 = state_16611;
var statearr_16658_16846 = state_16611__$1;
(statearr_16658_16846[(2)] = inst_16421);

(statearr_16658_16846[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (50))){
var inst_16428 = (state_16611[(22)]);
var inst_16339 = (state_16611[(10)]);
var inst_16426 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16427 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16426);
var inst_16428__$1 = inst_16427 === true;
var state_16611__$1 = (function (){var statearr_16659 = state_16611;
(statearr_16659[(22)] = inst_16428__$1);

return statearr_16659;
})();
if(cljs.core.truth_(inst_16428__$1)){
var statearr_16660_16847 = state_16611__$1;
(statearr_16660_16847[(1)] = (53));

} else {
var statearr_16661_16848 = state_16611__$1;
(statearr_16661_16848[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (116))){
var inst_16582 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16662_16849 = state_16611__$1;
(statearr_16662_16849[(2)] = inst_16582);

(statearr_16662_16849[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (75))){
var inst_16471 = (state_16611[(8)]);
var state_16611__$1 = state_16611;
var G__16663_16850 = inst_16471;
var G__16663_16851__$1 = (((G__16663_16850 instanceof cljs.core.Keyword))?G__16663_16850.fqn:null);
switch (G__16663_16851__$1) {
case "long":
var statearr_16664_16853 = state_16611__$1;
(statearr_16664_16853[(1)] = (79));


break;
case "bigint":
var statearr_16665_16854 = state_16611__$1;
(statearr_16665_16854[(1)] = (83));


break;
case "double":
var statearr_16666_16855 = state_16611__$1;
(statearr_16666_16855[(1)] = (87));


break;
case "float":
var statearr_16667_16856 = state_16611__$1;
(statearr_16667_16856[(1)] = (91));


break;
case "bigdec":
var statearr_16668_16857 = state_16611__$1;
(statearr_16668_16857[(1)] = (95));


break;
case "string":
var statearr_16669_16858 = state_16611__$1;
(statearr_16669_16858[(1)] = (99));


break;
case "instant":
var statearr_16670_16859 = state_16611__$1;
(statearr_16670_16859[(1)] = (103));


break;
default:
var statearr_16671_16860 = state_16611__$1;
(statearr_16671_16860[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (99))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16533 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16534 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16533,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,5,inst_16533,null));
var inst_16535 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16534,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16534,null));
var inst_16536 = (inst_16535.cljs$core$IFn$_invoke$arity$1 ? inst_16535.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16535.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16536)){
var statearr_16672_16861 = state_16611__$1;
(statearr_16672_16861[(1)] = (100));

} else {
var statearr_16673_16862 = state_16611__$1;
(statearr_16673_16862[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (21))){
var inst_16363 = (state_16611[(24)]);
var state_16611__$1 = state_16611;
var statearr_16674_16863 = state_16611__$1;
(statearr_16674_16863[(2)] = inst_16363);

(statearr_16674_16863[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (31))){
var inst_16379 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16675_16864 = state_16611__$1;
(statearr_16675_16864[(2)] = inst_16379);

(statearr_16675_16864[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (113))){
var inst_16585 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16676_16865 = state_16611__$1;
(statearr_16676_16865[(2)] = inst_16585);

(statearr_16676_16865[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (32))){
var state_16611__$1 = state_16611;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16677_16866 = state_16611__$1;
(statearr_16677_16866[(1)] = (35));

} else {
var statearr_16678_16867 = state_16611__$1;
(statearr_16678_16867[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (40))){
var inst_16415 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16415)){
var statearr_16679_16868 = state_16611__$1;
(statearr_16679_16868[(1)] = (44));

} else {
var statearr_16680_16869 = state_16611__$1;
(statearr_16680_16869[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (91))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16513 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16514 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16513,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,3,inst_16513,null));
var inst_16515 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16514,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16514,null));
var inst_16516 = (inst_16515.cljs$core$IFn$_invoke$arity$1 ? inst_16515.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16515.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16516)){
var statearr_16681_16870 = state_16611__$1;
(statearr_16681_16870[(1)] = (92));

} else {
var statearr_16682_16871 = state_16611__$1;
(statearr_16682_16871[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (117))){
var state_16611__$1 = state_16611;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16683_16872 = state_16611__$1;
(statearr_16683_16872[(1)] = (120));

} else {
var statearr_16684_16873 = state_16611__$1;
(statearr_16684_16873[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (108))){
var inst_16570 = (state_16611[(25)]);
var inst_16339 = (state_16611[(10)]);
var inst_16570__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16339);
var state_16611__$1 = (function (){var statearr_16685 = state_16611;
(statearr_16685[(25)] = inst_16570__$1);

return statearr_16685;
})();
if(cljs.core.truth_(inst_16570__$1)){
var statearr_16686_16874 = state_16611__$1;
(statearr_16686_16874[(1)] = (111));

} else {
var statearr_16687_16875 = state_16611__$1;
(statearr_16687_16875[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (56))){
var inst_16432 = (state_16611[(2)]);
var inst_16433 = fluree.db.util.async.throw_err(inst_16432);
var inst_16434 = cljs.core.not(inst_16433);
var state_16611__$1 = state_16611;
var statearr_16688_16876 = state_16611__$1;
(statearr_16688_16876[(2)] = inst_16434);

(statearr_16688_16876[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (33))){
var inst_16362 = (state_16611[(26)]);
var state_16611__$1 = state_16611;
var statearr_16689_16877 = state_16611__$1;
(statearr_16689_16877[(2)] = inst_16362);

(statearr_16689_16877[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (13))){
var inst_16357 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16357)){
var statearr_16690_16878 = state_16611__$1;
(statearr_16690_16878[(1)] = (17));

} else {
var statearr_16691_16879 = state_16611__$1;
(statearr_16691_16879[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (22))){
var inst_16388 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16388)){
var statearr_16692_16880 = state_16611__$1;
(statearr_16692_16880[(1)] = (32));

} else {
var statearr_16693_16881 = state_16611__$1;
(statearr_16693_16881[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (90))){
var inst_16511 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16694_16882 = state_16611__$1;
(statearr_16694_16882[(2)] = inst_16511);

(statearr_16694_16882[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (109))){
var inst_16568 = (state_16611[(27)]);
var state_16611__$1 = state_16611;
var statearr_16695_16883 = state_16611__$1;
(statearr_16695_16883[(2)] = inst_16568);

(statearr_16695_16883[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (36))){
var inst_16362 = (state_16611[(26)]);
var state_16611__$1 = state_16611;
var statearr_16696_16884 = state_16611__$1;
(statearr_16696_16884[(2)] = inst_16362);

(statearr_16696_16884[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (41))){
var inst_16339 = (state_16611[(10)]);
var inst_16407 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16408 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16407);
var inst_16409 = inst_16408 === true;
var state_16611__$1 = state_16611;
var statearr_16697_16885 = state_16611__$1;
(statearr_16697_16885[(2)] = inst_16409);

(statearr_16697_16885[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (118))){
var inst_16566 = (state_16611[(7)]);
var state_16611__$1 = state_16611;
var statearr_16698_16886 = state_16611__$1;
(statearr_16698_16886[(2)] = inst_16566);

(statearr_16698_16886[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (89))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16509 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16699_16887 = state_16611__$1;
(statearr_16699_16887[(2)] = inst_16509);

(statearr_16699_16887[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (100))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16700_16888 = state_16611__$1;
(statearr_16700_16888[(2)] = inst_16458);

(statearr_16700_16888[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (122))){
var inst_16598 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16701_16889 = state_16611__$1;
(statearr_16701_16889[(2)] = inst_16598);

(statearr_16701_16889[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (43))){
var inst_16412 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16702_16890 = state_16611__$1;
(statearr_16702_16890[(2)] = inst_16412);

(statearr_16702_16890[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (61))){
var inst_16420 = (state_16611[(14)]);
var state_16611__$1 = state_16611;
var statearr_16703_16891 = state_16611__$1;
(statearr_16703_16891[(2)] = inst_16420);

(statearr_16703_16891[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (29))){
var inst_16339 = (state_16611[(10)]);
var inst_16374 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16375 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16374);
var inst_16376 = inst_16375 === true;
var state_16611__$1 = state_16611;
var statearr_16704_16892 = state_16611__$1;
(statearr_16704_16892[(2)] = inst_16376);

(statearr_16704_16892[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (44))){
var inst_16401 = (state_16611[(28)]);
var inst_16417 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16401,"a component","a non-component",throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16705_16893 = state_16611__$1;
(statearr_16705_16893[(2)] = inst_16417);

(statearr_16705_16893[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (93))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16519 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16706_16894 = state_16611__$1;
(statearr_16706_16894[(2)] = inst_16519);

(statearr_16706_16894[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (6))){
var inst_16338 = (state_16611[(15)]);
var inst_16326 = (state_16611[(21)]);
var inst_16335 = cljs.core.seq(inst_16326);
var inst_16336 = cljs.core.first(inst_16335);
var inst_16337 = cljs.core.next(inst_16335);
var inst_16338__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16336,(0),null);
var inst_16339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16336,(1),null);
var inst_16340 = cljs.core.not(inst_16338__$1);
var state_16611__$1 = (function (){var statearr_16707 = state_16611;
(statearr_16707[(20)] = inst_16337);

(statearr_16707[(15)] = inst_16338__$1);

(statearr_16707[(10)] = inst_16339);

return statearr_16707;
})();
if(inst_16340){
var statearr_16708_16895 = state_16611__$1;
(statearr_16708_16895[(1)] = (8));

} else {
var statearr_16709_16896 = state_16611__$1;
(statearr_16709_16896[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (111))){
var inst_16339 = (state_16611[(10)]);
var inst_16574 = (state_16611[(29)]);
var inst_16572 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16573 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16572);
var inst_16574__$1 = inst_16573 === true;
var state_16611__$1 = (function (){var statearr_16710 = state_16611;
(statearr_16710[(29)] = inst_16574__$1);

return statearr_16710;
})();
if(cljs.core.truth_(inst_16574__$1)){
var statearr_16711_16897 = state_16611__$1;
(statearr_16711_16897[(1)] = (114));

} else {
var statearr_16712_16898 = state_16611__$1;
(statearr_16712_16898[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (28))){
var inst_16382 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16713_16899 = state_16611__$1;
(statearr_16713_16899[(2)] = inst_16382);

(statearr_16713_16899[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (64))){
var inst_16459 = (state_16611[(11)]);
var state_16611__$1 = state_16611;
var statearr_16714_16900 = state_16611__$1;
(statearr_16714_16900[(2)] = inst_16459);

(statearr_16714_16900[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (103))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16543 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16544 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16543,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,2,inst_16543,null));
var inst_16545 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16544,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16544,null));
var inst_16546 = (inst_16545.cljs$core$IFn$_invoke$arity$1 ? inst_16545.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16545.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16546)){
var statearr_16715_16901 = state_16611__$1;
(statearr_16715_16901[(1)] = (104));

} else {
var statearr_16716_16902 = state_16611__$1;
(statearr_16716_16902[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (51))){
var inst_16424 = (state_16611[(30)]);
var state_16611__$1 = state_16611;
var statearr_16717_16903 = state_16611__$1;
(statearr_16717_16903[(2)] = inst_16424);

(statearr_16717_16903[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (25))){
var inst_16385 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16718_16904 = state_16611__$1;
(statearr_16718_16904[(2)] = inst_16385);

(statearr_16718_16904[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (34))){
var inst_16402 = (state_16611[(18)]);
var inst_16339 = (state_16611[(10)]);
var inst_16401 = (state_16611[(2)]);
var inst_16402__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16339);
var state_16611__$1 = (function (){var statearr_16719 = state_16611;
(statearr_16719[(18)] = inst_16402__$1);

(statearr_16719[(28)] = inst_16401);

return statearr_16719;
})();
if(cljs.core.truth_(inst_16402__$1)){
var statearr_16720_16905 = state_16611__$1;
(statearr_16720_16905[(1)] = (38));

} else {
var statearr_16721_16906 = state_16611__$1;
(statearr_16721_16906[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (17))){
var inst_16327 = (state_16611[(16)]);
var inst_16359 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16327,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16722_16907 = state_16611__$1;
(statearr_16722_16907[(2)] = inst_16359);

(statearr_16722_16907[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (3))){
var inst_16609 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16611__$1,inst_16609);
} else {
if((state_val_16612 === (12))){
var inst_16343 = (state_16611[(31)]);
var state_16611__$1 = state_16611;
var statearr_16723_16908 = state_16611__$1;
(statearr_16723_16908[(2)] = inst_16343);

(statearr_16723_16908[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (2))){
var _ = (function (){var statearr_16724 = state_16611;
(statearr_16724[(4)] = cljs.core.cons((5),(state_16611[(4)])));

return statearr_16724;
})();
var inst_16319 = pred_changes;
var inst_16320 = cljs.core.seq(inst_16319);
var inst_16321 = cljs.core.first(inst_16320);
var inst_16322 = cljs.core.next(inst_16320);
var inst_16323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16321,(0),null);
var inst_16324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16321,(1),null);
var inst_16325 = db;
var inst_16326 = inst_16319;
var inst_16327 = inst_16325;
var state_16611__$1 = (function (){var statearr_16725 = state_16611;
(statearr_16725[(21)] = inst_16326);

(statearr_16725[(32)] = inst_16322);

(statearr_16725[(33)] = inst_16324);

(statearr_16725[(34)] = inst_16323);

(statearr_16725[(16)] = inst_16327);

return statearr_16725;
})();
var statearr_16726_16909 = state_16611__$1;
(statearr_16726_16909[(2)] = null);

(statearr_16726_16909[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (66))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16339 = (state_16611[(10)]);
var inst_16468 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16469 = cljs.core.__destructure_map(inst_16468);
var inst_16470__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16469,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16471__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16469,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16472 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16471__$1,inst_16470__$1);
var state_16611__$1 = (function (){var statearr_16727 = state_16611;
(statearr_16727[(8)] = inst_16471__$1);

(statearr_16727[(9)] = inst_16470__$1);

return statearr_16727;
})();
if(inst_16472){
var statearr_16728_16910 = state_16611__$1;
(statearr_16728_16910[(1)] = (69));

} else {
var statearr_16729_16911 = state_16611__$1;
(statearr_16729_16911[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (107))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16553 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16730_16912 = state_16611__$1;
(statearr_16730_16912[(2)] = inst_16553);

(statearr_16730_16912[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (23))){
var inst_16368 = (state_16611[(17)]);
var inst_16339 = (state_16611[(10)]);
var inst_16367 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16368__$1 = inst_16367 === true;
var state_16611__$1 = (function (){var statearr_16731 = state_16611;
(statearr_16731[(17)] = inst_16368__$1);

return statearr_16731;
})();
if(cljs.core.truth_(inst_16368__$1)){
var statearr_16732_16913 = state_16611__$1;
(statearr_16732_16913[(1)] = (26));

} else {
var statearr_16733_16914 = state_16611__$1;
(statearr_16733_16914[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (47))){
var inst_16424 = (state_16611[(30)]);
var inst_16339 = (state_16611[(10)]);
var inst_16423 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16424__$1 = cljs.core.not(inst_16423);
var state_16611__$1 = (function (){var statearr_16734 = state_16611;
(statearr_16734[(30)] = inst_16424__$1);

return statearr_16734;
})();
if(inst_16424__$1){
var statearr_16735_16915 = state_16611__$1;
(statearr_16735_16915[(1)] = (50));

} else {
var statearr_16736_16916 = state_16611__$1;
(statearr_16736_16916[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (35))){
var inst_16391 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16392 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16393 = cljs.core.PersistentHashMap.fromArrays(inst_16391,inst_16392);
var inst_16394 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16393);
var inst_16395 = (function(){throw inst_16394})();
var state_16611__$1 = state_16611;
var statearr_16737_16917 = state_16611__$1;
(statearr_16737_16917[(2)] = inst_16395);

(statearr_16737_16917[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (82))){
var inst_16491 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16738_16918 = state_16611__$1;
(statearr_16738_16918[(2)] = inst_16491);

(statearr_16738_16918[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (76))){
var state_16611__$1 = state_16611;
var statearr_16739_16919 = state_16611__$1;
(statearr_16739_16919[(2)] = null);

(statearr_16739_16919[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (97))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16529 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16740_16920 = state_16611__$1;
(statearr_16740_16920[(2)] = inst_16529);

(statearr_16740_16920[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (19))){
var inst_16339 = (state_16611[(10)]);
var inst_16363 = (state_16611[(24)]);
var inst_16362 = (state_16611[(2)]);
var inst_16363__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16339);
var state_16611__$1 = (function (){var statearr_16741 = state_16611;
(statearr_16741[(26)] = inst_16362);

(statearr_16741[(24)] = inst_16363__$1);

return statearr_16741;
})();
if(cljs.core.truth_(inst_16363__$1)){
var statearr_16742_16921 = state_16611__$1;
(statearr_16742_16921[(1)] = (20));

} else {
var statearr_16743_16922 = state_16611__$1;
(statearr_16743_16922[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (57))){
var state_16611__$1 = state_16611;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16744_16923 = state_16611__$1;
(statearr_16744_16923[(1)] = (60));

} else {
var statearr_16745_16924 = state_16611__$1;
(statearr_16745_16924[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (68))){
var inst_16568 = (state_16611[(27)]);
var inst_16339 = (state_16611[(10)]);
var inst_16566 = (state_16611[(2)]);
var inst_16567 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16568__$1 = inst_16567 === true;
var state_16611__$1 = (function (){var statearr_16746 = state_16611;
(statearr_16746[(7)] = inst_16566);

(statearr_16746[(27)] = inst_16568__$1);

return statearr_16746;
})();
if(cljs.core.truth_(inst_16568__$1)){
var statearr_16747_16925 = state_16611__$1;
(statearr_16747_16925[(1)] = (108));

} else {
var statearr_16748_16926 = state_16611__$1;
(statearr_16748_16926[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (11))){
var inst_16347 = (state_16611[(23)]);
var inst_16339 = (state_16611[(10)]);
var inst_16345 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16346 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16345);
var inst_16347__$1 = inst_16346 === false;
var state_16611__$1 = (function (){var statearr_16749 = state_16611;
(statearr_16749[(23)] = inst_16347__$1);

return statearr_16749;
})();
if(cljs.core.truth_(inst_16347__$1)){
var statearr_16750_16927 = state_16611__$1;
(statearr_16750_16927[(1)] = (14));

} else {
var statearr_16751_16928 = state_16611__$1;
(statearr_16751_16928[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (115))){
var inst_16574 = (state_16611[(29)]);
var state_16611__$1 = state_16611;
var statearr_16753_16929 = state_16611__$1;
(statearr_16753_16929[(2)] = inst_16574);

(statearr_16753_16929[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (9))){
var inst_16343 = (state_16611[(31)]);
var inst_16339 = (state_16611[(10)]);
var inst_16343__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16339);
var state_16611__$1 = (function (){var statearr_16754 = state_16611;
(statearr_16754[(31)] = inst_16343__$1);

return statearr_16754;
})();
if(cljs.core.truth_(inst_16343__$1)){
var statearr_16755_16930 = state_16611__$1;
(statearr_16755_16930[(1)] = (11));

} else {
var statearr_16756_16931 = state_16611__$1;
(statearr_16756_16931[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (5))){
var _ = (function (){var statearr_16757 = state_16611;
(statearr_16757[(4)] = cljs.core.rest((state_16611[(4)])));

return statearr_16757;
})();
var state_16611__$1 = state_16611;
var ex16752 = (state_16611__$1[(2)]);
var statearr_16758_16932 = state_16611__$1;
(statearr_16758_16932[(5)] = ex16752);


if((ex16752 instanceof Error)){
var statearr_16759_16933 = state_16611__$1;
(statearr_16759_16933[(1)] = (4));

(statearr_16759_16933[(5)] = null);

} else {
throw ex16752;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (112))){
var inst_16570 = (state_16611[(25)]);
var state_16611__$1 = state_16611;
var statearr_16760_16934 = state_16611__$1;
(statearr_16760_16934[(2)] = inst_16570);

(statearr_16760_16934[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (83))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16493 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16494 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16493,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,3,inst_16493,null));
var inst_16495 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16494,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16494,null));
var inst_16496 = (inst_16495.cljs$core$IFn$_invoke$arity$1 ? inst_16495.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16495.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16496)){
var statearr_16761_16935 = state_16611__$1;
(statearr_16761_16935[(1)] = (84));

} else {
var statearr_16762_16936 = state_16611__$1;
(statearr_16762_16936[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (14))){
var inst_16339 = (state_16611[(10)]);
var inst_16349 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16350 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16349);
var inst_16351 = inst_16350 === true;
var state_16611__$1 = state_16611;
var statearr_16763_16937 = state_16611__$1;
(statearr_16763_16937[(2)] = inst_16351);

(statearr_16763_16937[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (45))){
var inst_16401 = (state_16611[(28)]);
var state_16611__$1 = state_16611;
var statearr_16764_16938 = state_16611__$1;
(statearr_16764_16938[(2)] = inst_16401);

(statearr_16764_16938[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (53))){
var inst_16338 = (state_16611[(15)]);
var inst_16327 = (state_16611[(16)]);
var inst_16430 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16327,inst_16338);
var state_16611__$1 = state_16611;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16611__$1,(56),inst_16430);
} else {
if((state_val_16612 === (78))){
var inst_16556 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16765_16939 = state_16611__$1;
(statearr_16765_16939[(2)] = inst_16556);

(statearr_16765_16939[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (26))){
var inst_16372 = (state_16611[(35)]);
var inst_16339 = (state_16611[(10)]);
var inst_16370 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16371 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16370);
var inst_16372__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16371);
var state_16611__$1 = (function (){var statearr_16766 = state_16611;
(statearr_16766[(35)] = inst_16372__$1);

return statearr_16766;
})();
if(inst_16372__$1){
var statearr_16767_16940 = state_16611__$1;
(statearr_16767_16940[(1)] = (29));

} else {
var statearr_16768_16941 = state_16611__$1;
(statearr_16768_16941[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (16))){
var inst_16354 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16769_16942 = state_16611__$1;
(statearr_16769_16942[(2)] = inst_16354);

(statearr_16769_16942[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (81))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16489 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16770_16943 = state_16611__$1;
(statearr_16770_16943[(2)] = inst_16489);

(statearr_16770_16943[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (120))){
var inst_16591 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16592 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16593 = cljs.core.PersistentHashMap.fromArrays(inst_16591,inst_16592);
var inst_16594 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_16593);
var inst_16595 = (function(){throw inst_16594})();
var state_16611__$1 = state_16611;
var statearr_16771_16944 = state_16611__$1;
(statearr_16771_16944[(2)] = inst_16595);

(statearr_16771_16944[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (79))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16483 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16484 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16483,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,2,inst_16483,null));
var inst_16485 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16484,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16484,null));
var inst_16486 = (inst_16485.cljs$core$IFn$_invoke$arity$1 ? inst_16485.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16485.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16486)){
var statearr_16772_16945 = state_16611__$1;
(statearr_16772_16945[(1)] = (80));

} else {
var statearr_16773_16946 = state_16611__$1;
(statearr_16773_16946[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (38))){
var inst_16339 = (state_16611[(10)]);
var inst_16405 = (state_16611[(36)]);
var inst_16404 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16405__$1 = cljs.core.not(inst_16404);
var state_16611__$1 = (function (){var statearr_16774 = state_16611;
(statearr_16774[(36)] = inst_16405__$1);

return statearr_16774;
})();
if(inst_16405__$1){
var statearr_16775_16947 = state_16611__$1;
(statearr_16775_16947[(1)] = (41));

} else {
var statearr_16776_16948 = state_16611__$1;
(statearr_16776_16948[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (98))){
var inst_16531 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16777_16949 = state_16611__$1;
(statearr_16777_16949[(2)] = inst_16531);

(statearr_16777_16949[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (87))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16503 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16504 = (inst_16471.cljs$core$IFn$_invoke$arity$5 ? inst_16471.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16503,null) : inst_16471.call(null,cljs.core.PersistentArrayMap,null,3,inst_16503,null));
var inst_16505 = (inst_16471.cljs$core$IFn$_invoke$arity$4 ? inst_16471.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16504,null) : inst_16471.call(null,cljs.core.PersistentHashSet,null,inst_16504,null));
var inst_16506 = (inst_16505.cljs$core$IFn$_invoke$arity$1 ? inst_16505.cljs$core$IFn$_invoke$arity$1(inst_16470) : inst_16505.call(null,inst_16470));
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16506)){
var statearr_16778_16950 = state_16611__$1;
(statearr_16778_16950[(1)] = (88));

} else {
var statearr_16779_16951 = state_16611__$1;
(statearr_16779_16951[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (30))){
var inst_16372 = (state_16611[(35)]);
var state_16611__$1 = state_16611;
var statearr_16780_16952 = state_16611__$1;
(statearr_16780_16952[(2)] = inst_16372);

(statearr_16780_16952[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (73))){
var state_16611__$1 = state_16611;
var statearr_16781_16953 = state_16611__$1;
(statearr_16781_16953[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (96))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16783_16954 = state_16611__$1;
(statearr_16783_16954[(2)] = inst_16458);

(statearr_16783_16954[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (10))){
var inst_16604 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16784_16955 = state_16611__$1;
(statearr_16784_16955[(2)] = inst_16604);

(statearr_16784_16955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (18))){
var inst_16327 = (state_16611[(16)]);
var state_16611__$1 = state_16611;
var statearr_16785_16956 = state_16611__$1;
(statearr_16785_16956[(2)] = inst_16327);

(statearr_16785_16956[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (105))){
var inst_16471 = (state_16611[(8)]);
var inst_16470 = (state_16611[(9)]);
var inst_16549 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16470,inst_16471,throw_QMARK_);
var state_16611__$1 = state_16611;
var statearr_16786_16957 = state_16611__$1;
(statearr_16786_16957[(2)] = inst_16549);

(statearr_16786_16957[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (52))){
var inst_16440 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16787_16958 = state_16611__$1;
(statearr_16787_16958[(2)] = inst_16440);

(statearr_16787_16958[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (114))){
var inst_16339 = (state_16611[(10)]);
var inst_16576 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16577 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16576);
var inst_16578 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16577);
var inst_16579 = (!(inst_16578));
var state_16611__$1 = state_16611;
var statearr_16788_16959 = state_16611__$1;
(statearr_16788_16959[(2)] = inst_16579);

(statearr_16788_16959[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (67))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16789_16960 = state_16611__$1;
(statearr_16789_16960[(2)] = inst_16458);

(statearr_16789_16960[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (71))){
var inst_16563 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16790_16961 = state_16611__$1;
(statearr_16790_16961[(2)] = inst_16563);

(statearr_16790_16961[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (42))){
var inst_16405 = (state_16611[(36)]);
var state_16611__$1 = state_16611;
var statearr_16791_16962 = state_16611__$1;
(statearr_16791_16962[(2)] = inst_16405);

(statearr_16791_16962[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (80))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16792_16963 = state_16611__$1;
(statearr_16792_16963[(2)] = inst_16458);

(statearr_16792_16963[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (37))){
var inst_16398 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16793_16964 = state_16611__$1;
(statearr_16793_16964[(2)] = inst_16398);

(statearr_16793_16964[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (63))){
var inst_16339 = (state_16611[(10)]);
var inst_16461 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16339);
var inst_16462 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16461);
var state_16611__$1 = state_16611;
var statearr_16794_16965 = state_16611__$1;
(statearr_16794_16965[(2)] = inst_16462);

(statearr_16794_16965[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (94))){
var inst_16521 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
var statearr_16795_16966 = state_16611__$1;
(statearr_16795_16966[(2)] = inst_16521);

(statearr_16795_16966[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (8))){
var inst_16327 = (state_16611[(16)]);
var state_16611__$1 = state_16611;
var statearr_16796_16967 = state_16611__$1;
(statearr_16796_16967[(2)] = inst_16327);

(statearr_16796_16967[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (49))){
var inst_16443 = (state_16611[(2)]);
var state_16611__$1 = state_16611;
if(cljs.core.truth_(inst_16443)){
var statearr_16797_16968 = state_16611__$1;
(statearr_16797_16968[(1)] = (57));

} else {
var statearr_16798_16969 = state_16611__$1;
(statearr_16798_16969[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16612 === (84))){
var inst_16458 = (state_16611[(12)]);
var state_16611__$1 = state_16611;
var statearr_16799_16970 = state_16611__$1;
(statearr_16799_16970[(2)] = inst_16458);

(statearr_16799_16970[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16800 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16800[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16800[(1)] = (1));

return statearr_16800;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16611){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16611);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16801){var ex__2730__auto__ = e16801;
var statearr_16802_16971 = state_16611;
(statearr_16802_16971[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16611[(4)]))){
var statearr_16803_16972 = state_16611;
(statearr_16803_16972[(1)] = cljs.core.first((state_16611[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16973 = state_16611;
state_16611 = G__16973;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16611){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16804 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_16804[(6)] = c__2749__auto__);

return statearr_16804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16975 = arguments.length;
switch (G__16975) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16999){
var state_val_17000 = (state_16999[(1)]);
if((state_val_17000 === (7))){
var state_16999__$1 = state_16999;
var statearr_17001_17021 = state_16999__$1;
(statearr_17001_17021[(2)] = db);

(statearr_17001_17021[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17000 === (1))){
var state_16999__$1 = state_16999;
var statearr_17002_17022 = state_16999__$1;
(statearr_17002_17022[(2)] = null);

(statearr_17002_17022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17000 === (4))){
var inst_16976 = (state_16999[(2)]);
var state_16999__$1 = state_16999;
var statearr_17003_17023 = state_16999__$1;
(statearr_17003_17023[(2)] = inst_16976);

(statearr_17003_17023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17000 === (6))){
var inst_16985 = (state_16999[(7)]);
var inst_16984 = (state_16999[(2)]);
var inst_16985__$1 = fluree.db.util.async.throw_err(inst_16984);
var inst_16986 = cljs.core.empty_QMARK_(inst_16985__$1);
var state_16999__$1 = (function (){var statearr_17004 = state_16999;
(statearr_17004[(7)] = inst_16985__$1);

return statearr_17004;
})();
if(inst_16986){
var statearr_17005_17024 = state_16999__$1;
(statearr_17005_17024[(1)] = (7));

} else {
var statearr_17006_17025 = state_16999__$1;
(statearr_17006_17025[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17000 === (3))){
var inst_16997 = (state_16999[(2)]);
var state_16999__$1 = state_16999;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16999__$1,inst_16997);
} else {
if((state_val_17000 === (2))){
var _ = (function (){var statearr_17008 = state_16999;
(statearr_17008[(4)] = cljs.core.cons((5),(state_16999[(4)])));

return statearr_17008;
})();
var inst_16982 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16999__$1 = state_16999;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16999__$1,(6),inst_16982);
} else {
if((state_val_17000 === (9))){
var inst_16994 = (state_16999[(2)]);
var _ = (function (){var statearr_17009 = state_16999;
(statearr_17009[(4)] = cljs.core.rest((state_16999[(4)])));

return statearr_17009;
})();
var state_16999__$1 = state_16999;
var statearr_17010_17026 = state_16999__$1;
(statearr_17010_17026[(2)] = inst_16994);

(statearr_17010_17026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17000 === (5))){
var _ = (function (){var statearr_17011 = state_16999;
(statearr_17011[(4)] = cljs.core.rest((state_16999[(4)])));

return statearr_17011;
})();
var state_16999__$1 = state_16999;
var ex17007 = (state_16999__$1[(2)]);
var statearr_17012_17027 = state_16999__$1;
(statearr_17012_17027[(5)] = ex17007);


if((ex17007 instanceof Error)){
var statearr_17013_17028 = state_16999__$1;
(statearr_17013_17028[(1)] = (4));

(statearr_17013_17028[(5)] = null);

} else {
throw ex17007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17000 === (10))){
var inst_16991 = (state_16999[(2)]);
var inst_16992 = fluree.db.util.async.throw_err(inst_16991);
var state_16999__$1 = state_16999;
var statearr_17014_17029 = state_16999__$1;
(statearr_17014_17029[(2)] = inst_16992);

(statearr_17014_17029[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17000 === (8))){
var inst_16985 = (state_16999[(7)]);
var inst_16989 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16985,db,true);
var state_16999__$1 = state_16999;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16999__$1,(10),inst_16989);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_17015 = [null,null,null,null,null,null,null,null];
(statearr_17015[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_17015[(1)] = (1));

return statearr_17015;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16999){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_16999);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17016){var ex__2730__auto__ = e17016;
var statearr_17017_17030 = state_16999;
(statearr_17017_17030[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_16999[(4)]))){
var statearr_17018_17031 = state_16999;
(statearr_17018_17031[(1)] = cljs.core.first((state_16999[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17032 = state_16999;
state_16999 = G__17032;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16999){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17019 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17019[(6)] = c__2749__auto__);

return statearr_17019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__17034 = arguments.length;
switch (G__17034) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__17036 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17036,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17036,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17036,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = fluree.db.flake.p(flake);
var o = fluree.db.flake.o(flake);
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__17039_SHARP_,p2__17040_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17039_SHARP_,p2__17040_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__17041_SHARP_){
var f = p1__17041_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,fluree.db.flake.p(f))){
return fluree.db.flake.o(f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17107){
var state_val_17108 = (state_17107[(1)]);
if((state_val_17108 === (1))){
var state_17107__$1 = state_17107;
var statearr_17109_17127 = state_17107__$1;
(statearr_17109_17127[(2)] = null);

(statearr_17109_17127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17108 === (2))){
var _ = (function (){var statearr_17110 = state_17107;
(statearr_17110[(4)] = cljs.core.cons((5),(state_17107[(4)])));

return statearr_17110;
})();
var inst_17059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17060 = fluree.db.flake.max_subject_id((1));
var inst_17061 = [inst_17060];
var inst_17062 = (new cljs.core.PersistentVector(null,1,(5),inst_17059,inst_17061,null));
var inst_17063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17064 = [(0)];
var inst_17065 = (new cljs.core.PersistentVector(null,1,(5),inst_17063,inst_17064,null));
var inst_17066 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17062,cljs.core._LT__EQ_,inst_17065);
var state_17107__$1 = state_17107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17107__$1,(6),inst_17066);
} else {
if((state_val_17108 === (3))){
var inst_17105 = (state_17107[(2)]);
var state_17107__$1 = state_17107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17107__$1,inst_17105);
} else {
if((state_val_17108 === (4))){
var inst_17047 = (state_17107[(2)]);
var state_17107__$1 = state_17107;
var statearr_17112_17128 = state_17107__$1;
(statearr_17112_17128[(2)] = inst_17047);

(statearr_17112_17128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17108 === (5))){
var _ = (function (){var statearr_17113 = state_17107;
(statearr_17113[(4)] = cljs.core.rest((state_17107[(4)])));

return statearr_17113;
})();
var state_17107__$1 = state_17107;
var ex17111 = (state_17107__$1[(2)]);
var statearr_17114_17129 = state_17107__$1;
(statearr_17114_17129[(5)] = ex17111);


if((ex17111 instanceof Error)){
var statearr_17115_17130 = state_17107__$1;
(statearr_17115_17130[(1)] = (4));

(statearr_17115_17130[(5)] = null);

} else {
throw ex17111;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17108 === (6))){
var inst_17068 = (state_17107[(2)]);
var inst_17069 = fluree.db.util.async.throw_err(inst_17068);
var inst_17070 = (function (){var schema_flakes = inst_17069;
return (function (p1__17042_SHARP_){
return (fluree.db.flake.s(p1__17042_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17071 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17070,inst_17069);
var inst_17072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17071,(0),null);
var inst_17073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17071,(1),null);
var inst_17074 = (function (){var schema_flakes = inst_17069;
var vec__17053 = inst_17071;
var collection_flakes = inst_17072;
var predicate_flakes = inst_17073;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = fluree.db.flake.s(first_flake);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17045_SHARP_,p2__17044_SHARP_){
var f = p2__17044_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17045_SHARP_,fluree.db.flake.p(f),fluree.db.flake.o(f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_17075 = [(-1),"_tx"];
var inst_17076 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17077 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17078 = cljs.core.PersistentHashMap.fromArrays(inst_17076,inst_17077);
var inst_17079 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17080 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17081 = cljs.core.PersistentHashMap.fromArrays(inst_17079,inst_17080);
var inst_17082 = [inst_17078,inst_17081];
var inst_17083 = cljs.core.PersistentHashMap.fromArrays(inst_17075,inst_17082);
var inst_17084 = (function (){var schema_flakes = inst_17069;
var vec__17053 = inst_17071;
var collection_flakes = inst_17072;
var predicate_flakes = inst_17073;
return (function (p1__17043_SHARP_){
return fluree.db.flake.s(p1__17043_SHARP_);
});
})();
var inst_17085 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17084,inst_17072);
var inst_17086 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17074,inst_17083,inst_17085);
var inst_17088 = (function (){var schema_flakes = inst_17069;
var vec__17053 = inst_17071;
var collection_flakes = inst_17072;
var predicate_flakes = inst_17073;
var coll = inst_17086;
return (function (p__17087,pred_flakes){
var vec__17116 = p__17087;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17116,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17116,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = fluree.db.flake.s(first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__17119 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__17119.cljs$core$IFn$_invoke$arity$1 ? fexpr__17119.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__17119.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_17089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17090 = cljs.core.PersistentHashMap.EMPTY;
var inst_17091 = cljs.core.PersistentHashSet.EMPTY;
var inst_17092 = [inst_17090,inst_17091];
var inst_17093 = (new cljs.core.PersistentVector(null,2,(5),inst_17089,inst_17092,null));
var inst_17094 = (function (){var schema_flakes = inst_17069;
var vec__17053 = inst_17071;
var collection_flakes = inst_17072;
var predicate_flakes = inst_17073;
var coll = inst_17086;
return (function (p1__17046_SHARP_){
return fluree.db.flake.s(p1__17046_SHARP_);
});
})();
var inst_17095 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17094,inst_17073);
var inst_17096 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17088,inst_17093,inst_17095);
var inst_17097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17096,(0),null);
var inst_17098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17096,(1),null);
var inst_17099 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17100 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17101 = [inst_17100,inst_17086,inst_17097,inst_17098];
var inst_17102 = cljs.core.PersistentHashMap.fromArrays(inst_17099,inst_17101);
var _ = (function (){var statearr_17120 = state_17107;
(statearr_17120[(4)] = cljs.core.rest((state_17107[(4)])));

return statearr_17120;
})();
var state_17107__$1 = state_17107;
var statearr_17121_17131 = state_17107__$1;
(statearr_17121_17131[(2)] = inst_17102);

(statearr_17121_17131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0 = (function (){
var statearr_17122 = [null,null,null,null,null,null,null];
(statearr_17122[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2727__auto__);

(statearr_17122[(1)] = (1));

return statearr_17122;
});
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1 = (function (state_17107){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17107);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17123){var ex__2730__auto__ = e17123;
var statearr_17124_17132 = state_17107;
(statearr_17124_17132[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17107[(4)]))){
var statearr_17125_17133 = state_17107;
(statearr_17125_17133[(1)] = cljs.core.first((state_17107[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17134 = state_17107;
state_17107 = G__17134;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = function(state_17107){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1.call(this,state_17107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17126 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17126[(6)] = c__2749__auto__);

return statearr_17126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17176){
var state_val_17177 = (state_17176[(1)]);
if((state_val_17177 === (7))){
var inst_17159 = (state_17176[(2)]);
var inst_17160 = fluree.db.query.schema.flake__GT_pred_map(inst_17159);
var inst_17161 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17160,(114));
var inst_17163 = cljs.core.boolean$(inst_17162);
var inst_17164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17160,(110));
var inst_17165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17160,(117));
var inst_17166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_17165);
var inst_17167 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17160,(111));
var inst_17168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17160,(115));
var inst_17169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17160,(112));
var inst_17170 = [inst_17163,inst_17164,inst_17166,inst_17167,inst_17168,inst_17169];
var inst_17171 = cljs.core.PersistentHashMap.fromArrays(inst_17161,inst_17170);
var _ = (function (){var statearr_17178 = state_17176;
(statearr_17178[(4)] = cljs.core.rest((state_17176[(4)])));

return statearr_17178;
})();
var state_17176__$1 = state_17176;
var statearr_17179_17202 = state_17176__$1;
(statearr_17179_17202[(2)] = inst_17171);

(statearr_17179_17202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (1))){
var state_17176__$1 = state_17176;
var statearr_17180_17203 = state_17176__$1;
(statearr_17180_17203[(2)] = null);

(statearr_17180_17203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (4))){
var inst_17135 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
var statearr_17181_17204 = state_17176__$1;
(statearr_17181_17204[(2)] = inst_17135);

(statearr_17181_17204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (6))){
var _ = (function (){var statearr_17182 = state_17176;
(statearr_17182[(4)] = cljs.core.cons((9),(state_17176[(4)])));

return statearr_17182;
})();
var inst_17147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17149 = ["_setting/id","root"];
var inst_17150 = (new cljs.core.PersistentVector(null,2,(5),inst_17148,inst_17149,null));
var inst_17151 = [inst_17150];
var inst_17152 = (new cljs.core.PersistentVector(null,1,(5),inst_17147,inst_17151,null));
var inst_17153 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17152);
var state_17176__$1 = state_17176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17176__$1,(10),inst_17153);
} else {
if((state_val_17177 === (3))){
var inst_17174 = (state_17176[(2)]);
var state_17176__$1 = state_17176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17176__$1,inst_17174);
} else {
if((state_val_17177 === (2))){
var _ = (function (){var statearr_17185 = state_17176;
(statearr_17185[(4)] = cljs.core.cons((5),(state_17176[(4)])));

return statearr_17185;
})();
var state_17176__$1 = state_17176;
var statearr_17186_17205 = state_17176__$1;
(statearr_17186_17205[(2)] = null);

(statearr_17186_17205[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (9))){
var _ = (function (){var statearr_17187 = state_17176;
(statearr_17187[(4)] = cljs.core.rest((state_17176[(4)])));

return statearr_17187;
})();
var state_17176__$1 = state_17176;
var ex17183 = (state_17176__$1[(2)]);
var statearr_17188_17206 = state_17176__$1;
(statearr_17188_17206[(5)] = ex17183);


var statearr_17189_17207 = state_17176__$1;
(statearr_17189_17207[(1)] = (8));

(statearr_17189_17207[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (5))){
var _ = (function (){var statearr_17190 = state_17176;
(statearr_17190[(4)] = cljs.core.rest((state_17176[(4)])));

return statearr_17190;
})();
var state_17176__$1 = state_17176;
var ex17184 = (state_17176__$1[(2)]);
var statearr_17191_17208 = state_17176__$1;
(statearr_17191_17208[(5)] = ex17184);


if((ex17184 instanceof Error)){
var statearr_17192_17209 = state_17176__$1;
(statearr_17192_17209[(1)] = (4));

(statearr_17192_17209[(5)] = null);

} else {
throw ex17184;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (10))){
var inst_17155 = (state_17176[(2)]);
var inst_17156 = fluree.db.util.async.throw_err(inst_17155);
var _ = (function (){var statearr_17193 = state_17176;
(statearr_17193[(4)] = cljs.core.rest((state_17176[(4)])));

return statearr_17193;
})();
var state_17176__$1 = state_17176;
var statearr_17194_17210 = state_17176__$1;
(statearr_17194_17210[(2)] = inst_17156);

(statearr_17194_17210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17177 === (8))){
var inst_17141 = (state_17176[(2)]);
var state_17176__$1 = (function (){var statearr_17195 = state_17176;
(statearr_17195[(7)] = inst_17141);

return statearr_17195;
})();
var statearr_17196_17211 = state_17176__$1;
(statearr_17196_17211[(2)] = null);

(statearr_17196_17211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0 = (function (){
var statearr_17197 = [null,null,null,null,null,null,null,null];
(statearr_17197[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2727__auto__);

(statearr_17197[(1)] = (1));

return statearr_17197;
});
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1 = (function (state_17176){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17176);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17198){var ex__2730__auto__ = e17198;
var statearr_17199_17212 = state_17176;
(statearr_17199_17212[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17176[(4)]))){
var statearr_17200_17213 = state_17176;
(statearr_17200_17213[(1)] = cljs.core.first((state_17176[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17214 = state_17176;
state_17176 = G__17214;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = function(state_17176){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1.call(this,state_17176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17201 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17201[(6)] = c__2749__auto__);

return statearr_17201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
