// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__76410 = opts_SINGLEQUOTE_;
var map__76410__$1 = cljs.core.__destructure_map(map__76410);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76410__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__76412 = arguments.length;
switch (G__76412) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__76415 = arguments.length;
switch (G__76415) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__76418 = arguments.length;
switch (G__76418) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__76421 = arguments.length;
switch (G__76421) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__76424 = arguments.length;
switch (G__76424) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__76427 = arguments.length;
switch (G__76427) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___76436 = arguments.length;
var i__5770__auto___76437 = (0);
while(true){
if((i__5770__auto___76437 < len__5769__auto___76436)){
args__5775__auto__.push((arguments[i__5770__auto___76437]));

var G__76438 = (i__5770__auto___76437 + (1));
i__5770__auto___76437 = G__76438;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__76432){
var vec__76433 = p__76432;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76433,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq76429){
var G__76430 = cljs.core.first(seq76429);
var seq76429__$1 = cljs.core.next(seq76429);
var G__76431 = cljs.core.first(seq76429__$1);
var seq76429__$2 = cljs.core.next(seq76429__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__76430,G__76431,seq76429__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76460){
var state_val_76461 = (state_76460[(1)]);
if((state_val_76461 === (1))){
var state_76460__$1 = state_76460;
var statearr_76462_76477 = state_76460__$1;
(statearr_76462_76477[(2)] = null);

(statearr_76462_76477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76461 === (2))){
var _ = (function (){var statearr_76463 = state_76460;
(statearr_76463[(4)] = cljs.core.cons((5),(state_76460[(4)])));

return statearr_76463;
})();
var state_76460__$1 = state_76460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76460__$1,(6),db);
} else {
if((state_val_76461 === (3))){
var inst_76458 = (state_76460[(2)]);
var state_76460__$1 = state_76460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76460__$1,inst_76458);
} else {
if((state_val_76461 === (4))){
var inst_76439 = (state_76460[(2)]);
var inst_76440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76441 = [inst_76439];
var inst_76442 = (new cljs.core.PersistentVector(null,1,(5),inst_76440,inst_76441,null));
var inst_76443 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76442);
var inst_76444 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76439) : reject.call(null,inst_76439));
var state_76460__$1 = (function (){var statearr_76465 = state_76460;
(statearr_76465[(7)] = inst_76443);

return statearr_76465;
})();
var statearr_76466_76478 = state_76460__$1;
(statearr_76466_76478[(2)] = inst_76444);

(statearr_76466_76478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76461 === (5))){
var _ = (function (){var statearr_76467 = state_76460;
(statearr_76467[(4)] = cljs.core.rest((state_76460[(4)])));

return statearr_76467;
})();
var state_76460__$1 = state_76460;
var ex76464 = (state_76460__$1[(2)]);
var statearr_76468_76479 = state_76460__$1;
(statearr_76468_76479[(5)] = ex76464);


var statearr_76469_76480 = state_76460__$1;
(statearr_76469_76480[(1)] = (4));

(statearr_76469_76480[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76461 === (6))){
var inst_76451 = (state_76460[(2)]);
var inst_76452 = fluree.db.util.async.throw_err(inst_76451);
var inst_76453 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_76452);
var inst_76454 = cljs.core.clj__GT_js(inst_76453);
var inst_76455 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76454) : resolve.call(null,inst_76454));
var _ = (function (){var statearr_76470 = state_76460;
(statearr_76470[(4)] = cljs.core.rest((state_76460[(4)])));

return statearr_76470;
})();
var state_76460__$1 = state_76460;
var statearr_76471_76481 = state_76460__$1;
(statearr_76471_76481[(2)] = inst_76455);

(statearr_76471_76481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2727__auto__ = null;
var flureedb$db_schema_$_state_machine__2727__auto____0 = (function (){
var statearr_76472 = [null,null,null,null,null,null,null,null];
(statearr_76472[(0)] = flureedb$db_schema_$_state_machine__2727__auto__);

(statearr_76472[(1)] = (1));

return statearr_76472;
});
var flureedb$db_schema_$_state_machine__2727__auto____1 = (function (state_76460){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76460);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76473){var ex__2730__auto__ = e76473;
var statearr_76474_76482 = state_76460;
(statearr_76474_76482[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76460[(4)]))){
var statearr_76475_76483 = state_76460;
(statearr_76475_76483[(1)] = cljs.core.first((state_76460[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76484 = state_76460;
state_76460 = G__76484;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2727__auto__ = function(state_76460){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2727__auto____1.call(this,state_76460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2727__auto____0;
flureedb$db_schema_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2727__auto____1;
return flureedb$db_schema_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76476 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76476[(6)] = c__2749__auto__);

return statearr_76476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__76486 = arguments.length;
switch (G__76486) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76559){
var state_val_76560 = (state_76559[(1)]);
if((state_val_76560 === (7))){
var inst_76502 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76559__$1 = state_76559;
var statearr_76561_76606 = state_76559__$1;
(statearr_76561_76606[(2)] = inst_76502);

(statearr_76561_76606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (20))){
var inst_76510 = (state_76559[(7)]);
var inst_76534 = (state_76559[(2)]);
var state_76559__$1 = (function (){var statearr_76562 = state_76559;
(statearr_76562[(8)] = inst_76534);

return statearr_76562;
})();
if(cljs.core.truth_(inst_76510)){
var statearr_76563_76607 = state_76559__$1;
(statearr_76563_76607[(1)] = (21));

} else {
var statearr_76564_76608 = state_76559__$1;
(statearr_76564_76608[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (1))){
var state_76559__$1 = state_76559;
var statearr_76565_76609 = state_76559__$1;
(statearr_76565_76609[(2)] = null);

(statearr_76565_76609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (24))){
var inst_76541 = (state_76559[(2)]);
var inst_76542 = fluree.db.util.async.throw_err(inst_76541);
var state_76559__$1 = state_76559;
var statearr_76566_76610 = state_76559__$1;
(statearr_76566_76610[(2)] = inst_76542);

(statearr_76566_76610[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (4))){
var inst_76487 = (state_76559[(2)]);
var inst_76488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76489 = [inst_76487];
var inst_76490 = (new cljs.core.PersistentVector(null,1,(5),inst_76488,inst_76489,null));
var inst_76491 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76490);
var inst_76492 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76487) : reject.call(null,inst_76487));
var state_76559__$1 = (function (){var statearr_76567 = state_76559;
(statearr_76567[(9)] = inst_76491);

return statearr_76567;
})();
var statearr_76568_76611 = state_76559__$1;
(statearr_76568_76611[(2)] = inst_76492);

(statearr_76568_76611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (15))){
var inst_76523 = (state_76559[(10)]);
var inst_76525 = fluree.db.util.core.without_nils(inst_76523);
var inst_76526 = fluree.db.util.json.stringify(inst_76525);
var state_76559__$1 = state_76559;
var statearr_76569_76612 = state_76559__$1;
(statearr_76569_76612[(2)] = inst_76526);

(statearr_76569_76612[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (21))){
var inst_76529 = (state_76559[(11)]);
var inst_76534 = (state_76559[(8)]);
var inst_76536 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_76537 = [inst_76529,inst_76534];
var inst_76538 = cljs.core.PersistentHashMap.fromArrays(inst_76536,inst_76537);
var inst_76539 = fluree.db.operations.command_async(conn,inst_76538);
var state_76559__$1 = state_76559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76559__$1,(24),inst_76539);
} else {
if((state_val_76560 === (13))){
var inst_76511 = (state_76559[(12)]);
var inst_76518 = (inst_76511 + (30000));
var state_76559__$1 = state_76559;
var statearr_76570_76613 = state_76559__$1;
(statearr_76570_76613[(2)] = inst_76518);

(statearr_76570_76613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (22))){
var inst_76523 = (state_76559[(10)]);
var inst_76544 = fluree.db.operations.unsigned_command_async(conn,inst_76523);
var state_76559__$1 = state_76559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76559__$1,(25),inst_76544);
} else {
if((state_val_76560 === (6))){
var state_76559__$1 = state_76559;
var statearr_76571_76614 = state_76559__$1;
(statearr_76571_76614[(2)] = null);

(statearr_76571_76614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (25))){
var inst_76546 = (state_76559[(2)]);
var inst_76547 = fluree.db.util.async.throw_err(inst_76546);
var state_76559__$1 = state_76559;
var statearr_76572_76615 = state_76559__$1;
(statearr_76572_76615[(2)] = inst_76547);

(statearr_76572_76615[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (17))){
var inst_76510 = (state_76559[(7)]);
var inst_76529 = (state_76559[(2)]);
var state_76559__$1 = (function (){var statearr_76573 = state_76559;
(statearr_76573[(11)] = inst_76529);

return statearr_76573;
})();
if(cljs.core.truth_(inst_76510)){
var statearr_76574_76616 = state_76559__$1;
(statearr_76574_76616[(1)] = (18));

} else {
var statearr_76575_76617 = state_76559__$1;
(statearr_76575_76617[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (3))){
var inst_76557 = (state_76559[(2)]);
var state_76559__$1 = state_76559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76559__$1,inst_76557);
} else {
if((state_val_76560 === (12))){
var inst_76508 = (state_76559[(13)]);
var state_76559__$1 = state_76559;
var statearr_76576_76618 = state_76559__$1;
(statearr_76576_76618[(2)] = inst_76508);

(statearr_76576_76618[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (2))){
var _ = (function (){var statearr_76577 = state_76559;
(statearr_76577[(4)] = cljs.core.cons((5),(state_76559[(4)])));

return statearr_76577;
})();
var inst_76499 = (opts == null);
var state_76559__$1 = state_76559;
if(cljs.core.truth_(inst_76499)){
var statearr_76578_76619 = state_76559__$1;
(statearr_76578_76619[(1)] = (6));

} else {
var statearr_76579_76620 = state_76559__$1;
(statearr_76579_76620[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (23))){
var inst_76549 = (state_76559[(2)]);
var inst_76550 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_76551 = [(200),inst_76549];
var inst_76552 = cljs.core.PersistentHashMap.fromArrays(inst_76550,inst_76551);
var inst_76553 = cljs.core.clj__GT_js(inst_76552);
var inst_76554 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76553) : resolve.call(null,inst_76553));
var _ = (function (){var statearr_76580 = state_76559;
(statearr_76580[(4)] = cljs.core.rest((state_76559[(4)])));

return statearr_76580;
})();
var state_76559__$1 = state_76559;
var statearr_76581_76621 = state_76559__$1;
(statearr_76581_76621[(2)] = inst_76554);

(statearr_76581_76621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (19))){
var state_76559__$1 = state_76559;
var statearr_76582_76622 = state_76559__$1;
(statearr_76582_76622[(2)] = null);

(statearr_76582_76622[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (11))){
var inst_76508 = (state_76559[(13)]);
var inst_76515 = (state_76559[(2)]);
var state_76559__$1 = (function (){var statearr_76584 = state_76559;
(statearr_76584[(14)] = inst_76515);

return statearr_76584;
})();
if(cljs.core.truth_(inst_76508)){
var statearr_76585_76623 = state_76559__$1;
(statearr_76585_76623[(1)] = (12));

} else {
var statearr_76586_76624 = state_76559__$1;
(statearr_76586_76624[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (9))){
var inst_76507 = (state_76559[(15)]);
var state_76559__$1 = state_76559;
var statearr_76587_76625 = state_76559__$1;
(statearr_76587_76625[(2)] = inst_76507);

(statearr_76587_76625[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (5))){
var _ = (function (){var statearr_76588 = state_76559;
(statearr_76588[(4)] = cljs.core.rest((state_76559[(4)])));

return statearr_76588;
})();
var state_76559__$1 = state_76559;
var ex76583 = (state_76559__$1[(2)]);
var statearr_76589_76626 = state_76559__$1;
(statearr_76589_76626[(5)] = ex76583);


var statearr_76590_76627 = state_76559__$1;
(statearr_76590_76627[(1)] = (4));

(statearr_76590_76627[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (14))){
var inst_76515 = (state_76559[(14)]);
var inst_76510 = (state_76559[(7)]);
var inst_76520 = (state_76559[(2)]);
var inst_76521 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_76522 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_76515,inst_76520];
var inst_76523 = cljs.core.PersistentHashMap.fromArrays(inst_76521,inst_76522);
var state_76559__$1 = (function (){var statearr_76591 = state_76559;
(statearr_76591[(10)] = inst_76523);

return statearr_76591;
})();
if(cljs.core.truth_(inst_76510)){
var statearr_76592_76628 = state_76559__$1;
(statearr_76592_76628[(1)] = (15));

} else {
var statearr_76593_76629 = state_76559__$1;
(statearr_76593_76629[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (16))){
var state_76559__$1 = state_76559;
var statearr_76594_76630 = state_76559__$1;
(statearr_76594_76630[(2)] = null);

(statearr_76594_76630[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (10))){
var inst_76511 = (state_76559[(12)]);
var state_76559__$1 = state_76559;
var statearr_76595_76631 = state_76559__$1;
(statearr_76595_76631[(2)] = inst_76511);

(statearr_76595_76631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (18))){
var inst_76529 = (state_76559[(11)]);
var inst_76510 = (state_76559[(7)]);
var inst_76531 = fluree.crypto.sign_message(inst_76529,inst_76510);
var state_76559__$1 = state_76559;
var statearr_76596_76632 = state_76559__$1;
(statearr_76596_76632[(2)] = inst_76531);

(statearr_76596_76632[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76560 === (8))){
var inst_76507 = (state_76559[(15)]);
var inst_76504 = (state_76559[(2)]);
var inst_76505 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76504);
var inst_76506 = cljs.core.__destructure_map(inst_76504);
var inst_76507__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76506,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_76508 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76506,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_76509 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76506,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_76510 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76506,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_76511 = fluree.db.util.core.current_time_millis();
var state_76559__$1 = (function (){var statearr_76597 = state_76559;
(statearr_76597[(15)] = inst_76507__$1);

(statearr_76597[(13)] = inst_76508);

(statearr_76597[(12)] = inst_76511);

(statearr_76597[(16)] = inst_76505);

(statearr_76597[(17)] = inst_76509);

(statearr_76597[(7)] = inst_76510);

return statearr_76597;
})();
if(cljs.core.truth_(inst_76507__$1)){
var statearr_76598_76633 = state_76559__$1;
(statearr_76598_76633[(1)] = (9));

} else {
var statearr_76599_76634 = state_76559__$1;
(statearr_76599_76634[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76600[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76600[(1)] = (1));

return statearr_76600;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76559){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76559);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76601){var ex__2730__auto__ = e76601;
var statearr_76602_76635 = state_76559;
(statearr_76602_76635[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76559[(4)]))){
var statearr_76603_76636 = state_76559;
(statearr_76603_76636[(1)] = cljs.core.first((state_76559[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76637 = state_76559;
state_76559 = G__76637;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76559){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76604 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76604[(6)] = c__2749__auto__);

return statearr_76604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76659){
var state_val_76660 = (state_76659[(1)]);
if((state_val_76660 === (1))){
var state_76659__$1 = state_76659;
var statearr_76661_76676 = state_76659__$1;
(statearr_76661_76676[(2)] = null);

(statearr_76661_76676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76660 === (2))){
var _ = (function (){var statearr_76662 = state_76659;
(statearr_76662[(4)] = cljs.core.cons((5),(state_76659[(4)])));

return statearr_76662;
})();
var inst_76649 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_76659__$1 = state_76659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76659__$1,(6),inst_76649);
} else {
if((state_val_76660 === (3))){
var inst_76657 = (state_76659[(2)]);
var state_76659__$1 = state_76659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76659__$1,inst_76657);
} else {
if((state_val_76660 === (4))){
var inst_76638 = (state_76659[(2)]);
var inst_76639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76640 = [inst_76638];
var inst_76641 = (new cljs.core.PersistentVector(null,1,(5),inst_76639,inst_76640,null));
var inst_76642 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76641);
var inst_76643 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76638) : reject.call(null,inst_76638));
var state_76659__$1 = (function (){var statearr_76664 = state_76659;
(statearr_76664[(7)] = inst_76642);

return statearr_76664;
})();
var statearr_76665_76677 = state_76659__$1;
(statearr_76665_76677[(2)] = inst_76643);

(statearr_76665_76677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76660 === (5))){
var _ = (function (){var statearr_76666 = state_76659;
(statearr_76666[(4)] = cljs.core.rest((state_76659[(4)])));

return statearr_76666;
})();
var state_76659__$1 = state_76659;
var ex76663 = (state_76659__$1[(2)]);
var statearr_76667_76678 = state_76659__$1;
(statearr_76667_76678[(5)] = ex76663);


var statearr_76668_76679 = state_76659__$1;
(statearr_76668_76679[(1)] = (4));

(statearr_76668_76679[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76660 === (6))){
var inst_76651 = (state_76659[(2)]);
var inst_76652 = fluree.db.util.async.throw_err(inst_76651);
var inst_76653 = cljs.core.clj__GT_js(inst_76652);
var inst_76654 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76653) : resolve.call(null,inst_76653));
var _ = (function (){var statearr_76669 = state_76659;
(statearr_76669[(4)] = cljs.core.rest((state_76659[(4)])));

return statearr_76669;
})();
var state_76659__$1 = state_76659;
var statearr_76670_76680 = state_76659__$1;
(statearr_76670_76680[(2)] = inst_76654);

(statearr_76670_76680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2727__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2727__auto____0 = (function (){
var statearr_76671 = [null,null,null,null,null,null,null,null];
(statearr_76671[(0)] = flureedb$ledger_stats_$_state_machine__2727__auto__);

(statearr_76671[(1)] = (1));

return statearr_76671;
});
var flureedb$ledger_stats_$_state_machine__2727__auto____1 = (function (state_76659){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76659);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76672){var ex__2730__auto__ = e76672;
var statearr_76673_76681 = state_76659;
(statearr_76673_76681[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76659[(4)]))){
var statearr_76674_76682 = state_76659;
(statearr_76674_76682[(1)] = cljs.core.first((state_76659[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76683 = state_76659;
state_76659 = G__76683;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2727__auto__ = function(state_76659){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2727__auto____1.call(this,state_76659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2727__auto____0;
flureedb$ledger_stats_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2727__auto____1;
return flureedb$ledger_stats_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76675 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76675[(6)] = c__2749__auto__);

return statearr_76675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than ledger-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not ledger-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__76685 = arguments.length;
switch (G__76685) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76812){
var state_val_76813 = (state_76812[(1)]);
if((state_val_76813 === (7))){
var inst_76711 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_76812__$1 = state_76812;
var statearr_76814_76884 = state_76812__$1;
(statearr_76814_76884[(2)] = inst_76711);

(statearr_76814_76884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (20))){
var inst_76718 = (state_76812[(7)]);
var inst_76757 = (state_76812[(2)]);
var inst_76758 = fluree.db.util.core.current_time_millis();
var state_76812__$1 = (function (){var statearr_76815 = state_76812;
(statearr_76815[(8)] = inst_76757);

(statearr_76815[(9)] = inst_76758);

return statearr_76815;
})();
if(cljs.core.truth_(inst_76718)){
var statearr_76816_76885 = state_76812__$1;
(statearr_76816_76885[(1)] = (21));

} else {
var statearr_76817_76886 = state_76812__$1;
(statearr_76817_76886[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (27))){
var inst_76726 = (state_76812[(10)]);
var inst_76771 = (state_76812[(11)]);
var inst_76773 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76771,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_76726);
var state_76812__$1 = state_76812;
var statearr_76818_76887 = state_76812__$1;
(statearr_76818_76887[(2)] = inst_76773);

(statearr_76818_76887[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (1))){
var state_76812__$1 = state_76812;
var statearr_76819_76888 = state_76812__$1;
(statearr_76819_76888[(2)] = null);

(statearr_76819_76888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (24))){
var inst_76724 = (state_76812[(12)]);
var state_76812__$1 = state_76812;
var statearr_76820_76889 = state_76812__$1;
(statearr_76820_76889[(2)] = inst_76724);

(statearr_76820_76889[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (39))){
var inst_76794 = (state_76812[(2)]);
var inst_76795 = fluree.db.util.async.throw_err(inst_76794);
var state_76812__$1 = state_76812;
var statearr_76821_76890 = state_76812__$1;
(statearr_76821_76890[(2)] = inst_76795);

(statearr_76821_76890[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (4))){
var inst_76686 = (state_76812[(2)]);
var inst_76687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76688 = [inst_76686];
var inst_76689 = (new cljs.core.PersistentVector(null,1,(5),inst_76687,inst_76688,null));
var inst_76690 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76689);
var inst_76691 = cljs.core.ex_data(inst_76686);
var inst_76692 = cljs.core.ex_message(inst_76686);
var inst_76693 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76691,new cljs.core.Keyword(null,"message","message",-406056002),inst_76692);
var inst_76694 = cljs.core.clj__GT_js(inst_76693);
var inst_76695 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76694) : reject.call(null,inst_76694));
var state_76812__$1 = (function (){var statearr_76822 = state_76812;
(statearr_76822[(13)] = inst_76690);

return statearr_76822;
})();
var statearr_76823_76891 = state_76812__$1;
(statearr_76823_76891[(2)] = inst_76695);

(statearr_76823_76891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (15))){
var inst_76747 = (state_76812[(14)]);
var inst_76749 = fluree.db.graphdb.validate_ledger_name(inst_76747,"alias");
var state_76812__$1 = state_76812;
var statearr_76824_76892 = state_76812__$1;
(statearr_76824_76892[(2)] = inst_76749);

(statearr_76824_76892[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (21))){
var inst_76718 = (state_76812[(7)]);
var state_76812__$1 = state_76812;
var statearr_76825_76893 = state_76812__$1;
(statearr_76825_76893[(2)] = inst_76718);

(statearr_76825_76893[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (31))){
var state_76812__$1 = state_76812;
var statearr_76826_76894 = state_76812__$1;
(statearr_76826_76894[(2)] = null);

(statearr_76826_76894[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (32))){
var inst_76720 = (state_76812[(15)]);
var inst_76782 = (state_76812[(2)]);
var state_76812__$1 = (function (){var statearr_76827 = state_76812;
(statearr_76827[(16)] = inst_76782);

return statearr_76827;
})();
if(cljs.core.truth_(inst_76720)){
var statearr_76828_76895 = state_76812__$1;
(statearr_76828_76895[(1)] = (33));

} else {
var statearr_76829_76896 = state_76812__$1;
(statearr_76829_76896[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (40))){
var inst_76799 = (state_76812[(2)]);
var inst_76800 = fluree.db.util.async.throw_err(inst_76799);
var state_76812__$1 = state_76812;
var statearr_76830_76897 = state_76812__$1;
(statearr_76830_76897[(2)] = inst_76800);

(statearr_76830_76897[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (33))){
var inst_76782 = (state_76812[(16)]);
var inst_76720 = (state_76812[(15)]);
var inst_76784 = fluree.crypto.sign_message(inst_76782,inst_76720);
var state_76812__$1 = state_76812;
var statearr_76831_76898 = state_76812__$1;
(statearr_76831_76898[(2)] = inst_76784);

(statearr_76831_76898[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (13))){
var state_76812__$1 = state_76812;
var statearr_76832_76899 = state_76812__$1;
(statearr_76832_76899[(2)] = null);

(statearr_76832_76899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (22))){
var inst_76758 = (state_76812[(9)]);
var state_76812__$1 = state_76812;
var statearr_76833_76900 = state_76812__$1;
(statearr_76833_76900[(2)] = inst_76758);

(statearr_76833_76900[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (36))){
var inst_76782 = (state_76812[(16)]);
var inst_76787 = (state_76812[(17)]);
var inst_76789 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_76790 = [inst_76782,inst_76787];
var inst_76791 = cljs.core.PersistentHashMap.fromArrays(inst_76789,inst_76790);
var inst_76792 = fluree.db.operations.command_async(conn,inst_76791);
var state_76812__$1 = state_76812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76812__$1,(39),inst_76792);
} else {
if((state_val_76813 === (29))){
var inst_76720 = (state_76812[(15)]);
var inst_76776 = (state_76812[(2)]);
var state_76812__$1 = (function (){var statearr_76834 = state_76812;
(statearr_76834[(18)] = inst_76776);

return statearr_76834;
})();
if(cljs.core.truth_(inst_76720)){
var statearr_76835_76901 = state_76812__$1;
(statearr_76835_76901[(1)] = (30));

} else {
var statearr_76836_76902 = state_76812__$1;
(statearr_76836_76902[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (6))){
var state_76812__$1 = state_76812;
var statearr_76837_76903 = state_76812__$1;
(statearr_76837_76903[(2)] = null);

(statearr_76837_76903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (28))){
var inst_76771 = (state_76812[(11)]);
var state_76812__$1 = state_76812;
var statearr_76838_76904 = state_76812__$1;
(statearr_76838_76904[(2)] = inst_76771);

(statearr_76838_76904[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (25))){
var inst_76758 = (state_76812[(9)]);
var inst_76765 = (inst_76758 + (30000));
var state_76812__$1 = state_76812;
var statearr_76839_76905 = state_76812__$1;
(statearr_76839_76905[(2)] = inst_76765);

(statearr_76839_76905[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (34))){
var state_76812__$1 = state_76812;
var statearr_76840_76906 = state_76812__$1;
(statearr_76840_76906[(2)] = null);

(statearr_76840_76906[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (17))){
var inst_76728 = (state_76812[(19)]);
var inst_76752 = (state_76812[(2)]);
var state_76812__$1 = (function (){var statearr_76841 = state_76812;
(statearr_76841[(20)] = inst_76752);

return statearr_76841;
})();
if(cljs.core.truth_(inst_76728)){
var statearr_76842_76907 = state_76812__$1;
(statearr_76842_76907[(1)] = (18));

} else {
var statearr_76843_76908 = state_76812__$1;
(statearr_76843_76908[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (3))){
var inst_76810 = (state_76812[(2)]);
var state_76812__$1 = state_76812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76812__$1,inst_76810);
} else {
if((state_val_76813 === (12))){
var inst_76742 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_76812__$1 = state_76812;
var statearr_76844_76909 = state_76812__$1;
(statearr_76844_76909[(2)] = inst_76742);

(statearr_76844_76909[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (2))){
var _ = (function (){var statearr_76845 = state_76812;
(statearr_76845[(4)] = cljs.core.cons((5),(state_76812[(4)])));

return statearr_76845;
})();
var inst_76708 = (opts == null);
var state_76812__$1 = state_76812;
if(cljs.core.truth_(inst_76708)){
var statearr_76846_76910 = state_76812__$1;
(statearr_76846_76910[(1)] = (6));

} else {
var statearr_76847_76911 = state_76812__$1;
(statearr_76847_76911[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (23))){
var inst_76724 = (state_76812[(12)]);
var inst_76762 = (state_76812[(2)]);
var state_76812__$1 = (function (){var statearr_76848 = state_76812;
(statearr_76848[(21)] = inst_76762);

return statearr_76848;
})();
if(cljs.core.truth_(inst_76724)){
var statearr_76849_76912 = state_76812__$1;
(statearr_76849_76912[(1)] = (24));

} else {
var statearr_76850_76913 = state_76812__$1;
(statearr_76850_76913[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (35))){
var inst_76720 = (state_76812[(15)]);
var inst_76787 = (state_76812[(2)]);
var state_76812__$1 = (function (){var statearr_76851 = state_76812;
(statearr_76851[(17)] = inst_76787);

return statearr_76851;
})();
if(cljs.core.truth_(inst_76720)){
var statearr_76852_76914 = state_76812__$1;
(statearr_76852_76914[(1)] = (36));

} else {
var statearr_76853_76915 = state_76812__$1;
(statearr_76853_76915[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (19))){
var state_76812__$1 = state_76812;
var statearr_76854_76916 = state_76812__$1;
(statearr_76854_76916[(2)] = null);

(statearr_76854_76916[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (11))){
var inst_76728 = (state_76812[(19)]);
var inst_76738 = (state_76812[(22)]);
var inst_76731 = (state_76812[(23)]);
var inst_76738__$1 = (state_76812[(2)]);
var inst_76739 = fluree.db.graphdb.validate_ledger_name(inst_76738__$1,"ledger");
var inst_76740 = fluree.db.graphdb.validate_ledger_name(inst_76731,"network");
var state_76812__$1 = (function (){var statearr_76856 = state_76812;
(statearr_76856[(22)] = inst_76738__$1);

(statearr_76856[(24)] = inst_76740);

(statearr_76856[(25)] = inst_76739);

return statearr_76856;
})();
if(cljs.core.truth_(inst_76728)){
var statearr_76857_76917 = state_76812__$1;
(statearr_76857_76917[(1)] = (12));

} else {
var statearr_76858_76918 = state_76812__$1;
(statearr_76858_76918[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (9))){
var inst_76732 = (state_76812[(26)]);
var inst_76735 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_76732,(1));
var state_76812__$1 = state_76812;
var statearr_76859_76919 = state_76812__$1;
(statearr_76859_76919[(2)] = inst_76735);

(statearr_76859_76919[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (5))){
var _ = (function (){var statearr_76860 = state_76812;
(statearr_76860[(4)] = cljs.core.rest((state_76812[(4)])));

return statearr_76860;
})();
var state_76812__$1 = state_76812;
var ex76855 = (state_76812__$1[(2)]);
var statearr_76861_76920 = state_76812__$1;
(statearr_76861_76920[(5)] = ex76855);


var statearr_76862_76921 = state_76812__$1;
(statearr_76862_76921[(1)] = (4));

(statearr_76862_76921[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (14))){
var inst_76728 = (state_76812[(19)]);
var inst_76745 = (state_76812[(2)]);
var inst_76746 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76745,(0),null);
var inst_76747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76745,(1),null);
var state_76812__$1 = (function (){var statearr_76863 = state_76812;
(statearr_76863[(27)] = inst_76746);

(statearr_76863[(14)] = inst_76747);

return statearr_76863;
})();
if(cljs.core.truth_(inst_76728)){
var statearr_76864_76922 = state_76812__$1;
(statearr_76864_76922[(1)] = (15));

} else {
var statearr_76865_76923 = state_76812__$1;
(statearr_76865_76923[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (26))){
var inst_76757 = (state_76812[(8)]);
var inst_76725 = (state_76812[(28)]);
var inst_76723 = (state_76812[(29)]);
var inst_76717 = (state_76812[(30)]);
var inst_76721 = (state_76812[(31)]);
var inst_76738 = (state_76812[(22)]);
var inst_76762 = (state_76812[(21)]);
var inst_76719 = (state_76812[(32)]);
var inst_76722 = (state_76812[(33)]);
var inst_76726 = (state_76812[(10)]);
var inst_76727 = (state_76812[(34)]);
var inst_76731 = (state_76812[(23)]);
var inst_76729 = (state_76812[(35)]);
var inst_76767 = (state_76812[(2)]);
var inst_76768 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_76769 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76731),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76738)].join('');
var inst_76770 = [inst_76769,inst_76722,inst_76723,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_76767,inst_76725,inst_76757,inst_76729,inst_76727,inst_76717,inst_76762,inst_76719,inst_76721];
var inst_76771 = cljs.core.PersistentHashMap.fromArrays(inst_76768,inst_76770);
var state_76812__$1 = (function (){var statearr_76866 = state_76812;
(statearr_76866[(11)] = inst_76771);

return statearr_76866;
})();
if(cljs.core.truth_(inst_76726)){
var statearr_76867_76924 = state_76812__$1;
(statearr_76867_76924[(1)] = (27));

} else {
var statearr_76868_76925 = state_76812__$1;
(statearr_76868_76925[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (16))){
var state_76812__$1 = state_76812;
var statearr_76869_76926 = state_76812__$1;
(statearr_76869_76926[(2)] = null);

(statearr_76869_76926[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (38))){
var inst_76802 = (state_76812[(2)]);
var inst_76803 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_76804 = [(200),inst_76802];
var inst_76805 = cljs.core.PersistentHashMap.fromArrays(inst_76803,inst_76804);
var inst_76806 = cljs.core.clj__GT_js(inst_76805);
var inst_76807 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76806) : resolve.call(null,inst_76806));
var _ = (function (){var statearr_76870 = state_76812;
(statearr_76870[(4)] = cljs.core.rest((state_76812[(4)])));

return statearr_76870;
})();
var state_76812__$1 = state_76812;
var statearr_76871_76927 = state_76812__$1;
(statearr_76871_76927[(2)] = inst_76807);

(statearr_76871_76927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (30))){
var inst_76776 = (state_76812[(18)]);
var inst_76778 = fluree.db.util.core.without_nils(inst_76776);
var inst_76779 = fluree.db.util.json.stringify(inst_76778);
var state_76812__$1 = state_76812;
var statearr_76872_76928 = state_76812__$1;
(statearr_76872_76928[(2)] = inst_76779);

(statearr_76872_76928[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (10))){
var inst_76732 = (state_76812[(26)]);
var state_76812__$1 = state_76812;
var statearr_76873_76929 = state_76812__$1;
(statearr_76873_76929[(2)] = inst_76732);

(statearr_76873_76929[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (18))){
var inst_76746 = (state_76812[(27)]);
var inst_76747 = (state_76812[(14)]);
var inst_76754 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76746),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76747)].join('');
var state_76812__$1 = state_76812;
var statearr_76874_76930 = state_76812__$1;
(statearr_76874_76930[(2)] = inst_76754);

(statearr_76874_76930[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76813 === (37))){
var inst_76776 = (state_76812[(18)]);
var inst_76797 = fluree.db.operations.unsigned_command_async(conn,inst_76776);
var state_76812__$1 = state_76812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76812__$1,(40),inst_76797);
} else {
if((state_val_76813 === (8))){
var inst_76732 = (state_76812[(26)]);
var inst_76713 = (state_76812[(2)]);
var inst_76714 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_76713);
var inst_76715 = cljs.core.__destructure_map(inst_76713);
var inst_76716 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76715,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_76717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_76718 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_76719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_76720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_76721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_76722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_76723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_76724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_76725 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_76726 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_76727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_76728 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_76729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76715,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_76730 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_76731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76730,(0),null);
var inst_76732__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76730,(1),null);
var inst_76733 = clojure.string.starts_with_QMARK_(inst_76732__$1,"$");
var state_76812__$1 = (function (){var statearr_76875 = state_76812;
(statearr_76875[(19)] = inst_76728);

(statearr_76875[(28)] = inst_76725);

(statearr_76875[(29)] = inst_76723);

(statearr_76875[(30)] = inst_76717);

(statearr_76875[(31)] = inst_76721);

(statearr_76875[(36)] = inst_76716);

(statearr_76875[(12)] = inst_76724);

(statearr_76875[(7)] = inst_76718);

(statearr_76875[(32)] = inst_76719);

(statearr_76875[(33)] = inst_76722);

(statearr_76875[(37)] = inst_76714);

(statearr_76875[(10)] = inst_76726);

(statearr_76875[(26)] = inst_76732__$1);

(statearr_76875[(34)] = inst_76727);

(statearr_76875[(23)] = inst_76731);

(statearr_76875[(15)] = inst_76720);

(statearr_76875[(35)] = inst_76729);

return statearr_76875;
})();
if(inst_76733){
var statearr_76876_76931 = state_76812__$1;
(statearr_76876_76931[(1)] = (9));

} else {
var statearr_76877_76932 = state_76812__$1;
(statearr_76877_76932[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_76878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76878[(0)] = flureedb$state_machine__2727__auto__);

(statearr_76878[(1)] = (1));

return statearr_76878;
});
var flureedb$state_machine__2727__auto____1 = (function (state_76812){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76812);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76879){var ex__2730__auto__ = e76879;
var statearr_76880_76933 = state_76812;
(statearr_76880_76933[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76812[(4)]))){
var statearr_76881_76934 = state_76812;
(statearr_76881_76934[(1)] = cljs.core.first((state_76812[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76935 = state_76812;
state_76812 = G__76935;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_76812){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_76812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76882 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76882[(6)] = c__2749__auto__);

return statearr_76882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_76958){
var state_val_76959 = (state_76958[(1)]);
if((state_val_76959 === (1))){
var state_76958__$1 = state_76958;
var statearr_76960_76976 = state_76958__$1;
(statearr_76960_76976[(2)] = null);

(statearr_76960_76976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76959 === (2))){
var _ = (function (){var statearr_76961 = state_76958;
(statearr_76961[(4)] = cljs.core.cons((5),(state_76958[(4)])));

return statearr_76961;
})();
var inst_76948 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76949 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_76958__$1 = (function (){var statearr_76962 = state_76958;
(statearr_76962[(7)] = inst_76948);

return statearr_76962;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76958__$1,(6),inst_76949);
} else {
if((state_val_76959 === (3))){
var inst_76956 = (state_76958[(2)]);
var state_76958__$1 = state_76958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76958__$1,inst_76956);
} else {
if((state_val_76959 === (4))){
var inst_76936 = (state_76958[(2)]);
var inst_76937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76938 = [inst_76936];
var inst_76939 = (new cljs.core.PersistentVector(null,1,(5),inst_76937,inst_76938,null));
var inst_76940 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76939);
var inst_76941 = cljs.core.clj__GT_js(inst_76936);
var inst_76942 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76941) : reject.call(null,inst_76941));
var state_76958__$1 = (function (){var statearr_76964 = state_76958;
(statearr_76964[(8)] = inst_76940);

return statearr_76964;
})();
var statearr_76965_76977 = state_76958__$1;
(statearr_76965_76977[(2)] = inst_76942);

(statearr_76965_76977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76959 === (5))){
var _ = (function (){var statearr_76966 = state_76958;
(statearr_76966[(4)] = cljs.core.rest((state_76958[(4)])));

return statearr_76966;
})();
var state_76958__$1 = state_76958;
var ex76963 = (state_76958__$1[(2)]);
var statearr_76967_76978 = state_76958__$1;
(statearr_76967_76978[(5)] = ex76963);


var statearr_76968_76979 = state_76958__$1;
(statearr_76968_76979[(1)] = (4));

(statearr_76968_76979[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76959 === (6))){
var inst_76951 = (state_76958[(2)]);
var inst_76952 = cljs.core.clj__GT_js(inst_76951);
var inst_76953 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_76952) : resolve.call(null,inst_76952));
var _ = (function (){var statearr_76969 = state_76958;
(statearr_76969[(4)] = cljs.core.rest((state_76958[(4)])));

return statearr_76969;
})();
var state_76958__$1 = state_76958;
var statearr_76970_76980 = state_76958__$1;
(statearr_76970_76980[(2)] = inst_76953);

(statearr_76970_76980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2727__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_76971 = [null,null,null,null,null,null,null,null,null];
(statearr_76971[(0)] = flureedb$monitor_tx_$_state_machine__2727__auto__);

(statearr_76971[(1)] = (1));

return statearr_76971;
});
var flureedb$monitor_tx_$_state_machine__2727__auto____1 = (function (state_76958){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_76958);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e76972){var ex__2730__auto__ = e76972;
var statearr_76973_76981 = state_76958;
(statearr_76973_76981[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_76958[(4)]))){
var statearr_76974_76982 = state_76958;
(statearr_76974_76982[(1)] = cljs.core.first((state_76958[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76983 = state_76958;
state_76958 = G__76983;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2727__auto__ = function(state_76958){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2727__auto____1.call(this,state_76958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2727__auto____0;
flureedb$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2727__auto____1;
return flureedb$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_76975 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_76975[(6)] = c__2749__auto__);

return statearr_76975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__76985 = arguments.length;
switch (G__76985) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77014){
var state_val_77015 = (state_77014[(1)]);
if((state_val_77015 === (7))){
var inst_77000 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_77014__$1 = state_77014;
var statearr_77016_77037 = state_77014__$1;
(statearr_77016_77037[(2)] = inst_77000);

(statearr_77016_77037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77015 === (1))){
var state_77014__$1 = state_77014;
var statearr_77017_77038 = state_77014__$1;
(statearr_77017_77038[(2)] = null);

(statearr_77017_77038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77015 === (4))){
var inst_76986 = (state_77014[(2)]);
var inst_76987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76988 = [inst_76986];
var inst_76989 = (new cljs.core.PersistentVector(null,1,(5),inst_76987,inst_76988,null));
var inst_76990 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76989);
var inst_76991 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_76986) : reject.call(null,inst_76986));
var state_77014__$1 = (function (){var statearr_77018 = state_77014;
(statearr_77018[(7)] = inst_76990);

return statearr_77018;
})();
var statearr_77019_77039 = state_77014__$1;
(statearr_77019_77039[(2)] = inst_76991);

(statearr_77019_77039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77015 === (6))){
var state_77014__$1 = state_77014;
var statearr_77020_77040 = state_77014__$1;
(statearr_77020_77040[(2)] = null);

(statearr_77020_77040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77015 === (3))){
var inst_77012 = (state_77014[(2)]);
var state_77014__$1 = state_77014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77014__$1,inst_77012);
} else {
if((state_val_77015 === (2))){
var _ = (function (){var statearr_77022 = state_77014;
(statearr_77022[(4)] = cljs.core.cons((5),(state_77014[(4)])));

return statearr_77022;
})();
var inst_76997 = (opts == null);
var state_77014__$1 = state_77014;
if(cljs.core.truth_(inst_76997)){
var statearr_77023_77041 = state_77014__$1;
(statearr_77023_77041[(1)] = (6));

} else {
var statearr_77024_77042 = state_77014__$1;
(statearr_77024_77042[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77015 === (9))){
var inst_77007 = (state_77014[(2)]);
var inst_77008 = cljs.core.clj__GT_js(inst_77007);
var inst_77009 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77008) : resolve.call(null,inst_77008));
var _ = (function (){var statearr_77025 = state_77014;
(statearr_77025[(4)] = cljs.core.rest((state_77014[(4)])));

return statearr_77025;
})();
var state_77014__$1 = state_77014;
var statearr_77026_77043 = state_77014__$1;
(statearr_77026_77043[(2)] = inst_77009);

(statearr_77026_77043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77015 === (5))){
var _ = (function (){var statearr_77027 = state_77014;
(statearr_77027[(4)] = cljs.core.rest((state_77014[(4)])));

return statearr_77027;
})();
var state_77014__$1 = state_77014;
var ex77021 = (state_77014__$1[(2)]);
var statearr_77028_77044 = state_77014__$1;
(statearr_77028_77044[(5)] = ex77021);


var statearr_77029_77045 = state_77014__$1;
(statearr_77029_77045[(1)] = (4));

(statearr_77029_77045[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77015 === (8))){
var inst_77002 = (state_77014[(2)]);
var inst_77003 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_77002);
var inst_77004 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_77005 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_77004,inst_77002);
var state_77014__$1 = (function (){var statearr_77030 = state_77014;
(statearr_77030[(8)] = inst_77003);

return statearr_77030;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77014__$1,(9),inst_77005);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_77031 = [null,null,null,null,null,null,null,null,null];
(statearr_77031[(0)] = flureedb$state_machine__2727__auto__);

(statearr_77031[(1)] = (1));

return statearr_77031;
});
var flureedb$state_machine__2727__auto____1 = (function (state_77014){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77014);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77032){var ex__2730__auto__ = e77032;
var statearr_77033_77046 = state_77014;
(statearr_77033_77046[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77014[(4)]))){
var statearr_77034_77047 = state_77014;
(statearr_77034_77047[(1)] = cljs.core.first((state_77014[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77048 = state_77014;
state_77014 = G__77048;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_77014){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_77014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77035 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77035[(6)] = c__2749__auto__);

return statearr_77035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__77050 = arguments.length;
switch (G__77050) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77082){
var state_val_77083 = (state_77082[(1)]);
if((state_val_77083 === (7))){
var inst_77065 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_77082__$1 = state_77082;
var statearr_77084_77105 = state_77082__$1;
(statearr_77084_77105[(2)] = inst_77065);

(statearr_77084_77105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77083 === (1))){
var state_77082__$1 = state_77082;
var statearr_77085_77106 = state_77082__$1;
(statearr_77085_77106[(2)] = null);

(statearr_77085_77106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77083 === (4))){
var inst_77051 = (state_77082[(2)]);
var inst_77052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77053 = [inst_77051];
var inst_77054 = (new cljs.core.PersistentVector(null,1,(5),inst_77052,inst_77053,null));
var inst_77055 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77054);
var inst_77056 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77051) : reject.call(null,inst_77051));
var state_77082__$1 = (function (){var statearr_77086 = state_77082;
(statearr_77086[(7)] = inst_77055);

return statearr_77086;
})();
var statearr_77087_77107 = state_77082__$1;
(statearr_77087_77107[(2)] = inst_77056);

(statearr_77087_77107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77083 === (6))){
var state_77082__$1 = state_77082;
var statearr_77088_77108 = state_77082__$1;
(statearr_77088_77108[(2)] = null);

(statearr_77088_77108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77083 === (3))){
var inst_77080 = (state_77082[(2)]);
var state_77082__$1 = state_77082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77082__$1,inst_77080);
} else {
if((state_val_77083 === (2))){
var _ = (function (){var statearr_77090 = state_77082;
(statearr_77090[(4)] = cljs.core.cons((5),(state_77082[(4)])));

return statearr_77090;
})();
var inst_77062 = (opts == null);
var state_77082__$1 = state_77082;
if(cljs.core.truth_(inst_77062)){
var statearr_77091_77109 = state_77082__$1;
(statearr_77091_77109[(1)] = (6));

} else {
var statearr_77092_77110 = state_77082__$1;
(statearr_77092_77110[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77083 === (9))){
var inst_77067 = (state_77082[(8)]);
var inst_77070 = (state_77082[(2)]);
var inst_77071 = fluree.db.util.async.throw_err(inst_77070);
var inst_77072 = fluree.db.query.block.block_range(inst_77071,start,end,inst_77067);
var state_77082__$1 = state_77082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77082__$1,(10),inst_77072);
} else {
if((state_val_77083 === (5))){
var _ = (function (){var statearr_77093 = state_77082;
(statearr_77093[(4)] = cljs.core.rest((state_77082[(4)])));

return statearr_77093;
})();
var state_77082__$1 = state_77082;
var ex77089 = (state_77082__$1[(2)]);
var statearr_77094_77111 = state_77082__$1;
(statearr_77094_77111[(5)] = ex77089);


var statearr_77095_77112 = state_77082__$1;
(statearr_77095_77112[(1)] = (4));

(statearr_77095_77112[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77083 === (10))){
var inst_77074 = (state_77082[(2)]);
var inst_77075 = fluree.db.util.async.throw_err(inst_77074);
var inst_77076 = cljs.core.clj__GT_js(inst_77075);
var inst_77077 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77076) : resolve.call(null,inst_77076));
var _ = (function (){var statearr_77096 = state_77082;
(statearr_77096[(4)] = cljs.core.rest((state_77082[(4)])));

return statearr_77096;
})();
var state_77082__$1 = state_77082;
var statearr_77097_77113 = state_77082__$1;
(statearr_77097_77113[(2)] = inst_77077);

(statearr_77097_77113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77083 === (8))){
var inst_77067 = (state_77082[(8)]);
var inst_77067__$1 = (state_77082[(2)]);
var inst_77068 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77067__$1], 0));
var state_77082__$1 = (function (){var statearr_77098 = state_77082;
(statearr_77098[(8)] = inst_77067__$1);

return statearr_77098;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77082__$1,(9),inst_77068);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_77099 = [null,null,null,null,null,null,null,null,null];
(statearr_77099[(0)] = flureedb$state_machine__2727__auto__);

(statearr_77099[(1)] = (1));

return statearr_77099;
});
var flureedb$state_machine__2727__auto____1 = (function (state_77082){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77082);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77100){var ex__2730__auto__ = e77100;
var statearr_77101_77114 = state_77082;
(statearr_77101_77114[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77082[(4)]))){
var statearr_77102_77115 = state_77082;
(statearr_77102_77115[(1)] = cljs.core.first((state_77082[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77116 = state_77082;
state_77082 = G__77116;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_77082){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_77082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77103 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77103[(6)] = c__2749__auto__);

return statearr_77103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__77118 = arguments.length;
switch (G__77118) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77156){
var state_val_77157 = (state_77156[(1)]);
if((state_val_77157 === (7))){
var inst_77134 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_77156__$1 = state_77156;
var statearr_77158_77179 = state_77156__$1;
(statearr_77158_77179[(2)] = inst_77134);

(statearr_77158_77179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77157 === (1))){
var state_77156__$1 = state_77156;
var statearr_77159_77180 = state_77156__$1;
(statearr_77159_77180[(2)] = null);

(statearr_77159_77180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77157 === (4))){
var inst_77119 = (state_77156[(2)]);
var inst_77120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77121 = [inst_77119];
var inst_77122 = (new cljs.core.PersistentVector(null,1,(5),inst_77120,inst_77121,null));
var inst_77123 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77122);
var inst_77124 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77119) : reject.call(null,inst_77119));
var state_77156__$1 = (function (){var statearr_77160 = state_77156;
(statearr_77160[(7)] = inst_77123);

return statearr_77160;
})();
var statearr_77161_77181 = state_77156__$1;
(statearr_77161_77181[(2)] = inst_77124);

(statearr_77161_77181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77157 === (6))){
var state_77156__$1 = state_77156;
var statearr_77162_77182 = state_77156__$1;
(statearr_77162_77182[(2)] = null);

(statearr_77162_77182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77157 === (3))){
var inst_77154 = (state_77156[(2)]);
var state_77156__$1 = state_77156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77156__$1,inst_77154);
} else {
if((state_val_77157 === (2))){
var _ = (function (){var statearr_77164 = state_77156;
(statearr_77164[(4)] = cljs.core.cons((5),(state_77156[(4)])));

return statearr_77164;
})();
var inst_77131 = (opts == null);
var state_77156__$1 = state_77156;
if(cljs.core.truth_(inst_77131)){
var statearr_77165_77183 = state_77156__$1;
(statearr_77165_77183[(1)] = (6));

} else {
var statearr_77166_77184 = state_77156__$1;
(statearr_77166_77184[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77157 === (9))){
var inst_77136 = (state_77156[(8)]);
var inst_77139 = (state_77156[(9)]);
var inst_77140 = (state_77156[(10)]);
var inst_77143 = (state_77156[(2)]);
var inst_77144 = fluree.db.util.async.throw_err(inst_77143);
var inst_77145 = fluree.db.query.block.block_range(inst_77144,inst_77139,inst_77140,inst_77136);
var state_77156__$1 = state_77156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77156__$1,(10),inst_77145);
} else {
if((state_val_77157 === (5))){
var _ = (function (){var statearr_77167 = state_77156;
(statearr_77167[(4)] = cljs.core.rest((state_77156[(4)])));

return statearr_77167;
})();
var state_77156__$1 = state_77156;
var ex77163 = (state_77156__$1[(2)]);
var statearr_77168_77185 = state_77156__$1;
(statearr_77168_77185[(5)] = ex77163);


var statearr_77169_77186 = state_77156__$1;
(statearr_77169_77186[(1)] = (4));

(statearr_77169_77186[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77157 === (10))){
var inst_77147 = (state_77156[(2)]);
var inst_77148 = fluree.db.util.async.throw_err(inst_77147);
var inst_77149 = fluree.db.query.range.block_with_tx_data(inst_77148);
var inst_77150 = cljs.core.clj__GT_js(inst_77149);
var inst_77151 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77150) : resolve.call(null,inst_77150));
var _ = (function (){var statearr_77170 = state_77156;
(statearr_77170[(4)] = cljs.core.rest((state_77156[(4)])));

return statearr_77170;
})();
var state_77156__$1 = state_77156;
var statearr_77171_77187 = state_77156__$1;
(statearr_77171_77187[(2)] = inst_77151);

(statearr_77171_77187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77157 === (8))){
var inst_77136 = (state_77156[(8)]);
var inst_77136__$1 = (state_77156[(2)]);
var inst_77137 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_77138 = cljs.core.__destructure_map(inst_77137);
var inst_77139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77138,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_77140 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77138,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_77141 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77136__$1], 0));
var state_77156__$1 = (function (){var statearr_77172 = state_77156;
(statearr_77172[(8)] = inst_77136__$1);

(statearr_77172[(9)] = inst_77139);

(statearr_77172[(10)] = inst_77140);

return statearr_77172;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77156__$1,(9),inst_77141);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_77173 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_77173[(0)] = flureedb$state_machine__2727__auto__);

(statearr_77173[(1)] = (1));

return statearr_77173;
});
var flureedb$state_machine__2727__auto____1 = (function (state_77156){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77156);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77174){var ex__2730__auto__ = e77174;
var statearr_77175_77188 = state_77156;
(statearr_77175_77188[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77156[(4)]))){
var statearr_77176_77189 = state_77156;
(statearr_77176_77189[(1)] = cljs.core.first((state_77156[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77190 = state_77156;
state_77156 = G__77190;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_77156){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_77156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77177 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77177[(6)] = c__2749__auto__);

return statearr_77177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__77192 = arguments.length;
switch (G__77192) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77262){
var state_val_77263 = (state_77262[(1)]);
if((state_val_77263 === (7))){
var inst_77208 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_77262__$1 = state_77262;
var statearr_77264_77305 = state_77262__$1;
(statearr_77264_77305[(2)] = inst_77208);

(statearr_77264_77305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (20))){
var inst_77204 = (state_77262[(7)]);
var inst_77210 = (state_77262[(8)]);
var inst_77246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77247 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_77248 = (new cljs.core.PersistentVector(null,1,(5),inst_77246,inst_77247,null));
var inst_77249 = cljs.core.assoc_in(inst_77210,inst_77248,new cljs.core.Keyword(null,"block","block",664686210));
var inst_77250 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_77204,inst_77249);
var state_77262__$1 = state_77262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77262__$1,(23),inst_77250);
} else {
if((state_val_77263 === (1))){
var state_77262__$1 = state_77262;
var statearr_77265_77306 = state_77262__$1;
(statearr_77265_77306[(2)] = null);

(statearr_77265_77306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (4))){
var inst_77193 = (state_77262[(2)]);
var inst_77194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77195 = [inst_77193];
var inst_77196 = (new cljs.core.PersistentVector(null,1,(5),inst_77194,inst_77195,null));
var inst_77197 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77196);
var inst_77198 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77193) : reject.call(null,inst_77193));
var state_77262__$1 = (function (){var statearr_77266 = state_77262;
(statearr_77266[(9)] = inst_77197);

return statearr_77266;
})();
var statearr_77267_77307 = state_77262__$1;
(statearr_77267_77307[(2)] = inst_77198);

(statearr_77267_77307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (15))){
var inst_77234 = (state_77262[(2)]);
var inst_77235 = fluree.db.util.async.throw_err(inst_77234);
var state_77262__$1 = state_77262;
var statearr_77268_77308 = state_77262__$1;
(statearr_77268_77308[(2)] = inst_77235);

(statearr_77268_77308[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (21))){
var inst_77255 = (state_77262[(2)]);
var inst_77256 = cljs.core.clj__GT_js(inst_77255);
var inst_77257 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77256) : resolve.call(null,inst_77256));
var _ = (function (){var statearr_77269 = state_77262;
(statearr_77269[(4)] = cljs.core.rest((state_77262[(4)])));

return statearr_77269;
})();
var state_77262__$1 = state_77262;
var statearr_77270_77309 = state_77262__$1;
(statearr_77270_77309[(2)] = inst_77257);

(statearr_77270_77309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (13))){
var state_77262__$1 = state_77262;
var statearr_77271_77310 = state_77262__$1;
(statearr_77271_77310[(2)] = null);

(statearr_77271_77310[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (22))){
var inst_77243 = (state_77262[(2)]);
var inst_77244 = fluree.db.util.async.throw_err(inst_77243);
var state_77262__$1 = state_77262;
var statearr_77272_77311 = state_77262__$1;
(statearr_77272_77311[(2)] = inst_77244);

(statearr_77272_77311[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (6))){
var state_77262__$1 = state_77262;
var statearr_77273_77312 = state_77262__$1;
(statearr_77273_77312[(2)] = null);

(statearr_77273_77312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (17))){
var state_77262__$1 = state_77262;
var statearr_77274_77313 = state_77262__$1;
(statearr_77274_77313[(2)] = null);

(statearr_77274_77313[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (3))){
var inst_77260 = (state_77262[(2)]);
var state_77262__$1 = state_77262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77262__$1,inst_77260);
} else {
if((state_val_77263 === (12))){
var inst_77218 = (state_77262[(10)]);
var inst_77222 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_77262__$1 = (function (){var statearr_77275 = state_77262;
(statearr_77275[(11)] = inst_77222);

return statearr_77275;
})();
if(cljs.core.truth_(inst_77218)){
var statearr_77276_77314 = state_77262__$1;
(statearr_77276_77314[(1)] = (16));

} else {
var statearr_77277_77315 = state_77262__$1;
(statearr_77277_77315[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (2))){
var _ = (function (){var statearr_77278 = state_77262;
(statearr_77278[(4)] = cljs.core.cons((5),(state_77262[(4)])));

return statearr_77278;
})();
var inst_77204 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_77205 = (opts == null);
var state_77262__$1 = (function (){var statearr_77279 = state_77262;
(statearr_77279[(7)] = inst_77204);

return statearr_77279;
})();
if(cljs.core.truth_(inst_77205)){
var statearr_77280_77316 = state_77262__$1;
(statearr_77280_77316[(1)] = (6));

} else {
var statearr_77281_77317 = state_77262__$1;
(statearr_77281_77317[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (23))){
var inst_77252 = (state_77262[(2)]);
var inst_77253 = fluree.db.util.async.throw_err(inst_77252);
var state_77262__$1 = state_77262;
var statearr_77282_77318 = state_77262__$1;
(statearr_77282_77318[(2)] = inst_77253);

(statearr_77282_77318[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (19))){
var inst_77204 = (state_77262[(7)]);
var inst_77238 = (state_77262[(12)]);
var inst_77210 = (state_77262[(8)]);
var inst_77241 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_77238,inst_77204,inst_77210);
var state_77262__$1 = state_77262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77262__$1,(22),inst_77241);
} else {
if((state_val_77263 === (11))){
var inst_77212 = (state_77262[(13)]);
var inst_77210 = (state_77262[(8)]);
var inst_77218 = (state_77262[(2)]);
var inst_77219 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_77210);
var inst_77220 = (inst_77212 == null);
var state_77262__$1 = (function (){var statearr_77284 = state_77262;
(statearr_77284[(14)] = inst_77219);

(statearr_77284[(10)] = inst_77218);

return statearr_77284;
})();
if(cljs.core.truth_(inst_77220)){
var statearr_77285_77319 = state_77262__$1;
(statearr_77285_77319[(1)] = (12));

} else {
var statearr_77286_77320 = state_77262__$1;
(statearr_77286_77320[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (9))){
var inst_77213 = (state_77262[(15)]);
var state_77262__$1 = state_77262;
var statearr_77287_77321 = state_77262__$1;
(statearr_77287_77321[(2)] = inst_77213);

(statearr_77287_77321[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (5))){
var _ = (function (){var statearr_77288 = state_77262;
(statearr_77288[(4)] = cljs.core.rest((state_77262[(4)])));

return statearr_77288;
})();
var state_77262__$1 = state_77262;
var ex77283 = (state_77262__$1[(2)]);
var statearr_77289_77322 = state_77262__$1;
(statearr_77289_77322[(5)] = ex77283);


var statearr_77290_77323 = state_77262__$1;
(statearr_77290_77323[(1)] = (4));

(statearr_77290_77323[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (14))){
var inst_77212 = (state_77262[(13)]);
var inst_77238 = (state_77262[(2)]);
var inst_77239 = (inst_77212 == null);
var state_77262__$1 = (function (){var statearr_77291 = state_77262;
(statearr_77291[(12)] = inst_77238);

return statearr_77291;
})();
if(cljs.core.truth_(inst_77239)){
var statearr_77292_77324 = state_77262__$1;
(statearr_77292_77324[(1)] = (19));

} else {
var statearr_77293_77325 = state_77262__$1;
(statearr_77293_77325[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (16))){
var inst_77218 = (state_77262[(10)]);
var inst_77224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77225 = ["_auth/id",inst_77218];
var inst_77226 = (new cljs.core.PersistentVector(null,2,(5),inst_77224,inst_77225,null));
var state_77262__$1 = state_77262;
var statearr_77294_77326 = state_77262__$1;
(statearr_77294_77326[(2)] = inst_77226);

(statearr_77294_77326[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (10))){
var inst_77210 = (state_77262[(8)]);
var inst_77216 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_77210);
var state_77262__$1 = state_77262;
var statearr_77295_77327 = state_77262__$1;
(statearr_77295_77327[(2)] = inst_77216);

(statearr_77295_77327[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77263 === (18))){
var inst_77219 = (state_77262[(14)]);
var inst_77222 = (state_77262[(11)]);
var inst_77229 = (state_77262[(2)]);
var inst_77230 = [inst_77229,inst_77219];
var inst_77231 = cljs.core.PersistentHashMap.fromArrays(inst_77222,inst_77230);
var inst_77232 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77231], 0));
var state_77262__$1 = state_77262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77262__$1,(15),inst_77232);
} else {
if((state_val_77263 === (8))){
var inst_77210 = (state_77262[(8)]);
var inst_77213 = (state_77262[(15)]);
var inst_77210__$1 = (state_77262[(2)]);
var inst_77211 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_77210__$1);
var inst_77212 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_77210__$1);
var inst_77213__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_77210__$1);
var state_77262__$1 = (function (){var statearr_77296 = state_77262;
(statearr_77296[(13)] = inst_77212);

(statearr_77296[(16)] = inst_77211);

(statearr_77296[(8)] = inst_77210__$1);

(statearr_77296[(15)] = inst_77213__$1);

return statearr_77296;
})();
if(cljs.core.truth_(inst_77213__$1)){
var statearr_77297_77328 = state_77262__$1;
(statearr_77297_77328[(1)] = (9));

} else {
var statearr_77298_77329 = state_77262__$1;
(statearr_77298_77329[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_77299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77299[(0)] = flureedb$state_machine__2727__auto__);

(statearr_77299[(1)] = (1));

return statearr_77299;
});
var flureedb$state_machine__2727__auto____1 = (function (state_77262){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77262);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77300){var ex__2730__auto__ = e77300;
var statearr_77301_77330 = state_77262;
(statearr_77301_77330[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77262[(4)]))){
var statearr_77302_77331 = state_77262;
(statearr_77302_77331[(1)] = cljs.core.first((state_77262[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77332 = state_77262;
state_77262 = G__77332;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_77262){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_77262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77303 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77303[(6)] = c__2749__auto__);

return statearr_77303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77355){
var state_val_77356 = (state_77355[(1)]);
if((state_val_77356 === (1))){
var state_77355__$1 = state_77355;
var statearr_77357_77372 = state_77355__$1;
(statearr_77357_77372[(2)] = null);

(statearr_77357_77372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77356 === (2))){
var _ = (function (){var statearr_77358 = state_77355;
(statearr_77358[(4)] = cljs.core.cons((5),(state_77355[(4)])));

return statearr_77358;
})();
var inst_77344 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_77345 = fluree.db.api.query.history_query_async(sources,inst_77344);
var state_77355__$1 = state_77355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77355__$1,(6),inst_77345);
} else {
if((state_val_77356 === (3))){
var inst_77353 = (state_77355[(2)]);
var state_77355__$1 = state_77355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77355__$1,inst_77353);
} else {
if((state_val_77356 === (4))){
var inst_77333 = (state_77355[(2)]);
var inst_77334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77335 = [inst_77333];
var inst_77336 = (new cljs.core.PersistentVector(null,1,(5),inst_77334,inst_77335,null));
var inst_77337 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77336);
var inst_77338 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77333) : reject.call(null,inst_77333));
var state_77355__$1 = (function (){var statearr_77360 = state_77355;
(statearr_77360[(7)] = inst_77337);

return statearr_77360;
})();
var statearr_77361_77373 = state_77355__$1;
(statearr_77361_77373[(2)] = inst_77338);

(statearr_77361_77373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77356 === (5))){
var _ = (function (){var statearr_77362 = state_77355;
(statearr_77362[(4)] = cljs.core.rest((state_77355[(4)])));

return statearr_77362;
})();
var state_77355__$1 = state_77355;
var ex77359 = (state_77355__$1[(2)]);
var statearr_77363_77374 = state_77355__$1;
(statearr_77363_77374[(5)] = ex77359);


var statearr_77364_77375 = state_77355__$1;
(statearr_77364_77375[(1)] = (4));

(statearr_77364_77375[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77356 === (6))){
var inst_77347 = (state_77355[(2)]);
var inst_77348 = fluree.db.util.async.throw_err(inst_77347);
var inst_77349 = cljs.core.clj__GT_js(inst_77348);
var inst_77350 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77349) : resolve.call(null,inst_77349));
var _ = (function (){var statearr_77365 = state_77355;
(statearr_77365[(4)] = cljs.core.rest((state_77355[(4)])));

return statearr_77365;
})();
var state_77355__$1 = state_77355;
var statearr_77366_77376 = state_77355__$1;
(statearr_77366_77376[(2)] = inst_77350);

(statearr_77366_77376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2727__auto__ = null;
var flureedb$history_query_$_state_machine__2727__auto____0 = (function (){
var statearr_77367 = [null,null,null,null,null,null,null,null];
(statearr_77367[(0)] = flureedb$history_query_$_state_machine__2727__auto__);

(statearr_77367[(1)] = (1));

return statearr_77367;
});
var flureedb$history_query_$_state_machine__2727__auto____1 = (function (state_77355){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77355);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77368){var ex__2730__auto__ = e77368;
var statearr_77369_77377 = state_77355;
(statearr_77369_77377[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77355[(4)]))){
var statearr_77370_77378 = state_77355;
(statearr_77370_77378[(1)] = cljs.core.first((state_77355[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77379 = state_77355;
state_77355 = G__77379;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2727__auto__ = function(state_77355){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2727__auto____1.call(this,state_77355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2727__auto____0;
flureedb$history_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2727__auto____1;
return flureedb$history_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77371 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77371[(6)] = c__2749__auto__);

return statearr_77371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77402){
var state_val_77403 = (state_77402[(1)]);
if((state_val_77403 === (1))){
var state_77402__$1 = state_77402;
var statearr_77404_77419 = state_77402__$1;
(statearr_77404_77419[(2)] = null);

(statearr_77404_77419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77403 === (2))){
var _ = (function (){var statearr_77405 = state_77402;
(statearr_77405[(4)] = cljs.core.cons((5),(state_77402[(4)])));

return statearr_77405;
})();
var inst_77391 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_77392 = fluree.db.api.query.multi_query_async(sources,inst_77391);
var state_77402__$1 = state_77402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77402__$1,(6),inst_77392);
} else {
if((state_val_77403 === (3))){
var inst_77400 = (state_77402[(2)]);
var state_77402__$1 = state_77402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77402__$1,inst_77400);
} else {
if((state_val_77403 === (4))){
var inst_77380 = (state_77402[(2)]);
var inst_77381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77382 = [inst_77380];
var inst_77383 = (new cljs.core.PersistentVector(null,1,(5),inst_77381,inst_77382,null));
var inst_77384 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77383);
var inst_77385 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77380) : reject.call(null,inst_77380));
var state_77402__$1 = (function (){var statearr_77407 = state_77402;
(statearr_77407[(7)] = inst_77384);

return statearr_77407;
})();
var statearr_77408_77420 = state_77402__$1;
(statearr_77408_77420[(2)] = inst_77385);

(statearr_77408_77420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77403 === (5))){
var _ = (function (){var statearr_77409 = state_77402;
(statearr_77409[(4)] = cljs.core.rest((state_77402[(4)])));

return statearr_77409;
})();
var state_77402__$1 = state_77402;
var ex77406 = (state_77402__$1[(2)]);
var statearr_77410_77421 = state_77402__$1;
(statearr_77410_77421[(5)] = ex77406);


var statearr_77411_77422 = state_77402__$1;
(statearr_77411_77422[(1)] = (4));

(statearr_77411_77422[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77403 === (6))){
var inst_77394 = (state_77402[(2)]);
var inst_77395 = fluree.db.util.async.throw_err(inst_77394);
var inst_77396 = cljs.core.clj__GT_js(inst_77395);
var inst_77397 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77396) : resolve.call(null,inst_77396));
var _ = (function (){var statearr_77412 = state_77402;
(statearr_77412[(4)] = cljs.core.rest((state_77402[(4)])));

return statearr_77412;
})();
var state_77402__$1 = state_77402;
var statearr_77413_77423 = state_77402__$1;
(statearr_77413_77423[(2)] = inst_77397);

(statearr_77413_77423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2727__auto__ = null;
var flureedb$multi_query_$_state_machine__2727__auto____0 = (function (){
var statearr_77414 = [null,null,null,null,null,null,null,null];
(statearr_77414[(0)] = flureedb$multi_query_$_state_machine__2727__auto__);

(statearr_77414[(1)] = (1));

return statearr_77414;
});
var flureedb$multi_query_$_state_machine__2727__auto____1 = (function (state_77402){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77402);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77415){var ex__2730__auto__ = e77415;
var statearr_77416_77424 = state_77402;
(statearr_77416_77424[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77402[(4)]))){
var statearr_77417_77425 = state_77402;
(statearr_77417_77425[(1)] = cljs.core.first((state_77402[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77426 = state_77402;
state_77402 = G__77426;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2727__auto__ = function(state_77402){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2727__auto____1.call(this,state_77402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2727__auto____0;
flureedb$multi_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2727__auto____1;
return flureedb$multi_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77418 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77418[(6)] = c__2749__auto__);

return statearr_77418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77449){
var state_val_77450 = (state_77449[(1)]);
if((state_val_77450 === (1))){
var state_77449__$1 = state_77449;
var statearr_77451_77466 = state_77449__$1;
(statearr_77451_77466[(2)] = null);

(statearr_77451_77466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77450 === (2))){
var _ = (function (){var statearr_77452 = state_77449;
(statearr_77452[(4)] = cljs.core.cons((5),(state_77449[(4)])));

return statearr_77452;
})();
var inst_77439 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_77440 = fluree.db.api.query.query_async(sources,inst_77439);
var state_77449__$1 = state_77449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77449__$1,(6),inst_77440);
} else {
if((state_val_77450 === (3))){
var inst_77447 = (state_77449[(2)]);
var state_77449__$1 = state_77449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77449__$1,inst_77447);
} else {
if((state_val_77450 === (4))){
var inst_77427 = (state_77449[(2)]);
var inst_77428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77429 = [inst_77427];
var inst_77430 = (new cljs.core.PersistentVector(null,1,(5),inst_77428,inst_77429,null));
var inst_77431 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77430);
var inst_77432 = cljs.core.clj__GT_js(inst_77427);
var inst_77433 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77432) : reject.call(null,inst_77432));
var state_77449__$1 = (function (){var statearr_77454 = state_77449;
(statearr_77454[(7)] = inst_77431);

return statearr_77454;
})();
var statearr_77455_77467 = state_77449__$1;
(statearr_77455_77467[(2)] = inst_77433);

(statearr_77455_77467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77450 === (5))){
var _ = (function (){var statearr_77456 = state_77449;
(statearr_77456[(4)] = cljs.core.rest((state_77449[(4)])));

return statearr_77456;
})();
var state_77449__$1 = state_77449;
var ex77453 = (state_77449__$1[(2)]);
var statearr_77457_77468 = state_77449__$1;
(statearr_77457_77468[(5)] = ex77453);


var statearr_77458_77469 = state_77449__$1;
(statearr_77458_77469[(1)] = (4));

(statearr_77458_77469[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77450 === (6))){
var inst_77442 = (state_77449[(2)]);
var inst_77443 = cljs.core.clj__GT_js(inst_77442);
var inst_77444 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77443) : resolve.call(null,inst_77443));
var _ = (function (){var statearr_77459 = state_77449;
(statearr_77459[(4)] = cljs.core.rest((state_77449[(4)])));

return statearr_77459;
})();
var state_77449__$1 = state_77449;
var statearr_77460_77470 = state_77449__$1;
(statearr_77460_77470[(2)] = inst_77444);

(statearr_77460_77470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2727__auto__ = null;
var flureedb$query_$_state_machine__2727__auto____0 = (function (){
var statearr_77461 = [null,null,null,null,null,null,null,null];
(statearr_77461[(0)] = flureedb$query_$_state_machine__2727__auto__);

(statearr_77461[(1)] = (1));

return statearr_77461;
});
var flureedb$query_$_state_machine__2727__auto____1 = (function (state_77449){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77449);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77462){var ex__2730__auto__ = e77462;
var statearr_77463_77471 = state_77449;
(statearr_77463_77471[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77449[(4)]))){
var statearr_77464_77472 = state_77449;
(statearr_77464_77472[(1)] = cljs.core.first((state_77449[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77473 = state_77449;
state_77449 = G__77473;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2727__auto__ = function(state_77449){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2727__auto____1.call(this,state_77449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2727__auto____0;
flureedb$query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2727__auto____1;
return flureedb$query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77465 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77465[(6)] = c__2749__auto__);

return statearr_77465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__77475 = arguments.length;
switch (G__77475) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77505){
var state_val_77506 = (state_77505[(1)]);
if((state_val_77506 === (7))){
var inst_77492 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_77505__$1 = state_77505;
var statearr_77507_77528 = state_77505__$1;
(statearr_77507_77528[(2)] = inst_77492);

(statearr_77507_77528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (1))){
var state_77505__$1 = state_77505;
var statearr_77508_77529 = state_77505__$1;
(statearr_77508_77529[(2)] = null);

(statearr_77508_77529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (4))){
var inst_77476 = (state_77505[(2)]);
var inst_77477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77478 = [inst_77476];
var inst_77479 = (new cljs.core.PersistentVector(null,1,(5),inst_77477,inst_77478,null));
var inst_77480 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77479);
var inst_77481 = cljs.core.clj__GT_js(inst_77476);
var inst_77482 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77481) : reject.call(null,inst_77481));
var state_77505__$1 = (function (){var statearr_77509 = state_77505;
(statearr_77509[(7)] = inst_77480);

return statearr_77509;
})();
var statearr_77510_77530 = state_77505__$1;
(statearr_77510_77530[(2)] = inst_77482);

(statearr_77510_77530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (6))){
var state_77505__$1 = state_77505;
var statearr_77511_77531 = state_77505__$1;
(statearr_77511_77531[(2)] = null);

(statearr_77511_77531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (3))){
var inst_77503 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77505__$1,inst_77503);
} else {
if((state_val_77506 === (2))){
var _ = (function (){var statearr_77513 = state_77505;
(statearr_77513[(4)] = cljs.core.cons((5),(state_77505[(4)])));

return statearr_77513;
})();
var inst_77488 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_77489 = (opts == null);
var state_77505__$1 = (function (){var statearr_77514 = state_77505;
(statearr_77514[(8)] = inst_77488);

return statearr_77514;
})();
if(cljs.core.truth_(inst_77489)){
var statearr_77515_77532 = state_77505__$1;
(statearr_77515_77532[(1)] = (6));

} else {
var statearr_77516_77533 = state_77505__$1;
(statearr_77516_77533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (9))){
var inst_77497 = (state_77505[(2)]);
var inst_77498 = fluree.db.util.async.throw_err(inst_77497);
var inst_77499 = cljs.core.clj__GT_js(inst_77498);
var inst_77500 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77499) : resolve.call(null,inst_77499));
var _ = (function (){var statearr_77517 = state_77505;
(statearr_77517[(4)] = cljs.core.rest((state_77505[(4)])));

return statearr_77517;
})();
var state_77505__$1 = state_77505;
var statearr_77518_77534 = state_77505__$1;
(statearr_77518_77534[(2)] = inst_77500);

(statearr_77518_77534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (5))){
var _ = (function (){var statearr_77519 = state_77505;
(statearr_77519[(4)] = cljs.core.rest((state_77505[(4)])));

return statearr_77519;
})();
var state_77505__$1 = state_77505;
var ex77512 = (state_77505__$1[(2)]);
var statearr_77520_77535 = state_77505__$1;
(statearr_77520_77535[(5)] = ex77512);


var statearr_77521_77536 = state_77505__$1;
(statearr_77521_77536[(1)] = (4));

(statearr_77521_77536[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (8))){
var inst_77488 = (state_77505[(8)]);
var inst_77494 = (state_77505[(2)]);
var inst_77495 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_77488,inst_77494);
var state_77505__$1 = state_77505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77505__$1,(9),inst_77495);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2727__auto__ = null;
var flureedb$state_machine__2727__auto____0 = (function (){
var statearr_77522 = [null,null,null,null,null,null,null,null,null];
(statearr_77522[(0)] = flureedb$state_machine__2727__auto__);

(statearr_77522[(1)] = (1));

return statearr_77522;
});
var flureedb$state_machine__2727__auto____1 = (function (state_77505){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77505);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77523){var ex__2730__auto__ = e77523;
var statearr_77524_77537 = state_77505;
(statearr_77524_77537[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77505[(4)]))){
var statearr_77525_77538 = state_77505;
(statearr_77525_77538[(1)] = cljs.core.first((state_77505[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77539 = state_77505;
state_77505 = G__77539;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureedb$state_machine__2727__auto__ = function(state_77505){
switch(arguments.length){
case 0:
return flureedb$state_machine__2727__auto____0.call(this);
case 1:
return flureedb$state_machine__2727__auto____1.call(this,state_77505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2727__auto____0;
flureedb$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2727__auto____1;
return flureedb$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77526 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77526[(6)] = c__2749__auto__);

return statearr_77526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
