// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__76293 = arguments.length;
switch (G__76293) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___76332 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76314){
var state_val_76315 = (state_76314[(1)]);
if((state_val_76315 === (1))){
var state_76314__$1 = state_76314;
var statearr_76316_76333 = state_76314__$1;
(statearr_76316_76333[(2)] = null);

(statearr_76316_76333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76315 === (2))){
var _ = (function (){var statearr_76317 = state_76314;
(statearr_76317[(4)] = cljs.core.cons.call(null,(5),(state_76314[(4)])));

return statearr_76317;
})();
var inst_76300 = fluree.db.session.db.call(null,conn,ledger,null);
var state_76314__$1 = state_76314;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76314__$1,(7),inst_76300);
} else {
if((state_val_76315 === (3))){
var inst_76310 = (state_76314[(2)]);
var inst_76311 = cljs.core.async.put_BANG_.call(null,pc,inst_76310);
var inst_76312 = cljs.core.async.close_BANG_.call(null,pc);
var state_76314__$1 = (function (){var statearr_76319 = state_76314;
(statearr_76319[(7)] = inst_76311);

return statearr_76319;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76314__$1,inst_76312);
} else {
if((state_val_76315 === (4))){
var inst_76294 = (state_76314[(2)]);
var state_76314__$1 = state_76314;
var statearr_76320_76334 = state_76314__$1;
(statearr_76320_76334[(2)] = inst_76294);

(statearr_76320_76334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76315 === (5))){
var _ = (function (){var statearr_76321 = state_76314;
(statearr_76321[(4)] = cljs.core.rest.call(null,(state_76314[(4)])));

return statearr_76321;
})();
var state_76314__$1 = state_76314;
var ex76318 = (state_76314__$1[(2)]);
var statearr_76322_76335 = state_76314__$1;
(statearr_76322_76335[(5)] = ex76318);


var statearr_76323_76336 = state_76314__$1;
(statearr_76323_76336[(1)] = (4));

(statearr_76323_76336[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76315 === (6))){
var inst_76306 = (state_76314[(2)]);
var inst_76307 = fluree.db.util.async.throw_err.call(null,inst_76306);
var _ = (function (){var statearr_76324 = state_76314;
(statearr_76324[(4)] = cljs.core.rest.call(null,(state_76314[(4)])));

return statearr_76324;
})();
var state_76314__$1 = state_76314;
var statearr_76325_76337 = state_76314__$1;
(statearr_76325_76337[(2)] = inst_76307);

(statearr_76325_76337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76315 === (7))){
var inst_76302 = (state_76314[(2)]);
var inst_76303 = fluree.db.util.async.throw_err.call(null,inst_76302);
var inst_76304 = fluree.db.time_travel.as_of_block.call(null,inst_76303,block);
var state_76314__$1 = state_76314;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76314__$1,(6),inst_76304);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_76326 = [null,null,null,null,null,null,null,null];
(statearr_76326[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_76326[(1)] = (1));

return statearr_76326;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_76314){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76314);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76327){var ex__2749__auto__ = e76327;
var statearr_76328_76338 = state_76314;
(statearr_76328_76338[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76314[(4)]))){
var statearr_76329_76339 = state_76314;
(statearr_76329_76339[(1)] = cljs.core.first.call(null,(state_76314[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76340 = state_76314;
state_76314 = G__76340;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_76314){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_76314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76330 = f__2769__auto__.call(null);
(statearr_76330[(6)] = c__2768__auto___76332);

return statearr_76330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76381){
var state_val_76382 = (state_76381[(1)]);
if((state_val_76382 === (7))){
var inst_76350 = cljs.core._EQ_.call(null,(0),auth);
var state_76381__$1 = state_76381;
if(inst_76350){
var statearr_76383_76414 = state_76381__$1;
(statearr_76383_76414[(1)] = (9));

} else {
var statearr_76384_76415 = state_76381__$1;
(statearr_76384_76415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (1))){
var state_76381__$1 = state_76381;
var statearr_76385_76416 = state_76381__$1;
(statearr_76385_76416[(2)] = null);

(statearr_76385_76416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (4))){
var inst_76341 = (state_76381[(2)]);
var state_76381__$1 = state_76381;
var statearr_76386_76417 = state_76381__$1;
(statearr_76386_76417[(2)] = inst_76341);

(statearr_76386_76417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (15))){
var inst_76358 = (state_76381[(7)]);
var inst_76357 = (state_76381[(2)]);
var inst_76358__$1 = fluree.db.util.async.throw_err.call(null,inst_76357);
var state_76381__$1 = (function (){var statearr_76387 = state_76381;
(statearr_76387[(7)] = inst_76358__$1);

return statearr_76387;
})();
if(cljs.core.truth_(inst_76358__$1)){
var statearr_76388_76418 = state_76381__$1;
(statearr_76388_76418[(1)] = (16));

} else {
var statearr_76389_76419 = state_76381__$1;
(statearr_76389_76419[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (13))){
var state_76381__$1 = state_76381;
var statearr_76390_76420 = state_76381__$1;
(statearr_76390_76420[(2)] = null);

(statearr_76390_76420[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (6))){
var state_76381__$1 = state_76381;
var statearr_76391_76421 = state_76381__$1;
(statearr_76391_76421[(2)] = db);

(statearr_76391_76421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (17))){
var inst_76362 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_76363 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76364 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_76365 = cljs.core.PersistentHashMap.fromArrays(inst_76363,inst_76364);
var inst_76366 = cljs.core.ex_info.call(null,inst_76362,inst_76365);
var inst_76367 = (function(){throw inst_76366})();
var state_76381__$1 = state_76381;
var statearr_76392_76422 = state_76381__$1;
(statearr_76392_76422[(2)] = inst_76367);

(statearr_76392_76422[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (3))){
var inst_76379 = (state_76381[(2)]);
var state_76381__$1 = state_76381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76381__$1,inst_76379);
} else {
if((state_val_76382 === (12))){
var inst_76355 = fluree.db.dbproto._subid.call(null,db,auth);
var state_76381__$1 = state_76381;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76381__$1,(15),inst_76355);
} else {
if((state_val_76382 === (2))){
var _ = (function (){var statearr_76393 = state_76381;
(statearr_76393[(4)] = cljs.core.cons.call(null,(5),(state_76381[(4)])));

return statearr_76393;
})();
var inst_76347 = cljs.core.not.call(null,auth);
var state_76381__$1 = state_76381;
if(inst_76347){
var statearr_76394_76423 = state_76381__$1;
(statearr_76394_76423[(1)] = (6));

} else {
var statearr_76395_76424 = state_76381__$1;
(statearr_76395_76424[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (11))){
var inst_76374 = (state_76381[(2)]);
var state_76381__$1 = state_76381;
var statearr_76397_76425 = state_76381__$1;
(statearr_76397_76425[(2)] = inst_76374);

(statearr_76397_76425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (9))){
var inst_76352 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_76381__$1 = state_76381;
var statearr_76398_76426 = state_76381__$1;
(statearr_76398_76426[(2)] = inst_76352);

(statearr_76398_76426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (5))){
var _ = (function (){var statearr_76399 = state_76381;
(statearr_76399[(4)] = cljs.core.rest.call(null,(state_76381[(4)])));

return statearr_76399;
})();
var state_76381__$1 = state_76381;
var ex76396 = (state_76381__$1[(2)]);
var statearr_76400_76427 = state_76381__$1;
(statearr_76400_76427[(5)] = ex76396);


if((ex76396 instanceof Error)){
var statearr_76401_76428 = state_76381__$1;
(statearr_76401_76428[(1)] = (4));

(statearr_76401_76428[(5)] = null);

} else {
throw ex76396;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (14))){
var inst_76372 = (state_76381[(2)]);
var state_76381__$1 = state_76381;
var statearr_76402_76429 = state_76381__$1;
(statearr_76402_76429[(2)] = inst_76372);

(statearr_76402_76429[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (16))){
var inst_76358 = (state_76381[(7)]);
var inst_76360 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_76358);
var state_76381__$1 = state_76381;
var statearr_76403_76430 = state_76381__$1;
(statearr_76403_76430[(2)] = inst_76360);

(statearr_76403_76430[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (10))){
var state_76381__$1 = state_76381;
var statearr_76404_76431 = state_76381__$1;
(statearr_76404_76431[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (18))){
var inst_76369 = (state_76381[(2)]);
var state_76381__$1 = state_76381;
var statearr_76406_76432 = state_76381__$1;
(statearr_76406_76432[(2)] = inst_76369);

(statearr_76406_76432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76382 === (8))){
var inst_76376 = (state_76381[(2)]);
var _ = (function (){var statearr_76407 = state_76381;
(statearr_76407[(4)] = cljs.core.rest.call(null,(state_76381[(4)])));

return statearr_76407;
})();
var state_76381__$1 = state_76381;
var statearr_76408_76433 = state_76381__$1;
(statearr_76408_76433[(2)] = inst_76376);

(statearr_76408_76433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0 = (function (){
var statearr_76409 = [null,null,null,null,null,null,null,null];
(statearr_76409[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__);

(statearr_76409[(1)] = (1));

return statearr_76409;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1 = (function (state_76381){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76410){var ex__2749__auto__ = e76410;
var statearr_76411_76434 = state_76381;
(statearr_76411_76434[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76381[(4)]))){
var statearr_76412_76435 = state_76381;
(statearr_76412_76435[(1)] = cljs.core.first.call(null,(state_76381[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76436 = state_76381;
state_76381 = G__76436;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = function(state_76381){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1.call(this,state_76381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76413 = f__2769__auto__.call(null);
(statearr_76413[(6)] = c__2768__auto__);

return statearr_76413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76508){
var state_val_76509 = (state_76508[(1)]);
if((state_val_76509 === (7))){
var inst_76446 = cljs.core._EQ_.call(null,(0),auth);
var state_76508__$1 = state_76508;
if(inst_76446){
var statearr_76510_76564 = state_76508__$1;
(statearr_76510_76564[(1)] = (9));

} else {
var statearr_76511_76565 = state_76508__$1;
(statearr_76511_76565[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (20))){
var inst_76470 = (state_76508[(7)]);
var state_76508__$1 = state_76508;
if(cljs.core.truth_(inst_76470)){
var statearr_76512_76566 = state_76508__$1;
(statearr_76512_76566[(1)] = (22));

} else {
var statearr_76513_76567 = state_76508__$1;
(statearr_76513_76567[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (27))){
var state_76508__$1 = state_76508;
var statearr_76514_76568 = state_76508__$1;
(statearr_76514_76568[(2)] = null);

(statearr_76514_76568[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (1))){
var state_76508__$1 = state_76508;
var statearr_76515_76569 = state_76508__$1;
(statearr_76515_76569[(2)] = null);

(statearr_76515_76569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (24))){
var inst_76484 = (state_76508[(2)]);
var state_76508__$1 = state_76508;
var statearr_76516_76570 = state_76508__$1;
(statearr_76516_76570[(2)] = inst_76484);

(statearr_76516_76570[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (4))){
var inst_76437 = (state_76508[(2)]);
var state_76508__$1 = state_76508;
var statearr_76517_76571 = state_76508__$1;
(statearr_76517_76571[(2)] = inst_76437);

(statearr_76517_76571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (15))){
var inst_76453 = (state_76508[(8)]);
var inst_76452 = (state_76508[(2)]);
var inst_76453__$1 = fluree.db.util.async.throw_err.call(null,inst_76452);
var state_76508__$1 = (function (){var statearr_76518 = state_76508;
(statearr_76518[(8)] = inst_76453__$1);

return statearr_76518;
})();
if(cljs.core.truth_(inst_76453__$1)){
var statearr_76519_76572 = state_76508__$1;
(statearr_76519_76572[(1)] = (16));

} else {
var statearr_76520_76573 = state_76508__$1;
(statearr_76520_76573[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (21))){
var inst_76486 = (state_76508[(9)]);
var inst_76486__$1 = (state_76508[(2)]);
var state_76508__$1 = (function (){var statearr_76521 = state_76508;
(statearr_76521[(9)] = inst_76486__$1);

return statearr_76521;
})();
if(cljs.core.truth_(inst_76486__$1)){
var statearr_76522_76574 = state_76508__$1;
(statearr_76522_76574[(1)] = (29));

} else {
var statearr_76523_76575 = state_76508__$1;
(statearr_76523_76575[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (31))){
var inst_76486 = (state_76508[(9)]);
var inst_76494 = (state_76508[(2)]);
var state_76508__$1 = (function (){var statearr_76524 = state_76508;
(statearr_76524[(10)] = inst_76494);

return statearr_76524;
})();
if(cljs.core.truth_(inst_76486)){
var statearr_76525_76576 = state_76508__$1;
(statearr_76525_76576[(1)] = (33));

} else {
var statearr_76526_76577 = state_76508__$1;
(statearr_76526_76577[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (32))){
var inst_76490 = (state_76508[(2)]);
var inst_76491 = fluree.db.util.async.throw_err.call(null,inst_76490);
var state_76508__$1 = state_76508;
var statearr_76527_76578 = state_76508__$1;
(statearr_76527_76578[(2)] = inst_76491);

(statearr_76527_76578[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (33))){
var inst_76486 = (state_76508[(9)]);
var inst_76496 = fluree.db.permissions.permission_map.call(null,db,inst_76486,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_76508__$1 = state_76508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76508__$1,(36),inst_76496);
} else {
if((state_val_76509 === (13))){
var state_76508__$1 = state_76508;
var statearr_76528_76579 = state_76508__$1;
(statearr_76528_76579[(2)] = null);

(statearr_76528_76579[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (22))){
var inst_76470 = (state_76508[(7)]);
var inst_76474 = fluree.db.auth.roles.call(null,db,inst_76470);
var state_76508__$1 = state_76508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76508__$1,(25),inst_76474);
} else {
if((state_val_76509 === (36))){
var inst_76498 = (state_76508[(2)]);
var inst_76499 = fluree.db.util.async.throw_err.call(null,inst_76498);
var state_76508__$1 = state_76508;
var statearr_76529_76580 = state_76508__$1;
(statearr_76529_76580[(2)] = inst_76499);

(statearr_76529_76580[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (29))){
var inst_76470 = (state_76508[(7)]);
var inst_76486 = (state_76508[(9)]);
var inst_76488 = fluree.db.dbfunctions.ctx.build.call(null,db,inst_76470,inst_76486);
var state_76508__$1 = state_76508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76508__$1,(32),inst_76488);
} else {
if((state_val_76509 === (6))){
var state_76508__$1 = state_76508;
var statearr_76530_76581 = state_76508__$1;
(statearr_76530_76581[(2)] = null);

(statearr_76530_76581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (28))){
var inst_76482 = (state_76508[(2)]);
var state_76508__$1 = state_76508;
var statearr_76531_76582 = state_76508__$1;
(statearr_76531_76582[(2)] = inst_76482);

(statearr_76531_76582[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (25))){
var inst_76476 = (state_76508[(2)]);
var inst_76477 = fluree.db.util.async.throw_err.call(null,inst_76476);
var state_76508__$1 = state_76508;
var statearr_76532_76583 = state_76508__$1;
(statearr_76532_76583[(2)] = inst_76477);

(statearr_76532_76583[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (34))){
var state_76508__$1 = state_76508;
var statearr_76533_76584 = state_76508__$1;
(statearr_76533_76584[(2)] = null);

(statearr_76533_76584[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (17))){
var inst_76456 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_76457 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76458 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_76459 = cljs.core.PersistentHashMap.fromArrays(inst_76457,inst_76458);
var inst_76460 = cljs.core.ex_info.call(null,inst_76456,inst_76459);
var inst_76461 = (function(){throw inst_76460})();
var state_76508__$1 = state_76508;
var statearr_76534_76585 = state_76508__$1;
(statearr_76534_76585[(2)] = inst_76461);

(statearr_76534_76585[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (3))){
var inst_76506 = (state_76508[(2)]);
var state_76508__$1 = state_76508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76508__$1,inst_76506);
} else {
if((state_val_76509 === (12))){
var inst_76450 = fluree.db.dbproto._subid.call(null,db,auth);
var state_76508__$1 = state_76508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76508__$1,(15),inst_76450);
} else {
if((state_val_76509 === (2))){
var _ = (function (){var statearr_76535 = state_76508;
(statearr_76535[(4)] = cljs.core.cons.call(null,(5),(state_76508[(4)])));

return statearr_76535;
})();
var inst_76443 = (auth == null);
var state_76508__$1 = state_76508;
if(cljs.core.truth_(inst_76443)){
var statearr_76536_76586 = state_76508__$1;
(statearr_76536_76586[(1)] = (6));

} else {
var statearr_76537_76587 = state_76508__$1;
(statearr_76537_76587[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (23))){
var state_76508__$1 = state_76508;
var statearr_76538_76588 = state_76508__$1;
(statearr_76538_76588[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (35))){
var inst_76470 = (state_76508[(7)]);
var inst_76494 = (state_76508[(10)]);
var inst_76486 = (state_76508[(9)]);
var inst_76502 = (state_76508[(2)]);
var inst_76503 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_76470,new cljs.core.Keyword(null,"roles","roles",143379530),inst_76486,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_76502,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_76494);
var _ = (function (){var statearr_76540 = state_76508;
(statearr_76540[(4)] = cljs.core.rest.call(null,(state_76508[(4)])));

return statearr_76540;
})();
var state_76508__$1 = state_76508;
var statearr_76541_76589 = state_76508__$1;
(statearr_76541_76589[(2)] = inst_76503);

(statearr_76541_76589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (19))){
var state_76508__$1 = state_76508;
var statearr_76542_76590 = state_76508__$1;
(statearr_76542_76590[(2)] = roles);

(statearr_76542_76590[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (11))){
var inst_76468 = (state_76508[(2)]);
var state_76508__$1 = state_76508;
var statearr_76544_76591 = state_76508__$1;
(statearr_76544_76591[(2)] = inst_76468);

(statearr_76544_76591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (9))){
var state_76508__$1 = state_76508;
var statearr_76545_76592 = state_76508__$1;
(statearr_76545_76592[(2)] = (0));

(statearr_76545_76592[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (5))){
var _ = (function (){var statearr_76546 = state_76508;
(statearr_76546[(4)] = cljs.core.rest.call(null,(state_76508[(4)])));

return statearr_76546;
})();
var state_76508__$1 = state_76508;
var ex76543 = (state_76508__$1[(2)]);
var statearr_76547_76593 = state_76508__$1;
(statearr_76547_76593[(5)] = ex76543);


if((ex76543 instanceof Error)){
var statearr_76548_76594 = state_76508__$1;
(statearr_76548_76594[(1)] = (4));

(statearr_76548_76594[(5)] = null);

} else {
throw ex76543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (14))){
var inst_76466 = (state_76508[(2)]);
var state_76508__$1 = state_76508;
var statearr_76549_76595 = state_76508__$1;
(statearr_76549_76595[(2)] = inst_76466);

(statearr_76549_76595[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (26))){
var state_76508__$1 = state_76508;
var statearr_76550_76596 = state_76508__$1;
(statearr_76550_76596[(2)] = null);

(statearr_76550_76596[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (16))){
var inst_76453 = (state_76508[(8)]);
var state_76508__$1 = state_76508;
var statearr_76551_76597 = state_76508__$1;
(statearr_76551_76597[(2)] = inst_76453);

(statearr_76551_76597[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (30))){
var state_76508__$1 = state_76508;
var statearr_76552_76598 = state_76508__$1;
(statearr_76552_76598[(2)] = null);

(statearr_76552_76598[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (10))){
var state_76508__$1 = state_76508;
if(cljs.core.truth_(auth)){
var statearr_76553_76599 = state_76508__$1;
(statearr_76553_76599[(1)] = (12));

} else {
var statearr_76554_76600 = state_76508__$1;
(statearr_76554_76600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (18))){
var inst_76463 = (state_76508[(2)]);
var state_76508__$1 = state_76508;
var statearr_76555_76601 = state_76508__$1;
(statearr_76555_76601[(2)] = inst_76463);

(statearr_76555_76601[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76509 === (8))){
var inst_76470 = (state_76508[(2)]);
var state_76508__$1 = (function (){var statearr_76556 = state_76508;
(statearr_76556[(7)] = inst_76470);

return statearr_76556;
})();
if(cljs.core.truth_(roles)){
var statearr_76557_76602 = state_76508__$1;
(statearr_76557_76602[(1)] = (19));

} else {
var statearr_76558_76603 = state_76508__$1;
(statearr_76558_76603[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0 = (function (){
var statearr_76559 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_76559[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__);

(statearr_76559[(1)] = (1));

return statearr_76559;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1 = (function (state_76508){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76560){var ex__2749__auto__ = e76560;
var statearr_76561_76604 = state_76508;
(statearr_76561_76604[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76508[(4)]))){
var statearr_76562_76605 = state_76508;
(statearr_76562_76605[(1)] = cljs.core.first.call(null,(state_76508[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76606 = state_76508;
state_76508 = G__76606;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = function(state_76508){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1.call(this,state_76508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76563 = f__2769__auto__.call(null);
(statearr_76563[(6)] = c__2768__auto__);

return statearr_76563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__76607 = db;
var map__76607__$1 = cljs.core.__destructure_map.call(null,map__76607);
var conn = cljs.core.get.call(null,map__76607__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__76607__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__76607__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76614){
var state_val_76615 = (state_76614[(1)]);
if((state_val_76615 === (1))){
var inst_76608 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_76609 = fluree.db.session.db.call(null,conn,inst_76608,null);
var state_76614__$1 = state_76614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76614__$1,(2),inst_76609);
} else {
if((state_val_76615 === (2))){
var inst_76611 = (state_76614[(2)]);
var inst_76612 = cljs.core.async.put_BANG_.call(null,resp_port,inst_76611);
var state_76614__$1 = state_76614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76614__$1,inst_76612);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_76616 = [null,null,null,null,null,null,null];
(statearr_76616[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_76616[(1)] = (1));

return statearr_76616;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_76614){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76617){var ex__2749__auto__ = e76617;
var statearr_76618_76645 = state_76614;
(statearr_76618_76645[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76614[(4)]))){
var statearr_76619_76646 = state_76614;
(statearr_76619_76646[(1)] = cljs.core.first.call(null,(state_76614[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76647 = state_76614;
state_76614 = G__76647;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_76614){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_76614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76620 = f__2769__auto__.call(null);
(statearr_76620[(6)] = c__2768__auto__);

return statearr_76620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,ledger_id,listen_id,event_fn);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76633){
var state_val_76634 = (state_76633[(1)]);
if((state_val_76634 === (1))){
var inst_76621 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_76622 = fluree.db.session.db.call(null,conn,inst_76621,null);
var state_76633__$1 = state_76633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76633__$1,(2),inst_76622);
} else {
if((state_val_76634 === (2))){
var inst_76624 = (state_76633[(7)]);
var inst_76624__$1 = (state_76633[(2)]);
var inst_76625 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_76624__$1);
var inst_76626 = newer_block_QMARK_.call(null,inst_76625);
var state_76633__$1 = (function (){var statearr_76635 = state_76633;
(statearr_76635[(7)] = inst_76624__$1);

return statearr_76635;
})();
if(inst_76626){
var statearr_76636_76648 = state_76633__$1;
(statearr_76636_76648[(1)] = (3));

} else {
var statearr_76637_76649 = state_76633__$1;
(statearr_76637_76649[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76634 === (3))){
var inst_76624 = (state_76633[(7)]);
var inst_76628 = cljs.core.async.put_BANG_.call(null,resp_port,inst_76624);
var state_76633__$1 = state_76633;
var statearr_76638_76650 = state_76633__$1;
(statearr_76638_76650[(2)] = inst_76628);

(statearr_76638_76650[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76634 === (4))){
var state_76633__$1 = state_76633;
var statearr_76639_76651 = state_76633__$1;
(statearr_76639_76651[(2)] = null);

(statearr_76639_76651[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76634 === (5))){
var inst_76631 = (state_76633[(2)]);
var state_76633__$1 = state_76633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76633__$1,inst_76631);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_76640 = [null,null,null,null,null,null,null,null];
(statearr_76640[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_76640[(1)] = (1));

return statearr_76640;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_76633){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76641){var ex__2749__auto__ = e76641;
var statearr_76642_76652 = state_76633;
(statearr_76642_76652[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76633[(4)]))){
var statearr_76643_76653 = state_76633;
(statearr_76643_76653[(1)] = cljs.core.first.call(null,(state_76633[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76654 = state_76633;
state_76633 = G__76654;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_76633){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_76633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76644 = f__2769__auto__.call(null);
(statearr_76644[(6)] = c__2768__auto__);

return statearr_76644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__76655 = db;
var map__76655__$1 = cljs.core.__destructure_map.call(null,map__76655);
var conn = cljs.core.get.call(null,map__76655__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__76655__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__76655__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2768__auto___76731 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76705){
var state_val_76706 = (state_76705[(1)]);
if((state_val_76706 === (7))){
var inst_76671 = (state_76705[(7)]);
var inst_76682 = cljs.core._EQ_.call(null,inst_76671,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_76705__$1 = state_76705;
if(inst_76682){
var statearr_76707_76732 = state_76705__$1;
(statearr_76707_76732[(1)] = (9));

} else {
var statearr_76708_76733 = state_76705__$1;
(statearr_76708_76733[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (1))){
var inst_76656 = (state_76705[(8)]);
var inst_76664 = (state_76705[(9)]);
var inst_76656__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_76664__$1 = res_port;
var inst_76665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76666 = [inst_76656__$1,inst_76664__$1];
var inst_76667 = (new cljs.core.PersistentVector(null,2,(5),inst_76665,inst_76666,null));
var state_76705__$1 = (function (){var statearr_76709 = state_76705;
(statearr_76709[(8)] = inst_76656__$1);

(statearr_76709[(9)] = inst_76664__$1);

return statearr_76709;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_76705__$1,(2),inst_76667);
} else {
if((state_val_76706 === (4))){
var inst_76671 = (state_76705[(7)]);
var inst_76664 = (state_76705[(9)]);
var inst_76675 = cljs.core._EQ_.call(null,inst_76671,inst_76664);
var state_76705__$1 = state_76705;
if(inst_76675){
var statearr_76710_76734 = state_76705__$1;
(statearr_76710_76734[(1)] = (6));

} else {
var statearr_76711_76735 = state_76705__$1;
(statearr_76711_76735[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (13))){
var inst_76690 = (state_76705[(10)]);
var inst_76701 = cljs.core.async.put_BANG_.call(null,pc,inst_76690);
var state_76705__$1 = state_76705;
var statearr_76712_76736 = state_76705__$1;
(statearr_76712_76736[(2)] = inst_76701);

(statearr_76712_76736[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (6))){
var inst_76669 = (state_76705[(11)]);
var inst_76680 = cljs.core.nth.call(null,inst_76669,(0),null);
var state_76705__$1 = state_76705;
var statearr_76713_76737 = state_76705__$1;
(statearr_76713_76737[(2)] = inst_76680);

(statearr_76713_76737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (3))){
var state_76705__$1 = state_76705;
var statearr_76714_76738 = state_76705__$1;
(statearr_76714_76738[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_76714_76738[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (12))){
var inst_76694 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_76695 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76696 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_76697 = cljs.core.PersistentHashMap.fromArrays(inst_76695,inst_76696);
var inst_76698 = cljs.core.ex_info.call(null,inst_76694,inst_76697);
var inst_76699 = cljs.core.async.put_BANG_.call(null,pc,inst_76698);
var state_76705__$1 = state_76705;
var statearr_76715_76739 = state_76705__$1;
(statearr_76715_76739[(2)] = inst_76699);

(statearr_76715_76739[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (2))){
var inst_76656 = (state_76705[(8)]);
var inst_76669 = (state_76705[(11)]);
var inst_76671 = (state_76705[(7)]);
var inst_76669__$1 = (state_76705[(2)]);
var inst_76670 = cljs.core.nth.call(null,inst_76669__$1,(0),null);
var inst_76671__$1 = cljs.core.nth.call(null,inst_76669__$1,(1),null);
var inst_76672 = cljs.core._EQ_.call(null,inst_76671__$1,inst_76656);
var state_76705__$1 = (function (){var statearr_76716 = state_76705;
(statearr_76716[(11)] = inst_76669__$1);

(statearr_76716[(7)] = inst_76671__$1);

(statearr_76716[(12)] = inst_76670);

return statearr_76716;
})();
if(inst_76672){
var statearr_76717_76740 = state_76705__$1;
(statearr_76717_76740[(1)] = (3));

} else {
var statearr_76718_76741 = state_76705__$1;
(statearr_76718_76741[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (11))){
var inst_76686 = (state_76705[(2)]);
var state_76705__$1 = state_76705;
var statearr_76719_76742 = state_76705__$1;
(statearr_76719_76742[(2)] = inst_76686);

(statearr_76719_76742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (9))){
var inst_76670 = (state_76705[(12)]);
var state_76705__$1 = state_76705;
var statearr_76720_76743 = state_76705__$1;
(statearr_76720_76743[(2)] = inst_76670);

(statearr_76720_76743[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (5))){
var inst_76690 = (state_76705[(10)]);
var inst_76690__$1 = (state_76705[(2)]);
var inst_76691 = fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);
var inst_76692 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_76690__$1);
var state_76705__$1 = (function (){var statearr_76721 = state_76705;
(statearr_76721[(13)] = inst_76691);

(statearr_76721[(10)] = inst_76690__$1);

return statearr_76721;
})();
if(inst_76692){
var statearr_76722_76744 = state_76705__$1;
(statearr_76722_76744[(1)] = (12));

} else {
var statearr_76723_76745 = state_76705__$1;
(statearr_76723_76745[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (14))){
var inst_76703 = (state_76705[(2)]);
var state_76705__$1 = state_76705;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76705__$1,inst_76703);
} else {
if((state_val_76706 === (10))){
var state_76705__$1 = state_76705;
var statearr_76724_76746 = state_76705__$1;
(statearr_76724_76746[(2)] = null);

(statearr_76724_76746[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76706 === (8))){
var inst_76688 = (state_76705[(2)]);
var state_76705__$1 = state_76705;
var statearr_76725_76747 = state_76705__$1;
(statearr_76725_76747[(2)] = inst_76688);

(statearr_76725_76747[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0 = (function (){
var statearr_76726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76726[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__);

(statearr_76726[(1)] = (1));

return statearr_76726;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1 = (function (state_76705){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76727){var ex__2749__auto__ = e76727;
var statearr_76728_76748 = state_76705;
(statearr_76728_76748[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76705[(4)]))){
var statearr_76729_76749 = state_76705;
(statearr_76729_76749[(1)] = cljs.core.first.call(null,(state_76705[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76750 = state_76705;
state_76705 = G__76750;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = function(state_76705){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1.call(this,state_76705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76730 = f__2769__auto__.call(null);
(statearr_76730[(6)] = c__2768__auto___76731);

return statearr_76730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__76752 = arguments.length;
switch (G__76752) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__76753){
var map__76754 = p__76753;
var map__76754__$1 = cljs.core.__destructure_map.call(null,map__76754);
var opts = map__76754__$1;
var roles = cljs.core.get.call(null,map__76754__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__76754__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__76754__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__76754__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__76754__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2768__auto___76843 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76805){
var state_val_76806 = (state_76805[(1)]);
if((state_val_76806 === (7))){
var inst_76767 = (state_76805[(7)]);
var inst_76769 = fluree.db.api.ledger.syncTo_db.call(null,inst_76767,syncTo,syncTimeout);
var state_76805__$1 = state_76805;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76805__$1,(10),inst_76769);
} else {
if((state_val_76806 === (20))){
var inst_76791 = (state_76805[(8)]);
var state_76805__$1 = state_76805;
var statearr_76807_76844 = state_76805__$1;
(statearr_76807_76844[(2)] = inst_76791);

(statearr_76807_76844[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (1))){
var state_76805__$1 = state_76805;
var statearr_76808_76845 = state_76805__$1;
(statearr_76808_76845[(2)] = null);

(statearr_76808_76845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (4))){
var inst_76755 = (state_76805[(2)]);
var inst_76756 = cljs.core.async.put_BANG_.call(null,pc,inst_76755);
var inst_76757 = cljs.core.async.close_BANG_.call(null,pc);
var state_76805__$1 = (function (){var statearr_76809 = state_76805;
(statearr_76809[(9)] = inst_76756);

return statearr_76809;
})();
var statearr_76810_76846 = state_76805__$1;
(statearr_76810_76846[(2)] = inst_76757);

(statearr_76810_76846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (15))){
var inst_76783 = (state_76805[(10)]);
var inst_76785 = fluree.db.api.ledger.add_db_permissions.call(null,inst_76783,auth,roles);
var state_76805__$1 = state_76805;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76805__$1,(18),inst_76785);
} else {
if((state_val_76806 === (21))){
var inst_76799 = (state_76805[(2)]);
var inst_76800 = cljs.core.async.put_BANG_.call(null,pc,inst_76799);
var _ = (function (){var statearr_76811 = state_76805;
(statearr_76811[(4)] = cljs.core.rest.call(null,(state_76805[(4)])));

return statearr_76811;
})();
var state_76805__$1 = state_76805;
var statearr_76812_76847 = state_76805__$1;
(statearr_76812_76847[(2)] = inst_76800);

(statearr_76812_76847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (13))){
var inst_76783 = (state_76805[(2)]);
var state_76805__$1 = (function (){var statearr_76813 = state_76805;
(statearr_76813[(10)] = inst_76783);

return statearr_76813;
})();
if(cljs.core.truth_(roles)){
var statearr_76814_76848 = state_76805__$1;
(statearr_76814_76848[(1)] = (15));

} else {
var statearr_76815_76849 = state_76805__$1;
(statearr_76815_76849[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (22))){
var inst_76795 = (state_76805[(2)]);
var inst_76796 = fluree.db.util.async.throw_err.call(null,inst_76795);
var state_76805__$1 = state_76805;
var statearr_76816_76850 = state_76805__$1;
(statearr_76816_76850[(2)] = inst_76796);

(statearr_76816_76850[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (6))){
var inst_76766 = (state_76805[(2)]);
var inst_76767 = fluree.db.util.async.throw_err.call(null,inst_76766);
var state_76805__$1 = (function (){var statearr_76817 = state_76805;
(statearr_76817[(7)] = inst_76767);

return statearr_76817;
})();
if(cljs.core.truth_(syncTo)){
var statearr_76818_76851 = state_76805__$1;
(statearr_76818_76851[(1)] = (7));

} else {
var statearr_76819_76852 = state_76805__$1;
(statearr_76819_76852[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (17))){
var inst_76791 = (state_76805[(2)]);
var state_76805__$1 = (function (){var statearr_76820 = state_76805;
(statearr_76820[(8)] = inst_76791);

return statearr_76820;
})();
if(cljs.core.truth_(auth)){
var statearr_76821_76853 = state_76805__$1;
(statearr_76821_76853[(1)] = (19));

} else {
var statearr_76822_76854 = state_76805__$1;
(statearr_76822_76854[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (3))){
var inst_76803 = (state_76805[(2)]);
var state_76805__$1 = state_76805;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76805__$1,inst_76803);
} else {
if((state_val_76806 === (12))){
var inst_76775 = (state_76805[(11)]);
var state_76805__$1 = state_76805;
var statearr_76823_76855 = state_76805__$1;
(statearr_76823_76855[(2)] = inst_76775);

(statearr_76823_76855[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (2))){
var _ = (function (){var statearr_76824 = state_76805;
(statearr_76824[(4)] = cljs.core.cons.call(null,(5),(state_76805[(4)])));

return statearr_76824;
})();
var inst_76764 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_76805__$1 = state_76805;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76805__$1,(6),inst_76764);
} else {
if((state_val_76806 === (19))){
var inst_76791 = (state_76805[(8)]);
var inst_76793 = fluree.db.api.ledger.add_db_permissions.call(null,inst_76791,auth,roles);
var state_76805__$1 = state_76805;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76805__$1,(22),inst_76793);
} else {
if((state_val_76806 === (11))){
var inst_76775 = (state_76805[(11)]);
var inst_76777 = fluree.db.time_travel.as_of_block.call(null,inst_76775,block);
var state_76805__$1 = state_76805;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76805__$1,(14),inst_76777);
} else {
if((state_val_76806 === (9))){
var inst_76775 = (state_76805[(2)]);
var state_76805__$1 = (function (){var statearr_76826 = state_76805;
(statearr_76826[(11)] = inst_76775);

return statearr_76826;
})();
if(cljs.core.truth_(block)){
var statearr_76827_76856 = state_76805__$1;
(statearr_76827_76856[(1)] = (11));

} else {
var statearr_76828_76857 = state_76805__$1;
(statearr_76828_76857[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (5))){
var _ = (function (){var statearr_76829 = state_76805;
(statearr_76829[(4)] = cljs.core.rest.call(null,(state_76805[(4)])));

return statearr_76829;
})();
var state_76805__$1 = state_76805;
var ex76825 = (state_76805__$1[(2)]);
var statearr_76830_76858 = state_76805__$1;
(statearr_76830_76858[(5)] = ex76825);


var statearr_76831_76859 = state_76805__$1;
(statearr_76831_76859[(1)] = (4));

(statearr_76831_76859[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (14))){
var inst_76779 = (state_76805[(2)]);
var inst_76780 = fluree.db.util.async.throw_err.call(null,inst_76779);
var state_76805__$1 = state_76805;
var statearr_76832_76860 = state_76805__$1;
(statearr_76832_76860[(2)] = inst_76780);

(statearr_76832_76860[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (16))){
var inst_76783 = (state_76805[(10)]);
var state_76805__$1 = state_76805;
var statearr_76833_76861 = state_76805__$1;
(statearr_76833_76861[(2)] = inst_76783);

(statearr_76833_76861[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (10))){
var inst_76771 = (state_76805[(2)]);
var inst_76772 = fluree.db.util.async.throw_err.call(null,inst_76771);
var state_76805__$1 = state_76805;
var statearr_76834_76862 = state_76805__$1;
(statearr_76834_76862[(2)] = inst_76772);

(statearr_76834_76862[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (18))){
var inst_76787 = (state_76805[(2)]);
var inst_76788 = fluree.db.util.async.throw_err.call(null,inst_76787);
var state_76805__$1 = state_76805;
var statearr_76835_76863 = state_76805__$1;
(statearr_76835_76863[(2)] = inst_76788);

(statearr_76835_76863[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76806 === (8))){
var inst_76767 = (state_76805[(7)]);
var state_76805__$1 = state_76805;
var statearr_76836_76864 = state_76805__$1;
(statearr_76836_76864[(2)] = inst_76767);

(statearr_76836_76864[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_76837 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76837[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_76837[(1)] = (1));

return statearr_76837;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_76805){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76805);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e76838){var ex__2749__auto__ = e76838;
var statearr_76839_76865 = state_76805;
(statearr_76839_76865[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76805[(4)]))){
var statearr_76840_76866 = state_76805;
(statearr_76840_76866[(1)] = cljs.core.first.call(null,(state_76805[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76867 = state_76805;
state_76805 = G__76867;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_76805){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_76805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_76841 = f__2769__auto__.call(null);
(statearr_76841[(6)] = c__2768__auto___76843);

return statearr_76841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

