// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71776 = arguments.length;
var i__5770__auto___71777 = (0);
while(true){
if((i__5770__auto___71777 < len__5769__auto___71776)){
args__5775__auto__.push((arguments[i__5770__auto___71777]));

var G__71778 = (i__5770__auto___71777 + (1));
i__5770__auto___71777 = G__71778;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__71705){
var vec__71706 = p__71705;
var opts = cljs.core.nth.call(null,vec__71706,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___71779 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71753){
var state_val_71754 = (state_71753[(1)]);
if((state_val_71754 === (7))){
var inst_71730 = (state_71753[(7)]);
var inst_71739 = (state_71753[(8)]);
var inst_71741 = fluree.db.time_travel.as_of_block.call(null,inst_71739,inst_71730);
var state_71753__$1 = state_71753;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71753__$1,(10),inst_71741);
} else {
if((state_val_71754 === (1))){
var state_71753__$1 = state_71753;
var statearr_71755_71780 = state_71753__$1;
(statearr_71755_71780[(2)] = null);

(statearr_71755_71780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71754 === (4))){
var inst_71709 = (state_71753[(2)]);
var inst_71710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71711 = [inst_71709];
var inst_71712 = (new cljs.core.PersistentVector(null,1,(5),inst_71710,inst_71711,null));
var inst_71713 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71712);
var inst_71714 = cljs.core.async.put_BANG_.call(null,pc,inst_71709);
var inst_71715 = cljs.core.async.close_BANG_.call(null,pc);
var state_71753__$1 = (function (){var statearr_71756 = state_71753;
(statearr_71756[(9)] = inst_71714);

(statearr_71756[(10)] = inst_71713);

return statearr_71756;
})();
var statearr_71757_71781 = state_71753__$1;
(statearr_71757_71781[(2)] = inst_71715);

(statearr_71757_71781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71754 === (6))){
var inst_71733 = (state_71753[(11)]);
var inst_71734 = (state_71753[(12)]);
var inst_71730 = (state_71753[(7)]);
var inst_71737 = (state_71753[(2)]);
var inst_71738 = fluree.db.util.async.throw_err.call(null,inst_71737);
var inst_71739 = cljs.core.assoc.call(null,inst_71738,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_71733,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_71734);
var state_71753__$1 = (function (){var statearr_71758 = state_71753;
(statearr_71758[(8)] = inst_71739);

return statearr_71758;
})();
if(cljs.core.truth_(inst_71730)){
var statearr_71759_71782 = state_71753__$1;
(statearr_71759_71782[(1)] = (7));

} else {
var statearr_71760_71783 = state_71753__$1;
(statearr_71760_71783[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71754 === (3))){
var inst_71751 = (state_71753[(2)]);
var state_71753__$1 = state_71753;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71753__$1,inst_71751);
} else {
if((state_val_71754 === (2))){
var _ = (function (){var statearr_71762 = state_71753;
(statearr_71762[(4)] = cljs.core.cons.call(null,(5),(state_71753[(4)])));

return statearr_71762;
})();
var inst_71725 = opts;
var inst_71726 = cljs.core.__destructure_map.call(null,inst_71725);
var inst_71727 = cljs.core.get.call(null,inst_71726,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_71728 = cljs.core.get.call(null,inst_71726,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_71729 = cljs.core.get.call(null,inst_71726,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_71730 = cljs.core.get.call(null,inst_71726,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71731 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_71732 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_71733 = cljs.core.nth.call(null,inst_71732,(0),null);
var inst_71734 = cljs.core.nth.call(null,inst_71732,(1),null);
var inst_71735 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_71753__$1 = (function (){var statearr_71763 = state_71753;
(statearr_71763[(13)] = inst_71728);

(statearr_71763[(14)] = inst_71731);

(statearr_71763[(11)] = inst_71733);

(statearr_71763[(12)] = inst_71734);

(statearr_71763[(7)] = inst_71730);

(statearr_71763[(15)] = inst_71727);

(statearr_71763[(16)] = inst_71729);

return statearr_71763;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71753__$1,(6),inst_71735);
} else {
if((state_val_71754 === (9))){
var inst_71747 = (state_71753[(2)]);
var inst_71748 = cljs.core.async.put_BANG_.call(null,pc,inst_71747);
var _ = (function (){var statearr_71764 = state_71753;
(statearr_71764[(4)] = cljs.core.rest.call(null,(state_71753[(4)])));

return statearr_71764;
})();
var state_71753__$1 = state_71753;
var statearr_71765_71784 = state_71753__$1;
(statearr_71765_71784[(2)] = inst_71748);

(statearr_71765_71784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71754 === (5))){
var _ = (function (){var statearr_71766 = state_71753;
(statearr_71766[(4)] = cljs.core.rest.call(null,(state_71753[(4)])));

return statearr_71766;
})();
var state_71753__$1 = state_71753;
var ex71761 = (state_71753__$1[(2)]);
var statearr_71767_71785 = state_71753__$1;
(statearr_71767_71785[(5)] = ex71761);


var statearr_71768_71786 = state_71753__$1;
(statearr_71768_71786[(1)] = (4));

(statearr_71768_71786[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71754 === (10))){
var inst_71743 = (state_71753[(2)]);
var inst_71744 = fluree.db.util.async.throw_err.call(null,inst_71743);
var state_71753__$1 = state_71753;
var statearr_71769_71787 = state_71753__$1;
(statearr_71769_71787[(2)] = inst_71744);

(statearr_71769_71787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71754 === (8))){
var inst_71739 = (state_71753[(8)]);
var state_71753__$1 = state_71753;
var statearr_71770_71788 = state_71753__$1;
(statearr_71770_71788[(2)] = inst_71739);

(statearr_71770_71788[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71771 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71771[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71771[(1)] = (1));

return statearr_71771;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71753){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71753);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71772){var ex__2749__auto__ = e71772;
var statearr_71773_71789 = state_71753;
(statearr_71773_71789[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71753[(4)]))){
var statearr_71774_71790 = state_71753;
(statearr_71774_71790[(1)] = cljs.core.first.call(null,(state_71753[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71791 = state_71753;
state_71753 = G__71791;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71753){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71775 = f__2769__auto__.call(null);
(statearr_71775[(6)] = c__2768__auto___71779);

return statearr_71775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq71702){
var G__71703 = cljs.core.first.call(null,seq71702);
var seq71702__$1 = cljs.core.next.call(null,seq71702);
var G__71704 = cljs.core.first.call(null,seq71702__$1);
var seq71702__$2 = cljs.core.next.call(null,seq71702__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71703,G__71704,seq71702__$2);
}));

fluree.db.api_js.ledger_ident_QMARK_ = (function fluree$db$api_js$ledger_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__71793 = arguments.length;
switch (G__71793) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71922){
var state_val_71923 = (state_71922[(1)]);
if((state_val_71923 === (7))){
var inst_71822 = (state_71922[(7)]);
var inst_71812 = (state_71922[(8)]);
var inst_71824 = fluree.db.time_travel.as_of_block.call(null,inst_71822,inst_71812);
var state_71922__$1 = state_71922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71922__$1,(10),inst_71824);
} else {
if((state_val_71923 === (20))){
var inst_71816 = (state_71922[(9)]);
var state_71922__$1 = state_71922;
var statearr_71924_72004 = state_71922__$1;
(statearr_71924_72004[(2)] = inst_71816);

(statearr_71924_72004[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (27))){
var inst_71810 = (state_71922[(10)]);
var state_71922__$1 = state_71922;
var statearr_71925_72005 = state_71922__$1;
(statearr_71925_72005[(2)] = inst_71810);

(statearr_71925_72005[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (1))){
var state_71922__$1 = state_71922;
var statearr_71926_72006 = state_71922__$1;
(statearr_71926_72006[(2)] = null);

(statearr_71926_72006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (24))){
var inst_71819 = (state_71922[(11)]);
var state_71922__$1 = state_71922;
if(cljs.core.truth_(inst_71819)){
var statearr_71927_72007 = state_71922__$1;
(statearr_71927_72007[(1)] = (26));

} else {
var statearr_71928_72008 = state_71922__$1;
(statearr_71928_72008[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (39))){
var inst_71884 = (state_71922[(12)]);
var inst_71887 = cljs.core.ex_data.call(null,inst_71884);
var inst_71888 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71889 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_71887);
var inst_71890 = cljs.core.ex_message.call(null,inst_71884);
var inst_71891 = [inst_71889,inst_71890,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71892 = cljs.core.PersistentHashMap.fromArrays(inst_71888,inst_71891);
var state_71922__$1 = state_71922;
var statearr_71929_72009 = state_71922__$1;
(statearr_71929_72009[(2)] = inst_71892);

(statearr_71929_72009[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (46))){
var inst_71884 = (state_71922[(12)]);
var state_71922__$1 = state_71922;
var statearr_71930_72010 = state_71922__$1;
(statearr_71930_72010[(2)] = inst_71884);

(statearr_71930_72010[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (4))){
var inst_71794 = (state_71922[(2)]);
var inst_71795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71796 = [inst_71794];
var inst_71797 = (new cljs.core.PersistentVector(null,1,(5),inst_71795,inst_71796,null));
var inst_71798 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71797);
var inst_71799 = cljs.core.ex_data.call(null,inst_71794);
var inst_71800 = cljs.core.ex_message.call(null,inst_71794);
var inst_71801 = cljs.core.assoc.call(null,inst_71799,new cljs.core.Keyword(null,"message","message",-406056002),inst_71800);
var state_71922__$1 = (function (){var statearr_71931 = state_71922;
(statearr_71931[(13)] = inst_71798);

return statearr_71931;
})();
var statearr_71932_72011 = state_71922__$1;
(statearr_71932_72011[(2)] = inst_71801);

(statearr_71932_72011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (15))){
var state_71922__$1 = state_71922;
var statearr_71933_72012 = state_71922__$1;
(statearr_71933_72012[(2)] = (1000000));

(statearr_71933_72012[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (48))){
var inst_71884 = (state_71922[(12)]);
var state_71922__$1 = state_71922;
var statearr_71934_72013 = state_71922__$1;
(statearr_71934_72013[(2)] = inst_71884);

(statearr_71934_72013[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (50))){
var inst_71911 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
var statearr_71935_72014 = state_71922__$1;
(statearr_71935_72014[(2)] = inst_71911);

(statearr_71935_72014[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (21))){
var inst_71815 = (state_71922[(14)]);
var state_71922__$1 = state_71922;
if(cljs.core.truth_(inst_71815)){
var statearr_71936_72015 = state_71922__$1;
(statearr_71936_72015[(1)] = (23));

} else {
var statearr_71937_72016 = state_71922__$1;
(statearr_71937_72016[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (31))){
var inst_71873 = (state_71922[(2)]);
var inst_71874 = cljs.core.not.call(null,inst_71873);
var state_71922__$1 = state_71922;
if(inst_71874){
var statearr_71938_72017 = state_71922__$1;
(statearr_71938_72017[(1)] = (35));

} else {
var statearr_71939_72018 = state_71922__$1;
(statearr_71939_72018[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (32))){
var inst_71817 = (state_71922[(15)]);
var state_71922__$1 = state_71922;
var statearr_71940_72019 = state_71922__$1;
(statearr_71940_72019[(2)] = inst_71817);

(statearr_71940_72019[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (40))){
var inst_71847 = (state_71922[(16)]);
var state_71922__$1 = state_71922;
if(cljs.core.truth_(inst_71847)){
var statearr_71941_72020 = state_71922__$1;
(statearr_71941_72020[(1)] = (42));

} else {
var statearr_71942_72021 = state_71922__$1;
(statearr_71942_72021[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (33))){
var inst_71813 = (state_71922[(17)]);
var state_71922__$1 = state_71922;
var statearr_71943_72022 = state_71922__$1;
(statearr_71943_72022[(2)] = inst_71813);

(statearr_71943_72022[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (13))){
var inst_71842 = (state_71922[(18)]);
var inst_71818 = (state_71922[(19)]);
var inst_71840 = (state_71922[(2)]);
var inst_71841 = cljs.core.volatile_BANG_.call(null,(0));
var inst_71842__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71818);
var state_71922__$1 = (function (){var statearr_71944 = state_71922;
(statearr_71944[(20)] = inst_71841);

(statearr_71944[(18)] = inst_71842__$1);

(statearr_71944[(21)] = inst_71840);

return statearr_71944;
})();
if(cljs.core.truth_(inst_71842__$1)){
var statearr_71945_72023 = state_71922__$1;
(statearr_71945_72023[(1)] = (14));

} else {
var statearr_71946_72024 = state_71922__$1;
(statearr_71946_72024[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (22))){
var inst_71863 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
var statearr_71947_72025 = state_71922__$1;
(statearr_71947_72025[(2)] = inst_71863);

(statearr_71947_72025[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (36))){
var inst_71849 = (state_71922[(22)]);
var inst_71830 = (state_71922[(23)]);
var inst_71880 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71849);
var inst_71881 = fluree.db.query.fql.query.call(null,inst_71830,inst_71880);
var state_71922__$1 = state_71922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71922__$1,(38),inst_71881);
} else {
if((state_val_71923 === (41))){
var inst_71915 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
var statearr_71948_72026 = state_71922__$1;
(statearr_71948_72026[(2)] = inst_71915);

(statearr_71948_72026[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (43))){
var state_71922__$1 = state_71922;
var statearr_71949_72027 = state_71922__$1;
(statearr_71949_72027[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (29))){
var inst_71817 = (state_71922[(15)]);
var state_71922__$1 = state_71922;
if(cljs.core.truth_(inst_71817)){
var statearr_71951_72028 = state_71922__$1;
(statearr_71951_72028[(1)] = (32));

} else {
var statearr_71952_72029 = state_71922__$1;
(statearr_71952_72029[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (44))){
var inst_71913 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
var statearr_71953_72030 = state_71922__$1;
(statearr_71953_72030[(2)] = inst_71913);

(statearr_71953_72030[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (6))){
var inst_71812 = (state_71922[(8)]);
var inst_71821 = (state_71922[(2)]);
var inst_71822 = fluree.db.util.async.throw_err.call(null,inst_71821);
var state_71922__$1 = (function (){var statearr_71954 = state_71922;
(statearr_71954[(7)] = inst_71822);

return statearr_71954;
})();
if(cljs.core.truth_(inst_71812)){
var statearr_71955_72031 = state_71922__$1;
(statearr_71955_72031[(1)] = (7));

} else {
var statearr_71956_72032 = state_71922__$1;
(statearr_71956_72032[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (28))){
var inst_71859 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
var statearr_71957_72033 = state_71922__$1;
(statearr_71957_72033[(2)] = inst_71859);

(statearr_71957_72033[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (25))){
var inst_71861 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
var statearr_71958_72034 = state_71922__$1;
(statearr_71958_72034[(2)] = inst_71861);

(statearr_71958_72034[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (34))){
var inst_71870 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
var statearr_71959_72035 = state_71922__$1;
(statearr_71959_72035[(2)] = inst_71870);

(statearr_71959_72035[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (17))){
var inst_71811 = (state_71922[(24)]);
var state_71922__$1 = state_71922;
var statearr_71960_72036 = state_71922__$1;
(statearr_71960_72036[(2)] = inst_71811);

(statearr_71960_72036[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (3))){
var inst_71920 = (state_71922[(2)]);
var state_71922__$1 = state_71922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71922__$1,inst_71920);
} else {
if((state_val_71923 === (12))){
var inst_71838 = cljs.core.PersistentHashMap.EMPTY;
var state_71922__$1 = state_71922;
var statearr_71961_72037 = state_71922__$1;
(statearr_71961_72037[(2)] = inst_71838);

(statearr_71961_72037[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (2))){
var _ = (function (){var statearr_71962 = state_71922;
(statearr_71962[(4)] = cljs.core.cons.call(null,(5),(state_71922[(4)])));

return statearr_71962;
})();
var inst_71808 = query_map;
var inst_71809 = cljs.core.__destructure_map.call(null,inst_71808);
var inst_71810 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_71811 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_71812 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71813 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_71814 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_71815 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_71816 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_71817 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_71818 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71819 = cljs.core.get.call(null,inst_71809,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_71922__$1 = (function (){var statearr_71963 = state_71922;
(statearr_71963[(17)] = inst_71813);

(statearr_71963[(25)] = inst_71814);

(statearr_71963[(24)] = inst_71811);

(statearr_71963[(15)] = inst_71817);

(statearr_71963[(11)] = inst_71819);

(statearr_71963[(8)] = inst_71812);

(statearr_71963[(14)] = inst_71815);

(statearr_71963[(9)] = inst_71816);

(statearr_71963[(10)] = inst_71810);

(statearr_71963[(19)] = inst_71818);

return statearr_71963;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71922__$1,(6),sources);
} else {
if((state_val_71923 === (23))){
var inst_71815 = (state_71922[(14)]);
var state_71922__$1 = state_71922;
var statearr_71964_72038 = state_71922__$1;
(statearr_71964_72038[(2)] = inst_71815);

(statearr_71964_72038[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (47))){
var inst_71841 = (state_71922[(20)]);
var inst_71895 = (state_71922[(26)]);
var inst_71830 = (state_71922[(23)]);
var inst_71848 = (state_71922[(27)]);
var inst_71901 = (state_71922[(2)]);
var inst_71902 = cljs.core.deref.call(null,inst_71841);
var inst_71903 = fluree.db.util.core.response_time_formatted.call(null,inst_71848);
var inst_71904 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71830);
var inst_71905 = [(200),inst_71901,inst_71902,inst_71903,inst_71904];
var inst_71906 = cljs.core.PersistentHashMap.fromArrays(inst_71895,inst_71905);
var state_71922__$1 = state_71922;
var statearr_71965_72039 = state_71922__$1;
(statearr_71965_72039[(2)] = inst_71906);

(statearr_71965_72039[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (35))){
var inst_71876 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71877 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71878 = cljs.core.PersistentHashMap.fromArrays(inst_71876,inst_71877);
var state_71922__$1 = state_71922;
var statearr_71966_72040 = state_71922__$1;
(statearr_71966_72040[(2)] = inst_71878);

(statearr_71966_72040[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (19))){
var inst_71865 = (state_71922[(28)]);
var inst_71865__$1 = (state_71922[(2)]);
var state_71922__$1 = (function (){var statearr_71967 = state_71922;
(statearr_71967[(28)] = inst_71865__$1);

return statearr_71967;
})();
if(cljs.core.truth_(inst_71865__$1)){
var statearr_71968_72041 = state_71922__$1;
(statearr_71968_72041[(1)] = (29));

} else {
var statearr_71969_72042 = state_71922__$1;
(statearr_71969_72042[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (11))){
var inst_71814 = (state_71922[(25)]);
var inst_71830 = (state_71922[(23)]);
var inst_71831 = (state_71922[(29)]);
var inst_71833 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_71830);
var inst_71834 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_71831);
var inst_71835 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_71830);
var inst_71836 = fluree.db.api_js.get_sources.call(null,inst_71831,inst_71833,inst_71834,inst_71835,inst_71814,db_fn);
var state_71922__$1 = state_71922;
var statearr_71971_72043 = state_71922__$1;
(statearr_71971_72043[(2)] = inst_71836);

(statearr_71971_72043[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (9))){
var inst_71814 = (state_71922[(25)]);
var inst_71830 = (state_71922[(23)]);
var inst_71830__$1 = (state_71922[(2)]);
var inst_71831 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_71830__$1);
var state_71922__$1 = (function (){var statearr_71972 = state_71922;
(statearr_71972[(23)] = inst_71830__$1);

(statearr_71972[(29)] = inst_71831);

return statearr_71972;
})();
if(cljs.core.truth_(inst_71814)){
var statearr_71973_72044 = state_71922__$1;
(statearr_71973_72044[(1)] = (11));

} else {
var statearr_71974_72045 = state_71922__$1;
(statearr_71974_72045[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (5))){
var _ = (function (){var statearr_71975 = state_71922;
(statearr_71975[(4)] = cljs.core.rest.call(null,(state_71922[(4)])));

return statearr_71975;
})();
var state_71922__$1 = state_71922;
var ex71970 = (state_71922__$1[(2)]);
var statearr_71976_72046 = state_71922__$1;
(statearr_71976_72046[(5)] = ex71970);


var statearr_71977_72047 = state_71922__$1;
(statearr_71977_72047[(1)] = (4));

(statearr_71977_72047[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (14))){
var inst_71842 = (state_71922[(18)]);
var state_71922__$1 = state_71922;
var statearr_71978_72048 = state_71922__$1;
(statearr_71978_72048[(2)] = inst_71842);

(statearr_71978_72048[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (45))){
var inst_71884 = (state_71922[(12)]);
var inst_71898 = cljs.core.doall.call(null,inst_71884);
var state_71922__$1 = state_71922;
var statearr_71979_72049 = state_71922__$1;
(statearr_71979_72049[(2)] = inst_71898);

(statearr_71979_72049[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (26))){
var inst_71819 = (state_71922[(11)]);
var state_71922__$1 = state_71922;
var statearr_71980_72050 = state_71922__$1;
(statearr_71980_72050[(2)] = inst_71819);

(statearr_71980_72050[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (16))){
var inst_71811 = (state_71922[(24)]);
var inst_71841 = (state_71922[(20)]);
var inst_71840 = (state_71922[(21)]);
var inst_71818 = (state_71922[(19)]);
var inst_71846 = (state_71922[(2)]);
var inst_71847 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71818);
var inst_71848 = fluree.db.util.core.current_time_millis.call(null);
var inst_71849 = cljs.core.assoc.call(null,inst_71818,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_71840,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_71846,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71841);
var state_71922__$1 = (function (){var statearr_71981 = state_71922;
(statearr_71981[(16)] = inst_71847);

(statearr_71981[(22)] = inst_71849);

(statearr_71981[(27)] = inst_71848);

return statearr_71981;
})();
if(cljs.core.truth_(inst_71811)){
var statearr_71982_72051 = state_71922__$1;
(statearr_71982_72051[(1)] = (17));

} else {
var statearr_71983_72052 = state_71922__$1;
(statearr_71983_72052[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (38))){
var inst_71884 = (state_71922[(12)]);
var inst_71883 = (state_71922[(2)]);
var inst_71884__$1 = fluree.db.util.async.throw_err.call(null,inst_71883);
var inst_71885 = (inst_71884__$1 instanceof cljs.core.ExceptionInfo);
var state_71922__$1 = (function (){var statearr_71984 = state_71922;
(statearr_71984[(12)] = inst_71884__$1);

return statearr_71984;
})();
if(cljs.core.truth_(inst_71885)){
var statearr_71985_72053 = state_71922__$1;
(statearr_71985_72053[(1)] = (39));

} else {
var statearr_71986_72054 = state_71922__$1;
(statearr_71986_72054[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (30))){
var inst_71865 = (state_71922[(28)]);
var state_71922__$1 = state_71922;
var statearr_71987_72055 = state_71922__$1;
(statearr_71987_72055[(2)] = inst_71865);

(statearr_71987_72055[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (10))){
var inst_71826 = (state_71922[(2)]);
var inst_71827 = fluree.db.util.async.throw_err.call(null,inst_71826);
var state_71922__$1 = state_71922;
var statearr_71988_72056 = state_71922__$1;
(statearr_71988_72056[(2)] = inst_71827);

(statearr_71988_72056[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (18))){
var inst_71816 = (state_71922[(9)]);
var state_71922__$1 = state_71922;
if(cljs.core.truth_(inst_71816)){
var statearr_71989_72057 = state_71922__$1;
(statearr_71989_72057[(1)] = (20));

} else {
var statearr_71990_72058 = state_71922__$1;
(statearr_71990_72058[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (42))){
var inst_71884 = (state_71922[(12)]);
var inst_71895 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71896 = cljs.core.sequential_QMARK_.call(null,inst_71884);
var state_71922__$1 = (function (){var statearr_71991 = state_71922;
(statearr_71991[(26)] = inst_71895);

return statearr_71991;
})();
if(inst_71896){
var statearr_71992_72059 = state_71922__$1;
(statearr_71992_72059[(1)] = (45));

} else {
var statearr_71993_72060 = state_71922__$1;
(statearr_71993_72060[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (37))){
var inst_71917 = (state_71922[(2)]);
var _ = (function (){var statearr_71994 = state_71922;
(statearr_71994[(4)] = cljs.core.rest.call(null,(state_71922[(4)])));

return statearr_71994;
})();
var state_71922__$1 = state_71922;
var statearr_71995_72061 = state_71922__$1;
(statearr_71995_72061[(2)] = inst_71917);

(statearr_71995_72061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (8))){
var inst_71822 = (state_71922[(7)]);
var state_71922__$1 = state_71922;
var statearr_71996_72062 = state_71922__$1;
(statearr_71996_72062[(2)] = inst_71822);

(statearr_71996_72062[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71923 === (49))){
var state_71922__$1 = state_71922;
var statearr_71997_72063 = state_71922__$1;
(statearr_71997_72063[(2)] = null);

(statearr_71997_72063[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71998[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71998[(1)] = (1));

return statearr_71998;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71922){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71999){var ex__2749__auto__ = e71999;
var statearr_72000_72064 = state_71922;
(statearr_72000_72064[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71922[(4)]))){
var statearr_72001_72065 = state_71922;
(statearr_72001_72065[(1)] = cljs.core.first.call(null,(state_71922[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72066 = state_71922;
state_71922 = G__72066;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71922){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72002 = f__2769__auto__.call(null);
(statearr_72002[(6)] = c__2768__auto__);

return statearr_72002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__72067_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__72067_SHARP_);
}));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72089){
var state_val_72090 = (state_72089[(1)]);
if((state_val_72090 === (1))){
var inst_72071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72072 = [resp_chan,timeout_chan];
var inst_72073 = (new cljs.core.PersistentVector(null,2,(5),inst_72071,inst_72072,null));
var state_72089__$1 = state_72089;
return cljs.core.async.ioc_alts_BANG_.call(null,state_72089__$1,(2),inst_72073);
} else {
if((state_val_72090 === (2))){
var inst_72075 = (state_72089[(2)]);
var inst_72076 = cljs.core.nth.call(null,inst_72075,(0),null);
var inst_72077 = cljs.core.nth.call(null,inst_72075,(1),null);
var inst_72078 = cljs.core._EQ_.call(null,timeout_chan,inst_72077);
var state_72089__$1 = (function (){var statearr_72091 = state_72089;
(statearr_72091[(7)] = inst_72076);

return statearr_72091;
})();
if(inst_72078){
var statearr_72092_72102 = state_72089__$1;
(statearr_72092_72102[(1)] = (3));

} else {
var statearr_72093_72103 = state_72089__$1;
(statearr_72093_72103[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72090 === (3))){
var inst_72080 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_72081 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_72082 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_72083 = [tid,(408),inst_72082];
var inst_72084 = cljs.core.PersistentHashMap.fromArrays(inst_72081,inst_72083);
var state_72089__$1 = (function (){var statearr_72094 = state_72089;
(statearr_72094[(8)] = inst_72080);

return statearr_72094;
})();
var statearr_72095_72104 = state_72089__$1;
(statearr_72095_72104[(2)] = inst_72084);

(statearr_72095_72104[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72090 === (4))){
var inst_72076 = (state_72089[(7)]);
var state_72089__$1 = state_72089;
var statearr_72096_72105 = state_72089__$1;
(statearr_72096_72105[(2)] = inst_72076);

(statearr_72096_72105[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72090 === (5))){
var inst_72087 = (state_72089[(2)]);
var state_72089__$1 = state_72089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72089__$1,inst_72087);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0 = (function (){
var statearr_72097 = [null,null,null,null,null,null,null,null,null];
(statearr_72097[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__);

(statearr_72097[(1)] = (1));

return statearr_72097;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1 = (function (state_72089){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72098){var ex__2749__auto__ = e72098;
var statearr_72099_72106 = state_72089;
(statearr_72099_72106[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72089[(4)]))){
var statearr_72100_72107 = state_72089;
(statearr_72100_72107[(1)] = cljs.core.first.call(null,(state_72089[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72108 = state_72089;
state_72089 = G__72108;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = function(state_72089){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1.call(this,state_72089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72101 = f__2769__auto__.call(null);
(statearr_72101[(6)] = c__2768__auto__);

return statearr_72101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__72110 = arguments.length;
switch (G__72110) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__72111 = opts;
var map__72111__$1 = cljs.core.__destructure_map.call(null,map__72111);
var auth = cljs.core.get.call(null,map__72111__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__72111__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__72111__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__72111__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__72112 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__72112,(0),null);
var authority = cljs.core.nth.call(null,vec__72112,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e72115){var e = e72115;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__72118 = arguments.length;
switch (G__72118) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72187){
var state_val_72188 = (state_72187[(1)]);
if((state_val_72188 === (7))){
var inst_72142 = (state_72187[(7)]);
var inst_72141 = (state_72187[(8)]);
var inst_72140 = (state_72187[(9)]);
var inst_72138 = (state_72187[(10)]);
var inst_72143 = (state_72187[(11)]);
var inst_72156 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_72157 = [ledger,txn,inst_72138,inst_72140,inst_72141,inst_72142,inst_72143];
var inst_72158 = cljs.core.PersistentHashMap.fromArrays(inst_72156,inst_72157);
var inst_72159 = fluree.db.util.core.without_nils.call(null,inst_72158);
var inst_72160 = fluree.db.operations.transact_async.call(null,conn,inst_72159);
var state_72187__$1 = state_72187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72187__$1,(13),inst_72160);
} else {
if((state_val_72188 === (20))){
var inst_72178 = (state_72187[(2)]);
var state_72187__$1 = state_72187;
var statearr_72189_72225 = state_72187__$1;
(statearr_72189_72225[(2)] = inst_72178);

(statearr_72189_72225[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (1))){
var state_72187__$1 = state_72187;
var statearr_72190_72226 = state_72187__$1;
(statearr_72190_72226[(2)] = null);

(statearr_72190_72226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (4))){
var inst_72119 = (state_72187[(2)]);
var inst_72120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72121 = [inst_72119];
var inst_72122 = (new cljs.core.PersistentVector(null,1,(5),inst_72120,inst_72121,null));
var inst_72123 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72122);
var inst_72124 = cljs.core.ex_data.call(null,inst_72119);
var inst_72125 = cljs.core.ex_message.call(null,inst_72119);
var inst_72126 = cljs.core.assoc.call(null,inst_72124,new cljs.core.Keyword(null,"message","message",-406056002),inst_72125);
var state_72187__$1 = (function (){var statearr_72191 = state_72187;
(statearr_72191[(12)] = inst_72123);

return statearr_72191;
})();
var statearr_72192_72227 = state_72187__$1;
(statearr_72192_72227[(2)] = inst_72126);

(statearr_72192_72227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (15))){
var inst_72137 = (state_72187[(13)]);
var inst_72162 = (state_72187[(14)]);
var inst_72165 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_72162,inst_72137);
var state_72187__$1 = state_72187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72187__$1,(17),inst_72165);
} else {
if((state_val_72188 === (13))){
var inst_72136 = (state_72187[(15)]);
var inst_72162 = (state_72187[(2)]);
var state_72187__$1 = (function (){var statearr_72193 = state_72187;
(statearr_72193[(14)] = inst_72162);

return statearr_72193;
})();
if(cljs.core.truth_(inst_72136)){
var statearr_72194_72228 = state_72187__$1;
(statearr_72194_72228[(1)] = (14));

} else {
var statearr_72195_72229 = state_72187__$1;
(statearr_72195_72229[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (6))){
var inst_72136 = (state_72187[(15)]);
var inst_72135 = (state_72187[(16)]);
var inst_72145 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_72135,opts);
var inst_72146 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_72145);
var inst_72147 = fluree.db.operations.command_async.call(null,conn,inst_72145);
var state_72187__$1 = (function (){var statearr_72196 = state_72187;
(statearr_72196[(17)] = inst_72146);

(statearr_72196[(18)] = inst_72147);

return statearr_72196;
})();
if(cljs.core.truth_(inst_72136)){
var statearr_72197_72230 = state_72187__$1;
(statearr_72197_72230[(1)] = (9));

} else {
var statearr_72198_72231 = state_72187__$1;
(statearr_72198_72231[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (17))){
var inst_72167 = (state_72187[(19)]);
var inst_72167__$1 = (state_72187[(2)]);
var inst_72168 = (inst_72167__$1 instanceof cljs.core.ExceptionInfo);
var state_72187__$1 = (function (){var statearr_72199 = state_72187;
(statearr_72199[(19)] = inst_72167__$1);

return statearr_72199;
})();
if(cljs.core.truth_(inst_72168)){
var statearr_72200_72232 = state_72187__$1;
(statearr_72200_72232[(1)] = (18));

} else {
var statearr_72201_72233 = state_72187__$1;
(statearr_72201_72233[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (3))){
var inst_72185 = (state_72187[(2)]);
var state_72187__$1 = state_72187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72187__$1,inst_72185);
} else {
if((state_val_72188 === (12))){
var inst_72152 = (state_72187[(2)]);
var state_72187__$1 = state_72187;
var statearr_72202_72234 = state_72187__$1;
(statearr_72202_72234[(2)] = inst_72152);

(statearr_72202_72234[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (2))){
var inst_72135 = (state_72187[(16)]);
var _ = (function (){var statearr_72203 = state_72187;
(statearr_72203[(4)] = cljs.core.cons.call(null,(5),(state_72187[(4)])));

return statearr_72203;
})();
var inst_72133 = opts;
var inst_72134 = cljs.core.__destructure_map.call(null,inst_72133);
var inst_72135__$1 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_72136 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_72137 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_72138 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72139 = fluree.db.util.core.current_time_millis.call(null);
var inst_72140 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_72139);
var inst_72141 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_72142 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_72143 = cljs.core.get.call(null,inst_72134,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_72187__$1 = (function (){var statearr_72204 = state_72187;
(statearr_72204[(13)] = inst_72137);

(statearr_72204[(7)] = inst_72142);

(statearr_72204[(8)] = inst_72141);

(statearr_72204[(9)] = inst_72140);

(statearr_72204[(15)] = inst_72136);

(statearr_72204[(16)] = inst_72135__$1);

(statearr_72204[(10)] = inst_72138);

(statearr_72204[(11)] = inst_72143);

return statearr_72204;
})();
if(cljs.core.truth_(inst_72135__$1)){
var statearr_72205_72235 = state_72187__$1;
(statearr_72205_72235[(1)] = (6));

} else {
var statearr_72206_72236 = state_72187__$1;
(statearr_72206_72236[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (19))){
var inst_72167 = (state_72187[(19)]);
var state_72187__$1 = state_72187;
var statearr_72207_72237 = state_72187__$1;
(statearr_72207_72237[(2)] = inst_72167);

(statearr_72207_72237[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (11))){
var inst_72154 = (state_72187[(2)]);
var state_72187__$1 = state_72187;
var statearr_72209_72238 = state_72187__$1;
(statearr_72209_72238[(2)] = inst_72154);

(statearr_72209_72238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (9))){
var inst_72147 = (state_72187[(18)]);
var state_72187__$1 = state_72187;
var statearr_72210_72239 = state_72187__$1;
(statearr_72210_72239[(2)] = inst_72147);

(statearr_72210_72239[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (5))){
var _ = (function (){var statearr_72211 = state_72187;
(statearr_72211[(4)] = cljs.core.rest.call(null,(state_72187[(4)])));

return statearr_72211;
})();
var state_72187__$1 = state_72187;
var ex72208 = (state_72187__$1[(2)]);
var statearr_72212_72240 = state_72187__$1;
(statearr_72212_72240[(5)] = ex72208);


var statearr_72213_72241 = state_72187__$1;
(statearr_72213_72241[(1)] = (4));

(statearr_72213_72241[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (14))){
var inst_72162 = (state_72187[(14)]);
var state_72187__$1 = state_72187;
var statearr_72214_72242 = state_72187__$1;
(statearr_72214_72242[(2)] = inst_72162);

(statearr_72214_72242[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (16))){
var inst_72180 = (state_72187[(2)]);
var state_72187__$1 = state_72187;
var statearr_72215_72243 = state_72187__$1;
(statearr_72215_72243[(2)] = inst_72180);

(statearr_72215_72243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (10))){
var inst_72137 = (state_72187[(13)]);
var inst_72146 = (state_72187[(17)]);
var inst_72150 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_72146,inst_72137);
var state_72187__$1 = state_72187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72187__$1,(12),inst_72150);
} else {
if((state_val_72188 === (18))){
var inst_72167 = (state_72187[(19)]);
var inst_72170 = cljs.core.ex_data.call(null,inst_72167);
var inst_72171 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72172 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72170);
var inst_72173 = cljs.core.ex_message.call(null,inst_72167);
var inst_72174 = [inst_72172,inst_72173,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_72175 = cljs.core.PersistentHashMap.fromArrays(inst_72171,inst_72174);
var state_72187__$1 = state_72187;
var statearr_72216_72244 = state_72187__$1;
(statearr_72216_72244[(2)] = inst_72175);

(statearr_72216_72244[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72188 === (8))){
var inst_72182 = (state_72187[(2)]);
var _ = (function (){var statearr_72217 = state_72187;
(statearr_72217[(4)] = cljs.core.rest.call(null,(state_72187[(4)])));

return statearr_72217;
})();
var state_72187__$1 = state_72187;
var statearr_72218_72245 = state_72187__$1;
(statearr_72218_72245[(2)] = inst_72182);

(statearr_72218_72245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_72219 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72219[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_72219[(1)] = (1));

return statearr_72219;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_72187){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72220){var ex__2749__auto__ = e72220;
var statearr_72221_72246 = state_72187;
(statearr_72221_72246[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72187[(4)]))){
var statearr_72222_72247 = state_72187;
(statearr_72222_72247[(1)] = cljs.core.first.call(null,(state_72187[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72248 = state_72187;
state_72187 = G__72248;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_72187){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_72187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72223 = f__2769__auto__.call(null);
(statearr_72223[(6)] = c__2768__auto__);

return statearr_72223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___72250 = arguments.length;
var i__5770__auto___72251 = (0);
while(true){
if((i__5770__auto___72251 < len__5769__auto___72250)){
args__5775__auto__.push((arguments[i__5770__auto___72251]));

var G__72252 = (i__5770__auto___72251 + (1));
i__5770__auto___72251 = G__72252;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq72249){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq72249));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72283){
var state_val_72284 = (state_72283[(1)]);
if((state_val_72284 === (1))){
var inst_72253 = cljs.core.first.call(null,flakes);
var inst_72254 = cljs.core.rest.call(null,flakes);
var inst_72255 = cljs.core.PersistentVector.EMPTY;
var inst_72256 = inst_72253;
var inst_72257 = inst_72254;
var inst_72258 = inst_72255;
var state_72283__$1 = (function (){var statearr_72285 = state_72283;
(statearr_72285[(7)] = inst_72257);

(statearr_72285[(8)] = inst_72258);

(statearr_72285[(9)] = inst_72256);

return statearr_72285;
})();
var statearr_72286_72299 = state_72283__$1;
(statearr_72286_72299[(2)] = null);

(statearr_72286_72299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72284 === (2))){
var inst_72256 = (state_72283[(9)]);
var inst_72260 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_72261 = cljs.core.PersistentHashMap.EMPTY;
var inst_72262 = [true,inst_72261];
var inst_72263 = cljs.core.PersistentHashMap.fromArrays(inst_72260,inst_72262);
var inst_72264 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_72263,inst_72256);
var state_72283__$1 = state_72283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72283__$1,(4),inst_72264);
} else {
if((state_val_72284 === (3))){
var inst_72281 = (state_72283[(2)]);
var state_72283__$1 = state_72283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72283__$1,inst_72281);
} else {
if((state_val_72284 === (4))){
var inst_72257 = (state_72283[(7)]);
var inst_72258 = (state_72283[(8)]);
var inst_72266 = (state_72283[(2)]);
var inst_72267 = fluree.db.util.async.throw_err.call(null,inst_72266);
var inst_72268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72269 = [inst_72267];
var inst_72270 = (new cljs.core.PersistentVector(null,1,(5),inst_72268,inst_72269,null));
var inst_72271 = cljs.core.concat.call(null,inst_72258,inst_72270);
var inst_72272 = cljs.core.first.call(null,inst_72257);
var state_72283__$1 = (function (){var statearr_72287 = state_72283;
(statearr_72287[(10)] = inst_72271);

return statearr_72287;
})();
if(cljs.core.truth_(inst_72272)){
var statearr_72288_72300 = state_72283__$1;
(statearr_72288_72300[(1)] = (5));

} else {
var statearr_72289_72301 = state_72283__$1;
(statearr_72289_72301[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72284 === (5))){
var inst_72257 = (state_72283[(7)]);
var inst_72271 = (state_72283[(10)]);
var inst_72274 = cljs.core.first.call(null,inst_72257);
var inst_72275 = cljs.core.rest.call(null,inst_72257);
var inst_72256 = inst_72274;
var inst_72257__$1 = inst_72275;
var inst_72258 = inst_72271;
var state_72283__$1 = (function (){var statearr_72290 = state_72283;
(statearr_72290[(7)] = inst_72257__$1);

(statearr_72290[(8)] = inst_72258);

(statearr_72290[(9)] = inst_72256);

return statearr_72290;
})();
var statearr_72291_72302 = state_72283__$1;
(statearr_72291_72302[(2)] = null);

(statearr_72291_72302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72284 === (6))){
var inst_72271 = (state_72283[(10)]);
var state_72283__$1 = state_72283;
var statearr_72292_72303 = state_72283__$1;
(statearr_72292_72303[(2)] = inst_72271);

(statearr_72292_72303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72284 === (7))){
var inst_72279 = (state_72283[(2)]);
var state_72283__$1 = state_72283;
var statearr_72293_72304 = state_72283__$1;
(statearr_72293_72304[(2)] = inst_72279);

(statearr_72293_72304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_72294 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72294[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__);

(statearr_72294[(1)] = (1));

return statearr_72294;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1 = (function (state_72283){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72295){var ex__2749__auto__ = e72295;
var statearr_72296_72305 = state_72283;
(statearr_72296_72305[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72283[(4)]))){
var statearr_72297_72306 = state_72283;
(statearr_72297_72306[(1)] = cljs.core.first.call(null,(state_72283[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72307 = state_72283;
state_72283 = G__72307;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = function(state_72283){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1.call(this,state_72283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72298 = f__2769__auto__.call(null);
(statearr_72298[(6)] = c__2768__auto__);

return statearr_72298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72375){
var state_val_72376 = (state_72375[(1)]);
if((state_val_72376 === (7))){
var inst_72335 = (state_72375[(2)]);
var inst_72336 = fluree.db.util.async.throw_err.call(null,inst_72335);
var state_72375__$1 = state_72375;
var statearr_72377_72403 = state_72375__$1;
(statearr_72377_72403[(2)] = inst_72336);

(statearr_72377_72403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (1))){
var inst_72312 = cljs.core.volatile_BANG_.call(null,(0));
var inst_72313 = cljs.core.PersistentHashMap.EMPTY;
var inst_72314 = cljs.core.volatile_BANG_.call(null,inst_72313);
var inst_72315 = cljs.core.first.call(null,resp);
var inst_72316 = cljs.core.rest.call(null,resp);
var inst_72317 = cljs.core.PersistentVector.EMPTY;
var inst_72318 = inst_72312;
var inst_72319 = inst_72314;
var inst_72320 = inst_72315;
var inst_72321 = inst_72316;
var inst_72322 = inst_72317;
var state_72375__$1 = (function (){var statearr_72378 = state_72375;
(statearr_72378[(7)] = inst_72319);

(statearr_72378[(8)] = inst_72321);

(statearr_72378[(9)] = inst_72320);

(statearr_72378[(10)] = inst_72318);

(statearr_72378[(11)] = inst_72322);

return statearr_72378;
})();
var statearr_72379_72404 = state_72375__$1;
(statearr_72379_72404[(2)] = null);

(statearr_72379_72404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (4))){
var inst_72319 = (state_72375[(7)]);
var inst_72321 = (state_72375[(8)]);
var inst_72320 = (state_72375[(9)]);
var inst_72318 = (state_72375[(10)]);
var inst_72326 = (state_72375[(12)]);
var inst_72324 = (state_72375[(13)]);
var inst_72322 = (state_72375[(11)]);
var inst_72330 = (function (){var fuel = inst_72318;
var cache = inst_72319;
var curr_block = inst_72320;
var rest_blocks = inst_72321;
var acc = inst_72322;
var flakes = inst_72324;
var asserted = inst_72326;
return (function (p1__72309_SHARP_){
return p1__72309_SHARP_.s;
});
})();
var inst_72331 = cljs.core.group_by.call(null,inst_72330,inst_72326);
var inst_72332 = cljs.core.vals.call(null,inst_72331);
var inst_72333 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_72319,inst_72318,inst_72332);
var state_72375__$1 = state_72375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72375__$1,(7),inst_72333);
} else {
if((state_val_72376 === (13))){
var inst_72363 = (state_72375[(14)]);
var state_72375__$1 = state_72375;
var statearr_72380_72405 = state_72375__$1;
(statearr_72380_72405[(2)] = inst_72363);

(statearr_72380_72405[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (6))){
var inst_72339 = (state_72375[(15)]);
var inst_72319 = (state_72375[(7)]);
var inst_72321 = (state_72375[(8)]);
var inst_72341 = (state_72375[(16)]);
var inst_72320 = (state_72375[(9)]);
var inst_72318 = (state_72375[(10)]);
var inst_72326 = (state_72375[(12)]);
var inst_72324 = (state_72375[(13)]);
var inst_72322 = (state_72375[(11)]);
var inst_72339__$1 = (state_72375[(2)]);
var inst_72340 = (function (){var fuel = inst_72318;
var cache = inst_72319;
var curr_block = inst_72320;
var rest_blocks = inst_72321;
var acc = inst_72322;
var flakes = inst_72324;
var asserted = inst_72326;
var asserted_SINGLEQUOTE_ = inst_72339__$1;
return (function (p1__72310_SHARP_){
return p1__72310_SHARP_.op === false;
});
})();
var inst_72341__$1 = cljs.core.filter.call(null,inst_72340,inst_72324);
var inst_72342 = cljs.core.empty_QMARK_.call(null,inst_72341__$1);
var inst_72343 = (!(inst_72342));
var state_72375__$1 = (function (){var statearr_72383 = state_72375;
(statearr_72383[(15)] = inst_72339__$1);

(statearr_72383[(16)] = inst_72341__$1);

return statearr_72383;
})();
if(inst_72343){
var statearr_72384_72406 = state_72375__$1;
(statearr_72384_72406[(1)] = (8));

} else {
var statearr_72385_72407 = state_72375__$1;
(statearr_72385_72407[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (3))){
var inst_72373 = (state_72375[(2)]);
var state_72375__$1 = state_72375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72375__$1,inst_72373);
} else {
if((state_val_72376 === (12))){
var inst_72319 = (state_72375[(7)]);
var inst_72363 = (state_72375[(14)]);
var inst_72321 = (state_72375[(8)]);
var inst_72318 = (state_72375[(10)]);
var inst_72366 = cljs.core.first.call(null,inst_72321);
var inst_72367 = cljs.core.rest.call(null,inst_72321);
var tmp72381 = inst_72319;
var tmp72382 = inst_72318;
var inst_72318__$1 = tmp72382;
var inst_72319__$1 = tmp72381;
var inst_72320 = inst_72366;
var inst_72321__$1 = inst_72367;
var inst_72322 = inst_72363;
var state_72375__$1 = (function (){var statearr_72386 = state_72375;
(statearr_72386[(7)] = inst_72319__$1);

(statearr_72386[(8)] = inst_72321__$1);

(statearr_72386[(9)] = inst_72320);

(statearr_72386[(10)] = inst_72318__$1);

(statearr_72386[(11)] = inst_72322);

return statearr_72386;
})();
var statearr_72387_72408 = state_72375__$1;
(statearr_72387_72408[(2)] = null);

(statearr_72387_72408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (2))){
var inst_72319 = (state_72375[(7)]);
var inst_72321 = (state_72375[(8)]);
var inst_72320 = (state_72375[(9)]);
var inst_72318 = (state_72375[(10)]);
var inst_72326 = (state_72375[(12)]);
var inst_72324 = (state_72375[(13)]);
var inst_72322 = (state_72375[(11)]);
var inst_72324__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_72320);
var inst_72325 = (function (){var fuel = inst_72318;
var cache = inst_72319;
var curr_block = inst_72320;
var rest_blocks = inst_72321;
var acc = inst_72322;
var flakes = inst_72324__$1;
return (function (p1__72308_SHARP_){
return p1__72308_SHARP_.op;
});
})();
var inst_72326__$1 = cljs.core.filter.call(null,inst_72325,inst_72324__$1);
var inst_72327 = cljs.core.empty_QMARK_.call(null,inst_72326__$1);
var inst_72328 = (!(inst_72327));
var state_72375__$1 = (function (){var statearr_72388 = state_72375;
(statearr_72388[(12)] = inst_72326__$1);

(statearr_72388[(13)] = inst_72324__$1);

return statearr_72388;
})();
if(inst_72328){
var statearr_72389_72409 = state_72375__$1;
(statearr_72389_72409[(1)] = (4));

} else {
var statearr_72390_72410 = state_72375__$1;
(statearr_72390_72410[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (11))){
var inst_72351 = (state_72375[(2)]);
var inst_72352 = fluree.db.util.async.throw_err.call(null,inst_72351);
var state_72375__$1 = state_72375;
var statearr_72391_72411 = state_72375__$1;
(statearr_72391_72411[(2)] = inst_72352);

(statearr_72391_72411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (9))){
var state_72375__$1 = state_72375;
var statearr_72392_72412 = state_72375__$1;
(statearr_72392_72412[(2)] = null);

(statearr_72392_72412[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (5))){
var state_72375__$1 = state_72375;
var statearr_72393_72413 = state_72375__$1;
(statearr_72393_72413[(2)] = null);

(statearr_72393_72413[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (14))){
var inst_72371 = (state_72375[(2)]);
var state_72375__$1 = state_72375;
var statearr_72394_72414 = state_72375__$1;
(statearr_72394_72414[(2)] = inst_72371);

(statearr_72394_72414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (10))){
var inst_72339 = (state_72375[(15)]);
var inst_72321 = (state_72375[(8)]);
var inst_72320 = (state_72375[(9)]);
var inst_72322 = (state_72375[(11)]);
var inst_72355 = (state_72375[(2)]);
var inst_72356 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_72357 = [inst_72339,inst_72355];
var inst_72358 = cljs.core.PersistentHashMap.fromArrays(inst_72356,inst_72357);
var inst_72359 = cljs.core.assoc.call(null,inst_72320,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_72358);
var inst_72360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72361 = [inst_72359];
var inst_72362 = (new cljs.core.PersistentVector(null,1,(5),inst_72360,inst_72361,null));
var inst_72363 = cljs.core.concat.call(null,inst_72322,inst_72362);
var inst_72364 = cljs.core.first.call(null,inst_72321);
var state_72375__$1 = (function (){var statearr_72395 = state_72375;
(statearr_72395[(14)] = inst_72363);

return statearr_72395;
})();
if(cljs.core.truth_(inst_72364)){
var statearr_72396_72415 = state_72375__$1;
(statearr_72396_72415[(1)] = (12));

} else {
var statearr_72397_72416 = state_72375__$1;
(statearr_72397_72416[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72376 === (8))){
var inst_72339 = (state_72375[(15)]);
var inst_72319 = (state_72375[(7)]);
var inst_72321 = (state_72375[(8)]);
var inst_72341 = (state_72375[(16)]);
var inst_72320 = (state_72375[(9)]);
var inst_72318 = (state_72375[(10)]);
var inst_72326 = (state_72375[(12)]);
var inst_72324 = (state_72375[(13)]);
var inst_72322 = (state_72375[(11)]);
var inst_72345 = (function (){var flakes = inst_72324;
var rest_blocks = inst_72321;
var curr_block = inst_72320;
var asserted_SINGLEQUOTE_ = inst_72339;
var acc = inst_72322;
var fuel = inst_72318;
var cache = inst_72319;
var retracted = inst_72341;
var asserted = inst_72326;
return (function (p1__72311_SHARP_){
return p1__72311_SHARP_.s;
});
})();
var inst_72346 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_72341);
var inst_72347 = cljs.core.group_by.call(null,inst_72345,inst_72346);
var inst_72348 = cljs.core.vals.call(null,inst_72347);
var inst_72349 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_72319,inst_72318,inst_72348);
var state_72375__$1 = state_72375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72375__$1,(11),inst_72349);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_72398 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72398[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_72398[(1)] = (1));

return statearr_72398;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_72375){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72399){var ex__2749__auto__ = e72399;
var statearr_72400_72417 = state_72375;
(statearr_72400_72417[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72375[(4)]))){
var statearr_72401_72418 = state_72375;
(statearr_72401_72418[(1)] = cljs.core.first.call(null,(state_72375[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72419 = state_72375;
state_72375 = G__72419;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_72375){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_72375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72402 = f__2769__auto__.call(null);
(statearr_72402[(6)] = c__2768__auto__);

return statearr_72402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72519){
var state_val_72520 = (state_72519[(1)]);
if((state_val_72520 === (7))){
var inst_72484 = (state_72519[(7)]);
var inst_72491 = (state_72519[(8)]);
var inst_72490 = cljs.core.seq.call(null,inst_72484);
var inst_72491__$1 = cljs.core.first.call(null,inst_72490);
var inst_72492 = cljs.core.next.call(null,inst_72490);
var state_72519__$1 = (function (){var statearr_72521 = state_72519;
(statearr_72521[(9)] = inst_72492);

(statearr_72521[(8)] = inst_72491__$1);

return statearr_72521;
})();
if(cljs.core.truth_(inst_72491__$1)){
var statearr_72522_72559 = state_72519__$1;
(statearr_72522_72559[(1)] = (9));

} else {
var statearr_72523_72560 = state_72519__$1;
(statearr_72523_72560[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (1))){
var state_72519__$1 = state_72519;
var statearr_72524_72561 = state_72519__$1;
(statearr_72524_72561[(2)] = null);

(statearr_72524_72561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (4))){
var inst_72421 = (state_72519[(2)]);
var state_72519__$1 = state_72519;
var statearr_72525_72562 = state_72519__$1;
(statearr_72525_72562[(2)] = inst_72421);

(statearr_72525_72562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (6))){
var inst_72470 = (state_72519[(2)]);
var inst_72471 = fluree.db.util.async.throw_err.call(null,inst_72470);
var inst_72479 = resp;
var inst_72480 = cljs.core.seq.call(null,inst_72479);
var inst_72481 = cljs.core.first.call(null,inst_72480);
var inst_72482 = cljs.core.next.call(null,inst_72480);
var inst_72483 = cljs.core.PersistentHashMap.EMPTY;
var inst_72484 = inst_72479;
var inst_72485 = inst_72483;
var state_72519__$1 = (function (){var statearr_72526 = state_72519;
(statearr_72526[(10)] = inst_72471);

(statearr_72526[(11)] = inst_72485);

(statearr_72526[(7)] = inst_72484);

(statearr_72526[(12)] = inst_72482);

(statearr_72526[(13)] = inst_72481);

return statearr_72526;
})();
var statearr_72527_72563 = state_72519__$1;
(statearr_72527_72563[(2)] = null);

(statearr_72527_72563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (3))){
var inst_72517 = (state_72519[(2)]);
var state_72519__$1 = state_72519;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72519__$1,inst_72517);
} else {
if((state_val_72520 === (2))){
var _ = (function (){var statearr_72528 = state_72519;
(statearr_72528[(4)] = cljs.core.cons.call(null,(5),(state_72519[(4)])));

return statearr_72528;
})();
var inst_72427 = (function (){return (function (p1__72420_SHARP_){
return p1__72420_SHARP_.t;
});
})();
var inst_72428 = cljs.core.map.call(null,inst_72427,resp);
var inst_72429 = cljs.core.set.call(null,inst_72428);
var inst_72466 = cljs.core.async.chan.call(null,(1));
var inst_72467 = (function (){var ts = inst_72429;
var c__2768__auto____$1 = inst_72466;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72464){
var state_val_72465 = (state_72464[(1)]);
if((state_val_72465 === (1))){
var inst_72437 = ts;
var inst_72438 = cljs.core.seq.call(null,inst_72437);
var inst_72439 = cljs.core.first.call(null,inst_72438);
var inst_72440 = cljs.core.next.call(null,inst_72438);
var inst_72441 = cljs.core.PersistentHashMap.EMPTY;
var inst_72442 = inst_72437;
var inst_72443 = inst_72441;
var state_72464__$1 = (function (){var statearr_72529 = state_72464;
(statearr_72529[(7)] = inst_72439);

(statearr_72529[(8)] = inst_72440);

(statearr_72529[(9)] = inst_72442);

(statearr_72529[(10)] = inst_72443);

return statearr_72529;
})();
var statearr_72530_72564 = state_72464__$1;
(statearr_72530_72564[(2)] = null);

(statearr_72530_72564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72465 === (2))){
var inst_72449 = (state_72464[(11)]);
var inst_72442 = (state_72464[(9)]);
var inst_72448 = cljs.core.seq.call(null,inst_72442);
var inst_72449__$1 = cljs.core.first.call(null,inst_72448);
var inst_72450 = cljs.core.next.call(null,inst_72448);
var state_72464__$1 = (function (){var statearr_72531 = state_72464;
(statearr_72531[(11)] = inst_72449__$1);

(statearr_72531[(12)] = inst_72450);

return statearr_72531;
})();
if(cljs.core.truth_(inst_72449__$1)){
var statearr_72532_72565 = state_72464__$1;
(statearr_72532_72565[(1)] = (4));

} else {
var statearr_72533_72566 = state_72464__$1;
(statearr_72533_72566[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72465 === (3))){
var inst_72462 = (state_72464[(2)]);
var state_72464__$1 = state_72464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72464__$1,inst_72462);
} else {
if((state_val_72465 === (4))){
var inst_72449 = (state_72464[(11)]);
var inst_72452 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_72449);
var state_72464__$1 = state_72464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72464__$1,(7),inst_72452);
} else {
if((state_val_72465 === (5))){
var inst_72443 = (state_72464[(10)]);
var state_72464__$1 = state_72464;
var statearr_72534_72567 = state_72464__$1;
(statearr_72534_72567[(2)] = inst_72443);

(statearr_72534_72567[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72465 === (6))){
var inst_72460 = (state_72464[(2)]);
var state_72464__$1 = state_72464;
var statearr_72535_72568 = state_72464__$1;
(statearr_72535_72568[(2)] = inst_72460);

(statearr_72535_72568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72465 === (7))){
var inst_72449 = (state_72464[(11)]);
var inst_72450 = (state_72464[(12)]);
var inst_72443 = (state_72464[(10)]);
var inst_72454 = (state_72464[(2)]);
var inst_72455 = fluree.db.util.async.throw_err.call(null,inst_72454);
var inst_72456 = cljs.core.assoc.call(null,inst_72443,inst_72449,inst_72455);
var inst_72442 = inst_72450;
var inst_72443__$1 = inst_72456;
var state_72464__$1 = (function (){var statearr_72536 = state_72464;
(statearr_72536[(9)] = inst_72442);

(statearr_72536[(10)] = inst_72443__$1);

return statearr_72536;
})();
var statearr_72537_72569 = state_72464__$1;
(statearr_72537_72569[(2)] = null);

(statearr_72537_72569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_72538 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72538[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_72538[(1)] = (1));

return statearr_72538;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_72464){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72539){var ex__2749__auto__ = e72539;
var statearr_72540_72570 = state_72464;
(statearr_72540_72570[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72464[(4)]))){
var statearr_72541_72571 = state_72464;
(statearr_72541_72571[(1)] = cljs.core.first.call(null,(state_72464[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72572 = state_72464;
state_72464 = G__72572;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_72464){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_72464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72542 = f__2769__auto__.call(null);
(statearr_72542[(6)] = c__2768__auto____$1);

return statearr_72542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_72468 = cljs.core.async.impl.dispatch.run.call(null,inst_72467);
var state_72519__$1 = (function (){var statearr_72543 = state_72519;
(statearr_72543[(14)] = inst_72468);

return statearr_72543;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72519__$1,(6),inst_72466);
} else {
if((state_val_72520 === (11))){
var inst_72511 = (state_72519[(2)]);
var state_72519__$1 = state_72519;
var statearr_72545_72573 = state_72519__$1;
(statearr_72545_72573[(2)] = inst_72511);

(statearr_72545_72573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (9))){
var inst_72471 = (state_72519[(10)]);
var inst_72492 = (state_72519[(9)]);
var inst_72485 = (state_72519[(11)]);
var inst_72491 = (state_72519[(8)]);
var inst_72494 = inst_72491.t;
var inst_72495 = cljs.core.get.call(null,inst_72471,inst_72494);
var inst_72496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72497 = [inst_72495,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72498 = (new cljs.core.PersistentVector(null,2,(5),inst_72496,inst_72497,null));
var inst_72499 = cljs.core.assoc_in.call(null,inst_72485,inst_72498,inst_72495);
var inst_72500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72501 = [inst_72495,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_72502 = (new cljs.core.PersistentVector(null,2,(5),inst_72500,inst_72501,null));
var inst_72503 = cljs.core.update_in.call(null,inst_72499,inst_72502,cljs.core.conj,inst_72491);
var inst_72504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72505 = [inst_72495,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_72506 = (new cljs.core.PersistentVector(null,2,(5),inst_72504,inst_72505,null));
var inst_72507 = cljs.core.update_in.call(null,inst_72503,inst_72506,fluree.db.api_js.min_safe,inst_72494);
var inst_72484 = inst_72492;
var inst_72485__$1 = inst_72507;
var state_72519__$1 = (function (){var statearr_72546 = state_72519;
(statearr_72546[(11)] = inst_72485__$1);

(statearr_72546[(7)] = inst_72484);

return statearr_72546;
})();
var statearr_72547_72574 = state_72519__$1;
(statearr_72547_72574[(2)] = null);

(statearr_72547_72574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (5))){
var _ = (function (){var statearr_72548 = state_72519;
(statearr_72548[(4)] = cljs.core.rest.call(null,(state_72519[(4)])));

return statearr_72548;
})();
var state_72519__$1 = state_72519;
var ex72544 = (state_72519__$1[(2)]);
var statearr_72549_72575 = state_72519__$1;
(statearr_72549_72575[(5)] = ex72544);


if((ex72544 instanceof Error)){
var statearr_72550_72576 = state_72519__$1;
(statearr_72550_72576[(1)] = (4));

(statearr_72550_72576[(5)] = null);

} else {
throw ex72544;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (10))){
var inst_72485 = (state_72519[(11)]);
var state_72519__$1 = state_72519;
var statearr_72551_72577 = state_72519__$1;
(statearr_72551_72577[(2)] = inst_72485);

(statearr_72551_72577[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72520 === (8))){
var inst_72513 = (state_72519[(2)]);
var inst_72514 = cljs.core.vals.call(null,inst_72513);
var _ = (function (){var statearr_72552 = state_72519;
(statearr_72552[(4)] = cljs.core.rest.call(null,(state_72519[(4)])));

return statearr_72552;
})();
var state_72519__$1 = state_72519;
var statearr_72553_72578 = state_72519__$1;
(statearr_72553_72578[(2)] = inst_72514);

(statearr_72553_72578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_72554 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72554[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_72554[(1)] = (1));

return statearr_72554;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_72519){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72519);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72555){var ex__2749__auto__ = e72555;
var statearr_72556_72579 = state_72519;
(statearr_72556_72579[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72519[(4)]))){
var statearr_72557_72580 = state_72519;
(statearr_72557_72580[(1)] = cljs.core.first.call(null,(state_72519[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72581 = state_72519;
state_72519 = G__72581;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_72519){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_72519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72558 = f__2769__auto__.call(null);
(statearr_72558[(6)] = c__2768__auto__);

return statearr_72558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72729){
var state_val_72730 = (state_72729[(1)]);
if((state_val_72730 === (7))){
var inst_72609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72610 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_72611 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_72612 = [inst_72610,inst_72611];
var inst_72613 = (new cljs.core.PersistentVector(null,2,(5),inst_72609,inst_72612,null));
var state_72729__$1 = state_72729;
var statearr_72731_72802 = state_72729__$1;
(statearr_72731_72802[(2)] = inst_72613);

(statearr_72731_72802[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (20))){
var inst_72639 = (state_72729[(7)]);
var state_72729__$1 = state_72729;
var statearr_72732_72803 = state_72729__$1;
(statearr_72732_72803[(2)] = inst_72639);

(statearr_72732_72803[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (27))){
var state_72729__$1 = state_72729;
var statearr_72733_72804 = state_72729__$1;
(statearr_72733_72804[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (1))){
var state_72729__$1 = state_72729;
var statearr_72735_72805 = state_72729__$1;
(statearr_72735_72805[(2)] = null);

(statearr_72735_72805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (24))){
var inst_72638 = (state_72729[(8)]);
var state_72729__$1 = state_72729;
if(cljs.core.truth_(inst_72638)){
var statearr_72736_72806 = state_72729__$1;
(statearr_72736_72806[(1)] = (26));

} else {
var statearr_72737_72807 = state_72729__$1;
(statearr_72737_72807[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (39))){
var inst_72685 = (state_72729[(9)]);
var inst_72684 = (state_72729[(10)]);
var inst_72710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72711 = [inst_72684,inst_72685];
var inst_72712 = (new cljs.core.PersistentVector(null,2,(5),inst_72710,inst_72711,null));
var state_72729__$1 = state_72729;
var statearr_72738_72808 = state_72729__$1;
(statearr_72738_72808[(2)] = inst_72712);

(statearr_72738_72808[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (4))){
var inst_72582 = (state_72729[(2)]);
var inst_72583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72584 = [inst_72582];
var inst_72585 = (new cljs.core.PersistentVector(null,1,(5),inst_72583,inst_72584,null));
var inst_72586 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72585);
var inst_72587 = cljs.core.ex_data.call(null,inst_72582);
var inst_72588 = cljs.core.ex_message.call(null,inst_72582);
var inst_72589 = cljs.core.assoc.call(null,inst_72587,new cljs.core.Keyword(null,"message","message",-406056002),inst_72588);
var state_72729__$1 = (function (){var statearr_72739 = state_72729;
(statearr_72739[(11)] = inst_72586);

return statearr_72739;
})();
var statearr_72740_72809 = state_72729__$1;
(statearr_72740_72809[(2)] = inst_72589);

(statearr_72740_72809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (15))){
var inst_72618 = (state_72729[(12)]);
var inst_72623 = (state_72729[(13)]);
var inst_72632 = (state_72729[(2)]);
var inst_72633 = [inst_72623,inst_72632];
var inst_72634 = (new cljs.core.PersistentVector(null,2,(5),inst_72618,inst_72633,null));
var state_72729__$1 = state_72729;
var statearr_72741_72810 = state_72729__$1;
(statearr_72741_72810[(2)] = inst_72634);

(statearr_72741_72810[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (21))){
var inst_72638 = (state_72729[(8)]);
var state_72729__$1 = state_72729;
var statearr_72742_72811 = state_72729__$1;
(statearr_72742_72811[(2)] = inst_72638);

(statearr_72742_72811[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (31))){
var inst_72679 = (state_72729[(2)]);
var state_72729__$1 = state_72729;
var statearr_72743_72812 = state_72729__$1;
(statearr_72743_72812[(2)] = inst_72679);

(statearr_72743_72812[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (32))){
var inst_72685 = (state_72729[(9)]);
var inst_72688 = cljs.core.pos_int_QMARK_.call(null,inst_72685);
var state_72729__$1 = state_72729;
var statearr_72744_72813 = state_72729__$1;
(statearr_72744_72813[(2)] = inst_72688);

(statearr_72744_72813[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (40))){
var inst_72716 = (state_72729[(14)]);
var inst_72640 = (state_72729[(15)]);
var inst_72714 = (state_72729[(2)]);
var inst_72715 = cljs.core.nth.call(null,inst_72714,(0),null);
var inst_72716__$1 = cljs.core.nth.call(null,inst_72714,(1),null);
var inst_72717 = (inst_72716__$1 > inst_72640);
var state_72729__$1 = (function (){var statearr_72745 = state_72729;
(statearr_72745[(14)] = inst_72716__$1);

(statearr_72745[(16)] = inst_72715);

return statearr_72745;
})();
if(cljs.core.truth_(inst_72717)){
var statearr_72746_72814 = state_72729__$1;
(statearr_72746_72814[(1)] = (41));

} else {
var statearr_72747_72815 = state_72729__$1;
(statearr_72747_72815[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (33))){
var inst_72686 = (state_72729[(17)]);
var state_72729__$1 = state_72729;
var statearr_72748_72816 = state_72729__$1;
(statearr_72748_72816[(2)] = inst_72686);

(statearr_72748_72816[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (13))){
var inst_72624 = (state_72729[(18)]);
var inst_72626 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_72624);
var state_72729__$1 = state_72729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72729__$1,(16),inst_72626);
} else {
if((state_val_72730 === (22))){
var inst_72657 = (state_72729[(2)]);
var state_72729__$1 = state_72729;
if(cljs.core.truth_(inst_72657)){
var statearr_72749_72817 = state_72729__$1;
(statearr_72749_72817[(1)] = (23));

} else {
var statearr_72750_72818 = state_72729__$1;
(statearr_72750_72818[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (36))){
var state_72729__$1 = state_72729;
var statearr_72751_72819 = state_72729__$1;
(statearr_72751_72819[(2)] = null);

(statearr_72751_72819[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (41))){
var inst_72640 = (state_72729[(15)]);
var state_72729__$1 = state_72729;
var statearr_72752_72820 = state_72729__$1;
(statearr_72752_72820[(2)] = inst_72640);

(statearr_72752_72820[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (43))){
var inst_72715 = (state_72729[(16)]);
var inst_72721 = (state_72729[(2)]);
var inst_72722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72723 = [inst_72715,inst_72721];
var inst_72724 = (new cljs.core.PersistentVector(null,2,(5),inst_72722,inst_72723,null));
var _ = (function (){var statearr_72753 = state_72729;
(statearr_72753[(4)] = cljs.core.rest.call(null,(state_72729[(4)])));

return statearr_72753;
})();
var state_72729__$1 = state_72729;
var statearr_72754_72821 = state_72729__$1;
(statearr_72754_72821[(2)] = inst_72724);

(statearr_72754_72821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (29))){
var inst_72615 = (state_72729[(19)]);
var inst_72670 = cljs.core.pr_str.call(null,inst_72615);
var inst_72671 = ["Invalid block range provided: ",inst_72670].join('');
var inst_72672 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72673 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72674 = cljs.core.PersistentHashMap.fromArrays(inst_72672,inst_72673);
var inst_72675 = cljs.core.ex_info.call(null,inst_72671,inst_72674);
var inst_72676 = (function(){throw inst_72675})();
var state_72729__$1 = state_72729;
var statearr_72755_72822 = state_72729__$1;
(statearr_72755_72822[(2)] = inst_72676);

(statearr_72755_72822[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (6))){
var inst_72607 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_72729__$1 = state_72729;
var statearr_72756_72823 = state_72729__$1;
(statearr_72756_72823[(2)] = inst_72607);

(statearr_72756_72823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (28))){
var inst_72681 = (state_72729[(2)]);
var state_72729__$1 = state_72729;
var statearr_72757_72824 = state_72729__$1;
(statearr_72757_72824[(2)] = inst_72681);

(statearr_72757_72824[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (25))){
var inst_72684 = (state_72729[(10)]);
var inst_72686 = (state_72729[(17)]);
var inst_72683 = (state_72729[(2)]);
var inst_72684__$1 = cljs.core.nth.call(null,inst_72683,(0),null);
var inst_72685 = cljs.core.nth.call(null,inst_72683,(1),null);
var inst_72686__$1 = cljs.core.pos_int_QMARK_.call(null,inst_72684__$1);
var state_72729__$1 = (function (){var statearr_72758 = state_72729;
(statearr_72758[(9)] = inst_72685);

(statearr_72758[(10)] = inst_72684__$1);

(statearr_72758[(17)] = inst_72686__$1);

return statearr_72758;
})();
if(inst_72686__$1){
var statearr_72759_72825 = state_72729__$1;
(statearr_72759_72825[(1)] = (32));

} else {
var statearr_72760_72826 = state_72729__$1;
(statearr_72760_72826[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (34))){
var inst_72691 = (state_72729[(2)]);
var inst_72692 = cljs.core.not.call(null,inst_72691);
var state_72729__$1 = state_72729;
if(inst_72692){
var statearr_72761_72827 = state_72729__$1;
(statearr_72761_72827[(1)] = (35));

} else {
var statearr_72762_72828 = state_72729__$1;
(statearr_72762_72828[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (17))){
var inst_72640 = (state_72729[(15)]);
var inst_72638 = (state_72729[(8)]);
var inst_72643 = cljs.core.pr_str.call(null,inst_72638);
var inst_72644 = cljs.core.pr_str.call(null,inst_72640);
var inst_72645 = ["Start block is out of range for this ledger. Start block provided: ",inst_72643,". Database block: ",inst_72644].join('');
var inst_72646 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72647 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72648 = cljs.core.PersistentHashMap.fromArrays(inst_72646,inst_72647);
var inst_72649 = cljs.core.ex_info.call(null,inst_72645,inst_72648);
var inst_72650 = (function(){throw inst_72649})();
var state_72729__$1 = state_72729;
var statearr_72763_72829 = state_72729__$1;
(statearr_72763_72829[(2)] = inst_72650);

(statearr_72763_72829[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (3))){
var inst_72727 = (state_72729[(2)]);
var state_72729__$1 = state_72729;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72729__$1,inst_72727);
} else {
if((state_val_72730 === (12))){
var inst_72624 = (state_72729[(18)]);
var inst_72615 = (state_72729[(19)]);
var inst_72622 = (state_72729[(2)]);
var inst_72623 = fluree.db.util.async.throw_err.call(null,inst_72622);
var inst_72624__$1 = cljs.core.second.call(null,inst_72615);
var state_72729__$1 = (function (){var statearr_72764 = state_72729;
(statearr_72764[(18)] = inst_72624__$1);

(statearr_72764[(13)] = inst_72623);

return statearr_72764;
})();
if(cljs.core.truth_(inst_72624__$1)){
var statearr_72765_72830 = state_72729__$1;
(statearr_72765_72830[(1)] = (13));

} else {
var statearr_72766_72831 = state_72729__$1;
(statearr_72766_72831[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (2))){
var _ = (function (){var statearr_72767 = state_72729;
(statearr_72767[(4)] = cljs.core.cons.call(null,(5),(state_72729[(4)])));

return statearr_72767;
})();
var inst_72604 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_72605 = cljs.core.sequential_QMARK_.call(null,inst_72604);
var state_72729__$1 = state_72729;
if(inst_72605){
var statearr_72768_72832 = state_72729__$1;
(statearr_72768_72832[(1)] = (6));

} else {
var statearr_72769_72833 = state_72729__$1;
(statearr_72769_72833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (23))){
var inst_72639 = (state_72729[(7)]);
var inst_72638 = (state_72729[(8)]);
var inst_72659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72660 = [inst_72638,inst_72639];
var inst_72661 = (new cljs.core.PersistentVector(null,2,(5),inst_72659,inst_72660,null));
var state_72729__$1 = state_72729;
var statearr_72770_72834 = state_72729__$1;
(statearr_72770_72834[(2)] = inst_72661);

(statearr_72770_72834[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (35))){
var inst_72615 = (state_72729[(19)]);
var inst_72694 = cljs.core.pr_str.call(null,inst_72615);
var inst_72695 = ["Invalid block range provided: ",inst_72694].join('');
var inst_72696 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72697 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72698 = cljs.core.PersistentHashMap.fromArrays(inst_72696,inst_72697);
var inst_72699 = cljs.core.ex_info.call(null,inst_72695,inst_72698);
var inst_72700 = (function(){throw inst_72699})();
var state_72729__$1 = state_72729;
var statearr_72771_72835 = state_72729__$1;
(statearr_72771_72835[(2)] = inst_72700);

(statearr_72771_72835[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (19))){
var inst_72638 = (state_72729[(8)]);
var inst_72653 = (state_72729[(2)]);
var state_72729__$1 = (function (){var statearr_72772 = state_72729;
(statearr_72772[(20)] = inst_72653);

return statearr_72772;
})();
if(cljs.core.truth_(inst_72638)){
var statearr_72773_72836 = state_72729__$1;
(statearr_72773_72836[(1)] = (20));

} else {
var statearr_72774_72837 = state_72729__$1;
(statearr_72774_72837[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (11))){
var inst_72640 = (state_72729[(15)]);
var inst_72638 = (state_72729[(8)]);
var inst_72637 = (state_72729[(2)]);
var inst_72638__$1 = cljs.core.nth.call(null,inst_72637,(0),null);
var inst_72639 = cljs.core.nth.call(null,inst_72637,(1),null);
var inst_72640__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_72641 = (inst_72638__$1 > inst_72640__$1);
var state_72729__$1 = (function (){var statearr_72776 = state_72729;
(statearr_72776[(15)] = inst_72640__$1);

(statearr_72776[(7)] = inst_72639);

(statearr_72776[(8)] = inst_72638__$1);

return statearr_72776;
})();
if(cljs.core.truth_(inst_72641)){
var statearr_72777_72838 = state_72729__$1;
(statearr_72777_72838[(1)] = (17));

} else {
var statearr_72778_72839 = state_72729__$1;
(statearr_72778_72839[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (9))){
var inst_72615 = (state_72729[(19)]);
var inst_72618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72619 = cljs.core.first.call(null,inst_72615);
var inst_72620 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_72619);
var state_72729__$1 = (function (){var statearr_72779 = state_72729;
(statearr_72779[(12)] = inst_72618);

return statearr_72779;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72729__$1,(12),inst_72620);
} else {
if((state_val_72730 === (5))){
var _ = (function (){var statearr_72780 = state_72729;
(statearr_72780[(4)] = cljs.core.rest.call(null,(state_72729[(4)])));

return statearr_72780;
})();
var state_72729__$1 = state_72729;
var ex72775 = (state_72729__$1[(2)]);
var statearr_72781_72840 = state_72729__$1;
(statearr_72781_72840[(5)] = ex72775);


var statearr_72782_72841 = state_72729__$1;
(statearr_72782_72841[(1)] = (4));

(statearr_72782_72841[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (14))){
var state_72729__$1 = state_72729;
var statearr_72783_72842 = state_72729__$1;
(statearr_72783_72842[(2)] = null);

(statearr_72783_72842[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (26))){
var inst_72638 = (state_72729[(8)]);
var inst_72664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72665 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_72666 = [inst_72638,inst_72665];
var inst_72667 = (new cljs.core.PersistentVector(null,2,(5),inst_72664,inst_72666,null));
var state_72729__$1 = state_72729;
var statearr_72784_72843 = state_72729__$1;
(statearr_72784_72843[(2)] = inst_72667);

(statearr_72784_72843[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (16))){
var inst_72628 = (state_72729[(2)]);
var inst_72629 = fluree.db.util.async.throw_err.call(null,inst_72628);
var state_72729__$1 = state_72729;
var statearr_72785_72844 = state_72729__$1;
(statearr_72785_72844[(2)] = inst_72629);

(statearr_72785_72844[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (38))){
var inst_72685 = (state_72729[(9)]);
var inst_72684 = (state_72729[(10)]);
var inst_72706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72707 = [inst_72685,inst_72684];
var inst_72708 = (new cljs.core.PersistentVector(null,2,(5),inst_72706,inst_72707,null));
var state_72729__$1 = state_72729;
var statearr_72786_72845 = state_72729__$1;
(statearr_72786_72845[(2)] = inst_72708);

(statearr_72786_72845[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (30))){
var state_72729__$1 = state_72729;
var statearr_72787_72846 = state_72729__$1;
(statearr_72787_72846[(2)] = null);

(statearr_72787_72846[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (10))){
var inst_72615 = (state_72729[(19)]);
var state_72729__$1 = state_72729;
var statearr_72788_72847 = state_72729__$1;
(statearr_72788_72847[(2)] = inst_72615);

(statearr_72788_72847[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (18))){
var state_72729__$1 = state_72729;
var statearr_72789_72848 = state_72729__$1;
(statearr_72789_72848[(2)] = null);

(statearr_72789_72848[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (42))){
var inst_72716 = (state_72729[(14)]);
var state_72729__$1 = state_72729;
var statearr_72790_72849 = state_72729__$1;
(statearr_72790_72849[(2)] = inst_72716);

(statearr_72790_72849[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (37))){
var inst_72685 = (state_72729[(9)]);
var inst_72684 = (state_72729[(10)]);
var inst_72703 = (state_72729[(2)]);
var inst_72704 = (inst_72685 < inst_72684);
var state_72729__$1 = (function (){var statearr_72791 = state_72729;
(statearr_72791[(21)] = inst_72703);

return statearr_72791;
})();
if(cljs.core.truth_(inst_72704)){
var statearr_72792_72850 = state_72729__$1;
(statearr_72792_72850[(1)] = (38));

} else {
var statearr_72793_72851 = state_72729__$1;
(statearr_72793_72851[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72730 === (8))){
var inst_72615 = (state_72729[(19)]);
var inst_72615__$1 = (state_72729[(2)]);
var inst_72616 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_72615__$1);
var state_72729__$1 = (function (){var statearr_72794 = state_72729;
(statearr_72794[(19)] = inst_72615__$1);

return statearr_72794;
})();
if(cljs.core.truth_(inst_72616)){
var statearr_72795_72852 = state_72729__$1;
(statearr_72795_72852[(1)] = (9));

} else {
var statearr_72796_72853 = state_72729__$1;
(statearr_72796_72853[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_72797 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72797[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__);

(statearr_72797[(1)] = (1));

return statearr_72797;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_72729){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72798){var ex__2749__auto__ = e72798;
var statearr_72799_72854 = state_72729;
(statearr_72799_72854[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72729[(4)]))){
var statearr_72800_72855 = state_72729;
(statearr_72800_72855[(1)] = cljs.core.first.call(null,(state_72729[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72856 = state_72729;
state_72729 = G__72856;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = function(state_72729){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_72729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72801 = f__2769__auto__.call(null);
(statearr_72801[(6)] = c__2768__auto__);

return statearr_72801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__72858 = arguments.length;
switch (G__72858) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72952){
var state_val_72953 = (state_72952[(1)]);
if((state_val_72953 === (7))){
var inst_72884 = (state_72952[(7)]);
var inst_72887 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_72884);
var state_72952__$1 = state_72952;
var statearr_72954_73005 = state_72952__$1;
(statearr_72954_73005[(2)] = inst_72887);

(statearr_72954_73005[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (20))){
var inst_72923 = (state_72952[(8)]);
var inst_72926 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_72923);
var state_72952__$1 = state_72952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72952__$1,(23),inst_72926);
} else {
if((state_val_72953 === (27))){
var inst_72932 = (state_72952[(9)]);
var inst_72938 = cljs.core.doall.call(null,inst_72932);
var state_72952__$1 = state_72952;
var statearr_72955_73006 = state_72952__$1;
(statearr_72955_73006[(2)] = inst_72938);

(statearr_72955_73006[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (1))){
var state_72952__$1 = state_72952;
var statearr_72956_73007 = state_72952__$1;
(statearr_72956_73007[(2)] = null);

(statearr_72956_73007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (24))){
var inst_72932 = (state_72952[(9)]);
var inst_72935 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_72936 = cljs.core.sequential_QMARK_.call(null,inst_72932);
var state_72952__$1 = (function (){var statearr_72957 = state_72952;
(statearr_72957[(10)] = inst_72935);

return statearr_72957;
})();
if(inst_72936){
var statearr_72958_73008 = state_72952__$1;
(statearr_72958_73008[(1)] = (27));

} else {
var statearr_72959_73009 = state_72952__$1;
(statearr_72959_73009[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (4))){
var inst_72859 = (state_72952[(2)]);
var inst_72860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72861 = [inst_72859];
var inst_72862 = (new cljs.core.PersistentVector(null,1,(5),inst_72860,inst_72861,null));
var inst_72863 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72862);
var inst_72864 = cljs.core.ex_data.call(null,inst_72859);
var inst_72865 = cljs.core.ex_message.call(null,inst_72859);
var inst_72866 = cljs.core.assoc.call(null,inst_72864,new cljs.core.Keyword(null,"message","message",-406056002),inst_72865);
var state_72952__$1 = (function (){var statearr_72960 = state_72952;
(statearr_72960[(11)] = inst_72863);

return statearr_72960;
})();
var statearr_72961_73010 = state_72952__$1;
(statearr_72961_73010[(2)] = inst_72866);

(statearr_72961_73010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (15))){
var inst_72884 = (state_72952[(7)]);
var inst_72897 = (state_72952[(2)]);
var inst_72898 = cljs.core.ex_info.call(null,inst_72897,inst_72884);
var inst_72899 = (function(){throw inst_72898})();
var state_72952__$1 = state_72952;
var statearr_72962_73011 = state_72952__$1;
(statearr_72962_73011[(2)] = inst_72899);

(statearr_72962_73011[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (21))){
var inst_72923 = (state_72952[(8)]);
var state_72952__$1 = state_72952;
var statearr_72963_73012 = state_72952__$1;
(statearr_72963_73012[(2)] = inst_72923);

(statearr_72963_73012[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (13))){
var inst_72892 = (state_72952[(12)]);
var state_72952__$1 = state_72952;
var statearr_72964_73013 = state_72952__$1;
(statearr_72964_73013[(2)] = inst_72892);

(statearr_72964_73013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (22))){
var inst_72932 = (state_72952[(2)]);
var inst_72933 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_72952__$1 = (function (){var statearr_72965 = state_72952;
(statearr_72965[(9)] = inst_72932);

return statearr_72965;
})();
if(cljs.core.truth_(inst_72933)){
var statearr_72966_73014 = state_72952__$1;
(statearr_72966_73014[(1)] = (24));

} else {
var statearr_72967_73015 = state_72952__$1;
(statearr_72967_73015[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (29))){
var inst_72876 = (state_72952[(13)]);
var inst_72935 = (state_72952[(10)]);
var inst_72941 = (state_72952[(2)]);
var inst_72942 = fluree.db.util.core.response_time_formatted.call(null,inst_72876);
var inst_72943 = [(200),inst_72941,(100),inst_72942];
var inst_72944 = cljs.core.PersistentHashMap.fromArrays(inst_72935,inst_72943);
var state_72952__$1 = state_72952;
var statearr_72968_73016 = state_72952__$1;
(statearr_72968_73016[(2)] = inst_72944);

(statearr_72968_73016[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (6))){
var inst_72885 = (state_72952[(14)]);
var inst_72884 = (state_72952[(7)]);
var inst_72883 = (state_72952[(2)]);
var inst_72884__$1 = fluree.db.util.async.throw_err.call(null,inst_72883);
var inst_72885__$1 = cljs.core.map_QMARK_.call(null,inst_72884__$1);
var state_72952__$1 = (function (){var statearr_72969 = state_72952;
(statearr_72969[(14)] = inst_72885__$1);

(statearr_72969[(7)] = inst_72884__$1);

return statearr_72969;
})();
if(inst_72885__$1){
var statearr_72970_73017 = state_72952__$1;
(statearr_72970_73017[(1)] = (7));

} else {
var statearr_72971_73018 = state_72952__$1;
(statearr_72971_73018[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (28))){
var inst_72932 = (state_72952[(9)]);
var state_72952__$1 = state_72952;
var statearr_72972_73019 = state_72952__$1;
(statearr_72972_73019[(2)] = inst_72932);

(statearr_72972_73019[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (25))){
var inst_72932 = (state_72952[(9)]);
var state_72952__$1 = state_72952;
var statearr_72973_73020 = state_72952__$1;
(statearr_72973_73020[(2)] = inst_72932);

(statearr_72973_73020[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (17))){
var inst_72915 = cljs.core.pr_str.call(null,query_map);
var inst_72916 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_72915].join('');
var inst_72917 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72918 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72919 = cljs.core.PersistentHashMap.fromArrays(inst_72917,inst_72918);
var inst_72920 = cljs.core.ex_info.call(null,inst_72916,inst_72919);
var inst_72921 = (function(){throw inst_72920})();
var state_72952__$1 = state_72952;
var statearr_72974_73021 = state_72952__$1;
(statearr_72974_73021[(2)] = inst_72921);

(statearr_72974_73021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (3))){
var inst_72950 = (state_72952[(2)]);
var state_72952__$1 = state_72952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72952__$1,inst_72950);
} else {
if((state_val_72953 === (12))){
var inst_72884 = (state_72952[(7)]);
var inst_72902 = (state_72952[(2)]);
var inst_72903 = cljs.core.nth.call(null,inst_72884,(0),null);
var inst_72904 = cljs.core.nth.call(null,inst_72884,(1),null);
var inst_72905 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_72906 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_72907 = cljs.core.keys.call(null,inst_72906);
var inst_72908 = cljs.core._EQ_.call(null,inst_72905,inst_72907);
var state_72952__$1 = (function (){var statearr_72975 = state_72952;
(statearr_72975[(15)] = inst_72903);

(statearr_72975[(16)] = inst_72902);

(statearr_72975[(17)] = inst_72904);

return statearr_72975;
})();
if(inst_72908){
var statearr_72976_73022 = state_72952__$1;
(statearr_72976_73022[(1)] = (16));

} else {
var statearr_72977_73023 = state_72952__$1;
(statearr_72977_73023[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (2))){
var _ = (function (){var statearr_72978 = state_72952;
(statearr_72978[(4)] = cljs.core.cons.call(null,(5),(state_72952[(4)])));

return statearr_72978;
})();
var inst_72876 = fluree.db.util.core.current_time_millis.call(null);
var inst_72877 = db;
var inst_72878 = cljs.core.__destructure_map.call(null,inst_72877);
var inst_72879 = cljs.core.get.call(null,inst_72878,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_72880 = cljs.core.get.call(null,inst_72878,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_72881 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_72952__$1 = (function (){var statearr_72979 = state_72952;
(statearr_72979[(18)] = inst_72880);

(statearr_72979[(13)] = inst_72876);

(statearr_72979[(19)] = inst_72879);

return statearr_72979;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72952__$1,(6),inst_72881);
} else {
if((state_val_72953 === (23))){
var inst_72928 = (state_72952[(2)]);
var inst_72929 = fluree.db.util.async.throw_err.call(null,inst_72928);
var state_72952__$1 = state_72952;
var statearr_72980_73024 = state_72952__$1;
(statearr_72980_73024[(2)] = inst_72929);

(statearr_72980_73024[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (19))){
var inst_72912 = (state_72952[(2)]);
var inst_72913 = fluree.db.util.async.throw_err.call(null,inst_72912);
var state_72952__$1 = state_72952;
var statearr_72981_73025 = state_72952__$1;
(statearr_72981_73025[(2)] = inst_72913);

(statearr_72981_73025[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (11))){
var state_72952__$1 = state_72952;
var statearr_72983_73026 = state_72952__$1;
(statearr_72983_73026[(2)] = null);

(statearr_72983_73026[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (9))){
var inst_72890 = (state_72952[(2)]);
var state_72952__$1 = state_72952;
if(cljs.core.truth_(inst_72890)){
var statearr_72984_73027 = state_72952__$1;
(statearr_72984_73027[(1)] = (10));

} else {
var statearr_72985_73028 = state_72952__$1;
(statearr_72985_73028[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (5))){
var _ = (function (){var statearr_72986 = state_72952;
(statearr_72986[(4)] = cljs.core.rest.call(null,(state_72952[(4)])));

return statearr_72986;
})();
var state_72952__$1 = state_72952;
var ex72982 = (state_72952__$1[(2)]);
var statearr_72987_73029 = state_72952__$1;
(statearr_72987_73029[(5)] = ex72982);


var statearr_72988_73030 = state_72952__$1;
(statearr_72988_73030[(1)] = (4));

(statearr_72988_73030[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (14))){
var inst_72880 = (state_72952[(18)]);
var inst_72879 = (state_72952[(19)]);
var inst_72895 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72879),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72880)].join('');
var state_72952__$1 = state_72952;
var statearr_72989_73031 = state_72952__$1;
(statearr_72989_73031[(2)] = inst_72895);

(statearr_72989_73031[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (26))){
var inst_72947 = (state_72952[(2)]);
var _ = (function (){var statearr_72990 = state_72952;
(statearr_72990[(4)] = cljs.core.rest.call(null,(state_72952[(4)])));

return statearr_72990;
})();
var state_72952__$1 = state_72952;
var statearr_72991_73032 = state_72952__$1;
(statearr_72991_73032[(2)] = inst_72947);

(statearr_72991_73032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (16))){
var inst_72903 = (state_72952[(15)]);
var inst_72904 = (state_72952[(17)]);
var inst_72910 = fluree.db.query.block.block_range.call(null,db,inst_72903,inst_72904,opts);
var state_72952__$1 = state_72952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72952__$1,(19),inst_72910);
} else {
if((state_val_72953 === (10))){
var inst_72884 = (state_72952[(7)]);
var inst_72892 = (state_72952[(12)]);
var inst_72892__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_72884);
var state_72952__$1 = (function (){var statearr_72992 = state_72952;
(statearr_72992[(12)] = inst_72892__$1);

return statearr_72992;
})();
if(cljs.core.truth_(inst_72892__$1)){
var statearr_72993_73033 = state_72952__$1;
(statearr_72993_73033[(1)] = (13));

} else {
var statearr_72994_73034 = state_72952__$1;
(statearr_72994_73034[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (18))){
var inst_72923 = (state_72952[(2)]);
var inst_72924 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_72952__$1 = (function (){var statearr_72995 = state_72952;
(statearr_72995[(8)] = inst_72923);

return statearr_72995;
})();
if(cljs.core.truth_(inst_72924)){
var statearr_72996_73035 = state_72952__$1;
(statearr_72996_73035[(1)] = (20));

} else {
var statearr_72997_73036 = state_72952__$1;
(statearr_72997_73036[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72953 === (8))){
var inst_72885 = (state_72952[(14)]);
var state_72952__$1 = state_72952;
var statearr_72998_73037 = state_72952__$1;
(statearr_72998_73037[(2)] = inst_72885);

(statearr_72998_73037[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_72999 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72999[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_72999[(1)] = (1));

return statearr_72999;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_72952){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73000){var ex__2749__auto__ = e73000;
var statearr_73001_73038 = state_72952;
(statearr_73001_73038[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72952[(4)]))){
var statearr_73002_73039 = state_72952;
(statearr_73002_73039[(1)] = cljs.core.first.call(null,(state_72952[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73040 = state_72952;
state_72952 = G__73040;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_72952){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_72952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73003 = f__2769__auto__.call(null);
(statearr_73003[(6)] = c__2768__auto__);

return statearr_73003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__73042 = arguments.length;
switch (G__73042) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73237){
var state_val_73238 = (state_73237[(1)]);
if((state_val_73238 === (62))){
var inst_73235 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73237__$1,inst_73235);
} else {
if((state_val_73238 === (7))){
var inst_73063 = (state_73237[(7)]);
var inst_73073 = cljs.core.not_EQ_.call(null,(1),inst_73063);
var state_73237__$1 = state_73237;
var statearr_73239_73330 = state_73237__$1;
(statearr_73239_73330[(2)] = inst_73073);

(statearr_73239_73330[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (59))){
var inst_73223 = (state_73237[(2)]);
var inst_73224 = fluree.db.util.async.throw_err.call(null,inst_73223);
var state_73237__$1 = state_73237;
var statearr_73240_73331 = state_73237__$1;
(statearr_73240_73331[(2)] = inst_73224);

(statearr_73240_73331[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (20))){
var inst_73131 = (state_73237[(8)]);
var inst_73139 = (state_73237[(9)]);
var inst_73131__$1 = (state_73237[(2)]);
var inst_73132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73133 = cljs.core.get.call(null,inst_73131__$1,(0));
var inst_73134 = cljs.core.get.call(null,inst_73131__$1,(1));
var inst_73135 = cljs.core.get.call(null,inst_73131__$1,(2));
var inst_73136 = cljs.core.get.call(null,inst_73131__$1,(3));
var inst_73137 = [inst_73133,inst_73134,inst_73135,inst_73136];
var inst_73138 = (new cljs.core.PersistentVector(null,4,(5),inst_73132,inst_73137,null));
var inst_73139__$1 = cljs.core.nth.call(null,inst_73138,(0),null);
var inst_73140 = cljs.core.nth.call(null,inst_73138,(1),null);
var inst_73141 = cljs.core.nth.call(null,inst_73138,(2),null);
var inst_73142 = cljs.core.nth.call(null,inst_73138,(3),null);
var inst_73143 = (inst_73139__$1 == null);
var inst_73144 = cljs.core.not.call(null,inst_73143);
var state_73237__$1 = (function (){var statearr_73241 = state_73237;
(statearr_73241[(8)] = inst_73131__$1);

(statearr_73241[(10)] = inst_73140);

(statearr_73241[(11)] = inst_73141);

(statearr_73241[(12)] = inst_73142);

(statearr_73241[(9)] = inst_73139__$1);

return statearr_73241;
})();
if(inst_73144){
var statearr_73242_73332 = state_73237__$1;
(statearr_73242_73332[(1)] = (30));

} else {
var statearr_73243_73333 = state_73237__$1;
(statearr_73243_73333[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (58))){
var inst_73071 = (state_73237[(13)]);
var inst_73227 = (state_73237[(2)]);
var state_73237__$1 = (function (){var statearr_73244 = state_73237;
(statearr_73244[(14)] = inst_73227);

return statearr_73244;
})();
if(cljs.core.truth_(inst_73071)){
var statearr_73245_73334 = state_73237__$1;
(statearr_73245_73334[(1)] = (60));

} else {
var statearr_73246_73335 = state_73237__$1;
(statearr_73246_73335[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (60))){
var inst_73215 = (state_73237[(15)]);
var inst_73227 = (state_73237[(14)]);
var inst_73229 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_73230 = cljs.core.count.call(null,inst_73215);
var inst_73231 = [inst_73227,inst_73230,(200)];
var inst_73232 = cljs.core.PersistentHashMap.fromArrays(inst_73229,inst_73231);
var state_73237__$1 = state_73237;
var statearr_73247_73336 = state_73237__$1;
(statearr_73247_73336[(2)] = inst_73232);

(statearr_73247_73336[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (27))){
var inst_73050 = (state_73237[(16)]);
var inst_73119 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73050)].join('');
var inst_73120 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73121 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73122 = cljs.core.PersistentHashMap.fromArrays(inst_73120,inst_73121);
var inst_73123 = cljs.core.ex_info.call(null,inst_73119,inst_73122);
var inst_73124 = (function(){throw inst_73123})();
var state_73237__$1 = state_73237;
var statearr_73248_73337 = state_73237__$1;
(statearr_73248_73337[(2)] = inst_73124);

(statearr_73248_73337[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (1))){
var inst_73047 = query_map;
var inst_73048 = cljs.core.__destructure_map.call(null,inst_73047);
var inst_73049 = cljs.core.get.call(null,inst_73048,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73050 = cljs.core.get.call(null,inst_73048,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_73051 = cljs.core.get.call(null,inst_73048,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_73237__$1 = (function (){var statearr_73249 = state_73237;
(statearr_73249[(17)] = inst_73051);

(statearr_73249[(16)] = inst_73050);

(statearr_73249[(18)] = inst_73049);

return statearr_73249;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73237__$1,(2),sources);
} else {
if((state_val_73238 === (24))){
var inst_73050 = (state_73237[(16)]);
var inst_73108 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73050)].join('');
var inst_73109 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73110 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73111 = cljs.core.PersistentHashMap.fromArrays(inst_73109,inst_73110);
var inst_73112 = cljs.core.ex_info.call(null,inst_73108,inst_73111);
var inst_73113 = (function(){throw inst_73112})();
var state_73237__$1 = state_73237;
var statearr_73250_73338 = state_73237__$1;
(statearr_73250_73338[(2)] = inst_73113);

(statearr_73250_73338[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (55))){
var inst_73051 = (state_73237[(17)]);
var inst_73218 = (state_73237[(2)]);
var inst_73219 = fluree.db.util.async.throw_err.call(null,inst_73218);
var state_73237__$1 = (function (){var statearr_73251 = state_73237;
(statearr_73251[(19)] = inst_73219);

return statearr_73251;
})();
if(cljs.core.truth_(inst_73051)){
var statearr_73252_73339 = state_73237__$1;
(statearr_73252_73339[(1)] = (56));

} else {
var statearr_73253_73340 = state_73237__$1;
(statearr_73253_73340[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (39))){
var inst_73140 = (state_73237[(10)]);
var inst_73141 = (state_73237[(11)]);
var inst_73142 = (state_73237[(12)]);
var inst_73139 = (state_73237[(9)]);
var inst_73163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73165 = [inst_73140,inst_73139,inst_73141,inst_73142];
var inst_73166 = (new cljs.core.PersistentVector(null,4,(5),inst_73164,inst_73165,null));
var inst_73167 = [inst_73166,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_73168 = (new cljs.core.PersistentVector(null,2,(5),inst_73163,inst_73167,null));
var state_73237__$1 = state_73237;
var statearr_73254_73341 = state_73237__$1;
(statearr_73254_73341[(2)] = inst_73168);

(statearr_73254_73341[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (46))){
var inst_73173 = (state_73237[(20)]);
var state_73237__$1 = state_73237;
var statearr_73255_73342 = state_73237__$1;
(statearr_73255_73342[(2)] = inst_73173);

(statearr_73255_73342[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (4))){
var state_73237__$1 = state_73237;
var statearr_73256_73343 = state_73237__$1;
(statearr_73256_73343[(2)] = null);

(statearr_73256_73343[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (54))){
var inst_73215 = (state_73237[(15)]);
var inst_73054 = (state_73237[(21)]);
var inst_73214 = (state_73237[(2)]);
var inst_73215__$1 = fluree.db.util.async.throw_err.call(null,inst_73214);
var inst_73216 = fluree.db.api_js.format_history_resp.call(null,inst_73054,inst_73215__$1);
var state_73237__$1 = (function (){var statearr_73257 = state_73237;
(statearr_73257[(15)] = inst_73215__$1);

return statearr_73257;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73237__$1,(55),inst_73216);
} else {
if((state_val_73238 === (15))){
var inst_73054 = (state_73237[(21)]);
var inst_73095 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73054);
var state_73237__$1 = state_73237;
var statearr_73258_73344 = state_73237__$1;
(statearr_73258_73344[(2)] = inst_73095);

(statearr_73258_73344[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (48))){
var inst_73140 = (state_73237[(10)]);
var inst_73141 = (state_73237[(11)]);
var inst_73142 = (state_73237[(12)]);
var inst_73139 = (state_73237[(9)]);
var inst_73184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73186 = [inst_73140,inst_73141,inst_73139,inst_73142];
var inst_73187 = (new cljs.core.PersistentVector(null,4,(5),inst_73185,inst_73186,null));
var inst_73188 = [inst_73187,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_73189 = (new cljs.core.PersistentVector(null,2,(5),inst_73184,inst_73188,null));
var state_73237__$1 = state_73237;
var statearr_73259_73345 = state_73237__$1;
(statearr_73259_73345[(2)] = inst_73189);

(statearr_73259_73345[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (50))){
var inst_73202 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73260_73346 = state_73237__$1;
(statearr_73260_73346[(2)] = inst_73202);

(statearr_73260_73346[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (21))){
var inst_73050 = (state_73237[(16)]);
var inst_73106 = cljs.core.empty_QMARK_.call(null,inst_73050);
var state_73237__$1 = state_73237;
if(inst_73106){
var statearr_73261_73347 = state_73237__$1;
(statearr_73261_73347[(1)] = (24));

} else {
var statearr_73262_73348 = state_73237__$1;
(statearr_73262_73348[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (31))){
var inst_73150 = (state_73237[(22)]);
var inst_73139 = (state_73237[(9)]);
var inst_73150__$1 = (inst_73139 == null);
var state_73237__$1 = (function (){var statearr_73263 = state_73237;
(statearr_73263[(22)] = inst_73150__$1);

return statearr_73263;
})();
if(cljs.core.truth_(inst_73150__$1)){
var statearr_73264_73349 = state_73237__$1;
(statearr_73264_73349[(1)] = (33));

} else {
var statearr_73265_73350 = state_73237__$1;
(statearr_73265_73350[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (32))){
var inst_73054 = (state_73237[(21)]);
var inst_73097 = (state_73237[(23)]);
var inst_73087 = (state_73237[(24)]);
var inst_73206 = (state_73237[(2)]);
var inst_73207 = cljs.core.nth.call(null,inst_73206,(0),null);
var inst_73208 = cljs.core.nth.call(null,inst_73206,(1),null);
var inst_73209 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_73210 = [inst_73087,inst_73097];
var inst_73211 = cljs.core.PersistentHashMap.fromArrays(inst_73209,inst_73210);
var inst_73212 = fluree.db.query.range.time_range.call(null,inst_73054,inst_73208,cljs.core._EQ_,inst_73207,inst_73211);
var state_73237__$1 = state_73237;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73237__$1,(54),inst_73212);
} else {
if((state_val_73238 === (40))){
var inst_73170 = (state_73237[(25)]);
var inst_73139 = (state_73237[(9)]);
var inst_73170__$1 = (inst_73139 == null);
var state_73237__$1 = (function (){var statearr_73266 = state_73237;
(statearr_73266[(25)] = inst_73170__$1);

return statearr_73266;
})();
if(cljs.core.truth_(inst_73170__$1)){
var statearr_73267_73351 = state_73237__$1;
(statearr_73267_73351[(1)] = (42));

} else {
var statearr_73268_73352 = state_73237__$1;
(statearr_73268_73352[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (56))){
var inst_73054 = (state_73237[(21)]);
var inst_73219 = (state_73237[(19)]);
var inst_73221 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_73054,inst_73219);
var state_73237__$1 = state_73237;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73237__$1,(59),inst_73221);
} else {
if((state_val_73238 === (33))){
var inst_73140 = (state_73237[(10)]);
var inst_73153 = (state_73237[(26)]);
var inst_73152 = (inst_73140 == null);
var inst_73153__$1 = cljs.core.not.call(null,inst_73152);
var state_73237__$1 = (function (){var statearr_73269 = state_73237;
(statearr_73269[(26)] = inst_73153__$1);

return statearr_73269;
})();
if(inst_73153__$1){
var statearr_73270_73353 = state_73237__$1;
(statearr_73270_73353[(1)] = (36));

} else {
var statearr_73271_73354 = state_73237__$1;
(statearr_73271_73354[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (13))){
var inst_73081 = (state_73237[(2)]);
var inst_73082 = fluree.db.util.async.throw_err.call(null,inst_73081);
var inst_73083 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73082);
var inst_73084 = (inst_73083 - (1));
var state_73237__$1 = state_73237;
var statearr_73272_73355 = state_73237__$1;
(statearr_73272_73355[(2)] = inst_73084);

(statearr_73272_73355[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (22))){
var state_73237__$1 = state_73237;
var statearr_73273_73356 = state_73237__$1;
(statearr_73273_73356[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (36))){
var inst_73141 = (state_73237[(11)]);
var inst_73155 = (inst_73141 == null);
var state_73237__$1 = state_73237;
var statearr_73275_73357 = state_73237__$1;
(statearr_73275_73357[(2)] = inst_73155);

(statearr_73275_73357[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (41))){
var inst_73204 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73276_73358 = state_73237__$1;
(statearr_73276_73358[(2)] = inst_73204);

(statearr_73276_73358[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (43))){
var inst_73170 = (state_73237[(25)]);
var state_73237__$1 = state_73237;
var statearr_73277_73359 = state_73237__$1;
(statearr_73277_73359[(2)] = inst_73170);

(statearr_73277_73359[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (61))){
var inst_73227 = (state_73237[(14)]);
var state_73237__$1 = state_73237;
var statearr_73278_73360 = state_73237__$1;
(statearr_73278_73360[(2)] = inst_73227);

(statearr_73278_73360[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (29))){
var inst_73127 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73279_73361 = state_73237__$1;
(statearr_73279_73361[(2)] = inst_73127);

(statearr_73279_73361[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (44))){
var inst_73182 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
if(cljs.core.truth_(inst_73182)){
var statearr_73280_73362 = state_73237__$1;
(statearr_73280_73362[(1)] = (48));

} else {
var statearr_73281_73363 = state_73237__$1;
(statearr_73281_73363[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (6))){
var inst_73058 = (state_73237[(2)]);
var inst_73059 = fluree.db.util.async.throw_err.call(null,inst_73058);
var state_73237__$1 = state_73237;
var statearr_73282_73364 = state_73237__$1;
(statearr_73282_73364[(2)] = inst_73059);

(statearr_73282_73364[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (28))){
var state_73237__$1 = state_73237;
var statearr_73283_73365 = state_73237__$1;
(statearr_73283_73365[(2)] = null);

(statearr_73283_73365[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (51))){
var inst_73050 = (state_73237[(16)]);
var inst_73192 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73050)].join('');
var inst_73193 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73194 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73195 = cljs.core.PersistentHashMap.fromArrays(inst_73193,inst_73194);
var inst_73196 = cljs.core.ex_info.call(null,inst_73192,inst_73195);
var inst_73197 = (function(){throw inst_73196})();
var state_73237__$1 = state_73237;
var statearr_73284_73366 = state_73237__$1;
(statearr_73284_73366[(2)] = inst_73197);

(statearr_73284_73366[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (25))){
var inst_73050 = (state_73237[(16)]);
var state_73237__$1 = state_73237;
var statearr_73285_73367 = state_73237__$1;
(statearr_73285_73367[(2)] = inst_73050);

(statearr_73285_73367[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (34))){
var inst_73150 = (state_73237[(22)]);
var state_73237__$1 = state_73237;
var statearr_73286_73368 = state_73237__$1;
(statearr_73286_73368[(2)] = inst_73150);

(statearr_73286_73368[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (17))){
var inst_73091 = (state_73237[(2)]);
var inst_73092 = fluree.db.util.async.throw_err.call(null,inst_73091);
var inst_73093 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73092);
var state_73237__$1 = state_73237;
var statearr_73287_73369 = state_73237__$1;
(statearr_73287_73369[(2)] = inst_73093);

(statearr_73287_73369[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (3))){
var inst_73054 = (state_73237[(21)]);
var inst_73056 = fluree.db.api_js.resolve_block_range.call(null,inst_73054,query_map);
var state_73237__$1 = state_73237;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73237__$1,(6),inst_73056);
} else {
if((state_val_73238 === (12))){
var inst_73064 = (state_73237[(27)]);
var inst_73087 = (state_73237[(2)]);
var state_73237__$1 = (function (){var statearr_73288 = state_73237;
(statearr_73288[(24)] = inst_73087);

return statearr_73288;
})();
if(cljs.core.truth_(inst_73064)){
var statearr_73289_73370 = state_73237__$1;
(statearr_73289_73370[(1)] = (14));

} else {
var statearr_73290_73371 = state_73237__$1;
(statearr_73290_73371[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (2))){
var inst_73049 = (state_73237[(18)]);
var inst_73053 = (state_73237[(2)]);
var inst_73054 = fluree.db.util.async.throw_err.call(null,inst_73053);
var state_73237__$1 = (function (){var statearr_73291 = state_73237;
(statearr_73291[(21)] = inst_73054);

return statearr_73291;
})();
if(cljs.core.truth_(inst_73049)){
var statearr_73292_73372 = state_73237__$1;
(statearr_73292_73372[(1)] = (3));

} else {
var statearr_73293_73373 = state_73237__$1;
(statearr_73293_73373[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (23))){
var inst_73129 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73294_73374 = state_73237__$1;
(statearr_73294_73374[(2)] = inst_73129);

(statearr_73294_73374[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (47))){
var inst_73179 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73295_73375 = state_73237__$1;
(statearr_73295_73375[(2)] = inst_73179);

(statearr_73295_73375[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (35))){
var inst_73161 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
if(cljs.core.truth_(inst_73161)){
var statearr_73296_73376 = state_73237__$1;
(statearr_73296_73376[(1)] = (39));

} else {
var statearr_73297_73377 = state_73237__$1;
(statearr_73297_73377[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (19))){
var inst_73050 = (state_73237[(16)]);
var inst_73104 = cljs.core.sequential_QMARK_.call(null,inst_73050);
var state_73237__$1 = state_73237;
if(inst_73104){
var statearr_73298_73378 = state_73237__$1;
(statearr_73298_73378[(1)] = (21));

} else {
var statearr_73299_73379 = state_73237__$1;
(statearr_73299_73379[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (57))){
var inst_73219 = (state_73237[(19)]);
var state_73237__$1 = state_73237;
var statearr_73300_73380 = state_73237__$1;
(statearr_73300_73380[(2)] = inst_73219);

(statearr_73300_73380[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (11))){
var state_73237__$1 = state_73237;
var statearr_73301_73381 = state_73237__$1;
(statearr_73301_73381[(2)] = (-1));

(statearr_73301_73381[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (9))){
var inst_73076 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
if(cljs.core.truth_(inst_73076)){
var statearr_73302_73382 = state_73237__$1;
(statearr_73302_73382[(1)] = (10));

} else {
var statearr_73303_73383 = state_73237__$1;
(statearr_73303_73383[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (5))){
var inst_73063 = (state_73237[(7)]);
var inst_73062 = (state_73237[(2)]);
var inst_73063__$1 = cljs.core.nth.call(null,inst_73062,(0),null);
var inst_73064 = cljs.core.nth.call(null,inst_73062,(1),null);
var inst_73071 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_73237__$1 = (function (){var statearr_73304 = state_73237;
(statearr_73304[(7)] = inst_73063__$1);

(statearr_73304[(27)] = inst_73064);

(statearr_73304[(13)] = inst_73071);

return statearr_73304;
})();
if(cljs.core.truth_(inst_73063__$1)){
var statearr_73305_73384 = state_73237__$1;
(statearr_73305_73384[(1)] = (7));

} else {
var statearr_73306_73385 = state_73237__$1;
(statearr_73306_73385[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (14))){
var inst_73054 = (state_73237[(21)]);
var inst_73064 = (state_73237[(27)]);
var inst_73089 = fluree.db.time_travel.as_of_block.call(null,inst_73054,inst_73064);
var state_73237__$1 = state_73237;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73237__$1,(17),inst_73089);
} else {
if((state_val_73238 === (45))){
var inst_73141 = (state_73237[(11)]);
var inst_73175 = (inst_73141 == null);
var inst_73176 = cljs.core.not.call(null,inst_73175);
var state_73237__$1 = state_73237;
var statearr_73307_73386 = state_73237__$1;
(statearr_73307_73386[(2)] = inst_73176);

(statearr_73307_73386[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (53))){
var inst_73200 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73308_73387 = state_73237__$1;
(statearr_73308_73387[(2)] = inst_73200);

(statearr_73308_73387[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (26))){
var inst_73116 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73309_73388 = state_73237__$1;
(statearr_73309_73388[(2)] = inst_73116);

(statearr_73309_73388[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (16))){
var inst_73050 = (state_73237[(16)]);
var inst_73097 = (state_73237[(2)]);
var inst_73098 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_73050);
var state_73237__$1 = (function (){var statearr_73310 = state_73237;
(statearr_73310[(23)] = inst_73097);

return statearr_73310;
})();
if(inst_73098){
var statearr_73311_73389 = state_73237__$1;
(statearr_73311_73389[(1)] = (18));

} else {
var statearr_73312_73390 = state_73237__$1;
(statearr_73312_73390[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (38))){
var inst_73158 = (state_73237[(2)]);
var state_73237__$1 = state_73237;
var statearr_73313_73391 = state_73237__$1;
(statearr_73313_73391[(2)] = inst_73158);

(statearr_73313_73391[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (30))){
var inst_73131 = (state_73237[(8)]);
var inst_73146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73147 = [inst_73131,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_73148 = (new cljs.core.PersistentVector(null,2,(5),inst_73146,inst_73147,null));
var state_73237__$1 = state_73237;
var statearr_73314_73392 = state_73237__$1;
(statearr_73314_73392[(2)] = inst_73148);

(statearr_73314_73392[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (10))){
var inst_73063 = (state_73237[(7)]);
var inst_73054 = (state_73237[(21)]);
var inst_73078 = (inst_73063 - (1));
var inst_73079 = fluree.db.time_travel.as_of_block.call(null,inst_73054,inst_73078);
var state_73237__$1 = state_73237;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73237__$1,(13),inst_73079);
} else {
if((state_val_73238 === (18))){
var inst_73050 = (state_73237[(16)]);
var inst_73100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73101 = [inst_73050];
var inst_73102 = (new cljs.core.PersistentVector(null,1,(5),inst_73100,inst_73101,null));
var state_73237__$1 = state_73237;
var statearr_73315_73393 = state_73237__$1;
(statearr_73315_73393[(2)] = inst_73102);

(statearr_73315_73393[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (52))){
var state_73237__$1 = state_73237;
var statearr_73316_73394 = state_73237__$1;
(statearr_73316_73394[(2)] = null);

(statearr_73316_73394[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (42))){
var inst_73140 = (state_73237[(10)]);
var inst_73173 = (state_73237[(20)]);
var inst_73172 = (inst_73140 == null);
var inst_73173__$1 = cljs.core.not.call(null,inst_73172);
var state_73237__$1 = (function (){var statearr_73317 = state_73237;
(statearr_73317[(20)] = inst_73173__$1);

return statearr_73317;
})();
if(inst_73173__$1){
var statearr_73318_73395 = state_73237__$1;
(statearr_73318_73395[(1)] = (45));

} else {
var statearr_73319_73396 = state_73237__$1;
(statearr_73319_73396[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (37))){
var inst_73153 = (state_73237[(26)]);
var state_73237__$1 = state_73237;
var statearr_73320_73397 = state_73237__$1;
(statearr_73320_73397[(2)] = inst_73153);

(statearr_73320_73397[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (8))){
var inst_73063 = (state_73237[(7)]);
var state_73237__$1 = state_73237;
var statearr_73321_73398 = state_73237__$1;
(statearr_73321_73398[(2)] = inst_73063);

(statearr_73321_73398[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73238 === (49))){
var state_73237__$1 = state_73237;
var statearr_73322_73399 = state_73237__$1;
(statearr_73322_73399[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_73324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73324[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_73324[(1)] = (1));

return statearr_73324;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_73237){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73237);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73325){var ex__2749__auto__ = e73325;
var statearr_73326_73400 = state_73237;
(statearr_73326_73400[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73237[(4)]))){
var statearr_73327_73401 = state_73237;
(statearr_73327_73401[(1)] = cljs.core.first.call(null,(state_73237[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73402 = state_73237;
state_73237 = G__73402;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_73237){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_73237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73328 = f__2769__auto__.call(null);
(statearr_73328[(6)] = c__2768__auto__);

return statearr_73328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__73410 = arguments.length;
switch (G__73410) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__73403_SHARP_){
return cljs.core.dissoc.call(null,p1__73403_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73499){
var state_val_73500 = (state_73499[(1)]);
if((state_val_73500 === (7))){
var inst_73460 = (state_73499[(7)]);
var inst_73456 = (state_73499[(8)]);
var inst_73453 = (state_73499[(9)]);
var inst_73450 = (state_73499[(10)]);
var inst_73466 = (function (){var responses = inst_73450;
var responses_STAR_ = inst_73453;
var statuses = inst_73456;
var fuel = inst_73460;
return (function (p1__73406_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__73406_SHARP_);
});
})();
var inst_73467 = cljs.core.some.call(null,inst_73466,inst_73456);
var state_73499__$1 = state_73499;
if(cljs.core.truth_(inst_73467)){
var statearr_73501_73549 = state_73499__$1;
(statearr_73501_73549[(1)] = (9));

} else {
var statearr_73502_73550 = state_73499__$1;
(statearr_73502_73550[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (20))){
var inst_73494 = (state_73499[(2)]);
var state_73499__$1 = state_73499;
var statearr_73503_73551 = state_73499__$1;
(statearr_73503_73551[(2)] = inst_73494);

(statearr_73503_73551[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (1))){
var inst_73445 = cljs.core.async.chan.call(null,(1));
var inst_73446 = (function (){var c__2768__auto____$1 = inst_73445;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73443){
var state_val_73444 = (state_73443[(1)]);
if((state_val_73444 === (1))){
var inst_73411 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_73412 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_73413 = cljs.core.assoc.call(null,inst_73412,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_73414 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_73415 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_73416 = cljs.core.PersistentHashMap.EMPTY;
var inst_73417 = inst_73411;
var inst_73418 = inst_73413;
var inst_73419 = inst_73414;
var inst_73420 = inst_73415;
var inst_73421 = inst_73416;
var state_73443__$1 = (function (){var statearr_73504 = state_73443;
(statearr_73504[(7)] = inst_73419);

(statearr_73504[(8)] = inst_73421);

(statearr_73504[(9)] = inst_73417);

(statearr_73504[(10)] = inst_73420);

(statearr_73504[(11)] = inst_73418);

return statearr_73504;
})();
var statearr_73505_73552 = state_73443__$1;
(statearr_73505_73552[(2)] = null);

(statearr_73505_73552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73444 === (2))){
var inst_73418 = (state_73443[(11)]);
var inst_73423 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_73418);
var inst_73424 = cljs.core.merge.call(null,opts,inst_73423);
var inst_73425 = cljs.core.assoc.call(null,inst_73418,new cljs.core.Keyword(null,"opts","opts",155075701),inst_73424);
var inst_73426 = fluree.db.api_js.query_async.call(null,db,inst_73425,db_fn);
var state_73443__$1 = state_73443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73443__$1,(4),inst_73426);
} else {
if((state_val_73444 === (3))){
var inst_73441 = (state_73443[(2)]);
var state_73443__$1 = state_73443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73443__$1,inst_73441);
} else {
if((state_val_73444 === (4))){
var inst_73419 = (state_73443[(7)]);
var inst_73421 = (state_73443[(8)]);
var inst_73417 = (state_73443[(9)]);
var inst_73428 = (state_73443[(2)]);
var inst_73429 = cljs.core.assoc.call(null,inst_73421,inst_73417,inst_73428);
var inst_73430 = cljs.core.first.call(null,inst_73419);
var state_73443__$1 = (function (){var statearr_73506 = state_73443;
(statearr_73506[(12)] = inst_73429);

return statearr_73506;
})();
if(cljs.core.truth_(inst_73430)){
var statearr_73507_73553 = state_73443__$1;
(statearr_73507_73553[(1)] = (5));

} else {
var statearr_73508_73554 = state_73443__$1;
(statearr_73508_73554[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73444 === (5))){
var inst_73419 = (state_73443[(7)]);
var inst_73429 = (state_73443[(12)]);
var inst_73420 = (state_73443[(10)]);
var inst_73432 = cljs.core.first.call(null,inst_73419);
var inst_73433 = cljs.core.first.call(null,inst_73420);
var inst_73434 = cljs.core.rest.call(null,inst_73419);
var inst_73435 = cljs.core.rest.call(null,inst_73420);
var inst_73417 = inst_73432;
var inst_73418 = inst_73433;
var inst_73419__$1 = inst_73434;
var inst_73420__$1 = inst_73435;
var inst_73421 = inst_73429;
var state_73443__$1 = (function (){var statearr_73509 = state_73443;
(statearr_73509[(7)] = inst_73419__$1);

(statearr_73509[(8)] = inst_73421);

(statearr_73509[(9)] = inst_73417);

(statearr_73509[(10)] = inst_73420__$1);

(statearr_73509[(11)] = inst_73418);

return statearr_73509;
})();
var statearr_73510_73555 = state_73443__$1;
(statearr_73510_73555[(2)] = null);

(statearr_73510_73555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73444 === (6))){
var inst_73429 = (state_73443[(12)]);
var state_73443__$1 = state_73443;
var statearr_73511_73556 = state_73443__$1;
(statearr_73511_73556[(2)] = inst_73429);

(statearr_73511_73556[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73444 === (7))){
var inst_73439 = (state_73443[(2)]);
var state_73443__$1 = state_73443;
var statearr_73512_73557 = state_73443__$1;
(statearr_73512_73557[(2)] = inst_73439);

(statearr_73512_73557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_73513 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73513[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_73513[(1)] = (1));

return statearr_73513;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_73443){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73514){var ex__2749__auto__ = e73514;
var statearr_73515_73558 = state_73443;
(statearr_73515_73558[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73443[(4)]))){
var statearr_73516_73559 = state_73443;
(statearr_73516_73559[(1)] = cljs.core.first.call(null,(state_73443[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73560 = state_73443;
state_73443 = G__73560;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_73443){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_73443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73517 = f__2769__auto__.call(null);
(statearr_73517[(6)] = c__2768__auto____$1);

return statearr_73517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_73447 = cljs.core.async.impl.dispatch.run.call(null,inst_73446);
var state_73499__$1 = (function (){var statearr_73518 = state_73499;
(statearr_73518[(11)] = inst_73447);

return statearr_73518;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73499__$1,(2),inst_73445);
} else {
if((state_val_73500 === (4))){
var inst_73450 = (state_73499[(10)]);
var state_73499__$1 = state_73499;
var statearr_73519_73561 = state_73499__$1;
(statearr_73519_73561[(2)] = inst_73450);

(statearr_73519_73561[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (15))){
var state_73499__$1 = state_73499;
var statearr_73520_73562 = state_73499__$1;
(statearr_73520_73562[(2)] = (400));

(statearr_73520_73562[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (13))){
var state_73499__$1 = state_73499;
var statearr_73521_73563 = state_73499__$1;
(statearr_73521_73563[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (6))){
var inst_73456 = (state_73499[(8)]);
var inst_73464 = cljs.core.first.call(null,inst_73456);
var state_73499__$1 = state_73499;
var statearr_73523_73564 = state_73499__$1;
(statearr_73523_73564[(2)] = inst_73464);

(statearr_73523_73564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (17))){
var inst_73477 = (state_73499[(2)]);
var state_73499__$1 = state_73499;
var statearr_73524_73565 = state_73499__$1;
(statearr_73524_73565[(2)] = inst_73477);

(statearr_73524_73565[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (3))){
var inst_73460 = (state_73499[(7)]);
var inst_73456 = (state_73499[(8)]);
var inst_73453 = (state_73499[(9)]);
var inst_73450 = (state_73499[(10)]);
var inst_73455 = cljs.core.vals.call(null,inst_73450);
var inst_73456__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_73455);
var inst_73457 = (function (){var responses = inst_73450;
var responses_STAR_ = inst_73453;
var statuses = inst_73456__$1;
return (function (p1__73404_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__73404_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_73458 = cljs.core.vals.call(null,inst_73450);
var inst_73459 = cljs.core.map.call(null,inst_73457,inst_73458);
var inst_73460__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_73459);
var inst_73461 = (function (){var responses = inst_73450;
var responses_STAR_ = inst_73453;
var statuses = inst_73456__$1;
var fuel = inst_73460__$1;
return (function (p1__73405_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__73405_SHARP_);
});
})();
var inst_73462 = cljs.core.every_QMARK_.call(null,inst_73461,inst_73456__$1);
var state_73499__$1 = (function (){var statearr_73525 = state_73499;
(statearr_73525[(7)] = inst_73460__$1);

(statearr_73525[(8)] = inst_73456__$1);

return statearr_73525;
})();
if(inst_73462){
var statearr_73526_73566 = state_73499__$1;
(statearr_73526_73566[(1)] = (6));

} else {
var statearr_73527_73567 = state_73499__$1;
(statearr_73527_73567[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (12))){
var state_73499__$1 = state_73499;
var statearr_73528_73568 = state_73499__$1;
(statearr_73528_73568[(2)] = (500));

(statearr_73528_73568[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (2))){
var inst_73450 = (state_73499[(10)]);
var inst_73449 = (state_73499[(2)]);
var inst_73450__$1 = fluree.db.util.async.throw_err.call(null,inst_73449);
var inst_73451 = (function (){var responses = inst_73450__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_73452 = cljs.core.PersistentHashMap.EMPTY;
var inst_73453 = cljs.core.reduce_kv.call(null,inst_73451,inst_73452,inst_73450__$1);
var state_73499__$1 = (function (){var statearr_73529 = state_73499;
(statearr_73529[(9)] = inst_73453);

(statearr_73529[(10)] = inst_73450__$1);

return statearr_73529;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_73530_73569 = state_73499__$1;
(statearr_73530_73569[(1)] = (3));

} else {
var statearr_73531_73570 = state_73499__$1;
(statearr_73531_73570[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (19))){
var inst_73460 = (state_73499[(7)]);
var inst_73483 = (state_73499[(12)]);
var inst_73453 = (state_73499[(9)]);
var inst_73492 = cljs.core.assoc.call(null,inst_73453,new cljs.core.Keyword(null,"status","status",-1997798413),inst_73483,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_73460);
var state_73499__$1 = state_73499;
var statearr_73532_73571 = state_73499__$1;
(statearr_73532_73571[(2)] = inst_73492);

(statearr_73532_73571[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (11))){
var inst_73481 = (state_73499[(2)]);
var state_73499__$1 = state_73499;
var statearr_73533_73572 = state_73499__$1;
(statearr_73533_73572[(2)] = inst_73481);

(statearr_73533_73572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (9))){
var state_73499__$1 = state_73499;
var statearr_73534_73573 = state_73499__$1;
(statearr_73534_73573[(2)] = (207));

(statearr_73534_73573[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (5))){
var inst_73497 = (state_73499[(2)]);
var state_73499__$1 = state_73499;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73499__$1,inst_73497);
} else {
if((state_val_73500 === (14))){
var inst_73479 = (state_73499[(2)]);
var state_73499__$1 = state_73499;
var statearr_73535_73574 = state_73499__$1;
(statearr_73535_73574[(2)] = inst_73479);

(statearr_73535_73574[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (16))){
var state_73499__$1 = state_73499;
var statearr_73536_73575 = state_73499__$1;
(statearr_73536_73575[(2)] = null);

(statearr_73536_73575[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (10))){
var inst_73460 = (state_73499[(7)]);
var inst_73456 = (state_73499[(8)]);
var inst_73453 = (state_73499[(9)]);
var inst_73450 = (state_73499[(10)]);
var inst_73470 = (function (){var responses = inst_73450;
var responses_STAR_ = inst_73453;
var statuses = inst_73456;
var fuel = inst_73460;
return (function (p1__73407_SHARP_){
return ((499) < p1__73407_SHARP_);
});
})();
var inst_73471 = cljs.core.some.call(null,inst_73470,inst_73456);
var state_73499__$1 = state_73499;
if(cljs.core.truth_(inst_73471)){
var statearr_73537_73576 = state_73499__$1;
(statearr_73537_73576[(1)] = (12));

} else {
var statearr_73538_73577 = state_73499__$1;
(statearr_73538_73577[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (18))){
var inst_73460 = (state_73499[(7)]);
var inst_73483 = (state_73499[(12)]);
var inst_73453 = (state_73499[(9)]);
var inst_73488 = (state_73499[(13)]);
var inst_73490 = cljs.core.assoc.call(null,inst_73453,new cljs.core.Keyword(null,"status","status",-1997798413),inst_73483,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_73460,new cljs.core.Keyword(null,"block","block",664686210),inst_73488);
var state_73499__$1 = state_73499;
var statearr_73539_73578 = state_73499__$1;
(statearr_73539_73578[(2)] = inst_73490);

(statearr_73539_73578[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73500 === (8))){
var inst_73460 = (state_73499[(7)]);
var inst_73456 = (state_73499[(8)]);
var inst_73483 = (state_73499[(12)]);
var inst_73453 = (state_73499[(9)]);
var inst_73488 = (state_73499[(13)]);
var inst_73450 = (state_73499[(10)]);
var inst_73483__$1 = (state_73499[(2)]);
var inst_73484 = (function (){var responses = inst_73450;
var responses_STAR_ = inst_73453;
var statuses = inst_73456;
var fuel = inst_73460;
var status = inst_73483__$1;
return (function (p1__73408_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__73408_SHARP_));
});
})();
var inst_73485 = cljs.core.vals.call(null,inst_73450);
var inst_73486 = cljs.core.filter.call(null,inst_73484,inst_73485);
var inst_73487 = cljs.core.first.call(null,inst_73486);
var inst_73488__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_73487);
var state_73499__$1 = (function (){var statearr_73540 = state_73499;
(statearr_73540[(12)] = inst_73483__$1);

(statearr_73540[(13)] = inst_73488__$1);

return statearr_73540;
})();
if(cljs.core.truth_(inst_73488__$1)){
var statearr_73541_73579 = state_73499__$1;
(statearr_73541_73579[(1)] = (18));

} else {
var statearr_73542_73580 = state_73499__$1;
(statearr_73542_73580[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_73543 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73543[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_73543[(1)] = (1));

return statearr_73543;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_73499){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73544){var ex__2749__auto__ = e73544;
var statearr_73545_73581 = state_73499;
(statearr_73545_73581[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73499[(4)]))){
var statearr_73546_73582 = state_73499;
(statearr_73546_73582[(1)] = cljs.core.first.call(null,(state_73499[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73583 = state_73499;
state_73499 = G__73583;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_73499){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_73499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73547 = f__2769__auto__.call(null);
(statearr_73547[(6)] = c__2768__auto__);

return statearr_73547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__73585 = arguments.length;
switch (G__73585) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__73586 = opts;
var map__73586__$1 = cljs.core.__destructure_map.call(null,map__73586);
var auth = cljs.core.get.call(null,map__73586__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__73586__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__73586__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__73586__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__73587 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__73587,(0),null);
var authority = cljs.core.nth.call(null,vec__73587,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e73590){var e = e73590;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__73593 = arguments.length;
switch (G__73593) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73627){
var state_val_73628 = (state_73627[(1)]);
if((state_val_73628 === (7))){
var state_73627__$1 = state_73627;
var statearr_73629_73650 = state_73627__$1;
(statearr_73629_73650[(2)] = opts);

(statearr_73629_73650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73628 === (1))){
var state_73627__$1 = state_73627;
var statearr_73630_73651 = state_73627__$1;
(statearr_73630_73651[(2)] = null);

(statearr_73630_73651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73628 === (4))){
var inst_73594 = (state_73627[(2)]);
var inst_73595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73596 = [inst_73594];
var inst_73597 = (new cljs.core.PersistentVector(null,1,(5),inst_73595,inst_73596,null));
var inst_73598 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73597);
var inst_73599 = cljs.core.ex_data.call(null,inst_73594);
var inst_73600 = cljs.core.ex_message.call(null,inst_73594);
var inst_73601 = cljs.core.assoc.call(null,inst_73599,new cljs.core.Keyword(null,"message","message",-406056002),inst_73600);
var state_73627__$1 = (function (){var statearr_73631 = state_73627;
(statearr_73631[(7)] = inst_73598);

return statearr_73631;
})();
var statearr_73632_73652 = state_73627__$1;
(statearr_73632_73652[(2)] = inst_73601);

(statearr_73632_73652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73628 === (6))){
var inst_73611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73612 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_73613 = (new cljs.core.PersistentVector(null,1,(5),inst_73611,inst_73612,null));
var inst_73614 = cljs.core.assoc_in.call(null,opts,inst_73613,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_73627__$1 = state_73627;
var statearr_73633_73653 = state_73627__$1;
(statearr_73633_73653[(2)] = inst_73614);

(statearr_73633_73653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73628 === (3))){
var inst_73625 = (state_73627[(2)]);
var state_73627__$1 = state_73627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73627__$1,inst_73625);
} else {
if((state_val_73628 === (2))){
var _ = (function (){var statearr_73635 = state_73627;
(statearr_73635[(4)] = cljs.core.cons.call(null,(5),(state_73627[(4)])));

return statearr_73635;
})();
var inst_73607 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_73608 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_73609 = (inst_73608 == null);
var state_73627__$1 = (function (){var statearr_73636 = state_73627;
(statearr_73636[(8)] = inst_73607);

return statearr_73636;
})();
if(cljs.core.truth_(inst_73609)){
var statearr_73637_73654 = state_73627__$1;
(statearr_73637_73654[(1)] = (6));

} else {
var statearr_73638_73655 = state_73627__$1;
(statearr_73638_73655[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73628 === (9))){
var inst_73621 = (state_73627[(2)]);
var inst_73622 = fluree.db.util.async.throw_err.call(null,inst_73621);
var _ = (function (){var statearr_73639 = state_73627;
(statearr_73639[(4)] = cljs.core.rest.call(null,(state_73627[(4)])));

return statearr_73639;
})();
var state_73627__$1 = state_73627;
var statearr_73640_73656 = state_73627__$1;
(statearr_73640_73656[(2)] = inst_73622);

(statearr_73640_73656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73628 === (5))){
var _ = (function (){var statearr_73641 = state_73627;
(statearr_73641[(4)] = cljs.core.rest.call(null,(state_73627[(4)])));

return statearr_73641;
})();
var state_73627__$1 = state_73627;
var ex73634 = (state_73627__$1[(2)]);
var statearr_73642_73657 = state_73627__$1;
(statearr_73642_73657[(5)] = ex73634);


var statearr_73643_73658 = state_73627__$1;
(statearr_73643_73658[(1)] = (4));

(statearr_73643_73658[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73628 === (8))){
var inst_73607 = (state_73627[(8)]);
var inst_73617 = (state_73627[(2)]);
var inst_73618 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_73607,inst_73617);
var inst_73619 = fluree.db.operations.command_async.call(null,conn,inst_73618);
var state_73627__$1 = state_73627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73627__$1,(9),inst_73619);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_73644 = [null,null,null,null,null,null,null,null,null];
(statearr_73644[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_73644[(1)] = (1));

return statearr_73644;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_73627){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73645){var ex__2749__auto__ = e73645;
var statearr_73646_73659 = state_73627;
(statearr_73646_73659[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73627[(4)]))){
var statearr_73647_73660 = state_73627;
(statearr_73647_73660[(1)] = cljs.core.first.call(null,(state_73627[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73661 = state_73627;
state_73627 = G__73661;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_73627){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_73627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73648 = f__2769__auto__.call(null);
(statearr_73648[(6)] = c__2768__auto__);

return statearr_73648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

