// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.call(null,"set websocket id:",ws_id);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.call(null,"process event:",event_type,event_data);

var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__13918 = cljs.core.seq.call(null,callbacks);
var chunk__13919 = null;
var count__13920 = (0);
var i__13921 = (0);
while(true){
if((i__13921 < count__13920)){
var vec__13930 = cljs.core._nth.call(null,chunk__13919,i__13921);
var k = cljs.core.nth.call(null,vec__13930,(0),null);
var f = cljs.core.nth.call(null,vec__13930,(1),null);
try{f.call(null,event_type,event_data);
}catch (e13933){var e_13938 = e13933;
fluree.db.util.log.error.call(null,e_13938,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__13939 = seq__13918;
var G__13940 = chunk__13919;
var G__13941 = count__13920;
var G__13942 = (i__13921 + (1));
seq__13918 = G__13939;
chunk__13919 = G__13940;
count__13920 = G__13941;
i__13921 = G__13942;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__13918);
if(temp__5804__auto__){
var seq__13918__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13918__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__13918__$1);
var G__13943 = cljs.core.chunk_rest.call(null,seq__13918__$1);
var G__13944 = c__5568__auto__;
var G__13945 = cljs.core.count.call(null,c__5568__auto__);
var G__13946 = (0);
seq__13918 = G__13943;
chunk__13919 = G__13944;
count__13920 = G__13945;
i__13921 = G__13946;
continue;
} else {
var vec__13934 = cljs.core.first.call(null,seq__13918__$1);
var k = cljs.core.nth.call(null,vec__13934,(0),null);
var f = cljs.core.nth.call(null,vec__13934,(1),null);
try{f.call(null,event_type,event_data);
}catch (e13937){var e_13947 = e13937;
fluree.db.util.log.error.call(null,e_13947,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__13948 = cljs.core.next.call(null,seq__13918__$1);
var G__13949 = null;
var G__13950 = (0);
var G__13951 = (0);
seq__13918 = G__13948;
chunk__13919 = G__13949;
count__13920 = G__13950;
i__13921 = G__13951;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__13954 = msg;
var event_type = cljs.core.nth.call(null,vec__13954,(0),null);
var subject = cljs.core.nth.call(null,vec__13954,(1),null);
var event_data = cljs.core.nth.call(null,vec__13954,(2),null);
var error_data = cljs.core.nth.call(null,vec__13954,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__13957 = conn;
var map__13957__$1 = cljs.core.__destructure_map.call(null,map__13957);
var state = cljs.core.get.call(null,map__13957__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__13958 = event_type__$1;
var G__13958__$1 = (((G__13958 instanceof cljs.core.Keyword))?G__13958.fqn:null);
switch (G__13958__$1) {
case "response":
var temp__5804__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5804__auto__)){
var res_chan = temp__5804__auto__;
fluree.db.util.log.trace.call(null,"Found response channel for subject",subject);

cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__13952_SHARP_){
return cljs.core.dissoc.call(null,p1__13952_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__13959 = error_data;
var map__13959__$1 = cljs.core.__destructure_map.call(null,map__13959);
var message = cljs.core.get.call(null,map__13959__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e13953){var e = e13953;
return fluree.db.util.log.error.call(null,e);
}});
