// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__69947_70128 = cljs.core.seq.call(null,servers);
var chunk__69948_70129 = null;
var count__69949_70130 = (0);
var i__69950_70131 = (0);
while(true){
if((i__69950_70131 < count__69949_70130)){
var server_70132 = cljs.core._nth.call(null,chunk__69948_70129,i__69950_70131);
var healthcheck_uri_70133 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_70132),"/fdb/health"].join('');
var resp_chan_70134 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_70133,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___70135 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70135,healthcheck_uri_70133,resp_chan_70134,server_70132){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70135,healthcheck_uri_70133,resp_chan_70134,server_70132){
return (function (state_70020){
var state_val_70021 = (state_70020[(1)]);
if((state_val_70021 === (1))){
var state_70020__$1 = state_70020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70020__$1,(2),resp_chan_70134);
} else {
if((state_val_70021 === (2))){
var inst_70006 = (state_70020[(7)]);
var inst_70006__$1 = (state_70020[(2)]);
var inst_70007 = fluree.db.util.core.exception_QMARK_.call(null,inst_70006__$1);
var state_70020__$1 = (function (){var statearr_70022 = state_70020;
(statearr_70022[(7)] = inst_70006__$1);

return statearr_70022;
})();
if(inst_70007){
var statearr_70023_70136 = state_70020__$1;
(statearr_70023_70136[(1)] = (3));

} else {
var statearr_70024_70137 = state_70020__$1;
(statearr_70024_70137[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70021 === (3))){
var inst_70006 = (state_70020[(7)]);
var inst_70009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70010 = cljs.core.ex_message.call(null,inst_70006);
var inst_70011 = cljs.core.ex_data.call(null,inst_70006);
var inst_70012 = ["Server contact error: ",inst_70010,inst_70011];
var inst_70013 = (new cljs.core.PersistentVector(null,3,(5),inst_70009,inst_70012,null));
var inst_70014 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70013);
var state_70020__$1 = state_70020;
var statearr_70025_70138 = state_70020__$1;
(statearr_70025_70138[(2)] = inst_70014);

(statearr_70025_70138[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70021 === (4))){
var inst_70016 = cljs.core.async.put_BANG_.call(null,promise_chan,server_70132);
var state_70020__$1 = state_70020;
var statearr_70026_70139 = state_70020__$1;
(statearr_70026_70139[(2)] = inst_70016);

(statearr_70026_70139[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70021 === (5))){
var inst_70018 = (state_70020[(2)]);
var state_70020__$1 = state_70020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70020__$1,inst_70018);
} else {
return null;
}
}
}
}
}
});})(seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70135,healthcheck_uri_70133,resp_chan_70134,server_70132))
;
return ((function (seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,switch__2745__auto__,c__2768__auto___70135,healthcheck_uri_70133,resp_chan_70134,server_70132){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_70027 = [null,null,null,null,null,null,null,null];
(statearr_70027[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_70027[(1)] = (1));

return statearr_70027;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_70020){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70028){var ex__2749__auto__ = e70028;
var statearr_70029_70140 = state_70020;
(statearr_70029_70140[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70020[(4)]))){
var statearr_70030_70141 = state_70020;
(statearr_70030_70141[(1)] = cljs.core.first.call(null,(state_70020[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70142 = state_70020;
state_70020 = G__70142;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_70020){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_70020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,switch__2745__auto__,c__2768__auto___70135,healthcheck_uri_70133,resp_chan_70134,server_70132))
})();
var state__2770__auto__ = (function (){var statearr_70031 = f__2769__auto__.call(null);
(statearr_70031[(6)] = c__2768__auto___70135);

return statearr_70031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70135,healthcheck_uri_70133,resp_chan_70134,server_70132))
);



var G__70143 = seq__69947_70128;
var G__70144 = chunk__69948_70129;
var G__70145 = count__69949_70130;
var G__70146 = (i__69950_70131 + (1));
seq__69947_70128 = G__70143;
chunk__69948_70129 = G__70144;
count__69949_70130 = G__70145;
i__69950_70131 = G__70146;
continue;
} else {
var temp__5804__auto___70147 = cljs.core.seq.call(null,seq__69947_70128);
if(temp__5804__auto___70147){
var seq__69947_70148__$1 = temp__5804__auto___70147;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__69947_70148__$1)){
var c__5568__auto___70149 = cljs.core.chunk_first.call(null,seq__69947_70148__$1);
var G__70150 = cljs.core.chunk_rest.call(null,seq__69947_70148__$1);
var G__70151 = c__5568__auto___70149;
var G__70152 = cljs.core.count.call(null,c__5568__auto___70149);
var G__70153 = (0);
seq__69947_70128 = G__70150;
chunk__69948_70129 = G__70151;
count__69949_70130 = G__70152;
i__69950_70131 = G__70153;
continue;
} else {
var server_70154 = cljs.core.first.call(null,seq__69947_70148__$1);
var healthcheck_uri_70155 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_70154),"/fdb/health"].join('');
var resp_chan_70156 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_70155,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___70157 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70157,healthcheck_uri_70155,resp_chan_70156,server_70154,seq__69947_70148__$1,temp__5804__auto___70147){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70157,healthcheck_uri_70155,resp_chan_70156,server_70154,seq__69947_70148__$1,temp__5804__auto___70147){
return (function (state_70047){
var state_val_70048 = (state_70047[(1)]);
if((state_val_70048 === (1))){
var state_70047__$1 = state_70047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70047__$1,(2),resp_chan_70156);
} else {
if((state_val_70048 === (2))){
var inst_70033 = (state_70047[(7)]);
var inst_70033__$1 = (state_70047[(2)]);
var inst_70034 = fluree.db.util.core.exception_QMARK_.call(null,inst_70033__$1);
var state_70047__$1 = (function (){var statearr_70049 = state_70047;
(statearr_70049[(7)] = inst_70033__$1);

return statearr_70049;
})();
if(inst_70034){
var statearr_70050_70158 = state_70047__$1;
(statearr_70050_70158[(1)] = (3));

} else {
var statearr_70051_70159 = state_70047__$1;
(statearr_70051_70159[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70048 === (3))){
var inst_70033 = (state_70047[(7)]);
var inst_70036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70037 = cljs.core.ex_message.call(null,inst_70033);
var inst_70038 = cljs.core.ex_data.call(null,inst_70033);
var inst_70039 = ["Server contact error: ",inst_70037,inst_70038];
var inst_70040 = (new cljs.core.PersistentVector(null,3,(5),inst_70036,inst_70039,null));
var inst_70041 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70040);
var state_70047__$1 = state_70047;
var statearr_70052_70160 = state_70047__$1;
(statearr_70052_70160[(2)] = inst_70041);

(statearr_70052_70160[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70048 === (4))){
var inst_70043 = cljs.core.async.put_BANG_.call(null,promise_chan,server_70154);
var state_70047__$1 = state_70047;
var statearr_70053_70161 = state_70047__$1;
(statearr_70053_70161[(2)] = inst_70043);

(statearr_70053_70161[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70048 === (5))){
var inst_70045 = (state_70047[(2)]);
var state_70047__$1 = state_70047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70047__$1,inst_70045);
} else {
return null;
}
}
}
}
}
});})(seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70157,healthcheck_uri_70155,resp_chan_70156,server_70154,seq__69947_70148__$1,temp__5804__auto___70147))
;
return ((function (seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,switch__2745__auto__,c__2768__auto___70157,healthcheck_uri_70155,resp_chan_70156,server_70154,seq__69947_70148__$1,temp__5804__auto___70147){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_70054 = [null,null,null,null,null,null,null,null];
(statearr_70054[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_70054[(1)] = (1));

return statearr_70054;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_70047){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70055){var ex__2749__auto__ = e70055;
var statearr_70056_70162 = state_70047;
(statearr_70056_70162[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70047[(4)]))){
var statearr_70057_70163 = state_70047;
(statearr_70057_70163[(1)] = cljs.core.first.call(null,(state_70047[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70164 = state_70047;
state_70047 = G__70164;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_70047){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_70047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,switch__2745__auto__,c__2768__auto___70157,healthcheck_uri_70155,resp_chan_70156,server_70154,seq__69947_70148__$1,temp__5804__auto___70147))
})();
var state__2770__auto__ = (function (){var statearr_70058 = f__2769__auto__.call(null);
(statearr_70058[(6)] = c__2768__auto___70157);

return statearr_70058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__69947_70128,chunk__69948_70129,count__69949_70130,i__69950_70131,c__2768__auto___70157,healthcheck_uri_70155,resp_chan_70156,server_70154,seq__69947_70148__$1,temp__5804__auto___70147))
);



var G__70165 = cljs.core.next.call(null,seq__69947_70148__$1);
var G__70166 = null;
var G__70167 = (0);
var G__70168 = (0);
seq__69947_70128 = G__70165;
chunk__69948_70129 = G__70166;
count__69949_70130 = G__70167;
i__69950_70131 = G__70168;
continue;
}
} else {
}
}
break;
}

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70102){
var state_val_70103 = (state_70102[(1)]);
if((state_val_70103 === (7))){
var inst_70074 = (state_70102[(7)]);
var inst_70081 = cljs.core._EQ_.call(null,inst_70074,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_70102__$1 = state_70102;
if(inst_70081){
var statearr_70104_70169 = state_70102__$1;
(statearr_70104_70169[(1)] = (9));

} else {
var statearr_70105_70170 = state_70102__$1;
(statearr_70105_70170[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (1))){
var inst_70066 = (state_70102[(8)]);
var inst_70067 = (state_70102[(9)]);
var inst_70066__$1 = promise_chan;
var inst_70067__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_70068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70069 = [inst_70066__$1,inst_70067__$1];
var inst_70070 = (new cljs.core.PersistentVector(null,2,(5),inst_70068,inst_70069,null));
var state_70102__$1 = (function (){var statearr_70106 = state_70102;
(statearr_70106[(8)] = inst_70066__$1);

(statearr_70106[(9)] = inst_70067__$1);

return statearr_70106;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70102__$1,(2),inst_70070);
} else {
if((state_val_70103 === (4))){
var inst_70074 = (state_70102[(7)]);
var inst_70067 = (state_70102[(9)]);
var inst_70078 = cljs.core._EQ_.call(null,inst_70074,inst_70067);
var state_70102__$1 = state_70102;
if(inst_70078){
var statearr_70107_70171 = state_70102__$1;
(statearr_70107_70171[(1)] = (6));

} else {
var statearr_70108_70172 = state_70102__$1;
(statearr_70108_70172[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (13))){
var state_70102__$1 = state_70102;
var statearr_70109_70173 = state_70102__$1;
(statearr_70109_70173[(2)] = null);

(statearr_70109_70173[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (6))){
var state_70102__$1 = state_70102;
var statearr_70110_70174 = state_70102__$1;
(statearr_70110_70174[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_70110_70174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (3))){
var state_70102__$1 = state_70102;
var statearr_70111_70175 = state_70102__$1;
(statearr_70111_70175[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_70111_70175[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (12))){
var inst_70092 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_70093 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70094 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_70095 = cljs.core.PersistentHashMap.fromArrays(inst_70093,inst_70094);
var inst_70096 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_70095);
var inst_70097 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_70096);
var state_70102__$1 = (function (){var statearr_70112 = state_70102;
(statearr_70112[(10)] = inst_70092);

return statearr_70112;
})();
var statearr_70113_70176 = state_70102__$1;
(statearr_70113_70176[(2)] = inst_70097);

(statearr_70113_70176[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (2))){
var inst_70066 = (state_70102[(8)]);
var inst_70074 = (state_70102[(7)]);
var inst_70072 = (state_70102[(2)]);
var inst_70073 = cljs.core.nth.call(null,inst_70072,(0),null);
var inst_70074__$1 = cljs.core.nth.call(null,inst_70072,(1),null);
var inst_70075 = cljs.core._EQ_.call(null,inst_70074__$1,inst_70066);
var state_70102__$1 = (function (){var statearr_70114 = state_70102;
(statearr_70114[(11)] = inst_70073);

(statearr_70114[(7)] = inst_70074__$1);

return statearr_70114;
})();
if(inst_70075){
var statearr_70115_70177 = state_70102__$1;
(statearr_70115_70177[(1)] = (3));

} else {
var statearr_70116_70178 = state_70102__$1;
(statearr_70116_70178[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (11))){
var inst_70085 = (state_70102[(2)]);
var state_70102__$1 = state_70102;
var statearr_70117_70179 = state_70102__$1;
(statearr_70117_70179[(2)] = inst_70085);

(statearr_70117_70179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (9))){
var inst_70073 = (state_70102[(11)]);
var state_70102__$1 = state_70102;
var statearr_70118_70180 = state_70102__$1;
(statearr_70118_70180[(2)] = inst_70073);

(statearr_70118_70180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (5))){
var inst_70089 = (state_70102[(2)]);
var inst_70090 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_70089);
var state_70102__$1 = state_70102;
if(inst_70090){
var statearr_70119_70181 = state_70102__$1;
(statearr_70119_70181[(1)] = (12));

} else {
var statearr_70120_70182 = state_70102__$1;
(statearr_70120_70182[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (14))){
var inst_70100 = (state_70102[(2)]);
var state_70102__$1 = state_70102;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70102__$1,inst_70100);
} else {
if((state_val_70103 === (10))){
var state_70102__$1 = state_70102;
var statearr_70121_70183 = state_70102__$1;
(statearr_70121_70183[(2)] = null);

(statearr_70121_70183[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70103 === (8))){
var inst_70087 = (state_70102[(2)]);
var state_70102__$1 = state_70102;
var statearr_70122_70184 = state_70102__$1;
(statearr_70122_70184[(2)] = inst_70087);

(statearr_70122_70184[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_70123 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70123[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_70123[(1)] = (1));

return statearr_70123;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_70102){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70102);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70124){var ex__2749__auto__ = e70124;
var statearr_70125_70185 = state_70102;
(statearr_70125_70185[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70102[(4)]))){
var statearr_70126_70186 = state_70102;
(statearr_70126_70186[(1)] = cljs.core.first.call(null,(state_70102[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70187 = state_70102;
state_70102 = G__70187;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_70102){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_70102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70127 = f__2769__auto__.call(null);
(statearr_70127[(6)] = c__2768__auto__);

return statearr_70127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70231){
var state_val_70232 = (state_70231[(1)]);
if((state_val_70232 === (7))){
var state_70231__$1 = state_70231;
var statearr_70233_70259 = state_70231__$1;
(statearr_70233_70259[(2)] = null);

(statearr_70233_70259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (1))){
var state_70231__$1 = state_70231;
var statearr_70234_70260 = state_70231__$1;
(statearr_70234_70260[(2)] = null);

(statearr_70234_70260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (4))){
var inst_70188 = (state_70231[(2)]);
var state_70231__$1 = state_70231;
var statearr_70235_70261 = state_70231__$1;
(statearr_70235_70261[(2)] = inst_70188);

(statearr_70235_70261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (6))){
var inst_70210 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_70231__$1 = state_70231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70231__$1,(9),inst_70210);
} else {
if((state_val_70232 === (3))){
var inst_70229 = (state_70231[(2)]);
var state_70231__$1 = state_70231;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70231__$1,inst_70229);
} else {
if((state_val_70232 === (12))){
var inst_70223 = (state_70231[(2)]);
var state_70231__$1 = state_70231;
var statearr_70236_70262 = state_70231__$1;
(statearr_70236_70262[(2)] = inst_70223);

(statearr_70236_70262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (2))){
var inst_70194 = (state_70231[(7)]);
var inst_70204 = (state_70231[(8)]);
var inst_70199 = (state_70231[(9)]);
var _ = (function (){var statearr_70237 = state_70231;
(statearr_70237[(4)] = cljs.core.cons.call(null,(5),(state_70231[(4)])));

return statearr_70237;
})();
var inst_70194__$1 = cljs.core.random_uuid.call(null);
var inst_70195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70196 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_70197 = (new cljs.core.PersistentVector(null,2,(5),inst_70195,inst_70196,null));
var inst_70198 = (function (){var lock_id = inst_70194__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_70199__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_70197,inst_70198);
var inst_70200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70201 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_70202 = (new cljs.core.PersistentVector(null,3,(5),inst_70200,inst_70201,null));
var inst_70203 = cljs.core.get_in.call(null,inst_70199__$1,inst_70202);
var inst_70204__$1 = cljs.core._EQ_.call(null,inst_70194__$1,inst_70203);
var inst_70205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70206 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_70207 = (new cljs.core.PersistentVector(null,3,(5),inst_70205,inst_70206,null));
var inst_70208 = cljs.core.get_in.call(null,inst_70199__$1,inst_70207);
var state_70231__$1 = (function (){var statearr_70238 = state_70231;
(statearr_70238[(10)] = inst_70208);

(statearr_70238[(7)] = inst_70194__$1);

(statearr_70238[(8)] = inst_70204__$1);

(statearr_70238[(9)] = inst_70199__$1);

return statearr_70238;
})();
if(inst_70204__$1){
var statearr_70239_70263 = state_70231__$1;
(statearr_70239_70263[(1)] = (6));

} else {
var statearr_70240_70264 = state_70231__$1;
(statearr_70240_70264[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (11))){
var inst_70215 = (state_70231[(11)]);
var inst_70208 = (state_70231[(10)]);
var inst_70214 = (state_70231[(12)]);
var inst_70221 = fluree.db.util.xhttp.try_socket.call(null,inst_70214,sub_chan,pub_chan,inst_70208,(60000),inst_70215);
var state_70231__$1 = state_70231;
var statearr_70242_70265 = state_70231__$1;
(statearr_70242_70265[(2)] = inst_70221);

(statearr_70242_70265[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (9))){
var inst_70208 = (state_70231[(10)]);
var inst_70194 = (state_70231[(7)]);
var inst_70204 = (state_70231[(8)]);
var inst_70212 = (state_70231[(13)]);
var inst_70214 = (state_70231[(12)]);
var inst_70199 = (state_70231[(9)]);
var inst_70212__$1 = (state_70231[(2)]);
var inst_70213 = clojure.string.replace.call(null,inst_70212__$1,"http","ws");
var inst_70214__$1 = [inst_70213,"/fdb/ws"].join('');
var inst_70215 = (function (){var lock_id = inst_70194;
var state = inst_70199;
var have_lock_QMARK_ = inst_70204;
var resp_chan = inst_70208;
var healthy_server = inst_70212__$1;
var ws_url = inst_70214__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_70216 = fluree.db.util.core.exception_QMARK_.call(null,inst_70212__$1);
var state_70231__$1 = (function (){var statearr_70243 = state_70231;
(statearr_70243[(11)] = inst_70215);

(statearr_70243[(13)] = inst_70212__$1);

(statearr_70243[(12)] = inst_70214__$1);

return statearr_70243;
})();
if(inst_70216){
var statearr_70244_70266 = state_70231__$1;
(statearr_70244_70266[(1)] = (10));

} else {
var statearr_70245_70267 = state_70231__$1;
(statearr_70245_70267[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (5))){
var _ = (function (){var statearr_70246 = state_70231;
(statearr_70246[(4)] = cljs.core.rest.call(null,(state_70231[(4)])));

return statearr_70246;
})();
var state_70231__$1 = state_70231;
var ex70241 = (state_70231__$1[(2)]);
var statearr_70247_70268 = state_70231__$1;
(statearr_70247_70268[(5)] = ex70241);


if((ex70241 instanceof Error)){
var statearr_70248_70269 = state_70231__$1;
(statearr_70248_70269[(1)] = (4));

(statearr_70248_70269[(5)] = null);

} else {
throw ex70241;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (10))){
var inst_70208 = (state_70231[(10)]);
var inst_70212 = (state_70231[(13)]);
var inst_70218 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_70219 = cljs.core.async.put_BANG_.call(null,inst_70208,inst_70212);
var state_70231__$1 = (function (){var statearr_70249 = state_70231;
(statearr_70249[(14)] = inst_70218);

return statearr_70249;
})();
var statearr_70250_70270 = state_70231__$1;
(statearr_70250_70270[(2)] = inst_70219);

(statearr_70250_70270[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70232 === (8))){
var inst_70208 = (state_70231[(10)]);
var inst_70226 = (state_70231[(2)]);
var _ = (function (){var statearr_70251 = state_70231;
(statearr_70251[(4)] = cljs.core.rest.call(null,(state_70231[(4)])));

return statearr_70251;
})();
var state_70231__$1 = (function (){var statearr_70252 = state_70231;
(statearr_70252[(15)] = inst_70226);

return statearr_70252;
})();
var statearr_70253_70271 = state_70231__$1;
(statearr_70253_70271[(2)] = inst_70208);

(statearr_70253_70271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_70254 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70254[(0)] = fluree$db$connection$establish_socket_$_state_machine__2746__auto__);

(statearr_70254[(1)] = (1));

return statearr_70254;
});
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____1 = (function (state_70231){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70255){var ex__2749__auto__ = e70255;
var statearr_70256_70272 = state_70231;
(statearr_70256_70272[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70231[(4)]))){
var statearr_70257_70273 = state_70231;
(statearr_70257_70273[(1)] = cljs.core.first.call(null,(state_70231[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70274 = state_70231;
state_70231 = G__70274;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = function(state_70231){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____1.call(this,state_70231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70258 = f__2769__auto__.call(null);
(statearr_70258[(6)] = c__2768__auto__);

return statearr_70258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k70276,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__70280 = k70276;
var G__70280__$1 = (((G__70280 instanceof cljs.core.Keyword))?G__70280.fqn:null);
switch (G__70280__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k70276,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__70281){
var vec__70282 = p__70281;
var k__5367__auto__ = cljs.core.nth.call(null,vec__70282,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__70282,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__70275){
var self__ = this;
var G__70275__$1 = this;
return (new cljs.core.RecordIter((0),G__70275__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this70277,other70278){
var self__ = this;
var this70277__$1 = this;
return (((!((other70278 == null)))) && ((((this70277__$1.constructor === other70278.constructor)) && (((cljs.core._EQ_.call(null,this70277__$1.id,other70278.id)) && (((cljs.core._EQ_.call(null,this70277__$1.servers,other70278.servers)) && (((cljs.core._EQ_.call(null,this70277__$1.state,other70278.state)) && (((cljs.core._EQ_.call(null,this70277__$1.req_chan,other70278.req_chan)) && (((cljs.core._EQ_.call(null,this70277__$1.sub_chan,other70278.sub_chan)) && (((cljs.core._EQ_.call(null,this70277__$1.pub_chan,other70278.pub_chan)) && (((cljs.core._EQ_.call(null,this70277__$1.group,other70278.group)) && (((cljs.core._EQ_.call(null,this70277__$1.storage_read,other70278.storage_read)) && (((cljs.core._EQ_.call(null,this70277__$1.storage_list,other70278.storage_list)) && (((cljs.core._EQ_.call(null,this70277__$1.storage_write,other70278.storage_write)) && (((cljs.core._EQ_.call(null,this70277__$1.storage_exists,other70278.storage_exists)) && (((cljs.core._EQ_.call(null,this70277__$1.storage_rename,other70278.storage_rename)) && (((cljs.core._EQ_.call(null,this70277__$1.storage_delete,other70278.storage_delete)) && (((cljs.core._EQ_.call(null,this70277__$1.object_cache,other70278.object_cache)) && (((cljs.core._EQ_.call(null,this70277__$1.async_cache,other70278.async_cache)) && (((cljs.core._EQ_.call(null,this70277__$1.parallelism,other70278.parallelism)) && (((cljs.core._EQ_.call(null,this70277__$1.serializer,other70278.serializer)) && (((cljs.core._EQ_.call(null,this70277__$1.default_network,other70278.default_network)) && (((cljs.core._EQ_.call(null,this70277__$1.transactor_QMARK_,other70278.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this70277__$1.publish,other70278.publish)) && (((cljs.core._EQ_.call(null,this70277__$1.transact_handler,other70278.transact_handler)) && (((cljs.core._EQ_.call(null,this70277__$1.tx_private_key,other70278.tx_private_key)) && (((cljs.core._EQ_.call(null,this70277__$1.tx_key_id,other70278.tx_key_id)) && (((cljs.core._EQ_.call(null,this70277__$1.meta,other70278.meta)) && (((cljs.core._EQ_.call(null,this70277__$1.add_listener,other70278.add_listener)) && (((cljs.core._EQ_.call(null,this70277__$1.remove_listener,other70278.remove_listener)) && (((cljs.core._EQ_.call(null,this70277__$1.close,other70278.close)) && (cljs.core._EQ_.call(null,this70277__$1.__extmap,other70278.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__70285){
var self__ = this;
var map__70286 = p__70285;
var map__70286__$1 = cljs.core.__destructure_map.call(null,map__70286);
var node = map__70286__$1;
var id__$1 = cljs.core.get.call(null,map__70286__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__70286__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.call(null,map__70286__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf.call(null,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),(function (_){
return fluree.db.storage.core.resolve_index_node.call(null,conn__$1,node,(function (){
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),null);
}));
}));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k70276){
var self__ = this;
var this__5350__auto____$1 = this;
var G__70287 = k70276;
var G__70287__$1 = (((G__70287 instanceof cljs.core.Keyword))?G__70287.fqn:null);
switch (G__70287__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k70276);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__70275){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__70288 = cljs.core.keyword_identical_QMARK_;
var expr__70289 = k__5352__auto__;
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__70289))){
return (new fluree.db.connection.Connection(G__70275,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,G__70275,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__70275,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__70275,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__70275,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__70275,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__70275,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__70275,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__70275,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__70275,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__70275,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__70275,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__70275,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__70275,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__70275,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__70275,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__70275,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__70275,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__70275,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__70275,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__70275,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__70275,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__70275,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__70275,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__70275,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__70275,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70288.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__70289))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__70275,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__70275),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_read.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return self__.storage_write.call(null,k,data);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_exists.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return self__.storage_rename.call(null,old_key,new_key);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return self__.storage_list.call(null,d);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_delete.call(null,k);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__70275){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__70275,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__70279){
var extmap__5385__auto__ = (function (){var G__70291 = cljs.core.dissoc.call(null,G__70279,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__70279)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__70291);
} else {
return G__70291;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__70279),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__70279),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__70297 = servers_STAR_;
var vec__70298 = G__70297;
var seq__70299 = cljs.core.seq.call(null,vec__70298);
var first__70300 = cljs.core.first.call(null,seq__70299);
var seq__70299__$1 = cljs.core.next.call(null,seq__70299);
var server = first__70300;
var r = seq__70299__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__70297__$1 = G__70297;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__70304 = G__70297__$1;
var seq__70305 = cljs.core.seq.call(null,vec__70304);
var first__70306 = cljs.core.first.call(null,seq__70305);
var seq__70305__$1 = cljs.core.next.call(null,seq__70305);
var server__$1 = first__70306;
var r__$1 = seq__70305__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__70307 = r__$1;
var G__70308 = is_https_QMARK_;
var G__70309 = result_STAR_;
G__70297__$1 = G__70307;
https_QMARK___$1 = G__70308;
result__$1 = G__70309;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__70310 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__70310 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__70310);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70339){
var state_val_70340 = (state_70339[(1)]);
if((state_val_70340 === (7))){
var inst_70325 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70326 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70327 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70328 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70329 = fluree.db.connection.establish_socket.call(null,inst_70325,inst_70326,inst_70327,inst_70328);
var state_70339__$1 = state_70339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70339__$1,(9),inst_70329);
} else {
if((state_val_70340 === (1))){
var state_70339__$1 = state_70339;
var statearr_70341_70360 = state_70339__$1;
(statearr_70341_70360[(2)] = null);

(statearr_70341_70360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70340 === (4))){
var inst_70311 = (state_70339[(2)]);
var state_70339__$1 = state_70339;
var statearr_70342_70361 = state_70339__$1;
(statearr_70342_70361[(2)] = inst_70311);

(statearr_70342_70361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70340 === (6))){
var inst_70322 = (state_70339[(7)]);
var state_70339__$1 = state_70339;
var statearr_70343_70362 = state_70339__$1;
(statearr_70343_70362[(2)] = inst_70322);

(statearr_70343_70362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70340 === (3))){
var inst_70337 = (state_70339[(2)]);
var state_70339__$1 = state_70339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70339__$1,inst_70337);
} else {
if((state_val_70340 === (2))){
var inst_70322 = (state_70339[(7)]);
var _ = (function (){var statearr_70345 = state_70339;
(statearr_70345[(4)] = cljs.core.cons.call(null,(5),(state_70339[(4)])));

return statearr_70345;
})();
var inst_70317 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_70318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70319 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70320 = [inst_70319,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_70321 = (new cljs.core.PersistentVector(null,3,(5),inst_70318,inst_70320,null));
var inst_70322__$1 = cljs.core.get_in.call(null,inst_70317,inst_70321);
var state_70339__$1 = (function (){var statearr_70346 = state_70339;
(statearr_70346[(7)] = inst_70322__$1);

return statearr_70346;
})();
if(cljs.core.truth_(inst_70322__$1)){
var statearr_70347_70363 = state_70339__$1;
(statearr_70347_70363[(1)] = (6));

} else {
var statearr_70348_70364 = state_70339__$1;
(statearr_70348_70364[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70340 === (9))){
var inst_70331 = (state_70339[(2)]);
var inst_70332 = fluree.db.util.async.throw_err.call(null,inst_70331);
var state_70339__$1 = state_70339;
var statearr_70349_70365 = state_70339__$1;
(statearr_70349_70365[(2)] = inst_70332);

(statearr_70349_70365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70340 === (5))){
var _ = (function (){var statearr_70350 = state_70339;
(statearr_70350[(4)] = cljs.core.rest.call(null,(state_70339[(4)])));

return statearr_70350;
})();
var state_70339__$1 = state_70339;
var ex70344 = (state_70339__$1[(2)]);
var statearr_70351_70366 = state_70339__$1;
(statearr_70351_70366[(5)] = ex70344);


if((ex70344 instanceof Error)){
var statearr_70352_70367 = state_70339__$1;
(statearr_70352_70367[(1)] = (4));

(statearr_70352_70367[(5)] = null);

} else {
throw ex70344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70340 === (8))){
var inst_70334 = (state_70339[(2)]);
var _ = (function (){var statearr_70353 = state_70339;
(statearr_70353[(4)] = cljs.core.rest.call(null,(state_70339[(4)])));

return statearr_70353;
})();
var state_70339__$1 = state_70339;
var statearr_70354_70368 = state_70339__$1;
(statearr_70354_70368[(2)] = inst_70334);

(statearr_70354_70368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_70355 = [null,null,null,null,null,null,null,null];
(statearr_70355[(0)] = fluree$db$connection$get_socket_$_state_machine__2746__auto__);

(statearr_70355[(1)] = (1));

return statearr_70355;
});
var fluree$db$connection$get_socket_$_state_machine__2746__auto____1 = (function (state_70339){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70356){var ex__2749__auto__ = e70356;
var statearr_70357_70369 = state_70339;
(statearr_70357_70369[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70339[(4)]))){
var statearr_70358_70370 = state_70339;
(statearr_70358_70370[(1)] = cljs.core.first.call(null,(state_70339[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70371 = state_70339;
state_70339 = G__70371;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2746__auto__ = function(state_70339){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____1.call(this,state_70339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2746__auto____0;
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70359 = f__2769__auto__.call(null);
(statearr_70359[(6)] = c__2768__auto__);

return statearr_70359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e70372){var e = e70372;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__70374){
var map__70375 = p__70374;
var map__70375__$1 = cljs.core.__destructure_map.call(null,map__70375);
var conn = map__70375__$1;
var state = cljs.core.get.call(null,map__70375__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.call(null,map__70375__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.call(null,map__70375__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70521){
var state_val_70522 = (state_70521[(1)]);
if((state_val_70522 === (7))){
var inst_70517 = (state_70521[(2)]);
var state_70521__$1 = state_70521;
var statearr_70524_70598 = state_70521__$1;
(statearr_70524_70598[(2)] = inst_70517);

(statearr_70524_70598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (20))){
var _ = (function (){var statearr_70525 = state_70521;
(statearr_70525[(4)] = cljs.core.rest.call(null,(state_70521[(4)])));

return statearr_70525;
})();
var state_70521__$1 = state_70521;
var ex70523 = (state_70521__$1[(2)]);
var statearr_70526_70599 = state_70521__$1;
(statearr_70526_70599[(5)] = ex70523);


var statearr_70527_70600 = state_70521__$1;
(statearr_70527_70600[(1)] = (10));

(statearr_70527_70600[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (27))){
var inst_70478 = (state_70521[(7)]);
var inst_70478__$1 = (state_70521[(2)]);
var inst_70479 = inst_70478__$1 === true;
var state_70521__$1 = (function (){var statearr_70528 = state_70521;
(statearr_70528[(7)] = inst_70478__$1);

return statearr_70528;
})();
if(cljs.core.truth_(inst_70479)){
var statearr_70529_70601 = state_70521__$1;
(statearr_70529_70601[(1)] = (28));

} else {
var statearr_70530_70602 = state_70521__$1;
(statearr_70530_70602[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (1))){
var inst_70376 = (0);
var state_70521__$1 = (function (){var statearr_70531 = state_70521;
(statearr_70531[(8)] = inst_70376);

return statearr_70531;
})();
var statearr_70532_70603 = state_70521__$1;
(statearr_70532_70603[(2)] = null);

(statearr_70532_70603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (24))){
var inst_70468 = (state_70521[(9)]);
var state_70521__$1 = state_70521;
var statearr_70533_70604 = state_70521__$1;
(statearr_70533_70604[(2)] = inst_70468);

(statearr_70533_70604[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (39))){
var inst_70503 = (state_70521[(2)]);
var state_70521__$1 = state_70521;
var statearr_70534_70605 = state_70521__$1;
(statearr_70534_70605[(2)] = inst_70503);

(statearr_70534_70605[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (4))){
var inst_70379 = (state_70521[(10)]);
var inst_70379__$1 = (state_70521[(2)]);
var state_70521__$1 = (function (){var statearr_70535 = state_70521;
(statearr_70535[(10)] = inst_70379__$1);

return statearr_70535;
})();
if(cljs.core.truth_(inst_70379__$1)){
var statearr_70536_70606 = state_70521__$1;
(statearr_70536_70606[(1)] = (5));

} else {
var statearr_70537_70607 = state_70521__$1;
(statearr_70537_70607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (15))){
var inst_70392 = (state_70521[(11)]);
var state_70521__$1 = state_70521;
var statearr_70538_70608 = state_70521__$1;
(statearr_70538_70608[(2)] = inst_70392);

(statearr_70538_70608[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (21))){
var inst_70424 = (state_70521[(12)]);
var inst_70421 = (state_70521[(13)]);
var inst_70376 = (state_70521[(8)]);
var inst_70430 = (state_70521[(14)]);
var inst_70425 = (state_70521[(15)]);
var inst_70429 = (state_70521[(16)]);
var inst_70422 = (state_70521[(17)]);
var inst_70423 = (state_70521[(18)]);
var inst_70379 = (state_70521[(10)]);
var inst_70426 = (state_70521[(19)]);
var inst_70432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70433 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_70429];
var inst_70434 = (new cljs.core.PersistentVector(null,2,(5),inst_70432,inst_70433,null));
var inst_70435 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_70434,inst_70424);
var inst_70462 = cljs.core.async.chan.call(null,(1));
var inst_70463 = (function (){var resp_chan = inst_70424;
var timeout = inst_70430;
var i = inst_70376;
var data = inst_70423;
var _ = inst_70421;
var req_id = inst_70429;
var operation = inst_70422;
var msg = inst_70379;
var temp__5804__auto__ = inst_70379;
var c__2768__auto____$1 = inst_70462;
var vec__70414 = inst_70379;
var opts = inst_70425;
var map__70417 = inst_70426;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70460){
var state_val_70461 = (state_70460[(1)]);
if((state_val_70461 === (1))){
var inst_70439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70440 = cljs.core.async.timeout.call(null,timeout);
var inst_70441 = [resp_chan,inst_70440];
var inst_70442 = (new cljs.core.PersistentVector(null,2,(5),inst_70439,inst_70441,null));
var state_70460__$1 = state_70460;
return cljs.core.async.ioc_alts_BANG_.call(null,state_70460__$1,(2),inst_70442);
} else {
if((state_val_70461 === (2))){
var inst_70445 = (state_70460[(7)]);
var inst_70444 = (state_70460[(2)]);
var inst_70445__$1 = cljs.core.nth.call(null,inst_70444,(0),null);
var inst_70446 = cljs.core.nth.call(null,inst_70444,(1),null);
var inst_70447 = (function (){var vec__70436 = inst_70444;
var resp = inst_70445__$1;
var c = inst_70446;
return (function (p1__70373_SHARP_){
return cljs.core.dissoc.call(null,p1__70373_SHARP_,req_id);
});
})();
var inst_70448 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_70447);
var inst_70449 = cljs.core._EQ_.call(null,inst_70446,resp_chan);
var state_70460__$1 = (function (){var statearr_70539 = state_70460;
(statearr_70539[(8)] = inst_70448);

(statearr_70539[(7)] = inst_70445__$1);

return statearr_70539;
})();
if(inst_70449){
var statearr_70540_70609 = state_70460__$1;
(statearr_70540_70609[(1)] = (3));

} else {
var statearr_70541_70610 = state_70460__$1;
(statearr_70541_70610[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70461 === (3))){
var inst_70445 = (state_70460[(7)]);
var state_70460__$1 = state_70460;
var statearr_70542_70611 = state_70460__$1;
(statearr_70542_70611[(2)] = inst_70445);

(statearr_70542_70611[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70461 === (4))){
var inst_70452 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_70453 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70454 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_70455 = cljs.core.PersistentHashMap.fromArrays(inst_70453,inst_70454);
var inst_70456 = cljs.core.ex_info.call(null,inst_70452,inst_70455);
var state_70460__$1 = state_70460;
var statearr_70543_70612 = state_70460__$1;
(statearr_70543_70612[(2)] = inst_70456);

(statearr_70543_70612[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70461 === (5))){
var inst_70458 = (state_70460[(2)]);
var state_70460__$1 = state_70460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70460__$1,inst_70458);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_70544 = [null,null,null,null,null,null,null,null,null];
(statearr_70544[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_70544[(1)] = (1));

return statearr_70544;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_70460){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70545){var ex__2749__auto__ = e70545;
var statearr_70546_70613 = state_70460;
(statearr_70546_70613[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70460[(4)]))){
var statearr_70547_70614 = state_70460;
(statearr_70547_70614[(1)] = cljs.core.first.call(null,(state_70460[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70615 = state_70460;
state_70460 = G__70615;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_70460){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_70460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70548 = f__2769__auto__.call(null);
(statearr_70548[(6)] = c__2768__auto____$1);

return statearr_70548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_70464 = cljs.core.async.impl.dispatch.run.call(null,inst_70463);
var state_70521__$1 = (function (){var statearr_70549 = state_70521;
(statearr_70549[(20)] = inst_70464);

(statearr_70549[(21)] = inst_70435);

return statearr_70549;
})();
var statearr_70550_70616 = state_70521__$1;
(statearr_70550_70616[(2)] = inst_70462);

(statearr_70550_70616[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (31))){
var inst_70478 = (state_70521[(7)]);
var inst_70484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70485 = [inst_70478,"Error processing message in producer."];
var inst_70486 = (new cljs.core.PersistentVector(null,2,(5),inst_70484,inst_70485,null));
var inst_70487 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70486);
var state_70521__$1 = state_70521;
var statearr_70551_70617 = state_70521__$1;
(statearr_70551_70617[(2)] = inst_70487);

(statearr_70551_70617[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (32))){
var inst_70478 = (state_70521[(7)]);
var inst_70489 = (inst_70478 == null);
var state_70521__$1 = state_70521;
if(cljs.core.truth_(inst_70489)){
var statearr_70552_70618 = state_70521__$1;
(statearr_70552_70618[(1)] = (34));

} else {
var statearr_70553_70619 = state_70521__$1;
(statearr_70553_70619[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (33))){
var inst_70507 = (state_70521[(2)]);
var state_70521__$1 = state_70521;
var statearr_70554_70620 = state_70521__$1;
(statearr_70554_70620[(2)] = inst_70507);

(statearr_70554_70620[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (13))){
var inst_70392 = (state_70521[(11)]);
var inst_70389 = (state_70521[(2)]);
var inst_70390 = cljs.core.nth.call(null,inst_70389,(0),null);
var inst_70391 = cljs.core.nth.call(null,inst_70389,(1),null);
var inst_70392__$1 = cljs.core.nth.call(null,inst_70389,(2),null);
var state_70521__$1 = (function (){var statearr_70555 = state_70521;
(statearr_70555[(11)] = inst_70392__$1);

(statearr_70555[(22)] = inst_70391);

(statearr_70555[(23)] = inst_70390);

return statearr_70555;
})();
if(cljs.core.truth_(inst_70392__$1)){
var statearr_70556_70621 = state_70521__$1;
(statearr_70556_70621[(1)] = (14));

} else {
var statearr_70557_70622 = state_70521__$1;
(statearr_70557_70622[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (22))){
var state_70521__$1 = state_70521;
var statearr_70558_70623 = state_70521__$1;
(statearr_70558_70623[(2)] = null);

(statearr_70558_70623[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (36))){
var inst_70505 = (state_70521[(2)]);
var state_70521__$1 = state_70521;
var statearr_70559_70624 = state_70521__$1;
(statearr_70559_70624[(2)] = inst_70505);

(statearr_70559_70624[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (29))){
var inst_70478 = (state_70521[(7)]);
var inst_70482 = fluree.db.util.core.exception_QMARK_.call(null,inst_70478);
var state_70521__$1 = state_70521;
if(inst_70482){
var statearr_70560_70625 = state_70521__$1;
(statearr_70560_70625[(1)] = (31));

} else {
var statearr_70561_70626 = state_70521__$1;
(statearr_70561_70626[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (6))){
var state_70521__$1 = state_70521;
var statearr_70562_70627 = state_70521__$1;
(statearr_70562_70627[(2)] = null);

(statearr_70562_70627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (28))){
var state_70521__$1 = state_70521;
var statearr_70563_70628 = state_70521__$1;
(statearr_70563_70628[(2)] = null);

(statearr_70563_70628[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (25))){
var state_70521__$1 = state_70521;
var statearr_70564_70629 = state_70521__$1;
(statearr_70564_70629[(2)] = fluree.db.connection.default_publish_fn);

(statearr_70564_70629[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (34))){
var inst_70491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70492 = ["Error processing message in producer. Socket closed."];
var inst_70493 = (new cljs.core.PersistentVector(null,1,(5),inst_70491,inst_70492,null));
var inst_70494 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70493);
var state_70521__$1 = state_70521;
var statearr_70565_70630 = state_70521__$1;
(statearr_70565_70630[(2)] = inst_70494);

(statearr_70565_70630[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (17))){
var inst_70392 = (state_70521[(11)]);
var inst_70381 = (state_70521[(24)]);
var inst_70399 = cljs.core.async.put_BANG_.call(null,inst_70392,inst_70381);
var state_70521__$1 = state_70521;
var statearr_70566_70631 = state_70521__$1;
(statearr_70566_70631[(2)] = inst_70399);

(statearr_70566_70631[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (3))){
var inst_70519 = (state_70521[(2)]);
var state_70521__$1 = state_70521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70521__$1,inst_70519);
} else {
if((state_val_70522 === (12))){
var state_70521__$1 = state_70521;
var statearr_70567_70632 = state_70521__$1;
(statearr_70567_70632[(2)] = null);

(statearr_70567_70632[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (2))){
var state_70521__$1 = state_70521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70521__$1,(4),req_chan);
} else {
if((state_val_70522 === (23))){
var inst_70468 = (state_70521[(9)]);
var inst_70467 = (state_70521[(2)]);
var inst_70468__$1 = publish;
var state_70521__$1 = (function (){var statearr_70568 = state_70521;
(statearr_70568[(25)] = inst_70467);

(statearr_70568[(9)] = inst_70468__$1);

return statearr_70568;
})();
if(cljs.core.truth_(inst_70468__$1)){
var statearr_70569_70633 = state_70521__$1;
(statearr_70569_70633[(1)] = (24));

} else {
var statearr_70570_70634 = state_70521__$1;
(statearr_70570_70634[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (35))){
var state_70521__$1 = state_70521;
var statearr_70571_70635 = state_70521__$1;
(statearr_70571_70635[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (19))){
var inst_70408 = (state_70521[(2)]);
var state_70521__$1 = state_70521;
var statearr_70573_70636 = state_70521__$1;
(statearr_70573_70636[(2)] = inst_70408);

(statearr_70573_70636[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (11))){
var inst_70379 = (state_70521[(10)]);
var state_70521__$1 = state_70521;
var statearr_70574_70637 = state_70521__$1;
(statearr_70574_70637[(2)] = inst_70379);

(statearr_70574_70637[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (9))){
var inst_70376 = (state_70521[(8)]);
var inst_70512 = (state_70521[(2)]);
var inst_70513 = (inst_70376 + (1));
var inst_70376__$1 = inst_70513;
var state_70521__$1 = (function (){var statearr_70575 = state_70521;
(statearr_70575[(8)] = inst_70376__$1);

(statearr_70575[(26)] = inst_70512);

return statearr_70575;
})();
var statearr_70576_70638 = state_70521__$1;
(statearr_70576_70638[(2)] = null);

(statearr_70576_70638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (5))){
var state_70521__$1 = state_70521;
var statearr_70577_70639 = state_70521__$1;
(statearr_70577_70639[(2)] = null);

(statearr_70577_70639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (14))){
var inst_70392 = (state_70521[(11)]);
var inst_70394 = fluree.db.util.async.channel_QMARK_.call(null,inst_70392);
var state_70521__$1 = state_70521;
var statearr_70578_70640 = state_70521__$1;
(statearr_70578_70640[(2)] = inst_70394);

(statearr_70578_70640[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (26))){
var inst_70429 = (state_70521[(16)]);
var inst_70422 = (state_70521[(17)]);
var inst_70423 = (state_70521[(18)]);
var inst_70472 = (state_70521[(2)]);
var inst_70473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70474 = [inst_70422,inst_70429,inst_70423];
var inst_70475 = (new cljs.core.PersistentVector(null,3,(5),inst_70473,inst_70474,null));
var inst_70476 = inst_70472.call(null,conn,inst_70475);
var state_70521__$1 = state_70521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70521__$1,(27),inst_70476);
} else {
if((state_val_70522 === (16))){
var inst_70397 = (state_70521[(2)]);
var state_70521__$1 = state_70521;
if(cljs.core.truth_(inst_70397)){
var statearr_70579_70641 = state_70521__$1;
(statearr_70579_70641[(1)] = (17));

} else {
var statearr_70580_70642 = state_70521__$1;
(statearr_70580_70642[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (38))){
var state_70521__$1 = state_70521;
var statearr_70581_70643 = state_70521__$1;
(statearr_70581_70643[(2)] = null);

(statearr_70581_70643[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (30))){
var inst_70509 = (state_70521[(2)]);
var _ = (function (){var statearr_70582 = state_70521;
(statearr_70582[(4)] = cljs.core.rest.call(null,(state_70521[(4)])));

return statearr_70582;
})();
var state_70521__$1 = state_70521;
var statearr_70583_70644 = state_70521__$1;
(statearr_70583_70644[(2)] = inst_70509);

(statearr_70583_70644[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (10))){
var inst_70379 = (state_70521[(10)]);
var inst_70381 = (state_70521[(2)]);
var inst_70385 = cljs.core.sequential_QMARK_.call(null,inst_70379);
var state_70521__$1 = (function (){var statearr_70584 = state_70521;
(statearr_70584[(24)] = inst_70381);

return statearr_70584;
})();
if(inst_70385){
var statearr_70585_70645 = state_70521__$1;
(statearr_70585_70645[(1)] = (11));

} else {
var statearr_70586_70646 = state_70521__$1;
(statearr_70586_70646[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (18))){
var inst_70379 = (state_70521[(10)]);
var inst_70381 = (state_70521[(24)]);
var inst_70401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70402 = cljs.core.pr_str.call(null,inst_70379);
var inst_70403 = ["Error processing ledger request, no valid return channel: ",inst_70402].join('');
var inst_70404 = [inst_70381,inst_70403];
var inst_70405 = (new cljs.core.PersistentVector(null,2,(5),inst_70401,inst_70404,null));
var inst_70406 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70405);
var state_70521__$1 = state_70521;
var statearr_70587_70647 = state_70521__$1;
(statearr_70587_70647[(2)] = inst_70406);

(statearr_70587_70647[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (37))){
var inst_70478 = (state_70521[(7)]);
var inst_70497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70498 = ["Error processing message in producer. Socket closed. Published result",inst_70478];
var inst_70499 = (new cljs.core.PersistentVector(null,2,(5),inst_70497,inst_70498,null));
var inst_70500 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70499);
var state_70521__$1 = state_70521;
var statearr_70588_70648 = state_70521__$1;
(statearr_70588_70648[(2)] = inst_70500);

(statearr_70588_70648[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70522 === (8))){
var inst_70424 = (state_70521[(12)]);
var inst_70425 = (state_70521[(15)]);
var inst_70379 = (state_70521[(10)]);
var inst_70426 = (state_70521[(19)]);
var _ = (function (){var statearr_70589 = state_70521;
(statearr_70589[(4)] = cljs.core.cons.call(null,(20),(state_70521[(4)])));

return statearr_70589;
})();
var inst_70418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70419 = ["Outgoing message to websocket: ",inst_70379];
var inst_70420 = (new cljs.core.PersistentVector(null,2,(5),inst_70418,inst_70419,null));
var inst_70421 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_70420);
var inst_70422 = cljs.core.nth.call(null,inst_70379,(0),null);
var inst_70423 = cljs.core.nth.call(null,inst_70379,(1),null);
var inst_70424__$1 = cljs.core.nth.call(null,inst_70379,(2),null);
var inst_70425__$1 = cljs.core.nth.call(null,inst_70379,(3),null);
var inst_70426__$1 = cljs.core.__destructure_map.call(null,inst_70425__$1);
var inst_70427 = cljs.core.random_uuid.call(null);
var inst_70428 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70427);
var inst_70429 = cljs.core.get.call(null,inst_70426__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_70428);
var inst_70430 = cljs.core.get.call(null,inst_70426__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_70521__$1 = (function (){var statearr_70590 = state_70521;
(statearr_70590[(12)] = inst_70424__$1);

(statearr_70590[(13)] = inst_70421);

(statearr_70590[(14)] = inst_70430);

(statearr_70590[(15)] = inst_70425__$1);

(statearr_70590[(16)] = inst_70429);

(statearr_70590[(17)] = inst_70422);

(statearr_70590[(18)] = inst_70423);

(statearr_70590[(19)] = inst_70426__$1);

return statearr_70590;
})();
if(cljs.core.truth_(inst_70424__$1)){
var statearr_70591_70649 = state_70521__$1;
(statearr_70591_70649[(1)] = (21));

} else {
var statearr_70592_70650 = state_70521__$1;
(statearr_70592_70650[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_70593 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70593[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_70593[(1)] = (1));

return statearr_70593;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_70521){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70594){var ex__2749__auto__ = e70594;
var statearr_70595_70651 = state_70521;
(statearr_70595_70651[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70521[(4)]))){
var statearr_70596_70652 = state_70521;
(statearr_70596_70652[(1)] = cljs.core.first.call(null,(state_70521[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70653 = state_70521;
state_70521 = G__70653;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_70521){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_70521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70597 = f__2769__auto__.call(null);
(statearr_70597[(6)] = c__2768__auto__);

return statearr_70597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70691){
var state_val_70692 = (state_70691[(1)]);
if((state_val_70692 === (7))){
var inst_70662 = (state_70691[(7)]);
var state_70691__$1 = state_70691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70691__$1,(9),inst_70662);
} else {
if((state_val_70692 === (1))){
var inst_70654 = (1);
var state_70691__$1 = (function (){var statearr_70693 = state_70691;
(statearr_70693[(8)] = inst_70654);

return statearr_70693;
})();
var statearr_70694_70717 = state_70691__$1;
(statearr_70694_70717[(2)] = null);

(statearr_70694_70717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (4))){
var inst_70659 = (state_70691[(2)]);
var inst_70660 = fluree.db.connection.get_socket.call(null,conn);
var state_70691__$1 = (function (){var statearr_70695 = state_70691;
(statearr_70695[(9)] = inst_70659);

return statearr_70695;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70691__$1,(5),inst_70660);
} else {
if((state_val_70692 === (15))){
var inst_70687 = (state_70691[(2)]);
var state_70691__$1 = state_70691;
var statearr_70696_70718 = state_70691__$1;
(statearr_70696_70718[(2)] = inst_70687);

(statearr_70696_70718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (13))){
var inst_70669 = (state_70691[(10)]);
var inst_70654 = (state_70691[(8)]);
var inst_70677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70678 = [inst_70669,"Cannot establish connection to a healthy server, backing off:",inst_70654,"s."];
var inst_70679 = (new cljs.core.PersistentVector(null,4,(5),inst_70677,inst_70678,null));
var inst_70680 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70679);
var inst_70681 = ((2) * inst_70654);
var inst_70682 = ((60) * (2));
var inst_70683 = ((inst_70681 < inst_70682) ? inst_70681 : inst_70682);
var inst_70654__$1 = inst_70683;
var state_70691__$1 = (function (){var statearr_70697 = state_70691;
(statearr_70697[(8)] = inst_70654__$1);

(statearr_70697[(11)] = inst_70680);

return statearr_70697;
})();
var statearr_70698_70719 = state_70691__$1;
(statearr_70698_70719[(2)] = null);

(statearr_70698_70719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (6))){
var inst_70662 = (state_70691[(7)]);
var state_70691__$1 = state_70691;
var statearr_70699_70720 = state_70691__$1;
(statearr_70699_70720[(2)] = inst_70662);

(statearr_70699_70720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (3))){
var inst_70689 = (state_70691[(2)]);
var state_70691__$1 = state_70691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70691__$1,inst_70689);
} else {
if((state_val_70692 === (12))){
var inst_70675 = (state_70691[(2)]);
var state_70691__$1 = state_70691;
if(cljs.core.truth_(inst_70675)){
var statearr_70700_70721 = state_70691__$1;
(statearr_70700_70721[(1)] = (13));

} else {
var statearr_70701_70722 = state_70691__$1;
(statearr_70701_70722[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (2))){
var inst_70654 = (state_70691[(8)]);
var inst_70656 = (inst_70654 * (1000));
var inst_70657 = cljs.core.async.timeout.call(null,inst_70656);
var state_70691__$1 = state_70691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70691__$1,(4),inst_70657);
} else {
if((state_val_70692 === (11))){
var inst_70669 = (state_70691[(10)]);
var inst_70673 = fluree.db.util.core.exception_QMARK_.call(null,inst_70669);
var state_70691__$1 = state_70691;
var statearr_70702_70723 = state_70691__$1;
(statearr_70702_70723[(2)] = inst_70673);

(statearr_70702_70723[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (9))){
var inst_70667 = (state_70691[(2)]);
var state_70691__$1 = state_70691;
var statearr_70703_70724 = state_70691__$1;
(statearr_70703_70724[(2)] = inst_70667);

(statearr_70703_70724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (5))){
var inst_70662 = (state_70691[(7)]);
var inst_70662__$1 = (state_70691[(2)]);
var inst_70663 = fluree.db.util.core.exception_QMARK_.call(null,inst_70662__$1);
var state_70691__$1 = (function (){var statearr_70704 = state_70691;
(statearr_70704[(7)] = inst_70662__$1);

return statearr_70704;
})();
if(inst_70663){
var statearr_70705_70725 = state_70691__$1;
(statearr_70705_70725[(1)] = (6));

} else {
var statearr_70706_70726 = state_70691__$1;
(statearr_70706_70726[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (14))){
var inst_70669 = (state_70691[(10)]);
var state_70691__$1 = state_70691;
var statearr_70707_70727 = state_70691__$1;
(statearr_70707_70727[(2)] = inst_70669);

(statearr_70707_70727[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (10))){
var inst_70670 = (state_70691[(12)]);
var state_70691__$1 = state_70691;
var statearr_70708_70728 = state_70691__$1;
(statearr_70708_70728[(2)] = inst_70670);

(statearr_70708_70728[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70692 === (8))){
var inst_70669 = (state_70691[(10)]);
var inst_70670 = (state_70691[(12)]);
var inst_70669__$1 = (state_70691[(2)]);
var inst_70670__$1 = (inst_70669__$1 == null);
var state_70691__$1 = (function (){var statearr_70709 = state_70691;
(statearr_70709[(10)] = inst_70669__$1);

(statearr_70709[(12)] = inst_70670__$1);

return statearr_70709;
})();
if(cljs.core.truth_(inst_70670__$1)){
var statearr_70710_70729 = state_70691__$1;
(statearr_70710_70729[(1)] = (10));

} else {
var statearr_70711_70730 = state_70691__$1;
(statearr_70711_70730[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0 = (function (){
var statearr_70712 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70712[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__);

(statearr_70712[(1)] = (1));

return statearr_70712;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1 = (function (state_70691){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70713){var ex__2749__auto__ = e70713;
var statearr_70714_70731 = state_70691;
(statearr_70714_70731[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70691[(4)]))){
var statearr_70715_70732 = state_70691;
(statearr_70715_70732[(1)] = cljs.core.first.call(null,(state_70691[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70733 = state_70691;
state_70691 = G__70733;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = function(state_70691){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1.call(this,state_70691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70716 = f__2769__auto__.call(null);
(statearr_70716[(6)] = c__2768__auto__);

return statearr_70716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__70734){
var map__70735 = p__70734;
var map__70735__$1 = cljs.core.__destructure_map.call(null,map__70735);
var conn = map__70735__$1;
var sub_chan = cljs.core.get.call(null,map__70735__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.call(null,map__70735__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.call(null,map__70735__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.call(null,map__70735__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70846){
var state_val_70847 = (state_70846[(1)]);
if((state_val_70847 === (7))){
var inst_70842 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70848_70904 = state_70846__$1;
(statearr_70848_70904[(2)] = inst_70842);

(statearr_70848_70904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (20))){
var inst_70793 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70849_70905 = state_70846__$1;
(statearr_70849_70905[(2)] = inst_70793);

(statearr_70849_70905[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (27))){
var inst_70811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70812 = ["Connection closed."];
var inst_70813 = (new cljs.core.PersistentVector(null,1,(5),inst_70811,inst_70812,null));
var inst_70814 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_70813);
var state_70846__$1 = state_70846;
var statearr_70850_70906 = state_70846__$1;
(statearr_70850_70906[(2)] = inst_70814);

(statearr_70850_70906[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (1))){
var inst_70736 = (0);
var state_70846__$1 = (function (){var statearr_70851 = state_70846;
(statearr_70851[(7)] = inst_70736);

return statearr_70851;
})();
var statearr_70852_70907 = state_70846__$1;
(statearr_70852_70907[(2)] = null);

(statearr_70852_70907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (24))){
var inst_70780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70781 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_70782 = [keep_alive_fn];
var inst_70783 = cljs.core.PersistentHashMap.fromArrays(inst_70781,inst_70782);
var inst_70784 = ["Unsupported callback registered",inst_70783];
var inst_70785 = (new cljs.core.PersistentVector(null,2,(5),inst_70780,inst_70784,null));
var inst_70786 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70785);
var state_70846__$1 = state_70846;
var statearr_70853_70908 = state_70846__$1;
(statearr_70853_70908[(2)] = inst_70786);

(statearr_70853_70908[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (4))){
var inst_70741 = (state_70846[(8)]);
var inst_70746 = (state_70846[(2)]);
var inst_70747 = cljs.core.nth.call(null,inst_70746,(0),null);
var inst_70748 = cljs.core.nth.call(null,inst_70746,(1),null);
var inst_70749 = cljs.core._EQ_.call(null,inst_70748,inst_70741);
var state_70846__$1 = (function (){var statearr_70854 = state_70846;
(statearr_70854[(9)] = inst_70747);

return statearr_70854;
})();
if(inst_70749){
var statearr_70855_70909 = state_70846__$1;
(statearr_70855_70909[(1)] = (5));

} else {
var statearr_70856_70910 = state_70846__$1;
(statearr_70856_70910[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (15))){
var inst_70766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70767 = ["No keep-alive callback is registered"];
var inst_70768 = (new cljs.core.PersistentVector(null,1,(5),inst_70766,inst_70767,null));
var inst_70769 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_70768);
var state_70846__$1 = state_70846;
var statearr_70857_70911 = state_70846__$1;
(statearr_70857_70911[(2)] = inst_70769);

(statearr_70857_70911[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (21))){
var inst_70777 = cljs.core.eval.call(null,keep_alive_fn);
var state_70846__$1 = state_70846;
var statearr_70858_70912 = state_70846__$1;
(statearr_70858_70912[(2)] = inst_70777);

(statearr_70858_70912[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (31))){
var state_70846__$1 = state_70846;
var statearr_70859_70913 = state_70846__$1;
(statearr_70859_70913[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (32))){
var inst_70838 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70861_70914 = state_70846__$1;
(statearr_70861_70914[(2)] = inst_70838);

(statearr_70861_70914[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (33))){
var inst_70747 = (state_70846[(9)]);
var inst_70825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70826 = fluree.db.util.json.parse.call(null,inst_70747);
var inst_70827 = cljs.core.pr_str.call(null,inst_70826);
var inst_70828 = ["Received message:",inst_70827];
var inst_70829 = (new cljs.core.PersistentVector(null,2,(5),inst_70825,inst_70828,null));
var inst_70830 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_70829);
var inst_70831 = fluree.db.util.json.parse.call(null,inst_70747);
var inst_70832 = fluree.db.conn_events.process_events.call(null,conn,inst_70831);
var inst_70736 = (0);
var state_70846__$1 = (function (){var statearr_70862 = state_70846;
(statearr_70862[(10)] = inst_70830);

(statearr_70862[(7)] = inst_70736);

(statearr_70862[(11)] = inst_70832);

return statearr_70862;
})();
var statearr_70863_70915 = state_70846__$1;
(statearr_70863_70915[(2)] = null);

(statearr_70863_70915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (13))){
var inst_70801 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70864_70916 = state_70846__$1;
(statearr_70864_70916[(2)] = inst_70801);

(statearr_70864_70916[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (22))){
var state_70846__$1 = state_70846;
var statearr_70865_70917 = state_70846__$1;
(statearr_70865_70917[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (29))){
var inst_70840 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70867_70918 = state_70846__$1;
(statearr_70867_70918[(2)] = inst_70840);

(statearr_70867_70918[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (6))){
var inst_70747 = (state_70846[(9)]);
var inst_70809 = (inst_70747 == null);
var state_70846__$1 = state_70846;
if(cljs.core.truth_(inst_70809)){
var statearr_70868_70919 = state_70846__$1;
(statearr_70868_70919[(1)] = (27));

} else {
var statearr_70869_70920 = state_70846__$1;
(statearr_70869_70920[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (28))){
var inst_70747 = (state_70846[(9)]);
var inst_70816 = fluree.db.util.core.exception_QMARK_.call(null,inst_70747);
var state_70846__$1 = state_70846;
if(inst_70816){
var statearr_70870_70921 = state_70846__$1;
(statearr_70870_70921[(1)] = (30));

} else {
var statearr_70871_70922 = state_70846__$1;
(statearr_70871_70922[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (25))){
var state_70846__$1 = state_70846;
var statearr_70872_70923 = state_70846__$1;
(statearr_70872_70923[(2)] = null);

(statearr_70872_70923[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (34))){
var state_70846__$1 = state_70846;
var statearr_70873_70924 = state_70846__$1;
(statearr_70873_70924[(2)] = null);

(statearr_70873_70924[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (17))){
var inst_70795 = (state_70846[(2)]);
var inst_70796 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70797 = fluree.db.connection.close_websocket.call(null,inst_70796);
var inst_70798 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_70799 = fluree.db.session.close_all_sessions.call(null,inst_70798);
var state_70846__$1 = (function (){var statearr_70874 = state_70846;
(statearr_70874[(12)] = inst_70797);

(statearr_70874[(13)] = inst_70795);

return statearr_70874;
})();
var statearr_70875_70925 = state_70846__$1;
(statearr_70875_70925[(2)] = inst_70799);

(statearr_70875_70925[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (3))){
var inst_70844 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70846__$1,inst_70844);
} else {
if((state_val_70847 === (12))){
var inst_70759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70760 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_70761 = (new cljs.core.PersistentVector(null,1,(5),inst_70759,inst_70760,null));
var inst_70762 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_70761);
var inst_70763 = keep_alive_fn;
var inst_70764 = (keep_alive_fn == null);
var state_70846__$1 = (function (){var statearr_70876 = state_70846;
(statearr_70876[(14)] = inst_70762);

(statearr_70876[(15)] = inst_70763);

return statearr_70876;
})();
if(cljs.core.truth_(inst_70764)){
var statearr_70877_70926 = state_70846__$1;
(statearr_70877_70926[(1)] = (15));

} else {
var statearr_70878_70927 = state_70846__$1;
(statearr_70878_70927[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (2))){
var inst_70741 = (state_70846[(8)]);
var inst_70741__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_70742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70743 = [sub_chan,inst_70741__$1];
var inst_70744 = (new cljs.core.PersistentVector(null,2,(5),inst_70742,inst_70743,null));
var state_70846__$1 = (function (){var statearr_70879 = state_70846;
(statearr_70879[(8)] = inst_70741__$1);

return statearr_70879;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70846__$1,(4),inst_70744);
} else {
if((state_val_70847 === (23))){
var inst_70791 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70880_70928 = state_70846__$1;
(statearr_70880_70928[(2)] = inst_70791);

(statearr_70880_70928[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (35))){
var inst_70836 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70881_70929 = state_70846__$1;
(statearr_70881_70929[(2)] = inst_70836);

(statearr_70881_70929[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (19))){
var inst_70775 = typeof keep_alive_fn === 'string';
var state_70846__$1 = state_70846;
if(cljs.core.truth_(inst_70775)){
var statearr_70882_70930 = state_70846__$1;
(statearr_70882_70930[(1)] = (21));

} else {
var statearr_70883_70931 = state_70846__$1;
(statearr_70883_70931[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (11))){
var inst_70754 = fluree.db.connection.reconnect_conn.call(null,conn);
var state_70846__$1 = state_70846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70846__$1,(14),inst_70754);
} else {
if((state_val_70847 === (9))){
var inst_70736 = (state_70846[(7)]);
var inst_70803 = fluree.db.connection.ping_transactor.call(null,req_chan);
var inst_70804 = (inst_70736 + (1));
var inst_70736__$1 = inst_70804;
var state_70846__$1 = (function (){var statearr_70884 = state_70846;
(statearr_70884[(7)] = inst_70736__$1);

(statearr_70884[(16)] = inst_70803);

return statearr_70884;
})();
var statearr_70885_70932 = state_70846__$1;
(statearr_70885_70932[(2)] = null);

(statearr_70885_70932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (5))){
var inst_70736 = (state_70846[(7)]);
var inst_70751 = cljs.core._EQ_.call(null,(2),inst_70736);
var state_70846__$1 = state_70846;
if(inst_70751){
var statearr_70886_70933 = state_70846__$1;
(statearr_70886_70933[(1)] = (8));

} else {
var statearr_70887_70934 = state_70846__$1;
(statearr_70887_70934[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (14))){
var inst_70756 = (state_70846[(2)]);
var inst_70736 = (0);
var state_70846__$1 = (function (){var statearr_70888 = state_70846;
(statearr_70888[(17)] = inst_70756);

(statearr_70888[(7)] = inst_70736);

return statearr_70888;
})();
var statearr_70889_70935 = state_70846__$1;
(statearr_70889_70935[(2)] = null);

(statearr_70889_70935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (26))){
var inst_70789 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70890_70936 = state_70846__$1;
(statearr_70890_70936[(2)] = inst_70789);

(statearr_70890_70936[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (16))){
var inst_70771 = cljs.core.fn_QMARK_.call(null,keep_alive_fn);
var state_70846__$1 = state_70846;
if(inst_70771){
var statearr_70891_70937 = state_70846__$1;
(statearr_70891_70937[(1)] = (18));

} else {
var statearr_70892_70938 = state_70846__$1;
(statearr_70892_70938[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (30))){
var inst_70747 = (state_70846[(9)]);
var inst_70818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70819 = [inst_70747];
var inst_70820 = (new cljs.core.PersistentVector(null,1,(5),inst_70818,inst_70819,null));
var inst_70821 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70820);
var inst_70736 = (0);
var state_70846__$1 = (function (){var statearr_70893 = state_70846;
(statearr_70893[(7)] = inst_70736);

(statearr_70893[(18)] = inst_70821);

return statearr_70893;
})();
var statearr_70894_70939 = state_70846__$1;
(statearr_70894_70939[(2)] = null);

(statearr_70894_70939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (10))){
var inst_70807 = (state_70846[(2)]);
var state_70846__$1 = state_70846;
var statearr_70895_70940 = state_70846__$1;
(statearr_70895_70940[(2)] = inst_70807);

(statearr_70895_70940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (18))){
var inst_70773 = keep_alive_fn.call(null);
var state_70846__$1 = state_70846;
var statearr_70896_70941 = state_70846__$1;
(statearr_70896_70941[(2)] = inst_70773);

(statearr_70896_70941[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70847 === (8))){
var state_70846__$1 = state_70846;
if(cljs.core.truth_(keep_alive)){
var statearr_70897_70942 = state_70846__$1;
(statearr_70897_70942[(1)] = (11));

} else {
var statearr_70898_70943 = state_70846__$1;
(statearr_70898_70943[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0 = (function (){
var statearr_70899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70899[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2746__auto__);

(statearr_70899[(1)] = (1));

return statearr_70899;
});
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1 = (function (state_70846){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70900){var ex__2749__auto__ = e70900;
var statearr_70901_70944 = state_70846;
(statearr_70901_70944[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70846[(4)]))){
var statearr_70902_70945 = state_70846;
(statearr_70902_70945[(1)] = cljs.core.first.call(null,(state_70846[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70946 = state_70846;
state_70846 = G__70946;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = function(state_70846){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1.call(this,state_70846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70903 = f__2769__auto__.call(null);
(statearr_70903[(6)] = c__2768__auto__);

return statearr_70903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__70948 = arguments.length;
switch (G__70948) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__70949 = opts;
var map__70949__$1 = cljs.core.__destructure_map.call(null,map__70949);
var private$ = cljs.core.get.call(null,map__70949__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__70949__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71001){
var state_val_71002 = (state_71001[(1)]);
if((state_val_71002 === (7))){
var inst_70959 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_70960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70961 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_70962 = (new cljs.core.PersistentVector(null,2,(5),inst_70960,inst_70961,null));
var inst_70963 = cljs.core.get_in.call(null,inst_70959,inst_70962);
var state_71001__$1 = state_71001;
var statearr_71003_71034 = state_71001__$1;
(statearr_71003_71034[(2)] = inst_70963);

(statearr_71003_71034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (1))){
var state_71001__$1 = state_71001;
var statearr_71004_71035 = state_71001__$1;
(statearr_71004_71035[(2)] = null);

(statearr_71004_71035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (4))){
var inst_70950 = (state_71001[(2)]);
var state_71001__$1 = state_71001;
var statearr_71005_71036 = state_71001__$1;
(statearr_71005_71036[(2)] = inst_70950);

(statearr_71005_71036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (15))){
var inst_70970 = (state_71001[(7)]);
var inst_70989 = (state_71001[(2)]);
var inst_70990 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_70991 = [(5000),inst_70989,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_70992 = cljs.core.PersistentHashMap.fromArrays(inst_70990,inst_70991);
var inst_70993 = fluree.db.util.xhttp.get.call(null,inst_70970,inst_70992);
var state_71001__$1 = state_71001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71001__$1,(16),inst_70993);
} else {
if((state_val_71002 === (13))){
var inst_70980 = (state_71001[(8)]);
var inst_70970 = (state_71001[(7)]);
var inst_70982 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_70983 = [inst_70980];
var inst_70984 = cljs.core.PersistentHashMap.fromArrays(inst_70982,inst_70983);
var inst_70985 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_70970,inst_70984,private$);
var inst_70986 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_70985);
var state_71001__$1 = state_71001;
var statearr_71006_71037 = state_71001__$1;
(statearr_71006_71037[(2)] = inst_70986);

(statearr_71006_71037[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (6))){
var inst_70956 = (state_71001[(9)]);
var state_71001__$1 = state_71001;
var statearr_71007_71038 = state_71001__$1;
(statearr_71007_71038[(2)] = inst_70956);

(statearr_71007_71038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (3))){
var inst_70999 = (state_71001[(2)]);
var state_71001__$1 = state_71001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71001__$1,inst_70999);
} else {
if((state_val_71002 === (12))){
var inst_70980 = (state_71001[(2)]);
var state_71001__$1 = (function (){var statearr_71008 = state_71001;
(statearr_71008[(8)] = inst_70980);

return statearr_71008;
})();
if(cljs.core.truth_(private$)){
var statearr_71009_71039 = state_71001__$1;
(statearr_71009_71039[(1)] = (13));

} else {
var statearr_71010_71040 = state_71001__$1;
(statearr_71010_71040[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (2))){
var inst_70956 = (state_71001[(9)]);
var _ = (function (){var statearr_71011 = state_71001;
(statearr_71011[(4)] = cljs.core.cons.call(null,(5),(state_71001[(4)])));

return statearr_71011;
})();
var inst_70956__$1 = jwt;
var state_71001__$1 = (function (){var statearr_71012 = state_71001;
(statearr_71012[(9)] = inst_70956__$1);

return statearr_71012;
})();
if(cljs.core.truth_(inst_70956__$1)){
var statearr_71013_71041 = state_71001__$1;
(statearr_71013_71041[(1)] = (6));

} else {
var statearr_71014_71042 = state_71001__$1;
(statearr_71014_71042[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (11))){
var inst_70974 = (state_71001[(10)]);
var state_71001__$1 = state_71001;
var statearr_71016_71043 = state_71001__$1;
(statearr_71016_71043[(2)] = inst_70974);

(statearr_71016_71043[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (9))){
var inst_70966 = (state_71001[(11)]);
var inst_70965 = (state_71001[(12)]);
var inst_70969 = (state_71001[(2)]);
var inst_70970 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70969),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70966)].join('');
var inst_70972 = ["Accept"];
var inst_70973 = ["application/json"];
var inst_70974 = cljs.core.PersistentHashMap.fromArrays(inst_70972,inst_70973);
var state_71001__$1 = (function (){var statearr_71017 = state_71001;
(statearr_71017[(7)] = inst_70970);

(statearr_71017[(10)] = inst_70974);

return statearr_71017;
})();
if(cljs.core.truth_(inst_70965)){
var statearr_71018_71044 = state_71001__$1;
(statearr_71018_71044[(1)] = (10));

} else {
var statearr_71019_71045 = state_71001__$1;
(statearr_71019_71045[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (5))){
var _ = (function (){var statearr_71020 = state_71001;
(statearr_71020[(4)] = cljs.core.rest.call(null,(state_71001[(4)])));

return statearr_71020;
})();
var state_71001__$1 = state_71001;
var ex71015 = (state_71001__$1[(2)]);
var statearr_71021_71046 = state_71001__$1;
(statearr_71021_71046[(5)] = ex71015);


if((ex71015 instanceof Error)){
var statearr_71022_71047 = state_71001__$1;
(statearr_71022_71047[(1)] = (4));

(statearr_71022_71047[(5)] = null);

} else {
throw ex71015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (14))){
var inst_70980 = (state_71001[(8)]);
var state_71001__$1 = state_71001;
var statearr_71023_71048 = state_71001__$1;
(statearr_71023_71048[(2)] = inst_70980);

(statearr_71023_71048[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (16))){
var inst_70995 = (state_71001[(2)]);
var inst_70996 = fluree.db.util.async.throw_err.call(null,inst_70995);
var _ = (function (){var statearr_71024 = state_71001;
(statearr_71024[(4)] = cljs.core.rest.call(null,(state_71001[(4)])));

return statearr_71024;
})();
var state_71001__$1 = state_71001;
var statearr_71025_71049 = state_71001__$1;
(statearr_71025_71049[(2)] = inst_70996);

(statearr_71025_71049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (10))){
var inst_70965 = (state_71001[(12)]);
var inst_70974 = (state_71001[(10)]);
var inst_70976 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70965)].join('');
var inst_70977 = cljs.core.assoc.call(null,inst_70974,"Authorization",inst_70976);
var state_71001__$1 = state_71001;
var statearr_71026_71050 = state_71001__$1;
(statearr_71026_71050[(2)] = inst_70977);

(statearr_71026_71050[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71002 === (8))){
var inst_70965 = (state_71001[(2)]);
var inst_70966 = clojure.string.replace.call(null,k,"_","/");
var inst_70967 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_71001__$1 = (function (){var statearr_71027 = state_71001;
(statearr_71027[(11)] = inst_70966);

(statearr_71027[(12)] = inst_70965);

return statearr_71027;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71001__$1,(9),inst_70967);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_71028 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71028[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_71028[(1)] = (1));

return statearr_71028;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_71001){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71029){var ex__2749__auto__ = e71029;
var statearr_71030_71051 = state_71001;
(statearr_71030_71051[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71001[(4)]))){
var statearr_71031_71052 = state_71001;
(statearr_71031_71052[(1)] = cljs.core.first.call(null,(state_71001[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71053 = state_71001;
state_71001 = G__71053;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_71001){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_71001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71032 = f__2769__auto__.call(null);
(statearr_71032[(6)] = c__2768__auto__);

return statearr_71032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.call(null);
var temp__5802__auto___71078 = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___71078)){
var v_71079 = temp__5802__auto___71078;
cljs.core.async.put_BANG_.call(null,out,v_71079);
} else {
var c__2768__auto___71080 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71065){
var state_val_71066 = (state_71065[(1)]);
if((state_val_71066 === (1))){
var inst_71054 = value_fn.call(null,k);
var state_71065__$1 = state_71065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71065__$1,(2),inst_71054);
} else {
if((state_val_71066 === (2))){
var inst_71056 = (state_71065[(7)]);
var inst_71056__$1 = (state_71065[(2)]);
var inst_71057 = fluree.db.util.core.exception_QMARK_.call(null,inst_71056__$1);
var state_71065__$1 = (function (){var statearr_71067 = state_71065;
(statearr_71067[(7)] = inst_71056__$1);

return statearr_71067;
})();
if(inst_71057){
var statearr_71068_71081 = state_71065__$1;
(statearr_71068_71081[(1)] = (3));

} else {
var statearr_71069_71082 = state_71065__$1;
(statearr_71069_71082[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71066 === (3))){
var state_71065__$1 = state_71065;
var statearr_71070_71083 = state_71065__$1;
(statearr_71070_71083[(2)] = null);

(statearr_71070_71083[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71066 === (4))){
var inst_71056 = (state_71065[(7)]);
var inst_71060 = cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,inst_71056);
var state_71065__$1 = state_71065;
var statearr_71071_71084 = state_71065__$1;
(statearr_71071_71084[(2)] = inst_71060);

(statearr_71071_71084[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71066 === (5))){
var inst_71056 = (state_71065[(7)]);
var inst_71062 = (state_71065[(2)]);
var inst_71063 = cljs.core.async.put_BANG_.call(null,out,inst_71056);
var state_71065__$1 = (function (){var statearr_71072 = state_71065;
(statearr_71072[(8)] = inst_71062);

return statearr_71072;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71065__$1,inst_71063);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_71073 = [null,null,null,null,null,null,null,null,null];
(statearr_71073[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__);

(statearr_71073[(1)] = (1));

return statearr_71073;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1 = (function (state_71065){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71074){var ex__2749__auto__ = e71074;
var statearr_71075_71085 = state_71065;
(statearr_71075_71085[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71065[(4)]))){
var statearr_71076_71086 = state_71065;
(statearr_71076_71086[(1)] = cljs.core.first.call(null,(state_71065[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71087 = state_71065;
state_71065 = G__71087;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = function(state_71065){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1.call(this,state_71065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71077 = f__2769__auto__.call(null);
(statearr_71077[(6)] = c__2768__auto___71080);

return statearr_71077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__71088_SHARP_){
if(cljs.core.truth_(p1__71088_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__71089_SHARP_){
var or__5045__auto__ = p1__71089_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e71090){var e = e71090;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__71091 = opts;
var map__71091__$1 = cljs.core.__destructure_map.call(null,map__71091);
var sub_chan = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__71091__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71135 = arguments.length;
var i__5770__auto___71136 = (0);
while(true){
if((i__5770__auto___71136 < len__5769__auto___71135)){
args__5775__auto__.push((arguments[i__5770__auto___71136]));

var G__71137 = (i__5770__auto___71136 + (1));
i__5770__auto___71136 = G__71137;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__71094){
var vec__71095 = p__71094;
var opts = cljs.core.nth.call(null,vec__71095,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2768__auto___71138 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71118){
var state_val_71119 = (state_71118[(1)]);
if((state_val_71119 === (1))){
var inst_71098 = fluree.db.connection.get_socket.call(null,conn);
var state_71118__$1 = state_71118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71118__$1,(2),inst_71098);
} else {
if((state_val_71119 === (2))){
var inst_71100 = (state_71118[(7)]);
var inst_71101 = (state_71118[(8)]);
var inst_71100__$1 = (state_71118[(2)]);
var inst_71101__$1 = (inst_71100__$1 == null);
var state_71118__$1 = (function (){var statearr_71120 = state_71118;
(statearr_71120[(7)] = inst_71100__$1);

(statearr_71120[(8)] = inst_71101__$1);

return statearr_71120;
})();
if(cljs.core.truth_(inst_71101__$1)){
var statearr_71121_71139 = state_71118__$1;
(statearr_71121_71139[(1)] = (3));

} else {
var statearr_71122_71140 = state_71118__$1;
(statearr_71122_71140[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71119 === (3))){
var inst_71101 = (state_71118[(8)]);
var state_71118__$1 = state_71118;
var statearr_71123_71141 = state_71118__$1;
(statearr_71123_71141[(2)] = inst_71101);

(statearr_71123_71141[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71119 === (4))){
var inst_71100 = (state_71118[(7)]);
var inst_71104 = fluree.db.util.core.exception_QMARK_.call(null,inst_71100);
var state_71118__$1 = state_71118;
var statearr_71124_71142 = state_71118__$1;
(statearr_71124_71142[(2)] = inst_71104);

(statearr_71124_71142[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71119 === (5))){
var inst_71106 = (state_71118[(2)]);
var state_71118__$1 = state_71118;
if(cljs.core.truth_(inst_71106)){
var statearr_71125_71143 = state_71118__$1;
(statearr_71125_71143[(1)] = (6));

} else {
var statearr_71126_71144 = state_71118__$1;
(statearr_71126_71144[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71119 === (6))){
var inst_71100 = (state_71118[(7)]);
var inst_71108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71109 = [inst_71100,"Cannot establish connection to a healthy server, disconnecting."];
var inst_71110 = (new cljs.core.PersistentVector(null,2,(5),inst_71108,inst_71109,null));
var inst_71111 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71110);
var inst_71112 = cljs.core.async.close_BANG_.call(null,conn);
var state_71118__$1 = (function (){var statearr_71127 = state_71118;
(statearr_71127[(9)] = inst_71111);

return statearr_71127;
})();
var statearr_71128_71145 = state_71118__$1;
(statearr_71128_71145[(2)] = inst_71112);

(statearr_71128_71145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71119 === (7))){
var inst_71114 = fluree.db.connection.msg_consumer.call(null,conn);
var state_71118__$1 = state_71118;
var statearr_71129_71146 = state_71118__$1;
(statearr_71129_71146[(2)] = inst_71114);

(statearr_71129_71146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71119 === (8))){
var inst_71116 = (state_71118[(2)]);
var state_71118__$1 = state_71118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71118__$1,inst_71116);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_71130 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71130[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_71130[(1)] = (1));

return statearr_71130;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_71118){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71131){var ex__2749__auto__ = e71131;
var statearr_71132_71147 = state_71118;
(statearr_71132_71147[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71118[(4)]))){
var statearr_71133_71148 = state_71118;
(statearr_71133_71148[(1)] = cljs.core.first.call(null,(state_71118[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71149 = state_71118;
state_71118 = G__71149;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_71118){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_71118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71134 = f__2769__auto__.call(null);
(statearr_71134[(6)] = c__2768__auto___71138);

return statearr_71134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq71092){
var G__71093 = cljs.core.first.call(null,seq71092);
var seq71092__$1 = cljs.core.next.call(null,seq71092);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71093,seq71092__$1);
}));

